#include <stdio.h>
#include <stdlib.h>
#include "../dynapdf/dynapdf.h"

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   // The error type is a bitmask, see help file for further information.
   if (ErrType & E_WARNING)
      printf("Warning: %s\n", ErrMessage);
   else if (ErrType & E_SYNTAX_ERROR)
      printf("Syntax error!: %s\n", ErrMessage);
   else if (ErrType & E_VALUE_ERROR)
      printf("Value error: %s\n", ErrMessage);
   else if (ErrType & E_FONT_ERROR)
      printf("TrueType font error!: %s\n", ErrMessage);
   else if (ErrType & E_FILE_ERROR)
      printf("File error: %s\n", ErrMessage);
   else if (ErrType & E_FATAL_ERROR)
      printf("Fatal error: %s\n", ErrMessage);
   else
      printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(void)
{
   void* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?
   char outFile[] = "metafiles.pdf";
   
   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   if (!pdfCreateNewPDF(pdf, outFile))
   {
      pdfDeletePDF(pdf);
      return 1;
   }
   pdfAppend(pdf);
   pdfSetPageCoords(pdf, pcTopDown);
   // We use a landscape format
   pdfSetBBox(pdf, pbMediaBox, 0.0, 0.0, 842.0, 595.0);
   // This file transforms the coordinate system very often and uses clipping regions. The metafile
   // is scaled to the page width without changing its aspect ratio.
   pdfInsertMetafile(pdf, "test_files/coords.emf", 0.0, 0.0, pdfGetPageWidth(pdf), 0.0);
   pdfEndPage(pdf);

   pdfAppend(pdf);
   // Simple test of line and standard patterns
   pdfInsertMetafile(pdf, "test_files/fulltest.emf", 40.0, 20.0, pdfGetPageWidth(pdf) - 80.0, 0.0);
   pdfEndPage(pdf);

   pdfAppend(pdf);
   // Simple test of clipping paths
   pdfInsertMetafile(pdf, "test_files/gdi.emf", 40.0, 20.0, pdfGetPageWidth(pdf) - 80.0, 0.0);
   pdfEndPage(pdf);

   pdfCloseFile(pdf);
   // If you want to encrypt the file, use CloseFileEx() instead.
   //pdfCloseFileEx(pdf, NULL, "test", kl128bit, rsDenyAll - rsPrint - rsPrintHighRes);

   pdfDeletePDF(pdf); // Do not forget to delete the class instance

   printf("PDF file %s successfully created!\n", outFile);
   return 0;
}
