/*---------------------------------------------------------+
| DynaPDF 4.0                                              |
+----------------------------------------------------------+
| Copyright (C) 2003-2025                                  |
| Jens Boschulte, DynaForms GmbH.                          |
| All rights reserved.                                     |
+----------------------------------------------------------+
| Please report errors or other potential problems to      |
| support@dynaforms.com.                                   |
| The current version is available at www.dynaforms.com.   |
+----------------------------------------------------------+
|                Creation date: 09/15/2025                 |
+----------------------------------------------------------*/

#ifndef dynapdfH
#define dynapdfH

#define DYNAPDF_VERSIONSTRING "4.0.102.297"

#define DYNAPDF_REVISION "$Rev: 428 $"

#if defined(__BORLANDC__)
   /*
      Treat enums as int because an enum is defined as 16 bit short by default in
      Borland's C++ Builder.
   */
   #pragma option push -b
#endif

#ifdef WASM
   #include <emscripten.h>
#endif

/* ------------------------------------------ IMPORTANT --------------------------------------------- */

// When compiling DynaPDF as Windows DLL the makro PDF_INTERN and DRV_GLOBAL must be defined in your DynaPDF
// project settings. But this makro must NOT be defined in your application project that includes this interface!!!

// If you want to compile the library and bind it statically with your own VC++ workspace, declare PDF_STATIC in the
// project settings and include the following workspaces to your main worksapce:

   // dynapdf.vcproj               -> main project for DynaPDF
   // dynaren/dynaren.vcproj       -> DynaPDF rendering library
   // agg/agg.vcproj               -> Anti Grain rendering library
   // clipper/clipper.vcproj       -> Clipper library
   // freetype2/freetype2.vcproj   -> FreeType
   // gpc/gpc.vcproj               -> Generic Polygon Clipper (this library will be removed soon)
   // jpeg/jpeg.vcproj             -> JPEG library
   // little_cms/little_cms.vcproj -> Little CMS color management library
   // openjpeg/openjpeg.vcproj     -> OpenJPEG library
   // png/png.vcproj               -> PNG library
   // tiff/tiff.vcproj             -> Tiff library
   // zint/zint.vcproj             -> Zint library
   // zlib/zlib.vcproj             -> Zlib library

// The workspace dynapdf.vcproj depends on the other workspaces listed above. Set the dependencies under the menu
// Project/Dependencies. Your project depends on dynapdf.vcproj, so set this dependency too. At least, you
// must add the library path ..\Debug or ..\Release and the gdi32.lib to your project, finished!

// DynaPDF is delivered with pre-defined workspaces for VS 2005, 2010, and 2017.

/* ---------------------------------------- START INTERFACE ----------------------------------------- */

// PDF_DEBUG is used internally by DynaForms, there is no need to use this flag.

//#define PDF_DEBUG

// DynaPDF supports certain compiler settings to enable or disable image libraries or other features.
// All supported configuration macros can be found in the file /main/drv_type.h.

#if !defined(_WINDOWS) && (defined(__WIN32__) || defined(_WIN32) || defined(WIN32) || defined(WIN64) || defined(_WIN64) || defined(WINDOWS))
   #define _WINDOWS
#endif

#if defined(_MSC_VER) && _MSC_VER >= 1929
   #pragma warning(push)
   #pragma warning(disable:26495) // Variable is unitialized
   #pragma warning(disable:26812) // Type enum is unscoped. Prefer enum class over enum
#endif

#ifdef __cplusplus
   #define PDF_INLINE inline
#else
   #define PDF_INLINE
#endif

#ifdef WASM
   #define PDF_EXP extern "C" EMSCRIPTEN_KEEPALIVE
   #define PDF_CALL
#else
   #if (!defined(USE_CLASS_CPDF) && !defined(PDF_STATIC))
      #if defined(_WINDOWS) && defined(__cplusplus)
         #if defined(PDF_INTERN)
            #if defined(_MSC_VER) && (_MSC_VER > 1400)
               #define PDF_EXP extern "C" __declspec(dllexport)
            #else
               #define PDF_EXP extern "C"
            #endif
         #else
            #define PDF_EXP extern "C" __declspec(dllimport)
         #endif
      #elif defined(_WINDOWS)
         #define PDF_EXP extern __declspec(dllimport)
      #elif ((defined(__IBMC__) || defined(__IBMCPP__)) && defined(__DLL__) && defined(OS2))
         #define PDF_EXP _Export
      #elif defined(__SUNPRO_CC)
         #define PDF_EXP extern "C" __global
      #elif defined(__SUNPRO_C)
         #define PDF_EXP __global
      #elif __cplusplus
         #if defined(__GNUC__) && (__GNUC__ >= 4) // the visibility attribute is supported since GCC 4.0
            #define PDF_EXP extern "C" __attribute ((visibility ("default")))
         #else
            #define PDF_EXP extern "C"
         #endif
      #else
         #if defined(__GNUC__) && (__GNUC__ >= 4) // the visibility attribute is supported since GCC 4.0
            #define PDF_EXP __attribute ((visibility ("default")))
         #else
            #define PDF_EXP
         #endif
      #endif
   #else // static binding
      #ifdef __cplusplus
         #define PDF_EXP extern "C"
      #else
         #define PDF_EXP extern
      #endif
   #endif

   #if defined(_WINDOWS) && !defined(PDF_NO_STDCALL)
      #define PDF_CALL __stdcall
   #else
      #define PDF_CALL
   #endif
#endif

#ifdef __cplusplus
   #define ADDR &
#else
   #define ADDR *
#endif

// These types are not strong by default to preserve backwards compatibility
#if defined(PDF_STRICT_TYPES) && defined(__cplusplus)
   struct PPDF;    // PDF Instance
   struct PBCD;    // Barcode dictionay
   struct PFNT;    // Font object
   struct IPDFObj; // Pointer of an object that was derived from CBaseObject. This is the base class of all PDF objects.
#else
   typedef void PPDF;    // PDF Instance
   typedef void PBCD;    // Barcode dictionay
   typedef void PFNT;    // Font object
   typedef void IPDFObj; // Pointer of an object that was derived from CBaseObject. This is the base class of all PDF objects.
#endif

// Pointers of specific objects
#ifdef __cplusplus
   struct I3DV; // Pointer of a 3D View
   struct IACT; // Action pointer
   struct ICSP; // Pointer of a color space object
   struct IEFN; // Embedded file node
   struct IEVT; // Object event
   struct IEXG; // Extended graphics state object
   struct IFLD; // Field
   struct IFSR; // File specification
   struct ILST; // Ink list pointer
   struct IMSR; // Measure object
   struct INFM; // Number format object
   struct IOCG; // Optional Content Group
   struct IOCN; // Optional Content UI node
   struct IPGC; // Page cache
   struct IPGE; // Page object
   struct IPSR; // Parser Context
   struct IPTD; // Point data
   struct IRAS; // Rasterizer
   struct IRFN; // Related file node
   struct ITLE; // Tile object
   struct IXML; // XML parser object
   struct LGRP; // Pointer of a Layer Group
   struct PIMG; // Image object
   struct PPTN; // Pattern object
   struct PSHD; // Shading object
   struct PSIG; // Signature dictionay
   struct PSMK; // Soft mask
   struct PTMP; // Template object
   struct RWND; // Rendering window
#else
   typedef void I3DV; // Pointer of a 3D View
   typedef void IACT; // Action pointer
   typedef void ICSP; // Pointer of a color space object
   typedef void IEFN; // Embedded file node
   typedef void IEVT; // Object event
   typedef void IEXG; // Extended graphics state object
   typedef void IFLD; // Field
   typedef void IFSR; // File specification
   typedef void ILST; // Ink list pointer
   typedef void IMSR; // Measure object
   typedef void INFM; // Number format object
   typedef void IOCG; // Optional Content Group
   typedef void IOCN; // Optional Content UI node
   typedef void IPGC; // Page cache
   typedef void IPGE; // Page object
   typedef void IPSR; // Parser Context
   typedef void IPTD; // Point data
   typedef void IRAS; // Rasterizer
   typedef void IRFN; // Related file node
   typedef void ITLE; // Tile object
   typedef void IXML; // XML parser object
   typedef void LGRP; // Pointer of a Layer Group
   typedef void PIMG; // Image object
   typedef void PPTN; // Pattern object
   typedef void PSHD; // Shading object
   typedef void PSIG; // Signature dictionay
   typedef void PSMK; // Soft mask
   typedef void PTMP; // Template object
   typedef void RWND; // Rendering window
#endif

/* ----------------------------------------------- Default color values ------------------------------------------ */

// basic RGB colors
#define PDF_AQUA     0x00FFFF00
#define PDF_BLACK    0x00000000
#define PDF_BLUE     0x00FF0000
#define PDF_CREAM    0x00F0FBFF
#define PDF_DKGRAY   0x00808080
#define PDF_FUCHSIA  0x00FF00FF
#define PDF_GRAY     0x00808080
#define PDF_GREEN    0x00008000
#define PDF_LIME     0x0000FF00
#define PDF_LTGRAY   0x00C0C0C0
#define PDF_MAROON   0x00000080
#define PDF_MEDGRAY  0x00A4A0A0
#define PDF_MOGREEN  0x00C0DCC0
#define PDF_NAVY     0x00800000
#define PDF_OLIVE    0x00008080
#define PDF_PURPLE   0x00800080
#define PDF_RED      0x000000FF
#define PDF_SILVER   0x00C0C0C0
#define PDF_SKYBLUE  0x00F0CAA6
#define PDF_WHITE    0x00FFFFFF
#define PDF_TEAL     0x00808000
#define PDF_YELLOW   0x0000FFFF

// This value can be used for form fields, annotations and standard patterns to determine that the specific color is not set.
// For example, when a form field should have a transparent background, set the field background color
// to NO_COLOR. The background appears then transparent.
#define NO_COLOR     0xFFFFFFF1

// Error types.
// Note that error codes are negative; to determine the error type use the absolute value:
// if (-errCode & E_FATAL_ERROR) printf("A fatal error occurred!");
#define E_WARNING      0x02000000
#define E_SYNTAX_ERROR 0x04000000
#define E_VALUE_ERROR  0x08000000
#define E_FONT_ERROR   0x10000000
#define E_FATAL_ERROR  0x20000000
#define E_FILE_ERROR   0x40000000

   // Error codes are defined in ../main/drv_errcode.h

#if defined(DRV_GLOBAL)
   #include "../main/drv_type.h"
   #ifdef __cplusplus
      using namespace DOCDRV;
   #endif
#else
   #ifndef _WINDOWS
      #if defined(OS_ANDROID) || defined(ANDROID) || defined(OS_IOS) || defined(MAC_OS_X) || defined(__APPLE__)
         // We don't use the configure script for Mac OS X, iOS or Android (drv_conf.h does not exist).
         #if defined(__BIG_ENDIAN__)
            #define DRV_BIG_ENDIAN 1
         #elif defined(__LITTLE_ENDIAN__)
            #define DRV_BIG_ENDIAN 0
         #else
            #define DRV_BIG_ENDIAN 0
         #endif
         #define DRV_LOCK_CRITICAL_SECTIONS 1
         #define VS_2005_OR_HIGHER 0
         #define SIZEOF_WCHAR_T 4
      #else
         #include "drv_conf.h"
         #ifdef MAC_OS_X
            // We must not depend on the configure script when building a universal library!
            #if defined(__BIG_ENDIAN__)
               #define DRV_BIG_ENDIAN 1
            #elif defined(__LITTLE_ENDIAN__)
               #define DRV_BIG_ENDIAN 0
            #else
               #error "Cannot determine endian configuration!"
            #endif
         #elif (defined(WORDS_BIGENDIAN) && WORDS_BIGENDIAN == 1)
            #define DRV_BIG_ENDIAN 1
         #else
            #define DRV_BIG_ENDIAN 0
         #endif

         #if (defined(HAVE_PTHREAD_H) && HAVE_PTHREAD_H == 1)
            #define DRV_LOCK_CRITICAL_SECTIONS 1
         #else
            #define DRV_LOCK_CRITICAL_SECTIONS 0
         #endif
         #define VS_2005_OR_HIGHER 0
      #endif
   #else
      #if defined(_MSC_VER) && (_MSC_VER >= 1400)
         #define VS_2005_OR_HIGHER 1
      #else
         #define VS_2005_OR_HIGHER 0
      #endif
      #define DRV_BIG_ENDIAN 0
      #define DRV_LOCK_CRITICAL_SECTIONS 1
      #define SIZEOF_WCHAR_T 2
   #endif

   #ifdef _WINDOWS
      #if defined(WIN64) || defined(_WIN64)
         #if !defined(SI32)
            typedef int SI32;
         #endif
         #if !defined(UI32)
            typedef unsigned int UI32;
         #endif
      #else
         #if !defined(SI32)
            typedef long SI32;
         #endif
         #if !defined(UI32)
            typedef unsigned long UI32;
         #endif
      #endif
   #elif defined(OS_ANDROID) || defined(ANDROID) || defined(OS_IOS) || defined(MAC_OS_X) || defined(__APPLE__)
      #if !defined(SI32)
         typedef int SI32;
      #endif
      #if !defined(UI32)
         typedef unsigned int UI32;
      #endif
   #else
      #if (SIZEOF_INT == 4)
         #if !defined(SI32)
            typedef int SI32;
         #endif
         #if !defined(UI32)
            typedef unsigned int UI32;
         #endif
      #elif (SIZEOF_LONG == 4)
         #if !defined(SI32)
            typedef long SI32;
         #endif
         #if !defined(UI32)
            typedef unsigned long UI32;
         #endif
      #else
         #error "Only 32 bit and 64 bit targets are supported!"
      #endif
   #endif

   typedef SI32           LBOOL;
   typedef unsigned char  BYTE;
   typedef signed short   SI16;
   typedef unsigned short UI16;
   typedef double         FFLOAT; /* Obsolete, this typedef is not longer used by DynaPDF */
   #define DRV_FLOAT_PRECISION 5

   /* --------------------------------------------- Low level file handling ----------------------------------------- */

#if defined(_WINDOWS)
   #define FM_CREATE          "w+bN"
   #define FM_OPEN_READ       "rbN"
   #define FM_OPEN_WRITE      "r+bN"
   #define FM_OPEN_READ_WRITE "r+bN"
#else
   #define FM_CREATE          "w+"
   #define FM_OPEN_READ       "r"
   #define FM_OPEN_WRITE      "r+"
   #define FM_OPEN_READ_WRITE "r+"
#endif

   #if defined(_WINDOWS) && !defined(__BORLANDC__)
      #define SM_DENY_NONE       _SH_DENYNO
      #define SM_DENY_READ       _SH_DENYRD
      #define SM_DENY_WRITE      _SH_DENYWR
      #define SM_DENY_READ_WRITE _SH_DENYRW
   #elif defined(_WINDOWS)
      #define SM_DENY_NONE       SH_DENYNO
      #define SM_DENY_READ       SH_DENYRD
      #define SM_DENY_WRITE      SH_DENYWR
      #define SM_DENY_READ_WRITE SH_DENYRW
   #else
      #define SM_DENY_NONE       0
      #define SM_DENY_READ       0
      #define SM_DENY_WRITE      0
      #define SM_DENY_READ_WRITE 0
   #endif

   /* ------------------------------------------------ Callback functions ------------------------------------------- */

   typedef enum TEnumFontProcFlags
   {
      efpAnsiPath    = 0, // Code page 1252 on Windows, UTF-8 otherwise
      efpUnicodePath = 1, // FilePath is in Unicode format. Make a typecast to (UI16*) in this case.
      efpEmbeddable  = 2, // The font has embedding rights.
      efpEditable    = 4  // If set, the font has editing rights (important for form fields).
   }TEnumFontProcFlags;

   typedef enum TFontType
   {
      ftMMType1  = 0, // Multiple Master
      ftTrueType = 1, // TrueType font
      ftType0    = 2, // CID font -> Check the font file type to determine the font sub type.
      ftType1    = 3, // Type1 font
      ftType3    = 4  // Type3 font
   }TFontType;

   typedef enum TFontBaseType
   {
      fbtTrueType = 0, // TrueType, TrueType Collections, or OpenType fonts with TrueType outlines
      fbtType1    = 1, // Type1 font
      fbtOpenType = 2, // OpenType font with Postscript outlines
      fbtStdFont  = 3, // PDF Standard font
      fbtDisabled = 4  // This value can be used to disable a specific font format. See SetFontSearchOrder() for further information.
   }TFontBaseType;

   typedef enum TFontFileSubtype
   {
      ffsType1C        = 0, // CFF based Type1 font
      ffsCIDFontType0C = 1, // CFF based Type1 CID font
      ffsOpenType      = 2, // TrueType based OpenType font
      ffsOpenTypeC     = 3, // CFF based OpenType font
      ffsCIDFontType2  = 4, // TrueType based CID Font
      ffsCIDType1      = 5, // Regular Type1 used as CID font. Not documented and not supported in all PDF libraries.
      ffsNoSubtype     = 9  // The font file is in the format of FontType
   }TFontFileSubtype;

   typedef enum TICCProfileType
   {
      ictGray = 0,
      ictRGB  = 1,
      ictCMYK = 2,
      ictLab  = 3
   }TICCProfileType;

   // Data is always a user defined pointer which is passed unchanged to the callback funtion.
   typedef SI32 PDF_CALL TErrorProc(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType);
   typedef SI32 PDF_CALL TEnumFontProc(const void* Data, const UI16* FamilyName, const char* PostScriptName, SI32 Style);
   typedef SI32 PDF_CALL TEnumFontProc2(const void* Data, const PFNT* PDFFont, TFontType Type, const char* BaseFont, const char* FontName, LBOOL Embedded, LBOOL IsFormFont, UI32 Flags);
   typedef SI32 PDF_CALL TEnumFontProcEx(const void* Data, const UI16* FamilyName, const char* PostScriptName, SI32 Style, TFontBaseType BaseType, TEnumFontProcFlags Flags, const char* FilePath);
   typedef SI32 PDF_CALL TOnFontNotFoundProc(const void* Data, const PFNT* PDFFont, const char* FontName, SI32 Style, SI32 StdFontIndex, LBOOL IsSymbolFont);
   //typedef SI32 PDF_CALL TOnNeedPassword(const void* Data, TPwdType ADDR Type, char* ADDR Password);
   typedef SI32 PDF_CALL TOnReplaceICCProfile(const void* Data, TICCProfileType Type, SI32 ColorSpace);

   /* -------------------------------------- Error types, specific error values ------------------------------------- */

   typedef SI32 TErrMode;
   #define emIgnoreAll       0x00000000
   #define emSyntaxError     0x00000001
   #define emValueError      0x00000002
   #define emWarning         0x00000004
   #define emFileError       0x00000008
   #define emFontError       0x00000010
   #define emAllErrors       0x0000FFFF
   #define emNoFuncNames     0x10000000 // Do not print function names in error messages
   #define emUseErrLog       0x20000000 // Redirect all error messages to the error log
   // Special flags for CheckConformance().
   // These flags add info messages to the error log. The error callback function is not invoked.
   #define emLogFonts        0x00010000 // If set, CheckConformance() logs which fonts were replaced with system fonts or converted to Type3
   #define emLogFontsVerbose 0x00020000 // If set, the path to the font file is added to the error log too
#endif

/*
   Prior versions of DynaPDF used the names LONG and ULONG for 32 bit integer types. These names are
   already defined under Windows. As long as no 64 bit Windows is used the names do not conflict
   with existing declarations. However, 64 bit Windows operating systems declare the types LONG and
   ULONG correctly as 64 bit integer types but we still need 32 bit integer types.

   To solve this issue, the types LONG and ULONG were renamed in DynaPDF 2.0.18.222. You can still use the
   the old names but if you plan to use DynaPDF under 64 bit Windows then it is a good idea to use either
   a predifined 32 bit integer type or the abbrevations SI32 or UI32 respectively.
*/
#if !defined(WIN64) && !defined(_WIN64)
   #if !defined(SI16)
      typedef SI16 SHORT;
   #endif
   #if !defined(UI16)
      typedef UI16 USHORT;
   #endif
   #if !defined(LONG)
      typedef SI32 LONG;
   #endif
   #if !defined(ULONG)
      typedef UI32 ULONG;
   #endif
#endif

// The macro ToUTF16 can be used to convert UTF-32 literal strings or UTF32 Unicode strings which use
// the data type wchar_t.
// Example: pdfWiteTextW(50.0, 50.0, ToUTF16(L"This is a literal string")); ToUTF16 is only requiered for
// Linux and UNIX operating systems.

#ifdef _WINDOWS
   #define ToUTF16(IPDF, s)((s))
#else
   #if (SIZEOF_WCHAR_T == 4)
      #define ToUTF16(IPDF, s)(pdfUTF32ToUTF16((IPDF), (UI32*)(s)))
   #else
      #define ToUTF16(IPDF, s)((s))
   #endif
#endif

#if (DRV_BIG_ENDIAN == 1)
   #define pdf_MakeWord(a, b)((UI16)(((BYTE)(b))|((UI16)((BYTE)(a)))<<8))
   #define pdf_MakeLong(a, b)((UI32)(((UI16)(b))|((UI32)((UI16)(a)))<<16))
#else
   #define pdf_MakeWord(a, b)((UI16)(((BYTE)(a))|((UI16)((BYTE)(b)))<<8))
   #define pdf_MakeLong(a, b)((UI32)(((UI16)(a))|((UI32)((UI16)(b)))<<16))
#endif

#define PDF_MAX_INT 0x7FFFFFFF

/* ----------------------------------------- Start namespace DynaPDF -------------------------------------------- */

#ifdef __cplusplus
namespace DynaPDF
{
#endif

/* -------------------------------------------- Callback functions ---------------------------------------------- */

#define PDF_MAX_LIST_COUNT 32   // Maximum number of nested list levels (WriteFText())
#define DEFAULT_LIST_CHAR  159  // Default character index of the font Wingdings-Regular to create a list (see WriteFText())
#define PDF_LIST_SEP_WIDTH 10.0 // Default width between the list symbol and text (see WriteFText() in the help file for further information)
#define PDF_LIST_FONT      "Wingdings-Regular" // Default font to display the list symbol -> can be changed with SetListFont()

/* ------------------------------------- Callback function for WriteFText ---------------------------------------- */

// The TOnPageBreakProc function is called by WriteFText when the rectangle was filled with text, or when a
// manual page break was inserted to the text and more text is available for output.
// You must set the text rectangle with SetTextRect to continue the text on a new position or simply call
// EndPage() and then Append() or EditPage() to continue the text on an arbitrary new page. You can make some
// changes inside the callback function such as setting another font, font color or other thinks.

// When the callback function returns a value greater or equal zero, processing continues on the new
// position or page that was set inside the callback function.

// The text alignment can also be changed with the following return values:

#define NEW_ALIGN_LEFT      1
#define NEW_ALIGN_RIGHT     2
#define NEW_ALIGN_CENTER    3
#define NEW_ALIGN_JUSTIFY   4

// If the return value of the callback function is one of the above values, then the alignment will
// be changed before the remaining text will be processed. A return value of 0 determines that processing
// should be continued without changing the alignment.

// A negative return value breaks processing and WriteFText() returns immediately with a warning. Note that
// processing stops entirely if warnings are treated as fatal errors (see SetErrorMode() in the help
// file for further information).

// NOTE: The coordinate system is always set to bottom up when the callback function is called, independent
// of the coordinate system that was set before WriteFText() was called. WriteFText() restores the coordinate
// system and all other temporary changed variables when the function returns. The last text position is
// also returned in bottom up coordinates by GetLastTextPosY(). The last y-coordinate is the position of the
// last baseline.

// You can change the coordinate system inside the callback function if necessary. DynaPDF checks the state
// before processing continues.

// PageBreak is != 0 if the page break event was fired due to a page break tag in the text.

typedef SI32 PDF_CALL TOnPageBreakProc(const void* Data, double LastPosX, double LastPosY, LBOOL PageBreak);

/* ------------------------------- Callback functions to control a progress bar ---------------------------------- */

typedef SI32 TProgType;
#define ptImportPage  0 // Start page import
#define ptWritePage   1 // Start writing a page to file or buffer
#define ptPrintPage   2 // Start printing the PDF file
#define ptConvertPage 3 // Start converting the PDF file

// TInitProgressProc is called before TProgressProc is called the first time.
typedef void PDF_CALL TInitProgressProc(const void* Data, TProgType ProgType, SI32 MaxCount);
typedef SI32 PDF_CALL TProgressProc(const void* Data, SI32 ActivePage);

#define ENEED_PWD        -(0x000000B2 | E_FILE_ERROR)
#define EWRONG_OPEN_PWD  -(0x000000B3 | E_FILE_ERROR)
#define EWRONG_OWNER_PWD -(0x000000B4 | E_FILE_ERROR)
#define EWRONG_PWD       -(0x000000B5 | E_FILE_ERROR)

// Returns true if a wrong password was passed to OpenImportFile() or OpenImportBuffer().
// ErrCode must be the return value of OpenImportFile() or OpenImportBuffer().
#define IsWrongPwd(ErrCode)((ErrCode)==ENEED_PWD||(ErrCode)==EWRONG_OPEN_PWD||(ErrCode)==EWRONG_OWNER_PWD||(ErrCode)==EWRONG_PWD)
#define PDF_WRONG_PWD IsWrongPwd // Obsolete

// recommended color macros
#define PDF_RGB(r,g,b) ((UI32)(((BYTE)(r)|((UI16)((BYTE)(g))<<8))|(((UI32)(BYTE)(b))<<16)))

#if (DRV_BIG_ENDIAN == 1)
   #define PDF_CMYK(c,m,y,k) ((UI32)((((BYTE)(c)|((UI16)((BYTE)(m))<<8))|(((UI32)(BYTE)(y))<<16))|(((UI16)(BYTE)(k))<<24)))
#else
   #define PDF_CMYK(c,m,y,k) ((UI32)((((BYTE)(k)|((UI16)((BYTE)(y))<<8))|(((UI32)(BYTE)(m))<<16))|(((UI16)(BYTE)(c))<<24)))
#endif

// Macro to extract the width class from a TFStyle variable
#define WidthFromStyle(s)(((s) & 0x00000F00) >> 8)
// Macro to extract the font weight from a TFStyle variable
#define WeightFromStyle(s)(((s) & 0xFFF00000) >> 20)
// Macros to convert a width class or font weight to a style constant
#define WidthToStyle(w)((w)  << 8)
#define WeightToStyle(w)((w) << 20)

#define PDF_TABLEN 3

#if !defined(__cplusplus) && !defined(false) && !defined(true)
   typedef enum bool
   {
      false = 0,
      true  = 1
   }bool;
#endif

// This flag can be combined with the annotation handle in Set3DAnnotProps().
// 3D Annotations with a transparent background are supported since PDF 1.7, Extension Level 3
#define TRANSP_3D_ANNOT 0x40000000

typedef enum T3DActivationType
{
   at3D_AppDefault,
   at3D_PageOpen,    // The annotaiton should be activated when the page is opened.
   at3D_PageVisible, // The annotaiton should be activated when the page becomes visible.
   at3D_Explicit     // The annotation should remain inactive until explicitly activated by a script or action (default).
}T3DActivationType;

typedef enum T3DDeActivateType
{
   dt3D_AppDefault,
   dt3D_PageClosed,    // The annotaiton should be deactivated as soon as the page is closed.
   dt3D_PageInvisible, // The annotaiton should be deactivated as soon as the page becomes invisible (default).
   dt3D_Explicit       // The annotation should remain active until explicitly deactivated by a script or action.
}T3DDeActivateType;

typedef enum T3DDeActInstance
{
   di3D_AppDefault,
   di3D_UnInstantiated, // The annotation will be uninstantiated (default)
   di3D_Instantiated,   // The annotation is left instantiated
   di3D_Live            // If the 3D artwork contains an animation then it will stay live
}T3DDeActInstance;

typedef enum T3DInstanceType
{
   it3D_AppDefault,
   it3D_Instantiated, // The annotation will be instantiated but animations are disabled.
   it3D_Live          // The annotation will be instantiated and animations are enabled (default).
}T3DInstanceType;

typedef enum T3DLightingSheme
{
   lsArtwork, // Lights from file
   lsBlue,
   lsCAD,
   lsCube,
   lsDay,
   lsHard,
   lsHeadlamp,
   lsNight,
   lsNoLights,
   lsPrimary,
   lsRed,
   lsWhite,
   lsNotSet
}T3DLightingSheme;

typedef enum T3DNamedAction
{
   naDefault,
   naFirst,
   naLast,
   naNext,
   naPrevious
}T3DNamedAction;

typedef enum T3DProjType
{
   pt3DOrthographic,
   pt3DPerspective
}T3DProjType;

typedef enum T3DRenderingMode
{
   rmBoundingBox,
   rmHiddenWireframe,
   rmIllustration,
   rmShadedIllustration,
   rmShadedVertices,
   rmShadedWireframe,
   rmSolid,
   rmSolidOutline,
   rmSolidWireframe,
   rmTransparent,
   rmTranspBBox,
   rmTranspBBoxOutline,
   rmTranspWireframe,
   rmVertices,
   rmWireframe,
   rmNotSet
}T3DRenderingMode;

typedef enum T3DScaleType
{
   st3DValue,
   st3DWidth,
   st3DHeight,
   st3DMin,
   st3DMax
}T3DScaleType;

typedef enum TActionType
{
   atGoTo,
   atGoToR,
   atHide,
   atImportData,
   atJavaScript,
   atLaunch,
   atMovie,
   atNamed,
   atRendition,    // PDF 1.5
   atReset,        // ResetForm
   atSetOCGState,  // PDF 1.5
   atSound,
   atSubmit,       // SubmitForm
   atThread,
   atTransition,
   atURI,
   atGoTo3DView,   // PDF 1.6
   atGoToE,        // PDF 1.6 Like atGoToR but refers to an embedded PDF file.
   atRichMediaExec // PDF 1.7 Extension Level 3
}TActionType;

typedef enum TAFDestObject
{
   adAnnotation,
   adCatalog,    // The documents catalog is the root object
   adField,
   adImage,
   adPage,
   adTemplate
}TAFDestObject;

typedef enum TAFRelationship
{
   arAssociated,
   arData,
   arSource,
   arSupplement,
   arAlternative,
   arFormData
}TAFRelationship;

typedef UI32 TAnnotFlags;
#define afNone           0x00000000
#define afInvisible      0x00000001
#define afHidden         0x00000002
#define afPrint          0x00000004
#define afNoZoom         0x00000008
#define afNoRotate       0x00000010
#define afNoView         0x00000020
#define afReadOnly       0x00000040
#define afLocked         0x00000080
#define afToggleNoView   0x00000100
#define afLockedContents 0x00000200

/*
   By default all annotations which have an appearance stream and which have the print flag set are flattened.
   All annotations are deleted when the function returns with the exception of file attachment annotations.
   If you want to flatten the view state then set the flag affUseViewState.
*/
typedef UI32 TAnnotFlattenFlags;
#define affNone                  0x00000000 // Printable annotations independent of type.
#define affUseViewState          0x00000001 // If set, annotations which are visible in a viewer become flattened.
#define affMarkupAnnots          0x00000002 // If set, markup annotations are flattened only. Link, Sound, or FileAttach
                                            // annotations are no markup annotations. Such types will be left intact.
#define affNonPDFA_1             0x00000004 // If set, flatten all annotations which are not supported in PDF/A 1.
#define affNonPDFA_2             0x00000008 // If set, flatten all annotations which are not supported in PDF/A 2 or 3.
#define affNonPDFA_4e            0x00000080 // If set, flatten all annotations which are not supported in PDF/A 4e
#define affFormFields            0x00000010 // If set, form fields will be flattened too.
#define affUseFieldViewState     0x00000020 // Meaningful only if affFormFields or affSigFields is set. If set, flatten
                                            // the view state of form fields. Use the print state otherwise.
#define affSigFields             0x00000040 // Meaningful only if affFormFields is not set. If set, signature fields with an appearance stream will be flattened.

#define affKeepLinkAnnots        0x00001000 // If set, link annotations will be kept.
#define affKeepFileAttach        0x00002000 // If set, file attachment annotations will be kept.
#define affKeepTextAnnots        0x00004000 // If set, text annotations will be kept.
#define affKeepEmptySigFields    0x00008000 // If set, signature fields which are not already signed will be kept.
#define affKeepUnsupportedAnnots 0x00010000 // If set, annotations whose appearance stream cannot be rebuild will be kept (3D, Movie, Redact, or RichMedia annotations, for example).

#define affPreserveZOrder        0x00400000 // If set, preserve the z-order under any circumstances. That means visible overlapping annotations or form fields will be flattened, regardless the type.

typedef enum TAnnotIcon
{
   aiComment,
   aiHelp,
   aiInsert,
   aiKey,
   aiNewParagraph,
   aiNote,
   aiParagraph,
   aiUserDefined   // Internal, not usable
}TAnnotIcon;

typedef enum TAnnotState
{
   asNone,
   asAccepted,
   asRejected,
   asCancelled,
   asCompleted,
   asCreateReply // Don't add a migration state, create a reply instead. Set the contents of the reply with SetAnnotString().
}TAnnotState;

typedef enum TAnnotString
{
   asAuthor,
   asContent,
   asName,
   asSubject,
   asRichStyle, // Default style string. -> FreeText annotations only.
   asRichText   // Rich text string.     -> Supported by markup annotations.
}TAnnotString;

typedef enum TAnnotType
{
   atCaret,
   atCircle,
   atFileLink,    // A Link annotation with an associated GoToR action (go to remote)
   atFreeText,
   atHighlight,   // Highlight annotation
   atInk,
   atLine,
   atPageLink,    // A Link annotation with an associated GoTo action
   atPolygon,
   atPolyLine,
   atPopUp,
   atSquare,
   atSquiggly,    // Highlight annotation
   atStamp,
   atStrikeOut,   // Highlight annotation
   atText,        // Also used as container to store the State Model
   atUnderline,   // Highlight annotation
   atWebLink,     // A Link annotation with an associated URI action
   atWidget,      // Form Fields are handled separately
   at3D,          // PDF 1.6
   atSoundAnnot,  // PDF 1.2
   atFileAttach,  // PDF 1.3
   atRedact,      // PDF 1.7
   atWatermark,   // PDF 1.6
   atUnknown,     // Unknown annotation type
   atMovieAnnot,  // PDF 1.2
   atPrinterMark, // PDF 1.4
   atProjection,  // PDF 1.7 Extension Level 3
   atRichMedia,   // PDF 1.7 Extension Level 3
   atScreen,      // PDF 1.5
   atTrapNet      // PDF 1.3
}TAnnotType;

typedef enum TBaseEncoding
{
   beWinAnsi   = 0,
   beMacRoman  = 1,
   beMacExpert = 2,
   beStandard  = 3
}TBaseEncoding;

struct TBBox
{
   float x1;
   float y1;
   float x2;
   float y2;
 #ifdef __cplusplus
   TBBox(TBBox &R) :
      x1(R.x1),
      y1(R.y1),
      x2(R.x2),
      y2(R.y2)
   {}
   TBBox(void) :
      x1( 3.402823466e+37f),
      y1( 3.402823466e+37f),
      x2(-3.402823466e+37f),
      y2(-3.402823466e+37f)
   {}
   TBBox(float X1, float Y1, float X2, float Y2) :
      x1(X1),
      y1(Y1),
      x2(X2),
      y2(Y2)
   {}
   float Height(void)                          const {return (y2 - y1);}
   void  Init(float X1, float Y1, float X2, float Y2){x1 = X1; y1 = Y1; x2 = X2; y2 = Y2;}
   void  Intersect(TBBox &R)
   {
      if (x2 > R.x2) x2 = R.x2;
      if (y2 > R.y2) y2 = R.y2;
      if (x1 < R.x1) x1 = R.x1;
      if (y1 < R.y1) y1 = R.y1;
      if (x1 > x2)   x1 = x2;
      if (y1 > y2)   y1 = y2;
   }
   void Intersect(SI32 nx1, SI32 ny1, SI32 nx2, SI32 ny2)
   {
      if (x2 > (float)nx2) x2 = (float)nx2;
      if (y2 > (float)ny2) y2 = (float)ny2;
      if (x1 < (float)nx1) x1 = (float)nx1;
      if (y1 < (float)ny1) y1 = (float)ny1;
      if (x1 > x2) x1 = x2;
      if (y1 > y2) y1 = y2;
   }
   bool IsInside(float X1, float Y1, float X2, float Y2) const {return ((X2 >= x1 && X1 <= x2) && (Y2 >= y1 && Y1 <= y2));}
   void MoveX(float Value)                                     {x1 += Value; x2 += Value;}
   void MoveY(float Value)                                     {y1 += Value; y2 += Value;}
   void Normalize(void)
   {
      float t;
      if (x2 < x1)
      {
         t  = x1;
         x1 = x2;
         x2 = t;
      }
      if (y2 < y1)
      {
         t  = y1;
         y1 = y2;
         y2 = t;
      }
   }
   void Reset(void)                                            {x1 = y1 = 3.402823466e+37f; x2 = y2 = -3.402823466e+37f;}
   void Scale(float Value)                                     {x1 *= Value; y1 *= Value; x2 *= Value; y2 *= Value;}
   void Translate(float x, float y)                            {x1 += x; x2 += x; y1 += y; y2 += y;}
   void Widen(TBBox &BBox)
   {
      if (BBox.x1 < x1)
         x1 = BBox.x1;
      if (BBox.y1 < y1)
         y1 = BBox.y1;
      if (BBox.x2 > x2)
         x2 = BBox.x2;
      if (BBox.y2 > y2)
         y2 = BBox.y2;
   }
   float Width(void)               const {return (x2 - x1);}
   bool operator == (TBBox &Value) const {return (Value.x1 == x1 && Value.y1 == y1 && Value.x2 == x2 && Value.y2 == y2);}
   bool operator != (TBBox &Value) const {return (Value.x1 != x1 || Value.y1 != y1 || Value.x2 != x2 || Value.y2 != y2);}
 #endif
};

struct TFltPoint
{
   float x;
   float y;
 #ifdef __cplusplus
   TFltPoint(void){x = y = 0.0f;}
   TFltPoint(float x_, float y_) :
      x(x_),
      y(y_)
   {}
   float SqDist(void)                             const {return (x*x + y*y);}
   TFltPoint operator  + (const TFltPoint &P)     const {return TFltPoint(x + P.x, y + P.y);}
   TFltPoint operator  - (const TFltPoint &P)     const {return TFltPoint(x - P.x, y - P.y);}
   TFltPoint operator  * (const float Value)      const {return TFltPoint(x * Value, y * Value);}
   TFltPoint operator  * (const TFltPoint &P)     const {return TFltPoint(x * P.x, y * P.y);}
   void      operator *= (const float Value)            {x *= Value;   y *= Value;}
   void      operator *= (const TFltPoint &P)           {x *= P.x;     y *= P.y;}
   void      operator /= (const float Value)            {x /= Value;   y /= Value;}
   void      operator -= (const TFltPoint &Value)       {x -= Value.x; y -= Value.y;}
   void      operator += (const TFltPoint &Value)       {x += Value.x; y += Value.y;}
   void      operator += (const float Value)            {x += Value;   y += Value;}
   bool      operator == (const TFltPoint &Value) const {return (Value.x == x && Value.y == y);}
   bool      operator != (const TFltPoint &Value) const {return (Value.x != x || Value.y != y);}
   void Init(float x_, float y_)                        {x = x_; y = y_;}
 #endif
};

struct TI32Point
{
   SI32 x;
   SI32 y;
 #ifdef __cplusplus
   TI32Point(void){x = y = 0;}
   TI32Point(SI32 x_, SI32 y_) :
      x(x_),
      y(y_)
   {}
   TI32Point operator   + (const TI32Point &P)     const {return TI32Point(x + P.x, y + P.y);}
   TI32Point operator   - (const TI32Point &P)     const {return TI32Point(x - P.x, y - P.y);}
   TI32Point operator   * (const SI32 Value)       const {return TI32Point(x * Value, y * Value);}
   void      operator  -= (const TI32Point &Value)       {x -= Value.x; y -= Value.y;}
   void      operator  += (const TI32Point &Value)       {x += Value.x; y += Value.y;}
   void      operator  += (const SI32 Value)             {x += Value;   y += Value;}
   bool      operator  == (const TI32Point &Value) const {return (Value.x == x && Value.y == y);}
   bool      operator  != (const TI32Point &Value) const {return (Value.x != x || Value.y != y);}
   void      operator >>= (const SI32 Value)             {x >>= Value; y >>= Value;}
   void      operator <<= (const SI32 Value)             {x <<= Value; y <<= Value;}
   void Init(SI32 x_, SI32 y_)                           {x = x_; y = y_;}
 #endif
};

typedef enum TBlendMode
{
   bmNotSet     = 0,
   bmNormal     = 1,
   bmColor      = 2,
   bmColorBurn  = 3,
   bmColorDodge = 4,
   bmDarken     = 5,
   bmDifference = 6,
   bmExclusion  = 7,
   bmHardLight  = 8,
   bmHue        = 9,
   bmLighten    = 10,
   bmLuminosity = 11,
   bmMultiply   = 12,
   bmOverlay    = 13,
   bmSaturation = 14,
   bmScreen     = 15,
   bmSoftLight  = 16
}TBlendMode;

typedef enum TBmkStyle
{
   bmsNormal = 0,
   bmsItalic = 1,
   bmsBold   = 2
}TBmkStyle;

#define BMK_INSERT       0x20000000
#define BMK_ADD_CHILDREN 0x40000000

typedef enum TBorderEffect
{
   beSolid,   // Default
   beCloudy1, // Circle diameter 9 units
   beCloudy2  // Circle diameter 17 units
}TBorderEffect;

typedef enum TBorderStyle
{
   bsSolid,
   bsBevelled,
   bsInset,
   bsUnderline,
   bsDashed,
   bsUserDefined // Internal
}TBorderStyle;

typedef enum TBtnCaptionPos
{
   bcpCaptionOnly,  // Default
   bcpImageOnly,    // No caption; image only
   bcpCaptionBelow, // Caption below the image
   bcpCaptionAbove, // Caption above the image
   bcpCaptionRight, // Caption on the right of the image
   bcpCaptionLeft,  // Caption on the left of the image
   bcpCaptionOver   // Caption overlaid directly on the image
}TBtnCaptionPos;

typedef enum TButtonState
{
   bsUp,
   bsDown,
   bsRollOver
}TButtonState;

typedef enum TCheckBoxChar
{
   ccCheck,   // '4'
   ccCircle,  // 'l'
   ccCross1,  // '5'
   ccCross2,  // '6'
   ccCross3,  // '7'
   ccCross4,  // '8'
   ccDiamond, // 'u'
   ccSquare,  // 'n'
   ccStar     // 'H'
}TCheckBoxChar;

typedef enum TCheckBoxState
{
   cbUnknown,
   cbChecked,
   cbUnChecked
}TCheckBoxState;

struct TCIDMetric
{
   float Width;
   float x;
   float y;
};

typedef enum TColorConvFlags
{
   ccfBW_To_Gray   = 0, // Default, RGB Black and White set with rg or RG inline operators are converted to gray
   ccfRGB_To_Gray  = 1, // If set, inline color operators rg and RG are converted to gray
   ccfToGrayAdjust = 2  // Converts RGB and gray inline operators to gray and allows to darken or lighten the colors
}TColorConvFlags;

#if !defined(DRV_GLOBAL)

   typedef enum TClippingMode
   {
      cmEvenOdd = 0,
      cmWinding = 1
   }TClippingMode;

   typedef enum TCodepage
   {
      /*---------------------------------------- 8 bit code pages --------------------------------------*/
      cp1250,
      cp1251,
      cp1252,
      cp1253,
      cp1254,
      cp1255,
      cp1256,
      cp1257,
      cp1258,
      cp8859_2,
      cp8859_3,
      cp8859_4,
      cp8859_5,
      cp8859_6,
      cp8859_7,
      cp8859_8,
      cp8859_9,
      cp8859_10,
      cp8859_13,
      cp8859_14,
      cp8859_15,
      cp8859_16,
      cpSymbol,
      cp437,
      cp737,
      cp775,
      cp850,
      cp852,
      cp855,
      cp857,
      cp860,
      cp861,
      cp862,
      cp863,
      cp864,
      cp865,
      cp866,
      cp869,
      cp874,

      /* ----------------------------------------- Unicode (UCS-2) -------------------------------------*/

      cpUnicode,

      /*-------------------------------- CJK encodings for use with Unicode fonts ----------------------*/
      // The following encodings requires CJK or ISO-2022 input character sequences which are converted to Unicode
      // by DynaPDF. It is not possible to use these encodings with CJK fonts. If a CJK font should be used, choose
      // one of the native CJK character sets listed at the end this block. DynaPDF does not support a conversion
      // algorithm to convert ISO-2022 character sequences to CJK code points. If you needed such a mapping, please
      // send an email to support@dynaforms.com.

      // UCS-2 does not support all available CJK code points. However, surrogates are still accessible if the used
      // TrueType font contains a cmap format 12. Another way is to use a CJK font with a native CJK charset.

      cpCJK_Big5_Uni,    // Big5 plus HKSCS extension.
      cpCJK_EUC_JP_Uni,  // EUC-JP.
      cpCJK_EUC_KR_Uni,  // EUC-KR.
      cpCJK_EUC_TW_Uni,  // CNS-11643-1992 (Planes 1-15).
      cpCJK_GBK_Uni,     // GBK is the Microsoft code page 936 (GB2312, EUC-CN plus GBK extension).
      cpCJK_GB12345_Uni, // GB-12345-1990 (Traditional Chinese form of GB-2312).
      cpCJK_HZ_Uni,      // Mixed ASCII / GB-2312 encoding
      cpCJK_2022_CN_Uni, // ISO-2022-CN-EXT (GB-2312 plus ISO-11643 Planes 1-7).
      cpCJK_2022_JP_Uni, // ISO-2022-JP.
      cpCJK_2022_KR_Uni, // ISO-2022-KR.
      cpCJK_646_CN_Uni,  // ISO-646-CN (GB-1988-80).
      cpCJK_646_JP_Uni,  // ISO-646-JP (JIS_C6220-1969-RO).
      cpCJK_IR_165_Uni,  // ISO-IR-165 (extended version of GB-2312).
      cpCJK_932_Uni,     // Microsoft extended version of SHIFT_JIS.
      cpCJK_949_Uni,     // EUC-KR extended with UHC (Unified Hangul Codes).
      cpCJK_950_Uni,     // Microsoft extended version of Big5.
      cpCJK_JOHAB_Uni,   // JOHAB.

      /*---------------------------------- Native CJK charsets (CJK fonts only) ------------------------*/

      // When using a CJK font, DynaPDF creates dynamically a "To Unicode CMAP" to enable cut & paste
      // operations in Adobe's Acrobat. If a CJK sequence has no Unicode code point, the CJK code is used instead.
      // In this case, cut & paste works for all other characters, but the unmapped character appears as arbitrary
      // wrong character when the string is pasted to another document. A wrongly mapped character in the
      // "To Unicode CMAP" has no effect in viewing or printing the document.

      // The comments describe which mapping tables are available for a character set. Note these are character sets
      // and no code pages.

      cpShiftJIS,     // ShiftJIS charset plus code page 932 extension.
      cpBig5,         // Big5 plus HKSCS extension.
      cpGB2312,       // GB2312 charset plus GBK and cp936 extension.
      cpWansung,      // Wansung
      cpJohab,        // Johab
      cpMacRoman,     // Mac Roman
      cpAdobeStd,     // This is an encoding for Type1 fonts. It should normally not be used.
      cpInternal,     // Internal -> not usable
      cpGlyphIndexes, // Can be used with TrueType and OpenType fonts only. DynaPDF creates a reverse mapping so that copy & paste will work.
      cpPDFDocEnc,    // Internal -> not usable. Used for form fonts. This is a superset of the code page 1252 and MacRoman.
      cpExtCMap,      // Internal -> not usable. This code page is set when a font was loaded with an external cmap.
      cpDingbats,     // Internal -> Special encoding for ZapfDingbats
      cpMacExpert,    // Internal -> not usable.
      cpRoman8        // This is a standard PCL 5/6 code page
   }TCodepage;

   typedef enum TColorMode
   {
      cmFill       = 0,
      cmStroke     = 1,
      cmFillStroke = 2
   }TColorMode;

   typedef enum TCompressionFilter
   {
      cfFlate                 = 0x00000000, // PDF or TIFF output
      cfJPEG                  = 0x00000001, // PDF, JPEG, or TIFF output
      cfCCITT3                = 0x00000002, // PDF or TIFF output -> B&W CCITT Fax G3 compression -> fast but less compression ratio
      cfCCITT4                = 0x00000003, // PDF or TIFF output -> B&W CCITT Fax G4 compression -> slower but higher compression ratio
      cfLZW                   = 0x00000004, // TIFF or GIF output -> Very fast but less compression ratios than flate
      cfLZWBW                 = 0x00000005, // TIFF
      cfFlateBW               = 0x00000006, // TIFF, PNG, or BMP output -> Dithered black & white output. The resulting image will be
                                            // compressed with Flate or left uncompressed if the output image format is a bitmap. If
                                            // you want to use CCITT Fax 4 compression (TIFF only) set the flag icUseCCITT4 in the
                                            // AddImage() function call. Note that this filter is not supported for PDF creation!
      cfJP2K                  = 0x00000007, // PDF or JPEG2000 output
      cfJBIG2                 = 0x00000008, // PDF output only
      cfNone                  = 0x000000FF, // TIFF output only
      // Special flags for AddRasImage(), RenderPageToImage(), or RenderPDFFile() if the pixel format was set to pxfGray or pxfGrayA.
      // These flags can be combined with the filters cfFlate, cfCCITT3, cfCCITT4, cfJBIG2, cfLZW, and cfJP2K.
      cfDitherFloydSteinberg  = 0x00001000, // Floyd Steinberg dithering.
      cfConvGrayToOtsu        = 0x00002000, // The Otsu filter is a special filter to produce black & white images. It is very useful
                                            // if an OCR scan should be applied on the resulting 1 bit image.
      cfOrderedDithering      = 0x00004000, // Ordered dithering. The difference in comparison to the pixel format pxf1Bit is that
                                            // we render into a GrayA buffer instead of a native 1 bit buffer since this one produces
                                            // incorrect results in certain transparency calculations.
      cfIgnoreICCProfile      = 0x00008000, // Special flag for AddRasImage(). Meaningful only if color management is enabled. If set,
                                            // the device ICC profile is not embedded in the image file.
      // Special flags for Optimize()
      cfPresLosslessFilter    = 0x00010000, // Preserve loss-less compression filters and use the specified filter otherwise.
      cfPresLossyFilter       = 0x00020000  // Preserve lossy compression filters and use the specified filter otherwise.
                                            // cfPresLossLessFilter and cfPresLossyFilter can be combined to preserve the original
                                            // compression filter in either case.
   }TCompressionFilter;

   typedef enum TCompressionLevel
   {
      clNone    = 0,
      clDefault = 1,
      clFastest = 2,
      clMax     = 3
   }TCompressionLevel;

   struct TCTM
   {
      double a;
      double b;
      double c;
      double d;
      double x;
      double y;
   };

   typedef enum TDecodeFilter
   {
      dfNone            = 0,
      dfASCII85Decode   = 1, // No parameters
      dfASCIIHexDecode  = 2, // No parameters
      dfCCITTFaxDecode  = 3, // Optional Parameters
      dfDCTDecode       = 4, // Optional Parameters
      dfFlateDecode     = 5, // Optional Parameters
      dfJBIG2Decode     = 6, // Optional Parameters
      dfJPXDecode       = 7, // No parameters
      dfLZWDecode       = 8, // Optional Parameters
      dfRunLengthDecode = 9, // No parameters
      dfCrypt           = 10 // Internal, cannot occur -> Already handled by the security handler.
   }TDecodeFilter;

   typedef enum TDocumentInfo
   {
      diAuthor       = 0,
      diCreator      = 1,
      diKeywords     = 2,
      diProducer     = 3,
      diSubject      = 4,
      diTitle        = 5,
      diCompany      = 6,
      diPDFX_Ver     = 7,  // GetInDocInfo() or GetInDocInfoEx() only -> The PDF/X version is set by SetPDFVersion()!
      diCustom       = 8,  // User defined key
      diPDFX_Conf    = 9,  // GetInDocInfo() or GetInDocInfoEx() only. The value of the GTS_PDFXConformance key.
      diCreationDate = 10, // GetInDocInfo() or GetInDocInfoEx() or after ImportPDFFile() was called.
      diModDate      = 11  // GetInDocInfo() or GetInDocInfoEx() only
   }TDocumentInfo;

   typedef enum TDrawDirection
   {
      ddCounterClockwise = 0,
      ddClockwise        = 1
   }TDrawDirection;

   typedef enum TDrawMode
   {
      dmNormal         = 0,
      dmStroke         = 1,
      dmFillStroke     = 2,
      dmInvisible      = 3,
      dmFillClip       = 4,
      dmStrokeClip     = 5,
      dmFillStrokeClip = 6,
      dmClipping       = 7,
      dmNone           = -1 // Internal, do not use this mode!!!
   }TDrawMode;

   typedef enum TExtColorSpace
   {
      esDeviceRGB  = 0,  // Device color space
      esDeviceCMYK = 1,  // Device color space
      esDeviceGray = 2,  // Device color space
      esCalGray    = 3,  // CIE-based color space
      esCalRGB     = 4,  // CIE-based color space
      esLab        = 5,  // CIE-based color space
      esICCBased   = 6,  // ICC-based color space -> contains an ICC profile
      esPattern    = 7,  // Special color space
      esIndexed    = 8,  // Special color space
      esSeparation = 9,  // Special color space
      esDeviceN    = 10, // Special color space
      esNChannel   = 11, // Special color space
      esInitSpace  = -1  // Internal -> This value must not be used!
   }TExtColorSpace;

   struct TFltRect
   {
      float Left;
      float Bottom;
      float Right;
      float Top;
     #ifdef __cplusplus
      float Height(void)   {return (Top - Bottom);}
      float HeightABS(void){return (Top > Bottom ? Top - Bottom : Bottom - Top);}
      float WidthABS(void) {return (Right > Left ? Right - Left : Left - Right);}
      float Width(void)    {return (Right - Left);}
     #endif
   };

   struct TPDFRect
   {
      double Left;
      double Bottom;
      double Right;
      double Top;
     #ifdef __cplusplus
      double Height(void)   {return (Top - Bottom);}
      double HeightABS(void){return (Top > Bottom ? Top - Bottom : Bottom - Top);}
      double WidthABS(void) {return (Right > Left ? Right - Left : Left - Right);}
      double Width(void)    {return (Right - Left);}
     #endif
   };

   // If the font selection mode is set to smFullName or smPostScriptName the font styles fsItalic or fsBold are ignored.
   // The PostScript or Full Name are already unique font names incl. style information.
   typedef enum TFontSelMode
   {
      smFamilyName     = 0,
      smPostScriptName = 1,
      smFullName       = 2
   }TFontSelMode;

   /*
      The font search run works as follows:

         - DynaPDF tries always to find the exact weight, if it cannot be found then a font with
           the next smaller weight is selected (if available).
         - Italic styles can always be emulated but it is not possible to emulate thinner weights or
           regular styles with an italic font.
         - If the specified weight is larger as the font weight the remaining weight will be emulated
           if the difference to the requested weight is larger than 200.
           With SetFontWeight() it is possible to control whether a missing weight should be emulated.
           If FontWeight is smaller or equal to the requested font weight then emulation will be disabled.
   */
   /*
      TFStyle is a bitmask that is defined as follows:

         - Bits 0..7   // Style bits fsItalic, fsUnderlined, fsStriked
         - Bits 8..19  // Width class -> Defined for future use.
         - Bits 20..31 // Font Weight

      - A width class can be converted to a style constant by multiplying it with 256 (width << 8).
      - A font weight can be converted to a style constant by multiplying it with 1048576 (weight << 20).
      - Additional attributes can be added with a binary or operator (e.g. style |= fsItalic).
      - Only one width class and one font weight can be set at time.

      - The macro WidthFromStyle() extracts the width class.
      - The macro WeightFromStyle() extracts the font weight.

      The following macros extract the width class or font weight from a style variable:

         UI16 widthClass  = WidthFromStyle(style);
         UI16 weightClass = WeightFromStyle(style);
   */
   #if defined(__BORLANDC__)
      typedef enum TFStyle
      {
         fsNone           = 0x00000000, // Regular weight (400)
         fsItalic         = 0x00000001,
         fsUnderlined     = 0x00000004,
         fsStriked        = 0x00000008,
         fsVerticalMode   = 0x00000010, // Not considered at this time
         fsDblUnderline   = 0x00000020,
         // Width class
         fsUltraCondensed = 0x00000100, // 1
         fsExtraCondensed = 0x00000200, // 2
         fsCondensed      = 0x00000300, // 3
         fsSemiCondensed  = 0x00000400, // 4
         fsNormal         = 0x00000500, // 5
         fsSemiExpanded   = 0x00000600, // 6
         fsExpanded       = 0x00000700, // 7
         fsExtraExpanded  = 0x00000800, // 8
         fsUltraExpanded  = 0x00000900, // 9
         // Weight class
         fsThin           = 0x06400000, // 100
         fsExtraLight     = 0x0c800000, // 200
         fsLight          = 0x12C00000, // 300
         fsRegular        = 0x19000000, // 400 -> Same as fsNone
         fsMedium         = 0x1F400000, // 500
         fsDemiBold       = 0x25800000, // 600
         fsBold           = 0x2BC00000, // 700 -> The old constant 2 is still supported to preserve backward compatibility
         fsExtraBold      = 0x32000000, // 800
         fsBlack          = 0x38400000, // 900
         fsUltraBlack     = 0x3E800000  // 1000
      }TFStyle;
   #else
      typedef SI32 TFStyle;
      #define fsNone           0x00000000 // Regular weight (400)
      #define fsItalic         0x00000001
      #define fsUnderlined     0x00000004
      #define fsStriked        0x00000008
      #define fsVerticalMode   0x00000010 // Not considered at this time
      #define fsDblUnderline   0x00000020
      // Width Class
      #define fsUltraCondensed 0x00000100 // 1
      #define fsExtraCondensed 0x00000200 // 2
      #define fsCondensed      0x00000300 // 3
      #define fsSemiCondensed  0x00000400 // 4
      #define fsNormal         0x00000500 // 5
      #define fsSemiExpanded   0x00000600 // 6
      #define fsExpanded       0x00000700 // 7
      #define fsExtraExpanded  0x00000800 // 8
      #define fsUltraExpanded  0x00000900 // 9
      // Weight Class
      #define fsThin           0x06400000 // 100
      #define fsExtraLight     0x0C800000 // 200
      #define fsLight          0x12C00000 // 300
      #define fsRegular        0x19000000 // 400 -> Same as fsNone
      #define fsMedium         0x1F400000 // 500
      #define fsDemiBold       0x25800000 // 600
      #define fsBold           0x2BC00000 // 700 -> The old constant 2 is still supported to preserve backward compatibility
      #define fsExtraBold      0x32000000 // 800
      #define fsBlack          0x38400000 // 900
      #define fsUltraBlack     0x3E800000 // 1000
   #endif

   typedef UI32 TGStateFlags;
   #define gfCompatible         0x00000000 // Compatible graphics state to earlier DynaPDF versions -> default
   #define gfRestorePageCoords  0x00000001 // Restore the coordinate system with the graphics state (the value of PageCoords, see SetPageCoords())
   #define gfRealTopDownCoords  0x00000002 // If set, the page coordinate system is not reset to bottom-up when transforming
                                           // the coordinate system. However, real top-down coordinates require a large internal
                                           // overhead and where never fully implemented. The usage of this flag should be avoided
                                           // if possible.
   #define gfNativeBlackWhite   0x00000004 // Do not convert RGB black or white to DeviceGray
   #define gfUseImageColorSpace 0x00000008 // If set, the active color space is ignored when inserting an image. The color space is taken
                                           // from the image file instead.
   #define gfIgnoreICCProfiles  0x00000010 // Meaningful only if the flag gfUseImageColorSpace is set. If set, an embedded ICC profile is not used to
                                           // create an ICCBased color space for the image. The image is inserted in the corresponding device
                                           // color space instead.
   #define gfAnsiStringIsUTF8   0x00000020 // If set, single byte strings in Ansi functions are treated as UTF-8 encoded Unicode strings.
   #define gfRealPassThrough    0x00000040 // If set, JPEG images are inserted as is. JPEG images are normally rebuild, also in pass-through mode, to avoid issues
                                           // with certain malformed JPEG images which cannot be displayed in Adobes Acrobat or Reader. If you know that your JPEG
                                           // images work then set this flag to avoid unnecessary processing time.
   #define gfNoBitmapAlpha      0x00000080 // If set, the alpha channel in 32 bit bitmaps will be ignored. Useful for bitmaps with an invalid alpha channel.
   #define gfNoImageDuplCheck   0x00000100 // If set, no duplicate check for images will be performed. This can significantly improve processing speed.
   #define gfNoObjCompression   0x00000200 // If set, object compression will be disabled.
   #define gfComplexText        0x00000400 // If set, text is processed with Uniscribe on Windows.
   #define gfDisableJavascript  0x00000800 // If set, the raw field value of text fields is used to create the apprearance stream.
   #define gfDisableBidiCtrls   0x00001000 // Meaningful only if gfComplexText is set too. If set, bidi control characters are ignored. This flag can be useful if
                                           // the result of web browsers should be emulated since web browsers do not support bidi control characters. This flag
                                           // is also used internally to create the appearance stream of form fields since form fields do not support bidi control
                                           // characters.
   #define gfDoNotComprMetadata 0x00002000 // If set, arbitrary metadata stream associated with PDF objects other that the global metadata stream will not be
                                           // compressed. This can be useful since certain standards prohibit compression of metadata streams. The flag is
                                           // automatically for PDF/X files.
   #define gfUpdatePDFVTModDate 0x00004000 // If set, the key GTS_PDFVTModDate will be set to the file's modification date.
   #define gfSkaleAnnotIcons    0x00008000 // If set, icons of text and file attach annotation are scaled with the page like every other annotation. These annotations
                                           // have normally a fixed size that is indendent of the zoom or scaling factor.
   #define gfRoundHighlightAP   0x00010000 // If set, highlight annotations are drawn with round edges.

   /*
      TIFF is the only format that supports different compression filters. The Filter parameter of the function
      AddImage() is ignored if the image format supports only one specific compression filter.
      Note that images are automatically converted to the nearest supported color space if the image format does
      not support the color space of the image.
   */
   typedef enum TImageFormat
   {
      ifmTIFF,     // DeviceRGB, DeviceCMYK, DeviceGray, Black & White -> CCITT Fax Group 3/4, JPEG, Flate, LZW.
      ifmJPEG,     // DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG compression.
      ifmPNG,      // DeviceGray, DeviceRGB, Black & White -> Flate compression.
      ifmReserved, // Reserved for future extensions.
      ifmBMP,      // DeviceGray, DeviceRGB, Black & White -> Uncompressed.
      ifmJPC,      // DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG2000 compression.
      ifmBigTIFF   // Same as ifmTIFF but without the 4GB output restriction. Note that this format is not supported by most image viewers.
   }TImageFormat;

   typedef enum TKeyLen
   {
      kl40bit    = 0, // RC4 Encryption -> Acrobat 3 or higher
      kl128bit   = 1, // RC4 Encryption -> Acrobat 5 or higher
      kl128bitEx = 2, // RC4 Encryption -> Acrobat 6 or higher
      klAES128   = 3, // AES Encryption -> Acrobat 7 or higher
      klAES256   = 4, // AES Encryption -> Acrobat 9 or higher
      klAESRev6  = 5  // AES Encryption -> Acrobat X or higher
   }TKeyLen;

   typedef enum TLineCapStyle
   {
      csButtCap    = 0,
      csRoundCap   = 1,
      csSquareCap  = 2
   }TLineCapStyle;

   typedef enum TLineJoinStyle
   {
      jsMiterJoin = 0,
      jsRoundJoin = 1,
      jsBevelJoin = 2
   }TLineJoinStyle;

   typedef enum TLoadCMapFlags
   {
      lcmDefault   = 0, // Load the cmaps in the directory now
      lcmRecursive = 1, // Load sub directories recursively
      lcmDelayed   = 2  // Load the cmap files only when a font requires an external cmap
   }TLoadCMapFlags;

   typedef UI32 TMetaFlags;
   #define mfDefault           0x00000000 // Default conversion
   #define mfDebug             0x00000001 // Write debug information into the content stream
   #define mfShowBounds        0x00000002 // Show the bounding boxes of text strings
   #define mfNoTextScaling     0x00000004 // Do not scale text
   #define mfClipView          0x00000008 // Draw the file into a clipping rectangle
   #define mfUseRclBounds      0x00000010 // Use rclBounds instead of rclFrame
   #define mfNoClippingRgn     0x00000040 // Disables SelectClippingRegion, IntersectClipRect, and SelectClipPath
   #define mfNoFontEmbedding   0x00000080 // Do not embed fonts -> Fonts should be embedded!!!
   #define mfNoImages          0x00000100 // Ignore image records
   #define mfNoStdPatterns     0x00000200 // Ignore standard patterns
   #define mfNoBmpPatterns     0x00000400 // Ignore bitmap patterns
   #define mfNoText            0x00000800 // Ignore text records
   #define mfUseUnicode        0x00001000 // Ignore ANSI_CHARSET
   #define mfUseTextScaling    0x00004000 // Scale text instead of using the intercharacter spacing array
   #define mfNoUnicode         0x00008000 // Avoid usage of Unicode fonts -> recommended to enable PDF 1.2 compability
   #define mfFullScale         0x00010000 // Recommended if 32 bit coordinates are used
   #define mfUseRclFrame       0x00020000 // This flag should be set if the rclFrame rectangle is not properly set
   #define mfDefBkModeTransp   0x00040000 // Initialize the background mode to transparent (SetBkMode() overrides this state).
   #define mfApplyBidiAlgo     0x00080000 // Apply the bidirectional algorithm on Unicode strings
   #define mfGDIFontSelection  0x00100000 // Use the GDI to select fonts
   #define mfRclFrameEx        0x00200000 // If set, and if the rclBounds rectangle is larger than rclFrame, the function
                                          // extends the output rectangle according to rclBounds and uses the resulting
                                          // bounding box to calculate the image size (rclBounds represents the unscaled
                                          // image size). This is probably the correct way to calculate the image size.
                                          // However, to preserve backward compatibility the default calculation cannot
                                          // be changed.
   #define mfNoTextClipping    0x00400000 // If set, the ETO_CLIPPED flag in text records is ignored.
   #define mfSrcCopy_Only      0x00800000 // If set, images which use a ROP code other than SRCCOPY are ignored. This is useful when processing Excel 2007 spool files.
   #define mfClipRclBounds     0x01000000 // If set, the graphic is drawn into a clipping path with the size of rclBounds.
                                          // This flag is useful if the graphic contains content outside of its bounding box.
   #define mfDisableRasterEMF  0x02000000 // If set, EMF files which use unsupported ROP codes are not rastered.
   #define mfNoBBoxCheck       0x04000000 // If set, the rclBounds and rclFrame rectangles are used as is. DynaPDF uses normally
                                          // the rclBounds rectangle to calculate the picture size if the resolution of the EMF file
                                          // seems to be larger than 1800 DPI since this is mostly an indication that the rclFrame
                                          // rectangle was incorrectly calculated. If you process EMF files in such a high resolution
                                          // then this flag must be set. The flag can be set by default.
   #define mfIgnoreEmbFonts    0x08000000 // If set, embedded fonts in GDIComment records will be ignored. This flag must be set if the fonts
                                          // of an EMF spool file were pre-loaded with ConvertEMFSpool(). Spool fonts must always be loaded
                                          // in a pre-processing step since required fonts are not necessarily embedded in the EMF files.
   #define mfDontSkipROP_DPa   0x10000000 // If set, the ROP code 0x00A000C9 (DPa) is considered in BitBlt, StretchBlt, TranparentBlt, and AlphaBlend records.
                                          // This kind of ROP code combines a pattern brush with the backdrop. If the flag mfDisableRasterEMF is absent, the
                                          // usage of such a ROP code causes that the file is rendered to an image.
   #define mfCurrComprFilter   0x20000000 // If set, the currently active compression filter is used to compress the image (see SetCompressionFilter()).
                                          // This flag is used only if the file is rastered to an image.


   // Obsolete flags -> these flags are ignored, do no longer use them!
   #define mfUseSpacingArray   0x00000020 // enabled by default -> can be disabled with mfUseTextScaling
   #define mfIntersectClipRect 0x00002000 // enabled by default -> can be disabled with mfNoClippingRgn

   typedef enum TOrigin
   {
      orDownLeft = 0,
      orTopLeft  = 1
   }TOrigin;

   typedef enum TPageBoundary
   {
      pbArtBox     = 0,
      pbBleedBox   = 1,
      pbCropBox    = 2,
      pbTrimBox    = 3,
      pbMediaBox   = 4
   }TPageBoundary;

   typedef enum TPageCoord
   {
      pcBottomUp = 0,
      pcTopDown  = 1
   }TPageCoord;

   typedef enum TPageFormat
   {
      pfDIN_A3     = 0,
      pfDIN_A4     = 1,
      pfDIN_A5     = 2,
      pfDIN_B4     = 3,
      pfDIN_B5     = 4,
      pfDIN_B6     = 5,
      pfDIN_C3     = 6,
      pfDIN_C4     = 7,
      pfDIN_C5     = 8,
      pfDIN_C6     = 9,
      pfDIN_C65    = 10,
      pfDIN_DL     = 11,
      pfDIN_E4     = 12,
      pfDIN_E5     = 13,
      pfDIN_E6     = 14,
      pfDIN_E65    = 15,
      pfDIN_M5     = 16,
      pfDIN_M65    = 17,
      pfUS_Legal   = 18,
      pfUS_Letter  = 19,
      pfDIN_A0     = 20,
      pfDIN_A1     = 21,
      pfDIN_A2     = 22,
      pfDIN_A6     = 23,
      pfDIN_A7     = 24,
      pfDIN_A8     = 25,
      pfDIN_A9     = 26,
      pfDIN_A10    = 27
   }TPageFormat;

   typedef enum TPathFillMode
   {
      fmFillNoClose            = 0,
      fmStrokeNoClose          = 1,
      fmFillStrokeNoClose      = 2,
      fmFill                   = 3,
      fmStroke                 = 4,
      fmFillStroke             = 5,
      fmFillEvOdd              = 6,
      fmFillStrokeEvOdd        = 7,
      fmFillEvOddNoClose       = 8,
      fmFillStrokeEvOddNoClose = 9,
      fmNoFill                 = 10,
      fmClose                  = 11  // Close the path, but do not fill or stroke it. More vertices are required or stroke the path in a separate step.
   }TPathFillMode;

   typedef enum TPatternType
   {
      ptColored        = 0,
      ptUnColored      = 1,
      ptShadingPattern = 2
   }TPatternType;

   /*
      Notice:
      When using a bidirectional 8 bit code page the bidi algorithm is applied by default in Left to Right mode
      also if the bidi mode is set to bmNone (default). This mode produces identical results in comparison to
      applications like Edit or WordPad.

      The Right to Left mode is available in applications which use Microsoft's Uniscribe, e.g. BabelPad or MS Word.
      This mode works very well with the Reference Bidi Algorithm which is used by DynaPDF but Uniscribe's Left to Right
      mode produces different results in comparison to the Reference Bidi Algorithm. Because the bidi algorithm that is
      used in Uniscribe is not published it is practically impossible to get the same result in Left to Right mode
      without using this library.
   */

   typedef enum TPDFBidiMode
   {
      bmLeftToRight = 0, // Apply the bidi algorithm on Unicode strings in Left to Right layout.
      bmRightToLeft = 1, // Apply the bidi algorithm on Unicode strings in Right to Left layout.
      bmNone        = 2  // Default -> do not apply the bidi algorithm
   }TPDFBidiMode;

   typedef enum TPDFColorSpace
   {
      csDeviceRGB  = 0,
      csDeviceCMYK = 1,
      csDeviceGray = 2
   }TPDFColorSpace;

   typedef enum TPwdType
   {
      ptOpen        = 0,
      ptOwner       = 1,
      ptForceRepair = 2,      // Meaningful only when opening a PDF file with OpenImportFile() or OpenImportBuffer().
                              // If set, the PDF parser rebuilds the cross-reference table by scanning all the objects
                              // in the file. This can be useful if the cross-reference table contains damages while
                              // the top level objects are intact. Setting this flag makes only sence if the file
                              // was already previously opened in normal mode and if errors occured when importing
                              // pages of it.
      ptDontCopyBuf = 4,      // If set, OpenImportBuffer() does not copy the PDF buffer to an internal buffer. This
                              // increases the processing speed and reduces the memory usage. The PDF buffer must not
                              // be released until CloseImportFile() or CloseFile() was called.
   }TPwdType;

   struct TRectL
   {
      SI32 Left;
      SI32 Top;
      SI32 Right;
      SI32 Bottom;
   };

   typedef SI32 TRestrictions;
   #define rsDenyNothing      0x00000000
   #define rsDenyAll          0x00000F3C
   #define rsPrint            0x00000004
   #define rsModify           0x00000008
   #define rsCopyObj          0x00000010
   #define rsAddObj           0x00000020
   /* 128/256 bit encryption only -> these flags are ignored if 40 bit encryption is used */
   #define rsFillInFormFields 0x00000100
   #define rsExtractObj       0x00000200
   #define rsAssemble         0x00000400
   #define rsPrintHighRes     0x00000800
   #define rsExlMetadata      0x00001000 // PDF 1.5 Exclude metadata streams -> 128/256 bit encryption bit only.
   #define rsEmbFilesOnly     0x00002000 // PDF 1.6 Encrypt embedded files only -> Requires AES encryption.

   typedef enum TStdPattern
   {
      spHorizontal, /* ----- */
      spVertical,   /* ||||| */
      spRDiagonal,  /* \\\\\ */
      spLDiagonal,  /* ///// */
      spCross,      /* +++++ */
      spDiaCross    /* xxxxx */
   }TStdPattern;

   typedef enum TTilingType
   {
      ttConstSpacing     = 0,
      ttNoDistortion     = 1,
      ttFastConstSpacing = 2
   }TTilingType;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TUnicodeRange1
#else
   typedef enum TUnicodeRange1 : UI32
#endif
   {
      urBasicLatin                  = 1UL<<0,  // 0000-007F
      urLatin1Supplement            = 1UL<<1,  // 0080-00FF
      urLatinExtendedA              = 1UL<<2,  // 0100-017F
      urLatinExtendedB              = 1UL<<3,  // 0180-024F
      urIPAExtensions               = 1UL<<4,  // 0250-02AF, 1D00-1D7F, 1D80-1DBF
      urSpacingModifierLetters      = 1UL<<5,  // 02B0-02FF, A700-A71F
      urCombiningDiacriticalMarks   = 1UL<<6,  // 0300-036F, 1DC0-1DFF
      urGreekandCoptic              = 1UL<<7,  // 0370-03FF
      urCoptic                      = 1UL<<8,  // 2C80-2CFF
      urCyrillic                    = 1UL<<9,  // 0400-04FF, 0500-052F, 2DE0-2DFF, A640-A69F
      urArmenian                    = 1UL<<10, // 0530-058F
      urHebrew                      = 1UL<<11, // 0590-05FF
      urVai                         = 1UL<<12, // A500-A63F
      urArabic                      = 1UL<<13, // 0600-06FF, 0750-077F
      urNKo                         = 1UL<<14, // 07C0-07FF
      urDevanagari                  = 1UL<<15, // 0900-097F
      urBengali                     = 1UL<<16, // 0980-09FF
      urGurmukhi                    = 1UL<<17, // 0A00-0A7F
      urGujarati                    = 1UL<<18, // 0A80-0AFF
      urOriya                       = 1UL<<19, // 0B00-0B7F
      urTamil                       = 1UL<<20, // 0B80-0BFF
      urTelugu                      = 1UL<<21, // 0C00-0C7F
      urKannada                     = 1UL<<22, // 0C80-0CFF
      urMalayalam                   = 1UL<<23, // 0D00-0D7F
      urThai                        = 1UL<<24, // 0E00-0E7F
      urLao                         = 1UL<<25, // 0E80-0EFF
      urGeorgian                    = 1UL<<26, // 10A0-10FF, 2D00-2D2F
      urBalinese                    = 1UL<<27, // 1B00-1B7F
      urHangulJamo                  = 1UL<<28, // 1100-11FF
      urLatinExtendedAdditional     = 1UL<<29, // 1E00-1EFF, 2C60-2C7F, A720-A7FF
      urGreekExtended               = 1UL<<30, // 1F00-1FFF
      urGeneralPunctuation          = 1UL<<31  // 2000-206F, 2E00-2E7F
   }TUnicodeRange1;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TUnicodeRange2
#else
   typedef enum TUnicodeRange2 : UI32
#endif
   {
      urSuperscriptsAndSubscripts   = 1UL<<0,  // 2070-209F
      urCurrencySymbols             = 1UL<<1,  // 20A0-20CF
      urCombDiacritMarksForSymbols  = 1UL<<2,  // 20D0-20FF
      urLetterlikeSymbols           = 1UL<<3,  // 2100-214F
      urNumberForms                 = 1UL<<4,  // 2150-218F
      urArrows                      = 1UL<<5,  // 2190-21FF, 27F0-27FF, 2900-297F, 2B00-2BFF
      urMathematicalOperators       = 1UL<<6,  // 2200-22FF, 2A00-2AFF, 27C0-27EF, 2980-29FF
      urMiscellaneousTechnical      = 1UL<<7,  // 2300-23FF
      urControlPictures             = 1UL<<8,  // 2400-243F
      urOpticalCharacterRecognition = 1UL<<9,  // 2440-245F
      urEnclosedAlphanumerics       = 1UL<<10, // 2460-24FF
      urBoxDrawing                  = 1UL<<11, // 2500-257F
      urBlockElements               = 1UL<<12, // 2580-259F
      urGeometricShapes             = 1UL<<13, // 25A0-25FF
      urMiscellaneousSymbols        = 1UL<<14, // 2600-26FF
      urDingbats                    = 1UL<<15, // 2700-27BF
      urCJKSymbolsAndPunctuation    = 1UL<<16, // 3000-303F
      urHiragana                    = 1UL<<17, // 3040-309F
      urKatakana                    = 1UL<<18, // 30A0-30FF, 31F0-31FF
      urBopomofo                    = 1UL<<19, // 3100-312F, 31A0-31BF
      urHangulCompatibilityJamo     = 1UL<<20, // 3130-318F
      urPhagsPa                     = 1UL<<21, // A840-A87F
      urEnclosedCJKLettersAndMonths = 1UL<<22, // 3200-32FF
      urCJKCompatibility            = 1UL<<23, // 3300-33FF
      urHangulSyllables             = 1UL<<24, // AC00-D7AF
      urNonPlane0                   = 1UL<<25, // D800-DFFF
      urPhoenician                  = 1UL<<26, // 10900-1091F
      urCJKUnifiedIdeographs        = 1UL<<27, // 4E00-9FFF, 2E80-2EFF, 2F00-2FDF, 2FF0-2FFF, 3400-4DBF, 20000-2A6DF, 3190-319F
      urPrivateUseAreaPlane0        = 1UL<<28, // E000-F8FF
      urCJKStrokes                  = 1UL<<29, // 31C0-31EF, F900-FAFF, 2F800-2FA1F
      urAlphabeticPresentationForms = 1UL<<30, // FB00-FB4F
      urArabicPresentationFormsA    = 1UL<<31  // FB50-FDFF
   }TUnicodeRange2;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TUnicodeRange3
#else
   typedef enum TUnicodeRange3 : UI32
#endif
   {
      urCombiningHalfMarks          = 1UL<<0,  // FE20-FE2F
      urVerticalForms               = 1UL<<1,  // FE10-FE1F, FE30-FE4F
      urSmallFormVariants           = 1UL<<2,  // FE50-FE6F
      urArabicPresentationFormsB    = 1UL<<3,  // FE70-FEFF
      urHalfwidthAndFullwidthForms  = 1UL<<4,  // FF00-FFEF
      urSpecials                    = 1UL<<5,  // FFF0-FFFF
      urTibetan                     = 1UL<<6,  // 0F00-0FFF
      urSyriac                      = 1UL<<7,  // 0700-074F
      urThaana                      = 1UL<<8,  // 0780-07BF
      urSinhala                     = 1UL<<9,  // 0D80-0DFF
      urMyanmar                     = 1UL<<10, // 1000-109F
      urEthiopic                    = 1UL<<11, // 1200-137F, 1380-139F, 2D80-2DDF
      urCherokee                    = 1UL<<12, // 13A0-13FF
      urUnifiedCanadianAboriginal   = 1UL<<13, // 1400-167F
      urOgham                       = 1UL<<14, // 1680-169F
      urRunic                       = 1UL<<15, // 16A0-16FF
      urKhmer                       = 1UL<<16, // 1780-17FF, 19E0-19FF
      urMongolian                   = 1UL<<17, // 1800-18AF
      urBraillePatterns             = 1UL<<18, // 2800-28FF
      urYiSyllables                 = 1UL<<19, // A000-A48F, A490-A4CF
      urTagalog                     = 1UL<<20, // 1700-171F, 1720-173F, 1740-175F, 1760-177F
      urOldItalic                   = 1UL<<21, // 10300-1032F
      urGothic                      = 1UL<<22, // 10330-1034F
      urDeseret                     = 1UL<<23, // 10400-1044F
      urMusicalSymbols              = 1UL<<24, // 1D000-1D0FF, 1D100-1D1FF, 1D200-1D24F
      urMathematicalAlphanumeric    = 1UL<<25, // 1D400-1D7FF
      urPrivateUsePlane15           = 1UL<<26, // FF000-FFFFD, 100000-10FFFD
      urVariationSelectors          = 1UL<<27, // FE00-FE0F, E0100-E01EF
      urTags                        = 1UL<<28, // E0000-E007F
      urLimbu                       = 1UL<<29, // 1900-194F
      urTaiLe                       = 1UL<<30, // 1950-197F
      urNewTaiLue                   = 1UL<<31  // 1980-19DF
   }TUnicodeRange3;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TUnicodeRange4
#else
   typedef enum TUnicodeRange4 : UI32
#endif
   {
      urBuginese                    = 1UL<<0,  // 1A00-1A1F
      urGlagolitic                  = 1UL<<1,  // 2C00-2C5F
      urTifinagh                    = 1UL<<2,  // 2D30-2D7F
      urYijingHexagramSymbols       = 1UL<<3,  // 4DC0-4DFF
      urSylotiNagri                 = 1UL<<4,  // A800-A82F
      urLinearBSyllabary            = 1UL<<5,  // 10000-1007F, 10080-100FF, 10100-1013F
      urAncientGreekNumbers         = 1UL<<6,  // 10140-1018F
      urUgaritic                    = 1UL<<7,  // 10380-1039F
      urOldPersian                  = 1UL<<8,  // 103A0-103DF
      urShavian                     = 1UL<<9,  // 10450-1047F
      urOsmanya                     = 1UL<<10, // 10480-104AF
      urCypriotSyllabary            = 1UL<<11, // 10800-1083F
      urKharoshthi                  = 1UL<<12, // 10A00-10A5F
      urTaiXuanJingSymbols          = 1UL<<13, // 1D300-1D35F
      urCuneiform                   = 1UL<<14, // 12000-123FF, 12400-1247F
      urCountingRodNumerals         = 1UL<<15, // 1D360-1D37F
      urSundanese                   = 1UL<<16, // 1B80-1BBF
      urLepcha                      = 1UL<<17, // 1C00-1C4F
      urOlChiki                     = 1UL<<18, // 1C50-1C7F
      urSaurashtra                  = 1UL<<19, // A880-A8DF
      urKayahLi                     = 1UL<<20, // A900-A92F
      urRejang                      = 1UL<<21, // A930-A95F
      urCham                        = 1UL<<22, // AA00-AA5F
      urAncientSymbols              = 1UL<<23, // 10190-101CF
      urPhaistosDisc                = 1UL<<24, // 101D0-101FF
      urCarian                      = 1UL<<25, // 102A0-102DF, 10280-1029F, 10920-1093F
      urDominoTiles                 = 1UL<<26  // 1F030-1F09F, 1F000-1F02F
   }TUnicodeRange4;

#endif

   /* The first part of the following flags specifying how the destination page will be zoomed.                     */
   /* Zero values determines that the paramter is not specified (null).                                             */
   /* Example: SetBookmarkDest(bmk, ptXY_Zoom, 50, 700, 0, 0); -> Go to position (X, Y), use the actual zoom factor.*/

   /* The second part of the name (after the underscore "_"), defines what kind of parameter                        */
   /* must be passed to the function. If no such value is defined, all four numeric parameters are ignored.         */

   /* The 'B' stands for bounding box. For example, if the page has a crop box the page will be                     */
   /* zoomed to the width or heigth of the crop box (or both). If the page has no crop box, the media box is used.  */
   /* See help file for further information. */

typedef enum TDestType
{
   dtXY_Zoom,     /* three parameters (a, b, c) -> (X, Y, Zoom)                    */
   dtFit,         /* no parameters                                                 */
   dtFitH_Top,    /* one parameter    (a)                                          */
   dtFitV_Left,   /* one parameter    (a)                                          */
   dtFit_Rect,    /* four parameters  (a, b, c, d) -> (left, bottom, right, top)   */
   dtFitB,        /* no parameters                                                 */
   dtFitBH_Top,   /* one parameter    (a)                                          */
   dtFitBV_Left   /* one parameter    (a)                                          */
}TDestType;

struct TBookmark
{
   UI32            Color;
   SI32            DestPage;
   struct TPDFRect DestPos;
   TDestType       DestType;
   LBOOL           Open;
   SI32            Parent;
   TBmkStyle       Style;
   const void*     Title;
   UI32            TitleLen;
   LBOOL           Unicode;
};

struct TPDFBookmark
{
   UI32            StructSize;    // Must be set to sizeof(TPDFBookmark)
   SI32            Action;        // Action handle or -1 if not set.
   UI32            Color;         // Optional text color. Black is the default value (0).
   SI32            DestPage;      // Destination page.
   struct TPDFRect DestPos;       // Destination position.
   TDestType       DestType;      // Destination type.
   const char*     NamedDestA;    // Optional name of a named destination. If set, DestPage, DestPos, and DestType were already taken from the destination if it was found.
   const UI16*     NamedDestW;    // Either the Unicode or Ansi string is set but never both.
   LBOOL           Open;          // If true, child nodes should be visible.
   SI32            Parent;        // The immediate parent node or -1 for a root node.
   const void*     StructElem;    // Bookmarks can contain a reference to a structure element. There is no API to access structure elements yet.
   TBmkStyle       Style;         // The font style that should be used to render this node.
   const char*     TitleA;        // The bookmark title.
   const UI16*     TitleW;        // Either the Unicode or Ansi string is set but never both.
   UI32            TitleLen;      // String length in characters.
};

typedef UI32 TCheckOptions;
#define coDefault                  0x0010FFFF
#define coEmbedSubsets             0x00000001
#define coDeleteTransferFuncs      0x00000002
#define coDeleteMultiMediaContents 0x00000004
#define coDeleteActionsAndScripts  0x00000008
#define coDeleteInvRenderingIntent 0x00000010
#define coFlattenFormFields        0x00000020
#define coReplaceV4ICCProfiles     0x00000040
#define coDeleteEmbeddedFiles      0x00000080
#define coDeleteOPIComments        0x00000100
#define coDeleteSignatures         0x00000200
#define coDeletePostscript         0x00000400 // Delete Postscript XObjects. Rarely used and such Postscript fragments are meaningful on a Postscript device only.
                                              // It is usually safe to delete such objects.
#define coDeleteAlternateImages    0x00000800 // Alternate images are seldom used and prohibited in PDF/A.
#define coReComprJPEG2000Images    0x00001000 // JPEG 2000 images are prohibited in PDF/A 1. The conversion to PDF/A 1 will fail if the flag is absent and if a file contains JPEG 2000 images.
#define coResolveOverprint         0x00002000 // PDF/A 2 and 3. Set the overprint mode to 0 if overprint mode = 1 and if overprinting for fill or stroke is true
                                              // and if an ICCBased CMYK color space is used. Note that DeviceCMYK is treated as ICCBased color space due to implicit
                                              // color conversion rules.
#define coMakeLayerVisible         0x00004000 // PDF/A 2 and 3 prohibit invisible layers. Layers can also be flattened if this is no option.
#define coDeleteAppEvents          0x00008000 // PDF/A 2 and 3. Application events are prohibited in PDF/A. The view state will be applied.
#define coReplCCITTFaxWithFlate    0x00010000 // Replace CCITT Fax compression with Flate.
#define coApplyExportState         0x00020000 // Meaningful only if coDeleteAppEvents is set. Apply the export state.
#define coApplyPrintState          0x00040000 // Meaningful only if coDeleteAppEvents is set. Apply the print state.
#define coDeleteReplies            0x00080000 // Delete annotation replies. If absent, replies will be converted to regular text annotations.
#define coDeleteHalftones          0x00100000 // Delete halftone screens.
#define coFlattenLayers            0x00200000 // Flatten layers if any.
#define coDeletePresentation       0x00400000 // Presentations are prohibited in PDF/A 2 and 3.
#define coCheckImages              0x00800000 // If set, images will be decompressed to identify damaged images.
#define coDeleteDamagedImages      0x01000000 // Meaningful only if coCheckImages is set.
#define coRepairDamagedImages      0x02000000 // Meaningful only if coCheckImages is set. If set, try to recompress a damaged image. The new image is maybe not complete but error free.
#define coNoFontEmbedding          0x10000000 // If this flag is set no valid PDF/A file will be produced!
#define coFlushPages               0x20000000 // Write converted pages directly into the output file to reduce the memory usage.
#define coAllowDeviceSpaces        0x40000000 // If set, device color spaces will not be replaced with ICC based color spaces. This flag is meaningful for normalization only.
#define coResetAnnotAppearance     0x80000000 // If set, appearance streams of annotations are rebuild before executing CheckConformance().

// Common default flags for normalization:
#define coDefault_Normalize        (coAllowDeviceSpaces | coNoFontEmbedding)
// Common default flags for different PDF/A versions:
#define coDefault_PDFA_1           (coDefault | coFlattenLayers)                                   // The ability to flatten layers was added after coDefault was defined.
#define coDefault_PDFA_2           ((coDefault & ~coReComprJPEG2000Images) | coDeletePresentation) // Presentations are prohibited in PDF/A 2 and PDF/A 3.
#define coDefault_PDFA_3           (coDefault_PDFA_2 & ~coDeleteEmbeddedFiles)                     // Embedded files are allowed in PDF/A 3.
#define coDefault_PDFA_4           (coDefault_PDFA_2 & ~coDeleteEmbeddedFiles)                     // Embedded files are allowed in PDF/A 4.

// The data for user defined columns are stored in collection items.
typedef enum TColColumnType
{
   cisCreationDate,  // Data comes from the embedded file
   cisDescription,   // Data comes from the embedded file
   cisFileName,      // Data comes from the embedded file
   cisModDate,       // Data comes from the embedded file
   cisSize,          // Data comes from the embedded file
   cisCustomDate,    // User defined date.
   cisCustomNumber,  // User defined number.
   cisCustomString,  // User defined string.
   cisCompressedSize // Data comes from the embedded file
}TColColumnType;

typedef enum TColView
{
   civNotSet,
   civDetails,
   civTile,
   civHidden,
   civCustom  // PDF 1.7 Extension Level 3, the collection view is presented by a SWF file.
}TColView;

/*
   Please note that images must be decompressed if one of the following flags are set. Parsing gray or color images
   is in most cases not useful and you should not parse such images if it is not really required.
*/
typedef UI32 TCompBBoxFlags;
#define cbfNone              0x00000000
#define cbfIgnoreWhiteAreas  0x00000001 // Ignore white vector graphics or text.
#define cbfParse1BitImages   0x00000002 // Find the visible area in 1 bit images. This is the most important case
                                        // since scanned faxes are usually 1 bit images.
#define cbfParseGrayImages   0x00000004 // Find the visible area in gray images.
#define cbfParseColorImages  0x00000008 // Find the visible area in color images. This is usually not required
                                        // and slow downs processing a lot.
#define cbfParseAllImages    0x0000000E // Find the visible area in all images.

typedef enum TConformanceType
{
   ctPDFA_1b_2005,     // Convert the file to PDF/A 1b if possible
   ctNormalize,        // Check the file for errors, rebuild all embedded fonts plus options
   ctPDFA_2b,          // Convert the file to PDF/A 2b if possible
   ctPDFA_3b,          // Convert the file to PDF/A 3b if possible
   /* --------------------------------------------------------------------------------------------------------------------
    *                            ZUGFeRD, ZUGFeRD 2.0, and Factur-X / ZUGFeRD 2.1 or higher output
    * --------------------------------------------------------------------------------------------------------------------
    * The following constants convert the file to PDF/A 3b and set the whished ZUGFeRD, ZUGFeRD 2.0 or Factur-X conformance
    * level in the XMP metadata. Note that ZUGFeRD 2.1 or higher and Factur-X are technically the same in PDF. Note also that
    * CheckConformance() does not validate the XML invoice but it checks whether it is present.
    * The embedded XML invoice must be named as follows (case-sensitive and without quotes):
    *
    *  ZUGFeRD 1.0:            "ZUGFeRD-invoice.xml"
    *  ZUGFeRD 2.0:            "zugferd-invoice.xml"
    *  Factur-X / ZUGFeRD 2.1: "factur-x.xml"
    *  XRechnung:              "xrechnung.xml"
    *
    * Setting the correct ZUGFeRD or Factur-X conformance level is important since this value defines which fields must be
    * present in the XML invoice.
    */
   // ZUGFeRD 1.0:
   ctZUGFeRD_Basic,     // Basic profile
   ctZUGFeRD_Comfort,   // Comfort profile
   ctZUGFeRD_Extended,  // Extended profile
   // ZUGFeRD 2.0:
   ctZUGFeRD2_Minimum,  // Minimum profile
   ctZUGFeRD2_Basic,    // Basic profile
   ctZUGFeRD2_Basic_WL, // Basic WL profile
   ctZUGFeRD2_Comfort,  // EN 16931 profile
   ctZUGFeRD2_Extended, // Extended profile
   // Factur-X / ZUGFeRD 2.1 or higher:
   ctFacturX_Minimum,   // Minimum profile
   ctFacturX_Basic,     // Basic profile
   ctFacturX_Basic_WL,  // Basic WL profile
   ctFacturX_Comfort,   // EN 16931 profile
   ctFacturX_Extended,  // Extended profile
   ctFacturX_XRechnung, // German XRechnung profile
   ctPDFA_2u,           // Convert the file to PDF/A 2u if possible
   ctPDFA_3u,           // Convert the file to PDF/A 3u if possible
   ctPDFA_4,            // Convert the file to PDF/A 4 if possible. Embedded files are supported but no file attach annotations.
   ctPDFA_4e,           // Convert the file to PDF/A 4e if possible. This version allows 3D contents in rich media annotations.
   ctPDFA_4f            // Convert the file to PDF/A 4f if possible. This version allows file attach annotations.
}TConformanceType;

typedef enum TDateType
{
   dtCreationDate,
   dtModDate
}TDateType;

typedef enum TDecSeparator
{  /* thousand separator, decimal separator */
   dsCommaDot,
   dsNoneDot,
   dsDotComma,
   dsNoneComma,
   dsQuoteDot
}TDecSeparator;

typedef enum TDuplexMode
{
   dpmNone,          // Default
   dpmSimplex,
   dpmFlipShortEdge,
   dpmFlipLongEdge
}TDuplexMode;

typedef enum TEmbFileLocation
{
   eflChild,         // The file is an embedded file in the current document
   eflChildAnnot,    // The file is located in a file attachment annotion in the current document
   eflExternal,      // The file is an embedded file in an external document
   eflExternalAnnot, // The file is located in a file attachment annotion in an external document
   eflParent,        // The file is located in the parent document
   eflParentAnnot    // The file is located in a file attachment annotion in the parent document
}TEmbFileLocation;

typedef enum TFieldColor
{
   fcBackColor   = 0,
   fcBorderColor = 1,
   fcTextColor   = 2
}TFieldColor, TAnnotColor;

typedef UI32 TFieldFlags;
#define ffReadOnly         0x00000001
#define ffRequired         0x00000002
#define ffNoExport         0x00000004

#define ffInvisible        0x00000008
#define ffHidden           0x00000010
#define ffPrint            0x00000020
#define ffNoZoom           0x00000040
#define ffNoRotate         0x00000080
#define ffNoView           0x00000100

#define ffMultiline        0x00001000  /* Text fields only */
#define ffPassword         0x00002000  /* Text fields only */
#define ffNoToggleToOff    0x00004000  /* Radio buttons, check boxes */
#define ffRadioIsUnion     0x02000000  /* PDF-1.5 Radio buttons */
#define ffCommitOnSelCh    0x04000000  /* PDF-1.5 combo boxes, list boxes */

#define ffEdit             0x00040000  /* Combo boxes only */
#define ffSorted           0x00080000  /* Combo boxes and list boxes -> sorts the choice values in ascending order*/
#define ffFileSelect       0x00100000  /* PDF 1.4 Text fields only */
#define ffMultiSelect      0x00200000  /* PDF 1.4 List boxes only  */
#define ffDoNotSpellCheck  0x00400000  /* PDF 1.4 Text fields, combo boxes. If the field is a combo box, this flag is meaningful only if ffEdit is also set. */
#define ffDoNotScroll      0x00800000  /* PDF 1.4 Text fields only */
#define ffComb             0x01000000  /* PDF 1.5 Text fields only */

typedef enum TFieldType
{
   ftButton    = 0,
   ftCheckBox  = 1,
   ftRadioBtn  = 2,
   ftComboBox  = 3,
   ftListBox   = 4,
   ftText      = 5,
   ftSignature = 6,
   ftGroup     = 7 // this is not a real field type, it is just an array of fields
}TFieldType;

typedef enum TFileAttachIcon
{
   faiGraph,
   faiPaperClip,
   faiPushPin,
   faiTag,
   faiUserDefined
}TFileAttachIcon;

typedef enum TFileOP
{
   foOpen,
   foPrint
}TFileOP;

typedef enum TFlushPageFlags
{
   fpfDefault      = 0, // Write anything to the file that is possible
   fpfImagesOnly   = 1, // If set, only images are written to the file. The pages are still
                        // in memory and can be modified with EditPage(). Flushed images can
                        // still be referenced in other pages. The image handles remain valid.
   fpfExclLastPage = 2  // If set, the last page is not flushed
}TFlushPageFlags;

typedef enum THashType
{
   htDetached, // CloseAndSignFileExt() returns the byte ranges of the finish PDF buffer to create a detached signature
   htSHA1      // CloseAndSignFileExt() returns the SHA1 hash of the PDF file so that it can be signed
}THashType;

typedef enum THighlightMode
{
   hmNone     = 0,
   hmInvert   = 1,
   hmOutline  = 2,
   hmPush     = 3,
   hmPushUpd  = 4, // Update appearance stream on changes
   hmNotSet   = -1 // Internal
}THighlightMode;

typedef enum TImageConversionFlags
{
   icNone      = 0, // Default
   icUseCCITT4 = 1  // Use CCITT Fax 4 compression instead of Flate for dithered images.
}TImageConversionFlags;

typedef UI32 TImportFlags;
#define ifImportAll        0x0FFFFFFE // default
#define ifContentOnly      0x00000000
// If this flag is set, only interactive objects are imported if any, Otherwise only empty pages are imported.
// This flag can be used to copy an Interactive Form, bookmarks or annotations to another PDF file.
#define ifNoContent        0x00000001
// The imported page is not converted to a template if ifImportAsPage is set.
// Note that this flag can cause resource conflicts. Use this flag carefully!
#define ifImportAsPage     0x80000000
// base objects
#define ifCatalogAction    0x00000002 // Open action, Catalog actions
#define ifPageActions      0x00000004
#define ifBookmarks        0x00000008
#define ifArticles         0x00000010
#define ifPageLabels       0x00000020
#define ifThumbs           0x00000040
#define ifTranspGroups     0x00000080 // This flag is no longer considered.
#define ifSeparationInfo   0x00000100
#define ifBoxColorInfo     0x00000200
#define ifStructureTree    0x00000400
#define ifTransition       0x00000800
#define ifSearchIndex      0x00001000
#define ifJavaScript       0x00002000 // Global JavaScripts
#define ifJSActions        0x00004000 // JavaScript actions
#define ifDocInfo          0x00008000 // Document info entries
#define ifEmbeddedFiles    0x00200000 // File attachments
#define ifFileCollections  0x00400000 // File collections (PDF 1.7)
// Annotations -> Only the most important annotation types can be selected directly.
// Note that all annotation types can be deleted with DeleteAnnotation.
#define ifAllAnnots        0x009F0000
   #define ifFreeText      0x00010000
   #define ifTextAnnot     0x00020000
   #define ifLink          0x00040000
   #define ifStamp         0x00080000
   #define if3DAnnot       0x00100000
   #define ifOtherAnnots   0x00800000
// Interactive Form Fields are annotations too but we handle this type separately!
#define ifFormFields       0x01000000
#define ifPieceInfo        0x02000000 // The PieceInfo dictionary contains arbitrary user defined data. The data in
                                      // this dictionary is meaningful only for the application that created the data.

/* -------------------- Special flags -------------------- */
#define ifPrepareForPDFA   0x10000000 // Replace LZW compression with Flate, set the Interpolate key of images to false, do not import embedded files.
#define ifEnumFonts        0x20000000 // Import fonts for EnumDocFonts(). The document must be deleted when this flag is set!!!
#define ifAllPageObjects   0x40000000 // Import links when using ImportPageEx() within an open page. The entire document should be imported in this case.

typedef UI32 TImportFlags2;
#define if2MergeLayers     0x00000001 // If set, layers with identical name are merged. If this flag is absent DynaPDF
                                      // imports such layers separately so that each layer refers still to the pages
                                      // where it was originally used.
#define if2Normalize       0x00000002 // Replace LZW compression with Flate, apply limit checks, repair errors if possible
#define if2UseProxy        0x00000004 // If set, all streams are loaded from the file on demand but they are never hold in memory. This drastically reduces the
                                      // memory usage and enables the processing of almost arbitrary large PDF files with minimal memory usage. The corresponding
                                      // PDF file must not be deleted before CloseFile() or CloseFileEx() was called. The flag can be set for memory based PDF files
                                      // too. This is especially useful when pages should be rendered because streams can be decompressed on demand and released when
                                      // no longer needed.
#define if2NoMetadata      0x00000008 // Ignore metadata streams which are attached to fonts, pages, images, and so on.
#define if2DuplicateCheck  0x00000010 // Perform a duplicate check on color spaces, fonts, images, patterns, and templates when merging PDF files.
#define if2NoResNameCheck  0x00000020 // Import resources as is. This flag can significantly improve the loading time of pages with a huge resource tree.
                                      // This flag should only be set in viewer applications to improve the loading time of pages.
#define if2CopyEncryptDict 0x00000040 // If set, the encryption settings of an encrypted PDF file are copied to the new PDF file.
                                      // The flag does nothing if the file is not encrypted.
#define if2SkipDPartData   0x00000080 // If set, DPart dictionaries are not imported.
#define if2IncrementalUpd  0x00000100 /* This flag also sets the flags if2UseProxy, if2CopyEncryptDict, as well as ifImportAsPage and ifImportAll.

                                         If set, the next PDF file that is opened for import is prepared for an incremental update. The PDF file must be opened and
                                         imported BEFORE adding pages, bookmarks, or arbitrary other contents.

                                         The flag if2UseProxy creates a proxy so that the file can be copied to the output file or output buffer when CloseFile(),
                                         CloseAndSignFile(), or CloseAndSignFileExt() is called. All functions which encrypt the PDF file like CloseFileEx(), or
                                         CloseAndSignFileEx() for example, are prohibited because it is not possible to override the encryption settings or
                                         to save an unencrypted file encrypted with an incremental update.

                                         The flag if2CopyEncryptDict makes sure that the original encryption settings are copied to the output file.
                                      */

struct TI32QuadPoint
{
   struct TI32Point P1;
   struct TI32Point P2;
   struct TI32Point P3;
   struct TI32Point P4;
};

struct TIntRect
{
   SI32 x1;
   SI32 y1;
   SI32 x2;
   SI32 y2;
  #ifdef __cplusplus
   TIntRect(void) :
      x1( 0x7FFFFFFF),
      y1( 0x7FFFFFFF),
      x2(-0x7FFFFFFF),
      y2(-0x7FFFFFFF)
   {}
   TIntRect(SI32 x1_, SI32 y1_, SI32 x2_, SI32 y2_) :
      x1(x1_),
      y1(y1_),
      x2(x2_),
      y2(y2_)
   {}
   void Add(SI32 X, SI32 Y)                     {x1 += X; y1 += Y; x2 += X; y2 += Y;}
   SI32 Height(void)                            {return (y2-y1);}
   void Init(SI32 X1, SI32 Y1, SI32 X2, SI32 Y2){x1 = X1; y1 = Y1; x2 = X2; y2 = Y2;}
   bool IsEmpty(void) const                     {return (x2 < x1 || y2 < y1);}
   bool IsInside(SI32 x, SI32 y) const          {return (x >= x1 && x <= x2 && y >= y1 && y <= y2);}
   void Normalize(void)
   {
      SI32 t;
      if (x2 < x1)
      {
         t  = x1;
         x1 = x2;
         x2 = t;
      }
      if (y2 < y1)
      {
         t  = y1;
         y1 = y2;
         y2 = t;
      }
   }
   void Reset(void)
   {
      x1 =  0x7FFFFFFF;
      y1 =  0x7FFFFFFF;
      x2 = -0x7FFFFFFF;
      y2 = -0x7FFFFFFF;
   }
   void Widen(SI32 x, SI32 y)
   {
      if (x < x1)
         x1 = x;
      if (x > x2)
         x2 = x;
      if (y < y1)
         y1 = y;
      if (y > y2)
         y2 = y;
   }
   void Widen(SI32 x1_, SI32 y1_, SI32 x2_, SI32 y2_)
   {
      if (x1_ < x1)
         x1 = x1_;
      if (y1_ < y1)
         y1 = y1_;
      if (x2_ > x2)
         x2 = x2_;
      if (y2_ > y2)
         y2 = y2_;
   }
   void Widen(TI32Point &P1, TI32Point &P2, TI32Point &P3, TI32Point &P4)
   {
      Widen(P1.x, P1.y);
      Widen(P2.x, P2.y);
      Widen(P3.x, P3.y);
      Widen(P4.x, P4.y);
   }
   SI32 Width(void)                          {return (x2-x1);}
   void operator <<= (const UI32 Value)      {x1 <<= Value; y1 <<= Value; x2 <<= Value; y2 <<= Value;}
   void operator >>= (const UI32 Value)      {x1 >>= Value; y1 >>= Value; x2 >>= Value; y2 >>= Value;}
   bool operator  == (TIntRect &Value) const {return (Value.x1 == x1 && Value.y1 == y1 && Value.x2 == x2 && Value.y2 == y2);}
   bool operator  != (TIntRect &Value) const {return (Value.x1 != x1 || Value.y1 != y1 || Value.x2 != x2 || Value.y2 != y2);}
  #endif
};

typedef enum TLineEndStyle
{
   leNone,
   leButt,
   leCircle,
   leClosedArrow,
   leDiamond,
   leOpenArrow,
   leRClosedArrow,
   leROpenArrow,
   leSlash,
   leSquare
}TLineEndStyle;

typedef enum TLineCaptionPos
{
   cpInline, // The caption is centered inside the line
   cpTop     // The caption is drawn on top of the line
}TLineCaptionPos;

typedef enum TMeasureNumFormat
{
   mnfDecimal,
   mnfFractional,
   mnfRound,
   mnfTruncate
}TMeasureNumFormat;

typedef enum TMeasureLblPos
{
   mlpSuffix,
   mlpPrefix
}TMeasureLblPos;

typedef enum TMetadataObj
{
   mdoCatalog,
   mdoFont,
   mdoImage,
   mdoPage,
   mdoTemplate
}TMetadataObj;

typedef enum TNamedAction
{
   naFirstPage,
   naLastPage,
   naNextPage,
   naPrevPage,
   naGoBack,
   naOpenDlg,
   naPrintDlg,
   naGeneralInfo,
   naFontsInfo,
   naSaveAs,
   naSecurityInfo,
   naFitPage,
   naFullScreen,
   naDeletePages,
   naQuit,
   naUserDefined   // Non predefined action
}TNamedAction;

typedef enum TNegativeStyle
{
   nsMinusBlack,
   nsRed,
   nsParensBlack,
   nsParensRed
}TNegativeStyle;

typedef enum TObjEvent
{ /* All actions which should be applied to an event (except OnMouseUp) must be a JavaScript action! */
   oeNoEvent,           /* Internal use only -> DO NOT USE THIS VALUE!!! */
   oeOnOpen,            /* Catalog, Pages */
   oeOnClose,           /* Pages only */
   oeOnMouseUp,         /* All fields, page link annotations, bookmarks */
   oeOnMouseEnter,      /* Form fields only */
   oeOnMouseExit,       /* Form fields only */
   oeOnMouseDown,       /* Form fields only */
   oeOnFocus,           /* Form fields only */
   oeOnBlur,            /* Form fields only */
   oeOnKeyStroke,       /* Text fields only */
   oeOnFormat,          /* Text fields only */
   oeOnCalc,            /* Text fields, combo boxes, list boxes */
   oeOnValidate,        /* All form fields, except buttons  */
   oeOnPageVisible,     /* PDF 1.5 -> Form fields only */
   oeOnPageInVisible,   /* PDF 1.5 -> Form fields only */
   oeOnPageOpen,        /* PDF 1.5 -> Form fields only */
   oeOnPageClose,       /* PDF 1.5 -> Form fields only */
   oeOnBeforeClosing,   /* PDF 1.4 -> Catalog only */
   oeOnBeforeSaving,    /* PDF 1.4 -> Catalog only */
   oeOnAfterSaving,     /* PDF 1.4 -> Catalog only */
   oeOnBeforePrinting,  /* PDF 1.4 -> Catalog only */
   oeOnAfterPrinting    /* PDF 1.4 -> Catalog only */
}TObjEvent;

typedef enum TObjType
{
   otAction,
   otAnnotation,
   otBookmark,
   otCatalog,    // PDF 1.4
   otField,
   otPage,
   otPageLink
}TObjType;

typedef enum TOCAppEvent
{
   aeExport = 1,
   aePrint  = 2,
   aeView   = 4
}TOCAppEvent;

typedef enum TOCGIntent
{
   oiDesign  = 2,
   oiView    = 4,
   oiAll     = 8,
   oiEmpty   = 16,
   // Special flag for GetOCG().
   oiVisible = 32  // This flag is not considered when creating a layer. It is only used in GetOCG() to determine whether a layer is visible.
}TOCGIntent;

typedef enum TOCObject
{
   ooAnnotation,
   ooField,
   ooImage,
   ooTemplate
}TOCObject;

typedef enum TOCPageElement
{
   peBackgroundImage, // BG
   peForegroundImage, // FG
   peHeaderFooter,    // HF
   peLogo,            // L
   peNone
}TOCPageElement;

typedef enum TOCGUsageCategory
{
   oucNone     = 0,
   oucExport   = 1,
   oucLanguage = 2,
   oucPrint    = 4,
   oucUser     = 8,
   oucView     = 16,
   oucZoom     = 32
}TOCGUsageCategory;

typedef enum TOCUserType
{
   utIndividual,
   utOrganization,
   utTitle,
   utNotSet
}TOCUserType;

typedef enum TOCVisibility
{
   ovAllOff,
   ovAllOn,
   ovAnyOff,
   ovAnyOn,
   ovNotSet
}TOCVisibility;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TOptimizeFlags
#else
   typedef enum TOptimizeFlags : UI32
#endif
{
   ofDefault               = 0x00000000, // Just rebuild the content streams.
   ofInMemory              = 0x00000001, // Optimize the file fully in memory. Only useful for small PDF files.
   ofConvertAllColors      = 0x00000002, // If set, Separation, DeviceN, and NChannel color spaces will be converted to the device space.
   ofIgnoreICCBased        = 0x00000004, // If set, ICCBased color spaces will be left unchanged.
   ofScaleImages           = 0x00000008, // Scale images as specified in the TOptimizeParams structure.
   ofSkipMaskedImages      = 0x00000010, // Meaningful only if ofScaleImages is set. If set, don't scale images with a color mask.
   ofNewLinkNames          = 0x00000020, // If set, rename all object links to short names like F1, F2 etc.
   ofDeleteInvPaths        = 0x00000040, // Delete invisible paths. An invisible path is a path that was finished with the no-op operator "n".
   ofFlattenLayers         = 0x00000080, // Flatten layers if any.
   ofDeletePrivateData     = 0x00000100, // Delete private data objects from pages, templates, and images.
   ofDeleteThumbnails      = 0x00000200, // Thumbnails can be deleted since PDF viewers can create thumbnails easily on demand.
   ofDeleteAlternateImages = 0x00000400, // If set, alternate images will be deleted.
   ofNoImageSizeCheck      = 0x00000800, // Meaningful only if ofScaleImages is set. If set, do not check whether the scaled image is smaller as the original image.
   ofIgnoreZeroLineWidth   = 0x00001000, // Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                         // If set, ignore line width operators with a value of zero (zero means one device unit).
   ofAdjZeroLineWidthOnly  = 0x00002000, // Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                         // If set, change the line width of real hairlines only (a hairline is a one pixel width line -> LineWidth == 0).
   ofCompressWithJBIG2     = 0x00004000, // If set, 1 bit images are compressed with JBIG2 if not already compressed with this filter.
   ofNoFilterCheck         = 0x00008000, // Meaningful only, if the flag ofCompressWithJBIG2 is set. If set, re-compress all 1 bit images, also if already compressed with JBIG2.
                                         // This flag is mainly a debug flag to compare the compression ratio with other JBIG2 implementations.
   ofConvertGrayTo1Bit     = 0x00010000, // Useful for scanned faxes since many scanners create gray images for black & white input.
   /* ---------------------------- Notice: ----------------------------------------------
    * Special color spaces like Separation, DeviceN, and NChannel are ignored unless the flag ofConvertAllColors is set too.
    */
   ofConvertToGray         = 0x00020000, // If set, images, text, and vector graphics are converted to DeviceGray.
   ofConvertToRGB          = 0x00040000, // If set, images, text, and vector graphics are converted to DeviceRGB.
   ofConvertToCMYK         = 0x00080000, // If set, images, text, and vector graphics are converted to DeviceCMYK.
   ofConvertClrMask        = ofConvertToGray | ofConvertToRGB | ofConvertToCMYK, // internal
   ofReplaceJP2KWithJPEG   = 0x00100000, // Meaningful only, if the flag ofConvertToGray, ofConvertToRGB, or ofConvertToCMYK is set. If set, JPEG 2000 compressed images
                                         // (which are converted to another color space) will be compressed with JPEG instead JPEG 2000. JPEG 2000 compression is very slow
                                         // and requires much memory. JPEG compression is around 10 times faster and produces almost identical results.
   ofUseOtsuFilter         = 0x00200000, // Meaningful only, if the flag ofConvertGrayTo1Bit is set. The Otsu filter is useful for gray scanned faxes.
   ofConvTextToOutlines    = 0x00400000, // If set, texts of non-Type3 fonts are converted to outlines or vector graphics. The resulting file contains no fonts with
                                         // exception of Type3 fonts, if any. Such files are large but avoid printing issues due to missing or damaged fonts.
   ofConvNonEmbFontsOnly   = 0x00800000, // Meaningful only, if the flag ofConvTextToOutlines is set. If set, text of non-embedded fonts are converted to outlines only.
                                         // Embedded fonts remain embedded.
   ofIgnoreDeviceN         = 0x01000000, // If set, DeviceN color spaces are left unchanged.
   ofIgnoreNChannel        = 0x02000000, // If set, NChannel color spaces are left unchanged.
   ofIgnoreSeparation      = 0x04000000, // If set, Separation color spaces are left unchanged.
   ofFailOnOverprinting    = 0x08000000, // Meaningful only if a color conversion flag is set. If set, the function returns with a fatal error if an object with enabled
                                         // overprinting was found on the page. The appearance of overprinted objects would change and make the page maybe unusable.
                                         // Overprinted objects can be left unchanged (set the flag ofSkipOverprintedObj in this case) or Optimize() can return with a fatal
                                         // error to avoid the creation of an invalid document.
   ofSkipOverprintedObj    = 0x10000000, // Meaningful only if a color conversion flag is set. If set, objects that would be rendered with enabled overprinting are left
                                         // unchanged to avoid color errors on the page.
   ofRemoveBatesNumbers    = 0x20000000, // Remove bates numbers if any. The type BatesN can also contain headers / footers.
   ofRemoveHeaderFooter    = 0x40000000, // Remove headers / footers if any. This type is set if no bates numbering was added.
   ofIgnoreSeparationAll   = 0x80000000  // Meaningful only if a color conversion flag is set. If set, Separation color spaces with the special colorant "All" will be ignored.
}TOptimizeFlags;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TOptimizeFlags2
#else
   typedef enum TOptimizeFlags2 : UI32
#endif
{
   of2Default               = 0x00000000, // Nothing to do
   of2DeleteWatermarks      = 0x00000001, // Delete watermark templates
   of2DeleteWatermarkAnnots = 0x00000002  // If set, watermark annotations will be deleted.
}TOptimizeFlags2;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TOptimizeFlags3
#else
   typedef enum TOptimizeFlags3 : UI32
#endif
{
   of3Default              = 0x00000000  // Nothing to do
}TOptimizeFlags3;

#if !defined(__cplusplus) || (__cplusplus <= 199711)
   typedef enum TOptimizeFlags4
#else
   typedef enum TOptimizeFlags4 : UI32
#endif
{
   of4Default              = 0x00000000  // Nothing to do
}TOptimizeFlags4;

struct TOptimizeParams
{
   UI32               StructSize;     // Must be set to sizeof(TOptimizeParams).

   UI32               Min1BitRes;     // Minimum resolution before scaling.
   UI32               MinGrayRes;     // Minimum resolution before scaling.
   UI32               MinColorRes;    // Minimum resolution before scaling.

   UI32               Res1BitImages;  // 1 bit black & white images.
   UI32               ResGrayImages;  // Gray images.
   UI32               ResColorImages; // Multi-channel images.

   TCompressionFilter Filter1Bit;     // Filter for black & white images.
   TCompressionFilter FilterGray;     // Filter for gray images.
   TCompressionFilter FilterColor;    // Filter for multi-channel images.

   SI32               JPEGQuality;    // JPEG quality.
   SI32               JP2KQuality;    // JPEG 2000 quality.
   float              MinLineWidth;   // Zero means no hair line removal.
   const UI32*        ExcludeCS;      // Array of color space handles which should be excluded from color conversion.
   SI32               ExcludeCSCount; // Number of color space handles in the array. The value can be negative to reverse the meaning.
                                      // If negative, only these color spaces will be converted.
   TOptimizeFlags2    Flags2;         // Additional flags
   TOptimizeFlags3    Flags3;         // Additional flags
   TOptimizeFlags4    Flags4;         // Additional flags
};

typedef enum TPageLabelFormat
{
   plfDecimalArabic,    // 1,2,3,4...
   plfUppercaseRoman,   // I,II,III,IV...
   plfLowercaseRoman,   // i,ii,iii,iv...
   plfUppercaseLetters, // A,B,C,D...
   plfLowercaseLetters, // a,b,c,d...
   plfNone
}TPageLabelFormat;

typedef enum TPageLayout
{
   plSinglePage      = 0x00000000,
   plOneColumn       = 0x00000001,
   plTwoColumnLeft   = 0x00000002,
   plTwoColumnRight  = 0x00000003,
   plTwoPageLeft     = 0x00000004, // PDF 1.5
   plTwoPageRight    = 0x00000005, // PDF 1.5
   plDefault         = 0x00000006  // Use viewer's default settings
}TPageLayout;

typedef enum TPageMode
{
   pmUseNone        = 0,
   pmUseOutlines    = 1,
   pmUseThumbs      = 2,
   pmFullScreen     = 3,
   pmUseOC          = 4, // PDF 1.5
   pmUseAttachments = 5  // PDF 1.6
}TPageMode;

typedef UI32 TParseFlags;
#define pfNone             0x00000000
#define pfDecomprAllImages 0x00000002 // This flag causes that all image formats will be decompressed. If this
                                      // flag is not set, images which are already stored in a valid image file
                                      // format are returned as is. This is the case for Gray and RGB JPEG
                                      // images and for JPEG2000 images. If you want to extract the images
                                      // of a PDF file this flag should NOT be set!

#define pfNoJPXDecode      0x00000004 // Meaningful only if the flag pfDecomprAllImages is set. If set,
                                      // JPEG2000 images are returned as is so that you can use your own
                                      // library to decompress such images.

// The following flags are ignored if an image is not decompressed. Note that only one flag must be set
// at time. If no color space conversion flag is set images are returned in their native or alternate
// device color space. Note that these flags do not convert colors of vector graphics and so on.
// Use the function ConvColor() to convert colors of the graphics state into a device space.
#define pfDitherImagesToBW 0x00000008 // Floyd-Steinberg dithering.
#define pfConvImagesToGray 0x00000010
#define pfConvImagesToRGB  0x00000020
#define pfConvImagesToCMYK 0x00000040
#define pfImageInfoOnly    0x00000080 // If set, images are not decompressed. This flag is useful if you want
                                      // to enumerate the images of a PDF file or if you want to determine how
                                      // many images are stored in it.
                                      // Note that images can be compressed with multiple filters. The member
                                      // Filter of the structure TPDFImage contains only the last filter with
                                      // which the image was compressed. There is no indication whether multiple
                                      // decode filters are required to decompress the image buffer. So, it
                                      // makes no sense to set this flag if you want to try to decompress the
                                      // image buffer manually with your own decode filters.
#define pfErrorCheckOnly   0x00000100 // If set, images are checked for decompression errors only.
#define pfIgnoreColorSpace 0x00000200 // Internal flag used by the JPEG 2000 decoder. Do not set this flag!
#define pfFailOnError      0x80000000 // Fail on decompression errors. Used internally by CheckConformance().

/* The tags have the same meaning as the corresponding HTML tags.
   See PDF Reference for further information.

   Note that certain tags like btListElem or btTableDataCell cannot be used stand alone.
   Such tags require a parent tag of the correct type:

   Example:

      pdfOpenTag(PDF, btList, NULL, NULL, NULL);               // OK
         pdfOpenTag(PDF, btListElem, NULL, NULL, NULL);        // OK
            pdfOpenTag(PDF, btListElemText, NULL, NULL, NULL); // OK
               pdfWriteText(PDF, 50.0, 50.0, "List Text!");
            pdfCloseTag(PDF);
         pdfCloseTag(PDF);
      pdfCloseTag(PDF);

   ---------------------------------------------------------------------------------

      pdfOpenTag(PDF, btList, NULL, NULL, NULL);               // OK
         pdfOpenTag(PDF, btListElemText, NULL, NULL, NULL);    // False -> Parent list element must be btListElem
            pdfOpenTag(PDF, btListElem, NULL, NULL, NULL);     // False -> Parent list element must be btList
               pdfWriteText(PDF, 50.0, 50.0, "List Text!");
            pdfCloseTag(PDF);
         pdfCloseTag(PDF);
      pdfCloseTag(PDF);

   ---------------------------------------------------------------------------------

      pdfOpenTag(PDF, btList, NULL, NULL, NULL);               // OK
         pdfOpenTag(PDF, btListElem, NULL, NULL, NULL);        // OK
            pdfWriteText(PDF, 50.0, 50.0, "List Element!");
         pdfCloseTag(PDF);
      pdfCloseTag(PDF);

   ---------------------------------------------------------------------------------

      pdfOpenTag(PDF, btListElem, NULL, NULL, NULL);           // False -> No parent list element!
         pdfWriteText(PDF, 50.0, 50.0, "List Element!");
      pdfCloseTag(PDF);
*/
typedef enum TPDFBaseTag
{
   btArt,
   btArtifact,
   btAnnot,         // An annotation must be inserted to finish the tag!
   btBibEntry,      // BibEntry -> Bibliography entry
   btBlockQuote,
   btCaption,
   btCode,
   btDiv,
   btDocument,
   btFigure,
   btForm,          // A form field must be inserted to finish the tag!
   btFormula,
   btH,
   btH1,
   btH2,
   btH3,
   btH4,
   btH5,
   btH6,
   btIndex,
   btLink,          // A link annotation must be inserted to finish the tag (FileLink(), PageLink(), or WebLink()!
   btList,          // L
   btListElem,      // LI    -> Correct nesting: btList/btListElem
   btListText,      // LBody -> Correct nesting: btList/btListElem/btListText
   btNote,
   btP,
   btPart,
   btQuote,
   btReference,
   btSection,       // Sect
   btSpan,
   btTable,
   btTableDataCell, // TD
   btTableHeader,   // TH
   btTableRow,      // TR
   btTOC,
   btTOCEntry,      // TOCI
   btCL,            // CL (Continued List)
   btLabel,         // Lbl
   btRuby,
   btWarichu,
   // PDF 2.0 tags:
   btAbbr,
   btCallout,
   btDek,
   btEm,
   btLineNum,
   btReason,
   btRedaction,
   btSidebar,
   btStrong,
   btSub,
   btSup
}TPDFBaseTag;

typedef enum TPDFDateTime
{
   dfMM_D            = 0,
   dfM_D_YY          = 1,
   dfMM_DD_YY        = 2,
   dfMM_YY           = 3,
   dfD_MMM           = 4,
   dfD_MMM_YY        = 5,
   dfDD_MMM_YY       = 6,
   dfYY_MM_DD        = 7,
   dfMMM_YY          = 8,
   dfMMMM_YY         = 9,
   dfMMM_D_YYYY      = 10,
   dfMMMM_D_YYYY     = 11,
   dfM_D_YY_H_MM_TT  = 12,
   dfM_D_YY_HH_MM    = 13,
   /* time formats */
   df24HR_MM         = 14,
   df12HR_MM         = 15,
   df24HR_MM_SS      = 16,
   df12HR_MM_SS      = 17
}TPDFDateTime;

typedef enum TPDFFontFlags
{
   pffFixedPitch  = 0x00000001,
   pffSerifs      = 0x00000002,
   pffSymbolic    = 0x00000004,
   pffScriptStyle = 0x00000008,
   pffReserved1   = 0x00000010,
   pffNonSymbolic = 0x00000020,
   pffItalic      = 0x00000040,
   pffAllCap      = 0x00010000,
   pffSmallCap    = 0x00020000,
   pffForceBold   = 0x00040000
}TPDFFontFlags;

typedef enum TPDFMarkedContentType
{
   mcBDC, // Begins a marked content sequence with a property list
   mcBMC, // Same as BDC but without a property list
   mcDP,  // Marked content point with a property list
   mcMP,  // Same as DP but without a property list
   mcOCG, // Begins an optional content sequence with an Optional Content Group (OCG), also called layer
   mcOCMD // Begins an optional content sequence with an Optional Content Membership Dictionary (this is a visibility expression)
}TPDFMarkedContentType;

typedef enum TPDFMarkInfo
{
   miNotTagged      = 0,
   miTagged         = 1,
   miSuspects       = 2,
   miUserProperties = 4
}TPDFMarkInfo;

typedef enum TPDFPrintFlags
{
   pffDefault             = 0x00000000, // Gray printing
   pff1Bit                = 0x00000001, // Black & White output
   pffColor               = 0x00000002, // Color output
   pffAutoRotateAndCenter = 0x00000004, // Rotate and center the page if necessary
   pffPrintAsImage        = 0x00000008, // Defined for future use
   pffShrinkToPrintArea   = 0x00000010, // Scale the page so that it fits into the printable area
   pffNoStartDoc          = 0x00000020, // If set, StartDoc() of the Windows print API will not be called
   pffNoStartPage         = 0x00000040, // If set, StartPage() of the Windows print API will not be called
   pffNoEndDoc            = 0x00000080, // If set, EndDoc() of the Windows print API will not be called
   pffPrintPageAsIs       = 0x00000100, // If set, do not scale or rotate a page to fit into the printable area
   pffAutoRotate          = 0x00000200, // Rotate the page if necessary
   pffAutoCenter          = 0x00000400  // Center the page
}TPDFPrintFlags;

struct TPDFPrintParams
{
   UI32               StructSize;   // Must be set to sizeof(TPDFPrintParams).
   LBOOL              Compress;     // Meaningful only for image output. If true, compressed images are send to the printer.
   TCompressionFilter FilterGray;   // Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   TCompressionFilter FilterColor;  // Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   UI32               JPEGQuality;  // JPEG Quality in percent. Zero == Default == 60.
   UI32               MaxRes;       // Maximum print resolution. Zero == Default == 600 DPI.
   LBOOL              IgnoreDCSize; // If true, PageSize is used to calculate the output format.
   struct TIntRect    PageSize;     // Considered only, if IgnoreDCSize is set to true.
};

typedef enum TPDFVersion
{
   pvPDF_1_0     = 0,
   pvPDF_1_1     = 1,
   pvPDF_1_2     = 2,
   pvPDF_1_3     = 3,
   pvPDF_1_4     = 4,
   pvPDF_1_5     = 5,
   pvPDF_1_6     = 6,
   pvPDF_1_7     = 7,
   pvPDF_2_0     = 8,  // PDF 2.0
   pvReserved    = 9,  // Reserved for future use
   pvPDFX1a_2001 = 10, // PDF/X-1a:2001
   pvPDFX1a_2003 = 11, // PDF/X-1a:2003
   pvPDFX3_2002  = 12, // PDF/X-3:2002
   pvPDFX3_2003  = 13, // PDF/X-3:2003
   pvPDFA_2005   = 14, // PDF/A-1b 2005
   pvPDFX_4      = 15, // PDF/X-4
   pvPDFA_1a     = 16, // PDF/A 1a 2005
   pvPDFA_2a     = 17, // PDF/A 2a
   pvPDFA_2b     = 18, // PDF/A 2b
   pvPDFA_2u     = 19, // PDF/A 2u
   pvPDFA_3a     = 20, // PDF/A 3a
   pvPDFA_3b     = 21, // PDF/A 3b
   pvPDFA_3u     = 22, // PDF/A 3u
   // The following constants are flags which can be combined with pvPDFA_3a, pvPDFA_3b, and pvPDFA_3u.
   // If used stand alone PDF/A 3b with the correspondig ZUGFeRD metadata will be created.
   // The embedded XML invoice must be named ZUGFeRD-invoice.xml. Note that every ZUGFeRD version uses
   // another name for the XML invoice!
   pvZUGFeRD_Basic     = 0x00010000,
   pvZUGFeRD_Comfort   = 0x00020000,
   pvZUGFeRD_Extended  = 0x00040000,
   pvZUGFeRD_Mask      = pvZUGFeRD_Basic | pvZUGFeRD_Comfort | pvZUGFeRD_Extended,
   // Factur-X / ZUGFeRD 2.1, and ZUGFeRD 2.0 profiles. The usage is identically in comparision to
   // the older ZUGFeRD 1.0 flags. That means if used alone, a PDF/A 3b file will be created.
   // ZUGFeRD 2.1 and Factur-X are identically defined in PDF. In order to create a ZUGFeRD 2.1 invoice,
   // set one of the Factur-X constants but don't set the flag pvZUGFeRD2_Flag.
   /* --------------------------------------------------------------------------------------------------------------
    *                                         Factur-X vs. ZUGFeRD 2.0
    *---------------------------------------------------------------------------------------------------------------
    * ZUGFeRD 2.0 and Factur-X are almost identically defined. Both standards support the very same profiles. To create
    * a ZUGFeRD 2.0 invoice with the profile Basic WL, for example, set the PDF version as follows:
    *
    *    pdfSetPDFVersion(pdf, TPDFVersion(pvFacturX_Basic_WL | pvZUGFeRD2_Flag));
    *
    * The PDF version is set to PDF/A 3b in the above example.
    *
    * If you want to create the very same invoice but as PDF/A 3u file, for example, then set also the whished output PDF
    * version:
    *
    *    pdfSetPDFVersion(pdf, TPDFVersion(pvPDFA_3u | pvFacturX_Basic_WL | pvZUGFeRD2_Flag));
    *
   */
   pvFacturX_Minimum   = 0x00080000, // Minimum profile  -> Factur-X and ZUGFeRD 2.1
   pvFacturX_Basic     = 0x00100000, // Basic profile    -> Factur-X and ZUGFeRD 2.1
   pvFacturX_Basic_WL  = 0x00200000, // Basic WL profile -> Factur-X and ZUGFeRD 2.1
   pvFacturX_Comfort   = 0x00400000, // EN 16931 profile -> Factur-X and ZUGFeRD 2.1
   pvFacturX_Extended  = 0x00800000, // Extended profile -> Factur-X and ZUGFeRD 2.1
   pvFacturX_XRechnung = 0x02000000, // German XRechnung profile. The XML invoice must be named xrechnung.xml.
   pvFacturX_Mask      = pvFacturX_Minimum | pvFacturX_Basic | pvFacturX_Basic_WL | pvFacturX_Comfort | pvFacturX_Extended | pvFacturX_XRechnung,
   pvZUGFeRD2_Flag     = 0x01000000, // If set, the PDF version will be set to the corresponding ZUGFeRD2 profile.
                                     // The embedded XML file must be named zugferd-invoice.xml.
   pvPDFX5g            = 23,         // PDF/X-5g
   pvPDFX5n            = 24,         // PDF/X-5n
   pvPDFX5pg           = 25,         // PDF/X-5pg
   pvPDFX6             = 26,         // PDF/X 6
   pvPDFX6n            = 27,         // PDF/X 6n
   pvPDFX6p            = 28,         // PDF/X 6p
   pvPDFUA1            = 29,         // PDF/UA-1 (ISO 14289-1)
   pvPDFX4p            = 30,         // PDF/X-4p
   pvPDFVT1            = 0x10000000, // PDF/VT 1 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVT2            = 0x04000000, // PDF/VT 2 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVT3            = 0x08000000, // PDF/VT 3 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVTMask         = pvPDFVT1 | pvPDFVT2 | pvPDFVT3,
   pvPDFUAFlag         = 0x20000000, // PDF/UA flag. Can be used in addition with other standards. File metadata will contain PDF/A and PDF/UA entries.
   pvPDFA_4            = 31,         // PDF/A 4
   pvPDFA_4e           = 32,         // PDF/A 4e allows 3D contents in rich media annotations.
   pvPDFA_4f           = 33          // PDF/A 4f allows file attach annotations.
}TPDFVersion;

// We have different members for PDF/A, PDF/E, PDF/VT, and PDF/X because multiple versions can be set at time.
// PDF/VT files require also PDF/X version information.
struct TPDFVersionInfo
{
   UI32        StructSize;      // Must be set to sizeof(TPDFVersionInfo)
   UI32        Major;           // PDF major version, e.g. 1
   UI32        Minor;           // PDF minor version, e.g. 7
   const char* MainVer;         // Set only if the file conforms to a specific PDF standard, e.g. "PDF/X 1a:2003", "PDF/A 3b", and so on.
   const char* SubVer;          // e.g. "ZUGFeRD 2.0", "Factur-X", and so on.
   // PDF/A
   const char* PDFAConformance; // e.g. A, B, E, F, U, or UA.
   UI32        PDFAVersion;     // If greater zero, this is a PDF/A file.
   // PDF/E
   const char* PDFEVersion;     // e.g. PDF/E-1
   // PDF/VT
   const char* PDFVTModDate;    // Modification date, e.g. 2016-05-07T15:42:23+01:00
   const char* PDFVTVersion;    // e.g. PDF/VT-2
   // PDF/X
   const char* PDFXConformance; // e.g. PDF/X-1a:2001 or PDF/X-1a:2003. PDF/X 3 and above do not set this key anymore.
   const char* PDFXVersion;     // e.g. PDF/X-1:2001, PDF/X-1:2003, and so on.
   // ZUGFeRD, Factur-X, XRechnung
   const char* FXConfLevel;     // ConformanceLevel
   const char* FXDocName;       // DocumentFileName
   const char* FXDocType;       // DocumentType
   const char* FXVersion;       // Version
   SI32        VersionConst;    // If >= 0 this is the TPDFVersion constant as integer. If the version is not supported by DynaPDF, this member is set to -1.
};

typedef enum TPrintScaling
{
   psAppDefault, // Default
   psNone
}TPrintScaling;

typedef enum TRawImageFlags
{
   rifByteAligned  = 0x1000,
   rifRGBData      = 0x2000,
   rifCMYKData     = 0x4000
}TRawImageFlags;

typedef enum TRenderingIntent
{
   riAbsoluteColorimetric = 0,
   riPerceptual           = 1,
   riRelativeColorimetric = 2,
   riSaturation           = 3,
   riNone                 = 4 // Internal
}TRenderingIntent;

typedef enum TReplaceImageFlags
{
   rifDefault         = 0, // Nothing special to do.
   rifDeleteAltImages = 1, // Delete all alternate images that are associated with this image if any.
   rifDeleteMetadata  = 2, // Delete the meta data that was associated with the image.
   rifDeleteOCG       = 4, // Delete the Optional Content Group if any. This changes the visibility state of the image. Normally the OCG should be left as is.
   rifDeleteSoftMask  = 8  // An image can contain a soft mask that acts as an alpha channel. This mask can be deleted or left as is.
                           // The mask will always be deleted if the new image contains a soft mask or an alpha channel.
}TReplaceImageFlags;

typedef enum TRubberStamp
{
   rsApproved,
   rsAsIs,
   rsConfidential,
   rsDepartmental,
   rsDraft,
   rsExperimental,
   rsExpired,
   rsFinal,
   rsForComment,
   rsForPublicRelease,
   rsNotApproved,
   rsNotForPublicRelease,
   rsSold,
   rsTopSecret,
   rsUserDefined
}TRubberStamp;

typedef enum TShadingType
{
   stUnknown            = 0, // cannot occur -> internal use
   stFunctionBased      = 1,
   stAxial              = 2,
   stRadial             = 3,
   stFreeFormGouraud    = 4,
   stLatticeFormGouraud = 5,
   stCoonsPatch         = 6,
   stTensorProduct      = 7
}TShadingType;

typedef enum TSoftMaskType
{
   smtAlpha,
   smtLuminosity
}TSoftMaskType;

typedef enum TSpoolConvFlags
{
   spcDefault            = 0,
   spcIgnorePaperFormat  = 1, // If set, the current page format is used as is for the entire spool file.
   spcDontAddMargins     = 2, // If set, the page format is calculated from the EMF files as is. The current page format is not used to calculate
                              // margins which are maybe required. Note that the parameters LeftMargin and TopMargin will still be considered.
   spcLoadSpoolFontsOnly = 4, // If set, only embedded fonts will be loaded. The EMF files must be converted with the flag mfIgnoreEmbFonts in this
                              // case. This flag can be useful if you want to use your own code to convert the EMF files of the spool file.
   spcFlushPages         = 8  // If set, the function writes every finish page directly to the output file to reduce the memory usage. This flag
                              // is meaningful only if the PDF file is not created in memory. Note also that it is not possible to access already
                              // flushed pages again with EditPage().
}TSpoolConvFlags;

typedef SI32 TSubmitFlags;
#define sfNone             0x00000000 // The default export format is FDF
#define sfExlude           0x00000001 // If set, the fields in a submit form action are excluded if any
#define sfInclNoValFields  0x00000002 // If set, fields without a value should be submitted.
#define sfHTML             0x00000004 // Meaningful if the flags sfPDF and sfXML are both clear. If set, submit the form in HTML format.
#define sfGetMethod        0x00000008 // If set, submit the form with a HTTP GET request instead of POST.
#define sfSubmCoords       0x00000010 // Meaningful only if sfHTML ist set. If set, submit the cursor coordinates of the mouse click.
#define sfXML              0x00000024 // If set, submit the form in XFDF format.
#define sfInclAppSaves     0x00000040 // Meaningful only if the flags sfHTML and sfXML are both clear. If set, the FDF file shall include all incremental updates of the underlying PDF document.
#define sfInclAnnots       0x00000080 // Meaningful only if the flags sfHTML and sfXML are both clear. If set, the FDF file shall include all markup annotations of the underlying PDF document.
#define sfPDF              0x00000100 // Submit the entire PDF file -> requires the full version of Adobe's Acrobat
#define sfCanonicalFormat  0x00000200 // If set, any submitted field values representing dates shall be converted to the standard format (see CreateSubmitAction/The Standard Date Format).
#define sfExlNonUserAnnots 0x00000400 // Meaningful only if the flags sfHTML and sfXML are both clear and if sfInclAnnots is set. If set, include only those markup annotations whose name match the current user.
#define sfExlFKey          0x00000800 // Meaningful only if the flags sfHTML and sfXML are both clear. If set, the submitted FDF will exclude the "F" entry (the PDF file that this FDF file was exported from).
#define sfEmbedForm        0x00002000 // PDF 1.5 embed the entire form into a file stream inside the FDF file -> requires the full version of Adobe's Acrobat

typedef enum TSVGFlags
{
   svfDefault = 0
}TSVGFlags;

typedef enum TTextAlign
{
   taLeft      = 0,
   taCenter    = 1,
   taRight     = 2,
   taJustify   = 3,
   taPlainText = 0x10000000, // If this flag is set alignment and command tags are interpreted as plain text.
                             // See WriteFText() in the help file for further information.
   taNotSet    = 4           // Internal -> Do not use this value!
}TTextAlign;

typedef enum TTextExtractionFlags
{
   tefDefault               = 0, // Create text lines in the original order.
   tefSortTextX             = 1, // Sort text records in x-direction.
   tefSortTextY             = 2, // Sort text records in y-direction.
   tefSortTextXY            = tefSortTextX | tefSortTextY,
   tefDeleteOverlappingText = 4, // Text extraction only.
   tefNoHeuristic           = 8  // If set, text is sorted on the x-axis as specified. If absent, a heuristic
                                 // is used to determine whether it is might be better to leave a line unsorted.
}TTextExtractionFlags;

typedef enum TTabOrder
{
   toRow       = 0,
   toColumn    = 1,
   toStructure = 2,
   toNone      = 3,
   toAnnots    = 4, // Annotation order -> PDF 1.7 Extension Level 3
   toFields    = 5  // Widget order (Form Fields) -> PDF 1.7 Extension Level 3
}TTabOrder;

typedef SI32 TViewerPreference;
#define vpUseNone                0x00000000
#define vpHideToolBar            0x00000001
#define vpHideMenuBar            0x00000002
#define vpHideWindowUI           0x00000004
#define vpFitWindow              0x00000008
#define vpCenterWindow           0x00000010
#define vpDisplayDocTitle        0x00000020
#define vpNonFullScrPageMode     0x00000040
#define vpDirection              0x00000080
#define vpViewArea               0x00000100
#define vpViewClip               0x00000200
#define vpPrintArea              0x00000400
#define vpPrintClip              0x00000800

typedef SI32 TViewPrefAddVal;
#define avNone                   0x00000000
#define avNonFullScrUseNone      0x00000001
#define avNonFullScrUseOutlines  0x00000002
#define avNonFullScrUseThumbs    0x00000004
#define avNonFullScrUseOC        0x00000400 // PDF 1.6
#define avDirectionL2R           0x00000008
#define avDirectionR2L           0x00000010
#define avViewPrintArtBox        0x00000020
#define avViewPrintBleedBox      0x00000040
#define avViewPrintCropBox       0x00000080
#define avViewPrintMediaBox      0x00000100
#define avViewPrintTrimBox       0x00000200

// Use these masks to determine which value is defined.
#define AV_NON_FULL_SRC_MASK     0x00000005
#define AV_DIRECTION_MASK        0x00000018
#define AV_VIEW_PRINT_MASK       0x000003E0

struct TPDFAnnotation
{
   TAnnotType      Type;
   LBOOL           Deleted;
   struct TPDFRect BBox;
   double          BorderWidth;
   UI32            BorderColor;
   TBorderStyle    BorderStyle;
   UI32            BackColor;
   UI32            Handle;
   char*           AuthorA;
   UI16*           AuthorW;
   char*           ContentA;
   UI16*           ContentW;
   char*           NameA;
   UI16*           NameW;
   char*           SubjectA;
   UI16*           SubjectW;
   UI32            PageNum;
   THighlightMode  HighlightMode;
};

struct TPDFAnnotationEx
{
   TAnnotType       Type;
   LBOOL            Deleted;
   struct TPDFRect  BBox;
   float            BorderWidth;
   UI32             BorderColor;
   TBorderStyle     BorderStyle;
   UI32             BackColor;
   UI32             Handle;
   char*            AuthorA;
   UI16*            AuthorW;
   char*            ContentA;
   UI16*            ContentW;
   char*            NameA;
   UI16*            NameW;
   char*            SubjectA;
   UI16*            SubjectW;
   UI32             PageNum;
   THighlightMode   HighlightMode;
   // Page link annotations only
   SI32             DestPage;
   struct TPDFRect  DestPos;
   TDestType        DestType;
   // File link or web link annotations
   char*            DestFile;
   // The Icon type depends on the annotation type. If the annotation type is atText the Icon
   // is of type TAnnotIcon. If the annotation type is atFileAttach then it is of type
   // TFileAttachIcon. If the annotation type is atStamp then the Icon is the stamp type (TRubberStamp).
   // For any other annotation type this value is not set (-1).
   SI32             Icon;
   char*            StampName;        // Set only if Icon == rsUserDefined.
   UI32             AnnotFlags;       // See TAnnotFlags for available flags.
   char*            CreateDate;       // Creation Date -> Optional.
   char*            ModDate;          // Modification Date -> Optional.
   LBOOL            Grouped;          // (Reply type) Meaningful only if Parent != -1 and Type != atPopUp. If true,
                                      // the annotation is part of an annotation group. Properties like Content, CreateDate,
                                      // ModDate, BackColor, Subject, and Open must be taken from the parent annotation.
   LBOOL            Open;             // Meaningful only for annotations which have a corresponding PopUp annotation.
   SI32             Parent;           // Parent annotation handle of a PopUp Annotation or the parent annotation if
                                      // this annotation represents a state of a base annotation. In this case,
                                      // the annotation type is always atText and only the following members should
                                      // be considered:
                                      //    State      // The current state
                                      //    StateModel // Marked, Review, and so on
                                      //    CreateDate // Creation Date
                                      //    ModDate    // Modification Date
                                      //    Author     // The user who has set the state
                                      //    Content    // Not displayed in Adobe's Acrobat...
                                      //    Subject    // Not displayed in Adobe's Acrobat...
                                      // The PopUp annotation of a text annotation which represent an Annotation State
                                      // must be ignored.
   SI32             PopUp;            // Handle of the corresponding PopUp annotation if any.
   char*            State;            // The state of the annotation.
   char*            StateModel;       // The state model (Marked, Review, and so on).
   SI32             EmbeddedFile;     // FileAttach annotations only. A handle of an embedded file -> GetEmbeddedFile().
   char*            Subtype;          // Set only, if Type == atUnknownAnnot.
   UI32             PageIndex;        // The page index is used to sort form fields. See SortFieldsByIndex().
   LBOOL            MarkupAnnot;      // If true, the annotation is a markup annotation. Markup annotations can be flattened.
                                      // separately, see FlattenAnnots().
   float            Opacity;          // Opacity = 1.0 = Opaque, Opacity < 1.0 = Transparent, Markup annotations only.
   float*           QuadPoints;       // Highlight, Squiggly, Line, Link, and Redact annotations.
   UI32             QuadPointsCount;  // Number of values in the array. Since a quadpoint requires always four coordinate
                                      // pairs, the number of QuadPoints is QuadPointsCount divided by 8.

   float*           DashPattern;      // Only present if BorderStyle == bsDashed.
   UI32             DashPatternCount; // Number of values in the array.

   char*            Intent;           // Markup annotations only. The intent allows to distinguish between different uses of an annotation.
                                      // For example, line annotations have two intents: LineArrow and LineDimension.
   TLineEndStyle    LE1;              // Line end style of the start point -> Line and PolyLine annotations only.
   TLineEndStyle    LE2;              // Line end style of the end point -> Line and PolyLine annotations only.
   float*           Vertices;         // Line, PolyLine, and Polygon annotations only.
   UI32             VerticesCount;    // Number of values in the array. This is the raw number of floating point values.
                                      // Since a vertice requires always two coordinate pairs, the number of vertices
                                      // or points is VerticeCount divided by 2.
   // Line annotations only. These properties should only be considered if the member Intent is set to the string LineDimension.
   LBOOL            Caption;          // If true, the annotation string Content is used as caption. The string is shown in a PopUp annotation otherwise.
   float            CaptionOffsetX;   // Horizontal offset of the caption from its normal position
   float            CaptionOffsetY;   // Vertical offset of the caption from its normal position
   TLineCaptionPos  CaptionPos;       // The position where the caption should be drawn if present
   float            LeaderLineLen;    // Length of the leader lines (positive or negative)
   float            LeaderLineExtend; // Optional leader line extend beyond the leader line (must be a positive value or zero)
   float            LeaderLineOffset; // Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)

   TBorderEffect    BorderEffect;     // Circle, Square, FreeText, and Polygon annotations.
   char*            RichStyle;        // Optional default style string.      -> FreeText annotations only.
   char*            RichText;         // Optional rich text string (RC key). -> Markup annotations only.

   const ILST**     InkList;          // Ink annotations only. Array of array. The sub arrays can be accessed with GetInkList().
   UI32             InkListCount;     // Number of ink arrays.
   SI32             OC;               // Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   struct TFltRect* RD;               // Caret, Circle, Square, and FreeText annotations.
   SI32             Rotate;           // Caret and FreeText annotations only. Must be zero or a multiple of 90.
};

// Structur to create a barcode field
struct TPDFBarcode
{
   UI32        StructSize;   // Must be set to sizeof(TPDFBarcode) before calling CreateBarcodeField()!
   const char* CaptionA;     // Optional, the ansi string takes precedence
   const UI16* CaptionW;     // Optional
   float       ECC;          // 0..8 for PDF417, or 0..3 for QRCode
   float       Height;       // Height in inches
   float       nCodeWordCol; // Required for PDF417. The number of codewords per barcode coloumn.
   float       nCodeWordRow; // Required for PDF417. The number of codewords per barcode row.
   UI32        Resolution;   // Required -> Should be 300
   const char* Symbology;    // PDF417, QRCode, or DataMatrix.
   float       Version;      // Should be 1
   float       Width;        // Width in inches
   float       XSymHeight;   // Only needed for PDF417. The vertical distance between two barcode modules,
                             // measured in pixels. The ratio XSymHeight/XSymWidth shall be an integer
                             // value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode
                             // and DataMatrix, this ratio shall always be 1.
   float       XSymWidth;    // Required -> The horizontal distance, in pixels, between two barcode modules.
};

typedef enum TPDFBarcodeType
{
   bctNotInitialized    = 0x0000, // No valid value
   bctAustraliaPost     = 0x003F, // Australia Post Standard Customer
   bctAustraliaRedir    = 0x0044, // Australia Post Redirection
   bctAustraliaReply    = 0x0042, // Australia Post Reply Paid
   bctAustraliaRout     = 0x0043, // Australia Post Routing
   bctAztec             = 0x005C, // Aztec Code
   bctAztecRunes        = 0x0080, // Aztec Runes
   bctC2Of5IATA         = 0x0004, // Code 2 of 5 IATA
   bctC2Of5Industrial   = 0x0007, // Code 2 of 5 Industrial
   bctC2Of5Interleaved  = 0x0003, // Interleaved 2 of 5
   bctC2Of5Logic        = 0x0006, // Code 2 of 5 Data Logic
   bctC2Of5Matrix       = 0x0002, // Standard Code 2 of 5
   bctChannelCode       = 0x008C, // Channel Code
   bctCodabar           = 0x0012, // Codabar
   bctCodablockF        = 0x004A, // Codablock-F
   bctCode11            = 0x0001, // Code 11
   bctCode128           = 0x0014, // Code 128 (automatic subset switching)
   bctCode128B          = 0x003C, // Code 128 (Subset B)
   bctCode16K           = 0x0017, // Code 16K
   bctCode32            = 0x0081, // Code 32
   bctCode39            = 0x0008, // Code 3 of 9 (Code 39)
   bctCode49            = 0x0018, // Code 49
   bctCode93            = 0x0019, // Code 93
   bctCodeOne           = 0x008D, // Code One
   bctDAFT              = 0x005D, // DAFT Code
   bctDataBarOmniTrunc  = 0x001D, // GS1 DataBar-14 Omnidirectional and truncated / RSS14
   bctDataBarExpStacked = 0x0051, // GS1 DataBar Expanded Stacked
   bctDataBarExpanded   = 0x001F, // GS1 DataBar Expanded / RSS_EXP
   bctDataBarLimited    = 0x001E, // GS1 DataBar Limited  / RSS_LTD
   bctDataBarStacked    = 0x004F, // GS1 DataBar-14 Stacked
   bctDataBarStackedO   = 0x0050, // GS1 DataBar-14 Stacked Omnidirectional
   bctDataMatrix        = 0x0047, // Data Matrix ECC200
   bctDotCode           = 0x0073, // DotCode
   bctDPD               = 0x0060, // DPD code
   bctDPIdentCode       = 0x0016, // Deutsche Post Identcode
   bctDPLeitcode        = 0x0015, // Deutsche Post Leitcode
   bctEAN128            = 0x0010, // GS1-128 (UCC.EAN-128)
   bctEAN128_CC         = 0x0083, // Composite Symbol with GS1-128 linear component
   bctEAN14             = 0x0048, // EAN-14
   bctEANX              = 0x000D, // EAN
   bctEANX_CC           = 0x0082, // Composite Symbol with EAN linear component
   bctEANXCheck         = 0x000E, // EAN + Check Digit
   bctExtCode39         = 0x0009, // Extended Code 3 of 9 (Code 39+)
   bctFIM               = 0x0031, // FIM
   bctFlattermarken     = 0x001C, // Flattermarken
   bctHIBC_Aztec        = 0x0070, // HIBC Aztec Code
   bctHIBC_CodablockF   = 0x006E, // HIBC Codablock-F
   bctHIBC_Code128      = 0x0062, // HIBC Code 128
   bctHIBC_Code39       = 0x0063, // HIBC Code 39
   bctHIBC_DataMatrix   = 0x0066, // HIBC Data Matrix ECC200
   bctHIBC_MicroPDF417  = 0x006C, // HIBC MicroPDF417
   bctHIBC_PDF417       = 0x006A, // HIBC PDF417
   bctHIBC_QR           = 0x0068, // HIBC QR Code
   bctISBNX             = 0x0045, // ISBN (EAN-13 with verification stage)
   bctITF14             = 0x0059, // ITF-14
   bctJapanPost         = 0x004C, // Japanese Postal Code
   bctKIX               = 0x005A, // Dutch Post KIX Code
   bctKoreaPost         = 0x004D, // Korea Post
   bctLOGMARS           = 0x0032, // LOGMARS
   bctMailmark          = 0x0079, // Royal Mail 4-State Mailmark
   bctMaxicode          = 0x0039, // Maxicode
   bctMicroPDF417       = 0x0054, // Micro PDF417
   bctMicroQR           = 0x0061, // Micro QR Code
   bctMSIPlessey        = 0x0047, // MSI Plessey
   bctNVE18             = 0x004B, // NVE-18
   bctPDF417            = 0x0037, // PDF417
   bctPDF417Truncated   = 0x0038, // PDF417 Truncated
   bctPharmaOneTrack    = 0x0033, // Pharmacode One-Track
   bctPharmaTwoTrack    = 0x0035, // Pharmacode Two-Track
   bctPLANET            = 0x0052, // PLANET
   bctPlessey           = 0x0056, // Plessey
   bctPostNet           = 0x0028, // PostNet
   bctPZN               = 0x0034, // PZN
   bctQRCode            = 0x003A, // QR Code
   bctRMQR              = 0x0091, // Rectangular Micro QR Code (rMQR)
   bctRoyalMail4State   = 0x0046, // Royal Mail 4 State (RM4SCC)
   bctRSS_EXP_CC        = 0x0086, // Composite Symbol with GS1 DataBar Extended component
   bctRSS_EXPSTACK_CC   = 0x008B, // Composite Symbol with GS1 DataBar Expanded Stacked component
   bctRSS_LTD_CC        = 0x0085, // Composite Symbol with GS1 DataBar Limited component
   bctRSS14_CC          = 0x0084, // Composite Symbol with GS1 DataBar-14 linear component
   bctRSS14Stacked_CC   = 0x0089, // Composite Symbol with GS1 DataBar-14 Stacked component
   bctRSS14StackOMNI_CC = 0x008A, // Composite Symbol with GS1 DataBar-14 Stacked Omnidirectional component
   bctTelepen           = 0x0020, // Telepen Alpha
   bctTelepenNumeric    = 0x0057, // Telepen Numeric
   bctUltracode         = 0x0090, // Ultracode
   bctUPCA              = 0x0022, // UPC A
   bctUPCA_CC           = 0x0087, // Composite Symbol with UPC A linear component
   bctUPCACheckDigit    = 0x0023, // UPC A + Check Digit
   bctUPCE              = 0x0025, // UCP E
   bctUPCE_CC           = 0x0088, // Composite Symbol with UPC E linear component
   bctUPCECheckDigit    = 0x0026, // UPC E + Check Digit
   bctUPNQR             = 0x008F, // UPNQR (Univerzalni Placilni Nalog QR)
   bctUSPSOneCode       = 0x0055, // USPS OneCode
   bctVIN               = 0x0049  // Vehicle Identification Number (America)
}TPDFBarcodeType;

typedef enum TPDFBarcodeDataType
{
   bcdtBinary     = 0, // Binary data.
   bcdtUnicode    = 1, // UTF-8.
   bcdtGS1Mode    = 2, // Encodes GS1 data using FNC1 characters.
   bcdtEscapeMode = 8  // Scan input data for escape sequences. This is a flag that can be combined
                       // with the other constants, e.g. TBarcodeDataType(bcdtUnicode | bcdtEscapeMode).
}TPDFBarcodeDataType;

// The following flags can be combined with a binary or operator, e.g. TBarcodeOptions(bcoNoASCII | bcoDottyMode).
typedef enum TPDFBarcodeOptions
{
   bcoDefault          = 0x00000000, // Use default settings.
   bcoNoASCII          = 0x00000001, // Consider non-ASCII characters when creating the barcode.
   bcoBind             = 0x00000002, // Boundary bars above and below the symbol and between rows if stacking multiple symbols.
   bcoBox              = 0x00000004, // Add a box surrounding the symbol and whitespace.
   bcoReaderInit       = 0x00000010, // Add a reader initialisation symbol to the data before encoding.
   bcoSmallText        = 0x00000020, // Use a smaller font for human readable text.
   bcoBoldText         = 0x00000040, // Embolden human readable text.
   bcoDottyMode        = 0x00000100, // Plot a matrix symbol using dots rather than squares.
   bcoGS1_GS_Separator = 0x00000200, // Use GS instead FNC1 as GS1 separator.
   bcoImageOutput      = 0x01000000, // Draw the barcode as an image. Images are usually larger than vectors and require more processing time.
   bcoUseActiveFont    = 0x02000000  // Vector output only. If set, text is output with the active font. Helvetica is used otherwise.
}TPDFBarcodeOptions;

// Structure to create a barcode on a page
struct TPDFBarcode2
{
   UI32                StructSize;  // Must be set to sizeof(TPDFBarcode2).
   TPDFBarcodeType     BarcodeType; // The type of barcode that should be created.
   UI32                BgColor;     // Background color -> Default NO_COLOR (transparent).
   UI32                BorderWidth; // Border width -> default 0.
   const char*         Data;        // Data buffer.
   TPDFBarcodeDataType DataType;    // Data type and escape flag.
   float               DotSize;     // Dotty mode only -> Default 4.0/5.0.
   SI32                Eci;         // Extended Channel Interpretation mode -> Default 0.
   UI32                FgColor;     // RGB Foreground color -> Default 0.
   float               FSizeFactor; // Font size correction factor -> Default 0.7. Considered in vector mode only.
   SI32                Option1;     // Various, depends on barcode type. See help file for further information. -> Default -1.
   SI32                Option2;     // Various, depends on barcode type. See help file for further information. -> Default 0.
   SI32                Option3;     // Various, depends on barcode type. See help file for further information. -> Default 0.
   TPDFBarcodeOptions  Options;     // Output options.
   SI32                Orientation; // Supported values: 0, 90, -90, 180, -180, 270, -270.
   const char*         Primary;     // Composite codes only. Primary data message (max 127 bytes).
   float               Scale;       // Default 1.0.
   LBOOL               ShowText;    // Show human readable text? Default true.
   UI32                SpaceWidth;  // Whitespace width in pixels -> Default 0 (auto).
   UI32                SymbHeight;  // Default 50.
   float               TextOffsetY; // Offset to correct the y-coordinate of human readable text -> Default 0.
   struct TFltRect     OuterBorder; // Optional border around the scaled barcode measured in user space.
};

struct TPDFBitmap
{
   UI32  StructSize; // Must be set to sizeof(TPDFBitmap)
   BYTE* Buffer;     // Image buffer
   UI32  BufSize;    // Buffer size in bytes
   SI32  DestX;      // Destination x-coordinate on the main image (the rendered page)
   SI32  DestY;      // Destination y-coordinate on the main image (the rendered page)
   UI32  Height;     // Image height in pixels
   SI32  Stride;     // Scanline length in bytes
   UI32  Width;      // Image width
};

struct TPDFChoiceValue
{
   UI32  StructSize; // Must be set to sizeof(TPDFChoiceValue)
   char* ExpValueA;
   UI16* ExpValueW;
   UI32  ExpValueLen;
   char* ValueA;
   UI16* ValueW;
   UI32  ValueLen;
   LBOOL Selected;
};

/*
   The structure contains several duplicate fields because CMap files contain usually a DSC comment
   section which provides Postscript specific initialization code. With exception of DSCResName the
   strings in the DSC section should not differ from their CMap counterparts. The Identity mapping
   of a character collection should contain the DSC comment "%%BeginResource: CMap (Identity)".
   Otherwise the string should be set to the CMap name.
*/
struct TPDFCMap
{
   UI32  StructSize;     // Must be set to sizeof(TPDFCMap) before calling GetCMap()!
   char* BaseCMap;       // If set, this base cmap is required when loading the cmap.
   UI32  CIDCount;       // 0 if not set.
   char* CMapName;       // The CMap name.
   UI32  CMapType;       // Should be 1!
   float CMapVersion;    // The CMap version.
   char* DSCBaseCMap;    // DSC comment.
   float DSCCMapVersion; // DSC comment.
   char* DSCResName;     // DSC comment. If the CMap uses an Identity mapping this string should be set to Identity.
   char* DSCTitle;       // DSC comment -> DSC CMap name + Registry + Ordering + Supplement, e.g. "GB-EUC-H Adobe GB1 0"
   char* FileNameA;      // The file name and CMap name should be identical!
   UI16* FileNameW;      // The file name and CMap name should be identical!
   char* FilePathA;      // The Ansi string is set if the Ansi version of SetCMapDir() was used.
   UI16* FilePathW;      // The Unicode string is set if the Unicode version of SetCMapDir() was used.
   char* Ordering;       // CIDSystemInfo -> The Character Collection, e.g. Japan1.
   char* Registry;       // CIDSystemInfo -> The registrant of the Character Collection is usually Adobe.
   UI32  Supplement;     // CIDSystemInfo -> The Supplement number should be supported in the used PDF Version.
   UI32  WritingMode;    // 0 == Horizontal, 1 == Vertical
};

typedef enum TPDFColSplitInfo
{
   spiNone,       // Do not display a splitter
   spiHorizontal, // Display a horizontal splitter
   spiVertical    // Display a vertical splitter
}TPDFColSplitInfo;

struct TPDFCollectionInfo
{
   UI32             StructSize; // Must be set to sizeof(TPDFColectionInfo)
   SI32             InitalFile; // Possible values are -2, -1, or a valid embedded files handle (a value greater or equal zero). See help file for further information.
   TColView         InitalView; // Determines how embedded files should be displayed.
   const char*      SortBy;     // Optional name of the first field that should be used to sort the list of embedded files.
   LBOOL            SortDesc;   // If true, the list of embedded files should be sorted in descending order.
   TPDFColSplitInfo SplitInfo;  // Determines whether a splitter bar should be displayed.
   float            SplitPos;   // Meaningful only, if SplitInfo is not spiNone. The initial position of the splitter bar,
                                // specified as a percentage of the available window area (0 to 100).
};

struct TPDFColorSpaceObj
{
   TExtColorSpace Type;
   TExtColorSpace Alternate;        // Alternate color space or base space of an Indexed or Pattern color space.
   void*          IAlternate;       // Only set if the color space contains an alternate or base color space -> GetColorSpaceObjEx().
   BYTE*          Buffer;           // Contains either an ICC profile or the color table of an Indexed color space.
   UI32           BufSize;          // Buffer length in bytes.
   float*         BlackPoint;       // CIE blackpoint. If set, the array contains exactly 3 values.
   float*         WhitePoint;       // CIE whitepoint. If set, the array contains exactly 3 values.
   float*         Gamma;            // If set, one value per component.
   float*         Range;            // min/max for each component or for the .a and .b components of a Lab color space.
   float*         Matrix;           // XYZ matrix. If set, the array contains exactly 9 values.
   UI32           NumInComponents;  // Number of input components.
   UI32           NumOutComponents; // Number of output components.
   UI32           NumColors;        // HiVal + 1 as specified in the color space. Indexed color space only.
   BYTE*          Colorants[32];    // UTF-8 Colorant names (Separation, DeviceN, and NChannel only).
   UI32           ColorantsCount;   // The number of colorants in the array.
   BYTE*          Metadata;         // Optional XMP metadata stream -> ICCBased only.
   UI32           MetadataSize;     // Metadata length in bytes.
   void*          IFunction;        // Pointer to function object -> Separation, DeviceN, and NChannel only.
   void*          IAttributes;      // Optional attributes of DeviceN or NChannel color spaces -> GetDeviceNAttributes().
   void*          IColorSpaceObj;   // Pointer of the corresponding color space object
   SI32           Handle;           // Handle of the color space object or -1 if an internal color space object was returned by ParceContent(), for example.
   void*          Reserved01;
   void*          Reserved02;
   void*          Reserved03;
   void*          Reserved04;
   void*          Reserved05;
   void*          Reserved06;
   void*          Reserved07;
   void*          Reserved08;
};

struct TDeviceNAttributes
{
   void* IProcessColorSpace;    // Pointer to process color space or NULL -> GetColorSpaceEx().
   BYTE* ProcessColorants[8];   // UTF-8 Process colorant names
   UI32  ProcessColorantsCount; // Number of process colorants in the array or zero if not set.
   void* Separations[32];       // Optional pointers to Separation color spaces -> GetColorSpaceEx().
   UI32  SeparationsCount;      // Number of color spaces in the array.
   void* IMixingHints;          // Optional mixing hints. There is no API function at this time to access mixing hints.
   void* Reserved01;
   void* Reserved02;
   void* Reserved03;
   void* Reserved04;
};

struct TPDFError
{
   UI32        StructSize; // Must be initialized to sizeof(TPDFError)
   const char* Message;    // The error message
   SI32        ObjNum;     // -1 if not available
   SI32        Offset;     // -1 if not available
   const char* SrcFile;    // Source file
   UI32        SrcLine;    // Source line
   SI32        ErrCode;    // ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
   SI32        ErrType;    // ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
};

// It is not possible to set all available graphic state parameters with DynaPDF, such as black generation functions,
// halftones and so on. The structure will be extended when further objects are supported.
struct TPDFExtGState
{
   UI32             AutoStrokeAdjust; // PDF_MAX_INT if not set
   TBlendMode       BlendMode;        // Default bmNotSet
   float            FlatnessTol;      // -1.0 if not set
   UI32             OverPrintFill;    // PDF_MAX_INT if not set
   UI32             OverPrintStroke;  // PDF_MAX_INT if not set
   UI32             OverPrintMode;    // PDF_MAX_INT if not set
   TRenderingIntent RenderingIntent;  // riNone if not set
   float            SmoothnessTol;    // -1.0 if not set
   float            FillAlpha;        // -1.0 if not set
   float            StrokeAlpha;      // -1.0 if not set
   UI32             AlphaIsShape;     // PDF_MAX_INT if not set
   UI32             TextKnockout;     // PDF_MAX_INT if not set
   LBOOL            SoftMaskNone;     // Disables the active soft mask
   PSMK*            SoftMask;         // Soft mask pointer or NULL. See CreateSoftMask() for further information.
   void*            Reserved1;
   void*            Reserved2;
   void*            Reserved3;
   void*            Reserved4;
   void*            Reserved5;
   void*            Reserved6;
   void*            Reserved7;
};

// Extended graphics state dictionary
struct TPDFExtGState2
{
   LBOOL            AlphaIsShape;       // PDF_MAX_INT if not set
   LBOOL            AutoStrokeAdjust;   // PDF_MAX_INT if not set
   void*            BlackGen;           // Function handle or NULL -> GetFunction()
   void*            BlackGen2;          // Function handle or NULL -> GetFunction()
   TBlendMode*      BlendMode;          // Array of blend modes
   UI32             BlendModeCount;     // Number of blend modes
   float            FillAlpha;          // -1.0 if not set
   float            FlatnessTol;        // -1.0 if not set
   void*            Halftone;           // Halftone handle or NULL -> GetHalftoneDict()
   LBOOL            OverPrintFill;      // PDF_MAX_INT if not set
   LBOOL            OverPrintStroke;    // PDF_MAX_INT if not set
   LBOOL            OverPrintMode;      // PDF_MAX_INT if not set
   TRenderingIntent RenderingIntent;    // riNone if not set
   float            SmoothnessTol;      // -1.0 if not set
   PSMK*            SoftMask;           // Soft mask handle or NULL
   float            StrokeAlpha;        // -1.0 if not set
   LBOOL            TextKnockout;       // PDF_MAX_INT if not set
   void*            TransferFunc;       // Array of functions -> GetFunction()
   UI32             TransferFuncCount;  // Number of transfer functions
   void*            TransferFunc2;      // Array of functions -> GetFunction()
   UI32             TransferFunc2Count; // Number of transfer functions
   void*            UnderColorRem;      // Function handle or NULL -> GetFunction()
   void*            UnderColorRem2;     // Function handle or NULL -> GetFunction()
   LBOOL            SoftMaskNone;       // If true, the softmask must be disabled
   void*            Reserved1;
   void*            Reserved2;
   void*            Reserved3;
};

struct TPDFField
{
   SI32   FieldType;
   LBOOL  Deleted;
   struct TPDFRect BBox;
   SI32   Handle;
   char*  FieldName;
/*
   The field name is normally an ANSI string. However, Adobe's Designer uses Unicode strings as field names.
   To determine whether the string is an ANSI or Unicode string proceed as follows:
   if (f.FieldNameLen > 0)
   {
      // The field name is always null-terminated so that this action is safe.
      if (f.FieldName && strlen(f.FieldName) != f.FieldNameLen)
      {
         // The field name is an Unicode string!
         fieldNameW = (UI16*)f.FieldName;
         ...
      }
   }
*/
   UI32   FieldNameLen;
   UI32   BackCS;
   UI32   TextCS;
   UI32   BackColor;
   UI32   BorderColor;
   UI32   TextColor;
   LBOOL  Checked;
   SI32   Parent;
   UI32   KidCount;
   char*  Font;
   double FontSize;
   void*  Value;
   LBOOL  UniVal;
   UI32   ValLen;
   void*  ToolTip;
   LBOOL  UniToolTip;
   UI32   ToolTipLen;
};

#define PDF_ANNOT_INDEX 0x40000000 // Special flag for GetPageFieldEx() to indicate that an annotation index
                                   // was passed to the function. See GetPageFieldEx() for further information.

struct TPDFFieldEx
{
   UI32            StructSize;    // Must be set to sizeof(TPDFFieldEx)
   LBOOL           Deleted;       // If true, the field was marked as deleted by DeleteField()
   struct TPDFRect BBox;          // Bounding box of the field in bottom-up coordinates
   TFieldType      FieldType;     // Field type
   TFieldType      GroupType;     // If GroupType != FieldType the field is a terminal field of a field group
   UI32            Handle;        // Field handle
   UI32            BackColor;     // Background color
   TExtColorSpace  BackColorSP;   // Color space of the background color
   UI32            BorderColor;   // Border color
   TExtColorSpace  BorderColorSP; // Color space of the border color
   TBorderStyle    BorderStyle;   // Border style
   float           BorderWidth;   // Border width
   float           CharSpacing;   // Text fields only
   LBOOL           Checked;       // Check boxes only
   UI32            CheckBoxChar;  // ZapfDingbats character that is used to display the on state
   TCheckBoxState  DefState;      // Check boxes only
   const char*     DefValueA;     // Optional default value
   const UI16*     DefValueW;     // Optional default value
   const PFNT*     IEditFont;     // Pointer to default editing font
   const char*     EditFont;      // Postscript name of the editing font
   UI32            ExpValCount;   // Combo and list boxes only. The values can be accessed with GetFieldExpValueEx()
   const char*     ExpValueA;     // Check boxes only
   const UI16*     ExpValueW;     // Check boxes only
   TFieldFlags     FieldFlags;    // Field flags
   const PFNT*     IFieldFont;    // Pointer to the font that is used by the field
   const char*     FieldFont;     // Postscript name of the font
   UI32            Reserved1;     // Reserved field to avoid alignment errors
   double          FontSize;      // Font size. 0.0 means auto font size
   const char*     FieldNameA;    // Note that children of a field group or radio button have no name
   const UI16*     FieldNameW;    // Note that children of a field group or radio button have no name
   THighlightMode  HighlightMode; // Highlight mode
   LBOOL           IsCalcField;   // If true, the OnCalc event of the field is connected with a JavaScript action
   const char*     MapNameA;      // Optional unique mapping name of the field
   const UI16*     MapNameW;      // Optional unique mapping name of the field
   UI32            MaxLen;        // Text fields only -> zero means not restricted
   const IFLD**    Kids;          // Array of child fields -> GetFieldEx2()
   UI32            KidCount;      // Number of fields in the array
   IFLD*           Parent;        // Pointer to parent field or NULL
   SI32            PageNum;       // Page on which the field is used or -1
   SI32            Rotate;        // Rotation angle in degrees
   TTextAlign      TextAlign;     // Text fields only
   UI32            TextColor;     // Text color
   TExtColorSpace  TextColorSP;   // Color space of the field's text
   float           TextScaling;   // Text fields only
   const char*     ToolTipA;      // Optional tool tip
   const UI16*     ToolTipW;      // Optional tool tip
   const char*     UniqueNameA;   // Optional unique name (NM key)
   const UI16*     UniqueNameW;   // Optional unique name (NM key)
   const char*     ValueA;        // Field value
   const UI16*     ValueW;        // Field value
   float           WordSpacing;   // Text fields only
   UI32            PageIndex;     // Array index to change the tab order, see SortFieldsByIndex().
   const PBCD*     IBarcode;      // If present, this field is a barcode field. The field type is set to ftText
                                  // since barcode fields are extended text fields. -> GetBarcodeDict().
   const PSIG*     ISignature;    // Signature fields only. Present only for imported signature fields which
                                  // have a value. That means the file was digitally signed. -> GetSigDict().
                                  // Signed signature fields are always marked as deleted!
   const char*     ModDate;       // Last modification date (optional)
   // Push buttons only. The down and roll over states are optional. If not present, then all states use the up state.
   // The handles of the up, down, and roll over states are template handles! The templates can be opened for editing
   // with EditTemplate2() and parsed with ParseContent().
   TBtnCaptionPos  CaptionPos;    // Where to position the caption relative to its image
   const char*     DownCaptionA;  // Caption of the down state
   const UI16*     DownCaptionW;  // Caption of the down state
   SI32            DownImage;     // Image of the down state
   const char*     RollCaptionA;  // Caption of the roll over state
   const UI16*     RollCaptionW;  // Caption of the roll over state
   SI32            RollImage;     // Image of the roll over state
   const char*     UpCaptionA;    // Caption of the up state
   const UI16*     UpCaptionW;    // Caption of the up state
   SI32            UpImage;       // Image of the up state -> if > -1, the button is an image button
   SI32            OC;            // Handle of an OCG or OCMD or -1 if not set. See help file for further information.
   SI32            Action;        // Action handle or -1 if not set. This action is executed when the field is activated.
   TActionType     ActionType;    // Meaningful only, if Action >= 0.
   IEVT*           Events;        // See GetObjEvent() if set.
   UI32            Reserved2;     // Reserved field to avoid alignment errors
   UI32            FmtTextColor;  // Zero if not set. Usually RGB red otherwise.
   const char*     FmtTextA;      // Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
   const UI16*     FmtTextW;      // Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
};

/*
   All strings are null-terminated (except the checksum). If a string is returned in Unicode
   format then make a typecast to (UI16*) to get the right value. Note that most values are
   optional, they can be NULL.
*/
struct TPDFFileSpec
{
   char* Buffer;      // Buffer of an embedded file
   UI32  BufSize;     // Buffer size in bytes.
   LBOOL Compressed;  // Should be false if Decompress was true in the GetEmbeddedFile() call, otherwise usually true.
                      // DynaPDF decompresses Flate encoded streams only. Other filters can occur but this is very unusual.
   void* ColItem;     // If != NULL the embedded file contains a collection item with user defined data. This entry can
                      // occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further information.
   char* Name;        // Name of the file specification in the name tree.
   LBOOL NameUnicode; // Is Name in Unicode format?
   char* FileName;    // File name as 7 bit ASCII string.
   LBOOL IsURL;       // If true, FileName contains a URL.
   char* UF;          // PDF 1.7. Same as FileName but Unicode is allowed.
   LBOOL UFUnicode;   // Is UF in Unicode format?
   char* Desc;        // Description
   LBOOL DescUnicode; // Is Desc in Unicode format?
   UI32  FileSize;    // Size of the decompressed stream or zero if not known. Note: this is either the Size key of
                      // the Params dictionary if present or the DL key in the file stream. Whether this value is
                      // correct depends on the file creator! The parameter is definitely correct if the file was
                      // decompressed.
   char* MIMEType;    // MIME media type name as defined in Internet RFC 2046.
   char* CreateDate;  // Creation date as string. See help file "The standard date format".
   char* ModDate;     // Modification date as string. See help file "The standard date format".
   char* CheckSum;    // 16 byte MD5 digest. Note that this is a binary string. It is exactly 16 bytes long if set!
};

struct TPDFEmbFileNode
{
   UI32                StructSize; // Must be set to sizeof(TPDFEmbFileNode).
   const char*         Name;       // UTF-8 encoded name. This key contains usually a 7 bit ASCII string.
   struct TPDFFileSpec EF;         // Embedded file.
   IEFN*               NextNode;   // Next node if any.
};

struct TPDFEncryptInfo
{
   UI32          StructSize;        // Must be set to sizeof(TPDFEncryptInfo)
   TKeyLen       Filter;            // Encryption filter
   LBOOL         HaveOpenPassword;  // If true, an open password was set.
   LBOOL         HaveOwnerPassword; // If true, an owner password was set. This should always be true!
   TRestrictions Restrictions;      // What must be restricted? This is a bit mask and the very same value that GetInEncryptionFlags() returns.
   LBOOL         UnsafeOpenPwd;     // If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
   LBOOL         UnsafeOwnerPwd;    // If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
};

struct TPDFFileSpecEx
{
   UI32        StructSize;     // Must be set to sizeof(TPDFFileSpecEx).
   const char* AFRelationship; // PDF 2.0
   const void* ColItem;        // If set, the embedded file contains a collection item with user defined data. This entry can
                               // occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further information.
   const char* DescriptionA;   // Optional description string.
   const UI16* DescriptionW;   // Optional description string.
   const char* DOS;            // Optional DOS file name.
   IEFN*       EmbFileNode;    // GetEmbeddedFileNode().
   const char* FileName;       // File name as 7 bit ASCII string.
   LBOOL       FileNameIsURL;  // If true, FileName contains a URL.
   const BYTE* ID1;            // Optional file ID. Meaningful only if FileName points to a PDF file.
   UI32        ID1Len;         // String length in bytes.
   const BYTE* ID2;            // Optional file ID. Meaningful only if FileName points to a PDF file.
   UI32        ID2Len;         // String length in bytes.
   LBOOL       IsVolatile;     // If true, the file changes frequently with time.
   const char* Mac;            // Optional Mac file name.
   const char* Unix;           // Optional Unix file name.
   IRFN*       RelFileNode;    // Optional related files array. -> GetRelFileNode().
   PIMG*       Thumb;          // Optional thumb nail image. -> GetImageObjEx().
   const char* UFileNameA;     // PDF 1.7. Same as FileName but Unicode is allowed.
   const UI16* UFileNameW;     // Either the Ansi or Unicode string is set but never both.
};

struct TPDFFontInfo
{
   UI32               StructSize;       // Must be set to sizeof(TPDFFontInfo).
   float              Ascent;           // Ascent (optional).
   float              AvgWidth;         // Average character width (optional).
   TBaseEncoding      BaseEncoding;     // Valid only if HaveEncoding is true.
   char*              BaseFont;         // PostScript or Family name.
   float              CapHeight;        // Cap height (optional).
   char*              CharSet;          // The charset describes which glyphs are present in the font.
   UI32               CharSetSize;      // Length of the CharSet in bytes.
   char*              CIDOrdering;      // SystemInfo -> A string that uniquely names the character collection within the specified registry.
   char*              CIDRegistry;      // SystemInfo -> Issuer of the character collection.
   BYTE*              CIDSet;           // CID fonts only. This is a table of bits indexed by CIDs.
   UI32               CIDSetSize;       // Length of the CIDSet in bytes.
   UI32               CIDSupplement;    // CIDSystemInfo -> The supplement number of the character collection.
   BYTE*              CIDToGIDMap;      // Allowed for embedded TrueType based CID fonts only.
   UI32               CIDToGIDMapSize;  // Length of the stream in bytes.
   BYTE*              CMapBuf;          // Only available if the CMap was embedded.
   UI32               CMapBufSize;      // Buffer size in bytes.
   char*              CMapName;         // CID fonts only (this is the encoding if the CMap is not embedded).
   float              Descent;          // Descent (optional).
   UI16*              Encoding;         // Unicode mapping 0..255 -> not available for CID fonts.
   UI32               FirstChar;        // First char (simple fonts only).
   UI32               Flags;            // The font flags describe various characteristics of the font. See TPDFFontFlags.
   struct TBBox       FontBBox;         // This is the size of the largest glyph in this font. The bounding box is important for text selection.
   BYTE*              FontBuffer;       // The font buffer is present if the font was embedded or if it was loaded from a file buffer.
   UI32               FontBufSize;      // Font file size in bytes.
   char*              FontFamilyA;      // Optional Font Family (Family Name, always available for system fonts).
   UI16*              FontFamilyW;      // Optional Font Family (either the Ansi or Unicode string is set, but never both).
   char*              FontFilePathA;    // Only available for system fonts.
   UI16*              FontFilePathW;    // Either the Ansi or Unicode path is set, but never both.
   TFontFileSubtype   FontFileType;     // See description in the help file for further information.
   char*              FontName;         // Font name (should be the same as BaseFont).
   char*              FontStretch;      // Optional -> UltraCondensed, ExtraCondensed, Condensed, and so on.
   TFontType          FontType;         // If ftType0 the font is a CID font. The Encoding is not set in this case.
   float              FontWeight;       // Font weight (optional).
   char*              FullNameA;        // System fonts only.
   UI16*              FullNameW;        // System fonts only (either the Ansi or Unicode string is set, but never both).
   LBOOL              HaveEncoding;     // If true, BaseEncoding was set from the font's encoding.
   float*             HorzWidths;       // Horizontal glyph widths -> 0..HorzWidthsCount -1.
   UI32               HorzWidthsCount;  // Number of horizontal widths in the array.
   LBOOL              Imported;         // If true, the font was imported from an external PDF file.
   float              ItalicAngle;      // Italic angle.
   char*              Lang;             // Optional language code defined by BCP 47.
   UI32               LastChar;         // Last char (simple fonts only).
   float              Leading;          // Leading (optional).
   UI32               Length1;          // Length of the clear text portion of a Type1 font.
   UI32               Length2;          // Length of the encrypted portion of a Type1 font program (Type1 fonts only).
   UI32               Length3;          // Length of the fixed-content portion of a Type1 font program or zero if not present.
   float              MaxWidth;         // Maximum glyph width (optional).
   BYTE*              Metadata;         // Optional XMP stream that contains metadata about the font file.
   UI32               MetadataSize;     // Buffer size in bytes.
   float              MisWidth;         // Missing width (default = 0.0).
   BYTE*              Panose;           // CID fonts only -> Optional 12 bytes long Panose string as described in Microsofts TrueType 1.0 Font Files Technical Specification.
   char*              PostScriptNameA;  // System fonts only.
   UI16*              PostScriptNameW;  // System fonts only (either the Ansi or Unicode string is set, but never both).
   float              SpaceWidth;       // Space width in font units. A default value is set if the font contains no space character.
   float              StemH;            // The thickness, measured vertically, of the dominant horizontal stems of glyphs in the font.
   float              StemV;            // The thickness, measured horizontally, of the dominant vertical stems of glyphs in the font.
   BYTE*              ToUnicode;        // Only available for imported fonts. This is an embedded CMap that translates PDF strings to Unicode.
   UI32               ToUnicodeSize;    // Buffer size in bytes.
   struct TFltPoint   VertDefPos;       // Default vertical displacement vector.
   struct TCIDMetric* VertWidths;       // Vertical glyph widths -> 0..VertWidthsCount -1.
   UI32               VertWidthsCount;  // Number of vertical widths in the array.
   UI32               WMode;            // Writing Mode -> 0 == Horizontal, 1 == Vertical.
   float              XHeight;          // The height of lowercase letters (like the letter x), measured from the baseline, in fonts that have Latin characters.
   const UI16*        BaseFontW;        // BaseFont converted to Unicode. This is the font name that Adobe's Acrobat displays in the font overview.
};

struct TPDFFontMetrics
{
   UI32         StructSize;     // Must be set to sizeof(TPDFFontMetrics)
   float        Ascent;         // Ascent (usWinAscent)
   float        AvgWidth;       // Average character width
   float        CapHeight;      // Cap height
   float        DefWidth;       // Default width
   float        Descent;        // sTypoDescender of the OS/2 table of TrueType and OpenType fonts
   UI32         FirstChar;      // First char
   float        FixedWidth;     // Width of all glyphs in a fixed pitch font
   TFStyle      FontStyle;      // Font style with which the font was loaded
   struct TBBox FontBBox;       // Font's bounding box
   LBOOL        IsFixedPitch;   // Is this a fixed pitch font?
   LBOOL        IsSymbolFont;   // Is this is a symbolic font?
   LBOOL        IsStdFont;      // Is this is a standard font?
   float        ItalicAngle;    // Italic angle of italic fonts
   UI32         LastChar;       // Last char
   float        LineGap;        // sTypoLineGap of the OS/2 table of TrueType and OpenType fonts
   UI32         MacStyle;       // macOS style flags
   TFStyle      RealStyle;      // This is the real style of the font (bold and italic styles are maybe emulated)
   float        StemV;          // Width of vertical stems
   float        StrikeoutPos;   // Strikeout position
   float        StrikeoutWidth; // Width of the strikeout line
   float        UnderlinePos;   // Underline position
   float        UnderlineWidth; // Width of the underline
   UI32         UnicodeRange1;  // Bitset -> TUnicodeRange1
   UI32         UnicodeRange2;  // Bitset -> TUnicodeRange2
   UI32         UnicodeRange3;  // Bitset -> TUnicodeRange3
   UI32         UnicodeRange4;  // Bitset -> TUnicodeRange4
   UI32         Weight;         // Font weight
   UI32         WidthClass;     // Width class of the font
   float        WinDescent;     // usWinDescent of the OS/2 table of TrueType and OpenType fonts
   UI32         WinStyle;       // fsSelection of the OS/2 table of TrueType and OpenType fonts
   float        XHeight;        // X-height
   float        TypoAscender;   // sTypoAscender of the OS/2 table of TrueType and OpenType fonts
   float        TypoLeading;    // Typographic leading or line height of the font. This is TypoAscender - Descent + LineGap.
                                // If typographic metrics are not available then TypoAscender is set to Ascent.
};

struct TPDFFontObj
{
   float            Ascent;        // Ascent
   char*            BaseFont;      // PostScript Name or Family Name
   float            CapHeight;     // Cap height
   float            Descent;       // Descent
   UI16*            Encoding;      // Unicode mapping 0..255 -> not set if a CID font is selected
   UI32             FirstChar;     // First char
   UI32             Flags;         // Font flags -> see TPDFFontFlags
   char*            FontFamily;    // Optional Font Family (Family Name)
   LBOOL            FontFamilyUni; // Is FontFamily in Unicode format?
   char*            FontName;      // Font name -> font descriptor
   TFontType        FontType;      // If ftType0 the font is a CID font. The Encoding is not set in this case.
   float            ItalicAngle;   // Italic angle
   UI32             LastChar;      // Last char
   float            SpaceWidth;    // Space width in font units. A default value is set if the font contains no space character.
   float*           Widths;        // Glyph widths -> 0..WidthsCount -1
   UI32             WidthsCount;   // Number of widths in the array
   float            XHeight;       // x-height
   float            DefWidth;      // Default character width -> CID fonts only
   char*            FontFile;      // Font file buffer -> only imported fonts are returned.
   UI32             Length1;       // Length of the clear text portion of the Type1 font, or the length of the entire font program if FontType != ffType1.
   UI32             Length2;       // Length of the encrypted portion of the Type1 font program (Type1 fonts only).
   UI32             Length3;       // Length of the fixed-content portion of the Type1 font program or zero if not present.
   TFontFileSubtype FontFileType;  // See description in the help file for further information.
};

struct TFRect
{
   SI16 MinX;
   SI16 MinY;
   SI16 MaxX;
   SI16 MaxY;
};

struct TPDFGlyphOutline
{
   float             AdvanceX;
   float             AdvanceY;
   float             OriginX;
   float             OriginY;
   SI16              Lsb;
   SI16              Tsb;
   LBOOL             HaveBBox;
   struct TFRect     BBox;
   struct TI32Point* Outline;
   UI32              Size;
};

struct TPDFGoToAction
{
   UI32        StructSize;     // Must be set to sizeof(TPDFGoToAction).
   SI32        DestPage;       // Destination page (the first page is denoted by 1).
   float*      DestPos;        // Destination position -> Array of 4 floating point values if set.
   TDestType   DestType;       // Destination type.
   // GoToR (GoTo Remote) actions only:
   IFSR*       DestFile;       // see GetFileSpec().
   const char* DestNameA;      // Optional named destination that shall be loaded when opening the file.
   const UI16* DestNameW;      // Either the Ansi or Unicode string is set but never both.
   SI32        NewWindow;      // Meaningful only if the destination file points to a PDF file.
                               // -1 = viewer default, 0 = false, 1 = true.
   SI32        NextAction;     // -1 or next action handle to be executed if any.
   TActionType NextActionType; // Only set if NextAction is >= 0.
};

/* Every header or footer string supports the following numbering and date formats:
 *
 * Bates numbering syntax: Bates#0..10#1..2147483648 (case-sensitive). The number sign (#) is part of the syntax and is required.
 * No spaces before or after the number sign or before and after the keyword 'Bates' are allowed.
 *
 * <<Bates#6#1>>  // Six digits, numbering starts at 1 -> 000001.
 * <<Bates#10#5>> // Ten digits, numbering starts at 5 -> 0000000005.
 * << Bates#6#1>> // Wrong, no space is not allowed.
 * <<bates#6#1>>  // Wrong, the correct keyword name is 'Bates'.
 *
 * Date formats:
 *
 * The date format supports three characters: m = month, d = day, y = year.
 * Each character can be repeated to define the number of digits, e.g. mm, or yyyy are examples. Allowed delimiters are '.', '-', and '/'.
 *
 * <<yy/mm/d>>    // Ok
 * <<mm-d/yy>>    // Unusual but ok
 * <y/mm/d>>      // Wrong, missing '<' and a valid year format has either 2 or 4 digits
 * <<yyyy:mm:dd>> // Wrong, invalid delimiter
 *
 * Page numbering:
 *
 * The page number format has two reserved characters:
 *
 *  * 0..2147483648 -> The number is added to the current page index (the first page is denoted by 0). Default = 1.
 *  * 'n'           -> Is replaced by the number of pages. The 'n' must be surrounded by an escape character, otherwise it is treated as text.
 *  * Escapes chars -> ' ', ')', '(', '[', ']', '<', '>', '/', '%', '{', '}'.
 *
 * Arbitrary text can occur before, between, and after a reserved character.
 * Example results on the first page if the document has 57 pages:
 *
 * <<28>>              // Ok, 28 is added to the page index.                              -> "28"
 * << Page 4 of n>>    // Ok                                                              -> " Page 4 of 57"
 * <<1/n>>             // Ok                                                              -> "1/57"
 * <<0/n>>             // Ok, but unusual. The first page number would be 0 in this case. -> "0/57"
 * <<-5 of n>>         // Ok, note that the minus is treated as text!                     -> "-5 of 57"
 * <<Page1 ofn pages>> // Ok, but the 'n' is treated as text.                             -> "Page1 ofn pages"
 * <<Page 5 of n>>     // Ok, 5 is added to the page index.                               -> "Page 5 of 57".
 * <<Seite 1 von n>>   // Ok, note which 'n' is replaced by the number of pages.          -> "Seite 1 von 57"
 * <<Page>>            // Wrong, nothing to do. Treated as text.                          -> "<<Page>>"
 */

struct TPDFHdrFtr
{
   UI32           Color;      // Text color.
   TExtColorSpace CS;         // Color space -> default = esInitSpace.
   SI32           CSHandle;   // Optional color space handle if CS is set to a non-device space.
   TCodepage      Codepage;   // The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   LBOOL          Embed;      // If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   SI32           Reserved1;  // Placeholder to avoid alignment issues
   const char*    FontA;      // Optional font name.
   const UI16*    FontW;      // Optional font name.
   float          FontSize;   // Font size -> considered only if a font name is set.
   SI32           Reserved2;  // Placeholder to avoid alignment issues
   const char*    FontType;   // Optional font type ("TrueType", "OpenType", or "Type1").
   LBOOL          IsHeader;   // If true, the record is treated as header.
   TTextAlign     Position;   // Valid values are taLeft, taCenter, and taRight.
   float          ShiftX;     // Positive values move the text to the right, negative to the left.
   float          ShiftY;     // Positive values move the text up or down depending on the used coordinate system (top down or bottom up). Negative values move the text into the opposite direction.
   const char*    TextA;      // The text that should be output. Either the Ansi or Unicode string must be set.
   const UI16*    TextW;      // The text that should be output. Either the Ansi or Unicode string must be set.
   UI32           TextLen;    // Text length in characters.
   SI32           Reserved3;  // Placeholder to avoid alignment issues
};

typedef enum TPDFHdrFtrFlags
{
   hffNone       = 0,  // This constant is used internally, do not use it. Nothing can be output if the flags hffEvenPages and hffOddPages are both absent.
   hffDefault    = 3,  // Output header / footer text on even and odd pages.
   hffEvenPages  = 1,  // Output header / footer text on even pages.
   hffOddPages   = 2,  // Output header / footer text on odd pages.
   hffFixedPrint = 4,  // Can be set by LoadHeaderFooterSettings(). Not considered yet.
   hffLoadUTF8   = 8,  // Load all strings in UTF-8 format.
   hffShrink     = 16, // Can be set by LoadHeaderFooterSettings(). Not considered yet.
   hffLoadBatesN = 32, // Force to load bates number settings. See LoadHeaderFooterSetting() for further information.
   hffLoadHF     = 64, // Force to load regular header / footer settings. See LoadHeaderFooterSetting() for further information.
   hffSearchRun  = 128 // Scan the file for available header / footer types. See LoadHeaderFooterSetting() for further information.
}TPDFHdrFtrFlags;

struct TPDFHeaderFooter
{
   UI32            StructSize;      // Must be set to sizeof(TPDFHeaderFooter).
   SI32            FirstPage;       // In/Out -> The first output page.
   TPDFHdrFtrFlags Flags;           // In/Out -> Additional processing flags.
   UI32            InitColor;       // In/Out -> Initial text color.
   TExtColorSpace  InitCS;          // In/Out -> Initial color space -> default = esDeviceRGB.
   SI32            InitCSHandle;    // In     -> Optional color space handle if InitCS is set to a non-device space.
   const char*     InitDate;        // Out    -> Initial date format.
   TCodepage       InitCodepage;    // In/Out -> The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   LBOOL           InitEmbed;       // In     -> If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   const char*     InitFontA;       // In/Out -> Optional font name.
   const UI16*     InitFontW;       // In/Out -> Optional font name.
   float           InitFontSize;    // In/Out -> Optional font size. Considered only if a font name is set.
   SI32            Reserved;        // Placeholder to avoid alignment issues
   const char*     InitFontType;    // Out    -> Optional font type ("TrueType", "OpenType", or "Type1").
   const char*     InitPageFormatA; // Out    -> Initial page format string.
   const UI16*     InitPageFormatW; // Out    -> Initial page format string.
   SI32            LastPage;        // In/Out -> The last output page.
   struct TFltRect Margin;          // In/Out -> Margin to output the header/footer text.
};

struct TPDFHideAction
{
   UI32         StructSize;     // Must be set to sizeof(TPDFHideAction).
   const IFLD** Fields;         // Array of field pointers -> GetFieldEx2().
   UI32         FieldsCount;    // Number of fields in the array.
   LBOOL        Hide;           // A flag indicating whether to hide or show the fields in the array.
   SI32         NextAction;     // -1 or next action handle to be executed if any.
   TActionType  NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFImage
{
   BYTE*            Buffer;           // Each scanline is aligned to a full byte.
   UI32             BufSize;          // The size of the image buffer in bytes.
   TDecodeFilter    Filter;           // Required decode filter if the image is compressed.
                                      // Possible values are dfDCTDecode (JPEG), dfJPXDecode (JPEG2000),
                                      // and dfJBIG2Decode. Other filters are already removed by DynaPDF since
                                      // a conversion to a native file format is then always required.
   TDecodeFilter    OrgFilter;        // The image was compressed with this filter in the PDF file. This info is
                                      // useful to determine which compression filter should be used when creating
                                      // a new image file from the image buffer.
   BYTE*            JBIG2Globals;     // Optional global page 0 segment (dfJBIG2Decode filter only).
   UI32             JBIG2GlobalsSize; // The size of the bit stream in bytes.
   UI32             BitsPerPixel;     // Bit depth of the image buffer. Possible values are 1, 2, 4, 8, 24, 32, and 64.
   TExtColorSpace   ColorSpace;       // The color space refers either to the image buffer or to the color table if set.
                                      // Note that 1 bit images can occur with and without a color table.
   UI32             NumComponents;    // The number of components stored in the image buffer.
   LBOOL            MinIsWhite;       // If true, the colors of 1 bit images are reversed.
   const void*      IColorSpaceObj;   // Pointer to the original color space.
   BYTE*            ColorTable;       // The color table or NULL.
   UI32             ColorCount;       // The number of colors in the color table.
   UI32             Width;            // Image width in pixel.
   UI32             Height;           // Image height in pixel.
   UI32             ScanLineLength;   // The length of a scanline in bytes.
   LBOOL            InlineImage;      // If true, the image is an inline image.
   LBOOL            Interpolate;      // If true, image interpolation should be performed.
   LBOOL            Transparent;      // The meaning is different depending on the bit depth and whether a color
                                      // table is available. If the image is a 1 bit image and if no color table is available,
                                      // black pixels must be drawn with the current fill color.
                                      // If the image contains a color table, ColorMask contains the range of indexes
                                      // in the form min/max index which should appear transparent. If no color table is
                                      // present ColorMask contains the transparent ranges in the form min/max for
                                      // every color component.
   BYTE*            ColorMask;        // The array contains ranges in the form min/max (2 values per component) for each
                                      // component before decoding.
   const PIMG*      IMaskImage;       // If set, a 1 bit image is used as a transparency mask. Call GetImageObjEx() to decode the image.
   const PIMG*      ISoftMask;        // If set, a grayscale image is used as alpha channel. Call GetImageObjEx() to decode the image.
   float*           Decode;           // If set, samples must be decoded. The array contains 2 * NumComponents values.
                                      // The decode array is never set if the image is returned decompressed since
                                      // it is already applied during decompression.
   TRenderingIntent Intent;           // Default riNone.
   UI32             SMaskInData;      // JPXDecode only, PDF_MAX_INT if not set. See PDF Reference for further information.
   const IOCG*      OC;               // Pointer of an OCG or OCMD if set. -> See GetOCHandle()
   BYTE*            Metadata;         // Optional XML Metadata stream.
   UI32             MetadataSize;     // Length of Metadata in bytes.
   const PIMG*      ObjectPtr;        // Internal pointer to the image class.
   float            ResolutionX;      // Image resolution on the x-axis.
   float            ResolutionY;      // Image resolution on the y-axis.
   IMSR*            Measure;          // Optional measure dictionary -> GetMeasureObj().
   IPTD*            PtData;           // Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
   /*
      The parallelogram into which the image is drawn.
      p1--p2
      |   |
      p4--p3
   */
   float            DestX1;           // 0
   float            DestY1;           // 0
   float            DestX2;           // 1
   float            DestY2;           // 0
   float            DestX3;           // 1
   float            DestY3;           // 1
   float            DestX4;           // 0
   float            DestY4;           // 1
   float            DestWidth;        // Destination width (can be negative).
   float            DestHeight;       // Destination height (can be negative).
   UI32             FillColor;        // The current fill color. An image mask is drawn with the current fill color.
   TPDFColorSpace   FillColorSpace;   // The color space in which FillColor is defined.
   // Reserved fields for future extensions
   UI32 Reserved1;
   UI32 Reserved2;
   UI32 Reserved3;
   UI32 Reserved4;
};

struct TPDFImportDataAction
{
   UI32                  StructSize;     // Must be set to sizeof(TPDFImportDataAction).
   struct TPDFFileSpecEx Data;           // The data or file to be loaded.
   SI32                  NextAction;     // -1 or next action handle to be executed if any
   TActionType           NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFJavaScriptAction
{
   UI32        StructSize;     // Must be set to sizeof(TPDFJavaScriptAction).
   const char* ScriptA;        // The script.
   const UI16* ScriptW;        // Either the Ansi or Unicode string is set but never both.
   UI32        ScriptLen;      // Script length in characters, not bytes!
   SI32        NextAction;     // -1 or next action handle to be executed if any.
   TActionType NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFLaunchAction
{
   UI32        StructSize;     // Must be set to sizeof(TPDFLaunchAction).
   const char* AppName;        // Optional. The name of the application that should be launched.
   const char* DefDir;         // Optional default directory.
   IFSR*       File;           // see GetFileSpec().
   SI32        NewWindow;      // -1 = viewer default, 0 = false, 1 = true.
   SI32        NextAction;     // -1 or next action handle to be executed if any.
   TActionType NextActionType; // Only set if NextAction is >= 0.
   const char* Operation;      // Optional string specifying the operation to perform (open or print).
   const char* Parameter;      // Optional parameter string that shall be passed to the application (AppName).
};

struct TLineAnnotParms
{
   UI32            StructSize;       // Must be set to sizeof(TLineAnnotParms)
   LBOOL           Caption;          // If true, the annotation string Content is used as caption.
   float           CaptionOffsetX;   // Horizontal offset of the caption from its normal position
   float           CaptionOffsetY;   // Vertical offset of the caption from its normal position
   TLineCaptionPos CaptionPos;       // The position where the caption should be drawn if present
   float           LeaderLineLen;    // Length of the leader lines (positive or negative)
   float           LeaderLineExtend; // Optional leader line extend beyond the leader line (must be a positive value or zero)
   float           LeaderLineOffset; // Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)
};

struct TPDFMeasure
{
   UI32        StructSize;    // Must be set to sizeof(TPDFMeasure)
   LBOOL       IsRectilinear; // If true, the members of the rectilinear measure dictionary are set. The geospatial members otherwise.
   /* --- Rectilinear measure dictionary --- */
   INFM**      Angles;        // Number format array to measure angles -> GetNumberFormatObj()
   UI32        AnglesCount;   // Number of objects in the array.
   INFM**      Area;          // Number format array to measure areas -> GetNumberFormatObj()
   UI32        AreaCount;     // Number of objects in the array.
   float       CXY;           // Optional, meaningful only when Y is present.
   INFM**      Distance;      // Number format array to measure distances -> GetNumberFormatObj()
   UI32        DistanceCount; // Number of objects in the array.
   float       OriginX;       // Origin of the measurement coordinate system.
   float       OriginY;       // Origin of the measurement coordinate system.
   const char* RA;            // A text string expressing the scale ratio of the drawing.
   const UI16* RW;            // A text string expressing the scale ratio of the drawing.
   INFM**      Slope;         // Number format array for measurement of the slope of a line -> GetNumberFormatObj()
   UI32        SlopeCount;    // Number of objects in the array.
   INFM**      X;             // Number format array for measurement of change along the x-axis and, if Y is not present, along the y-axis as well.
   UI32        XCount;        // Number of objects in the array.
   INFM**      Y;             // Number format array for measurement of change along the y-axis.
   UI32        YCount;        // Number of objects in the array.

   /* --- Geospatial measure dictionary --- */
   double*     Bounds;        // Array of numbers taken pairwise to describe the bounds for which geospatial transforms are valid.
   UI32        BoundCount;    // Number of values in the array. Should be a multiple of two.

   // The DCS coordinate system is optional.
   LBOOL       DCS_IsSet;     // If true, the DCS members are set.
   LBOOL       DCS_Projected; // If true, the DCS values contain a pojected coordinate system.
   SI32        DCS_EPSG;      // Optional, either EPSG or WKT is set.
   const char* DCS_WKT;       // Optional ASCII string.

   // The GCS coordinate system is required and should be present.
   LBOOL       GCS_Projected; // If true, the GCS values contains a pojected coordinate system.
   SI32        GCS_EPSG;      // Optional, either EPSG or WKT is set.
   const char* GCS_WKT;       // Optional ASCII string.

   double*     GPTS;          // Required, an array of numbers that shall be taken pairwise, defining points in geographic space as degrees of latitude and longitude, respectively.
   UI32        GPTSCount;     // Number of values in the array.
   double*     LPTS;          // Optional, an array of numbers that shall be taken pairwise to define points in a 2D unit square.
   UI32        LPTSCount;     // Number of values in the array.

   const char* PDU1;          // Optional preferred linear display units.
   const char* PDU2;          // Optional preferred area display units.
   const char* PDU3;          // Optional preferred angular display units.
};

struct TPDFMovieAction
{
   UI32         StructSize;     // Must be set to sizeof(TPDFMovieAction).
   SI32         Annot;          // Optional. The movie annotation handle identifying the movie that shall be played.
   float        FWPosition[2];  // FWPosition
   UI32         FWScale[2];     // FWScale
   const char*  Mode;           // Mode
   SI32         NextAction;     // -1 or next action handle to be executed if any
   TActionType  NextActionType; // Only set if NextAction is >= 0.
   const char*  Operation;      // Operation
   float        Rate;           // Rate
   LBOOL        ShowControls;   // ShowControls
   LBOOL        Synchronous;    // Synchronous
   const char*  TitleA;         // The title of a movie annotation that shall be played. Either Annot or Title should be set, but not both.
   const UI16*  TitleW;         // Either the Ansi or Unicode string is set at time.
   float        Volume;         // Volume
};

struct TPDFNamedAction
{
   UI32         StructSize;     // Must be set to sizeof(TPDFNamedAction).
   const char*  Name;           // Only set if Type == naUserDefined.
   SI32         NewWindow;      // -1 = viewer default, 0 = false, 1 = true.
   SI32         NextAction;     // -1 or next action handle to be executed if any.
   TActionType  NextActionType; // Only set if NextAction is >= 0.
   TNamedAction Type;           // Known pre-defined actions.
};

struct TPDFNamedDest
{
   UI32            StructSize; // Must be initialized to sizeof(TPDFNamedDest)
   const char*     NameA;
   const UI16*     NameW;
   UI32            NameLen;
   const char*     DestFileA;
   const UI16*     DestFileW;
   UI32            DestFileLen;
   SI32            DestPage;
   struct TPDFRect DestPos;
   TDestType       DestType;
   SI32            Reserved;   // Reserved field to avoid alignment issues
};

struct TPDFNumberFormat
{
   UI32              StructSize; // Must be set to sizeof(TPDFNumberFormat).
   float             C;          // The conversion factor used to multiply a value in partial units
   SI32              D;          // A positive integer that shall specify the precision or denominator of a fractional amount.
   TMeasureNumFormat F;          // See TMeasureNumFormat.
   LBOOL             FD;         // If true, a fractional value formatted according to the D entry may not have its denominator reduced or low-order zeros truncated.
   TMeasureLblPos    O;          // See TMeasureLblPos.
   const char*       PSA;        // Text to be concatenated to the left of the label specified by U.
   const UI16*       PSW;        // Text to be concatenated to the left of the label specified by U.
   const char*       RDA;        // Text for the decimal position in displaying numerical values.
   const UI16*       RDW;        // Text for the decimal position in displaying numerical values.
   const char*       RTA;        // Text to be used between orders of thousands in display of numerical values.
   const UI16*       RTW;        // Text to be used between orders of thousands in display of numerical values.
   const char*       SSA;        // Text that shall be concatenated after the label specified by U.
   const UI16*       SSW;        // Text that shall be concatenated after the label specified by U.
   const char*       UA;         // Label, should be a universally recognized abbreviation.
   const UI16*       UW;         // Label, should be a universally recognized abbreviation.
};

struct TPDFObjActions
{
   UI32        StructSize; // Must be set to sizeof(TPDFObjActions).
   SI32        Action;     // Action handle or -1 if not set.
   TActionType ActionType; // The type of the action if Action >= 0.
   const IEVT* Events;     // Additional events if any -> GetObjEvent().
};

struct TPDFObjEvent
{
   UI32        StructSize; // Must be set to sizeof(TPDFObjEvent).
   SI32        Action;     // Action to be executed.
   TActionType ActionType; // The type of the action.
   TObjEvent   Event;      // The event when the action should be executed.
   const IEVT* Next;       // Pointer to the next event if any.
};

struct TPDFOCG
{
   UI32        StructSize;    // Must be set to sizeof(TPDFOCG)
   UI32        Handle;        // Handle or array index
   UI32        Intent;        // Bitmask -> TOCGIntent
   const char* NameA;         // Layer name
   const UI16* NameW;         // Layer name
   LBOOL       HaveContUsage; // If true, the layer contains a Content Usage dictionary. -> GetOCGContUsage().
   // The following two members can only be set if HaveContUsage is true.
   UI32        AppEvents;     // Bitmask -> see TOCAppEvent. If non-zero, the layer is included in one or more app events which control the layer state.
   UI32        Categories;    // Bitmask -> see TOCGUsageCategory. The Usage Categories which control the layer state.
};

struct TPDFOCGContUsage
{
   UI32           StructSize;     // Must be set to sizeof(TPDFOCGContUsage)
   UI32           ExportState;    // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   const char*    InfoCreatorA;   // CreatorInfo -> The application that created the group
   const UI16*    InfoCreatorW;   // CreatorInfo -> The application that created the group
   const char*    InfoSubtype;    // CreatorInfo -> A name defining the type of content, e.g. Artwork, Technical etc.
   const char*    LanguageA;      // A language code as described at SetLanguage() in the help file.
   const UI16*    LanguageW;      // A language code as described at SetLanguage() in the help file.
   UI32           LangPreferred;  // 0 = Off, 1 = On, PDF_MAX_INT = not set. The preffered state if there is a partial but no exact match of the language identifier.
   TOCPageElement PageElement;    // If the group contains a pagination artefact.
   UI32           PrintState;     // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   const char*    PrintSubtype;   // The type of content that is controlled by the OCG, e.g. Trapping, PrintersMarks or Watermark.
   UI32           UserNamesCount; // The user names (if any) can be accessed with GetOCGUsageUserName().
   TOCUserType    UserType;       // The user for whom this optional content group is primarily intendet.
   UI32           ViewState;      // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   float          ZoomMin;        // The minimum magnification factor at which the group should be On. -1 if not set.
   float          ZoomMax;        // The maximum magnification factor at which the group should be On. -1 if not set.
};

struct TPDFOCLayerConfig
{
   UI32        StructSize; // Must be set to sizeof(TOCLayerConfig)
   TOCGIntent  Intent;     // Possible values oiDesign, oiView, or oiAll.
   LBOOL       IsDefault;  // If true, this is the default configuration.
   const char* NameA;      // Optional configuration name. The default config has usually no name but all others should have one.
   const UI16* NameW;      // Either the Ansi or Unicode string is set at time but never both.
   UI32        NameLen;    // Length in characters.
};

struct TPDFOCUINode
{
   UI32        StructSize;  // Must be set to sizeof(TOCUINode)
   const char* LabelA;      // Optional label.
   const UI16* LabelW;      // Either the Ansi or Unicode string is set at time but never both.
   UI32        LabelLength; // Length in characters.
   IOCN*       NextChild;   // If set, the next child node that must be loaded.
   LBOOL       NewNode;     // If true, a new child node must be created.
   SI32        OCG;         // Optional OCG handle. -1 if not set -> GetOCG().
};

struct TPDFOutputIntent
{
   UI32  StructSize;
   BYTE* Buffer;
   UI32  BufSize;
   char* InfoA;
   UI16* InfoW;
   UI32  NumComponents;
   char* OutputConditionA;
   UI16* OutputConditionW;
   char* OutputConditionIDA;
   UI16* OutputConditionIDW;
   char* RegistryNameA;
   UI16* RegistryNameW;
   char* SubType;
};

struct TPDFPageLabel
{
   UI32             StartRange;   // Number of the first page in the range. If no further label follows, the last
                                  // page in the range is pdfGetPageCount(). The first page is denoted by 1.
   TPageLabelFormat Format;       // Number format to be used.
   SI32             FirstPageNum; // First page number to be displayed in the page label. Subsequent pages are
                                  // numbered sequentially from this value.
   char*            Prefix;       // Optional prefix
   UI32             PrefixLen;    // Length of the prefix in characters
   LBOOL            PrefixUni;    // If true, the prefix is a Unicode string
};

struct TPDFPrintSettings
{
   TDuplexMode   DuplexMode;
   SI32          NumCopies;         // -1 means not set. Values larger than 5 are ignored in viewer applications.
   SI32          PickTrayByPDFSize; // -1 means not set. 0 == false, 1 == true.
   UI32*         PrintRanges;       // If set, the array contains PrintRangesCount * 2 values. Each pair consists
                                    // of the first and last pages in the sub-range. The first page in the PDF file
                                    // is denoted by 0.
   UI32          PrintRangesCount;  // Number of ranges available in PrintRanges.
   TPrintScaling PrintScaling;      // psNone means not set.
   /* Reserved fields for future extensions*/
   UI32 Reserved0;
   UI32 Reserved1;
   UI32 Reserved2;
   UI32 Reserved3;
   UI32 Reserved4;
   UI32 Reserved5;
   UI32 Reserved6;
   UI32 Reserved7;
   UI32 Reserved8;
   UI32 Reserved9;
};

struct TTextRecordA
{
   float Advance; // Negative values move the cursor to the right, positive to the left. The value is measured in text space!
   BYTE* Text;    // Raw text (not null-terminated)
   UI32  Length;  // Raw text length in bytes
};

struct TTextRecordW
{
   float Advance; // Negative values move the cursor to the right, positive to the left. The value is measured in text space!
   UI16* Text;    // Already translated Unicode string (not null-terminated)
   UI32  Length;  // Length in characters
   float Width;   // String width measured in text space
};

typedef SI32 PDF_CALL TApplyPattern(const void* Data, const BYTE* Object, TPatternType Type, void* Pattern);
typedef SI32 PDF_CALL TBeginLayer(const void* Data, const IOCG* OC, LBOOL Invisible);
typedef SI32 PDF_CALL TBeginMarkedContent(const void* Data, TPDFMarkedContentType Type, LBOOL Invisible, const char* Dict, UI32 DictLen, IPDFObj* Object);
typedef SI32 PDF_CALL TBeginPattern(const void* Data, LBOOL Fill, SI32 Handle, TPatternType Type, struct TPDFRect* BBox, struct TCTM* Matrix, double* XStep, double* YStep);
typedef SI32 PDF_CALL TBeginTemplate(const void* Data, const BYTE* Object, SI32 Handle, struct TPDFRect* BBox, struct TCTM* Matrix);
typedef SI32 PDF_CALL TBezierTo1(const void* Data, const BYTE* Object, double x1, double y1, double x3, double y3);
typedef SI32 PDF_CALL TBezierTo2(const void* Data, const BYTE* Object, double x2, double y2, double x3, double y3);
typedef SI32 PDF_CALL TBezierTo3(const void* Data, const BYTE* Object, double x1, double y1, double x2, double y2, double x3, double y3);
typedef SI32 PDF_CALL TClipPath(const void* Data, const BYTE* Object, LBOOL EvenOdd, TPathFillMode Mode);
typedef SI32 PDF_CALL TClosePath(const void* Data, const BYTE* Object, TPathFillMode Mode);
typedef SI32 PDF_CALL TDrawShading(const void* Data, const BYTE* Object, TShadingType Type, PSHD* Shading);
typedef void PDF_CALL TEndMarkedContent(const void* Data, TPDFMarkedContentType Type, LBOOL Invisible);
typedef void PDF_CALL TEndLayer(const void* Data, const IOCG* OC, LBOOL Invisible);
typedef void PDF_CALL TEndPattern(const void* Data);
typedef void PDF_CALL TEndTemplate(const void* Data);
typedef SI32 PDF_CALL TInsertImage(const void* Data, struct TPDFImage* Image);
typedef SI32 PDF_CALL TLineTo(const void* Data, const BYTE* Object, double x, double y);
typedef SI32 PDF_CALL TMoveTo(const void* Data, const BYTE* Object, double x ,double y);
typedef void PDF_CALL TMulMatrix(const void* Data, const BYTE* Object, struct TCTM* Matrix);
typedef SI32 PDF_CALL TRectangle(const void* Data, const BYTE* Object, double x, double y, double w, double h);
typedef SI32 PDF_CALL TRestoreGraphicState(const void* Data);
typedef SI32 PDF_CALL TSaveGraphicState(const void* Data);
typedef void PDF_CALL TSetCharSpacing(const void* Data, const BYTE* Object, double Value);
typedef void PDF_CALL TSetExtGState(const void* Data, const BYTE* Object, const struct TPDFExtGState2* GS);
typedef void PDF_CALL TSetFillColor(const void* Data, const BYTE* Object, double* Color, UI32 NumComps, TExtColorSpace CS, void* IColorSpace);
typedef void PDF_CALL TSetFont(const void* Data, const BYTE* Object, TFontType Type, LBOOL Embedded, const char* FontName, TFStyle Style, double FontSize, const PFNT* Font);
typedef void PDF_CALL TSetLeading(const void* Data, const BYTE* Object, double Value);
typedef void PDF_CALL TSetLineCapStyle(const void* Data, const BYTE* Object, TLineCapStyle Style);
typedef void PDF_CALL TSetLineDashPattern(const void* Data, const BYTE* Object, double* Dash, UI32 NumValues, UI32 Phase);    // This version is obsolete. Please use TSetLineDashPattern2 instead.
typedef void PDF_CALL TSetLineDashPattern2(const void* Data, const BYTE* Object, float* Dash, UI32 NumValues, float Phase);
typedef void PDF_CALL TSetLineJoinStyle(const void* Data, const BYTE* Object, TLineJoinStyle Style);
typedef void PDF_CALL TSetLineWidth(const void* Data, const BYTE* Object, double Value);
typedef void PDF_CALL TSetMiterLimit(const void* Data, const BYTE* Object, double Value);
typedef void PDF_CALL TSetStrokeColor(const void* Data, const BYTE* Object, double* Color, UI32 NumComps, TExtColorSpace CS, void* IColorSpace);
typedef void PDF_CALL TSetTextDrawMode(const void* Data, const BYTE* Object, TDrawMode Mode);
typedef void PDF_CALL TSetTextScale(const void* Data, const BYTE* Object, double Value);
typedef void PDF_CALL TSetWordSpacing(const void* Data, const BYTE* Object, double Value);
typedef SI32 PDF_CALL TShowTextArrayA(const void* Data, const BYTE* Object, struct TCTM* Matrix, const struct TTextRecordA* Source, UI32 Count, double Width);
typedef SI32 PDF_CALL TShowTextArrayW(const void* Data, const struct TTextRecordA* Source, struct TCTM* Matrix, const struct TTextRecordW* Kerning, UI32 Count, double Width, LBOOL Decoded);

// Unnecessary callback functions can be set to NULL.
struct TPDFParseInterface
{
   TApplyPattern*        ApplyPattern;
   TBeginPattern*        BeginPattern;
   TBeginTemplate*       BeginTemplate;
   TBezierTo1*           BezierTo1;
   TBezierTo2*           BezierTo2;
   TBezierTo3*           BezierTo3;
   TClipPath*            ClipPath;
   TClosePath*           ClosePath;
   TDrawShading*         DrawShading;
   TEndPattern*          EndPattern;
   TEndTemplate*         EndTemplate;
   TLineTo*              LineTo;
   TMoveTo*              MoveTo;
   TMulMatrix*           MulMatrix;
   TRectangle*           Rectangle;
   TRestoreGraphicState* RestoreGraphicState;
   TSaveGraphicState*    SaveGraphicState;
   TSetCharSpacing*      SetCharSpacing;
   TSetExtGState*        SetExtGState;
   TSetFillColor*        SetFillColor;
   TSetFont*             SetFont;
   TSetLeading*          SetLeading;
   TSetLineCapStyle*     SetLineCapStyle;
   TSetLineDashPattern*  SetLineDashPattern; // Obsolete. Please set SetLineDashPattern2 instead.
   TSetLineJoinStyle*    SetLineJoinStyle;
   TSetLineWidth*        SetLineWidth;
   TSetMiterLimit*       SetMiterLimit;
   TSetStrokeColor*      SetStrokeColor;
   TSetTextDrawMode*     SetTextDrawMode;
   TSetTextScale*        SetTextScale;
   TSetWordSpacing*      SetWordSpacing;
   void*                 Reserved001;    // The old callabck functions TShowTextA and TShowTextW are no longer defined
   void*                 Reserved002;    // The old callabck functions TShowTextA and TShowTextW are no longer defined
   TShowTextArrayW*      ShowTextArrayW;
   TInsertImage*         InsertImage;
   TShowTextArrayA*      ShowTextArrayA;
   TBeginLayer*          BeginLayer;     // Not called if BeginMarkedContent is set
   TEndLayer*            EndLayer;       // Not called if EndMarkedContent is set
   TSetLineDashPattern2* SetLineDashPattern2;
   TBeginMarkedContent*  BeginMarkedContent;
   TEndMarkedContent*    EndMarkedContent;
   /* These variables must be initialized with NULL! */
   void*                 Reserved01;
   void*                 Reserved02;
   void*                 Reserved03;
   void*                 Reserved04;
   void*                 Reserved05;
   void*                 Reserved06;
   void*                 Reserved07;
   void*                 Reserved08;
   void*                 Reserved09;
   void*                 Reserved10;
   void*                 Reserved11;
   void*                 Reserved12;
   void*                 Reserved13;
   void*                 Reserved14;
   void*                 Reserved15;
   void*                 Reserved16;
   void*                 Reserved17;
   void*                 Reserved18;
   void*                 Reserved19;
   void*                 Reserved20;
   void*                 Reserved21;
   void*                 Reserved22;
};

struct TPDFRawImage
{
   UI32           StructSize;       // Must be set to sizeof(TPDFRawImage)
   const void*    Buffer;           // Image buffer
   UI32           BufSize;          // Buffer size
   UI32           BitsPerComponent; // Bits per component
   UI32           NumComponents;    // Number of components (max 32)
   TExtColorSpace CS;               // Image color space
   SI32           CSHandle;         // Color space handle (non-device color spaces only)
   SI32           Stride;           // Scanline length in bytes -> If negative, the image is defined in bottom up coordinates, top down otherwise
   LBOOL          HasAlpha;         // If true, the last component is an alpha channel
   LBOOL          IsBGR;            // esDeviceRGB only -> If true, the image components are defined in BGR format instead of RGB
   LBOOL          MinIsWhite;       // 1 bit images only -> If true, zero pixel values must be treated as white instead of black
   UI32           Width;            // Width in pixels (must be greater zero)
   UI32           Height;           // Height in pixels (must be greater zero)
};

struct TPDFRelFileNode
{
   UI32                StructSize; // Must be set to sizeof(TPDFRelFileNode).
   const char*         NameA;      // Name of this file spcification.
   const UI16*         NameW;      // Either the Ansi or Unicode name is set but never both.
   struct TPDFFileSpec EF;         // Embedded file.
   IRFN*               NextNode;   // Next node if any.
};

struct TPDFResetFormAction
{
   UI32         StructSize;     // Must be set to sizeof(TPDFResetFormAction).
   const IFLD** Fields;         // Array of field pointers -> GetFieldEx2().
   UI32         FieldsCount;    // Number of fields in the array.
   LBOOL        Include;        // If true, the fields in the Fields array must be reset. If false, these fields must be excluded.
   SI32         NextAction;     // -1 or next action handle to be executed if any
   TActionType  NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFSigDict
{
   UI32            StructSize;     // Must be set to sizeof(TPDFSigDict).
   const UI32*     ByteRange;      // ByteRange -> Byte offset followed by the corresponding length.
                                   // The byte ranges are required to create the digest. The values
                                   // are returned as is. So, you must check whether the offsets and
                                   // length values are valid. There are normally at least two ranges.
                                   // Overlapping ranges are not allowed! Any error breaks processing
                                   // and the signature should be considered as invalid.
   UI32            ByteRangeCount; // The number of Offset / Length pairs. ByteRange contains 2 * ByteRangeCount values!
   const BYTE*     Cert;           // X.509 Certificate when SubFilter is adbe.x509.rsa_sha1.
   UI32            CertLen;        // Length in bytes
   const UI32*     Changes;        // If set, an array of three integers that specify changes to the
                                   // document that have been made between the previous signature and
                                   // this signature in this order: the number of pages altered, the
                                   // number of fields altered, and the number of fields filled in.
   const char*     ContactInfoA;   // Optional contact info string, e.g. an email address
   const UI16*     ContactInfoW;   // Optional contact info string, e.g. an email address
   const BYTE*     Contents;       // The signature. This is either a DER encoded PKCS#1 binary data
                                   // object or a DER-encoded PKCS#7 binary data object depending on
                                   // the used SubFilter.
   UI32            ContentsSize;   // Length in bytes.
   const char*     Filter;         // The name of the security handler, usually Adobe.PPKLite.
   const char*     LocationA;      // Optional location of the signer
   const UI16*     LocationW;      // Optional location of the signer
   const char*     SignTime;       // Date/Time string
   const char*     NameA;          // Optional signers name
   const UI16*     NameW;          // Optional signers name
   UI32            PropAuthTime;   // Optional -> The number of seconds since the signer was last authenticated.
   const char*     PropAuthType;   // Optional -> The method that shall be used to authenticate the signer.
                                   // Valid values are PIN, Password, and Fingerprint.
   const char*     ReasonA;        // Optional reason
   const UI16*     ReasonW;        // Optional reason
   SI32            Revision;       // Optional -> The version of the signature handler that was used to create
                                   // the signature.
   const char*     SubFilter;      // A name that describes the encoding of the signature value. Should be
                                   // adbe.x509.rsa_sha1, adbe.pkcs7.detached, or adbe.pkcs7.sha1.
   SI32            Version;        // The version of the signature dictionary format.
};

struct TPDFSigParms
{
   UI32          StructSize;      // Must be set to sizeof(TSignParms)
   UI32          PKCS7ObjLen;     // The maximum length of the signed PKCS#7 object
   THashType     HashType;        // If set to htDetached, the byte ranges of the PDF file will be returned.
   const BYTE*   Range1;          // Out -> Contains either the hash or the first byte range to create a detached signature
   UI32          Range1Len;       // Out -> Length of the buffer
   const BYTE*   Range2;          // Out -> Set only if HashType == htDetached
   UI32          Range2Len;       // Out -> Length of the buffer
   const char*   ContactInfoA;    // Optional, e.g. an email address
   const UI16*   ContactInfoW;    // Optional, e.g. an email address
   const char*   LocationA;       // Optional location of the signer
   const UI16*   LocationW;       // Optional location of the signer
   const char*   ReasonA;         // Optional reason why the file was signed
   const UI16*   ReasonW;         // Optional reason why the file was signed
   const char*   SignerA;         // Optional, the issuer of the certificate takes precedence
   const UI16*   SignerW;         // Optional, the issuer of the certificate takes precedence
   LBOOL         Encrypt;         // If true, the file will be encrypted
   // These members will be ignored if Encrypt is set to false
   const char*   OpenPwd;         // Open password
   const char*   OwnerPwd;        // Owner password to change the security settings
   TKeyLen       KeyLen;          // Key length to be used to encrypt the file
   TRestrictions Restrict;        // What should be restricted?
   // Windows only
   const void*   Certificate;     // Handle of a certificate context (PCCERT_CONTEXT), returned by CertFindCertificateInStore(), for example.
                                  // If this paramteter is set, PKCS7ObjLen will be ignored and the file will be signed with this certificate.
   const UI16*   TimeStampServer; // Optional URL of a time stamp server
   UI32          TimeOut;         // Optional number of millisecond
};

#if !defined(DRV_GLOBAL)
   struct TPDFSysFont
   {
      UI32               StructSize;      // Must be set to sizeof(TPDFSysFont)
      TFontBaseType      BaseType;        // Font type
      const char*        CIDOrdering;     // OpenType CID fonts only
      const char*        CIDRegistry;     // OpenType CID fonts only
      UI32               CIDSupplement;   // OpenType CID fonts only
      UI32               DataOffset;      // Data offset
      const UI16*        FamilyName;      // Family name
      const char*        FilePathA;       // Font file path
      const UI16*        FilePathW;       // Font file path
      UI32               FileSize;        // File size in bytes
      TEnumFontProcFlags Flags;           // Bitmask
      const UI16*        FullName;        // Full name
      UI32               Length1;         // Length of the clear text portion of a Type1 font
      UI32               Length2;         // Length of the eexec encrypted binary portion of a Type1 font
      const char*        PostScriptNameA; // Postscript mame
      const UI16*        PostScriptNameW; // Postscript mame
      SI32               Index;           // Zero based font index if the font is stored in a TrueType collection
      LBOOL              IsFixedPitch;    // If true, the font is a fixed pitch font. A proportional font otherwise.
      TFStyle            Style;           // Font style
      TUnicodeRange1     UnicodeRange1;   // Bitmask
      TUnicodeRange2     UnicodeRange2;   // Bitmask
      TUnicodeRange3     UnicodeRange3;   // Bitmask
      TUnicodeRange4     UnicodeRange4;   // Bitmask
   };
#endif

/*
   ---------------------------------------- NOTICE: ----------------------------------------

   ------------------ DO NOT CHANGE A MEMBER OF THIS STRUCTURE AT RUNTIME! ------------------

   The only members which can be changed at runtime are ConvColors, DestSpace, and DeleteKerningAt.
   All other members are read-only!

   -----------------------------------------------------------------------------------------
*/
struct TPDFStack
{
   struct TCTM          ctm;          // Pre-multiplied global transformation matrix
   struct TCTM          tm;           // Pre-multiplied text transformation matrix
   double               x;            // Unused -> always 0.0
   double               y;            // Unused -> always 0.0
   double               FontSize;     // Font size
   double               CharSP;       // Character spacing
   double               WordSP;       // Word spacing
   double               HScale;       // Horizontal text scaling
   double               TextRise;     // Text rise -> always 0.0 because it is already included in the text transformation matrix
   double               Leading;      // Leading
   double               LineWidth;    // Line width
   TDrawMode            DrawMode;     // Text draw mode
   TPDFColorSpace       FillCS;       // Fill color space
   TPDFColorSpace       StrokeCS;     // Stroke color space
   UI32                 FillColor;    // Fill color
   UI32                 StrokeColor;  // Stroke color
   void*                BaseObject;   // Internal
   LBOOL                CIDFont;      // If true, ReplacePageText() can only be used to delete a string
   char*                Text;         // Raw text without kerning space
   UI32                 TextLen;      // Raw text length
   struct TTextRecordA* RawKern;      // Raw kerning array
   struct TTextRecordW* Kerning;      // Already translated Unicode kerning array
   UI32                 KerningCount; // Number of kerning records
   float                TextWidth;    // The width of the entire text record measured in text space
   PFNT*                IFont;        // Font object used to print the string -> fntGetFont() can be used to return the font properties
   LBOOL                Embedded;     // If true, the font is embedded
   float                SpaceWidth;   // Measured in text space
   /*
      These members can be modified after the structure has been initialized with InitStack().
      If the destination color space should be DeviceCMYK initialize FillColor and StrokeColor
      with PDF_CMYK(0,0,0,255); which represents black.
   */
   LBOOL                ConvColors;   // If set to true (default), all colors are converted to the specified destination color space
   TPDFColorSpace       DestSpace;    // Destination color space -> default == csDeviceRGB

   // This member can be used in combination with ReplacePageText() to preserve a number
   // of kerning records from deletion. All records above this value will be deleted.
   // Take a look into the file examples/util/pdf_edit_text.cpp to determine how this member
   // can be used.
   UI32                 DeleteKerningAt;
   UI32                 FontFlags;    // PDF font flags
   // ------------------------------- Reserved fields -------------------------------
   SI32                 Reserved1;
   SI32                 Reserved2;
   SI32                 Reserved3;
   SI32                 Reserved4;
   SI32                 Reserved5;
   SI32                 Reserved6;
   SI32                 Reserved7;
   SI32                 Reserved8;
   SI32                 Reserved9;
   SI32                 Reserved10;
   SI32                 Reserved11;
   void*                ContentPtr;
};

struct TPDFSubmitFormAction
{
   UI32         StructSize;     // Must be set to sizeof(TPDFSubmitFormAction)
   const char*  CharSet;        // Optional charset in which the form should be submitted.
   const IFLD** Fields;         // Array of field pointers -> GetFieldEx2().
   UI32         FieldsCount;    // Number of fields in the array.
   TSubmitFlags Flags;          // Various flags, see CreateSubmitAction() for further information.
   const char*  URL;            // The URL of the script at the Web server that will process the submission.
   SI32         NextAction;     // -1 or next action handle to be executed if any
   TActionType  NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFURIAction
{
   UI32        StructSize;     // Must be set to sizeof(TPDFURIAction)
   const char* BaseURL;        // Optional, if defined in the Catalog object.
   LBOOL       IsMap;          // A flag specifying whether to track the mouse position when the URI is resolved: e.g. http://test.org?50,70.
   const char* URI;            // Uniform Resource Identifier.
   SI32        NextAction;     // -1 or next action handle to be executed if any.
   TActionType NextActionType; // Only set if NextAction is >= 0.
};

struct TPDFViewport
{
   UI32            StructSize; // Must be set to sizeof(TPDFViewport)
   struct TFltRect BBox;       // Bounding box
   IMSR*           Measure;    // Optional -> GetMeasureObj()
   const char*     NameA;      // Optional name
   const UI16*     NameW;      // Optional name
   IPTD*           PtData;     // Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
};

struct TPDFXFAStream
{
   UI32        StructSize; // Must be set to sizeof(TPDFXFAStream)
   const BYTE* Buffer;
   UI32        BufSize;
   const char* NameA;
   const UI16* NameW;
};

/* ----------------------------------- Rendering API ----------------------------------- */

typedef enum TPDFPageScale
{
   psFitWidth,  // Scale the page to the width of the image buffer
   psFitHeight, // Scale the page to the height of the image buffer
   psFitBest,   // Scale the page so that it fits fully into the image buffer
   psFitZoom    // This mode should be used if the scaling factors of the transformation matrix are <> 1.0
}TPDFPageScale;

struct TPDFActionContext
{
   UI32          StructSize;   // Must be set to sizeof(TActionContext)
   SI32          NewX;         // New y-coordinate to scroll to
   SI32          NewY;         // New x-coordinate to scroll to
   float         NewZoom;      // New zoom factor
   TPDFPageScale NewPageScale; // New page scaling mode
   const IACT*   NextAction;   // Next action to execute, if any
   const IEVT*   NextEvent;    // Next event to execute, if any
};

typedef enum TPDFControlSubType
{
   cstNone,
   cstButton,
   cstCheckBox,
   cstComboBox,
   cstListBox,
   cstSignature,
   cstTextField
}TPDFControlSubType;

typedef enum TPDFControlType
{
   crpCaretAnnot,    // Draw a Caret annotation
   crpCircleAnnot,   // Draw an oval or circle if shift is pressed
   crpFileAttach,    // Draw a File Attach annotation
   crpFileLink,      // Draw a File Link annotation
   crpInkAnnot,      // Draw an Ink annotation
   crpLineAnnot,     // Draw a Line annotation
   crpPolygonAnnot,  // Draw a Polygon annotation
   crpPolyLineAnnot, // Draw a PolyLine annotation
   crpSelObject,     // Draw a placeholder for object selection. This type is created by SelectObject(). It cannot be created with CreateControl()!
   crpSquareAnnot,   // Draw a regular rectangle or square if shift is pressed
   crpStampAnnot,    // Draw a Stamp annotation
   crpTextAnnot,     // Draw a Text annotation
   crpWidget,        // Draw a form field
   crpSelRect        // Draw a selection rectangle.
}TPDFControlType;

typedef enum TPDFCtrlFlags
{
   fcfDefault   = 0,
   fcfChecked   = 1,
   fcfMultiline = 2,
   fcfSort      = 4
}TPDFCtrlFlags;

struct TPDFControl
{
   UI32               StructSize;     // Must be initialized with sizeof(TPDFControl)
   TBorderEffect      BorderEffect;   // Border effect
   float              BorderWidth;    // Border width in PDF units
   TPDFControlSubType ControlSubType; // Control sub type
   TPDFControlType    ControlType;    // Control type
   UI32               FillColor;      // Fill color
   UI32               IconType;       // Used by FileAttach and Text annotations only -> TAnnotIcon or TFileAttachIcon.
   TLineEndStyle      LineEndStyle1;  // Line end style of the start point
   TLineEndStyle      LineEndStyle2;  // Line end style of the end point
   float              Opacity;        // Opacity 0..1. 0 == fully transparent, 1.0 == fully opaque
   UI32               StrokeColor;    // Stroke color
   // Members for form fields
   TPDFCtrlFlags      Flags;          // Various flags
   SI32               MaxLen;         // Text fields
   const char*        Name;           // Might be an UTF8 string
   SI32               Parent;         // Parent field or -1
   const char*        StrVal;         // Caption or ExpValue
};

// Most pre-defined cursor constants have a counterpart in Delphi
typedef enum TPDFCursor
{
   pcrHandNormal = 0,  // This is the default cursor if the left mouse button is not pressed and if we are not over an action field or text
   pcrHandClosed = 1,  // This cursor is used if the cursor leaves an action field and if the left mouse button is pressed
   pcrHandPoint  = 2,  // This cursor is used if we enter a link or button field
   pcrIBeam      = 3,  // This cursor is used we move the cursor over text of if we enter an action field that accepts text input
   pcrCross      = 4,  // This cursor is used to draw a selection rectangle, for example.
   pcrDrag       = 5,  // Drag cursor for single items being dragged.
   pcrHourGlass  = 6,  // Hour glass cursor to indicate a busy process.
   pcrMultiDrag  = 7,  // Drag cursor for multiple items being dragged.
   pcrNo         = 8,  // Cross in a circle indicating invalid mouse target location.
   pcrNoDrop     = 7,  // Cross in a circle indicating that a drag operation is hovering over an invalid drop target.
   pcrSizeAll    = 8,  // Cursor for resizing up, down, left, and right.
   pcrSizeNESW   = 9,  // North-East to South-West resizing.
   pcrSizeNS     = 10, // Vertical resizing cursor.
   pcrSizeNWSE   = 11, // Resizing cursor from North-West to South-East resizing.
   pcrSizeWE     = 12, // Horizontal resizing cursor
   pcrSplitH     = 13, // Cursor shown when the mouse is over a horizontal splitter.
   pcrSplitV     = 14, // Cursor shown when the mouse is over a vertical splitter. 
   pcrArrow1     = 15, // White arrow.
   pcrArrow2     = 16, // Black arrow.
   pcrArrow3     = 17, // Black arrow with a smaller shape.
   pcrUserDef1   = 18, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef2   = 19, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef3   = 20, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef4   = 21, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef5   = 22, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef6   = 23, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef7   = 24, // User defined cursor. Can be activated with ChangeCursor().
   pcrUserDef8   = 25  // User defined cursor. Can be activated with ChangeCursor().
}TPDFCursor;

/*
   The path names can be set in Ansi (code page 1252 on Windows) or Unicode format. The Ansi version accepts
   UTF-8 strings on non-Windows operating systems. UTF-16 Unicode strings are converted to UTF-8 on non-Windows
   operating systems.

   In general, the DefInXXX profiles are used if no other profile is available for the color space. Possible
   sources are DefaultGray, DefaultRGB, DefaultCMYK, and the Rendering Intents.

   The SoftProof profile emulates the output device. This is typically a printer profile or a default CMYK
   profile. If no profile is set then no device will be emulated. What you see is maybe not what you get on
   a printer.

   To disable color management set the parameter Profiles of rasInitColormanagement() to NULL.
*/
struct TPDFColorProfiles
{
   UI32        StructSize;     // Must be set to sizeof(TPDFColorProfile)
   const char* DefInGrayA;     // Optional
   const UI16* DefInGrayW;     // Optional
   const char* DefInRGBA;      // Optional, sRGB is the default. The "A" stands for Ansi string and not for Alpha...
   const UI16* DefInRGBW;      // Optional
   const char* DefInCMYKA;     // Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
   const UI16* DefInCMYKW;     // but this is not possible with a CMYK profile. So, this is the most important input profile.
   const char* DeviceProfileA; // Optional, the output profile must be compatible with the output color space.
   const UI16* DeviceProfileW; // At this time only Gray or RGB profiles are supported. This is the monitor profile! Default is sRGB.
   const char* SoftProofA;     // Optional but very important. This profile emulates the output device.
   const UI16* SoftProofW;     // Optional.
};

struct TPDFColorProfilesEx
{
   UI32        StructSize;       // Must be set to sizeof(TPDFColorProfilesEx)
   const void* DefInGray;        // Optional
   UI32        DefInGrayLen;     // Optional
   const void* DefInRGB;         // Optional
   UI32        DefInRGBLen;      // Optional
   const void* DefInCMYK;        // Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
   UI32        DefInCMYKLen;     // but this is not possible with a CMYK profile. So, this is the most important input profile.
   const void* DeviceProfile;    // Optional, the output profile must be compatible with the output color space.
   UI32        DeviceProfileLen; // Gray, RGB, or CMYK profiles are supported.
   const void* SoftProof;        // Optional but very important. This profile emulates the output device.
   UI32        SoftProofLen;     // Optional.
};

typedef enum TPDFInitCMFlags
{
   icmDefault         = 0, // Default rules.
   icmBPCompensation  = 1, // Black point compensation preserves the black point when converting CMYK colors to different color spaces.
   icmCheckBlackPoint = 2  // If set, soft proofing will be disabled if the black point of the output intent is probably invalid.
}TPDFInitCMFlags;

typedef enum TPDFMouseKeys
{
   mkNone         = 0x00000000,
   mkLeftButton   = 0x00000001,
   mkRightButton  = 0x00000002,
   mkShift        = 0x00000004,
   mkControl      = 0x00000008,
   mkMiddleButton = 0x00000010
}TPDFMouseKeys;

typedef enum TSelObjAction
{
   soaNoSelection      = 0, // No object was selected
   soaDeselected       = 1, // Object was de-selected and nothing was changed.
   soaError            = 2, // An error occurred while applying pending change. Object is now de-selected.
   soaIgnored          = 3, // This state occurs if nothing was to do, e.g. if no button was pressed.
   soaInvObjInfo       = 4, // TPDFObjectInfo structure contains invalid data.
   soaSelctionApplied  = 5, // Pending change was applied and object was de-selected.
   soaSelected         = 6, // The object was selected.
   soaSelectionChanged = 7, // Another object was selected. Previous object was not changed.
   soaStillSelected    = 8  // Nothing changed. The same object is still selected.
}TSelObjAction;

typedef enum TSelectObjType
{
   sotDefault    = 0, // Hand tool
   sotAnnotation = 1, // Select annotations
   sotFormField  = 2, // Select form fields
   sotImage      = 4, // Select images
   sotText       = 8, // Select text
   sotVector     = 16 // Select vector graphics
}TSelectObjType;

typedef enum TPDFObjectFlags
{
   acfDefault           = 0,
   acfDrawTextSelection = 1
}TPDFObjectFlags;

struct TPDFObjectInfo
{
   UI32              StructSize; // Must be set to sizeof(TPDFObject).
   SI32              Action;     // Action handle or -1 if not set.
   const IACT*       ActionPtr;  // Action pointer for fast access if available.
   TActionType       ActionType; // The type of the action if Action >= 0.
   struct TIntRect   BBox;       // Bounding box if available.
   const IEVT*       Events;     // Additional events if any -> GetObjEvent().
   TPDFObjectFlags   Flags;      // Certain object flags.
   SI32              ObjHandle;  // Object handle.
   const void*       ObjPtr;     // Object pointer for fast access if available. If ObjType == sotText then ObjType holds a pointer of the corresponding font -> fntGetFontInfo().
   TSelectObjType    ObjType;    // Object type that was selected.
   SI32              PageNum;    // The page number on which this object was found.
   SI32              SubType;    // This is currently the annotation or field type if ObjType == sotAnnotation or ObjType == sotFormField. Otherwise the the value is not set (-1).
};

#if !defined(DRV_GLOBAL)
   typedef enum TPDFPixFormat
   {
      pxf1Bit,
      pxfGray,
      pxfRGB,
      pxfBGR,
      pxfRGBA,
      pxfBGRA,
      pxfARGB,
      pxfABGR,
      pxfGrayA,
      pxfCMYK,
      pxfCMYKA
   }TPDFPixFormat;
#endif

typedef enum TRasterFlags
{
   rfDefault               = 0x00000000, // Render the page as usual
   rfScaleToMediaBox       = 0x00000001, // Render the real paper format. Contents outside the crop box is clipped
   rfIgnoreCropBox         = 0x00000002, // Ignore the crop box and render anything inside the media box without clipping
   /*
      The art, bleed, or trim boxe is first intersected with the media box or crop box if present
      since these boxes represent the maximum extend of the page.
      If the flag rfIgnoreCropBox is set, the boxes are intersected with the media box. The page is
      scaled to the media or crop depending on the above flags.
   */
   rfClipToArtBox          = 0x00000004, // Clip the page to the art box if any
   rfClipToBleedBox        = 0x00000008, // Clip the page to the bleed box if any
   rfClipToTrimBox         = 0x00000010, // Clip the page to the trim box if any
   // ---------------------------------
   rfExclAnnotations       = 0x00000020, // Don't render annotations
   rfExclFormFields        = 0x00000040, // Don't render form fields
   rfSkipUpdateBG          = 0x00000080, // Don't generate an update event after initializing the background to white
   rfRotate90              = 0x00000100, // Rotate the page 90 degress
   rfRotate180             = 0x00000200, // Rotate the page 180 degress
   rfRotate270             = 0x00000400, // Rotate the page 270 degress
   rfInitBlack             = 0x00000800, // Initialize the image buffer to black before rendering (RGBA or GrayA must be initialized to black)
   rfCompositeWhite        = 0x00001000, // Composite pixel formats with an alpha channel finally with a white background. The alpha channel is
                                         // 255 everywhere after composition. This flag is mainly provided for debug purposes but it can also be
                                         // useful if the image must be copied on screen with a function that doesn't support alpha blending.
   rfExclPageContent       = 0x00002000, // If set, only annotations and form fields will be rendered (if any).

   // If you want to render specific field types with RenderAnnotOrField() then use the following flags to exclude these fields.
   // If all fields should be skipped then set the flag rfExclFormFields instead.
   rfExclButtons           = 0x00004000,
   rfExclCheckBoxes        = 0x00008000,
   rfExclComboBoxes        = 0x00010000,
   rfExclListBoxes         = 0x00020000,
   rfExclTextFields        = 0x00040000,
   rfExclSigFields         = 0x00080000,
   // ---------------------------------
   rfScaleToBBox           = 0x00100000, // Considered only, if the flag rfClipToArtBox, rfClipToBleedBox, or rfClipToTrimBox is set.
                                         // If set, the picture size is set to the size of the whished bounding box.
   rfDisableAAClipping     = 0x00200000, // Disable Anti-Aliasing for clipping paths which are used for images. This flag is the most important
                                         // one since clipping paths cause often visible artefacts in PDF files with flattened transparency.
   rfDisableAAText         = 0x00400000, // Disable Anti-Aliasing for text.
   rfDisableAAVector       = 0x00800000, // Disable Anti-Aliasing for vector graphics.
   rfDisableAntiAliasing   = rfDisableAAClipping | rfDisableAAText | rfDisableAAVector, // Fully disable Anti-Aliasing.
   rfDisableBiLinearFilter = 0x01000000, // Disable the BiLevel filter for images. Sometetimes useful if sharp images are needed, e.g. for barcodes.

   rfRenderInvisibleText   = 0x02000000, // If set, treat text rendering mode Invisible as Normal.
   // Internal flags
   rfClipBoxMask           = rfClipToArtBox | rfClipToBleedBox | rfClipToTrimBox,
   rfEnableTextSelection   = 0x04000000, // This flag is currently used internally by the page cache to enable text selection.
   rfEnableObjSelection    = 0x08000000, // This flag is currently used internally by the page cache to enable object selection (annotations, form fields, and so on).
   rfEnableBlendCS         = 0x10000000, // If set, the page is rendered in the color space of the page group, soft proof color space, or output intent if set, and
                                         // finally converted to the destination color space.
   rfRenderPrintState      = 0x20000000, // If set, the print state of layers, annotations, and form fields will be rendered.
   rfForceInterpolation    = 0x40000000, // If set, image interpolation will be applied.
   rfPremulAlpha           = 0x80000000  // If set, an image with pre-multiplied alpha values will be created.
}TRasterFlags;

typedef enum TInitCacheFlags
{
   icfDefault          = 0,
   icfIgnoreOpenAction = 1,
   icfIgnorePageLayout = 2,
   icfNonTileMode      = 4
}TInitCacheFlags;

typedef enum TPageCacheOptions
{
   pcoBackColor,     // UI32 -> Color
   pcoCursor,        // TPDFCursor
   pcoDefPageLayout, // TPageLayout
   pcoPageScale,     // TPDFPageScale
   pcoResolution,    // SI32
   pcoRotate         // SI32 (90 degree steps)
}TPageCacheOptions;

#if !defined(DRV_GLOBAL) // Internal define to avoid dependecies to this header file
   typedef enum TPDFThreadPriority
   {
      ttpLowest,
      ttpIdle,
      ttpBelowNormal, // This is the default value. Normal can be used too but scrolling is smoother in this mode.
      ttpNormal,
      ttpAboveNormal,
      ttpHighest,     // Not really useful...
      ttpTimeCritical // Don't do that!
   }TPDFThreadPriority;
#endif

typedef enum TUpdBmkAction
{
   ubaDoNothing     = 0,  // Nothing to do
   ubaOpenPage      = 1,  // Jump to the new page. This flag is set if the bookmark contained a destination or go to action.
   ubaPageScale     = 2,  // Update the page scale with SetPageScale().
   ubaZoom          = 4,  // Zoom into the page, update the scroll ranges, and set the scroll positions.
   ubaUpdScrollBars = 8,  // This flag is always set if ubaZoom is set.
   ubaExecAction    = 16  // Check the parameter Action to execute further code. This flag can occur with or without ubaOpenPage.
}TUpdBmkAction;

typedef enum TUpdScrollbar
{
   usbNoUpdate         = 0x00000000, // Nothing to do.
   usbVertRange        = 0x00000001, // Update the vertical scroll range.
   usbVertScrollPos    = 0x00000002, // Update the vertical scroll position.
   usbHorzRange        = 0x00000004, // Update the horizontal scroll range.
   usbHorzScrollPos    = 0x00000008, // Update the horizontal scroll position.
   usbUpdateAll        = 0x0000000F, // Update both scroll ranges and the scroll positions.
   // The cursor constants are set by MouseMove. Since we have only one cursor there is never more than one constant set.
   usbCursorHandNormal = 0x00000010, // This is the default cursor if the left mouse button is not pressed and if we are not over an action field or text
   usbCursorHandClosed = 0x00000020, // This cursor is used if the cursor leaves an action field and if the left mouse button is pressed
   usbCursorHandPoint  = 0x00000040, // This cursor is used if we enter a link or button field
   usbCursorIBeam      = 0x00000080, // This cursor is used if we move the cursor over text of if we enter an action field that accepts text input
   usbCursorCross      = 0x00001000, // This cursor is used to draw a selection rectangle, for example.
   usbCursorDrag       = 0x00001100, // Drag cursor for single items being dragged.
   usbCursorHourGlass  = 0x00001200, // Hour glass cursor to indicate a busy process.
   usbCursorMultiDrag  = 0x00001300, // Drag cursor for multiple items being dragged.
   usbCursorNo         = 0x00001400, // Cross in a circle indicating invalid mouse target location.
   usbCursorNoDrop     = 0x00001500, // Cross in a circle indicating that a drag operation is hovering over an invalid drop target.
   usbCursorSizeAll    = 0x00001600, // Cursor for resizing up, down, left, and right.
   usbCursorSizeNESW   = 0x00001700, // North-East to South-West resizing.
   usbCursorSizeNS     = 0x00001800, // Vertical resizing cursor.
   usbCursorSizeNWSE   = 0x00001900, // Resizing cursor from North-West to South-East resizing.
   usbCursorSizeWE     = 0x00001A00, // Horizontal resizing cursor.
   usbCursorSplitH     = 0x00001B00, // Cursor shown when the mouse is over a horizontal splitter.
   usbCursorSplitV     = 0x00001C00, // Cursor shown when the mouse is over a vertical splitter.
   usbCursorArrow1     = 0x00001D00, // White arrow.
   usbCursorArrow2     = 0x00001E00, // Black arrow.
   usbCursorArrow3     = 0x00001F00, // Black arrow with a smaller shape.
   usbCursorUserDef1   = 0x00002000, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef2   = 0x00002100, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef3   = 0x00002200, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef4   = 0x00002300, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef5   = 0x00002400, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef6   = 0x00002500, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef7   = 0x00002600, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorUserDef8   = 0x00002700, // User defined cursor. Can be activated with ChangeCursor().
   usbCursorMask       = 0x00003FF0  // Bitmask to mask out the cursor constants.
}TUpdScrollbar;

typedef SI32 PDF_CALL TOnUpdateWindow(const void* Data, struct TIntRect* Area);

// These flags can be combined with the structure size member:
//  TPDFRasterImage img;
//  img.StructSize = sizeof(img) | SKIP_INIT_SCREEN;
#define SKIP_INIT_SCREEN   0x10000000 // Do not initialize the screen with a white image before rendering begins
#define SKIP_UPDATE_SCREEN 0x20000000 // Do not finally update the screen after the page was rendered

struct TPDFRasterImage
{
   UI32             StructSize;            // Must be set to sizeof(TPDFRasterImage)
   TRasterFlags     Flags;                 // This is a bit mask. Flags can be combined with a binary or operator
   TPDFPageScale    DefScale;              // Specifies how the page should be scaled into the image buffer.
   LBOOL            InitWhite;             // If true, the image buffer is initialized to white before rendering.
                                           // When a clipping rectangle is set, only the area inside the clipping
                                           // rectangle is initialized to white.

   struct TIntRect  ClipRect;              // Optional clipping rectangle defined in device coordinates (Pixels), default 0,0,0,0 (no clipping)
   struct TCTM      Matrix;                // Optional transformation matrix. Initialize the variable to the identity matrix (1,0,0,1,0,0)
                                           // if you don't need it. The matrix can be used to move and scale the picture inside the image.
   struct TCTM      PageSpace;             // Out -> The matrix represents the mapping from page space to device space. This matrix
                                           // is required when further objects should be drawn on the page, e.g. the bounding boxes.

   LBOOL            DrawFrameRect;         // If true, the area outside the page's bounding box is filled with the
                                           // frame color. InitWhite can still be used, with or without a clipping
                                           // rectangle.
   UI32             FrameColor;            // Must be defined in the color space of the pixel format but in the natural
                                           // component order, e.g. RGB.

   TOnUpdateWindow* OnUpdateWindow;        // Optional, UpdateOnPathCount and UpdateOnImageCoverage define when the function should be called
   void*            OnInitDecoder;         // Not yet defined
   void*            OnDecodeLine;          // Not yet defined
   const void*      UserData;              // Arbitrary pointer that should be passed to the callback functions

   UI32             UpdateOnPathCount;     // Optional -> Call OnUpdateWindow when the limit was reached.
                                           // Clipping paths increment the number too.
                                           // Only full paths are considered, independent of the number of vertices
                                           // they contain. The value should be larger than 50 and smaller than 10000.

   float            UpdateOnImageCoverage; // Optional -> DynaPDF multiplies the output image width and height with this
                                           // factor to calculate the coverage limit. When an image is inserted the unscaled
                                           // width and height is added to the current coverage value. When the number
                                           // reaches the limit the OnUpdateWindow event is raised.
                                           // The factor should be around 0.5 through 5.0. Larger values cause less
                                           // frequently update events.
   // Statistics...
   UI32             NumAnnots;             // Out -> Number of rendered annotations (excluding invisible annotation but including annotations with no appearance)
   UI32             NumBezierCurves;       // Out -> Number of bezier curves which where rendered. Glyph outlines are not taken into account
   UI32             NumClipPaths;          // Out -> Number of clipping paths used in the page. Should be small as possible!
   UI32             NumFormFields;         // Out -> Number of rendered form fields (excluding invisible fields but including fields with no appearance)
   UI32             NumGlyphs;             // Out -> When the number of glyphs equals NumTextRecords then there is probably some room for optimization...
   UI32             NumImages;             // Out -> Number of images which were rendered
   UI32             NumLineTo;             // Out -> Number of LineTo operators
   UI32             NumPaths;              // Out -> Number of paths which were processed
   UI32             NumPatterns;           // Out -> Number of pattern which were processed
   UI32             NumRectangles;         // Out -> Number of rectangle operators
   UI32             NumRestoreGState;      // Out -> Should be equal to NumSaveGraphicStates
   UI32             NumSaveGState;         // Out -> The number of save graphics state operators
   UI32             NumShadings;           // Out -> Number shadings which were processed
   UI32             NumSoftMasks;          // Out -> Number of soft masks that were processed. Alpha channels of images are not taken into account.
   UI32             NumTextRecords;        // Out -> Number of text records which were rendered
   SI32             Reserved;              // Reserved field to avoid alignment issues.
};

/* -------------------- Helper functions for GetDynaPDFVersionInt() -------------------- */

static PDF_INLINE SI32 pdfIsNum(SI32 Value)
{
   Value -= 48;
   return (Value < 10 && Value > -1);
}

static PDF_INLINE SI32 pdfParseInt(const BYTE** Source, const BYTE* End)
{
   BYTE c;
   SI32 number = 0;
   bool isNegative = false;
   if ((*Source) >= End) return 0;
   if ((c = *(*Source)) == 45)
   {
      isNegative = true;
      ++(*Source);
   }else if (c == 43)
      ++(*Source);
   while ((*Source) < End)
   {
      c = *(*Source);
      if (!pdfIsNum(c)) break;
      number = number * 10 + c - 48;
      ++(*Source);
   }
   if (isNegative)
      return -number;
   else
      return number;
}

/* ------------------------------------------------------------------------------------- */

#if !defined(PDF_USE_CLASS) // Disable all exported functions to enable class access

// Debug stuff -> these functions do nothing in a release configuration!
PDF_EXP unsigned int PDF_CALL pdfGetAllocCount(void);
PDF_EXP unsigned int PDF_CALL pdfGetDenyAllocAt(void);
PDF_EXP unsigned int PDF_CALL pdfGetDenyCount(void);
PDF_EXP void         PDF_CALL pdfSetDenyAllocAt(unsigned int Count);

/*
   Due to the complexity of font handling a complete font API will be available later in a separate library.
*/

/* -------------------------- Helper functions for ParseContent() and Font API -------------------------- */

PDF_EXP LBOOL  PDF_CALL fntBuildFamilyNameAndStyle(const PFNT* IFont, char Name[128], TFStyle ADDR Style);
PDF_EXP LBOOL  PDF_CALL fntGetFont(const PFNT* IFont, struct TPDFFontObj* F);
PDF_EXP LBOOL  PDF_CALL fntGetFontInfo(const PFNT* IFont, struct TPDFFontInfo* F);
PDF_EXP double PDF_CALL fntGetSpaceWidth(const PFNT* IFont, double FontSize);
PDF_EXP double PDF_CALL fntGetTextWidth(const PFNT* IFont, const BYTE* Text, UI32 Len, float CharSpacing, float WordSpacing, float TextScale);
PDF_EXP UI32   PDF_CALL fntTranslateRawCode(const PFNT* IFont, const BYTE* Text, UI32 Len, double ADDR Width, UI16 OutText[32], SI32 ADDR OutLen, LBOOL ADDR Decoded, float CharSpacing, float WordSpacing, float TextScale);
PDF_EXP SI32   PDF_CALL fntTranslateString(struct TPDFStack* Stack, UI16* Buffer, UI32 Size, UI32 Flags);
PDF_EXP SI32   PDF_CALL fntTranslateString2(const PFNT* IFont, const BYTE* Text, UI32 Len, UI16* OutText, UI32 Size, UI32 Flags);

/* ---------------------------------------- Rendering functions  ---------------------------------------- */

PDF_EXP void   PDF_CALL rasAbort(IRAS* RasPtr);
PDF_EXP LBOOL  PDF_CALL rasAttachImageBuffer(IRAS* RasPtr, BYTE** Rows, BYTE* Buffer, UI32 Width, UI32 Height, SI32 ScanlineLen);
PDF_EXP void   PDF_CALL rasCalcPagePixelSize(IPGE* PagePtr, TPDFPageScale DefScale, float Scale, UI32 FrameWidth, UI32 FrameHeight, TRasterFlags Flags, UI32* Width, UI32* Height);
PDF_EXP IRAS*  PDF_CALL rasCreateRasterizer(const PPDF* IPDF, BYTE** Rows, BYTE* Buffer, UI32 Width, UI32 Height, SI32 ScanlineLen, TPDFPixFormat PixFmt);
PDF_EXP IRAS*  PDF_CALL rasCreateRasterizerEx(const PPDF* IPDF, const void* DC, UI32 Width, UI32 Height, TPDFPixFormat PixFmt);
PDF_EXP void   PDF_CALL rasDeleteRasterizer(IRAS** RasPtr);
PDF_EXP LBOOL  PDF_CALL rasGetWidthHeight(IPGE* PagePtr, TRasterFlags Flags, float* Width, float* Height, SI32 Rotate, struct TFltRect** BBox);
PDF_EXP void   PDF_CALL rasRedraw(IRAS* RasPtr, const void* DC, SI32 DestX, SI32 DestY);
PDF_EXP LBOOL  PDF_CALL rasResizeBitmap(IRAS* RasPtr, const void* DC, UI32 Width, UI32 Height);
PDF_EXP void   PDF_CALL rasSetMinLineWidth2(IRAS* RasPtr, float Value);
PDF_EXP void   PDF_CALL rasSetScreenRes(IRAS* RasPtr, UI32 Value);

/* -------------------------------------------- Page Cache  --------------------------------------------- */

#ifndef WINDOWS_METRO

   /* ------------------------------------- Page Cache V1 -------------------------------------- */
   PDF_EXP void            PDF_CALL rasChangeBackColor(IPGC* CachePtr, UI32 Value);
   PDF_EXP void            PDF_CALL rasCloseFile(IPGC* CachePtr);
   PDF_EXP IPGC*           PDF_CALL rasCreatePageCache(const PPDF* IPDF, TPDFPixFormat PixFmt, UI32 HBorder, UI32 VBorder, UI32 BackColor);
   PDF_EXP void            PDF_CALL rasDeletePageCache(IPGC** CachePtr);
   PDF_EXP TUpdBmkAction   PDF_CALL rasExecBookmark(IPGC* CachePtr, UI32 Handle, SI32* NewX, SI32* NewY, float* NewZoom, TPDFPageScale* NewPageScale, void* Action);
   PDF_EXP SI32            PDF_CALL rasGetCurrPage(IPGC* CachePtr);
   PDF_EXP float           PDF_CALL rasGetCurrZoom(IPGC* CachePtr);
   PDF_EXP TPageLayout     PDF_CALL rasGetDefPageLayout(IPGC* CachePtr);
   PDF_EXP SI32            PDF_CALL rasGetPageAt(IPGC* CachePtr, SI32 ScrollX, SI32 ScrollY, SI32 X, SI32 Y);
   PDF_EXP TPageLayout     PDF_CALL rasGetPageLayout(IPGC* CachePtr);
   PDF_EXP SI32            PDF_CALL rasGetPageMatrix(IPGC* CachePtr, SI32 CursorX, SI32 CursorY, SI32* DestX, SI32* DestY, SI32* Width, SI32* Height, struct TCTM* Matrix);
   PDF_EXP TPDFPageScale   PDF_CALL rasGetPageScale(IPGC* CachePtr);
   PDF_EXP SI32            PDF_CALL rasGetRotate(IPGC* CachePtr);
   PDF_EXP UI32            PDF_CALL rasGetScrollLineDelta(IPGC* CachePtr, LBOOL Vertical);
   PDF_EXP SI32            PDF_CALL rasGetScrollPos(IPGC* CachePtr, LBOOL Vertical, UI32 PageNum);
   PDF_EXP LBOOL           PDF_CALL rasGetScrollRange(IPGC* CachePtr, LBOOL Vertical, SI32* Max, SI32* SmallChange, SI32* LargeChange);
   PDF_EXP SI32            PDF_CALL rasInitBaseObjects(IPGC* CachePtr, SI32 Width, SI32 Height, TInitCacheFlags Flags);
   PDF_EXP LBOOL           PDF_CALL rasInitColorManagement(IPGC* CachePtr, struct TPDFColorProfiles* Profiles, TPDFInitCMFlags Flags);
   PDF_EXP LBOOL           PDF_CALL rasInitialize(IPGC* CachePtr, TPDFThreadPriority Priority);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseDown(IPGC* CachePtr, SI32 X, SI32 Y);
   PDF_EXP TUpdScrollbar   PDF_CALL rasMouseMove(IPGC* CachePtr, const void* hWnd, LBOOL LeftBtnDown, SI32* ScrollX, SI32* ScrollY, SI32 X, SI32 Y);
   PDF_EXP TUpdScrollbar   PDF_CALL rasPaint(IPGC* CachePtr, const void* DC, SI32* ScrollX, SI32* ScrollY);
   PDF_EXP void            PDF_CALL rasResetMousePos(IPGC* CachePtr);
   PDF_EXP LBOOL           PDF_CALL rasResize(IPGC* CachePtr, SI32 Width, SI32 Height);
   PDF_EXP LBOOL           PDF_CALL rasProcessErrors(IPGC* CachePtr);
   PDF_EXP TUpdScrollbar   PDF_CALL rasScroll(IPGC* CachePtr, LBOOL Vertical, SI32 ScrollCode, SI32* ScrollX, SI32* ScrollY);
   PDF_EXP SI32            PDF_CALL rasSetCMapDirA(IPGC* CachePtr, const char* Path, TLoadCMapFlags Flags);
   PDF_EXP SI32            PDF_CALL rasSetCMapDirW(IPGC* CachePtr, const UI16* Path, TLoadCMapFlags Flags);
   PDF_EXP void            PDF_CALL rasSetDefPageLayout(IPGC* CachePtr, TPageLayout Value);
   PDF_EXP LBOOL           PDF_CALL rasSetMinLineWidth(IPGC* CachePtr, float Value);
   PDF_EXP LBOOL           PDF_CALL rasSetOCGState(IPGC* CachePtr, UI32 Handle, LBOOL On, LBOOL SaveState);
   PDF_EXP void            PDF_CALL rasSetOnPaintCallback(IPGC* CachePtr, const void* UserData, TOnUpdateWindow* Callback);
   PDF_EXP void            PDF_CALL rasSetPageLayout(IPGC* CachePtr, TPageLayout Value);
   PDF_EXP void            PDF_CALL rasSetPageScale(IPGC* CachePtr, TPDFPageScale Value);
   PDF_EXP void            PDF_CALL rasSetRotate(IPGC* CachePtr, SI32 Value);
   PDF_EXP LBOOL           PDF_CALL rasSetScrollLineDelta(IPGC* CachePtr, LBOOL Vertical, UI32 Value);
   PDF_EXP void            PDF_CALL rasSetThreadPriority(IPGC* CachePtr, TPDFThreadPriority UpdateThread, TPDFThreadPriority RenderThread);
   PDF_EXP LBOOL           PDF_CALL rasZoom(IPGC* CachePtr, float Value, SI32* HorzPos, SI32* VertPos);

   /* ------------------------------------- Page Cache V2 -------------------------------------- */
   PDF_EXP void            PDF_CALL rasClearSelection(IPGC* CachePtr);
   PDF_EXP LBOOL           PDF_CALL rasCopyToClipBoard(IPGC* CachePtr, const void* hWnd, TSelectObjType SelectedObjType, UI32 Flags);
   PDF_EXP SI32            PDF_CALL rasCreateAnnotFromControl(IPGC* CachePtr, const UI16* Author, const UI16* Comment);
   PDF_EXP LBOOL           PDF_CALL rasCreateControl(IPGC** CachePtr, struct TPDFControl* Value);
   PDF_EXP TUpdBmkAction   PDF_CALL rasExecAction(IPGC** CachePtr, struct TPDFActionContext* Ctx);
   PDF_EXP TSelectObjType  PDF_CALL rasGetObjTypeAt(IPGC* CachePtr, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP LBOOL           PDF_CALL rasGetOption(IPGC* CachePtr, TPageCacheOptions Option, SI32* Value);
   PDF_EXP SI32            PDF_CALL rasGetPageAt(IPGC* CachePtr, SI32 ScrollX, SI32 ScrollY, SI32 X, SI32 Y);
   PDF_EXP LBOOL           PDF_CALL rasGetPagePos(IPGC* CachePtr, SI32 PageNum, SI32* X, SI32* Y);
   PDF_EXP SI32            PDF_CALL rasGetRotate(IPGC* CachePtr);
   PDF_EXP TSelectObjType  PDF_CALL rasGetSelectionMode(IPGC* CachePtr);
   PDF_EXP SI32            PDF_CALL rasGetSelRect(IPGC* CachePtr, struct TIntRect* Value);
   PDF_EXP SI32            PDF_CALL rasGetSelRectPDF(IPGC* CachePtr, struct TBBox* Value);
   PDF_EXP LBOOL           PDF_CALL rasHaveSelectedText(IPGC* CachePtr);
   PDF_EXP LBOOL           PDF_CALL rasHighlightText(IPGC* CachePtr, TAnnotType SubType, UI32 Color, const UI16* Author);
   PDF_EXP TPDFCursor      PDF_CALL rasKeyStroke(IPGC* CachePtr, LBOOL Down, UI32 CharCode, UI32 ShiftState);
   PDF_EXP void            PDF_CALL rasLock(IPGC* CachePtr);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseDblClick(IPGC* CachePtr, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseDown2(IPGC* CachePtr, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TUpdScrollbar   PDF_CALL rasMouseMove2(IPGC* CachePtr, const void* hWnd, TPDFMouseKeys Keys, SI32* ScrollX, SI32* ScrollY, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseUp2(IPGC* CachePtr, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP SI32            PDF_CALL rasPixToPDF(IPGC* CachePtr, SI32 X, SI32 Y, double* OutX, double* OutY);
   PDF_EXP void            PDF_CALL rasSelectAll(IPGC* CachePtr, TSelectObjType ObjTypes);
   PDF_EXP TUpdBmkAction   PDF_CALL rasSelectAnnotOrField(IPGC* CachePtr, UI32 Handle, LBOOL IsField, UI32 SelColor, float* NewX, float* NewY, float* NewZoom, TPDFPageScale* NewPageScale);
   PDF_EXP TSelObjAction   PDF_CALL rasSelectObject(IPGC* CachePtr, LBOOL Down, SI32 X, SI32 Y, UI32 SelColor, struct TPDFObjectInfo* Info);
   PDF_EXP void            PDF_CALL rasSetClientRect(IPGC* CachePtr, const void* DC, struct TIntRect* Value);
   PDF_EXP LBOOL           PDF_CALL rasSetOption(IPGC* CachePtr, TPageCacheOptions Option, SI32 Value);
   PDF_EXP void            PDF_CALL rasSetSelectionMode(IPGC* CachePtr, TSelectObjType Value);
   PDF_EXP void            PDF_CALL rasSetWindowHandle(IPGC* CachePtr, const void* hWnd);
   PDF_EXP void            PDF_CALL rasUnLock(IPGC* CachePtr);
   PDF_EXP void            PDF_CALL rasUpdate(IPGC* CachePtr, SI32 PageNum);

   /* ------------------------------------- Page Cache V3 -------------------------------------- */

   // The operator is encoded in TI32Point. Decode the type as follows:
   //  op = (p.x & (1<<30) | ((p.y & (1<<30) << 1);
   typedef enum TPDFShapeOP
   {
      spMoveTo    = 0,
      spLineTo    = 1,
      spRectangle = 2,
      spEllipse   = 3,
      spCoordMask = 0xFFFFFFFF &~(1<<30)
   }TPDFShapeOP;

   typedef enum TPDFPathType
   {
      ptQuadPoint  = 0x00000000, // Default
      ptEllipse    = 0x00000001, // Start and end point.
      ptPath       = 0x00000002, // Array of TI32Point. The operator type (TPDFShapeOP) is encoded in bit 30 of x and y.
      ptPolygon    = 0x00000003, // Array of TI32Point. The path must be closed.
      ptPolyLine   = 0x00000004, // Array of TI32Point.
      ptRectangle  = 0x00000005, // Start and end point.
      ptFillPath   = 0x00010000, // Fill path flag
      ptStrokePath = 0x00020000  // Stroke path flag
   }TPDFPathType;

   struct TPDFObjSelPath
   {
      UI32              StructSize;   // Must be set to sizeof(TPDFObjSelPath)
      struct TIntRect   BBox;         // Bounding box (24.8 fixed integer)
      SI32              First;        // Text selection only. First quad point that must be rendered. Note that this value must be divided by 4.
      SI32              Last;         // Text selection only. Last quad point that must be rendered. Note that this value must be divided by 4.
      float             LineWidth;    // Line width of stroked paths. This value was passed to CreatePDFControl().
      const void*       Path;         // The data type depends on PathType. By default quad points are returned. Make a typecast to TI32QuadPoint or TI32Point depending on PathType;
      UI32              PathSize;     // Note that this is the number of quad points or points, depending on PathType.
      TPDFPathType      PathType;     // Specifies how Path must be interpreted. ptQuadPoints = TI32QuadPoint, TI32Point otherwise.
      struct TI32Point* SizeGrip;     // If the control size can be changed, then we must draw a size grip around the base path.
      UI32              SizeGripSize; // Number of points in the path.
      UI32              PageWidth;    // The scaled page width for which this selection was created.
   };

   typedef enum TPDFTileFlags
   {
      tfrDefault        = 0,
      tfrSkipSelAreas   = 1, // Should be set when rendering tiles
      tfrNoUpdateEvents = 2  // Should be set if a page has already a bitmap, e.g. when resizing or zooming.
   }TPDFTileFlags;

   typedef enum TPDFCtrlType
   {
      pctNotInitialized,
      pctPDFCanvas,
      pctThumbCtrl
   }TPDFCtrlType;

   struct TPDFTile
   {
      UI32          StructSize;  // Must be set to sizeof(TPDFTile)
      struct TBBox  DstRect;     // Destination rectangle
      TPDFTileFlags Flags;       // Certain flags
      UI32          IndexX;      // Horizontal tile index
      UI32          IndexY;      // Vertical tile index
      UI32          PageW;       // Scaled page width in pixel
      float         Scale;       // Scaling factor of this tile
      float         SrcX;        // Source x-coordinate
      float         SrcY;        // Source y-coordinate
      UI32          TileH;       // Height in pixels
      UI32          TileW;       // Width in pixels
      const void*   UsrCtrl;     // User defined pointer
      TPDFCtrlType  UsrCtrlType; // User defined control type. The control type is considered by RenderTile(), AbortInvisible(), and AbortTile().
      const void*   UsrPage;     // User defined pointer
      UI32          Zoom;        // Quantized zoom factor
   };

   // This flag can be combined with the page number in non-tile mode as follows:
   //   rasGetPageInfo(m_Cache, PageNum | PDF_GET_TILE_INFO, &info);
   #define PDF_GET_TILE_INFO 0x10000000

   struct TPDFPageInfo
   {
      UI32             StructSize;  // Must be set to sizeof(TPDFPageInfo)
      float*           Cols;        // Column widths
      UI32             ColsCount;   // Number of columns
      float            DestH;       // Scaled height
      float            DestW;       // Scaled width
      float            DestX;       // Destination coordinate
      float            DestY;       // Destination coordinate
      float            IncY;        // Increment the destination y-coordinate by this value.
      LBOOL            NextRow;     // If true, add the divider height to the y-coordinate.
      UI32             PixH;        // Height in pixels
      UI32             PixW;        // Width in pixels
      float*           Rows;        // Row heights
      UI32             RowsCount;   // Number of rows
      UI32             TileH;       // The tile height of the page
      struct TPDFTile* Tiles;       // Tile array
      UI32             TileW;       // The tile width of the page
      UI32             Zoom;        // Quantized zoom factor
   };

   struct TPDFRasInfo
   {
      UI32   StructSize;
      void*  BmpInfo; // BITMAPINFO on Windows, NULL otherwise.
      BYTE*  Buffer;  // Either Buffer or Rows is set
      UI32   Height;  // Bitmap height
      BYTE** Rows;    // Either Buffer or Rows is set
      SI32   Stride;  // Scanline length in bytes
      UI32   Width;   // bitmap width
   };

   typedef void PDF_CALL TPDFDisplayTile(const void* UserData, UI32 NRows, UI32 NCols, struct TPDFTile* Tile);

   PDF_EXP void            PDF_CALL rasAbortInvisible(IPGC* CachePtr, TPDFCtrlType CtrlType, SI32 FirstVisible, SI32 LastVisible);
   PDF_EXP void            PDF_CALL rasAbortTile(IPGC* CachePtr, TPDFCtrlType CtrlType, UI32 PageNum, UI32 IndexX, UI32 IndexY, UI32 Zoom);
   PDF_EXP LBOOL           PDF_CALL rasAppend(IPGC* CachePtr);
   PDF_EXP void            PDF_CALL rasCalcMaxima(IPGC* CachePtr, SI32 FirstPage, SI32 LastPage);
   PDF_EXP IPGC*           PDF_CALL rasCreatePageCacheV3(const PPDF* IPDF, TPDFPixFormat PixFmt, float ScreenScale, float Divider, UI32 TileWidth, UI32 TileHeight);
   PDF_EXP LBOOL           PDF_CALL rasDeletePage(IPGC* CachePtr, UI32 PageNum);
   PDF_EXP LBOOL           PDF_CALL rasExchangePages(IPGC* CachePtr, UI32 First, UI32 Second);
   PDF_EXP LBOOL           PDF_CALL rasGetBaseControlSize(IPGC* CachePtr, struct TI32Point* Value);
   PDF_EXP LBOOL           PDF_CALL rasGetCurrTile(IPGC* CachePtr, struct TPDFTile* Tile);
   PDF_EXP TSelectObjType  PDF_CALL rasGetObjTypeAtV3(IPGC* CachePtr, UI32 PageNum, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP LBOOL           PDF_CALL rasGetPageInfo(IPGC* CachePtr, UI32 PageNum, struct TPDFPageInfo* Value);
   PDF_EXP LBOOL           PDF_CALL rasGetRasInfo(IPGC* CachePtr, struct TPDFRasInfo* Info);
   PDF_EXP const UI16*     PDF_CALL rasGetSelectedText(IPGC* CachePtr, UI32* Size);
   PDF_EXP LBOOL           PDF_CALL rasGetSelectionPath(IPGC* CachePtr, UI32 PageNum, struct TPDFObjSelPath* Value);
   PDF_EXP LBOOL           PDF_CALL rasHaveSelection(IPGC* CachePtr);
   PDF_EXP SI32            PDF_CALL rasInitBaseObjectsV3(IPGC* CachePtr, TPDFDisplayTile* DisplayTile, const void* UserData, float Width, float Height, TInitCacheFlags Flags);
   PDF_EXP LBOOL           PDF_CALL rasInitMainTile(IPGC* CachePtr, const void* Buffer, UI32 Width, UI32 Height, SI32 Stride, TPDFPixFormat PixFmt);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseDblClickV3(IPGC* CachePtr, UI32 PageNum, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseDown3(IPGC* CachePtr, UI32 PageNum, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TUpdScrollbar   PDF_CALL rasMouseMove3(IPGC* CachePtr, TPDFMouseKeys Keys, UI32 PageNum, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP TPDFCursor      PDF_CALL rasMouseUp3(IPGC* CachePtr, UI32 PageNum, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP LBOOL           PDF_CALL rasMovePage(IPGC* CachePtr, UI32 Source, UI32 Dest);
   PDF_EXP LBOOL           PDF_CALL rasRenderTile(IPGC* CachePtr, UI32 PageNum, UI32 PageW, UI32 PageH, UI32 NRows, UI32 NCols, struct TPDFTile* Tile);
   PDF_EXP void            PDF_CALL rasResizeViewport(IPGC* CachePtr, float Width, float Height);
   PDF_EXP TSelObjAction   PDF_CALL rasSelectObjectV3(IPGC* CachePtr, UI32 PageNum, LBOOL Down, SI32 X, SI32 Y, struct TPDFObjectInfo* Info);
   PDF_EXP void            PDF_CALL rasSetBaseControlSize(IPGC* CachePtr, SI32 Width, SI32 Height);

#endif

/* --------------------------------------------- Table API ---------------------------------------------- */

#ifdef __cplusplus
   struct ITBL; // Table object
#else
   typedef void ITBL;
#endif

typedef enum TCellContType
{
   cctText,
   cctImage,
   cctTable,
   cctTemplate,
   cctAction
}TCellContType;

typedef enum TDeleteContent
{
   dcText       = 0x00000001, // Text is always a foreground object
   dcImage      = 0x00000002,
   dcTemplate   = 0x00000004, // Templates can contain imported PDF pages, contents from EMF files and anything else that can be drawn into a template
   dcTable      = 0x00000008,
   dcAction     = 0x00000010, // A cell action is always a background object
   dcAllCont    = 0x0000001F, // Delete all content types
   dcForeGround = 0x10000000,
   dcBackGround = 0x20000000,
   dcBoth       = 0x30000000  // Delete both foreground and background objects
}TDeleteContent;

typedef enum TCellAlign
{
   coLeft   = 0,
   coTop    = coLeft,
   coRight  = 1,
   coBottom = coRight,
   coCenter = 2
}TCellAlign;

typedef enum TCellSide
{
   csLeft,
   csBottom,
   csRight,
   csTop
}TCellSide;

typedef enum TColumnAdjust
{
   coaUniqueWidth, // Set the column widths uniquely to TableWidth / NumColumns
   coaAdjLeft,     // Decrease or increase the column widths starting from the left side
   coaAdjRight     // Decrease or increase the column widths starting from the right side
}TColumnAdjust;

typedef enum TTableColor
{
   tcBackColor     = 0, // Table, Columns, Rows, Cells -> default none (transparent)
   tcBorderColor   = 1, // Table, Columns, Rows, Cells -> default black
   tcGridHorzColor = 2, // Table                       -> default black
   tcGridVertColor = 3, // Table                       -> default black
   tcImageColor    = 4, // Table, Columns, Rows, Cells -> default RGB black
   tcTextColor     = 5  // Table, Columns, Rows, Cells -> default black
}TTableColor;

typedef enum TTableBoxProperty
{
   tbpBorderWidth = 0, // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
   tbpCellSpacing = 1, // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
   tbpCellPadding = 2  // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
}TTableBoxProperty;

typedef enum TTableFlags
{
   tfDefault         = 0,
   tfStatic          = 1,  // This flag marks a row, column, or cell as static to avoid the deletion of the content with ClearContent().
   tfHeaderRow       = 2,  // Header rows are drawn first after a page break occurred
   tfNoLineBreak     = 4,  // Prohibit line breaks in cells whith text -> Can be set to the entire table, columns, rows, and cells
   tfScaleToRect     = 8,  // If set, the specified output width and height represents the maximum size of the image or template.
                           // The image or template is scaled into this rectangle without changing the aspect ratio.
   tfUseImageCS      = 16, // If set, images are inserted in the native image color space.
   tfAddFlags        = 32, // If set, the new flags are added to the current ones. If absent, the new flags override the previous value.
   tfFixedTextHeight = 64  // If set, text does not increase the row height if necessary. The row height must be non-zero in this case.
}TTableFlags;

PDF_EXP SI32   PDF_CALL tblAddColumn(const ITBL* Table, LBOOL Left, float Width);
PDF_EXP SI32   PDF_CALL tblAddRow(const ITBL* Table, float Height);
PDF_EXP SI32   PDF_CALL tblAddRows(const ITBL* Table, UI32 Count, float Height);
PDF_EXP void   PDF_CALL tblClearColumn(const ITBL* Table, UI32 Col, TDeleteContent Types);
PDF_EXP void   PDF_CALL tblClearContent(const ITBL* Table, TDeleteContent Types);
PDF_EXP void   PDF_CALL tblClearRow(const ITBL* Table, UI32 Row, TDeleteContent Types);
PDF_EXP ITBL*  PDF_CALL tblCreateTable(const PPDF* IPDF, UI32 AllocRows, UI32 NumCols, float Width, float DefRowHeight);
PDF_EXP void   PDF_CALL tblDeleteCol(const ITBL* Table, UI32 Col);
PDF_EXP void   PDF_CALL tblDeleteRow(const ITBL* Table, UI32 Row);
PDF_EXP void   PDF_CALL tblDeleteRows(const ITBL* Table);
PDF_EXP void   PDF_CALL tblDeleteTable(ITBL** Table);
PDF_EXP float  PDF_CALL tblDrawTable(const ITBL* Table, float x, float y, float MaxHeight);
PDF_EXP SI32   PDF_CALL tblGetFirstRow(const ITBL* Table);
PDF_EXP SI32   PDF_CALL tblGetFlags(const ITBL* Table, SI32 Row, SI32 Col);
PDF_EXP float  PDF_CALL tblGetNextHeight(const ITBL* Table, float MaxHeight, SI32* NextRow);
PDF_EXP SI32   PDF_CALL tblGetNextRow(const ITBL* Table);
PDF_EXP SI32   PDF_CALL tblGetNumCols(const ITBL* Table);
PDF_EXP SI32   PDF_CALL tblGetNumRows(const ITBL* Table);
PDF_EXP void*  PDF_CALL tblGetPDFInstance(const ITBL* Table);
PDF_EXP float  PDF_CALL tblGetTableHeight(const ITBL* Table);
PDF_EXP float  PDF_CALL tblGetTableWidth(const ITBL* Table);
PDF_EXP LBOOL  PDF_CALL tblHaveMore(const ITBL* Table);
PDF_EXP LBOOL  PDF_CALL tblSetBoxProperty(const ITBL* Table, SI32 Row, SI32 Col, TTableBoxProperty Type, float Left, float Right, float Top, float Bottom);
PDF_EXP LBOOL  PDF_CALL tblSetCellAction(const ITBL* Table, SI32 Row, SI32 Col, UI32 ActionHandle, THighlightMode Mode);
PDF_EXP LBOOL  PDF_CALL tblSetCellDashPattern(const ITBL* Table, SI32 Row, SI32 Col, TCellSide Side, TLineCapStyle Style, const float* Dash, UI32 NumValues, float Phase);
PDF_EXP LBOOL  PDF_CALL tblSetCellImageA(const ITBL* Table, SI32 Row, SI32 Col, LBOOL ForeGround, TCellAlign HAlign, TCellAlign VAlign, float Width, float Height, const char* Image, UI32 Index);
PDF_EXP LBOOL  PDF_CALL tblSetCellImageW(const ITBL* Table, SI32 Row, SI32 Col, LBOOL ForeGround, TCellAlign HAlign, TCellAlign VAlign, float Width, float Height, const UI16* Image, UI32 Index);
PDF_EXP LBOOL  PDF_CALL tblSetCellImageEx(const ITBL* Table, SI32 Row, SI32 Col, LBOOL ForeGround, TCellAlign HAlign, TCellAlign VAlign, float Width, float Height, const void* Buffer, UI32 BufSize, UI32 Index);
PDF_EXP LBOOL  PDF_CALL tblSetCellOrientation(const ITBL* Table, SI32 Row, SI32 Col, SI32 Orientation);
PDF_EXP LBOOL  PDF_CALL tblSetCellTable(const ITBL* Table, UI32 Row, UI32 Col, TCellAlign HAlign, TCellAlign VAlign, const ITBL* SubTable);
PDF_EXP LBOOL  PDF_CALL tblSetCellTemplate(const ITBL* Table, SI32 Row, SI32 Col, LBOOL ForeGround, TCellAlign HAlign, TCellAlign VAlign, UI32 TmplHandle, float Width, float Height);
PDF_EXP LBOOL  PDF_CALL tblSetCellTextA(const ITBL* Table, UI32 Row, UI32 Col, TTextAlign HAlign, TCellAlign VAlign, const char* Text, UI32 Len);
PDF_EXP LBOOL  PDF_CALL tblSetCellTextW(const ITBL* Table, UI32 Row, UI32 Col, TTextAlign HAlign, TCellAlign VAlign, const UI16* Text, UI32 Len);
PDF_EXP LBOOL  PDF_CALL tblSetColor(const ITBL* Table, SI32 Row, SI32 Col, TTableColor Type, TPDFColorSpace CS, UI32 Color);
PDF_EXP LBOOL  PDF_CALL tblSetColorEx(const ITBL* Table, SI32 Row, SI32 Col, TTableColor Type, float* Color, UI32 NumComps, TExtColorSpace CS, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL tblSetColWidth(const ITBL* Table, UI32 Col, float Width, LBOOL ExtTable);
PDF_EXP LBOOL  PDF_CALL tblSetFlags(const ITBL* Table, SI32 Row, SI32 Col, TTableFlags Flags);
PDF_EXP LBOOL  PDF_CALL tblSetFontA(const ITBL* Table, SI32 Row, SI32 Col, const char* Name, TFStyle Style, LBOOL Embed, TCodepage CP);
PDF_EXP LBOOL  PDF_CALL tblSetFontW(const ITBL* Table, SI32 Row, SI32 Col, const UI16* Name, TFStyle Style, LBOOL Embed, TCodepage CP);
PDF_EXP LBOOL  PDF_CALL tblSetFontSelMode(const ITBL* Table, SI32 Row, SI32 Col, TFontSelMode Mode);
PDF_EXP LBOOL  PDF_CALL tblSetFontSize(const ITBL* Table, SI32 Row, SI32 Col, float Value);
PDF_EXP LBOOL  PDF_CALL tblSetGridWidth(const ITBL* Table, float Horz, float Vert);
PDF_EXP void   PDF_CALL tblSetPDFInstance(const ITBL* Table, const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL tblSetRowHeight(const ITBL* Table, UI32 Row, float Value);
PDF_EXP void   PDF_CALL tblSetTableWidth(const ITBL* Table, float Value, TColumnAdjust AdjustType, float MinColWidth);

/* ----------------------------------------- DynaPDF functions ------------------------------------------ */

typedef enum TRichmediaFlags
{
   rmfDefault               = 0, // Enable the annotation on click, deaktivate it by user action or script.
   rmfActivateOnFocus       = 1, // If set, the annotation is activated as soon the page receives focus as current page.
   rmfActivateOnVisible     = 2, // If set, the annotation is activated as soon the page becomes visible.
   rmfDeactivateOnLostFocus = 4, // If set, the annotation is deactivated as soon the page loses focus.
   rmfDeactivateOnInvisible = 8  // If set, the annotation is deactivated as soon the page becomes invisible.
}TRichmediaFlags;

typedef enum TRichMediaType
{
   rmtUnknown,
   rmtFlash,
   rmtSound,
   rmtVideo,
   rmt3D
}TRichMediaType;

//PDF_EXP LBOOL  PDF_CALL pdfAddRichMediaAssetA(const PPDF* IPDF, UI32 Annot, const char* FileName, TRichMediaType Type);
//PDF_EXP LBOOL  PDF_CALL pdfAddRichMediaAssetW(const PPDF* IPDF, UI32 Annot, const UI16* FileName, TRichMediaType Type);
//PDF_EXP SI32   PDF_CALL pdfRichMediaAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TRichmediaFlags Flags, const char* SWFFile, const char* Image, const char* FlashVars);
//PDF_EXP SI32   PDF_CALL pdfRichMediaAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TRichmediaFlags Flags, const UI16* SWFFile, const UI16* Image, const UI16* FlashVars);

#ifdef _DEBUG
PDF_EXP LBOOL  PDF_CALL pdfInsertSVGA(const PPDF* IPDF, const char* FileName, double PosX, double PosY, double Width, double Height, TSVGFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfInsertSVGW(const PPDF* IPDF, const UI16* FileName, double PosX, double PosY, double Width, double Height, TSVGFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfInsertSVGEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, double PosX, double PosY, double Width, double Height, TSVGFlags Flags);
#endif

PDF_EXP LBOOL  PDF_CALL pdfActivateAltFontList(const PPDF* IPDF, SI32 Handle, LBOOL EnableSysFonts);
PDF_EXP LBOOL  PDF_CALL pdfAddActionToObj(const PPDF* IPDF, TObjType ObjType, TObjEvent Event, UI32 ActHandle, UI32 ObjHandle);
PDF_EXP LBOOL  PDF_CALL pdfAddAnnotToPage(const PPDF* IPDF, UI32 PageNum, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfAddArticle(const PPDF* IPDF, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkExA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 NamedDest, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkExW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 NamedDest, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkEx2A(const PPDF* IPDF, const char* Title, SI32 Parent, const void* NamedDest, LBOOL Unicode, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfAddBookmarkEx2W(const PPDF* IPDF, const UI16* Title, SI32 Parent, const void* NamedDest, LBOOL Unicode, LBOOL Open);
PDF_EXP LBOOL  PDF_CALL pdfAddButtonImageA(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, const char* ImgFile);
PDF_EXP LBOOL  PDF_CALL pdfAddButtonImageW(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const UI16* Caption, const UI16* ImgFile);
PDF_EXP LBOOL  PDF_CALL pdfAddButtonImageEx(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, void* hBitmap);
PDF_EXP LBOOL  PDF_CALL pdfAddButtonImageEx2(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, const void* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfAddContinueTextA(const PPDF* IPDF, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfAddContinueTextW(const PPDF* IPDF, const UI16* AText);
PDF_EXP LBOOL  PDF_CALL pdfAddDeviceNProcessColorants(const PPDF* IPDF, UI32 DeviceNCS, const char** Colorants, UI32 NumColorants, TExtColorSpace ProcessCS, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfAddDeviceNSeparations(const PPDF* IPDF, UI32 DeviceNCS, const char** Colorants, UI32* SeparationCS, UI32 NumColorants);
PDF_EXP SI32   PDF_CALL pdfAddDPartNode(const PPDF* IPDF, SI32 Parent, SI32 FirstPage, SI32 LastPage, const char* DPM);
PDF_EXP LBOOL  PDF_CALL pdfAddFieldToFormAction(const PPDF* IPDF, UI32 Action, UI32 AField, LBOOL Include);
PDF_EXP LBOOL  PDF_CALL pdfAddFieldToHideAction(const PPDF* IPDF, UI32 HideAct, UI32 AField);
PDF_EXP LBOOL  PDF_CALL pdfAddFileCommentA(const PPDF* IPDF, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfAddFileCommentW(const PPDF* IPDF, const UI16* AText);
PDF_EXP SI32   PDF_CALL pdfAddFontSearchPathA(const PPDF* IPDF, const char* APath, LBOOL Recursive);
PDF_EXP SI32   PDF_CALL pdfAddFontSearchPathW(const PPDF* IPDF, const UI16* APath, LBOOL Recursive);
PDF_EXP LBOOL  PDF_CALL pdfAddHeaderFooter(const PPDF* IPDF, struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfAddImage(const PPDF* IPDF, TCompressionFilter Filter, TImageConversionFlags Flags, struct TPDFImage* Image);
PDF_EXP LBOOL  PDF_CALL pdfAddInkList(const PPDF* IPDF, UI32 InkAnnot, struct TFltPoint* Points, UI32 NumPoints);
PDF_EXP SI32   PDF_CALL pdfAddJavaScriptA(const PPDF* IPDF, const char* Name, const char* Script);
PDF_EXP SI32   PDF_CALL pdfAddJavaScriptW(const PPDF* IPDF, const char* Name, const UI16* Script);
PDF_EXP LGRP*  PDF_CALL pdfAddLayerToDisplTreeA(const PPDF* IPDF, LGRP* Parent, SI32 Layer, const char* Title);
PDF_EXP LGRP*  PDF_CALL pdfAddLayerToDisplTreeW(const PPDF* IPDF, LGRP* Parent, SI32 Layer, const UI16* Title);
PDF_EXP LBOOL  PDF_CALL pdfAddMaskImage(const PPDF* IPDF, UI32 BaseImage, const void* Buffer, UI32 BufSize, SI32 Stride, UI32 BitsPerPixel, UI32 Width, UI32 Height);
PDF_EXP LBOOL  PDF_CALL pdfAddObjectToLayer(const PPDF* IPDF, UI32 OCG, TOCObject ObjType, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfAddOCGToAppEvent(const PPDF* IPDF, UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories);
PDF_EXP SI32   PDF_CALL pdfAddOutputIntentA(const PPDF* IPDF, const char* ICCFile);
PDF_EXP SI32   PDF_CALL pdfAddOutputIntentW(const PPDF* IPDF, const UI16* ICCFile);
PDF_EXP SI32   PDF_CALL pdfAddOutputIntentEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize);
PDF_EXP SI32   PDF_CALL pdfAddPageLabelA(const PPDF* IPDF, UI32 StartRange, TPageLabelFormat Format, const char* Prefix, SI32 FirstPageNum);
PDF_EXP SI32   PDF_CALL pdfAddPageLabelW(const PPDF* IPDF, UI32 StartRange, TPageLabelFormat Format, const UI16* Prefix, SI32 FirstPageNum);
PDF_EXP LBOOL  PDF_CALL pdfAddRasImage(const PPDF* IPDF, IRAS* RasPtr, TCompressionFilter Filter);
/* These functions were incorrectly named. Please use AddOutputIntent() instead */
PDF_EXP SI32   PDF_CALL pdfAddRenderingIntentA(const PPDF* IPDF, const char* ICCFile);
PDF_EXP SI32   PDF_CALL pdfAddRenderingIntentW(const PPDF* IPDF, const UI16* ICCFile);
PDF_EXP SI32   PDF_CALL pdfAddRenderingIntentEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize);
/* --------------------------------------------------------------------------------------------------------------------------- */
PDF_EXP LBOOL  PDF_CALL pdfAddValToChoiceFieldA(const PPDF* IPDF, UI32 Field, const char* ExpValue, const char* Value, LBOOL Selected);
PDF_EXP LBOOL  PDF_CALL pdfAddValToChoiceFieldW(const PPDF* IPDF, UI32 Field, const char* ExpValue, const UI16* Value, LBOOL Selected);
PDF_EXP LBOOL  PDF_CALL pdfAppend(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfApplyAppEvent(const PPDF* IPDF, TOCAppEvent Event, LBOOL SaveResult);
PDF_EXP LBOOL  PDF_CALL pdfApplyPattern(const PPDF* IPDF, SI32 PattHandle, TColorMode ColorMode, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfApplyShading(const PPDF* IPDF, SI32 ShadHandle);
PDF_EXP LBOOL  PDF_CALL pdfAssociateEmbFile(const PPDF* IPDF, TAFDestObject DestObject, SI32 DestHandle, TAFRelationship Relationship, UI32 EmbFile);
PDF_EXP SI32   PDF_CALL pdfAttachFileA(const PPDF* IPDF, const char* FilePath, const char* Description, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfAttachFileW(const PPDF* IPDF, const UI16* FilePath, const UI16* Description, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfAttachFileExA(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const char* FileName, const char* Description, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfAttachFileExW(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const UI16* FileName, const UI16* Description, LBOOL Compress);
PDF_EXP LBOOL  PDF_CALL pdfAutoTemplate(const PPDF* IPDF, UI32 Templ, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfBeginClipPath(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfBeginContinueText(const PPDF* IPDF, double PosX, double PosY);
PDF_EXP LBOOL  PDF_CALL pdfBeginLayer(const PPDF* IPDF, UI32 OCG);
PDF_EXP LBOOL  PDF_CALL pdfBeginPageTemplate(const PPDF* IPDF, const char* Name, LBOOL UseAutoTemplates);
PDF_EXP SI32   PDF_CALL pdfBeginPattern(const PPDF* IPDF, TPatternType PatternType, TTilingType TilingType, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfBeginTemplate(const PPDF* IPDF, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfBeginTemplateEx(const PPDF* IPDF, struct TPDFRect* BBox, struct TCTM* Matrix);
PDF_EXP SI32   PDF_CALL pdfBeginTransparencyGroup(const PPDF* IPDF, double x1, double y1, double x2, double y2, LBOOL Isolated, LBOOL Knockout, TExtColorSpace CS, SI32 CSHandle);
PDF_EXP LBOOL  PDF_CALL pdfBezier_1_2_3(const PPDF* IPDF, double x1, double y1, double x2, double y2, double x3, double y3);
PDF_EXP LBOOL  PDF_CALL pdfBezier_1_3(const PPDF* IPDF, double x1, double y1, double x3, double y3);
PDF_EXP LBOOL  PDF_CALL pdfBezier_2_3(const PPDF* IPDF, double x2, double y2, double x3, double y3);
PDF_EXP double PDF_CALL pdfCalcWidthHeight(const PPDF* IPDF, double OrgWidth, double OrgHeight, double ScaledWidth, double ScaledHeight);
PDF_EXP SI32   PDF_CALL pdfCaretAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content);
PDF_EXP SI32   PDF_CALL pdfCaretAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content);
PDF_EXP LBOOL  PDF_CALL pdfChangeAnnotPos(const PPDF* IPDF, UI32 Handle, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfChangeAnnotNameA(const PPDF* IPDF, UI32 Handle, const char* Name);
PDF_EXP LBOOL  PDF_CALL pdfChangeAnnotNameW(const PPDF* IPDF, UI32 Handle, const UI16* Name);
PDF_EXP LBOOL  PDF_CALL pdfChangeBookmarkA(const PPDF* IPDF, SI32 ABmk, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open);
PDF_EXP LBOOL  PDF_CALL pdfChangeBookmarkW(const PPDF* IPDF, SI32 ABmk, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open);
PDF_EXP LBOOL  PDF_CALL pdfChangeFont(const PPDF* IPDF, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfChangeFontEx(const PPDF* IPDF, SI32 Handle, double FontSize, TFStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfChangeFontSize(const PPDF* IPDF, double Size);
PDF_EXP LBOOL  PDF_CALL pdfChangeFontStyle(const PPDF* IPDF, TFStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfChangeFontStyleEx(const PPDF* IPDF, TFStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptA(const PPDF* IPDF, UI32 Handle, const char* NewScript);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptW(const PPDF* IPDF, UI32 Handle, const UI16* NewScript);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptActionA(const PPDF* IPDF, UI32 Handle, const char* NewScript);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptActionW(const PPDF* IPDF, UI32 Handle, const UI16* NewScript);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptNameA(const PPDF* IPDF, UI32 Handle, const char* Name);
PDF_EXP LBOOL  PDF_CALL pdfChangeJavaScriptNameW(const PPDF* IPDF, UI32 Handle, const UI16* Name);
PDF_EXP LBOOL  PDF_CALL pdfChangeLinkAnnot(const PPDF* IPDF, UI32 Handle, const char* URL);
PDF_EXP LBOOL  PDF_CALL pdfChangeNamedDestA(const PPDF* IPDF, TObjType ObjType, UI32 Handle, const char* NewDestName);
PDF_EXP LBOOL  PDF_CALL pdfChangeNamedDestW(const PPDF* IPDF, TObjType ObjType, UI32 Handle, const UI16* NewDestName);
PDF_EXP LBOOL  PDF_CALL pdfChangeOCGNameA(const PPDF* IPDF, UI32 Handle, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfChangeOCGNameW(const PPDF* IPDF, UI32 Handle, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfChangeSeparationColor(const PPDF* IPDF, UI32 CSHandle, UI32 NewColor, TExtColorSpace Alternate, SI32 AltHandle);
PDF_EXP SI32   PDF_CALL pdfCheckAndRepairFonts(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfCheckCollection(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfCheckConformance(const PPDF* IPDF, TConformanceType Type, TCheckOptions Options, const void* UserData, TOnFontNotFoundProc* OnFontNotFound, TOnReplaceICCProfile* OnReplaceICCProfile);
PDF_EXP SI32   PDF_CALL pdfCheckFieldNames(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfCircleAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Comment);
PDF_EXP SI32   PDF_CALL pdfCircleAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Comment);
PDF_EXP LBOOL  PDF_CALL pdfClearAutoTemplates(const PPDF* IPDF);
PDF_EXP void   PDF_CALL pdfClearErrorLog(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfClearHostFonts(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfClipPath(const PPDF* IPDF, TClippingMode ClipMode, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfCloseAndSignFile(const PPDF* IPDF, const char* CertFile, const char* Password, const char* Reason, const char* Location);
PDF_EXP LBOOL  PDF_CALL pdfCloseAndSignFileEx(const PPDF* IPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict, const char* CertFile, const char* Password, const char* Reason, const char* Location);
PDF_EXP LBOOL  PDF_CALL pdfCloseAndSignFileExt(const PPDF* IPDF, struct TPDFSigParms* SigParms);
PDF_EXP LBOOL  PDF_CALL pdfCloseFile(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfCloseFileEx(const PPDF* IPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict);
PDF_EXP LBOOL  PDF_CALL pdfCloseImage(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfCloseImportFile(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfCloseImportFileEx(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfClosePath(const PPDF* IPDF, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfCloseTag(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfComputeBBox(const PPDF* IPDF, struct TPDFRect ADDR BBox, TCompBBoxFlags Flags);
PDF_EXP UI32   PDF_CALL pdfConvColor(const double* Color, UI32 NumComps, TExtColorSpace SourceCS, const void* IColorSpace, TExtColorSpace DestCS);
PDF_EXP LBOOL  PDF_CALL pdfConvertColors(const PPDF* IPDF, TColorConvFlags Flags, const float* Add);
PDF_EXP SI32   PDF_CALL pdfConvertEMFSpoolA(const PPDF* IPDF, const char* SpoolFile, double LeftMargin, double TopMargin, TSpoolConvFlags Flags);
PDF_EXP SI32   PDF_CALL pdfConvertEMFSpoolW(const PPDF* IPDF, const UI16* SpoolFile, double LeftMargin, double TopMargin, TSpoolConvFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfConvToFreeTextCallout(const PPDF* IPDF, UI32 Handle, float StartX, float StartY, float KneeOffset, TLineEndStyle EndStyle);
PDF_EXP UI16*  PDF_CALL pdfConvToUnicode(const PPDF* IPDF, const char* AString, TCodepage CP);
PDF_EXP LBOOL  PDF_CALL pdfCopyChoiceValues(const PPDF* IPDF, UI32 Source, UI32 Dest, LBOOL Share);
PDF_EXP SI32   PDF_CALL pdfCreate3DAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* Name, const char* U3DFile, const char* Image);
PDF_EXP SI32   PDF_CALL pdfCreate3DAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Name, const UI16* U3DFile, const UI16* Image);
PDF_EXP LBOOL  PDF_CALL pdfCreate3DBackground(const PPDF* IPDF, const I3DV* IView, UI32 BackColor);
PDF_EXP SI32   PDF_CALL pdfCreate3DGotoViewAction(const PPDF* IPDF, UI32 Base3DAnnot, const I3DV* IView, T3DNamedAction Named);
PDF_EXP LBOOL  PDF_CALL pdfCreate3DProjection(const PPDF* IPDF, const I3DV* IView, T3DProjType ProjType, T3DScaleType ScaleType, double Diameter, double FOV);
PDF_EXP I3DV*  PDF_CALL pdfCreate3DViewA(const PPDF* IPDF, UI32 Base3DAnnot, const char* Name, LBOOL SetAsDefault, double* Matrix, double CamDistance, T3DRenderingMode RM, T3DLightingSheme LS);
PDF_EXP I3DV*  PDF_CALL pdfCreate3DViewW(const PPDF* IPDF, UI32 Base3DAnnot, const UI16* Name, LBOOL SetAsDefault, double* Matrix, double CamDistance, T3DRenderingMode RM, T3DLightingSheme LS);
PDF_EXP SI32   PDF_CALL pdfCreateAltFontList(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfCreateAnnotAP(const PPDF* IPDF, UI32 Annot);
PDF_EXP SI32   PDF_CALL pdfCreateArticleThreadA(const PPDF* IPDF, const char* ThreadName);
PDF_EXP SI32   PDF_CALL pdfCreateArticleThreadW(const PPDF* IPDF, const UI16* ThreadName);
PDF_EXP SI32   PDF_CALL pdfCreateAxialShading(const PPDF* IPDF, double sX, double sY, double eX, double eY, double SCenter, UI32 SColor, UI32 EColor, LBOOL Extend1, LBOOL Extend2);
PDF_EXP SI32   PDF_CALL pdfCreateBarcodeField(const PPDF* IPDF, const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height, struct TPDFBarcode* Barcode);
PDF_EXP SI32   PDF_CALL pdfCreateButtonA(const PPDF* IPDF, const char* Name, const char* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateButtonW(const PPDF* IPDF, const char* Name, const UI16* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateCheckBox(const PPDF* IPDF, const char* Name, const char* ExpValue, LBOOL Checked, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateCIEColorSpace(const PPDF* IPDF, TExtColorSpace CS, float* WhitePoint, float* BlackPoint, float* Gamma, float* Matrix);
PDF_EXP LBOOL  PDF_CALL pdfCreateColItemDate(const PPDF* IPDF, UI32 EmbFile, const char* Key, long Date, const char* Prefix);
PDF_EXP LBOOL  PDF_CALL pdfCreateColItemNumber(const PPDF* IPDF, UI32 EmbFile, const char* Key, double Value, const char* Prefix);
PDF_EXP LBOOL  PDF_CALL pdfCreateColItemStringA(const PPDF* IPDF, UI32 EmbFile, const char* Key, const char* Value, const char* Prefix);
PDF_EXP LBOOL  PDF_CALL pdfCreateColItemStringW(const PPDF* IPDF, UI32 EmbFile, const char* Key, const UI16* Value, const UI16* Prefix);
PDF_EXP LBOOL  PDF_CALL pdfCreateCollection(const PPDF* IPDF, TColView View);
PDF_EXP SI32   PDF_CALL pdfCreateCollectionFieldA(const PPDF* IPDF, TColColumnType ColType, SI32 Column, const char* Name, const char* Key, LBOOL Visible, LBOOL Editable);
PDF_EXP SI32   PDF_CALL pdfCreateCollectionFieldW(const PPDF* IPDF, TColColumnType ColType, SI32 Column, const UI16* Name, const char* Key, LBOOL Visible, LBOOL Editable);
PDF_EXP SI32   PDF_CALL pdfCreateComboBox(const PPDF* IPDF, const char* Name, LBOOL Sort, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateDeviceNColorSpace(const PPDF* IPDF, const char** Colorants, UI32 NumColorants, const char* PostScriptFunc, TExtColorSpace Alternate, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfCreateDPartRoot(const PPDF* IPDF, const char** NodeNameList, UI32 NodeNamesCount, SI32 RecordLevel);
PDF_EXP SI32   PDF_CALL pdfCreateExtGState(const PPDF* IPDF, struct TPDFExtGState* GS);
PDF_EXP SI32   PDF_CALL pdfCreateGeospatialMeasure(const PPDF* IPDF, UI32 Viewport, const char* Attributes);
PDF_EXP SI32   PDF_CALL pdfCreateGoToAction(const PPDF* IPDF, TDestType DestType, UI32 PageNum, double a, double b, double c, double d);
PDF_EXP SI32   PDF_CALL pdfCreateGoToActionEx(const PPDF* IPDF, UI32 NamedDest);
PDF_EXP SI32   PDF_CALL pdfCreateGoToEActionA(const PPDF* IPDF, TEmbFileLocation Location, const char* Source, UI32 SrcPage, const char* Target, const char* DestName, UI32 DestPage, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGoToEActionW(const PPDF* IPDF, TEmbFileLocation Location, const UI16* Source, UI32 SrcPage, const UI16* Target, const UI16* DestName, UI32 DestPage, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionA(const PPDF* IPDF, const char* FileName, UI32 PageNum);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionW(const PPDF* IPDF, const UI16* FileName, UI32 PageNum);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionExA(const PPDF* IPDF, const char* FileName, const char* DestName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionExW(const PPDF* IPDF, const char* FileName, const UI16* DestName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionExUA(const PPDF* IPDF, const UI16* FileName, const char* DestName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGoToRActionExUW(const PPDF* IPDF, const UI16* FileName, const UI16* DestName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateGroupField(const PPDF* IPDF, const char* Name, SI32 Parent);
PDF_EXP SI32   PDF_CALL pdfCreateHideAction(const PPDF* IPDF, UI32 AField, LBOOL Hide);
PDF_EXP SI32   PDF_CALL pdfCreateICCBasedColorSpaceA(const PPDF* IPDF, const char* ICCProfile);
PDF_EXP SI32   PDF_CALL pdfCreateICCBasedColorSpaceW(const PPDF* IPDF, const UI16* ICCProfile);
PDF_EXP SI32   PDF_CALL pdfCreateICCBasedColorSpaceEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfCreateImageA(const PPDF* IPDF, const char* FileName, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfCreateImageW(const PPDF* IPDF, const UI16* FileName, TImageFormat Format);
PDF_EXP SI32   PDF_CALL pdfCreateImpDataActionA(const PPDF* IPDF, const char* DataFile);
PDF_EXP SI32   PDF_CALL pdfCreateImpDataActionW(const PPDF* IPDF, const UI16* DataFile);
PDF_EXP SI32   PDF_CALL pdfCreateIndexedColorSpace(const PPDF* IPDF, TExtColorSpace Base, SI32 Handle, const void* ColorTable, UI32 NumColors);
PDF_EXP SI32   PDF_CALL pdfCreateJSActionA(const PPDF* IPDF, const char* Script);
PDF_EXP SI32   PDF_CALL pdfCreateJSActionW(const PPDF* IPDF, const UI16* Script);
PDF_EXP SI32   PDF_CALL pdfCreateLaunchAction(const PPDF* IPDF, TFileOP OP, const char* FileName, const char* DefDir, const char* Param, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateLaunchActionExA(const PPDF* IPDF, const char* FileName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateLaunchActionExW(const PPDF* IPDF, const UI16* FileName, LBOOL NewWindow);
PDF_EXP SI32   PDF_CALL pdfCreateListBox(const PPDF* IPDF, const char* Name, LBOOL Sort, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateNamedAction(const PPDF* IPDF, TNamedAction Action);
PDF_EXP SI32   PDF_CALL pdfCreateNamedDestA(const PPDF* IPDF, const char* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d);
PDF_EXP SI32   PDF_CALL pdfCreateNamedDestW(const PPDF* IPDF, const UI16* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d);
PDF_EXP LBOOL  PDF_CALL pdfCreateNewPDFA(const PPDF* IPDF, const char* OutPDF);
PDF_EXP LBOOL  PDF_CALL pdfCreateNewPDFW(const PPDF* IPDF, const UI16* OutPDF);
PDF_EXP SI32   PDF_CALL pdfCreateOCGA(const PPDF* IPDF, const char* Name, LBOOL DisplayInUI, LBOOL Visible, TOCGIntent Intent);
PDF_EXP SI32   PDF_CALL pdfCreateOCGW(const PPDF* IPDF, const UI16* Name, LBOOL DisplayInUI, LBOOL Visible, TOCGIntent Intent);
PDF_EXP SI32   PDF_CALL pdfCreateOCMD(const PPDF* IPDF, TOCVisibility Visibility, UI32* OCGs, UI32 Count);
PDF_EXP SI32   PDF_CALL pdfCreateRadialShading(const PPDF* IPDF, double sX, double sY, double R1, double eX, double eY, double R2, double SCenter, UI32 SColor, UI32 EColor, LBOOL Extend1, LBOOL Extend2);
PDF_EXP SI32   PDF_CALL pdfCreateRadioButton(const PPDF* IPDF, const char* Name, const char* ExpValue, SI32 Checked, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateRectilinearMeasureA(const PPDF* IPDF, UI32 Viewport, double Scale, const char* UnitDescription, const char* LabelDistance, const char* LabelArea);
PDF_EXP SI32   PDF_CALL pdfCreateRectilinearMeasureW(const PPDF* IPDF, UI32 Viewport, double Scale, const UI16* UnitDescription, const UI16* LabelDistance, const UI16* LabelArea);
PDF_EXP SI32   PDF_CALL pdfCreateResetAction(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfCreateSeparationCS(const PPDF* IPDF, const char* Colorant, TExtColorSpace Alternate, SI32 Handle, UI32 Color);
PDF_EXP SI32   PDF_CALL pdfCreateSetOCGStateAction(const PPDF* IPDF, UI32* On, UI32 OnCount, UI32* Off, UI32 OffCount, UI32* Toggle, UI32 ToggleCount, LBOOL PreserveRB);
PDF_EXP SI32   PDF_CALL pdfCreateSigField(const PPDF* IPDF, const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateSigFieldAP(const PPDF* IPDF, UI32 SigField);
PDF_EXP PSMK*  PDF_CALL pdfCreateSoftMask(const PPDF* IPDF, UI32 TranspGroup, TSoftMaskType MaskType, UI32 BackColor);
PDF_EXP SI32   PDF_CALL pdfCreateStdPattern(const PPDF* IPDF, TStdPattern Pattern, double LineWidth, double Distance, UI32 LineColor, UI32 BackColor);
PDF_EXP LBOOL  PDF_CALL pdfCreateStructureTree(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfCreateStructureTreeEx(const PPDF* IPDF, TPDFBaseTag RootTag);
PDF_EXP SI32   PDF_CALL pdfCreateSubmitAction(const PPDF* IPDF, TSubmitFlags Flags, const char* URL);
PDF_EXP SI32   PDF_CALL pdfCreateTextField(const PPDF* IPDF, const char* Name, SI32 Parent, LBOOL Multiline, SI32 MaxLen, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfCreateURIAction(const PPDF* IPDF, const char* URL);
PDF_EXP SI32   PDF_CALL pdfCreateViewportA(const PPDF* IPDF, const char* Name, double X1, double Y1, double X2, double Y2);
PDF_EXP SI32   PDF_CALL pdfCreateViewportW(const PPDF* IPDF, const UI16* Name, double X1, double Y1, double X2, double Y2);
PDF_EXP SI32   PDF_CALL pdfCreateXFAStreamA(const PPDF* IPDF, const char* Name, const void* Buffer, UI32 BufSize);
PDF_EXP SI32   PDF_CALL pdfCreateXFAStreamW(const PPDF* IPDF, const UI16* Name, const void* Buffer, UI32 BufSize);
PDF_EXP SI32   PDF_CALL pdfDecryptPDFA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* Password);
PDF_EXP SI32   PDF_CALL pdfDecryptPDFW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* Password);
PDF_EXP void   PDF_CALL pdfDeleteAcroForm(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfDeleteActionFromObj(const PPDF* IPDF, TObjType ObjType, UI32 ActHandle, UI32 ObjHandle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteActionFromObjEx(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex);
PDF_EXP LBOOL  PDF_CALL pdfDeleteAltFontList(const PPDF* IPDF, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteAnnotation(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteAnnotationFromPage(const PPDF* IPDF, UI32 PageNum, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfDeleteAppEvents(const PPDF* IPDF, LBOOL ApplyEvent, TOCAppEvent Event);
PDF_EXP SI32   PDF_CALL pdfDeleteBookmark(const PPDF* IPDF, UI32 ABmk);
PDF_EXP LBOOL  PDF_CALL pdfDeleteDPartNode(const PPDF* IPDF, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteEmbeddedFile(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteField(const PPDF* IPDF, UI32 AField);
PDF_EXP LBOOL  PDF_CALL pdfDeleteFieldEx(const PPDF* IPDF, const char* Name);
PDF_EXP void   PDF_CALL pdfDeleteJavaScripts(const PPDF* IPDF, LBOOL DelJavaScriptActions);
PDF_EXP LBOOL  PDF_CALL pdfDeleteNamedDestA(const PPDF* IPDF, const char* Name);
PDF_EXP LBOOL  PDF_CALL pdfDeleteNamedDestW(const PPDF* IPDF, const UI16* Name);
PDF_EXP LBOOL  PDF_CALL pdfDeleteNamedDestByIndex(const PPDF* IPDF, SI32 Index);
PDF_EXP LBOOL  PDF_CALL pdfDeleteOCGFromAppEvent(const PPDF* IPDF, UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories, LBOOL DelCategoryOnly);
PDF_EXP LBOOL  PDF_CALL pdfDeleteOCGFromDisplayTree(const PPDF* IPDF, UI32 OCGHandle, LBOOL Recursive);
PDF_EXP LBOOL  PDF_CALL pdfDeleteOCUINode(const PPDF* IPDF, IOCN* Node);
PDF_EXP SI32   PDF_CALL pdfDeleteOutputIntent(const PPDF* IPDF, SI32 Index);
PDF_EXP SI32   PDF_CALL pdfDeletePage(const PPDF* IPDF, UI32 PageNum);
PDF_EXP void   PDF_CALL pdfDeletePageLabels(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfDeletePDF(PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfDeleteSeparationInfo(const PPDF* IPDF, LBOOL AllPages);
PDF_EXP LBOOL  PDF_CALL pdfDeleteTemplate(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfDeleteTemplateEx(const PPDF* IPDF, UI32 Index);
PDF_EXP SI32   PDF_CALL pdfDeleteWatermark(const PPDF* IPDF, SI32 PageNum, LBOOL InclAnnots);
PDF_EXP void   PDF_CALL pdfDeleteXFAForm(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfDrawArc(const PPDF* IPDF, double PosX, double PosY, double Radius, double StartAngle, double EndAngle);
PDF_EXP LBOOL  PDF_CALL pdfDrawArcEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle);
PDF_EXP LBOOL  PDF_CALL pdfDrawChord(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfDrawCircle(const PPDF* IPDF, double PosX, double PosY, double Radius, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfDrawNGon(const PPDF* IPDF, double PosX, double PosY, double Radius, double Alpha, UI32 NumSides, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfDrawPie(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfEditPage(const PPDF* IPDF, SI32 PageNum);
PDF_EXP LBOOL  PDF_CALL pdfEditTemplate(const PPDF* IPDF, UI32 Index);
PDF_EXP LBOOL  PDF_CALL pdfEditTemplate2(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfEllipse(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfEnableImageCache(const PPDF* IPDF, UI32 MaxImageCount, UI32 Size);
PDF_EXP void   PDF_CALL pdfEnableMutex(const PPDF* IPDF, LBOOL Value);
PDF_EXP SI32   PDF_CALL pdfEncryptPDFA(const PPDF* IPDF, const char* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict);
PDF_EXP SI32   PDF_CALL pdfEncryptPDFW(const PPDF* IPDF, const UI16* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict);
PDF_EXP LBOOL  PDF_CALL pdfEndContinueText(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfEndLayer(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfEndPage(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfEndPattern(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfEndTemplate(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfEnumDocFonts(const PPDF* IPDF, const void* Data, TEnumFontProc2* EnumProc);
PDF_EXP SI32   PDF_CALL pdfEnumHostFonts(const PPDF* IPDF, const void* Data, TEnumFontProc* EnumProc);
PDF_EXP SI32   PDF_CALL pdfEnumHostFontsEx(const PPDF* IPDF, const void* Data, TEnumFontProcEx* EnumProc);
PDF_EXP LBOOL  PDF_CALL pdfExchangeBookmarks(const PPDF* IPDF, SI32 Bmk1, SI32 Bmk2);
PDF_EXP LBOOL  PDF_CALL pdfExchangePages(const PPDF* IPDF, UI32 First, UI32 Second);
PDF_EXP LBOOL  PDF_CALL pdfExtractText(const PPDF* IPDF, UI32 PageNum, TTextExtractionFlags Flags, struct TFltRect* Area, UI16** Text, UI32* TextLen);
PDF_EXP SI32   PDF_CALL pdfFileAttachAnnotA(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const char* Author, const char* Desc, const char* AFile, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfFileAttachAnnotW(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const UI16* Author, const UI16* Desc, const UI16* AFile, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfFileAttachAnnotExA(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const char* FileName, const char* Author, const char* Desc, const void* Buffer, UI32 BufSize, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfFileAttachAnnotExW(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const UI16* FileName, const UI16* Author, const UI16* Desc, const void* Buffer, UI32 BufSize, LBOOL Compress);
PDF_EXP SI32   PDF_CALL pdfFileLinkA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* AFilePath);
PDF_EXP SI32   PDF_CALL pdfFileLinkW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* AFilePath);
PDF_EXP SI32   PDF_CALL pdfFindBookmarkA(const PPDF* IPDF, SI32 DestPage, const char* Title);
PDF_EXP SI32   PDF_CALL pdfFindBookmarkW(const PPDF* IPDF, SI32 DestPage, const UI16* Title);
PDF_EXP SI32   PDF_CALL pdfFindEmbeddedFileA(const PPDF* IPDF, const char* Name);
PDF_EXP SI32   PDF_CALL pdfFindEmbeddedFileW(const PPDF* IPDF, const UI16* Name);
PDF_EXP SI32   PDF_CALL pdfFindFieldA(const PPDF* IPDF, const char* Name);
PDF_EXP SI32   PDF_CALL pdfFindFieldW(const PPDF* IPDF, const UI16* Name);
PDF_EXP LBOOL  PDF_CALL pdfFinishSignature(const PPDF* IPDF, const void* PKCS7Obj, UI32 Length);
PDF_EXP SI32   PDF_CALL pdfFindLinkAnnot(const PPDF* IPDF, const char* URL);
PDF_EXP SI32   PDF_CALL pdfFindNextBookmark(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfFlattenAnnots(const PPDF* IPDF, TAnnotFlattenFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfFlattenAnnotOrField(const PPDF* IPDF, UI32 Index, TAnnotFlattenFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfFlattenForm(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfFlushPageContent(const PPDF* IPDF, struct TPDFStack* Stack);
PDF_EXP LBOOL  PDF_CALL pdfFlushPages(const PPDF* IPDF, TFlushPageFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfFlushPagesEx(const PPDF* IPDF, TFlushPageFlags Flags, UI32 LastPage);
PDF_EXP void   PDF_CALL pdfFreeImageBuffer(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfFreeImageObj(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfFreeImageObjEx(const PPDF* IPDF, const PIMG* ImagePtr);
PDF_EXP LBOOL  PDF_CALL pdfFreePDF(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfFreeTextAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* AText, TTextAlign Align);
PDF_EXP SI32   PDF_CALL pdfFreeTextAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* AText, TTextAlign Align);
PDF_EXP LBOOL  PDF_CALL pdfFreeUniBuf(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGet3DAnnotStream(const PPDF* IPDF, UI32 Annot, BYTE** Data, UI32* Size, char** SubType);
PDF_EXP SI32   PDF_CALL pdfGetActionCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetActionHandle(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex);
PDF_EXP SI32   PDF_CALL pdfGetActionType(const PPDF* IPDF, UI32 ActHandle);
PDF_EXP SI32   PDF_CALL pdfGetActionTypeEx(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex);
PDF_EXP SI32   PDF_CALL pdfGetActiveFont(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetAllocBy(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetAnnot(const PPDF* IPDF, UI32 Handle, struct TPDFAnnotation ADDR Annot);
PDF_EXP LBOOL  PDF_CALL pdfGetAnnotBBox(const PPDF* IPDF, UI32 Handle, struct TPDFRect ADDR BBox);
PDF_EXP LBOOL  PDF_CALL pdfGetAnnotColor(const PPDF* IPDF, UI32 Handle, TAnnotColor ColorType, TPDFColorSpace* CS, UI32* Color);
PDF_EXP SI32   PDF_CALL pdfGetAnnotCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetAnnotEx(const PPDF* IPDF, UI32 Handle, struct TPDFAnnotationEx ADDR Annot);
PDF_EXP SI32   PDF_CALL pdfGetAnnotFlags(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetAnnotLink(const PPDF* IPDF, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfGetAnnotTextAlign(const PPDF* IPDF, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfGetAnnotType(const PPDF* IPDF, UI32 Handle);
PDF_EXP double PDF_CALL pdfGetAscent(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetBarcodeDict(const PBCD* IBarcode, struct TPDFBarcode* Barcode);
PDF_EXP LBOOL  PDF_CALL pdfGetBBox(const PPDF* IPDF, TPageBoundary Boundary, struct TPDFRect ADDR BBox);
PDF_EXP SI32   PDF_CALL pdfGetBidiMode(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetBookmark(const PPDF* IPDF, SI32 Handle, struct TBookmark ADDR Bmk);
PDF_EXP SI32   PDF_CALL pdfGetBookmarkCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetBookmarkEx(const PPDF* IPDF, UI32 Handle, struct TPDFBookmark* Bmk);
PDF_EXP SI32   PDF_CALL pdfGetBorderStyle(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetBuffer(const PPDF* IPDF, UI32 ADDR BufSize);
PDF_EXP double PDF_CALL pdfGetCapHeight(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetCharacterSpacing(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetCheckBoxChar(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetCheckBoxCharEx(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetCheckBoxDefState(const PPDF* IPDF, UI32 AField);
PDF_EXP LBOOL  PDF_CALL pdfGetCMap(const PPDF* IPDF, UI32 Index, struct TPDFCMap* CMap);
PDF_EXP SI32   PDF_CALL pdfGetCMapCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetCollectionInfo(const PPDF* IPDF, struct TPDFCollectionInfo* Value);
PDF_EXP SI32   PDF_CALL pdfGetColorSpace(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetColorSpaceCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetColorSpaceObj(const PPDF* IPDF, UI32 Handle, struct TPDFColorSpaceObj* CS);
PDF_EXP LBOOL  PDF_CALL pdfGetColorSpaceObjEx(const void* IColorSpace, struct TPDFColorSpaceObj* CS);
PDF_EXP SI32   PDF_CALL pdfGetCompressionFilter(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetCompressionLevel(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetContent(const PPDF* IPDF, char* ADDR Buffer);
PDF_EXP SI32   PDF_CALL pdfGetDefBitsPerPixel(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetDescent(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetDeviceNAttributes(void* IAttributes, struct TDeviceNAttributes* Attributes);
PDF_EXP SI32   PDF_CALL pdfGetDocInfo(const PPDF* IPDF, TDocumentInfo DInfo, UI16* ADDR Value);
PDF_EXP SI32   PDF_CALL pdfGetDocInfoCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetDocInfoEx(const PPDF* IPDF, UI32 Index, TDocumentInfo ADDR DInfo, char* ADDR Key, char* ADDR Value, LBOOL ADDR Unicode);
PDF_EXP LBOOL  PDF_CALL pdfGetDocUsesTransparency(const PPDF* IPDF, UI32 Flags);
PDF_EXP SI32   PDF_CALL pdfGetDrawDirection(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetDynaPDFVersion(void);
static PDF_INLINE SI32 PDF_CALL pdfGetDynaPDFVersionInt(void)
{
   const BYTE* end;
   SI32 retval = 0;
   const BYTE* ver = (const BYTE*)pdfGetDynaPDFVersion();
   if (!ver) return 0;
   end = ver;
   while (*end++) ;
   retval += pdfParseInt(&ver, end) * 10000000;
   ver += 3;
   retval += pdfParseInt(&ver, end) * 10000;
   ++ver;
   retval += pdfParseInt(&ver, end);
   return retval;
}
PDF_EXP LBOOL  PDF_CALL pdfGetEmbeddedFile(const PPDF* IPDF, UI32 Handle, struct TPDFFileSpec* FileSpec, LBOOL Decompress);
PDF_EXP SI32   PDF_CALL pdfGetEmbeddedFileCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetEmbeddedFileNode(const IEFN* IEF, struct TPDFEmbFileNode* F, LBOOL Decompress);
PDF_EXP double PDF_CALL pdfGetEMFPatternDistance(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetErrLogMessage(const PPDF* IPDF, UI32 Index, struct TPDFError* Err);
PDF_EXP SI32   PDF_CALL pdfGetErrLogMessageCount(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetErrorMessage(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetErrorMode(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetField(const PPDF* IPDF, UI32 Handle, struct TPDFField* Field);
PDF_EXP UI32   PDF_CALL pdfGetFieldBackColor(const PPDF* IPDF);
PDF_EXP UI32   PDF_CALL pdfGetFieldBorderColor(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetFieldBorderStyle(const PPDF* IPDF, UI32 AField);
PDF_EXP double PDF_CALL pdfGetFieldBorderWidth(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldCalcOrder(const PPDF* IPDF, UI32** Out);
PDF_EXP LBOOL  PDF_CALL pdfGetFieldChoiceValue(const PPDF* IPDF, UI32 AField, UI32 ValIndex, struct TPDFChoiceValue* Value);
PDF_EXP LBOOL  PDF_CALL pdfGetFieldColor(const PPDF* IPDF, UI32 AField, TFieldColor ColorType, SI32 ADDR ColorSpace, UI32 ADDR Color);
PDF_EXP SI32   PDF_CALL pdfGetFieldCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetFieldEx(const PPDF* IPDF, UI32 Handle, struct TPDFFieldEx* Field);
PDF_EXP LBOOL  PDF_CALL pdfGetFieldEx2(const IFLD* IField, struct TPDFFieldEx* Field);
PDF_EXP SI32   PDF_CALL pdfGetFieldExpValCount(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldExpValue(const PPDF* IPDF, UI32 AField, char* ADDR Value);
PDF_EXP LBOOL  PDF_CALL pdfGetFieldExpValueEx(const PPDF* IPDF, UI32 AField, UI32 ValIndex, char* ADDR Value, char* ADDR ExpValue, LBOOL ADDR Selected);
PDF_EXP SI32   PDF_CALL pdfGetFieldFlags(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldGroupType(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldHighlightMode(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldIndex(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldMapName(const PPDF* IPDF, UI32 AField, void* ADDR Value, LBOOL ADDR Unicode);
PDF_EXP SI32   PDF_CALL pdfGetFieldName(const PPDF* IPDF, UI32 AField, char* ADDR Name);
PDF_EXP SI32   PDF_CALL pdfGetFieldOrientation(const PPDF* IPDF, UI32 AField);
PDF_EXP SI32   PDF_CALL pdfGetFieldTextAlign(const PPDF* IPDF, UI32 AField);
PDF_EXP UI32   PDF_CALL pdfGetFieldTextColor(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetFieldToolTip(const PPDF* IPDF, UI32 AField, void* ADDR Value, LBOOL ADDR Unicode);
PDF_EXP SI32   PDF_CALL pdfGetFieldType(const PPDF* IPDF, UI32 AField);
PDF_EXP LBOOL  PDF_CALL pdfGetFileSpec(const IFSR* IFS, struct TPDFFileSpecEx* F);
PDF_EXP UI32   PDF_CALL pdfGetFillColor(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetFontCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetFontEx(const PPDF* IPDF, UI32 Handle, struct TPDFFontObj* F);
PDF_EXP LBOOL  PDF_CALL pdfGetFontInfoEx(const PPDF* IPDF, UI32 Handle, struct TPDFFontInfo* F);
PDF_EXP LBOOL  PDF_CALL pdfGetFontMetrics(const PPDF* IPDF, UI32 Handle, struct TPDFFontMetrics* Metrics);
PDF_EXP SI32   PDF_CALL pdfGetFontOrigin(const PPDF* IPDF);
PDF_EXP void   PDF_CALL pdfGetFontSearchOrder(const PPDF* IPDF, TFontBaseType Order[4]);
PDF_EXP SI32   PDF_CALL pdfGetFontSelMode(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetFontSize(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetFontWeight(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetFTextHeightA(const PPDF* IPDF, TTextAlign Align, const char* AText);
PDF_EXP double PDF_CALL pdfGetFTextHeightW(const PPDF* IPDF, TTextAlign Align, const UI16* AText);
PDF_EXP double PDF_CALL pdfGetFTextHeightExA(const PPDF* IPDF, double Width, TTextAlign Align, const char* AText);
PDF_EXP double PDF_CALL pdfGetFTextHeightExW(const PPDF* IPDF, double Width, TTextAlign Align, const UI16* AText);
PDF_EXP SI32   PDF_CALL pdfGetFullyQualifiedFieldName(const PPDF* IPDF, UI32 Handle, UI16* ADDR Value);
PDF_EXP SI32   PDF_CALL pdfGetGlyphIndex(const PPDF* IPDF, UI32 Index);
PDF_EXP SI32   PDF_CALL pdfGetGlyphOutline(const PPDF* IPDF, UI32 Index, struct TPDFGlyphOutline* Outline);
PDF_EXP LBOOL  PDF_CALL pdfGetGoToAction(const PPDF* IPDF, UI32 Handle, struct TPDFGoToAction* Action);
PDF_EXP LBOOL  PDF_CALL pdfGetGoToRAction(const PPDF* IPDF, UI32 Handle, struct TPDFGoToAction* Action);
PDF_EXP UI32   PDF_CALL pdfGetGStateFlags(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetHideAction(const PPDF* IPDF, UI32 Handle, struct TPDFHideAction* Action);
PDF_EXP UI32   PDF_CALL pdfGetIconColor(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetImageBuffer(const PPDF* IPDF, UI32 ADDR BufSize);
PDF_EXP SI32   PDF_CALL pdfGetImageCountA(const PPDF* IPDF, const char* FileName);
PDF_EXP SI32   PDF_CALL pdfGetImageCountW(const PPDF* IPDF, const UI16* FileName);
PDF_EXP SI32   PDF_CALL pdfGetImageCountEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize);
PDF_EXP SI32   PDF_CALL pdfGetImageHandle(const PPDF* IPDF, const PIMG* ImagePtr);
PDF_EXP SI32   PDF_CALL pdfGetImageHeight(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfGetImageObj(const PPDF* IPDF, UI32 Handle, TParseFlags Flags, struct TPDFImage* Image);
PDF_EXP SI32   PDF_CALL pdfGetImageObjCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetImageObjEx(const PPDF* IPDF, const PIMG* ImagePtr, TParseFlags Flags, struct TPDFImage* Image);
PDF_EXP SI32   PDF_CALL pdfGetImageWidth(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfGetImportDataAction(const PPDF* IPDF, UI32 Handle, struct TPDFImportDataAction* Action);
PDF_EXP UI32   PDF_CALL pdfGetImportFlags(const PPDF* IPDF);
PDF_EXP UI32   PDF_CALL pdfGetImportFlags2(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetInBBox(const PPDF* IPDF, UI32 PageNum, TPageBoundary Boundary, struct TPDFRect ADDR BBox);
PDF_EXP SI32   PDF_CALL pdfGetInDocInfo(const PPDF* IPDF, TDocumentInfo DInfo, UI16* ADDR Value);
PDF_EXP SI32   PDF_CALL pdfGetInDocInfoCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInDocInfoEx(const PPDF* IPDF, UI32 Index, TDocumentInfo ADDR DInfo, char* ADDR Key, char* ADDR Value, LBOOL ADDR Unicode);
PDF_EXP SI32   PDF_CALL pdfGetInEncryptionFlags(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetInEncryptionInfo(const PPDF* IPDF, struct TPDFEncryptInfo* Info);
PDF_EXP SI32   PDF_CALL pdfGetInFieldCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInIsCollection(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetInIsEncrypted(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInIsSigned(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInIsTaggedPDF(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInIsTrapped(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInIsXFAForm(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetInkList(const ILST* List, float** Points, UI32* Count);
PDF_EXP LBOOL  PDF_CALL pdfGetInMetadata(const PPDF* IPDF, SI32 PageNum, BYTE** Buffer, UI32* BufSize);
PDF_EXP SI32   PDF_CALL pdfGetInOrientation(const PPDF* IPDF, SI32 PageNum);
PDF_EXP SI32   PDF_CALL pdfGetInPageCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInPDFVersion(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetInPDFVersionEx(const PPDF* IPDF, struct TPDFVersionInfo* Value);
PDF_EXP LBOOL  PDF_CALL pdfGetInPrintSettings(const PPDF* IPDF, struct TPDFPrintSettings* Settings);
PDF_EXP SI32   PDF_CALL pdfGetInRepairMode(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetIsFixedPitch(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetIsTaggingEnabled(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetItalicAngle(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetJavaScript(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode);
PDF_EXP char*  PDF_CALL pdfGetJavaScriptAction(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode);
PDF_EXP char*  PDF_CALL pdfGetJavaScriptAction2(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex, UI32 ADDR Len, LBOOL ADDR Unicode, TObjEvent ADDR Event);
PDF_EXP LBOOL  PDF_CALL pdfGetJavaScriptActionEx(const PPDF* IPDF, UI32 Handle, struct TPDFJavaScriptAction* Action);
PDF_EXP SI32   PDF_CALL pdfGetJavaScriptCount(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetJavaScriptEx(const PPDF* IPDF, const char* Name, UI32 ADDR Len, LBOOL ADDR Unicode);
PDF_EXP char*  PDF_CALL pdfGetJavaScriptName(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode);
PDF_EXP SI32   PDF_CALL pdfGetJPEGQuality(const PPDF* IPDF);
PDF_EXP char*  PDF_CALL pdfGetLanguage(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLastTextPosX(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLastTextPosXAbs(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLastTextPosY(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLastTextPosYAbs(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetLaunchAction(const PPDF* IPDF, UI32 Handle, struct TPDFLaunchAction* Action);
PDF_EXP UI32   PDF_CALL pdfGetLastTextOffset(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetLayerConfig(const PPDF* IPDF, SI32 Index, struct TPDFOCLayerConfig* Config);
PDF_EXP SI32   PDF_CALL pdfGetLayerConfigCount(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLeading(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetLineCapStyle(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetLineJoinStyle(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetLineWidth(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetLinkHighlightMode(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetLogMetafileSizeA(const PPDF* IPDF, const char* FileName, struct TRectL* R);
PDF_EXP LBOOL  PDF_CALL pdfGetLogMetafileSizeW(const PPDF* IPDF, const UI16* FileName, struct TRectL* R);
PDF_EXP LBOOL  PDF_CALL pdfGetLogMetafileSizeEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, struct TRectL* R);
PDF_EXP LBOOL  PDF_CALL pdfGetMatrix(const PPDF* IPDF, struct TCTM* M);
PDF_EXP SI32   PDF_CALL pdfGetMaxFieldLen(const PPDF* IPDF, UI32 TxtField);
PDF_EXP LBOOL  PDF_CALL pdfGetMeasureObj(const IMSR* Measure, struct TPDFMeasure* Value);
PDF_EXP UI32   PDF_CALL pdfGetMetaConvFlags(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetMetadata(const PPDF* IPDF, TMetadataObj ObjType, SI32 Handle, BYTE** Buffer, UI32* BufSize);
PDF_EXP UI32*  PDF_CALL pdfGetMissingGlyphs(const PPDF* IPDF, UI32 ADDR Count);
PDF_EXP double PDF_CALL pdfGetMiterLimit(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetMovieAction(const PPDF* IPDF, UI32 Handle, struct TPDFMovieAction* Action);
PDF_EXP LBOOL  PDF_CALL pdfGetNamedAction(const PPDF* IPDF, UI32 Handle, struct TPDFNamedAction* Action);
PDF_EXP LBOOL  PDF_CALL pdfGetNamedDest(const PPDF* IPDF, UI32 Index, struct TPDFNamedDest* Dest);
PDF_EXP SI32   PDF_CALL pdfGetNamedDestCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetNeedAppearance(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetNumberFormatObj(const INFM* NumberFmt, struct TPDFNumberFormat* Value);
PDF_EXP SI32   PDF_CALL pdfGetObjActionCount(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle);
PDF_EXP SI32   PDF_CALL pdfGetObjActions(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, struct TPDFObjActions* Actions);
PDF_EXP LBOOL  PDF_CALL pdfGetObjEvent(const IEVT* IEvent, struct TPDFObjEvent* Event);
PDF_EXP LBOOL  PDF_CALL pdfGetOCG(const PPDF* IPDF, UI32 Handle, struct TPDFOCG* Out);
PDF_EXP LBOOL  PDF_CALL pdfGetOCGContUsage(const PPDF* IPDF, UI32 Handle, struct TPDFOCGContUsage* Out);
PDF_EXP SI32   PDF_CALL pdfGetOCGCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetOCGUsageUserName(const PPDF* IPDF, UI32 Handle, UI32 Index, char* ADDR NameA, UI16* ADDR NameW);
PDF_EXP SI32   PDF_CALL pdfGetOCHandle(const IOCG* OC);
PDF_EXP IOCN*  PDF_CALL pdfGetOCUINode(const PPDF* IPDF, const IOCN* Node, struct TPDFOCUINode* OutNode);
PDF_EXP double PDF_CALL pdfGetOpacity(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetOrientation(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetOutputIntent(const PPDF* IPDF, UI32 Index, struct TPDFOutputIntent* Intent);
PDF_EXP SI32   PDF_CALL pdfGetOutputIntentCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPageAnnot(const PPDF* IPDF, UI32 Index, struct TPDFAnnotation ADDR Annot);
PDF_EXP SI32   PDF_CALL pdfGetPageAnnotCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPageAnnotEx(const PPDF* IPDF, UI32 Index, struct TPDFAnnotationEx ADDR Annot);
PDF_EXP LBOOL  PDF_CALL pdfGetPageBBox(IPGE* PagePtr, TPageBoundary Boundary, struct TFltRect* BBox);
PDF_EXP SI32   PDF_CALL pdfGetPageCoords(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetPageCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPageField(const PPDF* IPDF, UI32 Index, struct TPDFField* Field);
PDF_EXP SI32   PDF_CALL pdfGetPageFieldCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPageFieldEx(const PPDF* IPDF, UI32 Index, struct TPDFFieldEx* Field);
PDF_EXP double PDF_CALL pdfGetPageHeight(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPageLabel(const PPDF* IPDF, UI32 Index, struct TPDFPageLabel* Label);
PDF_EXP SI32   PDF_CALL pdfGetPageLabelCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetPageLayout(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetPageMode(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetPageNum(const PPDF* IPDF);
PDF_EXP IPGE*  PDF_CALL pdfGetPageObject(const PPDF* IPDF, UI32 PageNum);
PDF_EXP SI32   PDF_CALL pdfGetPageOrientation(IPGE* PagePtr);
PDF_EXP LBOOL  PDF_CALL pdfGetPageText(const PPDF* IPDF, struct TPDFStack* Stack);
PDF_EXP double PDF_CALL pdfGetPageWidth(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetPDFVersion(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetPDFVersionEx(const PPDF* IPDF, struct TPDFVersionInfo* Value);
PDF_EXP LBOOL  PDF_CALL pdfGetPrintSettings(const PPDF* IPDF, struct TPDFPrintSettings* Settings);
PDF_EXP LBOOL  PDF_CALL pdfGetPtDataArray(const IPTD* PtData, UI32 Index, char** DataType, float** Values, UI32* ValCount);
PDF_EXP LBOOL  PDF_CALL pdfGetPtDataObj(const IPTD* PtData, char** Subtype, UI32* NumArrays);
PDF_EXP LBOOL  PDF_CALL pdfGetRelFileNode(const IRFN* IRF, struct TPDFRelFileNode* F, LBOOL Decompress);
PDF_EXP LBOOL  PDF_CALL pdfGetResetAction(const PPDF* IPDF, UI32 Handle, struct TPDFResetFormAction* Value);
PDF_EXP SI32   PDF_CALL pdfGetResolution(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetSaveNewImageFormat(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetSeparationInfo(const PPDF* IPDF, char* ADDR Colorant, TExtColorSpace ADDR CS);
PDF_EXP LBOOL  PDF_CALL pdfGetSigDict(const PSIG* ISignature, struct TPDFSigDict* SigDict);
PDF_EXP UI32   PDF_CALL pdfGetStrokeColor(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetSubmitAction(const PPDF* IPDF, UI32 Handle, struct TPDFSubmitFormAction* Value);
PDF_EXP SI32   PDF_CALL pdfGetSysFontInfo(const PPDF* IPDF, UI32 Handle, struct TPDFSysFont* Out);
PDF_EXP SI32   PDF_CALL pdfGetTabLen(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetTemplCount(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetTemplHandle(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetTemplHeight(const PPDF* IPDF, SI32 Handle);
PDF_EXP double PDF_CALL pdfGetTemplWidth(const PPDF* IPDF, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfGetTextBBoxA(const PPDF* IPDF, const char* Text, UI32 Len, struct TBBox* BBox);
PDF_EXP LBOOL  PDF_CALL pdfGetTextBBoxW(const PPDF* IPDF, const UI16* Text, UI32 Len, struct TBBox* BBox);
PDF_EXP SI32   PDF_CALL pdfGetTextDrawMode(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetTextFieldValue(const PPDF* IPDF, UI32 AField, char* ADDR Value, LBOOL ADDR ValIsUnicode, char* ADDR DefValue, LBOOL ADDR DefValIsUnicode);
PDF_EXP LBOOL  PDF_CALL pdfGetTextRect(const PPDF* IPDF, double ADDR PosX, double ADDR PosY, double ADDR Width, double ADDR Height);
PDF_EXP double PDF_CALL pdfGetTextRise(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetTextScaling(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetTextWidthA(const PPDF* IPDF, const char* AText);
PDF_EXP double PDF_CALL pdfGetTextWidthW(const PPDF* IPDF, const UI16* AText);
PDF_EXP double PDF_CALL pdfGetTextWidthExA(const PPDF* IPDF, const char* AText, UI32 Len);
PDF_EXP double PDF_CALL pdfGetTextWidthExW(const PPDF* IPDF, const UI16* AText, UI32 Len);
PDF_EXP UI32   PDF_CALL pdfGetTransparentColor(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetTrapped(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetTypoLeading(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetURIAction(const PPDF* IPDF, UI32 Handle, struct TPDFURIAction* Action);
PDF_EXP LBOOL  PDF_CALL pdfGetUseExactPwd(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetUseGlobalImpFiles(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetUseStdFonts(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetUseSystemFonts(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetUsesTransparency(const PPDF* IPDF, SI32 PageNum);
PDF_EXP LBOOL  PDF_CALL pdfGetUseTransparency(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetUseVisibleCoords(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetUserRights(const PPDF* IPDF);
PDF_EXP float  PDF_CALL pdfGetUserUnit(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetViewerPreferences(const PPDF* IPDF, SI32 ADDR Preference, SI32 ADDR AddVal);
PDF_EXP LBOOL  PDF_CALL pdfGetViewport(const PPDF* IPDF, UI32 PageNum, UI32 Index, struct TPDFViewport* VP);
PDF_EXP SI32   PDF_CALL pdfGetViewportCount(const PPDF* IPDF, UI32 PageNum);
PDF_EXP LBOOL  PDF_CALL pdfGetWMFDefExtent(const PPDF* IPDF, UI32 ADDR Width, UI32 ADDR Height);
PDF_EXP SI32   PDF_CALL pdfGetWMFPixelPerInch(const PPDF* IPDF);
PDF_EXP double PDF_CALL pdfGetWordSpacing(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfGetXFAStream(const PPDF* IPDF, UI32 Index, struct TPDFXFAStream* Out);
PDF_EXP LBOOL  PDF_CALL pdfHaveDPartRoot(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfGetXFAStreamCount(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfHaveOpenDoc(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfHaveOpenPage(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfHighlightAnnotA(const PPDF* IPDF, TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const char* Author, const char* Subject, const char* Comment);
PDF_EXP SI32   PDF_CALL pdfHighlightAnnotW(const PPDF* IPDF, TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const UI16* Author, const UI16* Subject, const UI16* Comment);
PDF_EXP SI32   PDF_CALL pdfImportBookmarks(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfImportCatalogObjects(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfImportDocInfo(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfImportEncryptionSettings(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfImportOCProperties(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfImportPage(const PPDF* IPDF, UI32 PageNum);
PDF_EXP SI32   PDF_CALL pdfImportPageEx(const PPDF* IPDF, UI32 PageNum, double ScaleX, double ScaleY);
PDF_EXP SI32   PDF_CALL pdfImportPDFFile(const PPDF* IPDF, UI32 DestPage, double ScaleX, double ScaleY);
PDF_EXP LBOOL  PDF_CALL pdfInitBarcode2(struct TPDFBarcode2* Barcode);
PDF_EXP LBOOL  PDF_CALL pdfInitColorManagement(const PPDF* IPDF, struct TPDFColorProfiles* Profiles, TPDFColorSpace DestSpace, TPDFInitCMFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfInitColorManagementEx(const PPDF* IPDF, struct TPDFColorProfilesEx* Profiles, TPDFColorSpace DestSpace, TPDFInitCMFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfInitExtGState(struct TPDFExtGState* GS);
PDF_EXP LBOOL  PDF_CALL pdfInitHeaderFooter(struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfInitOCGContUsage(struct TPDFOCGContUsage* Value);
PDF_EXP LBOOL  PDF_CALL pdfInitStack(const PPDF* IPDF, struct TPDFStack* Stack);
PDF_EXP SI32   PDF_CALL pdfInkAnnotA(const PPDF* IPDF, struct TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content);
PDF_EXP SI32   PDF_CALL pdfInkAnnotW(const PPDF* IPDF, struct TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content);
PDF_EXP SI32   PDF_CALL pdfInsertBarcode(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TCellAlign HAlign, TCellAlign VAlign, struct TPDFBarcode2* Barcode);
PDF_EXP SI32   PDF_CALL pdfInsertBMPFromBuffer(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer);
PDF_EXP SI32   PDF_CALL pdfInsertBMPFromHandle(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, void* hBitmap);
PDF_EXP SI32   PDF_CALL pdfInsertBookmarkA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open, LBOOL AddChildren);
PDF_EXP SI32   PDF_CALL pdfInsertBookmarkW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open, LBOOL AddChildren);
PDF_EXP SI32   PDF_CALL pdfInsertBookmarkExA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 NamedDest, LBOOL Open, LBOOL AddChildren);
PDF_EXP SI32   PDF_CALL pdfInsertBookmarkExW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 NamedDest, LBOOL Open, LBOOL AddChildren);
PDF_EXP SI32   PDF_CALL pdfInsertImage(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* Image);
PDF_EXP SI32   PDF_CALL pdfInsertImageExA(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* Image, UI32 Index);
PDF_EXP SI32   PDF_CALL pdfInsertImageExW(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const UI16* Image, UI32 Index);
PDF_EXP SI32   PDF_CALL pdfInsertImageFromBuffer(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer, UI32 BufSize, UI32 Index);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileA(const PPDF* IPDF, const char* FileName, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileW(const PPDF* IPDF, const UI16* FileName, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileExtA(const PPDF* IPDF, const char* FileName, struct TRectL* View, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileExtW(const PPDF* IPDF, const UI16* FileName, struct TRectL* View, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileExtEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, struct TRectL* View, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileFromHandle(const PPDF* IPDF, const void* hEnhMetafile, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfInsertMetafileFromHandleEx(const PPDF* IPDF, const void* hEnhMetafile, struct TRectL* View, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfInsertRawImage(const PPDF* IPDF, const void* Buffer, UI32 BitsPerPixel, UI32 ColorCount, SI32 ImgWidth, SI32 ImgHeight, double PosX, double PosY, double ScaleWidth, double ScaleHeight);
PDF_EXP SI32   PDF_CALL pdfInsertRawImageEx(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, struct TPDFRawImage* Image);
PDF_EXP SI32   PDF_CALL pdfIsBidiText(const PPDF* IPDF, const UI16* AText);
PDF_EXP SI32   PDF_CALL pdfIsColorPage(const PPDF* IPDF, LBOOL GrayIsColor);
PDF_EXP SI32   PDF_CALL pdfIsEmptyPage(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfLineTo(const PPDF* IPDF, double PosX, double PosY);
PDF_EXP SI32   PDF_CALL pdfLineAnnotA(const PPDF* IPDF, double x1, double y1, double x2, double y2, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content);
PDF_EXP SI32   PDF_CALL pdfLineAnnotW(const PPDF* IPDF, double x1, double y1, double x2, double y2, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content);
PDF_EXP SI32   PDF_CALL pdfLoadCMap(const PPDF* IPDF, const char* CMapName, LBOOL Embed);
PDF_EXP LBOOL  PDF_CALL pdfLoadFDFDataA(const PPDF* IPDF, const char* FileName, const char* Password, UI32 Flags);
PDF_EXP LBOOL  PDF_CALL pdfLoadFDFDataW(const PPDF* IPDF, const UI16* FileName, const char* Password, UI32 Flags);
PDF_EXP LBOOL  PDF_CALL pdfLoadFDFDataEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const char* Password, UI32 Flags);
PDF_EXP SI32   PDF_CALL pdfLoadFont(const PPDF* IPDF, const void* Buffer, UI32 BufSize, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfLoadFontExA(const PPDF* IPDF, const char* FontFile, UI32 Index, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfLoadFontExW(const PPDF* IPDF, const UI16* FontFile, UI32 Index, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfLoadHeaderFooterSettings(const PPDF* IPDF, struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray);
PDF_EXP LBOOL  PDF_CALL pdfLoadLayerConfig(const PPDF* IPDF, SI32 Index);
PDF_EXP LBOOL  PDF_CALL pdfLockLayer(const PPDF* IPDF, UI32 Layer);
PDF_EXP LBOOL  PDF_CALL pdfMarkTemplateAsWatermark(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfMovePage(const PPDF* IPDF, UI32 Source, UI32 Dest);
PDF_EXP LBOOL  PDF_CALL pdfMoveTo(const PPDF* IPDF, double PosX, double PosY);
PDF_EXP LBOOL  PDF_CALL pdfMultiplyMatrix(struct TCTM* M1, struct TCTM* M2, struct TCTM* NewMatrix);
PDF_EXP PPDF*  PDF_CALL pdfNewPDF(void);
PDF_EXP SI32   PDF_CALL pdfOpenImportBuffer(const PPDF* IPDF, const void* Buffer, UI32 BufSize, TPwdType PwdType, const char* Password);
PDF_EXP SI32   PDF_CALL pdfOpenImportFileA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* Password);
PDF_EXP SI32   PDF_CALL pdfOpenImportFileW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* Password);
PDF_EXP LBOOL  PDF_CALL pdfOpenOutputFileA(const PPDF* IPDF, const char* OutPDF);
PDF_EXP LBOOL  PDF_CALL pdfOpenOutputFileW(const PPDF* IPDF, const UI16* OutPDF);
PDF_EXP LBOOL  PDF_CALL pdfOpenOutputFileEncryptedA(const PPDF* IPDF, const char* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict);
PDF_EXP LBOOL  PDF_CALL pdfOpenOutputFileEncryptedW(const PPDF* IPDF, const UI16* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagA(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagW(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagBBoxA(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion, struct TBBox* BBox);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagBBoxW(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion, struct TBBox* BBox);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagExA(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion, const char* Attributes);
PDF_EXP LBOOL  PDF_CALL pdfOpenTagExW(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion, const char* Attributes);
PDF_EXP LBOOL  PDF_CALL pdfOptimize(const PPDF* IPDF, TOptimizeFlags Flags, struct TOptimizeParams* Parms);
PDF_EXP SI32   PDF_CALL pdfPageLink(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 DestPage);
PDF_EXP SI32   PDF_CALL pdfPageLink2(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 NamedDest);
PDF_EXP SI32   PDF_CALL pdfPageLink3A(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* NamedDest);
PDF_EXP SI32   PDF_CALL pdfPageLink3W(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* NamedDest);
PDF_EXP SI32   PDF_CALL pdfPageLinkEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TDestType DestType, UI32 DestPage, double a, double b, double c, double d);
PDF_EXP LBOOL  PDF_CALL pdfParseContent(const PPDF* IPDF, const void* Data, struct TPDFParseInterface* Stack, TParseFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfPlaceImage(const PPDF* IPDF, SI32 ImgHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight);
PDF_EXP LBOOL  PDF_CALL pdfPlaceSigFieldValidateIcon(const PPDF* IPDF, UI32 SigField, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfPlaceTemplate(const PPDF* IPDF, SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight);
PDF_EXP LBOOL  PDF_CALL pdfPlaceTemplateEx(const PPDF* IPDF, SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight);
PDF_EXP LBOOL  PDF_CALL pdfPlaceTemplByMatrix(const PPDF* IPDF, SI32 TmplHandle);
PDF_EXP SI32   PDF_CALL pdfPolygonAnnotA(const PPDF* IPDF, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content);
PDF_EXP SI32   PDF_CALL pdfPolygonAnnotW(const PPDF* IPDF, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content);
PDF_EXP SI32   PDF_CALL pdfPolyLineAnnotA(const PPDF* IPDF, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content);
PDF_EXP SI32   PDF_CALL pdfPolyLineAnnotW(const PPDF* IPDF, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content);
PDF_EXP LBOOL  PDF_CALL pdfPrintPageA(const PPDF* IPDF, UI32 PageNum, const char* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms);
PDF_EXP LBOOL  PDF_CALL pdfPrintPageW(const PPDF* IPDF, UI32 PageNum, const UI16* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms);
PDF_EXP LBOOL  PDF_CALL pdfPrintPDFFileA(const PPDF* IPDF, const char* TmpDir, const char* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms);
PDF_EXP LBOOL  PDF_CALL pdfPrintPDFFileW(const PPDF* IPDF, const UI16* TmpDir, const UI16* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormatA(const PPDF* IPDF, const char* FileName, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormatW(const PPDF* IPDF, const UI16* FileName, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormat2A(const PPDF* IPDF, const char* FileName, UI32 Index, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormat2W(const PPDF* IPDF, const UI16* FileName, UI32 Index, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormatEx(const PPDF* IPDF, void* hBitmap, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageFormatFromBuffer(const PPDF* IPDF, const void* Buffer, UI32 BufSize, UI32 Index, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip);
PDF_EXP LBOOL  PDF_CALL pdfReadImageResolutionA(const PPDF* IPDF, const char* FileName, UI32 Index, UI32 ADDR ResX, UI32 ADDR ResY);
PDF_EXP LBOOL  PDF_CALL pdfReadImageResolutionW(const PPDF* IPDF, const UI16* FileName, UI32 Index, UI32 ADDR ResX, UI32 ADDR ResY);
PDF_EXP LBOOL  PDF_CALL pdfReadImageResolutionEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, UI32 Index, UI32 ADDR ResX, UI32 ADDR ResY);
PDF_EXP LBOOL  PDF_CALL pdfRectangle(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TPathFillMode FillMode);
PDF_EXP SI32   PDF_CALL pdfReEncryptPDFA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict);
PDF_EXP SI32   PDF_CALL pdfReEncryptPDFW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict);
PDF_EXP SI32   PDF_CALL pdfRenameSpotColor(const PPDF* IPDF, const char* Colorant, const char* NewName);
PDF_EXP SI32   PDF_CALL pdfRenderAnnotOrField(const PPDF* IPDF, UI32 Handle, LBOOL IsAnnot, TButtonState State, struct TCTM* Matrix, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, struct TPDFBitmap* Out);
PDF_EXP LBOOL  PDF_CALL pdfRenderPage(const PPDF* IPDF, IPGE* PagePtr, IRAS* RasPtr, struct TPDFRasterImage* Img);
PDF_EXP LBOOL  PDF_CALL pdfRenderPageEx(const PPDF* IPDF, const void* DC, SI32* DestX, SI32* DestY, IPGE* PagePtr, IRAS* RasPtr, struct TPDFRasterImage* Img);
PDF_EXP LBOOL  PDF_CALL pdfRenderPageToImageA(const PPDF* IPDF, UI32 PageNum, const char* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfRenderPageToImageW(const PPDF* IPDF, UI32 PageNum, const UI16* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfRenderPDFFileA(const PPDF* IPDF, const char* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfRenderPDFFileW(const PPDF* IPDF, const UI16* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfRenderPDFFileExA(const PPDF* IPDF, const char* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfRenderPDFFileExW(const PPDF* IPDF, const UI16* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format);
PDF_EXP LBOOL  PDF_CALL pdfReOpenImportFile(const PPDF* IPDF, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfReplaceFontA(const PPDF* IPDF, const PFNT* PDFFont, const char* Name, TFStyle Style, LBOOL NameIsFamilyName);
PDF_EXP SI32   PDF_CALL pdfReplaceFontW(const PPDF* IPDF, const PFNT* PDFFont, const UI16* Name, TFStyle Style, LBOOL NameIsFamilyName);
PDF_EXP SI32   PDF_CALL pdfReplaceFontExA(const PPDF* IPDF, const PFNT* PDFFont, const char* FontFile, LBOOL Embed);
PDF_EXP SI32   PDF_CALL pdfReplaceFontExW(const PPDF* IPDF, const PFNT* PDFFont, const UI16* FontFile, LBOOL Embed);
PDF_EXP SI32   PDF_CALL pdfReplaceICCProfileA(const PPDF* IPDF, UI32 ColorSpace, const char* ICCFile);
PDF_EXP SI32   PDF_CALL pdfReplaceICCProfileW(const PPDF* IPDF, UI32 ColorSpace, const UI16* ICCFile);
PDF_EXP SI32   PDF_CALL pdfReplaceICCProfileEx(const PPDF* IPDF, UI32 ColorSpace, const void* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfReplaceImageA(const PPDF* IPDF, const PIMG* Source, const char* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfReplaceImageW(const PPDF* IPDF, const PIMG* Source, const UI16* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfReplaceImageEx(const PPDF* IPDF, const PIMG* Source, const void* Buffer, UI32 BufSize, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfReplacePageTextA(const PPDF* IPDF, const char* NewText, struct TPDFStack* Stack);
PDF_EXP LBOOL  PDF_CALL pdfReplacePageTextExA(const PPDF* IPDF, const char* NewText, struct TPDFStack* Stack);
PDF_EXP LBOOL  PDF_CALL pdfReplacePageTextExW(const PPDF* IPDF, const UI16* NewText, struct TPDFStack* Stack);
PDF_EXP LBOOL  PDF_CALL pdfResetAnnotAP(const PPDF* IPDF, SI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfResetEncryptionSettings(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfResetLineDashPattern(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfRestoreGraphicState(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfRotateCoords(const PPDF* IPDF, double alpha, double OriginX, double OriginY);
PDF_EXP LBOOL  PDF_CALL pdfRoundRect(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double Radius, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfRoundRectEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double rWidth, double rHeight, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfSaveGraphicState(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfScaleCoords(const PPDF* IPDF, double sx, double sy);
PDF_EXP LBOOL  PDF_CALL pdfSelfTest(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfSet3DAnnotProps(const PPDF* IPDF, UI32 Handle, T3DActivationType ActType, T3DDeActivateType DeActType, T3DInstanceType InstType, T3DDeActInstance DeInstType, LBOOL DisplToolbar, LBOOL DisplModelTree);
PDF_EXP LBOOL  PDF_CALL pdfSet3DAnnotScriptA(const PPDF* IPDF, UI32 Annot, const char* Value, UI32 Len);
PDF_EXP LBOOL  PDF_CALL pdfSetActiveSigField(const PPDF* IPDF, UI32 Handle);
PDF_EXP SI32   PDF_CALL pdfSetAllocBy(const PPDF* IPDF, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAltFontsA(const PPDF* IPDF, UI32 ListHandle, const char** List, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfSetAltFontsW(const PPDF* IPDF, UI32 ListHandle, const UI16** List, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotBorderEffect(const PPDF* IPDF, UI32 Handle, TBorderEffect Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotBorderStyle(const PPDF* IPDF, UI32 Handle, TBorderStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotBorderWidth(const PPDF* IPDF, UI32 Handle, double LineWidth);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotColor(const PPDF* IPDF, UI32 Handle, TAnnotColor ColorType, TPDFColorSpace CS, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotFlags(const PPDF* IPDF, TAnnotFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotFlagsEx(const PPDF* IPDF, UI32 Handle, SI32 Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotHighlightMode(const PPDF* IPDF, UI32 Handle, THighlightMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotIcon(const PPDF* IPDF, UI32 Handle, TAnnotIcon Icon);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotLineDashPattern(const PPDF* IPDF, UI32 Handle, const float* Dash, UI32 NumValues);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotLineEndStyle(const PPDF* IPDF, UI32 Handle, TLineEndStyle Start, TLineEndStyle End);
PDF_EXP SI32   PDF_CALL pdfSetAnnotMigrationStateA(const PPDF* IPDF, UI32 Annot, TAnnotState State, const char* User);
PDF_EXP SI32   PDF_CALL pdfSetAnnotMigrationStateW(const PPDF* IPDF, UI32 Annot, TAnnotState State, const UI16* User);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotOpacity(const PPDF* IPDF, UI32 Handle, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotOpenState(const PPDF* IPDF, UI32 Handle, LBOOL Open);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotOrFieldDate(const PPDF* IPDF, UI32 Handle, LBOOL IsField, TDateType Type, UI32 DateTime);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotQuadPoints(const PPDF* IPDF, UI32 Handle, struct TFltPoint* Value, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotStringA(const PPDF* IPDF, UI32 Handle, TAnnotString StringType, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotStringW(const PPDF* IPDF, UI32 Handle, TAnnotString StringType, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotSubjectA(const PPDF* IPDF, UI32 Handle, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetAnnotSubjectW(const PPDF* IPDF, UI32 Handle, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetBBox(const PPDF* IPDF, TPageBoundary Boundary, double LeftX, double LeftY, double RightX, double RightY);
PDF_EXP LBOOL  PDF_CALL pdfSetBidiMode(const PPDF* IPDF, TPDFBidiMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetBookmarkDest(const PPDF* IPDF, SI32 ABmk, TDestType DestType, double a, double b, double c, double d);
PDF_EXP LBOOL  PDF_CALL pdfSetBookmarkStyle(const PPDF* IPDF, SI32 ABmk, TFStyle Style, UI32 RGBColor);
PDF_EXP LBOOL  PDF_CALL pdfSetBorderStyle(const PPDF* IPDF, TBorderStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfSetCharacterSpacing(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetCheckBoxChar(const PPDF* IPDF, TCheckBoxChar CheckBoxChar);
PDF_EXP LBOOL  PDF_CALL pdfSetCheckBoxDefState(const PPDF* IPDF, UI32 AField, LBOOL Checked);
PDF_EXP LBOOL  PDF_CALL pdfSetCheckBoxState(const PPDF* IPDF, UI32 AField, LBOOL Checked);
PDF_EXP SI32   PDF_CALL pdfSetCIDFontA(const PPDF* IPDF, UI32 CMapHandle, const char* Name, TFStyle Style, double Size, LBOOL Embed);
PDF_EXP SI32   PDF_CALL pdfSetCIDFontW(const PPDF* IPDF, UI32 CMapHandle, const UI16* Name, TFStyle Style, double Size, LBOOL Embed);
PDF_EXP SI32   PDF_CALL pdfSetCMapDirA(const PPDF* IPDF, const char* Path, TLoadCMapFlags Flags);
PDF_EXP SI32   PDF_CALL pdfSetCMapDirW(const PPDF* IPDF, const UI16* Path, TLoadCMapFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetColDefFile(const PPDF* IPDF, UI32 EmbFile);
PDF_EXP LBOOL  PDF_CALL pdfSetColorMask(const PPDF* IPDF, UI32 ImageHandle, SI32* Mask, UI32 Count);
PDF_EXP LBOOL  PDF_CALL pdfSetColors(const PPDF* IPDF, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetColorSpace(const PPDF* IPDF, TPDFColorSpace ColorSpace);
PDF_EXP LBOOL  PDF_CALL pdfSetColSortField(const PPDF* IPDF, UI32 ColField, LBOOL AscendingOrder);
PDF_EXP LBOOL  PDF_CALL pdfSetCompressionFilter(const PPDF* IPDF, TCompressionFilter Filter);
PDF_EXP LBOOL  PDF_CALL pdfSetCompressionLevel(const PPDF* IPDF, TCompressionLevel CompressLevel);
PDF_EXP LBOOL  PDF_CALL pdfSetContent(const PPDF* IPDF, const char* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfSetDateTimeFormat(const PPDF* IPDF, UI32 TxtField, TPDFDateTime Fmt);
PDF_EXP LBOOL  PDF_CALL pdfSetDefBitsPerPixel(const PPDF* IPDF, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetDocInfoA(const PPDF* IPDF, TDocumentInfo DInfo, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetDocInfoW(const PPDF* IPDF, TDocumentInfo DInfo, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetDocInfoExA(const PPDF* IPDF, TDocumentInfo DInfo, const char* Key, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetDocInfoExW(const PPDF* IPDF, TDocumentInfo DInfo, const char* Key, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetDrawDirection(const PPDF* IPDF, TDrawDirection Direction);
PDF_EXP LBOOL  PDF_CALL pdfSetEMFFrameDPI(const PPDF* IPDF, UI32 DPIX, UI32 DPIY);
PDF_EXP LBOOL  PDF_CALL pdfSetEMFPatternDistance(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetErrorMode(const PPDF* IPDF, TErrMode ErrMode);
PDF_EXP LBOOL  PDF_CALL pdfSetExtColorSpace(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetExtFillColorSpace(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetExtGState(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetExtStrokeColorSpace(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldBackColor(const PPDF* IPDF, UI32 AColor);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldBBox(const PPDF* IPDF, UI32 AField, struct TPDFRect* BBox);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldBorderColor(const PPDF* IPDF, UI32 AColor);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldBorderWidth(const PPDF* IPDF, UI32 AField, double LineWidth);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldColor(const PPDF* IPDF, UI32 AField, TFieldColor ColorType, TPDFColorSpace CS, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldBorderStyle(const PPDF* IPDF, UI32 AField, TBorderStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldCalcOrder(const PPDF* IPDF, SI32 CurrIndex, UI32 NewIndex);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldExpValueA(const PPDF* IPDF, UI32 AField, UI32 ValIndex, const char* Value, const char* ExpValue, LBOOL Selected);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldExpValueW(const PPDF* IPDF, UI32 AField, UI32 ValIndex, const UI16* Value, const char* ExpValue, LBOOL Selected);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldExpValueEx(const PPDF* IPDF, UI32 AField, UI32 ValIndex, LBOOL Selected, LBOOL DefSelected);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldFlags(const PPDF* IPDF, UI32 AField, TFieldFlags Flags, LBOOL Reset);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldFontSize(const PPDF* IPDF, UI32 AField, double FontSize);
PDF_EXP SI32   PDF_CALL pdfSetFieldFontA(const PPDF* IPDF, UI32 Field, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfSetFieldFontW(const PPDF* IPDF, UI32 Field, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldFontEx(const PPDF* IPDF, UI32 Field, UI32 Handle, double FontSize);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldHighlightMode(const PPDF* IPDF, UI32 AField, THighlightMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldIndex(const PPDF* IPDF, UI32 AField, UI32 Index);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldMapNameA(const PPDF* IPDF, UI32 AField, const char* Name);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldMapNameW(const PPDF* IPDF, UI32 AField, const UI16* Name);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldNameA(const PPDF* IPDF, UI32 AField, const char* NewName);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldNameW(const PPDF* IPDF, UI32 AField, const UI16* NewName);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldOrientation(const PPDF* IPDF, UI32 AField, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldTextAlign(const PPDF* IPDF, UI32 AField, TTextAlign Align);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldTextColor(const PPDF* IPDF, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldToolTipA(const PPDF* IPDF, UI32 AField, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetFieldToolTipW(const PPDF* IPDF, UI32 AField, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetFillColor(const PPDF* IPDF, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetFillColorEx(const PPDF* IPDF, const BYTE* Color, UI32 NumComponents);
PDF_EXP LBOOL  PDF_CALL pdfSetFillColorF(const PPDF* IPDF, const float* Color, UI32 NumComponents);
PDF_EXP LBOOL  PDF_CALL pdfSetFillColorSpace(const PPDF* IPDF, TPDFColorSpace CS);
PDF_EXP LBOOL  PDF_CALL pdfSetFloatPrecision(const PPDF* IPDF, UI32 NumTextDecDigits, UI32 NumVectDecDigits);
PDF_EXP SI32   PDF_CALL pdfSetFontA(const PPDF* IPDF, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfSetFontW(const PPDF* IPDF, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfSetFontExA(const PPDF* IPDF, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP SI32   PDF_CALL pdfSetFontExW(const PPDF* IPDF, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP);
PDF_EXP LBOOL  PDF_CALL pdfSetFontOrigin(const PPDF* IPDF, TOrigin Origin);
PDF_EXP void   PDF_CALL pdfSetFontSearchOrder(const PPDF* IPDF, TFontBaseType Order[4]);
PDF_EXP void   PDF_CALL pdfSetFontSearchOrderEx(const PPDF* IPDF, TFontBaseType S1, TFontBaseType S2, TFontBaseType S3, TFontBaseType S4);
PDF_EXP LBOOL  PDF_CALL pdfSetFontSelMode(const PPDF* IPDF, TFontSelMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetFontWeight(const PPDF* IPDF, SI32 Weight);
PDF_EXP void   PDF_CALL pdfSetGStateFlags(const PPDF* IPDF, TGStateFlags Flags, LBOOL Reset);
PDF_EXP LBOOL  PDF_CALL pdfSetIconColor(const PPDF* IPDF, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetImportFlags(const PPDF* IPDF, TImportFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetImportFlags2(const PPDF* IPDF, TImportFlags2 Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetItalicAngle(const PPDF* IPDF, double Angle);
PDF_EXP LBOOL  PDF_CALL pdfSetJPEGQuality(const PPDF* IPDF, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetLanguage(const PPDF* IPDF, const char* ISOTag);
PDF_EXP LBOOL  PDF_CALL pdfSetLeading(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetLicenseKey(const PPDF* IPDF, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetLineAnnotParms(const PPDF* IPDF, UI32 Handle, SI32 FontHandle, double FontSize, struct TLineAnnotParms* Parms);
PDF_EXP LBOOL  PDF_CALL pdfSetLineAnnotPoints(const PPDF* IPDF, UI32 Handle, struct TFltPoint* P1, struct TFltPoint* P2);
PDF_EXP LBOOL  PDF_CALL pdfSetLineCapStyle(const PPDF* IPDF, TLineCapStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfSetLineDashPattern(const PPDF* IPDF, const char* Dash, SI32 Phase);
PDF_EXP LBOOL  PDF_CALL pdfSetLineDashPattern2(const PPDF* IPDF, const float* Dash, UI32 NumValues, float Phase);
PDF_EXP LBOOL  PDF_CALL pdfSetLineDashPatternEx(const PPDF* IPDF, const double* Dash, UI32 NumValues, SI32 Phase);
PDF_EXP LBOOL  PDF_CALL pdfSetLineJoinStyle(const PPDF* IPDF, TLineJoinStyle Style);
PDF_EXP LBOOL  PDF_CALL pdfSetLineWidth(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetLinkHighlightMode(const PPDF* IPDF, THighlightMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetListFont(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetMatrix(const PPDF* IPDF, struct TCTM* Matrix);
PDF_EXP void   PDF_CALL pdfSetMaxErrLogMsgCount(const PPDF* IPDF, UI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetMaxFieldLen(const PPDF* IPDF, UI32 TxtField, SI32 MaxLen);
PDF_EXP LBOOL  PDF_CALL pdfSetMetaConvFlags(const PPDF* IPDF, TMetaFlags Flags);
PDF_EXP LBOOL  PDF_CALL pdfSetMetadata(const PPDF* IPDF, TMetadataObj ObjType, SI32 Handle, const void* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfSetMiterLimit(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetNeedAppearance(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetNumberFormat(const PPDF* IPDF, UI32 TxtField, TDecSeparator Sep, UI32 DecPlaces, TNegativeStyle NegStyle, const char* CurrStr, LBOOL Prepend);
PDF_EXP LBOOL  PDF_CALL pdfSetOCGContUsage(const PPDF* IPDF, UI32 Handle, struct TPDFOCGContUsage* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetOCGState(const PPDF* IPDF, UI32 Handle, LBOOL On, LBOOL SaveState);
PDF_EXP LBOOL  PDF_CALL pdfSetOnErrorProc(const PPDF* IPDF, const void* Data, TErrorProc* ErrProc);
PDF_EXP LBOOL  PDF_CALL pdfSetOnPageBreakProc(const PPDF* IPDF, const void* Data, TOnPageBreakProc* OnBreakProc);
PDF_EXP LBOOL  PDF_CALL pdfSetOpacity(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetOrientation(const PPDF* IPDF, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetOrientationEx(const PPDF* IPDF, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetPageBBox(IPGE* PagePtr, TPageBoundary Boundary, struct TFltRect* BBox);
PDF_EXP LBOOL  PDF_CALL pdfSetPageCoords(const PPDF* IPDF, TPageCoord PageCoords);
PDF_EXP LBOOL  PDF_CALL pdfSetPageFormat(const PPDF* IPDF, TPageFormat Value);
PDF_EXP LBOOL  PDF_CALL pdfSetPageHeight(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetPageLayout(const PPDF* IPDF, TPageLayout Layout);
PDF_EXP LBOOL  PDF_CALL pdfSetPageMode(const PPDF* IPDF, TPageMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetPageOrientation(const PPDF* IPDF, IPGE* PagePtr, SI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetPageWidth(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetPDFVersion(const PPDF* IPDF, TPDFVersion Version);
PDF_EXP LBOOL  PDF_CALL pdfSetPrintSettings(const PPDF* IPDF, TDuplexMode Mode, SI32 PickTrayByPDFSize, UI32 NumCopies, TPrintScaling PrintScaling, UI32* PrintRanges, UI32 NumRanges);
PDF_EXP LBOOL  PDF_CALL pdfSetProgressProc(const PPDF* IPDF, const void* Data, TInitProgressProc* InitProgress, TProgressProc* Progress);
PDF_EXP LBOOL  PDF_CALL pdfSetRenderingIntent(const PPDF* IPDF, UI32 ImgHandle, TRenderingIntent Value);
PDF_EXP LBOOL  PDF_CALL pdfSetResolution(const PPDF* IPDF, UI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetSaveNewImageFormat(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetSeparationInfo(const PPDF* IPDF, UI32 Handle);
PDF_EXP LBOOL  PDF_CALL pdfSetSpaceWidthFactor(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetStrokeColor(const PPDF* IPDF, UI32 Color);
PDF_EXP LBOOL  PDF_CALL pdfSetStrokeColorEx(const PPDF* IPDF, const BYTE* Color, UI32 NumComponents);
PDF_EXP LBOOL  PDF_CALL pdfSetStrokeColorF(const PPDF* IPDF, const float* Color, UI32 NumComponents);
PDF_EXP LBOOL  PDF_CALL pdfSetStrokeColorSpace(const PPDF* IPDF, TPDFColorSpace CS);
PDF_EXP LBOOL  PDF_CALL pdfSetTabLen(const PPDF* IPDF, SI32 TabLen);
PDF_EXP LBOOL  PDF_CALL pdfSetTemplBBox(const PPDF* IPDF, UI32 Handle, TPageBoundary Boundary, struct TPDFRect* BBox);
PDF_EXP LBOOL  PDF_CALL pdfSetTextDrawMode(const PPDF* IPDF, TDrawMode Mode);
PDF_EXP LBOOL  PDF_CALL pdfSetTextFieldValueA(const PPDF* IPDF, UI32 Field, const char* Value, const char* DefValue, TTextAlign Align);
PDF_EXP LBOOL  PDF_CALL pdfSetTextFieldValueW(const PPDF* IPDF, UI32 Field, const UI16* Value, const UI16* DefValue, TTextAlign Align);
PDF_EXP LBOOL  PDF_CALL pdfSetTextFieldValueExA(const PPDF* IPDF, UI32 Field, const char* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetTextFieldValueExW(const PPDF* IPDF, UI32 Field, const UI16* Value);
PDF_EXP LBOOL  PDF_CALL pdfSetTextRect(const PPDF* IPDF, double PosX, double PosY, double Width, double Height);
PDF_EXP LBOOL  PDF_CALL pdfSetTextRise(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetTextScaling(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetTransparentColor(const PPDF* IPDF, UI32 AColor);
PDF_EXP void   PDF_CALL pdfSetTrapped(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseExactPwd(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseGlobalImpFiles(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseImageInterpolation(const PPDF* IPDF, UI32 Handle, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseImageInterpolationEx(const PIMG* Image, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUserUnit(const PPDF* IPDF, float Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseStdFonts(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseSwapFile(const PPDF* IPDF, LBOOL SwapContents, UI32 SwapLimit);
PDF_EXP LBOOL  PDF_CALL pdfSetUseSwapFileEx(const PPDF* IPDF, LBOOL SwapContents, UI32 SwapLimit, const char* SwapDir);
PDF_EXP LBOOL  PDF_CALL pdfSetUseSystemFonts(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseTransparency(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetUseVisibleCoords(const PPDF* IPDF, LBOOL Value);
PDF_EXP LBOOL  PDF_CALL pdfSetViewerPreferences(const PPDF* IPDF, TViewerPreference Value, TViewPrefAddVal AddVal);
PDF_EXP LBOOL  PDF_CALL pdfSetWMFDefExtent(const PPDF* IPDF, UI32 Width, UI32 Height);
PDF_EXP LBOOL  PDF_CALL pdfSetWMFPixelPerInch(const PPDF* IPDF, UI32 Value);
PDF_EXP LBOOL  PDF_CALL pdfSetWordSpacing(const PPDF* IPDF, double Value);
PDF_EXP LBOOL  PDF_CALL pdfSetXFAStream(const PPDF* IPDF, UI32 Index, const void* Buffer, UI32 BufSize);
PDF_EXP LBOOL  PDF_CALL pdfSkewCoords(const PPDF* IPDF, double alpha, double beta, double OriginX, double OriginY);
PDF_EXP LBOOL  PDF_CALL pdfSortFieldsByIndex(const PPDF* IPDF);
PDF_EXP LBOOL  PDF_CALL pdfSortFieldsByName(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfSquareAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Comment);
PDF_EXP SI32   PDF_CALL pdfSquareAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Comment);
PDF_EXP SI32   PDF_CALL pdfStampAnnotA(const PPDF* IPDF, TRubberStamp SubType, double PosX, double PosY, double Width, double Height, const char* Author, const char* Subject, const char* Comment);
PDF_EXP SI32   PDF_CALL pdfStampAnnotW(const PPDF* IPDF, TRubberStamp SubType, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Subject, const UI16* Comment);
PDF_EXP SI32   PDF_CALL pdfStrLenA(const char* AStr);
PDF_EXP SI32   PDF_CALL pdfStrLenW(const UI16* AStr);
PDF_EXP LBOOL  PDF_CALL pdfStrokePath(const PPDF* IPDF);
PDF_EXP SI32   PDF_CALL pdfTestGlyphsA(const PPDF* IPDF, SI32 FontHandle, const char* Text);
PDF_EXP SI32   PDF_CALL pdfTestGlyphsW(const PPDF* IPDF, SI32 FontHandle, const UI16* Text);
PDF_EXP SI32   PDF_CALL pdfTestGlyphsExA(const PPDF* IPDF, SI32 FontHandle, const char* Text, UI32 Len);
PDF_EXP SI32   PDF_CALL pdfTestGlyphsExW(const PPDF* IPDF, SI32 FontHandle, const UI16* Text, UI32 Len);
PDF_EXP LBOOL  PDF_CALL pdfTestPassword(const PPDF* IPDF, TPwdType PwdType, const char* Value);
PDF_EXP SI32   PDF_CALL pdfTextAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* Text, TAnnotIcon Icon, LBOOL Open);
PDF_EXP SI32   PDF_CALL pdfTextAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Text, TAnnotIcon Icon, LBOOL Open);
PDF_EXP LBOOL  PDF_CALL pdfTranslateCoords(const PPDF* IPDF, double OriginX, double OriginY);
PDF_EXP LBOOL  PDF_CALL pdfTriangle(const PPDF* IPDF, double x1, double y1, double x2, double y2, double x3, double y3, TPathFillMode FillMode);
PDF_EXP LBOOL  PDF_CALL pdfUnLockLayer(const PPDF* IPDF, UI32 Layer);
PDF_EXP UI32*  PDF_CALL pdfUTF16ToUTF32(const PPDF* IPDF, const UI16* Source);
PDF_EXP UI32*  PDF_CALL pdfUTF16ToUTF32Ex(const PPDF* IPDF, const UI16* Source, UI32 ADDR Len);
PDF_EXP UI16*  PDF_CALL pdfUTF32ToUTF16(const PPDF* IPDF, const UI32* Source);
PDF_EXP UI16*  PDF_CALL pdfUTF32ToUTF16Ex(const PPDF* IPDF, const UI32* Source, UI32 ADDR Len);
PDF_EXP SI32   PDF_CALL pdfWatermarkAnnot(const PPDF* IPDF, double PosX, double PosY, double Width, double Height);
PDF_EXP SI32   PDF_CALL pdfWebLinkA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* URL);
PDF_EXP SI32   PDF_CALL pdfWebLinkW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* URL);
PDF_EXP LBOOL  PDF_CALL pdfWriteAngleTextA(const PPDF* IPDF, const char* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin);
PDF_EXP LBOOL  PDF_CALL pdfWriteAngleTextW(const PPDF* IPDF, const UI16* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin);
PDF_EXP LBOOL  PDF_CALL pdfWriteFTextA(const PPDF* IPDF, TTextAlign Align, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteFTextW(const PPDF* IPDF, TTextAlign Align, const UI16* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteFTextExA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TTextAlign Align, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteFTextExW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TTextAlign Align, const UI16* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextA(const PPDF* IPDF, double PosX, double PosY, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextW(const PPDF* IPDF, double PosX, double PosY, const UI16* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextExA(const PPDF* IPDF, double PosX, double PosY, const char* AText, UI32 Len);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextExW(const PPDF* IPDF, double PosX, double PosY, const UI16* AText, UI32 Len);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextMatrixA(const PPDF* IPDF, struct TCTM* M, const char* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextMatrixW(const PPDF* IPDF, struct TCTM* M, const UI16* AText);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextMatrixExA(const PPDF* IPDF, struct TCTM* M, const char* AText, UI32 Len);
PDF_EXP LBOOL  PDF_CALL pdfWriteTextMatrixExW(const PPDF* IPDF, struct TCTM* M, const UI16* AText, UI32 Len);

// This is an internal debugging function that does nothing in a release build!
PDF_EXP SI32 PDF_CALL pdfDebugPDFFile(const PPDF* IPDF);

#if defined(_UNICODE) || defined(UNICODE)
   #define rasSetCMapDir               rasSetCMapDirW

   #define tblSetCellImage             tblSetCellImageW
   #define tblSetCellText              tblSetCellTextW
   #define tblSetFont                  tblSetFontW

   #define pdfAddBookmark              pdfAddBookmarkW
   #define pdfAddBookmarkEx            pdfAddBookmarkExW
   #define pdfAddBookmarkEx2           pdfAddBookmarkEx2W
   #define pdfAddButtonImage           pdfAddButtonImageW
   #define pdfAddContinueText          pdfAddContinueTextW
   #define pdfAddFontSearchPath        pdfAddFontSearchPathW
   #define pdfAddFileComment           pdfAddFileCommentW
   #define pdfAddJavaScript            pdfAddJavaScriptW
   #define pdfAddLayerToDisplTree      pdfAddLayerToDisplTreeW
   #define pdfAddOutputIntent          pdfAddOutputIntentW
   #define pdfAddPageLabel             pdfAddPageLabelW
   #define pdfAddRenderingIntent       pdfAddRenderingIntentW
   #define pdfAddValToChoiceField      pdfAddValToChoiceFieldW
   #define pdfAttachFile               pdfAttachFileW
   #define pdfAttachFileEx             pdfAttachFileExW
   #define pdfCaretAnnot               pdfCaretAnnotW
   #define pdfChangeAnnotName          pdfChangeAnnotNameW
   #define pdfChangeBookmark           pdfChangeBookmarkW
   #define pdfChangeJavaScript         pdfChangeJavaScriptW
   #define pdfChangeJavaScriptAction   pdfChangeJavaScriptActionW
   #define pdfChangeJavaScriptName     pdfChangeJavaScriptNameW
   #define pdfChangeNamedDest          pdfChangeNamedDestW
   #define pdfChangeOCGName            pdfChangeOCGNameW
   #define pdfCircleAnnot              pdfCircleAnnotW
   #define pdfConvertEMFSpool          pdfConvertEMFSpoolW
   #define pdfCreate3DAnnot            pdfCreate3DAnnotW
   #define pdfCreate3DView             pdfCreate3DViewW
   #define pdfCreateArticleThread      pdfCreateArticleThreadW
   #define pdfCreateButton             pdfCreateButtonW
   #define pdfCreateCollectionField    pdfCreateCollectionFieldW
   #define pdfCreateColItemString      pdfCreateColItemStringW
   #define pdfCreateGoToEAction        pdfCreateGoToEActionW
   #define pdfCreateGoToRAction        pdfCreateGoToRActionW
   #define pdfCreateGoToRActionEx      pdfCreateGoToRActionExW
   #define pdfCreateGoToRActionExU     pdfCreateGoToRActionExUW
   #define pdfCreateICCBasedColorSpace pdfCreateICCBasedColorSpaceW
   #define pdfCreateImage              pdfCreateImageW
   #define pdfCreateImpDataAction      pdfCreateImpDataActionW
   #define pdfCreateJSAction           pdfCreateJSActionW
   #define pdfCreateLaunchActionEx     pdfCreateLaunchActionExW
   #define pdfCreateNamedDest          pdfCreateNamedDestW
   #define pdfCreateNewPDF             pdfCreateNewPDFW
   #define pdfCreateOCG                pdfCreateOCGW
   #define pdfCreateRectilinearMeasure pdfCreateRectilinearMeasureW
   #define pdfCreateViewport           pdfCreateViewportW
   #define pdfCreateXFAStream          pdfCreateXFAStreamW
   #define pdfDecryptPDF               pdfDecryptPDFW
   #define pdfDeleteNamedDest          pdfDeleteNamedDestW
   #define pdfEncryptPDF               pdfEncryptPDFW
   #define pdfFileAttachAnnot          pdfFileAttachAnnotW
   #define pdfFileAttachAnnotEx        pdfFileAttachAnnotExW
   #define pdfFileLink                 pdfFileLinkW
   #define pdfFindBookmark             pdfFindBookmarkW
   #define pdfFindEmbeddedFile         pdfFindEmbeddedFileW
   #define pdfFindField                pdfFindFieldW
   #define pdfFreeTextAnnot            pdfFreeTextAnnotW
   #define pdfGetFTextHeight           pdfGetFTextHeightW
   #define pdfGetFTextHeightEx         pdfGetFTextHeightExW
   #define pdfGetImageCount            pdfGetImageCountW
   #define pdfGetLogMetafileSize       pdfGetLogMetafileSizeW
   #define pdfGetTextBBox              pdfGetTextBBoxW
   #define pdfGetTextWidthEx           pdfGetTextWidthExW
   #define pdfGetTextWidth             pdfGetTextWidthW
   #define pdfHighlightAnnot           pdfHighlightAnnotW
   #define pdfInkAnnot                 pdfInkAnnotW
   #define pdfInsertBookmark           pdfInsertBookmarkW
   #define pdfInsertBookmarkEx         pdfInsertBookmarkExW
   #define pdfInsertImageEx            pdfInsertImageExW
   #define pdfInsertMetafile           pdfInsertMetafileW
   #define pdfInsertMetafileExt        pdfInsertMetafileExtW
   #define pdfInsertSVG                pdfInsertSVGW
   #define pdfLineAnnot                pdfLineAnnotW
   #define pdfLoadFDFData              pdfLoadFDFDataW
   #define pdfLoadFontEx               pdfLoadFontExW
   #define pdfOpenImportFile           pdfOpenImportFileW
   #define pdfOpenOutputFile           pdfOpenOutputFileW
   #define pdfOpenOutputFileEncrypted  pdfOpenOutputFileEncryptedW
   #define pdfOpenTag                  pdfOpenTagW
   #define pdfOpenTagBBox              pdfOpenTagBBoxW
   #define pdfOpenTagEx                pdfOpenTagExW
   #define pdfPageLink3                pdfPageLink3W
   #define pdfPolygonAnnot             pdfPolygonAnnotW
   #define pdfPolyLineAnnot            pdfPolyLineAnnotW
   #define pdfPrintPage                pdfPrintPageW
   #define pdfPrintPDFFile             pdfPrintPDFFileW
   #define pdfReadImageFormat          pdfReadImageFormatW
   #define pdfReadImageFormat2         pdfReadImageFormat2W
   #define pdfReadImageResolution      pdfReadImageResolutionW
   #define pdfReEncryptPDF             pdfReEncryptPDFW
   #define pdfRenderPageToImage        pdfRenderPageToImageW
   #define pdfRenderPDFFile            pdfRenderPDFFileW
   #define pdfRenderPDFFileEx          pdfRenderPDFFileExW
   #define pdfReplaceFont              pdfReplaceFontW
   #define pdfReplaceFontEx            pdfReplaceFontExW
   #define pdfReplaceICCProfile        pdfReplaceICCProfileW
   #define pdfReplaceImage             pdfReplaceImageW
   #define pdfReplacePageTextEx        pdfReplacePageTextExW
   #define pdfRichMediaAnnot           pdfRichMediaAnnotW
   #define pdfSetAltFonts              pdfSetAltFontsW
   #define pdfSetAnnotMigrationState   pdfSetAnnotMigrationStateW
   #define pdfSetAnnotString           pdfSetAnnotStringW
   #define pdfSetAnnotSubject          pdfSetAnnotSubjectW
   #define pdfSetCIDFont               pdfSetCIDFontW
   #define pdfSetCMapDir               pdfSetCMapDirW
   #define pdfSetDocInfo               pdfSetDocInfoW
   #define pdfSetDocInfoEx             pdfSetDocInfoExW
   #define pdfSetFieldExpValue         pdfSetFieldExpValueW
   #define pdfSetFieldFont             pdfSetFieldFontW
   #define pdfSetFieldMapName          pdfSetFieldMapNameW
   #define pdfSetFieldName             pdfSetFieldNameW
   #define pdfSetFieldToolTip          pdfSetFieldToolTipW
   #define pdfSetFont                  pdfSetFontW
   #define pdfSetFontEx                pdfSetFontExW
   #define pdfSetTextFieldValue        pdfSetTextFieldValueW
   #define pdfSetTextFieldValueEx      pdfSetTextFieldValueExW
   #define pdfSquareAnnot              pdfSquareAnnotW
   #define pdfStampAnnot               pdfStampAnnotW
   #define pdfTestGlyphs               pdfTestGlyphsW
   #define pdfTestGlyphsEx             pdfTestGlyphsExW
   #define pdfTextAnnot                pdfTextAnnotW
   #define pdfWebLink                  pdfWebLinkW
   #define pdfWriteAngleText           pdfWriteAngleTextW
   #define pdfWriteFText               pdfWriteFTextW
   #define pdfWriteFTextEx             pdfWriteFTextExW
   #define pdfWriteText                pdfWriteTextW
   #define pdfWriteTextEx              pdfWriteTextExW
   #define pdfWriteTextMatrix          pdfWriteTextMatrixW
   #define pdfWriteTextMatrixEx        pdfWriteTextMatrixExW
#else
   #define rasSetCMapDir               rasSetCMapDirA

   #define tblSetCellImage             tblSetCellImageA
   #define tblSetCellText              tblSetCellTextA
   #define tblSetFont                  tblSetFontA

   #define pdfAddBookmark              pdfAddBookmarkA
   #define pdfAddBookmarkEx            pdfAddBookmarkExA
   #define pdfAddBookmarkEx2           pdfAddBookmarkEx2A
   #define pdfAddButtonImage           pdfAddButtonImageA
   #define pdfAddContinueText          pdfAddContinueTextA
   #define pdfAddFileComment           pdfAddFileCommentA
   #define pdfAddFontSearchPath        pdfAddFontSearchPathA
   #define pdfAddJavaScript            pdfAddJavaScriptA
   #define pdfAddLayerToDisplTree      pdfAddLayerToDisplTreeA
   #define pdfAddOutputIntent          pdfAddOutputIntentA
   #define pdfAddPageLabel             pdfAddPageLabelA
   #define pdfAddRenderingIntent       pdfAddRenderingIntentA
   #define pdfAddValToChoiceField      pdfAddValToChoiceFieldA
   #define pdfAttachFile               pdfAttachFileA
   #define pdfAttachFileEx             pdfAttachFileExA
   #define pdfCaretAnnot               pdfCaretAnnotA
   #define pdfChangeAnnotName          pdfChangeAnnotNameA
   #define pdfChangeBookmark           pdfChangeBookmarkA
   #define pdfChangeJavaScript         pdfChangeJavaScriptA
   #define pdfChangeJavaScriptAction   pdfChangeJavaScriptActionA
   #define pdfChangeJavaScriptName     pdfChangeJavaScriptNameA
   #define pdfChangeNamedDest          pdfChangeNamedDestA
   #define pdfChangeOCGName            pdfChangeOCGNameA
   #define pdfCircleAnnot              pdfCircleAnnotA
   #define pdfConvertEMFSpool          pdfConvertEMFSpoolA
   #define pdfCreate3DAnnot            pdfCreate3DAnnotA
   #define pdfCreate3DView             pdfCreate3DViewA
   #define pdfCreateArticleThread      pdfCreateArticleThreadA
   #define pdfCreateButton             pdfCreateButtonA
   #define pdfCreateCollectionField    pdfCreateCollectionFieldA
   #define pdfCreateColItemString      pdfCreateColItemStringA
   #define pdfCreateGoToEAction        pdfCreateGoToEActionA
   #define pdfCreateGoToRAction        pdfCreateGoToRActionA
   #define pdfCreateGoToRActionEx      pdfCreateGoToRActionExA
   #define pdfCreateGoToRActionExU     pdfCreateGoToRActionExUA
   #define pdfCreateICCBasedColorSpace pdfCreateICCBasedColorSpaceA
   #define pdfCreateImage              pdfCreateImageA
   #define pdfCreateImpDataAction      pdfCreateImpDataActionA
   #define pdfCreateJSAction           pdfCreateJSActionA
   #define pdfCreateLaunchActionEx     pdfCreateLaunchActionExA
   #define pdfCreateNamedDest          pdfCreateNamedDestA
   #define pdfCreateNewPDF             pdfCreateNewPDFA
   #define pdfCreateOCG                pdfCreateOCGA
   #define pdfCreateRectilinearMeasure pdfCreateRectilinearMeasureA
   #define pdfCreateViewport           pdfCreateViewportA
   #define pdfCreateXFAStream          pdfCreateXFAStreamA
   #define pdfDecryptPDF               pdfDecryptPDFA
   #define pdfDeleteNamedDest          pdfDeleteNamedDestA
   #define pdfEncryptPDF               pdfEncryptPDFA
   #define pdfFileAttachAnnot          pdfFileAttachAnnotA
   #define pdfFileAttachAnnotEx        pdfFileAttachAnnotExA
   #define pdfFileLink                 pdfFileLinkA
   #define pdfFindBookmark             pdfFindBookmarkA
   #define pdfFindEmbeddedFile         pdfFindEmbeddedFileA
   #define pdfFindField                pdfFindFieldA
   #define pdfFreeTextAnnot            pdfFreeTextAnnotA
   #define pdfGetFTextHeight           pdfGetFTextHeightA
   #define pdfGetImageCount            pdfGetImageCountA
   #define pdfGetLogMetafileSize       pdfGetLogMetafileSizeA
   #define pdfGetFTextHeightEx         pdfGetFTextHeightExA
   #define pdfGetTextBBox              pdfGetTextBBoxA
   #define pdfGetTextWidthEx           pdfGetTextWidthExA
   #define pdfGetTextWidth             pdfGetTextWidthA
   #define pdfHighlightAnnot           pdfHighlightAnnotA
   #define pdfInkAnnot                 pdfInkAnnotA
   #define pdfInsertBookmark           pdfInsertBookmarkA
   #define pdfInsertBookmarkEx         pdfInsertBookmarkExA
   #define pdfInsertImageEx            pdfInsertImageExA
   #define pdfInsertMetafile           pdfInsertMetafileA
   #define pdfInsertMetafileExt        pdfInsertMetafileExtA
   #define pdfInsertSVG                pdfInsertSVGA
   #define pdfLineAnnot                pdfLineAnnotA
   #define pdfLoadFDFData              pdfLoadFDFDataA
   #define pdfLoadFontEx               pdfLoadFontExA
   #define pdfOpenImportFile           pdfOpenImportFileA
   #define pdfOpenOutputFile           pdfOpenOutputFileA
   #define pdfOpenOutputFileEncrypted  pdfOpenOutputFileEncryptedA
   #define pdfOpenTag                  pdfOpenTagA
   #define pdfOpenTagBBox              pdfOpenTagBBoxA
   #define pdfOpenTagEx                pdfOpenTagExA
   #define pdfPageLink3                pdfPageLink3A
   #define pdfPolygonAnnot             pdfPolygonAnnotA
   #define pdfPolyLineAnnot            pdfPolyLineAnnotA
   #define pdfPrintPage                pdfPrintPageA
   #define pdfPrintPDFFile             pdfPrintPDFFileA
   #define pdfReadImageFormat          pdfReadImageFormatA
   #define pdfReadImageFormat2         pdfReadImageFormat2A
   #define pdfReadImageResolution      pdfReadImageResolutionA
   #define pdfReEncryptPDF             pdfReEncryptPDFA
   #define pdfRenderPageToImage        pdfRenderPageToImageA
   #define pdfRenderPDFFile            pdfRenderPDFFileA
   #define pdfRenderPDFFileEx          pdfRenderPDFFileExA
   #define pdfReplaceFont              pdfReplaceFontA
   #define pdfReplaceFontEx            pdfReplaceFontExA
   #define pdfReplaceICCProfile        pdfReplaceICCProfileA
   #define pdfReplaceImage             pdfReplaceImageA
   #define pdfReplacePageText          pdfReplacePageTextA
   #define pdfReplacePageTextEx        pdfReplacePageTextExA
   #define pdfRichMediaAnnot           pdfRichMediaAnnotA
   #define pdfSet3DAnnotScript         pdfSet3DAnnotScriptA
   #define pdfSetAltFonts              pdfSetAltFontsA
   #define pdfSetAnnotMigrationState   pdfSetAnnotMigrationStateA
   #define pdfSetAnnotString           pdfSetAnnotStringA
   #define pdfSetAnnotSubject          pdfSetAnnotSubjectA
   #define pdfSetCIDFont               pdfSetCIDFontA
   #define pdfSetCMapDir               pdfSetCMapDirA
   #define pdfSetDocInfo               pdfSetDocInfoA
   #define pdfSetDocInfoEx             pdfSetDocInfoExA
   #define pdfSetFieldExpValue         pdfSetFieldExpValueA
   #define pdfSetFieldFont             pdfSetFieldFontA
   #define pdfSetFieldMapName          pdfSetFieldMapNameA
   #define pdfSetFieldName             pdfSetFieldNameA
   #define pdfSetFieldToolTip          pdfSetFieldToolTipA
   #define pdfSetFont                  pdfSetFontA
   #define pdfSetFontEx                pdfSetFontExA
   #define pdfSetTextFieldValue        pdfSetTextFieldValueA
   #define pdfSetTextFieldValueEx      pdfSetTextFieldValueExA
   #define pdfSquareAnnot              pdfSquareAnnotA
   #define pdfStampAnnot               pdfStampAnnotA
   #define pdfTestGlyphs               pdfTestGlyphsA
   #define pdfTestGlyphsEx             pdfTestGlyphsExA
   #define pdfTextAnnot                pdfTextAnnotA
   #define pdfWebLink                  pdfWebLinkA
   #define pdfWriteAngleText           pdfWriteAngleTextA
   #define pdfWriteFText               pdfWriteFTextA
   #define pdfWriteFTextEx             pdfWriteFTextExA
   #define pdfWriteText                pdfWriteTextA
   #define pdfWriteTextEx              pdfWriteTextExA
   #define pdfWriteTextMatrix          pdfWriteTextMatrixA
   #define pdfWriteTextMatrixEx        pdfWriteTextMatrixExA
#endif

#endif // end PDF_USE_CLASS

#ifdef __cplusplus
} // end namespace
#endif

#if defined(__BORLANDC__)
   #pragma option pop
#endif

#if defined(_MSC_VER) && _MSC_VER >= 1929
   #pragma warning(pop)
#endif

#endif

