#include <stdio.h>
#include <stdlib.h>
#include "../dynapdf/dynapdf.h"

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   // The error type is a bitmask, see help file for further information.
   if (ErrType & E_WARNING)
      printf("Warning: %s\n", ErrMessage);
   else if (ErrType & E_SYNTAX_ERROR)
      printf("Syntax error!: %s\n", ErrMessage);
   else if (ErrType & E_VALUE_ERROR)
      printf("Value error: %s\n", ErrMessage);
   else if (ErrType & E_FONT_ERROR)
      printf("TrueType font error!: %s\n", ErrMessage);
   else if (ErrType & E_FILE_ERROR)
      printf("File error: %s\n", ErrMessage);
   else if (ErrType & E_FATAL_ERROR)
      printf("Fatal error: %s\n", ErrMessage);
   else
      printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(void)
{
   void* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetDocInfo(pdf, diCreator, "C++ Example project");
   pdfSetDocInfo(pdf, diTitle, "My first PDF output");

   char outFile[] = "hello_world.pdf";
   pdfCreateNewPDF(pdf, outFile);
   pdfAppend(pdf);
   //Copy your fonts into a directory and add it then to the list of search paths.
   //Otherwise, only the 14 standard fonts can be used.
   //pdfAddFontSearchPath(pdf, "MyFontDirectory", false);
   pdfSetFont(pdf, "Helvetica", fsItalic, 20.0, true, cp1252);
   pdfWriteFText(pdf, taCenter, "My first PDF output...");
   pdfEndPage(pdf);
   pdfCloseFile(pdf);

   pdfDeletePDF(pdf);
   printf("PDF file %s successfully created!\n", outFile);
   return 0;
}
