Attribute VB_Name = "DynaPDFInt2"
Option Explicit

' **********************************************************************************
'
' All structure wich end with "_I" are normally private but the class CPDF.cls reached
' already the maximum size. So, we have no other chance as declaring such structures
' as public since private declarations are not allowed in modules.
'
' **********************************************************************************

' Every header or footer string supports the following numbering and date formats:
'
' Bates numbering syntax: Bates#0..10#1..2147483648 (case-sensitive). The number sign (#) is part of the syntax and is required.
' No spaces before or after the number sign or before and after the keyword 'Bates' are allowed.
'
' <<Bates#6#1>>  // Six digits, numbering starts at 1 -> 000001.
' <<Bates#10#5>> // Ten digits, numbering starts at 5 -> 0000000005.
' << Bates#6#1>> // Wrong, no space is not allowed.
' <<bates#6#1>>  // Wrong, the correct keyword name is 'Bates'.
'
' Date formats:
'
' The date format supports three characters: m = month, d = day, y = year.
' Each character can be repeated to define the number of digits, e.g. mm, or yyyy are examples. Allowed delimiters are '.', '-', and '/'.
'
' <<yy/mm/d>>    // Ok
' <<mm-d/yy>>    // Unusual but ok
' <y/mm/d>>      // Wrong, missing '<' and a valid year format has either 2 or 4 digits
' <<yyyy:mm:dd>> // Wrong, invalid delimiter
'
' Page numbering:
'
' The page number format has two reserved characters:
'
'  0..2147483648 -> The number is added to the current page index (the first page is denoted by 0). Default = 1.
'  'n'           -> Is replaced by the number of pages. The 'n' must be surrounded by an escape character, otherwise it is treated as text.
'  Escapes chars -> ' ', ')', '(', '[', ']', '<', '>', '/', '%', '{', '}'.
'
' Arbitrary text can occur before, between, and after a reserved character.
' Example results on the first page if the document has 57 pages:
'
' <<28>>              // Ok, 28 is added to the page index.                              -> "28"
' << Page 4 of n>>    // Ok                                                              -> " Page 4 of 57"
' <<1/n>>             // Ok                                                              -> "1/57"
' <<0/n>>             // Ok, but unusual. The first page number would be 0 in this case. -> "0/57"
' <<-5 of n>>         // Ok, note that the minus is treated as text!                     -> "-5 of 57"
' <<Page1 ofn pages>> // Ok, but the 'n' is treated as text.                             -> "Page1 ofn pages"
' <<Page 5 of n>>     // Ok, 5 is added to the page index.                               -> "Page 5 of 57".
' <<Seite 1 von n>>   // Ok, note which 'n' is replaced by the number of pages.          -> "Seite 1 von 57"
' <<Page>>            // Wrong, nothing to do. Treated as text.                          -> "<<Page>>"

Public Type TPDFHdrFtr
   Color As Long          ' Text color.
   CS As TExtColorSpace   ' Color space -> default = esInitSpace.
   CSHandle As Long       ' Optional color space handle if CS is set to a non-device space.

   CodePage As TCodepage  ' The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   Embed As Boolean       ' If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   Font As String         ' Optional font name.
   FontSize As Single     ' Font size -> considered only if Font is set.
   FontType As String     ' Out -> Optional font type ("TrueType", "OpenType", or "Type1").

   IsHeader As Boolean    ' If true, the record is treated as header.
   Position As TTextAlign ' Valid values are taLeft, taCenter, and taRight.
   ShiftX As Single       ' Positive values move the text to the right, negative to the left.
   ShiftY As Single       ' Positive values move the text up or down depending on the used coordinate system (top down or bottom up). Negative values move the text into the opposite direction.
   text As String         ' The text that should be output. Either the Ansi or Unicode string must be set.
End Type

Public Enum TPDFHdrFtrFlags
   hffDefault = 3     ' Output header / footer text on even and odd pages
   hffEvenPages = 1   ' Output header / footer text on even pages
   hffOddPages = 2    ' Output header / footer text on odd pages
   hffFixedPrint = 4  ' Can be set by LoadHeaderFooterSettings(). Not considered yet.
   hffLoadUTF8 = 8    ' Load all strings in UTF-8 format.
   hffShrink = 16     ' Can be set by LoadHeaderFooterSettings(). Not considered yet.
   hffLoadBatesN = 32 ' If set, LoadHeaderFooterSetting() loads bates numbers only.
   hffLoadHF = 64     ' If set, LoadHeaderFooterSetting() loads header / footer settings only.
   hffSearchRun = 128 ' Scan the file for available header / footer types. See LoadHeaderFooterSetting() for further information.
End Enum

Public Type TPDFHeaderFooter
   FirstPage As Long         ' In/Out -> The first output page.
   Flags As TPDFHdrFtrFlags  ' In/Out -> Additional processing flags.
   InitColor As Long         ' In/Out -> Initial text color.
   InitCS As TExtColorSpace  ' In/Out -> Initial color space -> default = esDeviceGray.
   InitCSHandle As Long      ' In     -> Optional color space handle if InitCS is set to a non-device space.
   InitDate As String        ' Out    -> Initial date format.
   InitCodepage As TCodepage ' In/Out -> The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   InitEmbed As Boolean      ' In     -> If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   InitFont As String        ' In/Out -> Optional font name.
   InitFontSize As Single    ' In/Out -> Optional font size. Considered only if a font name is set.
   InitFontType As String    ' Out    -> Optional font type ("TrueType", "OpenType", or "Type1").
   InitPageFormat As String  ' Out    -> Initial page format string.
   LastPage As Long          ' In/Out -> The last output page.
   Margin As TFltRect        ' In/Out -> Margin to output the header/footer text.
End Type

Public Type TPDFHdrFtr_I
   Color As Long          ' Text color.
   CS As TExtColorSpace   ' Color space -> default = esInitSpace.
   CSHandle As Long       ' Optional color space handle if CS is set to a non-device space.
   CodePage As TCodepage  ' The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   Embed As Long          ' If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   Reserved1 As Long      ' Placeholder to avoid alignment issues
   FontA As Long          ' Optional font name.
   FontW As Long          ' Optional font name.
   FontSize As Single     ' Font size -> considered only if a font name is set.
   Reserved2 As Long      ' Placeholder to avoid alignment issues
   FontType As Long       ' Optional font type ("TrueType", "OpenType", or "Type1").
   IsHeader As Long       ' If true, the record is treated as header.
   Position As TTextAlign ' Valid values are taLeft, taCenter, and taRight.
   ShiftX As Single       ' Positive values move the text to the right, negative to the left.
   ShiftY As Single       ' Positive values move the text up or down depending on the used coordinate system (top down or bottom up). Negative values move the text into the opposite direction.
   TextA As Long          ' The text that should be output. Either the Ansi or Unicode string must be set.
   TextW As Long          ' The text that should be output. Either the Ansi or Unicode string must be set.
   TextLen As Long        ' Text length in characters.
   Reserved3 As Long      ' Placeholder to avoid alignment issues
End Type

Public Type TPDFHeaderFooter_I
   StructSize As Long        ' Must be set to sizeof(TPDFHeaderFooter).
   FirstPage As Long         ' In/Out -> The first output page.
   Flags As TPDFHdrFtrFlags  ' In/Out -> Additional processing flags.
   InitColor As Long         ' In/Out -> Initial text color.
   InitCS As TExtColorSpace  ' In/Out -> Initial color space -> default = esDeviceGray.
   InitCSHandle As Long      ' In     -> Optional color space handle if InitCS is set to a non-device space.
   InitDate As Long          ' Out    -> Initial date format.
   InitCodepage As TCodepage ' In/Out -> The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   InitEmbed As Long         ' In     -> If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   InitFontA As Long         ' In/Out -> Optional font name.
   InitFontW As Long         ' In/Out -> Optional font name.
   InitFontSize As Single    ' In/Out -> Optional font size. Considered only if a font name is set.
   Reserved As Long          ' Placeholder to avoid alignment issues
   InitFontType As Long      ' Out    -> Optional font type ("TrueType", "OpenType", or "Type1").
   InitPageFormatA As Long   ' Out    -> Initial page format string.
   InitPageFormatW As Long   ' Out    -> Initial page format string.
   LastPage As Long          ' In/Out -> The last output page.
   Margin As TFltRect        ' In/Out -> Margin to output the header/footer text.
End Type

' ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Public Type TContent
   Count As Long ' Number of available operators.
   OP As Long    ' Array of operators.
End Type

Public Type TContentParseParms
   StructSize As Long ' Automatically set
   InitMatrix As TCTM ' Considered only if the flag cpfInitMatrix is set.
End Type

Public Type TTextSelection
   StructSize As Long ' Must be set to sizeof(TTextSelection).
   Line As Long       ' Index of the text line.
   Matrix As TCTM     ' Text matrix pre-calculated in user space.
   Sub1 As Long       ' Index of the text node.
   Sub2 As Long       ' Index of the sub text node.
   TextLen As Long    ' How many characters of this record are selected?
   TextOP As Long     ' The text record in which the text was found. The real declaration follows later...
   TextPos As Long    ' Index where the first character of the search text was found.
   X As Single        ' X-Coordinate in text space
   Y As Single        ' Y-Coordinate in text space
   NextNode As Long   ' Next record if the search text spans multiple text records. (TTextSelection)
   PrevNode As Long   ' Prev record if any. (TTextSelection)
   Reserved As Long   ' Placeholder to avoid alignment issues
End Type

Public Type TPDFVersionInfo
   Major As Long             ' PDF major version, e.g. 1
   Minor As Long             ' PDF minor version, e.g. 7
   MainVer As String         ' Set only if the file conforms to a specific PDF standard, e.g. "PDF/X 1a:2003", "PDF/A 3b", and so on.
   SubVer As String          ' e.g. "ZUGFeRD 2.0", "Factur-X", and so on

   PDFAConformance As String ' e.g. A, B, E, F, U, or UA.
   PDFAVersion As Long       ' If greater zero, this is a PDF/A file.
   ' PDF/E
   PDFEVersion As String     ' e.g. PDF/E-1
   ' PDF/VT
   PDFVTModDate As String    ' Modification date, e.g. 2016-05-07T15:42:23+01:00
   PDFVTVersion As String    ' e.g. PDF/VT-2
   ' PDF/X
   PDFXConformance As String ' e.g. PDF/X-1a:2001 or PDF/X-1a:2003. PDF/X 3 and above do not set this key anymore.
   PDFXVersion As String     ' e.g. PDF/X-1:2001, PDF/X-1:2003, and so on.
   ' ZUGFeRD, Factur-X, XRechnung
   FXConfLevel As String     ' ConformanceLevel
   FXDocName As String       ' DocumentFileName
   FXDocType As String       ' DocumentType
   FXVersion As String       ' Version
   VersionConst As Long      ' If >= 0 this is the TPDFVersion constant as integer. If the version is not supported by DynaPDF, this member is set to -1.
End Type

Public Type TPDFVersionInfo_I
   StructSize As Long      ' Must be set to sizeof(TPDFVersionInfo)
   Major As Long           ' PDF major version, e.g. 1
   Minor As Long           ' PDF minor version, e.g. 7
   MainVer As Long         ' Set only if the file conforms to a specific PDF standard, e.g. "PDF/X 1a:2003", "PDF/A 3b", and so on.
   SubVer As Long          ' e.g. "ZUGFeRD 2.0", "Factur-X", and so on
   ' PDF/A
   PDFAConformance As Long ' e.g. A, B, E, F, U, or UA.
   PDFAVersion As Long     ' If greater zero, this is a PDF/A file.
   ' PDF/E
   PDFEVersion As Long     ' e.g. PDF/E-1
   ' PDF/VT
   PDFVTModDate As Long    ' Modification date, e.g. 2016-05-07T15:42:23+01:00
   PDFVTVersion As Long    ' e.g. PDF/VT-2
   ' PDF/X
   PDFXConformance As Long ' e.g. PDF/X-1a:2001 or PDF/X-1a:2003. PDF/X 3 and above do not set this key anymore.
   PDFXVersion As Long     ' e.g. PDF/X-1:2001, PDF/X-1:2003, and so on.
   ' ZUGFeRD, Factur-X, XRechnung
   FXConfLevel As Long     ' ConformanceLevel
   FXDocName As Long       ' DocumentFileName
   FXDocType As Long       ' DocumentType
   FXVersion As Long       ' Version
   VersionConst As Long    ' If >= 0 this is the TPDFVersion constant as integer. If the version is not supported by DynaPDF, this member is set to -1.
End Type

' ---------------------------------- Private API functions ----------------------------
' These functions should normally be declared as private functions in the file CPDF.cls but this file reached the maximum size...

Public Declare Function pdfActivateAltFontList Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal EnableSysFonts As Long) As Long
Public Declare Function pdfAddDPartNode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Parent As Long, ByVal FirstPage As Long, ByVal LastPage As Long, ByVal DPM As String) As Long
Public Declare Function pdfAddHeaderFooter Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Value As TPDFHeaderFooter_I, ByVal HFArray As Long, ByVal Count As Long) As Long
Public Declare Function pdfChangeOCGNameW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As Long) As Long
Public Declare Function pdfConvToFreeTextCallout Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal StartX As Single, ByVal StartY As Single, ByVal KneeOffset As Single, ByVal EndStyle As TLineEndStyle) As Long
Public Declare Function pdfCreateAltFontList Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Public Declare Function pdfCreateDPartRoot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NodeNameList As Long, ByVal NodeNamesCount As Long, ByVal RecordLevel As Long) As Long
Public Declare Function pdfCreateGeospatialMeasure Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Viewport As Long, ByVal Attributes As String) As Long
Public Declare Function pdfDeleteAltFontList Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Public Declare Function pdfDeleteDPartNode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Public Declare Function pdfDeleteNamedDestW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long) As Long
Public Declare Function pdfDeleteNamedDestByIndex Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Public Declare Function pdfDeleteOCGFromDisplayTree Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OCGHandle As Long, ByVal Recursive As Long) As Long
Public Declare Function pdfDeleteOCUINode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Node As Long) As Long
Public Declare Function pdfDeleteWatermark Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal InclAnnots As Long) As Long
Public Declare Function pdfEnableImageCache Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal MaxImageCount As Long, ByVal Size As Long) As Long
Public Declare Function pdfGetFontSize Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Public Declare Function pdfGetFullyQualifiedFieldName Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As Long) As Long
Public Declare Function pdfGetInIsTaggedPDF Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Public Declare Function pdfGetInPDFVersionEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Value As TPDFVersionInfo_I) As Long
Public Declare Function pdfGetLastTextPosXAbs Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Public Declare Function pdfGetLastTextPosYAbs Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Public Declare Function pdfGetPDFVersionEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Value As TPDFVersionInfo_I) As Long
Public Declare Function pdfHaveDPartRoot Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Public Declare Function pdfInitHeaderFooter Lib "dynapdf.dll" (ByRef Value As TPDFHeaderFooter_I, ByVal HFArray As Long, ByVal Count As Long) As Long
Public Declare Function pdfLoadHeaderFooterSettings Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Value As TPDFHeaderFooter_I, ByVal HFArray As Long) As Long
Public Declare Function pdfMarkTemplateAsWatermark Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Public Declare Function pdfOpenTagExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Tag As TPDFBaseTag, ByVal Lang As String, ByVal AltText As Long, ByVal Expansion As Long, ByVal Attributes As String) As Long
Public Declare Function pdfSetAltFontsW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ListHandle As Long, ByVal List As Long, ByVal Count As Long) As Long
Public Declare Function pdfSetPageOrientation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PagePtr As Long, ByVal Value As Long) As Long
Public Declare Function pdfSetSpaceWidthFactor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Public Declare Function pdfSetLineAnnotPoints Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef p1 As TFltPoint, ByRef p2 As TFltPoint) As Long
Public Declare Function pdfSetActiveSigField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
