VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CPDFContentParser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Enum TContentParseFlags
   cpfDefault = &H0               ' Nothing special to do.
   cpfComputeBBox = &H1           ' Compute bounding boxes of all objects.
   cpfFlattenLayers = &H2         ' Flatten layers.
   cpfSkipInvisibleObjects = &H4  ' Ignore invisible objects.
   cpfFullRecursive = &H8         ' Parse all objects recursively.
   cpfNoInlineTemplate = &H10     ' Do not resolve templates with a reference count of 1.
   cpfCalcDeviceColors = &H20     ' Compute device colors of all colors which are set in the content streams.
   cpfImidiateMode = &H40         ' Internal. This flag is always set if the TPDFParseCallbacks structure is passed to ParsePage(). It disables certain optimisations.
   cpfNewLinkNames = &H80         ' Internal. Create new link names for all objects. This flag is used by Optimize() and CheckConformance().
   cpfEnableTextSelection = &H100 ' This flag is required to enable text selection and text extraction.
   cpfInitMatrix = &H200          ' The transformation matrix must be set in the TContentParseParms structure.
   cpfSkipClipPaths = &H400       ' Useful for debugging purposes.
   cpfSkipImages = &H800          ' Ignore all images. This flag is useful for text extraction.
   cpfSkipShadings = &H1000       ' Useful for debugging purposes.
   cpfSkipText = &H2000           ' Useful for debugging purposes.
   cpfSkipVector = &H4000         ' Useful for debugging purposes. Exclude vector graphics with exception of clipping paths.
End Enum

Enum TDeleteTextFlags
   dtfDefault = 0
End Enum

Enum TReplaceTextFlags
   rtfDefault = 0
End Enum
   
Enum TSearchType
   stDefault = 0         ' Case sensitive search
   stWholeWord = 1       ' Only whole words
   stCaseInSensitive = 2 ' Case insensitive search
   stMatchAlways = 4     ' Return every character that was found
   stSearchAsIs = 8      ' Disable sorting on the x-axis
End Enum

Private m_Ctx As Long
Private m_Instance As Long
Private m_PDF As CPDF

Private Declare Sub psrAbort Lib "dynapdf.dll" (ByVal ctx As Long)
Private Declare Function psrChangeAltFont Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Handle As Long) As Long
Private Declare Sub psrClearSelection Lib "dynapdf.dll" (ByVal ctx As Long)
Private Declare Function psrCreateParserContext Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As TOptimizeFlags, ByVal Parms As Long) As Long
Private Declare Function psrDeleteOperator Lib "dynapdf.dll" (ByVal ctx As Long, ByVal Index As Long) As Long
Private Declare Function psrDeleteOperatorInObject Lib "dynapdf.dll" (ByVal ctx As Long, ByVal ObjPtr As Long, ByVal Index As Long) As Long
Private Declare Sub psrDeleteParserContext Lib "dynapdf.dll" (ByRef ctx As Long)
Private Declare Function psrDeleteText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByRef Area As TFltRect, ByVal Flags As TDeleteTextFlags) As Long
Private Declare Function psrExtractText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Flags As TTextExtractionFlags, ByVal Area As Long, ByRef text As Long, ByRef TextLen As Long) As Long
Private Declare Function psrFindText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Area As Long, ByVal SearchType As TSearchType, ByVal Last As Long, ByVal text As Long, ByVal TextLen As Long, ByRef SelText As TTextSelection) As Long
Private Declare Function psrGetSelBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByRef SelText As TTextSelection, ByRef BBox As TBBox) As Long
Private Declare Function psrGetSelBBox2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef SelText As TTextSelection, ByVal QuadPoint As Long) As Long
Private Declare Function psrGetSelText Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef SelText As TTextSelection, ByRef text As Long, ByRef TextLen As Long) As Long
Private Declare Function psrParsePage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal UserData As Long, ByVal Funcs As Long, ByVal PageNum As Long, ByVal Flags As TContentParseFlags, ByVal Parms As Long, ByRef out As TContent) As Long
Private Declare Sub psrReset Lib "dynapdf.dll" (ByVal ctx As Long)
Private Declare Function psrReplaceSelText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Flags As TReplaceTextFlags, ByRef SelText As TTextSelection, ByVal text As Long, ByVal TextLen As Long) As Long
Private Declare Function psrSetAltFontW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Name As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
Private Declare Function psrWriteToPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ctx As Long, ByVal Flags As TOptimizeFlags, ByVal Parms As Long) As Long

Private Sub Class_Terminate()
   Call psrDeleteParserContext(m_Ctx)
   Set m_PDF = Nothing
End Sub

Friend Sub CreateParserContext(ByVal PDFInst As CPDF, ByVal Flags As TOptimizeFlags)
   ' We increment the reference counter of the PDF class to make sure that it will not be deleted before the parser is released
   If m_Ctx <> 0 Then
      Call psrDeleteParserContext(m_Ctx)
      Set m_PDF = Nothing
   End If
   Set m_PDF = PDFInst
   m_Instance = PDFInst.GetInstancePtr()
   m_Ctx = psrCreateParserContext(m_Instance, Flags, 0)
   If m_Ctx = 0 Then Err.Raise 1, , "Out of memory!"
End Sub

Friend Sub CreateParserContext2(ByVal PDFInst As CPDF, ByVal Flags As TOptimizeFlags, ByRef Parms As TOptimizeParams, Optional IncludeCSArray = False)
   ' We increment the reference counter of the PDF class to make sure that it will not be deleted before the parser is released
   Dim p As TOptimizeParams_I
   If m_Ctx <> 0 Then
      Call psrDeleteParserContext(m_Ctx)
      Set m_PDF = Nothing
   End If
   Set m_PDF = PDFInst
   m_Instance = PDFInst.GetInstancePtr()
   Call m_PDF.GetOptimizeParams(Parms, p, IncludeCSArray)
   m_Ctx = psrCreateParserContext(m_Instance, Flags, VarPtr(p))
   If m_Ctx = 0 Then Err.Raise 1, , "Out of memory!"
End Sub

Friend Sub Abort()
   Call psrAbort(m_Ctx)
End Sub

Friend Function ChangeAltFont(ByVal Handle As Long) As Boolean
   ChangeAltFont = psrChangeAltFont(m_Instance, m_Ctx, Handle) <> 0
End Function

Friend Sub ClearSelection()
   Call psrClearSelection(m_Ctx)
End Sub

Friend Function DeleteOperator(ByVal Index As Long) As Boolean
   DeleteOperator = psrDeleteOperator(m_Ctx, Index) <> 0
End Function

Friend Function DeleteOperatorInObject(ByVal ObjPtr As Long, ByVal Index As Long) As Boolean
   DeleteOperatorInObject = psrDeleteOperatorInObject(m_Ctx, ObjPtr, Index) <> 0
End Function

Friend Function DeleteText(ByVal Flags As TDeleteTextFlags, ByRef Area As TFltRect) As Boolean
   DeleteText = psrDeleteText(m_Instance, m_Ctx, Area, Flags) <> 0
End Function

Friend Function ExtractText(ByVal Flags As TTextExtractionFlags, ByRef text As String) As Boolean
   Dim txt As Long
   Dim txtLen As Long
   ExtractText = psrExtractText(m_Instance, m_Ctx, Flags, 0, txt, txtLen) <> 0
   If ExtractText And txtLen > 0 Then
      text = Space(txtLen)
      pdfCopyMem2 txt, ByVal StrPtr(text), txtLen * 2
   Else
      text = vbNullString
   End If
End Function

Friend Function ExtractText2(ByVal Flags As TTextExtractionFlags, ByRef Area As TFltRect, ByRef text As String) As Boolean
   Dim txt As Long
   Dim txtLen As Long
   ExtractText2 = psrExtractText(m_Instance, m_Ctx, Flags, VarPtr(Area), txt, txtLen) <> 0
   If ExtractText2 And txtLen > 0 Then
      text = Space(txtLen)
      pdfCopyMem2 txt, ByVal StrPtr(text), txtLen * 2
   Else
      text = vbNullString
   End If
End Function

' The parameter Last must be set as VarPtr(last) and it must be of type TTextSelection
Friend Function FindText(ByVal SearchType As TSearchType, ByVal Last As Long, ByVal text As String, ByRef SelText As TTextSelection) As Boolean
   SelText.StructSize = LenB(SelText)
   FindText = psrFindText(m_Instance, m_Ctx, 0, SearchType, Last, StrPtr(text), Len(text), SelText) <> 0
End Function

' The parameter Last must be set as VarPtr(last) and it must be of type TTextSelection
Friend Function FindText2(ByRef Area As TFltRect, ByVal SearchType As TSearchType, ByVal Last As Long, ByVal text As String, ByRef SelText As TTextSelection) As Boolean
   SelText.StructSize = LenB(SelText)
   FindText2 = psrFindText(m_Instance, m_Ctx, VarPtr(Area), SearchType, Last, StrPtr(text), Len(text), SelText) <> 0
End Function

Friend Function GetSelBBox(ByRef SelText As TTextSelection, ByRef BBox As TBBox) As Boolean
   GetSelBBox = psrGetSelBBox(m_Instance, m_Ctx, SelText, BBox) <> 0
End Function

Friend Function GetSelBBox2(ByRef SelText As TTextSelection, ByRef QuadPoint() As TFltPoint) As Boolean
   GetSelBBox2 = psrGetSelBBox2(m_Instance, SelText, VarPtr(QuadPoint(0))) <> 0
End Function

Friend Function GetSelText(ByRef SelText As TTextSelection, ByRef text As String) As Boolean
   Dim txt As Long, txtLen As Long
   text = vbNullString
   GetSelText = psrGetSelText(m_Instance, SelText, txt, txtLen) <> 0
   If GetSelText Then
      text = Space(txtLen)
      pdfCopyMem2 txt, ByVal StrPtr(text), txtLen * 2
   End If
End Function

Friend Function ParsePage(ByVal PageNum As Long, ByVal Flags As TContentParseFlags, ByRef out As TContent) As Boolean
   ParsePage = psrParsePage(m_Instance, m_Ctx, 0, 0, PageNum, Flags, 0, out) <> 0
End Function

Friend Function ParsePage2(ByVal PageNum As Long, ByVal Flags As TContentParseFlags, ByRef Parms As TContentParseParms, ByRef out As TContent) As Boolean
   Parms.StructSize = LenB(Parms)
   ParsePage2 = psrParsePage(m_Instance, m_Ctx, 0, 0, PageNum, Flags, VarPtr(Parms), out) <> 0
End Function

Friend Function ReplaceSelText(ByVal Flags As TReplaceTextFlags, ByRef SelText As TTextSelection, ByVal text As String) As Boolean
   ReplaceSelText = psrReplaceSelText(m_Instance, m_Ctx, Flags, SelText, StrPtr(text), Len(text)) <> 0
End Function

Friend Sub Reset()
   Call psrReset(m_Ctx)
End Sub

Friend Function SetAltFont(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   SetAltFont = psrSetAltFontW(m_Instance, m_Ctx, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function WriteToPage(ByVal Flags As TOptimizeFlags) As Boolean
   WriteToPage = psrWriteToPage(m_Instance, m_Ctx, Flags, 0) <> 0
End Function

Friend Function WriteToPage2(ByVal Flags As TOptimizeFlags, ByRef Parms As TOptimizeParams, Optional IncludeCSArray = False) As Boolean
   Dim p As TOptimizeParams_I
   Call m_PDF.GetOptimizeParams(Parms, p, IncludeCSArray)
   WriteToPage2 = psrWriteToPage(m_Instance, m_Ctx, Flags, VarPtr(p)) <> 0
End Function
