VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CPDF"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Wrapper class for DynaPDF 4.0"
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'----------------------------------------------------------+
' DynaPDF 4.0                                              |
'----------------------------------------------------------+
' Copyright (C) 2003-2025                                  |
' Jens Boschulte, DynaForms GmbH.                          |
' All rights reserved.                                     |
'----------------------------------------------------------+
' Please report errors or other potential problems to      |
' support@dynaforms.com.                                   |
' The current version is available at www.dynaforms.com.   |
'----------------------------------------------------------+
'             Creation date: June 9, 2025                  |
'----------------------------------------------------------+

Implements IPDFCallBack
' Event procedures
Public Event EnumDocFont(ByVal PDFFont As Long, ByVal FontType As TFontType, ByVal BaseFont As String, ByVal FontName As String, ByVal Embedded As Boolean, ByVal IsFormFont As Boolean, ByVal Flags As Long, DoBreak As Boolean)
Public Event EnumFont(ByVal FamilyName As String, PostScriptName As String, ByVal Style As Long, DoBreak As Boolean)
Public Event EnumFontEx(ByVal FamilyName As String, ByVal PostScriptName As String, ByVal Style As Long, ByVal BaseType As TFontBaseType, ByVal Embeddable As Boolean, ByVal FilePath As String, DoBreak As Boolean)
Public Event Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
Public Event InitProgress(ByVal ProgType As Long, ByVal MaxCount As Long)
' The page break event is not connected when creating an instance of the wrapper class.
' If you want to use this event call the procedure ConnectPageBreakEvent().
Public Event PageBreak(ByVal LastPosX As Double, ByVal LastPosY As Double, ByVal PageBreak As Long, NewAlign As TNewAlign, DoBreak As Boolean)
Public Event Progress(ByVal ActivePage As Long, DoBreak As Boolean)

Enum TErrMode
   emIgnoreAll = 0
   emSyntaxError = 1
   emValueError = 2
   emWarning = 4
   emFileError = 8
   emFontError = 16
   emAllErrors = 65535
   emNoFuncNames = &H10000000  ' Do not print function names in error messages
   emUseErrLog = &H20000000    ' Redirect all error messages to the error log
   ' Special flags for CheckConformance().
   ' These flags add info messages to the error log. The error callback function is not invoked.
   emLogFonts = &H10000        ' If set, CheckConformance() logs which fonts will were replaced with system fonts or converted to Type3
   emLogFontsVerbose = &H20000 ' If set, the path to the font file is added to the error log too
End Enum

Const PDF_MAX_INT = &H7FFFFFFF

' ------------------------------------------------- Default types -----------------------------------------------

' This flag can be combined with the annotation handle in Set3DAnnotProps().
' 3D Annotations with a transparent background are supported since PDF 1.7, Extension Level 3
Const TRANSP_3D_ANNOT = &H40000000

Enum T3DActivationType
   at3D_AppDefault
   at3D_PageOpen    ' The annotaiton should be activated when the page is opened.
   at3D_PageVisible ' The annotaiton should be activated when the page becomes visible.
   at3D_Explicit    ' The annotation should remain inactive until explicitely activated by a script or action (default).
End Enum

Enum T3DDeActivateType
   dt3D_AppDefault
   dt3D_PageClosed    ' The annotaiton should be deactivated as soon as the page is closed.
   dt3D_PageInvisible ' The annotaiton should be deactivated as soon as the page becomes invisible (default).
   dt3D_Explicit      ' The annotation should remain active until explicitely deactivated by a script or action.
End Enum

Enum T3DDeActInstance
   di3D_AppDefault
   di3D_UnInstantiated ' The annotation will be uninstantiated (default)
   di3D_Instantiated   ' The annotation is left instantiated
   di3D_Live           ' If the 3D artwork contains an animation then it will stay live
End Enum

Enum T3DInstanceType
   it3D_AppDefault
   it3D_Instantiated ' The annotation will be instantiated but animations are disabled.
   it3D_Live         ' The annotation will be instantiated and animations are enabled (default).
End Enum

Enum T3DLightingSheme
   lsArtwork
   lsBlue
   lsCAD
   lsCube
   lsDay
   lsHard
   lsHeadlamp
   lsNight
   lsNoLights
   lsPrimary
   lsRed
   lsWhite
   lsNotSet
End Enum

Enum T3DNamedAction
   naDefault
   naFirst
   naLast
   naNext
   naPrevious
End Enum

Enum T3DProjType
   pt3DOrthographic
   pt3DPerspective
End Enum

Enum T3DRenderingMode
   rmBoundingBox
   rmHiddenWireframe
   rmIllustration
   rmShadedIllustration
   rmShadedVertices
   rmShadedWireframe
   rmSolid
   rmSolidOutline
   rmSolidWireframe
   rmTransparent
   rmTranspBBox
   rmTranspBBoxOutline
   rmTranspWireframe
   rmVertices
   rmWireframe
   rmNotSet
End Enum

Enum T3DScaleType
   st3DValue
   st3DWidth
   st3DHeight
   st3DMin
   st3DMax
End Enum

Enum TAFRelationship
   arAssociated
   arData
   arSource
   arSupplement
   arAlternative
   arFormData
End Enum

Enum TAFDestObject
   adAnnotation
   adCatalog    ' The documents catalog is the root object
   adField
   adImage
   adPage
   adTemplate
End Enum

Enum TAnnotFlags
   afNone = &H0
   afInvisible = &H1
   afHidden = &H2
   afPrint = &H4
   afNoZoom = &H8
   afNoRotate = &H10
   afNoView = &H20
   afReadOnly = &H40
   afLocked = &H80
   afToggleNoView = &H100
   afLockedContents = &H200
End Enum

'By default all annotations which have an appearance stream and which have the print flag set are flattened.
'All annotations are deleted when the function returns with the exception of file attachment annotations.
'If you want to flatten the view state then set the flag affUseViewState.
Enum TAnnotFlattenFlags
   affNone = &H0&                     ' Printable annotations independent of the type
   affUseViewState = &H1&             ' If set, annotations which are visible in a viewer become flattened.
   affMarkupAnnots = &H2&             ' If set, markup annotations are flattened only. Link, Sound, or FileAttach
                                      ' annotations are no markup annotations. These types will be left intact.
   affNonPDFA_1 = &H4&                ' If set, flatten all annotations which are not supported in PDF/A 1.
   affNonPDFA_2 = &H8&                ' If set, flatten all annotations which are not supported in PDF/A 2 or 3.
   affNonPDFA_4e = &H80               ' If set, flatten all annotations which are not supported in PDF/A 4e
   affFormFields = &H10&              ' If set, form fields will be flattened too.
   affUseFieldViewState = &H20&       ' Meaningful only if affFormFields is set. If set, flatten the view state of form fields. Use the print state otherwise.
   affSigFields = &H40&               ' Meaningful only if affFormFields is not set. If set, signed signature fields will be flattened.
   
   affKeepLinkAnnots = &H1000&        ' If set, link annotations will be kept.
   affKeepFileAttach = &H2000&        ' If set, file attachment annotations will be kept.
   affKeepTextAnnots = &H4000&        ' If set, text annotations will be kept.
   affKeepEmptySigFields = &H8000&    ' If set, signature fields which are not already signed will be kept.
   affKeepUnsupportedAnnots = &H10000 ' If set, annotations whose appearance stream cannot be rebuild will be kept (3D, Movie, Redact, or RichMedia annotations, for example).
   
   affPreserveZOrder = &H400000       ' If set, preserve the z-order under any curcumstances. That means visible overlapping annotations or form fields will be flattened, regardless the type.
End Enum

Enum TAnnotState
   asNone
   asAccepted
   asRejected
   asCancelled
   asCompleted
   asCreateReply ' Don't add a migration state, create a reply instead. Set the contents of the reply with SetAnnotString().
End Enum

Enum TAnnotString
   asAuthor
   asContent
   asName
   asSubject
   asRichStyle ' Default style string. -> FreeText annotations only.
   asRichText  ' Rich text string.     -> Supported by markup annotations.
End Enum

Enum TButtonState
   bsUp
   bsDown
   bsRollOver
End Enum

Enum TCheckBoxChar
   ccCheck
   ccCircle
   ccCross1
   ccCross2
   ccCross3
   ccCross4
   ccDiamond
   ccSquare
   ccStar
End Enum

Enum TCheckOptions
   coDefault = &H10FFFF
   coEmbedSubsets = &H1&
   coDeleteTransferFuncs = &H2&
   coDeleteMultiMediaContents = &H4&
   coDeleteActionsAndScripts = &H8&
   coDeleteInvRenderingIntent = &H10&
   coFlattenFormFields = &H20&
   coReplaceV4ICCProfiles = &H40&
   coDeleteEmbeddedFiles = &H80&
   coDeleteOPIComments = &H100&
   coDeleteSignatures = &H200&
   coDeletePostscript = &H400&         ' Delete Postscript XObjects. Rarely used and such Postscript fragments are meaningful on a Postscript device only.
                                       ' It is usually safe to delete such objects.
   coDeleteAlternateImages = &H800&    ' Alternate images are seldom used and prohibited in PDF/A.
   coReComprJPEG2000Images = &H1000&   ' Recompression results usually in larger images. It is often better to keep such files as is.
   coResolveOverprint = &H2000&        ' PDF/A 2 and 3. Set the overprint mode to 0 if overprint mode = 1 and if overprinting for fill or stroke is true
                                       ' and if an ICCBased CMYK color space is used. Note that DeviceCMYK is treated as ICCBased color space due to implicit
                                       ' color conversion rules.
   coMakeLayerVisible = &H4000&        ' PDF/A 2 and 3 prohibit invisible layers. Layers can also be flattened if this is no option.
   coDeleteAppEvents = &H8000&         ' PDF/A 2 and 3. Application events are prohibited in PDF/A. The view state will be applied.
   coReplCCITTFaxWithFlate = &H10000   ' Replace CCITT Fax compression with Flate.
   coApplyExportState = &H20000        ' Meaningful only if coDeleteAppEvents is set. Apply the export state.
   coApplyPrintState = &H40000         ' Meaningful only if coDeleteAppEvents is set. Apply the print state.
   coDeleteReplies = &H80000           ' Delete annotation replies. If absent, replies will be converted to regular text annotations.
   coDeleteHalftones = &H100000        ' Delete halftone screens.
   coFlattenLayers = &H200000          ' Flatten layers if any.
   coDeletePresentation = &H400000     ' Presentations are prohibited in PDF/A 2 and 3.
   coCheckImages = &H800000            ' If set, images will be decompressed to identify damaged images.
   coDeleteDamagedImages = &H1000000   ' Meaningful only if coCheckImages is set.
   coRepairDamagedImages = &H2000000   ' Meaningful only if coCheckImages is set. If set, try to recompress a damaged image. The new image is maybe not complete but error free.
   coNoFontEmbedding = &H10000000
   coFlushPages = &H20000000           ' Write converted pages directly into the output file to reduce the memory usage.
   coAllowDeviceSpaces = &H40000000    ' If set, device color spaces will not be replaced with ICC based color spaces. This flag is meaningful for normalization only.
   coResetAnnotAppearance = &H80000000 ' If set, appearance streams of annotations are rebuild before executing CheckConformance().
   ' Common default flags for normalization:
   coDefault_Normalize = coAllowDeviceSpaces Or coNoFontEmbedding    ' No need to change color spaces or to embed fonts.
   ' Common default flags for different PDF/A versions:
   coDefault_PDFA_1 = coDefault Or coFlattenLayers                   ' The ability to flatten layers was added after coDefault was defined.
   coDefault_PDFA_2 = (coDefault And Not coReComprJPEG2000Images) Or coDeletePresentation ' Presentations are prohibited in PDF/A 2 and PDF/A 3.
   coDefault_PDFA_3 = coDefault_PDFA_2 And Not coDeleteEmbeddedFiles ' Embedded files are allowed in PDF/A 3.
   coDefault_PDFA_4 = coDefault_PDFA_2 And Not coDeleteEmbeddedFiles ' Embedded files are allowed in PDF/A 4.
End Enum

Enum TClippingMode
  cmEvenOdd
  cmWinding
End Enum

' The data for user defined columns is stored in collection items.
Enum TColColumnType
   cisCreationDate ' Data comes from the embedded file
   cisDescription  ' Data comes from the embedded file
   cisFileName     ' Data comes from the embedded file
   cisModDate      ' Data comes from the embedded file
   cisSize         ' Data comes from the embedded file
   cisCustomDate   ' User defined date.
   cisCustomNumber ' User defined nummber.
   cisCustomString ' User defined string.
End Enum

Enum TColorConvFlags
   ccfBW_To_Gray = 0    ' Default, RGB Black and White set with rg or RG inline operators are converted to gray
   ccfRGB_To_Gray = 1   ' If set, inline color operators rg and RG are converted to gray
   ccfToGrayAdjust = 2  ' Converts RGB and gray inline operators to gray and allows to darken or lighten the colors
End Enum

Enum TColorMode
   cmFill
   cmStroke
   cmFillStroke
End Enum

Enum TCompBBoxFlags
   cbfNone = 0
   cbfIgnoreWhiteAreas = 1 ' Ignore white vector graphics or text.
'  Please note that images must be decompressed if one of the following flags are set. Parsing gray or color images
'  is in most cases not useful and you should not parse such images if it is not really required.
   cbfParse1BitImages = 2  ' Find the visible area in 1 bit images. This is the most important case
                           ' since scanned faxes are usually 1 bit images.
   cbfParseGrayImages = 4  ' Find the visible area in gray images.
   cbfParseColorImages = 8 ' Find the visible area in color images. This is usually not required
                           ' and slow downs processing a lot.
   cbfParseAllImages = 14  ' Find the visible area in all images.
End Enum

Enum TCompressionLevel
   clNone
   clDefault
   clFastest
   clMax
End Enum

Enum TConformanceType
   ctPDFA_1b_2005
   ctNormalize
   ctPDFA_2b
   ctPDFA_3b
   ' --------------------------------------------------------------------------------------------------------------------
   '                                 ZUGFeRD 1.0, ZUGFeRD 2.0, and Factur-X output
   ' --------------------------------------------------------------------------------------------------------------------
   ' The following constants convert the file to PDF/A 3b and set the whished ZUGFeRD, ZUGFeRD 2.0 or Factur-X conformance
   ' level in the XMP metadata. CheckConformance() does not validate the XML invoice but it checks whether it is present.
   ' The embedded XML invoice must be named as follows (case-sensitive and without quotes):
   '
   '   ZUGFeRD 1.0: "ZUGFeRD-invoice.xml"
   '   ZUGFeRD 2.0: "zugferd-invoice.xml"
   '   Factur-X:    "factur-x.xml"
   '
   ' Setting the correct ZUGFeRD or Factur-X conformance level is important since this value defines which fields
   ' must be present in the XML invoice.
   ' ZUGFeRD 1.0:
   ctZUGFeRD_Basic     ' Basic profile
   ctZUGFeRD_Comfort   ' Comfort profile
   ctZUGFeRD_Extended  ' Extended profile
   ' ZUGFeRD 2.0:
   ctZUGFeRD2_Minimum  ' Minimum profile
   ctZUGFeRD2_Basic    ' Basic profile
   ctZUGFeRD2_Basic_WL ' Basic WL profile
   ctZUGFeRD2_Comfort  ' EN 16931 profile
   ctZUGFeRD2_Extended ' Extended profile
   ' Factur-X
   ctFacturX_Minimum   ' Minimum profile
   ctFacturX_Basic     ' Basic profile
   ctFacturX_Basic_WL  ' Basic WL profile
   ctFacturX_Comfort   ' EN 16931 profile
   ctFacturX_Extended  ' Extended profile
   ctFacturX_XRechnung ' German XRechnung profile
   ctPDFA_2u           ' Convert the file to PDF/A 2u if possible
   ctPDFA_3u           ' Convert the file to PDF/A 3u if possible
   ctPDFA_4            ' Convert the file to PDF/A 4 if possible. Embedded files are supported but no file attach annotations.
   ctPDFA_4e           ' Convert the file to PDF/A 4e if possible. This version allows 3D contents in rich media annotations.
   ctPDFA_4f           ' Convert the file to PDF/A 4f if possible. This version allows file attach annotations.
End Enum

Enum TDateType
   dtCreationDate
   dtModDate
End Enum

Enum TDecSeparator
' per thousand separator, decimal separator
   dsCommaDot
   dsNoneDot
   dsDotComma
   dsNoneComma
   dsQuoteDot
End Enum

Enum TDocumentInfo
   diAuthor
   diCreator
   diKeywords
   diProducer
   diSubject
   diTitle
   diCompany
   diPDFX_Ver     ' GetInDocInfo() or GetInDocInfoEx() only -> The PDF/X version is set by SetPDFVersion()!
   diCustom       ' User defined key
   diPDFX_Conf    ' GetInDocInfo() or GetInDocInfoEx() only. The value of the GTS_PDFXConformance key.
   diCreationDate ' GetInDocInfo() or GetInDocInfoEx() or after ImnportPDFFile() was called.
   diModDate      ' GetInDocInfo() or GetInDocInfoEx() only
End Enum

Enum TDrawDirection
  ddCounterClockwise
  ddClockwise
End Enum

Enum TEmbFileLocation
   eflChild         ' The file is an embedded file in the current document
   eflChildAnnot    ' The file is located in a file attachment annotion in the current document
   eflExternal      ' The file is an embedded file in an external document
   eflExternalAnnot ' The file is located in a file attachment annotion in an external document
   eflParent        ' The file is located in the parent document
   eflParentAnnot   ' The file is located in a file attachment annotion in the parent document
End Enum

Enum TFieldColor
   fcBackColor
   fcBorderColor
   fcTextColor
End Enum

Enum TFileAttachIcon
   faiGraph
   faiPaperClip
   faiPushPin
   faiTag
   faiUserDefined
End Enum

Enum TFileOP
   foOpen
   foPrint
End Enum

Enum TFlushPageFlags
   fpfDefault = 0      ' Write anything to the file that is possible
   fpfImagesOnly = 1   ' If set, only images are written to the file. The pages are still
                       ' in memory and can be modified with EditPage(). Flushed images can
                       ' still be referenced in other pages. The image handles remain valid.
   fpfExclLastPage = 2 ' If set, the last page is not flushed
End Enum

Enum TFontSelMode
   smFamilyName
   smPostScriptName
   smFullName
End Enum

Enum TGStateFlags
   gfCompatible = 0              ' Compatible graphics state to earlier DynaPDF versions -> default
   gfRestorePageCoords = 1       ' Restore the coordinate system with the graphics state (the value of PageCoords, see SetPageCoords())
   gfRealTopDownCoords = 2       ' If set, the page coordinate system is not reset to bottom-up when transforming
                                 ' the coordinate system. However, real top-down coordinates require a large internal
                                 ' overhead and where never fully implemented. The usage of this flag should be avoided
                                 ' if possible.
   gfUseImageColorSpace = 8      ' If set, the active color space is ignored when inserting an image. The color space is taken
                                 ' from the image file instead.
   gfIgnoreICCProfiles = 16      ' Meaningful only if the flag gfUseImageColorSpace is set. If set, an embedded profile is not used to
                                 ' create an ICCBased color space for the image. The image is inserted in the corresponding device
                                 ' color space instead.
   gfAnsiStringIsUTF8 = 32       ' If set, single byte strings in Ansi functions are treated as UTF-8 encoded Unicode strings.
   gfRealPassThrough = 64        ' If set, JPEG images are inserted as is. JPEG images are normally rebuild, also in pass-through mode, to avoid issues
                                 ' with certain malformed JPEG images which cannot be displayed in Adobes Acrobat or Reader. If you know that your JPEG
                                 ' images work then set this flag to avoid unnecessary processing time.
   gfNoBitmapAlpha = 128         ' If set, the alpha channel in 32 bit bitmaps will be ignored. Useful for bitmaps with an invalid alpha channel.
   gfNoImageDuplCheck = 256      ' If set, no duplicate check for images will be performed. This can significantly improve processing speed.
   gfNoObjCompression = 512      ' If set, object compression will be disabled.
   gfComplexText = 1024          ' If set, text is processed with Uniscribe on Windows.
   gfDisableJavascript = 2048    ' If set, the raw field value of text fields is used to create the apprearance stream.
   gfDisableBidiCtrls = &H1000   ' Meaningful only if gfComplexText is set too. If set, bidi control characters are ignored. This flag can be useful if
                                 ' the result of web browsers should be emulated since web browsers do not support bidi control characters. This flag
                                 ' is also used internally to create the appearance stream of form fields since form fields do not support bidi control
                                 ' characters.
   gfDoNotComprMetadata = &H2000 ' If set, arbitrary metadata stream associated with PDF objects other that the global metadata stream will not be
                                 ' compressed. This can be useful since certain standards prohibit compression of metadata streams. The flag is
                                 ' automatically for PDF/X files.
   gfUpdatePDFVTModDate = &H4000 ' If set, the key GTS_PDFVTModDate will be set to the file's modification date.
   gfSkaleAnnotIcons = &H8000    ' If set, icons of text and file attach annotation are scaled with the page like every other annotation. These annotations
                                 ' have normally a fixed size that is indendent of the zoom or scaling factor.
   gfRoundHighlightAP = &H10000  ' If set, highlight annotations are drawn with round edges.
End Enum

Enum TICCProfileType
   ictGray
   ictRGB
   ictCMYK
   ictLab
End Enum

Enum TImportFlags
   ifImportAll = &HFFFFFFE ' default
   ifContentOnly = &H0&
   ' If this flag is set, only interactive objects are imported if any, Otherwise only empty pages are imported.
   ' This flag can be used to copy an interactive form to another PDF file.
   ifNoContent = &H1&
   ' The imported page is not converted to a template if ifImportAsPage is set.
   ' Note that this flag can cause resource conflicts. Use this flag carefully!
   ifImportAsPage = &H80000000
   ' base objects
   ifCatalogAction = &H2&
   ifPageActions = &H4&
   ifBookmarks = &H8&
   ifArticles = &H10&
   ifPageLabels = &H20&
   ifThumbs = &H40&
   ifTranspGroups = &H80&        ' This flag is not longer considered.
   ifSeparationInfo = &H100&
   ifBoxColorInfo = &H200&
   ifStructureTree = &H400&
   ifTransition = &H800&
   ifSearchIndex = &H1000&
   ifJavaScript = &H2000&
   ifJSActions = &H4000&
   ifDocInfo = &H8000&          ' Document info entries
   ifEmbeddedFiles = &H200000   ' File attachments
   ifFileCollections = &H400000 ' File collections (PDF 1.7)
   ' Annotations -> Only the most important annotation types can be selected directly.
   ' Note that all annotation types can be deleted with DeleteAnnotation.
   ifAllAnnots = &H9F0000
      ifFreeText = &H10000
      ifTextAnnot = &H20000
      ifLink = &H40000
      ifStamp = &H80000
      if3DAnnot = &H100000
      ifOtherAnnots = &H800000
   ' Interactive Form fields are also annotations but we handle this type separately!
   ifFormFields = &H1000000
   ifPieceInfo = &H2000000       ' The PieceInfo dictionary contains arbitrary user defined data. The data in
                                 ' this dictionary is meaningful only for the application that created the data.

' -------------------- Special flags --------------------
   ifPrepareForPDFA = &H10000000  ' Replace LZW compression with Flate, set the Interpolate key of images to false, do not import embedded files.
   ifEnumFonts = &H20000000      ' Import fonts for EnumDocFonts(). The document must be deleted when this flag is set!!!
   ifAllPageObjects = &H40000000 ' Import links when using ImportPageEx() within an open page. The entire document should be imported in this case.
End Enum

Enum TImportFlags2
   if2MergeLayers = &H1          ' If set, layers with identical name are merged. If this flag is absent DynaPDF
                                 ' imports such layers separately so that each layer refers still to the pages
                                 ' where it was originally used.
   if2Normalize = &H2            ' Replace LZW compression with Flate, apply limit checks, repair errors if possible.
   if2UseProxy = &H4             ' Not meaningful for PDF files which are loaded from a memory buffer. If set, all streams are loaded from the file
                                 ' on demand but they are never hold in memory. This reduces drastically the memory usage and enables the processing
                                 ' of almost arbitrary large PDF files with minimal memory usage. The corresponding PDF file must not be deleted before
                                 ' CloseFile() or CloseFileEx() was called.
   if2NoMetadata = &H8           ' Ignore metadata streams which are attached to fonts, pages, images, and so on.
   if2DuplicateCheck = &H10      ' Perform a duplicate check on fonts, images, patterns, and templates when merging PDF files.
   if2NoResNameCheck = &H20      ' Import resources as is. This flag can significantly imporove the loading time of pages with a huge resource tree.
                                 ' This flag should only be set in viewer applications to improve the loading time of pages.
   if2CopyEncryptDict = &H40     ' If set, the encryption settings of an encrypted PDF file are copied to the new PDF file.
                                 ' The flag does nothing if the file is not encrypted.
   if2SkipDPartData = &H80       ' If set, DPart dictionaries are not imported.
End Enum

Enum TLineCapStyle
  csButtCap
  csRoundCap
  csSquareCap
End Enum

Enum TLineJoinStyle
  jsMiterJoin
  jsRoundJoin
  jsBevelJoin
End Enum

Enum TMetadataObj
   mdoCatalog
   mdoFont
   mdoImage
   mdoPage
   mdoTemplate
End Enum

Enum TMetaFlags
   mfDefault = &H0&                ' Default conversion
   mfDebug = &H1&                  ' Write debug information into the content stream
   mfShowBounds = &H2&             ' Show the bounding boxes of text strings
   mfNoTextScaling = &H4&          ' Do not scale text
   mfClipView = &H8&               ' Draw the file into a clipping rectangle
   mfUseRclBounds = &H10&          ' Use rclBounds instead of rclFrame
   mfNoClippingRgn = &H40&         ' Disables SelectClippingRegion and IntersectClipRect
   mfNoFontEmbedding = &H80&       ' Do not embed fonts -> Fonts should be embedded!!!
   mfNoImages = &H100&             ' Ignore image records
   mfNoStdPatterns = &H200&        ' Ignore standard patterns
   mfNoBmpPatterns = &H400&        ' Ignore bitmap patterns
   mfNoText = &H800&               ' Ignore text records
   mfUseUnicode = &H1000&          ' Ignore ANSI_CHARSET
   mfUseTextScaling = &H4000&      ' Scale text instead of using the intercharacter spacing array
   mfNoUnicode = &H8000&           ' Avoid usage of Unicode fonts -> recommended to enable PDF 1.2 compability
   mfFullScale = &H10000           ' Scale coordinates to the window size. Recommended if 32 bit coordinates are used.
   mfUseRclFrame = &H20000         ' This flag should be set if the rclFrame rectangle is properly set
   mfDefBkModeTransp = &H40000     ' Initialize the background mode to transparent (SetBkMode() overrides this state).
   mfApplyBidiAlgo = &H80000       ' Apply the bidirectional algorithm on Unicode strings
   mfGDIFontSelection = &H100000   ' Use the GDI to select fonts
   mfRclFrameEx = &H200000         ' If set, and if the rclBounds rectangle is larger than rclFrame, the function
                                   ' extends the output rectangle according to rclBounds and uses the resulting
                                   ' bounding box to calculate the image size (rclBounds represents the unscaled
                                   ' image size). This is probably the correct way to calculate the image size.
                                   ' However, to preserve backward compatibility the default calculation cannot
                                   ' be changed.
   mfNoTextClipping = &H400000     ' If set, the ETO_CLIPPED flag in text records is ignored.
   mfSrcCopy_Only = &H800000       ' If set, images which use a ROP code other than SRCCOPY are ignored. This is useful when processing Excel 2007 spool files.
   mfClipRclBounds = &H1000000     ' If set, the graphic is drawn into a clipping path with the size of rclBounds.
                                   ' This flag is useful if the graphic contains content outside of its bounding box.
   mfDisableRasterEMF = &H2000000  ' If set, EMF files which use unsupported ROP codes are not rastered.
   mfNoBBoxCheck = &H4000000       ' If set, the rclBounds and rclFrame rectangles are used as is. DynaPDF uses normally
                                   ' the rclBounds rectangle to calculate the picture size if the resolution of the EMF file
                                   ' seems to be larger than 1800 DPI since this is mostly an indication that the rclFrame
                                   ' rectangle was incorrectly calculated. If you process EMF files in such a high resolution
                                   ' then this flag must be set. The flag can be set by default.
   mfIgnoreEmbFonts = &H8000000    ' If set, embedded fonts in GDIComment records will be ignored. This flag must be set if the fonts
                                   ' of an EMF spool file were pre-loaded with ConvertEMFSpool(). Spool fonts must always be loaded
                                   ' in a pre-processing step since required fonts are not necessarily embedded in the EMF files.
   mfDontSkipROP_DPa = &H10000000  ' If set, the ROP code 0x00A000C9 (DPa) is considered in BitBlt, StretchBlt, TranparentBlt, and AlphaBlend records.
                                   ' This kind of ROP code combines a pattern brush with the backdrop. If the flag mfDisableRasterEMF is absent, the
                                   ' usage of such a ROP code causes that the file is rendered to an image.
   mfCurrComprFilter = &H20000000  ' If set, the currently active compression filter is used to compress the image (see SetCompressionFilter()).
                                   ' This flag is used only if the file is rastered to an image.

   ' Obsolete flags -> these flags are ignored, do no longer use them!
   mfUseSpacingArray = &H20&       ' enabled by default -> can be disabled with mfUseTextScaling
   mfIntersectClipRect = &H2000&   ' enabled by default -> can be disabled with mfNoClippingRgn
End Enum

Enum TNegativeStyle
   nsMinusBlack
   nsRed
   nsParensBlack
   nsParensRed
End Enum

Enum TOrigin
  orDownLeft
  orTopLeft
End Enum

Enum TOCObject
   ooAnnotation
   ooField
   ooImage
   ooTemplate
End Enum

Enum TOCVisibility
   ovAllOff
   ovAllOn
   ovAnyOff
   ovAnyOn
   ovNotSet ' Internal
End Enum

Enum TPageBoundary
   pbArtBox
   pbBleedBox
   pbCropBox
   pbTrimBox
   pbMediaBox
End Enum

Enum TPageCoord
  pcBottomUp
  pcTopDown
End Enum

Enum TPageFormat
   pfDIN_A3
   pfDIN_A4
   pfDIN_A5
   pfDIN_B4
   pfDIN_B5
   pfDIN_B6
   pfDIN_C3
   pfDIN_C4
   pfDIN_C5
   pfDIN_C6
   pfDIN_C65
   pfDIN_DL
   pfDIN_E4
   pfDIN_E5
   pfDIN_E6
   pfDIN_E65
   pfDIN_M5
   pfDIN_M65
   pfUS_Legal
   pfUS_Letter
   pfDIN_A0
   pfDIN_A1
   pfDIN_A2
   pfDIN_A6
   pfDIN_A7
   pfDIN_A8
   pfDIN_A9
   pfDIN_A10
End Enum

Enum TPageMode
   pmUseNone
   pmUseOutLines
   pmUseThumbs
   pmFullScreen
   pmUseOC          ' Optional Content (Layers)
   pmUseAttachments
End Enum

Enum TParseFlags
   pfNone = &H0&
   pfDecomprAllImages = &H2&  ' This flag causes that all image formats will be decompressed. If this
                              ' flag is not set, images which are already stored in a valid image file
                              ' format are returned as is. This is the case for Gray and RGB JPEG
                              ' images and for JPEG2000 images. If you want to extract the images
                              ' of a PDF file this flag should NOT be set!

   pfNoJPXDecode = &H4&       ' Meaningful only if the flag pfDecomprAllImages is set. If set,
                              ' JPEG2000 images are returned as is so that you can use your own
                              ' library to decompress such images.

   ' The following flags are ignored if an image is not decompressed. Note that only one flag must be set
   ' at time. If no color space conversion flag is set images are returned in their native or alternate
   ' device color space. Note that these flags do not convert colors of vector graphics and so on.
   ' Use the function ConvColor() to convert colors of the graphics state into a device space.
   pfDitherImagesToBW = &H8&  ' Floyd-Steinberg dithering.
   pfConvImagesToGray = &H10&
   pfConvImagesToRGB = &H20&
   pfConvImagesToCMYK = &H40&
   pfImageInfoOnly = &H80&    ' If set, images are not decompressed. This flag is useful if you want
                              ' to enumerate the images of a PDF file or if you want to determine how
                              ' many images are stored in it.
                              ' Note that images can be compressed with multiple filters. The member
                              ' Filter of the structure TPDFImage contains only the last filter with
                              ' which the image was compressed. There is no indication whether multiple
                              ' decode filters are required to decompress the image buffer. So, it
                              ' makes no sense to set this flag if you want to try to decompress the
                              ' image buffer manually with your own decode filters.
   pfErrorCheckOnly = &H100&  ' If set, images are checked for decompression errors only. Used internally by CheckConformance().
   pfFailOnError = &H80000000 ' Fail on decompression errors. Used internally by CheckConformance().

End Enum

Enum TPathFillMode
   fmFillNoClose
   fmStrokeNoClose
   fmFillStrokeNoClose
   fmFill
   fmStroke
   fmFillStroke
   fmFillEvOdd
   fmFillStrokeEvOdd
   fmFillEvOddNoClose
   fmFillStrokeEvOddNoClose
   fmNoFill
   fmClose
End Enum

Enum TPatternType
   ptColored
   ptUnColored
   ptShadingPattern ' Cannot be created with DynaPDF
End Enum

' Notice:
'   When using a bidirectional 8 bit code page the bidi algorithm is applied by default in Left to Right mode
'   also if the bidi mode is set to bmNone (default). This mode produces identical results in comparison to
'   applications like Edit or WordPad.
'
'   The Right to Left mode is available in applications which use Microsoft's Uniscribe, e.g. BabelPad. This
'   mode works very well with the Reference Bidi Algorithm which is used by DynaPDF.
'
'   However , Uniscribe 's Left to Right mode produces different results in comparison to the Reference Bidi
'   Algorithm. Because the bidi algorithm that is used in Uniscribe is not published it is practically
'   impossible to get the same result in Left to Right mode without using this library.

Enum TPDFBidiMode
   bmLeftToRight ' Apply the bidi algorithm on Unicode strings in Left to Right layout.
   bmRightToLeft ' Apply the bidi algorithm on Unicode strings in Right to Left layout.
   bmNone        ' Default -> not apply the bidi algorithm
End Enum

Enum TPDFDateTime
   dfMM_D
   dfM_D_YY
   dfMM_DD_YY
   dfMM_YY
   dfD_MMM
   dfD_MMM_YY
   dfDD_MMM_YY
   dfYY_MM_DD
   dfMMM_YY
   dfMMMM_YY
   dfMMM_D_YYYY
   dfMMMM_D_YYYY
   dfM_D_YY_H_MM_TT
   dfM_D_YY_HH_MM
   ' time formats
   df24HR_MM
   df12HR_MM
   df24HR_MM_SS
   df12HR_MM_SS
End Enum

Enum TPDFPrintFlags
   pffDefault = &H0                    ' Gray printing
   pff1Bit = &H1                       ' Black & White output
   pffColor = &H2                      ' Color output
   pffAutoRotateAndCenter = &H4        ' Rotate and center the page if necessary
   pffPrintAsImage = &H8               ' Defined for future use
   pffShrinkToPrintArea = &H10         ' Scale the page so that it fits into the printable area
   pffNoStartDoc = &H20                ' If set StartDoc() of the Windows print API will not be called
   pffNoStartPage = &H40               ' If set StartPage() of the Windows print API will not be called
   pffNoEndDoc = &H80                  ' If set EndDoc() of the Windows print API will not be called
   pffPrintPageAsIs = &H100            ' If set do not scale or rotate a page to fit into the printable area
   pffAutoRotate = &H200               ' Rotate the page if necessary
   pffAutoCenter = &H400               ' Center the page
End Enum

Enum TPDFVersion
   pvPDF_1_0 = 0
   pvPDF_1_1 = 1
   pvPDF_1_2 = 2
   pvPDF_1_3 = 3
   pvPDF_1_4 = 4
   pvPDF_1_5 = 5
   pvPDF_1_6 = 6
   pvPDF_1_7 = 7
   pvPDF_2_0 = 8      ' PDF 2.0
   pvReserved = 9     ' Reserved for future use
   pvPDFX1a_2001 = 10 ' PDF/X-1a:2001
   pvPDFX1a_2003 = 11 ' PDF/X-1a:2002
   pvPDFX3_2002 = 12  ' PDF/X-3:2002
   pvPDFX3_2003 = 13  ' PDF/X-3:2003
   pvPDFA_2005 = 14   ' PDF/A-1b 2005
   pvPDFX_4 = 15      ' PDF/X-4
   pvPDFA_1a = 16     ' PDF/A 1a 2005
   pvPDFA_2a = 17     ' PDF/A 2a
   pvPDFA_2b = 18     ' PDF/A 2b
   pvPDFA_2u = 19     ' PDF/A 2u
   pvPDFA_3a = 20     ' PDF/A 3a
   pvPDFA_3b = 21     ' PDF/A 3b
   pvPDFA_3u = 22     ' PDF/A 3u
   ' The following constants are flags which can be combined with pvPDFA_3a, pvPDFA_3b, and pvPDFA_3u.
   ' If used stand alone PDF/A 3b with the correspondig ZUGFeRD metadata will be created.
   pvZUGFeRD_Basic = &H10000
   pvZUGFeRD_Comfort = &H20000
   pvZUGFeRD_Extended = &H40000
   pvZUGFeRD_Mask = pvZUGFeRD_Basic Or pvZUGFeRD_Comfort Or pvZUGFeRD_Extended
   ' Factur-X and ZUGFeRD2 profiles. The usage is identically as the older ZUGFeRD flags. That means if
   ' used alone, a PDF/A 3b file will be created.
   ' --------------------------------------------------------------------------------------------------------------
   '                                                Factur-X vs. ZUGFeRD 2.0
   ' ---------------------------------------------------------------------------------------------------------------
   ' ZUGFeRD 2.0 and Factur-X are almost identically defined. Both standards support the very same profiles. To create
   ' a ZUGFeRD 2.0 invoice with the profile Basic WL, for example, set the PDF version as follows:
   '
   '   call pdf.SetPDFVersion(pvFacturX_Basic_WL Or pvZUGFeRD2_Flag)
   '
   ' The PDF version is set to PDF/A 3b in the above example.
   '
   ' If you want to create the very same invoice but as PDF/A 3u file, for example, then set also the whished output PDF
   ' version:
   '
   '   call pdf.SetPDFVersion(pdf, pvPDFA_3u Or pvFacturX_Basic_WL Or pvZUGFeRD2_Flag)
   '
   pvFacturX_Minimum = &H80000      ' Minimum profile
   pvFacturX_Basic = &H100000       ' Basic profile
   pvFacturX_Basic_WL = &H200000    ' Basic WL profile
   pvFacturX_Comfort = &H400000     ' EN 16931 profile
   pvFacturX_Extended = &H800000    ' Extended profile
   pvFacturX_XRechnung = &H2000000  ' German XRechnung profile. The XML invoice must be named xrechnung.xml.
   
   pvFacturX_Mask = pvFacturX_Minimum Or pvFacturX_Basic Or pvFacturX_Basic_WL Or pvFacturX_Comfort Or pvFacturX_Extended
   pvZUGFeRD2_Flag = &H1000000      ' If set the PDF version will be set to the corresponding ZUGFeRD2 profile.
   pvPDFX5g = 23                    ' PDF/X-5g
   pvPDFX5n = 24                    ' PDF/X-5n
   pvPDFX5pg = 25                   ' PDF/X-5pg
   pvPDFX6 = 26                     ' PDF/X 6
   pvPDFX6n = 27                    ' PDF/X 6n
   pvPDFX6p = 28                    ' PDF/X 6p
   pvPDFUA1 = 29                    ' PDF/UA-1 (ISO 14289-1)
   pvPDFX4p = 30                    ' PDF/X-4p
   pvPDFVT1 = &H10000000            ' PDF/VT 1 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVT2 = &H4000000             ' PDF/VT 2 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVT3 = &H8000000             ' PDF/VT 3 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   pvPDFVTMask = pvPDFVT1 Or pvPDFVT2 Or pvPDFVT3
   pvPDFUAFlag = &H20000000         ' PDF/UA flag. Can be used in addition with other standards. File metadata will contain PDF/A and PDF/UA entries.
   pvPDFA_4 = 31                    ' PDF/A 4
   pvPDFA_4e = 32                   ' PDF/A 4e allows 3D contents in rich media annotations.
   pvPDFA_4f = 33                   ' PDF/A 4f allows file attach annotations.
End Enum

Enum TProgType
   ptImportPage = 0
   ptWritePage = 1
   ptPrintPage = 2
   ptConvertPage = 3
End Enum

Enum TRawImageFlags
   rifByteAligned = &H1000&
   rifRGBData = &H2000
   rifCMYKData = &H4000
End Enum

Enum TReplaceImageFlags
   rifDefault = 0         ' Nothing special to do.
   rifDeleteAltImages = 1 ' Delete all alternate images that are associated with this image if any.
   rifDeleteMetadata = 2  ' Delete the meta data that was associated with the image.
   rifDeleteOCG = 4       ' Delete the Optional Content Group if any. Note that this changes the visibility state of the image. Normally, the OCG should be left as is.
   rifDeleteSoftMask = 8  ' An image can contain a soft mask that acts as an alpha channel. This mask can be deleted or left as is.
                          ' The mask will always be deleted if the new image contains a soft mask or an alpha channel.
End Enum

Enum TShadingType
   stUnknown       ' cannot occur -> internal use
   stFunctionBased
   stAxial
   stRadial
   stFreeFormGouraud
   stLatticeFormGouraud
   stCoonsPatch
   stTensorProduct
End Enum

Enum TSoftMaskType
   smtAlpha
   smtLuminosity
End Enum

Enum TSpoolConvFlags
   spcDefault = 0
   spcIgnorePaperFormat = 1  ' If set, the current page format is used as is for the entire spool file.
   spcDontAddMargins = 2     ' If set, the page format is calculated from the EMF files as is. The current page format is not used to calculate
                             ' margins which are maybe required. Note that the parameters LeftMargin and TopMargin will still be considered.
   spcLoadSpoolFontsOnly = 4 ' If set, only embedded fonts will be loaded. The EMF files must be converted with the flag mfIgnoreEmbFonts in this
                             ' case. This flag can be useful if you want to use your own code to convert the EMF files of the spool file.
   spcFlushPages = 8         ' If set, the function writes every finish page directly to the output file to reduce the memory usage. This flag
                             ' is meaningful only if the PDF file is not created in memory. Note also that it is not possible to access already
                             ' flushed pages again with EditPage().
End Enum

Enum TStdPattern
   spHorizontal ' -----
   spVertical   ' |||||
   spRDiagonal  ' \\\\\
   spLDiagonal  ' /////
   spCross      ' +++++
   spDiaCross   ' xxxxx
End Enum

Enum TTextExtractionFlags
   tefDefault = 0               ' Create text lines in the original order.
   tefSortTextX = 1             ' Sort text records in x-direction.
   tefSortTextY = 2             ' Sort text records in y-direction.
   tefSortTextXY = tefSortTextX Or tefSortTextY
   tefDeleteOverlappingText = 4 ' Text extraction only.
   tefNoHeuristic = 8           ' If set, text is sorted on the x-axis as specified. If absent, a heuristic
                                ' is used to determine whether it is might be better to leave a line unsorted.
End Enum

Enum TTilingType
   ttConstSpacing
   ttNoDistortion
   ttFastConstSpacing
End Enum

Enum TViewerPreference
  vpUseNone = &H0
  vpHideToolBar = &H1
  vpHideMenuBar = &H2
  vpHideWindowUI = &H4
  vpFitWindow = &H8
  vpCenterWindow = &H10
  vpDisplayDocTitle = &H20
  vpNonFullScrPageMode = &H40
  vpDirection = &H80
  vpViewArea = &H100
  vpViewClip = &H200
  vpPrintArea = &H400
  vpPrintClip = &H800
End Enum

Enum TViewPrefAddVal
  avNone = &H0
  avNonFullScrUseNone = &H1
  avNonFullScrUseOutlines = &H2
  avNonFullScrUseThumbs = &H4
  avNonFullScrUseOC = &H400 ' PDF 1.6
  avDirectionL2R = &H8
  avDirectionR2L = &H10
  avViewPrintArtBox = &H20
  avViewPrintBleedBox = &H40
  avViewPrintCropBox = &H80
  avViewPrintMediaBox = &H100
  avViewPrintTrimBox = &H200
End Enum

' ------------------------------------------------ Private Structures -------------------------------------------------

Private Type TBookmark_I
   Color As Long
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
   DoOpen As Long
   Parent As Long
   Style As Long
   Title As Long
   TitleLen As Long
   bUnicode As Long
End Type

Private Type TDeviceNAttributes_I
   IProcessColorSpace As Long    ' Pointer to process color space or NULL -> GetColorSpaceEx().
   ProcessColorants(7) As Long   ' UTF-8 Process colorant names
   ProcessColorantsCount As Long ' Number of process colorants in the array or zero if not set.
   Separations(31) As Long       ' Optional pointers to Separation color spaces -> GetColorSpaceEx().
   SeparationsCount As Long      ' Number of color spaces in the array.
   IMixingHints As Long          ' Optional mixing hints. There is no API function at this time to access mixing hints.
   Reserved01 As Long
   Reserved02 As Long
   Reserved03 As Long
   Reserved04 As Long
End Type

Private Type TTextRecordW_I
   Advance As Single ' Negative values move the cursor the right, positive to the left
   text As Long      ' Pointer tp already translated Unicode string (not null-terminated)
   Length As Long    ' Length in characters
   Width As Single   ' String width measured in text space
End Type

Private Type TPDFAnnotation_I
   AnnotType As Long
   Deleted As Long
   BBox As TPDFRect
   BorderWidth As Double
   BorderColor As Long
   BorderStyle As Long
   BackColor As Long
   Handle As Long
   AuthorA As Long
   AuthorW As Long
   ContentA As Long
   ContentW As Long
   NameA As Long
   NameW As Long
   SubjectA As Long
   SubjectW As Long
   PageNum  As Long
   HighlightMode As Long
End Type

Private Type TPDFAnnotationEx_I
   AnnotType As Long
   Deleted As Long
   BBox As TPDFRect
   BorderWidth As Single
   BorderColor As Long
   BorderStyle As Long
   BackColor As Long
   Handle As Long
   AuthorA As Long
   AuthorW As Long
   ContentA As Long
   ContentW As Long
   NameA As Long
   NameW As Long
   SubjectA As Long
   SubjectW As Long
   PageNum As Long
   HighlightMode As Long
   ' Page link annotations only
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
   DestFile As Long      ' File link or web link annotations
   Icon As Long          ' The Icon type depends on the annotation type. If the annotation type is atText then the Icon
                         ' is of type TAnnotIcon. If the annotation type is atFileAttach then it is of type
                         ' TFileAttachIcon. If the annotation type is atStamp then the Icon is the stamp type (TRubberStamp).
                         ' For any other annotion type this value is not set (-1).
   StampName As Long     ' Set only, if Icon == rsUserDefined
   AnnotFlags As Long    ' See TAnnotFlags for available flags
   CreateDate As Long    ' Creation Date -> Optional
   ModDate As Long       ' Modification Date -> Optional
   Grouped As Long       ' (Reply type) Meaningful only if Parent != -1 and Type != atPopUp. If true,
                         ' the annotation is part of an annotation group. Properties like Content, CreateDate,
                         ' ModDate, BackColor, Subject, and Open must be taken from the parent annotation.
   Open As Long          ' Meaningful only for annotations which have a corresponding PopUp annotation.
   Parent As Long        ' Parent annotation handle of a PopUp Annotation or the parent annotation if
                         ' this annotation represents a state of a base annotation. In this case,
                         ' the annotation type is always atText and only the following members should
                         ' be considered:
                         '    State      // The current state
                         '    StateModel // Marked, Review, and so on
                         '    CreateDate // Creation Date
                         '    ModDate    // Modification Date
                         '    Author     // The user who has set the state
                         '    Content    // Not displayed in Adobe's Acrobat...
                         '    Subject    // Not displayed in Adobe's Acrobat...
                         ' The PopUp annotation of a text annotation which represent an Annotation State
                         ' must be ignored.
   PopUp As Long         ' Handle of the corresponding PopUp annotation if any.
   State As Long         ' The state of the annotation.
   StateModel As Long    ' The state model (Marked, Review, and so on).
   EmbeddedFile As Long  ' FileAttach annotations only. A handle of an embedded file -> GetEmbeddedFile().
   Subtype As Long       ' Set only, if Type = atUnknownAnnot
   PageIndex As Long     ' The page index is used to sort form fields. See SortFieldsByIndex().
   MarkupAnnot As Long   ' If true, the annotation is a markup annotation. Markup annotations can be flattened
                         ' separately, see FlattenAnnots().
   Opacity As Single     ' Opacity = 1.0 = Opaque, Opacity < 1.0 = Transparent, Markup annotations only
   QuadPoints As Long      ' Highlight, Link, and Redact annotations only
   QuadPointsCount As Long ' Highlight, Link, and Redact annotations only


   DashPattern As Long      ' Only present if BorderStyle == bsDashed
   DashPatternCount As Long ' Number of values in the array

   Intent As Long           ' Markup annotations only. The intent allows to distinguish between different uses of an annotation.
                            ' For example, line annotations have two intents: LineArrow and LineDimension.
   LE1 As TLineEndStyle     ' Line end style of the start point -> Line and PolyLine annotations only
   LE2 As TLineEndStyle     ' Line end style of the end point -> Line and PolyLine annotations only

   Vertices As Long         ' Line, PolyLine, and Polygon annotations only
   VerticesCount As Long    ' Number of values in the array. This is the raw number of floating point values.
                            ' Since a vertice requires always two coordinate pairs, the number of vertices
                            ' or points is VerticeCount divided by 2.

   ' Line annotations only. These properties should only be considered if the member Intent is set to the string LineDimension.
   Caption As Long               ' If true, the annotation string Content is used as caption.
   CaptionOffsetX As Single      ' Horizontal offset of the caption from its normal position
   CaptionOffsetY As Single      ' Vertical offset of the caption from its normal position
   CaptionPos As TLineCaptionPos ' The position where the caption should be drawn if present
   LeaderLineLen As Single       ' Length of the leader lines (positive or negative)
   LeaderLineExtend As Single    ' Optional leader line extend beyond the leader line (must be a positive value or zero)
   LeaderLineOffset As Single    ' Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)

   BorderEffect As TBorderEffect ' Circle, Square, FreeText, and Polygon annotations.
   RichStyle As Long             ' Optional default style string.      -> FreeText annotations only.
   RichText As Long              ' Optional rich text string (RC key). -> Markup annotations only.

   InkList As Long               ' Ink annotations only. Array of array. The sub arrays can be accessed with GetInkList().
   InkListCount As Long          ' Number of ink arrays.
   OC As Long                    ' Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   RD As Long                    ' Caret, Circle, Square, and FreeText annotations.
   Rotate As Long                ' Caret annotations only. Must be zero or a multiple of 90. This key is not documented in the specs.
End Type

Private Type TPDFBarcode_I
   StructSize As Long     ' Must be set to sizeof(TPDFBarcode) before calling CreateBarcodeField()!
   CaptionA As Long       ' Optional, the ansi string takes precedence
   CaptionW As Long       ' Optional
   ECC As Single          ' 0..8 for PDF417, or 0..3 for QRCode
   Height As Single       ' Height in inches
   nCodeWordCol As Single ' Required for PDF417. The number of codewords per barcode coloumn.
   nCodeWordRow As Single ' Required for PDF417. The number of codewords per barcode row.
   Resolution As Long     ' Required -> Should be 300
   Symbology As Long      ' PDF417, QRCode, or DataMatrix.
   Version As Single      ' Should be 1
   Width As Single        ' Width in inches
   XSymHeight As Single   ' Only needed for PDF417. The vertical distance between two barcode modules,
                          ' measured in pixels. The ratio XSymHeight/XSymWidth shall be an integer
                          ' value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode
                          ' and DataMatrix, this ratio shall always be 1.
   XSymWidth As Single    ' Required -> The horizontal distance, in pixels, between two barcode modules.
End Type

Private Type TPDFChoiceValue_I
   StructSize As Long ' Must be initialzed to sizeof(TPDFChoiceValue_I)
   ExpValueA As Long
   ExpValueW As Long
   ExpValueLen As Long
   ValueA As Long
   ValueW As Long
   ValueLen As Long
   Selected As Long
End Type

'The structure contains several duplicate fields because CMap files contain usually a DSC comment
'section which provides Postscript specific initialization code. With exception of DSCResName the
'strings in the DSC section should not differ from their CMap counterparts. The Identity mapping
'of a character collection should contain the DSC comment "%%BeginResource: CMap (Identity)".
'Otherwise the string should be set to the CMap name.
Private Type TPDFCMap_I
   StructSize As Long       ' Must be set to sizeof(TPDFCMap) before calling GetCMap()!
   BaseCMap As Long         ' If set, this base cmap is required when loading the cmap.
   CIDCount As Long         ' 0 if not set.
   CMapName As Long         ' The CMap name.
   CMapType As Long         ' Should be 1!
   CMapVersion As Single    ' The CMap version.
   DSCBaseCMap As Long      ' DSC comment.
   DSCCMapVersion As Single ' DSC comment.
   DSCResName As Long       ' DSC comment. If the CMap uses an Identity mapping this string should be set to Identity.
   DSCTitle As Long         ' DSC comment -> DSC CMap name + Registry + Ordering + Supplement, e.g. "GB-EUC-H Adobe GB1 0"
   FileNameA As Long        ' The file name and CMap name should be identical!
   FileNameW As Long        ' The file name and CMap name should be identical!
   FilePathA As Long        ' The Ansi string is set if the Ansi version of SetCMapDir() was used.
   FilePathW As Long        ' The Unicode string is set if the Unicode version of SetCMapDir() was used.
   Ordering As Long         ' CIDSystemInfo -> The Character Collection, e.g. Japan1.
   Registry As Long         ' CIDSystemInfo -> The registrant of the Character Collection is usually Adobe.
   Supplement As Long       ' CIDSystemInfo -> The Supplement number should be supported in the used PDF version.
   WritingMode As Long      ' 0 == Horizontal, 1 == Vertical
End Type

Private Type TPDFColorSpaceObj_I
   ColorSpaceType As TExtColorSpace
   Alternate As TExtColorSpace      ' Alternate color space or base space of an Indexed or Pattern color space.
   IAlternate As Long               ' Only set if the color space contains an alternate or base color space -> GetColorSpaceObjEx().
   Buffer As Long                   ' Contains either an ICC profile or the color table of an Indexed color space.
   BufSize As Long                  ' Buffer length in bytes.
   BlackPoint As Long               ' CIE blackpoint. If set, the array contains exactly 3 values.
   WhitePoint As Long               ' CIE whitepoint. If set, the array contains exactly 3 values.
   Gamma As Long                    ' If set, one value per component.
   Range As Long                    ' min/max for each component or for the .a and .b components of a Lab color space.
   Matrix As Long                   ' XYZ matrix. If set, the array contains exactly 9 values.
   NumInComponents As Long          ' Number of input components.
   NumOutComponents As Long         ' Number of output components.
   NumColors As Long                ' HiVal + 1 as specified in the color space. Indexed color space only.
   Colorants(31) As Long            ' UTF-8 Colorant names (Separation, DeviceN, and NChannel only).
   ColorantsCount As Long           ' The number of colorants in the array.
   Metadata As Long                 ' Optional XMP metadata stream -> ICCBased only.
   MetadataSize As Long             ' Metadata length in bytes.
   IFunction As Long                ' Pointer to function object -> Separation, DeviceN, and NChannel only.
   IAttributes As Long              ' Optional attributes of DeviceN or NChannel color spaces -> GetNChannelAttributes().
   IColorSpaceObj As Long           ' Pointer of the corresponding color space object
   Handle As Long                   ' Handle of the color space object
   Reserved01 As Long
   Reserved02 As Long
   Reserved03 As Long
   Reserved04 As Long
   Reserved05 As Long
   Reserved06 As Long
   Reserved07 As Long
   Reserved08 As Long
End Type

Private Type TPDFError_I
   StructSize As Long ' Must be initialized to sizeof(TPDFError)
   Message As Long    ' The error message
   ObjNum As Long     ' -1 if not available
   Offset As Long     ' -1 if not available
   SrcFile As Long    ' Source file
   SrcLine As Long    ' Source line
   ErrCode As Long    ' ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
   ErrType As Long    ' ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
End Type

Private Type TPDFField_I
   FieldType As Long
   Deleted As Long
   BBox As TPDFRect
   Handle As Long
   FieldName As Long
   FieldNameLen As Long
   BackCS As Long
   TextCS As Long
   BackColor As Long
   BorderColor As Long
   TextColor As Long
   Checked As Long
   Parent As Long
   KidCount As Long
   FontName As Long
   FontSize As Double
   Value As Long
   UniVal As Long
   valLen As Long
   ToolTip As Long
   UniToolTip As Long
   ToolTipLen As Long
End Type

Private Type TPDFFieldEx_I
   StructSize As Long              ' Must be set to sizeof(TPDFFieldEx)
   Deleted As Long                 ' If true, the field was marked as deleted by DeleteField()
   BBox As TPDFRect                ' Bounding box of the field in bottom-up coordinates
   FieldType As TFieldType         ' Field type
   GroupType As TFieldType         ' If GroupType != FieldType the field is a terminal field of a field group
   Handle As Long                  ' Field handle
   BackColor As Long               ' Background color
   BackColorSP As TExtColorSpace   ' Color space of the background color
   BorderColor As Long             ' Border color
   BorderColorSP As TExtColorSpace ' Color space of the border color
   BorderStyle As TBorderStyle     ' Border style
   BorderWidth As Single           ' Border width
   CharSpacing As Single           ' Text fields only
   Checked As Long                 ' Check boxes only
   CheckBoxChar As Long            ' ZapfDingbats character that is used to display the on state
   DefState As TCheckBoxState      ' Check boxes only
   DefValueA As Long               ' Optional default value
   DefValueW As Long               ' Optional default value
   IEditFont As Long               ' Pointer to default editing font
   EditFont As Long                ' Postscript name of the editing font
   ExpValCount As Long             ' Combo and list boxes only. The values can be accessed with GetFieldExpValueEx()
   ExpValueA As Long               ' Check boxes only
   ExpValueW As Long               ' Check boxes only
   FieldFlags As TFieldFlags       ' Field flags
   IFieldFont As Long              ' Pointer to the font that is used by the field
   FieldFont As Long               ' Postscript name of the font
   Reserved1 As Long               ' Reserved field to avoid alignment errors
   FontSize As Double              ' Font size. 0.0 means auto font size
   FieldNameA As Long              ' Note that children of a field group or radio button have no name
   FieldNameW As Long              ' Field name length in characters
   HighlightMode As THighlightMode ' Highlight mode
   IsCalcField As Long             ' If true, the OnCalc event of the field is connected with a JavaScript action
   MapNameA As Long                ' Optional unique mapping name of the field
   MapNameW As Long                ' MapName length in characters
   MaxLen As Long                  ' Text fields only -> zero means not restricted
   Kids As Long                    ' Array of child fields -> GetFieldEx2()
   KidCount As Long                ' Number of fields in the array
   Parent As Long                  ' Pointer to parent field or NULL
   PageNum As Long                 ' Page on which the field is used or -1
   Rotate As Long                  ' Rotation angle in degrees
   TextAlign As TTextAlign         ' Text fields only
   TextColor As Long               ' Text color
   TextColorSP As TExtColorSpace   ' Color space of the field's text
   TextScaling As Single           ' Text fields only
   ToolTipA As Long                ' Optional tool tip
   ToolTipW As Long                ' Optional tool tip
   UniqueNameA As Long             ' Optional unique name (NM key)
   UniqueNameW As Long             ' Optional unique name (NM key)
   ValueA As Long                  ' Field value
   ValueW As Long                  ' Field value
   WordSpacing As Single           ' Text fields only
   PageIndex As Long               ' Array index to change the tab order, see SortFieldsByIndex().
   IBarcode As Long                ' If present, this field is a barcode field. The field type is set to ftText
                                   ' since barcode fields are extended text fields. -> GetBarcodeDict().
   ISignature As Long              ' Signature fields only. Present only for imported signature fields which
                                   ' which have a value. That means the file was digitally signed. -> GetSigDict().
                                   ' Signed signature fields are always marked as deleted!
   ModDate As Long                 ' Last modification date (optional)
   ' Push buttons only. The down and roll over states are optional. If not present, then all states use the up state.
   ' The handles of the up, down, and roll over states are template handles! The templates can be opened for editing
   ' with EditTemplate2() and parsed with ParseContent().
   CaptionPos As TBtnCaptionPos    ' Where to position the caption relative to its image
   DownCaptionA As Long            ' Caption of the down state
   DownCaptionW As Long            ' Caption of the down state
   DownImage As Long               ' Image of the down state
   RollCaptionA As Long            ' Caption of the roll over state
   RollCaptionW As Long            ' Caption of the roll over state
   RollImage As Long               ' Image of the roll over state
   UpCaptionA As Long              ' Caption of the up state
   UpCaptionW As Long              ' Caption of the up state
   UpImage As Long                 ' Image of the up state -> if > -1, the button is an image button
   OC As Long                      ' Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   Action As Long                  ' Action handle or -1 if not set. This action is executed when the field is activated.
   ActionType As TActionType       ' Meaningful only, if Action >= 0.
   Events As Long                  ' See GetObjEvent() if set.
   Reserved2 As Long               ' Reserved field to avoid alignment errors
   FmtTextColor As Long            ' Zero if not set. Usually RGB red otherwise.
   FmtTextA As Long                ' Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
   FmtTextW As Long                ' Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
   Reserved3 As Long               ' Reserved field to avoid alignment errors
End Type

Private Type TPDFFileSpec_I
   Buffer As Long
   BufSize As Long
   Compressed As Long
   ColItem As Long
   Name As Long
   NameUnicode As Long
   FileName As Long
   IsURL As Long
   UF As Long
   UFUnicode As Long
   Desc As Long
   DescUnicode As Long
   FileSize As Long
   MIMEType As Long
   CreateDate As Long
   ModDate As Long
   CheckSum As Long
End Type

Private Type TPDFFileSpecEx_I
   StructSize As Long     ' Must be set to sizeof(TPDFFileSpecEx).
   AFRelationship As Long ' PDF 2.0
   ColItem As Long        ' If != NULL the embedded file contains a collection item with user defined data. This entry can
                          ' occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further information.
   DescriptionA As Long   ' Optional description string.
   DescriptionW As Long   ' Optional description string.
   DOS As Long            ' Optional DOS file name.
   EmbFileNode As Long    ' GetEmbeddedFileNode().
   FileName As Long       ' File name as 7 bit ASCII string.
   FileNameIsURL As Long  ' If true, FileName contains a URL.
   ID1 As Long            ' Optional file ID. Meaningful only if FileName points to a PDF file.
   ID1Len As Long         ' String length in bytes.
   ID2 As Long            ' Optional file ID. Meaningful only if FileName points to a PDF file.
   ID2Len As Long         ' String length in bytes.
   IsVolatile As Long     ' If true, the file changes frequently with time.
   Mac As Long            ' Optional Mac file name.
   Unix As Long           ' Optional Unix file name.
   RelFileNode As Long    ' Optional related files array. -> GetRelFileNode().
   Thumb As Long          ' Optional thumb nail image. -> GetImageObjEx().
   UFileNameA As Long     ' PDF 1.7. Same as FileName but Unicode is allowed.
   UFileNameW As Long     ' Either the Ansi or Unicode string is set but never both.
End Type

Private Type TPDFEmbFileNode_I
   StructSize As Long   ' Must be set to sizeof(TPDFEmbFileNode).
   Name As Long         ' UTF-8 encoded name. This key contains usually a 7 bit ASCII string.
   EF As TPDFFileSpec_I ' Embedded file
   NextNode As Long     ' Next node if any.
End Type

Private Type TPDFGlyphOutline_I
   AdvanceX As Single
   AdvanceY As Single
   OriginX As Single
   OriginY As Single
   Lsb As Integer
   Tsb As Integer
   HaveBBox As Long
   BBox As TFRect
   Outline As Long
   Size As Long
End Type

Private Type TPDFGoToAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFGoToAction).
   DestPage As Long              ' Destination page (the first page is denoted by 1).
   DestPos As Long               ' Destination position -> Array of 4 floating point values if set.
   DestType As TDestType         ' Destination type.
   ' GoToR (GoTo Remote) actions only:
   DestFile As Long              ' see GetFileSpec().
   DestNameA As Long             ' Optional named destination that shall be loaded when opening the file.
   DestNameW As Long             ' Either the Ansi or Unicode string is set but never both.
   NewWindow As Long             ' Meaningful only if the destination file points to a PDF file.
                                 ' -1 = viewer default, 0 = false, 1 = true.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFHideAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFHideAction).
   Fields As Long                ' Array of field pointers -> GetFieldEx2().
   FieldsCount As Long           ' Number of fields in the array.
   Hide As Long                  ' A flag indicating whether to hide or show the fields in the array.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFImportDataAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFImportDataAction).
   Data As TPDFFileSpecEx_I      ' The data or file to be loaded.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFJavaScriptAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFJavaScriptAction)
   ScriptA As Long               ' The script
   ScriptW As Long               ' Either the Ansi or Unicode string is set but never both
   ScriptLen As Long             ' Script length in characters
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFLaunchAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFLaunchAction).
   AppName As Long               ' Optional. The name of the application that should be launched.
   DefDir As Long                ' Optional default directory.
   File As Long                  ' see GetFileSpec().
   NewWindow As Long             ' -1 = viewer default, 0 = false, 1 = true.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
   Operation As Long             ' Optional string specifying the operation to perform (open or print).
   Parameter As Long             ' Optional parameter string that shall be passed to the application (AppName).
End Type

Private Type TPDFMeasure_I
   StructSize As Long    ' Must be set to sizeof(TPDFMeasure)
   IsRectilinear As Long ' If true, the members of the rectilinear measure dictionary are set. The geospatial members otherwise.
   ' --- Rectilinear measure dictionary ---
   Angles As Long        ' Number format array to measure angles -> GetNumberFormatObj()
   AnglesCount As Long   ' Number of objects in the array.
   Area As Long          ' Number format array to measure areas -> GetNumberFormatObj()
   AreaCount As Long     ' Number of objects in the array.
   CXY As Single         ' Optional, meaningful only when Y is present.
   Distance As Long      ' Number format array to measure distances -> GetNumberFormatObj()
   DistanceCount As Long ' Number of objects in the array.
   OriginX As Single     ' Origin of the measurement coordinate system.
   OriginY As Single     ' Origin of the measurement coordinate system.
   RA As Long            ' A text string expressing the scale ratio of the drawing.
   RW As Long            ' A text string expressing the scale ratio of the drawing.
   Slope As Long         ' Number format array for measurement of the slope of a line -> GetNumberFormatObj()
   SlopeCount As Long    ' Number of objects in the array.
   X As Long             ' Number format array for measurement of change along the x-axis and, if Y is not present, along the y-axis as well.
   XCount As Long        ' Number of objects in the array.
   Y As Long             ' Number format array for measurement of change along the y-axis.
   YCount As Long        ' Number of objects in the array.

   ' --- Geospatial measure dictionary ---
   Bounds As Long        ' Array of numbers taken pairwise to describe the bounds for which geospatial transforms are valid.
   BoundCount As Long    ' Number of values in the array. Should be a multiple of two.

   ' The DCS coordinate system is optional.
   DCS_IsSet As Long     ' If true, the DCS members are set.
   DCS_Projected As Long ' If true, the DCS values contains a pojected coordinate system.
   DCS_EPSG As Long      ' Optional, either EPSG or WKT is set.
   DCS_WKT As Long       ' Optional ASCII string

   ' The GCS coordinate system is required and should be present.
   GCS_Projected As Long ' If true, the GCS values contains a pojected coordinate system.
   GCS_EPSG As Long      ' Optional, either EPSG or WKT is set.
   GCS_WKT As Long       ' Optional ASCII string

   GPTS As Long          ' Required, an array of numbers that shall be taken pairwise, defining points in geographic space as degrees of latitude and longitude, respectively.
   GPTSCount As Long     ' Number of values in the array.
   LPTS As Long          ' Optional, an array of numbers that shall be taken pairwise to define points in a 2D unit square.
   LPTSCount As Long     ' Number of values in the array.

   PDU1 As Long          ' Optional preferred linear display units.
   PDU2 As Long          ' Optional preferred area display units.
   PDU3 As Long          ' Optional preferred angular display units.
End Type

Private Type TPDFMovieAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFMovieAction).
   Annot As Long                 ' Optional. The movie annotation handle identifying the movie that shall be played.
   FWPosition(1) As Single       ' FWPosition
   FWScale(1) As Long            ' FWScale
   Mode As Long                  ' Mode
   Operation As Long             ' Operation
   Rate As Single                ' Rate
   ShowControls As Long          ' ShowControls
   Synchronous As Long           ' Synchronous
   TitleA As Long                ' The title of a movie annotation that shall be played. Either Annot or Title should be set, but not both.
   TitleW As Long                ' Either the Ansi or Unicode string is set at time.
   Volume As Single              ' Volume
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFNamedAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFNamedAction).
   Name As Long                  ' Only set if Type == naUserDefined
   NewWindow As Long             ' -1 = viewer default, 0 = false, 1 = true.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
   Type As TNamedAction          ' Known pre-defined actions.
End Type

Private Type TPDFNamedDest_I
   StructSize As Long
   NameA As Long
   NameW As Long
   NameLen As Long
   DestFileA As Long
   DestFileW As Long
   DestFileLen As Long
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
End Type

Private Type TPDFNumberFormat_I
   StructSize As Long
   C As Single
   d As Long
   f As TMeasureNumFormat
   FD As Long
   O As TMeasureLblPos
   PSA As Long
   PSW As Long
   RDA As Long
   RDW As Long
   RTA As Long
   RTW As Long
   SSA As Long
   SSW As Long
   UA As Long
   UW As Long
End Type

Private Type TPDFOCG_I
   StructSize As Long    ' Must be set to sizeof(TPDFOCG)
   Handle As Long        ' Handle or array index
   Intent As Long        ' Bitmask -> TOCGIntent
   NameA As Long         ' Layer name
   NameW As Long         ' Layer name
   HaveContUsage As Long ' If true, the layer contains a Content Usage dictionary. -> GetOCGContUsage().
   ' The following two members can only be set if HaveContUsage is true.
   AppEvents As Long     ' Bitmask -> see TOCAppEvent. If non-zero, the layer is included in one or more app events which control the layer state.
   Categories As Long    ' Bitmask -> see TOCGUsageCategory. The Usage Categories which control the layer state.
End Type

Private Type TPDFOCGContUsage_I
   StructSize As Long            ' Must be set to sizeof(TPDFOCGContUsage)
   ExportState As Long           ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   InfoCreatorA As Long          ' CreatorInfo -> The application that created the group
   InfoCreatorW As Long          ' CreatorInfo -> The application that created the group
   InfoSubtype As Long           ' CreatorInfo -> A name defining the type of content, e.g. Artwork, Technical etc.
   LanguageA As Long             ' A language code as described at SetLanguage() in the help file.
   LanguageW As Long             ' A language code as described at SetLanguage() in the help file.
   LangPreferred As Long         ' 0 = Off, 1 = On, PDF_MAX_INT = not set. The preffered state if there is a partial but no exact match of the language identifier.
   PageElement As TOCPageElement ' If the group contains a pagination artefact.
   PrintState As Long            ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   PrintSubtype As Long          ' The type of content that is controlled by the OCG, e.g. Trapping, PrintersMarks or Watermark.
   UserNamesCount As Long        ' The user names (if any) can be accessed with GetOCGUsageUserName().
   UserType As TOCUserType       ' The user for whom this optional content group is primarily intendet.
   ViewState As Long             ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   ZoomMin As Single             ' The minimum magnification factor at which the group should be On. -1 if not set.
   ZoomMax As Single             ' The maximum magnification factor at which the group should be On. -1 if not set.
End Type

Private Type TPDFOCLayerConfig_I
   StructSize As Long   ' Must be set to sizeof(TOCLayerConfig)
   Intent As TOCGIntent ' Possible values oiDesign, oiView, or oiAll.
   IsDefault As Long    ' If true, this is the default configuration.
   NameA As Long        ' Optional configuration name. The default config has usually no name but all others should have one.
   NameW As Long        ' Either the Ansi or Unicode string is set at time but never both.
   NameLen As Long      ' Length in characters.
End Type

Private Type TPDFOCUINode_I
   StructSize As Long  ' Must be set to sizeof(TOCUINode)
   LabelA As Long      ' Optional label.
   LabelW As Long      ' Either the Ansi or Unicode string is set at time but never both.
   LabelLength As Long ' Length in characters.
   NextChild As Long   ' If set, the next child node that must be loaded.
   NewNode As Long     ' If true, a new child node must be created.
   OCG As Long         ' Optional OCG handle. -1 if not set -> GetOCG().
End Type

Private Type TPDFOutputIntent_I
   StructSize As Long
   Buffer As Long
   BufSize As Long
   InfoA As Long
   InfoW  As Long
   NumComponents As Long
   OutputConditionA As Long
   OutputConditionW As Long
   OutputConditionIDA As Long
   OutputConditionIDW As Long
   RegistryNameA As Long
   RegistryNameW As Long
   Subtype As Long
End Type

Private Type TPDFPageLabel_I
   StartRange As Long
   Format As TPageLabelFormat
   FirstPageNum As Long
   Prefix As Long
   PrefixLen As Long
   PrefixUni As Long
End Type

Private Type TPDFPrintSettings_I
   DuplexMode As Long
   NumCopies As Long             ' -1 means not set. Values larger than 5 are ignored in viewer applications.
   PickTrayByPDFSize As Long     ' -1 means not set. 0 == false, 1 == true.
   PrintRanges As Long           ' If set, the array contains PrintRangesCount * 2 values. Each pair consists
                                 ' of the first and last pages in the sub-range. The first page in the PDF file
                                 ' is denoted by 0.
   PrintRangesCount As Long      ' Number of ranges available in PrintRanges.
   PrintScaling As Long ' dpmNone means not set.
   ' Reserved fields for future extensions
   Reserved0 As Long
   Reserved1 As Long
   Reserved2 As Long
   Reserved3 As Long
   Reserved4 As Long
   Reserved5 As Long
   Reserved6 As Long
   Reserved7 As Long
   Reserved8 As Long
   Reserved9 As Long
End Type

Private Type TPDFRawImage_I
   StructSize As Long       ' Must be set to sizeof(TPDFRawImage)
   Buffer As Long           ' Image buffer
   BufSize As Long          ' Buffer size
   BitsPerComponent As Long ' Bits per component
   NumComponents As Long    ' Number of components (max 32)
   CS As TExtColorSpace     ' Image color space
   CSHandle As Long         ' Color space handle (non-device color spaces only)
   Stride As Long           ' Scanline length in bytes -> If negative, the image is defined in bottom up coordinates, top down otherwise
   HasAlpha As Long         ' If true, the last component is an alpha channel
   IsBGR As Long            ' esDeviceRGB only -> If true, the image components are defined as BGR instead of RGB
   MinIsWhite As Long       ' 1 bit images only -> If true, zero pixel values must be treated as white instead of black
   Width As Long            ' Width in pixels (must be greater zero)
   Height As Long           ' Height in pixels (must be greater zero)
End Type

Private Type TPDFRelFileNode_I
   StructSize As Long     ' Must be set to sizeof(TPDFRelFileNode).
   NameA As Long          ' Name of this file spcification.
   NameW As Long          ' Either the Ansi or Unicode name is set but never both.
   EF As TPDFFileSpecEx_I ' Embedded file.
   NextNode As Long       ' Next node if any.
End Type

Private Type TPDFResetFormAction_I
   StructSize As Long            ' Must be set to sizeof(TResetFormAction)
   Fields As Long                ' Array of field pointers -> GetFieldEx2().
   FieldsCount As Long           ' Number of fields in the array.
   Include As Long               ' If true, the fields in the Fields array must be reset. If false, these fields must be excluded.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFSigDict_I
   StructSize As Long     ' Must be set to sizeof(TPDFSigDict_I).
   ByteRange As Long      ' ByteRange -> Byte offset followed by the corresponding length.
                          ' The byte ranges are required to create the digest. The values
                          ' are returned as is. So, you must check whether the offsets and
                          ' length values are valid. There are normally at least two ranges.
                          ' Overlapping ranges are not allowed! Any error breaks processing
                          ' and the signature should be considered as invalid.
   ByteRangeCount As Long ' The number of Offset / Length pairs. ByteRange contains 2 * ByteRangeCount values!
   Cert As Long           ' X.509 Certificate when SubFilter is adbe.x509.rsa_sha1.
   CertLen As Long        ' Length in bytes
   Changes As Long        ' If set, an array of three integers that specify changes to the
                          ' document that have been made between the previous signature and
                          ' this signature in this order: the number of pages altered, the
                          ' number of fields altered, and the number of fields filled in.
   ContactInfoA As Long   ' Optional contact info string, e.g. an email address
   ContactInfoW As Long   ' Optional contact info string, e.g. an email address
   Contents As Long       ' The signature. This is either a DER encoded PKCS#1 binary data
                          ' object or a DER-encoded PKCS#7 binary data object depending on
                          ' the used SubFilter.
   ContentsSize As Long   ' Length in bytes.
   Filter As Long         ' The name of the security handler, usually Adobe.PPKLite.
   LocationA As Long      ' Optional location of the signer
   LocationW As Long      ' Optional location of the signer
   SignTime As Long       ' Date/Time string
   NameA As Long          ' Optional signers name
   NameW As Long          ' Optional signers name
   PropAuthTime As Long   ' Optional -> The number of seconds since the signer was last authenticated.
   PropAuthType As Long   ' Optional -> The method that shall be used to authenticate the signer.
                          ' Valid values are PIN, Password, and Fingerprint.
   ReasonA As Long        ' Optional reason
   ReasonW As Long        ' Optional reason
   Revision As Long       ' Optional -> The version of the signature handler that was used to create
                          ' the signature.
   SubFilter As Long      ' A name that describes the encoding of the signature value. Should be
                          ' adbe.x509.rsa_sha1, adbe.pkcs7.detached, or adbe.pkcs7.sha1.
   Version As Long        ' The version of the signature dictionary format.
End Type

Private Type TPDFSigParms_I
   StructSize As Long        ' Must be set to sizeof(TSignParms)
   PKCS7ObjLen As Long       ' The maximum length of the signed PKCS#7 object
   HashType As THashType     ' If set to htDetached, the bytes ranges of the PDF file will be returned.
   Range1 As Long            ' Out -> Contains either the hash or the first byte range to create a detached signature
   Range1Len As Long         ' Out -> Length of the buffer
   Range2 As Long            ' Out -> Set only if HashType == htDetached
   Range2Len As Long         ' Out -> Length of the buffer
   ContactInfoA As Long      ' Optional, e.g. an email address
   ContactInfoW As Long      ' Optional, e.g. an email address
   LocationA As Long         ' Optional location of the signer
   LocationW As Long         ' Optional location of the signer
   ReasonA As Long           ' Optional reason why the file was signed
   ReasonW As Long           ' Optional reason why the file was signed
   SignerA As Long           ' Optional, the issuer of the certificate takes precedence
   SignerW As Long           ' Optional, the issuer of the certificate takes precedence
   Encrypt As Long           ' If true, the file will be encrypted
   ' These members will be ignored if Encrypt is set to false
   OpenPwd As String         ' Open password
   OwnerPwd As String        ' Owner password to change the security settings
   KeyLen As TKeyLen         ' Key length to be used to encrypt the file
   Restrict As TRestrictions ' What should be restricted?
   Certificate As Long       ' Handle of a certificate (PCCERT_CONTEXT), returned by CertFindCertificateInStore(), for example.
                             ' If this paramteter is set, PKCS7ObjLen will be ignored and the file will be signed with this certificate.
   TimeStampServer As Long   ' Optional URL of a time stamp server
   TimeOut As Long           ' Optional number of millisecond
End Type

Private Type TPDFSubmitFormAction_I
   StructSize As Long            ' Must be set to sizeof(TSubmitFormAction)
   CharSet As Long               ' Optional charset in which the form should be submitted.
   Fields As Long                ' Array of field pointers -> GetFieldEx2().
   FieldsCount As Long           ' Number of fields in the array.
   Flags As TSubmitFlags         ' Various flags, see CreateSubmitAction() for further information.
   URL As Long                   ' The URL of the script at the Web server that will process the submission.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFSysFont_I
   StructSize As Long          ' Must be set to sizeof(TPDFSysFont)
   BaseType As TFontBaseType   ' Font type
   CIDOrdering As Long         ' OpenType CID fonts only
   CIDRegistry As Long         ' OpenType CID fonts only
   CIDSupplement As Long       ' OpenType CID fonts only
   DataOffset As Long          ' Data offset
   FamilyName As Long          ' Family name
   FilePathA As Long           ' Font file path
   FilePathW As Long           ' Font file path
   FileSize As Long            ' File size in bytes
   Flags As TEnumFontProcFlags ' Bitmask
   FullName As Long            ' Full name
   Length1 As Long             ' Length of the clear text portion of a Type1 font
   Length2 As Long             ' Length of the eexec encrypted binary portion of a Type1 font
   PostScriptNameA As Long     ' Postscript mame
   PostScriptNameW As Long     ' Postscript mame
   Index As Long               ' Zero based font index if the font is stored in a TrueType collection
   IsFixedPitch As Long        ' If true, the font is a fixed pitch font. A proprtional font otherwise.
   Style As TFStyle            ' Font style
   UnicodeRange1 As Long       ' Bitmask -> TUnicodeRange1
   UnicodeRange2 As Long       ' Bitmask -> TUnicodeRange2
   UnicodeRange3 As Long       ' Bitmask -> TUnicodeRange3
   UnicodeRange4 As Long       ' Bitmask -> TUnicodeRange3
End Type

Private Type TPDFURIAction_I
   StructSize As Long            ' Must be set to sizeof(TPDFURIAction)
   BaseURL As Long               ' Optional, if defined in the Catalog object.
   IsMap As Long                 ' A flag specifying whether to track the mouse position when the URI is resolved: e.g. http:'test.org?50,70.
   URI As Long                   ' Uniform Resource Identifier.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Private Type TPDFViewport_I
   StructSize As Long ' Must be set to sizeof(TPDFViewport)
   BBox As TFltRect   ' Bounding box
   Measure As Long    ' Optional -> GetMeasureObj()
   NameA As Long      ' Optional name
   NameW As Long      ' Optional name
   PtData As Long     ' Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
End Type

Private Type TPDFXFAStream_I
   StructSize As Long ' Must be set to sizeof(TPDFXFAStream_I)
   Buffer As Long
   BufSize As Long
   NameA As Long
   NameW As Long
End Type

Private m_Instance As Long

' These variables are used to speed up processing
Private FBookmark As TBookmark_I
Private FField As TPDFField_I
Private FStack As TPDFStack_I

Private Declare Function pdfAddDeviceNProcessColorants Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DeviceNCS As Long, ByVal Colorants As Long, ByVal NumColorants As Long, ByVal ProcessCS As Long, ByVal Handle As Long) As Long
Private Declare Function pdfAddDeviceNSeparations Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DeviceNCS As Long, ByVal Colorants As Long, ByVal SeparationCS As Long, ByVal NumColorants As Long) As Long
Private Declare Function pdfAddFieldToFormAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Action As Long, ByVal Field As Long, ByVal DoInclude As Long) As Long
Private Declare Function pdfAddFieldToHideAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal HideAct As Long, ByVal Field As Long) As Long
Private Declare Function pdfAddFileCommentA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String) As Long
Private Declare Function pdfAddFileCommentW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As Long) As Long
Private Declare Function pdfAddFontSearchPathA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal APath As String, ByVal Recursive As Long) As Long
Private Declare Function pdfAddFontSearchPathW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal APath As Long, ByVal Recursive As Long) As Long
Private Declare Function pdfAddInkList Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal InkAnnot As Long, ByVal points As Long, ByVal NumPoints As Long) As Long
Private Declare Function pdfAddJavaScriptA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Script As String) As Long
Private Declare Function pdfAddJavaScriptW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long, ByVal Script As Long) As Long
Private Declare Function pdfAddLayerToDisplTreeA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Parent As Long, ByVal Layer As Long, ByVal Title As String) As Long
Private Declare Function pdfAddLayerToDisplTreeW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Parent As Long, ByVal Layer As Long, ByVal Title As Long) As Long
Private Declare Function pdfAddMaskImage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal BaseImage As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Stride As Long, ByVal BitsPerPixel As Long, ByVal Width As Long, ByVal Height As Long) As Long
Private Declare Function pdfAddObjectToLayer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OCG As Long, ByVal ObjType As TOCObject, ByVal Handle As Long) As Long
Private Declare Function pdfAddOCGToAppEvent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Events As TOCAppEvent, ByVal Categories As TOCGUsageCategory) As Long
Private Declare Function pdfAddOutputIntentA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ICCFile As String) As Long
Private Declare Function pdfAddOutputIntentW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ICCFile As Long) As Long
Private Declare Function pdfAddOutputIntentEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfAddPageLabelA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal StartRange As Long, ByVal Format As Long, ByVal Prefix As String, ByVal AddNum As Long) As Long
Private Declare Function pdfAddPageLabelW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal StartRange As Long, ByVal Format As Long, ByVal Prefix As Long, ByVal AddNum As Long) As Long
Private Declare Function pdfAddRasImage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal RasPtr As Long, ByVal Filter As TCompressionFilter) As Long
Private Declare Function pdfAddValToChoiceFieldA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ExpValue As String, ByVal Value As String, ByVal Selected As Long) As Long
Private Declare Function pdfAddValToChoiceFieldW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ExpValue As String, ByVal Value As Long, ByVal Selected As Long) As Long
Private Declare Function pdfAppend Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfApplyAppEvent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AppEvent As TOCAppEvent, ByVal SaveResult As Long) As Long
Private Declare Function pdfApplyPattern Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PattHandle As Long, ByVal ColorMode As Long, ByVal Color As Long) As Long
Private Declare Function pdfApplyShading Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ShadHandle As Long) As Long
Private Declare Function pdfAssociateEmbFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DestObject As TAFDestObject, ByVal DestHandle As Long, ByVal Relationship As TAFRelationship, ByVal EmbFile As Long) As Long
Private Declare Function pdfAttachFileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FilePath As String, ByVal Description As String, ByVal Compress As Long) As Long
Private Declare Function pdfAttachFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FilePath As Long, ByVal Description As Long, ByVal Compress As Long) As Long
Private Declare Function pdfAttachFileExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal FileName As String, ByVal Description As String, ByVal Compress As Long) As Long
Private Declare Function pdfAttachFileExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal FileName As Long, ByVal Description As Long, ByVal Compress As Long) As Long
Private Declare Function pdfAutoTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Templ As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfBeginClipPath Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfBeginContinueText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double) As Long
Private Declare Function pdfBeginLayer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OCG As Long) As Long
Private Declare Function pdfBeginPageTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal UseAutoTemplates As Long) As Long
Private Declare Function pdfBeginPattern Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PatternType As Long, ByVal TilingType As Long, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfBeginTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfBeginTransparencyGroup Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal Isolated As Integer, ByVal Knockout As Integer, ByVal CS As TExtColorSpace, ByVal CSHandle As Long) As Long
Private Declare Function pdfBezier_1_2_3 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double) As Long
Private Declare Function pdfBezier_1_3 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x3 As Double, ByVal y3 As Double) As Long
Private Declare Function pdfBezier_2_3 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double) As Long
Private Declare Function pdfCalcWidthHeight Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OrgWidth As Double, ByVal OrgHeight As Double, ByVal ScaledWidth As Double, ByVal ScaledHeight As Double) As Double
Private Declare Function pdfCaretAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
Private Declare Function pdfCaretAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Content As Long) As Long
Private Declare Function pdfChangeAnnotNameA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Name As String) As Long
Private Declare Function pdfChangeAnnotNameW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Name As Long) As Long
Private Declare Function pdfChangeAnnotPos Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfChangeBookmarkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ABmk As Long, ByVal ATitle As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long) As Long
Private Declare Function pdfChangeBookmarkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ABmk As Long, ByVal ATitle As Long, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long) As Long
Private Declare Function pdfChangeFont Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfChangeFontEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal FontSize As Double, ByVal Style As TFStyle) As Long
Private Declare Function pdfChangeFontSize Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Size As Double) As Long
Private Declare Function pdfChangeFontStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Style As Long) As Long
Private Declare Function pdfChangeFontStyleEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Style As Long) As Long
Private Declare Function pdfChangeJavaScriptA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal NewScript As String) As Long
Private Declare Function pdfChangeJavaScriptW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal NewScript As Long) As Long
Private Declare Function pdfChangeJavaScriptActionA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal NewScript As String) As Long
Private Declare Function pdfChangeJavaScriptActionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal NewScript As Long) As Long
Private Declare Function pdfChangeJavaScriptNameA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Name As String) As Long
Private Declare Function pdfChangeJavaScriptNameW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Name As Long) As Long
Private Declare Function pdfChangeLinkAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal URL As String) As Long
Private Declare Function pdfChangeSeparationColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CSHandle As Long, ByVal NewColor As Long, ByVal Alternate As TExtColorSpace, ByVal AltHandle As Long) As Long
Private Declare Function pdfCheckFieldNames Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCheckCollection Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCheckConformance Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ConfType As Long, ByVal Options As Long, ByVal UserData As Long, ByVal OnFontNotFound As Long, ByVal OnReplaceICCProfile As Long) As Long
Private Declare Function pdfCircleAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
Private Declare Function pdfCircleAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Comment As Long) As Long
Private Declare Function pdfClearAutoTemplates Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Sub pdfClearErrorLog Lib "dynapdf.dll" (ByVal IPDF As Long)
Private Declare Function pdfClearHostFonts Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfClipPath Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ClipMode As Long, ByVal FillMode As Long) As Long
Private Declare Function pdfCloseAndSignFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CertFile As String, ByVal Password As String, ByVal Reason As String, ByVal Location As String) As Long
Private Declare Function pdfCloseAndSignFileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As Long, ByVal Restrict As Long, ByVal CertFile As String, ByVal Password As String, ByVal Reason As String, ByVal Location As String) As Long
Private Declare Function pdfCloseAndSignFileExt Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef SigParms As TPDFSigParms_I) As Long
Private Declare Function pdfCloseFile Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCloseFileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As Long, ByVal Restrict As Long) As Long
Private Declare Function pdfCloseImage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCloseImportFile Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCloseImportFileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfClosePath Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FillMode As Long) As Long
Private Declare Function pdfCloseTag Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfComputeBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef BBox As TPDFRect, ByVal Flags As Long) As Long
Private Declare Function pdfConvertColors Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long, ByVal Add As Long) As Long
Private Declare Function pdfConvertEMFSpoolA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SpoolFile As String, ByVal LeftMargin As Double, ByVal TopMargin As Double, ByVal Flags As TSpoolConvFlags) As Long
Private Declare Function pdfConvertEMFSpoolW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SpoolFile As Long, ByVal LeftMargin As Double, ByVal TopMargin As Double, ByVal Flags As TSpoolConvFlags) As Long
Private Declare Function pdfConvToUnicode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AString As String, ByVal CP As Long) As Long
Private Declare Function pdfCopyChoiceValues Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Source As Long, ByVal Dest As Long, ByVal Share As Long) As Long
Private Declare Function pdfCreate3DAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Name As String, ByVal U3DFile As String, ByVal Image As String) As Long
Private Declare Function pdfCreate3DAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Name As String, ByVal U3DFile As String, ByVal Image As String) As Long
Private Declare Function pdfCreate3DAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As Long, ByVal Name As Long, ByVal U3DFile As Long, ByVal Image As Long) As Long
Private Declare Function pdfCreate3DBackground Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal IView As Long, ByVal BackColor As Long) As Long
Private Declare Function pdfCreate3DGotoViewAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Base3DAnnot As Long, ByVal IView As Long, ByVal Named As Long) As Long
Private Declare Function pdfCreate3DProjection Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal IView As Long, ByVal ProjType As Long, ByVal ScaleType As Long, ByVal Diameter As Double, ByVal FOV As Double) As Long
Private Declare Function pdfCreate3DViewW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Base3DAnnot As Long, ByVal Name As Long, ByVal SetAsDefault As Long, ByRef Matrix As Any, ByVal CamDistance As Double, ByVal RM As Long, ByVal LS As Long) As Long
Private Declare Function pdfCreateAnnotAP Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Annot As Long) As Long
Private Declare Function pdfCreateArticleThreadA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ThreadName As String) As Long
Private Declare Function pdfCreateArticleThreadW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ThreadName As Long) As Long
Private Declare Function pdfCreateAxialShading Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal sx As Double, ByVal sy As Double, ByVal eX As Double, ByVal eY As Double, ByVal SCenter As Double, ByVal SColor As Long, ByVal EColor As Long, ByVal Extend1 As Long, ByVal Extend2 As Long) As Long
Private Declare Function pdfCreateBarcodeField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByRef Barcode As TPDFBarcode_I) As Long
Private Declare Function pdfCreateButtonA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Caption As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateButtonW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Caption As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateCheckBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal ExpValue As String, ByVal Checked As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateCIEColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Base As Long, ByVal WhitePoint As Long, ByVal BlackPoint As Long, ByVal Gamma As Long, ByVal Matrix As Long) As Long
Private Declare Function pdfCreateCollection Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal View As Long) As Long
Private Declare Function pdfCreateCollectionFieldA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColType As Long, ByVal Column As Long, ByVal Name As String, ByVal Key As String, ByVal Visible As Long, ByVal Editable As Long) As Long
Private Declare Function pdfCreateCollectionFieldW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColType As Long, ByVal Column As Long, ByVal Name As Long, ByVal Key As String, ByVal Visible As Long, ByVal Editable As Long) As Long
Private Declare Function pdfCreateColItemDate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal EmbFile As Long, ByVal Key As String, ByVal DateVal As Long, ByVal Prefix As String) As Long
Private Declare Function pdfCreateColItemNumber Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal EmbFile As Long, ByVal Key As String, ByVal Value As Double, ByVal Prefix As String) As Long
Private Declare Function pdfCreateColItemStringA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal EmbFile As Long, ByVal Key As String, ByVal Value As String, ByVal Prefix As String) As Long
Private Declare Function pdfCreateColItemStringW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal EmbFile As Long, ByVal Key As String, ByVal Value As Long, ByVal Prefix As Long) As Long
Private Declare Function pdfCreateComboBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Sort As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateDeviceNColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Colorants As Long, ByVal NumColorants As Long, ByVal PostScriptFunc As String, ByVal Alternate As Long, ByVal Handle As Long) As Long
Private Declare Function pdfCreateExtGState Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef GS As TPDFExtGState) As Long
Private Declare Function pdfCreateGoToAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DestType As Long, ByVal PageNum As Long, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
Private Declare Function pdfCreateGoToActionEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NamedDest As Long) As Long
Private Declare Function pdfCreateGoToEActionA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Location As TEmbFileLocation, ByVal Source As String, ByVal SrcPage As Long, ByVal Target As String, ByVal DestName As String, ByVal DestPage As Long, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGoToEActionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Location As TEmbFileLocation, ByVal Source As Long, ByVal SrcPage As Long, ByVal Target As Long, ByVal DestName As Long, ByVal DestPage As Long, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGoToRAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal PageNum As Long) As Long
Private Declare Function pdfCreateGoToRActionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfCreateGoToRActionExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGoToRActionExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal DestName As Long, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGoToRActionExUA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal DestName As String, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGoToRActionExUW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal DestName As Long, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateGroupField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Parent As Long) As Long
Private Declare Function pdfCreateHideAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Hide As Long) As Long
Private Declare Function pdfCreateICCBasedColorSpaceA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ICCProfile As String) As Long
Private Declare Function pdfCreateICCBasedColorSpaceW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ICCProfile As Long) As Long
Private Declare Function pdfCreateICCBasedColorSpaceEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfCreateImageA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal Format As Long) As Long
Private Declare Function pdfCreateImageW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal Format As Long) As Long
Private Declare Function pdfCreateImpDataActionA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DataFile As String) As Long
Private Declare Function pdfCreateImpDataActionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DataFile As Long) As Long
Private Declare Function pdfCreateIndexedColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Base As Long, ByVal Handle As Long, ByRef ColorTable() As Byte, ByVal NumColors As Long) As Long
Private Declare Function pdfCreateJSActionA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Script As String) As Long
Private Declare Function pdfCreateJSActionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Script As Long) As Long
Private Declare Function pdfCreateLaunchAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OP As Long, ByVal FileName As String, ByVal DefDir As String, ByVal Param As String, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateLaunchActionExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateLaunchActionExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal NewWindow As Long) As Long
Private Declare Function pdfCreateListBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Sort As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateNamedAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Action As Long) As Long
Private Declare Function pdfCreateNamedDestA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal DestPage As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
Private Declare Function pdfCreateNamedDestW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long, ByVal DestPage As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
Private Declare Function pdfCreateNewPDFA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutPDF As String) As Long
Private Declare Function pdfCreateNewPDFW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutPDF As Long) As Long
Private Declare Function pdfCreateOCGA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal DisplayInUI As Long, ByVal Visible As Long, ByVal Intent As TOCGIntent) As Long
Private Declare Function pdfCreateOCGW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long, ByVal DisplayInUI As Long, ByVal Visible As Long, ByVal Intent As TOCGIntent) As Long
Private Declare Function pdfCreateOCMD Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Visibility As TOCVisibility, ByRef OCGs As Any, ByVal Count As Long) As Long
Private Declare Function pdfCreateRadialShading Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal sx As Double, ByVal sy As Double, ByVal R1 As Double, ByVal eX As Double, ByVal eY As Double, ByVal R2 As Double, ByVal SCenter As Double, ByVal SColor As Long, ByVal EColor As Long, ByVal Extend1 As Long, ByVal Extend2 As Long) As Long
Private Declare Function pdfCreateRadioButton Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal ExpValue As String, ByVal Checked As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateRectilinearMeasureW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Viewport As Long, ByVal UnitScale As Double, ByVal UnitDescription As Long, ByVal LabelDistance As Long, ByVal LabelArea As Long) As Long
Private Declare Function pdfCreateResetAction Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCreateSeparationCS Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Colorant As String, ByVal Alternate As Long, ByVal Handle As Long, ByVal Color As Long) As Long
Private Declare Function pdfCreateSigField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateSigFieldAP Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SigField As Long) As Long
Private Declare Function pdfCreateSoftMask Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TranspGroup As Long, ByVal MaskType As TSoftMaskType, ByVal BackColor As Long) As Long
Private Declare Function pdfCreateSetOCGStateAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal On_ As Long, ByVal OnCount As Long, ByVal Off As Long, ByVal OffCount As Long, ByVal Toggle As Long, ByVal ToggleCount As Long, ByVal PreserveRB As Long) As Long
Private Declare Function pdfCreateStdPattern Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Pattern As Long, ByVal LineWidth As Double, ByVal Distance As Double, ByVal LineColor As Long, ByVal BackColor As Long) As Long
Private Declare Function pdfCreateStructureTree Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfCreateStructureTreeEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal RootTag As TPDFBaseTag) As Long
Private Declare Function pdfCreateSubmitAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long, ByVal URL As String) As Long
Private Declare Function pdfCreateTextField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Parent As Long, ByVal Multiline As Long, ByVal MaxLen As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfCreateURIAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal URL As String) As Long
Private Declare Function pdfCreateViewportW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double) As Long
Private Declare Function pdfCreateXFAStreamA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfDecryptPDFA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal PwdType As Long, ByVal Password As String) As Long
Private Declare Function pdfDecryptPDFW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal PwdType As Long, ByVal Password As String) As Long
Private Declare Sub pdfDeleteAcroForm Lib "dynapdf.dll" (ByVal IPDF As Long)
Private Declare Function pdfDeleteActionFromObj Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal ActHandle As Long, ByVal ObjHandle As Long) As Long
Private Declare Function pdfDeleteActionFromObjEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Long
Private Declare Function pdfDeleteAnnotation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfDeleteAnnotationFromPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal Handle As Long) As Long
Private Declare Function pdfDeleteAppEvents Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ApplyEvent As Long, ByVal AppEvent As TOCAppEvent) As Long
Private Declare Function pdfDeleteBookmark Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ABmk As Long) As Long
Private Declare Function pdfDeleteEmbeddedFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfDeleteField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfDeleteFieldEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String) As Long
Private Declare Sub pdfDeleteJavaScripts Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DelJavaScriptActions As Long)
Private Declare Function pdfDeleteOCGFromAppEvent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Events As TOCAppEvent, ByVal Categories As TOCGUsageCategory, ByVal DelCategoryOnly As Long) As Long
Private Declare Function pdfDeleteOutputIntent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Private Declare Function pdfDeletePage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Sub pdfDeletePageLabels Lib "dynapdf.dll" (ByVal IPDF As Long)
Private Declare Function pdfDeletePDF Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfDeleteSeparationInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AllPages As Long) As Long
Private Declare Function pdfDeleteTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfDeleteTemplateEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Private Declare Sub pdfDeleteXFAForm Lib "dynapdf.dll" (ByVal IPDF As Long)
Private Declare Function pdfDrawArc Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal StartAngle As Double, ByVal EndAngle As Double) As Long
Private Declare Function pdfDrawArcEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double) As Long
Private Declare Function pdfDrawChord Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfDrawCircle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfDrawNGon Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal Alpha As Double, ByVal NumSides As Long, ByVal FillMode As TPathFillMode) As Long
Private Declare Function pdfDrawPie Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfEditPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfEditTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Private Declare Function pdfEditTemplate2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfEllipse Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfEncryptPDFA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As Long, ByVal Restrict As Long) As Long
Private Declare Function pdfEncryptPDFW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As Long, ByVal Restrict As Long) As Long
Private Declare Function pdfEndContinueText Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfEndLayer Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfEndPage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfEndPattern Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfEndTemplate Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfEnumDocFonts Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal EnumProc As Long) As Long
Private Declare Function pdfEnumHostFonts Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal EnumProc As Long) As Long
Private Declare Function pdfEnumHostFontsEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal EnumProc As Long) As Long
Private Declare Function pdfExchangeBookmarks Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Bmk1 As Long, ByVal Bmk2 As Long) As Long
Private Declare Function pdfExchangePages Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal First As Long, ByVal Second As Long) As Long
Private Declare Function pdfExtractText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal Flags As TTextExtractionFlags, ByVal Area As Long, ByRef text As Long, ByRef TextLen As Long) As Long
Private Declare Function pdfFileAttachAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As Long, ByVal Author As String, ByVal Desc As String, ByVal AFile As String, ByVal Compress As Long) As Long
Private Declare Function pdfFileAttachAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As Long, ByVal Author As Long, ByVal Desc As Long, ByVal AFile As Long, ByVal Compress As Long) As Long
Private Declare Function pdfFileAttachAnnotExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal FileName As String, ByVal Author As String, ByVal Desc As String, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Compress As Long) As Long
Private Declare Function pdfFileAttachAnnotExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal FileName As Long, ByVal Author As Long, ByVal Desc As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Compress As Long) As Long
Private Declare Function pdfFileLinkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal AFilePath As String) As Long
Private Declare Function pdfFileLinkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal AFilePath As Long) As Long
Private Declare Function pdfFindBookmarkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DestPage As Long, ByVal Title As String) As Long
Private Declare Function pdfFindBookmarkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DestPage As Long, ByVal Title As Long) As Long
Private Declare Function pdfFindEmbeddedFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long) As Long
Private Declare Function pdfFindFieldA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String) As Long
Private Declare Function pdfFindFieldW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long) As Long
Private Declare Function pdfFindLinkAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal URL As String) As Long
Private Declare Function pdfFindNextBookmark Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfFinishSignature Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef PKCS7Obj As Any, ByVal Length As Long) As Long
Private Declare Function pdfFlattenAnnotOrField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByVal Flags As TAnnotFlattenFlags) As Long
Private Declare Function pdfFlattenAnnots Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfFlattenForm Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfFlushPageContent Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfFlushPages Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As TFlushPageFlags) As Long
Private Declare Function pdfFlushPagesEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As TFlushPageFlags, ByVal LastPage As Long) As Long
Private Declare Sub pdfFreeImageBuffer Lib "dynapdf.dll" (ByVal IPDF As Long)
Private Declare Function pdfFreeImageObj Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfFreeImageObjEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ImagePtr As Long) As Long
Private Declare Function pdfFreePDF Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfFreeTextAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal AText As String, ByVal Align As Long) As Long
Private Declare Function pdfFreeTextAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As Long, ByVal AText As Long, ByVal Align As Long) As Long
Private Declare Function pdfFreeUniBuf Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGet3DAnnotStream Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Annot As Long, ByRef Data As Long, ByRef Size As Long, ByRef Subtype As Long) As Long
Private Declare Function pdfGetActionCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetActionHandle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Long
Private Declare Function pdfGetActionType Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ActHandle As Long) As Long
Private Declare Function pdfGetActionTypeEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Long
Private Declare Function pdfGetActiveFont Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetAllocBy Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Annot As TPDFAnnotation_I) As Long
Private Declare Function pdfGetAnnotBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef BBox As TPDFRect) As Long
Private Declare Function pdfGetAnnotCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetAnnotEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Annot As TPDFAnnotationEx_I) As Long
Private Declare Function pdfGetAnnotFlags Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetAnnotLink Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfGetAnnotType Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfGetAscent Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetBarcodeDict Lib "dynapdf.dll" (ByVal IBarcode As Long, ByRef Barcode As TPDFBarcode_I) As Long
Private Declare Function pdfGetBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Boundary As Long, ByRef BBox As TPDFRect) As Long
Private Declare Function pdfGetBidiMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetBookmark Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Bmk As TBookmark_I) As Long
Private Declare Function pdfGetBookmarkCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetBorderStyle Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef BufSize As Long) As Long
Private Declare Function pdfGetCapHeight Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetCharacterSpacing Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetCheckBoxChar Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetCheckBoxCharEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AField As Long) As Long
Private Declare Function pdfGetCheckBoxDefState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetCMap Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef CMap As TPDFCMap_I) As Long
Private Declare Function pdfGetCMapCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetColorSpaceCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetColorSpaceObj Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef CS As TPDFColorSpaceObj_I) As Long
Private Declare Function pdfGetColorSpaceObjEx Lib "dynapdf.dll" (ByVal IColorSpace As Long, ByRef CS As TPDFColorSpaceObj_I) As Long
Private Declare Function pdfGetCompressionFilter Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetCompressionLevel Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetContent Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Long) As Long
Private Declare Function pdfGetDefBitsPerPixel Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetDescent Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetDeviceNAttributes Lib "dynapdf.dll" (ByVal IAttributes As Long, ByRef Attributes As TDeviceNAttributes_I) As Long
Private Declare Function pdfGetDocInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByRef Value As Long) As Long
Private Declare Function pdfGetDocInfoCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetDocInfoEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef DInfo As Long, ByRef Key As Long, ByRef Value As Long, ByRef Unicode As Long) As Long
Private Declare Function pdfGetDocUsesTransparency Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfGetDrawDirection Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetDynaPDFVersion Lib "dynapdf.dll" () As Long
Private Declare Function pdfGetEmbeddedFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef FileSpec As TPDFFileSpec_I, ByVal Decompress As Long) As Long
Private Declare Function pdfGetEmbeddedFileCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetEmbeddedFileNode Lib "dynapdf.dll" (ByVal IEF As Long, ByRef f As TPDFEmbFileNode_I, ByVal Decompress As Long) As Long
Private Declare Function pdfGetEMFPatternDistance Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetErrLogMessage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Err As TPDFError_I) As Long
Private Declare Function pdfGetErrLogMessageCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetErrorMessage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetErrorMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Field As TPDFField_I) As Long
Private Declare Function pdfGetFieldBackColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFieldBorderColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFieldBorderStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldBorderWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Double
Private Declare Function pdfGetFieldCalcOrder Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef out As Long) As Long
Private Declare Function pdfGetFieldChoiceValue Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ValIndex As Long, ByRef Value As TPDFChoiceValue_I) As Long
Private Declare Function pdfGetFieldColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ColorType As Long, ByRef ColorSpace As Long, ByRef Color As Long) As Long
Private Declare Function pdfGetFieldCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFieldEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Field As TPDFFieldEx_I) As Long
Private Declare Function pdfGetFieldEx2 Lib "dynapdf.dll" (ByVal IField As Long, ByRef Field As TPDFFieldEx_I) As Long
Private Declare Function pdfGetFieldExpValCount Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldExpValue Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef Value As Long) As Long
Private Declare Function pdfGetFieldExpValueEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ValIndex As Long, ByRef Value As Long, ByRef ExpValue As Long, ByRef Selected As Long) As Long
Private Declare Function pdfGetFieldFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldGroupType Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldHighlightMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldIndex Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldMapName Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef Value As Long, ByRef bUnicode As Long) As Long
Private Declare Function pdfGetFieldName Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef Name As Long) As Long
Private Declare Function pdfGetFieldOrientation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldTextAlign Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFieldTextColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFieldToolTip Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef Value As Long, ByRef bUnicode As Long) As Long
Private Declare Function pdfGetFieldType Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long) As Long
Private Declare Function pdfGetFileSpec Lib "dynapdf.dll" (ByVal IFS As Long, ByRef f As TPDFFileSpecEx_I) As Long
Private Declare Function pdfGetFillColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFontCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFontEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Font As TPDFFontObj_I) As Long
Private Declare Function pdfGetFontInfoEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Font As TPDFFontInfo_I) As Long
Private Declare Function pdfGetFontMetrics Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Metrics As TPDFFontMetrics) As Long
Private Declare Function pdfGetFontOrigin Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Sub pdfGetFontSearchOrder Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Order As Any)
Private Declare Function pdfGetFontSelMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFontWeight Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetFTextHeightA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Align As Long, ByVal AText As String) As Double
Private Declare Function pdfGetFTextHeightW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Align As Long, ByVal AText As Long) As Double
Private Declare Function pdfGetFTextHeightExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Width As Double, ByVal Align As Long, ByVal AText As String) As Double
Private Declare Function pdfGetFTextHeightExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Width As Double, ByVal Align As Long, ByVal AText As Long) As Double
Private Declare Function pdfGetGlyphIndex Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Private Declare Function pdfGetGlyphOutline Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Outline As Any) As Long
Private Declare Function pdfGetGoToAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFGoToAction_I) As Long
Private Declare Function pdfGetGoToRAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFGoToAction_I) As Long
Private Declare Function pdfGetGStateFlags Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetHideAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFHideAction_I) As Long
Private Declare Function pdfGetIconColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetImageBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef BufSize As Long) As Long
Private Declare Function pdfGetImageCountW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long) As Long
Private Declare Function pdfGetImageHeight Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfGetImageObj Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Flags As TParseFlags, ByRef Image As TPDFImage) As Long
Private Declare Function pdfGetImageObjCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetImageObjEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ImagePtr As Long, ByVal Flags As TParseFlags, ByRef Image As TPDFImage) As Long
Private Declare Function pdfGetImageWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfGetImportDataAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFImportDataAction_I) As Long
Private Declare Function pdfGetImportFlags Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetImportFlags2 Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal Boundary As Long, ByRef BBox As TPDFRect) As Long
Private Declare Function pdfGetInDocInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByRef Value As Long) As Long
Private Declare Function pdfGetInDocInfoCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInDocInfoEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef DInfo As Long, ByRef Key As Long, ByRef Value As Long, ByRef Unicode As Long) As Long
Private Declare Function pdfGetInEncryptionFlags Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInFieldCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInIsCollection Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInIsEncrypted Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInIsSigned Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInIsTrapped Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInIsXFAForm Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInkList Lib "dynapdf.dll" (ByVal List As Long, ByRef points As Long, ByRef Count As Long) As Long
Private Declare Function pdfGetInMetadata Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByRef Buffer As Long, ByRef BufSize As Long) As Long
Private Declare Function pdfGetInOrientation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfGetInPageCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInPDFVersion Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetInPrintSettings Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Settings As TPDFPrintSettings_I) As Long
Private Declare Function pdfGetInRepairMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetIsFixedPitch Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetIsTaggingEnabled Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetItalicAngle Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetJavaScript Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef sLen As Long, ByRef bUnicode As Long) As Long
Private Declare Function pdfGetJavaScriptAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef sLen As Long, ByRef bUnicode As Long) As Long
Private Declare Function pdfGetJavaScriptAction2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal ObjHandle As Long, ByVal ActIndex As Long, ByRef sLen As Long, ByRef bUnicode As Long, ByRef ObjEvent As Long) As Long
Private Declare Function pdfGetJavaScriptActionEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFJavaScriptAction_I) As Long
Private Declare Function pdfGetJavaScriptCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetJavaScriptEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByRef sLen As Long, ByRef bUnicode As Long) As Long
Private Declare Function pdfGetJavaScriptName Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef NameLen As Long, ByRef Unicode As Long) As Long
Private Declare Function pdfGetJPEGQuality Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLanguage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLastTextPosX Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetLastTextPosY Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetLayerConfig Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Config As TPDFOCLayerConfig_I) As Long
Private Declare Function pdfGetLayerConfigCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLaunchAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFLaunchAction_I) As Long
Private Declare Function pdfGetLeading Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetLineCapStyle Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLineJoinStyle Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLineWidth Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetLinkHighlightMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetLogMetafileSizeW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByRef r As TRectL) As Long
Private Declare Function pdfGetLogMetafileSizeEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByRef r As TRectL) As Long
Private Declare Function pdfGetMatrix Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM) As Long
Private Declare Function pdfGetMaxFieldLen Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TxtField As Long) As Long
Private Declare Function pdfGetMeasureObj Lib "dynapdf.dll" (ByVal Measure As Long, ByRef Value As TPDFMeasure_I) As Long
Private Declare Function pdfGetMetaConvFlags Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetMetadata Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As TMetadataObj, ByVal Handle As Long, ByRef Buffer As Long, ByRef BufSize As Long) As Long
Private Declare Function pdfGetMissingGlyphs Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Count As Long) As Long
Private Declare Function pdfGetMiterLimit Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetMovieAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFMovieAction_I) As Long
Private Declare Function pdfGetNamedAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFNamedAction_I) As Long
Private Declare Function pdfGetNamedDest Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Dest As TPDFNamedDest_I) As Long
Private Declare Function pdfGetNamedDestCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetNeedAppearance Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetNumberFormatObj Lib "dynapdf.dll" (ByVal NumberFmt As Long, ByRef Value As TPDFNumberFormat_I) As Long
Private Declare Function pdfGetObjActionCount Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal ObjHandle As Long) As Long
Private Declare Function pdfGetObjActions Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByRef Actions As TPDFObjActions) As Long
Private Declare Function pdfGetObjEvent Lib "dynapdf.dll" (ByVal IEvent As Long, ByRef ObjEvent As TPDFObjEvent) As Long
Private Declare Function pdfGetOCG Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFOCG_I) As Long
Private Declare Function pdfGetOCGContUsage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFOCGContUsage_I) As Long
Private Declare Function pdfGetOCGCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetOCGUsageUserName Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Index As Long, ByRef NameA As Long, ByRef NameW As Long) As Long
Private Declare Function pdfGetOCHandle Lib "dynapdf.dll" (ByVal OC As Long) As Long
Private Declare Function pdfGetOCUINode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Node As Long, ByRef OutNode As TPDFOCUINode_I) As Long
Private Declare Function pdfGetOpacity Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetOrientation Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetOutputIntent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Intent As TPDFOutputIntent_I) As Long
Private Declare Function pdfGetOutputIntentCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Annot As TPDFAnnotation_I) As Long
Private Declare Function pdfGetPageAnnotCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageAnnotEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Annot As TPDFAnnotationEx_I) As Long
Private Declare Function pdfGetPageBBox Lib "dynapdf.dll" (ByVal PagePtr As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TFltRect) As Long
Private Declare Function pdfGetPageCoords Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Field As TPDFField_I) As Long
Private Declare Function pdfGetPageFieldCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageFieldEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Field As TPDFFieldEx_I) As Long
Private Declare Function pdfGetPageHeight Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetPageLabel Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Lbl As TPDFPageLabel_I) As Long
Private Declare Function pdfGetPageLabelCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageLayout Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageNum Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPageObject Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfGetPageOrientation Lib "dynapdf.dll" (ByVal PagePtr As Long) As Long
Private Declare Function pdfGetPageText Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfGetPageWidth Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetPDFVersion Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetPrintSettings Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Settings As TPDFPrintSettings_I) As Long
Private Declare Function pdfGetPtDataArray Lib "dynapdf.dll" (ByVal PtData As Long, ByVal Index As Long, ByRef DataType As Long, ByRef values As Long, ByRef valCount As Long) As Long
Private Declare Function pdfGetPtDataObj Lib "dynapdf.dll" (ByVal PtData As Long, ByRef Subtype As Long, ByRef NumArrays As Long) As Long
Private Declare Function pdfGetRelFileNode Lib "dynapdf.dll" (ByVal IRF As Long, ByRef f As TPDFRelFileNode_I, ByVal Decompress As Long) As Long
Private Declare Function pdfGetResetAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFResetFormAction_I) As Long
Private Declare Function pdfGetResolution Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetSaveNewImageFormat Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetSigDict Lib "dynapdf.dll" (ByVal ISignature As Long, ByRef SigDict As TPDFSigDict_I) As Long
Private Declare Function pdfGetStrokeColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetSubmitAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFSubmitFormAction_I) As Long
Private Declare Function pdfGetSysFontInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFSysFont_I) As Long
Private Declare Function pdfGetTabLen Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTemplCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTemplHandle Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTemplHeight Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Double
Private Declare Function pdfGetTemplWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Double
Private Declare Function pdfGetTextDrawMode Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTextFieldValue Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef Value As Long, ByRef ValIsUnicode As Long, ByRef DefValue As Long, ByRef DefValIsUnicode As Long) As Long
Private Declare Function pdfGetTextRect Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef PosX As Double, ByRef PosY As Double, ByRef Width As Double, ByRef Height As Double) As Long
Private Declare Function pdfGetTextRise Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetTextScaling Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetTextWidthA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String) As Double
Private Declare Function pdfGetTextWidthW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As Long) As Double
Private Declare Function pdfGetTextWidthExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String, ByVal sLen As Long) As Double
Private Declare Function pdfGetTextWidthExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As Long, ByVal sLen As Long) As Double
Private Declare Function pdfGetTransparentColor Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTrapped Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetTypoLeading Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetURIAction Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Action As TPDFURIAction_I) As Long
Private Declare Function pdfGetUseExactPwd Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUseGlobalImpFiles Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUserRights Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUserUnit Lib "dynapdf.dll" (ByVal IPDF As Long) As Single
Private Declare Function pdfGetUseStdFonts Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUseSystemFonts Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUsesTransparency Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfGetUseTransparency Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetUseVisibleCoords Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetViewerPreferences Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Preference As Long, ByRef AddVal As Long) As Long
Private Declare Function pdfGetViewport Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal Index As Long, ByRef vp As TPDFViewport_I) As Long
Private Declare Function pdfGetViewportCount Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfGetWMFDefExtent Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Width As Long, ByRef Height As Long) As Long
Private Declare Function pdfGetWMFPixelPerInch Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfGetWordSpacing Lib "dynapdf.dll" (ByVal IPDF As Long) As Double
Private Declare Function pdfGetXFAStream Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByVal out As Long) As Long
Private Declare Function pdfGetXFAStreamCount Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfHaveOpenDoc Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfHaveOpenPage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfHighlightAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Subtype As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
Private Declare Function pdfHighlightAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Subtype As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal Author As Long, ByVal Subject As Long, ByVal Comment As Long) As Long
Private Declare Function pdfImportBookmarks Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfImportCatalogObjects Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfImportDocInfo Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfImportEncryptionSettings Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfImportOCProperties Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfImportPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long) As Long
Private Declare Function pdfImportPageEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal ScaleX As Double, ByVal ScaleY As Double) As Long
Private Declare Function pdfImportPDFFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DestPage As Long, ByVal ScaleX As Double, ByVal ScaleY As Double) As Long
Private Declare Function pdfInitBarcode2 Lib "dynapdf.dll" (ByRef Barcode As TPDFBarcode2) As Long
Private Declare Function pdfInitColorManagement Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Profiles As Any, ByVal DestSpace As TPDFColorSpace, ByVal Flags As TPDFInitCMFlags) As Long
Private Declare Function pdfInitColorManagementEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Profiles As Any, ByVal DestSpace As TPDFColorSpace, ByVal Flags As TPDFInitCMFlags) As Long
Private Declare Function pdfInitExtGState Lib "dynapdf.dll" (ByRef GS As TPDFExtGState) As Long
Private Declare Function pdfInitOCGContUsage Lib "dynapdf.dll" (ByRef Value As TPDFOCGContUsage_I) As Long
Private Declare Function pdfInitStack Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfInkAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal points As Long, ByVal NumPoints As Long, ByVal LineWidth As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
Private Declare Function pdfInkAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal points As Long, ByVal NumPoints As Long, ByVal LineWidth As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Content As Long) As Long
Private Declare Function pdfInsertBarcode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByRef Barcode As TPDFBarcode2) As Long
Private Declare Function pdfInsertBMPFromBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByRef Buffer As Any) As Long
Private Declare Function pdfInsertBMPFromHandle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal hBitmap As Long) As Long
Private Declare Function pdfInsertBookmarkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long, ByVal AddChildren As Long) As Long
Private Declare Function pdfInsertBookmarkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long, ByVal AddChildren As Long) As Long
Private Declare Function pdfInsertBookmarkExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long, ByVal AddChildren As Long) As Long
Private Declare Function pdfInsertBookmarkExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long, ByVal AddChildren As Long) As Long
Private Declare Function pdfInsertImage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal AFile As String) As Long
Private Declare Function pdfInsertImageExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal AFile As Long, ByVal Index As Long) As Long
Private Declare Function pdfInsertImageFromBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Index As Long) As Long
Private Declare Function pdfInsertMetafileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertMetafileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertMetafileExtW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertMetafileExtEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertMetafileFromHandle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal hEnhMetafile As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertMetafileFromHandleEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal hEnhMetafile As Long, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfInsertRawImage Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BitsPerPixel As Long, ByVal ColorCount As Long, ByVal ImgWidth As Long, ByVal ImgHeight As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Long
Private Declare Function pdfInsertRawImageEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByRef Image As TPDFRawImage_I) As Long
Private Declare Function pdfIsBidiText Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String) As Long
Private Declare Function pdfIsColorPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal GrayIsColor As Long) As Long
Private Declare Function pdfIsEmptyPage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfLineAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
Private Declare Function pdfLineAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Comment As Long) As Long
Private Declare Function pdfLineTo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double) As Long
Private Declare Function pdfLoadCMap Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CMapName As String, ByVal Embed As Long) As Long
Private Declare Function pdfLoadFDFDataA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal Password As String, ByVal Flags As Long) As Long
Private Declare Function pdfLoadFDFDataW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal Password As String, ByVal Flags As Long) As Long
Private Declare Function pdfLoadFDFDataEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Password As String, ByVal Flags As Long) As Long
Private Declare Function pdfLoadFont Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfLoadFontExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal Index As Long, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfLoadFontExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal Index As Long, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfLoadLayerConfig Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long) As Long
Private Declare Function pdfLockLayer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Layer As Long) As Long
Private Declare Function pdfMovePage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Source As Long, ByVal Dest As Long) As Long
Private Declare Function pdfMoveTo Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double) As Long
Private Declare Function pdfNewPDF Lib "dynapdf.dll" () As Long
Private Declare Function pdfOpenImportBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal PwdType As Long, ByVal Password As String) As Long
Private Declare Function pdfOpenImportFileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal PwdType As Long, ByVal Password As String) As Long
Private Declare Function pdfOpenImportFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal PwdType As Long, ByVal Password As String) As Long
Private Declare Function pdfOpenOutputFileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutPDF As String) As Long
Private Declare Function pdfOpenOutputFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutPDF As Long) As Long
Private Declare Function pdfOpenOutputFileEncryptedW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutPDF As Long, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
Private Declare Function pdfOpenTagA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Tag As Long, ByVal Lang As String, ByVal AltText As String, ByVal Expansion As String) As Long
Private Declare Function pdfOpenTagW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Tag As Long, ByVal Lang As Long, ByVal AltText As Long, ByVal Expansion As Long) As Long
Private Declare Function pdfOptimize Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As TOptimizeFlags, ByVal Parms As Long) As Long
Private Declare Function pdfPageLink Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal DestPage As Long) As Long
Private Declare Function pdfPageLink2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As Long) As Long
Private Declare Function pdfPageLink3A Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As String) As Long
Private Declare Function pdfPageLink3W Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As Long) As Long
Private Declare Function pdfPageLinkEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal DestType As Long, ByVal DestPage As Long, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
Private Declare Function pdfPlaceImage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ImgHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Long
Private Declare Function pdfPlaceSigFieldValidateIcon Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SigField As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfPlaceTemplate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TmplHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Long
Private Declare Function pdfPlaceTemplateEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TmplHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Long
Private Declare Function pdfPolygonAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Vertices As Long, ByVal NumVertices As Long, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
Private Declare Function pdfPolygonAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Vertices As Long, ByVal NumVertices As Long, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Content As Long) As Long
Private Declare Function pdfPolyLineAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Vertices As Long, ByVal NumVertices As Long, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
Private Declare Function pdfPolyLineAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Vertices As Long, ByVal NumVertices As Long, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Content As Long) As Long
Private Declare Function pdfPrintPageA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Long
Private Declare Function pdfPrintPageW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal DocName As Long, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Long
Private Declare Function pdfPrintPDFFileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TmpDir As String, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Long
Private Declare Function pdfPrintPDFFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TmpDir As Long, ByVal DocName As Long, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Long
Private Declare Function pdfReadImageFormatW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByRef Width As Long, ByRef Height As Long, ByRef BitsPerPixel As Long, ByRef UseZip As Long) As Long
Private Declare Function pdfReadImageFormat2W Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal Index As Long, ByRef Width As Long, ByRef Height As Long, ByRef BitsPerPixel As Long, ByRef UseZip As Long) As Long
Private Declare Function pdfReadImageFormatEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal hBitmap As Long, ByRef Width As Long, ByRef Height As Long, ByRef BitsPerPixel As Long, ByRef UseZip As Long) As Long
Private Declare Function pdfReadImageFormatFromBuffer Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Index As Long, ByRef Width As Long, ByRef Height As Long, ByRef BitsPerPixel As Long, ByRef UseZip As Long) As Long
Private Declare Function pdfReadImageResolutionW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal Index As Long, ByRef resX As Long, ByRef resY As Long) As Long
Private Declare Function pdfReadImageResolutionEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Index As Long, ByRef resX As Long, ByRef resY As Long) As Long
Private Declare Function pdfRectangle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfReEncryptPDFA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As String, ByVal PwdType As Long, ByVal InPwd As String, ByVal NewOpenPwd As String, ByVal NewOwnerPwd As String, ByVal NewKeyLen As Long, ByVal Restrict As Long) As Long
Private Declare Function pdfReEncryptPDFW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FileName As Long, ByVal PwdType As Long, ByVal InPwd As String, ByVal NewOpenPwd As String, ByVal NewOwnerPwd As String, ByVal NewKeyLen As Long, ByVal Restrict As Long) As Long
Private Declare Function pdfRenameSpotColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Colorant As String, ByVal NewName As String) As Long
Private Declare Function pdfRenderAnnotOrField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal IsAnnot As Long, ByVal State As TButtonState, ByRef Matrix As TCTM, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByRef out As TPDFBitmap) As Long
Private Declare Function pdfRenderPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PagePtr As Long, ByVal RasPtr As Long, ByRef img As TPDFRasterImage) As Long
Private Declare Function pdfRenderPageEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DC As Long, ByRef DestX As Long, ByRef DestY As Long, ByVal PagePtr As Long, ByVal RasPtr As Long, ByRef img As TPDFRasterImage) As Long
Private Declare Function pdfRenderPageToImageA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfRenderPageToImageW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal OutFile As Long, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfRenderPDFFileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfRenderPDFFileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutFile As Long, ByVal Resolution As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfRenderPDFFileExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfRenderPDFFileExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OutFile As Long, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
Private Declare Function pdfReOpenImportFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfReplaceFontA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PDFFont As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal NameIsFamilyName As Long) As Long
Private Declare Function pdfReplaceFontW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PDFFont As Long, ByVal Name As Long, ByVal Style As TFStyle, ByVal NameIsFamilyName As Long) As Long
Private Declare Function pdfReplaceFontExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PDFFont As Long, ByVal FontFile As String, ByVal Embed As Long) As Long
Private Declare Function pdfReplaceFontExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PDFFont As Long, ByVal FontFile As Long, ByVal Embed As Long) As Long
Private Declare Function pdfReplaceICCProfileA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColorSpace As Long, ByVal ICCFile As String) As Long
Private Declare Function pdfReplaceICCProfileW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColorSpace As Long, ByVal ICCFile As Long) As Long
Private Declare Function pdfReplaceICCProfileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColorSpace As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfReplaceImageA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Source As Long, ByVal Image As String, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Long
Private Declare Function pdfReplaceImageW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Source As Long, ByVal Image As Long, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Long
Private Declare Function pdfReplaceImageEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Source As Long, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Long
Private Declare Function pdfReplacePageTextA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NewText As String, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfReplacePageTextExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NewText As String, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfReplacePageTextExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NewText As Long, ByRef Stack As TPDFStack_I) As Long
Private Declare Function pdfResetAnnotAP Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfResetEncryptionSettings Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfResetLineDashPattern Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfRestoreGraphicState Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfRotateCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Alpha As Double, ByVal OriginX As Double, ByVal OriginY As Double) As Long
Private Declare Function pdfRoundRect Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Radius As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfRoundRectEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal rWidth As Double, ByVal rHeight As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfSaveGraphicState Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfScaleCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal sx As Double, ByVal sy As Double) As Long
Private Declare Function pdfSelfTest Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfSet3DAnnotProps Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Annot As Long, ByVal ActType As Long, ByVal DeActType As Long, ByVal InstType As Long, ByVal DeInstType As Long, ByVal DisplToolbar As Long, ByVal DisplModelTree As Long) As Long
Private Declare Function pdfSet3DAnnotScriptA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Annot As Long, ByVal Value As String, ByVal sLen As Long) As Long
Private Declare Function pdfSetAllocBy Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetAnnotBorderEffect Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As TBorderEffect) As Long
Private Declare Function pdfSetAnnotBorderStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Style As TBorderStyle) As Long
Private Declare Function pdfSetAnnotBorderWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal LineWidth As Double) As Long
Private Declare Function pdfSetAnnotColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal ColorType As TAnnotColor, ByVal CS As TPDFColorSpace, ByVal Color As Long) As Long
Private Declare Function pdfSetAnnotFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfSetAnnotFlagsEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Flags As Long) As Long
Private Declare Function pdfSetAnnotHighlightMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Mode As THighlightMode) As Long
Private Declare Function pdfSetAnnotIcon Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Icon As TAnnotIcon) As Long
Private Declare Function pdfSetAnnotLineDashPattern Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Dash As Any, ByVal NumValues As Long) As Long
Private Declare Function pdfSetAnnotLineEndStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal StartStyle As TLineEndStyle, ByVal EndStyle As TLineEndStyle) As Long
Private Declare Function pdfSetAnnotMigrationStateW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Annot As Long, ByVal State As TAnnotState, ByVal User As Long) As Long
Private Declare Function pdfSetAnnotOpacity Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetAnnotOpenState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal DoOpen As Long) As Long
Private Declare Function pdfSetAnnotOrFieldDate Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal IsField As Long, ByVal DateType As TDateType, ByVal DateTime As Long) As Long
Private Declare Function pdfSetAnnotQuadPoints Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As Long, ByVal Count As Long) As Long
Private Declare Function pdfSetAnnotStringA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal StringType As Long, ByVal Value As String) As Long
Private Declare Function pdfSetAnnotStringW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal StringType As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetAnnotSubjectA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As String) As Long
Private Declare Function pdfSetAnnotSubjectW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Boundary As Long, ByVal LeftX As Double, ByVal LeftY As Double, ByVal RightX As Double, ByVal RightY As Double) As Long
Private Declare Function pdfSetBidiMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetBookmarkDest Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ABmk As Long, ByVal DestType As Long, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
Private Declare Function pdfSetBookmarkStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ABmk As Long, ByVal Style As Long, ByVal RGBColor As Long) As Long
Private Declare Function pdfSetBorderStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Style As Long) As Long
Private Declare Function pdfSetCharacterSpacing Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetCheckBoxChar Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CheckBoxChar As Long) As Long
Private Declare Function pdfSetCheckBoxDefState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Checked As Long) As Long
Private Declare Function pdfSetCheckBoxState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Checked As Long) As Long
Private Declare Function pdfSetCIDFontA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CMapHandle As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long) As Long
Private Declare Function pdfSetCIDFontW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CMapHandle As Long, ByVal Name As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long) As Long
Private Declare Function pdfSetCMapDirA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Path As String, ByVal Flags As TLoadCMapFlags) As Long
Private Declare Function pdfSetCMapDirW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Path As Long, ByVal Flags As TLoadCMapFlags) As Long
Private Declare Function pdfSetColDefFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal EmbFile As Long) As Long
Private Declare Function pdfSetColorMask Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ImageHandle As Long, ByVal Mask As Long, ByVal Count As Long) As Long
Private Declare Function pdfSetColors Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColorSpace As Long) As Long
Private Declare Function pdfSetColSortField Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ColField As Long, ByVal AscendingOrder As Long) As Long
Private Declare Function pdfSetCompressionFilter Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ComprFilter As Long) As Long
Private Declare Function pdfSetCompressionLevel Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CompressLevel As Long) As Long
Private Declare Function pdfSetContent Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfSetDateTimeFormat Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TxtField As Long, ByVal Fmt As Long) As Long
Private Declare Function pdfSetDefBitsPerPixel Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetDocInfoA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByVal Value As String) As Long
Private Declare Function pdfSetDocInfoW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetDocInfoExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByVal Key As String, ByVal Value As String) As Long
Private Declare Function pdfSetDocInfoExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DInfo As Long, ByVal Key As String, ByVal Value As Long) As Long
Private Declare Function pdfSetDrawDirection Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Direction As Long) As Long
Private Declare Function pdfSetEMFFrameDPI Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DPIX As Long, ByVal DPIY As Long) As Long
Private Declare Function pdfSetEMFPatternDistance Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetErrorMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ErrMode As Long) As Long
Private Declare Function pdfSetExtColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfSetExtFillColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfSetExtGState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfSetExtStrokeColorSpace Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Function pdfSetFieldBackColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AColor As Long) As Long
Private Declare Function pdfSetFieldBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByRef BBox As TPDFRect) As Long
Private Declare Function pdfSetFieldBorderColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AColor As Long) As Long
Private Declare Function pdfSetFieldBorderStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Style As Long) As Long
Private Declare Function pdfSetFieldBorderWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal LineWidth As Double) As Long
Private Declare Function pdfSetFieldCalcOrder Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal CurrIndex As Long, ByVal NewIndex As Long) As Long
Private Declare Function pdfSetFieldColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ColorType As Long, ByVal CS As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetFieldExpValueW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal ValIndex As Long, ByVal Value As Long, ByVal ExpValue As String, ByVal Selected As Long) As Long
Private Declare Function pdfSetFieldExpValueEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AField As Long, ByVal ValIndex As Long, ByVal Selected As Long, ByVal DefSelected As Long) As Long
Private Declare Function pdfSetFieldFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Flags As Long, ByVal DoReset As Long) As Long
Private Declare Function pdfSetFieldFontA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
Private Declare Function pdfSetFieldFontW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Name As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
Private Declare Function pdfSetFieldFontEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Handle As Long, ByVal FontSize As Double) As Long
Private Declare Function pdfSetFieldFontSize Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal FontSize As Double) As Long
Private Declare Function pdfSetFieldHighlightMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetFieldIndex Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Index As Long) As Long
Private Declare Function pdfSetFieldMapNameA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As String) As Long
Private Declare Function pdfSetFieldMapNameW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetFieldNameA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal NewName As String) As Long
Private Declare Function pdfSetFieldNameW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal NewName As Long) As Long
Private Declare Function pdfSetFieldOrientation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetFieldTextAlign Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Align As Long) As Long
Private Declare Function pdfSetFieldTextColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetFieldToolTipA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As String) As Long
Private Declare Function pdfSetFieldToolTipW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetFillColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetFillColorEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Color As Any, ByVal NumComponents As Long) As Long
Private Declare Function pdfSetFillColorF Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Color As Any, ByVal NumComponents As Long) As Long
Private Declare Function pdfSetFloatPrecision Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal NumTextDecDigits As Long, ByVal NumVectDecDigits As Long) As Long
Private Declare Function pdfSetFontA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfSetFontW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfSetFontExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As String, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfSetFontExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Name As Long, ByVal Style As Long, ByVal Size As Double, ByVal Embed As Long, ByVal CP As Long) As Long
Private Declare Function pdfSetFontOrigin Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Origin As Long) As Long
Private Declare Sub pdfSetFontSearchOrder Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Order As Any)
Private Declare Sub pdfSetFontSearchOrderEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal S1 As TFontBaseType, ByVal S2 As TFontBaseType, ByVal S3 As TFontBaseType, ByVal S4 As TFontBaseType)
Private Declare Function pdfSetFontSelMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetFontWeight Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Weight As Long) As Long
Private Declare Sub pdfSetGStateFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long, ByVal Reset As Long)
Private Declare Function pdfSetIconColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetImportFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfSetImportFlags2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfSetItalicAngle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Angle As Double) As Long
Private Declare Function pdfSetJPEGQuality Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetLanguage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ISOTag As String) As Long
Private Declare Function pdfSetLeading Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetLicenseKey Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As String) As Long
Private Declare Function pdfSetLineAnnotParms Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal FontHandle As Long, ByVal FontSize As Double, ByRef Parms As TLineAnnotParms) As Long
Private Declare Function pdfSetLineAnnotParms2 Lib "dynapdf.dll" Alias "pdfSetLineAnnotParms" (ByVal IPDF As Long, ByVal Handle As Long, ByVal FontHandle As Long, ByVal FontSize As Double, ByVal Parms As Long) As Long
Private Declare Function pdfSetLineCapStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Style As Long) As Long
Private Declare Function pdfSetLineDashPattern Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Dash As String, ByVal Phase As Long) As Long
Private Declare Function pdfSetLineDashPattern2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Dash As Any, ByVal NumValues As Long, ByVal Phase As Single) As Long
Private Declare Function pdfSetLineDashPatternEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Dash As Any, ByVal NumValues As Long, ByVal Phase As Long) As Long
Private Declare Function pdfSetLineJoinStyle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Style As Long) As Long
Private Declare Function pdfSetLineWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetLinkHighlightMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetListFont Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Private Declare Sub pdfSetMaxErrLogMsgCount Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long)
Private Declare Function pdfSetMaxFieldLen Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TxtField As Long, ByVal MaxLen As Long) As Long
Private Declare Function pdfSetMatrix Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM) As Long
Private Declare Function pdfSetMetaConvFlags Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Flags As Long) As Long
Private Declare Function pdfSetMetadata Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As TMetadataObj, ByVal Handle As Long, ByVal Buffer As Long, ByVal BufSize As Long) As Long
Private Declare Function pdfSetMiterLimit Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetNeedAppearance Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetNumberFormat Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TxtField As Long, ByVal Sep As Long, ByVal DecPlaces As Long, ByVal NegStyle As Long, ByVal CurrStr As String, ByVal Prepend As Long) As Long
Private Declare Function pdfSetOCGContUsage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Value As TPDFOCGContUsage_I) As Long
Private Declare Function pdfSetOCGState Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Visible As Long, ByVal SaveState As Long) As Long
Private Declare Function pdfSetOnErrorProc Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal ErrProc As Long) As Long
Private Declare Function pdfSetOnPageBreakProc Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal OnBreakProc As Long) As Long
Private Declare Function pdfSetOpacity Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetOrientation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetOrientationEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetPageBBox Lib "dynapdf.dll" (ByVal PagePtr As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TFltRect) As Long
Private Declare Function pdfSetPageCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageCoords As Long) As Long
Private Declare Function pdfSetPageFormat Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetPageHeight Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetPageLayout Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Layout As Long) As Long
Private Declare Function pdfSetPageMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetPageWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetPDFVersion Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Version As Long) As Long
Private Declare Function pdfSetPrintSettings Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long, ByVal PickTrayByPDFSize As Long, ByVal NumCopies As Long, ByVal PrintScaling As Long, ByVal PrintRanges As Long, ByVal NumRanges As Long) As Long
Private Declare Function pdfSetProgressProc Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Data As Long, ByVal InitProgress As Long, ByVal Progress As Long) As Long
Private Declare Function pdfSetResolution Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetSaveNewImageFormat Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetStrokeColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Color As Long) As Long
Private Declare Function pdfSetStrokeColorEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Color As Any, ByVal NumComponents As Long) As Long
Private Declare Function pdfSetStrokeColorF Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Color As Any, ByVal NumComponents As Long) As Long
Private Declare Function pdfSetTabLen Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal TabLen As Long) As Long
Private Declare Function pdfSetTemplBBox Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TPDFRect) As Long
Private Declare Function pdfSetTextDrawMode Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Mode As Long) As Long
Private Declare Function pdfSetTextFieldValueA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As String, ByVal DefValue As String, ByVal Align As Long) As Long
Private Declare Function pdfSetTextFieldValueW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As Long, ByVal DefValue As Long, ByVal Align As Long) As Long
Private Declare Function pdfSetTextFieldValueExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As String) As Long
Private Declare Function pdfSetTextFieldValueExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Field As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetTextRect Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfSetTextRise Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetTextScaling Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetTransparentColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AColor As Long) As Long
Private Declare Sub pdfSetTrapped Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long)
Private Declare Function pdfSetUseExactPwd Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseGlobalImpFiles Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseImageInterpolation Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseImageInterpolationEx Lib "dynapdf.dll" (ByVal Image As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUserUnit Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Single) As Long
Private Declare Function pdfSetUseStdFonts Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseSwapFile Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SwapContents As Long, ByVal SwapLimit As Long) As Long
Private Declare Function pdfSetUseSwapFileEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal SwapContents As Long, ByVal SwapLimit As Long, ByVal SwapDir As String) As Long
Private Declare Function pdfSetUseSystemFonts Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseTransparency Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetUseVisibleCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetViewerPreferences Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long, ByVal AddVal As Long) As Long
Private Declare Function pdfSetWMFDefExtent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Width As Long, ByVal Height As Long) As Long
Private Declare Function pdfSetWMFPixelPerInch Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Long) As Long
Private Declare Function pdfSetWordSpacing Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Double) As Long
Private Declare Function pdfSetXFAStream Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Index As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Private Declare Function pdfSkewCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Alpha As Double, ByVal beta As Double, ByVal OriginX As Double, ByVal OriginY As Double) As Long
Private Declare Function pdfSortFieldsByIndex Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfSortFieldsByName Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfSquareAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
Private Declare Function pdfSquareAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As Long, ByVal Subject As Long, ByVal Comment As Long) As Long
Private Declare Function pdfStampAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Subtype As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
Private Declare Function pdfStampAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Subtype As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As Long, ByVal Subject As Long, ByVal Comment As Long) As Long
Private Declare Function pdfStrokePath Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Private Declare Function pdfTestGlyphsA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FontHandle As Long, ByVal text As String) As Long
Private Declare Function pdfTestGlyphsW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FontHandle As Long, ByVal text As Long) As Long
Private Declare Function pdfTestGlyphsExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FontHandle As Long, ByVal text As String, ByVal Length As Long) As Long
Private Declare Function pdfTestGlyphsExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal FontHandle As Long, ByVal text As Long, ByVal Length As Long) As Long
Private Declare Function pdfTextAnnotA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal text As String, ByVal Icon As Long, ByVal DoOpen As Long) As Long
Private Declare Function pdfTextAnnotW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As Long, ByVal text As Long, ByVal Icon As Long, ByVal DoOpen As Long) As Long
Private Declare Function pdfTranslateCoords Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal OriginX As Double, ByVal OriginY As Double) As Long
Private Declare Function pdfTriangle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double, ByVal FillMode As Long) As Long
Private Declare Function pdfUnLockLayer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Layer As Long) As Long
Private Declare Function pdfWatermarkAnnot Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Private Declare Function pdfWebLinkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal URL As String) As Long
Private Declare Function pdfWebLinkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal URL As Long) As Long
Private Declare Function pdfWriteAngleTextA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String, ByVal Angle As Double, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal YOrigin As Double) As Long
Private Declare Function pdfWriteAngleTextW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As Long, ByVal Angle As Double, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal YOrigin As Double) As Long
Private Declare Function pdfWriteFTextA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Align As Long, ByVal AText As String) As Long
Private Declare Function pdfWriteFTextW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Align As Long, ByVal AText As Long) As Long
Private Declare Function pdfWriteFTextExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Align As Long, ByVal AText As String) As Long
Private Declare Function pdfWriteFTextExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Align As Long, ByVal AText As Long) As Long
Private Declare Function pdfWriteTextA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String) As Long
Private Declare Function pdfWriteTextW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal AText As Long) As Long
Private Declare Function pdfWriteTextExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String, ByVal sLen As Long) As Long
Private Declare Function pdfWriteTextExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal AText As Long, ByVal sLen As Long) As Long
Private Declare Function pdfWriteTextMatrixA Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM, ByVal AText As String) As Long
Private Declare Function pdfWriteTextMatrixW Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM, ByVal AText As Long) As Long
Private Declare Function pdfWriteTextMatrixExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM, ByVal AText As String, ByVal sLen As Long) As Long
Private Declare Function pdfWriteTextMatrixExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Matrix As TCTM, ByVal AText As Long, ByVal sLen As Long) As Long

Private Declare Function MultiByteToWideChar Lib "kernel32.dll" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpMultiByteStr As Long, ByVal cbMultiByte As Long, ByVal lpWideCharStr As Long, ByVal cchWideChar As Long) As Long


' --------------------------------------------------------------------------------------------------------------

Private Sub Class_Initialize()
   m_Instance = pdfNewPDF
   If m_Instance = 0 Then Err.Raise 7, "CPDF.Initialize", "Out of Memory!"
   pdfSetOnErrorProc m_Instance, ObjPtr(Me), AddressOf pdf_ErrorProc
   pdfSetProgressProc m_Instance, ObjPtr(Me), AddressOf pdf_InitProgress, AddressOf pdf_Progress
End Sub

Private Sub Class_Terminate()
   pdfDeletePDF m_Instance
End Sub

Friend Sub Abort(ByVal RasPtr As Long)
   Call rasAbort(RasPtr)
End Sub

Friend Function ActivateAltFontList(ByVal Handle As Long, ByVal EnableSysFonts As Boolean) As Boolean
   ActivateAltFontList = pdfActivateAltFontList(m_Instance, Handle, EnableSysFonts) <> 0
End Function

Friend Function AddActionToObj(ByVal ObjType As TObjType, ByVal ObjEvent As TObjEvent, ByVal ActHandle As Long, ByVal ObjHandle As Long) As Long
   AddActionToObj = pdfAddActionToObj(m_Instance, ObjType, ObjEvent, ActHandle, ObjHandle)
End Function

Friend Function AddAnnotToPage(ByVal PageNum As Long, ByVal Handle As Long) As Long
   AddAnnotToPage = pdfAddAnnotToPage(m_Instance, PageNum, Handle)
End Function

Friend Function AddArticle(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   AddArticle = pdfAddArticle(m_Instance, PosX, PosY, Width, Height) <> 0
End Function

Friend Function AddBookmark(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Long
   AddBookmark = pdfAddBookmarkW(m_Instance, StrPtr(Title), Parent, DestPage, DoOpen)
End Function

Friend Function AddBookmarkA(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Long
   AddBookmarkA = pdfAddBookmarkA(m_Instance, Title, Parent, DestPage, DoOpen)
End Function

Friend Function AddBookmarkW(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Long
   AddBookmarkW = pdfAddBookmarkW(m_Instance, StrPtr(Title), Parent, DestPage, DoOpen)
End Function

Friend Function AddBookmarkEx(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long) As Long
   AddBookmarkEx = pdfAddBookmarkExW(m_Instance, StrPtr(Title), Parent, NamedDest, CInt(DoOpen))
End Function

Friend Function AddBookmarkExA(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long) As Long
   AddBookmarkExA = pdfAddBookmarkExA(m_Instance, Title, Parent, NamedDest, CInt(DoOpen))
End Function

Friend Function AddBookmarkExW(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long) As Long
   AddBookmarkExW = pdfAddBookmarkExW(m_Instance, StrPtr(Title), Parent, NamedDest, CInt(DoOpen))
End Function

Friend Function AddBookmarkEx2(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As String, ByVal Unicode As Boolean, ByVal DoOpen As Boolean) As Long
   If Unicode Then
      AddBookmarkEx2 = pdfAddBookmarkEx2WW(m_Instance, StrPtr(Title), Parent, StrPtr(NamedDest), Unicode, DoOpen)
   Else
      AddBookmarkEx2 = pdfAddBookmarkEx2WA(m_Instance, StrPtr(Title), Parent, NamedDest, Unicode, DoOpen)
   End If
End Function

Friend Function AddBookmarkEx2A(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As String, ByVal Unicode As Boolean, ByVal DoOpen As Boolean) As Long
   If Unicode Then
      AddBookmarkEx2A = pdfAddBookmarkEx2AW(m_Instance, Title, Parent, StrPtr(NamedDest), Unicode, DoOpen)
   Else
      AddBookmarkEx2A = pdfAddBookmarkEx2AA(m_Instance, Title, Parent, NamedDest, Unicode, DoOpen)
   End If
End Function

Friend Function AddBookmarkEx2W(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As String, ByVal Unicode As Boolean, ByVal DoOpen As Boolean) As Long
   If Unicode Then
      AddBookmarkEx2W = pdfAddBookmarkEx2WW(m_Instance, StrPtr(Title), Parent, StrPtr(NamedDest), Unicode, DoOpen)
   Else
      AddBookmarkEx2W = pdfAddBookmarkEx2WA(m_Instance, StrPtr(Title), Parent, NamedDest, Unicode, DoOpen)
   End If
End Function

Friend Function AddButtonImage(ByVal BtnHandle As Long, ByVal State As TButtonState, ByVal Caption As String, ByVal ImgFile As String) As Boolean
   AddButtonImage = pdfAddButtonImageW(m_Instance, BtnHandle, State, StrPtr(Caption), StrPtr(ImgFile)) <> 0
End Function

Friend Function AddButtonImageW(ByVal BtnHandle As Long, ByVal State As TButtonState, ByVal Caption As String, ByVal ImgFile As String) As Boolean
   AddButtonImageW = pdfAddButtonImageW(m_Instance, BtnHandle, State, StrPtr(Caption), StrPtr(ImgFile)) <> 0
End Function

Friend Function AddButtonImageEx(ByVal BtnHandle As Long, ByVal State As TButtonState, ByVal Caption As String, ByVal hBitmap As Long) As Boolean
   AddButtonImageEx = pdfAddButtonImageEx(m_Instance, BtnHandle, State, Caption, hBitmap) <> 0
End Function

Friend Function AddButtonImageEx2(ByVal BtnHandle As Long, ByVal State As TButtonState, ByVal Caption As String, ByRef Buffer() As Byte) As Boolean
   AddButtonImageEx2 = pdfAddButtonImageEx2(m_Instance, BtnHandle, State, Caption, Buffer(0), UBound(Buffer) + 1) <> 0
End Function

Friend Function AddContinueText(ByVal AText As String) As Boolean
   AddContinueText = pdfAddContinueTextW(m_Instance, StrPtr(AText)) <> 0
End Function

Friend Function AddContinueTextA(ByVal AText As String) As Boolean
   AddContinueTextA = pdfAddContinueTextA(m_Instance, AText) <> 0
End Function

Friend Function AddContinueTextW(ByVal AText As String) As Boolean
   AddContinueTextW = pdfAddContinueTextW(m_Instance, StrPtr(AText)) <> 0
End Function

Friend Function AddDeviceNProcessColorants(ByVal DeviceNCS As Long, ByRef Colorants() As String, ByVal NumColorants As Long, ByVal ProcessCS As TExtColorSpace, ByVal Handle As Long) As Boolean
   Dim i As Long
   Dim C() As String
   ReDim C(NumColorants - 1)
   For i = 0 To NumColorants - 1
      C(i) = StrConv(Colorants(i), vbFromUnicode, 0)
   Next i
   AddDeviceNProcessColorants = pdfAddDeviceNProcessColorants(m_Instance, DeviceNCS, VarPtr(C(0)), NumColorants, ProcessCS, Handle) <> 0
End Function

Friend Function AddDeviceNSeparations(ByVal DeviceNCS As Long, ByRef Colorants() As String, ByRef SeparationCS() As Long, ByVal NumColorants As Long) As Boolean
   Dim i As Long
   Dim C() As String
   ReDim C(NumColorants - 1)
   For i = 0 To NumColorants - 1
      C(i) = StrConv(Colorants(i), vbFromUnicode, 0)
   Next i
   AddDeviceNSeparations = pdfAddDeviceNSeparations(m_Instance, DeviceNCS, VarPtr(C(0)), VarPtr(SeparationCS(0)), NumColorants) <> 0
End Function

Friend Function AddDPartNode(ByVal Parent As Long, ByVal FirstPage As Long, ByVal LastPage As Long, ByVal DPM As String) As Long
   AddDPartNode = pdfAddDPartNode(m_Instance, Parent, FirstPage, LastPage, DPM)
End Function

Friend Function AddFieldToFormAction(ByVal Action As Long, ByVal Field As Long, ByVal DoInclude As Boolean) As Boolean
   AddFieldToFormAction = pdfAddFieldToFormAction(m_Instance, Action, Field, DoInclude) <> 0
End Function

Friend Function AddFieldToHideAction(ByVal HideAct As Long, ByVal Field As Long) As Boolean
   AddFieldToHideAction = pdfAddFieldToHideAction(m_Instance, HideAct, Field) <> 0
End Function

Friend Function AddFileCommentA(ByVal AText As String) As Boolean
   AddFileCommentA = pdfAddFileCommentA(m_Instance, AText) <> 0
End Function

Friend Function AddFileCommentW(ByVal AText As String) As Boolean
   AddFileCommentW = pdfAddFileCommentW(m_Instance, StrPtr(AText)) <> 0
End Function

Friend Function AddFontSearchPath(ByVal APath As String, ByVal Recursive As Boolean) As Long
   AddFontSearchPath = pdfAddFontSearchPathW(m_Instance, StrPtr(APath), Recursive)
End Function

Friend Function AddFontSearchPathA(ByVal APath As String, ByVal Recursive As Boolean) As Long
   AddFontSearchPathA = pdfAddFontSearchPathA(m_Instance, APath, Recursive)
End Function

Friend Function AddFontSearchPathW(ByVal APath As String, ByVal Recursive As Boolean) As Long
   AddFontSearchPathW = pdfAddFontSearchPathW(m_Instance, StrPtr(APath), Recursive)
End Function

Friend Function AddHeaderFooter(ByRef Value As TPDFHeaderFooter, ByRef HFArray() As TPDFHdrFtr) As Boolean
   Dim i As Long
   Dim val As TPDFHeaderFooter_I
   Dim hf() As TPDFHdrFtr_I
   
   ReDim hf(UBound(HFArray))
   
   val.StructSize = LenB(val)
   val.FirstPage = Value.FirstPage
   val.Flags = Value.Flags
   val.InitCodepage = Value.InitCodepage
   val.InitColor = Value.InitColor
   val.InitCS = Value.InitCS
   val.InitCSHandle = Value.InitCSHandle
   val.InitEmbed = Value.InitEmbed
   val.InitFontW = StrPtr(Value.InitFont)
   val.InitFontSize = Value.InitFontSize
   val.LastPage = Value.LastPage
   val.Margin = Value.Margin
   
   For i = 0 To UBound(HFArray)
      hf(i).CodePage = HFArray(i).CodePage
      hf(i).Color = HFArray(i).Color
      hf(i).CS = HFArray(i).CS
      hf(i).CSHandle = HFArray(i).CSHandle
      hf(i).Embed = HFArray(i).Embed
      hf(i).FontW = StrPtr(HFArray(i).Font)
      hf(i).FontSize = HFArray(i).FontSize
      hf(i).IsHeader = HFArray(i).IsHeader
      hf(i).Position = HFArray(i).Position
      hf(i).ShiftX = HFArray(i).ShiftX
      hf(i).ShiftY = HFArray(i).ShiftY
      hf(i).TextW = StrPtr(HFArray(i).text)
      hf(i).TextLen = Len(HFArray(i).text)
   Next i
   AddHeaderFooter = pdfAddHeaderFooter(m_Instance, val, VarPtr(hf(0)), UBound(hf) + 1)
End Function

Friend Function AddInkList(ByVal InkAnnot As Long, ByRef points() As TFltPoint) As Long
   AddInkList = pdfAddInkList(m_Instance, InkAnnot, VarPtr(points(0)), UBound(points) + 1)
End Function

Friend Function AddJavaScript(ByVal Name As String, ByVal Script As String) As Long
   AddJavaScript = pdfAddJavaScriptW(m_Instance, Name, StrPtr(Script))
End Function

Friend Function AddJavaScriptA(ByVal Name As String, ByVal Script As String) As Long
   AddJavaScriptA = pdfAddJavaScriptA(m_Instance, Name, Script)
End Function

Friend Function AddJavaScriptW(ByVal Name As String, ByVal Script As String) As Long
   AddJavaScriptW = pdfAddJavaScriptW(m_Instance, Name, StrPtr(Script))
End Function

Friend Function AddLayerToDisplTree(ByVal Parent As Long, ByVal Layer As Long, ByVal Title As String) As Long
   AddLayerToDisplTree = pdfAddLayerToDisplTreeW(m_Instance, Parent, Layer, StrPtr(Title))
End Function

Friend Function AddLayerToDisplTreeA(ByVal Parent As Long, ByVal Layer As Long, ByVal Title As String) As Long
   AddLayerToDisplTreeA = pdfAddLayerToDisplTreeA(m_Instance, Parent, Layer, Title)
End Function

Friend Function AddLayerToDisplTreeW(ByVal Parent As Long, ByVal Layer As Long, ByVal Title As String) As Long
   AddLayerToDisplTreeW = pdfAddLayerToDisplTreeW(m_Instance, Parent, Layer, StrPtr(Title))
End Function

Friend Function AddMaskImage(ByVal BaseImage As Long, ByRef Buffer() As Byte, ByVal Stride As Long, ByVal BitsPerPixel As Long, ByVal Width As Long, ByVal Height As Long) As Boolean
   AddMaskImage = pdfAddMaskImage(m_Instance, BaseImage, Buffer(0), UBound(Buffer) + 1, Stride, BitsPerPixel, Width, Height) <> 0
End Function

Friend Function AddObjectToLayer(ByVal OCG As Long, ByVal ObjType As TOCObject, ByVal Handle As Long) As Boolean
   AddObjectToLayer = pdfAddObjectToLayer(m_Instance, OCG, ObjType, Handle) <> 0
End Function

Friend Function AddOCGToAppEvent(ByVal Handle As Long, ByVal Events As TOCAppEvent, ByVal Categories As TOCGUsageCategory) As Boolean
   AddOCGToAppEvent = pdfAddOCGToAppEvent(m_Instance, Handle, Events, Categories) <> 0
End Function

Friend Function AddOutputIntent(ByVal ICCFile As String) As Long
   AddOutputIntent = pdfAddOutputIntentW(m_Instance, StrPtr(ICCFile))
End Function

Friend Function AddOutputIntentA(ByVal ICCFile As String) As Long
   AddOutputIntentA = pdfAddOutputIntentA(m_Instance, ICCFile)
End Function

Friend Function AddOutputIntentW(ByVal ICCFile As String) As Long
   AddOutputIntentW = pdfAddOutputIntentW(m_Instance, StrPtr(ICCFile))
End Function

Friend Function AddOutputIntentEx(ByRef Buffer() As Byte) As Long
   AddOutputIntentEx = pdfAddOutputIntentEx(m_Instance, Buffer(0), UBound(Buffer) + 1)
End Function

Friend Function AddPageLabel(ByVal StartRange As Long, ByVal Format As TPageLabelFormat, ByVal Prefix As String, ByVal AddNum As Long) As Long
   AddPageLabel = pdfAddPageLabelW(m_Instance, StartRange, Format, StrPtr(Prefix), AddNum)
End Function

Friend Function AddPageLabelA(ByVal StartRange As Long, ByVal Format As TPageLabelFormat, ByVal Prefix As String, ByVal AddNum As Long) As Long
   AddPageLabelA = pdfAddPageLabelA(m_Instance, StartRange, Format, Prefix, AddNum)
End Function

Friend Function AddPageLabelW(ByVal StartRange As Long, ByVal Format As TPageLabelFormat, ByVal Prefix As String, ByVal AddNum As Long) As Long
   AddPageLabelW = pdfAddPageLabelW(m_Instance, StartRange, Format, StrPtr(Prefix), AddNum)
End Function

Friend Function AddRasImage(ByVal RasPtr As Long, ByVal Filter As TCompressionFilter) As Boolean
   AddRasImage = pdfAddRasImage(m_Instance, RasPtr, Filter) <> 0
End Function

Friend Function AddValToChoiceField(ByVal Field As Long, ByVal ExpValue As String, ByVal Value As String, ByVal Selected As Boolean) As Boolean
   AddValToChoiceField = pdfAddValToChoiceFieldW(m_Instance, Field, ExpValue, StrPtr(Value), Selected) <> 0
End Function

Friend Function AddValToChoiceFieldA(ByVal Field As Long, ByVal ExpValue As String, ByVal Value As String, ByVal Selected As Boolean) As Boolean
   AddValToChoiceFieldA = pdfAddValToChoiceFieldA(m_Instance, Field, ExpValue, Value, Selected) <> 0
End Function

Friend Function AddValToChoiceFieldW(ByVal Field As Long, ByVal ExpValue As String, ByVal Value As String, ByVal Selected As Boolean) As Boolean
   AddValToChoiceFieldW = pdfAddValToChoiceFieldW(m_Instance, Field, ExpValue, StrPtr(Value), Selected) <> 0
End Function

Friend Function Append() As Boolean
   Append = pdfAppend(m_Instance) <> 0
End Function

Friend Function ApplyAppEvent(ByVal AppEvent As TOCAppEvent, ByVal SaveResult As Long) As Boolean
   ApplyAppEvent = pdfApplyAppEvent(m_Instance, AppEvent, SaveResult) <> 0
End Function

Friend Function ApplyPattern(ByVal PattHandle As Long, ByVal ColorMode As TColorMode, ByVal Color As Long) As Boolean
   ApplyPattern = pdfApplyPattern(m_Instance, PattHandle, ColorMode, Color) <> 0
End Function

Friend Function ApplyShading(ByVal ShadHandle As Long) As Boolean
   ApplyShading = pdfApplyShading(m_Instance, ShadHandle) <> 0
End Function

Friend Function AssociateEmbFile(ByVal DestObject As TAFDestObject, ByVal DestHandle As Long, ByVal Relationship As TAFRelationship, ByVal EmbFile As Long) As Boolean
   AssociateEmbFile = pdfAssociateEmbFile(m_Instance, DestObject, DestHandle, Relationship, EmbFile) <> 0
End Function

Friend Function AttachFile(ByVal FilePath As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFile = pdfAttachFileW(m_Instance, StrPtr(FilePath), StrPtr(Description), Compress)
End Function

Friend Function AttachFileA(ByVal FilePath As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFileA = pdfAttachFileA(m_Instance, FilePath, Description, Compress)
End Function

Friend Function AttachFileW(ByVal FilePath As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFileW = pdfAttachFileW(m_Instance, StrPtr(FilePath), StrPtr(Description), Compress)
End Function

Friend Function AttachFileEx(ByRef Buffer() As Byte, ByVal FileName As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFileEx = pdfAttachFileExW(m_Instance, Buffer(0), UBound(Buffer) + 1, StrPtr(FileName), StrPtr(Description), Compress)
End Function

Friend Function AttachFileExA(ByRef Buffer() As Byte, ByVal FileName As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFileExA = pdfAttachFileExA(m_Instance, Buffer(0), UBound(Buffer) + 1, FileName, Description, Compress)
End Function

Friend Function AttachFileExW(ByRef Buffer() As Byte, ByVal FileName As String, ByVal Description As String, ByVal Compress As Boolean) As Long
   AttachFileExW = pdfAttachFileExW(m_Instance, Buffer(0), UBound(Buffer) + 1, StrPtr(FileName), StrPtr(Description), Compress)
End Function

Friend Function AttachImageBuffer(ByVal RasPtr As Long, ByVal Rows As Long, ByVal Buffer As Long, ByVal Width As Long, ByVal Height As Long, ByVal ScanlineLen As Long) As Boolean
   AttachImageBuffer = rasAttachImageBuffer(RasPtr, Rows, Buffer, Width, Height, ScanlineLen) <> 0
End Function

Friend Function AutoTemplate(ByVal Templ As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   AutoTemplate = pdfAutoTemplate(m_Instance, Templ, PosX, PosY, Width, Height) <> 0
End Function

Friend Function BeginClipPath() As Boolean
   BeginClipPath = True ' Obsolete function! Nothing to do.
End Function

Friend Function BeginContinueText(ByVal PosX As Double, ByVal PosY As Double) As Boolean
   BeginContinueText = pdfBeginContinueText(m_Instance, PosX, PosY) <> 0
End Function

Friend Function BeginLayer(ByVal OCG As Long) As Boolean
   BeginLayer = pdfBeginLayer(m_Instance, OCG) <> 0
End Function

Friend Function BeginPageTemplate(ByVal Name As String, ByVal UseAutoTemplates As Boolean) As Boolean
   BeginPageTemplate = pdfBeginPageTemplate(m_Instance, Name, UseAutoTemplates) <> 0
End Function

Friend Function BeginPattern(ByVal PatternType As TPatternType, ByVal TilingType As TTilingType, ByVal Width As Double, ByVal Height As Double) As Long
   BeginPattern = pdfBeginPattern(m_Instance, PatternType, TilingType, Width, Height)
End Function

Friend Function BeginTemplate(ByVal Width As Double, ByVal Height As Double) As Long
   BeginTemplate = pdfBeginTemplate(m_Instance, Width, Height)
End Function

Friend Function BeginTransparencyGroup(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal Isolated As Integer, ByVal Knockout As Integer, ByVal CS As TExtColorSpace, ByVal CSHandle As Long) As Long
   BeginTransparencyGroup = pdfBeginTransparencyGroup(m_Instance, x1, y1, x2, y2, Isolated, Knockout, CS, CSHandle)
End Function

Friend Function Bezier_1_2_3(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double) As Boolean
   Bezier_1_2_3 = pdfBezier_1_2_3(m_Instance, x1, y1, x2, y2, x3, y3) <> 0
End Function

Friend Function Bezier_1_3(ByVal x1 As Double, ByVal y1 As Double, ByVal x3 As Double, ByVal y3 As Double) As Boolean
   Bezier_1_3 = pdfBezier_1_3(m_Instance, x1, y1, x3, y3) <> 0
End Function

Friend Function Bezier_2_3(ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double) As Boolean
   Bezier_2_3 = pdfBezier_2_3(m_Instance, x2, y2, x3, y3) <> 0
End Function

Friend Sub CalcPagePixelSize(ByVal PagePtr As Long, ByVal DefScale As TPDFPageScale, ByVal ScaleFactor As Single, ByVal FrameWidth As Long, ByVal FrameHeight As Long, ByVal Flags As TRasterFlags, ByRef Width As Long, ByRef Height As Long)
   Call rasCalcPagePixelSize(PagePtr, DefScale, ScaleFactor, FrameWidth, FrameHeight, Flags, Width, Height)
End Sub

Friend Function CalcWidthHeight(ByVal OrgWidth As Double, ByVal OrgHeight As Double, ByVal ScaledWidth As Double, ByVal ScaledHeight As Double) As Double
   CalcWidthHeight = pdfCalcWidthHeight(m_Instance, OrgWidth, OrgHeight, ScaledWidth, ScaledHeight)
End Function

Friend Function CaretAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   CaretAnnot = pdfCaretAnnotW(m_Instance, PosX, PosY, Width, Height, Color, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function CaretAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   CaretAnnotA = pdfCaretAnnotA(m_Instance, PosX, PosY, Width, Height, Color, CS, Author, Subject, Content)
End Function

Friend Function CaretAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   CaretAnnotW = pdfCaretAnnotW(m_Instance, PosX, PosY, Width, Height, Color, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function ChangeAnnotName(ByVal Handle As Long, ByVal Name As String) As Boolean
   ChangeAnnotName = pdfChangeAnnotNameW(m_Instance, Handle, StrPtr(Name)) <> 0
End Function

Friend Function ChangeAnnotNameA(ByVal Handle As Long, ByVal Name As String) As Boolean
   ChangeAnnotNameA = pdfChangeAnnotNameA(m_Instance, Handle, Name) <> 0
End Function

Friend Function ChangeAnnotNameW(ByVal Handle As Long, ByVal Name As String) As Boolean
   ChangeAnnotNameW = pdfChangeAnnotNameW(m_Instance, Handle, StrPtr(Name)) <> 0
End Function

Friend Function ChangeAnnotPos(ByVal Handle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   ChangeAnnotPos = pdfChangeAnnotPos(m_Instance, Handle, PosX, PosY, Width, Height) <> 0
End Function

Friend Function ChangeBookmark(ByVal ABmk As Long, ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Boolean
   ChangeBookmark = pdfChangeBookmarkW(m_Instance, ABmk, StrPtr(Title), Parent, DestPage, DoOpen) <> 0
End Function

Friend Function ChangeBookmarkA(ByVal ABmk As Long, ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Boolean
   ChangeBookmarkA = pdfChangeBookmarkA(m_Instance, ABmk, Title, Parent, DestPage, DoOpen) <> 0
End Function

Friend Function ChangeBookmarkW(ByVal ABmk As Long, ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean) As Boolean
   ChangeBookmarkW = pdfChangeBookmarkW(m_Instance, ABmk, StrPtr(Title), Parent, DestPage, DoOpen) <> 0
End Function

Friend Function ChangeFont(ByVal Handle As Long) As Boolean
   ChangeFont = pdfChangeFont(m_Instance, Handle) <> 0
End Function

Friend Function ChangeFontEx(ByVal Handle As Long, ByVal FontSize As Double, ByVal Style As TFStyle) As Boolean
   ChangeFontEx = pdfChangeFontEx(m_Instance, Handle, FontSize, Style) <> 0
End Function

Friend Function ChangeFontSize(ByVal Size As Double) As Boolean
   ChangeFontSize = pdfChangeFontSize(m_Instance, Size) <> 0
End Function

Friend Function ChangeFontStyle(ByVal Style As TFStyle) As Boolean
   ChangeFontStyle = pdfChangeFontStyle(m_Instance, Style) <> 0
End Function

Friend Function ChangeFontStyleEx(ByVal Style As TFStyle) As Boolean
   ChangeFontStyleEx = pdfChangeFontStyleEx(m_Instance, Style) <> 0
End Function

Friend Function ChangeJavaScript(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScript = pdfChangeJavaScriptW(m_Instance, Handle, StrPtr(NewScript)) <> 0
End Function

Friend Function ChangeJavaScriptA(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScriptA = pdfChangeJavaScriptA(m_Instance, Handle, NewScript) <> 0
End Function

Friend Function ChangeJavaScriptW(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScriptW = pdfChangeJavaScriptW(m_Instance, Handle, StrPtr(NewScript)) <> 0
End Function

Friend Function ChangeJavaScriptAction(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScriptAction = pdfChangeJavaScriptActionW(m_Instance, Handle, StrPtr(NewScript)) <> 0
End Function

Friend Function ChangeJavaScriptActionA(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScriptActionA = pdfChangeJavaScriptActionA(m_Instance, Handle, NewScript) <> 0
End Function

Friend Function ChangeJavaScriptActionW(ByVal Handle As Long, ByVal NewScript As String) As Boolean
   ChangeJavaScriptActionW = pdfChangeJavaScriptActionW(m_Instance, Handle, StrPtr(NewScript)) <> 0
End Function

Friend Function ChangeJavaScriptName(ByVal Handle As Long, ByVal Name As String) As Long
   ChangeJavaScriptName = pdfChangeJavaScriptNameW(m_Instance, Handle, StrPtr(Name))
End Function

Friend Function ChangeJavaScriptNameA(ByVal Handle As Long, ByVal Name As String) As Long
   ChangeJavaScriptNameA = pdfChangeJavaScriptNameA(m_Instance, Handle, Name)
End Function

Friend Function ChangeJavaScriptNameW(ByVal Handle As Long, ByVal Name As String) As Long
   ChangeJavaScriptNameW = pdfChangeJavaScriptNameW(m_Instance, Handle, StrPtr(Name))
End Function

Friend Function ChangeLinkAnnot(ByVal Handle As Long, ByVal URL As String) As Boolean
    ChangeLinkAnnot = pdfChangeLinkAnnot(m_Instance, Handle, URL) <> 0
End Function

Friend Function ChangeNamedDest(ByVal ObjType As TObjType, ByVal Handle As Long, ByVal NewDestName As String) As Boolean
   ChangeNamedDest = pdfChangeNamedDestW(m_Instance, ObjType, Handle, StrPtr(NewDestName)) <> 0
End Function

Friend Function ChangeOCGName(ByVal Handle As Long, ByVal Value As String) As Boolean
   ChangeOCGName = pdfChangeOCGNameW(m_Instance, Handle, StrPtr(Value))
End Function

Friend Function ChangeSeparationColor(ByVal CSHandle As Long, ByVal NewColor As Long, ByVal Alternate As TExtColorSpace, ByVal AltHandle As Long) As Boolean
   ChangeSeparationColor = pdfChangeSeparationColor(m_Instance, CSHandle, NewColor, Alternate, AltHandle) <> 0
End Function

Friend Function CheckCollection() As Boolean
   CheckCollection = pdfCheckCollection(m_Instance) <> 0
End Function

Friend Function CheckConformance(ByVal ConfType As TConformanceType, ByVal Options As TCheckOptions, ByVal UserData As Long, ByVal OnFontNotFoundProc As Long, ByVal OnReplaceICCProfile As Long) As Long
   CheckConformance = pdfCheckConformance(m_Instance, ConfType, Options, UserData, OnFontNotFoundProc, OnReplaceICCProfile)
End Function

Friend Function CheckFieldNames() As Long
   CheckFieldNames = pdfCheckFieldNames(m_Instance)
End Function

Friend Function CircleAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   CircleAnnot = pdfCircleAnnotW(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function CircleAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   CircleAnnotA = pdfCircleAnnotA(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, Author, Subject, Comment)
End Function

Friend Function CircleAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   CircleAnnotW = pdfCircleAnnotW(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function ClearAutoTemplates() As Boolean
   ClearAutoTemplates = pdfClearAutoTemplates(m_Instance) <> 0
End Function

Friend Sub ClearErrorLog()
   Call pdfClearErrorLog(m_Instance)
End Sub

Friend Function ClearHostFonts() As Boolean
   ClearHostFonts = pdfClearHostFonts(m_Instance) <> 0
End Function

Friend Function ClipPath(ByVal ClipMode As TClippingMode, ByVal FillMode As TPathFillMode) As Boolean
   ClipPath = pdfClipPath(m_Instance, ClipMode, FillMode) <> 0
End Function

Friend Function CloseAndSignFile(ByVal CertFile As String, ByVal Password As String, ByVal Reason As String, ByVal Location As String) As Boolean
   CloseAndSignFile = pdfCloseAndSignFile(m_Instance, CertFile, Password, Reason, Location) <> 0
End Function

Friend Function CloseAndSignFileEx(ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions, ByVal CertFile As String, ByVal Password As String, ByVal Reason As String, ByVal Location As String) As Boolean
   CloseAndSignFileEx = pdfCloseAndSignFileEx(m_Instance, OpenPwd, OwnerPwd, KeyLen, Restrict, CertFile, Password, Reason, Location) <> 0
End Function

Friend Function CloseAndSignFileExt(ByRef SigParms As TPDFSigParms) As Boolean
   Dim p As TPDFSigParms_I
   p.StructSize = LenB(p)
   p.ContactInfoW = StrPtr(SigParms.ContactInfo)
   p.Encrypt = SigParms.Encrypt
   p.KeyLen = SigParms.KeyLen
   p.HashType = SigParms.HashType
   p.LocationW = StrPtr(SigParms.Location)
   p.OpenPwd = SigParms.OpenPwd
   p.OwnerPwd = SigParms.OwnerPwd
   p.PKCS7ObjLen = SigParms.PKCS7ObjLen
   p.ReasonW = StrPtr(SigParms.Reason)
   p.SignerW = StrPtr(SigParms.Signer)
   p.Restrict = SigParms.Restrict
   p.Certificate = SigParms.Certificate
   p.TimeStampServer = StrPtr(SigParms.TimeStampServer)
   p.TimeOut = SigParms.TimeOut

   If pdfCloseAndSignFileExt(m_Instance, p) = 0 Then Exit Function
   ReDim SigParms.Range1(p.Range1Len - 1)
   pdfCopyMem2 p.Range1, SigParms.Range1(0), p.Range1Len
   If p.Range2Len > 0 Then
      ReDim SigParms.Range2(p.Range2Len - 1)
      pdfCopyMem2 p.Range2, SigParms.Range2(0), p.Range2Len
   Else
      Erase SigParms.Range2
   End If
   CloseAndSignFileExt = True
End Function

Friend Function CloseFile() As Boolean
   CloseFile = pdfCloseFile(m_Instance) <> 0
End Function

Friend Function CloseFileEx(ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Boolean
   CloseFileEx = pdfCloseFileEx(m_Instance, OpenPwd, OwnerPwd, KeyLen, Restrict) <> 0
End Function

Friend Function CloseImage() As Boolean
   CloseImage = pdfCloseImage(m_Instance) <> 0
End Function

Friend Function CloseImportFile() As Boolean
   CloseImportFile = pdfCloseImportFile(m_Instance) <> 0
End Function

Friend Function CloseImportFileEx(ByVal Handle As Long) As Boolean
   CloseImportFileEx = pdfCloseImportFileEx(m_Instance, Handle) <> 0
End Function

Friend Function ClosePath(ByVal FillMode As TPathFillMode) As Boolean
   ClosePath = pdfClosePath(m_Instance, FillMode) <> 0
End Function

Friend Function CloseTag() As Boolean
   CloseTag = pdfCloseTag(m_Instance) <> 0
End Function

Friend Function CloseXFAStream(ByVal Index As Long) As Boolean
   CloseXFAStream = pdfGetXFAStream(m_Instance, Index, 0) <> 0
End Function

Friend Function CMYK(C As Byte, m As Byte, Y As Byte, K As Byte) As Long
   If C >= &H80 Then
      CMYK = K Or (Y * &H100&) Or (m * &H10000) Or ((C And &H7F) * &H1000000) Or &H80000000
   Else
      CMYK = K Or (Y * &H100&) Or (m * &H10000) Or (C * &H1000000)
   End If
End Function

Friend Function ComputeBBox(ByRef BBox As TPDFRect, ByVal Flags As TCompBBoxFlags) As Boolean
   ComputeBBox = pdfComputeBBox(m_Instance, BBox, Flags) <> 0
End Function

Friend Sub ConnectPageBreakEvent(ByVal Connect As Boolean)
   If Connect Then
      pdfSetOnPageBreakProc m_Instance, ObjPtr(Me), AddressOf pdf_OnPageBreakProc
   Else
      pdfSetOnPageBreakProc m_Instance, 0&, 0&
   End If
End Sub

Friend Function ConvertColors(ByVal Flags As TColorConvFlags, Optional ByVal Add As Single = 0#) As Boolean
   ConvertColors = pdfConvertColors(m_Instance, Flags, VarPtr(Add)) <> 0
End Function

Friend Function ConvertEMFSpool(ByVal SpoolFile As String, ByVal LeftMargin As Double, ByVal TopMargin As Double, ByVal Flags As TSpoolConvFlags) As Long
   ConvertEMFSpool = pdfConvertEMFSpoolW(m_Instance, StrPtr(SpoolFile), LeftMargin, TopMargin, Flags)
End Function

Friend Function ConvertEMFSpoolA(ByVal SpoolFile As String, ByVal LeftMargin As Double, ByVal TopMargin As Double, ByVal Flags As TSpoolConvFlags) As Long
   ConvertEMFSpoolA = pdfConvertEMFSpoolA(m_Instance, SpoolFile, LeftMargin, TopMargin, Flags)
End Function

Friend Function ConvertEMFSpoolW(ByVal SpoolFile As String, ByVal LeftMargin As Double, ByVal TopMargin As Double, ByVal Flags As TSpoolConvFlags) As Long
   ConvertEMFSpoolW = pdfConvertEMFSpoolW(m_Instance, StrPtr(SpoolFile), LeftMargin, TopMargin, Flags)
End Function

Friend Function ConvToFreeTextCallout(ByVal Handle As Long, ByVal StartX As Single, ByVal StartY As Single, ByVal KneeOffset As Single, ByVal EndStyle As TLineEndStyle) As Boolean
   ConvToFreeTextCallout = pdfConvToFreeTextCallout(m_Instance, Handle, StartX, StartY, KneeOffset, EndStyle) <> 0
End Function

Friend Function ConvToUnicode(ByVal AString As String, ByVal CP As TCodepage) As String
   Dim ptr As Long
   ptr = pdfConvToUnicode(m_Instance, AString, CP)
   ConvToUnicode = ToStringW(ptr)
End Function

Friend Function CopyChoiceValues(ByVal Source As Long, ByVal Dest As Long, ByVal Share As Boolean) As Boolean
   CopyChoiceValues = pdfCopyChoiceValues(m_Instance, Source, Dest, Share) <> 0
End Function

Friend Function Create3DAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Name As String, ByVal U3DFile As String, ByVal Image As String) As Long
   Create3DAnnot = pdfCreate3DAnnot(m_Instance, PosX, PosY, Width, Height, Author, Name, U3DFile, Image)
End Function

Friend Function Create3DAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Name As String, ByVal U3DFile As String, ByVal Image As String) As Long
   Create3DAnnotA = pdfCreate3DAnnot(m_Instance, PosX, PosY, Width, Height, Author, Name, U3DFile, Image)
End Function

Friend Function Create3DAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Name As String, ByVal U3DFile As String, ByVal Image As String) As Long
   Create3DAnnotW = pdfCreate3DAnnot(m_Instance, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(Name), StrPtr(U3DFile), StrPtr(Image))
End Function

Friend Function Create3DBackground(ByVal IView As Long, ByVal BackColor As Long) As Boolean
   Create3DBackground = pdfCreate3DBackground(m_Instance, IView, BackColor) <> 0
End Function

Friend Function Create3DGotoViewAction(ByVal Base3DAnnot As Long, ByVal IView As Long, ByVal Named As T3DNamedAction) As Long
   Create3DGotoViewAction = pdfCreate3DGotoViewAction(m_Instance, Base3DAnnot, IView, Named)
End Function

Friend Function Create3DProjection(ByVal IView As Long, ByVal ProjType As T3DProjType, ByVal ScaleType As T3DScaleType, ByVal Diameter As Double, ByVal FOV As Double) As Boolean
   Create3DProjection = pdfCreate3DProjection(m_Instance, IView, ProjType, ScaleType, Diameter, FOV) <> 0
End Function

Friend Function Create3DView(ByVal Base3DAnnot As Long, ByVal Name As String, ByVal SetAsDefault As Boolean, ByRef Matrix() As Double, ByVal CamDistance As Double, ByVal RM As T3DRenderingMode, ByVal LS As T3DLightingSheme) As Long
   On Error GoTo errf
   If UBound(Matrix) < 11 Then
      Create3DView = pdfCreate3DViewW(m_Instance, Base3DAnnot, StrPtr(Name), SetAsDefault, ByVal 0&, CamDistance, RM, LS)
   Else
      Create3DView = pdfCreate3DViewW(m_Instance, Base3DAnnot, StrPtr(Name), SetAsDefault, Matrix(0), CamDistance, RM, LS)
   End If
   Exit Function
errf:
   Create3DView = pdfCreate3DViewW(m_Instance, Base3DAnnot, StrPtr(Name), SetAsDefault, ByVal 0&, CamDistance, RM, LS)
   Resume Next
End Function

Friend Function CreateAltFontList() As Long
   CreateAltFontList = pdfCreateAltFontList(m_Instance)
End Function

Friend Function CreateAnnotAP(ByVal Annot As Long) As Long
   CreateAnnotAP = pdfCreateAnnotAP(m_Instance, Annot)
End Function

Friend Function CreateArticleThread(ByVal ThreadName As String) As Long
   CreateArticleThread = pdfCreateArticleThreadW(m_Instance, StrPtr(ThreadName))
End Function

Friend Function CreateArticleThreadA(ByVal ThreadName As String) As Long
   CreateArticleThreadA = pdfCreateArticleThreadA(m_Instance, ThreadName)
End Function

Friend Function CreateArticleThreadW(ByVal ThreadName As String) As Long
   CreateArticleThreadW = pdfCreateArticleThreadW(m_Instance, StrPtr(ThreadName))
End Function

Friend Function CreateAxialShading(ByVal sx As Double, ByVal sy As Double, ByVal eX As Double, ByVal eY As Double, ByVal SCenter As Double, ByVal SColor As Long, ByVal EColor As Long, ByVal Extend1 As Long, ByVal Extend2 As Long) As Long
   CreateAxialShading = pdfCreateAxialShading(m_Instance, sx, sy, eX, eY, SCenter, SColor, EColor, Extend1, Extend2)
End Function

Friend Function CreateBarcodeField(ByVal Name As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByRef Barcode As TPDFBarcode) As Long
   Dim s As String
   Dim bc As TPDFBarcode_I
   s = StrConv(Barcode.Symbology, vbFromUnicode, 0)
   bc.StructSize = LenB(bc)
   bc.CaptionW = StrPtr(Barcode.Caption)
   bc.ECC = Barcode.ECC
   bc.Height = Barcode.Height
   bc.nCodeWordCol = Barcode.nCodeWordCol
   bc.nCodeWordRow = Barcode.nCodeWordRow
   bc.Resolution = Barcode.Resolution
   bc.Symbology = StrPtr(s)
   bc.Version = Barcode.Version
   bc.Width = Barcode.Width
   bc.XSymHeight = Barcode.XSymHeight
   bc.XSymWidth = Barcode.XSymWidth
   CreateBarcodeField = pdfCreateBarcodeField(m_Instance, Name, Parent, PosX, PosY, Width, Height, bc)
End Function

Friend Function CreateButton(ByVal Name As String, ByVal Caption As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateButton = pdfCreateButtonW(m_Instance, Name, StrPtr(Caption), Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateButtonA(ByVal Name As String, ByVal Caption As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateButtonA = pdfCreateButtonA(m_Instance, Name, Caption, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateButtonW(ByVal Name As String, ByVal Caption As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateButtonW = pdfCreateButtonW(m_Instance, Name, StrPtr(Caption), Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateCheckBox(ByVal Name As String, ByVal ExpValue As String, ByVal Checked As Boolean, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateCheckBox = pdfCreateCheckBox(m_Instance, Name, ExpValue, Checked, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateCIEColorSpace(ByVal Base As TExtColorSpace, ByRef WhitePoint() As Single, ByRef BlackPoint() As Single, ByRef Gamma() As Single, ByRef Matrix() As Single) As Long
   CreateCIEColorSpace = pdfCreateCIEColorSpace(m_Instance, Base, VarPtr(WhitePoint(0)), VarPtr(BlackPoint(0)), VarPtr(Gamma(0)), VarPtr(Matrix(0)))
End Function

Friend Function CreateCollection(ByVal View As TColView) As Boolean
   CreateCollection = pdfCreateCollection(m_Instance, View) <> 0
End Function

Friend Function CreateCollectionField(ByVal ColType As TColColumnType, ByVal Column As Long, ByVal Name As String, ByVal Key As String, ByVal Visible As Boolean, ByVal Editable As Boolean) As Long
   CreateCollectionField = pdfCreateCollectionFieldW(m_Instance, ColType, Column, StrPtr(Name), Key, Visible, Editable)
End Function

Friend Function CreateCollectionFieldA(ByVal ColType As TColColumnType, ByVal Column As Long, ByVal Name As String, ByVal Key As String, ByVal Visible As Boolean, ByVal Editable As Boolean) As Long
   CreateCollectionFieldA = pdfCreateCollectionFieldA(m_Instance, ColType, Column, Name, Key, Visible, Editable)
End Function

Friend Function CreateCollectionFieldW(ByVal ColType As TColColumnType, ByVal Column As Long, ByVal Name As String, ByVal Key As String, ByVal Visible As Boolean, ByVal Editable As Boolean) As Long
   CreateCollectionFieldW = pdfCreateCollectionFieldW(m_Instance, ColType, Column, StrPtr(Name), Key, Visible, Editable)
End Function

Friend Function CreateColItemDate(ByVal EmbFile As Long, ByVal Key As String, ByVal DateVal As Long, ByVal Prefix As String) As Boolean
   CreateColItemDate = pdfCreateColItemDate(m_Instance, EmbFile, Key, DateVal, Prefix) <> 0
End Function

Friend Function CreateColItemNumber(ByVal EmbFile As Long, ByVal Key As String, ByVal Value As Double, ByVal Prefix As String) As Boolean
   CreateColItemNumber = pdfCreateColItemNumber(m_Instance, EmbFile, Key, Value, Prefix) <> 0
End Function

Friend Function CreateColItemString(ByVal EmbFile As Long, ByVal Key As String, ByVal Value As String, ByVal Prefix As String) As Boolean
   CreateColItemString = pdfCreateColItemStringW(m_Instance, EmbFile, Key, StrPtr(Value), StrPtr(Prefix)) <> 0
End Function

Friend Function CreateColItemStringA(ByVal EmbFile As Long, ByVal Key As String, ByVal Value As String, ByVal Prefix As String) As Boolean
   CreateColItemStringA = pdfCreateColItemStringA(m_Instance, EmbFile, Key, Value, Prefix) <> 0
End Function

Friend Function CreateColItemStringW(ByVal EmbFile As Long, ByVal Key As String, ByVal Value As String, ByVal Prefix As String) As Boolean
   CreateColItemStringW = pdfCreateColItemStringW(m_Instance, EmbFile, Key, StrPtr(Value), StrPtr(Prefix)) <> 0
End Function

Friend Function CreateComboBox(ByVal Name As String, ByVal Sort As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateComboBox = pdfCreateComboBox(m_Instance, Name, Sort, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateDeviceNColorSpace(ByRef Colorants() As String, ByVal PostScriptFunc As String, ByVal Alternate As TExtColorSpace, ByVal Handle As Long) As Long
   Dim i As Long
   Dim C() As String
   ReDim C(UBound(Colorants))
   For i = 0 To UBound(Colorants)
      C(i) = StrConv(Colorants(i), vbFromUnicode, 0)
   Next i
   CreateDeviceNColorSpace = pdfCreateDeviceNColorSpace(m_Instance, VarPtr(C(0)), UBound(Colorants) + 1, PostScriptFunc, Alternate, Handle)
   Erase C
End Function

Friend Function CreateDPartRoot(ByRef NodeNameList() As String, ByVal RecordLevel As Long) As Boolean
   Dim i As Long
   Dim names() As String
   ReDim names(UBound(NodeNameList))
   For i = 0 To UBound(NodeNameList)
      names(i) = StrConv(NodeNameList(i), vbFromUnicode, 0)
   Next i
   CreateDPartRoot = pdfCreateDPartRoot(m_Instance, VarPtr(names(0)), UBound(NodeNameList) + 1, RecordLevel) <> 0
   Erase names
End Function

Friend Function CreateExtGState(ByRef GS As TPDFExtGState) As Long
   CreateExtGState = pdfCreateExtGState(m_Instance, GS)
End Function

Friend Function CreateGeospatialMeasure(ByVal Viewport As Long, ByVal Attributes As String) As Long
   CreateGeospatialMeasure = pdfCreateGeospatialMeasure(m_Instance, Viewport, Attributes)
End Function

Friend Function CreateGoToAction(ByVal DestType As TDestType, ByVal PageNum As Long, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
   CreateGoToAction = pdfCreateGoToAction(m_Instance, DestType, PageNum, a, b, C, d)
End Function

Friend Function CreateGoToActionEx(ByVal NamedDest As Long) As Long
   CreateGoToActionEx = pdfCreateGoToActionEx(m_Instance, NamedDest)
End Function

Friend Function CreateGoToEAction(ByVal Location As TEmbFileLocation, ByVal Source As String, ByVal SrcPage As Long, ByVal Target As String, ByVal DestName As String, ByVal DestPage As Long, ByVal NewWindow As Boolean) As Long
   CreateGoToEAction = pdfCreateGoToEActionW(m_Instance, Location, StrPtr(Source), SrcPage, StrPtr(Target), StrPtr(DestName), DestPage, NewWindow)
End Function

Friend Function CreateGoToEActionA(ByVal Location As TEmbFileLocation, ByVal Source As String, ByVal SrcPage As Long, ByVal Target As String, ByVal DestName As String, ByVal DestPage As Long, ByVal NewWindow As Boolean) As Long
   CreateGoToEActionA = pdfCreateGoToEActionA(m_Instance, Location, Source, SrcPage, Target, DestName, DestPage, NewWindow)
End Function

Friend Function CreateGoToEActionW(ByVal Location As TEmbFileLocation, ByVal Source As String, ByVal SrcPage As Long, ByVal Target As String, ByVal DestName As String, ByVal DestPage As Long, ByVal NewWindow As Boolean) As Long
   CreateGoToEActionW = pdfCreateGoToEActionW(m_Instance, Location, StrPtr(Source), SrcPage, StrPtr(Target), StrPtr(DestName), DestPage, NewWindow)
End Function

Friend Function CreateGoToRAction(ByVal FileName As String, ByVal PageNum As Long) As Long
   CreateGoToRAction = pdfCreateGoToRActionW(m_Instance, FileName, PageNum)
End Function

Friend Function CreateGoToRActionW(ByVal FileName As String, ByVal PageNum As Long) As Long
   CreateGoToRActionW = pdfCreateGoToRActionW(m_Instance, StrPtr(FileName), PageNum)
End Function

Friend Function CreateGoToRActionEx(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionEx = pdfCreateGoToRActionExW(m_Instance, FileName, StrPtr(DestName), NewWindow)
End Function

Friend Function CreateGoToRActionExA(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionExA = pdfCreateGoToRActionExA(m_Instance, FileName, DestName, NewWindow)
End Function

Friend Function CreateGoToRActionExW(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionExW = pdfCreateGoToRActionExW(m_Instance, FileName, StrPtr(DestName), NewWindow)
End Function

Friend Function CreateGoToRActionExU(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionExU = pdfCreateGoToRActionExUW(m_Instance, StrPtr(FileName), StrPtr(DestName), NewWindow)
End Function

Friend Function CreateGoToRActionExUA(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionExUA = pdfCreateGoToRActionExUA(m_Instance, StrPtr(FileName), DestName, NewWindow)
End Function

Friend Function CreateGoToRActionExUW(ByVal FileName As String, ByVal DestName As String, ByVal NewWindow As Boolean) As Long
   CreateGoToRActionExUW = pdfCreateGoToRActionExUW(m_Instance, StrPtr(FileName), StrPtr(DestName), NewWindow)
End Function

Friend Function CreateGroupField(ByVal Name As String, ByVal Parent As Long) As Long
   CreateGroupField = pdfCreateGroupField(m_Instance, Name, Parent)
End Function

Friend Function CreateHideAction(ByVal Field As Long, ByVal Hide As Long) As Long
   CreateHideAction = pdfCreateHideAction(m_Instance, Field, Hide)
End Function

Friend Function CreateICCBasedColorSpace(ByVal ICCProfile As String) As Long
   CreateICCBasedColorSpace = pdfCreateICCBasedColorSpaceW(m_Instance, StrPtr(ICCProfile))
End Function

Friend Function CreateICCBasedColorSpaceA(ByVal ICCProfile As String) As Long
   CreateICCBasedColorSpaceA = pdfCreateICCBasedColorSpaceA(m_Instance, ICCProfile)
End Function

Friend Function CreateICCBasedColorSpaceW(ByVal ICCProfile As String) As Long
   CreateICCBasedColorSpaceW = pdfCreateICCBasedColorSpaceW(m_Instance, StrPtr(ICCProfile))
End Function

Friend Function CreateICCBasedColorSpaceEx(ByRef Buffer() As Byte) As Long
   CreateICCBasedColorSpaceEx = pdfCreateICCBasedColorSpaceEx(m_Instance, Buffer(0), UBound(Buffer) + 1)
End Function

Friend Function CreateImage(ByVal FileName As String, ByVal Format As TImageFormat) As Boolean
   CreateImage = pdfCreateImageW(m_Instance, StrPtr(FileName), Format) <> 0
End Function

Friend Function CreateImageA(ByVal FileName As String, ByVal Format As TImageFormat) As Boolean
   CreateImageA = pdfCreateImageA(m_Instance, FileName, Format) <> 0
End Function

Friend Function CreateImageW(ByVal FileName As String, ByVal Format As TImageFormat) As Boolean
   CreateImageW = pdfCreateImageW(m_Instance, StrPtr(FileName), Format) <> 0
End Function

Friend Function CreateImpDataAction(ByVal DataFile As String) As Long
   CreateImpDataAction = pdfCreateImpDataActionW(m_Instance, StrPtr(DataFile))
End Function

Friend Function CreateImpDataActionA(ByVal DataFile As String) As Long
   CreateImpDataActionA = pdfCreateImpDataActionA(m_Instance, DataFile)
End Function

Friend Function CreateImpDataActionW(ByVal DataFile As String) As Long
   CreateImpDataActionW = pdfCreateImpDataActionW(m_Instance, StrPtr(DataFile))
End Function

Friend Function CreateIndexedColorSpace(ByVal Base As TExtColorSpace, ByVal Handle As Long, ByRef ColorTable() As Byte, ByVal NumColors As Long) As Long
   CreateIndexedColorSpace = pdfCreateIndexedColorSpace(m_Instance, Base, Handle, ColorTable, NumColors)
End Function

Friend Function CreateJSAction(ByVal Script As String) As Long
   CreateJSAction = pdfCreateJSActionW(m_Instance, StrPtr(Script))
End Function

Friend Function CreateJSActionA(ByVal Script As String) As Long
   CreateJSActionA = pdfCreateJSActionA(m_Instance, Script)
End Function

Friend Function CreateJSActionW(ByVal Script As String) As Long
   CreateJSActionW = pdfCreateJSActionW(m_Instance, StrPtr(Script))
End Function

Friend Function CreateLaunchAction(ByVal OP As TFileOP, ByVal FileName As String, ByVal DefDir As String, ByVal Param As String, ByVal NewWindow As Long) As Long
   CreateLaunchAction = pdfCreateLaunchAction(m_Instance, OP, FileName, DefDir, Param, NewWindow)
End Function

Friend Function CreateLaunchActionEx(ByVal FileName As String, ByVal NewWindow As Boolean) As Long
   CreateLaunchActionEx = pdfCreateLaunchActionExW(m_Instance, StrPtr(FileName), NewWindow)
End Function

Friend Function CreateLaunchActionExA(ByVal FileName As String, ByVal NewWindow As Boolean) As Long
   CreateLaunchActionExA = pdfCreateLaunchActionExA(m_Instance, FileName, NewWindow)
End Function

Friend Function CreateLaunchActionExW(ByVal FileName As String, ByVal NewWindow As Boolean) As Long
   CreateLaunchActionExW = pdfCreateLaunchActionExW(m_Instance, StrPtr(FileName), NewWindow)
End Function

Friend Function CreateListBox(ByVal Name As String, ByVal Sort As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateListBox = pdfCreateListBox(m_Instance, Name, Sort, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateNamedAction(ByVal Action As TNamedAction) As Long
   CreateNamedAction = pdfCreateNamedAction(m_Instance, Action)
End Function

Friend Function CreateNamedDest(ByVal Name As String, ByVal DestPage As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
   CreateNamedDest = pdfCreateNamedDestW(m_Instance, StrPtr(Name), DestPage, DestType, a, b, C, d)
End Function

Friend Function CreateNamedDestA(ByVal Name As String, ByVal DestPage As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
   CreateNamedDestA = pdfCreateNamedDestA(m_Instance, Name, DestPage, DestType, a, b, C, d)
End Function

Friend Function CreateNamedDestW(ByVal Name As String, ByVal DestPage As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
   CreateNamedDestW = pdfCreateNamedDestW(m_Instance, StrPtr(Name), DestPage, DestType, a, b, C, d)
End Function

Friend Function CreateNewPDF(ByVal OutPDF As String) As Boolean
   CreateNewPDF = pdfCreateNewPDFW(m_Instance, StrPtr(OutPDF)) <> 0
End Function

Friend Function CreateNewPDFA(ByVal OutPDF As String) As Boolean
   CreateNewPDFA = pdfCreateNewPDFA(m_Instance, OutPDF) <> 0
End Function

Friend Function CreateNewPDFW(ByVal OutPDF As String) As Boolean
   CreateNewPDFW = pdfCreateNewPDFW(m_Instance, StrPtr(OutPDF)) <> 0
End Function

Friend Function CreateOCG(ByVal Name As String, ByVal DisplayInUI As Boolean, ByVal Visible As Boolean, ByVal Intent As TOCGIntent) As Long
   CreateOCG = pdfCreateOCGW(m_Instance, StrPtr(Name), DisplayInUI, Visible, Intent)
End Function

Friend Function CreateOCGA(ByVal Name As String, ByVal DisplayInUI As Boolean, ByVal Visible As Boolean, ByVal Intent As TOCGIntent) As Long
   CreateOCGA = pdfCreateOCGA(m_Instance, Name, DisplayInUI, Visible, Intent)
End Function

Friend Function CreateOCGW(ByVal Name As String, ByVal DisplayInUI As Boolean, ByVal Visible As Boolean, ByVal Intent As TOCGIntent) As Long
   CreateOCGW = pdfCreateOCGW(m_Instance, StrPtr(Name), DisplayInUI, Visible, Intent)
End Function

Friend Function CreateOCMD(ByVal Visibility As TOCVisibility, ByRef OCGs() As Long) As Long
   CreateOCMD = pdfCreateOCMD(m_Instance, Visibility, OCGs(0), UBound(OCGs) + 1)
End Function

Friend Function CreateRadialShading(ByVal sx As Double, ByVal sy As Double, ByVal R1 As Double, ByVal eX As Double, ByVal eY As Double, ByVal R2 As Double, ByVal SCenter As Double, ByVal SColor As Long, ByVal EColor As Long, ByVal Extend1 As Long, ByVal Extend2 As Long) As Long
   CreateRadialShading = pdfCreateRadialShading(m_Instance, sx, sy, R1, eX, eY, R2, SCenter, SColor, EColor, Extend1, Extend2)
End Function

Friend Function CreateRadioButton(ByVal Name As String, ByVal ExpValue As String, ByVal Checked As Long, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateRadioButton = pdfCreateRadioButton(m_Instance, Name, ExpValue, Checked, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateRasterizer(ByVal Rows As Long, ByVal Buffer As Long, ByVal Width As Long, ByVal Height As Long, ByVal ScanlineLen As Long, ByVal PixFmt As TPDFPixFormat) As Long
   CreateRasterizer = rasCreateRasterizer(m_Instance, Rows, Buffer, Width, Height, ScanlineLen, PixFmt)
End Function

Friend Function CreateRasterizerEx(ByVal DC As Long, ByVal Width As Long, ByVal Height As Long, ByVal PixFmt As TPDFPixFormat) As Long
   CreateRasterizerEx = rasCreateRasterizerEx(m_Instance, DC, Width, Height, PixFmt)
End Function

Friend Function CreateRectilinearMeasure(ByVal Viewport As Long, ByVal UnitScale As Double, ByVal UnitDescription As String, ByVal LabelDistance As String, ByVal LabelArea As String) As Long
   CreateRectilinearMeasure = pdfCreateRectilinearMeasureW(m_Instance, Viewport, UnitScale, StrPtr(UnitDescription), StrPtr(LabelDistance), StrPtr(LabelArea))
End Function

Friend Function CreateResetAction() As Long
   CreateResetAction = pdfCreateResetAction(m_Instance)
End Function

Friend Function CreateSeparationCS(ByVal Colorant As String, ByVal Alternate As TExtColorSpace, ByVal Handle As Long, ByVal Color As Long) As Long
   CreateSeparationCS = pdfCreateSeparationCS(m_Instance, Colorant, Alternate, Handle, Color)
End Function

Friend Function CreateSetOCGStateAction(ByRef On_() As Long, ByRef Off() As Long, ByRef Toggle() As Long, ByVal PreserveRB As Boolean) As Long
   ' An empty array must be a non initialized variable, e.g. Dim n() as Long.
   On Error Resume Next
   Dim numOn As Long
   Dim onPtr As Long
   Dim numOff As Long
   Dim offPtr As Long
   Dim numToggle As Long
   Dim togglePtr As Long

   numOn = UBound(On_) + 1
   onPtr = VarPtr(On_(0))
   numOff = UBound(Off) + 1
   offPtr = VarPtr(Off(0))
   numToggle = UBound(Toggle) + 1
   togglePtr = VarPtr(Toggle(0))

   CreateSetOCGStateAction = pdfCreateSetOCGStateAction(m_Instance, onPtr, numOn, offPtr, numOff, togglePtr, numToggle, PreserveRB)
End Function

Friend Function CreateSigField(ByVal Name As String, ByVal Parent As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateSigField = pdfCreateSigField(m_Instance, Name, Parent, PosX, PosY, Width, Height)
End Function

Friend Function CreateSigFieldAP(ByVal SigField As Long) As Long
   CreateSigFieldAP = pdfCreateSigFieldAP(m_Instance, SigField)
End Function

Friend Function CreateSoftMask(ByVal TranspGroup As Long, ByVal MaskType As TSoftMaskType, ByVal BackColor As Long) As Long
   CreateSoftMask = pdfCreateSoftMask(m_Instance, TranspGroup, MaskType, BackColor)
End Function

Friend Function CreateStdPattern(ByVal Pattern As TStdPattern, ByVal LineWidth As Double, ByVal Distance As Double, ByVal LineColor As Long, ByVal BackColor As Long) As Long
   CreateStdPattern = pdfCreateStdPattern(m_Instance, Pattern, LineWidth, Distance, LineColor, BackColor)
End Function

Friend Function CreateStructureTree() As Boolean
   CreateStructureTree = pdfCreateStructureTree(m_Instance) <> 0
End Function

Friend Function CreateStructureTreeEx(ByVal RootTag As TPDFBaseTag) As Boolean
   CreateStructureTreeEx = pdfCreateStructureTreeEx(m_Instance, RootTag) <> 0
End Function

Friend Function CreateSubmitAction(ByVal Flags As TSubmitFlags, ByVal URL As String) As Long
   CreateSubmitAction = pdfCreateSubmitAction(m_Instance, Flags, URL)
End Function

Friend Function CreateTextField(ByVal Name As String, ByVal Parent As Long, ByVal Multiline As Long, ByVal MaxLen As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   CreateTextField = pdfCreateTextField(m_Instance, Name, Parent, Multiline, MaxLen, PosX, PosY, Width, Height)
End Function

Friend Function CreateURIAction(ByVal URL As String) As Long
   CreateURIAction = pdfCreateURIAction(m_Instance, URL)
End Function

Friend Function CreateViewport(ByVal Name As String, ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double) As Long
   CreateViewport = pdfCreateViewportW(m_Instance, StrPtr(Name), x1, y1, x2, y2)
End Function

Friend Function CreateXFAStream(ByVal Name As String, ByRef Buffer() As Byte) As Long
   CreateXFAStream = pdfCreateXFAStreamA(m_Instance, Name, Buffer(0), UBound(Buffer) + 1)
End Function

Friend Function DecryptPDF(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   DecryptPDF = pdfDecryptPDFW(m_Instance, StrPtr(FileName), PwdType, Password)
End Function

Friend Function DecryptPDFA(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   DecryptPDFA = pdfDecryptPDFA(m_Instance, FileName, PwdType, Password)
End Function

Friend Function DecryptPDFW(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   DecryptPDFW = pdfDecryptPDFW(m_Instance, StrPtr(FileName), PwdType, Password)
End Function

Friend Sub DeleteAcroForm()
   pdfDeleteAcroForm m_Instance
End Sub

Friend Function DeleteActionFromObj(ByVal ObjType As TObjType, ByVal ActHandle As Long, ByVal ObjHandle As Long) As Boolean
   DeleteActionFromObj = pdfDeleteActionFromObj(m_Instance, ObjType, ActHandle, ObjHandle) <> 0
End Function

Friend Function DeleteActionFromObjEx(ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Boolean
   DeleteActionFromObjEx = pdfDeleteActionFromObjEx(m_Instance, ObjType, ObjHandle, ActIndex) <> 0
End Function

Friend Function DeleteAltFontList(ByVal Handle As Long) As Boolean
   DeleteAltFontList = pdfDeleteAltFontList(m_Instance, Handle) <> 0
End Function

Friend Function DeleteAnnotation(ByVal Handle As Long) As Boolean
   DeleteAnnotation = pdfDeleteAnnotation(m_Instance, Handle) <> 0
End Function

Friend Function DeleteAnnotationFromPage(ByVal PageNum As Long, ByVal Handle As Long) As Boolean
   DeleteAnnotationFromPage = pdfDeleteAnnotationFromPage(m_Instance, PageNum, Handle) <> 0
End Function

Friend Function DeleteAppEvents(ByVal ApplyEvent As Long, ByVal AppEvent As TOCAppEvent) As Long
   DeleteAppEvents = pdfDeleteAppEvents(m_Instance, ApplyEvent, AppEvent)
End Function

Friend Function DeleteBookmark(ByVal ABmk As Long) As Long
   DeleteBookmark = pdfDeleteBookmark(m_Instance, ABmk)
End Function

Friend Function DeleteDPartNode(ByVal Handle As Long) As Boolean
   DeleteDPartNode = pdfDeleteDPartNode(m_Instance, Handle) <> 0
End Function

Friend Function DeleteEmbeddedFile(ByVal Handle As Long) As Boolean
   DeleteEmbeddedFile = pdfDeleteEmbeddedFile(m_Instance, Handle) <> 0
End Function

Friend Function DeleteField(ByVal Field As Long) As Boolean
   DeleteField = pdfDeleteField(m_Instance, Field) <> 0
End Function

Friend Function DeleteFieldEx(ByVal Name As String) As Boolean
   DeleteFieldEx = pdfDeleteFieldEx(m_Instance, Name) <> 0
End Function

Friend Sub DeleteJavaScripts(ByVal DelJavaScriptActions As Boolean)
   pdfDeleteJavaScripts m_Instance, DelJavaScriptActions
End Sub

Friend Function DeleteNamedDest(ByVal Name As String) As Boolean
   DeleteNamedDest = pdfDeleteNamedDestW(m_Instance, StrPtr(Name)) <> 0
End Function

Friend Function DeleteNamedDestByIndex(ByVal Index As Long) As Boolean
   DeleteNamedDestByIndex = pdfDeleteNamedDestByIndex(m_Instance, Index) <> 0
End Function

Friend Function DeleteOCGFromAppEvent(ByVal Handle As Long, ByVal Events As TOCAppEvent, ByVal Categories As TOCGUsageCategory, ByVal DelCategoryOnly As Boolean) As Boolean
   DeleteOCGFromAppEvent = pdfDeleteOCGFromAppEvent(m_Instance, Handle, Events, Categories, DelCategoryOnly) <> 0
End Function

Friend Function DeleteOCGFromDisplayTree(ByVal OCGHandle As Long, ByVal Recursive As Long) As Boolean
   DeleteOCGFromDisplayTree = pdfDeleteOCGFromDisplayTree(m_Instance, OCGHandle, Recursive) <> 0
End Function

Friend Function DeleteOCUINode(ByVal Node As Long) As Boolean
   DeleteOCUINode = pdfDeleteOCUINode(m_Instance, Node) <> 0
End Function

Friend Function DeleteOutputIntent(ByVal Index As Long) As Long
   DeleteOutputIntent = pdfDeleteOutputIntent(m_Instance, Index)
End Function

Friend Function DeletePage(ByVal PageNum As Long) As Long
   DeletePage = pdfDeletePage(m_Instance, PageNum)
End Function

Friend Sub DeletePageLabels()
   pdfDeletePageLabels m_Instance
End Sub

Friend Sub DeleteRasterizer(ByRef RasPtr As Long)
   Call rasDeleteRasterizer(RasPtr)
End Sub

Friend Function DeleteSeparationInfo(ByVal AllPages As Boolean) As Boolean
   DeleteSeparationInfo = pdfDeleteSeparationInfo(m_Instance, AllPages) <> 0
End Function

Friend Function DeleteTemplate(ByVal Handle As Long) As Boolean
   DeleteTemplate = pdfDeleteTemplate(m_Instance, Handle) <> 0
End Function

Friend Function DeleteTemplateEx(ByVal Index As Long) As Boolean
   DeleteTemplateEx = pdfDeleteTemplateEx(m_Instance, Index) <> 0
End Function

Friend Function DeleteWatermark(ByVal PageNum As Long, ByVal InclAnnots As Long) As Long
   DeleteWatermark = pdfDeleteWatermark(m_Instance, PageNum, InclAnnots)
End Function

Friend Sub DeleteXFAForm()
   pdfDeleteXFAForm m_Instance
End Sub

Friend Sub DisableColorManagement()
   Call pdfInitColorManagement(m_Instance, ByVal 0, csDeviceRGB, icmDefault)
End Sub

Friend Function DrawArc(ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal StartAngle As Double, ByVal EndAngle As Double) As Boolean
   DrawArc = pdfDrawArc(m_Instance, PosX, PosY, Radius, StartAngle, EndAngle) <> 0
End Function

Friend Function DrawArcEx(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double) As Boolean
   DrawArcEx = pdfDrawArcEx(m_Instance, PosX, PosY, Width, Height, StartAngle, EndAngle) <> 0
End Function

Friend Function DrawChord(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double, ByVal FillMode As TPathFillMode) As Boolean
   DrawChord = pdfDrawChord(m_Instance, PosX, PosY, Width, Height, StartAngle, EndAngle, FillMode) <> 0
End Function

Friend Function DrawCircle(ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal FillMode As TPathFillMode) As Boolean
   DrawCircle = pdfDrawCircle(m_Instance, PosX, PosY, Radius, FillMode) <> 0
End Function

Friend Function DrawNGon(ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal Alpha As Double, ByVal NumSides As Long, ByVal FillMode As TPathFillMode) As Boolean
   DrawNGon = pdfDrawNGon(m_Instance, PosX, PosY, Radius, Alpha, NumSides, FillMode) <> 0
End Function

Friend Function DrawPie(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal StartAngle As Double, ByVal EndAngle As Double, ByVal FillMode As TPathFillMode) As Boolean
   DrawPie = pdfDrawPie(m_Instance, PosX, PosY, Width, Height, StartAngle, EndAngle, FillMode) <> 0
End Function

Friend Function EditPage(ByVal PageNum As Long) As Boolean
   EditPage = pdfEditPage(m_Instance, PageNum) <> 0
End Function

Friend Function EditTemplate(ByVal Index As Long) As Boolean
   EditTemplate = pdfEditTemplate(m_Instance, Index) <> 0
End Function

Friend Function EditTemplate2(ByVal Handle As Long) As Boolean
   EditTemplate2 = pdfEditTemplate2(m_Instance, Handle) <> 0
End Function

Friend Function Ellipse(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal FillMode As TPathFillMode) As Boolean
   Ellipse = pdfEllipse(m_Instance, PosX, PosY, Width, Height, FillMode) <> 0
End Function

Friend Function EnableImageCache(ByVal MaxImageCount As Long, ByVal Size As Long) As Boolean
   EnableImageCache = pdfEnableImageCache(m_Instance, MaxImageCount, Size) <> 0
End Function

Friend Function EncryptPDF(ByVal FileName As String, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   EncryptPDF = pdfEncryptPDFW(m_Instance, StrPtr(FileName), OpenPwd, OwnerPwd, KeyLen, Restrict)
End Function

Friend Function EncryptPDFA(ByVal FileName As String, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   EncryptPDFA = pdfEncryptPDFA(m_Instance, FileName, OpenPwd, OwnerPwd, KeyLen, Restrict)
End Function

Friend Function EncryptPDFW(ByVal FileName As String, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   EncryptPDFW = pdfEncryptPDFW(m_Instance, StrPtr(FileName), OpenPwd, OwnerPwd, KeyLen, Restrict)
End Function

Friend Function EndContinueText() As Boolean
   EndContinueText = pdfEndContinueText(m_Instance) <> 0
End Function

Friend Function EndLayer() As Boolean
   EndLayer = pdfEndLayer(m_Instance) <> 0
End Function

Friend Function EndPage() As Boolean
   EndPage = pdfEndPage(m_Instance) <> 0
End Function

Friend Function EndPattern() As Boolean
   EndPattern = pdfEndPattern(m_Instance) <> 0
End Function

Friend Function EndTemplate() As Boolean
   EndTemplate = pdfEndTemplate(m_Instance) <> 0
End Function

Friend Function EnumDocFonts() As Long
   EnumDocFonts = pdfEnumDocFonts(m_Instance, ObjPtr(Me), AddressOf pdf_EnumFontsProc2)
End Function

Friend Function EnumHostFonts() As Long
   EnumHostFonts = pdfEnumHostFonts(m_Instance, ObjPtr(Me), AddressOf pdf_EnumFontsProc)
End Function

Friend Function EnumHostFontsEx() As Long
   EnumHostFontsEx = pdfEnumHostFontsEx(m_Instance, ObjPtr(Me), AddressOf pdf_EnumFontsProcEx)
End Function

Friend Function ExchangeBookmarks(ByVal Bmk1 As Long, ByVal Bmk2 As Long) As Boolean
   ExchangeBookmarks = pdfExchangeBookmarks(m_Instance, Bmk1, Bmk2) <> 0
End Function

Friend Function ExchangePages(ByVal First As Long, ByVal Second As Long) As Boolean
   ExchangePages = pdfExchangePages(m_Instance, First, Second) <> 0
End Function

Friend Function ExtractText(ByVal PageNum As Long, ByVal Flags As TTextExtractionFlags, ByRef text As String) As Boolean
   Dim txt As Long, txtLen As Long
   ExtractText = pdfExtractText(m_Instance, PageNum, Flags, 0, txt, txtLen) <> 0
   If ExtractText Then
      text = Space(txtLen)
      pdfCopyMem2 txt, ByVal StrPtr(text), txtLen * 2
   Else
      text = vbNullString
   End If
End Function

Friend Function ExtractText2(ByVal PageNum As Long, ByVal Flags As TTextExtractionFlags, ByRef Area As TFltRect, ByRef text As String) As Boolean
   Dim txt As Long, txtLen As Long
   ExtractText2 = pdfExtractText(m_Instance, PageNum, Flags, VarPtr(Area), txt, txtLen) <> 0
   If ExtractText2 Then
      text = Space(txtLen)
      pdfCopyMem2 txt, ByVal StrPtr(text), txtLen * 2
   Else
      text = vbNullString
   End If
End Function

Friend Function FileAttachAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal Author As String, ByVal Desc As String, ByVal AFile As String, ByVal Compress As Boolean) As Long
   FileAttachAnnot = pdfFileAttachAnnotW(m_Instance, PosX, PosY, Icon, StrPtr(Author), StrPtr(Desc), StrPtr(AFile), Compress)
End Function

Friend Function FileAttachAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal Author As String, ByVal Desc As String, ByVal AFile As String, ByVal Compress As Boolean) As Long
   FileAttachAnnotA = pdfFileAttachAnnotA(m_Instance, PosX, PosY, Icon, Author, Desc, AFile, Compress)
End Function

Friend Function FileAttachAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal Author As String, ByVal Desc As String, ByVal AFile As String, ByVal Compress As Boolean) As Long
   FileAttachAnnotW = pdfFileAttachAnnotW(m_Instance, PosX, PosY, Icon, StrPtr(Author), StrPtr(Desc), StrPtr(AFile), Compress)
End Function

Friend Function FileAttachAnnotEx(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal FileName As String, ByVal Author As String, ByVal Desc As String, ByRef Buffer() As Byte, ByVal Compress As Boolean) As Long
   FileAttachAnnotEx = pdfFileAttachAnnotExW(m_Instance, PosX, PosY, Icon, StrPtr(FileName), StrPtr(Author), StrPtr(Desc), Buffer(0), UBound(Buffer) + 1, Compress)
End Function

Friend Function FileAttachAnnotExA(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal FileName As String, ByVal Author As String, ByVal Desc As String, ByRef Buffer() As Byte, ByVal Compress As Boolean) As Long
   FileAttachAnnotExA = pdfFileAttachAnnotExA(m_Instance, PosX, PosY, Icon, FileName, Author, Desc, Buffer(0), UBound(Buffer) + 1, Compress)
End Function

Friend Function FileAttachAnnotExW(ByVal PosX As Double, ByVal PosY As Double, ByVal Icon As TFileAttachIcon, ByVal FileName As String, ByVal Author As String, ByVal Desc As String, ByRef Buffer() As Byte, ByVal Compress As Boolean) As Long
   FileAttachAnnotExW = pdfFileAttachAnnotExW(m_Instance, PosX, PosY, Icon, StrPtr(FileName), StrPtr(Author), StrPtr(Desc), Buffer(0), UBound(Buffer) + 1, Compress)
End Function

Friend Function FileLink(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal AFilePath As String) As Long
   FileLink = pdfFileLinkW(m_Instance, PosX, PosY, Width, Height, StrPtr(AFilePath))
End Function

Friend Function FileLinkA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal AFilePath As String) As Long
   FileLinkA = pdfFileLinkA(m_Instance, PosX, PosY, Width, Height, AFilePath)
End Function

Friend Function FileLinkW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal AFilePath As String) As Long
   FileLinkW = pdfFileLinkW(m_Instance, PosX, PosY, Width, Height, StrPtr(AFilePath))
End Function

Friend Function FindBookmark(ByVal DestPage As Long, ByVal Title As String) As Long
   FindBookmark = pdfFindBookmarkW(m_Instance, DestPage, StrPtr(Title))
End Function

Friend Function FindBookmarkA(ByVal DestPage As Long, ByVal Title As String) As Long
   FindBookmarkA = pdfFindBookmarkA(m_Instance, DestPage, Title)
End Function

Friend Function FindBookmarkW(ByVal DestPage As Long, ByVal Title As String) As Long
   FindBookmarkW = pdfFindBookmarkW(m_Instance, DestPage, StrPtr(Title))
End Function

Friend Function FindEmbeddedFile(ByVal Name As String) As Long
   FindEmbeddedFile = pdfFindEmbeddedFileW(m_Instance, StrPtr(Name))
End Function

Friend Function FindField(ByVal Name As String) As Long
   FindField = pdfFindFieldW(m_Instance, StrPtr(Name))
End Function

Friend Function FindFieldA(ByVal Name As String) As Long
   FindFieldA = pdfFindFieldA(m_Instance, Name)
End Function

Friend Function FindFieldW(ByVal Name As String) As Long
   FindFieldW = pdfFindFieldW(m_Instance, StrPtr(Name))
End Function

Friend Function FindLinkAnnot(ByVal URL As String) As Long
    FindLinkAnnot = pdfFindLinkAnnot(m_Instance, URL)
End Function

Friend Function FindNextBookmark() As Long
   FindNextBookmark = pdfFindNextBookmark(m_Instance)
End Function

Friend Function FinishSignature(ByRef PKCS7Obj() As Byte) As Boolean
   FinishSignature = pdfFinishSignature(m_Instance, PKCS7Obj(0), UBound(PKCS7Obj) + 1) <> 0
End Function

Friend Function FlattenAnnotOrField(ByVal Index As Long, ByVal Flags As TAnnotFlattenFlags) As Boolean
   FlattenAnnotOrField = pdfFlattenAnnotOrField(m_Instance, Index, Flags) <> 0
End Function

Friend Function FlattenAnnots(ByVal Flags As TAnnotFlattenFlags) As Long
   FlattenAnnots = pdfFlattenAnnots(m_Instance, Flags)
End Function

Friend Function FlattenForm() As Boolean
   FlattenForm = pdfFlattenForm(m_Instance) <> 0
End Function

Friend Function FlushPageContent() As Boolean
   FlushPageContent = pdfFlushPageContent(m_Instance, FStack) <> 0
End Function

Friend Function FlushPages(ByVal Flags As TFlushPageFlags) As Boolean
   FlushPages = pdfFlushPages(m_Instance, Flags) <> 0
End Function

Friend Function FlushPagesEx(ByVal Flags As TFlushPageFlags, ByVal LastPage As Long) As Boolean
   FlushPagesEx = pdfFlushPagesEx(m_Instance, Flags, LastPage) <> 0
End Function

Friend Sub FreeImageBuffer()
   pdfFreeImageBuffer m_Instance
End Sub

Friend Function FreeImageObj(ByVal Handle As Long) As Boolean
   FreeImageObj = pdfFreeImageObj(m_Instance, Handle) <> 0
End Function

Friend Function FreeImageObjEx(ByVal ImagePtr As Long) As Boolean
   FreeImageObjEx = pdfFreeImageObjEx(m_Instance, ImagePtr) <> 0
End Function

Friend Function FreePDF() As Boolean
   FreePDF = pdfFreePDF(m_Instance) <> 0
End Function

Friend Function FreeTextAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal AText As String, ByVal Align As TTextAlign) As Long
   FreeTextAnnot = pdfFreeTextAnnotW(m_Instance, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(AText), Align)
End Function

Friend Function FreeTextAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal AText As String, ByVal Align As TTextAlign) As Long
   FreeTextAnnotA = pdfFreeTextAnnotA(m_Instance, PosX, PosY, Width, Height, Author, AText, Align)
End Function

Friend Function FreeTextAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal AText As String, ByVal Align As TTextAlign) As Long
   FreeTextAnnotW = pdfFreeTextAnnotW(m_Instance, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(AText), Align)
End Function

Friend Function FreeUniBuf() As Boolean
   FreeUniBuf = pdfFreeUniBuf(m_Instance) <> 0
End Function

Friend Function Get3DAnnotStream(ByVal Annot As Long, ByRef Data() As Byte, ByRef Subtype As String) As Boolean
   Dim pdata As Long
   Dim psize As Long
   Dim st As Long
   Get3DAnnotStream = pdfGet3DAnnotStream(m_Instance, Annot, pdata, psize, st) <> 0
   If Get3DAnnotStream Then
      Subtype = ToStringA(st)
      If psize > 0 Then
         ReDim Data(psize - 1)
         Call pdfCopyMem2(pdata, Data(0), psize)
      Else
         Erase Data
      End If
   Else
      Erase Data
      Subtype = ""
   End If
End Function

Friend Function GetActionCount() As Long
   GetActionCount = pdfGetActionCount(m_Instance)
End Function

Friend Function GetActionHandle(ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Long
   GetActionHandle = pdfGetActionHandle(m_Instance, ObjType, ObjHandle, ActIndex)
End Function

Friend Function GetActionType(ByVal ActHandle As Long) As Long
   GetActionType = pdfGetActionType(m_Instance, ActHandle)
End Function

Friend Function GetActionTypeEx(ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByVal ActIndex As Long) As Long
   GetActionTypeEx = pdfGetActionTypeEx(m_Instance, ObjType, ObjHandle, ActIndex)
End Function

Friend Function GetActiveFont() As Long
   GetActiveFont = pdfGetActiveFont(m_Instance)
End Function

Friend Function GetAllocBy() As Long
   GetAllocBy = pdfGetAllocBy(m_Instance)
End Function

Friend Function GetAnnot(ByVal Handle As Long, ByRef Annot As TPDFAnnotation) As Boolean
   Dim retval As TPDFAnnotation_I
   If pdfGetAnnot(m_Instance, Handle, retval) = 0 Then Exit Function
   GetIntAnnot retval, Annot
   GetAnnot = True
End Function

Friend Function GetAnnotBBox(ByVal Handle As Long, ByRef BBox As TPDFRect) As Boolean
   GetAnnotBBox = pdfGetAnnotBBox(m_Instance, Handle, BBox) <> 0
End Function

Friend Function GetAnnotColor(ByVal Handle As Long, ByVal ColorType As TAnnotColor, ByRef CS As TPDFColorSpace, ByRef Color As Long) As Long
   GetAnnotColor = pdfGetAnnotColor(m_Instance, Handle, ColorType, CS, Color)
End Function

Friend Function GetAnnotCount() As Long
   GetAnnotCount = pdfGetAnnotCount(m_Instance)
End Function

Friend Function GetAnnotEx(ByVal Handle As Long, ByRef Annot As TPDFAnnotationEx) As Boolean
   Dim retval As TPDFAnnotationEx_I
   If pdfGetAnnotEx(m_Instance, Handle, retval) = 0 Then Exit Function
   GetIntAnnotEx retval, Annot
   GetAnnotEx = True
End Function

Friend Function GetAnnotFlags() As Long
   GetAnnotFlags = pdfGetAnnotFlags(m_Instance)
End Function

Friend Function GetAnnotLink(ByVal Handle As Long) As String
   Dim ptr As Long
   ptr = pdfGetAnnotLink(m_Instance, Handle)
   GetAnnotLink = ToStringA(ptr)
End Function

Friend Function GetAnnotTextAlign(ByVal Handle As Long) As Long
   GetAnnotTextAlign = pdfGetAnnotTextAlign(m_Instance, Handle)
End Function

Friend Function GetAnnotType(ByVal Handle As Long) As Long
   GetAnnotType = pdfGetAnnotType(m_Instance, Handle)
End Function

Friend Function GetAscent() As Double
   GetAscent = pdfGetAscent(m_Instance)
End Function

Friend Function GetBarcodeDict(ByVal IBarcode As Long, ByRef Barcode As TPDFBarcode) As Boolean
   Dim bc As TPDFBarcode_I
   bc.StructSize = LenB(bc)
   If pdfGetBarcodeDict(IBarcode, bc) = 0 Then Exit Function
   GetIntBarcode bc, Barcode
   GetBarcodeDict = True
End Function

Friend Function GetBBox(ByVal Boundary As TPageBoundary, BBox As TPDFRect) As Long
   GetBBox = pdfGetBBox(m_Instance, Boundary, BBox)
End Function

Friend Function GetBidiMode() As TPDFBidiMode
   GetBidiMode = pdfGetBidiMode(m_Instance)
End Function

Friend Function GetBookmark(ByVal Handle As Long, Bmk As TBookmark) As Boolean
   GetBookmark = pdfGetBookmark(m_Instance, Handle, FBookmark) <> 0
   If GetBookmark = False Then Exit Function
   Bmk.Color = FBookmark.Color
   Bmk.DestPage = FBookmark.DestPage
   Bmk.DestPos.rBottom = FBookmark.DestPos.rBottom
   Bmk.DestPos.rLeft = FBookmark.DestPos.rLeft
   Bmk.DestPos.rRight = FBookmark.DestPos.rRight
   Bmk.DestPos.rTop = FBookmark.DestPos.rTop
   Bmk.DestType = FBookmark.DestType
   Bmk.DoOpen = FBookmark.DoOpen <> 0
   Bmk.Parent = FBookmark.Parent
   Bmk.Style = FBookmark.Style
   Bmk.Title = ToString2(FBookmark.Title, FBookmark.TitleLen, FBookmark.bUnicode <> 0)
End Function

Friend Function GetBookmarkCount() As Long
   GetBookmarkCount = pdfGetBookmarkCount(m_Instance)
End Function

Friend Function GetBookmarkEx(ByVal Handle As Long, ByRef Bmk As TPDFBookmark) As Boolean
   Dim b As TPDFBookmark_I
   b.StructSize = LenB(b)
   GetBookmarkEx = pdfGetBookmarkEx(m_Instance, Handle, b) <> 0
   If GetBookmarkEx = False Then Exit Function
   Bmk.Action = b.Action
   Bmk.Color = b.Color
   Bmk.DestPage = b.DestPage
   Bmk.DestPos.rBottom = b.DestPos.rBottom
   Bmk.DestPos.rLeft = b.DestPos.rLeft
   Bmk.DestPos.rRight = b.DestPos.rRight
   Bmk.DestPos.rTop = b.DestPos.rTop
   Bmk.DestType = b.DestType
   Bmk.NamedDest = ToStringEx(b.NamedDestA, b.NamedDestW)
   Bmk.DoOpen = b.DoOpen <> 0
   Bmk.Parent = b.Parent
   Bmk.StructElem = b.StructElem
   Bmk.Style = b.Style
   Bmk.Title = ToStringEx(b.TitleA, b.TitleW, b.TitleLen)
End Function

Friend Function GetBorderStyle() As Long
   GetBorderStyle = pdfGetBorderStyle(m_Instance)
End Function

Friend Function GetBuffer() As Byte()
   Dim pBuffer As Long
   Dim BufSize As Long
   Dim retval() As Byte

   pBuffer = pdfGetBuffer(m_Instance, BufSize)
   If (BufSize = 0) Or (pBuffer = 0) Then Exit Function
   ReDim retval(BufSize - 1)
   pdfCopyMem2 pBuffer, retval(0), BufSize
   GetBuffer = retval
   pdfFreePDF m_Instance
End Function

Friend Function GetCapHeight() As Double
   GetCapHeight = pdfGetCapHeight(m_Instance)
End Function

Friend Function GetCharacterSpacing() As Double
   GetCharacterSpacing = pdfGetCharacterSpacing(m_Instance)
End Function

Friend Function GetCheckBoxChar() As Long
   GetCheckBoxChar = pdfGetCheckBoxChar(m_Instance)
End Function

Friend Function GetCheckBoxCharEx(ByVal AField As Long) As Long
   GetCheckBoxCharEx = pdfGetCheckBoxCharEx(m_Instance, AField)
End Function

Friend Function GetCheckBoxDefState(ByVal Field As Long) As Long
   GetCheckBoxDefState = pdfGetCheckBoxDefState(m_Instance, Field)
End Function

Friend Function GetCMap(ByVal Index As Long, ByRef CMap As TPDFCMap) As Boolean
   Dim m As TPDFCMap_I
   m.StructSize = LenB(m)
   If pdfGetCMap(m_Instance, Index, m) <> 0 Then
      CMap.BaseCMap = ToStringA(m.BaseCMap)
      CMap.CIDCount = m.CIDCount
      CMap.CMapName = ToStringA(m.CMapName)
      CMap.CMapType = m.CMapType
      CMap.CMapVersion = m.CMapVersion
      CMap.DSCBaseCMap = ToStringA(m.DSCBaseCMap)
      CMap.DSCCMapVersion = m.DSCCMapVersion
      CMap.DSCResName = ToStringA(m.DSCResName)
      CMap.DSCTitle = ToStringA(m.DSCTitle)
      CMap.FileName = ToStringEx(m.FileNameA, m.FileNameW)
      CMap.FilePath = ToStringEx(m.FilePathA, m.FilePathW)
      CMap.Ordering = ToStringA(m.Ordering)
      CMap.Registry = ToStringA(m.Registry)
      CMap.Supplement = m.Supplement
      CMap.WritingMode = m.WritingMode
      GetCMap = True
   Else
      GetCMap = False
   End If
End Function

Friend Function GetCMapCount() As Long
   GetCMapCount = pdfGetCMapCount(m_Instance)
End Function

Friend Function GetCollectionInfo(ByRef Value As TPDFCollectionInfo) As Boolean
   Dim i As TPDFCollectionInfo_I
   GetCollectionInfo = pdfGetCollectionInfo(m_Instance, i) <> 0
   If GetCollectionInfo = 0 Then Exit Function
   Value.InitalFile = i.InitalFile
   Value.InitalView = i.InitalView
   Value.SortBy = ToStringA(i.SortBy)
   Value.SortDesc = i.SortDesc <> 0
   Value.SplitInfo = i.SplitInfo
   Value.SplitPos = i.SplitPos
End Function

Friend Function GetColorSpace() As Long
   GetColorSpace = pdfGetColorSpace(m_Instance)
End Function

Friend Function GetColorSpaceCount() As Long
   GetColorSpaceCount = pdfGetColorSpaceCount(m_Instance)
End Function

Friend Function GetColorSpaceObj(ByVal Handle As Long, ByRef CS As TPDFColorSpaceObj) As Boolean
   Dim ics As TPDFColorSpaceObj_I
   If pdfGetColorSpaceObj(m_Instance, Handle, ics) = 0 Then Exit Function
   GetIntColorSpaceObj ics, CS
   GetColorSpaceObj = True
End Function

Friend Function GetColorSpaceObjEx(ByVal IColorSpace As Long, ByRef CS As TPDFColorSpaceObj) As Boolean
   Dim ics As TPDFColorSpaceObj_I
   If pdfGetColorSpaceObjEx(IColorSpace, ics) = 0 Then Exit Function
   GetIntColorSpaceObj ics, CS
   GetColorSpaceObjEx = True
End Function

Friend Function GetCompressionFilter() As Long
   GetCompressionFilter = pdfGetCompressionFilter(m_Instance)
End Function

Friend Function GetCompressionLevel() As Long
   GetCompressionLevel = pdfGetCompressionLevel(m_Instance)
End Function

Friend Function GetContent(ByRef Buffer() As Byte) As Boolean
   Dim BufSize As Long
   Dim pBuffer As Long
   Dim EmptyBuffer() As Byte
   BufSize = pdfGetContent(m_Instance, pBuffer)
   If BufSize < 0 Then Exit Function
   If BufSize = 0 Then
      Buffer = EmptyBuffer
   Else
      ReDim Buffer(BufSize - 1)
      pdfCopyMem2 pBuffer, Buffer(0), BufSize
   End If
   GetContent = True
End Function

Friend Function GetDefBitsPerPixel() As Long
   GetDefBitsPerPixel = pdfGetDefBitsPerPixel(m_Instance)
End Function

Friend Function GetDescent() As Double
   GetDescent = pdfGetDescent(m_Instance)
End Function

Friend Function GetDeviceNAttributes(ByVal IAttributes As Long, ByRef Attributes As TDeviceNAttributes) As Boolean
   Dim i As Long
   Dim attr As TDeviceNAttributes_I
   If pdfGetDeviceNAttributes(IAttributes, attr) = 0 Then Exit Function
   Attributes.IProcessColorSpace = attr.IProcessColorSpace
   Attributes.ProcessColorantsCount = attr.ProcessColorantsCount
   Attributes.SeparationsCount = attr.SeparationsCount
   Attributes.IMixingHints = attr.IMixingHints
   Erase Attributes.ProcessColorants
   For i = 0 To Attributes.ProcessColorantsCount - 1
      Attributes.ProcessColorants(i) = UTF8ToString(attr.ProcessColorants(i))
   Next i
   For i = 0 To Attributes.SeparationsCount - 1
      Attributes.Separations(i) = attr.Separations(i)
   Next i
   GetDeviceNAttributes = True
End Function

Friend Function GetDocInfo(ByVal DInfo As TDocumentInfo, Value As String) As Boolean
   Dim BufSize As Long
   Dim pBuffer As Long

   BufSize = pdfGetDocInfo(m_Instance, DInfo, pBuffer)
   If BufSize < 0 Then Exit Function
   Value = ToStringW(pBuffer, BufSize)
   GetDocInfo = True
End Function

Friend Function GetDocInfoCount() As Long
   GetDocInfoCount = pdfGetDocInfoCount(m_Instance)
End Function

Friend Function GetDocInfoEx(ByVal Index As Long, ByRef DInfo As TDocumentInfo, ByRef Key As String, ByRef Value As String) As Boolean
   Dim valName As Long
   Dim keyName As Long
   Dim valLen As Long
   Dim uni As Long
   Dim Info As Long

   valLen = pdfGetDocInfoEx(m_Instance, Index, Info, keyName, valName, uni)
   If valLen <= 0 Then
      Key = ""
      Value = ""
      GetDocInfoEx = False
      Exit Function
   End If
   DInfo = Info
   Key = UTF8ToString(keyName)
   Value = ToString2(valName, valLen, uni <> 0)
   GetDocInfoEx = True
End Function

Friend Function GetDocUsesTransparency(ByVal Flags As Long) As Boolean
   GetDocUsesTransparency = pdfGetDocUsesTransparency(m_Instance, Flags) <> 0
End Function

Friend Function GetDrawDirection() As Long
   GetDrawDirection = pdfGetDrawDirection(m_Instance)
End Function

Friend Function GetDynaPDFVersion() As String
   Dim ptr As Long
   ptr = pdfGetDynaPDFVersion
   GetDynaPDFVersion = ToStringA(ptr)
End Function

Friend Function GetDynaPDFVersionInt() As Long
   Dim sLen As Long, retval As Long, Value As Long, p As Long, v As String
   v = GetDynaPDFVersion()
   p = 1
   GetDynaPDFVersionInt = 0
   sLen = ParseInt(v, p, Value)
   If sLen = 0 Then Exit Function
   retval = Value * 10000000
   p = p + sLen + 3
   sLen = ParseInt(v, p, Value)
   If sLen = 0 Then Exit Function
   retval = retval + Value * 10000
   p = p + sLen + 1
   If ParseInt(v, p, Value) = 0 Then Exit Function
   retval = retval + Value
   GetDynaPDFVersionInt = retval
End Function

Friend Function GetEmbeddedFile(ByVal Handle As Long, ByRef FileSpec As TPDFFileSpec, ByVal Decompress As Boolean) As Boolean
   Dim fSpec As TPDFFileSpec_I
   If pdfGetEmbeddedFile(m_Instance, Handle, fSpec, Decompress) = 0 Then Exit Function
   If fSpec.Buffer > 0 Then
      ReDim FileSpec.Buffer(fSpec.BufSize - 1)
      FileSpec.BufSize = fSpec.BufSize
      pdfCopyMem2 fSpec.Buffer, FileSpec.Buffer(0), fSpec.BufSize
   Else
      Erase FileSpec.Buffer
      FileSpec.BufSize = 0
   End If
   FileSpec.ColItem = fSpec.ColItem
   FileSpec.Compressed = fSpec.Compressed <> 0
   FileSpec.FileSize = fSpec.FileSize
   FileSpec.IsURL = fSpec.IsURL <> 0
   If fSpec.CheckSum <> 0 Then
      ReDim FileSpec.CheckSum(15)
      pdfCopyMem2 fSpec.CheckSum, FileSpec.CheckSum(0), 16
   Else
      Erase FileSpec.CheckSum
   End If
   FileSpec.CreateDate = ToStringA(fSpec.CreateDate)
   FileSpec.Desc = ToString2(fSpec.Desc, , fSpec.DescUnicode <> 0)
   FileSpec.FileName = ToStringA(fSpec.FileName)
   FileSpec.MIMEType = ToStringA(fSpec.MIMEType)
   FileSpec.ModDate = ToStringA(fSpec.ModDate)
   FileSpec.Name = ToString2(fSpec.Name, , fSpec.NameUnicode <> 0)
   FileSpec.UF = ToString2(fSpec.UF, , fSpec.UFUnicode <> 0)
   GetEmbeddedFile = True
End Function

Friend Function GetEmbeddedFileCount() As Long
   GetEmbeddedFileCount = pdfGetEmbeddedFileCount(m_Instance)
End Function

Friend Function GetEmbeddedFileNode(ByVal IEF As Long, ByRef f As TPDFEmbFileNode, ByVal Decompress As Boolean) As Boolean
   Dim Node As TPDFEmbFileNode_I
   GetEmbeddedFileNode = False
   Node.StructSize = LenB(Node)
   If pdfGetEmbeddedFileNode(IEF, Node, Decompress) <> 0 Then
      f.Name = UTF8ToString(Node.Name)
      f.NextNode = Node.NextNode
      If Node.EF.BufSize > 0 Then
         ReDim f.EF.Buffer(Node.EF.BufSize - 1)
         f.EF.BufSize = Node.EF.BufSize
         pdfCopyMem2 Node.EF.Buffer, f.EF.Buffer(0), Node.EF.BufSize
      Else
         Erase f.EF.Buffer
         f.EF.BufSize = 0
      End If
      f.EF.ColItem = Node.EF.ColItem
      f.EF.Compressed = Node.EF.Compressed <> 0
      f.EF.FileSize = Node.EF.FileSize
      f.EF.IsURL = Node.EF.IsURL <> 0
      If Node.EF.CheckSum <> 0 Then
         ReDim f.EF.CheckSum(15)
         pdfCopyMem2 Node.EF.CheckSum, f.EF.CheckSum(0), 16
      Else
         Erase f.EF.CheckSum
      End If
      f.EF.CreateDate = ToStringA(Node.EF.CreateDate)
      f.EF.Desc = ToString2(Node.EF.Desc, , Node.EF.DescUnicode <> 0)
      f.EF.FileName = ToStringA(Node.EF.FileName)
      f.EF.MIMEType = ToStringA(Node.EF.MIMEType)
      f.EF.ModDate = ToStringA(Node.EF.ModDate)
      f.EF.Name = ToString2(Node.EF.Name, , Node.EF.NameUnicode <> 0)
      f.EF.UF = ToString2(Node.EF.UF, , Node.EF.UFUnicode <> 0)
      GetEmbeddedFileNode = True
   End If
End Function

Friend Function GetEMFPatternDistance() As Double
   GetEMFPatternDistance = pdfGetEMFPatternDistance(m_Instance)
End Function

Friend Function GetErrLogMessage(ByVal Index As Long, ByRef Err As TPDFError) As Boolean
   Dim e As TPDFError_I
   e.StructSize = LenB(e)
   If pdfGetErrLogMessage(m_Instance, Index, e) = 0 Then Exit Function
   Err.Message = ToStringA(e.Message)
   Err.ObjNum = e.ObjNum
   Err.Offset = e.Offset
   Err.SrcFile = ToStringA(e.SrcFile)
   Err.SrcLine = e.SrcLine
   Err.ErrCode = e.ErrCode
   Err.ErrType = e.ErrType
   GetErrLogMessage = True
End Function

Friend Function GetErrLogMessageCount() As Long
   GetErrLogMessageCount = pdfGetErrLogMessageCount(m_Instance)
End Function

Friend Function GetErrorMessage() As String
   Dim ptr As Long
   ptr = pdfGetErrorMessage(m_Instance)
   GetErrorMessage = ToStringA(ptr)
End Function

Friend Function GetErrorMode() As Long
   GetErrorMode = pdfGetErrorMode(m_Instance)
End Function

Friend Function GetField(ByVal Handle As Long, Field As TPDFField) As Boolean
   If pdfGetField(m_Instance, Handle, FField) = 0 Then Exit Function
   GetIntField Field
   GetField = True
End Function

Friend Function GetFieldBackColor() As Long
   GetFieldBackColor = pdfGetFieldBackColor(m_Instance)
End Function

Friend Function GetFieldBorderColor() As Long
   GetFieldBorderColor = pdfGetFieldBorderColor(m_Instance)
End Function

Friend Function GetFieldBorderStyle(ByVal Field As Long) As Long
   GetFieldBorderStyle = pdfGetFieldBorderStyle(m_Instance, Field)
End Function

Friend Function GetFieldBorderWidth(ByVal Field As Long) As Double
   GetFieldBorderWidth = pdfGetFieldBorderWidth(m_Instance, Field)
End Function

Friend Function GetFieldCalcOrder(ByRef CalcOrder() As Long) As Long
   Dim ptr As Long, n As Long
   n = pdfGetFieldCalcOrder(m_Instance, ptr)
   If n > 0 Then
      ReDim CalcOrder(n - 1)
      pdfCopyMem2 ptr, CalcOrder(0), n * 4
   Else
      Erase CalcOrder
   End If
   GetFieldCalcOrder = n
End Function

Friend Function GetFieldChoiceValue(ByVal Field As Long, ByVal ValIndex As Long, ByRef Value As TPDFChoiceValue) As Boolean
   Dim v As TPDFChoiceValue_I
   v.StructSize = LenB(v)
   If pdfGetFieldChoiceValue(m_Instance, Field, ValIndex, v) = 0 Then Exit Function
   Value.ExpValue = ToStringEx(v.ExpValueA, v.ExpValueW, v.ExpValueLen)
   Value.Value = ToStringEx(v.ValueA, v.ValueW, v.ValueLen)
   Value.Selected = v.Selected <> 0
   GetFieldChoiceValue = True
End Function

Friend Function GetFieldColor(ByVal Field As Long, ByVal ColorType As TFieldColor, ColorSpace As Long, Color As Long) As Boolean
   GetFieldColor = pdfGetFieldColor(m_Instance, Field, ColorType, ColorSpace, Color) <> 0
End Function

Friend Function GetFieldCount() As Long
   GetFieldCount = pdfGetFieldCount(m_Instance)
End Function

Friend Function GetFieldEx(ByVal Handle As Long, ByRef Field As TPDFFieldEx) As Boolean
   Dim f As TPDFFieldEx_I
   f.StructSize = LenB(f)
   If pdfGetFieldEx(m_Instance, Handle, f) = 0 Then Exit Function
   GetIntFieldEx f, Field
   GetFieldEx = True
End Function

Friend Function GetFieldEx2(ByVal IField As Long, ByRef Field As TPDFFieldEx) As Boolean
   Dim f As TPDFFieldEx_I
   f.StructSize = Len(f)
   If pdfGetFieldEx2(IField, f) = 0 Then Exit Function
   GetIntFieldEx f, Field
   GetFieldEx2 = True
End Function

Friend Function GetFieldExpValCount(ByVal Field As Long) As Long
   GetFieldExpValCount = pdfGetFieldExpValCount(m_Instance, Field)
End Function

Friend Function GetFieldExpValue(ByVal Field As Long, ByRef Value As String) As Boolean
   Dim pBuffer As Long
   Dim BufSize As Long

   BufSize = pdfGetFieldExpValue(m_Instance, Field, pBuffer)
   If BufSize < 0 Then
      Value = ""
      Exit Function
   End If
   Value = ToStringA(pBuffer, BufSize)
   GetFieldExpValue = True
End Function

Friend Function GetFieldExpValueEx(ByVal Field As Long, ByVal ValIndex As Long, ByRef Value As String, ByRef ExpValue As String, ByRef bSelected As Long) As Boolean
   Dim valPtr As Long
   Dim expPtr As Long
   If pdfGetFieldExpValueEx(m_Instance, Field, ValIndex, valPtr, expPtr, bSelected) = 0 Then
      Value = ""
      ExpValue = ""
      bSelected = False
      Exit Function
   End If
   Value = ToStringA(valPtr)
   ExpValue = ToStringA(expPtr)
   GetFieldExpValueEx = True
End Function

Friend Function GetFieldFlags(ByVal Field As Long) As Long
   GetFieldFlags = pdfGetFieldFlags(m_Instance, Field)
End Function

Friend Function GetFieldGroupType(ByVal Field As Long) As Long
   GetFieldGroupType = pdfGetFieldGroupType(m_Instance, Field)
End Function

Friend Function GetFieldHighlightMode(ByVal Field As Long) As Long
   GetFieldHighlightMode = pdfGetFieldHighlightMode(m_Instance, Field)
End Function

Friend Function GetFieldIndex(ByVal Field As Long) As Long
   GetFieldIndex = pdfGetFieldIndex(m_Instance, Field)
End Function

Friend Function GetFieldMapName(ByVal Field As Long, Value As String) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   BufSize = pdfGetFieldMapName(m_Instance, Field, pBuffer, uni)
   If BufSize < 0 Then
      Value = ""
      Exit Function
   End If
   Value = ToString2(pBuffer, BufSize, uni <> 0)
   GetFieldMapName = True
End Function

Friend Function GetFieldName(ByVal Field As Long, Name As String) As Boolean
   Dim pBuffer As Long
   Dim BufSize As Long

   BufSize = pdfGetFieldName(m_Instance, Field, pBuffer)
   If BufSize < 0 Then
      Name = ""
      Exit Function
   End If
   Name = ToString3(pBuffer, BufSize)
   GetFieldName = True
End Function

Friend Function GetFieldOrientation(ByVal Field As Long) As Long
   GetFieldOrientation = pdfGetFieldOrientation(m_Instance, Field)
End Function

Friend Function GetFieldTextAlign(ByVal Field As Long) As TTextAlign
   GetFieldTextAlign = pdfGetFieldTextAlign(m_Instance, Field)
End Function

Friend Function GetFieldTextColor() As Long
   GetFieldTextColor = pdfGetFieldTextColor(m_Instance)
End Function

Friend Function GetFieldToolTip(ByVal Field As Long, Value As String) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   BufSize = pdfGetFieldToolTip(m_Instance, Field, pBuffer, uni)
   If BufSize < 0 Then
      Value = ""
      Exit Function
   End If
   Value = ToString2(pBuffer, BufSize, uni <> 0)
   GetFieldToolTip = True
End Function

Friend Function GetFieldType(ByVal Field As Long, ByRef Value As TFieldType) As Boolean
   Dim retval As Long
   retval = pdfGetFieldType(m_Instance, Field)
   If retval < 0 Then Exit Function
   Value = retval
   GetFieldType = True
End Function

Friend Function GetFileSpec(ByVal IFS As Long, ByRef f As TPDFFileSpecEx) As Boolean
   Dim fs As TPDFFileSpecEx_I
   fs.StructSize = LenB(fs)
   GetFileSpec = False
   If pdfGetFileSpec(IFS, fs) <> 0 Then
      CopyFileSpecEx fs, f
      GetFileSpec = True
   End If
End Function

Friend Function GetFillColor() As Long
   GetFillColor = pdfGetFillColor(m_Instance)
End Function

Friend Function GetFont(ByVal IFont As Long, ByRef Font As TPDFFontObj) As Boolean
   Dim fnt As TPDFFontObj_I
   If fntGetFont(IFont, fnt) = 0 Then Exit Function
   GetIntFont fnt, Font
   GetFont = True
End Function

Friend Function GetFontCount() As Long
   GetFontCount = pdfGetFontCount(m_Instance)
End Function

Friend Function GetFontEx(ByVal Handle As Long, ByRef Font As TPDFFontObj) As Boolean
   Dim fnt As TPDFFontObj_I
   If pdfGetFontEx(m_Instance, Handle, fnt) = 0 Then Exit Function
   GetIntFont fnt, Font
   GetFontEx = True
End Function

Friend Function GetFontInfo(ByVal IFont As Long, ByRef Font As TPDFFontInfo) As Boolean
   Dim fnt As TPDFFontInfo_I
   fnt.StructSize = LenB(fnt)
   If fntGetFontInfo(IFont, fnt) = 0 Then Exit Function
   GetIntFontInfo fnt, Font
   GetFontInfo = True
End Function

Friend Function GetFontInfoEx(ByVal Handle As Long, ByRef Font As TPDFFontInfo) As Boolean
   Dim fnt As TPDFFontInfo_I
   fnt.StructSize = LenB(fnt)
   If pdfGetFontInfoEx(m_Instance, Handle, fnt) = 0 Then Exit Function
   GetIntFontInfo fnt, Font
   GetFontInfoEx = True
End Function

Friend Function GetFontMetrics(ByVal Handle As Long, ByRef Metrics As TPDFFontMetrics) As Boolean
   Metrics.StructSize = LenB(Metrics)
   GetFontMetrics = pdfGetFontMetrics(m_Instance, Handle, Metrics)
End Function

Friend Function GetFontOrigin() As TOrigin
   GetFontOrigin = pdfGetFontOrigin(m_Instance)
End Function

Friend Sub GetFontSearchOrder(ByRef Order() As TFontBaseType)
   pdfGetFontSearchOrder m_Instance, Order(0)
End Sub

Friend Function GetFontSelMode() As TFontSelMode
   GetFontSelMode = pdfGetFontSelMode(m_Instance)
End Function

Friend Function GetFontWeight() As Long
   GetFontWeight = pdfGetFontWeight(m_Instance)
End Function

Friend Function GetFTextHeight(ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeight = pdfGetFTextHeightW(m_Instance, Align, StrPtr(AText))
End Function

Friend Function GetFTextHeightA(ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeightA = pdfGetFTextHeightA(m_Instance, Align, AText)
End Function

Friend Function GetFTextHeightW(ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeightW = pdfGetFTextHeightW(m_Instance, Align, StrPtr(AText))
End Function

Friend Function GetFTextHeightEx(ByVal Width As Double, ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeightEx = pdfGetFTextHeightExW(m_Instance, Width, Align, StrPtr(AText))
End Function

Friend Function GetFTextHeightExA(ByVal Width As Double, ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeightExA = pdfGetFTextHeightExA(m_Instance, Width, Align, AText)
End Function

Friend Function GetFTextHeightExW(ByVal Width As Double, ByVal Align As TTextAlign, ByVal AText As String) As Double
   GetFTextHeightExW = pdfGetFTextHeightExW(m_Instance, Width, Align, StrPtr(AText))
End Function

Friend Function GetFullyQualifiedFieldName(ByVal Handle As Long, ByRef Value As String) As Long
   Dim v As Long
   Dim sLen As Long
   Value = ""
   sLen = pdfGetFullyQualifiedFieldName(m_Instance, Handle, v)
   If sLen > 0 Then
      Value = ToString2(v, sLen, True)
   End If
   GetFullyQualifiedFieldName = sLen
End Function

Friend Function GetFontSize() As Double
   GetFontSize = pdfGetFontSize(m_Instance)
End Function

Friend Function GetGlyphIndex(ByVal Index As Long) As Long
   GetGlyphIndex = pdfGetGlyphIndex(m_Instance, Index)
End Function

Friend Function GetGlyphOutline(ByVal Index As Long, ByRef Outline As TPDFGlyphOutline) As Long
   Dim g As TPDFGlyphOutline_I
   Erase Outline.Outline
   GetGlyphOutline = pdfGetGlyphOutline(m_Instance, Index, ByVal 0&)
   If GetGlyphOutline > 0 Then
      ReDim Outline.Outline(GetGlyphOutline - 1)
      g.Outline = VarPtr(Outline.Outline(0))
      GetGlyphOutline = pdfGetGlyphOutline(m_Instance, Index, g)
   End If
   Outline.AdvanceX = g.AdvanceX
   Outline.AdvanceY = g.AdvanceY
   Outline.OriginX = g.OriginX
   Outline.OriginY = g.OriginY
   Outline.Lsb = g.Lsb
   Outline.Tsb = g.Tsb
   Outline.HaveBBox = g.HaveBBox <> 0
   Outline.BBox = g.BBox
End Function

Friend Function GetGoToAction(ByVal Handle As Long, ByRef Action As TPDFGoToAction) As Boolean
   Dim a As TPDFGoToAction_I
   a.StructSize = LenB(a)
   GetGoToAction = False
   If pdfGetGoToAction(m_Instance, Handle, a) <> 0 Then
      Action.DestFile = a.DestFile
      Action.DestName = ToStringEx(a.DestNameA, a.DestNameW)
      Action.DestPage = a.DestPage
      Action.DestType = a.DestType
      Action.NewWindow = a.NewWindow
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      If a.DestPage <> 0 Then
         ReDim Action.DestPos(3)
         pdfCopyMem2 a.DestPos, Action.DestPos(0), 16
      Else
         Erase Action.DestPos
      End If
      GetGoToAction = True
   End If
End Function

Friend Function GetGoToRAction(ByVal Handle As Long, ByRef Action As TPDFGoToAction) As Boolean
   GetGoToRAction = GetGoToAction(Handle, Action)
End Function

Friend Function GetGStateFlags() As Long
   GetGStateFlags = pdfGetGStateFlags(m_Instance)
End Function

Friend Function GetHideAction(ByVal Handle As Long, ByRef Action As TPDFHideAction) As Boolean
   Dim a As TPDFHideAction_I
   a.StructSize = LenB(a)
   GetHideAction = False
   If pdfGetHideAction(m_Instance, Handle, a) <> 0 Then
      Action.Hide = a.Hide <> 0
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      If a.FieldsCount > 0 Then
         ReDim Action.Fields(a.FieldsCount - 1)
         pdfCopyMem2 a.Fields, Action.Fields(0), a.FieldsCount * 4
      Else
         Erase Action.Fields
      End If
      GetHideAction = True
   End If
End Function

Friend Function GetIconColor() As Long
   GetIconColor = pdfGetIconColor(m_Instance)
End Function

Friend Function GetImageBuffer() As Byte()
   ' Is this really intelligent to return the image buffer as VB byte array?
   Dim pBuffer As Long
   Dim BufSize As Long
   Dim retval() As Byte

   pBuffer = pdfGetImageBuffer(m_Instance, BufSize)
   If (BufSize = 0) Or (pBuffer = 0) Then Exit Function
   ReDim retval(BufSize - 1)
   pdfCopyMem2 pBuffer, retval(0), BufSize
   GetImageBuffer = retval
   pdfFreeImageBuffer m_Instance
End Function

Friend Function GetImageBufferEx(ByRef BufSize As Long) As Long
   GetImageBufferEx = pdfGetImageBuffer(m_Instance, BufSize)
End Function

Friend Function GetImageCount(ByVal FileName As String) As Long
   GetImageCount = pdfGetImageCountW(m_Instance, StrPtr(FileName))
End Function

Friend Function GetImageCountW(ByVal FileName As String) As Long
   GetImageCountW = pdfGetImageCountW(m_Instance, StrPtr(FileName))
End Function

Friend Function GetImageHeight(ByVal Handle As Long) As Long
   GetImageHeight = pdfGetImageHeight(m_Instance, Handle)
End Function

Friend Function GetImageObj(ByVal Handle As Long, ByVal Flags As TParseFlags, ByRef Image As TPDFImage) As Boolean
   GetImageObj = pdfGetImageObj(m_Instance, Handle, Flags, Image) <> 0
End Function

Friend Function GetImageObjCount() As Long
   GetImageObjCount = pdfGetImageObjCount(m_Instance)
End Function

Friend Function GetImageObjEx(ByVal ImagePtr As Long, ByVal Flags As TParseFlags, ByRef Image As TPDFImage) As Long
   GetImageObjEx = pdfGetImageObjEx(m_Instance, ImagePtr, Flags, Image)
End Function

Friend Function GetImageWidth(ByVal Handle As Long) As Long
   GetImageWidth = pdfGetImageWidth(m_Instance, Handle)
End Function

Friend Function GetImportDataAction(ByVal Handle As Long, ByRef Action As TPDFImportDataAction) As Boolean
   Dim a As TPDFImportDataAction_I
   a.StructSize = LenB(a)
   GetImportDataAction = False
   If pdfGetImportDataAction(m_Instance, Handle, a) <> 0 Then
      CopyFileSpecEx a.Data, Action.Data
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      GetImportDataAction = True
   End If
End Function

Friend Function GetImportFlags() As Long
   GetImportFlags = pdfGetImportFlags(m_Instance)
End Function

Friend Function GetImportFlags2() As Long
   GetImportFlags2 = pdfGetImportFlags2(m_Instance)
End Function

Friend Function GetInBBox(ByVal PageNum As Long, ByVal Boundary As TPageBoundary, BBox As TPDFRect) As Boolean
   GetInBBox = pdfGetInBBox(m_Instance, PageNum, Boundary, BBox) <> 0
End Function

Friend Function GetInDocInfo(ByVal DInfo As TDocumentInfo, Value As String) As Boolean
   Dim BufSize As Long
   Dim pBuffer As Long
   BufSize = pdfGetInDocInfo(m_Instance, DInfo, pBuffer)
   If BufSize < 0 Then
      Value = ""
      Exit Function
   End If
   Value = ToStringW(pBuffer, BufSize)
   GetInDocInfo = True
End Function

Friend Function GetInDocInfoCount() As Long
   GetInDocInfoCount = pdfGetInDocInfoCount(m_Instance)
End Function

Friend Function GetInDocInfoEx(ByVal Index As Long, ByRef DInfo As TDocumentInfo, ByRef Key As String, ByRef Value As String) As Boolean
   Dim Info As Long
   Dim uni As Long
   Dim keyBuf As Long
   Dim KeyLen As Long
   Dim valBuf As Long
   Dim valLen As Long
   valLen = pdfGetInDocInfoEx(m_Instance, Index, Info, keyBuf, valBuf, uni)
   If valLen <= 0 Then
      Key = ""
      Value = ""
      Exit Function
   End If
   DInfo = Info
   Key = UTF8ToString(keyBuf)
   Value = ToString2(valBuf, valLen, uni <> 0)
   GetInDocInfoEx = True
End Function

Friend Function GetInEncryptionFlags() As Long
   GetInEncryptionFlags = pdfGetInEncryptionFlags(m_Instance)
End Function

Friend Function GetInEncryptionInfo(ByRef Info As TPDFEncryptInfo) As Boolean
   Info.StructSize = LenB(Info)
   GetInEncryptionInfo = pdfGetInEncryptionInfo(m_Instance, Info) <> 0
End Function

Friend Function GetInFieldCount() As Long
   GetInFieldCount = pdfGetInFieldCount(m_Instance)
End Function

Friend Function GetInIsCollection() As Boolean
   Dim retval As Long
   retval = pdfGetInIsCollection(m_Instance)
   If retval < 0 Then Exit Function
   GetInIsCollection = retval <> 0
End Function

Friend Function GetInIsEncrypted() As Boolean
   Dim retval As Long
   retval = pdfGetInIsEncrypted(m_Instance)
   If retval < 0 Then Exit Function
   GetInIsEncrypted = retval <> 0
End Function

Friend Function GetInIsSigned() As Boolean
   Dim retval As Long
   retval = pdfGetInIsSigned(m_Instance)
   If retval < 0 Then Exit Function
   GetInIsSigned = retval <> 0
End Function

Friend Function GetInIsTaggedPDF() As Long
   GetInIsTaggedPDF = pdfGetInIsTaggedPDF(m_Instance)
End Function

Friend Function GetInIsTrapped() As Boolean
   Dim retval As Long
   retval = pdfGetInIsTrapped(m_Instance)
   If retval < 0 Then Exit Function
   GetInIsTrapped = retval <> 0
End Function

Friend Function GetInIsXFAForm() As Boolean
   GetInIsXFAForm = pdfGetInIsXFAForm(m_Instance) <> 0
End Function

Friend Function GetInkList(ByVal List As Long, ByRef points() As Single) As Boolean
   Dim pts As Long, cnt As Long
   If pdfGetInkList(List, pts, cnt) <> 0 Then
      If cnt > 0 Then
         ReDim points(cnt - 1)
         pdfCopyMem2 pts, points(0), cnt * 4
      Else
         Erase points
      End If
      GetInkList = True
   Else
      Erase points
      GetInkList = False
   End If
End Function

Friend Function GetInMetadata(ByVal PageNum As Long, ByRef Buffer() As Byte) As Boolean
   Dim pbuf As Long
   Dim BufSize As Long
   If pdfGetInMetadata(m_Instance, PageNum, pbuf, BufSize) <> 0 Then
      If BufSize > 0 Then
         ReDim Buffer(BufSize - 1)
         pdfCopyMem2 pbuf, Buffer(0), BufSize
      Else
         Erase Buffer
      End If
      GetInMetadata = True
   Else
      Erase Buffer
      GetInMetadata = False
   End If
End Function

Friend Function GetInPageCount() As Long
   GetInPageCount = pdfGetInPageCount(m_Instance)
End Function

Friend Function GetInOrientation(ByVal PageNum As Long) As Long
   GetInOrientation = pdfGetInOrientation(m_Instance, PageNum)
End Function

Friend Function GetInPDFVersion() As Long
   GetInPDFVersion = pdfGetInPDFVersion(m_Instance)
End Function

Friend Function GetInPDFVersionEx(ByRef Value As TPDFVersionInfo) As Boolean
   Dim v As TPDFVersionInfo_I
   v.StructSize = LenB(v)
   If pdfGetInPDFVersionEx(m_Instance, v) > -1 Then
      Value.Major = v.Major
      Value.Minor = v.Minor
      Value.MainVer = ToStringA(v.MainVer)
      Value.SubVer = ToStringA(v.SubVer)
      Value.PDFAConformance = ToStringA(v.PDFAConformance)
      Value.PDFAVersion = v.PDFAVersion
      Value.PDFEVersion = ToStringA(v.PDFEVersion)
      Value.PDFVTModDate = ToStringA(v.PDFVTModDate)
      Value.PDFVTVersion = ToStringA(v.PDFVTVersion)
      Value.PDFXConformance = ToStringA(v.PDFXConformance)
      Value.PDFXVersion = ToStringA(v.PDFXVersion)
      Value.FXConfLevel = ToStringA(v.FXConfLevel)
      Value.FXDocName = ToStringA(v.FXDocName)
      Value.FXDocType = ToStringA(v.FXDocType)
      Value.FXVersion = ToStringA(v.FXVersion)
      Value.VersionConst = v.VersionConst

      GetInPDFVersionEx = True
   Else
      GetInPDFVersionEx = False
   End If
End Function

Friend Function GetInPrintSettings(ByRef Settings As TPDFPrintSettings) As Boolean
   Dim s As TPDFPrintSettings_I
   If pdfGetInPrintSettings(m_Instance, s) = 0 Then Exit Function
   Settings.DuplexMode = s.DuplexMode
   Settings.NumCopies = s.NumCopies
   Settings.PickTrayByPDFSize = s.PickTrayByPDFSize
   Settings.PrintScaling = s.PrintScaling
   If s.PrintRangesCount > 0 Then
      ReDim Settings.PrintRanges(s.PrintRangesCount * 2 - 1)
      pdfCopyMem2 s.PrintRanges, Settings.PrintRanges(0), s.PrintRangesCount * 2 * 4
   Else
      Erase Settings.PrintRanges
   End If
   GetInPrintSettings = True
End Function

Friend Function GetInRepairMode() As Boolean
   GetInRepairMode = pdfGetInRepairMode(m_Instance) <> 0
End Function

Friend Function GetInstancePtr() As Long
   GetInstancePtr = m_Instance
End Function

Friend Function GetIsFixedPitch() As Boolean
   GetIsFixedPitch = pdfGetIsFixedPitch(m_Instance) <> 0
End Function

Friend Function GetIsTaggingEnabled() As Boolean
   GetIsTaggingEnabled = pdfGetIsTaggingEnabled(m_Instance) <> 0
End Function

Friend Function GetItalicAngle() As Double
   GetItalicAngle = pdfGetItalicAngle(m_Instance)
End Function

Friend Function GetJavaScript(ByVal Handle As Long, Script As String) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   pBuffer = pdfGetJavaScript(m_Instance, Handle, BufSize, uni)
   If pBuffer = 0 Then
      Script = ""
      Exit Function
   End If
   Script = ToString2(pBuffer, BufSize, uni <> 0)
   GetJavaScript = True
End Function

Friend Function GetJavaScriptAction(ByVal Handle As Long, Script As String) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   pBuffer = pdfGetJavaScriptAction(m_Instance, Handle, BufSize, uni)
   If pBuffer = 0 Then
      Script = ""
      Exit Function
   End If
   Script = ToString2(pBuffer, BufSize, uni <> 0)
   GetJavaScriptAction = True
End Function

Friend Function GetJavaScriptAction2(ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByVal ActIndex As Long, Script As String, ByRef ObjEvent As TObjEvent) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   pBuffer = pdfGetJavaScriptAction2(m_Instance, ObjType, ObjHandle, ActIndex, BufSize, uni, ObjEvent)
   If pBuffer = 0 Then
      Script = ""
      Exit Function
   End If
   Script = ToString2(pBuffer, BufSize, uni <> 0)
   GetJavaScriptAction2 = True
End Function

Friend Function GetJavaScriptActionEx(ByVal Handle As Long, ByRef Action As TPDFJavaScriptAction) As Boolean
   Dim a As TPDFJavaScriptAction_I
   a.StructSize = LenB(a)
   GetJavaScriptActionEx = False
   If pdfGetJavaScriptActionEx(m_Instance, Handle, a) <> 0 Then
      Action.Script = ToStringEx(a.ScriptA, a.ScriptW, a.ScriptLen)
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      GetJavaScriptActionEx = True
   End If
End Function

Friend Function GetJavaScriptCount() As Long
   GetJavaScriptCount = pdfGetJavaScriptCount(m_Instance)
End Function

Friend Function GetJavaScriptEx(ByVal Name As String, Script As String) As Boolean
   Dim uni As Long
   Dim pBuffer As Long
   Dim BufSize As Long

   pBuffer = pdfGetJavaScriptEx(m_Instance, Name, BufSize, uni)
   If pBuffer = 0 Then
      Script = ""
      Exit Function
   End If
   Script = ToString2(pBuffer, BufSize, uni <> 0)
   GetJavaScriptEx = True
End Function

Friend Function GetJavaScriptName(ByVal Handle As Long) As String
   Dim uni As Long
   Dim BufSize As Long
   Dim pBuffer As Long
   pBuffer = pdfGetJavaScriptName(m_Instance, Handle, BufSize, uni)
   GetJavaScriptName = ToString2(pBuffer, BufSize, uni <> 0)
End Function

Friend Function GetJPEGQuality() As Long
   GetJPEGQuality = pdfGetJPEGQuality(m_Instance)
End Function

Friend Function GetLanguage() As String
   Dim ptr As Long
   ptr = pdfGetLanguage(m_Instance)
   GetLanguage = ToStringA(ptr)
End Function

Friend Function GetLastTextPosX() As Double
   GetLastTextPosX = pdfGetLastTextPosX(m_Instance)
End Function

Friend Function GetLastTextPosXAbs() As Double
   GetLastTextPosXAbs = pdfGetLastTextPosXAbs(m_Instance)
End Function

Friend Function GetLastTextPosY() As Double
   GetLastTextPosY = pdfGetLastTextPosY(m_Instance)
End Function

Friend Function GetLastTextPosYAbs() As Double
   GetLastTextPosYAbs = pdfGetLastTextPosYAbs(m_Instance)
End Function

Friend Function GetLayerConfig(ByVal Index As Long, ByRef Config As TPDFOCLayerConfig) As Boolean
   Dim cfg As TPDFOCLayerConfig_I
   cfg.StructSize = LenB(cfg)
   GetLayerConfig = pdfGetLayerConfig(m_Instance, Index, cfg) <> 0
   If GetLayerConfig Then
      Config.Intent = cfg.Intent
      Config.IsDefault = cfg.IsDefault <> 0
      Config.Name = ToStringEx(cfg.NameA, cfg.NameW, cfg.NameLen)
   End If
End Function

Friend Function GetLayerConfigCount() As Long
   GetLayerConfigCount = pdfGetLayerConfigCount(m_Instance)
End Function

Friend Function GetLaunchAction(ByVal Handle As Long, ByRef Action As TPDFLaunchAction) As Boolean
   Dim a As TPDFLaunchAction_I
   a.StructSize = LenB(a)
   GetLaunchAction = False
   If pdfGetLaunchAction(m_Instance, Handle, a) <> 0 Then
      Action.AppName = ToStringA(a.AppName)
      Action.DefDir = ToStringA(a.DefDir)
      Action.File = a.File
      Action.NewWindow = a.NewWindow
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      Action.Operation = ToStringA(a.Operation)
      Action.Parameter = ToStringA(a.Parameter)
      GetLaunchAction = True
   End If
End Function

Friend Function GetLeading() As Double
   GetLeading = pdfGetLeading(m_Instance)
End Function

Friend Function GetLineCapStyle() As TLineCapStyle
   GetLineCapStyle = pdfGetLineCapStyle(m_Instance)
End Function

Friend Function GetLineJoinStyle() As TLineJoinStyle
   GetLineJoinStyle = pdfGetLineJoinStyle(m_Instance)
End Function

Friend Function GetLineWidth() As Double
   GetLineWidth = pdfGetLineWidth(m_Instance)
End Function

Friend Function GetLinkHighlightMode() As THighlightMode
   GetLinkHighlightMode = pdfGetLinkHighlightMode(m_Instance)
End Function

Friend Function GetLogMetafileSize(ByVal FileName As String, ARect As TRectL) As Boolean
   GetLogMetafileSize = pdfGetLogMetafileSizeW(m_Instance, StrPtr(FileName), ARect) <> 0
End Function

Friend Function GetLogMetafileSizeW(ByVal FileName As String, ARect As TRectL) As Boolean
   GetLogMetafileSizeW = pdfGetLogMetafileSizeW(m_Instance, StrPtr(FileName), ARect) <> 0
End Function

Friend Function GetLogMetafileSizeEx(Buffer() As Byte, ARect As TRectL) As Boolean
   GetLogMetafileSizeEx = pdfGetLogMetafileSizeEx(m_Instance, Buffer(0), UBound(Buffer) + 1, ARect) <> 0
End Function

Friend Function GetMatrix(ByRef Matrix As TCTM) As Boolean
   GetMatrix = pdfGetMatrix(m_Instance, Matrix) <> 0
End Function

Friend Function GetMaxFieldLen(ByVal TxtField As Long) As Long
   GetMaxFieldLen = pdfGetMaxFieldLen(m_Instance, TxtField)
End Function

Friend Function GetMeasureObj(ByVal MeasurePtr As Long, ByRef Value As TPDFMeasure) As Boolean
   Dim m As TPDFMeasure_I
   m.StructSize = LenB(m)
   If pdfGetMeasureObj(MeasurePtr, m) = 0 Then
      GetMeasureObj = False
      Exit Function
   End If
   If m.IsRectilinear <> 0 Then
      Value.IsRectilinear = True
      Call CopyIntArray(m.Angles, Value.Angles, m.AnglesCount)
      Call CopyIntArray(m.Area, Value.Area, m.AreaCount)
      Value.CXY = m.CXY
      Call CopyIntArray(m.Distance, Value.Distance, m.DistanceCount)
      Value.OriginX = m.OriginX
      Value.OriginY = m.OriginY
      Value.r = ToStringEx(m.RA, m.RW)
      Call CopyIntArray(m.Slope, Value.Slope, m.SlopeCount)
      Call CopyIntArray(m.X, Value.X, m.XCount)
      Call CopyIntArray(m.Y, Value.Y, m.YCount)
   Else
      Call CopyFloatArray(m.Bounds, Value.Bounds, m.BoundCount)
      If m.DCS_IsSet <> 0 Then
         Value.DCS_IsSet = True
         Value.DCS_Projected = m.DCS_Projected <> 0
         Value.DCS_EPSG = m.DCS_EPSG
         Value.DCS_WKT = ToStringA(m.DCS_WKT)
      End If
      Value.GCS_Projected = m.GCS_Projected <> 0
      Value.GCS_EPSG = m.GCS_EPSG
      Value.GCS_WKT = ToStringA(m.GCS_WKT)
      Call CopyFloatArray(m.GPTS, Value.GPTS, m.GPTSCount)
      Call CopyFloatArray(m.LPTS, Value.LPTS, m.LPTSCount)
      Value.PDU1 = ToStringA(m.PDU1)
      Value.PDU2 = ToStringA(m.PDU2)
      Value.PDU3 = ToStringA(m.PDU3)
   End If
   GetMeasureObj = True
End Function

Friend Function GetMetaConvFlags() As Long
   GetMetaConvFlags = pdfGetMetaConvFlags(m_Instance)
End Function

Friend Function GetMetadata(ByVal ObjType As TMetadataObj, ByVal Handle As Long, ByRef Buffer() As Byte) As Boolean
   Dim pbuf As Long
   Dim BufSize As Long
   If pdfGetMetadata(m_Instance, ObjType, Handle, pbuf, BufSize) <> 0 Then
      If BufSize > 0 Then
         ReDim Buffer(BufSize - 1)
         pdfCopyMem2 pbuf, Buffer(0), BufSize
      Else
         Erase Buffer
      End If
      GetMetadata = True
   Else
      Erase Buffer
      GetMetadata = False
   End If
End Function

Friend Function GetMissingGlyphs(ByRef glyphs() As Long) As Long
   Dim ptr As Long, Count As Long
   ptr = pdfGetMissingGlyphs(m_Instance, Count)
   If ptr = 0 Then
      Erase glyphs
      Exit Function
   End If
   ReDim glyphs(Count - 1)
   Call pdfCopyMem2(ptr, glyphs(0), Count * 4)
   GetMissingGlyphs = Count
End Function

Friend Function GetMiterLimit() As Double
   GetMiterLimit = pdfGetMiterLimit(m_Instance)
End Function

Friend Function GetMovieAction(ByVal Handle As Long, ByRef Action As TPDFMovieAction) As Boolean
   Dim a As TPDFMovieAction_I
   a.StructSize = LenB(a)
   GetMovieAction = False
   If pdfGetMovieAction(m_Instance, Handle, a) <> 0 Then
      Action.Annot = a.Annot
      Action.FWPosition(0) = a.FWPosition(0)
      Action.FWPosition(1) = a.FWPosition(1)
      Action.FWScale(0) = a.FWScale(0)
      Action.FWScale(1) = a.FWScale(1)
      Action.Mode = ToStringA(a.Mode)
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      Action.Operation = ToStringA(a.Operation)
      Action.Rate = a.Rate
      Action.ShowControls = a.ShowControls <> 0
      Action.Synchronous = a.Synchronous <> 0
      Action.Title = ToStringEx(a.TitleA, a.TitleW)
      Action.Volume = a.Volume
      GetMovieAction = True
   End If
End Function

Friend Function GetNamedAction(ByVal Handle As Long, ByRef Action As TPDFNamedAction) As Boolean
   Dim a As TPDFNamedAction_I
   a.StructSize = LenB(a)
   GetNamedAction = False
   If pdfGetNamedAction(m_Instance, Handle, a) <> 0 Then
      Action.Name = ToStringA(a.Name)
      Action.NewWindow = a.NewWindow
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      Action.Type = a.Type
      GetNamedAction = True
   End If
End Function

Friend Function GetNamedDest(ByVal Index As Long, ByRef Dest As TPDFNamedDest) As Boolean
   Dim d As TPDFNamedDest_I
   d.StructSize = LenB(d)
   If pdfGetNamedDest(m_Instance, Index, d) = 0 Then Exit Function
   Dest.Name = ToStringEx(d.NameA, d.NameW, d.NameLen)
   Dest.DestFile = ToStringEx(d.DestFileA, d.DestFileW, d.DestFileLen)
   Dest.DestPage = d.DestPage
   Dest.DestPos = d.DestPos
   Dest.DestType = d.DestType
   GetNamedDest = True
End Function

Friend Function GetNamedDestCount() As Long
   GetNamedDestCount = pdfGetNamedDestCount(m_Instance)
End Function

Friend Function GetNeedAppearance() As Boolean
   GetNeedAppearance = pdfGetNeedAppearance(m_Instance) <> 0
End Function

Friend Function GetNumberFormatObj(ByVal NumFmtPtr As Long, ByRef Value As TPDFNumberFormat) As Boolean
   Dim nf As TPDFNumberFormat_I
   nf.StructSize = LenB(nf)
   GetNumberFormatObj = False
   If pdfGetNumberFormatObj(NumFmtPtr, nf) = 0 Then Exit Function
   Value.C = nf.C
   Value.d = nf.d
   Value.f = nf.f
   Value.FD = nf.FD <> 0
   Value.O = nf.O
   Value.PS = ToStringEx(nf.PSA, nf.PSW)
   Value.RD = ToStringEx(nf.RDA, nf.RDW)
   Value.RT = ToStringEx(nf.RTA, nf.RTW)
   Value.SS = ToStringEx(nf.SSA, nf.SSW)
   Value.U = ToStringEx(nf.UA, nf.UW)
   GetNumberFormatObj = True
End Function

Friend Function GetObjActionCount(ByVal ObjType As TObjType, ByVal ObjHandle As Long) As Long
   GetObjActionCount = pdfGetObjActionCount(m_Instance, ObjType, ObjHandle)
End Function

Friend Function GetObjActions(ByVal ObjType As TObjType, ByVal ObjHandle As Long, ByRef Actions As TPDFObjActions) As Long
   Actions.StructSize = LenB(Actions)
   GetObjActions = pdfGetObjActions(m_Instance, ObjType, ObjHandle, Actions)
End Function

Friend Function GetObjEvent(ByVal IEvent As Long, ByRef ObjEvent As TPDFObjEvent) As Boolean
   ObjEvent.StructSize = LenB(ObjEvent)
   GetObjEvent = pdfGetObjEvent(IEvent, ObjEvent) <> 0
End Function

Friend Function GetOCG(ByVal Handle As Long, ByRef Value As TPDFOCG) As Boolean
   Dim tmp As TPDFOCG_I
   tmp.StructSize = LenB(tmp)
   If pdfGetOCG(m_Instance, Handle, tmp) <> 0 Then
      Value.AppEvents = tmp.AppEvents
      Value.Categories = tmp.Categories
      Value.Handle = tmp.Handle
      Value.HaveContUsage = tmp.HaveContUsage <> 0
      Value.Intent = tmp.Intent
      Value.Name = ToStringEx(tmp.NameA, tmp.NameW)
      GetOCG = True
   Else
      GetOCG = False
   End If
End Function

Friend Function GetOCGContUsage(ByVal Handle As Long, ByRef Value As TPDFOCGContUsage) As Boolean
   Dim tmp As TPDFOCGContUsage_I
   tmp.StructSize = LenB(tmp)
   If pdfGetOCGContUsage(m_Instance, Handle, tmp) <> 0 Then
      Value.ExportState = tmp.ExportState
      Value.InfoCreator = ToStringEx(tmp.InfoCreatorA, tmp.InfoCreatorW)
      Value.InfoSubtype = ToStringA(tmp.InfoSubtype)
      Value.LangPreferred = tmp.LangPreferred
      Value.Language = ToStringEx(tmp.LanguageA, tmp.LanguageW)
      Value.PageElement = tmp.PageElement
      Value.PrintState = tmp.PrintState
      Value.PrintSubtype = ToStringA(tmp.PrintSubtype)
      Value.UserNamesCount = tmp.UserNamesCount
      Value.UserType = tmp.UserType
      Value.ViewState = tmp.ViewState
      Value.ZoomMax = tmp.ZoomMax
      Value.ZoomMin = tmp.ZoomMin
      GetOCGContUsage = True
   Else
      GetOCGContUsage = False
   End If
End Function

Friend Function GetOCGCount() As Long
   GetOCGCount = pdfGetOCGCount(m_Instance)
End Function

Friend Function GetOCGUsageUserName(ByVal Handle As Long, ByVal Index As Long, ByRef Name As String) As Boolean
   Dim nmeA As Long, nmeW As Long
   If pdfGetOCGUsageUserName(m_Instance, Handle, Index, nmeA, nmeW) <> 0 Then
      Name = ToStringEx(nmeA, nmeW)
      GetOCGUsageUserName = True
   Else
      Name = vbNullString
      GetOCGUsageUserName = False
   End If
End Function

Friend Function GetOCHandle(ByVal OC As Long) As Long
   GetOCHandle = pdfGetOCHandle(OC)
End Function

Friend Function GetOCUINode(ByVal Node As Long, ByRef OutNode As TPDFOCUINode) As Boolean
   Dim n As TPDFOCUINode_I
   n.StructSize = LenB(n)
   GetOCUINode = pdfGetOCUINode(m_Instance, Node, n) <> 0
   If GetOCUINode Then
      OutNode.Label = ToStringEx(n.LabelA, n.LabelW, n.LabelLength)
      OutNode.NewNode = n.NewNode <> 0
      OutNode.NextChild = n.NextChild
      OutNode.OCG = n.OCG
   End If
End Function

Friend Function GetOpacity() As Double
   GetOpacity = pdfGetOpacity(m_Instance)
End Function

Friend Function GetOrientation() As Long
   GetOrientation = pdfGetOrientation(m_Instance)
End Function

Friend Sub GetOptimizeParams(ByRef Parms As TOptimizeParams, ByRef Value As TOptimizeParams_I, Optional IncludeCSArray = False)
   Value.StructSize = LenB(Value)
   
   If Not IsArrayEmpty(Parms.ExcludeCS) Then
      Value.ExcludeCS = VarPtr(Parms.ExcludeCS(0))
      Value.ExcludeCSCount = UBound(Parms.ExcludeCS) + 1
      If IncludeCSArray Then Value.ExcludeCSCount = -Value.ExcludeCSCount
   End If

   Value.Filter1Bit = Parms.Filter1Bit
   Value.FilterColor = Parms.FilterColor
   Value.FilterGray = Parms.FilterGray
   Value.Flags2 = Parms.Flags2
   Value.Flags3 = Parms.Flags3
   Value.Flags4 = Parms.Flags4
   Value.JP2KQuality = Parms.JP2KQuality
   Value.JPEGQuality = Parms.JPEGQuality
   Value.Min1BitRes = Parms.Min1BitRes
   Value.MinColorRes = Parms.MinColorRes
   Value.MinGrayRes = Parms.MinGrayRes
   Value.MinLineWidth = Parms.MinLineWidth
   Value.Res1BitImages = Parms.Res1BitImages
   Value.ResColorImages = Parms.ResColorImages
   Value.ResGrayImages = Parms.ResGrayImages
End Sub

Friend Function GetOutputIntent(ByVal Index As Long, ByRef Intent As TPDFOutputIntent) As Boolean
   Dim retval As TPDFOutputIntent_I
   retval.StructSize = LenB(retval)
   If pdfGetOutputIntent(m_Instance, Index, retval) = 0 Then Exit Function
   GetIntOutputIntent retval, Intent
   GetOutputIntent = True
End Function

Friend Function GetOutputIntentCount() As Long
   GetOutputIntentCount = pdfGetOutputIntentCount(m_Instance)
End Function

Friend Function GetPageAnnot(ByVal Index As Long, ByRef Annot As TPDFAnnotation) As Boolean
   Dim retval As TPDFAnnotation_I
   If pdfGetPageAnnot(m_Instance, Index, retval) = 0 Then Exit Function
   GetIntAnnot retval, Annot
   GetPageAnnot = True
End Function

Friend Function GetPageAnnotCount() As Long
   GetPageAnnotCount = pdfGetPageAnnotCount(m_Instance)
End Function

Friend Function GetPageAnnotEx(ByVal Index As Long, ByRef Annot As TPDFAnnotationEx) As Boolean
   Dim retval As TPDFAnnotationEx_I
   If pdfGetPageAnnotEx(m_Instance, Index, retval) = 0 Then Exit Function
   GetIntAnnotEx retval, Annot
   GetPageAnnotEx = True
End Function

Friend Function GetPageBBox(ByVal PagePtr As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TFltRect) As Boolean
   GetPageBBox = pdfGetPageBBox(PagePtr, Boundary, BBox) <> 0
End Function

Friend Function GetPageCoords() As Long
   GetPageCoords = pdfGetPageCoords(m_Instance)
End Function

Friend Function GetPageCount() As Long
   GetPageCount = pdfGetPageCount(m_Instance)
End Function

Friend Function GetPageField(ByVal Index As Long, Field As TPDFField) As Boolean
   If pdfGetPageField(m_Instance, Index, FField) = 0 Then Exit Function
   GetIntField Field
   GetPageField = True
End Function

Friend Function GetPageFieldCount() As Long
   GetPageFieldCount = pdfGetPageFieldCount(m_Instance)
End Function

Friend Function GetPageFieldEx(ByVal Index As Long, ByRef Field As TPDFFieldEx) As Boolean
   Dim f As TPDFFieldEx_I
   f.StructSize = LenB(f)
   If pdfGetPageFieldEx(m_Instance, Index, f) = 0 Then Exit Function
   GetIntFieldEx f, Field
   GetPageFieldEx = True
End Function

Friend Function GetPageHeight() As Double
   GetPageHeight = pdfGetPageHeight(m_Instance)
End Function

Friend Function GetPageLabel(ByVal Index As Long, ByRef Lbl As TPDFPageLabel) As Boolean
   Dim pLabel As TPDFPageLabel_I
   If pdfGetPageLabel(m_Instance, Index, pLabel) = 0 Then Exit Function
   Lbl.FirstPageNum = pLabel.FirstPageNum
   Lbl.Format = pLabel.Format
   Lbl.StartRange = pLabel.StartRange
   Lbl.Prefix = ToString2(pLabel.Prefix, pLabel.PrefixLen, pLabel.PrefixUni <> 0)
   GetPageLabel = True
End Function
 
Friend Function GetPageLabelCount() As Long
   GetPageLabelCount = pdfGetPageLabelCount(m_Instance)
End Function

Friend Function GetPageLayout() As Long
   GetPageLayout = pdfGetPageLayout(m_Instance)
End Function

Friend Function GetPageMode() As Long
   GetPageMode = pdfGetPageMode(m_Instance)
End Function

Friend Function GetPageNum() As Long
   GetPageNum = pdfGetPageNum(m_Instance)
End Function

Friend Function GetPageObject(ByVal PageNum As Long) As Long
   GetPageObject = pdfGetPageObject(m_Instance, PageNum)
End Function

Friend Function GetPageOrientation(ByVal PagePtr As Long) As Long
   GetPageOrientation = pdfGetPageOrientation(PagePtr)
End Function

Friend Function GetPageText(Stack As TPDFStack) As Boolean
   FStack.ConvColors = Stack.ConvColors
   FStack.DestSpace = Stack.DestSpace
   GetPageText = pdfGetPageText(m_Instance, FStack) <> 0
   Stack.ctm = FStack.ctm
   Stack.tm = FStack.tm
   Stack.X = FStack.X
   Stack.Y = FStack.Y
   Stack.FontSize = FStack.FontSize
   Stack.CharSP = FStack.CharSP
   Stack.WordSP = FStack.WordSP
   Stack.HScale = FStack.HScale
   Stack.TextRise = FStack.TextRise
   Stack.Leading = FStack.Leading
   Stack.LineWidth = FStack.LineWidth
   Stack.DrawMode = FStack.DrawMode
   Stack.FillCS = FStack.FillCS
   Stack.FillColor = FStack.FillColor
   Stack.StrokeCS = FStack.StrokeCS
   Stack.StrokeColor = FStack.StrokeColor
   Stack.TextWidth = FStack.TextWidth
   Stack.SpaceWidth = FStack.SpaceWidth
   Stack.IFont = FStack.IFont
   Stack.Embedded = FStack.Embedded <> 0
   Stack.FontFlags = FStack.FontFlags
   If FStack.TextLen > 0 Then
      Dim i As Long
      Dim Kerning() As TTextRecordW_I
      ReDim Kerning(FStack.KerningCount - 1)
      ReDim Stack.RawKern(FStack.KerningCount - 1)
      ReDim Stack.Kerning(FStack.KerningCount - 1)

      Stack.text = ToStringA(FStack.text, FStack.TextLen)
      Call pdfCopyMem2(FStack.RawKern, Stack.RawKern(0), FStack.KerningCount * 12)
      Call pdfCopyMem2(FStack.Kerning, Kerning(0), FStack.KerningCount * 16)
      For i = 0 To FStack.KerningCount - 1
         Stack.Kerning(i).Advance = Kerning(i).Advance
         Stack.Kerning(i).Width = Kerning(i).Width
         Stack.Kerning(i).text = ToStringW(Kerning(i).text, Kerning(i).Length)
      Next i
   Else
      Stack.text = ""
      Erase Stack.RawKern
      Erase Stack.Kerning
   End If
End Function

Friend Function GetPageWidth() As Double
   GetPageWidth = pdfGetPageWidth(m_Instance)
End Function

Friend Function GetPDFVersion() As Long
   GetPDFVersion = pdfGetPDFVersion(m_Instance)
End Function

Friend Function GetPDFVersionEx(ByRef Value As TPDFVersionInfo) As Boolean
   Dim v As TPDFVersionInfo_I
   v.StructSize = LenB(v)
   If pdfGetPDFVersionEx(m_Instance, v) <> 0 Then
      Value.Major = v.Major
      Value.Minor = v.Minor
      Value.MainVer = ToStringA(v.MainVer)
      Value.SubVer = ToStringA(v.SubVer)
      Value.PDFAConformance = ToStringA(v.PDFAConformance)
      Value.PDFAVersion = v.PDFAVersion
      Value.PDFEVersion = ToStringA(v.PDFEVersion)
      Value.PDFVTModDate = ToStringA(v.PDFVTModDate)
      Value.PDFVTVersion = ToStringA(v.PDFVTVersion)
      Value.PDFXConformance = ToStringA(v.PDFXConformance)
      Value.PDFXVersion = ToStringA(v.PDFXVersion)
      Value.FXConfLevel = ToStringA(v.FXConfLevel)
      Value.FXDocName = ToStringA(v.FXDocName)
      Value.FXDocType = ToStringA(v.FXDocType)
      Value.FXVersion = ToStringA(v.FXVersion)
      Value.VersionConst = v.VersionConst

      GetPDFVersionEx = True
   Else
      GetPDFVersionEx = False
   End If
End Function

Friend Function GetPrintSettings(ByRef Settings As TPDFPrintSettings) As Boolean
   Dim s As TPDFPrintSettings_I
   If pdfGetPrintSettings(m_Instance, s) = 0 Then Exit Function
   Settings.DuplexMode = s.DuplexMode
   Settings.NumCopies = s.NumCopies
   Settings.PickTrayByPDFSize = s.PickTrayByPDFSize
   Settings.PrintScaling = s.PrintScaling
   If s.PrintRangesCount > 0 Then
      ReDim Settings.PrintRanges(s.PrintRangesCount * 2 - 1)
      pdfCopyMem2 s.PrintRanges, Settings.PrintRanges(0), s.PrintRangesCount * 2 * 4
   Else
      Erase Settings.PrintRanges
   End If
   GetPrintSettings = True
End Function

Friend Function GetPtDataArray(ByVal PtData As Long, ByVal Index As Long, ByRef DataType As String, ByRef values() As Single) As Boolean
   Dim dtype As Long, val As Long, valCount As Long
   DataType = vbNullString
   Erase values
   GetPtDataArray = False
   If pdfGetPtDataArray(PtData, Index, dtype, val, valCount) = 0 Then Exit Function
   If valCount < 2 Then Exit Function
   DataType = ToStringA(dtype)
   ReDim values(valCount - 1)
   Call pdfCopyMem2(val, values(0), valCount * 4)
   GetPtDataArray = True
End Function

Friend Function GetPtDataObj(ByVal PtData As Long, ByRef Subtype As String, ByRef NumArrays As Long) As Boolean
   Dim st As Long
   Subtype = vbNullString
   NumArrays = 0
   GetPtDataObj = False
   If pdfGetPtDataObj(PtData, st, NumArrays) = 0 Then Exit Function
   Subtype = ToStringA(st)
   GetPtDataObj = True
End Function

Friend Function GetRelFileNode(IRF As Long, ByRef f As TPDFRelFileNode, ByVal Decompress As Boolean) As Boolean
   Dim Node As TPDFRelFileNode_I
   Node.StructSize = LenB(Node)
   GetRelFileNode = False
   If pdfGetRelFileNode(IRF, Node, Decompress) <> 0 Then
      CopyFileSpecEx Node.EF, f.EF
      f.Name = ToStringEx(Node.NameA, Node.NameW)
      f.NextNode = Node.NextNode
      GetRelFileNode = True
   End If
End Function

Friend Function GetResetAction(ByVal Handle As Long, ByRef Value As TPDFResetFormAction) As Boolean
   Dim v As TPDFResetFormAction_I
   v.StructSize = LenB(v)
   If pdfGetResetAction(m_Instance, Handle, v) <> 0 Then
      If v.FieldsCount > 0 Then
         ReDim Value.Fields(v.FieldsCount - 1)
         pdfCopyMem2 v.Fields, Value.Fields(0), v.FieldsCount * 4
      Else
         Erase Value.Fields
      End If
      Value.Include = v.Include <> 0
      Value.NextAction = v.NextAction
      Value.NextActionType = v.NextActionType
      GetResetAction = True
   Else
      GetResetAction = False
   End If
End Function

Friend Function GetResolution() As Long
   GetResolution = pdfGetResolution(m_Instance)
End Function

Friend Function GetSaveNewImageFormat() As Boolean
   GetSaveNewImageFormat = pdfGetSaveNewImageFormat(m_Instance) <> 0
End Function

Friend Function GetSigDict(ByVal ISignature As Long, ByRef SigDict As TPDFSigDict) As Boolean
   Dim sd As TPDFSigDict_I
   sd.StructSize = LenB(sd)
   If pdfGetSigDict(ISignature, sd) = 0 Then Exit Function
   GetIntSigDict sd, SigDict
   GetSigDict = True
End Function

Friend Function GetStrokeColor() As Long
   GetStrokeColor = pdfGetStrokeColor(m_Instance)
End Function

Friend Function GetSubmitAction(ByVal Handle As Long, ByRef Value As TPDFSubmitFormAction) As Boolean
   Dim v As TPDFSubmitFormAction_I
   v.StructSize = LenB(v)
   If pdfGetSubmitAction(m_Instance, Handle, v) <> 0 Then
      Value.CharSet = ToStringA(v.CharSet)
      If v.FieldsCount > 0 Then
         ReDim Value.Fields(v.FieldsCount - 1)
         pdfCopyMem2 v.Fields, Value.Fields(0), v.FieldsCount * 4
      Else
         Erase Value.Fields
      End If
      Value.Flags = v.Flags
      Value.URL = ToStringA(v.URL)
      Value.NextAction = v.NextAction
      Value.NextActionType = v.NextActionType
      GetSubmitAction = True
   Else
      GetSubmitAction = False
   End If
End Function

Friend Function GetSysFontInfo(ByVal Handle As Long, ByRef Value As TPDFSysFont) As Long
   Dim retval As Long
   Dim f As TPDFSysFont_I
   f.StructSize = LenB(f)
   retval = pdfGetSysFontInfo(m_Instance, Handle, f)
   GetSysFontInfo = retval
   If retval < 0 Then Exit Function
   If retval = 0 Then
      If f.FamilyName = 0 Then
         Dim tmp As TPDFSysFont
         Value = tmp
         Exit Function
      End If
   End If
   Value.BaseType = f.BaseType
   Value.CIDOrdering = ToStringA(f.CIDOrdering)
   Value.CIDRegistry = ToStringA(f.CIDRegistry)
   Value.CIDSupplement = f.CIDSupplement
   Value.DataOffset = f.DataOffset
   Value.FamilyName = ToStringW(f.FamilyName)
   Value.FilePath = ToStringEx(f.FilePathA, f.FilePathW)
   Value.FileSize = f.FileSize
   Value.Flags = f.Flags
   Value.FullName = ToStringW(f.FullName)
   Value.Index = f.Index
   Value.IsFixedPitch = f.IsFixedPitch <> 0
   Value.Length1 = f.Length1
   Value.Length2 = f.Length2
   Value.PostScriptName = ToStringEx(f.PostScriptNameA, f.PostScriptNameW)
   Value.Style = f.Style
   Value.UnicodeRange1 = f.UnicodeRange1
   Value.UnicodeRange2 = f.UnicodeRange2
   Value.UnicodeRange3 = f.UnicodeRange3
   Value.UnicodeRange4 = f.UnicodeRange4
End Function

Friend Function GetTabLen() As Long
   GetTabLen = pdfGetTabLen(m_Instance)
End Function

Friend Function GetTemplCount() As Long
   GetTemplCount = pdfGetTemplCount(m_Instance)
End Function

Friend Function GetTemplHandle() As Long
   GetTemplHandle = pdfGetTemplHandle(m_Instance)
End Function

Friend Function GetTemplHeight(ByVal Handle As Long) As Double
   GetTemplHeight = pdfGetTemplHeight(m_Instance, Handle)
End Function

Friend Function GetTemplWidth(ByVal Handle As Long) As Double
   GetTemplWidth = pdfGetTemplWidth(m_Instance, Handle)
End Function

Friend Function GetTextBBox(ByVal text As String, ByRef BBox As TBBox) As Boolean
   GetTextBBox = pdfGetTextBBoxW(m_Instance, StrPtr(text), Len(text), BBox)
End Function

Friend Function GetTextDrawMode() As TDrawMode
   GetTextDrawMode = pdfGetTextDrawMode(m_Instance)
End Function

Friend Function GetTextFieldValue(ByVal AField As Long, ByRef Value As String, ByRef DefValue As String) As Boolean
   Dim valUni As Long
   Dim defValUni As Long
   Dim val As Long
   Dim defVal As Long
   If pdfGetTextFieldValue(m_Instance, AField, val, valUni, defVal, defValUni) = 0 Then
      Value = ""
      DefValue = ""
      Exit Function
   End If
   Value = ToString2(val, , valUni <> 0)
   DefValue = ToString2(defVal, , defValUni <> 0)
   GetTextFieldValue = True
End Function

Friend Function GetTextRect(PosX As Double, PosY As Double, Width As Double, Height As Double) As Boolean
   GetTextRect = pdfGetTextRect(m_Instance, PosX, PosY, Width, Height) <> 0
End Function

Friend Function GetTextRise() As Double
   GetTextRise = pdfGetTextRise(m_Instance)
End Function

Friend Function GetTextScaling() As Double
   GetTextScaling = pdfGetTextScaling(m_Instance)
End Function

Friend Function GetTextWidth2(ByVal IFont As Long, ByVal text As Long, ByVal sLen As Long, ByVal CharSpacing As Single, ByVal WordSpacing As Single, ByVal TextScale As Single) As Double
   GetTextWidth2 = fntGetTextWidth(IFont, text, sLen, CharSpacing, WordSpacing, TextScale)
End Function

Friend Function GetTextWidth(ByVal AText As String) As Double
   GetTextWidth = pdfGetTextWidthW(m_Instance, StrPtr(AText))
End Function

Friend Function GetTextWidthA(ByVal AText As String) As Double
   GetTextWidthA = pdfGetTextWidthA(m_Instance, AText)
End Function

Friend Function GetTextWidthW(ByVal AText As String) As Double
   GetTextWidthW = pdfGetTextWidthW(m_Instance, StrPtr(AText))
End Function

Friend Function GetTextWidthEx(ByVal AText As String, ByVal sLen As Long) As Double
   Dim s As String
   s = Mid(AText, 1, sLen)
   GetTextWidthEx = pdfGetTextWidthExW(m_Instance, StrPtr(s), Len(s))
End Function

Friend Function GetTextWidthExA(ByVal AText As String, ByVal sLen As Long) As Double
   GetTextWidthExA = pdfGetTextWidthExA(m_Instance, AText, sLen)
End Function

Friend Function GetTextWidthExW(ByVal AText As String, ByVal sLen As Long) As Double
   GetTextWidthExW = pdfGetTextWidthExW(m_Instance, StrPtr(AText), Len(AText))
End Function

Friend Function GetTransparentColor() As Long
   GetTransparentColor = pdfGetTransparentColor(m_Instance)
End Function

Friend Function GetTrapped() As Boolean
   GetTrapped = pdfGetTrapped(m_Instance) <> 0
End Function

Friend Function GetTypoLeading() As Double
   GetTypoLeading = pdfGetTypoLeading(m_Instance)
End Function

Friend Function GetURIAction(ByVal Handle As Long, ByRef Action As TPDFURIAction) As Boolean
   Dim a As TPDFURIAction_I
   a.StructSize = LenB(a)
   GetURIAction = False
   If pdfGetURIAction(m_Instance, Handle, a) <> 0 Then
      Action.BaseURL = ToStringA(a.BaseURL)
      Action.IsMap = a.IsMap <> 0
      Action.NextAction = a.NextAction
      Action.NextActionType = a.NextActionType
      Action.URI = ToStringA(a.URI)
      GetURIAction = True
   End If
End Function

Friend Function GetUseExactPwd() As Boolean
   GetUseExactPwd = pdfGetUseExactPwd(m_Instance) <> 0
End Function

Friend Function GetUseGlobalImpFiles() As Boolean
   GetUseGlobalImpFiles = pdfGetUseGlobalImpFiles(m_Instance) <> 0
End Function

Friend Function GetUserRights() As Long
   GetUserRights = pdfGetUserRights(m_Instance)
End Function

Friend Function GetUserUnit() As Single
   GetUserUnit = pdfGetUserUnit(m_Instance)
End Function

Friend Function GetUseStdFonts() As Boolean
   GetUseStdFonts = pdfGetUseStdFonts(m_Instance) <> 0
End Function

Friend Function GetUseSystemFonts() As Boolean
   GetUseSystemFonts = pdfGetUseSystemFonts(m_Instance) <> 0
End Function

Friend Function GetUsesTransparency(ByVal PageNum As Long) As Long
   GetUsesTransparency = pdfGetUsesTransparency(m_Instance, PageNum)
End Function

Friend Function GetUseTransparency() As Boolean
   GetUseTransparency = pdfGetUseTransparency(m_Instance) <> 0
End Function

Friend Function GetUseVisibleCoords() As Boolean
   GetUseVisibleCoords = pdfGetUseVisibleCoords(m_Instance) <> 0
End Function

Friend Function GetViewerPreferences(Preference As Long, AddVal As Long) As Boolean
   GetViewerPreferences = pdfGetViewerPreferences(m_Instance, Preference, AddVal) <> 0
End Function

Friend Function GetViewport(ByVal PageNum As Long, ByVal Index As Long, ByRef Value As TPDFViewport) As Boolean
   Dim vp As TPDFViewport_I
   vp.StructSize = LenB(vp)
   GetViewport = False
   If pdfGetViewport(m_Instance, PageNum, Index, vp) = 0 Then Exit Function
   Value.BBox = vp.BBox
   Value.Measure = vp.Measure
   Value.Name = ToStringEx(vp.NameA, vp.NameW)
   Value.PtData = vp.PtData
End Function

Friend Function GetViewportCount(ByVal PageNum As Long) As Long
   GetViewportCount = pdfGetViewportCount(m_Instance, PageNum)
End Function

Friend Function GetWidthHeight(ByVal PagePtr As Long, ByVal Flags As TRasterFlags, ByRef Width As Single, ByRef Height As Single, ByVal Rotate As Long, ByRef BBox As TFltRect) As Boolean
   Dim v As Long
   If rasGetWidthHeight(PagePtr, Flags, Width, Height, Rotate, v) <> 0 Then
      Call pdfCopyMem2(v, BBox, LenB(BBox))
      GetWidthHeight = True
   Else
      GetWidthHeight = False
   End If
End Function

Friend Function GetWMFDefExtent(Width As Long, Height As Long) As Boolean
   GetWMFDefExtent = pdfGetWMFDefExtent(m_Instance, Width, Height) <> 0
End Function

Friend Function GetWMFPixelPerInch() As Long
   GetWMFPixelPerInch = pdfGetWMFPixelPerInch(m_Instance)
End Function

Friend Function GetWordSpacing() As Double
   GetWordSpacing = pdfGetWordSpacing(m_Instance)
End Function

Friend Function GetXFAStream(ByVal Index As Long, ByRef out As TPDFXFAStream) As Boolean
   Dim strm As TPDFXFAStream_I
   Erase out.Buffer
   If pdfGetXFAStream(m_Instance, Index, VarPtr(strm)) <> 0 Then
      ReDim out.Buffer(strm.BufSize - 1)
      Call pdfCopyMem2(strm.Buffer, out.Buffer(0), strm.BufSize)
      out.Name = ToStringEx(strm.NameA, strm.NameW)
      GetXFAStream = True
   Else
      out.Name = ""
      GetXFAStream = False
   End If
End Function

Friend Function GetXFAStreamCount() As Long
   GetXFAStreamCount = pdfGetXFAStreamCount(m_Instance)
End Function

Friend Function HaveDPartRoot() As Boolean
   HaveDPartRoot = pdfHaveDPartRoot(m_Instance) <> 0
End Function

Friend Function HaveOpenDoc() As Boolean
   HaveOpenDoc = pdfHaveOpenDoc(m_Instance) <> 0
End Function

Friend Function HaveOpenPage() As Boolean
   HaveOpenPage = pdfHaveOpenPage(m_Instance) <> 0
End Function

Friend Function HighlightAnnot(ByVal Subtype As TAnnotType, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   HighlightAnnot = pdfHighlightAnnotW(m_Instance, Subtype, PosX, PosY, Width, Height, Color, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function HighlightAnnotA(ByVal Subtype As TAnnotType, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   HighlightAnnotA = pdfHighlightAnnotA(m_Instance, Subtype, PosX, PosY, Width, Height, Color, Author, Subject, Comment)
End Function

Friend Function HighlightAnnotW(ByVal Subtype As TAnnotType, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Color As Long, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   HighlightAnnotW = pdfHighlightAnnotW(m_Instance, Subtype, PosX, PosY, Width, Height, Color, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function ImportBookmarks() As Long
   ImportBookmarks = pdfImportBookmarks(m_Instance)
End Function

Friend Function ImportCatalogObjects() As Boolean
   ImportCatalogObjects = pdfImportCatalogObjects(m_Instance) <> 0
End Function

Friend Function ImportDocInfo() As Boolean
   ImportDocInfo = pdfImportDocInfo(m_Instance) <> 0
End Function

Friend Function ImportEncryptionSettings() As Boolean
   ImportEncryptionSettings = pdfImportEncryptionSettings(m_Instance) <> 0
End Function

Friend Function ImportOCProperties() As Boolean
   ImportOCProperties = pdfImportOCProperties(m_Instance)
End Function

Friend Function ImportPage(ByVal PageNum As Long) As Long
   ImportPage = pdfImportPage(m_Instance, PageNum)
End Function

Friend Function ImportPageEx(ByVal PageNum As Long, ByVal ScaleX As Double, ByVal ScaleY As Double) As Long
   ImportPageEx = pdfImportPageEx(m_Instance, PageNum, ScaleX, ScaleY)
End Function

Friend Function ImportPDFFile(ByVal DestPage As Long, ByVal ScaleX As Double, ByVal ScaleY As Double) As Long
   ImportPDFFile = pdfImportPDFFile(m_Instance, DestPage, ScaleX, ScaleY)
End Function

Friend Function InitBarcode2(ByRef Barcode As TPDFBarcode2) As Boolean
   Barcode.StructSize = LenB(Barcode)
   InitBarcode2 = pdfInitBarcode2(Barcode) <> 0
End Function

Friend Function InitColorManagement(ByRef Profiles As TPDFColorProfiles, ByVal DestSpace As TPDFColorSpace, ByVal Flags As TPDFInitCMFlags) As Boolean
   InitColorManagement = pdfInitColorManagement(m_Instance, Profiles, DestSpace, Flags) <> 0
End Function

Friend Function InitColorManagementEx(ByRef Profiles As TPDFColorProfilesEx, ByVal DestSpace As TPDFColorSpace, ByVal Flags As TPDFInitCMFlags) As Boolean
   InitColorManagementEx = pdfInitColorManagementEx(m_Instance, Profiles, DestSpace, Flags) <> 0
End Function

Friend Function InitExtGState(ByRef GS As TPDFExtGState) As Boolean
   InitExtGState = pdfInitExtGState(GS) <> 0
End Function

Friend Function InitOCGContUsage(ByRef Value As TPDFOCGContUsage) As Boolean
   Dim tmp As TPDFOCGContUsage_I
   tmp.StructSize = LenB(tmp)
   If pdfInitOCGContUsage(tmp) <> 0 Then
      Value.ExportState = tmp.ExportState
      Value.InfoCreator = vbNullString
      Value.InfoSubtype = vbNullString
      Value.LangPreferred = tmp.LangPreferred
      Value.Language = vbNullString
      Value.PageElement = tmp.PageElement
      Value.PrintState = tmp.PrintState
      Value.PrintSubtype = vbNullString
      Value.UserNamesCount = tmp.UserNamesCount
      Value.UserType = tmp.UserType
      Value.ViewState = tmp.ViewState
      Value.ZoomMax = tmp.ZoomMax
      Value.ZoomMin = tmp.ZoomMin
      InitOCGContUsage = True
   Else
      InitOCGContUsage = False
   End If
End Function

Friend Function InitHeaderFooter(ByRef Value As TPDFHeaderFooter, ByRef HFArray() As TPDFHdrFtr) As Boolean
   Dim val As TPDFHeaderFooter_I
   Dim hf() As TPDFHdrFtr_I

   ReDim hf(UBound(HFArray))
   
   val.StructSize = LenB(val)
   
   If pdfInitHeaderFooter(val, VarPtr(hf(0)), UBound(HFArray) + 1) <> 0 Then
      Call ConvertHeaderFooter(Value, val)
      Call ConvertHFArray(HFArray, hf)
      InitHeaderFooter = True
   Else
      InitHeaderFooter = False
   End If
End Function

Friend Function InitStack(Stack As TPDFStack) As Boolean
   If pdfInitStack(m_Instance, FStack) = 0 Then Exit Function
   Stack.ctm = FStack.ctm
   Stack.tm = FStack.tm
   Stack.X = FStack.X
   Stack.Y = FStack.Y
   Stack.FontSize = FStack.FontSize
   Stack.CharSP = FStack.CharSP
   Stack.WordSP = FStack.WordSP
   Stack.HScale = FStack.HScale
   Stack.TextRise = FStack.TextRise
   Stack.Leading = FStack.Leading
   Stack.LineWidth = FStack.LineWidth
   Stack.DrawMode = FStack.DrawMode
   Stack.FillCS = FStack.FillCS
   Stack.FillColor = FStack.FillColor
   Stack.StrokeCS = FStack.StrokeCS
   Stack.StrokeColor = FStack.StrokeColor
   Stack.text = ""
   InitStack = True
End Function

Friend Function InkAnnot(ByRef points() As TFltPoint, ByVal LineWidth As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   InkAnnot = pdfInkAnnotW(m_Instance, VarPtr(points(0)), UBound(points) + 1, LineWidth, Color, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function InkAnnotA(ByRef points() As TFltPoint, ByVal LineWidth As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   InkAnnotA = pdfInkAnnotA(m_Instance, VarPtr(points(0)), UBound(points) + 1, LineWidth, Color, CS, Author, Subject, Content)
End Function

Friend Function InkAnnotW(ByRef points() As TFltPoint, ByVal LineWidth As Double, ByVal Color As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   InkAnnotW = pdfInkAnnotW(m_Instance, VarPtr(points(0)), UBound(points) + 1, LineWidth, Color, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function InsertBarcode(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByRef Barcode As TPDFBarcode2) As Long
   InsertBarcode = pdfInsertBarcode(m_Instance, PosX, PosY, Width, Height, HAlign, VAlign, Barcode)
End Function

Friend Function InsertBMPFromBuffer(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, Buffer() As Byte) As Long
   InsertBMPFromBuffer = pdfInsertBMPFromBuffer(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, Buffer(0))
End Function

Friend Function InsertBMPFromHandle(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal hBitmap As Long) As Long
   InsertBMPFromHandle = pdfInsertBMPFromHandle(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, hBitmap)
End Function

Friend Function InsertBookmark(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmark = pdfInsertBookmarkW(m_Instance, StrPtr(Title), Parent, DestPage, DoOpen, AddChildren)
End Function

Friend Function InsertBookmarkA(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmarkA = pdfInsertBookmarkA(m_Instance, Title, Parent, DestPage, DoOpen, AddChildren)
End Function

Friend Function InsertBookmarkW(ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmarkW = pdfInsertBookmarkW(m_Instance, StrPtr(Title), Parent, DestPage, DoOpen, AddChildren)
End Function

Friend Function InsertBookmarkEx(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmarkEx = pdfInsertBookmarkExW(m_Instance, StrPtr(Title), Parent, NamedDest, DoOpen, AddChildren)
End Function

Friend Function InsertBookmarkExA(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmarkExA = pdfInsertBookmarkExA(m_Instance, Title, Parent, NamedDest, DoOpen, AddChildren)
End Function

Friend Function InsertBookmarkExW(ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Boolean, ByVal AddChildren As Boolean) As Long
   InsertBookmarkExW = pdfInsertBookmarkExW(m_Instance, StrPtr(Title), Parent, NamedDest, DoOpen, AddChildren)
End Function

Friend Function InsertImage(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal AFile As String) As Long
   InsertImage = pdfInsertImage(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, AFile)
End Function

Friend Function InsertImageEx(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal AFile As String, ByVal Index As Long) As Long
   InsertImageEx = pdfInsertImageExW(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, StrPtr(AFile), Index)
End Function

Friend Function InsertImageExW(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByVal AFile As String, ByVal Index As Long) As Long
   InsertImageExW = pdfInsertImageExW(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, StrPtr(AFile), Index)
End Function

Friend Function InsertImageFromBuffer(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByRef Buffer() As Byte, ByVal Index As Long) As Long
   InsertImageFromBuffer = pdfInsertImageFromBuffer(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, Buffer(0), UBound(Buffer) + 1, Index)
End Function

Friend Function InsertMetafile(ByVal FileName As String, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafile = pdfInsertMetafileW(m_Instance, StrPtr(FileName), PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileW(ByVal FileName As String, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileW = pdfInsertMetafileW(m_Instance, StrPtr(FileName), PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileEx(Buffer() As Byte, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileEx = pdfInsertMetafileEx(m_Instance, Buffer(0), UBound(Buffer) + 1, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileExt(ByVal FileName As String, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileExt = pdfInsertMetafileExtW(m_Instance, FileName, View, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileExtW(ByVal FileName As String, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileExtW = pdfInsertMetafileExtW(m_Instance, StrPtr(FileName), View, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileExtEx(Buffer() As Byte, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileExtEx = pdfInsertMetafileExtEx(m_Instance, Buffer(0), UBound(Buffer) + 1, View, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileFromHandle(ByVal hEnhMetafile As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileFromHandle = pdfInsertMetafileFromHandle(m_Instance, hEnhMetafile, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertMetafileFromHandleEx(ByVal hEnhMetafile As Long, ByRef View As TRectL, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   InsertMetafileFromHandleEx = pdfInsertMetafileFromHandleEx(m_Instance, hEnhMetafile, View, PosX, PosY, Width, Height) <> 0
End Function

Friend Function InsertRawImage(Buffer() As Byte, ByVal BitsPerPixel As Long, ByVal ColorCount As Long, ByVal ImgWidth As Long, ByVal ImgHeight As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Long
   InsertRawImage = pdfInsertRawImage(m_Instance, Buffer(0), BitsPerPixel, ColorCount, ImgWidth, ImgHeight, PosX, PosY, ScaleWidth, ScaleHeight)
End Function

Friend Function InsertRawImageEx(ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double, ByRef Image As TPDFRawImage) As Long
   Dim img As TPDFRawImage_I
   img.StructSize = LenB(img)
   img.Buffer = VarPtr(Image.Buffer(0))
   img.BufSize = UBound(Image.Buffer) + 1
   img.CS = Image.CS
   img.CSHandle = Image.CSHandle
   img.HasAlpha = Image.HasAlpha
   img.IsBGR = Image.IsBGR
   img.MinIsWhite = Image.MinIsWhite
   img.NumComponents = Image.NumComponents
   img.Stride = Image.Stride
   img.Height = Image.Height
   img.Width = Image.Width
   InsertRawImageEx = pdfInsertRawImageEx(m_Instance, PosX, PosY, ScaleWidth, ScaleHeight, img)
End Function

Friend Function IsBidiText(ByVal AText As String) As Long
   IsBidiText = pdfIsBidiText(m_Instance, AText)
End Function

Friend Function IsColorPage(ByVal GrayIsColor As Boolean) As Long
   IsColorPage = pdfIsColorPage(m_Instance, GrayIsColor)
End Function

Friend Function IsEmptyPage() As Long
   IsEmptyPage = pdfIsEmptyPage(m_Instance)
End Function

Friend Function IsWrongPwd(ErrCode As Long) As Boolean
   IsWrongPwd = ((ErrCode = ENEED_PWD) Or (ErrCode = EWRONG_OPEN_PWD) Or (ErrCode = EWRONG_OWNER_PWD) Or (ErrCode = EWRONG_PWD))
End Function

Friend Function LineAnnot(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   LineAnnot = pdfLineAnnotW(m_Instance, x1, y1, x2, y2, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function LineAnnotA(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   LineAnnotA = pdfLineAnnotA(m_Instance, x1, y1, x2, y2, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, Author, Subject, Comment)
End Function

Friend Function LineAnnotW(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   LineAnnotW = pdfLineAnnotW(m_Instance, x1, y1, x2, y2, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function LineTo(ByVal PosX As Double, ByVal PosY As Double) As Boolean
   LineTo = pdfLineTo(m_Instance, PosX, PosY) <> 0
End Function

Friend Function LoadCMap(ByVal CMapName As String, ByVal Embed As Boolean) As Long
   LoadCMap = pdfLoadCMap(m_Instance, CMapName, Embed)
End Function

Friend Function LoadFDFData(ByVal FileName As String, ByVal Password As String, ByVal Flags As Long) As Boolean
   LoadFDFData = pdfLoadFDFDataW(m_Instance, StrPtr(FileName), Password, Flags) <> 0
End Function

Friend Function LoadFDFDataA(ByVal FileName As String, ByVal Password As String, ByVal Flags As Long) As Boolean
   LoadFDFDataA = pdfLoadFDFDataA(m_Instance, FileName, Password, Flags) <> 0
End Function

Friend Function LoadFDFDataW(ByVal FileName As String, ByVal Password As String, ByVal Flags As Long) As Boolean
   LoadFDFDataW = pdfLoadFDFDataW(m_Instance, StrPtr(FileName), Password, Flags) <> 0
End Function

Friend Function LoadFDFDataEx(ByRef Buffer() As Byte, ByVal Password As String, ByVal Flags As Long) As Boolean
   LoadFDFDataEx = pdfLoadFDFDataEx(m_Instance, Buffer(0), UBound(Buffer) + 1, Password, Flags) <> 0
End Function

Friend Function LoadFont(ByRef Buffer() As Byte, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   LoadFont = pdfLoadFont(m_Instance, Buffer(0), UBound(Buffer) + 1, Style, Size, Embed, CP)
End Function

Friend Function LoadFontEx(ByVal FontFile As String, ByVal Index As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   LoadFontEx = pdfLoadFontExW(m_Instance, StrPtr(FontFile), Index, Style, Size, Embed, CP)
End Function

Friend Function LoadFontExA(ByVal FontFile As String, ByVal Index As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   LoadFontExA = pdfLoadFontExA(m_Instance, FontFile, Index, Style, Size, Embed, CP)
End Function

Friend Function LoadFontExW(ByVal FontFile As String, ByVal Index As Long, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   LoadFontExW = pdfLoadFontExW(m_Instance, StrPtr(FontFile), Index, Style, Size, Embed, CP)
End Function

Friend Function LoadHeaderFooterSettings(ByRef Value As TPDFHeaderFooter, ByRef HFArray() As TPDFHdrFtr) As Long
   Dim i As Long, retval As Long
   Dim val As TPDFHeaderFooter_I
   Dim hf() As TPDFHdrFtr_I
   
   LoadHeaderFooterSettings = 0
   If UBound(HFArray) <> 5 Then Exit Function
   
   ReDim hf(UBound(HFArray))
   
   val.StructSize = LenB(val)
   
   retval = pdfLoadHeaderFooterSettings(m_Instance, val, VarPtr(hf(0)))
   
   If retval > 0 Then
      Call ConvertHeaderFooter(Value, val)
      Call ConvertHFArray(HFArray, hf)
   End If
   LoadHeaderFooterSettings = retval
End Function

Friend Function LoadLayerConfig(ByVal Index As Long) As Boolean
   LoadLayerConfig = pdfLoadLayerConfig(m_Instance, Index) <> 0
End Function

Friend Function LockLayer(ByVal Layer As Long) As Long
   LockLayer = pdfLockLayer(m_Instance, Layer)
End Function

Friend Function MarkTemplateAsWatermark(ByVal Handle As Long) As Boolean
   MarkTemplateAsWatermark = pdfMarkTemplateAsWatermark(m_Instance, Handle) <> 0
End Function

Friend Function MovePage(ByVal Source As Long, ByVal Dest As Long) As Boolean
   MovePage = pdfMovePage(m_Instance, Source, Dest) <> 0
End Function

Friend Function MoveTo(ByVal PosX As Double, ByVal PosY As Double) As Boolean
   MoveTo = pdfMoveTo(m_Instance, PosX, PosY) <> 0
End Function

Friend Sub MuliplyMatrix(ByRef M1 As TCTM, ByRef M2 As TCTM, ByRef NewMatrix As TCTM)
   NewMatrix.a = M2.a * M1.a + M2.b * M1.C
   NewMatrix.b = M2.a * M1.b + M2.b * M1.d
   NewMatrix.C = M2.C * M1.a + M2.d * M1.C
   NewMatrix.d = M2.C * M1.b + M2.d * M1.d
   NewMatrix.X = M2.X * M1.a + M2.Y * M1.C + M1.X
   NewMatrix.Y = M2.X * M1.b + M2.Y * M1.d + M1.Y
End Sub

Friend Function OpenImportBuffer(Buffer() As Byte, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   OpenImportBuffer = pdfOpenImportBuffer(m_Instance, Buffer(0), UBound(Buffer) + 1, PwdType, Password)
End Function

Friend Function OpenImportFile(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   OpenImportFile = pdfOpenImportFileW(m_Instance, StrPtr(FileName), PwdType, Password)
End Function

Friend Function OpenImportFileA(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   OpenImportFileA = pdfOpenImportFileA(m_Instance, FileName, PwdType, Password)
End Function

Friend Function OpenImportFileW(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal Password As String) As Long
   OpenImportFileW = pdfOpenImportFileW(m_Instance, StrPtr(FileName), PwdType, Password)
End Function

Friend Function OpenOutputFile(ByVal OutPDF As String) As Boolean
   OpenOutputFile = pdfOpenOutputFileW(m_Instance, StrPtr(OutPDF)) <> 0
End Function

Friend Function OpenOutputFileA(ByVal OutPDF As String) As Boolean
   OpenOutputFileA = pdfOpenOutputFileA(m_Instance, OutPDF) <> 0
End Function

Friend Function OpenOutputFileW(ByVal OutPDF As String) As Boolean
   OpenOutputFileW = pdfOpenOutputFileW(m_Instance, StrPtr(OutPDF)) <> 0
End Function

Friend Function OpenOutputFileEncrypted(ByVal OutPDF As String, ByVal OpenPwd As String, ByVal OwnerPwd As String, ByVal KeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   OpenOutputFileEncrypted = pdfOpenOutputFileEncryptedW(m_Instance, StrPtr(OutPDF), OpenPwd, OwnerPwd, KeyLen, Restrict)
End Function

Friend Function OpenTag(ByVal Tag As TPDFBaseTag, Optional ByVal Lang As String = vbNullString, Optional ByVal AltText As String = vbNullString, Optional ByVal Expansion As String = vbNullString) As Boolean
   OpenTag = pdfOpenTagW(m_Instance, Tag, StrPtr(Lang), StrPtr(AltText), StrPtr(Expansion)) <> 0
End Function

Friend Function OpenTagA(ByVal Tag As TPDFBaseTag, Optional ByVal Lang As String = vbNullString, Optional ByVal AltText As String = vbNullString, Optional ByVal Expansion As String = vbNullString) As Boolean
   OpenTagA = pdfOpenTagA(m_Instance, Tag, Lang, AltText, Expansion) <> 0
End Function

Friend Function OpenTagW(ByVal Tag As TPDFBaseTag, Optional ByVal Lang As String = vbNullString, Optional ByVal AltText As String = vbNullString, Optional ByVal Expansion As String = vbNullString) As Boolean
   OpenTagW = pdfOpenTagW(m_Instance, Tag, StrPtr(Lang), StrPtr(AltText), StrPtr(Expansion)) <> 0
End Function

Friend Function OpenTagBBox(ByVal Tag As TPDFBaseTag, ByVal Lang As String, ByVal AltText As String, ByVal Expansion As String, ByRef BBox As TBBox) As Boolean
   OpenTagBBox = pdfOpenTagBBoxW(m_Instance, Tag, Lang, StrPtr(AltText), StrPtr(Expansion), BBox) <> 0
End Function

Friend Function OpenTagEx(ByVal Tag As TPDFBaseTag, ByVal Lang As String, ByVal AltText As String, ByVal Expansion As String, ByVal Attributes As String) As Boolean
   OpenTagEx = pdfOpenTagExW(m_Instance, Tag, Lang, StrPtr(AltText), StrPtr(Expansion), Attributes) <> 0
End Function

Friend Function Optimize(ByVal Flags As TOptimizeFlags, ByRef Parms As TOptimizeParams, Optional IncludeCSArray = False) As Boolean
   Dim p As TOptimizeParams_I
   Call GetOptimizeParams(Parms, p, IncludeCSArray)
   Optimize = pdfOptimize(m_Instance, Flags, VarPtr(p)) <> 0
End Function

Friend Function Optimize2(ByVal Flags As TOptimizeFlags) As Boolean
   Optimize2 = pdfOptimize(m_Instance, Flags, 0) <> 0
End Function

Friend Function PageLink(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal DestPage As Long) As Long
   PageLink = pdfPageLink(m_Instance, PosX, PosY, Width, Height, DestPage)
End Function

Friend Function PageLink2(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As Long) As Long
   PageLink2 = pdfPageLink2(m_Instance, PosX, PosY, Width, Height, NamedDest)
End Function

Friend Function PageLink3(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As String) As Long
   PageLink3 = pdfPageLink3W(m_Instance, PosX, PosY, Width, Height, StrPtr(NamedDest))
End Function

Friend Function PageLink3A(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As String) As Long
   PageLink3A = pdfPageLink3A(m_Instance, PosX, PosY, Width, Height, NamedDest)
End Function

Friend Function PageLink3W(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal NamedDest As String) As Long
   PageLink3W = pdfPageLink3W(m_Instance, PosX, PosY, Width, Height, StrPtr(NamedDest))
End Function

Friend Function PageLinkEx(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal DestType As TDestType, ByVal DestPage As Long, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Long
   PageLinkEx = pdfPageLinkEx(m_Instance, PosX, PosY, Width, Height, DestType, DestPage, a, b, C, d)
End Function

Friend Function PlaceImage(ByVal ImgHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Boolean
   PlaceImage = pdfPlaceImage(m_Instance, ImgHandle, PosX, PosY, ScaleWidth, ScaleHeight) <> 0
End Function

Friend Function PlaceSigFieldValidateIcon(ByVal SigField As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   PlaceSigFieldValidateIcon = pdfPlaceSigFieldValidateIcon(m_Instance, SigField, PosX, PosY, Width, Height) <> 0
End Function

Friend Function PlaceTemplate(ByVal TmplHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Boolean
   PlaceTemplate = pdfPlaceTemplate(m_Instance, TmplHandle, PosX, PosY, ScaleWidth, ScaleHeight) <> 0
End Function

Friend Function PlaceTemplateEx(ByVal TmplHandle As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal ScaleWidth As Double, ByVal ScaleHeight As Double) As Boolean
   PlaceTemplateEx = pdfPlaceTemplateEx(m_Instance, TmplHandle, PosX, PosY, ScaleWidth, ScaleHeight) <> 0
End Function

Friend Function PolygonAnnot(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolygonAnnot = pdfPolygonAnnotW(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function PolygonAnnotA(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolygonAnnotA = pdfPolygonAnnotA(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, FillColor, StrokeColor, CS, Author, Subject, Content)
End Function

Friend Function PolygonAnnotW(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolygonAnnotW = pdfPolygonAnnotW(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function PolyLineAnnot(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolyLineAnnot = pdfPolyLineAnnotW(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function PolyLineAnnotA(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolyLineAnnotA = pdfPolyLineAnnotA(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, Author, Subject, Content)
End Function

Friend Function PolyLineAnnotW(ByRef Vertices() As TFltPoint, ByVal LineWidth As Double, ByVal lStart As TLineEndStyle, ByVal lEnd As TLineEndStyle, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Content As String) As Long
   PolyLineAnnotW = pdfPolyLineAnnotW(m_Instance, VarPtr(Vertices(0)), UBound(Vertices) + 1, LineWidth, lStart, lEnd, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Content))
End Function

Friend Function PrintPage(ByVal PageNum As Long, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Boolean
   PrintPage = pdfPrintPageW(m_Instance, PageNum, StrPtr(DocName), DC, Flags, Margin, Parms) <> 0
End Function

Friend Function PrintPageA(ByVal PageNum As Long, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Boolean
   PrintPageA = pdfPrintPageA(m_Instance, PageNum, DocName, DC, Flags, Margin, Parms) <> 0
End Function

Friend Function PrintPageW(ByVal PageNum As Long, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, ByVal Parms As Long) As Boolean
   PrintPageW = pdfPrintPageW(m_Instance, PageNum, StrPtr(DocName), DC, Flags, Margin, Parms) <> 0
End Function

Friend Function PrintPDFFile(ByVal TmpDir As String, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, Optional ByVal Parms As Long) As Boolean
   PrintPDFFile = pdfPrintPDFFileW(m_Instance, StrPtr(TmpDir), StrPtr(DocName), DC, Flags, Margin, Parms) <> 0
End Function

Friend Function PrintPDFFileA(ByVal TmpDir As String, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, Optional ByVal Parms As Long) As Boolean
   PrintPDFFileA = pdfPrintPDFFileA(m_Instance, TmpDir, DocName, DC, Flags, Margin, Parms) <> 0
End Function

Friend Function PrintPDFFileW(ByVal TmpDir As String, ByVal DocName As String, ByVal DC As Long, ByVal Flags As TPDFPrintFlags, ByRef Margin As TRectL, Optional ByVal Parms As Long) As Boolean
   PrintPDFFileW = pdfPrintPDFFileW(m_Instance, StrPtr(TmpDir), StrPtr(DocName), DC, Flags, Margin, Parms) <> 0
End Function

Friend Function ReadImageFormat(ByVal FileName As String, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormat = pdfReadImageFormatW(m_Instance, StrPtr(FileName), Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageFormatW(ByVal FileName As String, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormatW = pdfReadImageFormatW(m_Instance, StrPtr(FileName), Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageFormat2(ByVal FileName As String, ByVal Index As Long, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormat2 = pdfReadImageFormat2W(m_Instance, StrPtr(FileName), Index, Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageFormat2W(ByVal FileName As String, ByVal Index As Long, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormat2W = pdfReadImageFormat2W(m_Instance, StrPtr(FileName), Index, Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageFormatEx(ByVal hBitmap As Long, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormatEx = pdfReadImageFormatEx(m_Instance, hBitmap, Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageFormatFromBuffer(Buffer() As Byte, ByVal Index As Long, Width As Long, Height As Long, BitsPerPixel As Long, UseZip As Long) As Boolean
   ReadImageFormatFromBuffer = pdfReadImageFormatFromBuffer(m_Instance, Buffer(0), UBound(Buffer) + 1, Index, Width, Height, BitsPerPixel, UseZip) <> 0
End Function

Friend Function ReadImageResolution(ByVal FileName As String, ByVal Index As Long, resX As Long, resY As Long) As Boolean
   ReadImageResolution = pdfReadImageResolutionW(m_Instance, StrPtr(FileName), Index, resX, resY) <> 0
End Function

Friend Function ReadImageResolutionW(ByVal FileName As String, ByVal Index As Long, resX As Long, resY As Long) As Boolean
   ReadImageResolutionW = pdfReadImageResolutionW(m_Instance, StrPtr(FileName), Index, resX, resY) <> 0
End Function

Friend Function ReadImageResolutionEx(Buffer() As Byte, ByVal Index As Long, resX As Long, resY As Long) As Boolean
   ReadImageResolutionEx = pdfReadImageResolutionEx(m_Instance, Buffer(0), UBound(Buffer) + 1, Index, resX, resY) <> 0
End Function

Friend Function Rectangle(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal FillMode As TPathFillMode) As Boolean
   Rectangle = pdfRectangle(m_Instance, PosX, PosY, Width, Height, FillMode) <> 0
End Function

Friend Sub Redraw(ByVal RasPtr, ByVal DC As Long, ByVal DestX As Long, ByVal DestY As Long)
   rasRedraw RasPtr, DC, DestX, DestY
End Sub

Friend Function ReEncryptPDF(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal InPwd As String, ByVal NewOpenPwd As String, ByVal NewOwnerPwd As String, ByVal NewKeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   ReEncryptPDF = pdfReEncryptPDFW(m_Instance, StrPtr(FileName), PwdType, InPwd, NewOpenPwd, NewOwnerPwd, NewKeyLen, Restrict)
End Function

Friend Function ReEncryptPDFA(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal InPwd As String, ByVal NewOpenPwd As String, ByVal NewOwnerPwd As String, ByVal NewKeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   ReEncryptPDFA = pdfReEncryptPDFA(m_Instance, FileName, PwdType, InPwd, NewOpenPwd, NewOwnerPwd, NewKeyLen, Restrict)
End Function

Friend Function ReEncryptPDFW(ByVal FileName As String, ByVal PwdType As TPwdType, ByVal InPwd As String, ByVal NewOpenPwd As String, ByVal NewOwnerPwd As String, ByVal NewKeyLen As TKeyLen, ByVal Restrict As TRestrictions) As Long
   ReEncryptPDFW = pdfReEncryptPDFW(m_Instance, StrPtr(FileName), PwdType, InPwd, NewOpenPwd, NewOwnerPwd, NewKeyLen, Restrict)
End Function

Friend Function RenameSpotColor(ByVal Colorant As String, ByVal NewName As String) As Long
   RenameSpotColor = pdfRenameSpotColor(m_Instance, Colorant, NewName)
End Function

Friend Function RenderAnnotOrField(ByVal Handle As Long, ByVal IsAnnot As Boolean, ByVal State As TButtonState, ByRef Matrix As TCTM, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByRef out As TPDFBitmap) As Long
   RenderAnnotOrField = pdfRenderAnnotOrField(m_Instance, Handle, IsAnnot, State, Matrix, Flags, PixFmt, Filter, out)
End Function

Friend Function RenderPage(ByVal PagePtr As Long, ByVal RasPtr As Long, ByRef img As TPDFRasterImage) As Boolean
   RenderPage = pdfRenderPage(m_Instance, PagePtr, RasPtr, img) <> 0
End Function

Friend Function RenderPageEx(ByVal DC As Long, ByRef DestX As Long, ByRef DestY As Long, ByVal PagePtr As Long, ByVal RasPtr As Long, ByRef img As TPDFRasterImage) As Boolean
   RenderPageEx = pdfRenderPageEx(m_Instance, DC, DestX, DestY, PagePtr, RasPtr, img) <> 0
End Function

Friend Function RenderPageToImage(ByVal PageNum As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
   RenderPageToImage = pdfRenderPageToImageW(m_Instance, PageNum, StrPtr(OutFile), Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPageToImageA(ByVal PageNum As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
   RenderPageToImageA = pdfRenderPageToImageA(m_Instance, PageNum, OutFile, Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPageToImageW(ByVal PageNum As Long, ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Long
   RenderPageToImageW = pdfRenderPageToImageW(m_Instance, PageNum, StrPtr(OutFile), Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFile(ByVal OutFile As String, ByVal Resolution As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFile = pdfRenderPDFFileW(m_Instance, StrPtr(OutFile), Resolution, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFileA(ByVal OutFile As String, ByVal Resolution As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFileA = pdfRenderPDFFileA(m_Instance, OutFile, Resolution, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFileW(ByVal OutFile As String, ByVal Resolution As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFileW = pdfRenderPDFFileW(m_Instance, StrPtr(OutFile), Resolution, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFileEx(ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFileEx = pdfRenderPDFFileExW(m_Instance, StrPtr(OutFile), Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFileExA(ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFileExA = pdfRenderPDFFileExA(m_Instance, OutFile, Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function RenderPDFFileExW(ByVal OutFile As String, ByVal Resolution As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TRasterFlags, ByVal PixFmt As TPDFPixFormat, ByVal Filter As TCompressionFilter, ByVal Format As TImageFormat) As Boolean
   RenderPDFFileExW = pdfRenderPDFFileExW(m_Instance, StrPtr(OutFile), Resolution, Width, Height, Flags, PixFmt, Filter, Format) <> 0
End Function

Friend Function ReOpenImportFile(ByVal Handle As Long) As Boolean
   ReOpenImportFile = pdfReOpenImportFile(m_Instance, Handle) <> 0
End Function

Friend Function ReplaceFont(ByVal PDFFont As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal NameIsFamilyName As Boolean) As Long
   ReplaceFont = pdfReplaceFontW(m_Instance, PDFFont, StrPtr(Name), Style, NameIsFamilyName)
End Function

Friend Function ReplaceFontA(ByVal PDFFont As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal NameIsFamilyName As Boolean) As Long
   ReplaceFontA = pdfReplaceFontA(m_Instance, PDFFont, Name, Style, NameIsFamilyName)
End Function

Friend Function ReplaceFontW(ByVal PDFFont As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal NameIsFamilyName As Boolean) As Long
   ReplaceFontW = pdfReplaceFontW(m_Instance, PDFFont, StrPtr(Name), Style, NameIsFamilyName)
End Function

Friend Function ReplaceFontEx(ByVal PDFFont As Long, ByVal FontFile As String, ByVal Embed As Boolean) As Long
   ReplaceFontEx = pdfReplaceFontExW(m_Instance, PDFFont, StrPtr(FontFile), Embed)
End Function

Friend Function ReplaceFontExA(ByVal PDFFont As Long, ByVal FontFile As String, ByVal Embed As Boolean) As Long
   ReplaceFontExA = pdfReplaceFontExA(m_Instance, PDFFont, FontFile, Embed)
End Function

Friend Function ReplaceFontExW(ByVal PDFFont As Long, ByVal FontFile As String, ByVal Embed As Boolean) As Long
   ReplaceFontExW = pdfReplaceFontExW(m_Instance, PDFFont, StrPtr(FontFile), Embed)
End Function

Friend Function ReplaceICCProfile(ByVal ColorSpace As Long, ByVal ICCFile As String) As Long
   ReplaceICCProfile = pdfReplaceICCProfileW(m_Instance, ColorSpace, StrPtr(ICCFile))
End Function

Friend Function ReplaceICCProfileA(ByVal ColorSpace As Long, ByVal ICCFile As String) As Long
   ReplaceICCProfileA = pdfReplaceICCProfileA(m_Instance, ColorSpace, ICCFile)
End Function

Friend Function ReplaceICCProfileW(ByVal ColorSpace As Long, ByVal ICCFile As String) As Long
   ReplaceICCProfileW = pdfReplaceICCProfileW(m_Instance, ColorSpace, StrPtr(ICCFile))
End Function

Friend Function ReplaceICCProfileEx(ByVal ColorSpace As Long, ByRef Buffer() As Byte) As Long
   ReplaceICCProfileEx = pdfReplaceICCProfileEx(m_Instance, ColorSpace, Buffer(0), UBound(Buffer) + 1)
End Function

Friend Function ReplaceImageA(ByVal Source As Long, ByVal Image As String, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Boolean
   ReplaceImageA = pdfReplaceImageA(m_Instance, Source, Image, Index, CS, CSHandle, Flags) <> 0
End Function

Friend Function ReplaceImageW(ByVal Source As Long, ByVal Image As String, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Boolean
   ReplaceImageW = pdfReplaceImageW(m_Instance, Source, StrPtr(Image), Index, CS, CSHandle, Flags) <> 0
End Function

Friend Function ReplaceImageEx(ByVal Source As Long, ByRef Buffer() As Byte, ByVal Index As Long, ByVal CS As TExtColorSpace, ByVal CSHandle As Long, ByVal Flags As TReplaceImageFlags) As Boolean
   ReplaceImageEx = pdfReplaceImageEx(m_Instance, Source, Buffer(0), UBound(Buffer) + 1, Index, CS, CSHandle, Flags) <> 0
End Function

Friend Function ReplacePageTextA(ByRef Stack As TPDFStack, ByVal NewText As String) As Boolean
   FStack.DeleteKerningAt = Stack.DeleteKerningAt
   ReplacePageTextA = pdfReplacePageTextA(m_Instance, NewText, FStack) <> 0
End Function

Friend Function ReplacePageTextEx(ByVal NewText As String) As Boolean
   ReplacePageTextEx = pdfReplacePageTextExW(m_Instance, StrPtr(NewText), FStack) <> 0
End Function

Friend Function ReplacePageTextExA(ByVal NewText As String) As Boolean
   ReplacePageTextExA = pdfReplacePageTextExA(m_Instance, NewText, FStack) <> 0
End Function

Friend Function ReplacePageTextExW(ByVal NewText As String) As Boolean
   ReplacePageTextExW = pdfReplacePageTextExW(m_Instance, StrPtr(NewText), FStack) <> 0
End Function

Friend Function ResetAnnotAP(ByVal Handle As Long) As Boolean
   ResetAnnotAP = pdfResetAnnotAP(m_Instance, Handle) <> 0
End Function

Friend Function ResetEncryptionSettings() As Boolean
   ResetEncryptionSettings = pdfResetEncryptionSettings(m_Instance) <> 0
End Function

Friend Function ResetLineDashPattern() As Boolean
   ResetLineDashPattern = pdfResetLineDashPattern(m_Instance) <> 0
End Function

Friend Function ResizeBitmap(ByVal RasPtr As Long, ByVal DC As Long, ByVal Width As Long, ByVal Height As Long) As Boolean
   ResizeBitmap = rasResizeBitmap(RasPtr, DC, Width, Height) <> 0
End Function

Friend Function RestoreGraphicState() As Boolean
   RestoreGraphicState = pdfRestoreGraphicState(m_Instance) <> 0
End Function

Friend Function RotateCoords(ByVal Alpha As Double, ByVal OriginX As Double, ByVal OriginY As Double) As Boolean
   RotateCoords = pdfRotateCoords(m_Instance, Alpha, OriginX, OriginY) <> 0
End Function

Friend Function RoundRect(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Radius As Double, ByVal FillMode As TPathFillMode) As Boolean
   RoundRect = pdfRoundRect(m_Instance, PosX, PosY, Width, Height, Radius, FillMode) <> 0
End Function

Friend Function RoundRectEx(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal rWidth As Double, ByVal rHeight As Double, ByVal FillMode As TPathFillMode) As Boolean
   RoundRectEx = pdfRoundRectEx(m_Instance, PosX, PosY, Width, Height, rWidth, rHeight, FillMode) <> 0
End Function

Friend Function SaveGraphicState() As Boolean
   SaveGraphicState = pdfSaveGraphicState(m_Instance) <> 0
End Function

Friend Function ScaleCoords(ByVal sx As Double, ByVal sy As Double) As Long
   ScaleCoords = pdfScaleCoords(m_Instance, sx, sy)
End Function

Friend Function SelfTest() As Boolean
   SelfTest = pdfSelfTest(m_Instance) <> 0
End Function

Friend Function Set3DAnnotProps(ByVal Annot As Long, ByVal ActType As T3DActivationType, ByVal DeActType As T3DDeActivateType, ByVal InstType As T3DInstanceType, ByVal DeInstType As T3DDeActInstance, ByVal DisplToolbar As Boolean, ByVal DisplModelTree As Boolean) As Boolean
   Set3DAnnotProps = pdfSet3DAnnotProps(m_Instance, Annot, ActType, DeActType, InstType, DeInstType, DisplToolbar, DisplModelTree) <> 0
End Function

Friend Function Set3DAnnotScriptA(ByVal Annot As Long, ByVal Value As String) As Boolean
   Set3DAnnotScriptA = pdfSet3DAnnotScriptA(m_Instance, Annot, Value, Len(Value)) <> 0
End Function

Friend Function SetActiveSigField(ByVal Handle As Long) As Long
   SetActiveSigField = pdfSetActiveSigField(m_Instance, Handle)
End Function

Friend Function SetAllocBy(ByVal Value As Long) As Long
   SetAllocBy = pdfSetAllocBy(m_Instance, Value)
End Function

Friend Function SetAltFonts(ByVal ListHandle As Long, ByRef List() As String) As Boolean
   Dim values() As Long, i As Long
   ReDim values(UBound(List))
   For i = 0 To UBound(List)
      values(i) = StrPtr(List(i))
   Next i
   SetAltFonts = pdfSetAltFontsW(m_Instance, ListHandle, VarPtr(values(0)), UBound(values) + 1)
End Function

Friend Function SetAnnotBorderEffect(ByVal Handle As Long, ByVal Value As TBorderEffect) As Boolean
   SetAnnotBorderEffect = pdfSetAnnotBorderEffect(m_Instance, Handle, Value) <> 0
End Function

Friend Function SetAnnotBorderStyle(ByVal Handle As Long, ByVal Style As TBorderStyle) As Boolean
   SetAnnotBorderStyle = pdfSetAnnotBorderStyle(m_Instance, Handle, Style) <> 0
End Function

Friend Function SetAnnotBorderWidth(ByVal Handle As Long, ByVal LineWidth As Double) As Boolean
   SetAnnotBorderWidth = pdfSetAnnotBorderWidth(m_Instance, Handle, LineWidth) <> 0
End Function

Friend Function SetAnnotColor(ByVal Handle As Long, ByVal ColorType As TAnnotColor, ByVal CS As TPDFColorSpace, ByVal Color As Long) As Boolean
   SetAnnotColor = pdfSetAnnotColor(m_Instance, Handle, ColorType, CS, Color) <> 0
End Function

Friend Function SetAnnotFlags(ByVal Flags As TAnnotFlags) As Boolean
   SetAnnotFlags = pdfSetAnnotFlags(m_Instance, Flags) <> 0
End Function

Friend Function SetAnnotFlagsEx(ByVal Handle As Long, ByVal Flags As Long) As Boolean
   SetAnnotFlagsEx = pdfSetAnnotFlagsEx(m_Instance, Handle, Flags) <> 0
End Function

Friend Function SetAnnotHighlightMode(ByVal Handle As Long, ByVal Mode As THighlightMode) As Boolean
   SetAnnotHighlightMode = pdfSetAnnotHighlightMode(m_Instance, Handle, Mode) <> 0
End Function

Friend Function SetAnnotIcon(ByVal Handle As Long, ByVal Icon As TAnnotIcon) As Boolean
   SetAnnotIcon = pdfSetAnnotIcon(m_Instance, Handle, Icon) <> 0
End Function

Friend Function SetAnnotLineDashPattern(ByVal Handle As Long, ByRef Dash() As Single, ByVal NumValues As Long) As Boolean
   SetAnnotLineDashPattern = pdfSetAnnotLineDashPattern(m_Instance, Handle, Dash(0), NumValues) <> 0
End Function

Friend Function SetAnnotLineEndStyle(ByVal Handle As Long, ByVal StartStyle As TLineEndStyle, ByVal EndStyle As TLineEndStyle) As Boolean
   SetAnnotLineEndStyle = pdfSetAnnotLineEndStyle(m_Instance, Handle, StartStyle, EndStyle) <> 0
End Function

Friend Function SetAnnotMigrationState(ByVal Annot As Long, ByVal State As TAnnotState, ByVal User As String) As Long
   SetAnnotMigrationState = pdfSetAnnotMigrationStateW(m_Instance, Annot, State, StrPtr(User))
End Function

Friend Function SetAnnotOpacity(ByVal Handle As Long, ByVal Value As Double) As Boolean
   SetAnnotOpacity = pdfSetAnnotOpacity(m_Instance, Handle, Value) <> 0
End Function

Friend Function SetAnnotOpenState(ByVal Handle As Long, ByVal DoOpen As Boolean) As Boolean
   SetAnnotOpenState = pdfSetAnnotOpenState(m_Instance, Handle, DoOpen) <> 0
End Function

Friend Function SetAnnotOrFieldDate(ByVal Handle As Long, ByVal IsField As Long, ByVal DateType As TDateType, ByVal DateTime As Long) As Boolean
   SetAnnotOrFieldDate = pdfSetAnnotOrFieldDate(m_Instance, Handle, IsField, DateType, DateTime) <> 0
End Function

Friend Function SetAnnotQuadPoints(ByVal Handle As Long, ByRef Value() As TFltPoint) As Boolean
   SetAnnotQuadPoints = pdfSetAnnotQuadPoints(m_Instance, Handle, VarPtr(Value(0)), UBound(Value) + 1) <> 0
End Function

Friend Function SetAnnotString(ByVal Handle As Long, ByVal StringType As TAnnotString, ByVal Value As String) As Boolean
   SetAnnotString = pdfSetAnnotStringW(m_Instance, Handle, StringType, StrPtr(Value)) <> 0
End Function

Friend Function SetAnnotStringA(ByVal Handle As Long, ByVal StringType As TAnnotString, ByVal Value As String) As Boolean
   SetAnnotStringA = pdfSetAnnotStringA(m_Instance, Handle, StringType, Value) <> 0
End Function

Friend Function SetAnnotStringW(ByVal Handle As Long, ByVal StringType As TAnnotString, ByVal Value As String) As Boolean
   SetAnnotStringW = pdfSetAnnotStringW(m_Instance, Handle, StringType, StrPtr(Value)) <> 0
End Function

Friend Function SetAnnotSubject(ByVal Handle As Long, ByVal Value As String) As Boolean
   SetAnnotSubject = pdfSetAnnotSubjectW(m_Instance, Handle, StrPtr(Value)) <> 0
End Function

Friend Function SetAnnotSubjectA(ByVal Handle As Long, ByVal Value As String) As Boolean
   SetAnnotSubjectA = pdfSetAnnotSubjectA(m_Instance, Handle, Value) <> 0
End Function

Friend Function SetAnnotSubjectW(ByVal Handle As Long, ByVal Value As String) As Boolean
   SetAnnotSubjectW = pdfSetAnnotSubjectW(m_Instance, Handle, StrPtr(Value)) <> 0
End Function

Friend Function SetBBox(ByVal Boundary As TPageBoundary, ByVal LeftX As Double, ByVal LeftY As Double, ByVal RightX As Double, ByVal RightY As Double) As Boolean
   SetBBox = pdfSetBBox(m_Instance, Boundary, LeftX, LeftY, RightX, RightY) <> 0
End Function

Friend Function SetBidiMode(ByVal Mode As TPDFBidiMode) As Boolean
   SetBidiMode = pdfSetBidiMode(m_Instance, Mode) <> 0
End Function

Friend Function SetBookmarkDest(ByVal ABmk As Long, ByVal DestType As TDestType, ByVal a As Double, ByVal b As Double, ByVal C As Double, ByVal d As Double) As Boolean
   SetBookmarkDest = pdfSetBookmarkDest(m_Instance, ABmk, DestType, a, b, C, d) <> 0
End Function

Friend Function SetBookmarkStyle(ByVal ABmk As Long, ByVal Style As TFStyle, ByVal RGBColor As Long) As Boolean
   SetBookmarkStyle = pdfSetBookmarkStyle(m_Instance, ABmk, Style, RGBColor) <> 0
End Function

Friend Function SetBorderStyle(ByVal Style As TBorderStyle) As Boolean
   SetBorderStyle = pdfSetBorderStyle(m_Instance, Style) <> 0
End Function

Friend Function SetCharacterSpacing(ByVal Value As Double) As Boolean
   SetCharacterSpacing = pdfSetCharacterSpacing(m_Instance, Value) <> 0
End Function

Friend Function SetCheckBoxChar(ByVal CheckBoxChar As TCheckBoxChar) As Boolean
   SetCheckBoxChar = pdfSetCheckBoxChar(m_Instance, CheckBoxChar) <> 0
End Function

Friend Function SetCheckBoxDefState(ByVal Field As Long, ByVal Checked As Boolean) As Boolean
   SetCheckBoxDefState = pdfSetCheckBoxDefState(m_Instance, Field, Checked) <> 0
End Function

Friend Function SetCheckBoxState(ByVal Field As Long, ByVal Checked As Boolean) As Boolean
   SetCheckBoxState = pdfSetCheckBoxState(m_Instance, Field, Checked) <> 0
End Function

Friend Function SetCIDFont(ByVal CMapHandle As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean) As Long
   SetCIDFont = pdfSetCIDFontW(m_Instance, CMapHandle, StrPtr(Name), Style, Size, Embed)
End Function

Friend Function SetCIDFontA(ByVal CMapHandle As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean) As Long
   SetCIDFontA = pdfSetCIDFontA(m_Instance, CMapHandle, Name, Style, Size, Embed)
End Function

Friend Function SetCIDFontW(ByVal CMapHandle As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean) As Long
   SetCIDFontW = pdfSetCIDFontW(m_Instance, CMapHandle, StrPtr(Name), Style, Size, Embed)
End Function

Friend Function SetCMapDir(ByVal Path As String, ByVal Flags As TLoadCMapFlags) As Long
   SetCMapDir = pdfSetCMapDirW(m_Instance, StrPtr(Path), Flags)
End Function

Friend Function SetCMapDirA(ByVal Path As String, ByVal Flags As TLoadCMapFlags) As Long
   SetCMapDirA = pdfSetCMapDirA(m_Instance, Path, Flags)
End Function

Friend Function SetCMapDirW(ByVal Path As String, ByVal Flags As TLoadCMapFlags) As Long
   SetCMapDirW = pdfSetCMapDirW(m_Instance, StrPtr(Path), Flags)
End Function

Friend Function SetColDefFile(ByVal EmbFile As Long) As Boolean
   SetColDefFile = pdfSetColDefFile(m_Instance, EmbFile) <> 0
End Function

Friend Function SetColorMask(ByVal ImageHandle As Long, ByRef Mask() As Long) As Boolean
   On Error GoTo errf
   Dim Count As Long
   Count = UBound(Mask) + 1
   SetColorMask = pdfSetColorMask(m_Instance, ImageHandle, VarPtr(Mask(0)), Count) <> 0
errf:
   SetColorMask = pdfSetColorMask(m_Instance, ImageHandle, 0, 0) <> 0
End Function

Friend Function SetColors(ByVal Color As Long) As Boolean
   SetColors = pdfSetColors(m_Instance, Color) <> 0
End Function

Friend Function SetColorSpace(ByVal ColorSpace As TPDFColorSpace) As Boolean
   SetColorSpace = pdfSetColorSpace(m_Instance, ColorSpace) <> 0
End Function

Friend Function SetColSortField(ByVal ColField As Long, ByVal AscendingOrder As Long) As Boolean
   SetColSortField = pdfSetColSortField(m_Instance, ColField, AscendingOrder) <> 0
End Function

Friend Function SetCompressionFilter(ByVal ComprFilter As TCompressionFilter) As Boolean
   SetCompressionFilter = pdfSetCompressionFilter(m_Instance, ComprFilter) <> 0
End Function

Friend Function SetCompressionLevel(ByVal CompressLevel As TCompressionLevel) As Boolean
   SetCompressionLevel = pdfSetCompressionLevel(m_Instance, CompressLevel) <> 0
End Function

Friend Function SetContent(ByRef Buffer() As Byte) As Boolean
    Dim IsEmptyArray As Boolean
On Error Resume Next
    IsEmptyArray = True
    IsEmptyArray = UBound(Buffer) < LBound(Buffer)
On Error GoTo 0
    If IsEmptyArray Then
        SetContent = pdfSetContent(m_Instance, ByVal 0, 0) <> 0
    Else
        SetContent = pdfSetContent(m_Instance, Buffer(0), UBound(Buffer) + 1) <> 0
    End If
End Function

Friend Function SetDateTimeFormat(ByVal TxtField As Long, ByVal Fmt As TPDFDateTime) As Boolean
   SetDateTimeFormat = pdfSetDateTimeFormat(m_Instance, TxtField, Fmt) <> 0
End Function

Friend Function SetDefBitsPerPixel(ByVal Value As Long) As Boolean
   SetDefBitsPerPixel = pdfSetDefBitsPerPixel(m_Instance, Value) <> 0
End Function

Friend Function SetDocInfo(ByVal DInfo As TDocumentInfo, ByVal Value As String) As Boolean
   SetDocInfo = pdfSetDocInfoW(m_Instance, DInfo, StrPtr(Value)) <> 0
End Function

Friend Function SetDocInfoA(ByVal DInfo As TDocumentInfo, ByVal Value As String) As Boolean
   SetDocInfoA = pdfSetDocInfoA(m_Instance, DInfo, Value) <> 0
End Function

Friend Function SetDocInfoW(ByVal DInfo As TDocumentInfo, ByVal Value As String) As Boolean
   SetDocInfoW = pdfSetDocInfoW(m_Instance, DInfo, StrPtr(Value)) <> 0
End Function

Friend Function SetDocInfoEx(ByVal DInfo As TDocumentInfo, ByVal Key As String, ByVal Value As String) As Boolean
   SetDocInfoEx = pdfSetDocInfoExW(m_Instance, DInfo, Key, StrPtr(Value)) <> 0
End Function

Friend Function SetDocInfoExA(ByVal DInfo As TDocumentInfo, ByVal Key As String, ByVal Value As String) As Boolean
   SetDocInfoExA = pdfSetDocInfoExA(m_Instance, DInfo, Key, Value) <> 0
End Function

Friend Function SetDocInfoExW(ByVal DInfo As TDocumentInfo, ByVal Key As String, ByVal Value As String) As Boolean
   SetDocInfoExW = pdfSetDocInfoExW(m_Instance, DInfo, Key, StrPtr(Value)) <> 0
End Function

Friend Function SetDrawDirection(ByVal Direction As TDrawDirection) As Boolean
   SetDrawDirection = pdfSetDrawDirection(m_Instance, Direction) <> 0
End Function

Friend Function SetEMFFrameDPI(ByVal DPIX As Long, ByVal DPIY As Long) As Boolean
   SetEMFFrameDPI = pdfSetEMFFrameDPI(m_Instance, DPIX, DPIY) <> 0
End Function

Friend Function SetEMFPatternDistance(ByVal Value As Double) As Boolean
   SetEMFPatternDistance = pdfSetEMFPatternDistance(m_Instance, Value) <> 0
End Function

Friend Function SetErrorMode(ByVal ErrMode As TErrMode) As Boolean
   SetErrorMode = pdfSetErrorMode(m_Instance, ErrMode) <> 0
End Function

Friend Function SetExtColorSpace(ByVal Handle As Long) As Boolean
   SetExtColorSpace = pdfSetExtColorSpace(m_Instance, Handle) <> 0
End Function

Friend Function SetExtFillColorSpace(ByVal Handle As Long) As Boolean
   SetExtFillColorSpace = pdfSetExtFillColorSpace(m_Instance, Handle) <> 0
End Function

Friend Function SetExtGState(ByVal Handle As Long) As Boolean
   SetExtGState = pdfSetExtGState(m_Instance, Handle) <> 0
End Function

Friend Function SetExtStrokeColorSpace(ByVal Handle As Long) As Boolean
   SetExtStrokeColorSpace = pdfSetExtStrokeColorSpace(m_Instance, Handle) <> 0
End Function

Friend Function SetFieldBackColor(ByVal AColor As Long) As Boolean
   SetFieldBackColor = pdfSetFieldBackColor(m_Instance, AColor) <> 0
End Function

Friend Function SetFieldBBox(ByVal Field As Long, ByRef BBox As TPDFRect) As Boolean
    SetFieldBBox = pdfSetFieldBBox(m_Instance, Field, BBox) <> 0
End Function

Friend Function SetFieldBorderColor(ByVal AColor As Long) As Boolean
   SetFieldBorderColor = pdfSetFieldBorderColor(m_Instance, AColor) <> 0
End Function

Friend Function SetFieldBorderStyle(ByVal Field As Long, ByVal aStyle As TBorderStyle) As Boolean
   SetFieldBorderStyle = pdfSetFieldBorderStyle(m_Instance, Field, aStyle) <> 0
End Function

Friend Function SetFieldBorderWidth(ByVal Field As Long, ByVal LineWidth As Double) As Boolean
   SetFieldBorderWidth = pdfSetFieldBorderWidth(m_Instance, Field, LineWidth) <> 0
End Function

Friend Function SetFieldCalcOrder(ByVal CurrIndex As Long, ByVal NewIndex As Long) As Boolean
   SetFieldCalcOrder = pdfSetFieldCalcOrder(m_Instance, CurrIndex, NewIndex) <> 0
End Function

Friend Function SetFieldColor(ByVal Field As Long, ByVal ColorType As TFieldColor, ByVal CS As TPDFColorSpace, ByVal Color As Long) As Boolean
   SetFieldColor = pdfSetFieldColor(m_Instance, Field, ColorType, CS, Color) <> 0
End Function

Friend Function SetFieldExpValue(ByVal Field As Long, ByVal ValIndex As Long, ByVal Value As String, ByVal ExpValue As String, ByVal Selected As Boolean) As Boolean
   SetFieldExpValue = pdfSetFieldExpValueW(m_Instance, Field, ValIndex, StrPtr(Value), ExpValue, Selected) <> 0
End Function

Friend Function SetFieldExpValueW(ByVal Field As Long, ByVal ValIndex As Long, ByVal Value As String, ByVal ExpValue As String, ByVal Selected As Boolean) As Boolean
   SetFieldExpValueW = pdfSetFieldExpValueW(m_Instance, Field, ValIndex, StrPtr(Value), ExpValue, Selected) <> 0
End Function

Friend Function SetFieldExpValueEx(ByVal AField As Long, ByVal ValIndex As Long, ByVal Selected As Boolean, ByVal DefSelected As Boolean) As Boolean
   SetFieldExpValueEx = pdfSetFieldExpValueEx(m_Instance, AField, ValIndex, Selected, DefSelected) <> 0
End Function

Friend Function SetFieldFlags(ByVal Field As Long, ByVal Flags As TFieldFlags, ByVal DoReset As Boolean) As Boolean
   SetFieldFlags = pdfSetFieldFlags(m_Instance, Field, Flags, DoReset) <> 0
End Function

Friend Function SetFieldFont(ByVal Field As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   SetFieldFont = pdfSetFieldFontW(m_Instance, Field, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFieldFontA(ByVal Field As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   SetFieldFontA = pdfSetFieldFontA(m_Instance, Field, Name, Style, Size, Embed, CP)
End Function

Friend Function SetFieldFontW(ByVal Field As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Long, ByVal CP As TCodepage) As Long
   SetFieldFontW = pdfSetFieldFontW(m_Instance, Field, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFieldFontEx(ByVal Field As Long, ByVal Handle As Long, ByVal FontSize As Double) As Long
   SetFieldFontEx = pdfSetFieldFontEx(m_Instance, Field, Handle, FontSize)
End Function

Friend Function SetFieldFontSize(ByVal Field As Long, ByVal FontSize As Double) As Boolean
    SetFieldFontSize = pdfSetFieldFontSize(m_Instance, Field, FontSize) <> 0
End Function

Friend Function SetFieldHighlightMode(ByVal Field As Long, ByVal Mode As THighlightMode) As Boolean
   SetFieldHighlightMode = pdfSetFieldHighlightMode(m_Instance, Field, Mode) <> 0
End Function

Friend Function SetFieldIndex(ByVal Field As Long, ByVal Index As Long) As Boolean
   SetFieldIndex = pdfSetFieldIndex(m_Instance, Field, Index) <> 0
End Function

Friend Function SetFieldMapName(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldMapName = pdfSetFieldMapNameW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetFieldMapNameA(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldMapNameA = pdfSetFieldMapNameA(m_Instance, Field, Value) <> 0
End Function

Friend Function SetFieldMapNameW(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldMapNameW = pdfSetFieldMapNameW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetFieldName(ByVal Field As Long, ByVal NewName As String) As Boolean
   SetFieldName = pdfSetFieldNameW(m_Instance, Field, NewName) <> 0
End Function

Friend Function SetFieldNameA(ByVal Field As Long, ByVal NewName As String) As Boolean
   SetFieldNameA = pdfSetFieldNameA(m_Instance, Field, NewName) <> 0
End Function

Friend Function SetFieldNameW(ByVal Field As Long, ByVal NewName As String) As Boolean
   SetFieldNameW = pdfSetFieldNameW(m_Instance, Field, StrPtr(NewName)) <> 0
End Function

Friend Function SetFieldOrientation(ByVal Field As Long, ByVal Value As Long) As Boolean
   SetFieldOrientation = pdfSetFieldOrientation(m_Instance, Field, Value) <> 0
End Function

Friend Function SetFieldTextAlign(ByVal Field As Long, ByVal Align As TTextAlign) As Boolean
   SetFieldTextAlign = pdfSetFieldTextAlign(m_Instance, Field, Align) <> 0
End Function

Friend Function SetFieldTextColor(ByVal Color As Long) As Boolean
   SetFieldTextColor = pdfSetFieldTextColor(m_Instance, Color) <> 0
End Function

Friend Function SetFieldToolTip(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldToolTip = pdfSetFieldToolTipW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetFieldToolTipA(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldToolTipA = pdfSetFieldToolTipA(m_Instance, Field, Value) <> 0
End Function

Friend Function SetFieldToolTipW(ByVal Field As Long, ByVal Value As String) As Boolean
   SetFieldToolTipW = pdfSetFieldToolTipW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetFillColor(ByVal Color As Long) As Boolean
   SetFillColor = pdfSetFillColor(m_Instance, Color) <> 0
End Function

Friend Function SetFillColorEx(ByRef Color() As Byte, ByVal NumComponents As Long) As Boolean
   SetFillColorEx = pdfSetFillColorEx(m_Instance, Color(0), NumComponents) <> 0
End Function

Friend Function SetFillColorF(ByRef Color() As Single, ByVal NumComponents As Long) As Boolean
   SetFillColorF = pdfSetFillColorF(m_Instance, Color(0), NumComponents) <> 0
End Function

Friend Function SetFloatPrecision(ByVal NumTextDecDigits As Long, ByVal NumVectDecDigits As Long) As Boolean
   SetFloatPrecision = pdfSetFloatPrecision(m_Instance, NumTextDecDigits, NumVectDecDigits) <> 0
End Function

Friend Function SetFont(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFont = pdfSetFontW(m_Instance, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFontA(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFontA = pdfSetFontA(m_Instance, Name, Style, Size, Embed, CP)
End Function

Friend Function SetFontW(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFontW = pdfSetFontW(m_Instance, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFontEx(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFontEx = pdfSetFontExW(m_Instance, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFontExA(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFontExA = pdfSetFontExA(m_Instance, Name, Style, Size, Embed, CP)
End Function

Friend Function SetFontExW(ByVal Name As String, ByVal Style As TFStyle, ByVal Size As Double, ByVal Embed As Boolean, ByVal CP As TCodepage) As Long
   SetFontExW = pdfSetFontExW(m_Instance, StrPtr(Name), Style, Size, Embed, CP)
End Function

Friend Function SetFontOrigin(ByVal Origin As TOrigin) As Boolean
   SetFontOrigin = pdfSetFontOrigin(m_Instance, Origin) <> 0
End Function

Friend Sub SetFontSearchOrder(ByRef Order() As TFontBaseType)
   pdfSetFontSearchOrder m_Instance, Order(0)
End Sub

Friend Sub SetFontSearchOrderEx(ByVal S1 As TFontBaseType, ByVal S2 As TFontBaseType, ByVal S3 As TFontBaseType, ByVal S4 As TFontBaseType)
   pdfSetFontSearchOrderEx m_Instance, S1, S2, S3, S4
End Sub

Friend Function SetFontSelMode(ByVal Mode As TFontSelMode) As Boolean
   SetFontSelMode = pdfSetFontSelMode(m_Instance, Mode) <> 0
End Function

Friend Function SetFontWeight(ByVal Weight As Long) As Boolean
   SetFontWeight = pdfSetFontWeight(m_Instance, Weight) <> 0
End Function

Friend Sub SetGStateFlags(ByVal Flags As TGStateFlags, ByVal Reset As Boolean)
   pdfSetGStateFlags m_Instance, Flags, Reset
End Sub

Friend Function SetIconColor(ByVal Color As Long) As Boolean
   SetIconColor = pdfSetIconColor(m_Instance, Color) <> 0
End Function

Friend Function SetImportFlags(ByVal Flags As TImportFlags) As Boolean
   SetImportFlags = pdfSetImportFlags(m_Instance, Flags) <> 0
End Function

Friend Function SetImportFlags2(ByVal Flags As TImportFlags2) As Boolean
   SetImportFlags2 = pdfSetImportFlags2(m_Instance, Flags) <> 0
End Function

Friend Function SetItalicAngle(ByVal Angle As Double) As Boolean
   SetItalicAngle = pdfSetItalicAngle(m_Instance, Angle) <> 0
End Function

Friend Function SetJPEGQuality(ByVal Value As Long) As Boolean
   SetJPEGQuality = pdfSetJPEGQuality(m_Instance, Value) <> 0
End Function

Friend Function SetLanguage(ByVal ISOTag As String) As Boolean
   SetLanguage = pdfSetLanguage(m_Instance, ISOTag) <> 0
End Function

Friend Function SetLeading(ByVal Value As Double) As Boolean
   SetLeading = pdfSetLeading(m_Instance, Value) <> 0
End Function

Friend Function SetLicenseKey(ByVal Value As String) As Boolean
   SetLicenseKey = pdfSetLicenseKey(m_Instance, Value) <> 0
End Function

Friend Function SetLineAnnotParms(ByVal Handle As Long, ByVal FontHandle As Long, ByVal FontSize As Double, ByRef Parms As TLineAnnotParms) As Boolean
   Parms.StructSize = LenB(Parms)
   SetLineAnnotParms = pdfSetLineAnnotParms(m_Instance, Handle, FontHandle, FontSize, Parms) <> 0
End Function

Friend Function SetLineAnnotParmsNothing(ByVal Handle As Long) As Boolean
   SetLineAnnotParmsNothing = pdfSetLineAnnotParms2(m_Instance, Handle, -1, 0#, 0) <> 0
End Function

Friend Function SetLineAnnotPoints(ByVal Handle As Long, ByRef p1 As TFltPoint, ByRef p2 As TFltPoint) As Boolean
   SetLineAnnotPoints = pdfSetLineAnnotPoints(m_Instance, Handle, p1, p2) <> 0
End Function

Friend Function SetLineCapStyle(ByVal Style As TLineCapStyle) As Boolean
   SetLineCapStyle = pdfSetLineCapStyle(m_Instance, Style) <> 0
End Function

Friend Function SetLineDashPattern(ByVal Dash As String, ByVal Phase As Long) As Boolean
   SetLineDashPattern = pdfSetLineDashPattern(m_Instance, Dash, Phase) <> 0
End Function

Friend Function SetLineDashPattern2(ByRef Dash() As Single, ByVal Phase As Single) As Boolean
   SetLineDashPattern2 = pdfSetLineDashPattern2(m_Instance, Dash(0), UBound(Dash) + 1, Phase) <> 0
End Function

Friend Function SetLineDashPatternEx(Dash() As Double, ByVal NumValues As Long, ByVal Phase As Long) As Boolean
   SetLineDashPatternEx = pdfSetLineDashPatternEx(m_Instance, Dash(0), NumValues, Phase) <> 0
End Function

Friend Function SetLineJoinStyle(ByVal Style As TLineJoinStyle) As Boolean
   SetLineJoinStyle = pdfSetLineJoinStyle(m_Instance, Style) <> 0
End Function

Friend Function SetLineWidth(ByVal Value As Double) As Boolean
   SetLineWidth = pdfSetLineWidth(m_Instance, Value) <> 0
End Function

Friend Function SetLinkHighlightMode(ByVal Mode As THighlightMode) As Boolean
   SetLinkHighlightMode = pdfSetLinkHighlightMode(m_Instance, Mode) <> 0
End Function

Friend Function SetListFont(ByVal Handle As Long) As Boolean
   SetListFont = pdfSetListFont(m_Instance, Handle) <> 0
End Function

Friend Function SetMatrix(ByRef Matrix As TCTM) As Boolean
   SetMatrix = pdfSetMatrix(m_Instance, Matrix) <> 0
End Function

Friend Sub SetMaxErrLogMsgCount(ByVal Value As Long)
   pdfSetMaxErrLogMsgCount m_Instance, Value
End Sub

Friend Function SetMaxFieldLen(ByVal TxtField As Long, ByVal MaxLen As Long) As Boolean
   SetMaxFieldLen = pdfSetMaxFieldLen(m_Instance, TxtField, MaxLen) <> 0
End Function

Friend Function SetMetaConvFlags(ByVal Flags As TMetaFlags) As Boolean
   SetMetaConvFlags = pdfSetMetaConvFlags(m_Instance, Flags) <> 0
End Function

Friend Function SetMetadata(ByVal ObjType As TMetadataObj, ByVal Handle As Long, ByRef Buffer() As Byte) As Boolean
   SetMetadata = pdfSetMetadata(m_Instance, ObjType, Handle, Buffer, UBound(Buffer) + 1) <> 0
End Function

Friend Sub SetMinLineWidth2(ByVal RasPtr As Long, ByVal Value As Single)
   rasSetMinLineWidth2 RasPtr, Value
End Sub

Friend Function SetMiterLimit(ByVal Value As Double) As Boolean
   SetMiterLimit = pdfSetMiterLimit(m_Instance, Value) <> 0
End Function

Friend Function SetNeedAppearance(ByVal Value As Boolean) As Boolean
   SetNeedAppearance = pdfSetNeedAppearance(m_Instance, Value) <> 0
End Function

Friend Function SetNumberFormat(ByVal TxtField As Long, ByVal Sep As TDecSeparator, ByVal DecPlaces As Long, ByVal NegStyle As TNegativeStyle, ByVal CurrStr As String, ByVal Prepend As Long) As Boolean
   SetNumberFormat = pdfSetNumberFormat(m_Instance, TxtField, Sep, DecPlaces, NegStyle, CurrStr, Prepend) <> 0
End Function

Friend Function SetOCGContUsage(ByVal Handle As Long, ByRef Value As TPDFOCGContUsage) As Boolean
   Dim tmp As TPDFOCGContUsage_I
   Dim Lang As String, PrintSubtype As String, InfoSubtype As String
   Lang = StrConv(Value.Language, vbFromUnicode, 0)
   InfoSubtype = StrConv(Value.InfoSubtype, vbFromUnicode, 0)
   PrintSubtype = StrConv(Value.PrintSubtype, vbFromUnicode, 0)
   tmp.StructSize = LenB(tmp)
   tmp.ExportState = Value.ExportState
   tmp.InfoCreatorA = 0
   tmp.InfoCreatorW = StrPtr(Value.InfoCreator)
   tmp.InfoSubtype = StrPtr(InfoSubtype)
   tmp.LangPreferred = Value.LangPreferred
   tmp.LanguageA = StrPtr(Lang)
   tmp.LanguageW = 0
   tmp.PageElement = Value.PageElement
   tmp.PrintState = Value.PrintState
   tmp.PrintSubtype = StrPtr(PrintSubtype)
   tmp.UserNamesCount = 0
   tmp.UserType = utNotSet
   tmp.ViewState = Value.ViewState
   tmp.ZoomMax = Value.ZoomMax
   tmp.ZoomMin = Value.ZoomMin
   SetOCGContUsage = pdfSetOCGContUsage(m_Instance, Handle, tmp) <> 0
End Function

Friend Function SetOCGState(ByVal Handle As Long, ByVal Visible As Boolean, ByVal SaveState As Boolean) As Boolean
   SetOCGState = pdfSetOCGState(m_Instance, Handle, Visible, SaveState) <> 0
End Function

Friend Function SetOpacity(ByVal Value As Double) As Boolean
   SetOpacity = pdfSetOpacity(m_Instance, Value) <> 0
End Function

Friend Function SetOrientation(ByVal Value As Long) As Boolean
   SetOrientation = pdfSetOrientation(m_Instance, Value) <> 0
End Function

Friend Function SetOrientationEx(ByVal Value As Long) As Boolean
   SetOrientationEx = pdfSetOrientationEx(m_Instance, Value) <> 0
End Function

Friend Function SetPageBBox(ByVal PagePtr As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TFltRect) As Boolean
   SetPageBBox = pdfSetPageBBox(PagePtr, Boundary, BBox) <> 0
End Function

Friend Function SetPageCoords(ByVal PageCoords As TPageCoord) As Boolean
   SetPageCoords = pdfSetPageCoords(m_Instance, PageCoords) <> 0
End Function

Friend Function SetPageFormat(ByVal Value As TPageFormat) As Boolean
   SetPageFormat = pdfSetPageFormat(m_Instance, Value) <> 0
End Function

Friend Function SetPageHeight(ByVal Value As Double) As Boolean
   SetPageHeight = pdfSetPageHeight(m_Instance, Value) <> 0
End Function

Friend Function SetPageLayout(ByVal Layout As TPageLayout) As Boolean
   SetPageLayout = pdfSetPageLayout(m_Instance, Layout) <> 0
End Function

Friend Function SetPageMode(ByVal Mode As TPageMode) As Boolean
   SetPageMode = pdfSetPageMode(m_Instance, Mode) <> 0
End Function

Friend Function SetPageOrientation(ByVal PagePtr As Long, ByVal Value As Long) As Boolean
   SetPageOrientation = pdfSetPageOrientation(m_Instance, PagePtr, Value) <> 0
End Function

Friend Function SetPageWidth(ByVal Value As Double) As Boolean
   SetPageWidth = pdfSetPageWidth(m_Instance, Value) <> 0
End Function

Friend Function SetPDFVersion(ByVal Version As TPDFVersion) As Boolean
   SetPDFVersion = pdfSetPDFVersion(m_Instance, Version) <> 0
End Function

Friend Function SetPrintSettings(ByVal Mode As TDuplexMode, ByVal PickTrayByPDFSize As Long, ByVal NumCopies As Long, ByVal PrintScaling As TPrintScaling, ByRef PrintRanges() As Long) As Boolean
   SetPrintSettings = pdfSetPrintSettings(m_Instance, Mode, PickTrayByPDFSize, NumCopies, PrintScaling, VarPtr(PrintRanges(0)), (UBound(PrintRanges) + 1) / 2) <> 0
End Function

Friend Function SetRenderingIntent(ByVal ImgHandle As Long, ByVal Value As TRenderingIntent) As Boolean
   SetRenderingIntent = pdfSetRenderingIntent(m_Instance, ImgHandle, Value) <> 0
End Function

Friend Function SetResolution(ByVal Value As Long) As Boolean
   SetResolution = pdfSetResolution(m_Instance, Value) <> 0
End Function

Friend Function SetSaveNewImageFormat(ByVal Value As Boolean) As Boolean
   SetSaveNewImageFormat = pdfSetSaveNewImageFormat(m_Instance, Value) <> 0
End Function

Friend Sub SetScreenRes(ByVal RasPtr As Long, ByVal Value As Long)
   rasSetScreenRes RasPtr, Value
End Sub

Friend Function SetSpaceWidthFactor(ByVal Value As Double) As Boolean
   SetSpaceWidthFactor = pdfSetSpaceWidthFactor(m_Instance, Value) <> 0
End Function

Friend Function SetStrokeColor(ByVal Color As Long) As Boolean
   SetStrokeColor = pdfSetStrokeColor(m_Instance, Color) <> 0
End Function

Friend Function SetStrokeColorEx(ByRef Color() As Byte, ByVal NumComponents As Long) As Boolean
   SetStrokeColorEx = pdfSetStrokeColorEx(m_Instance, Color(0), NumComponents) <> 0
End Function

Friend Function SetStrokeColorF(ByRef Color() As Single, ByVal NumComponents As Long) As Boolean
   SetStrokeColorF = pdfSetStrokeColorF(m_Instance, Color(0), NumComponents) <> 0
End Function

Friend Function SetTabLen(ByVal TabLen As Long) As Boolean
   SetTabLen = pdfSetTabLen(m_Instance, TabLen) <> 0
End Function

Friend Function SetTemplBBox(ByVal Handle As Long, ByVal Boundary As TPageBoundary, ByRef BBox As TPDFRect) As Boolean
   SetTemplBBox = pdfSetTemplBBox(m_Instance, Handle, Boundary, BBox) <> 0
End Function

Friend Function SetTextDrawMode(ByVal Mode As TDrawMode) As Boolean
   SetTextDrawMode = pdfSetTextDrawMode(m_Instance, Mode) <> 0
End Function

Friend Function SetTextFieldValue(ByVal Field As Long, ByVal Value As String, ByVal DefValue As String, ByVal Align As TTextAlign) As Boolean
   SetTextFieldValue = pdfSetTextFieldValueW(m_Instance, Field, StrPtr(Value), StrPtr(DefValue), Align) <> 0
End Function

Friend Function SetTextFieldValueA(ByVal Field As Long, ByVal Value As String, ByVal DefValue As String, ByVal Align As TTextAlign) As Boolean
   SetTextFieldValueA = pdfSetTextFieldValueA(m_Instance, Field, Value, DefValue, Align) <> 0
End Function

Friend Function SetTextFieldValueW(ByVal Field As Long, ByVal Value As String, ByVal DefValue As String, ByVal Align As TTextAlign) As Boolean
   SetTextFieldValueW = pdfSetTextFieldValueW(m_Instance, Field, StrPtr(Value), StrPtr(DefValue), Align) <> 0
End Function

Friend Function SetTextFieldValueEx(ByVal Field As Long, ByVal Value As String) As Boolean
   SetTextFieldValueEx = pdfSetTextFieldValueExW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetTextFieldValueExA(ByVal Field As Long, ByVal Value As String) As Boolean
   SetTextFieldValueExA = pdfSetTextFieldValueExA(m_Instance, Field, Value) <> 0
End Function

Friend Function SetTextFieldValueExW(ByVal Field As Long, ByVal Value As String) As Boolean
   SetTextFieldValueExW = pdfSetTextFieldValueExW(m_Instance, Field, StrPtr(Value)) <> 0
End Function

Friend Function SetTextRect(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Boolean
   SetTextRect = pdfSetTextRect(m_Instance, PosX, PosY, Width, Height) <> 0
End Function

Friend Function SetTextRise(ByVal Value As Double) As Boolean
   SetTextRise = pdfSetTextRise(m_Instance, Value) <> 0
End Function

Friend Function SetTextScaling(ByVal Value As Double) As Boolean
   SetTextScaling = pdfSetTextScaling(m_Instance, Value) <> 0
End Function

Friend Function SetTransparentColor(ByVal AColor As Long) As Boolean
   SetTransparentColor = pdfSetTransparentColor(m_Instance, AColor) <> 0
End Function

Friend Sub SetTrapped(ByVal Value As Boolean)
   pdfSetTrapped m_Instance, Value
End Sub

Friend Function SetUseExactPwd(ByVal Value As Boolean) As Boolean
   SetUseExactPwd = pdfSetUseExactPwd(m_Instance, Value) <> 0
End Function

Friend Function SetUseGlobalImpFiles(ByVal Value As Boolean) As Boolean
   SetUseGlobalImpFiles = pdfSetUseGlobalImpFiles(m_Instance, Value) <> 0
End Function

Friend Function SetUseImageInterpolation(ByVal Handle As Long, ByVal Value As Long) As Boolean
   SetUseImageInterpolation = pdfSetUseImageInterpolation(m_Instance, Handle, Value) <> 0
End Function

Friend Function SetUseImageInterpolationEx(ByVal Image As Long, ByVal Value As Long) As Boolean
   SetUseImageInterpolationEx = pdfSetUseImageInterpolationEx(Image, Value) <> 0
End Function

Friend Function SetUserUnit(ByVal Value As Single) As Boolean
   SetUserUnit = pdfSetUserUnit(m_Instance, Value)
End Function

Friend Function SetUseStdFonts(ByVal Value As Boolean) As Boolean
   SetUseStdFonts = pdfSetUseStdFonts(m_Instance, Value) <> 0
End Function

Friend Function SetUseSwapFile(ByVal SwapContents As Boolean, ByVal SwapLimit As Long) As Boolean
   SetUseSwapFile = pdfSetUseSwapFile(m_Instance, SwapContents, SwapLimit) <> 0
End Function

Friend Function SetUseSwapFileEx(ByVal SwapContents As Boolean, ByVal SwapLimit As Long, ByVal SwapDir As String) As Boolean
   SetUseSwapFileEx = pdfSetUseSwapFileEx(m_Instance, SwapContents, SwapLimit, SwapDir) <> 0
End Function

Friend Function SetUseSystemFonts(ByVal Value As Boolean) As Boolean
   SetUseSystemFonts = pdfSetUseSystemFonts(m_Instance, Value) <> 0
End Function

Friend Function SetUseTransparency(ByVal Value As Boolean) As Boolean
   SetUseTransparency = pdfSetUseTransparency(m_Instance, Value) <> 0
End Function

Friend Function SetUseVisibleCoords(ByVal Value As Boolean) As Boolean
   SetUseVisibleCoords = pdfSetUseVisibleCoords(m_Instance, Value) <> 0
End Function

Friend Function SetViewerPreferences(ByVal Value As TViewerPreference, ByVal AddVal As TViewPrefAddVal) As Boolean
   SetViewerPreferences = pdfSetViewerPreferences(m_Instance, Value, AddVal) <> 0
End Function

Friend Function SetWMFDefExtent(ByVal Width As Long, ByVal Height As Long) As Boolean
   SetWMFDefExtent = pdfSetWMFDefExtent(m_Instance, Width, Height) <> 0
End Function

Friend Function SetWMFPixelPerInch(ByVal Value As Long) As Boolean
   SetWMFPixelPerInch = pdfSetWMFPixelPerInch(m_Instance, Value) <> 0
End Function

Friend Function SetWordSpacing(ByVal Value As Double) As Boolean
   SetWordSpacing = pdfSetWordSpacing(m_Instance, Value) <> 0
End Function

Friend Function SetXFAStream(ByVal Index As Long, ByRef Buffer() As Byte) As Boolean
   SetXFAStream = pdfSetXFAStream(m_Instance, Index, Buffer(0), UBound(Buffer) + 1) <> 0
End Function

Friend Function SkewCoords(ByVal Alpha As Double, ByVal beta As Double, ByVal OriginX As Double, ByVal OriginY As Double) As Boolean
   SkewCoords = pdfSkewCoords(m_Instance, Alpha, beta, OriginX, OriginY) <> 0
End Function

Friend Function SortFieldsByIndex() As Boolean
   SortFieldsByIndex = pdfSortFieldsByIndex(m_Instance) <> 0
End Function

Friend Function SortFieldsByName() As Boolean
   SortFieldsByName = pdfSortFieldsByName(m_Instance) <> 0
End Function

Friend Function SquareAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   SquareAnnot = pdfSquareAnnotW(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function SquareAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   SquareAnnotA = pdfSquareAnnotA(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, Author, Subject, Comment)
End Function

Friend Function SquareAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal LineWidth As Double, ByVal FillColor As Long, ByVal StrokeColor As Long, ByVal CS As TPDFColorSpace, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   SquareAnnotW = pdfSquareAnnotW(m_Instance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function StampAnnot(ByVal Subtype As TRubberStamp, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   StampAnnot = pdfStampAnnotW(m_Instance, Subtype, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function StampAnnotA(ByVal Subtype As TRubberStamp, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   StampAnnotA = pdfStampAnnotA(m_Instance, Subtype, PosX, PosY, Width, Height, Author, Subject, Comment)
End Function

Friend Function StampAnnotW(ByVal Subtype As TRubberStamp, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal Subject As String, ByVal Comment As String) As Long
   StampAnnotW = pdfStampAnnotW(m_Instance, Subtype, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(Subject), StrPtr(Comment))
End Function

Friend Function StrLenA(ByVal AStr) As Long
   StrLenA = pdfStrLenA(AStr)
End Function

Friend Function StrokePath() As Boolean
   StrokePath = pdfStrokePath(m_Instance) <> 0
End Function

Friend Function TestGlyphs(ByVal FontHandle As Long, ByVal text As String) As Long
   TestGlyphs = pdfTestGlyphsW(m_Instance, FontHandle, text)
End Function

Friend Function TestGlyphsA(ByVal FontHandle As Long, ByVal text As String) As Long
   TestGlyphsA = pdfTestGlyphsA(m_Instance, FontHandle, text)
End Function

Friend Function TestGlyphsW(ByVal FontHandle As Long, ByVal text As String) As Long
   TestGlyphsW = pdfTestGlyphsW(m_Instance, FontHandle, text)
End Function

Friend Function TestGlyphsEx(ByVal FontHandle As Long, ByVal text As String, ByVal Length As Long) As Long
   TestGlyphsEx = pdfTestGlyphsExW(m_Instance, FontHandle, text, Length)
End Function

Friend Function TestGlyphsExA(ByVal FontHandle As Long, ByVal text As String, ByVal Length As Long) As Long
   TestGlyphsExA = pdfTestGlyphsExA(m_Instance, FontHandle, text, Length)
End Function

Friend Function TestGlyphsExW(ByVal FontHandle As Long, ByVal text As String, ByVal Length As Long) As Long
   TestGlyphsExW = pdfTestGlyphsExW(m_Instance, FontHandle, text, Length)
End Function

Friend Function TestPassword(ByVal PwdType As TPwdType, ByVal Value As String) As Boolean
   Dim Flags As Long
   Dim utf8() As Byte
   Dim ptr As Long
   utf8 = ToUTF8(Value)
   If IsArrayEmpty(utf8) Then
      ptr = 0
   Else
      ptr = VarPtr(utf8(0))
   End If
   Flags = pdfGetGStateFlags(m_Instance)
   Call pdfSetGStateFlags(m_Instance, gfAnsiStringIsUTF8, False)
   TestPassword = pdfTestPassword(m_Instance, PwdType, ptr) <> 0
   Call pdfSetGStateFlags(m_Instance, Flags, True)
End Function

Friend Function TextAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal text As String, ByVal Icon As TAnnotIcon, ByVal DoOpen As Boolean) As Long
   TextAnnot = pdfTextAnnotW(m_Instance, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(text), Icon, DoOpen)
End Function

Friend Function TextAnnotA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal text As String, ByVal Icon As TAnnotIcon, ByVal DoOpen As Boolean) As Long
   TextAnnotA = pdfTextAnnotA(m_Instance, PosX, PosY, Width, Height, Author, text, Icon, DoOpen)
End Function

Friend Function TextAnnotW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Author As String, ByVal text As String, ByVal Icon As TAnnotIcon, ByVal DoOpen As Boolean) As Long
   TextAnnotW = pdfTextAnnotW(m_Instance, PosX, PosY, Width, Height, StrPtr(Author), StrPtr(text), Icon, DoOpen)
End Function

Private Function ToUTF8(ByVal Value As String) As Byte()
   Dim ptr As Long
   Dim Size As Long, strLen As Long
   Dim buf() As Byte
   
   strLen = Len(Value)
   
   If strLen = 0 Then Exit Function
   
   ptr = StrPtr(Value)
   Size = WideCharToMultiByte(CP_UTF8, 0, ptr, strLen, 0, 0, 0, 0)
   ReDim buf(Size - 1)

   Call WideCharToMultiByte(CP_UTF8, 0, ptr, strLen, VarPtr(buf(0)), Size, 0, 0)
   
   ToUTF8 = buf
End Function

Friend Function TranslateCoords(ByVal OriginX As Double, ByVal OriginY As Double) As Boolean
   TranslateCoords = pdfTranslateCoords(m_Instance, OriginX, OriginY) <> 0
End Function

Friend Function TranslateRawCode(ByVal IFont As Long, ByVal text As Long, ByVal sLen As Long, ByRef Width As Double, ByRef OutText As String, ByRef OutLen As Long, ByRef Decoded As Long, ByVal CharSpacing As Single, ByVal WordSpacing As Single, ByVal TextScale As Single) As Long
   TranslateRawCode = fntTranslateRawCode(IFont, text, sLen, Width, StrPtr(OutText), OutLen, Decoded, CharSpacing, WordSpacing, TextScale)
End Function

Friend Function TranslateString(ByRef Stack As TPDFStack, ByRef OutText As String, ByVal Flags As Long) As Long
   TranslateString = fntTranslateString(FStack, StrPtr(OutText), Len(OutText), Flags)
End Function

Friend Function TranslateString2(ByVal IFont As Long, ByVal text As Long, ByVal sLen As Long, ByRef OutText As String, ByVal Flags As Long) As Long
   TranslateString2 = fntTranslateString2(IFont, text, sLen, StrPtr(OutText), Len(OutText), Flags)
End Function

Friend Function Triangle(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double, ByVal x3 As Double, ByVal y3 As Double, ByVal FillMode As TPathFillMode) As Boolean
   Triangle = pdfTriangle(m_Instance, x1, y1, x2, y2, x3, y3, FillMode) <> 0
End Function

Friend Function UnLockLayer(ByVal Layer As Long) As Long
   UnLockLayer = pdfUnLockLayer(m_Instance, Layer)
End Function

Friend Function WatermarkAnnot(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
   WatermarkAnnot = pdfWatermarkAnnot(m_Instance, PosX, PosY, Width, Height)
End Function

Friend Function WebLink(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal URL As String) As Long
   WebLink = pdfWebLinkW(m_Instance, PosX, PosY, Width, Height, StrPtr(URL))
End Function

Friend Function WebLinkA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal URL As String) As Long
   WebLinkA = pdfWebLinkA(m_Instance, PosX, PosY, Width, Height, URL)
End Function

Friend Function WebLinkW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal URL As String) As Long
   WebLinkW = pdfWebLinkW(m_Instance, PosX, PosY, Width, Height, StrPtr(URL))
End Function

Friend Function WeightFromStyle(ByVal Style As TFStyle) As Long
   WeightFromStyle = ((Style And &HFFF00000) / 1048576)
End Function

Friend Function WeightToStyle(ByVal Weight As Long) As TFStyle
   WeightToStyle = Weight * 1048576
End Function

Friend Function WidthFromStyle(ByVal Style As TFStyle) As Long
   WidthFromStyle = ((Style And &HF00) / 256)
End Function

Friend Function WidthToStyle(ByVal Width As Long) As TFStyle
   WidthToStyle = Width * 256
End Function

Friend Function WriteAngleText(ByVal AText As String, ByVal Angle As Double, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal YOrigin As Double) As Boolean
   WriteAngleText = pdfWriteAngleTextW(m_Instance, StrPtr(AText), Angle, PosX, PosY, Radius, YOrigin) <> 0
End Function

Friend Function WriteAngleTextA(ByVal AText As String, ByVal Angle As Double, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal YOrigin As Double) As Boolean
   WriteAngleTextA = pdfWriteAngleTextA(m_Instance, AText, Angle, PosX, PosY, Radius, YOrigin) <> 0
End Function

Friend Function WriteAngleTextW(ByVal AText As String, ByVal Angle As Double, ByVal PosX As Double, ByVal PosY As Double, ByVal Radius As Double, ByVal YOrigin As Double) As Boolean
   WriteAngleTextW = pdfWriteAngleTextW(m_Instance, StrPtr(AText), Angle, PosX, PosY, Radius, YOrigin) <> 0
End Function

Friend Function WriteFText(ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFText = pdfWriteFTextW(m_Instance, Align, StrPtr(AText)) <> 0
End Function

Friend Function WriteFTextA(ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFTextA = pdfWriteFTextA(m_Instance, Align, AText) <> 0
End Function

Friend Function WriteFTextW(ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFTextW = pdfWriteFTextW(m_Instance, Align, StrPtr(AText)) <> 0
End Function

Friend Function WriteFTextEx(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFTextEx = pdfWriteFTextExW(m_Instance, PosX, PosY, Width, Height, Align, StrPtr(AText)) <> 0
End Function

Friend Function WriteFTextExA(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFTextExA = pdfWriteFTextExA(m_Instance, PosX, PosY, Width, Height, Align, AText) <> 0
End Function

Friend Function WriteFTextExW(ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double, ByVal Align As TTextAlign, ByVal AText As String) As Boolean
   WriteFTextExW = pdfWriteFTextExW(m_Instance, PosX, PosY, Width, Height, Align, StrPtr(AText)) <> 0
End Function

Friend Function WriteText(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String) As Boolean
   WriteText = pdfWriteTextW(m_Instance, PosX, PosY, StrPtr(AText)) <> 0
End Function

Friend Function WriteTextA(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String) As Boolean
   WriteTextA = pdfWriteTextA(m_Instance, PosX, PosY, AText) <> 0
End Function

Friend Function WriteTextW(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String) As Boolean
   WriteTextW = pdfWriteTextW(m_Instance, PosX, PosY, StrPtr(AText)) <> 0
End Function

Friend Function WriteTextEx(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String, ByVal sLen As Long) As Boolean
   Dim s As String
   s = Mid(AText, 1, sLen)
   WriteTextEx = pdfWriteTextExW(m_Instance, PosX, PosY, StrPtr(s), Len(s)) <> 0
End Function

Friend Function WriteTextExA(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String, ByVal sLen As Long) As Boolean
   WriteTextExA = pdfWriteTextExA(m_Instance, PosX, PosY, AText, sLen) <> 0
End Function

Friend Function WriteTextExW(ByVal PosX As Double, ByVal PosY As Double, ByVal AText As String, ByVal sLen As Long) As Boolean
   Dim s As String
   s = Mid(AText, 1, sLen)
   WriteTextExW = pdfWriteTextExW(m_Instance, PosX, PosY, StrPtr(s), Len(s)) <> 0
End Function

Friend Function WriteTextMatrix(ByRef Matrix As TCTM, ByVal AText As String) As Boolean
   WriteTextMatrix = pdfWriteTextMatrixW(m_Instance, Matrix, StrPtr(AText)) <> 0
End Function

Friend Function WriteTextMatrixA(ByRef Matrix As TCTM, ByVal AText As String) As Boolean
   WriteTextMatrixA = pdfWriteTextMatrixA(m_Instance, Matrix, AText) <> 0
End Function

Friend Function WriteTextMatrixW(ByRef Matrix As TCTM, ByVal AText As String) As Boolean
   WriteTextMatrixW = pdfWriteTextMatrixW(m_Instance, Matrix, StrPtr(AText)) <> 0
End Function

Friend Function WriteTextMatrixEx(ByRef Matrix As TCTM, ByVal AText As String, ByVal sLen As Long) As Boolean
   Dim s As String
   s = Mid(AText, 1, sLen)
   WriteTextMatrixEx = pdfWriteTextMatrixExW(m_Instance, Matrix, StrPtr(s), Len(s)) <> 0
End Function

Friend Function WriteTextMatrixExA(ByRef Matrix As TCTM, ByVal AText As String, ByVal sLen As Long) As Boolean
   WriteTextMatrixExA = pdfWriteTextMatrixExA(m_Instance, Matrix, AText, sLen) <> 0
End Function

Friend Function WriteTextMatrixExW(ByRef Matrix As TCTM, ByVal AText As String, ByVal sLen As Long) As Boolean
   Dim s As String
   s = Mid(AText, 1, sLen)
   WriteTextMatrixExW = pdfWriteTextMatrixExW(m_Instance, Matrix, StrPtr(s), Len(s)) <> 0
End Function

' ------------------------------------------------- Private Functions -------------------------------------------------

Private Sub ConvertHeaderFooter(ByRef Dest As TPDFHeaderFooter, ByRef Source As TPDFHeaderFooter_I)
   Dest.FirstPage = Source.FirstPage
   Dest.Flags = Source.Flags
   Dest.InitCodepage = Source.InitCodepage
   Dest.InitColor = Source.InitColor
   Dest.InitCS = Source.InitCS
   Dest.InitCSHandle = Source.InitCSHandle
   Dest.InitDate = ToStringA(Source.InitDate)
   Dest.InitEmbed = Source.InitEmbed
   Dest.InitFont = ToStringEx(Source.InitFontA, Source.InitFontW)
   Dest.InitFontSize = Source.InitFontSize
   Dest.InitFontType = ToStringA(Source.InitFontType)
   Dest.InitPageFormat = ToStringEx(Source.InitPageFormatA, Source.InitPageFormatW)
   Dest.LastPage = Source.LastPage
   Dest.Margin = Source.Margin
End Sub

Private Sub ConvertHFArray(ByRef Dest() As TPDFHdrFtr, ByRef Source() As TPDFHdrFtr_I)
   Dim i As Long
   For i = 0 To UBound(Dest)
      Dest(i).CodePage = Source(i).CodePage
      Dest(i).Color = Source(i).Color
      Dest(i).CS = Source(i).CS
      Dest(i).CSHandle = Source(i).CSHandle
      Dest(i).Embed = Source(i).Embed
      Dest(i).Font = ToStringEx(Source(i).FontA, Source(i).FontW)
      Dest(i).FontSize = Source(i).FontSize
      Dest(i).IsHeader = Source(i).IsHeader
      Dest(i).Position = Source(i).Position
      Dest(i).ShiftX = Source(i).ShiftX
      Dest(i).ShiftY = Source(i).ShiftY
      Dest(i).text = ToStringEx(Source(i).TextA, Source(i).TextW)
   Next i
End Sub

Private Sub CopyFileSpecEx(ByRef Src As TPDFFileSpecEx_I, ByRef Dst As TPDFFileSpecEx)
   Dst.AFRelationship = ToStringA(Src.AFRelationship)
   Dst.ColItem = Src.ColItem
   Dst.Description = ToStringEx(Src.DescriptionA, Src.DescriptionW)
   Dst.DOS = ToStringA(Src.DOS)
   Dst.EmbFileNode = Src.EmbFileNode
   Dst.FileName = ToStringA(Src.FileName)
   Dst.FileNameIsURL = Src.FileNameIsURL <> 0
   If Src.ID1Len > 0 Then
      ReDim Dst.ID1(Src.ID1Len - 1)
      pdfCopyMem2 Src.ID1, Dst.ID1(0), Src.ID1Len
   Else
      Erase Dst.ID1
   End If
   If Src.ID2Len > 0 Then
      ReDim Dst.ID2(Src.ID2Len - 1)
      pdfCopyMem2 Src.ID2, Dst.ID2(0), Src.ID2Len
   Else
      Erase Dst.ID2
   End If
   Dst.IsVolatile = Src.IsVolatile <> 0
   Dst.Mac = ToStringA(Src.Mac)
   Dst.Unix = ToStringA(Src.Unix)
   Dst.RelFileNode = Src.RelFileNode
   Dst.Thumb = Src.Thumb
   Dst.UFileName = ToStringEx(Src.UFileNameA, Src.UFileNameW)
End Sub

Private Sub CopyFloatArray(ByVal ptr, ByRef Value() As Single, ByVal Count As Long)
   If Count > 0 Then
      ReDim Value(Count - 1)
      Call pdfCopyMem2(ptr, Value(0), Count * 4)
   Else
      Erase Value
   End If
End Sub

Private Sub CopyIntArray(ByVal ptr, ByRef Value() As Long, ByVal Count As Long)
   If Count > 0 Then
      ReDim Value(Count - 1)
      Call pdfCopyMem2(ptr, Value(0), Count * 4)
   Else
      Erase Value
   End If
End Sub

Private Sub GetIntAnnot(ByRef IAnnot As TPDFAnnotation_I, ByRef Annot As TPDFAnnotation)
   Annot.AnnotType = IAnnot.AnnotType
   Annot.Author = ToStringEx(IAnnot.AuthorA, IAnnot.AuthorW)
   Annot.Content = ToStringEx(IAnnot.ContentA, IAnnot.ContentW)
   Annot.Deleted = IAnnot.Deleted
   Annot.BBox = IAnnot.BBox
   Annot.BorderWidth = IAnnot.BorderWidth
   Annot.BorderColor = IAnnot.BorderColor
   Annot.BorderStyle = IAnnot.BorderStyle
   Annot.BackColor = IAnnot.BackColor
   Annot.Handle = IAnnot.Handle
   Annot.HighlightMode = IAnnot.HighlightMode
   Annot.Name = ToStringEx(IAnnot.NameA, IAnnot.NameW)
   Annot.PageNum = IAnnot.PageNum
   Annot.Subject = ToStringEx(IAnnot.SubjectA, IAnnot.SubjectW)
End Sub

Private Sub GetIntAnnotEx(ByRef IAnnot As TPDFAnnotationEx_I, ByRef Annot As TPDFAnnotationEx)
   Annot.AnnotFlags = IAnnot.AnnotFlags
   Annot.AnnotType = IAnnot.AnnotType
   Annot.Author = ToStringEx(IAnnot.AuthorA, IAnnot.AuthorW)
   Annot.BackColor = IAnnot.BackColor
   Annot.BBox = IAnnot.BBox
   Annot.BorderWidth = IAnnot.BorderWidth
   Annot.BorderColor = IAnnot.BorderColor
   Annot.BorderEffect = IAnnot.BorderEffect
   Annot.BorderStyle = IAnnot.BorderStyle
   Annot.Caption = IAnnot.Caption <> 0
   Annot.CaptionOffsetX = IAnnot.CaptionOffsetX
   Annot.CaptionOffsetY = IAnnot.CaptionOffsetY
   Annot.CaptionPos = IAnnot.CaptionPos
   Annot.Content = ToStringEx(IAnnot.ContentA, IAnnot.ContentW)
   Annot.CreateDate = ToStringA(IAnnot.CreateDate)
   Annot.Deleted = IAnnot.Deleted
   Annot.DestFile = ToStringA(IAnnot.DestFile)
   Annot.DestPage = IAnnot.DestPage
   Annot.DestPos = IAnnot.DestPos
   Annot.DestType = IAnnot.DestType
   Annot.EmbeddedFile = IAnnot.EmbeddedFile
   Annot.Grouped = IAnnot.Grouped <> 0
   Annot.Handle = IAnnot.Handle
   Annot.HighlightMode = IAnnot.HighlightMode
   Annot.Icon = IAnnot.Icon
   Annot.Intent = ToStringA(IAnnot.Intent)
   Annot.LeaderLineLen = IAnnot.LeaderLineLen
   Annot.LeaderLineExtend = IAnnot.LeaderLineExtend
   Annot.LeaderLineOffset = IAnnot.LeaderLineOffset
   Annot.LE1 = IAnnot.LE1
   Annot.LE2 = IAnnot.LE2
   Annot.MarkupAnnot = IAnnot.MarkupAnnot <> 0
   Annot.ModDate = ToStringA(IAnnot.ModDate)
   Annot.Name = ToStringEx(IAnnot.NameA, IAnnot.NameW)
   Annot.OC = IAnnot.OC
   Annot.Opacity = IAnnot.Opacity
   Annot.Open = IAnnot.Open <> 0
   Annot.PageIndex = IAnnot.PageIndex
   Annot.PageNum = IAnnot.PageNum
   Annot.Parent = IAnnot.Parent
   Annot.PopUp = IAnnot.PopUp
   Annot.RichStyle = ToStringA(IAnnot.RichStyle)
   Annot.RichText = ToStringA(IAnnot.RichText)
   Annot.Rotate = IAnnot.Rotate
   Annot.Subject = ToStringEx(IAnnot.SubjectA, IAnnot.SubjectW)
   Annot.StampName = ToStringA(IAnnot.StampName)
   Annot.State = ToStringA(IAnnot.State)
   Annot.StateModel = ToStringA(IAnnot.StateModel)
   Annot.Subtype = ToStringA(IAnnot.Subtype)

   If IAnnot.InkListCount > 0 Then
      ReDim Annot.InkList(IAnnot.InkListCount - 1)
      pdfCopyMem2 IAnnot.InkList, Annot.InkList(0), IAnnot.InkListCount * 4
   Else
      Erase Annot.InkList
   End If
   If IAnnot.DashPatternCount > 0 Then
      ReDim Annot.DashPattern(IAnnot.DashPatternCount - 1)
      pdfCopyMem2 IAnnot.DashPattern, Annot.DashPattern(0), IAnnot.DashPatternCount * 4
   Else
      Erase Annot.DashPattern
   End If
   If IAnnot.QuadPointsCount > 0 Then
      ReDim Annot.QuadPoints(IAnnot.QuadPointsCount - 1)
      pdfCopyMem2 IAnnot.QuadPoints, Annot.QuadPoints(0), IAnnot.QuadPointsCount * 4
   Else
      Erase Annot.QuadPoints
   End If
   If IAnnot.RD <> 0 Then
      ReDim Annot.RD(3)
      pdfCopyMem2 IAnnot.RD, Annot.RD(0), 16
   Else
      Erase Annot.RD
   End If
   If IAnnot.VerticesCount > 0 Then
      ReDim Annot.Vertices(IAnnot.VerticesCount - 1)
      pdfCopyMem2 IAnnot.Vertices, Annot.Vertices(0), IAnnot.VerticesCount * 4
   Else
      Erase Annot.Vertices
   End If
End Sub

Private Sub GetIntBarcode(ByRef IBC As TPDFBarcode_I, ByRef bc As TPDFBarcode)
   bc.Caption = ToStringEx(IBC.CaptionA, IBC.CaptionW)
   bc.ECC = IBC.ECC
   bc.Height = IBC.Height
   bc.nCodeWordCol = IBC.nCodeWordCol
   bc.nCodeWordRow = IBC.nCodeWordRow
   bc.Resolution = IBC.Resolution
   bc.Symbology = ToStringA(IBC.Symbology)
   bc.Version = IBC.Version
   bc.Width = IBC.Width
   bc.XSymHeight = IBC.XSymHeight
   bc.XSymWidth = IBC.XSymWidth
End Sub

Private Sub GetIntColorSpaceObj(ByRef ics As TPDFColorSpaceObj_I, ByRef CS As TPDFColorSpaceObj)
   Dim i As Long
   CS.ColorSpaceType = ics.ColorSpaceType
   CS.Alternate = ics.Alternate
   CS.IAlternate = ics.IAlternate
   CS.Buffer = ics.Buffer
   CS.BufSize = ics.BufSize
   CS.NumInComponents = ics.NumInComponents
   CS.NumOutComponents = ics.NumOutComponents
   CS.NumColors = ics.NumColors
   CS.ColorantsCount = ics.ColorantsCount
   CS.Metadata = ics.Metadata
   CS.MetadataSize = ics.MetadataSize
   CS.IFunction = ics.IFunction
   CS.IAttributes = ics.IAttributes
   CS.IColorSpaceObj = ics.IColorSpaceObj
   CS.Handle = ics.Handle
   If ics.BlackPoint <> 0 Then
      ReDim CS.BlackPoint(2)
      pdfCopyMem2 ics.BlackPoint, CS.BlackPoint(0), 12
   Else
      Erase CS.BlackPoint
   End If
   If ics.WhitePoint <> 0 Then
      ReDim CS.WhitePoint(2)
      pdfCopyMem2 ics.WhitePoint, CS.WhitePoint(0), 12
   Else
      Erase CS.WhitePoint
   End If
   If ics.Gamma <> 0 Then
      ReDim CS.Gamma(CS.NumInComponents - 1)
      pdfCopyMem2 ics.Gamma, CS.Gamma(0), CS.NumInComponents * 4
   Else
      Erase CS.Gamma
   End If
   If ics.Range <> 0 Then
      If ics.ColorSpaceType = esLab Then
         ReDim CS.Range(3)
         pdfCopyMem2 ics.Range, CS.Range(0), 16
      Else
         ReDim CS.Range(CS.NumInComponents * 2 - 1)
         pdfCopyMem2 ics.Range, CS.Range(0), CS.NumInComponents * 8
      End If
   Else
      Erase CS.Range
   End If
   If ics.Matrix <> 0 Then
      ReDim CS.Matrix(8)
      pdfCopyMem2 ics.Matrix, CS.Matrix(0), 36
   Else
      Erase CS.Matrix
   End If
   Erase CS.Colorants
   For i = 0 To CS.ColorantsCount - 1
      CS.Colorants(i) = UTF8ToString(ics.Colorants(i))
   Next i
End Sub

Private Sub GetIntField(ByRef Field As TPDFField)
   Field.BackColor = FField.BackColor
   Field.BBox.rBottom = FField.BBox.rBottom
   Field.BBox.rLeft = FField.BBox.rLeft
   Field.BBox.rRight = FField.BBox.rRight
   Field.BBox.rTop = FField.BBox.rTop
   Field.BorderColor = FField.BorderColor
   Field.Checked = FField.Checked <> 0
   Field.BackCS = FField.BackCS
   Field.TextCS = FField.TextCS
   Field.Deleted = FField.Deleted <> 0
   Field.FieldName = ToString3(FField.FieldName, FField.FieldNameLen)
   Field.FieldType = FField.FieldType
   Field.FontName = ToStringA(FField.FontName)
   Field.FontSize = FField.FontSize
   Field.Handle = FField.Handle
   Field.KidCount = FField.KidCount
   Field.Parent = FField.Parent
   Field.TextColor = FField.TextColor
   Field.ToolTip = ToString2(FField.ToolTip, FField.ToolTipLen, FField.UniToolTip <> 0)
   Field.Value = ToString2(FField.Value, FField.valLen, FField.UniVal <> 0)
End Sub

Private Sub GetIntFieldEx(ByRef Source As TPDFFieldEx_I, ByRef Dest As TPDFFieldEx)
   Dest.BackColor = Source.BackColor
   Dest.BackColorSP = Source.BackColorSP
   Dest.BBox = Source.BBox
   Dest.BorderColor = Source.BorderColor
   Dest.BorderColorSP = Source.BorderColorSP
   Dest.BorderStyle = Source.BorderStyle
   Dest.BorderWidth = Source.BorderWidth
   Dest.CharSpacing = Source.CharSpacing
   Dest.CheckBoxChar = Source.CheckBoxChar
   Dest.Checked = Source.Checked <> 0
   Dest.DefState = Source.DefState
   Dest.DefValue = ToStringEx(Source.DefValueA, Source.DefValueW)
   Dest.Deleted = Source.Deleted <> 0
   Dest.EditFont = Source.EditFont
   Dest.ExpValCount = Source.ExpValCount
   Dest.ExpValue = ToStringEx(Source.ExpValueA, Source.ExpValueW)
   Dest.FieldFlags = Source.FieldFlags
   Dest.FieldFont = ToStringA(Source.FieldFont)
   Dest.FieldName = ToStringEx(Source.FieldNameA, Source.FieldNameW)
   Dest.FieldType = Source.FieldType
   Dest.FontSize = Source.FontSize
   Dest.GroupType = Source.GroupType
   Dest.Handle = Source.Handle
   Dest.HighlightMode = Source.HighlightMode
   Dest.IEditFont = Source.IEditFont
   Dest.IFieldFont = Source.IFieldFont
   Dest.IsCalcField = Source.IsCalcField <> 0
   Dest.KidCount = Source.KidCount
   If Source.KidCount > 0 Then
      ReDim Dest.Kids(Source.KidCount - 1)
      Call pdfCopyMem2(Source.Kids, Dest.Kids(0), Source.KidCount * 4)
   Else
      Erase Dest.Kids
   End If
   Dest.MapName = ToStringEx(Source.MapNameA, Source.MapNameW)
   Dest.MaxLen = Source.MaxLen
   Dest.PageNum = Source.PageNum
   Dest.OC = Source.OC
   Dest.Parent = Source.Parent
   Dest.Rotate = Source.Rotate
   Dest.TextAlign = Source.TextAlign
   Dest.TextColor = Source.TextColor
   Dest.TextColorSP = Source.TextColorSP
   Dest.TextScaling = Source.TextScaling
   Dest.ToolTip = ToStringEx(Source.ToolTipA, Source.ToolTipW)
   Dest.UniqueName = ToStringEx(Source.UniqueNameA, Source.UniqueNameW)
   Dest.Value = ToStringEx(Source.ValueA, Source.ValueW)
   Dest.WordSpacing = Source.WordSpacing
   Dest.PageIndex = Source.PageIndex
   Dest.IBarcode = Source.IBarcode
   Dest.ISignature = Source.ISignature
   Dest.ModDate = ToStringA(Source.ModDate)
   Dest.CaptionPos = Source.CaptionPos
   Dest.DownCaption = ToStringEx(Source.DownCaptionA, Source.DownCaptionW)
   Dest.DownImage = Source.DownImage
   Dest.RollCaption = ToStringEx(Source.RollCaptionA, Source.RollCaptionW)
   Dest.RollImage = Source.RollImage
   Dest.UpCaption = ToStringEx(Source.UpCaptionA, Source.UpCaptionW)
   Dest.UpImage = Source.UpImage
   Dest.Action = Source.Action
   Dest.ActionType = Source.ActionType
   Dest.Events = Source.Events
   Dest.FmtTextColor = Source.FmtTextColor
   Dest.FmtText = ToStringEx(Source.FmtTextA, Source.FmtTextW)
End Sub

Private Sub GetIntFont(ByRef IFont As TPDFFontObj_I, ByRef Font As TPDFFontObj)
   Font.Ascent = IFont.Ascent
   Font.BaseFont = ToStringA(IFont.BaseFont)
   Font.CapHeight = IFont.CapHeight
   Font.DefWidth = IFont.DefWidth
   Font.Descent = IFont.Descent
   If IFont.Encoding <> 0 Then
      Font.Encoding = ToStringW(IFont.Encoding, 256)
   Else
      Font.Encoding = ""
   End If
   Font.FirstChar = IFont.FirstChar
   Font.Flags = IFont.Flags
   Font.FontFamily = ToString2(IFont.FontFamily, , IFont.FontFamilyUni <> 0)
   Font.FontName = ToStringA(IFont.FontName)
   Font.FontType = IFont.FontType
   Font.ItalicAngle = IFont.ItalicAngle
   Font.LastChar = IFont.LastChar
   Font.SpaceWidth = IFont.SpaceWidth
   Font.XHeight = IFont.XHeight
   If IFont.WidthsCount > 0 Then
      ReDim Font.Widths(IFont.WidthsCount - 1)
      Call pdfCopyMem2(IFont.Widths, Font.Widths(0), IFont.WidthsCount * 4)
   Else
      Erase Font.Widths
   End If
   ' We don't copy the buffer here! Copy the buffer manually with pdfCopyMem() if you need it!
   ' However, if Font.Length1 == 0 and if Font.FontFile <> 0 then the variable contains the
   ' file path to the used font file. This is always a null-terminated Ansi string at
   ' this time. The string length can be determined with pdfStrLenA().
   Font.FontFile = IFont.FontFile
   Font.Length1 = IFont.Length1
   Font.Length2 = IFont.Length2
   Font.Length3 = IFont.Length3
   Font.FontFileType = IFont.FontFileType
End Sub

Private Sub GetIntFontInfo(ByRef IFont As TPDFFontInfo_I, ByRef Font As TPDFFontInfo)
   Font.Ascent = IFont.Ascent
   Font.BaseEncoding = IFont.BaseEncoding
   Font.BaseFont = ToStringA(IFont.BaseFont)
   Font.BaseFontW = ToStringW(IFont.BaseFontW)
   Font.CapHeight = IFont.CapHeight
   Font.CharSet = ToStringA(IFont.CharSet, IFont.CharSetSize)
   Font.CIDOrdering = ToStringA(IFont.CIDOrdering)
   Font.CIDRegistry = ToStringA(IFont.CIDRegistry)
   If IFont.CIDSet <> 0 Then
      ReDim Font.CIDSet(IFont.CIDSetSize - 1)
      Call pdfCopyMem2(IFont.CIDSet, Font.CIDSet(0), IFont.CIDSetSize)
   Else
      Erase Font.CIDSet
   End If
   Font.CIDSupplement = IFont.CIDSupplement
   If IFont.CIDToGIDMap <> 0 Then
      ReDim Font.CIDToGIDMap(IFont.CIDToGIDMapSize - 1)
      Call pdfCopyMem2(IFont.CIDToGIDMap, Font.CIDToGIDMap(0), IFont.CIDToGIDMapSize)
   Else
      Erase Font.CIDToGIDMap
   End If
   If IFont.CMapBuf <> 0 Then
      ReDim Font.CMapBuf(IFont.CMapBufSize - 1)
      Call pdfCopyMem2(IFont.CMapBuf, Font.CMapBuf(0), IFont.CMapBufSize)
   Else
      Erase Font.CMapBuf
   End If
   Font.CMapName = ToStringA(IFont.CMapName)
   Font.Descent = IFont.Descent
   If IFont.Encoding <> 0 Then
      Font.Encoding = ToStringW(IFont.Encoding, 256)
   Else
      Font.Encoding = ""
   End If
   Font.FirstChar = IFont.FirstChar
   Font.Flags = IFont.Flags
   Font.FontBBox = IFont.FontBBox
   If IFont.FontBuffer <> 0 Then
      ReDim Font.FontBuffer(IFont.FontBufSize - 1)
      Call pdfCopyMem2(IFont.FontBuffer, Font.FontBuffer(0), IFont.FontBufSize)
   Else
      Erase Font.FontBuffer
   End If
   Font.FontFamily = ToStringEx(IFont.FontFamilyA, IFont.FontFamilyW)
   Font.FontFilePath = ToStringEx(IFont.FontFilePathA, IFont.FontFilePathW)
   Font.FontFileType = IFont.FontFileType
   Font.FontName = ToStringA(IFont.FontName)
   Font.FontStretch = ToStringA(IFont.FontStretch)
   Font.FontType = IFont.FontType
   Font.FontWeight = IFont.FontWeight
   Font.FullName = ToStringEx(IFont.FullNameA, IFont.FullNameW)
   Font.HaveEncoding = IFont.HaveEncoding <> 0
   If IFont.HorzWidthsCount > 0 Then
      ReDim Font.HorzWidths(IFont.HorzWidthsCount - 1)
      Call pdfCopyMem2(IFont.HorzWidths, Font.HorzWidths(0), IFont.HorzWidthsCount * 4)
   Else
      Erase Font.HorzWidths
   End If
   Font.Imported = IFont.Imported <> 0
   Font.ItalicAngle = IFont.ItalicAngle
   Font.Lang = ToStringA(IFont.Lang)
   Font.LastChar = IFont.LastChar
   Font.Leading = IFont.Leading
   Font.Length1 = IFont.Length1
   Font.Length2 = IFont.Length2
   Font.Length3 = IFont.Length3
   Font.MaxWidth = IFont.MaxWidth
   If IFont.Metadata <> 0 Then
      ReDim Font.Metadata(IFont.MetadataSize - 1)
      Call pdfCopyMem2(IFont.Metadata, Font.Metadata(0), IFont.MetadataSize)
   Else
      Erase Font.Metadata
   End If
   Font.MisWidth = IFont.MisWidth
   If IFont.Panose <> 0 Then
      ReDim Font.Panose(11)
      Call pdfCopyMem2(IFont.Panose, Font.Panose(0), 12)
   Else
      Erase Font.Panose
   End If
   Font.PostScriptName = ToStringEx(IFont.PostScriptNameA, IFont.PostScriptNameW)
   Font.SpaceWidth = IFont.SpaceWidth
   Font.StemH = IFont.StemH
   Font.StemV = IFont.StemV
   If IFont.ToUnicode <> 0 Then
      ReDim Font.ToUnicode(IFont.ToUnicodeSize - 1)
      Call pdfCopyMem2(IFont.ToUnicode, Font.ToUnicode(0), IFont.ToUnicodeSize)
   Else
      Erase Font.ToUnicode
   End If
   Font.VertDefPos = IFont.VertDefPos
   If IFont.VertWidthsCount > 0 Then
      ReDim Font.VertWidths(IFont.VertWidthsCount - 1)
      Call pdfCopyMem2(IFont.VertWidths, Font.VertWidths(0), IFont.VertWidthsCount * 12)
   Else
      Erase Font.VertWidths
   End If
   Font.WMode = IFont.WMode
   Font.XHeight = IFont.XHeight
End Sub

Private Sub GetIntOutputIntent(ByRef IIntent As TPDFOutputIntent_I, ByRef Intent As TPDFOutputIntent)
   If IIntent.BufSize > 0 Then
      ReDim Intent.Buffer(IIntent.BufSize - 1)
      Call pdfCopyMem2(IIntent.Buffer, Intent.Buffer(0), IIntent.BufSize)
   Else
      Erase Intent.Buffer
   End If
   Intent.Info = ToStringEx(IIntent.InfoA, IIntent.InfoW)
   Intent.NumComponents = IIntent.NumComponents
   Intent.OutputCondition = ToStringEx(IIntent.OutputConditionA, IIntent.OutputConditionW)
   Intent.OutputConditionID = ToStringEx(IIntent.OutputConditionIDA, IIntent.OutputConditionIDW)
   Intent.RegistryName = ToStringEx(IIntent.RegistryNameA, IIntent.RegistryNameW)
   Intent.Subtype = ToStringA(IIntent.Subtype)
End Sub

Private Sub GetIntSigDict(ByRef ISG As TPDFSigDict_I, ByRef SG As TPDFSigDict)
   If ISG.ByteRangeCount > 0 Then
      ReDim SG.ByteRange(ISG.ByteRangeCount * 2 - 1)
      Call pdfCopyMem2(ISG.ByteRange, SG.ByteRange(0), ISG.ByteRangeCount * 8)
   Else
      Erase SG.ByteRange
   End If
   If ISG.CertLen > 0 Then
      ReDim SG.Cert(ISG.CertLen - 1)
      Call pdfCopyMem2(ISG.Cert, SG.Cert(0), ISG.CertLen)
   Else
      Erase SG.Cert
   End If
   If ISG.Changes <> 0 Then
      ReDim SG.Changes(2)
      Call pdfCopyMem2(ISG.Changes, SG.Changes(0), 12)
   Else
      Erase SG.Changes
   End If
   SG.ContactInfo = ToStringEx(ISG.ContactInfoA, ISG.ContactInfoW)
   If ISG.ContentsSize > 0 Then
      ReDim SG.Contents(ISG.ContentsSize - 1)
      Call pdfCopyMem2(ISG.Contents, SG.Contents(0), ISG.ContentsSize)
   Else
      Erase SG.Contents
   End If
   SG.Filter = ToStringA(ISG.Filter)
   SG.Location = ToStringEx(ISG.LocationA, ISG.LocationW)
   SG.Name = ToStringEx(ISG.NameA, ISG.NameW)
   SG.PropAuthTime = ISG.PropAuthTime
   SG.PropAuthType = ToStringA(ISG.PropAuthType)
   SG.Reason = ToStringEx(ISG.ReasonA, ISG.ReasonW)
   SG.Revision = ISG.Revision
   SG.SignTime = ToStringA(ISG.SignTime)
   SG.SubFilter = ToStringA(ISG.SubFilter)
   SG.Version = ISG.Version
End Sub

' See https://stackoverflow.com/questions/183353/how-do-i-determine-if-an-array-is-initialized-in-vb6
Private Function IsArrayEmpty(Value) As Boolean
  Dim arr As Variant
  Dim vt As Integer
  Dim ptr As Long
  arr = Value
  pdfCopyMem2 ByVal VarPtr(arr), ByVal VarPtr(vt), Len(vt)

  If (vt And &H4000&) = &H4000& Then
    pdfCopyMem2 ByVal VarPtr(arr) + 8, ByVal VarPtr(ptr), Len(ptr)
    pdfCopyMem2 ByVal ptr, ByVal VarPtr(ptr), Len(ptr)
  Else
    pdfCopyMem2 ByVal VarPtr(arr) + 8, ByVal VarPtr(ptr), Len(ptr)
  End If
  IsArrayEmpty = ptr = 0
End Function

Private Function IsNum(ByVal C As String) As Boolean
   IsNum = Asc(C) - 48 < 10 And Asc(C) - 48 > -1
End Function

Private Function ParseInt(ByVal s As String, ByVal pos As Long, ByRef Value As Long) As Long
   Dim C As String, p As Long
   Dim isNegative As Boolean
   p = pos
   ParseInt = 0
   Value = 0
   If pos > Len(s) Then Exit Function
   isNegative = False
   Select Case Mid(s, pos, 1)
      Case "-"
         isNegative = True
         pos = pos + 1
      Case "+"
        pos = pos + 1
        If pos = Len(s) Then Exit Function
   End Select
   Do While pos <= Len(s)
      C = Mid(s, pos, 1)
      If Not IsNum(C) Then Exit Do
      Value = Value * 10 + Asc(C) - 48
      pos = pos + 1
   Loop
   If isNegative Then Value = -Value
   ParseInt = pos - p
End Function

Private Sub IPDFCallBack_EnumDocFonts(ByVal PDFFont As Long, ByVal FontType As TFontType, ByVal BaseFont As Long, ByVal FontName As Long, ByVal Embedded As Long, ByVal IsFormFont As Long, ByVal Flags As Long, DoBreak As Boolean)
   Dim bName As String
   Dim fName As String

   bName = ToStringA(BaseFont)
   fName = ToStringA(FontName)
   RaiseEvent EnumDocFont(PDFFont, FontType, bName, fName, Embedded, IsFormFont, Flags, DoBreak)
End Sub

Private Sub IPDFCallBack_EnumFonts(ByVal FamilyName As Long, ByVal PostScriptName As Long, ByVal Style As Long, DoBreak As Boolean)
   Dim famName  As String
   Dim postName As String

   famName = ToStringW(FamilyName)
   postName = ToStringA(PostScriptName)
   RaiseEvent EnumFont(famName, postName, Style, DoBreak)
End Sub

Private Sub IPDFCallBack_EnumFontsEx(ByVal FamilyName As Long, ByVal PostScriptName As Long, ByVal Style As Long, ByVal BaseType As TFontBaseType, ByVal Flags As TEnumFontProcFlags, ByVal FilePath As Long, DoBreak As Boolean)
   Dim famName  As String
   Dim postName As String
   Dim Path     As String
   Dim BufSize  As Long
   Dim uni As Boolean
   Dim embedable As Boolean

   uni = (Flags And efpUnicodePath) <> 0
   embedable = (Flags And efpEmbeddable) <> 0
   famName = ToStringW(FamilyName)
   postName = ToStringA(PostScriptName)
   Path = ToString2(FilePath, , uni)
   RaiseEvent EnumFontEx(famName, postName, Style, BaseType, embedable, Path, DoBreak)
End Sub

Private Sub IPDFCallBack_ErrorProc(ByVal ErrCode As Long, ByVal ErrMessage As Long, ByVal ErrType As Long, DoBreak As Boolean)
   Dim s As String

   s = ToStringA(ErrMessage)
   DoBreak = False
   RaiseEvent Error(s, ErrType, DoBreak)
End Sub

Private Sub IPDFCallBack_InitProgress(ByVal ProgType As Long, ByVal MaxCount As Long)
    RaiseEvent InitProgress(ProgType, MaxCount)
End Sub

Private Sub IPDFCallBack_OnPageBreakProc(ByVal LastPosX As Double, ByVal LastPosY As Double, ByVal PageBreak As Long, NewAlign As TNewAlign, DoBreak As Boolean)
    RaiseEvent PageBreak(LastPosX, LastPosY, PageBreak, NewAlign, DoBreak)
End Sub

Private Sub IPDFCallBack_Progress(ByVal ActivePage As Long, DoBreak As Boolean)
    RaiseEvent Progress(ActivePage, DoBreak)
End Sub

Private Function ToStringA(ByVal APtr As Long, Optional ByVal sLen As Long = -1) As String
   If (APtr = 0) Or (sLen = 0) Then Exit Function
   If sLen = -1 Then sLen = pdfStrLenA(APtr)
   ToStringA = Space(sLen)
   pdfCopyMem2 APtr, ByVal ToStringA, sLen
End Function

Private Function ToStringW(ByVal APtr As Long, Optional ByVal sLen As Long = -1) As String
   If (APtr = 0) Or (sLen = 0) Then Exit Function
   If sLen = -1 Then sLen = pdfStrLenW(APtr)
   ToStringW = Space(sLen)
   pdfCopyMem2 APtr, ByVal StrPtr(ToStringW), sLen * 2
End Function

Private Function ToString2(ByVal APtr As Long, Optional ByVal sLen As Long = -1, Optional ByVal bIsUnicode As Boolean) As String
    If bIsUnicode Then
        ToString2 = ToStringW(APtr, sLen)
    Else
        ToString2 = ToStringA(APtr, sLen)
    End If
End Function

' Special version for form fields
Private Function ToString3(ByVal APtr As Long, ByVal sLen As Long) As String
   If (APtr = 0) Or (sLen = 0) Then Exit Function
   ' Check whether we have an Unicode string.
   ToString3 = ToString2(APtr, sLen, sLen <> pdfStrLenA(APtr))
End Function

Private Function ToStringEx(ByVal PtrA As Long, ByVal PtrW As Long, Optional ByVal sLen As Long = 0) As String
   If sLen = 0 Then sLen = -1
   If PtrA <> 0 Then
      ToStringEx = ToStringA(PtrA, sLen)
   ElseIf PtrW <> 0 Then
      ToStringEx = ToStringW(PtrW, sLen)
   End If
End Function

Private Function UTF8ToString(ByVal Source As Long) As String
   Dim Length As Long, srcLen As Long
   Dim retval As String
   srcLen = pdfStrLenA(Source)
   Length = MultiByteToWideChar(65001, 0, Source, srcLen, 0, 0)
   retval = Space(Length)
   MultiByteToWideChar 65001, 0, Source, srcLen, StrPtr(retval), Length
   UTF8ToString = retval
End Function
