/*---------------------------------------------------------+
| DynaPDF 4.0                                              |
+----------------------------------------------------------+
| Copyright (C) 2003-2024                                  |
| Jens Boschulte, DynaForms GmbH.                          |
| All rights reserved.                                     |
+----------------------------------------------------------+
| Please report errors or other potential problems to      |
| support@dynaforms.com.                                   |
| The current version is available at www.dynaforms.com.   |
+----------------------------------------------------------*/

#include "dynapdf.h"

#if defined(__cplusplus)
   using namespace DynaPDF;
#endif

/*
   Dummy decalrations to enable intellisense (code completion) in Microsoft's Visual C++ 6.0
   Due to the macro definitions of the ANSI and Unicode mappings it is not possible to declare
   these functions here with that name (e.g. pdfAddBookmark). Code completion does not work
   for these functions. However, just add the 'A' or 'W' at the end of the function name and
   remove it again when finished.

   Notice:
   The dummy declarations cannot be used with the static library of DynaPDF!
*/

#ifndef PDF_STATIC

LBOOL  PDF_CALL fntBuildFamilyNameAndStyle(const void* IFont, char Name[128], TFStyle ADDR Style){return 0;}
LBOOL  PDF_CALL fntGetFont(const void* IFont, struct TPDFFontObj* F){return 0;}
LBOOL  PDF_CALL fntGetFontInfo(const void* IFont, struct TPDFFontInfo* F){return 0;}
double PDF_CALL fntGetSpaceWidth(const void* IFont, double FontSize){return 0;}
double PDF_CALL fntGetTextWidth(const void* IFont, const BYTE* Text, UI32 Len, float CharSpacing, float WordSpacing, float TextScale){return 0;}
SI32   PDF_CALL fntTranslateRawCode(const void* IFont, const BYTE* Text, UI32 Len, double ADDR Width, UI16 OutText[32], SI32 ADDR OutLen, LBOOL ADDR Decoded, float CharSpacing, float WordSpacing, float TextScale){return 0;}
SI32   PDF_CALL fntTranslateString(struct TPDFStack* Stack, UI16* Buffer, UI32 Size, UI32 Flags){return 0;}
SI32   PDF_CALL fntTranslateString2(void* IFont, const BYTE* Text, UI32 Len, UI16* OutBuf, UI32 Size, UI32 Flags){return 0;}

void   PDF_CALL rasAbort(IRAS* RasPtr){}
LBOOL  PDF_CALL rasAttachImageBuffer(IRAS* RasPtr, BYTE** Rows, BYTE* Buffer, UI32 Width, UI32 Height, SI32 ScanlineLen){return 0;}
void   PDF_CALL rasCalcPagePixelSize(IPGE* PagePtr, TPDFPageScale DefScale, float Scale, UI32 FrameWidth, UI32 FrameHeight, TRasterFlags Flags, UI32* Width, UI32* Height){}
IRAS*  PDF_CALL rasCreateRasterizer(const PPDF* IPDF, BYTE** Rows, BYTE* Buffer, UI32 Width, UI32 Height, SI32 ScanlineLen, TPDFPixFormat PixFmt){return 0;}
IRAS*  PDF_CALL rasCreateRasterizerEx(const PPDF* IPDF, const void* DC, UI32 Width, UI32 Height, TPDFPixFormat PixFmt){return 0;}
void   PDF_CALL rasDeleteRasterizer(IRAS** RasPtr){}
void   PDF_CALL rasRedraw(IRAS* RasPtr, const void* DC, SI32 DestX, SI32 DestY){}
LBOOL  PDF_CALL rasResizeBitmap(IRAS* RasPtr, const void* DC, UI32 Width, UI32 Height){return 0;}
void   PDF_CALL rasSetMinLineWidth2(IRAS* RasPtr, float Value){}
void   PDF_CALL rasSetScreenRes(IRAS* RasPtr, UI32 Value){}

void          PDF_CALL rasChangeBackColor(IPGC* CachePtr, UI32 Value){}
void          PDF_CALL rasCloseFile(IPGC* CachePtr){}
IPGC*         PDF_CALL rasCreatePageCache(const PPDF* IPDF, TPDFPixFormat PixFmt, UI32 HBorder, UI32 VBorder, UI32 BackColor){return 0;}
void          PDF_CALL rasDeletePageCache(IPGC** CachePtr){}
TUpdBmkAction PDF_CALL rasExecBookmark(IPGC* CachePtr, UI32 Handle, SI32* NewX, SI32* NewY, float* NewZoom, TPDFPageScale* NewPageScale, void* Action){return ubaDoNothing;}
SI32          PDF_CALL rasGetCurrPage(IPGC* CachePtr){return 0;}
float         PDF_CALL rasGetCurrZoom(IPGC* CachePtr){return 0;}
TPageLayout   PDF_CALL rasGetDefPageLayout(IPGC* CachePtr){return plSinglePage;}
SI32          PDF_CALL rasGetPageAt(IPGC* CachePtr, SI32 ScrollX, SI32 ScrollY, SI32 X, SI32 Y){return 0;}
TPageLayout   PDF_CALL rasGetPageLayout(IPGC* CachePtr){return plSinglePage;}
TPDFPageScale PDF_CALL rasGetPageScale(IPGC* CachePtr){return psFitWidth;}
SI32          PDF_CALL rasGetRotate(IPGC* CachePtr){return 0;}
UI32          PDF_CALL rasGetScrollLineDelta(IPGC* CachePtr, LBOOL Vertical){return 0;}
SI32          PDF_CALL rasGetScrollPos(IPGC* CachePtr, LBOOL Vertical, UI32 PageNum){return 0;}
LBOOL         PDF_CALL rasGetScrollRange(IPGC* CachePtr, LBOOL Vertical, SI32* Max, SI32* SmallChange, SI32* LargeChange){return 0;}
SI32          PDF_CALL rasInitBaseObjects(IPGC* CachePtr, SI32 Width, SI32 Height, TInitCacheFlags Flags){return 0;}
LBOOL         PDF_CALL rasInitColorManagement(IPGC* CachePtr, struct TPDFColorProfiles* Profiles, TPDFInitCMFlags Flags){return 0;}
LBOOL         PDF_CALL rasInitialize(IPGC* CachePtr, TPDFThreadPriority Priority){return 0;}
TPDFCursor    PDF_CALL rasMouseDown(IPGC* CachePtr, SI32 X, SI32 Y){return pcrHandNormal;}
TUpdScrollbar PDF_CALL rasMouseMove(IPGC* CachePtr, const void* hWnd, LBOOL LeftBtnDown, SI32* ScrollX, SI32* ScrollY, SI32 X, SI32 Y){return usbNoUpdate;}
TUpdScrollbar PDF_CALL rasPaint(IPGC* CachePtr, const void* DC, SI32* ScrollX, SI32* ScrollY){return usbNoUpdate;}
void          PDF_CALL rasResetMousePos(IPGC* CachePtr){}
LBOOL         PDF_CALL rasResize(IPGC* CachePtr, SI32 Width, SI32 Height){return 0;}
LBOOL         PDF_CALL rasProcessErrors(IPGC* CachePtr){return 0;}
TUpdScrollbar PDF_CALL rasScroll(IPGC* CachePtr, LBOOL Vertical, SI32 ScrollCode, SI32* ScrollX, SI32* ScrollY){return usbNoUpdate;}
SI32          PDF_CALL rasSetCMapDirA(IPGC* CachePtr, const char* Path, TLoadCMapFlags Flags){return 0;}
SI32          PDF_CALL rasSetCMapDirW(IPGC* CachePtr, const UI16* Path, TLoadCMapFlags Flags){return 0;}
void          PDF_CALL rasSetDefPageLayout(IPGC* CachePtr, TPageLayout Value){}
LBOOL         PDF_CALL rasSetMinLineWidth(IPGC* CachePtr, float Value){return 0;}
void          PDF_CALL rasSetPageLayout(IPGC* CachePtr, TPageLayout Value){}
void          PDF_CALL rasSetPageScale(IPGC* CachePtr, TPDFPageScale Value){}
void          PDF_CALL rasSetRotate(IPGC* CachePtr, SI32 Value){}
LBOOL         PDF_CALL rasSetScrollLineDelta(IPGC* CachePtr, LBOOL Vertical, UI32 Value){return 0;}
void          PDF_CALL rasSetThreadPriority(IPGC* CachePtr, TPDFThreadPriority UpdateThread, TPDFThreadPriority RenderThread){}
LBOOL         PDF_CALL rasZoom(IPGC* CachePtr, float Value, SI32* HorzPos, SI32* VertPos){return 0;}

LBOOL  PDF_CALL pdfAddActionToObj(const PPDF* IPDF, TObjType ObjType, TObjEvent Event, UI32 ActHandle, UI32 ObjHandle){return 0;}
LBOOL  PDF_CALL pdfAddAnnotToPage(const PPDF* IPDF, UI32 PageNum, UI32 Handle){return 0;}
SI32   PDF_CALL pdfAddArticle(const PPDF* IPDF, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfAddBookmarkA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open){return 0;}
SI32   PDF_CALL pdfAddBookmarkW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open){return 0;}
SI32   PDF_CALL pdfAddBookmarkExA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 NamedDest, LBOOL Open){return 0;}
SI32   PDF_CALL pdfAddBookmarkExW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 NamedDest, LBOOL Open){return 0;}
SI32   PDF_CALL pdfAddBookmarkEx2A(const PPDF* IPDF, const char* Title, SI32 Parent, const void* NamedDest, LBOOL Unicode, LBOOL Open){return 0;}
SI32   PDF_CALL pdfAddBookmarkEx2W(const PPDF* IPDF, const UI16* Title, SI32 Parent, const void* NamedDest, LBOOL Unicode, LBOOL Open){return 0;}
LBOOL  PDF_CALL pdfAddButtonImage(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, const char* ImgFile){return 0;}
LBOOL  PDF_CALL pdfAddButtonImageEx(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, void* hBitmap){return 0;}
LBOOL  PDF_CALL pdfAddButtonImageEx2(const PPDF* IPDF, UI32 BtnHandle, TButtonState State, const char* Caption, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfAddContinueTextA(const PPDF* IPDF, const char* AText){return 0;}
LBOOL  PDF_CALL pdfAddContinueTextW(const PPDF* IPDF, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfAddDeviceNProcessColorants(const PPDF* IPDF, UI32 DeviceNCS, const char** Colorants, UI32 NumColorants, TExtColorSpace CS, SI32 Handle){return 0;}
LBOOL  PDF_CALL pdfAddDeviceNSeparations(const PPDF* IPDF, UI32 DeviceNCS, const char** Colorants, UI32* SeparationCS, UI32 NumColorants){return 0;}
LBOOL  PDF_CALL pdfAddFieldToFormAction(const PPDF* IPDF, UI32 Action, UI32 AField, LBOOL Include){return 0;}
LBOOL  PDF_CALL pdfAddFieldToHideAction(const PPDF* IPDF, UI32 HideAct, UI32 AField){return 0;}
LBOOL  PDF_CALL pdfAddFileCommentA(const PPDF* IPDF, const char* AText){return 0;}
LBOOL  PDF_CALL pdfAddFileCommentW(const PPDF* IPDF, const UI16* AText){return 0;}
SI32   PDF_CALL pdfAddFontSearchPathA(const PPDF* IPDF, const char* APath, LBOOL Recursive){return 0;}
SI32   PDF_CALL pdfAddFontSearchPathW(const PPDF* IPDF, const UI16* APath, LBOOL Recursive){return 0;}
LBOOL  PDF_CALL pdfAddHeaderFooter(const PPDF* IPDF, struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray, UI32 Count){return 0;}
LBOOL  PDF_CALL pdfAddImage(const PPDF* IPDF, TCompressionFilter Filter, TImageConversionFlags Flags, struct TPDFImage* Image){return 0;}
LBOOL  PDF_CALL pdfAddInkList(const PPDF* IPDF, UI32 InkAnnot, struct TFltPoint* Points, UI32 NumPoints){return 0;}
SI32   PDF_CALL pdfAddJavaScriptA(const PPDF* IPDF, const char* Name, const char* Script){return 0;}
SI32   PDF_CALL pdfAddJavaScriptW(const PPDF* IPDF, const char* Name, const UI16* Script){return 0;}
LGRP*  PDF_CALL pdfAddLayerToDisplTreeA(const PPDF* IPDF, LGRP* Parent, SI32 Layer, const char* Title){return 0;}
LGRP*  PDF_CALL pdfAddLayerToDisplTreeW(const PPDF* IPDF, LGRP* Parent, SI32 Layer, const UI16* Title){return 0;}
LBOOL  PDF_CALL pdfAddMaskImage(const PPDF* IPDF, UI32 BaseImage, const void* Buffer, UI32 BufSize, SI32 Stride, UI32 BitsPerPixel, UI32 Width, UI32 Height){return 0;}
LBOOL  PDF_CALL pdfAddObjectToLayer(const PPDF* IPDF, UI32 OCG, TOCObject ObjType, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfAddOCGToAppEvent(const PPDF* IPDF, UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories){return 0;}
SI32   PDF_CALL pdfAddOutputIntentA(const PPDF* IPDF, const char* ICCFile){return 0;}
SI32   PDF_CALL pdfAddOutputIntentW(const PPDF* IPDF, const UI16* ICCFile){return 0;}
SI32   PDF_CALL pdfAddOutputIntentEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize){return 0;}
SI32   PDF_CALL pdfAddPageLabelA(const PPDF* IPDF, UI32 StartRange, TPageLabelFormat Format, const char* Prefix, SI32 AddNum){return 0;}
SI32   PDF_CALL pdfAddPageLabelW(const PPDF* IPDF, UI32 StartRange, TPageLabelFormat Format, const UI16* Prefix, SI32 AddNum){return 0;}
LBOOL  PDF_CALL pdfAddRasImage(const PPDF* IPDF, IRAS* RasPtr, TCompressionFilter Filter){return 0;}
SI32   PDF_CALL pdfAddRenderingIntentA(const PPDF* IPDF, const char* ICCFile){return 0;}
SI32   PDF_CALL pdfAddRenderingIntentW(const PPDF* IPDF, const UI16* ICCFile){return 0;}
SI32   PDF_CALL pdfAddRenderingIntentEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfAddValToChoiceFieldA(const PPDF* IPDF, UI32 Field, const char* ExpValue, const char* Value, LBOOL Selected){return 0;}
LBOOL  PDF_CALL pdfAddValToChoiceFieldW(const PPDF* IPDF, UI32 Field, const char* ExpValue, const UI16* Value, LBOOL Selected){return 0;}
LBOOL  PDF_CALL pdfAppend(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfApplyAppEvent(const PPDF* IPDF, TOCAppEvent Event, LBOOL SaveResult){return 0;}
LBOOL  PDF_CALL pdfApplyPattern(const PPDF* IPDF, SI32 PattHandle, TColorMode ColorMode, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfApplyShading(const PPDF* IPDF, SI32 ShadHandle){return 0;}
LBOOL  PDF_CALL pdfAssociateEmbFile(const PPDF* IPDF, TAFDestObject DestObject, SI32 DestHandle, TAFRelationship Relationship, UI32 EmbFile){return 0;}
SI32   PDF_CALL pdfAttachFileA(const PPDF* IPDF, const char* FilePath, const char* Description, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfAttachFileW(const PPDF* IPDF, const UI16* FilePath, const UI16* Description, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfAttachFileExA(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const char* FileName, const char* Description, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfAttachFileExW(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const UI16* FileName, const UI16* Description, LBOOL Compress){return 0;}
LBOOL  PDF_CALL pdfAutoTemplate(const PPDF* IPDF, UI32 Templ, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfBeginClipPath(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfBeginContinueText(const PPDF* IPDF, double PosX, double PosY){return 0;}
LBOOL  PDF_CALL pdfBeginLayer(const PPDF* IPDF, UI32 OCG){return 0;}
LBOOL  PDF_CALL pdfBeginPageTemplate(const PPDF* IPDF, const char* Name, LBOOL UseAutoTemplates){return 0;}
SI32   PDF_CALL pdfBeginPattern(const PPDF* IPDF, TPatternType PatternType, TTilingType TilingType, double Width, double Height){return 0;}
SI32   PDF_CALL pdfBeginTemplate(const PPDF* IPDF, double Width, double Height){return 0;}
SI32   PDF_CALL pdfBeginTemplateEx(const PPDF* IPDF, struct TPDFRect* BBox, struct TCTM* Matrix){return 0;}
SI32   PDF_CALL pdfBeginTransparencyGroup(const PPDF* IPDF, double x1, double y1, double x2, double y2, LBOOL Isolated, LBOOL Knockout, TExtColorSpace CS, SI32 CSHandle){return 0;}
LBOOL  PDF_CALL pdfBezier_1_2_3(const PPDF* IPDF, double x1, double y1, double x2, double y2, double x3, double y3){return 0;}
LBOOL  PDF_CALL pdfBezier_1_3(const PPDF* IPDF, double x1, double y1, double x3, double y3){return 0;}
LBOOL  PDF_CALL pdfBezier_2_3(const PPDF* IPDF, double x2, double y2, double x3, double y3){return 0;}
double PDF_CALL pdfCalcWidthHeight(const PPDF* IPDF, double OrgWidth, double OrgHeight, double ScaledWidth, double ScaledHeight){return 0;}
SI32   PDF_CALL pdfCaretAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content){return 0;}
SI32   PDF_CALL pdfCaretAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content){return 0;}
LBOOL  PDF_CALL pdfChangeAnnotPos(const PPDF* IPDF, UI32 Handle, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfChangeAnnotNameA(const PPDF* IPDF, UI32 Handle, const char* Name){return 0;}
LBOOL  PDF_CALL pdfChangeAnnotNameW(const PPDF* IPDF, UI32 Handle, const UI16* Name){return 0;}
LBOOL  PDF_CALL pdfChangeBookmarkA(const PPDF* IPDF, SI32 ABmk, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open){return 0;}
LBOOL  PDF_CALL pdfChangeBookmarkW(const PPDF* IPDF, SI32 ABmk, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open){return 0;}
LBOOL  PDF_CALL pdfChangeFont(const PPDF* IPDF, SI32 Handle){return 0;}
LBOOL  PDF_CALL pdfChangeFontEx(const PPDF* IPDF, SI32 Handle, double FontSize, TFStyle Style){return 0;}
LBOOL  PDF_CALL pdfChangeFontSize(const PPDF* IPDF, double Size){return 0;}
LBOOL  PDF_CALL pdfChangeFontStyle(const PPDF* IPDF, TFStyle Style){return 0;}
LBOOL  PDF_CALL pdfChangeFontStyleEx(const PPDF* IPDF, TFStyle Style){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptA(const PPDF* IPDF, UI32 Handle, const char* NewScript){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptW(const PPDF* IPDF, UI32 Handle, const UI16* NewScript){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptActionA(const PPDF* IPDF, UI32 Handle, const char* NewScript){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptActionW(const PPDF* IPDF, UI32 Handle, const UI16* NewScript){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptNameA(const PPDF* IPDF, UI32 Handle, const char* Name){return 0;}
LBOOL  PDF_CALL pdfChangeJavaScriptNameW(const PPDF* IPDF, UI32 Handle, const UI16* Name){return 0;}
LBOOL  PDF_CALL pdfChangeLinkAnnot(const PPDF* IPDF, UI32 Handle, const char* URL){return 0;}
LBOOL  PDF_CALL pdfChangeOCGNameA(const PPDF* IPDF, UI32 Handle, const char* Value){return 0;}
LBOOL  PDF_CALL pdfChangeOCGNameW(const PPDF* IPDF, UI32 Handle, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfChangeSeparationColor(const PPDF* IPDF, UI32 CSHandle, UI32 NewColor, TExtColorSpace Alternate, SI32 AltHandle){return 0;}
SI32   PDF_CALL pdfCheckFieldNames(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfCheckAndRepairFonts(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfCheckCollection(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfCheckConformance(const PPDF* IPDF, TConformanceType Type, TCheckOptions Options, const void* UserData, TOnFontNotFoundProc* OnFontNotFound, TOnReplaceICCProfile* OnReplaceICCProfile){return 0;}
LBOOL  PDF_CALL pdfClearAutoTemplates(const PPDF* IPDF){return 0;}
void   PDF_CALL pdfClearErrorLog(const PPDF* IPDF){}
LBOOL  PDF_CALL pdfClearHostFonts(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfClipPath(const PPDF* IPDF, TClippingMode ClipMode, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfCloseAndSignFile(const PPDF* IPDF, const char* CertFile, const char* Password, const char* Reason, const char* Location){return 0;}
LBOOL  PDF_CALL pdfCloseAndSignFileEx(const PPDF* IPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict, const char* CertFile, const char* Password, const char* Reason, const char* Location){return 0;}
LBOOL  PDF_CALL pdfCloseAndSignFileExt(const PPDF* IPDF, struct TPDFSigParms* SigParms){return 0;}
LBOOL  PDF_CALL pdfCloseFile(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfCloseFileEx(const PPDF* IPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict){return 0;}
LBOOL  PDF_CALL pdfCloseImage(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfCloseImportFile(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfCloseImportFileEx(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfClosePath(const PPDF* IPDF, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfCloseTag(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfComputeBBox(const PPDF* IPDF, struct TPDFRect ADDR BBox, TCompBBoxFlags Flags){return 0;}
UI32   PDF_CALL pdfConvColor(const double* Color, UI32 NumComps, TExtColorSpace SourceCS, const void* IColorSpace, TExtColorSpace DestCS){return 0;}
LBOOL  PDF_CALL pdfConvertColors(const PPDF* IPDF, TColorConvFlags Flags, const void* Reserved){return 0;}
UI16*  PDF_CALL pdfConvToUnicode(const PPDF* IPDF, const char* AString, TCodepage CP){return 0;}
LBOOL  PDF_CALL pdfCopyChoiceValues(const PPDF* IPDF, UI32 Source, UI32 Dest, LBOOL Share){return 0;}
SI32   PDF_CALL pdfCopyMem(const void* Source, void* Dest, UI32 Len){return 0;}
void   PDF_CALL pdfCopyPtr(void* Source, void* &Dest){}
SI32   PDF_CALL pdfCreate3DAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* Name, const char* U3DFile, const char* Image){return 0;}
SI32   PDF_CALL pdfCreate3DAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Name, const UI16* U3DFile, const UI16* Image){return 0;}
LBOOL  PDF_CALL pdfCreate3DBackground(const PPDF* IPDF, const void* IView, UI32 BackColor){return 0;}
SI32   PDF_CALL pdfCreate3DGotoViewAction(const PPDF* IPDF, UI32 Base3DAnnot, const void* IView, T3DNamedAction Named){return 0;}
LBOOL  PDF_CALL pdfCreate3DProjection(const PPDF* IPDF, const void* IView, T3DProjType ProjType, T3DScaleType ScaleType, double Diameter, double FOV){return 0;}
void*  PDF_CALL pdfCreate3DView(const PPDF* IPDF, UI32 Base3DAnnot, const char* Name, LBOOL SetAsDefault, double* Matrix, double CamDistance, T3DRenderingMode RM, T3DLightingSheme LS){return 0;}
SI32   PDF_CALL pdfCreateAnnotAP(const PPDF* IPDF, UI32 Annot){return 0;}
SI32   PDF_CALL pdfCreateArticleThreadA(const PPDF* IPDF, const char* ThreadName){return 0;}
SI32   PDF_CALL pdfCreateArticleThreadW(const PPDF* IPDF, const UI16* ThreadName){return 0;}
SI32   PDF_CALL pdfCreateAxialShading(const PPDF* IPDF, double sX, double sY, double eX, double eY, double SCenter, UI32 SColor, UI32 EColor, LBOOL Extend1, LBOOL Extend2){return 0;}
SI32   PDF_CALL pdfCreateBarcodeField(const PPDF* IPDF, const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height, struct TPDFBarcode* Barcode){return 0;}
SI32   PDF_CALL pdfCreateButtonA(const PPDF* IPDF, const char* Name, const char* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateButtonW(const PPDF* IPDF, const char* Name, const UI16* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateCheckBox(const PPDF* IPDF, const char* Name, const char* ExpValue, LBOOL Checked, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateCIEColorSpace(const PPDF* IPDF, TExtColorSpace Base, float* WhitePoint, float* BlackPoint, float* Gamma, float* Matrix){return 0;}
LBOOL  PDF_CALL pdfCreateCollection(const PPDF* IPDF, TColView View){return 0;}
SI32   PDF_CALL pdfCreateCollectionFieldA(const PPDF* IPDF, TColColumnType ColType, SI32 Column, const char* Name, const char* Key, LBOOL Visible, LBOOL Editable){return 0;}
SI32   PDF_CALL pdfCreateCollectionFieldW(const PPDF* IPDF, TColColumnType ColType, SI32 Column, const UI16* Name, const char* Key, LBOOL Visible, LBOOL Editable){return 0;}
LBOOL  PDF_CALL pdfCreateColItemDate(const PPDF* IPDF, UI32 EmbFile, const char* Key, long Date, const char* Prefix){return 0;}
LBOOL  PDF_CALL pdfCreateColItemNumber(const PPDF* IPDF, UI32 EmbFile, const char* Key, double Value, const char* Prefix){return 0;}
LBOOL  PDF_CALL pdfCreateColItemStringA(const PPDF* IPDF, UI32 EmbFile, const char* Key, const char* Value, const char* Prefix){return 0;}
LBOOL  PDF_CALL pdfCreateColItemStringW(const PPDF* IPDF, UI32 EmbFile, const char* Key, const UI16* Value, const UI16* Prefix){return 0;}
SI32   PDF_CALL pdfCreateComboBox(const PPDF* IPDF, const char* Name, LBOOL Sort, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateDeviceNColorSpace(const PPDF* IPDF, const char** Colorants, UI32 NumColorants, const char* PostScriptFunc, TExtColorSpace Alternate, SI32 Handle){return 0;}
SI32   PDF_CALL pdfCreateExtGState(const PPDF* IPDF, struct TPDFExtGState* GS){return 0;}
SI32   PDF_CALL pdfCreateGoToAction(const PPDF* IPDF, TDestType DestType, UI32 PageNum, double a, double b, double c, double d){return 0;}
SI32   PDF_CALL pdfCreateGoToActionEx(const PPDF* IPDF, UI32 NamedDest){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionA(const PPDF* IPDF, const char* FileName, UI32 PageNum){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionW(const PPDF* IPDF, const UI16* FileName, UI32 PageNum){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionExA(const PPDF* IPDF, const char* FileName, char* DestName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionExW(const PPDF* IPDF, const char* FileName, UI16* DestName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionExUA(const PPDF* IPDF, const UI16* FileName, char* DestName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateGoToRActionExUW(const PPDF* IPDF, const UI16* FileName, UI16* DestName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateGroupField(const PPDF* IPDF, const char* Name, SI32 Parent){return 0;}
SI32   PDF_CALL pdfCreateHideAction(const PPDF* IPDF, UI32 AField, LBOOL Hide){return 0;}
SI32   PDF_CALL pdfCreateICCBasedColorSpaceA(const PPDF* IPDF, const char* ICCProfile){return 0;}
SI32   PDF_CALL pdfCreateICCBasedColorSpaceW(const PPDF* IPDF, const UI16* ICCProfile){return 0;}
SI32   PDF_CALL pdfCreateICCBasedColorSpaceEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfCreateImageA(const PPDF* IPDF, const char* FileName, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfCreateImageW(const PPDF* IPDF, const UI16* FileName, TImageFormat Format){return 0;}
SI32   PDF_CALL pdfCreateImpDataActionA(const PPDF* IPDF, const char* DataFile){return 0;}
SI32   PDF_CALL pdfCreateImpDataActionW(const PPDF* IPDF, const UI16* DataFile){return 0;}
SI32   PDF_CALL pdfCreateIndexedColorSpace(const PPDF* IPDF, TExtColorSpace Base, SI32 Handle, const void* ColorTable, UI32 NumColors){return 0;}
SI32   PDF_CALL pdfCreateJSActionA(const PPDF* IPDF, const char* Script){return 0;}
SI32   PDF_CALL pdfCreateJSActionW(const PPDF* IPDF, const UI16* Script){return 0;}
SI32   PDF_CALL pdfCreateLaunchAction(const PPDF* IPDF, TFileOP OP, const char* FileName, const char* DefDir, const char* Param, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateLaunchActionExA(const PPDF* IPDF, const char* FileName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateLaunchActionExW(const PPDF* IPDF, const UI16* FileName, LBOOL NewWindow){return 0;}
SI32   PDF_CALL pdfCreateListBox(const PPDF* IPDF, const char* Name, LBOOL Sort, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateNamedAction(const PPDF* IPDF, TNamedAction Action){return 0;}
SI32   PDF_CALL pdfCreateNamedDestA(const PPDF* IPDF, const char* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d){return 0;}
SI32   PDF_CALL pdfCreateNamedDestW(const PPDF* IPDF, const UI16* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d){return 0;}
LBOOL  PDF_CALL pdfCreateNewPDFA(const PPDF* IPDF, const char* OutPDF){return 0;}
LBOOL  PDF_CALL pdfCreateNewPDFW(const PPDF* IPDF, const UI16* OutPDF){return 0;}
SI32   PDF_CALL pdfCreateOCGA(const PPDF* IPDF, const char* Name, LBOOL DisplayInUI, LBOOL Visible, TOCGIntent Intent){return 0;}
SI32   PDF_CALL pdfCreateOCGW(const PPDF* IPDF, const UI16* Name, LBOOL DisplayInUI, LBOOL Visible, TOCGIntent Intent){return 0;}
SI32   PDF_CALL pdfCreateOCMD(const PPDF* IPDF, TOCVisibility Visibility, UI32* OCGs, UI32 Count){return 0;}
SI32   PDF_CALL pdfCreateRadialShading(const PPDF* IPDF, double sX, double sY, double R1, double eX, double eY, double R2, double SCenter, UI32 SColor, UI32 EColor, LBOOL Extend1, LBOOL Extend2){return 0;}
SI32   PDF_CALL pdfCreateRadioButton(const PPDF* IPDF, const char* Name, const char* ExpValue, SI32 Checked, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateRectilinearMeasureA(const PPDF* IPDF, UI32 Viewport, double Scale, const char* UnitDescription, const char* LabelDistance, const char* LabelArea){return 0;}
SI32   PDF_CALL pdfCreateRectilinearMeasureW(const PPDF* IPDF, UI32 Viewport, double Scale, const UI16* UnitDescription, const UI16* LabelDistance, const UI16* LabelArea){return 0;}
SI32   PDF_CALL pdfCreateResetAction(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfCreateSeparationCS(const PPDF* IPDF, const char* Colorant, TExtColorSpace Alternate, SI32 Handle, UI32 Color){return 0;}
SI32   PDF_CALL pdfCreateSetOCGStateAction(const PPDF* IPDF, UI32* On, UI32 OnCount, UI32* Off, UI32 OffCount, UI32* Toggle, UI32 ToggleCount, LBOOL PreserveRB){return 0;}
SI32   PDF_CALL pdfCreateSigField(const PPDF* IPDF, const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateSigFieldAP(const PPDF* IPDF, UI32 SigField){return 0;}
void*  PDF_CALL pdfCreateSoftMask(const PPDF* IPDF, UI32 TranspGroup, TSoftMaskType MaskType, UI32 BackColor){return 0;}
SI32   PDF_CALL pdfCreateStdPattern(const PPDF* IPDF, TStdPattern Pattern, double LineWidth, double Distance, UI32 LineColor, UI32 BackColor){return 0;}
LBOOL  PDF_CALL pdfCreateStructureTree(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfCreateSubmitAction(const PPDF* IPDF, TSubmitFlags Flags, const char* URL){return 0;}
SI32   PDF_CALL pdfCreateTextField(const PPDF* IPDF, const char* Name, SI32 Parent, LBOOL Multiline, SI32 MaxLen, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfCreateURIAction(const PPDF* IPDF, const char* URL){return 0;}
SI32   PDF_CALL pdfCreateViewportA(const PPDF* IPDF, const char* Name, double X1, double Y1, double X2, double Y2){return 0;}
SI32   PDF_CALL pdfCreateViewportW(const PPDF* IPDF, const UI16* Name, double X1, double Y1, double X2, double Y2){return 0;}
SI32   PDF_CALL pdfCreateXFAStreamA(const PPDF* IPDF, const char* Name, const void* Buffer, UI32 BufSize){return 0;}
SI32   PDF_CALL pdfCreateXFAStreamW(const PPDF* IPDF, const UI16* Name, const void* Buffer, UI32 BufSize){return 0;}
SI32   PDF_CALL pdfDecryptPDFA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* Password){return 0;}
SI32   PDF_CALL pdfDecryptPDFW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* Password){return 0;}
void   PDF_CALL pdfDeleteAcroForm(const PPDF* IPDF){}
LBOOL  PDF_CALL pdfDeleteActionFromObj(const PPDF* IPDF, TObjType ObjType, UI32 ActHandle, UI32 ObjHandle){return 0;}
LBOOL  PDF_CALL pdfDeleteActionFromObjEx(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex){return 0;}
LBOOL  PDF_CALL pdfDeleteAnnotation(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfDeleteAnnotationFromPage(const PPDF* IPDF, UI32 PageNum, UI32 Handle){return 0;}
SI32   PDF_CALL pdfDeleteAppEvents(const PPDF* IPDF, LBOOL ApplyEvent, TOCAppEvent Event){return 0;}
SI32   PDF_CALL pdfDeleteBookmark(const PPDF* IPDF, UI32 ABmk){return 0;}
LBOOL  PDF_CALL pdfDeleteEmbeddedFile(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfDeleteField(const PPDF* IPDF, UI32 AField){return 0;}
LBOOL  PDF_CALL pdfDeleteFieldEx(const PPDF* IPDF, const char* Name){return 0;}
void   PDF_CALL pdfDeleteJavaScripts(const PPDF* IPDF, LBOOL DelJavaScriptActions){}
LBOOL  PDF_CALL pdfDeleteNamedDestA(const PPDF* IPDF, const char* Name){return 0;}
LBOOL  PDF_CALL pdfDeleteNamedDestW(const PPDF* IPDF, const UI16* Name){return 0;}
LBOOL  PDF_CALL pdfDeleteNamedDestByIndex(const PPDF* IPDF, SI32 Index){return 0;}
LBOOL  PDF_CALL pdfDeleteOCGFromAppEvent(const PPDF* IPDF, UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories, LBOOL DelCategoryOnly){return 0;}
LBOOL  PDF_CALL pdfDeleteOCGFromDisplayTree(const PPDF* IPDF, UI32 OCGHandle, LBOOL Recursive){return 0;}
LBOOL  PDF_CALL pdfDeleteOCUINode(const PPDF* IPDF, IOCN* Node){return 0;}
SI32   PDF_CALL pdfDeleteOutputIntent(const PPDF* IPDF, SI32 Index){return 0;}
SI32   PDF_CALL pdfDeletePage(const PPDF* IPDF, UI32 PageNum){return 0;}
void   PDF_CALL pdfDeletePageLabels(const PPDF* IPDF){}
LBOOL  PDF_CALL pdfDeletePDF(void* IPDF){return 0;}
void   PDF_CALL pdfDeleteXFAForm(const PPDF* IPDF){}
LBOOL  PDF_CALL pdfDeleteSeparationInfo(const PPDF* IPDF, LBOOL AllPages){return 0;}
LBOOL  PDF_CALL pdfDeleteTemplate(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfDeleteTemplateEx(const PPDF* IPDF, UI32 Index){return 0;}
LBOOL  PDF_CALL pdfDrawArc(const PPDF* IPDF, double PosX, double PosY, double Radius, double StartAngle, double EndAngle){return 0;}
LBOOL  PDF_CALL pdfDrawArcEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle){return 0;}
LBOOL  PDF_CALL pdfDrawChord(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfDrawCircle(const PPDF* IPDF, double PosX, double PosY, double Radius, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfDrawNGon(const PPDF* IPDF, double PosX, double PosY, double Radius, double Alpha, UI32 NumSides, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfDrawPie(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfEditPage(const PPDF* IPDF, SI32 PageNum){return 0;}
LBOOL  PDF_CALL pdfEditTemplate(const PPDF* IPDF, UI32 Index){return 0;}
LBOOL  PDF_CALL pdfEditTemplate2(const PPDF* IPDF, UI32 Handle){return 0;}
void   PDF_CALL pdfEnableMutex(const PPDF* IPDF, LBOOL Value){}
LBOOL  PDF_CALL pdfEllipse(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TPathFillMode FillMode){return 0;}
SI32   PDF_CALL pdfEncryptPDFA(const PPDF* IPDF, const char* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict){return 0;}
SI32   PDF_CALL pdfEncryptPDFW(const PPDF* IPDF, const UI16* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict){return 0;}
LBOOL  PDF_CALL pdfEndContinueText(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfEndLayer(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfEndPage(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfEndPattern(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfEndTemplate(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfEnumDocFonts(const PPDF* IPDF, const void* Data, TEnumFontProc2* EnumProc){return 0;}
SI32   PDF_CALL pdfEnumHostFonts(const PPDF* IPDF, const void* Data, TEnumFontProc* EnumProc){return 0;}
SI32   PDF_CALL pdfEnumHostFontsEx(const PPDF* IPDF, const void* Data, TEnumFontProcEx* EnumProc){return 0;}
LBOOL  PDF_CALL pdfExchangeBookmarks(const PPDF* IPDF, SI32 Bmk1, SI32 Bmk2){return 0;}
LBOOL  PDF_CALL pdfExchangePages(const PPDF* IPDF, UI32 First, UI32 Second){return 0;}
LBOOL  PDF_CALL pdfExtractText(const PPDF* IPDF, UI32 PageNum, TTextExtractionFlags Flags, struct TFltRect* Area, UI16** Text, UI32* TextLen){return 0;}
SI32   PDF_CALL pdfFileAttachAnnotA(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const char* Author, const char* Desc, const char* AFile, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfFileAttachAnnotW(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const UI16* Author, const UI16* Desc, const UI16* AFile, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfFileAttachAnnotExA(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const char* FileName, const char* Author, const char* Desc, const void* Buffer, UI32 BufSize, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfFileAttachAnnotExW(const PPDF* IPDF, double PosX, double PosY, TFileAttachIcon Icon, const UI16* FileName, const UI16* Author, const UI16* Desc, const void* Buffer, UI32 BufSize, LBOOL Compress){return 0;}
SI32   PDF_CALL pdfFileLinkA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* AFilePath){return 0;}
SI32   PDF_CALL pdfFileLinkW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* AFilePath){return 0;}
SI32   PDF_CALL pdfFindBookmarkA(const PPDF* IPDF, SI32 DestPage, const char* Title){return 0;}
SI32   PDF_CALL pdfFindBookmarkW(const PPDF* IPDF, SI32 DestPage, const UI16* Title){return 0;}
SI32   PDF_CALL pdfFindEmbeddedFileA(const PPDF* IPDF, const char* Name){return 0;}
SI32   PDF_CALL pdfFindEmbeddedFileW(const PPDF* IPDF, const UI16* Name){return 0;}
SI32   PDF_CALL pdfFindFieldA(const PPDF* IPDF, const char* Name){return 0;}
SI32   PDF_CALL pdfFindFieldW(const PPDF* IPDF, const UI16* Name){return 0;}
SI32   PDF_CALL pdfFindLinkAnnot(const PPDF* IPDF, const char* URL){return 0;}
SI32   PDF_CALL pdfFindNextBookmark(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfFinishSignature(const PPDF* IPDF, const void* PKCS7Obj, UI32 Length){return 0;}
LBOOL  PDF_CALL pdfFlattenAnnotOrField(const PPDF* IPDF, UI32 Index, TAnnotFlattenFlags Flags){return 0;}
SI32   PDF_CALL pdfFlattenAnnots(const PPDF* IPDF, TAnnotFlattenFlags Flags){return 0;}
LBOOL  PDF_CALL pdfFlattenForm(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfFlushPageContent(const PPDF* IPDF, struct TPDFStack* Stack){return 0;}
LBOOL  PDF_CALL pdfFlushPages(const PPDF* IPDF, TFlushPageFlags Flags){return 0;}
void   PDF_CALL pdfFreeImageBuffer(const PPDF* IPDF){}
LBOOL  PDF_CALL pdfFreeImageObj(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfFreeImageObjEx(const PPDF* IPDF, const void* ImagePtr){return 0;}
LBOOL  PDF_CALL pdfFreePDF(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfFreeTextAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* AText, TTextAlign Align){return 0;}
SI32   PDF_CALL pdfFreeTextAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* AText, TTextAlign Align){return 0;}
LBOOL  PDF_CALL pdfFreeUniBuf(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGet3DAnnotStream(const PPDF* IPDF, UI32 Annot, BYTE** Data, UI32* Size, char** SubType){return 0;}
SI32   PDF_CALL pdfGetActionCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetActionHandle(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex){return 0;}
SI32   PDF_CALL pdfGetActionType(const PPDF* IPDF, UI32 ActHandle){return 0;}
SI32   PDF_CALL pdfGetActionTypeEx(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex){return 0;}
SI32   PDF_CALL pdfGetActiveFont(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetAllocBy(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetAnnot(const PPDF* IPDF, UI32 Handle, struct TPDFAnnotation ADDR Annot){return 0;}
LBOOL  PDF_CALL pdfGetAnnotBBox(const PPDF* IPDF, UI32 Handle, struct TPDFRect ADDR BBox){return 0;}
SI32   PDF_CALL pdfGetAnnotCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetAnnotEx(const PPDF* IPDF, UI32 Handle, struct TPDFAnnotationEx ADDR Annot){return 0;}
SI32   PDF_CALL pdfGetAnnotFlags(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetAnnotLink(const PPDF* IPDF, UI32 Handle){return 0;}
SI32   PDF_CALL pdfGetAnnotType(const PPDF* IPDF, UI32 Handle){return 0;}
double PDF_CALL pdfGetAscent(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetBarcodeDict(const void* IBarcode, struct TPDFBarcode* Barcode){return 0;}
LBOOL  PDF_CALL pdfGetBBox(const PPDF* IPDF, TPageBoundary Boundary, struct TPDFRect ADDR BBox){return 0;}
SI32   PDF_CALL pdfGetBidiMode(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetBookmark(const PPDF* IPDF, SI32 Handle, struct TBookmark ADDR Bmk){return 0;}
SI32   PDF_CALL pdfGetBookmarkCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetBorderStyle(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetBuffer(const PPDF* IPDF, UI32 ADDR BufSize){return 0;}
double PDF_CALL pdfGetCapHeight(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetCharacterSpacing(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetCheckBoxChar(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetCheckBoxCharEx(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetCheckBoxDefState(const PPDF* IPDF, UI32 AField){return 0;}
LBOOL  PDF_CALL pdfGetCMap(const PPDF* IPDF, UI32 Index, struct TPDFCMap* CMap){return 0;}
SI32   PDF_CALL pdfGetCMapCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetColorSpace(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetColorSpaceCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetColorSpaceObj(const PPDF* IPDF, UI32 Handle, struct TPDFColorSpaceObj* CS){return 0;}
LBOOL  PDF_CALL pdfGetColorSpaceObjEx(const void* IColorSpace, struct TPDFColorSpaceObj* CS){return 0;}
SI32   PDF_CALL pdfGetCompressionFilter(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetCompressionLevel(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetContent(const PPDF* IPDF, char* ADDR Buffer){return 0;}
SI32   PDF_CALL pdfGetDefBitsPerPixel(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetDescent(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetDeviceNAttributes(void* IAttributes, struct TDeviceNAttributes* Attributes){return 0;}
SI32   PDF_CALL pdfGetDocInfo(const PPDF* IPDF, TDocumentInfo DInfo, UI16* ADDR Value){return 0;}
SI32   PDF_CALL pdfGetDocInfoCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetDocInfoEx(const PPDF* IPDF, UI32 Index, TDocumentInfo ADDR DInfo, char* ADDR Key, char* ADDR Value, LBOOL ADDR Unicode){return 0;}
LBOOL  PDF_CALL pdfGetDocUsesTransparency(const PPDF* IPDF, UI32 Flags){return 0;}
SI32   PDF_CALL pdfGetDrawDirection(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetDynaPDFVersion(void){return 0;}
LBOOL  PDF_CALL pdfGetEmbeddedFile(const PPDF* IPDF, UI32 Handle, struct TPDFFileSpec* FileSpec, LBOOL Decompress){return 0;}
SI32   PDF_CALL pdfGetEmbeddedFileCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetEmbeddedFileNode(const IEFN* IEF, struct TPDFEmbFileNode* F, LBOOL Decompress){return 0;}
double PDF_CALL pdfGetEMFPatternDistance(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetErrLogMessage(const PPDF* IPDF, UI32 Index, struct TPDFError* Err){return 0;}
SI32   PDF_CALL pdfGetErrLogMessageCount(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetErrorMessage(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetErrorMode(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetField(const PPDF* IPDF, UI32 Handle, struct TPDFField* Field){return 0;}
UI32   PDF_CALL pdfGetFieldBackColor(const PPDF* IPDF){return 0;}
UI32   PDF_CALL pdfGetFieldBorderColor(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetFieldBorderStyle(const PPDF* IPDF, UI32 AField){return 0;}
double PDF_CALL pdfGetFieldBorderWidth(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldCalcOrder(const PPDF* IPDF, UI32** Out){return 0;}
LBOOL  PDF_CALL pdfGetFieldChoiceValue(const PPDF* IPDF, UI32 AField, UI32 ValIndex, struct TPDFChoiceValue* Value){return 0;}
LBOOL  PDF_CALL pdfGetFieldColor(const PPDF* IPDF, UI32 AField, TFieldColor ColorType, SI32 ADDR ColorSpace, UI32 ADDR Color){return 0;}
SI32   PDF_CALL pdfGetFieldCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetFieldEx(const PPDF* IPDF, UI32 Handle, struct TPDFFieldEx* Field){return 0;}
LBOOL  PDF_CALL pdfGetFieldEx2(const void* IField, struct TPDFFieldEx* Field){return 0;}
SI32   PDF_CALL pdfGetFieldExpValCount(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldExpValue(const PPDF* IPDF, UI32 AField, char* ADDR Value){return 0;}
LBOOL  PDF_CALL pdfGetFieldExpValueEx(const PPDF* IPDF, UI32 AField, UI32 ValIndex, char* ADDR Value, char* ADDR ExpValue, LBOOL ADDR Selected){return 0;}
SI32   PDF_CALL pdfGetFieldFlags(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldGroupType(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldHighlightMode(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldIndex(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldMapName(const PPDF* IPDF, UI32 AField, void* ADDR Value, LBOOL ADDR Unicode){return 0;}
SI32   PDF_CALL pdfGetFieldName(const PPDF* IPDF, UI32 AField, char* ADDR Name){return 0;}
SI32   PDF_CALL pdfGetFieldOrientation(const PPDF* IPDF, UI32 AField){return 0;}
SI32   PDF_CALL pdfGetFieldTextAlign(const PPDF* IPDF, UI32 AField){return 0;}
UI32   PDF_CALL pdfGetFieldTextColor(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetFieldToolTip(const PPDF* IPDF, UI32 AField, void* ADDR Value, LBOOL ADDR Unicode){return 0;}
SI32   PDF_CALL pdfGetFieldType(const PPDF* IPDF, UI32 AField){return 0;}
LBOOL  PDF_CALL pdfGetFileSpec(const IFSR* IFS, struct TPDFFileSpecEx* F){return 0;}
UI32   PDF_CALL pdfGetFillColor(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetFontCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetFontEx(const PPDF* IPDF, UI32 Handle, struct TPDFFontObj* F){return 0;}
LBOOL  PDF_CALL pdfGetFontInfoEx(const PPDF* IPDF, UI32 Handle, struct TPDFFontInfo* F){return 0;}
SI32   PDF_CALL pdfGetFontOrigin(const PPDF* IPDF){return 0;}
void   PDF_CALL pdfGetFontSearchOrder(const PPDF* IPDF, TFontBaseType Order[4]){return;}
SI32   PDF_CALL pdfGetFontSelMode(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetFontSize(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetFontWeight(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetFTextHeightA(const PPDF* IPDF, TTextAlign Align, const char* AText){return 0;}
double PDF_CALL pdfGetFTextHeightW(const PPDF* IPDF, TTextAlign Align, const UI16* AText){return 0;}
double PDF_CALL pdfGetFTextHeightExA(const PPDF* IPDF, double Width, TTextAlign Align, const char* AText){return 0;}
double PDF_CALL pdfGetFTextHeightExW(const PPDF* IPDF, double Width, TTextAlign Align, const UI16* AText){return 0;}
SI32   PDF_CALL pdfGetGlyphIndex(const PPDF* IPDF, UI32 Index){return 0;}
SI32   PDF_CALL pdfGetGlyphOutline(const PPDF* IPDF, UI32 Index, struct TPDFGlyphOutline* Outline){return 0;}
LBOOL  PDF_CALL pdfGetGoToAction(const PPDF* IPDF, UI32 Handle, struct TPDFGoToAction* Action){return 0;}
LBOOL  PDF_CALL pdfGetGoToRAction(const PPDF* IPDF, UI32 Handle, struct TPDFGoToAction* Action){return 0;}
UI32   PDF_CALL pdfGetGStateFlags(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetHideAction(const PPDF* IPDF, UI32 Handle, struct TPDFHideAction* Action){return 0;}
UI32   PDF_CALL pdfGetIconColor(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetImageBuffer(const PPDF* IPDF, UI32 ADDR BufSize){return 0;}
SI32   PDF_CALL pdfGetImageCount(const PPDF* IPDF, const char* FileName){return 0;}
SI32   PDF_CALL pdfGetImageCountEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize){return 0;}
SI32   PDF_CALL pdfGetImageHeight(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfGetImageObj(const PPDF* IPDF, UI32 Handle, TParseFlags Flags, struct TPDFImage* Image){return 0;}
SI32   PDF_CALL pdfGetImageObjCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetImageObjEx(const PPDF* IPDF, const void* ImagePtr, TParseFlags Flags, struct TPDFImage* Image){return 0;}
SI32   PDF_CALL pdfGetImageWidth(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfGetImportDataAction(const PPDF* IPDF, UI32 Handle, struct TPDFImportDataAction* Action){return 0;}
UI32   PDF_CALL pdfGetImportFlags(const PPDF* IPDF){return 0;}
UI32   PDF_CALL pdfGetImportFlags2(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInBBox(const PPDF* IPDF, UI32 PageNum, TPageBoundary Boundary, struct TPDFRect ADDR BBox){return 0;}
SI32   PDF_CALL pdfGetInDocInfo(const PPDF* IPDF, TDocumentInfo DInfo, UI16* ADDR Value){return 0;}
SI32   PDF_CALL pdfGetInDocInfoCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetInDocInfoEx(const PPDF* IPDF, UI32 Index, TDocumentInfo ADDR DInfo, char* ADDR Key, char* ADDR Value, LBOOL ADDR Unicode){return 0;}
SI32   PDF_CALL pdfGetInEncryptionFlags(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetInFieldCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInIsCollection(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInIsEncrypted(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInIsSigned(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInIsTrapped(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInIsXFAForm(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInkList(const ILST* List, float** Points, UI32* Count){return 0;}
LBOOL  PDF_CALL pdfGetInMetadata(const PPDF* IPDF, SI32 PageNum, BYTE** Buffer, UI32* BufSize){return 0;}
LBOOL  PDF_CALL pdfGetInNamedDest(const PPDF* IPDF, UI32 Index, struct TPDFNamedDest* Dest){return 0;}
SI32   PDF_CALL pdfGetInNamedDestCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetInOrientation(const PPDF* IPDF, SI32 PageNum){return 0;}
SI32   PDF_CALL pdfGetInPageCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetInPDFVersion(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetInPrintSettings(const PPDF* IPDF, struct TPDFPrintSettings* Settings){return 0;}
SI32   PDF_CALL pdfGetIsFixedPitch(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetIsTaggingEnabled(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetItalicAngle(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetJavaScript(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode){return 0;}
char*  PDF_CALL pdfGetJavaScriptAction(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode){return 0;}
char*  PDF_CALL pdfGetJavaScriptAction2(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, UI32 ActIndex, UI32 ADDR Len, LBOOL ADDR Unicode){return 0;}
LBOOL  PDF_CALL pdfGetJavaScriptActionEx(const PPDF* IPDF, UI32 Handle, struct TPDFJavaScriptAction* Action){return 0;}
SI32   PDF_CALL pdfGetJavaScriptCount(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetJavaScriptEx(const PPDF* IPDF, const char* Name, UI32 ADDR Len, LBOOL ADDR Unicode){return 0;}
char*  PDF_CALL pdfGetJavaScriptName(const PPDF* IPDF, UI32 Handle, UI32 ADDR Len, LBOOL ADDR Unicode){return 0;}
SI32   PDF_CALL pdfGetJPEGQuality(const PPDF* IPDF){return 0;}
char*  PDF_CALL pdfGetLanguage(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetLastTextPosX(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetLastTextPosY(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetLayerConfig(const PPDF* IPDF, SI32 Index, struct TPDFOCLayerConfig* Config){return 0;}
SI32   PDF_CALL pdfGetLayerConfigCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetLaunchAction(const PPDF* IPDF, UI32 Handle, struct TPDFLaunchAction* Action){return 0;}
double PDF_CALL pdfGetLeading(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetLineCapStyle(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetLineJoinStyle(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetLineWidth(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetLinkHighlightMode(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetLogMetafileSize(const PPDF* IPDF, const char* FileName, struct TRectL* R){return 0;}
LBOOL  PDF_CALL pdfGetLogMetafileSizeEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, struct TRectL* R){return 0;}
LBOOL  PDF_CALL pdfGetMatrix(const PPDF* IPDF, struct TCTM* M){return 0;}
SI32   PDF_CALL pdfGetMaxFieldLen(const PPDF* IPDF, UI32 TxtField){return 0;}
LBOOL  PDF_CALL pdfGetMeasureObj(const IMSR* Measure, struct TPDFMeasure* Value){return 0;}
UI32   PDF_CALL pdfGetMetaConvFlags(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetMetadata(const PPDF* IPDF, TMetadataObj ObjType, SI32 Handle, BYTE** Buffer, UI32* BufSize){return 0;}
UI32*  PDF_CALL pdfGetMissingGlyphs(const PPDF* IPDF, UI32 ADDR Count){return 0;}
double PDF_CALL pdfGetMiterLimit(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetMovieAction(const PPDF* IPDF, UI32 Handle, struct TPDFMovieAction* Action){return 0;}
LBOOL  PDF_CALL pdfGetNamedAction(const PPDF* IPDF, UI32 Handle, struct TPDFNamedAction* Action){return 0;}
LBOOL  PDF_CALL pdfGetNamedDest(const PPDF* IPDF, UI32 Index, struct TPDFNamedDest* Dest){return 0;}
SI32   PDF_CALL pdfGetNamedDestCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetNeedAppearance(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetNumberFormatObj(const INFM* NumberFmt, struct TPDFNumberFormat* Value){return 0;}
SI32   PDF_CALL pdfGetObjActionCount(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle){return 0;}
LBOOL  PDF_CALL pdfGetObjActions(const PPDF* IPDF, TObjType ObjType, UI32 ObjHandle, struct TPDFObjActions* Actions){return 0;}
LBOOL  PDF_CALL pdfGetObjEvent(const IEVT* IEvent, struct TPDFObjEvent* Event){return 0;}
LBOOL  PDF_CALL pdfGetOCG(const PPDF* IPDF, UI32 Handle, struct TPDFOCG* Out){return 0;}
LBOOL  PDF_CALL pdfGetOCGContUsage(const PPDF* IPDF, UI32 Handle, struct TPDFOCGContUsage* Out){return 0;}
SI32   PDF_CALL pdfGetOCGCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetOCGUsageUserName(const PPDF* IPDF, UI32 Handle, UI32 Index, char* ADDR NameA, UI16* ADDR NameW){return 0;}
IOCN*  PDF_CALL pdfGetOCUINode(const PPDF* IPDF, const IOCN* Node, struct TPDFOCUINode* OutNode){return 0;}
double PDF_CALL pdfGetOpacity(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetOrientation(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetOutputIntent(const PPDF* IPDF, UI32 Index, struct TPDFOutputIntent* Intent){return 0;}
SI32   PDF_CALL pdfGetOutputIntentCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPageAnnot(const PPDF* IPDF, UI32 Index, struct TPDFAnnotation ADDR Annot){return 0;}
LBOOL  PDF_CALL pdfGetPageAnnotEx(const PPDF* IPDF, UI32 Index, struct TPDFAnnotationEx ADDR Annot){return 0;}
SI32   PDF_CALL pdfGetPageAnnotCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPageBBox(IPGE* PagePtr, TPageBoundary Boundary, struct TFltRect* BBox){return 0;}
SI32   PDF_CALL pdfGetPageCoords(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetPageCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPageField(const PPDF* IPDF, UI32 Index, struct TPDFField* Field){return 0;}
SI32   PDF_CALL pdfGetPageFieldCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPageFieldEx(const PPDF* IPDF, UI32 Index, struct TPDFFieldEx* Field){return 0;}
double PDF_CALL pdfGetPageHeight(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPageLabel(const PPDF* IPDF, UI32 Index, struct TPDFPageLabel* Label){return 0;}
SI32   PDF_CALL pdfGetPageLabelCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetPageLayout(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetPageMode(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetPageNum(const PPDF* IPDF){return 0;}
IPGE*  PDF_CALL pdfGetPageObject(const PPDF* IPDF, UI32 PageNum){return 0;}
SI32   PDF_CALL pdfGetPageOrientation(IPGE* PagePtr){return 0;}
LBOOL  PDF_CALL pdfGetPageText(const PPDF* IPDF, struct TPDFStack* Stack){return 0;}
double PDF_CALL pdfGetPageWidth(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetPDFVersion(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetPDFVersionEx(const PPDF* IPDF, struct TPDFVersionInfo* Value){return 0;}
LBOOL  PDF_CALL pdfGetPrintSettings(const PPDF* IPDF, struct TPDFPrintSettings* Settings){return 0;}
LBOOL  PDF_CALL pdfGetPtDataArray(const IPTD* PtData, UI32 Index, char** DataType, float** Values, UI32* ValCount){return 0;}
LBOOL  PDF_CALL pdfGetPtDataObj(const IPTD* PtData, char** Subtype, UI32* NumArrays){return 0;}
LBOOL  PDF_CALL pdfGetRelFileNode(const IRFN* IRF, struct TPDFRelFileNode* F, LBOOL Decompress){return 0;}
LBOOL  PDF_CALL pdfGetResetAction(const PPDF* IPDF, UI32 Handle, struct TPDFResetFormAction* Value){return 0;}
SI32   PDF_CALL pdfGetResolution(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetSaveNewImageFormat(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetSeparationInfo(const PPDF* IPDF, char* ADDR Colorant, TExtColorSpace ADDR CS){return 0;}
LBOOL  PDF_CALL pdfGetSigDict(const void* ISignature, struct TPDFSigDict* SigDict){return 0;}
UI32   PDF_CALL pdfGetStrokeColor(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetSubmitAction(const PPDF* IPDF, UI32 Handle, struct TPDFSubmitFormAction* Value){return 0;}
SI32   PDF_CALL pdfGetSysFontInfo(const PPDF* IPDF, UI32 Handle, struct TPDFSysFont* Out){return 0;}
SI32   PDF_CALL pdfGetTabLen(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetTemplCount(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetTemplHandle(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetTemplHeight(const PPDF* IPDF, SI32 Handle){return 0;}
double PDF_CALL pdfGetTemplWidth(const PPDF* IPDF, SI32 Handle){return 0;}
SI32   PDF_CALL pdfGetTextDrawMode(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetTextFieldValue(const PPDF* IPDF, UI32 AField, char* ADDR Value, LBOOL ADDR ValIsUnicode, char* ADDR DefValue, LBOOL ADDR DefValIsUnicode){return 0;}
LBOOL  PDF_CALL pdfGetTextRect(const PPDF* IPDF, double ADDR PosX, double ADDR PosY, double ADDR Width, double ADDR Height){return 0;}
double PDF_CALL pdfGetTextRise(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetTextScaling(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetTextWidthA(const PPDF* IPDF, const char* AText){return 0;}
double PDF_CALL pdfGetTextWidthW(const PPDF* IPDF, const UI16* AText){return 0;}
double PDF_CALL pdfGetTextWidthExA(const PPDF* IPDF, const char* AText, UI32 Len){return 0;}
double PDF_CALL pdfGetTextWidthExW(const PPDF* IPDF, const UI16* AText, UI32 Len){return 0;}
UI32   PDF_CALL pdfGetTransparentColor(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetTrapped(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetTypoLeading(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetURIAction(const PPDF* IPDF, UI32 Handle, struct TPDFURIAction* Action){return 0;}
LBOOL  PDF_CALL pdfGetUseExactPwd(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetUseGlobalImpFiles(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetUserRights(const PPDF* IPDF){return 0;}
float  PDF_CALL pdfGetUserUnit(const PPDF* IPDF){return 0.0f;}
LBOOL  PDF_CALL pdfGetUseStdFonts(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetUseSystemFonts(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfGetUsesTransparency(const PPDF* IPDF, SI32 PageNum){return 0;}
LBOOL  PDF_CALL pdfGetUseTransparency(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetUseVisibleCoords(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetViewerPrefrences(const PPDF* IPDF, SI32 ADDR Preference, SI32 ADDR AddVal){return 0;}
LBOOL  PDF_CALL pdfGetViewport(const PPDF* IPDF, UI32 PageNum, UI32 Index, struct TPDFViewport* VP){return 0;}
SI32   PDF_CALL pdfGetViewportCount(const PPDF* IPDF, UI32 PageNum){return 0;}
LBOOL  PDF_CALL pdfGetWMFDefExtent(const PPDF* IPDF, UI32 ADDR Width, UI32 ADDR Height){return 0;}
SI32   PDF_CALL pdfGetWMFPixelPerInch(const PPDF* IPDF){return 0;}
double PDF_CALL pdfGetWordSpacing(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfGetXFAStream(const PPDF* IPDF, UI32 Index, struct TPDFXFAStream* Out){return 0;}
SI32   PDF_CALL pdfGetXFAStreamCount(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfHaveOpenDoc(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfHaveOpenPage(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfHighlightAnnotA(const PPDF* IPDF, TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const char* Author, const char* Subject, const char* Comment){return 0;}
SI32   PDF_CALL pdfHighlightAnnotW(const PPDF* IPDF, TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const UI16* Author, const UI16* Subject, const UI16* Comment){return 0;}
SI32   PDF_CALL pdfImportBookmarks(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfImportCatalogObjects(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfImportDocInfo(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfImportEncryptionSettings(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfImportOCProperties(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfImportPage(const PPDF* IPDF, UI32 PageNum){return 0;}
SI32   PDF_CALL pdfImportPageEx(const PPDF* IPDF, UI32 PageNum, double ScaleX, double ScaleY){return 0;}
SI32   PDF_CALL pdfImportPDFFile(const PPDF* IPDF, UI32 DestPage, double ScaleX, double ScaleY){return 0;}
LBOOL  PDF_CALL pdfInitBarcode2(struct TPDFBarcode2* Barcode){return 0;}
LBOOL  PDF_CALL pdfInitColorManagement(const PPDF* IPDF, struct TPDFColorProfiles* Profiles, TPDFColorSpace DestSpace, TPDFInitCMFlags Flags){return 0;}
LBOOL  PDF_CALL pdfInitColorManagementEx(const PPDF* IPDF, struct TPDFColorProfilesEx* Profiles, TPDFColorSpace DestSpace, TPDFInitCMFlags Flags){return 0;}
LBOOL  PDF_CALL pdfInitExtGState(struct TPDFExtGState* GS){return 0;}
LBOOL  PDF_CALL pdfInitHeaderFooter(struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray, UI32 Count){return 0;}
LBOOL  PDF_CALL pdfInitOCGContUsage(struct TPDFOCGContUsage* Value){return 0;}
LBOOL  PDF_CALL pdfInitStack(const PPDF* IPDF, struct TPDFStack* Stack){return 0;}
SI32   PDF_CALL pdfInkAnnotA(const PPDF* IPDF, struct TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content){return 0;}
SI32   PDF_CALL pdfInkAnnotW(const PPDF* IPDF, struct TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content){return 0;}
SI32   PDF_CALL pdfInsertBarcode(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TCellAlign HAlign, TCellAlign VAlign, struct TPDFBarcode2* Barcode){return 0;}
SI32   PDF_CALL pdfInsertBMPFromBuffer(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer){return 0;}
SI32   PDF_CALL pdfInsertBMPFromHandle(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, void* hBitmap){return 0;}
SI32   PDF_CALL pdfInsertBookmarkA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 DestPage, LBOOL Open, LBOOL AddChildren){return 0;}
SI32   PDF_CALL pdfInsertBookmarkW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 DestPage, LBOOL Open, LBOOL AddChildren){return 0;}
SI32   PDF_CALL pdfInsertBookmarkExA(const PPDF* IPDF, const char* Title, SI32 Parent, UI32 NamedDest, LBOOL Open, LBOOL AddChildren){return 0;}
SI32   PDF_CALL pdfInsertBookmarkExW(const PPDF* IPDF, const UI16* Title, SI32 Parent, UI32 NamedDest, LBOOL Open, LBOOL AddChildren){return 0;}
SI32   PDF_CALL pdfInsertImage(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* AFile){return 0;}
SI32   PDF_CALL pdfInsertImageEx(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* AFile, UI32 Index){return 0;}
SI32   PDF_CALL pdfInsertImageFromBuffer(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer, UI32 BufSize, UI32 Index){return 0;}
LBOOL  PDF_CALL pdfInsertMetafile(const PPDF* IPDF, const char* FileName, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfInsertMetafileEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfInsertMetafileExt(const PPDF* IPDF, const char* FileName, struct TRectL* View, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfInsertMetafileExtEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, struct TRectL* View, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfInsertMetafileFromHandle(const PPDF* IPDF, const void* hEnhMetafile, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfInsertMetafileFromHandleEx(const PPDF* IPDF, const void* hEnhMetafile, struct TRectL* View, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfInsertRawImage(const PPDF* IPDF, const void* Buffer, UI32 BitsPerPixel, UI32 ColorCount, UI32 ImgWidth, UI32 ImgHeight, double PosX, double PosY, double ScaleWidth, double ScaleHeight){return 0;}
SI32   PDF_CALL pdfInsertRawImageEx(const PPDF* IPDF, double PosX, double PosY, double ScaleWidth, double ScaleHeight, struct TPDFRawImage* Image){return 0;}
SI32   PDF_CALL pdfIsBidiText(const PPDF* IPDF, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfIsColorPage(const PPDF* IPDF, LBOOL GrayIsColor){return 0;}
LBOOL  PDF_CALL pdfIsEmptyPage(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfLineTo(const PPDF* IPDF, double PosX, double PosY){return 0;}
SI32   PDF_CALL pdfLoadCMap(const PPDF* IPDF, const char* CMapName, LBOOL Embed){return 0;}
LBOOL  PDF_CALL pdfLoadFDFDataA(const PPDF* IPDF, const char* FileName, const char* Password, UI32 Flags){return 0;}
LBOOL  PDF_CALL pdfLoadFDFDataW(const PPDF* IPDF, const UI16* FileName, const char* Password, UI32 Flags){return 0;}
LBOOL  PDF_CALL pdfLoadFDFDataEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, const char* Password, UI32 Flags){return 0;}
SI32   PDF_CALL pdfLoadFont(const PPDF* IPDF, const void* Buffer, UI32 BufSize, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfLoadFontExA(const PPDF* IPDF, const char* FontFile, UI32 Index, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfLoadFontExW(const PPDF* IPDF, const UI16* FontFile, UI32 Index, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfLoadHeaderFooterSettings(const PPDF* IPDF, struct TPDFHeaderFooter* Init, struct TPDFHdrFtr* HFArray){return 0;}
LBOOL  PDF_CALL pdfLoadLayerConfig(const PPDF* IPDF, SI32 Index){return 0;}
LBOOL  PDF_CALL pdfLockLayer(const PPDF* IPDF, UI32 Layer){return 0;}
LBOOL  PDF_CALL pdfMovePage(const PPDF* IPDF, UI32 Source, UI32 Dest){return 0;}
LBOOL  PDF_CALL pdfMoveTo(const PPDF* IPDF, double PosX, double PosY){return 0;}
SI32   PDF_CALL pdfMultiplyMatrix(struct TCTM* M1, struct TCTM* M2, struct TCTM* NewMatrix){return 0;}
void*  PDF_CALL pdfNewPDF(void){return 0;}
SI32   PDF_CALL pdfOpenImportBuffer(const PPDF* IPDF, const void* Buffer, UI32 BufSize, TPwdType PwdType, const char* Password){return 0;}
SI32   PDF_CALL pdfOpenImportFileA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* Password){return 0;}
SI32   PDF_CALL pdfOpenImportFileW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* Password){return 0;}
LBOOL  PDF_CALL pdfOpenOutputFileA(const PPDF* IPDF, const char* OutPDF){return 0;}
LBOOL  PDF_CALL pdfOpenOutputFileW(const PPDF* IPDF, const UI16* OutPDF){return 0;}
LBOOL  PDF_CALL pdfOpenOutputFileEncryptedA(const PPDF* IPDF, const char* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict){return 0;}
LBOOL  PDF_CALL pdfOpenOutputFileEncryptedW(const PPDF* IPDF, const UI16* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict){return 0;}
LBOOL  PDF_CALL pdfOpenTagA(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion){return 0;}
LBOOL  PDF_CALL pdfOpenTagW(const PPDF* IPDF, TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion){return 0;}
LBOOL  PDF_CALL pdfOptimize(const PPDF* IPDF, UI32 Flags, struct TOptimizeParams* Parms){return 0;}
SI32   PDF_CALL pdfPageLink(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 DestPage){return 0;}
SI32   PDF_CALL pdfPageLink2(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, UI32 NamedDest){return 0;}
SI32   PDF_CALL pdfPageLink3A(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* NamedDest){return 0;}
SI32   PDF_CALL pdfPageLink3W(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* NamedDest){return 0;}
SI32   PDF_CALL pdfPageLinkEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TDestType DestType, UI32 DestPage, double a, double b, double c, double d){return 0;}
LBOOL  PDF_CALL pdfParseContent(const PPDF* IPDF, const void* Data, struct TPDFParseInterface* Stack, TParseFlags Flags){return 0;}
LBOOL  PDF_CALL pdfPlaceImage(const PPDF* IPDF, SI32 ImgHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight){return 0;}
LBOOL  PDF_CALL pdfPlaceSigFieldValidateIcon(const PPDF* IPDF, UI32 SigField, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfPlaceTemplate(const PPDF* IPDF, SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight){return 0;}
LBOOL  PDF_CALL pdfPlaceTemplateEx(const PPDF* IPDF, SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight){return 0;}
LBOOL  PDF_CALL pdfPlaceTemplByMatrix(const PPDF* IPDF, SI32 TmplHandle){return 0;}
LBOOL  PDF_CALL pdfPrintPageA(const PPDF* IPDF, UI32 PageNum, const char* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms){return 0;}
LBOOL  PDF_CALL pdfPrintPageW(const PPDF* IPDF, UI32 PageNum, const UI16* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, struct TPDFPrintParams* Parms){return 0;}
LBOOL  PDF_CALL pdfPrintPDFFileA(const PPDF* IPDF, const char* TmpDir, const char* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, const void* Parms){return 0;}
LBOOL  PDF_CALL pdfPrintPDFFileW(const PPDF* IPDF, const UI16* TmpDir, const UI16* DocName, const void* DC, TPDFPrintFlags Flags, struct TRectL* Margin, const void* Parms){return 0;}
LBOOL  PDF_CALL pdfReadImageFormat(const PPDF* IPDF, const char* FileName, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip){return 0;}
LBOOL  PDF_CALL pdfReadImageFormat2(const PPDF* IPDF, const char* FileName, UI32 Index, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip){return 0;}
LBOOL  PDF_CALL pdfReadImageFormatEx(const PPDF* IPDF, void* hBitmap, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip){return 0;}
LBOOL  PDF_CALL pdfReadImageFormatFromBuffer(const PPDF* IPDF, const void* Buffer, UI32 BufSize, UI32 Index, UI32 ADDR Width, UI32 ADDR Height, SI32 ADDR BitsPerPixel, SI32 ADDR UseZip){return 0;}
LBOOL  PDF_CALL pdfReadImageResolution(const PPDF* IPDF, const char* FileName, UI32 Index, UI32 ADDR ResX, UI32 ADDR ResY){return 0;}
LBOOL  PDF_CALL pdfReadImageResolutionEx(const PPDF* IPDF, const void* Buffer, UI32 BufSize, UI32 Index, UI32 ADDR ResX, UI32 ADDR ResY){return 0;}
LBOOL  PDF_CALL pdfRectangle(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TPathFillMode FillMode){return 0;}
SI32   PDF_CALL pdfReEncryptPDFA(const PPDF* IPDF, const char* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict){return 0;}
SI32   PDF_CALL pdfReEncryptPDFW(const PPDF* IPDF, const UI16* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict){return 0;}
SI32   PDF_CALL pdfRenameSpotColor(const PPDF* IPDF, const char* Colorant, const char* NewName){return 0;}
SI32   PDF_CALL pdfRenderAnnotOrField(const PPDF* IPDF, UI32 Handle, LBOOL IsAnnot, TButtonState State, struct TCTM* Matrix, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, struct TPDFBitmap* Out){return 0;}
LBOOL  PDF_CALL pdfRenderPage(const PPDF* IPDF, IPGE* PagePtr, IRAS* RasPtr, struct TPDFRasterImage* Img){return 0;}
LBOOL  PDF_CALL pdfRenderPageEx(const PPDF* IPDF, const void* DC, SI32* DestX, SI32* DestY, IPGE* PagePtr, IRAS* RasPtr, struct TPDFRasterImage* Img){return 0;}
LBOOL  PDF_CALL pdfRenderPageToImageA(const PPDF* IPDF, UI32 PageNum, const char* OutFile, UI32 Resolution, UI32 Width, UI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfRenderPageToImageW(const PPDF* IPDF, UI32 PageNum, const UI16* OutFile, UI32 Resolution, UI32 Width, UI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfRenderPDFFileA(const PPDF* IPDF, const char* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfRenderPDFFileW(const PPDF* IPDF, const UI16* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfRenderPDFFileExA(const PPDF* IPDF, const char* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfRenderPDFFileExW(const PPDF* IPDF, const UI16* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format){return 0;}
LBOOL  PDF_CALL pdfReOpenImportFile(const PPDF* IPDF, UI32 Handle){return 0;}
SI32   PDF_CALL pdfReplaceFontA(const PPDF* IPDF, const void* PDFFont, const char* Name, TFStyle Style, LBOOL NameIsFamilyName){return 0;}
SI32   PDF_CALL pdfReplaceFontW(const PPDF* IPDF, const void* PDFFont, const UI16* Name, TFStyle Style, LBOOL NameIsFamilyName){return 0;}
SI32   PDF_CALL pdfReplaceFontExA(const PPDF* IPDF, const void* PDFFont, const char* FontFile, LBOOL Embed){return 0;}
SI32   PDF_CALL pdfReplaceFontExW(const PPDF* IPDF, const void* PDFFont, const UI16* FontFile, LBOOL Embed){return 0;}
SI32   PDF_CALL pdfReplaceICCProfileA(const PPDF* IPDF, UI32 ColorSpace, const char* ICCFile){return 0;}
SI32   PDF_CALL pdfReplaceICCProfileW(const PPDF* IPDF, UI32 ColorSpace, const UI16* ICCFile){return 0;}
SI32   PDF_CALL pdfReplaceICCProfileEx(const PPDF* IPDF, UI32 ColorSpace, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfReplaceImageA(const PPDF* IPDF, const PIMG* Source, const char* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags){return 0;}
LBOOL  PDF_CALL pdfReplaceImageW(const PPDF* IPDF, const PIMG* Source, const UI16* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags){return 0;}
LBOOL  PDF_CALL pdfReplaceImageEx(const PPDF* IPDF, const PIMG* Source, const void* Buffer, UI32 BufSize, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags){return 0;}
LBOOL  PDF_CALL pdfReplacePageTextA(const PPDF* IPDF, const char* NewText, struct TPDFStack* Stack){return 0;}
LBOOL  PDF_CALL pdfReplacePageTextExA(const PPDF* IPDF, const char* NewText, struct TPDFStack* Stack){return 0;}
LBOOL  PDF_CALL pdfReplacePageTextExW(const PPDF* IPDF, const UI16* NewText, struct TPDFStack* Stack){return 0;}
LBOOL  PDF_CALL pdfResetEncryptionSettings(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfResetLineDashPattern(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfRestoreGraphicState(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfRotateCoords(const PPDF* IPDF, double alpha, double OriginX, double OriginY){return 0;}
LBOOL  PDF_CALL pdfRoundRect(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double Radius, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfRoundRectEx(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, double rWidth, double rHeight, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfSaveGraphicState(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfScaleCoords(const PPDF* IPDF, double sx, double sy){return 0;}
LBOOL  PDF_CALL pdfSelfTest(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfSet3DAnnotProps(const PPDF* IPDF, UI32 Annot, T3DActivationType ActType, T3DDeActivateType DeActType, T3DInstanceType InstType, T3DDeActInstance DeInstType, LBOOL DisplToolbar, LBOOL DisplModelTree){return 0;}
LBOOL  PDF_CALL pdfSet3DAnnotScriptA(const PPDF* IPDF, UI32 Annot, const char* Value, UI32 Len){return 0;}
SI32   PDF_CALL pdfSetAllocBy(const PPDF* IPDF, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotBorderEffect(const PPDF* IPDF, UI32 Handle, TBorderEffect Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotBorderStyle(const PPDF* IPDF, UI32 Handle, TBorderStyle Style){return 0;}
LBOOL  PDF_CALL pdfSetAnnotBorderWidth(const PPDF* IPDF, UI32 Handle, double LineWidth){return 0;}
LBOOL  PDF_CALL pdfSetAnnotColor(const PPDF* IPDF, UI32 Handle, TAnnotColor ColorType, TPDFColorSpace CS, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetAnnotFlags(const PPDF* IPDF, TAnnotFlags Flags){return 0;}
LBOOL  PDF_CALL pdfSetAnnotFlagsEx(const PPDF* IPDF, UI32 Handle, SI32 Flags){return 0;}
LBOOL  PDF_CALL pdfSetAnnotHighlightMode(const PPDF* IPDF, UI32 Handle, THighlightMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetAnnotIcon(const PPDF* IPDF, UI32 Handle, TAnnotIcon Icon){return 0;}
LBOOL  PDF_CALL pdfSetAnnotLineDashPattern(const PPDF* IPDF, UI32 Handle, const float* Dash, UI32 NumValues){return 0;}
LBOOL  PDF_CALL pdfSetAnnotLineEndStyle(const PPDF* IPDF, UI32 Handle, TLineEndStyle Start, TLineEndStyle End){return 0;}
SI32   PDF_CALL pdfSetAnnotMigrationStateA(const PPDF* IPDF, UI32 Annot, TAnnotState State, const char* User){return 0;}
SI32   PDF_CALL pdfSetAnnotMigrationStateW(const PPDF* IPDF, UI32 Annot, TAnnotState State, const UI16* User){return 0;}
LBOOL  PDF_CALL pdfSetAnnotOpacity(const PPDF* IPDF, UI32 Handle, double Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotOpenState(const PPDF* IPDF, UI32 Handle, LBOOL Open){return 0;}
LBOOL  PDF_CALL pdfSetAnnotOrFieldDate(const PPDF* IPDF, UI32 Handle, LBOOL IsField, TDateType Type, UI32 DateTime){return 0;}
LBOOL  PDF_CALL pdfSetAnnotQuadPoints(const PPDF* IPDF, UI32 Handle, TFltPoint* Value, UI32 Count){return 0;}
LBOOL  PDF_CALL pdfSetAnnotStringA(const PPDF* IPDF, UI32 Handle, TAnnotString StringType, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotStringW(const PPDF* IPDF, UI32 Handle, TAnnotString StringType, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotSubjectA(const PPDF* IPDF, UI32 Handle, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetAnnotSubjectW(const PPDF* IPDF, UI32 Handle, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetBBox(const PPDF* IPDF, TPageBoundary Boundary, double LeftX, double LeftY, double RightX, double RightY){return 0;}
LBOOL  PDF_CALL pdfSetBidiMode(const PPDF* IPDF, TPDFBidiMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetBookmarkDest(const PPDF* IPDF, SI32 ABmk, TDestType DestType, double a, double b, double c, double d){return 0;}
LBOOL  PDF_CALL pdfSetBookmarkStyle(const PPDF* IPDF, SI32 ABmk, TFStyle Style, UI32 RGBColor){return 0;}
LBOOL  PDF_CALL pdfSetBorderStyle(const PPDF* IPDF, TBorderStyle Style){return 0;}
LBOOL  PDF_CALL pdfSetCharacterSpacing(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetCheckBoxChar(const PPDF* IPDF, TCheckBoxChar CheckBoxChar){return 0;}
LBOOL  PDF_CALL pdfSetCheckBoxDefState(const PPDF* IPDF, UI32 AField, LBOOL Checked){return 0;}
LBOOL  PDF_CALL pdfSetCheckBoxState(const PPDF* IPDF, UI32 AField, LBOOL Checked){return 0;}
SI32   PDF_CALL pdfSetCIDFontA(const PPDF* IPDF, UI32 CMapHandle, const char* Name, TFStyle Style, double Size, LBOOL Embed){return 0;}
SI32   PDF_CALL pdfSetCIDFontW(const PPDF* IPDF, UI32 CMapHandle, const UI16* Name, TFStyle Style, double Size, LBOOL Embed){return 0;}
SI32   PDF_CALL pdfSetCMapDirA(const PPDF* IPDF, const char* Path, LBOOL Recursive){return 0;}
SI32   PDF_CALL pdfSetCMapDirW(const PPDF* IPDF, const UI16* Path, LBOOL Recursive){return 0;}
LBOOL  PDF_CALL pdfSetColDefFile(const PPDF* IPDF, UI32 EmbFile){return 0;}
LBOOL  PDF_CALL pdfSetColorMask(const PPDF* IPDF, UI32 ImageHandle, SI32* Mask, UI32 Count){return 0;}
LBOOL  PDF_CALL pdfSetColors(const PPDF* IPDF, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetColorSpace(const PPDF* IPDF, TPDFColorSpace ColorSpace){return 0;}
LBOOL  PDF_CALL pdfSetColSortField(const PPDF* IPDF, UI32 ColField, LBOOL AscendingOrder){return 0;}
LBOOL  PDF_CALL pdfSetCompressionFilter(const PPDF* IPDF, TCompressionFilter Filter){return 0;}
LBOOL  PDF_CALL pdfSetCompressionLevel(const PPDF* IPDF, TCompressionLevel CompressLevel){return 0;}
LBOOL  PDF_CALL pdfSetContent(const PPDF* IPDF, const char* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfSetDateTimeFormat(const PPDF* IPDF, UI32 TxtField, TPDFDateTime Fmt){return 0;}
LBOOL  PDF_CALL pdfSetDefBitsPerPixel(const PPDF* IPDF, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetDocInfoA(const PPDF* IPDF, TDocumentInfo DInfo, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetDocInfoW(const PPDF* IPDF, TDocumentInfo DInfo, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetDocInfoExA(const PPDF* IPDF, TDocumentInfo DInfo, const char* Key, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetDocInfoExW(const PPDF* IPDF, TDocumentInfo DInfo, const char* Key, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetDrawDirection(const PPDF* IPDF, TDrawDirection Direction){return 0;}
LBOOL  PDF_CALL pdfSetEMFFrameDPI(const PPDF* IPDF, UI32 DPIX, UI32 DPIY){return 0;}
LBOOL  PDF_CALL pdfSetEMFPatternDistance(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetErrorMode(const PPDF* IPDF, TErrMode ErrMode){return 0;}
LBOOL  PDF_CALL pdfSetExtColorSpace(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetExtFillColorSpace(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetExtGState(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetExtStrokeColorSpace(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetFieldBackColor(const PPDF* IPDF, UI32 AColor){return 0;}
LBOOL  PDF_CALL pdfSetFieldBBox(const PPDF* IPDF, UI32 AField, struct TPDFRect* BBox){return 0;}
LBOOL  PDF_CALL pdfSetFieldBorderColor(const PPDF* IPDF, UI32 AColor){return 0;}
LBOOL  PDF_CALL pdfSetFieldBorderWidth(const PPDF* IPDF, UI32 AField, double LineWidth){return 0;}
LBOOL  PDF_CALL pdfSetFieldCalcOrder(const PPDF* IPDF, SI32 CurrIndex, UI32 NewIndex){return 0;}
LBOOL  PDF_CALL pdfSetFieldColor(const PPDF* IPDF, UI32 AField, TFieldColor ColorType, TPDFColorSpace CS, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetFieldBorderStyle(const PPDF* IPDF, UI32 AField, TBorderStyle Style){return 0;}
LBOOL  PDF_CALL pdfSetFieldExpValue(const PPDF* IPDF, UI32 AField, UI32 ValIndex, const char* Value, const char* ExpValue, LBOOL Selected){return 0;}
LBOOL  PDF_CALL pdfSetFieldExpValueEx(const PPDF* IPDF, UI32 AField, UI32 ValIndex, LBOOL Selected, LBOOL DefSelected){return 0;}
LBOOL  PDF_CALL pdfSetFieldFlags(const PPDF* IPDF, UI32 AField, TFieldFlags Flags, LBOOL Reset){return 0;}
SI32   PDF_CALL pdfSetFieldFontA(const PPDF* IPDF, UI32 Field, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfSetFieldFontW(const PPDF* IPDF, UI32 Field, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
LBOOL  PDF_CALL pdfSetFieldFontEx(const PPDF* IPDF, UI32 Field, UI32 Handle, double FontSize){return 0;}
LBOOL  PDF_CALL pdfSetFieldFontSize(const PPDF* IPDF, UI32 AField, double FontSize){return 0;}
LBOOL  PDF_CALL pdfSetFieldHighlightMode(const PPDF* IPDF, UI32 AField, THighlightMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetFieldIndex(const PPDF* IPDF, UI32 AField, UI32 Index){return 0;}
LBOOL  PDF_CALL pdfSetFieldMapNameA(const PPDF* IPDF, UI32 AField, const char* Name){return 0;}
LBOOL  PDF_CALL pdfSetFieldMapNameW(const PPDF* IPDF, UI32 AField, const UI16* Name){return 0;}
LBOOL  PDF_CALL pdfSetFieldName(const PPDF* IPDF, UI32 AField, const char* NewName){return 0;}
LBOOL  PDF_CALL pdfSetFieldNameA(const PPDF* IPDF, UI32 AField, const char* NewName){return 0;}
LBOOL  PDF_CALL pdfSetFieldNameW(const PPDF* IPDF, UI32 AField, const UI16* NewName){return 0;}
LBOOL  PDF_CALL pdfSetFieldOrientation(const PPDF* IPDF, UI32 AField, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetFieldTextAlign(const PPDF* IPDF, UI32 AField, TTextAlign Align){return 0;}
LBOOL  PDF_CALL pdfSetFieldTextColor(const PPDF* IPDF, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetFieldToolTipA(const PPDF* IPDF, UI32 AField, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetFieldToolTipW(const PPDF* IPDF, UI32 AField, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetFillColor(const PPDF* IPDF, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetFillColorEx(const PPDF* IPDF, const BYTE* Color, UI32 NumComponents){return 0;}
LBOOL  PDF_CALL pdfSetFillColorF(const PPDF* IPDF, const float* Color, UI32 NumComponents){return 0;}
LBOOL  PDF_CALL pdfSetFillColorSpace(const PPDF* IPDF, TPDFColorSpace CS){return 0;}
LBOOL  PDF_CALL pdfSetFloatPrecision(const PPDF* IPDF, UI32 NumTextDecDigits, UI32 NumVectDecDigits){return 0;}
SI32   PDF_CALL pdfSetFontA(const PPDF* IPDF, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfSetFontW(const PPDF* IPDF, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfSetFontExA(const PPDF* IPDF, const char* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
SI32   PDF_CALL pdfSetFontExW(const PPDF* IPDF, const UI16* Name, TFStyle Style, double Size, LBOOL Embed, TCodepage CP){return 0;}
LBOOL  PDF_CALL pdfSetFontOrigin(const PPDF* IPDF, TOrigin Origin){return 0;}
void   PDF_CALL pdfSetFontSearchOrder(const PPDF* IPDF, TFontBaseType Order[4]){}
LBOOL  PDF_CALL pdfSetFontSelMode(const PPDF* IPDF, TFontSelMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetFontWeight(const PPDF* IPDF, SI32 Weight){return 0;}
void   PDF_CALL pdfSetGStateFlags(const PPDF* IPDF, TGStateFlags Flags, LBOOL Reset){}
LBOOL  PDF_CALL pdfSetIconColor(const PPDF* IPDF, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetImportFlags(const PPDF* IPDF, TImportFlags Flags){return 0;}
LBOOL  PDF_CALL pdfSetImportFlags2(const PPDF* IPDF, TImportFlags2 Flags){return 0;}
LBOOL  PDF_CALL pdfSetItalicAngle(const PPDF* IPDF, double Angle){return 0;}
LBOOL  PDF_CALL pdfSetJPEGQuality(const PPDF* IPDF, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetLanguage(const PPDF* IPDF, const char* ISOTag){return 0;}
LBOOL  PDF_CALL pdfSetLeading(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetLicenseKey(const PPDF* IPDF, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetLineAnnotParms(const PPDF* IPDF, UI32 Handle, SI32 FontHandle, double FontSize, struct TLineAnnotParms* Parms){return 0;}
LBOOL  PDF_CALL pdfSetLineCapStyle(const PPDF* IPDF, TLineCapStyle Style){return 0;}
LBOOL  PDF_CALL pdfSetLineDashPattern(const PPDF* IPDF, const char* Dash, SI32 Phase){return 0;}
LBOOL  PDF_CALL pdfSetLineDashPattern2(const PPDF* IPDF, const float* Dash, UI32 NumValues, float Phase){return 0;}
LBOOL  PDF_CALL pdfSetLineDashPatternEx(const PPDF* IPDF, const double* Dash, UI32 NumValues, SI32 Phase){return 0;}
LBOOL  PDF_CALL pdfSetLineJoinStyle(const PPDF* IPDF, TLineJoinStyle Style){return 0;}
LBOOL  PDF_CALL pdfSetLineWidth(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetLinkHighlightMode(const PPDF* IPDF, THighlightMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetListFont(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetMatrix(const PPDF* IPDF, struct TCTM* Matrix){return 0;}
void   PDF_CALL pdfSetMaxErrLogMsgCount(const PPDF* IPDF, UI32 Value){}
LBOOL  PDF_CALL pdfSetMaxFieldLen(const PPDF* IPDF, UI32 TxtField, SI32 MaxLen){return 0;}
LBOOL  PDF_CALL pdfSetMetaConvFlags(const PPDF* IPDF, TMetaFlags Flags){return 0;}
LBOOL  PDF_CALL pdfSetMetadata(const PPDF* IPDF, TMetadataObj ObjType, SI32 Handle, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfSetMiterLimit(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetNeedAppearance(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetNumberFormat(const PPDF* IPDF, UI32 TxtField, TDecSeparator Sep, UI32 DecPlaces, TNegativeStyle NegStyle, const char* CurrStr, LBOOL Prepend){return 0;}
LBOOL  PDF_CALL pdfSetOCGContUsage(const PPDF* IPDF, UI32 Handle, struct TPDFOCGContUsage* Value){return 0;}
LBOOL  PDF_CALL pdfSetOCGState(const PPDF* IPDF, UI32 Handle, LBOOL On, LBOOL SaveState){return 0;}
LBOOL  PDF_CALL pdfSetOnErrorProc(const PPDF* IPDF, const void* Data, const void* ErrProc){return 0;}
LBOOL  PDF_CALL pdfSetOnPageBreakProc(const PPDF* IPDF, const void* Data, const void* OnBreakProc){return 0;}
LBOOL  PDF_CALL pdfSetOpacity(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetOrientation(const PPDF* IPDF, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetOrientationEx(const PPDF* IPDF, SI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetPageBBox(IPGE* PagePtr, TPageBoundary Boundary, struct TFltRect* BBox){return 0;}
LBOOL  PDF_CALL pdfSetPageCoords(const PPDF* IPDF, TPageCoord PageCoords){return 0;}
LBOOL  PDF_CALL pdfSetPageFormat(const PPDF* IPDF, TPageFormat Value){return 0;}
LBOOL  PDF_CALL pdfSetPageHeight(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetPageLayout(const PPDF* IPDF, TPageLayout Layout){return 0;}
LBOOL  PDF_CALL pdfSetPageMode(const PPDF* IPDF, TPageMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetPageWidth(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetPDFVersion(const PPDF* IPDF, TPDFVersion Version){return 0;}
LBOOL  PDF_CALL pdfSetPrintSettings(const PPDF* IPDF, TDuplexMode Mode, SI32 PickTrayByPDFSize, UI32 NumCopies, TPrintScaling PrintScaling, UI32* PrintRanges, UI32 NumRanges){return 0;}
LBOOL  PDF_CALL pdfSetProgressProc(const PPDF* IPDF, const void* Data, const void* InitProgress, const void* Progress){return 0;}
LBOOL  PDF_CALL pdfSetResolution(const PPDF* IPDF, UI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetSaveNewImageFormat(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetSeparationInfo(const PPDF* IPDF, UI32 Handle){return 0;}
LBOOL  PDF_CALL pdfSetStrokeColor(const PPDF* IPDF, UI32 Color){return 0;}
LBOOL  PDF_CALL pdfSetStrokeColorEx(const PPDF* IPDF, const BYTE* Color, UI32 NumComponents){return 0;}
LBOOL  PDF_CALL pdfSetStrokeColorF(const PPDF* IPDF, const float* Color, UI32 NumComponents){return 0;}
LBOOL  PDF_CALL pdfSetStrokeColorSpace(const PPDF* IPDF, TPDFColorSpace CS){return 0;}
LBOOL  PDF_CALL pdfSetTabLen(const PPDF* IPDF, SI32 TabLen){return 0;}
LBOOL  PDF_CALL pdfSetTemplBBox(const PPDF* IPDF, UI32 Handle, TPageBoundary Boundary, struct TPDFRect* BBox){return 0;}
LBOOL  PDF_CALL pdfSetTextDrawMode(const PPDF* IPDF, TDrawMode Mode){return 0;}
LBOOL  PDF_CALL pdfSetTextFieldValueA(const PPDF* IPDF, UI32 Field, const char* Value, const char* DefValue, TTextAlign Align){return 0;}
LBOOL  PDF_CALL pdfSetTextFieldValueW(const PPDF* IPDF, UI32 Field, const UI16* Value, const UI16* DefValue, TTextAlign Align){return 0;}
LBOOL  PDF_CALL pdfSetTextFieldValueExA(const PPDF* IPDF, UI32 Field, const char* Value){return 0;}
LBOOL  PDF_CALL pdfSetTextFieldValueExW(const PPDF* IPDF, UI32 Field, const UI16* Value){return 0;}
LBOOL  PDF_CALL pdfSetTextRect(const PPDF* IPDF, double PosX, double PosY, double Width, double Height){return 0;}
LBOOL  PDF_CALL pdfSetTextRise(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetTextScaling(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetTransparentColor(const PPDF* IPDF, UI32 AColor){return 0;}
void   PDF_CALL pdfSetTrapped(const PPDF* IPDF, LBOOL Value){}
LBOOL  PDF_CALL pdfSetUseExactPwd(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseGlobalImpFiles(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseImageInterpolation(const PPDF* IPDF, UI32 Handle, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseImageInterpolationEx(const PIMG* Image, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUserUnit(const PPDF* IPDF, float Value){return 0;}
LBOOL  PDF_CALL pdfSetUseStdFonts(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseSwapFile(const PPDF* IPDF, LBOOL SwapContents, UI32 SwapLimit){return 0;}
LBOOL  PDF_CALL pdfSetUseSwapFileEx(const PPDF* IPDF, LBOOL SwapContents, UI32 SwapLimit, const char* SwapDir){return 0;}
LBOOL  PDF_CALL pdfSetUseSystemFonts(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseTransparency(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetUseVisibleCoords(const PPDF* IPDF, LBOOL Value){return 0;}
LBOOL  PDF_CALL pdfSetViewerPreferences(const PPDF* IPDF, TViewerPreference Value, TViewPrefAddVal AddVal){return 0;}
LBOOL  PDF_CALL pdfSetWMFDefExtent(const PPDF* IPDF, UI32 Width, UI32 Height){return 0;}
LBOOL  PDF_CALL pdfSetWMFPixelPerInch(const PPDF* IPDF, UI32 Value){return 0;}
LBOOL  PDF_CALL pdfSetWordSpacing(const PPDF* IPDF, double Value){return 0;}
LBOOL  PDF_CALL pdfSetXFAStream(const PPDF* IPDF, UI32 Index, const void* Buffer, UI32 BufSize){return 0;}
LBOOL  PDF_CALL pdfSkewCoords(const PPDF* IPDF, double alpha, double beta, double OriginX, double OriginY){return 0;}
LBOOL  PDF_CALL pdfSortFieldsByIndex(const PPDF* IPDF){return 0;}
LBOOL  PDF_CALL pdfSortFieldsByName(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfStrLenA(const char* AStr){return 0;}
SI32   PDF_CALL pdfStrLenW(const UI16* AStr){return 0;}
LBOOL  PDF_CALL pdfStrokePath(const PPDF* IPDF){return 0;}
SI32   PDF_CALL pdfStampAnnotA(const PPDF* IPDF, TRubberStamp SubType, double PosX, double PosY, double Width, double Height, const char* Author, const char* Subject, const char* Comment){return 0;}
SI32   PDF_CALL pdfStampAnnotW(const PPDF* IPDF, TRubberStamp SubType, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Subject, const UI16* Comment){return 0;}
SI32   PDF_CALL pdfTestGlyphsA(const PPDF* IPDF, SI32 FontHandle, const char* Text){return 0;}
SI32   PDF_CALL pdfTestGlyphsW(const PPDF* IPDF, SI32 FontHandle, const UI16* Text){return 0;}
SI32   PDF_CALL pdfTestGlyphsExA(const PPDF* IPDF, SI32 FontHandle, const char* Text, UI32 Len){return 0;}
SI32   PDF_CALL pdfTestGlyphsExW(const PPDF* IPDF, SI32 FontHandle, const UI16* Text, UI32 Len){return 0;}
SI32   PDF_CALL pdfTextAnnotA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* Author, const char* Text, TAnnotIcon Icon, LBOOL Open){return 0;}
SI32   PDF_CALL pdfTextAnnotW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Text, TAnnotIcon Icon, LBOOL Open){return 0;}
LBOOL  PDF_CALL pdfTranslateCoords(const PPDF* IPDF, double OriginX, double OriginY){return 0;}
LBOOL  PDF_CALL pdfTriangle(const PPDF* IPDF, double x1, double y1, double x2, double y2, double x3, double y3, TPathFillMode FillMode){return 0;}
LBOOL  PDF_CALL pdfUnLockLayer(const PPDF* IPDF, UI32 Layer){return 0;}
UI32*  PDF_CALL pdfUTF16ToUTF32(const PPDF* IPDF, const UI16* Source){return 0;}
UI32*  PDF_CALL pdfUTF16ToUTF32Ex(const PPDF* IPDF, const UI16* Source, UI32 ADDR Len){return 0;}
UI16*  PDF_CALL pdfUTF32ToUTF16(const PPDF* IPDF, const UI32* Source){return 0;}
UI16*  PDF_CALL pdfUTF32ToUTF16Ex(const PPDF* IPDF, const UI32* Source, UI32 ADDR Len){return 0;}
SI32   PDF_CALL pdfWatermarkAnnot(const PPDF* IPDF, double PosX, double PosY, double Width, double Height){return 0;}
SI32   PDF_CALL pdfWebLinkA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const char* URL){return 0;}
SI32   PDF_CALL pdfWebLinkW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, const UI16* URL){return 0;}
LBOOL  PDF_CALL pdfWriteAngleTextA(const PPDF* IPDF, const char* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin){return 0;}
LBOOL  PDF_CALL pdfWriteAngleTextW(const PPDF* IPDF, const UI16* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin){return 0;}
LBOOL  PDF_CALL pdfWriteFTextA(const PPDF* IPDF, TTextAlign Align, const char* AText){return 0;}
LBOOL  PDF_CALL pdfWriteFTextW(const PPDF* IPDF, TTextAlign Align, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfWriteFTextExA(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TTextAlign Align, const char* AText){return 0;}
LBOOL  PDF_CALL pdfWriteFTextExW(const PPDF* IPDF, double PosX, double PosY, double Width, double Height, TTextAlign Align, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfWriteTextA(const PPDF* IPDF, double PosX, double PosY, const char* AText){return 0;}
LBOOL  PDF_CALL pdfWriteTextW(const PPDF* IPDF, double PosX, double PosY, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfWriteTextExA(const PPDF* IPDF, double PosX, double PosY, const char* AText, UI32 Len){return 0;}
LBOOL  PDF_CALL pdfWriteTextExW(const PPDF* IPDF, double PosX, double PosY, const UI16* AText, UI32 Len){return 0;}
LBOOL  PDF_CALL pdfWriteTextMatrixA(const PPDF* IPDF, struct TCTM* M, const char* AText){return 0;}
LBOOL  PDF_CALL pdfWriteTextMatrixW(const PPDF* IPDF, struct TCTM* M, const UI16* AText){return 0;}
LBOOL  PDF_CALL pdfWriteTextMatrixExA(const PPDF* IPDF, struct TCTM* M, const char* AText, UI32 Len){return 0;}
LBOOL  PDF_CALL pdfWriteTextMatrixExW(const PPDF* IPDF, struct TCTM* M, const UI16* AText, UI32 Len){return 0;}

#endif
