#ifndef pdf_trans_affineH
#define pdf_trans_affineH

#include "../dynapdf.h"

#include <math.h>

#define CheckFloat(f)((f) < 0.0001 && (f) > -0.0001 ? (f)=0.0:(f))

class CTransAffine
{
  public:
   CTransAffine(void) :
      m_a(1.0),
      m_b(0.0),
      m_c(0.0),
      m_d(1.0),
      m_x(0.0),
      m_y(0.0)
   {}
   CTransAffine(double a, double b, double c, double d, double x, double y) :
      m_a(a),
      m_b(b),
      m_c(c),
      m_d(d),
      m_x(x),
      m_y(y)
   {}
   CTransAffine(DynaPDF::TCTM &M) :
      m_a(M.a),
      m_b(M.b),
      m_c(M.c),
      m_d(M.d),
      m_x(M.x),
      m_y(M.y)
   {}
   double GetRotationAngle(void)
   {
      double x1 = 0.0;
      double y1 = 0.0;
      double x2 = 1.0;
      double y2 = 0.0;
      Transform(x1, y1);
      Transform(x2, y2);
      x1 = atan2(y2-y1, x2-x1);
      CheckFloat(x1);
      return x1;
   }
   double GetScaleFactor(void)
   {
      #define sin45 0.70710678118654752440084436210485
      double x = sin45 * m_a + sin45 * m_c;
      double y = sin45 * m_b + sin45 * m_d;
      #undef sin45
      return sqrt(x*x + y*y);
   }
   void Invert(void)
   {
      double d  = 1.0 / (m_a * m_d - m_b * m_c);
      double ma =  m_d * d;
            m_d =  m_a * d;
            m_b = -m_b * d;
            m_c = -m_c * d;
      double mx = -m_x * ma  - m_y * m_c;
            m_y = -m_x * m_b - m_y * m_d;
            m_a = ma;
            m_x = mx;
   }
   bool IsIdentity(void)
   {
      return (m_a == 1.0 && m_b == 0.0 && m_c == 0.0 && m_d == 1.0 && m_x == 0.0 && m_y == 0.0);
   }
   void LeftMultiply(CTransAffine &M)
   {
      double a = m_a * M.m_a + m_b * M.m_c;
      double c = m_c * M.m_a + m_d * M.m_c;
      double x = m_x * M.m_a + m_y * M.m_c + M.m_x;
      m_b = m_a * M.m_b + m_b * M.m_d;
      m_d = m_c * M.m_b + m_d * M.m_d;
      m_y = m_x * M.m_b + m_y * M.m_d + M.m_y;
      m_a = a;
      m_c = c;
      m_x = x;
   }
   void LeftMultiply(double a, double b, double c, double d, double x, double y)
   {
      double ta = m_a * a + m_b * c;
      double tc = m_c * a + m_d * c;
      double tx = m_x * a + m_y * c + x;
      m_b = m_a * b + m_b * d;
      m_d = m_c * b + m_d * d;
      m_y = m_x * b + m_y * d + y;
      m_a = ta;
      m_c = tc;
      m_x = tx;
   }
   void Reset(void)
   {
      m_a = 1.0;
      m_b = 0.0;
      m_c = 0.0;
      m_d = 1.0;
      m_x = 0.0;
      m_y = 0.0;
   }
   void RightMultiply(CTransAffine &M)
   {
      double a = M.m_a * m_a + M.m_b * m_c;
      double b = M.m_a * m_b + M.m_b * m_d;
      double x = M.m_x * m_a + M.m_y * m_c + m_x;
      m_y = M.m_x * m_b + M.m_y * m_d + m_y;
      m_d = M.m_c * m_b + M.m_d * m_d;
      m_c = M.m_c * m_a + M.m_d * m_c;
      m_a = a;
      m_b = b;
      m_x = x;
   }
   void RightMultiply(double a, double b, double c, double d, double x, double y)
   {
      double ta = a * m_a + b * m_c;
      double tb = a * m_b + b * m_d;
      double tx = x * m_a + y * m_c + m_x;
      m_y = x * m_b + y * m_d + m_y;
      m_d = c * m_b + d * m_d;
      m_c = c * m_a + d * m_c;
      m_a = ta;
      m_b = tb;
      m_x = tx;
   }
   void SetMatrix(double a, double b, double c, double d, double x, double y)
   {
      m_a = a;
      m_b = b;
      m_c = c;
      m_d = d;
      m_x = x;
      m_y = y;
   }
   void Transform(double &x, double &y)
   {
      double tx = x;
      x = tx * m_a + y * m_c + m_x;
      y = tx * m_b + y * m_d + m_y;
   }
   void TransformInv(double &x, double &y)
   {
      double d = 1.0 / (m_a * m_d - m_b * m_c);
      double a = (x - m_x) * d;
      double b = (y - m_y) * d;
      x = a * m_d - b * m_c;
      y = b * m_a - a * m_b;
   }
  private:
   double m_a;
   double m_b;
   double m_c;
   double m_d;
   double m_x;
   double m_y;
};

#undef CheckFloat

#endif
