#ifndef pdf_text_bufferH
#define pdf_text_bufferH

#include <memory.h>
#include <stdlib.h>

#define PDF_STATIC // Enable static binding when compiling the project with the workspace dynapdf_static.
#include "../../../include/C_CPP/dynapdf.h"

class CTextBuffer
{
  public:
   CTextBuffer(void);
   CTextBuffer(UI32 AllocBy);
   ~CTextBuffer(void);
   void  AllocBy(UI32 Value){m_AllocBy = Value;}
   void  Add(const UI16* Text, UI32 Len);
   UI16* GetText(void)        const {return m_Text;}
   UI16* GetText(UI32 Offset) const {return (m_Text + Offset);}
   UI32  Length(void)         const {return m_Length;}
   void  Reset(void){m_Length = 0;}
  private:
   UI32  m_AllocBy;
   UI32  m_Length;
   UI32  m_MaxLength;
   UI16* m_Text;
};

#endif
