#include "pdf_text_buffer.h"

#if defined(_MSC_VER)
   #pragma warning(disable : 4514)
#endif

CTextBuffer::CTextBuffer(void) :
   m_AllocBy(128),
   m_Length(0),
   m_MaxLength(0),
   m_Text(NULL)
{
}

CTextBuffer::CTextBuffer(UI32 AllocBy) :
   m_AllocBy(AllocBy),
   m_Length(0),
   m_MaxLength(0),
   m_Text(NULL)
{
}

CTextBuffer::~CTextBuffer(void)
{
   if (m_Text) free(m_Text);
}

void CTextBuffer::Add(const UI16* Text, UI32 Len)
{
   if (m_Length + Len > m_MaxLength)
   {
      while (m_MaxLength < m_Length + Len)
         m_MaxLength += m_AllocBy;
      UI16* tmp = (UI16*)realloc(m_Text, m_MaxLength * sizeof(UI16));
      if (!tmp) throw "Out of memory!";
      m_Text = tmp;
   }
   memcpy(m_Text + m_Length, Text, Len * sizeof(UI16));
   m_Length += Len;
}
