#include <windows.h>
#include <shellapi.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"
#include "pdf_text_extract.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
// If the function name should not appear at the beginning of the error message then set
// the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0;
}

int main(int argc, char* argv[])
{
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   UI32 timeStart = GetTickCount();

   char filePath[MAX_PATH+1];
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // We create no PDF file in this example!

   // External cmaps should always be loaded when extracting text from PDF files.
   // See the description of GetPageText() for further information.
   _fullpath(filePath, "../../../Resource/CMap/", MAX_PATH);
   pdfSetCMapDir(pdf, filePath, (TLoadCMapFlags)(lcmRecursive | lcmDelayed));

   // We avoid the conversion of pages to templates
   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage);
   if (pdfOpenImportFile(pdf, "../../../dynapdf_help.pdf", ptOpen, NULL))
   {
      pdfDeletePDF(pdf);
      _getch();
      return 3;
   }
   pdfImportPDFFile(pdf, 1, 1.0, 1.0);
   pdfCloseImportFile(pdf);

   // We flatten markup annotations and form fields so that we can extract the text from these objects too.
   pdfFlattenAnnots(pdf, affMarkupAnnots);
   pdfFlattenForm(pdf);

   // We write the output file into the current directory.
   GetCurrentDirectory(MAX_PATH, filePath);
   strcat(filePath, "\\out.txt");

   CTextExtraction parser(pdf);
   try
   {
      SI32 i, pageCount;
      // Open the output file
      parser.Open(filePath);
      pageCount = pdfGetPageCount(pdf);
      for (i = 1; i <= pageCount; i++)
      {
         // DynaPDF error messages are already handled in the error callback function!
         if (!pdfEditPage(pdf, i)) throw -1;
         parser.WritePageIdentifier(L"%%----------------------- Page %d -----------------------------\r\n", i);
         parser.ParsePage();
         pdfEndPage(pdf);
      }
      parser.Close();
   }catch(char* Message)
   {
      printf("%s\n", Message);
      pdfDeletePDF(pdf);
      _getch();
      return -1;
   }catch(...)
   {
      pdfDeletePDF(pdf);
      printf("Unknown Error!\n");
      _getch();
      return -1;
   }
   pdfDeletePDF(pdf);

   timeStart = GetTickCount() - timeStart;
   printf("Processing time: %d ms\nText successfully extracted to:\n%s\n", timeStart, filePath);

   ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   _getch();
   return 0;
}
