#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <time.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 sigField, sh;
   char filePath[512];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return -2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfAppend(pdf);
      pdfSetFont(pdf, "Arial", fsNone, 14.0, true, cp1252);
      pdfWriteFText(pdf, taLeft, "This file is digitally signed with a self sign certificate."
         "The appearance of the signature field was created with normal DynaPDF functions. However, it "
         "would also be possible to import a PDF page, an EMF file, or an image into the "
         "appearance template.\n\n"
         "When creating an individual signature appearance make sure to place the validation icon "
         "properly with PlaceSigFieldValidateIcon(). The appearance of the validation icon "
         "depends on the Acrobat version with which the file is opened. However, the unscaled size "
         "of that icon is always 100.0 x 100.0 Units. It can be scaled to every size you want "
         "but it is usually best to preserve the aspect ratio and the icon must be placed fully "
         "inside the appearance template.");

      /* ---------------------- Signature field appearance ---------------------- */

      sigField = pdfCreateSigField(pdf, "Signature", -1, 200.0, 500.0, 200.0, 80.0);
      pdfSetFieldColor(pdf, sigField, fcBorderColor, csDeviceRGB, NO_COLOR);
      // Place the validation icon on the left side of the signature field.
      pdfPlaceSigFieldValidateIcon(pdf, sigField, 0.0, 15.0, 50.0, 50.0);
      /*
         This function creates a template into which you can draw whatever you want. The template
         is already opened when calling the function; it must be closed when finish with EndTemplate().
         An appearance template of a signature field is reserved for this field. It must not be placed
         on another page!

         In addition, it makes no sense to create an appearance template when the file is not digitally
         signed later. Empty signature fields cannot contain a user defined appearance.
      */
      pdfCreateSigFieldAP(pdf, sigField);

      pdfSaveGraphicState(pdf);
         pdfRectangle(pdf, 0.0, 0.0, 200.0, 80.0, fmNoFill);
         pdfClipPath(pdf, cmWinding, fmNoFill);
         sh = pdfCreateAxialShading(pdf, 0.0, 0.0, 200.0, 0.0, 0.5, PDF_RGB(120, 120, 220), PDF_WHITE, true, true);
         pdfApplyShading(pdf, sh);
      pdfRestoreGraphicState(pdf);

      pdfSaveGraphicState(pdf);
         pdfEllipse(pdf, 50.5, 1.0, 148.5, 78.0, fmNoFill);
         pdfClipPath(pdf, cmWinding, fmNoFill);
         sh = pdfCreateAxialShading(pdf, 0.0, 0.0, 0.0, 78.0, 2.0, PDF_WHITE, PDF_RGB(120, 120, 220), true, true);
         pdfApplyShading(pdf, sh);
      pdfRestoreGraphicState(pdf);

      pdfSetFont(pdf, "Arial", fsBold | fsUnderlined, 11.0, true, cp1252);
      pdfSetFillColor(pdf, PDF_RGB(120, 120, 220));
      pdfWriteFTextEx(pdf, 50.0, 60.0, 150.0, -1.0, taCenter, "Digitally signed by:");
      pdfSetFont(pdf, "Arial", fsBold|fsItalic, 18.0, true, cp1252);
      pdfSetFillColor(pdf, PDF_RGB(100, 100, 200));
      pdfWriteFTextEx(pdf, 50.0, 45.0, 150.0, -1.0, taCenter, "DynaPDF");

      pdfEndTemplate(pdf); // Close the appearance template.

      /* ------------------------------------------------------------------------ */

   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (!pdfCloseAndSignFile(pdf, "../../test_files/test_cert.pfx", "123456", "Test", NULL))
      {
         // Note: If the certificate cannot be found or when using a wrong password the PDF file is still
         // in memory. This is required to enable entering another password or certificate file.
         pdfDeletePDF(pdf); // This function frees all used resources. When sharing a PDF instance you must call pdfFreePDF() instead.
         _getch();
         return -2;
      }
      printf("PDF file %s successfully created!\n", filePath);
      ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   }
   pdfDeletePDF(pdf);
   return 0;
}
