#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 retval;
   char out[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return -1; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // We create no PDF file in this example

   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage); // The flag ifImportAsPage makes sure that pages will not be converted to templates.
   pdfSetImportFlags2(pdf, if2UseProxy);                 // The flag if2UseProxy reduces the memory usage.

   if ((retval = pdfOpenImportFile(pdf, "../../../../dynapdf_help.pdf", ptOpen, NULL)) < 0)
   {
      if (IsWrongPwd(retval))
      {
         printf("File is encrypted!");
      }
      pdfDeletePDF(pdf);
      return -2;
   }
   // We must import an external page before we can render it
   pdfAppend(pdf);
      pdfImportPageEx(pdf, 1, 1.0, 1.0);
   pdfEndPage(pdf);

   pdfCloseImportFile(pdf);

   GetCurrentDirectory(MAX_PATH, out);
   strcat(out, "\\out.tif");

   // Render the page with 600 DPI if possible but make sure that the width or height does not exceed 6000 pixels.
   // So, if the image becomes too large in the whished resolution, as in this example, then the page will be scaled to the maximum width or height.
   if (pdfRenderPageToImage(pdf, 1, out, 600, -6000, -6000, rfDefault, pxfRGB, cfLZW, ifmTIFF))
   {
      printf("TIFF image \"%s\" successfully created!\n", out);
      ShellExecute(0, "open", out, NULL, NULL, SW_SHOWMAXIMIZED);
   }

   pdfDeletePDF(pdf);
   return 0;
}