#ifndef render_pageH
#define render_pageH

#include "../render_base/base_app.h"

class CApp : public CBaseApp
{
  public:
   CApp(HINSTANCE Instance);
   ~CApp(void);
   SI32 GetCurrPage(void){return m_CurrPage;}
   bool Init(void);
   void OnKey(UI32 KeyCode, UI32 Ctrl);
   void OnMouseWheel(SI32 Delta, SI32 X, SI32 Y);
   void OnPaint(void);
   void OnResize(UI32 Width, UI32 Height);
   void OnShowOpenFileDlg(void);
   void RenderNextPage(SI32 PageNum);
   void RenderPage(void)
   {
      pdfRenderPage(m_PDF, m_CurrPageObj, m_RAS, &m_RasImage);
      m_Update = false;
   }
   void UpdateArea(TIntRect* Area)
   {
      ::SetDIBitsToDevice(m_DC,
                          Area->x1+APP_CLIENT_BORDER2,
                          Area->y1+APP_CLIENT_BORDER2,
                          Area->x2-Area->x1,
                          Area->y2-Area->y1,
                          Area->x1,
                          m_ImgH-Area->y2,
                          0,
                          m_ImgH,
                          m_Buffer,
                          m_BMPInfo,
                          DIB_RGB_COLORS);
   }
  protected:
   bool            m_AdjWindow;
   SI32            m_CurrPage;
   IPGE*           m_CurrPageObj;
   BYTE*           m_ImpPages;
   SI32            m_PageCount;
   PPDF*           m_PDF;
   IRAS*           m_RAS;
   TPDFRasterImage m_RasImage;
   HANDLE          m_RenderThread;
   bool            m_Update;

   void AddPage(SI32 PageNum)        {m_ImpPages[PageNum>>3] |= 0x80 >> (PageNum & 7);}
   bool InitImpPageArray(void);
   bool IsPageAvailable(SI32 PageNum){return (m_ImpPages[PageNum>>3] & (0x80 >> (PageNum & 7))) != 0;}
   void RenderCurrPage(void);
   void StartRenderThread(void);
   void StopRenderThread(void);
};

#endif
