#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <time.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?
   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   // Import anything and avoid the conversion of pages to templates.
   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage);
   if (pdfOpenImportFile(pdf, "../../test_files/taxform.pdf", ptOpen, NULL) < 0)
   {
      pdfDeletePDF(pdf);
      _getch();
      return 0;
   }
   pdfImportPDFFile(pdf, 1, 1.0, 1.0);

   pdfEditPage(pdf, 1);
   // We use the 14 standard fonts only because they are always available. However, in a real
   // project you should use fonts which can be embedded.
   pdfSetFont(pdf, "Courier", fsBold, 14.0, false, cp1252);

   pdfWriteText(pdf, 72.5, 748.5, "X");
   pdfWriteText(pdf, 74.0, 701.0, "Musterstadt");
   pdfWriteText(pdf, 74.0, 677.0, "252/1062/3323");

   pdfBeginContinueText(pdf, 74.0, 628.0);
   pdfSetLeading(pdf, 24.0);
   pdfSetCharacterSpacing(pdf, 5.8);
   pdfAddContinueText(pdf, "Mustermann");
   pdfAddContinueText(pdf, "Hermann");
   pdfAddContinueText(pdf, "22021963keineKaufmann");
   pdfAddContinueText(pdf, "Musterstrae 145");
   pdfAddContinueText(pdf, "12345Musterstadt");
   pdfSetCharacterSpacing(pdf, 0.0);
   pdfSetFont(pdf, "Courier", fsBold, 10.0, false, cp1252);
   pdfSetLeading(pdf, 47.5);
   pdfAddContinueText(pdf, "04.05.1994");
   pdfSetFont(pdf, "Courier", fsBold, 14.0, false, cp1252);
   pdfSetCharacterSpacing(pdf, 5.8);
   pdfAddContinueText(pdf, "Sabine");
   pdfAddContinueText(pdf, "18121966 ev  Hausfrau");
   pdfEndContinueText(pdf);

   pdfWriteText(pdf, 72.5, 365.0, "X");
   pdfWriteText(pdf, 396.0, 365.0, "X");

   pdfBeginContinueText(pdf, 74.0, 316.0);
   pdfSetLeading(pdf, 24.0);
   pdfAddContinueText(pdf, "2346256780     76834560");
   pdfAddContinueText(pdf, "Sparkasse Musterstadt");
   pdfEndContinueText(pdf);

   pdfWriteText(pdf, 72.5, 269.0, "X");
   pdfSetCharacterSpacing(pdf, 0.0);
   pdfSetFont(pdf, "Courier", fsNone, 10.0, false, cp1252);

   time_t t;
   struct tm* now;
   time(&t);
   now = gmtime(&t);
   char buf[64];
   sprintf(buf, "%02d.%02d.%d", now->tm_mday +1, now->tm_mon + 1, now->tm_year + 1900);

   pdfWriteText(pdf, 53.0, 48.0, buf);
   pdfSetFillColor(pdf, PDF_RGB(0xFF, 0x66, 0x66));
   pdfSetFont(pdf, "Helvetica", fsBold, 22.0, false, cp1252);
   pdfWriteText(pdf, 340, 70, "www.dynaforms.de");
   pdfSetLineWidth(pdf, 0.0);
   pdfSetLinkHighlightMode(pdf, hmPush);
   pdfSetAnnotFlags(pdf, afReadOnly);
   pdfWebLink(pdf, 340, 64, 204, 22, "http://www.dynaforms.de");
   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
