
#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

bool Optimize(const PPDF* PDF, const char* InFile, const char* OutFile)
{
   SI32 retval;
   pdfCreateNewPDF(PDF, NULL);           // The output file will be created later
   pdfSetDocInfo(PDF, diProducer, NULL); // No need to override the original producer

   // The flag ifImportAsPage makes sure that pages will not be converted to templates.
   // We don't import a piece info dictionary here since this dictionary contains private data that
   // is only usable in the application that created the data. InDesign, for example, stores original
   // images and document files in this dictionary, if external resources were placed on a page.
   pdfSetImportFlags(PDF, (ifImportAll | ifImportAsPage) & ~ifPieceInfo);
   // The flag if2UseProxy reduces the memory usage. The duplicate check is optional but recommended.
   // The resource name check can be omitted when we optimize a PDF file.
   pdfSetImportFlags2(PDF, if2UseProxy | if2DuplicateCheck | if2NoResNameCheck);
   if ((retval = pdfOpenImportFile(PDF, InFile, ptOpen, NULL)) < 0)
   {
      if (IsWrongPwd(retval))
      {
         printf("File is encrypted!");
      }
      goto err;
   }
   pdfImportPDFFile(PDF, 1, 1.0, 1.0);
   pdfCloseImportFile(PDF);
   /*
      It is not allowed to call this function twice for the same document in memory!
      In addition, we can either optimize the entire PDF file or nothing.
   */
   if (!pdfOptimize(PDF, (TOptimizeFlags)(ofInMemory | ofNewLinkNames | ofDeleteInvPaths | ofDeletePrivateData), NULL)) return false;

   // No fatal error occurred?
   if (!pdfOpenOutputFile(PDF, OutFile) || !pdfCloseFile(PDF)) goto err;
   return true;
  err:
   pdfFreePDF(PDF);
   return false;
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   // Set the license key here if you have one
   // pdfSetLicenseKey(pdf, "");

   // Non embedded CID fonts depend usually on the availability of external cmaps.
   // So, external cmaps should be loaded if possible.
   _fullpath(filePath, "../../../Resource/CMap/", MAX_PATH);
   pdfSetCMapDir(pdf, filePath, TLoadCMapFlags(DynaPDF::lcmDelayed | DynaPDF::lcmRecursive));

   GetCurrentDirectory(MAX_PATH, filePath);
   strcat(filePath, "/out.pdf");

   /*
      *************************** NOTICE!!! ***************************
      The help file was already optimized with this function and cannot
      become smaller! In fact, it becomes larger due to the demo string
      that will be added!
   */
   if (Optimize(pdf, "../../../dynapdf_help.pdf", filePath))
   {
      printf("PDF file \"%s\" successfully created!\n", filePath);
      ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   }
   pdfDeletePDF(pdf);
   return 0;
}