#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   LGRP* root, *grp;
   SI32 annot, ocmd, oc1, oc2, oc3;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   // Disable color key masking for images
   pdfSetUseTransparency(pdf, false);

   // Create three layers
   oc1 = pdfCreateOCG(pdf, "All", false, true, oiAll);
   oc2 = pdfCreateOCG(pdf, "Text and Annotations", false, true, oiAll);
   oc3 = pdfCreateOCG(pdf, "Images", false, true, oiAll);

   root = pdfAddLayerToDisplTree(pdf, NULL, oc1, "A layer group with a title");
   grp  = pdfAddLayerToDisplTree(pdf, root, -1, NULL);
   pdfAddLayerToDisplTree(pdf, grp, oc2, NULL);
   pdfAddLayerToDisplTree(pdf, grp, oc3, NULL);

   pdfAppend(pdf);
      // The main layer controls the visibility of all three layers in this example.
      pdfBeginLayer(pdf, oc1);
         pdfBeginLayer(pdf, oc2);
            pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
            const char someText[] = "Some text with a link!!!";
            pdfSetFillColor(pdf, PDF_BLUE);
            pdfWriteText(pdf, 50.0, 50.0, someText);
            double tw = pdfGetTextWidth(pdf, someText);
            // To reflect the same nesting as the text layer we must use an OCMD for the annotation
            // because the visibility of the layer oc2 depends on oc1 at this position.
            pdfSetBorderStyle(pdf, bsUnderline);
            pdfSetStrokeColor(pdf, PDF_BLUE);
            annot = pdfWebLink(pdf, 50.0, 51.0, tw, 12.0, "www.dynaforms.com");

            SI32 array[] = {oc1, oc2};
            ocmd = pdfCreateOCMD(pdf, ovAllOn, (UI32*)array, 2);
            pdfAddObjectToLayer(pdf, ocmd, ooAnnotation, annot);
         pdfEndLayer(pdf);

         pdfBeginLayer(pdf, oc3);
            pdfInsertImageEx(pdf, 50.0, 70.0, 300.0, 200.0, "../../../test_files/images/margarita-102572_640.jpg", 1);
         pdfEndLayer(pdf);
      pdfEndLayer(pdf);

      pdfSetFillColor(pdf, PDF_BLACK);
      pdfWriteText(pdf, 50.0, 300.0, "This text is not part of a layer!");
   pdfEndPage(pdf);

   pdfSetPageMode(pdf, pmUseOC);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
