#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <time.h>
#include <conio.h>

#include "pdf_signature.h" // Helper class to sign the PDF file

/*
   Additional note for the target x64 in Visual Studio 2005 though 2008:

   Some installations of Visual Studio 2005 through 2008 come without a working 64 bit
   version of the Windows Crypt API. To avoid compiliation errors the target x64 is disabled
   by default in these versions. You can enable the target x64 in the Configuration-Manager.
*/

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#pragma comment(lib, "crypt32.lib")

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0;
}

int main(int argc, char* argv[])
{
   SI32 sigField, sh;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return -2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is opened later

   pdfAppend(pdf);
      pdfSetFont(pdf, "Arial", fsNone, 12.0, true, cp1252);
      pdfWriteFText(pdf, taJustify, "This file was digitally signed with the Windows CryptAPI "
         "using a PKCS#12 certificate. It is also possible to use an arbitrary certificate of "
         "the user's certificate store. This could be a hardware or software certificate. The "
         "CryptAPI function calls are in both cases the same. Nothing special must be considered.\n\n"
         "The appearance of the signature field was created with normal DynaPDF functions. "
         "However, it would also be possible to import a PDF page, an EMF file, or an image "
         "into the appearance template. "
         "When creating an individual signature appearance make sure to place the "
         "validation icon properly with PlaceSigFieldValidateIcon(). The appearance of "
         "the validation icon depends on the Acrobat version with which the file is "
         "opened. However, the unscaled size of that icon is always 100.0 x 100.0 Units. "
         "It can be scaled to every size you want but it is usually best to preserve the "
         "aspect ratio and the icon must be placed fully inside the appearance template.");

      /* ---------------------- Signature field appearance ---------------------- */

      sigField = pdfCreateSigField(pdf, "Signature", -1, 200.0, 500.0, 200.0, 80.0);
      pdfSetFieldColor(pdf, sigField, fcBorderColor, csDeviceRGB, NO_COLOR);
      // Place the validation icon on the left side of the signature field.
      pdfPlaceSigFieldValidateIcon(pdf, sigField, 0.0, 15.0, 50.0, 50.0);
      /*
         This function creates a template into which you can draw whatever you want. The template
         is already opened when calling the function; it must be closed when finish with EndTemplate().
         An appearance template of a signature field is reserved for this field. It must not be placed
         on another page!

         In addition, it makes no sense to create an appearance template when the file is not digitally
         signed later. Empty signature fields cannot contain a user defined appearance.
      */
      pdfCreateSigFieldAP(pdf, sigField);

         pdfSaveGraphicState(pdf);
            pdfRectangle(pdf, 0.0, 0.0, 200.0, 80.0, fmNoFill);
            pdfClipPath(pdf, cmWinding, fmNoFill);
            sh = pdfCreateAxialShading(pdf, 0.0, 0.0, 200.0, 0.0, 0.5, PDF_RGB(120, 120, 220), PDF_WHITE, true, true);
            pdfApplyShading(pdf, sh);
         pdfRestoreGraphicState(pdf);

         pdfSaveGraphicState(pdf);
            pdfEllipse(pdf, 50.5, 1.0, 148.5, 78.0, fmNoFill);
            pdfClipPath(pdf, cmWinding, fmNoFill);
            sh = pdfCreateAxialShading(pdf, 0.0, 0.0, 0.0, 78.0, 2.0, PDF_WHITE, PDF_RGB(120, 120, 220), true, true);
            pdfApplyShading(pdf, sh);
         pdfRestoreGraphicState(pdf);

         pdfSetFont(pdf, "Arial", fsBold | fsUnderlined, 11.0, true, cp1252);
         pdfSetFillColor(pdf, PDF_RGB(120, 120, 220));
         pdfWriteFTextEx(pdf, 50.0, 60.0, 150.0, -1.0, taCenter, "Digitally signed by:");
         pdfSetFont(pdf, "Arial", fsBold|fsItalic, 18.0, true, cp1252);
         pdfSetFillColor(pdf, PDF_RGB(100, 100, 200));
         pdfWriteFTextEx(pdf, 50.0, 45.0, 150.0, -1.0, taCenter, "DynaPDF");

      pdfEndTemplate(pdf); // Close the appearance template.

   /* ------------------------------------------------------------------------ */

   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");

      // Now we can sign the PDF file
      CWinCrypt crypt;
      // In this example we load a PFX certificate file
      if (!crypt.LoadCertFromFile("../../test_files/test_cert.pfx", L"123456")) goto err;
      if (!crypt.OpenCert(0)) goto err;
      if (!crypt.CloseAndSignPDFFile(pdf, filePath, false)) goto err;
      crypt.CleanUp();
      /*
         // You can also use an arbitrary certificate of a certificate store.
         if (!crypt.OpenStore(L"MY")) goto err;
         if (!crypt.SelectCertificateFromStore()) goto err; // This function displays a dialog to select the certificate
         if (!crypt.CloseAndSignPDFFile(pdf, filePath, false)) goto err;
         crypt.CleanUp();
      */
      printf("PDF file %s successfully created!\n", filePath);
      ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;

err:
   pdfDeletePDF(pdf);
   _getch();
   return -2;
}
