#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"
#include "../../../include/C_CPP/parser_interface.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

bool ReplaceText(const PPDF* PDF, const wchar_t* InFile, const wchar_t* OutFile)
{
   SI32 i, retval;
   TContent out = {0, 0};
   TTextSelection sel, *curr;

   pdfCreateNewPDF(PDF, NULL); // The output file will be created later

   // The flag ifImportAsPage makes sure that pages will not be converted to templates.
   pdfSetImportFlags(PDF, (ifImportAll | ifImportAsPage) & ~ifPieceInfo);
   // The flag if2UseProxy reduces the memory usage.
   pdfSetImportFlags2(PDF, if2UseProxy);
   if ((retval = pdfOpenImportFileW(PDF, (const UI16*)InFile, ptOpen, NULL)) < 0)
   {
      if (IsWrongPwd(retval))
      {
         printf("File is encrypted!");
      }
      goto err;
   }
   pdfImportPDFFile(PDF, 1, 1.0, 1.0);

   wchar_t searchText[]  = L"PDF"; // This string occurs of course very often in the help file
   wchar_t replaceText[] = L"XDF"; // Just an example. Use also a longer or shorter string to see what happens...

   sel.StructSize = sizeof(sel);

   // Create a parser context
   IPSR* ctx = psrCreateParserContext(PDF, ofDefault, NULL);
   SI32  cnt = pdfGetPageCount(PDF);
   for (i = 1; i <= cnt; i++)
   {
      // The flag cpfEnableTextSelection is required. Otherwise no text can be found.
      if (psrParsePage(PDF, ctx, NULL, NULL, i, cpfEnableTextSelection, NULL, &out))
      {
         curr = NULL;
         // Replace all occurences of "PDF" with "XDF" (case insensitive).
         while (psrFindText(PDF, ctx, NULL, stCaseInSensitive, curr, (const UI16*)searchText, (sizeof(searchText)-1)>>1, &sel))
         {
            // Set the replacement string to an empty string one time to see how surrounding text will be handled...
            // With psrSetAltFont() you can also set the preferred alternate font to output the new text if the
            // original font is not available on the system.
            psrReplaceSelText(PDF, ctx, rtfDefault, &sel, (const UI16*)replaceText, (sizeof(replaceText)>>1) -1);
            curr = &sel;
         }
         psrWriteToPage(PDF, ctx, ofDefault, NULL);
      }
   }
   // Delete the parser context
   psrDeleteParserContext(&ctx);

   // No fatal error occurred?
   if (!pdfOpenOutputFileW(PDF, (const UI16*)OutFile) || !pdfCloseFile(PDF)) goto err;
   return true;
  err:
   pdfFreePDF(PDF);
   return false;
}

int main(int argc, char* argv[])
{
   wchar_t filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   // Set the license key here if you have one
   // pdfSetLicenseKey(pdf, "");

   // Non embedded CID fonts depend usually on the availability of external cmaps.
   // So, external cmaps should be loaded if possible.
   _wfullpath(filePath, L"../../../Resource/CMap/", MAX_PATH);
   pdfSetCMapDirW(pdf, (const UI16*)filePath, TLoadCMapFlags(DynaPDF::lcmDelayed | DynaPDF::lcmRecursive));

   GetCurrentDirectoryW(MAX_PATH, filePath);
   wcscat(filePath, L"/out.pdf");

   if (ReplaceText(pdf, L"../../../dynapdf_help.pdf", filePath))
   {
      printf("PDF file \"%S\" successfully created!\n", filePath);
      ShellExecuteW(0, L"open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   }

   pdfDeletePDF(pdf);
   _getch();
   return 0;
}
