#ifndef pdf_text_coordinatesH
#define pdf_text_coordinatesH

#include <stdio.h>
#include <stdlib.h>

#define PDF_STATIC // Enable static binding when compiling the project with the workspace dynapdf_static.
#include "../../../../include/C_CPP/dynapdf.h"

using namespace DynaPDF;

class CTextCoordinates
{
  public:
   CTextCoordinates(void);
   SI32 MarkCoordinates(TCTM* M, const TTextRecordA* Source, const TTextRecordW* Kerning, UI32 Count, double Width, bool Decoded);
   SI32 BeginTemplate(TPDFRect* BBox, TCTM* M);
   void EndTemplate(void)                {RestoreGState();}
   void Init(void);
   void MulMatrix(TCTM* M)               {m_GState.Matrix = MulMatrix(m_GState.Matrix, *M);}
   bool RestoreGState(void);
   SI32 SaveGState(void);
   void SetCharSpacing(double Value)     {m_GState.CharSpacing = (float)Value;}
   void SetFont(double FontSize, TFontType Type, const void* Font);
   void SetPDFInst(void* IPDF)           {m_PDF = IPDF;}
   void SetTextScale(double Value)       {m_GState.TextScale    = (float)Value;}
   void SetTextDrawMode(TDrawMode Mode)  {m_GState.TextDrawMode = Mode;}
   void SetWordSpacing(double Value)     {m_GState.WordSpacing  = (float)Value;}
  protected:
   struct TGState
   {
      const void* ActiveFont;
      TFontType   FontType;
      float       CharSpacing;
      double      FontSize;
      TCTM        Matrix;
      float       SpaceWidth;
      TDrawMode   TextDrawMode;
      float       TextScale;
      float       WordSpacing;
   };
   class CStack
   {
     public:
      CStack(void) :
         m_Capacity(0),
         m_Count(0),
         m_Items(NULL)
      {}
      ~CStack(void)
      {
         if (m_Items) free(m_Items);
      }
      bool Restore(TGState &F);
      SI32 Save(TGState &F);
     private:
      UI32     m_Capacity;
      UI32     m_Count;
      TGState* m_Items;
   };
   friend class CStack;
   UI32         m_Count;
   TGState      m_GState;
   void*        m_PDF;
   CStack       m_Stack;

   double CalcDistance(double x1, double y1, double x2, double y2);
   TCTM   MulMatrix(TCTM &M1, TCTM &M2);
   void   Transform(TCTM &M, double &x, double &y);
};

#endif
