#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <time.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 ef;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   // We create the output file later if no error occurred.
   pdfCreateNewPDF(pdf, NULL);

   // The page of this file is shown when opening the file with an older version of Adobe's Acrobat.
   // Otherwise, the default document of the collection is opened. Click on "Cover sheet" to view the
   // contents of this page.
   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage);
   if (pdfOpenImportFile(pdf, "../../test_files/collection_en.pdf", ptOpen, NULL) < 0)
   {
      pdfDeletePDF(pdf);
      _getch();
      return 0;
   }
   pdfImportPDFFile(pdf, 1, 1.0, 1.0);
   pdfCloseImportFile(pdf);

   pdfCreateCollection(pdf, civTile);

   // We add a user defined field Index to the list so that we can sort it in every order we want.
   ef = pdfCreateCollectionField(pdf, cisCustomNumber, 0, "File index", "Index", false, true);
   pdfSetColSortField(pdf, ef, true);

   pdfCreateCollectionField(pdf, cisFileName, 1, "File name", NULL, true, true);
   // Acrobat 8.0 does not display the creation date; this bug was solved in Acrobat 8.1.
   pdfCreateCollectionField(pdf, cisCreationDate, 4, "Creation date", NULL, true, false);
   pdfCreateCollectionField(pdf, cisSize, 2, "File size", NULL, true, false);
   pdfCreateCollectionField(pdf, cisModDate, 3, "Modification date", NULL, true, false);


   ef = pdfAttachFile(pdf, "../../test_files/taxform.pdf", "A PDF file...", true);
   pdfSetColDefFile(pdf, ef); // This file is opened when viewing the file with Acrobat 8 or later
   pdfCreateColItemNumber(pdf, ef, "Index", 0.0, NULL);

   ef = pdfAttachFile(pdf, "../../test_files/fulltest.emf", "An EMF file...", true);
   pdfCreateColItemNumber(pdf, ef, "Index", 1.0, NULL);

   ef = pdfAttachFile(pdf, "../../test_files/sample.txt", "A text file...", true);
   pdfCreateColItemNumber(pdf, ef, "Index", 2.0, NULL);

   // Let's check whether the collection is valid.
   // We know that the collection is valid in this example, but when editing an imported collection
   // this function can be very helpful.
   pdfCheckCollection(pdf);
   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF Collection \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}

