#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 a;
   char txt[64];
   double x, y, w, h;
   TLineAnnotParms p;

   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);

      w = 300.0;
      h = 100.0;
      x = pdfGetPageWidth(pdf)  / 2;
      y = pdfGetPageHeight(pdf) / 2;

      // We save the graphics state because the coordinate system will be rotated.
      // After RestoreGraphicState() we have the non-rotated coordinate system back.
      pdfSaveGraphicState(pdf);

         pdfSetGStateFlags(pdf, gfRealTopDownCoords, false); // This simplifies the handling a little bit.
         pdfRotateCoords(pdf, -30, x, y);

         x = -w / 2;
         y = -h / 2;

         pdfSetFillColor(pdf, PDF_CREAM);
         pdfRectangle(pdf, x, y, w, h, fmFillStroke);

         _snprintf(txt, 63, "%.1f", w);
         a = pdfLineAnnot(pdf, x, y, x + w, y, 1.0, leClosedArrow, leClosedArrow, PDF_BLACK, PDF_BLACK, csDeviceRGB, "This is a measure line", "Measure Line", txt);

         memset(&p, 0, sizeof(p));
         p.StructSize       = sizeof(p);
         p.Caption          = true;      // The parameter Content of LineAnnot() is used as caption.
         p.LeaderLineLen    = 10.0f;
         p.LeaderLineExtend = 4.0f;      // Try different values to understand what these parameters change.
         p.LeaderLineOffset = 2.0f;
         pdfSetLineAnnotParms(pdf, a, -1, 0.0, &p);

         _snprintf(txt, 63, "%.1f", h);
         a = pdfLineAnnot(pdf, x, y+h, x, y, 1.0, leClosedArrow, leClosedArrow, PDF_BLACK, PDF_BLACK, csDeviceRGB, "This is a measure line", "Measure Line", txt);
         // The parameters are exactly the same as above
         pdfSetLineAnnotParms(pdf, a, -1, 0.0, &p);

      pdfRestoreGraphicState(pdf);

   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}