#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

void AddHighlightAnnot(const PPDF* PDF, TAnnotType Type, UI32 Color, double x, double y, const char* Text, const char* Subject, const char* Comment)
{
   double w = pdfGetTextWidth(PDF, Text);
   pdfWriteText(PDF, x, y, Text);
   pdfHighlightAnnot(PDF, Type, x, y + pdfGetDescent(PDF), w, 20.0, Color, "Test app", Subject, Comment);
}

int main(int argc, char* argv[])
{
   SI32 i, a, count;
   double y = 50.0;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);

      pdfSetFont(pdf, "Helvetica", fsRegular, 20.0, false, cp1252);
      AddHighlightAnnot(pdf, atHighlight, PDF_YELLOW,  50.0, y, "Highlight Annotation", "Highlight Annotations", "This is a highlight annotation");
      AddHighlightAnnot(pdf, atSquiggly,  PDF_RED,    300.0, y, "Squiggly Annotation",  "Highlight Annotations", "This is a squiggly annotation");
      y += 30.0;
      AddHighlightAnnot(pdf, atStrikeOut, PDF_RED,     50.0, y, "Strikeout Annotation",  "Highlight Annotations", "This is a strikeout annotation");
      AddHighlightAnnot(pdf, atUnderline, PDF_RED,    300.0, y, "Underline Annotation",  "Highlight Annotations", "This is a underline annotation");

      y += 40.0;
      pdfCircleAnnot(pdf,  50.0, y, 200.0, 100.0, 1.0, PDF_CREAM, PDF_BLACK, csDeviceRGB, "Test app", "Circle Annotations", "This is a circle annotation");
      pdfSquareAnnot(pdf, 300.0, y, 200.0, 100.0, 1.0, PDF_CREAM, PDF_BLACK, csDeviceRGB, "Test app", "Square Annotations", "This is a square annotation");

      y += 130.0;
      pdfChangeFontSize(pdf, 12.0);
      pdfWriteFTextEx(pdf, 50.0, y, pdfGetPageWidth(pdf) - 100.0, -1.0, taLeft, "The icon color of text and file attachment annotations can be changed if "
                      "necessary with SetAnnotColor(). The background color must be set.\n\nText Annotations:");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;
      // The default icon color can be changed if necessary
      pdfTextAnnot(pdf,  50.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiComment, false);
      a = pdfTextAnnot(pdf, 100.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiHelp, false);
      pdfSetAnnotColor(pdf, a, fcBackColor, csDeviceRGB, PDF_RGB(200, 20, 30));

      pdfTextAnnot(pdf, 150.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiInsert, false);
      a = pdfTextAnnot(pdf, 200.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiKey, false);
      pdfSetAnnotColor(pdf, a, fcBackColor, csDeviceRGB, PDF_RGB(50, 200, 30));
      pdfTextAnnot(pdf, 250.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiNewParagraph, false);
      a = pdfTextAnnot(pdf, 300.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiNote, false);
      pdfSetAnnotColor(pdf, a, fcBackColor, csDeviceRGB, PDF_RGB(70, 120, 210));
      pdfTextAnnot(pdf, 350.0, y, 200.0, 100.0, "Test app", "This is a text annotation", aiParagraph, false);

      y += 50.0;
      pdfWriteText(pdf, 50.0, y, "File Attachment Annotations:");

      y += 20.0;
      const char path[] = "../../../test_files/gdi.emf";
      pdfFileAttachAnnot(pdf,  50.0, y, faiGraph,     "Test app", "An example attachment", path, true);
      pdfFileAttachAnnot(pdf, 100.0, y, faiPaperClip, "Test app", "An example attachment", path, true);
      a = pdfFileAttachAnnot(pdf, 150.0, y, faiPushPin, "Test app", "An example attachment", path, true);
      pdfSetAnnotColor(pdf, a, fcBackColor, csDeviceRGB, PDF_RGB(70, 120, 210));
      pdfFileAttachAnnot(pdf, 200.0, y, faiTag,       "Test app", "An example attachment", path, true);

      y += 60.0;
      a = pdfFreeTextAnnot(pdf, 50.0, y, 200.0, 80.0, "Test app", "This is a FreeText Annotation.", taCenter);
      pdfSetAnnotBorderWidth(pdf, a, 3.0);
      pdfSetAnnotColor(pdf, a, fcBorderColor, csDeviceRGB, PDF_GRAY);

      a = pdfFreeTextAnnot(pdf, 400.0, y, 150.0, 45.0, "Test app", "This is a FreeText Callout Annotation with a cloudy border.", taCenter);
      pdfSetAnnotBorderWidth(pdf, a, 2.0);
      pdfSetAnnotColor(pdf, a, fcBorderColor, csDeviceRGB, PDF_RED);
      pdfSetAnnotBorderEffect(pdf, a, beCloudy1);
      pdfConvToFreeTextCallout(pdf, a, 300.0f, (float)y + 40.0f, 30.0f, leOpenArrow);

      y += 120.0;
      pdfWriteText(pdf, 50.0, y, "Line Annotations:");

      y += 30.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leNone,         leNone, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leButt,         leButt, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leCircle,       leCircle, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leClosedArrow,  leClosedArrow, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leRClosedArrow, leRClosedArrow, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leDiamond,      leDiamond, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leOpenArrow,    leOpenArrow, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leROpenArrow,   leROpenArrow, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leSlash,        leSlash, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
      y += 20.0; pdfLineAnnot(pdf, 50.0, y, 350.0, y, 1.0, leSquare,       leSquare, PDF_RED, PDF_BLACK, csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");

   pdfEndPage(pdf);

   pdfAppend(pdf);

      TFltPoint points[] = {TFltPoint(50.0f, 200.0f), TFltPoint(50.0f, 100.0f), TFltPoint(150.0f, 50.0f), TFltPoint(250.0f, 100.0f), TFltPoint(250.0f, 200.0f)};
      count = sizeof(points) / sizeof(TFltPoint);

      pdfPolyLineAnnot(pdf, points, count, 1.0, leDiamond, leCircle, PDF_WHITE, PDF_RED, csDeviceRGB, "Test app", "Polyline Annotations", "This is a polyline annotation");

      for (i = 0; i < count; i++)
         points[i].x += 250.0f;

      pdfPolygonAnnot(pdf, points, count, 1.0, PDF_CREAM, PDF_RED, csDeviceRGB, "Test app", "Polygon Annotations", "This is a polygon annotation");

      for (i = 0; i < count; i++)
      {
         points[i].x -= 250.0f;
         points[i].y += 230.0f;
      }

      y = 230.0;
      pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
      pdfWriteFTextEx(pdf, 50.0, y, pdfGetPageWidth(pdf) - 100.0f, -1.0, taLeft, "The points of an Ink Annotation will be approximated with bezier curves."
         "The result is a smooth path. A polyline annotation is almost the same annotation type without the approximation with bezier curves.");

      pdfInkAnnot(pdf, points, count, 1.0, PDF_BLUE, csDeviceRGB, "Test app", "Ink Annotations", "This is an ink annotation");

      y+= 230.0;
      pdfWriteText(pdf, 50.0, y, "Stamp Annotations:");
      y += 20.0;
      pdfWriteFTextEx(pdf, 50.0, y, pdfGetPageWidth(pdf) - 100.0, -1.0, taLeft, "The default color of a stamp annotation can be changed with SetAnnotColor(). The border or text color must be set.");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;
      pdfStampAnnot(pdf, rsApproved,             50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsAsIs,                220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsConfidential,        390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

      y += 60.0;
      pdfStampAnnot(pdf, rsDepartmental,         50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsDraft,               220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsExperimental,        390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

      y += 60.0;
      pdfStampAnnot(pdf, rsExpired,              50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      a = pdfStampAnnot(pdf, rsFinal,            220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfSetAnnotColor(pdf, a, fcBorderColor, csDeviceRGB, PDF_RGB(170, 10, 160));
      pdfStampAnnot(pdf, rsForComment,          390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

      y += 60.0;
      pdfStampAnnot(pdf, rsForPublicRelease,     50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsNotApproved,         220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsNotForPublicRelease, 390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

      y += 60.0;
      pdfStampAnnot(pdf, rsSold,                 50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
      pdfStampAnnot(pdf, rsTopSecret,           220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}