#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 act, f;
   double y, base;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetDocInfo(pdf, diTitle, "Field groups");
   pdfSetDocInfo(pdf, diSubject, "DynaPDF C++ example");

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);
      pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
      pdfSetLeading(pdf, 12.0);
      pdfWriteFTextEx(pdf, 50.0, 50.0, pdfGetPageWidth(pdf) - 100.0, -1.0, taJustify,
         "The six text fields share the same value. Such an array of fields is called a field group. All fields in the group must be of the same type.\n\n"
         "A field group can be created in two different ways: either create two or more fields with the same name or pass the handle of the base field as Parent to the children. "
         "The latter way is more efficient since it is not required to search for the parent field when a child will be created.\n\n"
         "Enter some more text into a field to see the difference between auto size and fixed font size.");

      // GetLastTextPosY(pdf, ) returns bottom up coordinates. We must subtract the value from the page height.
      base = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 20.0;

      pdfWriteFTextEx(pdf, 50.0, base, 200.0, -1.0, taLeft, "Font size <= 1.0 means auto size.");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;

      pdfChangeFontSize(pdf, 1.0);
      f = pdfCreateTextField(pdf, "Auto", -1, false, 0, 50.0, y, 200.0, 20.0);
      pdfSetTextFieldValue(pdf, f, "Some text...", "Some text...", taLeft);

      y += 30.0;
      pdfCreateTextField(pdf, NULL, f, false, 0, 50.0, y, 200.0, 30.0);

      y += 40.0;
      pdfCreateTextField(pdf, NULL, f, false, 0, 50.0, y, 200.0, 40.0);

      pdfChangeFontSize(pdf, 12.0);
      pdfWriteFTextEx(pdf, 345.0, base, 200.0, -1.0, taLeft, "The same fields with a fixed font size.");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;

      pdfChangeFontSize(pdf, 12.0);
      pdfCreateTextField(pdf, NULL, f, false, 0, 345.0, y, 200.0, 20.0);

      y += 30.0;
      pdfChangeFontSize(pdf, 24.0);
      pdfCreateTextField(pdf, NULL, f, false, 0, 345.0, y, 200.0, 30.0);

      y += 40.0;
      pdfChangeFontSize(pdf, 34.0);
      pdfCreateTextField(pdf, NULL, f, false, 0, 345.0, y, 200.0, 40.0);

      pdfChangeFontSize(pdf, 18.0);
      f = pdfCreateButton(pdf, "Reset", "Reset", -1, 222.5, y + 80.0, 150.0, 25.0);
      pdfSetFieldColor(pdf, f, fcBackColor, csDeviceRGB, PDF_LTGRAY);
      pdfSetFieldBorderStyle(pdf, f, bsBevelled);

      act = pdfCreateResetAction(pdf);
      pdfAddActionToObj(pdf, otField, oeOnMouseUp, act, f);
   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}