Attribute VB_Name = "DynaPDFInt1"
Option Explicit

' Specific function which can be used to copy string values from DynaPDF pointers to VB strings
Public Declare Function pdfCopyMem2 Lib "dynapdf.dll" Alias "pdfCopyMem" (ByVal Source As Long, Dest As Any, ByVal sLen As Long) As Long

Public Declare Function pdfStrLenA Lib "dynapdf.dll" (ByVal AStr As Long) As Long
Public Declare Function pdfStrLenW Lib "dynapdf.dll" (ByVal AStr As Long) As Long

Private Declare Sub pdfCopyPtr Lib "dynapdf.dll" (ByVal Source As Long, ByRef Dest As Any)

Public Declare Function WideCharToMultiByte Lib "kernel32.dll" ( _
                         ByVal CodePage As Long, _
                         ByVal dwFlags As Long, _
                         ByVal lpWideCharStr As Long, _
                         ByVal cchWideChar As Long, _
                         ByVal lpMultiByteStr As Long, _
                         ByVal cbMultiByte As Long, _
                         ByVal lpDefaultChar As Long, _
                         ByVal lpUsedDefaultChar As Long) As Long

Public Const CP_UTF8 As Long = 65001


' Error types
Public Const E_WARNING As Long = &H2000000
Public Const E_SYNTAX_ERROR As Long = &H4000000
Public Const E_VALUE_ERROR As Long = &H8000000
Public Const E_FONT_ERROR As Long = &H10000000
Public Const E_FATAL_ERROR As Long = &H20000000
Public Const E_FILE_ERROR As Long = &H40000000

' Basic RGB colors
Public Const PDF_AQUA As Long = &HFFFF00
Public Const PDF_BLACK As Long = &H0&
Public Const PDF_BLUE As Long = &HFF0000
Public Const PDF_CREAM As Long = &HF0FBFF
Public Const PDF_DKGRAY As Long = &H808080
Public Const PDF_FUCHSIA As Long = &HFF00FF
Public Const PDF_GRAY As Long = &H808080
Public Const PDF_GREEN As Long = &H8000&
Public Const PDF_LIME As Long = &HFF00&
Public Const PDF_LTGRAY As Long = &HC0C0C0
Public Const PDF_MAROON As Long = &H80&
Public Const PDF_MEDGRAY As Long = &HA4A0A0
Public Const PDF_MOGREEN As Long = &HC0DCC0
Public Const PDF_NAVY As Long = &H800000
Public Const PDF_OLIVE As Long = &H8080&
Public Const PDF_PURPLE As Long = &H800080
Public Const PDF_RED As Long = &HFF&
Public Const PDF_SILVER As Long = &HC0C0C0
Public Const PDF_SKYBLUE As Long = &HF0CAA6
Public Const PDF_WHITE As Long = &HFFFFFF
Public Const PDF_TEAL As Long = &H808000
Public Const PDF_YELLOW As Long = &HFFFF&
Public Const NO_COLOR As Long = &HFFFFFFF1   ' Transparent color used by annotaions and form fields

' Specific error codes to determine whether the supplied to decrypt the input file password was wrong
Public Const ENEED_PWD As Long = -(&HB2 Or E_FILE_ERROR)
Public Const EWRONG_OPEN_PWD As Long = -(&HB3 Or E_FILE_ERROR)
Public Const EWRONG_OWNER_PWD As Long = -(&HB4 Or E_FILE_ERROR)
Public Const EWRONG_PWD As Long = -(&HB5 Or E_FILE_ERROR)

' Specific return values of the OnPageBreak callback function
Public Const NEW_ALIGN_LEFT As Long = 1
Public Const NEW_ALIGN_RIGHT As Long = 2
Public Const NEW_ALIGN_CENTER As Long = 3
Public Const NEW_ALIGN_JUSTIFY As Long = 4

' Use these masks to determine which viewer preference values are defined.
Public Const AV_NON_FULL_SRC_MASK As Long = &H5
Public Const AV_DIRECTION_MASK As Long = &H18
Public Const AV_VIEW_PRINT_MASK As Long = &H3E0

Public Const PDF_ANNOT_INDEX As Long = &H40000000 ' Special flag for GetPageFieldEx() to indicate that an annotation index
                                                  ' was passed to the function. See GetPageFieldEx() for further information.

Enum TActionType
   atGoTo
   atGoToR
   atHide
   atImportData
   atJavaScript
   atLaunch
   atMovie
   atNamed
   atRendition     ' PDF 1.5
   atReset         ' ResetForm
   atSetOCGState   ' PDF 1.5
   atSound
   atSubmit        ' SubmitForm
   atThread
   atTransition
   atURI
   atGoTo3DView    ' PDF 1.6
   atGoToE         ' PDF 1.6 Like atGoToR but refers to an embedded PDF file.
   atRichMediaExec ' PDF 1.7 Extension Level 3
End Enum

Enum TAnnotColor
   acBackColor
   acBorderColor
   acTextColor
End Enum

Enum TAnnotIcon
   aiComment
   aiHelp
   aiInsert
   aiKey
   aiNewParagraph
   aiNote
   aiParagraph
   aiUserDefined   ' Internal, not usable
End Enum

Enum TAnnotType
   atCaret
   atCircle
   atFileLink    ' A Link annotation with an associated GoToR action (go to remote)
   atFreeText
   atHighlight   ' Highlight annotation
   atInk
   atLine
   atPageLink    ' A Link annotation with an associated GoTo action
   atPolygon
   atPolyLine
   atPopUp
   atSquare
   atSquiggly    ' Highlight annotation
   atStamp
   atStrikeOut   ' Highlight annotation
   atText        ' Also used as container to store the State Model
   atUnderline   ' Highlight annotation
   atWebLink     ' A Link annotation with an associated URI action
   atWidget      ' Form Fields are handled separately
   at3D          ' PDF 1.6
   atSoundAnnot  ' PDF 1.2
   atFileAttach  ' PDF 1.3
   atRedact      ' PDF 1.7
   atWatermark   ' PDF 1.6
   atUnknown     ' Unknown annotation type
   atMovieAnnot  ' PDF 1.2
   atPrinterMark ' PDF 1.4
   atProjection  ' PDF 1.7 Extension Level 3
   atRichMedia   ' PDF 1.7 Extension Level 3
   atScreen      ' PDF 1.5
   atTrapNet     ' PDF 1.3
End Enum

Enum TBaseEncoding
   beWinAnsi
   beMacRoman
   beMacExpert
   beStandard
End Enum

' The tags have the same meaning as the corresponding HTML tags.
' See PDF Reference for further information.
Enum TPDFBaseTag
   btArt
   btArtifact
   btAnnot
   btBibEntry      ' BibEntry -> Bibliography entry
   btBlockQuote
   btCaption
   btCode
   btDiv
   btDocument
   btFigure
   btForm
   btFormula
   btH
   btH1
   btH2
   btH3
   btH4
   btH5
   btH6
   btIndex
   btLink
   btList          ' L
   btListElem      ' LI
   btListText      ' LBody
   btNote
   btP
   btPart
   btQuote
   btReference
   btSection       ' Sect
   btSpan
   btTable
   btTableDataCell ' TD
   btTableHeader   ' TH
   btTableRow      ' TR
   btTOC
   btTOCEntry      ' TOCI
   btCL            ' CL (Continued List)
   btLabel         ' Lbl
   btRuby
   btWarichu
   ' PDF 2.0 tags:
   btAbbr
   btCallout
   btDek
   btEm
   btLineNum
   btReason
   btRedaction
   btSidebar
   btStrong
   btSub
   btSup
End Enum

Public Type TBBox
   x1 As Single
   y1 As Single
   x2 As Single
   y2 As Single
End Type

Enum TBlendMode
   bmNotSet
   bmNormal
   bmColor
   bmColorBurn
   bmColorDodge
   bmDarken
   bmDifference
   bmExclusion
   bmHardLight
   bmHue
   bmLighten
   bmLuminosity
   bmMultiply
   bmOverlay
   bmSaturation
   bmScreen
   bmSoftLight
End Enum

Enum TBmkStyle
   bmsNormal = 0
   bmsItalic = 1
   bmsBold = 2
End Enum

Enum TBorderEffect
   beSolid   ' Default
   beCloudy1 ' Circle diameter 9 units
   beCloudy2 ' Circle diameter 17 units
End Enum

Enum TBorderStyle
   bsSolid
   bsBevelled
   bsInset
   bsUnderline
   bsDashed
   bsUserDefined ' Internal
End Enum

Enum TBtnCaptionPos
   bcpCaptionOnly  ' Default
   bcpImageOnly    ' No caption; image only
   bcpCaptionBelow ' Caption below the image
   bcpCaptionAbove ' Caption above the image
   bcpCaptionRight ' Caption on the right of the image
   bcpCaptionLeft  ' Caption on the left of the image
   bcpCaptionOver  ' Caption overlaid directly on the image
End Enum

Enum TCheckBoxState
   cbUnknown
   cbChecked
   cbUnChecked
End Enum

Type TCIDMetric
   Width As Single
   X As Single
   Y As Single
End Type

Enum TColView
   civNotSet
   civDetails
   civTile
   civHidden
   civCustom  ' PDF 1.7 Extension Level 3, the collection view is presented by a SWF file.
End Enum

Enum TCompressionFilter
   cfFlate = 0&                    ' Flate or Zip compression
   cfJPEG = 1&                     ' JPEG compression
   cfCCITT3 = 2&                   ' CCITT Fax G3 compression
   cfCCITT4 = 3&                   ' CCITT Fax G4 compression
   cfLZW = 4&                      ' TIFF or GIF output -> Very fast but less compression ratios than flate
   cfLZWBW = 5&                    ' TIFF
   cfFlateBW = 6&                  ' TIFF, PNG, or BMP output -> Dithered black & white output. The resulting image will be
                                   ' compressed with Flate or left uncompressed if the output image format is a bitmap. If
                                   ' you want to use CCITT Fax 4 compression (TIFF only) set the flag icUseCCITT4 in the
                                   ' AddImage() function call. Note that this filter is not supported for PDF creation!
   cfJP2K = 7&                     ' JPEG2000 compression
   cfJBIG2 = 8&                    ' PDF output only
   cfNone = 9&                     ' TIFF output only
   ' Special flags for AddRasImage(), RenderPageToImage(), or RenderPDFFile() if the pixel format was set to pxfGray or pxfGrayA.
   ' These flags can be combined with the filters cfFlate, cfCCITT3, cfCCITT4, cfJBIG2, cfLZW, and cfJP2K.
   cfDitherFloydSteinberg = &H1000& ' Floyd Steinberg dithering.
   cfConvGrayToOtsu = &H2000&      ' The Otsu filter is a special filter to produce black & white images. It is very useful
                                   ' if an OCR scan should be applied on the resulting 1 bit image. The flag is considered
                                   ' in AddRasImage(), RenderPDFFile(), and RenderPageToImage() if the pixel format was set
                                   ' to pxfGray.
   cfOrderedDithering = &H4000&    ' Ordered dithering. The difference in comparison to the pixel format pxf1Bit is that
                                   ' we render into a GrayA buffer instead of a native 1 bit buffer since this one produces
                                   ' incorrect results in certain transparency calculations.
   cfIgnoreICCProfile = &H8000&    ' Special flag for AddRasImage(). Meaningful only if color management is enabled. If set,
                                   ' the device ICC profile is not embedded in the image file.
   ' Special flags for Optimize()
   cfPresLosslessFilter = &H10000  ' Preserve loss-less compression filters and use the specified filter otherwise.
   cfPresLossyFilter = &H20000     ' Preserve lossy compression filters and use the specified filter otherwise.
                                   ' cfPresLossLessFilter and cfPresLossyFilter can be combined to preserve the original
                                   ' compression filter in either case.
End Enum

Enum TCellAlign
   coLeft = 0
   coTop = coLeft
   coRight = 1
   coBottom = coRight
   coCenter = 2
End Enum

Enum TCodepage
   cp1250
   cp1251
   cp1252
   cp1253
   cp1254
   cp1255
   cp1256
   cp1257
   cp1258
   cp8859_2
   cp8859_3
   cp8859_4
   cp8859_5
   cp8859_6
   cp8859_7
   cp8859_8
   cp8859_9
   cp8859_10
   cp8859_13
   cp8859_14
   cp8859_15
   cp8859_16
   cpSymbol
   cp437
   cp737
   cp775
   cp850
   cp852
   cp855
   cp857
   cp860
   cp861
   cp862
   cp863
   cp864
   cp865
   cp866
   cp869
   cp874
   cpUnicode
   cpCJK_Big5_Uni    ' Big5 plus HKSCS extension.
   cpCJK_EUC_JP_Uni  ' EUC-JP
   cpCJK_EUC_KR_Uni  ' EUC-KR
   cpCJK_EUC_TW_Uni  ' CNS-11643-1992 (Planes 1-15).
   cpCJK_GBK_Uni     ' GBK is the Microsoft code page 936 (GB2312 EUC-CN plus GBK extension).
   cpCJK_GB12345_Uni ' GB-12345-1990 (Traditional Chinese form of GB-2312).
   cpCJK_HZ_Uni      ' Mixed ASCII / GB-2312 encoding
   cpCJK_2022_CN_Uni ' ISO-2022-CN-EXT (GB-2312 plus ISO-11643 Planes 1-7).
   cpCJK_2022_JP_Uni ' ISO-2022-JP
   cpCJK_2022_KR_Uni ' ISO-2022-KR
   cpCJK_646_CN_Uni  ' ISO-646-CN (GB-1988-80)
   cpCJK_646_JP_Uni  ' ISO-646-JP (JIS_C6220-1969-RO).
   cpCJK_IR_165_Uni  ' ISO-IR-165 (extended version of GB-2312).
   cpCJK_932_Uni     ' Microsoft extended version of SHIFT_JIS.
   cpCJK_949_Uni     ' EUC-KR extended with UHC (Unified Hangul Codes).
   cpCJK_950_Uni     ' Microsoft extended version of Big5.
   cpCJK_JOHAB_Uni   ' JOHAB
   cpShiftJIS        ' ShiftJIS charset plus code page 932 ectension.
   cpBig5            ' Big5 plus HKSCS extension.
   cpGB2312          ' GB2312 charset plus GBK and cp936 extension.
   cpWansung         ' Wansung
   cpJohab           ' JOHAB
   cpMacRoman        ' Mac Roman
   cpAdobeStd        ' This is an encoding for Type1 fonts. It should normally not be used.
   cpInternal        ' Internal -> not usable
   cpGlyphIndexes    ' Can be used with TrueType and OpenType fonts only. DynaPDF creates a reverse mapping so that copy & paste will work.
   cpPDFDocEnc       ' Internal -> not usable. Used for form fonts. This is a superset of the code pages 1252 and MacRoman.
   cpExtCMap         ' Internal -> not usable. This code page is set when a font was loaded with an external cmap.
   cpDingbats        ' Internal -> Special encoding for ZapfDingbats
   cpMacExpert       ' Internal -> not usable
   cpRoman8          ' This is a standard PCL 5/6 code page
End Enum

Enum TDecodeFilter
   dfNone
   dfASCII85Decode   ' No parameters
   dfASCIIHexDecode  ' No parameters
   dfCCITTFaxDecode  ' Optional Parameters
   dfDCTDecode       ' Optional Parameters
   dfFlateDecode     ' Optional Parameters
   dfJBIG2Decode     ' Optional Parameters
   dfJPXDecode       ' No parameters
   dfLZWDecode       ' Optional Parameters
   dfRunLengthDecode ' No parameters
   dfCrypt = 10      ' Internal, cannot occur -> Already handled by the security handler.
End Enum

Enum TPDFColorSpace
   csDeviceRGB
   csDeviceCMYK
   csDeviceGray
End Enum

Enum TDestType
   dtXY_Zoom       ' three parameters (a, b, c) -> (X, Y, Zoom)
   dtFit           ' no parameters
   dtFitH_Top      ' one parameter    (a)
   dtFitV_Left     ' one parameter    (a)
   dtFit_Rect      ' four parameters  (a, b, c, d) -> (left, bottom, right, top)
   dtFitB          ' no parameter
   dtFitBH_Top     ' one parameter    (a)
   dtFitBV_Left    ' one parameter    (a)
End Enum

Enum TDrawMode
  dmNormal
  dmStroke
  dmFillStroke
  dmInvisible
  dmFillClip
  dmStrokeClip
  dmFillStrokeClip
  dmClipping
End Enum

Enum TDuplexMode
   dpmNone          ' Default
   dpmSimplex
   dpmFlipShortEdge
   dpmFlipLongEdge
End Enum

Enum TEnumFontProcFlags
   efpAnsiPath = 0    ' Code page 1252 on Windows, UTF-8 otherwise
   efpUnicodePath = 1 ' FilePath is in Unicode format. Make a typecast to (UI16*) in this case.
   efpEmbeddable = 2  ' The font has embedding rights.
   efpEditable = 4    ' If set, the font has editing rights (important for form fields).
End Enum

Enum TExtColorSpace
   esDeviceRGB   ' Device color space
   esDeviceCMYK  ' Device color space
   esDeviceGray  ' Device color space
   esCalGray     ' CIE-based color space
   esCalRGB      ' CIE-based color space
   esLab         ' CIE-based color space
   esICCBased    ' CIE-based color space -> contains an ICC profile
   esPattern     ' Special color space
   esIndexed     ' Special color space
   esSeparation  ' Special color space
   esDeviceN     ' Special color space
   esNChannel    ' Special color space
   esInitSpace = -1
End Enum

Enum TFieldFlags
   ffReadOnly = &H1
   ffRequired = &H2
   ffNoExport = &H4

   ffInvisible = &H8
   ffHidden = &H10
   ffPrint = &H20
   ffNoZoom = &H40
   ffNoRotate = &H80
   ffNoView = &H100

   ffMultiline = &H1000&        ' Text fields only
   ffPassword = &H2000          ' Text fields only
   ffNoToggleToOff = &H4000     ' Radio buttons, check boxes
   ffRadioIsUnion = &H2000000   ' PDF-1.5 radio buttons only
   ffCommitOnSelCh = &H4000000  ' PDF-1.5 combo boxes, list boxes

   ffEdit = &H40000             ' Combo boxes only
   ffSorted = &H80000           ' Combo boxes and list boxes -> sorts the choice values in ascending order
   ffFileSelect = &H100000      ' PDF 1.4 Text fields only
   ffMultiSelect = &H200000     ' PDF 1.4 List boxes only
   ffDoNotSpellCheck = &H400000 ' PDF 1.4 Text fields, combo boxes. If the field is a combo box, this flag is meaningful only if ffEdit is also set.
   ffDoNotScroll = &H800000     ' PDF 1.4 Text fields only
   ffComb = &H1000000
End Enum

Enum TFieldType
   ftButton
   ftCheckBox
   ftRadioBtn
   ftComboBox
   ftListBox
   ftText
   ftSignature
   ftGroup     ' this is not a real field type, it is just an array of fields
End Enum

Public Type TFltPoint
   X As Single
   Y As Single
End Type

Public Type TI32Point
   X As Long
   Y As Long
End Type

Public Type TFltRect
   Left As Single
   Bottom As Single
   Right As Single
   Top As Single
End Type

Enum TFontBaseType
   fbtTrueType ' TrueType, TrueType Collections, or OpenType fonts with TrueType outlines
   fbtType1    ' Type1 font
   fbtOpenType ' OpenType font with Postscript outlines
   fbtStdFont  ' PDF Standard font
   fbtDisabled ' This value can be used to disable a specific font format. See SetFontSearchOrder() for further information.
End Enum

Enum TFontFileSubtype
   ffsType1C        ' CFF based Type1 font
   ffsCIDFontType0C ' CFF based Type1 CID font
   ffsOpenType      ' TrueType based OpenType font
   ffsOpenTypeC     ' CFF based OpenType font
   ffsCIDFontType2  ' TrueType based CID Font
   ffsCIDType1      ' Type1 font used as CID font (not documented in PDF specs)
   ffsReserved1
   ffsReserved2
   ffsReserved3
   ffsNoSubtype
End Enum

Enum TFontType
   ftMMType1
   ftTrueType
   ftType0    ' Check the font file type to determine the font sub type
   ftType1
   ftType3
End Enum

'The font search run works as follows:

'   - DynaPDF tries always to find the exact weight, if it cannot be found then a font with
'     the next smaller weight is selected (if available).
'   - Italic styles can always be emulated but it is not possible to emulate thinner weights or
'     regular styles with an italic font.
'   - If the specified weight is larger as the font weight the remaining weight will be emulated
'     if the difference to the requested weight is larger than 200.
'     With SetFontWeight() it is possible to control whether a missing weight should be emulated.
'     If FontWeight is smaller or equal to the requested font weight then emulation will be disabled.

'TFStyle is a bitmask that is defined as follows:

'   - Bits 0..7   // Style bits fsItalic, fsUnderlined, fsStriked
'   - Bits 8..19  // Width class -> Defined for future use.
'   - Bits 20..31 // Font Weight

'- A width class can be converted to a style constant by multiplying it with 256 (width shl 8).
'- A font weight can be converted to a style constant by multiplying it with 1048576 (weight shl 20).
'- Additional attributes can be added with a binary or operator (e.g. style or fsItalic).
'- Only one width class and one font weight can be set at time.

'- WidthFromStyle() extracts the width class.
'- WeightFromStyle() extracts the font weight.

'The following functions extract the width class or font weight from a style variable:

'   widthClass  = WidthFromStyle(style);
'   weightClass = WeightFromStyle(style);

Enum TFStyle
   fsNone = &H0                  ' Regular weight (400)
   fsItalic = &H1
   fsUnderlined = &H4
   fsStriked = &H8
   fsVerticalMode = &H10         ' Not considered at this time
   fsDblUnderline = &H20
   ' Width class
   fsUltraCondensed = &H100      ' 1
   fsExtraCondensed = &H200      ' 2
   fsCondensed = &H300           ' 3
   fsSemiCondensed = &H400       ' 4
   fsNormal = &H500              ' 5
   fsSemiExpanded = &H600        ' 6
   fsExpanded = &H700            ' 7
   fsExtraExpanded = &H800       ' 8
   fsUltraExpanded = &H900       ' 9
   ' Weight class
   fsThin = &H6400000            ' 100
   fsExtraLight = &HC800000      ' 200
   fsLight = &H12C00000          ' 300
   fsRegular = &H19000000        ' 400 -> Same as fsNone
   fsMedium = &H1F400000         ' 500
   fsDemiBold = &H25800000       ' 600
   fsBold = &H2BC00000           ' 700 -> The old constant 2 is still supported to preserve backward compatibility
   fsExtraBold = &H32000000      ' 800
   fsBlack = &H38400000          ' 900
   fsUltraBlack = &H3E800000     ' 1000
End Enum

Enum THashType
   htDetached ' CloseAndSignFileExt() returns the byte ranges of the finish PDF buffer to create a detached signature
   htSHA1     ' CloseAndSignFileExt() returns the SHA1 hash of the PDF file so that it can be signed
End Enum

Enum THighlightMode
  hmNone
  hmInvert
  hmOutline
  hmPush
  hmPushUpd       ' Update appereance stream on changes
End Enum

Enum TImageFormat
   ifmTIFF     ' DeviceRGB, DeviceCMYK, DeviceGray, Black & White -> CCITT Fax Group 3/4, JPEG, Flate, LZW.
   ifmJPEG     ' DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG compression.
   ifmPNG      ' DeviceGray, DeviceRGB, Black & White -> Flate compression.
   ifmReserved ' Reserved for future extensions.
   ifmBMP      ' DeviceGray, DeviceRGB, Black & White -> Uncompressed.
   ifmJPC      ' DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG2000 compression.
End Enum

Public Type TIntRect
   x1 As Long
   y1 As Long
   x2 As Long
   y2 As Long
End Type

Enum TKeyLen
   kl40bit     ' RC4 Encryption -> Acrobat 3 or higher
   kl128bit    ' RC4 Encryption -> Acrobat 5 or higher
   kl128bitEx  ' RC4 Encryption -> Acrobat 6 or higher
   klAES128    ' AES Encryption -> Acrobat 7 or higher
   klAES256    ' AES Encryption -> Acrobat 9 or higher
   klAESRev6   ' AES Encryption -> Acrobat X or higher
End Enum

Enum TLineEndStyle
   leNone
   leButt
   leCircle
   leClosedArrow
   leDiamond
   leOpenArrow
   leRClosedArrow
   leROpenArrow
   leSlash
   leSquare
End Enum

Enum TLineCaptionPos
   cpInline ' The caption is centered inside the line
   cpTop     ' The caption is drawn on top of the line
End Enum

Public Type TLineAnnotParms
   StructSize As Long            ' Must be set to sizeof(TLineAnnotParms)
   Caption As Long               ' If true, the annotation string Content is used as caption.
   CaptionOffsetX As Single      ' Horizontal offset of the caption from its normal position
   CaptionOffsetY As Single      ' Vertical offset of the caption from its normal position
   CaptionPos As TLineCaptionPos ' The position where the caption should be drawn if present
   LeaderLineLen As Single       ' Length of the leader lines (positive or negative)
   LeaderLineExtend As Single    ' Optional leader line extend beyond the leader line (must be a positive value or zero)
   LeaderLineOffset As Single    ' Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)
End Type

Enum TLoadCMapFlags
   lcmDefault = 0   ' Load the cmaps in the directory now
   lcmRecursive = 1 ' Load sub directories recursively
   lcmDelayed = 2   ' Load the cmap files only when a font requires an external cmap
End Enum

Enum TMeasureNumFormat
   mnfDecimal
   mnfFractional
   mnfRound
   mnfTruncate
End Enum

Enum TMeasureLblPos
   mlpSuffix
   mlpPrefix
End Enum

Enum TNamedAction
   naFirstPage
   naLastPage
   naNexPage
   naPrevPage
   naGoBack
   naOpenDlg
   naPrintDlg
   naGeneralInfo
   naFontsInfo
   naSaveAs
   naSecurityInfo
   naFitPage
   naFullScreen
   naDeletePages
   naQuit
   naUserDefined  ' Non predefined action
End Enum

Enum TNewAlign
   naUnchanged = 0
   naLeft = 1
   naCenter = 2
   naRight = 3
   naJustify = 4
End Enum

' All actions which should be applied to an event except On Mouse Upend Enum must be a JavaScript action!
Enum TObjEvent
   oeNoEvent           ' Internal use only -> DO NOT USE THIS VALUE!!!
   oeOnOpen            ' Catalog Pages
   oeOnClose           ' Pages only
   oeOnMouseUp         ' All fields page link annotations bookmarks
   oeOnMouseEnter      ' Form fields only
   oeOnMouseExit       ' Form fields only
   oeOnMouseDown       ' Form fields only
   oeOnFocus           ' Form fields only
   oeOnBlur            ' Form fields only
   oeOnKeyStroke       ' Text fields only
   oeOnFormat          ' Text fields only
   oeOnCalc            ' Text fields combo boxes list boxes
   oeOnValidate        ' All form fields except buttons
   oeOnPageVisible     ' PDF 1.5 -> Form fields only
   oeOnPageInVisible   ' PDF 1.5 -> Form fields only
   oeOnPageOpen        ' PDF 1.5 -> Form fields only
   oeOnPageClose       ' PDF 1.5 -> Form fields only
   oeOnBeforeClosing   ' PDF 1.4 -> Catalog only
   oeOnBeforeSaving    ' PDF 1.4 -> Catalog only
   oeOnAfterSaving     ' PDF 1.4 -> Catalog only
   oeOnBeforePrinting  ' PDF 1.4 -> Catalog only
   oeOnAfterPrinting   ' PDF 1.4 -> Catalog only
End Enum

Enum TObjType
   otAction
   otAnnotation
   otBookmark
   otCatalog           ' PDF 1.4
   otField
   otPage
   otPageLink
End Enum

Enum TOCAppEvent
   aeExport = 1
   aePrint = 2
   aeView = 4
End Enum

Enum TOCGIntent
   oiDesign = 2
   oiView = 4     ' Default
   oiAll = 8
   oiEmpty = 16   ' Internal
   ' Special flag for GetOCG().
   oiVisible = 32 ' This flag is not considered when creating a layer. It is only used in GetOCG() to determine whether a layer is visible.
End Enum

Enum TOCPageElement
   peBackgroundImage ' BG
   peForegroundImage ' FG
   peHeaderFooter    ' HF
   peLogo            ' L
   peNone
End Enum

Enum TOCGUsageCategory
   oucNone = 0
   oucExport = 1
   oucLanguage = 2
   oucPrint = 4
   oucUser = 8
   oucView = 16
   oucZoom = 32
End Enum

Enum TOCUserType
   utIndividual
   utOrganization
   utTitle
   utNotSet
End Enum

Enum TOptimizeFlags
   ofDefault = &H0                      ' Just rebuild the content streams.
   ofInMemory = &H1                     ' Optimize the file fully in memory. Only useful for small PDF files.
   ofConvertAllColors = &H2             ' If set Separation DeviceN and NChannel color spaces will be converted to the device space.
   ofIgnoreICCBased = &H4               ' If set ICCBased color spaces will be left unchanged.
   ofScaleImages = &H8                  ' Scale images as specified in the TOptimizeParams structure.
   ofSkipMaskedImages = &H10            ' Meaningful only if ofScaleImages is set. If set don't scale images with a color mask.
   ofNewLinkNames = &H20                ' If set rename all object links to short names like F1 F2 etc.
   ofDeleteInvPaths = &H40              ' Delete invisible paths. An invisible path is a path that was finished with the no-op operator "n".
   ofFlattenLayers = &H80               ' Flatten layers if any.
   ofDeletePrivateData = &H100          ' Delete private data objects from pages templates and images.
   ofDeleteThumbnails = &H200           ' Thumbnails can be deleted since PDF viewers can create thumbnails easily on demand.
   ofDeleteAlternateImages = &H400      ' If set alternate images will be deleted.
   ofNoImageSizeCheck = &H800           ' Meaningful only if ofScaleImages is set. If set do not check whether the scaled image is smaller as the original image.
   ofIgnoreZeroLineWidth = &H1000&      ' Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                        ' If set ignore line width operators with a value of zero (zero means one device unit).
   ofAdjZeroLineWidthOnly = &H2000      ' Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                        ' If set, change the line width of real hairlines only (a hairline is a one pixel width line -> LineWidth == 0).
   ofCompressWithJBIG2 = &H4000         ' If set, 1 bit images are compressed with JBIG2 if not already compressed with this filter.
   ofNoFilterCheck = &H8000&            ' Meaningful only, if the flag ofCompressWithJBIG2 is set. If set, re-compress all 1 bit images, also if already compressed with JBIG2.
                                        ' This flag is mainly a debug flag to compare the compression ratio with other JBIG2 implementations.
   ofConvertGrayTo1Bit = &H10000        ' Useful for scanned faxes since many scanners create gray images for black & white input.
   ' ---------------------------- Notice: ----------------------------------------------
   ' Special color spaces like Separation, DeviceN, and NChannel are ignored unless the flag ofConvertAllColors is set too.
   '
   ofConvertToGray = &H20000            ' If set, images, text, and vector graphics are converted to DeviceGray.
   ofConvertToRGB = &H40000             ' If set, images, text, and vector graphics are converted to DeviceRGB.
   ofConvertToCMYK = &H80000            ' If set, images, text, and vector graphics are converted to DeviceCMYK.
   ofReplaceJP2KWithJPEG = &H100000     ' Meaningful only, if the flag ofConvertToGray, ofConvertToRGB, or ofConvertToCMYK is set. If set, JPEG 2000 compressed images
                                        ' (which are converted to another color space) will be compressed with JPEG instead JPEG 2000. JPEG 2000 compression is very slow
                                        ' and requires much memory. JPEG compression is around 10 times faster and produces almost identical results.
   ofUseOtsuFilter = &H200000           ' Meaningful only, if the flag ofConvertGrayTo1Bit is set. The Otsu filter is useful for gray scanned faxes.
   ofConvTextToOutlines = &H400000      ' If set, texts of non-Type3 fonts are converted to outlines or vector graphics. The resulting file contains no fonts with
                                        ' exception of Type3 fonts, if any. Such files are large but avoid printing issues due to missing or damaged fonts.
   ofConvNonEmbFontsOnly = &H800000     ' Meaningful only, if the flag ofConvTextToOutlines is set. If set, text of non-embedded fonts are converted to outlines only.
                                        ' Embedded fonts remain embedded.
   ofIgnoreDeviceN = &H1000000          ' If set DeviceN color spaces are left unchanged.
   ofIgnoreNChannel = &H2000000         ' If set NChannel color spaces are left unchanged.
   ofIgnoreSeparation = &H4000000       ' If set Separation color spaces are left unchanged.
   ofFailOnOverprinting = &H8000000     ' Meaningful only if a color conversion flag is set. If set the function returns with a fatal error if an object with enabled
                                        ' overprinting was found on the page. The appearance of overprinted objects would change and make the page maybe unusable.
                                        ' Overprinted objects can be left unchanged (set the flag ofSkipOverprintedObj in this case) or Optimize() can return with a fatal
                                        ' error to avoid the creation of an invalid document.
   ofSkipOverprintedObj = &H10000000    ' Meaningful only if a color conversion flag is set. If set objects that would be rendered with enabled overprinting are left
                                        ' unchanged to avoid color errors on the page.
   ofRemoveBatesNumbers = &H20000000    ' Remove bates numbers if any. The type BatesN can also contain headers / footers.
   ofRemoveHeaderFooter = &H40000000    ' Remove headers / footers if any. This type is set if no bates numbering was added.
   ofIgnoreSeparationAll = &H80000000   ' Meaningful only if a color conversion flag is set. If set, Separation color spaces with the special colorant "All" will be ignored.
End Enum

Enum TOptimizeFlags2
   of2Default = &H0                     ' Nothing to do
   of2DeleteWatermarks = &H1            ' Delete watermark templates
   of2DeleteWatermarkAnnots = &H2       ' If set, watermark annotations will be deleted.
End Enum

Enum TOptimizeFlags3
   of3Default = &H0                     ' Nothing to do
End Enum

Enum TOptimizeFlags4
   of4Default = &H0                     ' Nothing to do
End Enum

Enum TPageLabelFormat
   plfDecimalArabic    ' 1,2,3,4...
   plfUppercaseRoman   ' I,II,III,IV...
   plfLowercaseRoman   ' i,ii,iii,iv...
   plfUppercaseLetters ' A,B,C,D...
   plfLowercaseLetters ' a,b,c,d...
   plfNone
End Enum

Enum TPageLayout
   plSinglePage
   plOneColumn
   plTwoColumnLeft
   plTwoColumnRight
   plTwoPageLeft
   plTwoPageRight
   plDefault        ' Use viewer's default settings
End Enum

Enum TPDFBarcodeType
   bctNotInitialized = &H0       ' No valid value
   bctAustraliaPost = &H3F       ' Australia Post Standard Customer
   bctAustraliaRedir = &H44      ' Australia Post Redirection
   bctAustraliaReply = &H42      ' Australia Post Reply Paid
   bctAustraliaRout = &H43       ' Australia Post Routing
   bctAztec = &H5C               ' Aztec Code
   bctAztecRunes = &H80          ' Aztec Runes
   bctC2Of5IATA = &H4            ' Code 2 of 5 IATA
   bctC2Of5Industrial = &H7      ' Code 2 of 5 Industrial
   bctC2Of5Interleaved = &H3     ' Interleaved 2 of 5
   bctC2Of5Logic = &H6           ' Code 2 of 5 Data Logic
   bctC2Of5Matrix = &H2          ' Standard Code 2 of 5
   bctChannelCode = &H8C         ' Channel Code
   bctCodabar = &H12             ' Codabar
   bctCodablockF = &H4A          ' Codablock-F
   bctCode11 = &H1               ' Code 11
   bctCode128 = &H14             ' Code 128 (automatic subset switching)
   bctCode128B = &H3C            ' Code 128 (Subset B)
   bctCode16K = &H17             ' Code 16K
   bctCode32 = &H81              ' Code 32
   bctCode39 = &H8               ' Code 3 of 9 (Code 39)
   bctCode49 = &H18              ' Code 49
   bctCode93 = &H19              ' Code 93
   bctCodeOne = &H8D             ' Code One
   bctDAFT = &H5D                ' DAFT Code
   bctDataBarOmniTrunc = &H1D    ' GS1 DataBar-14 Omnidirectional and truncated / RSS14
   bctDataBarExpStacked = &H51   ' GS1 DataBar Expanded Stacked
   bctDataBarExpanded = &H1F     ' GS1 DataBar Expanded / RSS_EXP
   bctDataBarLimited = &H1E      ' GS1 DataBar Limited  / RSS_LTD
   bctDataBarStacked = &H4F      ' GS1 DataBar-14 Stacked
   bctDataBarStackedO = &H50     ' GS1 DataBar-14 Stacked Omnidirectional
   bctDataMatrix = &H47          ' Data Matrix ECC200
   bctDotCode = &H73             ' DotCode
   bctDPD = &H60                 ' DPD code
   bctDPIdentCode = &H16         ' Deutsche Post Identcode
   bctDPLeitcode = &H15          ' Deutsche Post Leitcode
   bctEAN128 = &H10              ' GS1-128 (UCC.EAN-128)
   bctEAN128_CC = &H83           ' Composite Symbol with GS1-128 linear component
   bctEAN14 = &H48               ' EAN-14
   bctEANX = &HD                 ' EAN
   bctEANX_CC = &H82             ' Composite Symbol with EAN linear component
   bctEANXCheck = &HE            ' EAN + Check Digit
   bctExtCode39 = &H9            ' Extended Code 3 of 9 (Code 39+)
   bctFIM = &H31                 ' FIM
   bctFlattermarken = &H1C       ' Flattermarken
   bctHIBC_Aztec = &H70          ' HIBC Aztec Code
   bctHIBC_CodablockF = &H6E     ' HIBC Codablock-F
   bctHIBC_Code128 = &H62        ' HIBC Code 128
   bctHIBC_Code39 = &H63         ' HIBC Code 39
   bctHIBC_DataMatrix = &H66     ' HIBC Data Matrix ECC200
   bctHIBC_MicroPDF417 = &H6C    ' HIBC MicroPDF417
   bctHIBC_PDF417 = &H6A         ' HIBC PDF417
   bctHIBC_QR = &H68             ' HIBC QR Code
   bctISBNX = &H45               ' ISBN (EAN-13 with verification stage)
   bctITF14 = &H59               ' ITF-14
   bctJapanPost = &H4C           ' Japanese Postal Code
   bctKIX = &H5A                 ' Dutch Post KIX Code
   bctKoreaPost = &H4D           ' Korea Post
   bctLOGMARS = &H32             ' LOGMARS
   bctMailmark = &H79            ' Royal Mail 4-State Mailmark
   bctMaxicode = &H39            ' Maxicode
   bctMicroPDF417 = &H54         ' Micro PDF417
   bctMicroQR = &H61             ' Micro QR Code
   bctMSIPlessey = &H47          ' MSI Plessey
   bctNVE18 = &H4B               ' NVE-18
   bctPDF417 = &H37              ' PDF417
   bctPDF417Truncated = &H38     ' PDF417 Truncated
   bctPharmaOneTrack = &H33      ' Pharmacode One-Track
   bctPharmaTwoTrack = &H35      ' Pharmacode Two-Track
   bctPLANET = &H52              ' PLANET
   bctPlessey = &H56             ' Plessey
   bctPostNet = &H28             ' PostNet
   bctPZN = &H34                 ' PZN
   bctQRCode = &H3A              ' QR Code
   bctRMQR = &H91                ' Rectangular Micro QR Code (rMQR)
   bctRoyalMail4State = &H46     ' Royal Mail 4 State (RM4SCC)
   bctRSS_EXP_CC = &H86          ' Composite Symbol with GS1 DataBar Extended component
   bctRSS_EXPSTACK_CC = &H8B     ' Composite Symbol with GS1 DataBar Expanded Stacked component
   bctRSS_LTD_CC = &H85          ' Composite Symbol with GS1 DataBar Limited component
   bctRSS14_CC = &H84            ' Composite Symbol with GS1 DataBar-14 linear component
   bctRSS14Stacked_CC = &H89     ' Composite Symbol with GS1 DataBar-14 Stacked component
   bctRSS14StackOMNI_CC = &H8A   ' Composite Symbol with GS1 DataBar-14 Stacked Omnidirectional component
   bctTelepen = &H20             ' Telepen Alpha
   bctTelepenNumeric = &H57      ' Telepen Numeric
   bctUltracode = &H90           ' Ultracode
   bctUPCA = &H22                ' UPC A
   bctUPCA_CC = &H87             ' Composite Symbol with UPC A linear component
   bctUPCACheckDigit = &H23      ' UPC A + Check Digit
   bctUPCE = &H25                ' UCP E
   bctUPCE_CC = &H88             ' Composite Symbol with UPC E linear component
   bctUPCECheckDigit = &H26      ' UPC E + Check Digit
   bctUPNQR = &H8F               ' UPNQR (Univerzalni Placilni Nalog QR)
   bctUSPSOneCode = &H55         ' USPS OneCode
   bctVIN = &H49                 ' Vehicle Identification Number (America)
End Enum

Enum TPDFBarcodeDataType
   bcdtBinary = 0     ' Binary data.
   bcdtUnicode = 1    ' UTF-8.
   bcdtGS1Mode = 2    ' Encodes GS1 data using FNC1 characters.
   bcdtEscapeMode = 8 ' Scan input data for escape sequences. This is a flag that can be combined
                      ' with the other constants, e.g. bcdtUnicode Or bcdtEscapeMode.
End Enum

' The following flags can be combined with a binary or operator e.g. bcoNoASCII Or bcoDottyMode.
Enum TPDFBarcodeOptions
   bcoDefault = &H0                 ' Use default settings.
   bcoNoASCII = &H1                 ' Consider non-ASCII characters when creating the barcode.
   bcoBind = &H2                    ' Boundary bars above and below the symbol and between rows if stacking multiple symbols.
   bcoBox = &H4                     ' Add a box surrounding the symbol and whitespace.
   bcoReaderInit = &H10             ' Add a reader initialisation symbol to the data before encoding.
   bcoSmallText = &H20              ' Use a smaller font for human readable text.
   bcoBoldText = &H40               ' Embolden human readable text.
   bcoDottyMode = &H100             ' Plot a matrix symbol using dots rather than squares.
   bcoGS1_GS_Separator = &H200      ' Use GS instead FNC1 as GS1 separator.
   bcoImageOutput = &H1000000       ' Draw the barcode as an image. Images are usually larger than vectors and require more processing time.
   bcoUseActiveFont = &H2000000     ' Vector output only. If set text is output with the active font. Helvetica is used otherwise.
End Enum

' Structure to create a barcode on a page
Public Type TPDFBarcode2
   StructSize As Long              ' Must be set to sizeof(TPDFBarcode2).
   BarcodeType As TPDFBarcodeType  ' The type of barcode that should be created.
   BgColor As Long                 ' Background color -> Default NO_COLOR (transparent).
   BorderWidth As Long             ' Border width -> default 0.
   Data As String                  ' Data buffer.
   DataType As TPDFBarcodeDataType ' Data type and escape flag.
   DotSize As Single               ' Dotty mode only -> Default 4.0/5.0.
   Eci As Long                     ' Extended Channel Interpretation mode -> Default 0.
   FgColor As Long                 ' RGB Foreground color -> Default 0.
   FSizeFactor As Single           ' Font size correction factor -> Default 0.7. Considered in vector mode only.
   Option1 As Long                 ' Various, depends on barcode type. See help file for further information. -> Default -1.
   Option2 As Long                 ' Various, depends on barcode type. See help file for further information. -> Default 0.
   Option3 As Long                 ' Various, depends on barcode type. See help file for further information. -> Default 0.
   Options As TPDFBarcodeOptions   ' Output options.
   Orientation As Long             ' Supported values: 0, 90, -90, 180, -180, 270, -270.
   Primary As String               ' Composite codes only. Primary data message (max 127 bytes).
   Scale As Single                 ' Default 1.0.
   ShowText As Long                ' Show human readable text? Default true.
   SpaceWidth As Long              ' Whitespace width in pixels -> Default 0 (auto).
   SymbHeight As Long              ' Default 50.
   TextOffsetY As Single           ' Offset to correct the y-coordinate of human readable text -> Default 0.
   OuterBorder As TFltRect         ' Optional border around the scaled barcode measured in user space.
End Type

Enum TPDFFontFlags
   pffFixedPitch = &H1
   pffSerifs = &H2
   pffSymbolic = &H4
   pffScriptStyle = &H8
   pffReserved1 = &H10
   pffNonSymbolic = &H20
   pffItalic = &H40
   pffAllCap = &H10000
   pffSmallCap = &H20000
   pffForceBold = &H40000
End Enum

Enum TPDFMarkInfo
   miNotTagged = 0
   miTagged = 1
   miSuspects = 2
   miUserProperties = 4
End Enum

Enum TRenderingIntent
   riAbsoluteColorimetric
   riPerceptual
   riRelativeColorimetric
   riSaturation
   riNone
End Enum

Enum TRestrictions
   rsDenyNothing = 0&
   rsDenyAll = &HF3C&
   rsPrint = &H4&
   rsModify = &H8&
   rsCopyObj = &H10&
   rsAddObj = &H20&
   ' 128/256 bit encryption only -> these flags are ignored if 40 bit encryption is used
   rsFillInFormFields = &H100&
   rsExtractObj = &H200&
   rsAssemble = &H400&
   rsPrintHighRes = &H800&
   rsExlMetadata = &H1000&  ' PDF 1.5 Exclude metadata streams -> 128/256 bit encryption bit only.
   rsEmbFilesOnly = &H2000& ' PDF 1.6 Encrypt embedded files only -> Requires AES encryption.
End Enum

Enum TRubberStamp
  rsApproved
  rsAsIs
  rsConfidential
  rsDepartmental
  rsDraft
  rsExperimental
  rsExpired
  rsFinal
  rsForComment
  rsForPublicRelease
  rsNotApproved
  rsNotForPublicRelease
  rsSold
  rsTopSecret
  rsUserDefined
End Enum

Public Enum TPDFColSplitInfo
   spiNone       ' Do not display a splitter
   spiHorizontal ' Display a horizontal splitter
   spiVertical   ' Display a vertical splitter
End Enum

Enum TSubmitFlags
   sfNone = &H0
   sfExlude = &H1                  ' if set, the fields in a sumbmit or reset form action are excluded
   sfInclNoValFields = &H2
   sfHTML = &H4
   sfGetMethod = &H8
   sfSubmCoords = &H10
   sfXML = &H24
   sfInclAppSaves = &H40
   sfInclAnnots = &H80
   sfPDF = &H100
   sfCanonicalFormat = &H200
   sfExlNonUserAnnots = &H400
   sfExlFKey = &H800
   sfEmbedForm = &H2000 ' PDF 1.5 embed the entire form into a file stream inside the FDF file -> requires the full version of Adobe's Acrobat
End Enum

Enum TTextAlign
   taLeft = 0
   taCenter = 1
   taRight = 2
   taJustify = 3
   taPlainText = &H10000000  ' If this flag is set alignment and command tags are interpreted as plain text.
                             ' See WriteFText() in the help file for further information.
End Enum

Enum TUnicodeRange1
   urBasicLatin = &H1                         ' 0000-007F
   urLatin1Supplement = &H2                   ' 0080-00FF
   urLatinExtendedA = &H4                     ' 0100-017F
   urLatinExtendedB = &H8                     ' 0180-024F
   urIPAExtensions = &H10                     ' 0250-02AF, 1D00-1D7F, 1D80-1DBF
   urSpacingModifierLetters = &H20            ' 02B0-02FF, A700-A71F
   urCombiningDiacriticalMarks = &H40         ' 0300-036F, 1DC0-1DFF
   urGreekandCoptic = &H80                    ' 0370-03FF
   urCoptic = &H100                           ' 2C80-2CFF
   urCyrillic = &H200                         ' 0400-04FF, 0500-052F, 2DE0-2DFF, A640-A69F
   urArmenian = &H400                         ' 0530-058F
   urHebrew = &H800                           ' 0590-05FF
   urVai = &H1000&                            ' A500-A63F
   urArabic = &H2000                          ' 0600-06FF, 0750-077F
   urNKo = &H4000                             ' 07C0-07FF
   urDevanagari = &H8000&                     ' 0900-097F
   urBengali = &H10000                        ' 0980-09FF
   urGurmukhi = &H20000                       ' 0A00-0A7F
   urGujarati = &H40000                       ' 0A80-0AFF
   urOriya = &H80000                          ' 0B00-0B7F
   urTamil = &H100000                         ' 0B80-0BFF
   urTelugu = &H200000                        ' 0C00-0C7F
   urKannada = &H400000                       ' 0C80-0CFF
   urMalayalam = &H800000                     ' 0D00-0D7F
   urThai = &H1000000                         ' 0E00-0E7F
   urLao = &H2000000                          ' 0E80-0EFF
   urGeorgian = &H4000000                     ' 10A0-10FF, 2D00-2D2F
   urBalinese = &H8000000                     ' 1B00-1B7F
   urHangulJamo = &H10000000                  ' 1100-11FF
   urLatinExtendedAdditional = &H20000000     ' 1E00-1EFF, 2C60-2C7F, A720-A7FF
   urGreekExtended = &H40000000               ' 1F00-1FFF
   urGeneralPunctuation = &H80000000          ' 2000-206F, 2E00-2E7F
End Enum

Enum TUnicodeRange2
   urSuperscriptsAndSubscripts = &H1          ' 2070-209F
   urCurrencySymbols = &H2                    ' 20A0-20CF
   urCombDiacritMarksForSymbols = &H4         ' 20D0-20FF
   urLetterlikeSymbols = &H8                  ' 2100-214F
   urNumberForms = &H10                       ' 2150-218F
   urArrows = &H20                            ' 2190-21FF, 27F0-27FF, 2900-297F, 2B00-2BFF
   urMathematicalOperators = &H40             ' 2200-22FF, 2A00-2AFF, 27C0-27EF, 2980-29FF
   urMiscellaneousTechnical = &H80            ' 2300-23FF
   urControlPictures = &H100                  ' 2400-243F
   urOpticalCharacterRecognition = &H200      ' 2440-245F
   urEnclosedAlphanumerics = &H400            ' 2460-24FF
   urBoxDrawing = &H800                       ' 2500-257F
   urBlockElements = &H1000&                  ' 2580-259F
   urGeometricShapes = &H2000                 ' 25A0-25FF
   urMiscellaneousSymbols = &H4000            ' 2600-26FF
   urDingbats = &H8000&                       ' 2700-27BF
   urCJKSymbolsAndPunctuation = &H10000       ' 3000-303F
   urHiragana = &H20000                       ' 3040-309F
   urKatakana = &H40000                       ' 30A0-30FF, 31F0-31FF
   urBopomofo = &H80000                       ' 3100-312F, 31A0-31BF
   urHangulCompatibilityJamo = &H100000       ' 3130-318F
   urPhagsPa = &H200000                       ' A840-A87F
   urEnclosedCJKLettersAndMonths = &H400000   ' 3200-32FF
   urCJKCompatibility = &H800000              ' 3300-33FF
   urHangulSyllables = &H1000000              ' AC00-D7AF
   urNonPlane0 = &H2000000                    ' D800-DFFF
   urPhoenician = &H4000000                   ' 10900-1091F
   urCJKUnifiedIdeographs = &H8000000         ' 4E00-9FFF, 2E80-2EFF, 2F00-2FDF, 2FF0-2FFF, 3400-4DBF, 20000-2A6DF, 3190-319F
   urPrivateUseAreaPlane0 = &H10000000        ' E000-F8FF
   urCJKStrokes = &H20000000                  ' 31C0-31EF, F900-FAFF, 2F800-2FA1F
   urAlphabeticPresentationForms = &H40000000 ' FB00-FB4F
   urArabicPresentationFormsA = &H80000000    ' FB50-FDFF
End Enum

Enum TUnicodeRange3
   urCombiningHalfMarks = &H1                 ' FE20-FE2F
   urVerticalForms = &H2                      ' FE10-FE1F, FE30-FE4F
   urSmallFormVariants = &H4                  ' FE50-FE6F
   urArabicPresentationFormsB = &H8           ' FE70-FEFF
   urHalfwidthAndFullwidthForms = &H10        ' FF00-FFEF
   urSpecials = &H20                          ' FFF0-FFFF
   urTibetan = &H40                           ' 0F00-0FFF
   urSyriac = &H80                            ' 0700-074F
   urThaana = &H100                           ' 0780-07BF
   urSinhala = &H200                          ' 0D80-0DFF
   urMyanmar = &H400                          ' 1000-109F
   urEthiopic = &H800                         ' 1200-137F, 1380-139F, 2D80-2DDF
   urCherokee = &H1000&                       ' 13A0-13FF
   urUnifiedCanadianAboriginal = &H2000       ' 1400-167F
   urOgham = &H4000                           ' 1680-169F
   urRunic = &H8000&                          ' 16A0-16FF
   urKhmer = &H10000                          ' 1780-17FF, 19E0-19FF
   urMongolian = &H20000                      ' 1800-18AF
   urBraillePatterns = &H40000                ' 2800-28FF
   urYiSyllables = &H80000                    ' A000-A48F, A490-A4CF
   urTagalog = &H100000                       ' 1700-171F, 1720-173F, 1740-175F, 1760-177F
   urOldItalic = &H200000                     ' 10300-1032F
   urGothic = &H400000                        ' 10330-1034F
   urDeseret = &H800000                       ' 10400-1044F
   urMusicalSymbols = &H1000000               ' 1D000-1D0FF, 1D100-1D1FF, 1D200-1D24F
   urMathematicalAlphanumeric = &H2000000     ' 1D400-1D7FF
   urPrivateUsePlane15 = &H4000000            ' FF000-FFFFD, 100000-10FFFD
   urVariationSelectors = &H8000000           ' FE00-FE0F, E0100-E01EF
   urTags = &H10000000                        ' E0000-E007F
   urLimbu = &H20000000                       ' 1900-194F
   urTaiLe = &H40000000                       ' 1950-197F
   urNewTaiLue = &H80000000                   ' 1980-19DF
End Enum

Enum TUnicodeRange4
   urBuginese = &H1                           ' 1A00-1A1F
   urGlagolitic = &H2                         ' 2C00-2C5F
   urTifinagh = &H4                           ' 2D30-2D7F
   urYijingHexagramSymbols = &H8              ' 4DC0-4DFF
   urSylotiNagri = &H10                       ' A800-A82F
   urLinearBSyllabary = &H20                  ' 10000-1007F, 10080-100FF, 10100-1013F
   urAncientGreekNumbers = &H40               ' 10140-1018F
   urUgaritic = &H80                          ' 10380-1039F
   urOldPersian = &H100                       ' 103A0-103DF
   urShavian = &H200                          ' 10450-1047F
   urOsmanya = &H400                          ' 10480-104AF
   urCypriotSyllabary = &H800                 ' 10800-1083F
   urKharoshthi = &H1000&                     ' 10A00-10A5F
   urTaiXuanJingSymbols = &H2000              ' 1D300-1D35F
   urCuneiform = &H4000                       ' 12000-123FF, 12400-1247F
   urCountingRodNumerals = &H8000&            ' 1D360-1D37F
   urSundanese = &H10000                      ' 1B80-1BBF
   urLepcha = &H20000                         ' 1C00-1C4F
   urOlChiki = &H40000                        ' 1C50-1C7F
   urSaurashtra = &H80000                     ' A880-A8DF
   urKayahLi = &H100000                       ' A900-A92F
   urRejang = &H200000                        ' A930-A95F
   urCham = &H400000                          ' AA00-AA5F
   urAncientSymbols = &H800000                ' 10190-101CF
   urPhaistosDisc = &H1000000                 ' 101D0-101FF
   urCarian = &H2000000                       ' 102A0-102DF, 10280-1029F, 10920-1093F
   urDominoTiles = &H4000000                  ' 1F030-1F09F, 1F000-1F02F
End Enum

Public Type TCTM
   a As Double
   b As Double
   C As Double
   d As Double
   X As Double
   Y As Double
End Type

Public Type TFRect
   MinX As Integer
   MinY As Integer
   MaxX As Integer
   MaxY As Integer
End Type


Private Type TTextRecordA
   Advance As Single ' Negative values move the cursor to right, positive to left. The value is measured in text space!
   Text As Long      ' Source string (not null-terminated)
   Length As Long    ' Length in characters
End Type

Public Type TTextRecordW
   Advance As Single ' Negative values move the cursor to right, positive to left. The value is measured in text space!
   Text As String    ' Already translated Unicode string (not null-terminated)
   Width As Single   ' String width measured in text space
End Type

Public Type TPDFRect
   rLeft As Double
   rBottom As Double
   rRight As Double
   rTop As Double
End Type

Public Type TOptimizeParams
   ExcludeCS() As Long                 ' Optional array of color space handles which should be excluded from color conversion.

   Flags2 As TOptimizeFlags2           ' Additional optimization flags
   Flags3 As TOptimizeFlags3           ' Additional optimization flags
   Flags4 As TOptimizeFlags4           ' Additional optimization flags

   Min1BitRes As Long                  ' Minimum resolution before scaling.
   MinGrayRes As Long                  ' Minimum resolution before scaling.
   MinColorRes As Long                 ' Minimum resolution before scaling.

   Res1BitImages As Long               ' 1 bit black & white images.
   ResGrayImages As Long               ' Gray images.
   ResColorImages As Long              ' Multi-channel images.

   Filter1Bit As TCompressionFilter    ' Filter for black & white images.
   FilterGray As TCompressionFilter    ' Filter for gray images.
   FilterColor As TCompressionFilter   ' Filter for multi-channel images.
   JPEGQuality As Long                 ' JPEG quality.
   JP2KQuality As Long                 ' JPEG 2000 quality.
   MinLineWidth As Single              ' Zero means no hair line removal.
End Type

Public Type TOptimizeParams_I
   StructSize As Long                  ' Must be set to sizeof(TOptimizeParams).

   Min1BitRes As Long                  ' Minimum resolution before scaling.
   MinGrayRes As Long                  ' Minimum resolution before scaling.
   MinColorRes As Long                 ' Minimum resolution before scaling.

   Res1BitImages As Long               ' 1 bit black & white images.
   ResGrayImages As Long               ' Gray images.
   ResColorImages As Long              ' Multi-channel images.

   Filter1Bit As TCompressionFilter    ' Filter for black & white images.
   FilterGray As TCompressionFilter    ' Filter for gray images.
   FilterColor As TCompressionFilter   ' Filter for multi-channel images.
   JPEGQuality As Long                 ' JPEG quality.
   JP2KQuality As Long                 ' JPEG 2000 quality.
   MinLineWidth As Single              ' Zero means no hair line removal.
   ExcludeCS As Long                   ' Array of color space handles which should be excluded from color conversion.
   ExcludeCSCount As Long              ' Number of color space handles in the array.
   Flags2 As TOptimizeFlags2
   Flags3 As TOptimizeFlags3
   Flags4 As TOptimizeFlags4
End Type

Public Type TPDFAnnotation
   AnnotType As TAnnotType
   Deleted As Boolean
   BBox As TPDFRect
   BorderWidth As Double
   BorderColor As Long
   BorderStyle As TBorderStyle
   BackColor As Long
   Handle As Long
   Author As String
   Content As String
   Name As String
   Subject As String
   PageNum  As Long
   HighlightMode As THighlightMode
End Type

Public Type TPDFAnnotationEx
   AnnotType As TAnnotType
   Deleted As Boolean
   BBox As TPDFRect
   BorderWidth As Single
   BorderColor As Long
   BorderStyle As TBorderStyle
   BackColor As Long
   Handle As Long
   Author As String
   Content As String
   Name As String
   Subject As String
   PageNum As Long
   HighlightMode As THighlightMode
   ' Page link annotations only
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
   DestFile As String       ' File link or web link annotations
   Icon As Long             ' The Icon type depends on the annotation type. If the annotation type is atText then the Icon
                            ' is of type TAnnotIcon. If the annotation type is atFileAttach then it is of type
                            ' TFileAttachIcon. If the annotation type is atStamp then the Icon is the stamp type (TRubberStamp).
                            ' For any other annotation type this value is not set (-1).
   StampName As String      ' Set only, if Icon == rsUserDefined
   AnnotFlags As Long       ' See TAnnotFlags for available flags
   CreateDate As String     ' Creation Date -> Optional
   ModDate As String        ' Modification Date -> Optional
   Grouped As Boolean       ' (Reply type) Meaningful only if Parent != -1 and Type != atPopUp. If true,
                            ' the annotation is part of an annotation group. Properties like Content, CreateDate,
                            ' ModDate, BackColor, Subject, and Open must be taken from the parent annotation.
   Open As Boolean          ' Meaningful only for annotations which have a corresponding PopUp annotation.
   Parent As Long           ' Parent annotation handle of a PopUp Annotation or the parent annotation if
                            ' this annotation represents a state of a base annotation. In this case,
                            ' the annotation type is always atText and only the following members should
                            ' be considered:
                            '    State      // The current state
                            '    StateModel // Marked, Review, and so on
                            '    CreateDate // Creation Date
                            '    ModDate    // Modification Date
                            '    Author     // The user who has set the state
                            '    Content    // Not displayed in Adobe's Acrobat...
                            '    Subject    // Not displayed in Adobe's Acrobat...
                            ' The PopUp annotation of a text annotation which represent an Annotation State
                            ' must be ignored.
   PopUp As Long            ' Handle of the corresponding PopUp annotation if any.
   State As String          ' The state of the annotation.
   StateModel As String     ' The state model (Marked, Review, and so on).
   EmbeddedFile As Long     ' FileAttach annotations only. A handle of an embedded file -> GetEmbeddedFile().
   Subtype As String        ' Set only, if Type = atUnknownAnnot
   PageIndex As Long        ' Array index to change the tab order, see SortFieldsByIndex().
   MarkupAnnot As Boolean   ' If true, the annotation is a markup annotation. Markup annotations can be flattened
                            ' separately, see FlattenAnnots().
   Opacity As Single        ' Opacity = 1.0 = Opaque, Opacity < 1.0 = Transparent, Markup annotations only
   QuadPoints() As Single   ' Highlight, Link, and Redact annotations only

   DashPattern() As Single  ' Only present if BorderStyle == bsDashed

   Intent As String         ' Markup annotations only. The intent allows to distinguish between different uses of an annotation.
                            ' For example, line annotations have two intents: LineArrow and LineDimension.
   LE1 As TLineEndStyle     ' Line end style of the start point -> Line and PolyLine annotations only
   LE2 As TLineEndStyle     ' Line end style of the end point -> Line and PolyLine annotations only
   Vertices() As Single     ' Line, PolyLine, and Polygon annotations only. This array contains the raw number of floating point values.
                            ' Since a vertice requires always two coordinate pairs, the number of vertices
                            ' or points is VerticeCount divided by 2.

   ' Line annotations only. These properties should only be considered if the member Intent is set to the string LineDimension.
   Caption As Boolean            ' If true, the annotation string Content is used as caption.
   CaptionOffsetX As Single      ' Horizontal offset of the caption from its normal position
   CaptionOffsetY As Single      ' Vertical offset of the caption from its normal position
   CaptionPos As TLineCaptionPos ' The position where the caption should be drawn if present
   LeaderLineLen As Single       ' Length of the leader lines (positive or negative)
   LeaderLineExtend As Single    ' Optional leader line extend beyond the leader line (must be a positive value or zero)
   LeaderLineOffset As Single    ' Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)

   BorderEffect As TBorderEffect ' Circle, Square, FreeText, and Polygon annotations.
   InkList() As Long             ' Ink annotations only. Array of array. The sub arrays can be accessed with GetInkList().
   RichStyle As String           ' Optional default style string.      -> FreeText annotations only.
   RichText As String            ' Optional rich text string (RC key). -> Markup annotations only.
   OC As Long                    ' Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   RD() As Single                ' Caret, Circle, Square, and FreeText annotations.
   Rotate As Long                ' Caret annotations only. Must be zero or a multiple of 90. This key is not documented in the specs.
End Type

Public Type TBookmark
   Color As Long
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
   DoOpen As Boolean
   Parent As Long
   Style As TBmkStyle
   Title As String
End Type

Public Type TPDFBarcode
   Caption As String      ' Optional
   ECC As Single          ' 0..8 for PDF417, or 0..3 for QRCode
   Height As Single       ' Height in inches
   nCodeWordCol As Single ' Required for PDF417. The number of codewords per barcode coloumn.
   nCodeWordRow As Single ' Required for PDF417. The number of codewords per barcode row.
   Resolution As Long  ' Required -> Should be 300
   Symbology As String    ' PDF417, QRCode, or DataMatrix.
   Version As Single      ' Should be 1
   Width As Single        ' Width in inches
   XSymHeight As Single   ' Only needed for PDF417. The vertical distance between two barcode modules,
                          ' measured in pixels. The ratio XSymHeight/XSymWidth shall be an integer
                          ' value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode
                          ' and DataMatrix, this ratio shall always be 1.
   XSymWidth As Single    ' Required -> The horizontal distance, in pixels, between two barcode modules.
End Type

Public Type TPDFBitmap
   StructSize As Long ' Must be set to sizeof(TPDFBitmap)
   Buffer As Long     ' Image buffer
   BufSize As Long    ' Buffer size in bytes
   DestX As Long      ' Destination x-coordinate on the main image (the rendered page)
   DestY As Long      ' Destination y-coordinate on the main image (the rendered page)
   Height As Long     ' Image height in pixels
   Stride As Long     ' Scanline length in bytes
   Width As Long      ' Image width
End Type

Public Type TPDFBookmark
   Action As Long        ' Action handle or -1 if not set.
   Color As Long         ' Optional text color. Black is the default value (0).
   DestPage As Long      ' Destination page.
   DestPos As TPDFRect   ' Destination position.
   DestType As TDestType ' Destination type.
   NamedDest As String   ' Optional name of a named destination.
   DoOpen As Boolean      ' If true, child nodes should be visible.
   Parent As Long        ' The immediate parent node or -1 for a root node.
   StructElem As Long    ' Bookmarks can contain a reference to a structure element. There is no API to access structure elements yet.
   Style As TBmkStyle    ' The font style that should be used to render this node.
   Title As String       ' The bookmark title.
End Type

Public Type TPDFBookmark_I
   StructSize As Long    ' Must be set to sizeof(TPDFBookmark_I)
   Action As Long        ' Action handle or -1 if not set.
   Color As Long         ' Optional text color. Black is the default value (0).
   DestPage As Long      ' Destination page.
   DestPos As TPDFRect   ' Destination position.
   DestType As TDestType ' Destination type.
   NamedDestA As Long    ' Optional name of a named destination. If set, DestPage, DestPos, and DestType were already taken from the destination if it was found.
   NamedDestW As Long    ' Either the Unicode or Ansi string is set but never both.
   DoOpen As Long        ' If true, child nodes should be visible.
   Parent As Long        ' The immediate parent node or -1 for a root node.
   StructElem As Long    ' Bookmarks can contain a reference to a structure element. There is no API to access structure elements yet.
   Style As TBmkStyle    ' The font style that should be used to render this node.
   TitleA As Long        ' The bookmark title.
   TitleW As Long        ' Either the Unicode or Ansi string is set but never both.
   TitleLen As Long      ' String length in characters.
End Type

Public Type TPDFChoiceValue
   ExpValue As String
   Value As String
   Selected As Boolean
End Type

Public Type TPDFCMap
   StructSize As Long       ' Must be set to sizeof(TPDFCMap) before calling GetCMap()!
   BaseCMap As String       ' If set, this base cmap is required when loading the cmap.
   CIDCount As Long         ' 0 if not set.
   CMapName As String       ' The CMap name.
   CMapType As Long         ' Should be 1!
   CMapVersion As Single    ' The CMap version.
   DSCBaseCMap As String    ' DSC comment.
   DSCCMapVersion As Single ' DSC comment.
   DSCResName As String     ' DSC comment. If the CMap uses an Identity mapping this string should be set to Identity.
   DSCTitle As String       ' DSC comment -> DSC CMap name + Registry + Ordering + Supplement, e.g. "GB-EUC-H Adobe GB1 0"
   FileName As String       ' The file name and CMap name should be identical!
   FilePath As String       ' Path to the CMap file.
   Ordering As String       ' CIDSystemInfo -> The Character Collection, e.g. Japan1.
   Registry As String       ' CIDSystemInfo -> The registrant of the Character Collection is usually Adobe.
   Supplement As Long       ' CIDSystemInfo -> The Supplement number should be supported in the used PDF Version.
   WritingMode As Long      ' 0 == Horizontal, 1 == Vertical
End Type

Public Type TPDFCollectionInfo
   InitalFile As Integer          ' Possible values are -2, -1, or a valid embedded files handle (a value greater or equal zero). See help file for further information.
   InitalView As TColView         ' Determines how embedded files should be displayed.
   SortBy     As String           ' Optional name of the first field that should be used to sort the list of embedded files.
   SortDesc   As Boolean          ' If true, the list of embedded files should be sorted in descending order.
   SplitInfo  As TPDFColSplitInfo ' Determines whether a splitter bar should be displayed.
   SplitPos   As Single           ' Meaningful only, if SplitInfo is not spiNone. The initial position of the splitter bar,
                                  ' specified as a percentage of the available window area (0 to 100).
End Type

Public Type TPDFCollectionInfo_I
   StructSize As Integer          ' Must be set to sizeof(TPDFColectionInfo_I)
   InitalFile As Integer          ' Possible values are -2, -1, or a valid embedded files handle (a value greater or equal zero). See help file for further information.
   InitalView As TColView         ' Determines how embedded files should be displayed.
   SortBy     As Long             ' Optional name of the first field that should be used to sort the list of embedded files.
   SortDesc   As Long             ' If true, the list of embedded files should be sorted in descending order.
   SplitInfo  As TPDFColSplitInfo ' Determines whether a splitter bar should be displayed.
   SplitPos   As Single           ' Meaningful only, if SplitInfo is not spiNone. The initial position of the splitter bar,
                                  ' specified as a percentage of the available window area (0 to 100).
End Type

Public Type TPDFColorSpaceObj
   ColorSpaceType As TExtColorSpace
   Alternate As TExtColorSpace      ' Alternate color space or base space of an Indexed or Pattern color space.
   IAlternate As Long               ' Only set if the color space contains an alternate or base color space -> GetColorSpaceObjEx().
   Buffer As Long                   ' Contains either an ICC profile or the color table of an Indexed color space.
   BufSize As Long                  ' Buffer length in bytes.
   BlackPoint() As Single           ' CIE blackpoint. If set, the array contains exactly 3 values.
   WhitePoint() As Single           ' CIE whitepoint. If set, the array contains exactly 3 values.
   Gamma() As Single                ' If set, one value per component.
   Range() As Single                ' The allowed range of input values (min/max for each component).
   Matrix() As Single               ' XYZ matrix. If set, the array contains exactly 9 values.
   NumInComponents As Long          ' Number of input components.
   NumOutComponents As Long         ' Number of output components.
   NumColors As Long                ' HiVal + 1 as specified in the color space. Indexed color space only.
   Colorants(31) As String          ' Colorant names (Separation, DeviceN, and NChannel only).
   ColorantsCount As Long           ' The number of colorants in the array.
   Metadata As Long                 ' Optional XMP metadata stream -> ICCBased only.
   MetadataSize As Long             ' Metadata length in bytes.
   IFunction As Long                ' Pointer to function object -> Separation, DeviceN, and NChannel only.
   IAttributes As Long              ' Optional attributes of DeviceN or NChannel color spaces -> GetNChannelAttributes().
   IColorSpaceObj As Long           ' Pointer of the corresponding color space object
   Handle As Long                   ' Handle of the color space object or -1 if an internal color space object was returned by ParseContent(), for example.
End Type

Public Type TDeviceNAttributes
   IProcessColorSpace As Long    ' Pointer to process color space or NULL -> GetColorSpaceEx().
   ProcessColorants(7) As String ' Does a process color space with more than 8 components exist? 6 components
                                 ' is the maximum so far I know. However, 8 components should be large enough for
                                 ' the next years...
   ProcessColorantsCount As Long ' Number of process colorants in the array or zero if not set.
   Separations(31) As Long       ' Optional pointers to Separation color spaces -> GetColorSpaceEx().
   SeparationsCount As Long      ' Number of color spaces in the array.
   IMixingHints As Long          ' Optional mixing hints. There is no API function at this time to access mixing hints.
End Type

Public Type TPDFEncryptInfo
   StructSize As Long            ' Must be set to sizeof(TPDFEncryptInfo)
   Filter As TKeyLen             ' Encryption filter
   HaveOpenPassword As Long      ' If true, an open password was set.
   HaveOwnerPassword As Long     ' If true, an owner password was set. This should always be true!
   Restrictions As TRestrictions ' What must be restricted? No additional call of GetInEncryptionFlags() required.
   UnsafeOpenPwd As Long         ' If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
   UnsafeOwnerPwd As Long        ' If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
End Type

Public Type TPDFError
   Message As String  ' The error message
   ObjNum As Long     ' -1 if not available
   Offset As Long     ' -1 if not available
   SrcFile As String  ' Source file
   SrcLine As Long    ' Source line
   ErrCode As Long    ' ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
   ErrType As Long    ' ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
End Type

' It is not possible to set all available graphic state parameters with DynaPDF, such as black generation functions,
' halftones and so on. The structure will be extended when further objects are supported.
Public Type TPDFExtGState
   AutoStrokeAdjust As Long            ' PDF_MAX_INT if not set
   BlendMode As TBlendMode             ' Default bmNotSet
   FlatnessTol As Single               ' -1.0 if not set
   OverPrintFill As Long               ' PDF_MAX_INT if not set
   OverPrintStroke As Long             ' PDF_MAX_INT if not set
   OverPrintMode As Long               ' PDF_MAX_INT if not set
   RenderingIntent As TRenderingIntent ' riNone if not set
   SmoothnessTol As Single             ' -1.0 if not set
   FillAlpha As Single                 ' -1.0 if not set
   StrokeAlpha As Single               ' -1.0 if not set
   AlphaIsShape As Long                ' PDF_MAX_INT if not set
   TextKnockout As Long                ' PDF_MAX_INT if not set
   SoftMaskNone As Long                ' Can be set to true to disable the active soft mask
   SoftMask As Long                    ' Soft mask pointer or NULL. See CreateSoftMask() for further information.
   Reserved1 As Long
   Reserved2 As Long
   Reserved3 As Long
   Reserved4 As Long
   Reserved5 As Long
   Reserved6 As Long
   Reserved7 As Long
End Type

Public Type TPDFField
   BBox As TPDFRect
   FieldType As TFieldType
   Deleted As Boolean
   Handle As Long
   FieldName As String
   BackCS As TPDFColorSpace
   TextCS As TPDFColorSpace
   BackColor As Long
   BorderColor As Long
   TextColor As Long
   Checked As Boolean
   Parent As Long
   KidCount As Long
   FontName As String
   FontSize As Double
   Value As String
   ToolTip As String
End Type

Public Type TPDFFieldEx
   Deleted As Boolean              ' If true, the field was marked as deleted by DeleteField()
   BBox As TPDFRect                ' Bounding box of the field in bottom-up coordinates
   FieldType As TFieldType         ' Field type
   GroupType As TFieldType         ' If GroupType != FieldType the field is a terminal field of a field group
   Handle As Long                  ' Field handle
   BackColor As Long               ' Background color
   BackColorSP As TExtColorSpace   ' Color space of the background color
   BorderColor As Long             ' Border color
   BorderColorSP As TExtColorSpace ' Color space of the border color
   BorderStyle As TBorderStyle     ' Border style
   BorderWidth As Single           ' Border width
   CharSpacing As Single           ' Text fields only
   Checked As Boolean              ' Check boxes only
   CheckBoxChar As Long            ' ZapfDingbats character that is used to display the on state
   DefState As TCheckBoxState      ' Check boxes only
   DefValue As String              ' Optional default value
   IEditFont As Long               ' Pointer to default editing font
   EditFont As String              ' Postscript name of the editing font
   ExpValCount As Long             ' Combo and list boxes only. The values can be accessed with GetFieldExpValueEx()
   ExpValue As String              ' Check boxes only
   FieldFlags As TFieldFlags       ' Field flags
   IFieldFont As Long              ' Pointer to the font that is used by the field
   FieldFont As String             ' Postscript name of the font
   FontSize As Double              ' Font size. 0.0 means auto font size
   FieldName As String             ' Note that children of a field group or radio button have no name
   HighlightMode As THighlightMode ' Highlight mode
   IsCalcField As Boolean          ' If true, the OnCalc event of the field is connected with a JavaScript action
   MapName As String               ' Optional unique mapping name of the field
   MaxLen As Long                  ' Text fields only -> zero means not restricted
   Kids() As Long                  ' Array of child fields -> GetFieldEx2()
   KidCount As Long                ' Number of pointers in the array
   Parent As Long                  ' Pointer to parent field or NULL
   PageNum As Long                 ' Page on which the field is used or -1
   Rotate As Long                  ' Rotation angle in degrees
   TextAlign As TTextAlign         ' Text fields only
   TextColor As Long               ' Text color
   TextColorSP As TExtColorSpace   ' Color space of the field's text
   TextScaling As Single           ' Text fields only
   ToolTip As String               ' Optional tool tip
   UniqueName As String            ' Optional unique name (NM key)
   Value As String                 ' Field value
   WordSpacing As Single           ' Text fields only
   PageIndex As Long               ' Array index to change the tab order, see SortFieldsByIndex().
   IBarcode As Long                ' If present, this field is a barcode field. The field type is set to ftText
                                   ' since barcode fields are extended text fields. -> GetBarcodeDict().
   ISignature As Long              ' Signature fields only. Present only for imported signature fields which
                                   ' which have a value. That means the file was digitally signed. -> GetSigDict().
                                   ' Signed signature fields are always marked as deleted!
   ModDate As String               ' Last modification date (optional)

   ' Push buttons only. The down and roll over states are optional. If not present, then all states use the up state.
   ' The handles of the up, down, and roll over states are template handles! The templates can be opened for editing
   ' with EditTemplate2() and parsed with ParseContent().
   CaptionPos As TBtnCaptionPos    ' Where to position the caption relative to its image
   DownCaption As String           ' Caption of the down state
   DownImage As Long               ' Image of the down state
   RollCaption As String           ' Caption of the roll over state
   RollImage As Long               ' Image of the roll over state
   UpCaption As String             ' Caption of the up state
   UpImage As Long                 ' Image of the up state -> if > -1, the button is an image button
   OC As Long                      ' Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   Action As Long                  ' Action handle or -1 if not set. This action is executed when the field is activated.
   ActionType As TActionType       ' Meaningful only, if Action >= 0.
   Events As Long                  ' See GetObjEvent() if set.
   FmtTextColor As Long            ' Zero if not set. Usually RGB red otherwise.
   FmtText As String               ' Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
End Type

Public Type TPDFFileSpec
   Buffer() As Byte       ' Buffer of an embedded file
   BufSize As Long        ' Buffer size in bytes.
   Compressed As Boolean  ' Should be false if Decompress was true in the GetEmbeddedFile() call, otherwise usually true.
                          ' DynaPDF decompresses Flate encoded streams only. Other filters can occur but this is very unusual.
   ColItem As Long        ' If != NULL the embedded file contains a collection item with user defined data. This entry
                          ' can occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further
                          ' information.
   Name As String         ' Name of the file specification in the name tree. This value is always present.
   FileName As String     ' File name as 7 bit ASCII string.
   IsURL As Boolean       ' If true, FileName contains a URL.
   UF As String           ' PDF 1.7. Same as FileName but Unicode is allowed.
   Desc As String         ' Description
   FileSize As Long       ' Size of the decompressed stream or zero if not known. Note: this is either the Size key of
                          ' the Params dictionary if present or the DL key in the file stream. Whether this value is
                          ' correct depends on the file creator! The parameter is definitely correct if the file was
                          ' decompressed.
   MIMEType As String     ' MIME media type name as defined in Internet RFC 2046.
   CreateDate As String   ' Creation date as string. See help file "The standard date format".
   ModDate As String      ' Modification date as string. See help file "The standard date format".
   CheckSum() As Byte     ' 16 byte MD5 digest. Note that this is a binary string. It is exactly 16 bytes long if set!
End Type

Public Type TPDFFileSpecEx
   AFRelationship As String ' PDF 2.0
   ColItem As Long          ' If != NULL the embedded file contains a collection item with user defined data. This entry can
                            ' occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further information.
   Description As String    ' Optional description string.
   DOS As String            ' Optional DOS file name.
   EmbFileNode As Long      ' GetEmbeddedFileNode().
   FileName As String       ' File name as 7 bit ASCII string.
   FileNameIsURL As Boolean ' If true, FileName contains a URL.
   ID1() As Byte            ' Optional file ID. Meaningful only if FileName points to a PDF file.
   ID2() As Byte            ' Optional file ID. Meaningful only if FileName points to a PDF file.
   IsVolatile As Boolean    ' If true, the file changes frequently with time.
   Mac As String            ' Optional Mac file name.
   Unix As String           ' Optional Unix file name.
   RelFileNode As Long      ' Optional related files array. -> GetRelFileNode().
   Thumb As Long            ' Optional thumb nail image. -> GetImageObjEx().
   UFileName As String      ' PDF 1.7. Same as FileName but Unicode is allowed.
End Type

Public Type TPDFEmbFileNode
   Name As String     ' UTF-8 encoded name. This key contains usually a 7 bit ASCII string.
   EF As TPDFFileSpec ' Embedded file.
   NextNode As Long   ' Next node if any.
End Type

Public Type TPDFFontInfo
   Ascent As Single                 ' Ascent (optional).
   AvgWidth As Single               ' Average character width (optional).
   BaseEncoding As TBaseEncoding    ' Valid only if HaveEncoding is true.
   BaseFont As String               ' PostScript Name or Family Name.
   BaseFontW As String              ' BaseFont converted to Unicode. This is the font name that Adobe's Acrobat displays in the font overview.
   CapHeight As Single              ' Cap height (optional).
   CharSet As String                ' The charset describes which glyphs are present in the font.
   CIDOrdering  As String           ' SystemInfo -> A string that uniquely names the character collection within the specified registry.
   CIDRegistry As String            ' SystemInfo -> Issuer of the character collection.
   CIDSet() As Byte                 ' CID fonts only. This is a table of bits indexed by CIDs.
   CIDSupplement As Long            ' CIDSystemInfo -> The supplement number of the character collection.
   CIDToGIDMap() As Byte            ' Allowed for embedded TrueType based CID fonts only.
   CMapBuf() As Byte                ' Only available if the CMap was embedded.
   CMapName As String               ' CID fonts only (this is the encoding if the CMap is not embedded).
   Descent As Single                ' Descent (optional).
   Encoding As String               ' Unicode mapping 0..255 -> not available for CID fonts.
   FirstChar As Long                ' First char (simple fonts only).
   Flags  As TPDFFontFlags          ' The font flags describe various characteristics of the font. See help file for further information.
   FontBBox As TBBox                ' This is the size of the largest glyph in this font. The bounding box is important for text selection.
   FontBuffer() As Byte             ' The font buffer is present if the font was embedded or if it was loaded from a file buffer.
   FontFamily As String             ' Optional Font Family (Family Name, always available for system fonts).
   FontFilePath As String           ' Only available for system fonts.
   FontFileType As TFontFileSubtype ' See description in the help file for further information.
   FontName As String               ' Font name (should be the same as BaseFont).
   FontStretch As String            ' Optional -> UltraCondensed, ExtraCondensed, Condensed, and so on.
   FontType As TFontType            ' If ftType0 the font is a CID font. The Encoding is not set in this case.
   FontWeight As Single             ' Font weight (optional).
   FullName As String               ' System fonts only.
   HaveEncoding As Boolean          ' If true, BaseEncoding was set from the font's encoding.
   HorzWidths() As Single           ' Horizontal glyph widths.
   Imported As Boolean              ' If true, the font was imported from an external PDF file.
   ItalicAngle As Single            ' Italic angle.
   Lang As String                   ' Optional language code defined by BCP 47.
   LastChar As Long                 ' Last char (simple fonts only).
   Leading As Single                ' Leading (optional).
   Length1 As Long                  ' Length of the clear text portion of a Type1 font.
   Length2 As Long                  ' Length of the encrypted portion of a Type1 font program (Type1 fonts only).
   Length3 As Long                  ' Length of the fixed-content portion of a Type1 font program or zero if not present.
   MaxWidth As Single               ' Maximum glyph width (optional).
   Metadata() As Byte               ' Optional XMP stream that contains metadata about the font file.
   MisWidth As Single               ' Missing width (default = 0.0).
   Panose() As Byte                 ' CID fonts only -> Optional 12 bytes long Panose string as described in Microsofts TrueType 1.0 Font Files Technical Specification.
   PostScriptName As String         ' System fonts only.
   SpaceWidth As Single             ' Space width in font units. A default value is set if the font contains no space character.
   StemH As Single                  ' The thickness, measured vertically, of the dominant horizontal stems of glyphs in the font.
   StemV As Single                  ' The thickness, measured horizontally, of the dominant vertical stems of glyphs in the font.
   ToUnicode() As Byte              ' Only available for imported fonts. This is an embedded CMap that translates PDF strings to Unicode.
   VertDefPos As TFltPoint          ' Default vertical displacement vector.
   VertWidths() As TCIDMetric       ' Vertical glyph widths -> 0..VertWidthsCount -1.
   WMode As Long                    ' Writing Mode -> 0 == Horizontal, 1 == Vertical.
   XHeight As Single                ' The height of lowercase letters (like the letter x), measured from the baseline, in fonts that have Latin characters.
End Type

Public Type TPDFFontInfo_I
   StructSize As Long               ' Must be set to sizeof(TPDFFontInfo).
   Ascent As Single                 ' Ascent (optional).
   AvgWidth As Single               ' Average character width (optional).
   BaseEncoding As TBaseEncoding    ' Valid only if HaveEncoding is true.
   BaseFont As Long                 ' PostScript Name or Family Name.
   CapHeight As Single              ' Cap height (optional).
   CharSet As Long                  ' The charset describes which glyphs are present in the font.
   CharSetSize As Long              ' Length of the CharSet string in bytes.
   CIDOrdering  As Long             ' SystemInfo -> A string that uniquely names the character collection within the specified registry.
   CIDRegistry As Long              ' SystemInfo -> Issuer of the character collection.
   CIDSet As Long                   ' CID fonts only. This is a table of bits indexed by CIDs.
   CIDSetSize As Long               ' Length of the CIDSet in bytes.
   CIDSupplement As Long            ' CIDSystemInfo -> The supllement number of the character collection.
   CIDToGIDMap As Long              ' Allowed for embedded TrueType based CID fonts only.
   CIDToGIDMapSize As Long          ' Length of the stream in bytes.
   CMapBuf As Long                  ' Only available if the CMap was embedded.
   CMapBufSize As Long              ' Buffer size in bytes.
   CMapName As Long                 ' CID fonts only (this is the encoding if the CMap is not embedded).
   Descent As Single                ' Descent (optional).
   Encoding As Long                 ' Unicode mapping 0..255 -> not available for CID fonts.
   FirstChar As Long                ' First char (simple fonts only).
   Flags  As Long                   ' The font flags describe various characteristics of the font. See help file for further information.
   FontBBox As TBBox                ' This is the size of the largest glyph in this font. The bounding box is important for text selection.
   FontBuffer As Long               ' The font buffer is present if the font was embedded or if it was loaded from a file buffer.
   FontBufSize As Long              ' Font file size in bytes.
   FontFamilyA As Long              ' Optional Font Family (Family Name, always available for system fonts).
   FontFamilyW As Long              ' Optional Font Family (either the Ansi or Unicode string is set, but never both).
   FontFilePathA As Long            ' Only available for system fonts.
   FontFilePathW As Long            ' Either the Ansi or Unicode path is set, but never both.
   FontFileType As TFontFileSubtype ' See description in the help file for further information.
   FontName As Long                 ' Font name (should be the same as BaseFont).
   FontStretch As Long              ' Optional -> UltraCondensed, ExtraCondensed, Condensed, and so on.
   FontType As TFontType            ' If ftType0 the font is a CID font. The Encoding is not set in this case.
   FontWeight As Single             ' Font weight (optional).
   FullNameA As Long                ' System fonts only.
   FullNameW As Long                ' System fonts only (either the Ansi or Unicode string is set, but never both).
   HaveEncoding As Long             ' If true, BaseEncoding was set from the font's encoding.
   HorzWidths As Long               ' Horizontal glyph widths -> 0..HorzWidthsCount -1.
   HorzWidthsCount As Long          ' Number of horizontal widths in the array.
   Imported As Long                 ' If true, the font was imported from an external PDF file.
   ItalicAngle As Single            ' Italic angle
   Lang As Long                     ' Optional language code defined by BCP 47.
   LastChar As Long                 ' Last char (simple fonts only).
   Leading As Single                ' Leading (optional).
   Length1 As Long                  ' Length of the clear text portion of a Type1 font.
   Length2 As Long                  ' Length of the encrypted portion of a Type1 font program (Type1 fonts only).
   Length3 As Long                  ' Length of the fixed-content portion of a Type1 font program or zero if not present.
   MaxWidth As Single               ' Maximum glyph width (optional).
   Metadata As Long                 ' Optional XMP stream that contains metadata about the font file.
   MetadataSize As Long             ' Buffer size in bytes.
   MisWidth As Single               ' Missing width (default = 0.0).
   Panose As Long                   ' CID fonts only -> Optional 12 bytes long Panose string as described in Microsofts TrueType 1.0 Font Files Technical Specification.
   PostScriptNameA As Long          ' System fonts only.
   PostScriptNameW As Long          ' System fonts only (either the Ansi or Unicode string is set, but never both).
   SpaceWidth As Single             ' Space width in font units. A default value is set if the font contains no space character.
   StemH As Single                  ' The thickness, measured vertically, of the dominant horizontal stems of glyphs in the font.
   StemV As Single                  ' The thickness, measured horizontally, of the dominant vertical stems of glyphs in the font.
   ToUnicode As Long                ' Only available for imported fonts. This is an embedded CMap that translates PDF strings to Unicode.
   ToUnicodeSize As Long            ' Buffer size in bytes.
   VertDefPos As TFltPoint          ' Default vertical displacement vector.
   VertWidths As Long               ' Vertical glyph widths -> 0..VertWidthsCount -1.
   VertWidthsCount As Long          ' Number of vertical widths in the array.
   WMode As Long                    ' Writing Mode -> 0 == Horizontal, 1 == Vertical.
   XHeight As Single                ' The height of lowercase letters (like the letter x), measured from the baseline, in fonts that have Latin characters.
   BaseFontW As Long                ' BaseFont converted to Unicode. This is the font name that Adobe's Acrobat displays in the font overview.
End Type

Public Type TPDFFontObj
   Ascent As Single       ' Ascent
   BaseFont As String     ' PostScript Name or Family Name
   CapHeight As Single    ' Cap height
   Descent As Single      ' Descent
   Encoding As String     ' Unicode mapping 0..255 -> not set if a CID font is selected
   FirstChar As Long      ' First char
   Flags As TPDFFontFlags ' Font flags -> font descriptor
   FontFamily As String   ' Optional Font Family (Family Name)
   FontName As String     ' Font name -> font descriptor
   FontType As TFontType  ' If ftType0 the font is a CID font. The Encoding is not set in this case.
   ItalicAngle As Single  ' Italic angle
   LastChar As Long       ' Last char
   SpaceWidth As Single   ' Space width in font units. A default value is set if the font contains no space character.
   Widths() As Single     ' Glyph widths -> 0..WidthsCount -1
   XHeight As Single      ' x-height
   DefWidth As Single     ' Default character widths -> CID fonts only
   FontFile As Long       ' Font file buffer -> only imported fonts are returned.
   Length1 As Long        ' Length of the clear text portion of the Type1 font, or the length of the entire font program if FontType != ffType1.
   Length2 As Long        ' Length of the encrypted portion of the Type1 font program (Type1 fonts only).
   Length3 As Long        ' Length of the fixed-content portion of the Type1 font program or zero if not present.
   FontFileType As TFontFileSubtype ' See description in the help file for further information.
End Type

Public Type TPDFFontObj_I
   Ascent As Single      ' Ascent
   BaseFont As Long      ' PostScript Name or Family Name
   CapHeight As Single   ' Cap height
   Descent As Single     ' Descent
   Encoding As Long      ' Unicode mapping 0..255 -> not set if a CID font is selected
   FirstChar As Long     ' First char
   Flags As Long         ' Font flags -> font descriptor
   FontFamily As Long    ' Optional Font Family (Family Name)
   FontFamilyUni As Long ' Is FontFamily in Unicode format?
   FontName As Long      ' Font name -> font descriptor
   FontType As TFontType ' If ftType0 the font is a CID font. The Encoding is not set in this case.
   ItalicAngle As Single ' Italic angle
   LastChar As Long      ' Last char
   SpaceWidth As Single  ' Space width in font units. A default value is set if the font contains no space character.
   Widths As Long        ' Glyph widths -> 0..WidthsCount -1
   WidthsCount As Long   ' Number of widths in the array
   XHeight As Single     ' x-height
   DefWidth As Single    ' Default character widths -> CID fonts only
   FontFile As Long      ' Font file buffer -> only imported fonts are returned.
   Length1 As Long       ' Length of the clear text portion of the Type1 font, or the length of the entire font program if FontType != ffType1.
   Length2 As Long       ' Length of the encrypted portion of the Type1 font program (Type1 fonts only).
   Length3 As Long       ' Length of the fixed-content portion of the Type1 font program or zero if not present.
   FontFileType As TFontFileSubtype  ' See description in the help file for further information.
End Type

Public Type TPDFFontMetrics
   StructSize As Long       ' Must be set to sizeof(TPDFFontMetrics)
   Ascent As Single         ' Ascent (usWinAscent)
   AvgWidth As Single       ' Average character width
   CapHeight As Single      ' Cap height
   DefWidth As Single       ' Default width
   Descent As Single        ' sTypoDescender of the OS/2 table of TrueType and OpenType fonts
   FirstChar As Long        ' First char
   FixedWidth As Long       ' Width of all glyphs in a fixed pitch font
   FontStyle As TFStyle     ' Font style with which the font was loaded
   FontBBox As TBBox        ' Font's bounding box
   IsFixedPitch As Long     ' Is this a fixed pitch font?
   IsSymbolFont As Long     ' Is this is a symbolic font?
   IsStdFont As Long        ' Is this is a standard font?
   ItalicAngle As Single    ' Italic angle of italic fonts
   LastChar As Long         ' Last char
   LineGap As Single        ' sTypoLineGap of the OS/2 table of TrueType and OpenType fonts
   MacStyle As Long         ' macOS style flags
   RealStyle As TFStyle     ' This is the real style of the font (bold and italic styles are maybe emulated)
   StemV As Single          ' Width of vertical stems
   StrikeoutPos As Single   ' Strikeout position
   StrikeoutWidth As Single ' Width of the strikeout line
   UnderlinePos As Single   ' Underline position
   UnderlineWidth As Single ' Width of the underline
   UnicodeRange1 As Long    ' Bitset -> TUnicodeRange1
   UnicodeRange2 As Long    ' Bitset -> TUnicodeRange2
   UnicodeRange3 As Long    ' Bitset -> TUnicodeRange3
   UnicodeRange4 As Long    ' Bitset -> TUnicodeRange4
   Weight As Long           ' Font weight
   WidthClass As Long       ' Width class of the font
   WinDescent As Single     ' usWinDescent of the OS/2 table of TrueType and OpenType fonts
   WinStyle As Long         ' fsSelection of the OS/2 table of TrueType and OpenType fonts
   XHeight As Single        ' X-height
   TypoAscender As Single   ' sTypoAscender of the OS/2 table of TrueType and OpenType fonts
   TypoLeading As Single    ' Typographic leading or line height of the font. This is TypoAscender - Descent + LineGap.
                            ' If typographic metrics are not available then TypoAscender is set to Ascent.
End Type

Public Type TPDFGlyphOutline
   AdvanceX As Single
   AdvanceY As Single
   OriginX As Single
   OriginY As Single
   Lsb As Integer
   Tsb As Integer
   HaveBBox As Boolean
   BBox As TFRect
   Outline() As TI32Point
End Type

Public Type TPDFGoToAction
   DestPage As Long              ' Destination page (the first page is denoted by 1).
   DestPos() As Single           ' Destination position -> Array of 4 floating point values if set.
   DestType As TDestType         ' Destination type.
   ' GoToR (GoTo Remote) actions only:
   DestFile As Long              ' see GetFileSpec().
   DestName As String            ' Optional named destination that shall be loaded when opening the file.
   NewWindow As Long             ' Meaningful only if the destination file points to a PDF file.
                                 ' -1 = viewer default, 0 = false, 1 = true.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFHideAction
   Fields() As Long              ' Array of field pointers -> GetFieldEx2().
   Hide As Boolean               ' A flag indicating whether to hide or show the fields in the array.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFImage
   Buffer As Long               ' Each scanline is aligned to a full byte.
   BufSize As Long              ' The size of the image buffer in bytes.
   Filter As TDecodeFilter      ' Required decode filter if the image is compressed.
                                ' Possible values are dfDCTDecode (JPEG), dfJPXDecode (JPEG2000),
                                ' and dfJBIG2Decode. Other filters are already removed by DynaPDF since
                                ' a conversion to a native file format is then always required.
   OrgFilter As TDecodeFilter   ' The image was compressed with this filter in the PDF file. This info is
                                ' useful to determine which compression filter should be used when creating
                                ' a new image file from the image buffer.
   JBIG2Globals As Long         ' Optional global page 0 segment (dfJBIG2Decode filter only).
   JBIG2GlobalsSize As Long     ' The size of the bit stream in bytes.
   BitsPerPixel As Long         ' Bit depth of the image buffer. Possible values are 1, 2, 4, 8, 24, 32, and 64.
   ColorSpace As TExtColorSpace ' The color space refers either to the image buffer or to the color table if set.
                                ' Note that 1 bit images can occur with and without a color table.
   NumComponents As Long        ' The number of components stored in the image buffer.
   MinIsWhite As Long           ' If true, the colors of 1 bit images are reversed.
   IColorSpaceObj As Long       ' Pointer to the original color space.
   ColorTable As Long           ' The color table or NULL.
   ColorCount As Long           ' The number of colors in the color table.
   Width As Long                ' Image width in pixel.
   Height As Long               ' Image height in pixel.
   ScanLineLength As Long       ' The length of a scanline in bytes.
   InlineImage As Long          ' If true, the image is an inline image.
   Interpolate As Long          ' If true, image interpolation should be performed.
   Transparent As Long          ' The meaning is different depending on the bit depth and whether a color
                                ' table is available. If the image is a 1 bit image and if no color table is available,
                                ' black pixels must be drawn with the current fill color.
                                ' If the image contains a color table, ColorMask contains the range of indexes
                                ' in the form min/max index which should appear transparent. If no color table is
                                ' present ColorMask contains the transparent ranges in the form min/max for
                                ' every color component.
   ColorMask As Long            ' The array contains ranges in the form min/max (2 values per component) for each
                                ' component before decoding.
   IMaskImage As Long           ' If set, a 1 bit image is used as a transparency mask. Call GetImageObjEx() to decode the image.
   ISoftMask As Long            ' If set, a grayscale image is used as alpha channel. Call GetImageObjEx() to decode the image.
   Decode As Long               ' If set, samples must be decoded. The array contains 2 * NumComponents values.
                                ' The decode array is never set if the image is returned decompressed since
                                ' it is already applied during decompression.
   Intent As TRenderingIntent   ' Default riNone.
   SMaskInData As Long          ' JPXDecode only, PDF_MAX_INT if not set. See PDF Reference for further information.
   OC As Long                   ' Pointer of an OCG or OCMD if set. -> See GetOCHandle()
   Metadata As Long             ' Optional XML Metadata stream.
   MetadataSize As Long         ' Length of Metadata in bytes.
   ObjectPtr As Long            ' Internal pointer to the image class.
   ResolutionX As Single        ' Image resolution on the x-axis.
   ResolutionY As Single        ' Image resolution on the y-axis.
   Measure As Long              ' Optional measure dictionary -> GetMeasureObj().
   PtData As Long               ' Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
   '   The parallelogram into which the image is drawn.
   '   p1 --p2
   '   |    |
   '   p4 --p3
   DestX1 As Single             ' 0
   DestY1 As Single             ' 0
   DestX2 As Single             ' 1
   DestY2 As Single             ' 0
   DestX3 As Single             ' 1
   DestY3 As Single             ' 1
   DestX4 As Single             ' 0
   DestY4 As Single             ' 1
   DestWidth As Single          ' Destination width (can be negative).
   DestHeight As Single         ' Destination height (can be negative).
   FillColor As Long            ' The current fill color. An image mask is drawn with the current fill color.
   FillColorSpace As TPDFColorSpace ' The color space in which FillColor is defined.
   ' Reserved fields for future extensions
   Reserved1 As Long
   Reserved2 As Long
   Reserved3 As Long
   Reserved4 As Long
End Type

Public Type TPDFImportDataAction
   Data As TPDFFileSpecEx        ' The data or file to be loaded.
   NextAction  As Long           ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFJavaScriptAction
   Script As String              ' The script
   NextAction As Long            ' -1 or next action handle to be executed if any.
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFLaunchAction
   AppName As String             ' Optional. The name of the application that should be launched.
   DefDir As String              ' Optional default directory.
   File As Long                  ' see GetFileSpec().
   NewWindow As Long             ' -1 = viewer default, 0 = false, 1 = true.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
   Operation As String           ' Optional string specifying the operation to perform (open or print).
   Parameter As String           ' Optional parameter string that shall be passed to the application (AppName).
End Type

Public Type TPDFMeasure
   IsRectilinear As Boolean ' If true, the members of the rectilinear measure dictionary are set. The geospatial members otherwise.
   ' --- Rectilinear measure dictionary ---
   Angles() As Long         ' Number format array to measure angles -> GetNumberFormatObj()
   Area() As Long           ' Number format array to measure areas -> GetNumberFormatObj()
   CXY As Single            ' Optional, meaningful only when Y is present.
   Distance() As Long       ' Number format array to measure distances -> GetNumberFormatObj()
   OriginX As Single        ' Origin of the measurement coordinate system.
   OriginY As Single        ' Origin of the measurement coordinate system.
   r As String              ' A text string expressing the scale ratio of the drawing.
   Slope() As Long          ' Number format array for measurement of the slope of a line -> GetNumberFormatObj()
   X() As Long              ' Number format array for measurement of change along the x-axis and, if Y is not present, along the y-axis as well.
   Y() As Long              ' Number format array for measurement of change along the y-axis.

   ' --- Geospatial measure dictionary ---
   Bounds() As Single       ' Array of numbers taken pairwise to describe the bounds for which geospatial transforms are valid.

   ' The DCS coordinate system is optional.
   DCS_IsSet As Boolean     ' If true, the DCS members are set.
   DCS_Projected As Boolean ' If true, the DCS values contains a pojected coordinate system.
   DCS_EPSG As Long         ' Optional, either EPSG or WKT is set.
   DCS_WKT As String        ' Optional ASCII string

   ' The GCS coordinate system is required and should be present.
   GCS_Projected As Boolean ' If true, the GCS values contains a pojected coordinate system.
   GCS_EPSG As Long         ' Optional, either EPSG or WKT is set.
   GCS_WKT As String        ' Optional ASCII string

   GPTS() As Single         ' Required, an array of numbers that shall be taken pairwise, defining points in geographic space as degrees of latitude and longitude, respectively.
   LPTS() As Single         ' Optional, an array of numbers that shall be taken pairwise to define points in a 2D unit square.

   PDU1 As String           ' Optional preferred linear display units.
   PDU2 As String           ' Optional preferred area display units.
   PDU3 As String           ' Optional preferred angular display units.
End Type

Public Type TPDFMovieAction
   Annot As Long                 ' Optional. The movie annotation handle identifying the movie that shall be played.
   FWPosition(1) As Single       ' FWPosition
   FWScale(1) As Long            ' FWScale
   Mode As String                ' Mode
   Operation As String           ' Operation
   Rate As Single                ' Rate
   ShowControls As Boolean       ' ShowControls
   Synchronous As Boolean        ' Synchronous
   Title As String               ' The title of a movie annotation that shall be played. Either Annot or Title should be set, but not both.
   Volume As Single              ' Volume
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFNamedAction
   Name As String                ' Only set if Type == naUserDefined.
   NewWindow As Long             ' -1 = viewer default, 0 = false, 1 = true.
   NextAction As Long            ' -1 or next action handle to be executed if any.
   NextActionType As TActionType ' Only set if NextAction is >= 0.
   Type As TNamedAction          ' Known pre-defined actions.
End Type

Public Type TPDFNamedDest
   Name As String
   DestFile As String    ' If set, the destination is located in this PDF file
   DestPage As Long
   DestPos As TPDFRect
   DestType As TDestType
End Type

Public Type TPDFNumberFormat
   C As Single
   d As Long
   f As TMeasureNumFormat
   FD As Boolean
   O As TMeasureLblPos
   PS As String
   RD As String
   RT As String
   SS As String
   U As String
End Type

Public Type TPDFObjActions
   StructSize As Long        ' Must be set to sizeof(TPDFObjActions).
   Action As Long            ' Action handle or -1 if not set.
   ActionType As TActionType ' The type of the action if Action >= 0.
   Events As Long            ' Additional events if any -> GetObjEvent().
End Type

Public Type TPDFObjEvent
   StructSize As Long        ' Must be set to sizeof(TPDFObjEvent).
   Action As Long            ' Action to be executed.
   ActionType As TActionType ' The type of the action.
   ObjEvent As TObjEvent     ' The event when the action should be executed.
   Next As Long              ' Pointer to the next event if any.
End Type

Public Type TPDFOCG
   Handle As Long                  ' Handle or array index
   Intent As TOCGIntent            ' Bitmask -> TOCGIntent
   Name As String                  ' Layer name
   HaveContUsage As Boolean        ' If true, the layer contains a Content Usage dictionary. -> GetOCGContUsage().
   ' The following two members can only be set if HaveContUsage is true.
   AppEvents As TOCAppEvent        ' Bitmask -> see TOCAppEvent. If non-zero, the layer is included in one or more app events which control the layer state.
   Categories As TOCGUsageCategory ' Bitmask -> see TOCGUsageCategory. The Usage Categories which control the layer state.
End Type

Public Type TPDFOCGContUsage
   ExportState As Long           ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   InfoCreator As String         ' CreatorInfo -> The application that created the group
   InfoSubtype As String         ' CreatorInfo -> A name defining the type of content, e.g. Artwork, Technical etc.
   Language As String             ' A language code as described at SetLanguage() in the help file.
   LangPreferred As Long         ' 0 = Off, 1 = On, PDF_MAX_INT = not set. The preffered state if there is a partial but no exact match of the language identifier.
   PageElement As TOCPageElement ' If the group contains a pagination artefact.
   PrintState As Long            ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   PrintSubtype As String        ' The type of content that is controlled by the OCG, e.g. Trapping, PrintersMarks or Watermark.
   UserNamesCount As Long        ' The user names (if any) can be accessed with GetOCGUsageUserName().
   UserType As TOCUserType       ' The user for whom this optional content group is primarily intendet.
   ViewState As Long             ' 0 = Off, 1 = On, PDF_MAX_INT = not set.
   ZoomMin As Single             ' The minimum magnification factor at which the group should be On. -1 if not set.
   ZoomMax As Single             ' The maximum magnification factor at which the group should be On. -1 if not set.
End Type

Public Type TPDFOCLayerConfig
   Intent As TOCGIntent ' Possible values oiDesign, oiView, or oiAll.
   IsDefault As Boolean ' If true, this is the default configuration.
   Name As String       ' Optional configuration name. The default config has usually no name but all others should have one.
End Type

Public Type TPDFOCUINode
   Label As String     ' Optional label.
   NextChild As Long   ' If set, the next child node that must be loaded.
   NewNode As Boolean  ' If true, a new child node must be created.
   OCG As Long         ' Optional OCG handle. -1 if not set -> GetOCG().
End Type

Public Type TPDFOutputIntent
   Buffer() As Byte
   Info As String
   NumComponents As Long
   OutputCondition As String
   OutputConditionID As String
   RegistryName As String
   Subtype As String
End Type

Public Type TPDFPageLabel
   StartRange As Long         ' Number of the first page in the range. If no further label follows, the last
                              ' page in the range is pdfGetPageCount(). The first page is denoted by 1.
   Format As TPageLabelFormat ' Number format to be used.
   FirstPageNum As Long       ' First page number to be displayed in the page label. Subsequent pages are
                              ' numbered sequentially from this value.
   Prefix As String           ' Optional prefix
End Type

Public Enum TPrintScaling
   psAppDefault ' Default
   psNone
End Enum

Public Type TPDFPrintParams
   StructSize As Long                ' Must be set to sizeof(TPDFPrintParams).
   Compress As Long                  ' Meaningful only for image output. If true, compressed images are send to the printer.
   FilterGray As TCompressionFilter  ' Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   FilterColor As TCompressionFilter ' Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   JPEGQuality As Long               ' JPEG Quality in percent. Zero == Default == 60.
   MaxRes As Long                    ' Maximum print resolution. Zero == Default == 600 DPI.
   IgnoreDCSize As Long              ' If true, PageSize is used to calculate the output format.
   PageSize As TIntRect              ' Considered only, if IgnoreDCSize is set to true.

End Type

Public Type TPDFPrintSettings
   DuplexMode As TDuplexMode
   NumCopies As Long             ' -1 means not set. Values larger than 5 are ignored in viewer applications.
   PickTrayByPDFSize As Long     ' -1 means not set. 0 == false, 1 == true.
   PrintRanges() As Long         ' If set, the array contains PrintRangesCount * 2 values. Each pair consists
                                 ' of the first and last pages in the sub-range. The first page in the PDF file
                                 ' is denoted by 0.
   PrintScaling As TPrintScaling ' dpmNone means not set.
End Type

Public Type TPDFRawImage
   Buffer() As Byte         ' Image buffer
   BitsPerComponent As Long ' Bits per component
   NumComponents As Long    ' Number of components (max 32)
   CS As TExtColorSpace     ' Image color space
   CSHandle As Long         ' Color space handle (non-device color spaces only)
   Stride As Long           ' Scanline length in bytes -> If negative, the image is defined in bottom up coordinates, top down otherwise
   HasAlpha As Boolean      ' If true, the last component is an alpha channel
   IsBGR As Boolean         ' esDeviceRGB only -> If true, the image components are defined in BGR format instead of RGB
   MinIsWhite As Boolean    ' 1 bit images only -> If true, zero pixel values must be treated as white instead of black
   Width As Long            ' Width in pixels (must be greater zero)
   Height As Long           ' Height in pixels (must be greater zero)
End Type

Public Type TPDFRelFileNode
   Name As String       ' Name of this file spcification.
   EF As TPDFFileSpecEx ' Embedded file.
   NextNode As Long     ' Next node if any.
End Type

Public Type TPDFResetFormAction
   Fields() As Long              ' Array of field pointers -> GetFieldEx2().
   Include As Boolean            ' If true, the fields in the Fields array must be reset. If false, these fields must be excluded.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFSigDict
   ByteRange() As Long     ' ByteRange -> Byte offset followed by the corresponding length.
                           ' The byte ranges are required to create the digest. The values
                           ' are returned as is. So, you must check whether the offsets and
                           ' length values are valid. There are normally at least two ranges.
                           ' Overlapping ranges are not allowed! Any error breaks processing
                           ' and the signature should be considered as invalid.
   Cert() As Byte          ' X.509 Certificate when SubFilter is adbe.x509.rsa_sha1.
   Changes() As Long       ' If set, an array of three integers that specify changes to the
                           ' document that have been made between the previous signature and
                           ' this signature in this order: the number of pages altered, the
                           ' number of fields altered, and the number of fields filled in.
   ContactInfo As String   ' Optional contact info string, e.g. an email address
   Contents() As Byte      ' The signature. This is either a DER encoded PKCS#1 binary data
                           ' object or a DER-encoded PKCS#7 binary data object depending on
                           ' the used SubFilter.
   Filter As String        ' The name of the security handler, usually Adobe.PPKLite.
   Location As String      ' Optional location of the signer
   SignTime As String      ' Date/Time string
   Name As String          ' Optional signers name
   PropAuthTime As Long    ' Optional -> The number of seconds since the signer was last authenticated.
   PropAuthType As String  ' Optional -> The method that shall be used to authenticate the signer.
                           ' Valid values are PIN, Password, and Fingerprint.
   Reason As String        ' Optional reason
   Revision As Long        ' Optional -> The version of the signature handler that was used to create
                           ' the signature.
   SubFilter As String     ' A name that describes the encoding of the signature value. Should be
                           ' adbe.x509.rsa_sha1, adbe.pkcs7.detached, or adbe.pkcs7.sha1.
   Version As Long         ' The version of the signature dictionary format.
End Type

Public Type TPDFSigParms
   PKCS7ObjLen As Long    ' The maximum length of the signed PKCS#7 object
   HashType As THashType     ' If set to htDetached, the bytes ranges of the PDF file will be returned.
   Range1() As Byte          ' Out -> Contains either the hash or the first byte range to create a detached signature
   Range2() As Byte          ' Out -> Set only if HashType == htDetached
   ContactInfo As String     ' Optional, e.g. an email address_
   Location As String        ' Optional location of the signer
   Reason As String          ' Optional reason why the file was signed
   Signer As String          ' Optional, the issuer of the certificate takes precedence
   Encrypt As Boolean        ' If true, the file will be encrypted
   ' These members will be ignored if Encrypt is set to false
   OpenPwd As String         ' Open password
   OwnerPwd As String        ' Owner password to change the security settings
   KeyLen As TKeyLen         ' Key length to be used to encrypt the file
   Restrict As TRestrictions ' What should be restricted?
   Certificate As Long       ' Handle of a certificate (PCCERT_CONTEXT), returned by CertFindCertificateInStore(), for example.
                             ' If this paramteter is set, PKCS7ObjLen will be ignored and the file will be signed with this certificate.
   TimeStampServer As String ' Optional URL of a time stamp server
   TimeOut As Long           ' Optional number of millisecond
End Type

Public Type TPDFStack
   ctm As TCTM                 ' Pre-multiplied global transformation matrix
   tm As TCTM                  ' Pre-multiplied text transformation matrix
   X As Double                 ' unused -> always 0.0
   Y As Double                 ' unused -> always 0.0
   FontSize As Double          ' Font size
   CharSP As Double            ' Character spacing
   WordSP As Double            ' Word spacing
   HScale As Double            ' Horizontal text scaling
   TextRise As Double          ' Text rise -> always 0.0 because it is already included in the text transformation matrix
   Leading As Double           ' Leading
   LineWidth As Double         ' Line width
   DrawMode As TDrawMode       ' Text draw mode
   FillCS As TPDFColorSpace    ' Fill color space
   StrokeCS As TPDFColorSpace  ' Stroke color space
   FillColor As Long           ' Fill color
   StrokeColor As Long         ' Stroke color
   CIDFont As Boolean          ' If true, ReplacePageText() can only be used to delete a string.
   Text As String              ' Raw text without kerning space
   RawKern() As TTextRecordA   ' Raw kerning array
   Kerning() As TTextRecordW   ' Already translated Unicode kerning array
   TextWidth As Single         ' Measured in text space
   SpaceWidth As Single        ' Measured in text space
   IFont As Long               ' Font object used to print the string -> fntGetFont() can be used to return the font properties.
   Embedded As Boolean         ' If true the font is embedded
   ConvColors As Boolean       ' If set to true (default), all colors are converted to the specified destination color space
   DestSpace As TPDFColorSpace ' Destination color space -> default == csDeviceRGB
   ' This member can be used in combination with ReplacePageText() to preserve a number
   ' of kerning records from deletion. All records above this value will be deleted.
   ' Take a look into the VB .Net demo examples/util/pdf_edit_text.vb to determine how this member
   ' can be used.
   DeleteKerningAt As Long
   FontFlags As Long           ' PDF font flags
End Type

Public Type TPDFStack_I
   ctm As TCTM                ' Pre-multiplied global transformation matrix
   tm As TCTM                 ' Pre-multiplied text transformation matrix
   X As Double                ' Unused -> always 0.0
   Y As Double                ' Unused -> always 0.0
   FontSize As Double         ' Font size
   CharSP As Double           ' Character spacing
   WordSP As Double           ' Word spacing
   HScale As Double           ' Horizontal text scaling
   TextRise As Double         ' Text rise -> always 0.0 because it is already included in the text transformation matrix
   Leading As Double          ' Leading
   LineWidth As Double        ' Line width
   DrawMode As TDrawMode      ' Text draw mode
   FillCS As TPDFColorSpace   ' Fill color space
   StrokeCS As TPDFColorSpace ' Stroke color space
   FillColor As Long          ' Fill color
   StrokeColor As Long        ' Stroke color
   BaseObject As Long         ' Internal
   CIDFont As Long            ' If true, ReplacePageText() can only be used to delete a string
   Text As Long               ' Raw text without kerning space
   TextLen As Long            ' Raw text length
   RawKern As Long            ' Raw kerning array
   Kerning As Long            ' Already translated Unicode kerning array
   KerningCount As Long       ' Number of kerning records
   TextWidth As Single        ' The width of the entire text record measured in text space
   IFont As Long              ' Font object used to print the string -> fntGetFont() can be used to return the font properties
   Embedded As Long           ' If true, the font is embedded
   SpaceWidth As Single       ' Measured in text space
   'These members can be modified after the structure has been initialized with InitStack().
   'If the destination color space should be DeviceCMYK initialize FillColor and StrokeColor
   'with PDF_CMYK(0,0,0,255); which represents black.
   ConvColors As Long          ' If set to true (default), all colors are converted to the specified destination color space
   DestSpace As TPDFColorSpace ' Destination color space -> default == csDeviceRGB

   ' This member can be used in combination with ReplacePageText() to preserve a number
   ' of kerning records from deletion. All records above this value will be deleted.
   ' Take a look into the VB .Net demo examples/util/pdf_edit_text.vb to determine how this member
   ' can be used.
   DeleteKerningAt As Long
   FontFlags As Long           ' PDF font flags
   ' ------------------------------- Reserved fields -------------------------------
   Reserved1 As Long
   Reserved2 As Long
   Reserved3 As Long
   Reserved4 As Long
   Reserved5 As Long
   Reserved6 As Long
   Reserved7 As Long
   Reserved8 As Long
   Reserved9 As Long
   Reserved10 As Long
   Reserved11 As Long
   ContentPtr As Long
End Type

Public Type TPDFSubmitFormAction
   CharSet As String             ' Optional charset in which the form should be submitted.
   Fields() As Long              ' Array of field pointers -> GetFieldEx2().
   Flags As TSubmitFlags         ' Various flags, see CreateSubmitAction() for further information.
   URL As String                 ' The URL of the script at the Web server that will process the submission.
   NextAction As Long            ' -1 or next action handle to be executed if any
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TRectL
   rLeft As Long
   rTop As Long
   rRight As Long
   rBottom As Long
End Type

Public Type TPDFSysFont
   BaseType As TFontBaseType   ' Font type
   CIDOrdering As String       ' OpenType CID fonts only
   CIDRegistry As String       ' OpenType CID fonts only
   CIDSupplement As Long       ' OpenType CID fonts only
   DataOffset As Long          ' Data offset
   FamilyName As String        ' Family name
   FilePath As String          ' Font file path
   FileSize As Long            ' File size in bytes
   Flags As TEnumFontProcFlags ' Bitmask
   FullName As String          ' Full name
   Length1 As Long             ' Length of the clear text portion of a Type1 font
   Length2 As Long             ' Length of the eexec encrypted binary portion of a Type1 font
   PostScriptName As String    ' Postscript mame
   Index As Long               ' Zero based font index if the font is stored in a TrueType collection
   IsFixedPitch As Boolean     ' If true, the font is a fixed pitch font. A proprtional font otherwise.
   Style As TFStyle            ' Font style
   UnicodeRange1 As Long       ' Bitmask -> TUnicodeRange1
   UnicodeRange2 As Long       ' Bitmask -> TUnicodeRange2
   UnicodeRange3 As Long       ' Bitmask -> TUnicodeRange3
   UnicodeRange4 As Long       ' Bitmask -> TUnicodeRange3
End Type

Public Type TPDFURIAction
   BaseURL As String             ' Optional, if defined in the Catalog object.
   IsMap As Boolean              ' A flag specifying whether to track the mouse position when the URI is resolved: e.g. http:'test.org?50,70.
   URI As String                 ' Uniform Resource Identifier.
   NextAction As Long            ' -1 or next action handle to be executed if any.
   NextActionType As TActionType ' Only set if NextAction is >= 0.
End Type

Public Type TPDFViewport
   BBox As TFltRect   ' Bounding box
   Measure As Long    ' Optional pointer of a measure dictionary -> GetMeasureObj()
   Name As String     ' Optional name
   PtData As Long     ' Optional pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
End Type

Public Type TPDFXFAStream
   Buffer() As Byte
   Name As String
End Type

' ------------------------------------- Page Cache ------------------------------------

'   The path names can be set in Ansi (code page 1252 on Windows) or Unicode format. The Ansi version accepts
'   UTF-8 strings on non-Windows operating systems. UTF-16 Unicode strings are converted to UTF-8 on non-Windows
'   operating systems.
'
'   In general, the DefInXXX profiles are used if no other profile is available for the color space. Possible
'   sources are DefaultGray, DefaultRGB, DefaultCMYK, and the Rendering Intents.
'
'   The SoftProof profile emulates the output device. This is typically a printer profile or a default CMYK
'   profile. If no profile is set then no device will be emulated. What you see is maybe not what you get on
'   a printer.
'
'   To disable color management set the parameter Profiles of rasInitColormanagement() to NULL.

' An Unicode path can be set via StrPtr(myProfilePath)
Public Type TPDFColorProfiles
   StructSize As Long       ' Must be set to sizeof(TPDFColorProfile)
   DefInGrayA As String     ' Optional
   DefInGrayW As Long       ' Optional
   DefInRGBA As String      ' Optional, sRGB is the default. The "A" stands for Ansi string and not for Alpha...
   DefInRGBW As Long        ' Optional
   DefInCMYKA As String     ' Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
   DefInCMYKW As Long       ' but this is not possible with a CMYK profile. So, this is the most important input profile.
   DeviceProfileA As String ' Optional, the output profile must be compatible with the output color space.
   DeviceProfileW As Long   ' At this time only Gray or RGB profiles are supported. This is the monitor profile! Default is sRGB.
   SoftProofA As String     ' Optional but very important. This profile emulates the output device.
   SoftProofW As Long       ' Optional.
End Type

Public Type TPDFColorProfilesEx
   StructSize As Long       ' Must be set to sizeof(TPDFColorProfilesEx)
   DefInGray As Long        ' Optional
   DefInGrayLen As Long     ' Optional
   DefInRGB As Long         ' Optional
   DefInRGBLen As Long      ' Optional
   DefInCMYK As Long        ' Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
   DefInCMYKLen As Long     ' but this is not possible with a CMYK profile. So, this is the most important input profile.
   DeviceProfile As Long    ' Optional, the output profile must be compatible with the output color space.
   DeviceProfileLen As Long ' Gray, RGB, or CMYK profiles are supported.
   SoftProof As Long        ' Optional but very important. This profile emulates the output device.
   SoftProofLen As Long     ' Optional.
End Type

' ----------------------------------- Rendering API -----------------------------------

Enum TPDFPixFormat
   pxf1Bit
   pxfGray
   pxfRGB
   pxfBGR
   pxfRGBA
   pxfBGRA
   pxfARGB
   pxfABGR
   pxfGrayA
   pxfCMYK
   pxfCMYKA
End Enum

Enum TPDFPageScale
   psFitWidth  ' Scale the page to the width of the image buffer
   psFitHeight ' Scale the page to the height of the image buffer
   psFitBest   ' Scale the page so that it fits fully into the image buffer
   psFitZoom   ' This mode should be used if the scaling factors of the transformation matrix are <> 1.0
End Enum

Enum TRasterFlags
   rfDefault = &H0           ' Render the page as usual
   rfScaleToMediaBox = &H1   ' Render the real paper format. Contents outside the crop box is clipped
   rfIgnoreCropBox = &H2     ' Ignore the crop box and render anything inside the media box without clipping
   ' Only one of these flags must be set at time!
   rfClipToArtBox = &H4      ' Clip the page to the art box if any
   rfClipToBleedBox = &H8    ' Clip the page to the bleed box if any
   rfClipToTrimBox = &H10    ' Clip the page to the trim box if any
   ' --------------------------------------------
   rfExclAnnotations = &H20  ' Don't render annotations
   rfExclFormFields = &H40   ' Don't render form fields
   rfSkipUpdateBG = &H80     ' Don't generate an update event arfer initializing the background to white
   rfRotate90 = &H100        ' Rotate the page 90 degress
   rfRotate180 = &H200       ' Rotate the page 180 degress
   rfRotate270 = &H400       ' Rotate the page 270 degress
   rfInitBlack = &H800       ' Initialize the image buffer to black before rendering (RGBA or GrayA must be initialized to black)
   rfCompositeWhite = &H1000& ' Composite pixel formats with an alpha channel finally with a white background. The alpha channel is
                             ' 255 everywhere arfer composition. This flag is mainly provided for debug purposes but it can also be
                             ' useful if the image must be copied on screen with a function that doesn't support alpha blending.

   rfExclPageContent = &H2000 ' If set, only annotations and form fields will be rendered (if any).

   ' If you want to render specific field types with RenderAnnotOrField() then use the following flags to exclude these fields.
   ' If all fields should be skipped then set the flag rfExclFormFields instead.
   rfExclButtons = &H4000
   rfExclCheckBoxes = &H8000&
   rfExclComboBoxes = &H10000
   rfExclListBoxes = &H20000
   rfExclTextFields = &H40000
   rfExclSigFields = &H80000

   ' ---------------------------------
   rfScaleToBBox = &H100000             ' Considered only if the flag rfClipToArtBox rfClipToBleedBox or rfClipToTrimBox is set.
                                        ' If set the picture size is set to the size of the whished bounding box.
   rfDisableAAClipping = &H200000       ' Disable Anti-Aliasing for clipping paths which are used for images. This flag is the most important
                                        ' one since clipping paths cause often visible artefacts in PDF files with flattened transparency.
   rfDisableAAText = &H400000           ' Disable Anti-Aliasing for text.
   rfDisableAAVector = &H800000         ' Disable Anti-Aliasing for vector graphics.
   rfDisableAntiAliasing = rfDisableAAClipping Or rfDisableAAText Or rfDisableAAVector ' Fully disable Anti-Aliasing.
   rfDisableBiLinearFilter = &H1000000  ' Disable the BiLevel filter for images. Sometetimes useful if sharp images are needed e.g. for barcodes.
   rfRenderInvisibleText = &H2000000    ' If set, treat text rendering mode Invisible as Normal.
   rfEnableBlendCS = &H10000000         ' If set, the page is rendered in the color space of the page group, soft proof color space, or output intent if set, and
                                        ' finally converted to the destination color space.
   rfRenderPrintState = &H20000000      ' If set, the print state of layers, annotations, and form fields will be rendered.
   rfForceInterpolation = &H40000000    ' If set, image interpolation will be applied.
   rfPremulAlpha = &H80000000           ' If set, an image with pre-multiplied alpha values will be created.
End Enum


' The OnUpdateWindow callback is defined as follows
'Public Function OnUpdateWindow(ByVal Data As Long, ByRef Area As TIntRect) As Long
' ...
'End Function

' These flags can be combined with the structure size member:
'  TPDFRasterImage img;
'  img.StructSize = sizeof(img) or SKIP_INIT_SCREEN;
Const SKIP_INIT_SCREEN = &H10000000   ' Do not initialize the screen with a white image before rendering begins
Const SKIP_UPDATE_SCREEN = &H20000000 ' Do not finally update the screen after the page was rendered

Type TPDFRasterImage
   StructSize As Long                ' Must be set to sizeof(TPDFRasterImage)
   Flags As TRasterFlags             ' This is a bit mask. Flags can be combined with a binary or operator
   DefScale As TPDFPageScale         ' Specifies how the page should be scaled into the image buffer.

   InitWhite As Long                 ' If true, the image buffer is initialized to white before rendering.
                                     ' When a clipping rectangle is set, only the area inside the clipping
                                     ' rectangle is initialized to white.
   
   ClipRect As TIntRect              ' Optional clipping rectangle defined in device coordinates (Pixels), default 0,0,0,0 (no clipping)
   Matrix As TCTM                    ' Optional transformation matrix. Initialize the variable to the identity matrix (1,0,0,1,0,0)
                                     ' if you don't need it. The matrix can be used to move and scale the picture inside the image.
   PageSpace As TCTM                 ' Out -> This matrix represents the mapping from page space to device space. The matrix
                                     ' is required when further objects should be drawn on the page, e.g. the bounding boxes.

   DrawFrameRect As Long             ' If true, the area outside the page's bounding box is filled with the
                                     ' frame color. InitWhite can still be used, with or without a clipping
                                     ' rectangle.
   FrameColor As Long                ' Must be defined in the color space of the pixel format but in the natural
                                     ' component order, e.g. RGB.

   OnUpdateWindow As Long            ' Callback -> Optional, UpdateOnPathCount and UpdateOnImageCoverage define when the function should be called.
                                     ' How the callback function must be defined is described above.
   OnInitDecoder As Long             ' Callback -> Not yet defined
   OnDecodeLine As Long              ' Callback -> Not yet defined
   UserData As Long                  ' Arbitrary pointer that should be passed to the callback functions

   UpdateOnPathCount As Long         ' Optional -> Call OnUpdateWindow when the limit was reached.
                                     ' Clipping paths increment the number too.
                                     ' Only full paths are considered, independent of the number of vertices
                                     ' they contain. The value should be larger than 50 and smaller than 10000.

   UpdateOnImageCoverage As Single   ' Optional -> DynaPDF multiplies the output image width and height with this
                                     ' factor to calculate the coverage limit. When an image is inserted the unscaled
                                     ' width and height is added to the current coverage value. When the number
                                     ' reaches the limit the OnUpdateWindow event is raised.
                                     ' The factor should be around 0.5 through 5.0. Larger values cause less
                                     ' frequently update events.
   ' Statistics...
   NumAnnots As Long                 ' Out -> Number of rendered annotations (excluding invisible annotation but annotations with no appearance are included)
   NumBezierCurves As Long           ' Out -> Number of bezier curves which where rendered. Glyph outlines are not taken into account.
   NumClipPaths As Long              ' Out -> Number of clipping paths used in the page. Should be small as possible!
   NumFormFields As Long             ' Out -> Number of rendered form fields (excluding invisible fields but fields with no appearance are included)
   NumGlyphs As Long                 ' Out -> When the number of glyphs equals NumTextRecords then there is probably some room for optimization...
   NumImages As Long                 ' Out -> Number of images that were rendered
   NumLineTo As Long                 ' Out -> Number of LineTo operators
   NumPaths As Long                  ' Out -> Number of paths which were processed
   NumPatterns As Long               ' Out -> Number of pattern which were processed
   NumRectangles As Long             ' Out -> Number of rectangle operators
   NumRestoreGState As Long          ' Out -> Should be equal to NumSaveGState
   NumSaveGState As Long             ' Out -> The number of save graphics state operators
   NumShadings As Long               ' Out -> Number shadings which were processed
   NumSoftMasks As Long              ' Out -> Number of soft masks that were processed. Alpha channels of images are not taken into account.
   NumTextRecords As Long            ' Out -> Number of independent text records which were rendered
End Type



' ------------------------------------------------- Page cache -------------------------------------------------

Enum TPDFCursor
   pcrHandNormal = 0
   pcrHandClosed = 1
   pcrHandPoint = 2
   pcrIBeam = 3
End Enum

Enum TPDFInitCMFlags
   icmDefault = 0         ' Default rules.
   icmBPCompensation = 1  ' Black point compensation preserves the black point when converting CMYK colors to different color spaces.
   icmCheckBlackPoint = 2 ' If set, soft proofing will be disabled if the black point of the output intent is probably invalid.
End Enum

Enum TPwdType
   ptOpen = 0
   ptOwner = 1
   ptForceRepair = 2 ' Meaningful only when opening a PDF file with OpenImportFile() or OpenImportBuffer().
                     ' If set, the PDF parser rebuilds the cross-reference table by scanning all the objects
                     ' in the file. This can be useful if the cross-reference table contains damages while
                     ' the top level objects are intact. Setting this flag makes only sence if the file
                     ' was already previously opened in normal mode and if errors occured when importing
                     ' pages of it.
   ptDontCopyBuf = 4 ' If set, OpenImportBuffer() does not copy the PDF buffer to an internal buffer. This
                     ' increases the processing speed and reduces the memory usage. The PDF buffer must not
                     ' be released until CloseImportFile() or CloseFile() was called.
End Enum

Enum TInitCacheFlags
   icfDefault = 0
   icfIgnoreOpenAction = 1
   icfIgnorePageLayout = 2
End Enum

Enum TSelectObjType
   sotDefault = 0    ' Hand tool
   sotAnnotation = 1 ' Select annotations
   sotFormField = 2  ' Select form fields
   sotImage = 4      ' Select images
   sotText = 8       ' Select text
   sotVector = 16    ' Select vector graphics
End Enum

Enum TPDFThreadPriority
   ttpLowest
   ttpIdle
   ttpBelowNormal  ' This is the default value. Normal can be used too but scrolling is smoother in this mode.
   ttpNormal
   ttpAboveNormal
   ttpHighest      ' Not really useful...
   ttpTimeCritical ' Don't do that!
End Enum

Enum TUpdBmkAction
   ubaDoNothing = 0      ' Nothing to do
   ubaOpenPage = 1       ' Jump to the new page. This flag is set if the bookmark contained a destination or go to action.
   ubaPageScale = 2      ' Update the page scale with SetPageScale().
   ubaZoom = 4           ' Zoom into the page, update the scroll ranges, and set the scroll positions.
   ubaUpdScrollBars = 8  ' This flag is always set if ubaZoom is set.
   ubaExecAction = 16    ' Check the parameter Action to execute further code. This flag can occur with or without ubaOpenPage.
End Enum

Enum TUpdScrollbar
   usbNoUpdate = 0           ' Nothing to do
   usbVertRange = 1          ' Update the vertical scroll range
   usbVertScrollPos = 2      ' Update the vertical scroll position
   usbHorzRange = 4          ' Update the horizontal scroll range
   usbHorzScrollPos = 8      ' Update the horizontal scroll position
   usbUpdateAll = 15         ' Update both scroll ranges and the scroll positions
   ' The cursor constants are set by MouseMove. Since we have only one cursor there is never more than one constant set.
   usbCursorHandNormal = 16  ' This is the default if the left mouse button is not pressed and if we are not over an action field
   usbCursorHandClosed = 32  ' Occurs when the cursor leaves an action field and if the left mouse button is pressed
   usbCursorHandPoint = 64   ' Occurs when we enter link or button field
   usbCursorIBeam = 128      ' Occurs when we enter an action field that accepts text input
   usbCursorMask = 240       ' Bitmask to mask out the cursor constants
End Enum

' ---------------------------------- Private API functions ----------------------------
' The functions below should normally be declared as private functions in the file CPDF.cls but this file reached the maximum size...

Public Declare Function fntGetFont Lib "dynapdf.dll" (ByVal IFont As Long, ByRef Font As TPDFFontObj_I) As Long
Public Declare Function fntGetFontInfo Lib "dynapdf.dll" (ByVal IFont As Long, ByRef Font As TPDFFontInfo_I) As Long
Public Declare Function fntGetSpaceWidth Lib "dynapdf.dll" (ByVal IFont As Long, ByVal FontSize As Double) As Double
Public Declare Function fntGetTextWidth Lib "dynapdf.dll" (ByVal IFont As Long, ByVal Text As Long, ByVal sLen As Long, ByVal CharSpacing As Single, ByVal WordSpacing As Single, ByVal TextScale As Single) As Double
Public Declare Function fntTranslateRawCode Lib "dynapdf.dll" (ByVal IFont As Long, ByVal Text As Long, ByVal sLen As Long, ByRef Width As Double, ByVal OutText As Long, ByRef OutLen As Long, ByRef Decoded As Long, ByVal CharSpacing As Single, ByVal WordSpacing As Single, ByVal TextScale As Single) As Long
Public Declare Function fntTranslateString Lib "dynapdf.dll" (ByRef Stack As TPDFStack_I, ByVal OutText As Long, ByVal Size As Long, ByVal Flags As Long) As Long
Public Declare Function fntTranslateString2 Lib "dynapdf.dll" (ByVal IFont As Long, ByVal Text As Long, ByVal sLen As Long, ByVal OutText As Long, ByVal Size As Long, ByVal Flags As Long) As Long

' -------------------------------------------------------------------------------------

Public Declare Sub rasChangeBackColor Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As Long)
Public Declare Sub rasCloseFile Lib "dynapdf.dll" (ByVal CachePtr As Long)
Public Declare Function rasCreatePageCache Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PixFmt As TPDFPixFormat, ByVal HBorder As Long, ByVal VBorder As Long, ByVal BackColor As Long) As Long
Public Declare Sub rasDeletePageCache Lib "dynapdf.dll" (ByRef CachePtr As Long)
Public Declare Function rasExecBookmark Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Handle As Long, ByRef NewX As Long, ByRef NewY As Long, ByRef NewZoom As Single, ByRef NewPageScale As TPDFPageScale, ByVal Action As Long) As TUpdBmkAction
Public Declare Function rasGetCurrPage Lib "dynapdf.dll" (ByVal IPDF As Long) As Long
Public Declare Function rasGetCurrZoom Lib "dynapdf.dll" (ByVal CachePtr As Long) As Single
Public Declare Function rasGetDefPageLayout Lib "dynapdf.dll" (ByVal CachePtr As Long) As TPageLayout
Public Declare Function rasGetPageAt Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal ScrollX As Long, ByVal ScrollY As Long, ByVal X As Long, ByVal Y As Long) As Long
Public Declare Function rasGetPageLayout Lib "dynapdf.dll" (ByVal CachePtr As Long) As TPageLayout
Public Declare Function rasGetPageMatrix Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal CursorX As Long, ByVal CursorY As Long, ByRef DestX As Long, ByRef DestY As Long, ByRef Width As Long, ByRef Height As Long, ByRef Matrix As TCTM) As Long
Public Declare Function rasGetPageScale Lib "dynapdf.dll" (ByVal CachePtr As Long) As TPDFPageScale
Public Declare Function rasGetRotate Lib "dynapdf.dll" (ByVal CachePtr As Long) As Long
Public Declare Function rasGetScrollLineDelta Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Vertical As Long) As Long
Public Declare Function rasGetScrollPos Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Vertical As Long, ByVal PageNum As Long) As Long
Public Declare Function rasGetScrollRange Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Vertical As Long, ByRef Max As Long, ByRef SmallChange As Long, ByRef LargeChange As Long) As Long
Public Declare Function rasInitBaseObjects Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Width As Long, ByVal Height As Long, ByVal Flags As TInitCacheFlags) As Long
Public Declare Function rasInitColorManagement Lib "dynapdf.dll" (ByVal CachePtr As Long, ByRef Profiles As TPDFColorProfiles, ByVal Flags As TPDFInitCMFlags) As Long
Public Declare Function rasInitialize Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Priority As TPDFThreadPriority) As Long
Public Declare Function rasMouseDown Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal X As Long, ByVal Y As Long) As TPDFCursor
Public Declare Function rasMouseMove Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal hWnd As Long, ByVal LeftBtnDown As Long, ByRef ScrollX As Long, ByRef ScrollY As Long, ByVal X As Long, ByVal Y As Long) As TUpdScrollbar
Public Declare Function rasPaint Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal DC As Long, ByRef ScrollX As Long, ByRef ScrollY As Long) As TUpdScrollbar
Public Declare Sub rasResetMousePos Lib "dynapdf.dll" (ByVal CachePtr As Long)
Public Declare Function rasResize Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Width As Long, ByVal Height As Long) As Long
Public Declare Function rasProcessErrors Lib "dynapdf.dll" (ByVal CachePtr As Long) As Long
Public Declare Function rasScroll Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Vertical As Long, ByVal ScrollCode As Long, ByRef ScrollX As Long, ByRef ScrollY As Long) As TUpdScrollbar
Public Declare Function rasSetCMapDirA Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal APath As String, ByVal Flags As TLoadCMapFlags) As Long
Public Declare Function rasSetCMapDirW Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal APath As Long, ByVal Flags As TLoadCMapFlags) As Long
Public Declare Sub rasSetDefPageLayout Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As TPageLayout)
Public Declare Function rasSetMinLineWidth Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Value As Single) As Long
Public Declare Function rasSetOCGState Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Handle As Long, ByVal Visible As Long, ByVal SaveState As Long) As Long
Public Declare Sub rasSetOnPaintCallback Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal UserData As Long, ByVal Callback As Long)
Public Declare Sub rasSetPageLayout Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As TPageLayout)
Public Declare Sub rasSetPageScale Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As TPDFPageScale)
Public Declare Sub rasSetRotate Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As Long)
Public Declare Function rasSetScrollLineDelta Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Vertical As Long, ByVal Value As Long) As Long
Public Declare Sub rasSetThreadPriority Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal UpdateThread As TPDFThreadPriority, ByVal RenderThread As TPDFThreadPriority)
Public Declare Function rasZoom Lib "dynapdf.dll" (ByVal CachePtr As Long, ByVal Value As Single, ByRef HorzPos As Long, ByRef VertPos As Long) As Long

' ----------------------------------- Rendering API -----------------------------------

Public Declare Function rasAttachImageBuffer Lib "dynapdf.dll" (ByVal RasPtr As Long, ByVal Rows As Long, ByVal Buffer As Long, ByVal Width As Long, ByVal Height As Long, ByVal ScanlineLen As Long) As Long
Public Declare Sub rasCalcPagePixelSize Lib "dynapdf.dll" (ByVal PagePtr As Long, ByVal DefScale As TPDFPageScale, ByVal ScaleFactor As Single, ByVal FrameWidth As Long, ByVal FrameHeight As Long, ByVal Flags As TRasterFlags, ByRef Width As Long, ByRef Height As Long)
Public Declare Function rasCreateRasterizer Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Rows As Long, ByVal Buffer As Long, ByVal Width As Long, ByVal Height As Long, ByVal ScanlineLen As Long, ByVal PixFmt As TPDFPixFormat) As Long
Public Declare Function rasCreateRasterizerEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal DC As Long, ByVal Width As Long, ByVal Height As Long, ByVal PixFmt As TPDFPixFormat) As Long
Public Declare Sub rasDeleteRasterizer Lib "dynapdf.dll" (ByRef RasPtr As Long)
Public Declare Function rasGetWidthHeight Lib "dynapdf.dll" (ByVal PagePtr As Long, ByVal Flags As TRasterFlags, ByRef Width As Single, ByRef Height As Single, ByVal Rotate As Long, ByRef BBox As Long) As Long
Public Declare Sub rasRedraw Lib "dynapdf.dll" (ByVal RasPtr As Long, ByVal DC As Long, ByVal DestX As Long, ByVal DestY As Long)
Public Declare Function rasResizeBitmap Lib "dynapdf.dll" (ByVal RasPtr As Long, ByVal DC As Long, ByVal Width As Long, ByVal Height As Long) As Long
Public Declare Sub rasSetMinLineWidth2 Lib "dynapdf.dll" (ByVal RasPtr As Long, ByVal Value As Single)
Public Declare Sub rasSetScreenRes Lib "dynapdf.dll" (ByVal RasPtr As Long, ByVal Value As Long)

' ----------------------------------- DynaPDF API -------------------------------------

Public Declare Sub rasAbort Lib "dynapdf.dll" (ByVal RasPtr As Long)
Public Declare Function pdfAddActionToObj Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As Long, ByVal AEvent As Long, ByVal ActHandle As Long, ByVal ObjHandle As Long) As Long
Public Declare Function pdfAddAnnotToPage Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PageNum As Long, ByVal Handle As Long) As Long
Public Declare Function pdfAddArticle Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PosX As Double, ByVal PosY As Double, ByVal Width As Double, ByVal Height As Double) As Long
Public Declare Function pdfAddBookmarkA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal DestPage As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkExA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkExW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal NamedDest As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkEx2AA Lib "dynapdf.dll" Alias "pdfAddBookmarkEx2A" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As String, ByVal Unicode As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkEx2AW Lib "dynapdf.dll" Alias "pdfAddBookmarkEx2A" (ByVal IPDF As Long, ByVal Title As String, ByVal Parent As Long, ByVal NamedDest As Long, ByVal Unicode As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkEx2WA Lib "dynapdf.dll" Alias "pdfAddBookmarkEx2W" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal NamedDest As String, ByVal Unicode As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddBookmarkEx2WW Lib "dynapdf.dll" Alias "pdfAddBookmarkEx2W" (ByVal IPDF As Long, ByVal Title As Long, ByVal Parent As Long, ByVal NamedDest As Long, ByVal Unicode As Long, ByVal DoOpen As Long) As Long
Public Declare Function pdfAddButtonImageW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal BtnHandle As Long, ByVal State As Long, ByVal Caption As Long, ByVal ImgFile As Long) As Long
Public Declare Function pdfAddButtonImageEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal BtnHandle As Long, ByVal State As Long, ByVal Caption As String, ByVal Handle As Long) As Long
Public Declare Function pdfAddButtonImageEx2 Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal BtnHandle As Long, ByVal State As Long, ByVal Caption As Long, ByRef Buffer As Any, ByVal BufSize As Long) As Long
Public Declare Function pdfAddContinueTextA Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As String) As Long
Public Declare Function pdfAddContinueTextW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AText As Long) As Long
Public Declare Function pdfChangeNamedDestW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ObjType As TObjType, ByVal Handle As Long, ByVal NewDestName As Long) As Long
Public Declare Function pdfGetAnnotColor Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByVal ColorType As TAnnotColor, ByRef CS As TPDFColorSpace, ByRef Color As Long) As Long
Public Declare Function pdfGetAnnotTextAlign Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long) As Long
Public Declare Function pdfGetBookmarkEx Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Handle As Long, ByRef Bmk As TPDFBookmark_I) As Long
Public Declare Function pdfGetCollectionInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Value As TPDFCollectionInfo_I) As Long
Public Declare Function pdfGetInEncryptionInfo Lib "dynapdf.dll" (ByVal IPDF As Long, ByRef Info As TPDFEncryptInfo) As Long
Public Declare Function pdfGetTextBBoxW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Text As Long, ByVal sLen As Long, ByRef BBox As TBBox) As Long
Public Declare Function pdfOpenTagBBoxW Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal Tag As TPDFBaseTag, ByVal Lang As String, ByVal AltText As Long, ByVal Expansion As Long, ByRef BBox As TBBox) As Long
Public Declare Function pdfSetRenderingIntent Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal ImgHandle As Long, ByVal Value As TRenderingIntent) As Long
Public Declare Function pdfTestPassword Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal PwdType As TPwdType, ByVal Value As Long) As Long

' -------------------------------------------------------------------------------------


' The following callback functions are used to raise events. Set a break point into the callback to see how the strings
' must be copied into VB strings.

Private Function GetInstance(ByVal Data As Long) As IPDFCallBack
   Dim p As Object
   ' Get the instance pointer back
   pdfCopyPtr Data, p
   ' Copy the pointer
   Set GetInstance = p
   ' Set the pointer back to nothing
   pdfCopyPtr 0&, p
End Function

' FamilyName is a Unicode string, the PostScriptName is an ANSI string!
Public Function pdf_EnumFontsProc(ByVal Data As Long, ByVal FamilyName As Long, ByVal PostScriptName As Long, ByVal Style As Long) As Long
   On Error Resume Next
   Dim DoBreak As Boolean
   DoBreak = False
   If Data = 0 Then
      pdf_EnumFontsProc = 1
   Else
      GetInstance(Data).EnumFonts FamilyName, PostScriptName, Style, DoBreak
      pdf_EnumFontsProc = (DoBreak = True)
   End If
End Function

Public Function pdf_EnumFontsProc2(ByVal Data As Long, ByVal PDFFont As Long, ByVal FontType As TFontType, ByVal BaseFont As Long, ByVal FontName As Long, ByVal Embedded As Long, ByVal IsFormFont As Long, ByVal Flags As Long) As Long
   On Error Resume Next
   Dim DoBreak As Boolean
   DoBreak = False
   If Data = 0 Then
      pdf_EnumFontsProc2 = 1
   Else
      GetInstance(Data).EnumDocFonts PDFFont, FontType, BaseFont, FontName, Embedded, IsFormFont, Flags, DoBreak
      pdf_EnumFontsProc2 = (DoBreak = True)
   End If
End Function

Public Function pdf_EnumFontsProcEx(ByVal Data As Long, ByVal FamilyName As Long, ByVal PostScriptName As Long, ByVal Style As Long, ByVal BaseType As Long, ByVal Flags As TEnumFontProcFlags, ByVal FilePath As Long) As Long
   On Error Resume Next
   Dim DoBreak As Boolean
   DoBreak = False
   If Data = 0 Then
      pdf_EnumFontsProcEx = 1
   Else
      GetInstance(Data).EnumFontsEx FamilyName, PostScriptName, Style, BaseType, Flags, FilePath, DoBreak
      pdf_EnumFontsProcEx = (DoBreak = True)
   End If
End Function

' Notice: Data is the user defined pointer that was passed to pdfSetOnErrorProc(). You can use pdfCopyMem() to copy the
' data behind the pointer to any user defined data structure.
Public Function pdf_ErrorProc(ByVal Data As Long, ByVal ErrCode As Long, ByVal ErrMessage As Long, ByVal ErrType As Long) As Long
   On Error Resume Next
   Dim DoBreak As Boolean
   DoBreak = False
   If Data = 0 Then
      'Default to ABORT Processing
      pdf_ErrorProc = 1
   Else
      GetInstance(Data).ErrorProc ErrCode, ErrMessage, ErrType, DoBreak
      pdf_ErrorProc = DoBreak
   End If
End Function

' ------------------------------------- Callback function for WriteFText ----------------------------------------

' The TOnPageBreakProc (see below) function is called by WriteFText when the rectangle was filled with text,
' or when a manual page break was inserted to the text and more text is available for output.
' You must set the text rectangle with SetTextRect to continue the text on a new position or simply call
' EndPage() and then Append() or EditPage() to continue the text on an arbitrary new page. You can make some
' changes inside the callback function such as setting another font, font color or other thinks.

' When the callback function returns a value greater or equal zero, processing continues on the new
' position or page that was set inside the callback function.

' The text alignment can also be changed with the following return values:

'Const NEW_ALIGN_LEFT = 1
'Const NEW_ALIGN_RIGHT = 2
'Const NEW_ALIGN_CENTER = 3
'Const NEW_ALIGN_JUSTIFY = 4

' When the return value of the callback function is one of the values listed above, then the alignment will
' be changed before the remaining text will be processed. A return value of 0 determines that processing should
' be continued without changing the alignment.

' A negative return value breaks the processing and WriteFText returns emmidiatly with a warning. Note that
' processing stops entirely when warnings should be handled as fatal errors (see SetErrorMode in the help
' file for further information).

' NOTE: The coordinate system is always set to bottom up when the callback function is called, independent
' of the coordinate system that was set before WriteFText was called. WriteFText restores the coordinate system
' and all other temporarily changed variables when the function is leaved. The last text position is
' also returned in bottom up coordinates. LastPosY is the position of the last baseline.

' You can change the coordinate system inside the callback function when needed, DynaPDF checks the state
' before processing continues.

Public Function pdf_OnPageBreakProc(ByVal Data As Long, ByVal LastPosX As Double, ByVal LastPosY As Double, ByVal PageBreak As Long) As Long
   Dim DoBreak As Boolean
   Dim NewAlign As TNewAlign
   DoBreak = False
   NewAlign = naUnchanged
   If Data = 0 Then
      pdf_OnPageBreakProc = -1
   Else
      GetInstance(Data).OnPageBreakProc LastPosX, LastPosY, PageBreak, NewAlign, DoBreak
      If Not DoBreak Then
         pdf_OnPageBreakProc = NewAlign
      Else
         pdf_OnPageBreakProc = -1
      End If
   End If
End Function

' -------------------------- Example callback functions to control a progress bar --------------------------------

' pdf_InitProgress is called before pdf_Progress is called the first time
Public Sub pdf_InitProgress(ByVal Data As Long, ByVal ProgType As Long, ByVal MaxCount As Long)
   Dim DoBreak As Boolean
   DoBreak = False
   If Data <> 0 Then GetInstance(Data).InitProgress ProgType, MaxCount
End Sub

Public Function pdf_Progress(ByVal Data As Long, ByVal ActivePage As Long) As Long
   Dim DoBreak As Boolean
   DoBreak = False
   If Data = 0 Then
      pdf_Progress = 1
   Else
      GetInstance(Data).Progress ActivePage, DoBreak
      pdf_Progress = (DoBreak = True)
   End If
End Function
