VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CPDFTable"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Enum TCellContType
   cctText
   cctImage
   cctTable
   cctTemplate
   cctAction
End Enum

Enum TColumnAdjust
   coaUniqueWidth ' Set the column widths uniquely to TableWidth / NumColumns
   coaAdjLeft     ' Decrease or increase the column widths starting from the left side
   coaAdjRight    ' Decrease or increase the column widths starting from the right side
End Enum

Enum TDeleteContent
   dcText = &H1              ' Text is always a foreground object
   dcImage = &H2
   dcTemplate = &H4          ' PDF or EMF objects
   dcTable = &H8
   dcAction = &H10           ' A cell action is always a background object
   dcAllCont = &H1F          ' Delete all content types
   dcForeGround = &H10000000
   dcBackGround = &H20000000
   dcBoth = &H30000000       ' Delete both foreground and background objects
End Enum

Enum TCellSide
   csLeft
   csBottom
   csRight
   csTop
End Enum

Enum TTableColor
   tcBackColor = 0     ' Table, Columns, Rows, Cells -> default none (transparent)
   tcBorderColor = 1   ' Table Columns Rows Cells -> default black
   tcGridHorzColor = 2 ' Table                       -> default black
   tcGridVertColor = 3 ' Table                       -> default black
   tcImageColor = 4    ' Table, Columns, Rows, Cells -> default RGB black
   tcTextColor = 5     ' Table, Columns, Rows, Cells -> default black
End Enum

Enum TTableBoxProperty
   tbpBorderWidth = 0 ' Table Columns Rows Cells -> default (0 0 0 0)
   tbpCellSpacing = 1 ' Table Columns Rows Cells -> default (0 0 0 0)
   tbpCellPadding = 2 ' Table Columns Rows Cells -> default (0 0 0 0)
End Enum

Enum TTableFlags
   tfDefault = 0
   tfStatic = 1           ' This flag marks a row column or cell as static to avoid the deletion of the content with ClearContent().
   tfHeaderRow = 2        ' Header rows are drawn first after a page break occurred
   tfNoLineBreak = 4      ' Prohibit line breaks in cells whith text -> Can be set to the entire table, columns, rows, and cells
   tfScaleToRect = 8      ' If set, the specified output width and height represents the maximum size of the image or template.
                          ' The image or template is scaled into this rectangle without changing the aspect ratio.
   tfUseImageCS = 16      ' If set, images are inserted in the native image color space.
   tfAddFlags = 32        ' If set, the new flags are added to the current ones. If absent, the new flags override the previous value.
   tfFixedTextHeight = 64 ' If set, text does not increase the row height if necessary. The row height must be non-zero in this case.
End Enum

Private m_PDF As CPDF
Private m_SubTables() As CPDFTable
Private m_SubTablesCount As Long
Private m_Table As Long

Private Declare Function tblAddColumn Lib "dynapdf.dll" (ByVal Table As Long, ByVal Left As Long, ByVal Width As Single) As Long
Private Declare Function tblAddRow Lib "dynapdf.dll" (ByVal Table As Long, ByVal Height As Single) As Long
Private Declare Function tblAddRows Lib "dynapdf.dll" (ByVal Table As Long, ByVal Count As Long, ByVal Height As Single) As Long
Private Declare Sub tblClearColumn Lib "dynapdf.dll" (ByVal Table As Long, ByVal Col As Long, ByVal Types As TDeleteContent)
Private Declare Sub tblClearContent Lib "dynapdf.dll" (ByVal Table As Long, ByVal Types As TDeleteContent)
Private Declare Sub tblClearRow Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Types As TDeleteContent)
Private Declare Function tblCreateTable Lib "dynapdf.dll" (ByVal IPDF As Long, ByVal AllocRows As Long, ByVal NumCols As Long, ByVal Width As Single, ByVal DefRowHeight As Single) As Long
Private Declare Sub tblDeleteCol Lib "dynapdf.dll" (ByVal Table As Long, ByVal Col As Long)
Private Declare Sub tblDeleteRow Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long)
Private Declare Sub tblDeleteRows Lib "dynapdf.dll" (ByVal Table As Long)
Private Declare Sub tblDeleteTable Lib "dynapdf.dll" (ByRef Table As Long)
Private Declare Function tblDrawTable Lib "dynapdf.dll" (ByVal Table As Long, ByVal x As Single, ByVal y As Single, ByVal MaxHeight As Single) As Single
Private Declare Function tblGetFirstRow Lib "dynapdf.dll" (ByVal Table As Long) As Long
Private Declare Function tblGetFlags Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long) As Long
Private Declare Function tblGetNextHeight Lib "dynapdf.dll" (ByVal Table As Long, ByVal MaxHeight As Single, ByRef NextRow As Long) As Single
Private Declare Function tblGetNextRow Lib "dynapdf.dll" (ByVal Table As Long) As Long
Private Declare Function tblGetNumCols Lib "dynapdf.dll" (ByVal Table As Long) As Long
Private Declare Function tblGetNumRows Lib "dynapdf.dll" (ByVal Table As Long) As Long
Private Declare Function tblGetTableHeight Lib "dynapdf.dll" (ByVal Table As Long) As Single
Private Declare Function tblGetTableWidth Lib "dynapdf.dll" (ByVal Table As Long) As Single
Private Declare Function tblHaveMore Lib "dynapdf.dll" (ByVal Table As Long) As Long
Private Declare Function tblSetBoxProperty Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal PropType As TTableBoxProperty, ByVal Left As Single, ByVal Right As Single, ByVal Top As Single, ByVal Bottom As Single) As Long
Private Declare Function tblSetCellAction Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ActionHandle As Long, ByVal Mode As THighlightMode) As Long
Private Declare Function tblSetCellDashPattern Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Side As TCellSide, ByVal Style As TLineCapStyle, ByRef Dash() As Single, ByVal NumValues As Long, ByVal Phase As Single) As Long
Private Declare Function tblSetCellImageW Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal Width As Single, ByVal Height As Single, ByVal Image As Long, ByVal Index As Long) As Long
Private Declare Function tblSetCellImageEx Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal Width As Single, ByVal Height As Single, ByRef Buffer As Any, ByVal BufSize As Long, ByVal Index As Long) As Long
Private Declare Function tblSetCellOrientation Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Orientation As Long) As Long
Private Declare Function tblSetCellTable Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal SubTable As Long) As Long
Private Declare Function tblSetCellTemplate Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal TmplHandle As Long, ByVal Width As Single, ByVal Height As Single) As Long
Private Declare Function tblSetCellTextA Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Align As TTextAlign, ByVal VAlign As TCellAlign, ByVal Text As String, ByVal sLen As Long) As Long
Private Declare Function tblSetCellTextW Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Align As TTextAlign, ByVal VAlign As TCellAlign, ByVal Text As Long, ByVal sLen As Long) As Long
Private Declare Function tblSetColor Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ClrType As TTableColor, ByVal CS As TPDFColorSpace, ByVal Color As Long) As Long
Private Declare Function tblSetColorEx Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal ClrType As TTableColor, ByRef Color As Any, ByVal NumComps As Long, ByVal CS As TExtColorSpace, ByVal Handle As Long) As Long
Private Declare Function tblSetColWidth Lib "dynapdf.dll" (ByVal Table As Long, ByVal Col As Long, ByVal Width As Single, ByVal ExtTable As Long) As Long
Private Declare Function tblSetFlags Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Flags As TTableFlags) As Long
Private Declare Function tblSetFontW Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Name As Long, ByVal Style As TFStyle, ByVal Embed As Long, ByVal CP As TCodepage) As Long
Private Declare Function tblSetFontSelMode Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Mode As TFontSelMode) As Long
Private Declare Function tblSetFontSize Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Col As Long, ByVal Value As Single) As Long
Private Declare Function tblSetGridWidth Lib "dynapdf.dll" (ByVal Table As Long, ByVal Horz As Single, ByVal Vert As Single) As Long
Private Declare Sub tblSetPDFInstance Lib "dynapdf.dll" (ByVal Table As Long, ByVal IPDF As Long)
Private Declare Function tblSetRowHeight Lib "dynapdf.dll" (ByVal Table As Long, ByVal Row As Long, ByVal Value As Single) As Long
Private Declare Sub tblSetTableWidth Lib "dynapdf.dll" (ByVal Table As Long, ByVal Value As Single, ByVal AdjustType As TColumnAdjust, ByVal MinColWidth As Single)


Private Sub Class_Terminate()
   If m_SubTablesCount > 0 Then
      Dim i As Long
      For i = 0 To m_SubTablesCount - 1
         Set m_SubTables(i) = Nothing
      Next i
      Erase m_SubTables
   End If
   If m_Table <> 0 Then tblDeleteTable m_Table
   Set m_PDF = Nothing
End Sub

Friend Function AddColumn(ByVal Left As Long, ByVal Width As Single) As Long
   AddColumn = tblAddColumn(m_Table, Left, Width)
End Function

Friend Function AddRow(ByVal Height As Single) As Long
   AddRow = tblAddRow(m_Table, Height)
End Function

Friend Function AddRows(ByVal Count As Long, ByVal Height As Single) As Long
   AddRows = tblAddRows(m_Table, Count, Height)
End Function

Friend Sub ClearColumn(ByVal Col As Long, ByVal Types As TDeleteContent)
   tblClearColumn m_Table, Col, Types
End Sub

Friend Sub ClearContent(ByVal Types As TDeleteContent)
   tblClearContent m_Table, Types
End Sub

Friend Sub ClearRow(ByVal Row As Long, ByVal Types As TDeleteContent)
   tblClearRow m_Table, Row, Types
End Sub

Friend Sub CreateTable(ByVal PDFInst As CPDF, ByVal AllocRows As Long, ByVal NumCols As Long, ByVal Width As Single, ByVal DefRowHeight As Single)
   ' We increment the reference counter of the PDF class to make sure that it will not be deleted before the table is released
   If m_Table <> 0 Then
      tblDeleteTable m_Table
      Set m_PDF = Nothing
   End If
   Set m_PDF = PDFInst
   m_Table = tblCreateTable(m_PDF.GetInstancePtr(), AllocRows, NumCols, Width, DefRowHeight)
   If m_Table = 0 Then Err.Raise 1, , "Out of memory!"
End Sub

Friend Sub DeleteCol(ByVal Col As Long)
   tblDeleteCol m_Table, Col
End Sub

Friend Sub DeleteRow(ByVal Row As Long)
   tblDeleteRow m_Table, Row
End Sub

Friend Sub DeleteRows()
   tblDeleteRows m_Table
End Sub

Friend Function DrawTable(ByVal x As Single, ByVal y As Single, ByVal MaxHeight As Single) As Single
   Call tblSetPDFInstance(m_Table, m_PDF.GetInstancePtr())
   DrawTable = tblDrawTable(m_Table, x, y, MaxHeight)
End Function

Friend Function GetFirstRow() As Long
   GetFirstRow = tblGetFirstRow(m_Table)
End Function

Friend Function GetFlags(ByVal Row As Long, ByVal Col As Long) As Long
   GetFlags = tblGetFlags(m_Table, Row, Col)
End Function

Friend Function GetInstancePtr() As Long
   GetInstancePtr = m_Table
End Function

Friend Function GetNextHeight(ByVal MaxHeight As Single, ByRef NextRow As Long) As Single
   GetNextHeight = tblGetNextHeight(m_Table, MaxHeight, NextRow)
End Function

Friend Function GetNextRow() As Long
   GetNextRow = tblGetNextRow(m_Table)
End Function

Friend Function GetNumCols() As Long
   GetNumCols = tblGetNumCols(m_Table)
End Function

Friend Function GetNumRows() As Long
   GetNumRows = tblGetNumRows(m_Table)
End Function

Friend Function GetTableHeight() As Single
   GetTableHeight = tblGetTableHeight(m_Table)
End Function

Friend Function GetTableWidth() As Single
   GetTableWidth = tblGetTableWidth(m_Table)
End Function

Friend Function HaveMore() As Boolean
   HaveMore = tblHaveMore(m_Table) <> 0
End Function

Friend Function SetBoxProperty(ByVal Row As Long, ByVal Col As Long, ByVal PropType As TTableBoxProperty, ByVal Left As Single, ByVal Right As Single, ByVal Top As Single, ByVal Bottom As Single) As Boolean
   SetBoxProperty = tblSetBoxProperty(m_Table, Row, Col, PropType, Left, Right, Top, Bottom) <> 0
End Function

Friend Function SetCellAction(ByVal Row As Long, ByVal Col As Long, ByVal ActionHandle As Long, ByVal Mode As THighlightMode) As Boolean
   SetCellAction = tblSetCellAction(m_Table, Row, Col, ActionHandle, Mode) <> 0
End Function

Friend Function SetCellDashPattern(ByVal Row As Long, ByVal Col As Long, ByVal Side As TCellSide, ByVal Style As TLineCapStyle, ByRef Dash() As Single, ByVal Phase As Single) As Boolean
   SetCellDashPattern = tblSetCellDashPattern(m_Table, Row, Col, Side, Style, Dash, UBound(Dash) + 1, Phase) <> 0
End Function

Friend Function SetCellImage(ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Boolean, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal Width As Single, ByVal Height As Single, ByVal Image As String, ByVal Index As Long) As Boolean
   SetCellImage = tblSetCellImageW(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, StrPtr(Image), Index) <> 0
End Function

Friend Function SetCellImageEx(ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Boolean, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal Width As Single, ByVal Height As Single, ByRef Buffer() As Byte, ByVal Index As Long) As Boolean
   SetCellImageEx = tblSetCellImageEx(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, Buffer(0), UBound(Buffer) + 1, Index) <> 0
End Function

Friend Function SetCellOrientation(ByVal Row As Long, ByVal Col As Long, ByVal Orientation As Long) As Boolean
   SetCellOrientation = tblSetCellOrientation(m_Table, Row, Col, Orientation) <> 0
End Function

Friend Function SetCellTable(ByVal Row As Long, ByVal Col As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal SubTable As CPDFTable) As Boolean
   ' We store a reference of the sub table in an array to avoid the deletion. This makes sure that the pointer of the sub table stays valid for the entire lifetime of the table that holds a reference of it.
   If m_SubTablesCount > 0 Then
      Dim i, e As Long
      i = 0
      e = m_SubTablesCount - 1
      Dim found As Boolean
      ' Already in the list?
      Do While i <= e
         If m_SubTables(i) = SubTable Then
            found = True
            Exit Do
         End If
         If m_SubTables(e) = SubTable Then
            found = True
            Exit Do
         End If
         i = i + 1
         e = e - 1
      Loop
      If Not found Then
         ReDim m_SubTables(m_SubTablesCount)
         m_SubTablesCount = m_SubTablesCount + 1
         Set m_SubTables(e) = SubTable
      End If
   Else
      ReDim m_SubTables(m_SubTablesCount)
      m_SubTablesCount = m_SubTablesCount + 1
      Set m_SubTables(0) = SubTable
   End If
   SetCellTable = tblSetCellTable(m_Table, Row, Col, HAlign, VAlign, SubTable.GetInstancePtr()) <> 0
End Function

Friend Function SetCellTemplate(ByVal Row As Long, ByVal Col As Long, ByVal ForeGround As Long, ByVal HAlign As TCellAlign, ByVal VAlign As TCellAlign, ByVal TmplHandle As Long, ByVal Width As Single, ByVal Height As Single) As Boolean
   SetCellTemplate = tblSetCellTemplate(m_Table, Row, Col, ForeGround, HAlign, VAlign, TmplHandle, Width, Height) <> 0
End Function

Friend Function SetCellText(ByVal Row As Long, ByVal Col As Long, ByVal HAlign As TTextAlign, ByVal VAlign As TCellAlign, ByVal Text As String) As Boolean
   SetCellText = tblSetCellTextW(m_Table, Row, Col, HAlign, VAlign, StrPtr(Text), Len(Text)) <> 0
End Function

Friend Function SetCellTextA(ByVal Row As Long, ByVal Col As Long, ByVal HAlign As TTextAlign, ByVal VAlign As TCellAlign, ByVal Text As String) As Boolean
   SetCellTextA = tblSetCellTextA(m_Table, Row, Col, HAlign, VAlign, Text, Len(Text)) <> 0
End Function

Friend Function SetCellTextW(ByVal Row As Long, ByVal Col As Long, ByVal HAlign As TTextAlign, ByVal VAlign As TCellAlign, ByVal Text As String) As Boolean
   SetCellTextW = tblSetCellTextW(m_Table, Row, Col, HAlign, VAlign, StrPtr(Text), Len(Text)) <> 0
End Function

Friend Function SetColor(ByVal Row As Long, ByVal Col As Long, ByVal ClrType As TTableColor, ByVal CS As TPDFColorSpace, ByVal Color As Long) As Boolean
   SetColor = tblSetColor(m_Table, Row, Col, ClrType, CS, Color) <> 0
End Function

Friend Function SetColorEx(ByVal Row As Long, ByVal Col As Long, ByVal ClrType As TTableColor, ByRef Color() As Single, ByVal CS As TExtColorSpace, ByVal Handle As Long) As Boolean
   SetColorEx = tblSetColorEx(m_Table, Row, Col, ClrType, Color(0), UBound(Color) + 1, CS, Handle) <> 0
End Function

Friend Function SetColWidth(ByVal Col As Long, ByVal Width As Single, ByVal ExtTable As Boolean) As Boolean
   SetColWidth = tblSetColWidth(m_Table, Col, Width, ExtTable) <> 0
End Function

Friend Function SetFlags(ByVal Row As Long, ByVal Col As Long, ByVal Flags As TTableFlags) As Boolean
   SetFlags = tblSetFlags(m_Table, Row, Col, Flags) <> 0
End Function

Friend Function SetFont(ByVal Row As Long, ByVal Col As Long, ByVal Name As String, ByVal Style As TFStyle, ByVal Embed As Boolean, ByVal CP As TCodepage) As Boolean
   SetFont = tblSetFontW(m_Table, Row, Col, StrPtr(Name), Style, Embed, CP) <> 0
End Function

Friend Function SetFontSelMode(ByVal Row As Long, ByVal Col As Long, ByVal Mode As TFontSelMode) As Boolean
   SetFontSelMode = tblSetFontSelMode(m_Table, Row, Col, Mode) <> 0
End Function

Friend Function SetFontSize(ByVal Row As Long, ByVal Col As Long, ByVal Value As Single) As Boolean
   SetFontSize = tblSetFontSize(m_Table, Row, Col, Value) <> 0
End Function

Friend Function SetGridWidth(ByVal Horz As Single, ByVal Vert As Single) As Boolean
   SetGridWidth = tblSetGridWidth(m_Table, Horz, Vert) <> 0
End Function

Friend Function SetRowHeight(ByVal Row As Long, ByVal Value As Single) As Boolean
   SetRowHeight = tblSetRowHeight(m_Table, Row, Value) <> 0
End Function

Friend Sub SetTableWidth(ByVal Value As Single, ByVal AdjustType As TColumnAdjust, ByVal MinColWidth As Single)
   tblSetTableWidth m_Table, Value, AdjustType, MinColWidth
End Sub
