{
           DELPHI INTERFACE FOR DYNAPDF VERSION 4.0.102.
   Copyright (c) Jens Boschulte, DynaForms GmbH, www.dynaforms.com.
   Please report errors and other potential problems to support@dynaforms.com.

   --------------------------------- Thank you! -------------------------------------

   Creation date: June 9, 2025
}

unit dynapdf;
{$LONGSTRINGS ON}
// Treat enums as 32 bit integer!!!
{$Z4}
{$if not defined(FPC) and (CompilerVersion >= 24.0)}
  {$LEGACYIFEND ON}
{$ifend}
{$if defined(WIN64) Or defined(ANDROID64) Or defined(MACOS64) Or defined(OSX64) Or defined(IOS64) Or defined(LINUX64) Or defined(CPUX64) Or defined(CPU64BITS)}
{$A8} // Make sure that structures are quad word aligned
{$ifend}

{$ifdef FPC}
   {$mode delphiunicode}
   {$DEFINE DELPHI6_OR_HIGHER}
   {$DEFINE DELPHI_UNICODE}
{$endif}

{
   To link the library statically define PDF_STATIC at "Project->Options->Building->Delphi Compiler->Conditional defines".
   On Windows we have no static import library but the DLL will be linked dynamically with the delayed keyword, if supported (see line 40).
   The interface classes become a bit smaller when PDF_STATIC is defined but note that the app will be terminated if a required DLL function
   cannot be found. With the build-in library loading mechanism this exception can be handled and the app can be executed, also if the dynapdf.dll
   is not available.

   Note also that the path parameter of TPDF can be considered only if static linking is disabled.
   However, on iOS static linking is required and will be enabled automatically.
}
{$if not defined(IOS) and not defined(PDF_STATIC)}
   {$define DYNLNK}
{$ifend}

{$if not defined(DYNLNK) Or defined(IOS)}
   {$ifdef MSWINDOWS}
      const DYNAPDFLIB = 'dynapdf.dll';
      {$ifdef LOAD_DELAYED_SUPPORT}
         {$define LDELAYED}          // Enable dynamic binding if supported. Requires Delphi 2010 or higher.
         {$WARN SYMBOL_PLATFORM OFF} // Disable the platform warning.
      {$endif}
   {$else}
      {$if defined(PDF_STATIC) Or defined(IOS)}
         const DYNAPDFLIB = 'libdynapdf.a';
      {$elseif defined(MACOS)}
         const DYNAPDFLIB = 'libdynapdf.dylib';
      {$elseif defined(ANDROID32)}
         const DYNAPDFLIB = 'libdynapdf32.so';
      {$elseif defined(ANDROID64)}
         const DYNAPDFLIB = 'libdynapdf64.so';
      {$else}
         const DYNAPDFLIB = 'libdynapdf.so';
      {$ifend}
   {$endif}
{$ifend}

interface

{$ifndef FPC} // Lazarus (Free Pascal)?
   {$UNDEF DELPHI2_OR_HIGHER}
   {$UNDEF DELPHI3_OR_HIGHER}
   {$UNDEF DELPHI4_OR_HIGHER}
   {$UNDEF DELPHI5_OR_HIGHER}
   {$UNDEF DELPHI6_OR_HIGHER}
   {$UNDEF DELPHI7_OR_HIGHER}
   {$UNDEF DELPHI8_OR_HIGHER}
   {$UNDEF DELPHI9_OR_HIGHER}  // 2005
   {$UNDEF DELPHI10_OR_HIGHER} // 2006
   {$UNDEF DELPHI11_OR_HIGHER} // 2007
   {$UNDEF DELPHI_UNICODE}     // WideString is default
   {$UNDEF CROSS_PLATFORM_SUPPORT} // Delphi XE 2 or higher

   {$ifndef VER80} // Delphi 1.0
     {$DEFINE DELPHI2_OR_HIGHER}
     {$ifndef VER90} // Delphi 2.0
        {$ifndef VER93} // C++ Builder 1.0
          {$DEFINE DELPHI3_OR_HIGHER}
          {$ifndef VER100} // Delphi 3.0
             {$ifndef VER110} // C++ Builder 3.0
               {$DEFINE DELPHI4_OR_HIGHER}
               {$ifndef VER120} // Delphi 4.0
                  {$ifndef VER125} // C++ Builder 4.0
                    {$DEFINE DELPHI5_OR_HIGHER}
                     {$ifndef VER130} // Delphi 5
                        {$DEFINE DELPHI6_OR_HIGHER}
                        {$ifndef VER140} // Delphi 6
                           {$DEFINE DELPHI7_OR_HIGHER}
                           {$ifndef VER150} // Delphi 7
                              {$DEFINE DELPHI8_OR_HIGHER}
                              {$ifndef VER160} // Delphi 8
                                 {$DEFINE DELPHI9_OR_HIGHER}
                                 {$ifndef VER170} // Delphi 2005
                                    {$DEFINE DELPHI10_OR_HIGHER}
                                    {$ifndef VER180} // Delphi 2006
                                       {$DEFINE DELPHI11_OR_HIGHER}
                                       {$DEFINE DELPHI_UNICODE} // This is the important point. From now WideString is the default string format.
                                       {$ifndef VER185} // Delphi 2007
                                          {$ifndef VER200} // Delphi 2009
                                             {$ifndef VER210} // Delphi 2010
                                                {$define LOAD_DELAYED_SUPPORT}
                                                {$ifndef VER220} // Delphi XE
                                                   {$ifndef VER230} // Delphi XE 2
                                                      {$DEFINE CROSS_PLATFORM_SUPPORT}
                                                   {$endif}
                                                {$endif}
                                             {$endif}
                                          {$endif}
                                       {$endif}
                                    {$endif}
                                 {$endif}
                              {$endif}
                           {$endif}
                        {$endif}
                     {$endif}
                  {$endif}
               {$endif}
             {$endif}
          {$endif}
        {$endif}
     {$endif}
   {$endif}
{$endif}

// Not sure whether MSWINDOWS is defined in all Delphi versions...
{$ifdef WIN32}
  {$ifndef MSWINDOWS}
     {$DEFINE MSWINDOWS}
  {$endif}
{$endif}

uses {$ifdef MSWINDOWS}Windows, {$endif} Classes {$ifdef FPC}, LCLIntf, dynlibs {$endif};

{ -------------------------------------- Error types, specific error values ------------------------------------- }

{$ifdef FPC}
Type
  HDC          = type Pointer;
  HWND         = type Pointer;
  HBITMAP      = type Pointer;
  HENHMETAFILE = type Pointer;
{$endif}

// For Mac-Delphi
{$ifdef POSIX}
type
  HDC          = type Pointer;
  HWND         = type Pointer;
  HBITMAP      = type Pointer;
  HENHMETAFILE = type Pointer;
{$endif}

{$ifndef DELPHI6_OR_HIGHER}
   type PCardinal  = ^Cardinal;
   type PPointer   = ^Pointer;
   type PPAnsiChar = ^PAnsiChar;
{$endif}

// NativeInt is not defined in earlier versions
{$ifndef DELPHI_UNICODE}
type NativeInt = Integer;
{$endif}

type IEFN    = Pointer; // Embedded file node
type IEVT    = Pointer; // Object event
type IFLD    = Pointer; // Pointer of a field
type PIFLD   = ^IFLD;   // Array of field pointers
type IFSR    = Pointer; // File specification
type ILST    = Pointer; // Ink list pointer
type IMSR    = Pointer; // Pointer of a Measure object
type INFM    = Pointer; // Pointer of a number format object
type IOCG    = Pointer; // Optional Content Group
type IOCN    = Pointer; // Optional Content UI node
type IPGC    = Pointer; // Page cache
type IPGE    = Pointer; // Page object
type IPSR    = Pointer; // Parser Context
type IPTD    = Pointer; // Point data
type IRAS    = Pointer; // Rasterizer
type IRFN    = Pointer; // Related file node
type LGRP    = Pointer; // Pointer of a Layer Group
type PBCD    = Pointer; // Barcode dictionay
type IPDFObj = Pointer; // Generic pointer of a PDSF object
type PFNT    = Pointer; // Font object
type PIMG    = Pointer; // Pointer of an image object
type PINFM   = ^INFM;   // Array of INFM pointers
type PPDF    = Pointer; // PDF Instance
type PIRAS   = ^IRAS;   // Adress of IRAS variable (used in DeleteRasterizer)
type PSIG    = Pointer; // Signature dictionay
type RWND    = Pointer; // Rendering window

type TErrMode = Integer;
const emIgnoreAll       = $00000000;
const emSyntaxError     = $00000001;
const emValueError      = $00000002;
const emWarning         = $00000004;
const emFileError       = $00000008;
const emFontError       = $00000010;
const emAllErrors       = $0000FFFF;
const emNoFuncNames     = $10000000; // Do not print function names in error messages
const emUseErrLog       = $20000000; // Redirect all error messages to the error log
// Special flags for CheckConformance().
// These flags add info messages to the error log. The error callback function is not invoked.
const emLogFonts        = $00010000; // If set, CheckConformance() logs which fonts will were replaced with system fonts or converted to Type3
const emLogFontsVerbose = $00020000; // If set, the path to the font file is added to the error log too

// Error types
const E_WARNING      = $02000000;
const E_SYNTAX_ERROR = $04000000;
const E_VALUE_ERROR  = $08000000;
const E_FONT_ERROR   = $10000000;
const E_FATAL_ERROR  = $20000000;
const E_FILE_ERROR   = $40000000;

// Special error types
const ENEED_PWD        = -($000000B2 or E_FILE_ERROR);
const EWRONG_OPEN_PWD  = -($000000B3 or E_FILE_ERROR);
const EWRONG_OWNER_PWD = -($000000B4 or E_FILE_ERROR);
const EWRONG_PWD       = -($000000B5 or E_FILE_ERROR);

const PDF_MAX_INT      = $7FFFFFFF;

{ ------------------------------------------------- Default types ----------------------------------------------- }

const NO_COLOR: Cardinal = $FFFFFFF1; // Transparent color used by annotations and form fields

// This flag can be combined with the annotation handle in Set3DAnnotProps().
// 3D Annotations with a transparent background are supported since PDF 1.7, Extension Level 3
const TRANSP_3D_ANNOT: Cardinal = $40000000;

type T3DActivationType =
(
   at3D_AppDefault,
   at3D_PageOpen,    // The annotaiton should be activated when the page is opened.
   at3D_PageVisible, // The annotaiton should be activated when the page becomes visible.
   at3D_Explicit     // The annotation should remain inactive until explicitely activated by a script or action (default).
);

type T3DDeActivateType =
(
   dt3D_AppDefault,
   dt3D_PageClosed,    // The annotaiton should be deactivated as soon as the page is closed.
   dt3D_PageInvisible, // The annotaiton should be deactivated as soon as the page becomes invisible (default).
   dt3D_Explicit       // The annotation should remain active until explicitely deactivated by a script or action.
);

type T3DDeActInstance =
(
   di3D_AppDefault,
   di3D_UnInstantiated, // The annotation will be uninstantiated (default)
   di3D_Instantiated,   // The annotation is left instantiated
   di3D_Live            // If the 3D artwork contains an animation then it will stay live
);

type T3DInstanceType =
(
   it3D_AppDefault,
   it3D_Instantiated, // The annotation will be instantiated but animations are disabled.
   it3D_Live          // The annotation will be instantiated and animations are enabled (default).
);

type T3DLightingSheme =
(
   lsArtwork,
   lsBlue,
   lsCAD,
   lsCube,
   lsDay,
   lsHard,
   lsHeadlamp,
   lsNight,
   lsNoLights,
   lsPrimary,
   lsRed,
   lsWhite,
   lsNotSet
);

type T3DNamedAction =
(
   naDefault,
   naFirst,
   naLast,
   naNext,
   naPrevious
);

type T3DProjType =
(
   pt3DOrthographic,
   pt3DPerspective
);

type T3DRenderingMode =
(
   rmBoundingBox,
   rmHiddenWireframe,
   rmIllustration,
   rmShadedIllustration,
   rmShadedVertices,
   rmShadedWireframe,
   rmSolid,
   rmSolidOutline,
   rmSolidWireframe,
   rmTransparent,
   rmTranspBBox,
   rmTranspBBoxOutline,
   rmTranspWireframe,
   rmVertices,
   rmWireframe,
   rmNotSet
);

type T3DScaleType =
(
   st3DValue,
   st3DWidth,
   st3DHeight,
   st3DMin,
   st3DMax
);

type TAFRelationship =
(
   arAssociated,
   arData,
   arSource,
   arSupplement,
   arAlternative,
   arFormData
);

type TAFDestObject =
(
   adAnnotation,
   adCatalog,    // The documents catalog is the root object
   adField,
   adImage,
   adPage,
   adTemplate
);

type TAnnotFlags = Cardinal;
const afNone           = $00000000;
const afInvisible      = $00000001;
const afHidden         = $00000002;
const afPrint          = $00000004;
const afNoZoom         = $00000008;
const afNoRotate       = $00000010;
const afNoView         = $00000020;
const afReadOnly       = $00000040;
const afLocked         = $00000080;
const afToggleNoView   = $00000100;
const afLockedContents = $00000200;

{
   By default all annotations which have an appearance stream and which have the print flag set are flattened.
   All annotations are deleted when the function returns with the exception of file attachment annotations.
   If you want to flatten the view state then set the flag affUseViewState.
}
type TAnnotFlattenFlags = Cardinal;
const affNone                  = $00000000; // Printable annotations independent of the type
const affUseViewState          = $00000001; // If set, annotations which are visible in a viewer become flattened.
const affMarkupAnnots          = $00000002; // If set, markup annotations are flattened only. Link, Sound, or FileAttach
                                         // annotations are no markup annotations. These types will be left intact.
const affNonPDFA_1             = $00000004; // If set, flatten all annotations which are not supported in PDF/A 1.
const affNonPDFA_2             = $00000008; // If set, flatten all annotations which are not supported in PDF/A 2 or 3.
const affNonPDFA_4e            = $00000080; // If set, flatten all annotations which are not supported in PDF/A 4e
const affFormFields            = $00000010; // If set, form fields will be flattened too.
const affUseFieldViewState     = $00000020; // Meaningful only if affFormFields is set. If set, flatten the view state of form fields. Use the print state otherwise.
const affSigFields             = $00000040; // Meaningful only if affFormFields is not set. If set, signed signature fields will be flattened.

const affKeepLinkAnnots        = $00001000; // If set, link annotations will be kept.
const affKeepFileAttach        = $00002000; // If set, file attachment annotations will be kept.
const affKeepTextAnnots        = $00004000; // If set, text annotations will be kept.
const affKeepEmptySigFields    = $00008000; // If set, signature fields which are not already signed will be kept.
const affKeepUnsupportedAnnots = $00010000; // If set, annotations whose appearance stream cannot be rebuild will be kept (3D, Movie, Redact, or RichMedia annotations, for example).

const affPreserveZOrder        = $00400000; // If set, preserve the z-order under any curcumstances. That means visible overlapping annotations or form fields will be flattened, regardless the type.


type TAnnotIcon =
(
  aiComment,
  aiHelp,
  aiInsert,
  aiKey,
  aiNewParagraph,
  aiNote,
  aiParagraph
);

type TActionType =
(
   atGoTo,
   atGoToR,
   atHide,
   atImportData,
   atJavaScript,
   atLaunch,
   atMovie,
   atNamed,
   atRendition,    // PDF 1.5
   atReset,        // ResetForm
   atSetOCGState,  // PDF 1.5
   atSound,
   atSubmit,       // SubmitForm
   atThread,
   atTransition,
   atURI,
   atGoTo3DView,   // PDF 1.6
   atGoToE,        // PDF 1.6 Like atGoToR but refers to an embedded PDF file.
   atRichMediaExec // PDF 1.7 Extension Level 3
);

type TAnnotState =
(
   asNone,
   asAccepted,
   asRejected,
   asCancelled,
   asCompleted,
   asCreateReply // Don't add a migration state, create a reply instead. Set the contents of the reply with SetAnnotString().
);

type TAnnotString =
(
   asAuthor,
   asContent,
   asName,
   asSubject,
   asRichStyle, // Default style string. -> FreeText annotations only.
   asRichText   // Rich text string.     -> Supported by markup annotations.
);

type TAnnotType =
(
   atCaret,
   atCircle,
   atFileLink,    // A Link annotation with an associated GoToR action (go to remote)
   atFreeText,
   atHighlight,   // Highlight annotation
   atInk,
   atLine,
   atPageLink,    // A Link annotation with an associated GoTo action
   atPolygon,
   atPolyLine,
   atPopUp,
   atSquare,
   atSquiggly,    // Highlight annotation
   atStamp,
   atStrikeOut,   // Highlight annotation
   atText,        // Also used as container to store the State Model
   atUnderline,   // Highlight annotation
   atWebLink,     // A Link annotation with an associated URI action
   atWidget,      // Form Fields are handled separately
   at3D,          // PDF 1.6
   atSoundAnnot,  // PDF 1.2
   atFileAttach,  // PDF 1.3
   atRedact,      // PDF 1.7
   atWatermark,   // PDF 1.6
   atUnknown,     // Unknown annotation type
   atMovieAnnot,  // PDF 1.2
   atPrinterMark, // PDF 1.4
   atProjection,  // PDF 1.7 Extension Level 3
   atRichMedia,   // PDF 1.7 Extension Level 3
   atScreen,      // PDF 1.5
   atTrapNet      // PDF 1.3
);

type TBaseEncoding =
(
   beWinAnsi,
   beMacRoman,
   beMacExpert,
   beStandard
);

type TBBox = record
   x1: Single;
   y1: Single;
   x2: Single;
   y2: Single;
end;

type PBBox = ^TBBox;

type TBlendMode =
(
   bmNotSet,
   bmNormal,
   bmColor,
   bmColorBurn,
   bmColorDodge,
   bmDarken,
   bmDifference,
   bmExclusion,
   bmHardLight,
   bmHue,
   bmLighten,
   bmLuminosity,
   bmMultiply,
   bmOverlay,
   bmSaturation,
   bmScreen,
   bmSoftLight
);

type TBorderEffect =
(
   beSolid,   // Default
   beCloudy1, // Circle diameter 9 units
   beCloudy2  // Circle diameter 17 units
);


type TBorderStyle =
(
   bsSolid,
   bsBevelled,
   bsInset,
   bsUnderline,
   bsDashed,
   bsUserDefined // Internal
);

type TBtnCaptionPos =
(
   bcpCaptionOnly,  // Default
   bcpImageOnly,    // No caption; image only
   bcpCaptionBelow, // Caption below the image
   bcpCaptionAbove, // Caption above the image
   bcpCaptionRight, // Caption on the right of the image
   bcpCaptionLeft,  // Caption on the left of the image
   bcpCaptionOver   // Caption overlaid directly on the image
);

type TButtonState =
(
   bsUp,
   bsDown,
   bsRollOver
);

type TCheckBoxChar =
(
   ccCheck,
   ccCircle,
   ccCross1,
   ccCross2,
   ccCross3,
   ccCross4,
   ccDiamond,
   ccSquare,
   ccStar
);

type TCheckOptions = Cardinal;
const coDefault                  = $0010FFFF;
const coEmbedSubsets             = $00000001;
const coDeleteTransferFuncs      = $00000002;
const coDeleteMultiMediaContents = $00000004;
const coDeleteActionsAndScripts  = $00000008;
const coDeleteInvRenderingIntent = $00000010;
const coFlattenFormFields        = $00000020;
const coReplaceV4ICCProfiles     = $00000040;
const coDeleteEmbeddedFiles      = $00000080;
const coDeleteOPIComments        = $00000100;
const coDeleteSignatures         = $00000200;
const coDeletePostscript         = $00000400; // Delete Postscript XObjects. Rarely used and such Postscript fragments are meaningful on a Postscript device only.
                                              // It is usually safe to delete such objects.
const coDeleteAlternateImages    = $00000800; // Alternate images are seldom used and prohibited in PDF/A.
const coReComprJPEG2000Images    = $00001000; // Recompression results usually in larger images. It is often better to keep such files as is.

const coResolveOverprint         = $00002000; // PDF/A 2 and 3. Set the overprint mode to 0 if overprint mode = 1 and if overprinting for fill or stroke is true
                                              // and if an ICCBased CMYK color space is used. Note that DeviceCMYK is treated as ICCBased color space due to implicit
                                              // color conversion rules.
const coMakeLayerVisible         = $00004000; // PDF/A 2 and 3 prohibit invisible layers. Layers can also be flattened if this is no option.
const coDeleteAppEvents          = $00008000; // PDF/A 2 and 3. Application events are prohibited in PDF/A. The view state will be applied.
const coReplCCITTFaxWithFlate    = $00010000; // Replace CCITT Fax compression with Flate.
const coApplyExportState         = $00020000; // Meaningful only if coDeleteAppEvents is set. Apply the export state.
const coApplyPrintState          = $00040000; // Meaningful only if coDeleteAppEvents is set. Apply the print state.

const coCheckImages              = $00800000; // If set, images will be decompressed to identify damaged images.
const coDeleteDamagedImages      = $01000000; // Meaningful only if coCheckImages is set.
const coRepairDamagedImages      = $02000000; // Meaningful only if coCheckImages is set. If set, try to recompress a damaged image.
                                              // The new image is maybe incomplete but error free. This flag can be combined with
                                              // coDeleteDamagedImages. If both flags are set, the function tries to recompress the
                                              // image and when this fails it will be deleted.

const coDeleteReplies            = $00080000; // Delete annotation replies. If absent, replies will be converted to regular text annotations.
const coDeleteHalftones          = $00100000; // Delete halftone screens.
const coFlattenLayers            = $00200000; // Flatten layers if any.
const coDeletePresentation       = $00400000; // Presentations are prohibited in PDF/A 2 and 3.
const coNoFontEmbedding          = $10000000;
const coFlushPages               = $20000000; // Write converted pages directly into the output file to reduce the memory usage.
const coAllowDeviceSpaces        = $40000000; // If set, device color spaces will not be replaced with ICC based color spaces. This flag is meaningful for normalization only.
const coResetAnnotAppearance     = $80000000; // If set, appearance streams of annotations are rebuild before executing CheckConformance().
// Common default flags for normalization:
const coDefault_Normalize        = coAllowDeviceSpaces or coNoFontEmbedding;
// Common default flags for different PDF/A versions:
const coDefault_PDFA_1           = coDefault or coFlattenLayers;                   // The ability to flatten layers was added after coDefault was defined.
const coDefault_PDFA_2           = (coDefault and not coReComprJPEG2000Images) or coDeletePresentation; // Presentations are prohibited in PDF/A 2 and PDF/A 3.
const coDefault_PDFA_3           = coDefault_PDFA_2 and not coDeleteEmbeddedFiles; // Embedded files are allowed in PDF/A 3.
const coDefault_PDFA_4           = coDefault_PDFA_2 and not coDeleteEmbeddedFiles; // Embedded files are allowed in PDF/A 4.

type TCheckBoxState =
(
   cbUnknown,
   cbChecked,
   cbUnChecked
);

type TCIDMetric = record
   Width: Single;
   x:     Single;
   y:     Single;
end;

type PCIDMetric = ^TCIDMetric;

type TClippingMode =
(
  cmEvenOdd,
  cmWinding,
  cmAllEvenOdd,
  cmAllWinding
);

type TCodepage =
(
   cp1250,
   cp1251,
   cp1252,
   cp1253,
   cp1254,
   cp1255,
   cp1256,
   cp1257,
   cp1258,
   cp8859_2,
   cp8859_3,
   cp8859_4,
   cp8859_5,
   cp8859_6,
   cp8859_7,
   cp8859_8,
   cp8859_9,
   cp8859_10,
   cp8859_13,
   cp8859_14,
   cp8859_15,
   cp8859_16,
   cpSymbol,
   cp437,
   cp737,
   cp775,
   cp850,
   cp852,
   cp855,
   cp857,
   cp860,
   cp861,
   cp862,
   cp863,
   cp864,
   cp865,
   cp866,
   cp869,
   cp874,
   cpUnicode,
   cpCJK_Big5_Uni,    // Big5 plus HKSCS extension.
   cpCJK_EUC_JP_Uni,  // EUC-JP
   cpCJK_EUC_KR_Uni,  // EUC-KR
   cpCJK_EUC_TW_Uni,  // CNS-11643-1992 (Planes 1-15).
   cpCJK_GBK_Uni,     // GBK is the Microsoft code page 936 (GB2312, EUC-CN plus GBK extension).
   cpCJK_GB12345_Uni, // GB-12345-1990 (Traditional Chinese form of GB-2312).
   cpCJK_HZ_Uni,      // Mixed ASCII / GB-2312 encoding
   cpCJK_2022_CN_Uni, // ISO-2022-CN-EXT (GB-2312 plus ISO-11643 Planes 1-7).
   cpCJK_2022_JP_Uni, // ISO-2022-JP
   cpCJK_2022_KR_Uni, // ISO-2022-KR
   cpCJK_646_CN_Uni,  // ISO-646-CN (GB-1988-80)
   cpCJK_646_JP_Uni,  // ISO-646-JP (JIS_C6220-1969-RO).
   cpCJK_IR_165_Uni,  // ISO-IR-165 (extended version of GB-2312).
   cpCJK_932_Uni,     // Microsoft extended version of SHIFT_JIS.
   cpCJK_949_Uni,     // EUC-KR extended with UHC (Unified Hangul Codes).
   cpCJK_950_Uni,     // Microsoft extended version of Big5.
   cpCJK_JOHAB_Uni,   // JOHAB
   cpShiftJIS,        // ShiftJIS charset plus code page 932 ectension.
   cpBig5,            // Big5 plus HKSCS extension.
   cpGB2312,          // GB2312 charset plus GBK and cp936 extension.
   cpWansung,         // Wansung
   cpJohab,           // JOHAB
   cpMacRoman,        // Mac Roman
   cpAdobeStd,        // This is an encoding for Type1 fonts. It should normally not be used.
   cpInternal,        // Internal -> not usable
   cpGlyphIndexes,    // Can be used with TrueType and OpenType fonts only. DynaPDF creates a reverse mapping so that copy & paste will work.
   cpPDFDocEnc,       // Internal -> not usable. Used for form fonts. This is a superset of the code page 1252 and MacRoman.
   cpExtCMap,         // Internal -> not usable. This code page is set when a font was loaded with an external cmap.
   cpDingbats,        // Internal -> Special encoding for ZapfDingbats
   cpMacExpert,       // Internal -> not usable.
   cpRoman8           // This is a standard PCL 5/6 code page
);

type TColorConvFlags = Cardinal;
const ccfBW_To_Gray   = $00000000; // Default, RGB Black and White set with rg or RG inline operators are converted to gray
const ccfRGB_To_Gray  = $00000001; // If set, inline color operators rg and RG are converted to gray
const ccfToGrayAdjust = $00000002; // Converts RGB and gray inline operators to gray and allows to darken or lighten the colors

type TCompBBoxFlags = Cardinal;
const cbfNone              = $00000000;
const cbfIgnoreWhiteAreas  = $00000001; // Ignore white vector graphics or text.
{
   Please note that images must be decompressed if one of the following flags are set. Parsing gray or color images
   is in most cases not useful and you should not parse such images if it is not really required.
}
const cbfParse1BitImages   = $00000002; // Find the visible area in 1 bit images. This is the most important case
                                        // since scanned faxes are usually 1 bit images.
const cbfParseGrayImages   = $00000004; // Find the visible area in gray images.
const cbfParseColorImages  = $00000008; // Find the visible area in color images. This is usually not required
                                        // and slow downs processing a lot.
const cbfParseAllImages    = $0000000E; // Find the visible area in all images.

// The data for user defined columns is stored in collection items.
type TColColumnType =
(
   cisCreationDate, // Data comes from the embedded file
   cisDescription,  // Data comes from the embedded file
   cisFileName,     // Data comes from the embedded file
   cisModDate,      // Data comes from the embedded file
   cisSize,         // Data comes from the embedded file
   cisCustomDate,   // User defined date.
   cisCustomNumber, // User defined nummber.
   cisCustomString  // User defined string.
);

type TColorMode =
(
   cmFill,
   cmStroke,
   cmFillStroke
);

type TColView =
(
   civNotSet,
   civDetails,
   civTile,
   civHidden,
   civCustom  // PDF 1.7 Extension Level 3, the collection view is presented by a SWF file.
);

type TCompressionLevel =
(
   clNone,
   clDefault,
   clFastest,
   clMax
);

type TCompressionFilter = Integer;
const
   cfFlate                 = $00000000; // PDF or TIFF output
   cfJPEG                  = $00000001; // PDF, JPEG, or TIFF output
   cfCCITT3                = $00000002; // PDF or TIFF output -> B&W CCITT Fax G3 compression -> fast but less compression ratio
   cfCCITT4                = $00000003; // PDF or TIFF output -> B&W CCITT Fax G4 compression -> slower but higher compression ratio
   cfLZW                   = $00000004; // TIFF or GIF output -> Very fast but less compression ratios than flate
   cfLZWBW                 = $00000005; // TIFF
   cfFlateBW               = $00000006; // TIFF, PNG, or BMP output -> Dithered black & white output. The resulting image will be
                                        // compressed with Flate or left uncompressed if the output image format is a bitmap. If
                                        // you want to use CCITT Fax 4 compression (TIFF only) set the flag icUseCCITT4 in the
                                        // AddImage() function call. Note that this filter is not supported for PDF creation!
   cfJP2K                  = $00000007; // PDF or JPEG2000 output
   cfJBIG2                 = $00000008; // PDF output only
   cfNone                  = $00000009; // TIFF output only
   // Special flags for AddRasImage(), RenderPageToImage(), or RenderPDFFile() if the pixel format was set to pxfGray or pxfGrayA.
   // These flags can be combined with the filters cfFlate, cfCCITT3, cfCCITT4, cfJBIG2, cfLZW, and cfJP2K.
   cfDitherFloydSteinberg  = $00001000; // Floyd Steinberg dithering.
   cfConvGrayToOtsu        = $00002000; // The Otsu filter is a special filter to produce black & white images. It is very useful
                                        // if an OCR scan should be applied on the resulting 1 bit image. The flag is considered
                                        // in AddRasImage(), RenderPDFFile(), and RenderPageToImage() if the pixel format was set
                                        // to pxfGray.
   cfOrderedDithering      = $00004000; // Ordered dithering. The difference in comparison to the pixel format pxf1Bit is that
                                        // we render into a GrayA buffer instead of a native 1 bit buffer since this one produces
                                        // incorrect results in certain transparency calculations.
   cfIgnoreICCProfile      = $00008000; // Special flag for AddRasImage(). Meaningful only if color management is enabled. If set,
                                        // the device ICC profile is not embedded in the image file.
   // Special flags for Optimize()
   cfPresLosslessFilter    = $00010000; // Preserve loss-less compression filters and use the specified filter otherwise.
   cfPresLossyFilter       = $00020000; // Preserve lossy compression filters and use the specified filter otherwise.
                                        // cfPresLossLessFilter and cfPresLossyFilter can be combined to preserve the original
                                        // compression filter in either case.

type TConformanceType =
(
   ctPDFA_1b_2005,
   ctNormalize,
   ctPDFA_2b,
   ctPDFA_3b,
   {* --------------------------------------------------------------------------------------------------------------------
    *                                  ZUGFeRD, ZUGFeRD 2.0, and Factur-X output
    * --------------------------------------------------------------------------------------------------------------------
    * The following constants convert the file to PDF/A 3b and set the whished ZUGFeRD, ZUGFeRD 2.0 or Factur-X conformance
    * level in the XMP metadata. CheckConformance() does not validate the XML invoice but it checks whether it is present.
    * The embedded XML invoice must be named as follows (case-sensitive and without quotes):
    *
    *  ZUGFeRD 1.0: "ZUGFeRD-invoice.xml"
    *  ZUGFeRD 2.0: "zugferd-invoice.xml"
    *  Factur-X:    "factur-x.xml"
    *
    * Setting the correct ZUGFeRD or Factur-X conformance level is important since this value defines which fields must be
    * present in the XML invoice.
    *}
   // ZUGFeRD 1.0:
   ctZUGFeRD_Basic,     // Basic profile
   ctZUGFeRD_Comfort,   // Comfort profile
   ctZUGFeRD_Extended,  // Extended profile
   // ZUGFeRD 2.0:
   ctZUGFeRD2_Minimum,  // Minimum profile
   ctZUGFeRD2_Basic,    // Basic profile
   ctZUGFeRD2_Basic_WL, // Basic WL profile
   ctZUGFeRD2_Comfort,  // EN 16931 profile
   ctZUGFeRD2_Extended, // Extended profile
   // Factur-X
   ctFacturX_Minimum,   // Minimum profile
   ctFacturX_Basic,     // Basic profile
   ctFacturX_Basic_WL,  // Basic WL profile
   ctFacturX_Comfort,   // EN 16931 profile
   ctFacturX_Extended,  // Extended profile
   ctFacturX_XRechnung, // German XRechnung profile
   ctPDFA_2u,           // Convert the file to PDF/A 2u if possible
   ctPDFA_3u,           // Convert the file to PDF/A 3u if possible
   ctPDFA_4,            // Convert the file to PDF/A 4 if possible. Embedded files are supported but no file attach annotations.
   ctPDFA_4e,           // Convert the file to PDF/A 4e if possible. This version allows 3D contents in rich media annotations.
   ctPDFA_4f            // Convert the file to PDF/A 4f if possible. This version allows file attach annotations.
);

type TCTM = record
   a: Double;
   b: Double;
   c: Double;
   d: Double;
   x: Double;
   y: Double;
end;

type PCTM = ^TCTM;

type TDateType =
(
   dtCreationDate,
   dtModDate
);

type TDestType =
(
   dtXY_Zoom,       // three parameters (a, b, c) -> (X, Y, Zoom)
   dtFit,           // no parameters
   dtFitH_Top,      // one parameter    (a)
   dtFitV_Left,     // one parameter    (a)
   dtFit_Rect,      // four parameters  (a, b, c, d) -> (left, bottom, right, top)
   dtFitB,          // no parameter
   dtFitBH_Top,     // one parameter    (a)
   dtFitBV_Left     // one parameter    (a)
);

type TDuplexMode =
(
   dpmNone,          // Default
   dpmSimplex,
   dpmFlipShortEdge,
   dpmFlipLongEdge
);

type TEmbFileLocation =
(
   eflChild,         // The file is an embedded file in the current document
   eflChildAnnot,    // The file is located in a file attachment annotion in the current document
   eflExternal,      // The file is an embedded file in an external document
   eflExternalAnnot, // The file is located in a file attachment annotion in an external document 
   eflParent,        // The file is located in the parent document
   eflParentAnnot    // The file is located in a file attachment annotion in the parent document
);

type TEnumFontProcFlags = Integer;
const
   efpAnsiPath    = 0; // Code page 1252 on Windows, UTF-8 otherwise
   efpUnicodePath = 1; // FilePath is in Unicode format. Make a typecast to (UI16*) in this case.
   efpEmbeddable  = 2; // The font has embedding rights.
   efpEditable    = 4; // The font has editing rights (important for form fields).

type
   PFltPoint = ^TFltPoint;
   TFltPoint = record
   x: Single;
   y: Single;
end;

type
   PI32Point = ^TI32Point;
   TI32Point = record
   x: Integer;
   y: Integer;
end;

type
   PI32QuadPoint = ^TI32QuadPoint;
   TI32QuadPoint = record
   P1: TI32Point;
   P2: TI32Point;
   P3: TI32Point;
   P4: TI32Point;
end;
   
type
   PFltRect = ^TFltRect;
   TFltRect = record
   Left,
   Bottom,
   Right,
   Top: Single;
end;

type
   PIntRect = ^TIntRect;
   TIntRect = record
   x1,
   y1,
   x2,
   y2: Integer;
end;

type TPDFRect = record
   Left,
   Bottom,
   Right,
   Top: Double;
end;

type TBmkStyle = Cardinal;
const
   bmsNormal = 0;
   bmsItalic = 1;
   bmsBold   = 2;

type TBookmark = record
   Color:    Cardinal;
   DestPage: Integer;
   DestPos:  TPDFRect;
   DestType: TDestType;
   Open:     LongBool;
   Parent:   Integer;
   Style:    TBmkStyle; // 1 = Italic, 2 = Bold, 3 = BoldItalic
   Title:    Pointer;
   TitleLen: Cardinal;
   Unicode:  LongBool;
end;

type TPDFBookmark = record
   StructSize: Cardinal;  // Must be set to sizeof(TPDFBookmark)
   Action:     Integer;   // Action handle or -1 if not set.
   Color:      Cardinal;  // Optional text color. Black is the default value (0).
   DestPage:   Integer;   // Destination page.
   DestPos:    TPDFRect;  // Destination position.
   DestType:   TDestType; // Destination type.
   NamedDestA: PAnsiChar; // Optional name of a named destination. If set, DestPage, DestPos, and DestType were already taken from the destination if it was found.
   NamedDestW: PWideChar; // Either the Unicode or Ansi string is set but never both.
   Open:       LongBool;  // If true, child nodes should be visible.
   Parent:     Integer;   // The immediate parent node or -1 for a root node.
   StructElem: Pointer;   // Bookmarks can contain a reference to a structure element. There is no API to access structure elements yet.
   Style:      TBmkStyle; // The font style that should be used to render this node.
   TitleA:     PAnsiChar; // The bookmark title.
   TitleW:     PWideChar; // Either the Unicode or Ansi string is set but never both.
   TitleLen:   Cardinal;  // String length in characters.
end;

{
   The font search run works as follows:

      - DynaPDF tries always to find the exact weight, if it cannot be found then a font with
        the next smaller weight is selected (if available).
      - Italic styles can always be emulated but it is not possible to emulate thinner weights or
        regular styles with an italic font.
      - If the specified weight is larger as the font weight the remaining weight will be emulated
        if the difference to the requested weight is larger than 200.
        With SetFontWeight() it is possible to control whether a missing weight should be emulated.
        If FontWeight is smaller or equal to the requested font weight then emulation will be disabled.

   TFStyle is a bitmask that is defined as follows:

      - Bits 0..7   // Style bits fsItalic, fsUnderlined, fsStriked
      - Bits 8..19  // Width class -> Defined for future use.
      - Bits 20..31 // Font Weight

   - A width class can be converted to a style constant by multiplying it with 256 (width shl 8).
   - A font weight can be converted to a style constant by multiplying it with 1048576 (weight shl 20).
   - Additional attributes can be added with a binary or operator (e.g. style or fsItalic).
   - Only one width class and one font weight can be set at time.

   - WidthFromStyle() extracts the width class.
   - WeightFromStyle() extracts the font weight.

   The following functions extract the width class or font weight from a style variable:

      widthClass  = WidthFromStyle(style);
      weightClass = WeightFromStyle(style);
}

type TFStyle = Integer;
const
   fsNone           = $00000000; // Regular weight (400)
   fsItalic         = $00000001;
   fsUnderlined     = $00000004;
   fsStriked        = $00000008;
   fsVerticalMode   = $00000010; // Not considered at this time
   fsDblUnderline   = $00000020;
   // Width class
   fsUltraCondensed = $00000100; // 1
   fsExtraCondensed = $00000200; // 2
   fsCondensed      = $00000300; // 3
   fsSemiCondensed  = $00000400; // 4
   fsNormal         = $00000500; // 5
   fsSemiExpanded   = $00000600; // 6
   fsExpanded       = $00000700; // 7
   fsExtraExpanded  = $00000800; // 8
   fsUltraExpanded  = $00000900; // 9
   // Weight class
   fsThin           = $06400000; // 100
   fsExtraLight     = $0c800000; // 200
   fsLight          = $12C00000; // 300
   fsRegular        = $19000000; // 400 -> Same as fsNone
   fsMedium         = $1F400000; // 500
   fsDemiBold       = $25800000; // 600
   fsBold           = $2BC00000; // 700 -> The old constant 2 is still supported to preserve backward compatibility
   fsExtraBold      = $32000000; // 800
   fsBlack          = $38400000; // 900
   fsUltraBlack     = $3E800000; // 1000
   
type TDecodeFilter =
(
   dfNone,
   dfASCII85Decode,  // No parameters
   dfASCIIHexDecode, // No parameters
   dfCCITTFaxDecode, // Optional Parameters
   dfDCTDecode,      // Optional Parameters
   dfFlateDecode,    // Optional Parameters
   dfJBIG2Decode,    // Optional Parameters
   dfJPXDecode,      // No parameters
   dfLZWDecode,      // Optional Parameters
   dfRunLengthDecode // No parameters
);

type TDecSeparator =
(  // per thousand separator, decimal separator
   dsCommaDot,
   dsNoneDot,
   dsDotComma,
   dsNoneComma,
   dsQuoteDot
);

type TDocumentInfo =
(
   diAuthor,
   diCreator,
   diKeywords,
   diProducer,
   diSubject,
   diTitle,
   diCompany,
   diPDFX_Ver,     // GetInDocInfo() or GetInDocInfoEx() only -> The PDF/X version is set by SetPDFVersion()!
   diCustom,       // User defined key
   diPDFX_Conf,    // GetInDocInfo() or GetInDocInfoEx() only. The value of the GTS_PDFXConformance key.
   diCreationDate, // GetInDocInfo() or GetInDocInfoEx() or after ImportPDFFile() was called.
   diModDate       // GetInDocInfo() or GetInDocInfoEx() only
);

type TDrawDirection =
(
   ddCounterClockwise,
   ddClockwise
);

type TDrawMode =
(
   dmNormal,
   dmStroke,
   dmFillStroke,
   dmInvisible,
   dmFillClip,
   dmStrokeClip,
   dmFillStrokeClip,
   dmClipping
);

{$ifdef DELPHI6_OR_HIGHER}

type TExtColorSpace =
(
   esInitSpace = -1,// Special value for AddHeaderFooter()
   esDeviceRGB,     // Device color space
   esDeviceCMYK,    // Device color space
   esDeviceGray,    // Device color space
   esCalGray,       // CIE-based color space
   esCalRGB,        // CIE-based color space
   esLab,           // CIE-based color space
   esICCBased,      // CIE-based color space -> contains an ICC profile
   esPattern,       // Special color space
   esIndexed,       // Special color space
   esSeparation,    // Special color space
   esDeviceN,       // Special color space
   esNChannel       // Special color space
);

{$else}

type TExtColorSpace = Integer;
const
   esDeviceRGB   = 0;  // Device color space
   esDeviceCMYK  = 1;  // Device color space
   esDeviceGray  = 2;  // Device color space
   esCalGray     = 3;  // CIE-based color space
   esCalRGB      = 4;  // CIE-based color space
   esLab         = 5;  // CIE-based color space
   esICCBased    = 6;  // CIE-based color space -> contains an ICC profile
   esPattern     = 7;  // Special color space
   esIndexed     = 8;  // Special color space
   esSeparation  = 9;  // Special color space
   esDeviceN     = 10; // Special color space
   esNChannel    = 11; // Special color space
   esInitSpace   = -1; // Special value for AddHeaderFooter()

{$endif}

type TFieldColor =
(
   fcBackColor,
   fcBorderColor,
   fcTextColor
);

type TAnnotColor = TFieldColor;

type TFieldFlags = Cardinal;
const ffReadOnly         = $00000001;
const ffRequired         = $00000002;
const ffNoExport         = $00000004;

const ffInvisible        = $00000008;
const ffHidden           = $00000010;
const ffPrint            = $00000020;
const ffNoZoom           = $00000040;
const ffNoRotate         = $00000080;
const ffNoView           = $00000100;

const ffMultiline        = $00001000;  // Text fields only
const ffPassword         = $00002000;  // Text fields only
const ffNoToggleToOff    = $00004000;  // Radio buttons, check boxes
const ffRadioIsUnion     = $02000000;  // PDF-1.5 radio buttons
const ffCommitOnSelCh    = $04000000;  // PDF-1.5 combo boxes, list boxes

const ffEdit             = $00040000;  // Combo boxes only
const ffSorted           = $00080000;  // Combo boxes and list boxes -> sorts the choice values in ascending order
const ffFileSelect       = $00100000;  // PDF 1.4 Text fields only
const ffMultiSelect      = $00200000;  // PDF 1.4 List boxes only
const ffDoNotSpellCheck  = $00400000;  // PDF 1.4 Text fields, combo boxes. If the field is a combo box, this flag is meaningful only if ffEdit is also set.
const ffDoNotScroll      = $00800000;  // PDF 1.4 Text fields only
const ffComb             = $01000000;  // PDF 1.5 Text fields only

type TFieldType =
(
   ftButton,
   ftCheckBox,
   ftRadioBtn,
   ftComboBox,
   ftListBox,
   ftText,
   ftSignature,
   ftGroup     // this is not a real field type, it is just an array of fields
);

type TFileAttachIcon =
(
   faiGraph,
   faiPaperClip,
   faiPushPin,
   faiTag,
   faiUserDefined
);

type TFileOP =
(
   foOpen,
   foPrint
);

type TFlushPageFlags = Cardinal;
const
   fpfDefault      = 0; // Write anything to the file that is possible
   fpfImagesOnly   = 1; // If set, only images are written to the file. The pages are still
                        // in memory and can be modified with EditPage(). Flushed images can
                        // still be referenced in other pages. The image handles remain valid.
   fpfExclLastPage = 2; // If set, the last page is not flushed

type TFontBaseType =
(
   fbtTrueType, // TrueType, TrueType Collections, or OpenType fonts with TrueType outlines
   fbtType1,    // Type1 font
   fbtOpenType, // OpenType font with Postscript outlines
   fbtStdFont,  // PDF Standard font
   fbtDisabled  // This value can be used to disable a specific font format. See SetFontSearchOrder() for further information.
);
type PFontBaseType = ^TFontBaseType;

type TFontFileSubtype =
(
   ffsType1C,        // CFF based Type1 font
   ffsCIDFontType0C, // CFF based Type1 CID font
   ffsOpenType,      // TrueType based OpenType font
   ffsOpenTypeC,     // CFF based OpenType font
   ffsCIDFontType2,  // TrueType based CID Font
   ffsCIDType1,      // Type1 font used as CID font (not documented in PDF specs)
   ffsReserved1,
   ffsReserved2,
   ffsReserved3,
   ffsNoSubtype
);

type TFontSelMode =
(
   smFamilyName,
   smPostScriptName,
   smFullName
);

type TFontType =
(
   ftMMType1,
   ftTrueType,
   ftType0,    // Check the font file type to determine the font sub type
   ftType1,
   ftType3
);

type TGStateFlags = Cardinal;
const gfCompatible         = $00000000; // Compatible graphics state to earlier DynaPDF versions -> default
const gfRestorePageCoords  = $00000001; // Restore the coordinate system with the graphics state (the value of PageCoords, see SetPageCoords())
const gfRealTopDownCoords  = $00000002; // If set, the page coordinate system is not reset to bottom-up when transforming
                                        // the coordinate system. However, real top-down coordinates require a large internal
                                        // overhead and where never fully implemented. The usage of this flag should be avoided
                                        // if possible.
const gfNativeBlackWhite   = $00000004; // Do not convert RGB black or white to DeviceGray
const gfUseImageColorSpace = $00000008; // If set, the active color space is ignored when inserting an image. The color space is taken
                                        // from the image file instead.
const gfIgnoreICCProfiles  = $00000010; // Meaningful only if the flag gfUseImageColorSpace is set. If set, an embedded profile is not used to
                                        // create an ICCBased color space for the image. The image is inserted in the corresponding device
                                        // color space instead.
const gfAnsiStringIsUTF8   = $00000020; // If set, single byte strings in Ansi functions are treated as UTF-8 encoded Unicode strings.
const gfRealPassThrough    = $00000040; // If set, JPEG images are inserted as is. JPEG images are normally rebuild, also in pass-through mode, to avoid issues
                                        // with certain malformed JPEG images which cannot be displayed in Adobes Acrobat or Reader. If you know that your JPEG
                                        // images work then set this flag to avoid unnecessary processing time.
const gfNoBitmapAlpha      = $00000080; // If set, the alpha channel in 32 bit bitmaps will be ignored. Useful for bitmaps with an invalid alpha channel.
const gfNoImageDuplCheck   = $00000100; // If set, no duplicate check for images will be performed. This can significantly improve processing speed.
const gfNoObjCompression   = $00000200; // If set, object compression will be disabled.
const gfComplexText        = $00000400; // If set, text is processed with Uniscribe on Windows.
const gfDisableJavascript  = $00000800; // If set, the raw field value of text fields is used to create the apprearance stream.
const gfDisableBidiCtrls   = $00001000; // Meaningful only if gfComplexText is set too. If set, bidi control characters are ignored. This flag can be useful if
                                        // the result of web browsers should be emulated since web browsers do not support bidi control characters. This flag
                                        // is also used internally to create the appearance stream of form fields since form fields do not support bidi control
                                        // characters.
const gfDoNotComprMetadata = $00002000; // If set, arbitrary metadata stream associated with PDF objects other that the global metadata stream will not be
                                        // compressed. This can be useful since certain standards prohibit compression of metadata streams. The flag is
                                        // automatically for PDF/X files.
const gfUpdatePDFVTModDate = $00004000; // If set, the key GTS_PDFVTModDate will be set to the file's modification date.
const gfSkaleAnnotIcons    = $00008000; // If set, icons of text and file attach annotation are scaled with the page like every other annotation. These annotations
                                        // have normally a fixed size that is indendent of the zoom or scaling factor.
const gfRoundHighlightAP   = $00010000; // If set, highlight annotations are drawn with round edges.

type TFRect = record
   MinX: Smallint;
   MinY: Smallint;
   MaxX: Smallint;
   MaxY: Smallint;
end;

{$if defined(DELPHI6_OR_HIGHER) and not defined(FPC)}

type TPDFBarcodeType =
(
   bctNotInitialized    = $0000, // No valid value
   bctAustraliaPost     = $003F, // Australia Post Standard Customer
   bctAustraliaRedir    = $0044, // Australia Post Redirection
   bctAustraliaReply    = $0042, // Australia Post Reply Paid
   bctAustraliaRout     = $0043, // Australia Post Routing
   bctAztec             = $005C, // Aztec Code
   bctAztecRunes        = $0080, // Aztec Runes
   bctC2Of5IATA         = $0004, // Code 2 of 5 IATA
   bctC2Of5Industrial   = $0007, // Code 2 of 5 Industrial
   bctC2Of5Interleaved  = $0003, // Interleaved 2 of 5
   bctC2Of5Logic        = $0006, // Code 2 of 5 Data Logic
   bctC2Of5Matrix       = $0002, // Standard Code 2 of 5
   bctChannelCode       = $008C, // Channel Code
   bctCodabar           = $0012, // Codabar
   bctCodablockF        = $004A, // Codablock-F
   bctCode11            = $0001, // Code 11
   bctCode128           = $0014, // Code 128 (automatic subset switching)
   bctCode128B          = $003C, // Code 128 (Subset B)
   bctCode16K           = $0017, // Code 16K
   bctCode32            = $0081, // Code 32
   bctCode39            = $0008, // Code 3 of 9 (Code 39)
   bctCode49            = $0018, // Code 49
   bctCode93            = $0019, // Code 93
   bctCodeOne           = $008D, // Code One
   bctDAFT              = $005D, // DAFT Code
   bctDataBarOmniTrunc  = $001D, // GS1 DataBar-14 Omnidirectional and truncated / RSS14
   bctDataBarExpStacked = $0051, // GS1 DataBar Expanded Stacked
   bctDataBarExpanded   = $001F, // GS1 DataBar Expanded / RSS_EXP
   bctDataBarLimited    = $001E, // GS1 DataBar Limited  / RSS_LTD
   bctDataBarStacked    = $004F, // GS1 DataBar-14 Stacked
   bctDataBarStackedO   = $0050, // GS1 DataBar-14 Stacked Omnidirectional
   bctDataMatrix        = $0047, // Data Matrix ECC200
   bctDotCode           = $0073, // DotCode
   bctDPD               = $0060, // DPD code
   bctDPIdentCode       = $0016, // Deutsche Post Identcode
   bctDPLeitcode        = $0015, // Deutsche Post Leitcode
   bctEAN128            = $0010, // GS1-128 (UCC.EAN-128)
   bctEAN128_CC         = $0083, // Composite Symbol with GS1-128 linear component
   bctEAN14             = $0048, // EAN-14
   bctEANX              = $000D, // EAN
   bctEANX_CC           = $0082, // Composite Symbol with EAN linear component
   bctEANXCheck         = $000E, // EAN + Check Digit
   bctExtCode39         = $0009, // Extended Code 3 of 9 (Code 39+)
   bctFIM               = $0031, // FIM
   bctFlattermarken     = $001C, // Flattermarken
   bctHIBC_Aztec        = $0070, // HIBC Aztec Code
   bctHIBC_CodablockF   = $006E, // HIBC Codablock-F
   bctHIBC_Code128      = $0062, // HIBC Code 128
   bctHIBC_Code39       = $0063, // HIBC Code 39
   bctHIBC_DataMatrix   = $0066, // HIBC Data Matrix ECC200
   bctHIBC_MicroPDF417  = $006C, // HIBC MicroPDF417
   bctHIBC_PDF417       = $006A, // HIBC PDF417
   bctHIBC_QR           = $0068, // HIBC QR Code
   bctISBNX             = $0045, // ISBN (EAN-13 with verification stage)
   bctITF14             = $0059, // ITF-14
   bctJapanPost         = $004C, // Japanese Postal Code
   bctKIX               = $005A, // Dutch Post KIX Code
   bctKoreaPost         = $004D, // Korea Post
   bctLOGMARS           = $0032, // LOGMARS
   bctMailmark          = $0079, // Royal Mail 4-State Mailmark
   bctMaxicode          = $0039, // Maxicode
   bctMicroPDF417       = $0054, // Micro PDF417
   bctMicroQR           = $0061, // Micro QR Code
   bctMSIPlessey        = $0047, // MSI Plessey
   bctNVE18             = $004B, // NVE-18
   bctPDF417            = $0037, // PDF417
   bctPDF417Truncated   = $0038, // PDF417 Truncated
   bctPharmaOneTrack    = $0033, // Pharmacode One-Track
   bctPharmaTwoTrack    = $0035, // Pharmacode Two-Track
   bctPLANET            = $0052, // PLANET
   bctPlessey           = $0056, // Plessey
   bctPostNet           = $0028, // PostNet
   bctPZN               = $0034, // PZN
   bctQRCode            = $003A, // QR Code
   bctRMQR              = $0091, // Rectangular Micro QR Code (rMQR)
   bctRoyalMail4State   = $0046, // Royal Mail 4 State (RM4SCC)
   bctRSS_EXP_CC        = $0086, // Composite Symbol with GS1 DataBar Extended component
   bctRSS_EXPSTACK_CC   = $008B, // Composite Symbol with GS1 DataBar Expanded Stacked component
   bctRSS_LTD_CC        = $0085, // Composite Symbol with GS1 DataBar Limited component
   bctRSS14_CC          = $0084, // Composite Symbol with GS1 DataBar-14 linear component
   bctRSS14Stacked_CC   = $0089, // Composite Symbol with GS1 DataBar-14 Stacked component
   bctRSS14StackOMNI_CC = $008A, // Composite Symbol with GS1 DataBar-14 Stacked Omnidirectional component
   bctTelepen           = $0020, // Telepen Alpha
   bctTelepenNumeric    = $0057, // Telepen Numeric
   bctUltracode         = $0090, // Ultracode
   bctUPCA              = $0022, // UPC A
   bctUPCA_CC           = $0087, // Composite Symbol with UPC A linear component
   bctUPCACheckDigit    = $0023, // UPC A + Check Digit
   bctUPCE              = $0025, // UCP E
   bctUPCE_CC           = $0088, // Composite Symbol with UPC E linear component
   bctUPCECheckDigit    = $0026, // UPC E + Check Digit
   bctUPNQR             = $008F, // UPNQR (Univerzalni Placilni Nalog QR)
   bctUSPSOneCode       = $0055, // USPS OneCode
   bctVIN               = $0049  // Vehicle Identification Number (America)
);

{$else}

type TPDFBarcodeType = Integer;
const
   bctNotInitialized    = $0000; // No valid value
   bctAustraliaPost     = $003F; // Australia Post Standard Customer
   bctAustraliaRedir    = $0044; // Australia Post Redirection
   bctAustraliaReply    = $0042; // Australia Post Reply Paid
   bctAustraliaRout     = $0043; // Australia Post Routing
   bctAztec             = $005C; // Aztec Code
   bctAztecRunes        = $0080; // Aztec Runes
   bctC2Of5IATA         = $0004; // Code 2 of 5 IATA
   bctC2Of5Industrial   = $0006; // Code 2 of 5 Industrial
   bctC2Of5Interleaved  = $0003; // Interleaved 2 of 5
   bctC2Of5Logic        = $0005; // Code 2 of 5 Data Logic
   bctC2Of5Matrix       = $0002; // Standard Code 2 of 5
   bctChannelCode       = $008C; // Channel Code
   bctCodabar           = $0012; // Codabar
   bctCodablockF        = $004A; // Codablock-F
   bctCode11            = $0001; // Code 11
   bctCode128           = $0014; // Code 128 (automatic subset switching)
   bctCode128B          = $003C; // Code 128 (Subset B)
   bctCode16K           = $0017; // Code 16K
   bctCode32            = $0081; // Code 32
   bctCode39            = $0007; // Code 3 of 9 (Code 39)
   bctCode49            = $0018; // Code 49
   bctCode93            = $0019; // Code 93
   bctCodeOne           = $008D; // Code One
   bctDAFT              = $005D; // DAFT Code
   bctDataBarOmniTrunc  = $001D; // GS1 DataBar-14 Omnidirectional and truncated / RSS14
   bctDataBarExpStacked = $0051; // GS1 DataBar Expanded Stacked
   bctDataBarExpanded   = $001F; // GS1 DataBar Expanded / RSS_EXP
   bctDataBarLimited    = $001E; // GS1 DataBar Limited  / RSS_LTD
   bctDataBarStacked    = $004F; // GS1 DataBar-14 Stacked
   bctDataBarStackedO   = $0050; // GS1 DataBar-14 Stacked Omnidirectional
   bctDataMatrix        = $0047; // Data Matrix ECC200
   bctDotCode           = $0073; // DotCode
   bctDPD               = $0060; // DPD code
   bctDPIdentCode       = $0016; // Deutsche Post Identcode
   bctDPLeitcode        = $0015; // Deutsche Post Leitcode
   bctEAN128            = $0010; // GS1-128 (UCC.EAN-128)
   bctEAN128_CC         = $0083; // Composite Symbol with GS1-128 linear component
   bctEAN14             = $0048; // EAN-14
   bctEANX              = $000D; // EAN
   bctEANX_CC           = $0082; // Composite Symbol with EAN linear component
   bctEANXCheck         = $000E; // EAN + Check Digit
   bctExtCode39         = $0008; // Extended Code 3 of 9 (Code 39+)
   bctFIM               = $0031; // FIM
   bctFlattermarken     = $001C; // Flattermarken
   bctHIBC_Aztec        = $0070; // HIBC Aztec Code
   bctHIBC_CodablockF   = $006E; // HIBC Codablock-F
   bctHIBC_Code128      = $0062; // HIBC Code 128
   bctHIBC_Code39       = $0063; // HIBC Code 39
   bctHIBC_DataMatrix   = $0066; // HIBC Data Matrix ECC200
   bctHIBC_MicroPDF417  = $006C; // HIBC MicroPDF417
   bctHIBC_PDF417       = $006A; // HIBC PDF417
   bctHIBC_QR           = $0068; // HIBC QR Code
   bctISBNX             = $0045; // ISBN (EAN-13 with verification stage)
   bctITF14             = $0059; // ITF-14
   bctJapanPost         = $004C; // Japanese Postal Code
   bctKIX               = $005A; // Dutch Post KIX Code
   bctKoreaPost         = $004D; // Korea Post
   bctLOGMARS           = $0032; // LOGMARS
   bctMailmark          = $0079; // Royal Mail 4-State Mailmark
   bctMaxicode          = $0039; // Maxicode
   bctMicroPDF417       = $0054; // Micro PDF417
   bctMicroQR           = $0061; // Micro QR Code
   bctMSIPlessey        = $0047; // MSI Plessey
   bctNVE18             = $004B; // NVE-18
   bctPDF417            = $0037; // PDF417
   bctPDF417Truncated   = $0038; // PDF417 Truncated
   bctPharmaOneTrack    = $0033; // Pharmacode One-Track
   bctPharmaTwoTrack    = $0035; // Pharmacode Two-Track
   bctPLANET            = $0052; // PLANET
   bctPlessey           = $0056; // Plessey
   bctPostNet           = $0028; // PostNet
   bctPZN               = $0034; // PZN
   bctQRCode            = $003A; // QR Code
   bctRMQR              = $0091; // Rectangular Micro QR Code (rMQR)
   bctRoyalMail4State   = $0046; // Royal Mail 4 State (RM4SCC)
   bctRSS_EXP_CC        = $0086; // Composite Symbol with GS1 DataBar Extended component
   bctRSS_EXPSTACK_CC   = $008B; // Composite Symbol with GS1 DataBar Expanded Stacked component
   bctRSS_LTD_CC        = $0085; // Composite Symbol with GS1 DataBar Limited component
   bctRSS14_CC          = $0084; // Composite Symbol with GS1 DataBar-14 linear component
   bctRSS14Stacked_CC   = $0089; // Composite Symbol with GS1 DataBar-14 Stacked component
   bctRSS14StackOMNI_CC = $008A; // Composite Symbol with GS1 DataBar-14 Stacked Omnidirectional component
   bctTelepen           = $0020; // Telepen Alpha
   bctTelepenNumeric    = $0057; // Telepen Numeric
   bctUltracode         = $0090; // Ultracode
   bctUPCA              = $0022; // UPC A
   bctUPCA_CC           = $0087; // Composite Symbol with UPC A linear component
   bctUPCACheckDigit    = $0023; // UPC A + Check Digit
   bctUPCE              = $0025; // UCP E
   bctUPCE_CC           = $0088; // Composite Symbol with UPC E linear component
   bctUPCECheckDigit    = $0026; // UPC E + Check Digit
   bctUPNQR             = $008F; // UPNQR (Univerzalni Placilni Nalog QR)
   bctUSPSOneCode       = $0055; // USPS OneCode
   bctVIN               = $0049; // Vehicle Identification Number (America)

{$ifend}

type TPDFBarcodeDataType = Integer;
const
   bcdtBinary     = 0; // Binary data.
   bcdtUnicode    = 1; // UTF-8.
   bcdtGS1Mode    = 2; // Encodes GS1 data using FNC1 characters.
   bcdtEscapeMode = 8; // Scan input data for escape sequences. This is a flag that can be combined
                       // with the other constants, e.g. bcdtUnicode or bcdtEscapeMode.

// The following flags can be combined with a binary or operator, e.g. TBarcodeOptions(bcoNoASCII | bcoDottyMode).
type TPDFBarcodeOptions = Integer;
const
   bcoDefault          = $00000000; // Use default settings.
   bcoNoASCII          = $00000001; // Consider non-ASCII characters when creating the barcode.
   bcoBind             = $00000002; // Boundary bars above and below the symbol and between rows if stacking multiple symbols.
   bcoBox              = $00000004; // Add a box surrounding the symbol and whitespace.
   bcoReaderInit       = $00000010; // Add a reader initialisation symbol to the data before encoding.
   bcoSmallText        = $00000020; // Use a smaller font for human readable text.
   bcoBoldText         = $00000040; // Embolden human readable text.
   bcoDottyMode        = $00000100; // Plot a matrix symbol using dots rather than squares.
   bcoGS1_GS_Separator = $00000200; // Use GS instead FNC1 as GS1 separator.
   bcoImageOutput      = $01000000; // Draw the barcode as an image. Images are usually larger than vectors and require more processing time.
   bcoUseActiveFont    = $02000000; // Vector output only. If set, text is output with the active font. Helvetica is used otherwise.

// Structure to create a barcode on a page
type TPDFBarcode2 = record
   StructSize:  Cardinal;            // Must be set to sizeof(TPDFBarcode2).
   BarcodeType: TPDFBarcodeType;     // The type of barcode that should be created.
   BgColor:     Cardinal;            // Background color -> Default NO_COLOR (transparent).
   BorderWidth: Cardinal;            // Border width -> default 0.
   Data:        PAnsiChar;           // Data buffer.
   DataType:    TPDFBarcodeDataType; // Data type and escape flag.
   DotSize:     Single;              // Dotty mode only -> Default 4.0/5.0.
   Eci:         Integer;             // Extended Channel Interpretation mode -> Default 0.
   FgColor:     Cardinal;            // RGB Foreground color -> Default 0.
   FSizeFactor: Single;              // Font size correction factor -> Default 0.7. Considered in vector mode only.
   Option1:     Integer;             // Various, depends on barcode type. See help file for further information. -> Default -1.
   Option2:     Integer;             // Various, depends on barcode type. See help file for further information. -> Default 0.
   Option3:     Integer;             // Various, depends on barcode type. See help file for further information. -> Default 0.
   Options:     TPDFBarcodeOptions;  // Output options.
   Orientation: Integer;             // Supported values: 0, 90, -90, 180, -180, 270, -270.
   Primary:     PAnsiChar;           // Composite codes only. Primary data message (max 127 bytes).
   Scale:       Single;              // Default 1.0.
   ShowText:    LongBool;            // Show human readable text? Default true.
   SpaceWidth:  Cardinal;            // Whitespace width in pixels -> Default 0 (auto).
   SymbHeight:  Cardinal;            // Default 50.
   TextOffsetY: Single;              // Offset to correct the y-coordinate of human readable text -> Default 0.
   OuterBorder: TFltRect;            // Optional border around the scaled barcode measured in user space.
end;

type TPDFGlyphOutline = record
   AdvanceX: Single;
   AdvanceY: Single;
   OriginX:  Single;
   OriginY:  Single;
   Lsb:      Smallint;
   Tsb:      Smallint;
   HaveBBox: LongBool;
   BBox:     TFRect;
   Outline:  PI32Point;
   Size:     Cardinal;
end;

type PPDFGlyphOutline = ^TPDFGlyphOutline;

type THashType =
(
   htDetached, // CloseAndSignFileExt() returns the byte ranges of the finish PDF buffer to create a detached signature
   htSHA1      // CloseAndSignFileExt() returns the SHA1 hash of the PDF file so that it can be signed
);
                                        
type THighlightMode =
(
  hmNone,
  hmInvert,
  hmOutline,
  hmPush,
  hmPushUpd  // Update appereance stream on changes
);

type TICCProfileType =
(
   ictGray,
   ictRGB,
   ictCMYK,
   ictLab
);

type TImageConversionFlags = Cardinal;
const icNone      = 0; // Default
const icUseCCITT4 = 1; // Use CCITT Fax 4 compression instead of Flate for dithered images.

{
   TIFF is the only format that supports different compression filters. The Filter parameter of the function
   AddImage() is ignored if the image format supports only one specific compression filter.
   Note that images are automatically converted to the nearest supported color space if the image format does
   not support the color space of the image.
}
type TImageFormat =
(
   ifmTIFF,     // DeviceRGB, DeviceCMYK, DeviceGray, Black & White -> CCITT Fax Group 3/4, JPEG, Flate, LZW.
   ifmJPEG,     // DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG compression.
   ifmPNG,      // DeviceGray, DeviceRGB, Black & White -> Flate compression.
   ifmReserved, // Reserved for future extensions.
   ifmBMP,      // DeviceGray, DeviceRGB, Black & White -> Uncompressed.
   ifmJPC,      // DeviceRGB, DeviceCMYK, DeviceGray    -> JPEG2000 compression.
   ifmBigTIFF   // Same as ifmTIFF but without the 4GB output restriction. Note that this format is not supported by most image viewers.
);

type TImportFlags = Cardinal;
const ifImportAll        = $0FFFFFFE; // default
const ifContentOnly      = $00000000;
// If this flag is set, only interactive objects are imported if any, Otherwise only empty pages are imported.
// This flag can be used to copy an interactive form to another PDF file.
const ifNoContent        = $00000001;
// The imported page is not converted to a template if ifImportAsPage is set.
// Note that this flag can cause resource conflicts. Use this flag carefully!
const ifImportAsPage     = $80000000;
// base objects
const ifCatalogAction    = $00000002;
const ifPageActions      = $00000004;
const ifBookmarks        = $00000008;
const ifArticles         = $00000010;
const ifPageLabels       = $00000020;
const ifThumbs           = $00000040;
const ifTranspGroups     = $00000080; // This flag is not longer considered.
const ifSeparationInfo   = $00000100;
const ifBoxColorInfo     = $00000200;
const ifStructureTree    = $00000400;
const ifTransition       = $00000800;
const ifSearchIndex      = $00001000;
const ifJavaScript       = $00002000;
const ifJSActions        = $00004000;
const ifDocInfo          = $00008000;
const ifEmbeddedFiles    = $00200000; // File attachments
const ifFileCollections  = $00400000; // File collections (PDF 1.7)
// Annotations -> Only the most important annotation types can be selected directly.
// Note that all annotation types can be deleted with DeleteAnnotation.
const ifAllAnnots        = $009F0000;
   const ifFreeText      = $00010000;
   const ifTextAnnot     = $00020000;
   const ifLink          = $00040000;
   const ifStamp         = $00080000;
   const if3DAnnot       = $00100000;
   const ifOtherAnnots   = $00800000;

// Interactive Form fields are annotations too but we handle this type separately!
const ifFormFields       = $01000000;
const ifPieceInfo        = $02000000; // The PieceInfo dictionary contains arbitrary user defined data. The data in
                                      // this dictionary is only meaningful for the application that created the data.
{ -------------------- Special flags -------------------- }
const ifPrepareForPDFA   = $10000000; // Replace LZW compression with Flate, set the Interpolate key of images to false, do not import embedded files.
const ifEnumFonts        = $20000000; // Import fonts for EnumDocFonts(). The document must be deleted when this flag is set!!!
const ifAllPageObjects   = $40000000; // Import links when using ImportPageEx() within an open page. The entire document should be imported in this case.

type TImportFlags2 = Cardinal;
const if2Default         = $00000000; // Default
const if2MergeLayers     = $00000001; // If set, layers with identical name are merged. If this flag is absent DynaPDF
                                      // imports such layers separately so that each layer refers still to the pages
                                      // where it was originally used.
const if2Normalize       = $00000002; // Replace LZW compression with Flate, apply limit checks, repair errors if possible.
const if2UseProxy        = $00000004; // Not meaningful for PDF files which are loaded from a memory buffer. If set, all streams are loaded from the file
                                      // on demand and never hold in memory. This reduces drastically the memory usage and enables the processing of arbitrary
                                      // large PDF files with minimal memory usage. The corresponding PDF file(s) must not be deleted before CloseFile() or
                                      // CloseFileEx() was called.
const if2NoMetadata      = $00000008; // Ignore metadata streams which are attached to fonts, pages, images, and so on.
const if2DuplicateCheck  = $00000010; // Perform a duplicate check on color spaces, fonts, images, patterns, and templates when merging PDF files.
const if2NoResNameCheck  = $00000020; // Import resources as is. This flag can significantly imporove the loading time of pages with a huge resource tree.
                                      // This flag should only be set in viewer applications to improve the loading time of pages.
const if2CopyEncryptDict = $00000040; // If set, the encryption settings of an encrypted PDF file are copied to the new PDF file.
                                      // The flag does nothing if the file is not encrypted.
const if2SkipDPartData   = $00000080; // If set, DPart dictionaries are not imported.
const if2IncrementalUpd  = $00000100; { This flag also sets the flags if2UseProxy, if2CopyEncryptDict, as well as ifImportAsPage and ifImportAll.

                                         If set, the next PDF file that is opened for import is prepared for an incremental update. The PDF file must be opened and
                                         imported BEFORE adding pages, bookmarks, or arbitrary other contents.

                                         The flag if2UseProxy creates a proxy so that the file can be copied to the output file or output buffer when CloseFile(),
                                         CloseAndSignFile(), or CloseAndSignFileExt() is called. All functions which encrypt the PDF file like CloseFileEx(), or
                                         CloseAndSignFileEx() for example, are prohibited because it is not possible to override the encryption settings or
                                         to save an unencrypted file encrypted with an incremental update.

                                         The flag if2CopyEncryptDict makes sure that the original encryption settings are copied to the output file.
                                      }

type TKeyLen =
(
   kl40bit,    // RC4 Encryption -> Acrobat 3 or higher
   kl128bit,   // RC4 Encryption -> Acrobat 5 or higher
   kl128bitEx, // RC4 Encryption -> Acrobat 6 or higher
   klAES128,   // AES Encryption -> Acrobat 7 or higher
   klAES256,   // AES Encryption -> Acrobat 9 or higher
   klAESRev6   // AES Encryption -> Acrobat X or higher
);

type TLineCapStyle =
(
  csButtCap,
  csRoundCap,
  csSquareCap
);

type TLineEndStyle =
(
   leNone,
   leButt,
   leCircle,
   leClosedArrow,
   leDiamond,
   leOpenArrow,
   leRClosedArrow,
   leROpenArrow,
   leSlash,
   leSquare
);

type TLineCaptionPos =
(
   cpInline, // The caption is centered inside the line
   cpTop     // The caption is drawn on top of the line
);

type TLineAnnotParms = record
   StructSize:       Cardinal;        // Must be set to sizeof(TLineAnnotParms)
   Caption:          LongBool;        // If true, the annotation string Content is used as caption.
   CaptionOffsetX:   Single;          // Horizontal offset of the caption from its normal position
   CaptionOffsetY:   Single;          // Vertical offset of the caption from its normal position
   CaptionPos:       TLineCaptionPos; // The position where the caption should be drawn if present
   LeaderLineLen:    Single;          // Length of the leader lines (positive or negative)
   LeaderLineExtend: Single;          // Optional leader line extend beyond the leader line (must be a positive value or zero)
   LeaderLineOffset: Single;          // Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)
end;

type PLineAnnotParms = ^TLineAnnotParms;

type TLineJoinStyle =
(
   jsMiterJoin,
   jsRoundJoin,
   jsBevelJoin
);

type TMetadataObj =
(
   mdoCatalog,
   mdoFont,
   mdoImage,
   mdoPage,
   mdoTemplate
);

type TMeasureNumFormat =
(
   mnfDecimal,
   mnfFractional,
   mnfRound,
   mnfTruncate
);

type TMeasureLblPos =
(
   mlpSuffix,
   mlpPrefix
);

type TMetaFlags = Cardinal;
const mfDefault           = $00000000; // Default conversion
const mfDebug             = $00000001; // Write debug information into the content stream
const mfShowBounds        = $00000002; // Show the bounding boxes of text strings
const mfNoTextScaling     = $00000004; // Do not scale text
const mfClipView          = $00000008; // Draw the file into a clipping rectangle
const mfUseRclBounds      = $00000010; // Use rclBounds instead of rclFrame
const mfNoClippingRgn     = $00000040; // Disables SelectClippingRegion and IntersectClipRect
const mfNoFontEmbedding   = $00000080; // Do not embed fonts -> Fonts should be embedded!!!
const mfNoImages          = $00000100; // Ignore image records
const mfNoStdPatterns     = $00000200; // Ignore standard patterns
const mfNoBmpPatterns     = $00000400; // Ignore bitmap patterns
const mfNoText            = $00000800; // Ignore text records
const mfUseUnicode        = $00001000; // Ignore ANSI_CHARSET
const mfUseTextScaling    = $00004000; // Scale text instead of using the intercharacter spacing array
const mfNoUnicode         = $00008000; // Avoid usage of Unicode fonts -> recommended to enable PDF 1.2 compability
const mfFullScale         = $00010000; // Scale coordinates to the window size. Recommended if 32 bit coordinates are used.
const mfUseRclFrame       = $00020000; // This flag should be set if the rclFrame rectangle is properly set
const mfDefBkModeTransp   = $00040000; // Initialize the background mode to transparent (SetBkMode() overrides this state).
const mfApplyBidiAlgo     = $00080000; // Apply the bidirectional algorithm on Unicode strings
const mfGDIFontSelection  = $00100000; // Use the GDI to select fonts
const mfRclFrameEx        = $00200000; // If set, and if the rclBounds rectangle is larger than rclFrame, the function
                                       // extends the output rectangle according to rclBounds and uses the resulting
                                       // bounding box to calculate the image size (rclBounds represents the unscaled
                                       // image size). This is probably the correct way to calculate the image size.
                                       // However, to preserve backward compatibility the default calculation cannot
                                       // be changed.
const mfNoTextClipping    = $00400000; // If set, the ETO_CLIPPED flag in text records is ignored.
const mfSrcCopy_Only      = $00800000; // If set, images which use a ROP code other than SRCCOPY are ignored. This is useful when processing Excel 2007 spool files.
const mfClipRclBounds     = $01000000; // If set, the graphic is drawn into a clipping path with the size of rclBounds.
                                       // This flag is useful if the graphic contains content outside of its bounding box.
const mfDisableRasterEMF  = $02000000; // If set, EMF files which use unsupported ROP codes are not rastered.
const mfNoBBoxCheck       = $04000000; // If set, the rclBounds and rclFrame rectangles are used as is. DynaPDF uses normally
                                       // the rclBounds rectangle to calculate the picture size if the resolution of the EMF file
                                       // seems to be larger than 1800 DPI since this is mostly an indication that the rclFrame
                                       // rectangle was incorrectly calculated. If you process EMF files in such a high resolution
                                       // then this flag must be set. The flag can be set by default.
const mfIgnoreEmbFonts    = $08000000; // If set, embedded fonts in GDIComment records will be ignored. This flag must be set if the fonts
                                       // of an EMF spool file were pre-loaded with ConvertEMFSpool(). Spool fonts must always be loaded
                                       // in a pre-processing step since required fonts are not necessarily embedded in the EMF files.
const mfDontSkipROP_DPa   = $10000000; // If set, the ROP code 0x00A000C9 (DPa) is considered in BitBlt, StretchBlt, TranparentBlt, and AlphaBlend records.
                                       // This kind of ROP code combines a pattern brush with the backdrop. If the flag mfDisableRasterEMF is absent, the 
                                       // usage of such a ROP code causes that the file is rendered to an image.
const mfCurrComprFilter   = $20000000; // If set, the currently active compression filter is used to compress the image (see SetCompressionFilter()).
                                       // This flag is used only if the file is rastered to an image.


// Obsolete flags -> these flags are ignored, do no longer use them!
const mfUseSpacingArray   = $00000020; // enabled by default -> can be disabled with mfUseTextScaling
const mfIntersectClipRect = $00002000; // enabled by default -> can be disabled with mfNoClippingRgn

type TLoadCMapFlags = Cardinal;
const lcmDefault   = 0; // Load the cmaps in the directory now
const lcmRecursive = 1; // Load sub directories recursively
const lcmDelayed   = 2; // Load the cmap files only when a font requires an external cmap

type TNamedAction =
(
   naFirstPage,
   naLastPage,
   naNexPage,
   naPrevPage,
   naGoBack,
   naOpenDlg,
   naPrintDlg,
   naGeneralInfo,
   naFontsInfo,
   naSaveAs,
   naSecurityInfo,
   naFitPage,
   naFullScreen,
   naDeletePages,
   naQuit,
   naUserDefined    // Non predefined action
);

type TNegativeStyle =
(
   nsMinusBlack,
   nsRed,
   nsParensBlack,
   nsParensRed
);

type TObjEvent =
( // All actions which should be applied to an event (except On Mouse Up) must be a JavaScript action!
   oeNoEvent,           // Internal use only -> DO NOT USE THIS VALUE!!!
   oeOnOpen,            // Catalog, Pages
   oeOnClose,           // Pages only
   oeOnMouseUp,         // All fields, page link annotations, bookmarks
   oeOnMouseEnter,      // Form fields only
   oeOnMouseExit,       // Form fields only
   oeOnMouseDown,       // Form fields only
   oeOnFocus,           // Form fields only
   oeOnBlur,            // Form fields only
   oeOnKeyStroke,       // Text fields only
   oeOnFormat,          // Text fields only
   oeOnCalc,            // Text fields, combo boxes, list boxes
   oeOnValidate,        // All form fields, except buttons
   oeOnPageVisible,     // PDF 1.5 -> Form fields only
   oeOnPageInVisible,   // PDF 1.5 -> Form fields only
   oeOnPageOpen,        // PDF 1.5 -> Form fields only
   oeOnPageClose,       // PDF 1.5 -> Form fields only
   oeOnBeforeClosing,   // PDF 1.4 -> Catalog only
   oeOnBeforeSaving,    // PDF 1.4 -> Catalog only
   oeOnAfterSaving,     // PDF 1.4 -> Catalog only
   oeOnBeforePrinting,  // PDF 1.4 -> Catalog only
   oeOnAfterPrinting    // PDF 1.4 -> Catalog only
);

type TObjType =
(
   otAction,
   otAnnotation,
   otBookmark,
   otCatalog,           // PDF 1.4
   otField,
   otPage,
   otPageLink
);

type TOCObject =
(
   ooAnnotation,
   ooField,
   ooImage,
   ooTemplate
);

type TOCAppEvent = Cardinal;
   const aeExport = 1;
   const aePrint  = 2;
   const aeView   = 4;

   type TOCGIntent = Cardinal;
   const oiDesign  = 2;
   const oiView    = 4;  // Default
   const oiAll     = 8;
   const oiEmpty   = 16; // Internal
   // Special flag for GetOCG().
   const oiVisible = 32; // This flag is not considered when creating a layer. It is only used in GetOCG() to determine whether a layer is visible.

type TOCGUsageCategory = Cardinal;
   const oucNone     = 0;
   const oucExport   = 1;
   const oucLanguage = 2;
   const oucPrint    = 4;
   const oucUser     = 8;
   const oucView     = 16;
   const oucZoom     = 32;

type TOCPageElement =
(
   peBackgroundImage, // BG
   peForegroundImage, // FG
   peHeaderFooter,    // HF
   peLogo,            // L
   peNone
);

type TOCUserType =
(
   utIndividual,
   utOrganization,
   utTitle,
   utNotSet
);

type TOCVisibility =
(
   ovAllOff,
   ovAllOn,
   ovAnyOff,
   ovAnyOn,
   ovNotSet  // Internal
);

type TOptimizeFlags = Cardinal;
const
   ofDefault               = $00000000; // Just rebuild the content streams.
   ofInMemory              = $00000001; // Optimize the file fully in memory. Only useful for small PDF files.
   ofConvertAllColors      = $00000002; // If set; Separation; DeviceN; and NChannel color spaces will be converted to the device space.
   ofIgnoreICCBased        = $00000004; // If set; ICCBased color spaces will be left unchanged.
   ofScaleImages           = $00000008; // Scale images as specified in the TOptimizeParams structure.
   ofSkipMaskedImages      = $00000010; // Meaningful only if ofScaleImages is set. If set; don't scale images with a color mask.
   ofNewLinkNames          = $00000020; // If set; rename all object links to short names like F1; F2 etc.
   ofDeleteInvPaths        = $00000040; // Delete invisible paths. An invisible path is a path that was finished with the no-op operator "n".
   ofFlattenLayers         = $00000080; // Flatten layers if any.
   ofDeletePrivateData     = $00000100; // Delete private data objects from pages; templates; and images.
   ofDeleteThumbnails      = $00000200; // Thumbnails can be deleted since PDF viewers can create thumbnails easily on demand.
   ofDeleteAlternateImages = $00000400; // If set; alternate images will be deleted.
   ofNoImageSizeCheck      = $00000800; // Meaningful only if ofScaleImages is set. If set; do not check whether the scaled image is smaller as the original image.
   ofIgnoreZeroLineWidth   = $00001000; // Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                        // If set, ignore line width operators with a value of zero (zero means one device unit).
   ofAdjZeroLineWidthOnly  = $00002000; // Meaningful only if the parameter MinLineWidth of the TOptimizeParams structure is greater zero.
                                        // If set, change the line width of real hairlines only (a hairline is a one pixel width line -> LineWidth == 0).
   ofCompressWithJBIG2     = $00004000; // If set, 1 bit images are compressed with JBIG2 if not already compressed with this filter.
   ofNoFilterCheck         = $00008000; // Meaningful only, if the flag ofCompressWithJBIG2 is set. If set, re-compress all 1 bit images, also if already compressed with JBIG2.
                                        // This flag is mainly a debug flag to compare the compression ratio with other JBIG2 implementations.
   ofConvertGrayTo1Bit     = $00010000; // Useful for scanned faxes since many scanners create gray images for black & white input.
   { -------------------------------------------------- Notice: ----------------------------------------------
      Special color spaces like Separation, DeviceN, and NChannel are ignored unless the flag ofConvertAllColors is set too.
   }
   ofConvertToGray         = $00020000; // If set, images, text, and vector graphics are converted to DeviceGray.
   ofConvertToRGB          = $00040000; // If set, images, text, and vector graphics are converted to DeviceRGB.
   ofConvertToCMYK         = $00080000; // If set, images, text, and vector graphics are converted to DeviceCMYK.
   ofReplaceJP2KWithJPEG   = $00100000; // Meaningful only, if the flag ofConvertToGray, ofConvertToRGB, or ofConvertToCMYK is set. If set, JPEG 2000 compressed images
                                        // (which are converted to another color space) will be compressed with JPEG instead JPEG 2000. JPEG 2000 compression is very slow
                                        // and requires much memory. JPEG compression is around 10 times faster and produces almost identical results.
   ofUseOtsuFilter         = $00200000; // Meaningful only, if the flag ofConvertGrayTo1Bit is set. The Otsu filter is useful for gray scanned faxes.
   ofConvTextToOutlines    = $00400000; // If set, texts of non-Type3 fonts are converted to outlines or vector graphics. The resulting file contains no fonts with
                                        // exception of Type3 fonts, if any. Such files are large but avoid printing issues due to missing or damaged fonts.
   ofConvNonEmbFontsOnly   = $00800000; // Meaningful only, if the flag ofConvTextToOutlines is set. If set, text of non-embedded fonts are converted to outlines only.
                                        // Embedded fonts remain embedded.
   ofIgnoreDeviceN         = $01000000; // If set, DeviceN color spaces are left unchanged.
   ofIgnoreNChannel        = $02000000; // If set, NChannel color spaces are left unchanged.
   ofIgnoreSeparation      = $04000000; // If set, Separation color spaces are left unchanged.
   ofFailOnOverprinting    = $08000000; // Meaningful only if a color conversion flag is set. If set, the function returns with a fatal error if an object with enabled
                                        // overprinting was found on the page. The appearance of overprinted objects would change and make the page maybe unusable.
                                        // Overprinted objects can be left unchanged (set the flag ofSkipOverprintedObj in this case) or Optimize() can return with a fatal
                                        // error to avoid the creation of an invalid document.
   ofSkipOverprintedObj    = $10000000; // Meaningful only if a color conversion flag is set. If set, objects that would be rendered with enabled overprinting are left
                                        // unchanged to avoid color errors on the page.
   ofRemoveBatesNumbers    = $20000000; // Remove bates numbers if any. The type BatesN can also contain headers / footers.
   ofRemoveHeaderFooter    = $40000000; // Remove headers / footers if any. This type is set if no bates numbering was added.
   ofIgnoreSeparationAll   = $80000000; // Meaningful only if a color conversion flag is set. If set, Separation color spaces with the special colorant "All" will be ignored.
   
type TOptimizeFlags2 = Cardinal;
const
   of2Default               = $00000000; // Nothing to do
   of2DeleteWatermarks      = $00000001; // Delete watermark templates
   of2DeleteWatermarkAnnots = $00000002; // If set, watermark annotations will be deleted.
   
type TOptimizeFlags3 = Cardinal;
const
   of3Default               = $00000000; // Nothing to do
   
type TOptimizeFlags4 = Cardinal;
const
   of4Default               = $00000000; // Nothing to do
   
type TOptimizeParams = record
   StructSize:     Cardinal;           // Must be set to sizeof(TOptimizeParams).

   Min1BitRes:     Cardinal;           // Minimum resolution before scaling.
   MinGrayRes:     Cardinal;           // Minimum resolution before scaling.
   MinColorRes:    Cardinal;           // Minimum resolution before scaling.

   Res1BitImages:  Cardinal;           // 1 bit black & white images.
   ResGrayImages:  Cardinal;           // Gray images.
   ResColorImages: Cardinal;           // Multi-channel images.

   Filter1Bit:     TCompressionFilter; // Filter for black & white images.
   FilterGray:     TCompressionFilter; // Filter for gray images.
   FilterColor:    TCompressionFilter; // Filter for multi-channel images.
   JPEGQuality:    Integer;            // JPEG quality.
   JP2KQuality:    Integer;            // JPEG 2000 quality.
   MinLineWidth:   Single;             // Zero means no hair line removal.
   ExcludeCS:      PCardinal;          // Array of color space handles which should be excluded from color conversion.
   ExcludeCSCount: Integer;            // Number of color space handles in the array.

   Flags2:         TOptimizeFlags2;    // Additional flags
   Flags3:         TOptimizeFlags3;    // Additional flags
   Flags4:         TOptimizeFlags4;    // Additional flags
end;

type POptimizeParams = ^TOptimizeParams;
                                        
type TOrigin =
(
   orDownLeft,
   orTopLeft
);

type TPageCoord =
(
   pcBottomUp,
   pcTopDown
);

type TPageFormat =
(
   pfDIN_A3,
   pfDIN_A4,
   pfDIN_A5,
   pfDIN_B4,
   pfDIN_B5,
   pfDIN_B6,
   pfDIN_C3,
   pfDIN_C4,
   pfDIN_C5,
   pfDIN_C6,
   pfDIN_C65,
   pfDIN_DL,
   pfDIN_E4,
   pfDIN_E5,
   pfDIN_E6,
   pfDIN_E65,
   pfDIN_M5,
   pfDIN_M65,
   pfUS_Legal,
   pfUS_Letter,
   pfDIN_A0,
   pfDIN_A1,
   pfDIN_A2,
   pfDIN_A6,
   pfDIN_A7,
   pfDIN_A8,
   pfDIN_A9,
   pfDIN_A10
);

type TPageBoundary =
(
   pbArtBox,
   pbBleedBox,
   pbCropBox,
   pbTrimBox,
   pbMediaBox
);

type TPageMode =
(
   pmUseNone,
   pmUseOutLines,
   pmUseThumbs,
   pmFullScreen,
   pmUseOC,
   pmUseAttachments
);

type TPageLabelFormat =
(
   plfDecimalArabic,    // 1,2,3,4...
   plfUppercaseRoman,   // I,II,III,IV...
   plfLowercaseRoman,   // i,ii,iii,iv...
   plfUppercaseLetters, // A,B,C,D...
   plfLowercaseLetters, // a,b,c,d...
   plfNone
);

type TPageLayout = Integer;
const
   plSinglePage      = $00000000;
   plOneColumn       = $00000001;
   plTwoColumnLeft   = $00000002;
   plTwoColumnRight  = $00000003;
   plTwoPageLeft     = $00000004;
   plTwoPageRight    = $00000005;
   plDefault         = $00000006;

type TParseFlags = Cardinal;
const pfNone             = $00000000;
const pfDecomprAllImages = $00000002; // This flag causes that all image formats will be decompressed
                                      // with the exception of JBIG2 compressed images. If this flag is
                                      // not set, images which are already stored in a valid image file
                                      // format are returned as is. This is the case for Gray and RGB JPEG
                                      // images and for JPEG2000 images. If you want to extract the images
                                      // of a PDF file this flag should NOT be set!

const pfNoJPXDecode      = $00000004; // Meaningful only if the flag pfDecomprAllImages is set. If set,
                                      // JPEG2000 images are returned as is so that you can use your own
                                      // library to decompress such images since the the entire JPEG2000
                                      // codec is still marked as experimental. If we find an alternative
                                      // to the currently used Jasper library then we will replace it
                                      // immediatly with another one...

// The following flags are ignored if an image is not decompressed. Note that only one flag must be set
// at time. If no color space conversion flag is set images are returned in their native or alternate
// device color space. Note that these flags do not convert colors of vector graphics and so on.
// Use the function ConvColor() to convert colors of the graphics state into a device space.
const pfDitherImagesToBW = $00000008; // Floyd-Steinberg dithering.
const pfConvImagesToGray = $00000010;
const pfConvImagesToRGB  = $00000020;
const pfConvImagesToCMYK = $00000040;
const pfImageInfoOnly    = $00000080; // If set, images are not decompressed. This flag is useful if you want
                                      // to enumerate the images of a PDF file or if you want to determine how
                                      // many images are stored in it.
                                      // Note that images can be compressed with multiple filters. The member
                                      // Filter of the structure TPDFImage contains only the last filter with
                                      // which the image was compressed. There is no indication whether multiple
                                      // decode filters are required to decompress the image buffer. So, it
                                      // makes no sense to set this flag if you want to try to decompress the
                                      // image buffer manually with your own decode filters.
const pfErrorCheckOnly   = $00000100; // If set, images are checked for decompression errors only. Used internally by CheckConformance().
const pfFailOnError      = $80000000; // Fail on decompression errors. Used internally by CheckConformance().

type TPathFillMode =
(
   fmFillNoClose,
   fmStrokeNoClose,
   fmFillStrokeNoClose,
   fmFill,
   fmStroke,
   fmFillStroke,
   fmFillEvOdd,
   fmFillStrokeEvOdd,
   fmFillEvOddNoClose,
   fmFillStrokeEvOddNoClose,
   fmNoFill,
   fmClose
);

type TPatternType =
(
   ptColored,
   ptUnColored,
   ptShadingPattern // Cannot be created with DynaPDF
);

{
   Notice:
   When using a bidirectional 8 bit code page the bidi algorithm is applied by default in Left to Right mode
   also if the bidi mode is set to bmNone (default). This mode produces identical results in comparison to
   applications like Edit or WordPad.

   The Right to Left mode is available in applications which use Microsoft's Uniscribe, e.g. BabelPad or MS Word.
   This mode works very well with the Reference Bidi Algorithm which is used by DynaPDF but Uniscribe's Left to Right
   mode produces different results in comparison to the Reference Bidi Algorithm. Because the bidi algorithm that is
   used in Uniscribe is not published it is practically impossible to get the same result in Left to Right mode
   without using this library.
}
type TPDFBidiMode =
(
   bmLeftToRight, // Apply the bidi algorithm on Unicode strings in Left to Right layout.
   bmRightToLeft, // Apply the bidi algorithm on Unicode strings in Right to Left layout.
   bmNone         // Default -> do not apply the bidi algorithm
);

type TPDFFontFlags = Cardinal;
const
   pffFixedPitch  = $00000001;
   pffSerifs      = $00000002;
   pffSymbolic    = $00000004;
   pffScriptStyle = $00000008;
   pffReserved1   = $00000010;
   pffNonSymbolic = $00000020;
   pffItalic      = $00000040;
   pffAllCap      = $00010000;
   pffSmallCap    = $00020000;
   pffForceBold   = $00040000;

type TPDFMarkedContentType =
(
   mcBDC, // Begins a marked content sequence with a property list
   mcBMC, // Same as BDC but without a property list
   mcDP,  // Marked content point with a property list
   mcMP,  // Same as DP but without a property list
   mcOCG, // Begins an optional content sequence with an Optional Content Group (OCG), also called layer
   mcOCMD // Begins an optional content sequence with an Optional Content Membership Dictionary (this is a visibility expression)
);
   
type TPDFMarkInfo = Cardinal;
const
   miNotTagged      = $00000000;
   miTagged         = $00000001;
   miSuspects       = $00000002;
   miUserProperties = $00000004;
   
type TPrintScaling =
(
   psAppDefault, // Default
   psNone
);

type TPDFPrintFlags = Cardinal;
const
   pffDefault             = $00000000; // Gray printing
   pff1Bit                = $00000001; // Black & White output
   pffColor               = $00000002; // Color output
   pffAutoRotateAndCenter = $00000004; // Rotate and center the page if necessary
   pffPrintAsImage        = $00000008; // Defined for future use
   pffShrinkToPrintArea   = $00000010; // Scale the page so that it fits into the printable area
   pffNoStartDoc          = $00000020; // If set; StartDoc() of the Windows print API will not be called
   pffNoStartPage         = $00000040; // If set; StartPage() of the Windows print API will not be called
   pffNoEndDoc            = $00000080; // If set; EndDoc() of the Windows print API will not be called
   pffPrintPageAsIs       = $00000100; // If set; do not scale or rotate a page to fit into the printable area
   pffAutoRotate          = $00000200; // Rotate the page if necessary
   pffAutoCenter          = $00000400; // Center the page

type TPDFPrintSettings = record
   DuplexMode:        TDuplexMode;
   NumCopies:         Integer;      // -1 means not set. Values larger than 5 are ignored in viewer applications.
   PickTrayByPDFSize: Integer;      // -1 means not set. 0 == false, 1 == true.
   PrintRanges:       PCardinal;    // If set, the array contains PrintRangesCount * 2 values. Each pair consists
                                    // of the first and last pages in the sub-range. The first page in the PDF file
                                    // is denoted by 0.
   PrintRangesCount: Cardinal;      // Number of ranges available in PrintRanges.
   PrintScaling:     TPrintScaling; // dpmNone means not set.
   { Reserved fields for future extensions }
   Reserved0: Cardinal;
   Reserved1: Cardinal;
   Reserved2: Cardinal;
   Reserved3: Cardinal;
   Reserved4: Cardinal;
   Reserved5: Cardinal;
   Reserved6: Cardinal;
   Reserved7: Cardinal;
   Reserved8: Cardinal;
   Reserved9: Cardinal;
end;

type TPwdType = Cardinal;
const
   ptOpen        = 0;
   ptOwner       = 1;
   ptForceRepair = 2; // Meaningful only when opening a PDF file with OpenImportFile() or OpenImportBuffer().
                      // If set, the PDF parser rebuilds the cross-reference table by scanning all the objects
                      // in the file. This can be useful if the cross-reference table contains damages while
                      // the top level objects are intact. Setting this flag makes only sence if the file
                      // was already previously opened in normal mode and if errors occured when importing
                      // pages of it.
   ptDontCopyBuf = 4; // If set, OpenImportBuffer() does not copy the PDF buffer to an internal buffer. This
                      // increases the processing speed and reduces the memory usage. The PDF buffer must not
                      // be released until CloseImportFile() or CloseFile() was called.

type TRawImageFlags = Cardinal;
const
   rifByteAligned  = $1000;
   rifRGBData      = $2000;
   rifCMYKData     = $4000;

type TRenderingIntent =
(
   riAbsoluteColorimetric,
   riPerceptual,
   riRelativeColorimetric,
   riSaturation,
   riNone
);

type TReplaceImageFlags = Cardinal;
const
   rifDefault         = 0; // Nothing special to do.
   rifDeleteAltImages = 1; // Delete all alternate images that are associated with this image if any.
   rifDeleteMetadata  = 2; // Delete the meta data that was associated with the image.
   rifDeleteOCG       = 4; // Delete the Optional Content Group if any. This changes the visibility state of the image. Normally the OCG should be left as is.
   rifDeleteSoftMask  = 8; // An image can contain a soft mask that acts as an alpha channel. This mask can be deleted or left as is.

type TRestrictions = Integer;
const
   rsDenyNothing      = $00000000;
   rsDenyAll          = $00000F3C;
   rsPrint            = $00000004;
   rsModify           = $00000008;
   rsCopyObj          = $00000010;
   rsAddObj           = $00000020;
   // 128/256 bit encryption only -> these flags are ignored if 40 bit encryption is used
   rsFillInFormFields = $00000100;
   rsExtractObj       = $00000200;
   rsAssemble         = $00000400;
   rsPrintHighRes     = $00000800;
   rsExlMetadata      = $00001000; // PDF 1.5 Exclude metadata streams -> 128/256 bit encryption bit only.
   rsEmbFilesOnly     = $00002000; // PDF 1.6 Encrypt embedded files only -> Requires AES encryption.

type TRubberStamp =
(
   rsApproved,
   rsAsIs,
   rsConfidential,
   rsDepartmental,
   rsDraft,
   rsExperimental,
   rsExpired,
   rsFinal,
   rsForComment,
   rsForPublicRelease,
   rsNotApproved,
   rsNotForPublicRelease,
   rsSold,
   rsTopSecret,
   rsUserDefined
);

type TSoftMaskType =
(
   smtAlpha,
   smtLuminosity
);

type TSubmitFlags = Integer;
   const sfNone             = $00000000;
   const sfExlude           = $00000001; // if set, the fields in a sumbmit or reset form action are excluded
   const sfInclNoValFields  = $00000002;
   const sfHTML             = $00000004;
   const sfGetMethod        = $00000008;
   const sfSubmCoords       = $00000010;
   const sfXML              = $00000024;
   const sfInclAppSaves     = $00000040;
   const sfInclAnnots       = $00000080;
   const sfPDF              = $00000100;
   const sfCanonicalFormat  = $00000200;
   const sfExlNonUserAnnots = $00000400;
   const sfExlFKey          = $00000800;
   const sfEmbedForm        = $00002000; // PDF 1.5 embed the entire form into a file stream inside the FDF file -> requires the full version of Adobe's Acrobat

type TTabOrder =
(
   toRow,
   toColumn,
   toStructure,
   toNone,
   toAnnots, // Annotation order -> PDF 1.7 Extension Level 3
   toFields  // Widget order (Form Fields) -> PDF 1.7 Extension Level 3
);

type TTextExtractionFlags = Integer;
   const tefDefault               = 0; // Create text lines in the original order.
   const tefSortTextX             = 1; // Sort text records in x-direction.
   const tefSortTextY             = 2; // Sort text records in y-direction.
   const tefSortTextXY            = tefSortTextX or tefSortTextY;
   const tefDeleteOverlappingText = 4; // Text extraction only.
   const tefNoHeuristic           = 8; // If set, text is sorted on the x-axis as specified. If absent, a heuristic
                                       // is used to determine whether it is might be better to leave a line unsorted.

type TTilingType =
(
   ttConstSpacing,
   ttNoDistortion,
   ttFastConstSpacing
);

type TTextAlign = Cardinal;
const
   taLeft      = 0;
   taCenter    = 1;
   taRight     = 2;
   taJustify   = 3;
   taPlainText = $10000000; // If this flag is set alignment and command tags are interpreted as plain text.
                            // See WriteFText() in the help file for further information.

type TTextRecordA = record
   Advance: Single;    // Negative values move the cursor to right, positive to left. The value is measured in text space!
   Text:    PAnsiChar; // Raw text (not null-terminated)
   Length:  Integer;   // Raw text length in bytes
end;

type TTextRecordAPtr = ^TTextRecordA;

type TTextRecordW = record
   Advance: Single;    // Negative values move the cursor to right, positive to left. The value is measured in text space!
   Text:    PWideChar; // Already translated Unicode string (not null-terminated)
   Length:  Integer;   // Length in characters
   Width:   Single;    // String width measured in text space
end;

type TTextRecordWPtr = ^TTextRecordW;

type TPDFAnnotation = record
   AnnotType:     TAnnotType;
   Deleted:       LongBool;
   BBox:          TPDFRect;
   BorderWidth:   Double;
   BorderColor:   Cardinal;
   BorderStyle:   TBorderStyle;
   BackColor:     Cardinal;
   Handle:        Cardinal;
   AuthorA:       PAnsiChar;
   AuthorW:       PWideChar;
   ContentA:      PAnsiChar;
   ContentW:      PWideChar;
   NameA:         PAnsiChar;
   NameW:         PWideChar;
   SubjectA:      PAnsiChar;
   SubjectW:      PWideChar;
   PageNum:       Cardinal;
   HighlightMode: THighlightMode;
end;

type TPDFAnnotationEx = record
   AnnotType:        TAnnotType;
   Deleted:          LongBool;
   BBox:             TPDFRect;
   BorderWidth:      Single;
   BorderColor:      Cardinal;
   BorderStyle:      TBorderStyle;
   BackColor:        Cardinal;
   Handle:           Cardinal;
   AuthorA:          PAnsiChar;
   AuthorW:          PWideChar;
   ContentA:         PAnsiChar;
   ContentW:         PWideChar;
   NameA:            PAnsiChar;
   NameW:            PWideChar;
   SubjectA:         PAnsiChar;
   SubjectW:         PWideChar;
   PageNum:          Cardinal;
   HighlightMode:    THighlightMode;
   // Page link annotations only
   DestPage:         Integer;
   DestPos:          TPDFRect;
   DestType:         TDestType;
   DestFile:         PAnsiChar;        // File link or web link annotations
   // The Icon type depends on the annotation type. If the annotation type is atText then the Icon
   // is of type TAnnotIcon. If the annotation type is atFileAttach then it is of type
   // TFileAttachIcon. If the annotation type is atStamp then the Icon is the stamp type (TRubberStamp).
   // For any other annotation type this value is not set (-1).
   Icon:             Integer;
   StampName:        PAnsiChar;        // Set only, if Icon == rsUserDefined
   AnnotFlags:       Cardinal;         // See TAnnotFlags for available flags
   CreateDate:       PAnsiChar;        // Creation Date -> Optional
   ModDate:          PAnsiChar;        // Modification Date -> Optional
   Grouped:          LongBool;         // (Reply type) Meaningful only if Parent != -1 and Type != atPopUp. If true,
                                       // the annotation is part of an annotation group. Properties like Content, CreateDate,
                                       // ModDate, BackColor, Subject, and Open must be taken from the parent annotation.
   Open:             LongBool;         // Meaningful only for annotations which have a corresponding PopUp annotation.
   Parent:           Integer;          // Parent annotation handle of a PopUp Annotation or the parent annotation if
                                       // this annotation represents a state of a base annotation. In this case,
                                       // the annotation type is always atText and only the following members should
                                       // be considered:
                                       //    State      // The current state
                                       //    StateModel // Marked, Review, and so on
                                       //    CreateDate // Creation Date
                                       //    ModDate    // Modification Date
                                       //    Author     // The user who has set the state
                                       //    Content    // Not displayed in Adobe's Acrobat...
                                       //    Subject    // Not displayed in Adobe's Acrobat...
                                       // The PopUp annotation of a text annotation which represent an Annotation State
                                       // must be ignored.
   PopUp:            Integer;          // Handle of the corresponding PopUp annotation if any.
   State:            PAnsiChar;        // The state of the annotation.
   StateModel:       PAnsiChar;        // The state model (Marked, Review, and so on).
   EmbeddedFile:     Integer;          // FileAttach annotations only. A handle of an embedded file -> GetEmbeddedFile().
   Subtype:          PAnsiChar;        // Set only, if Type == atUnknownAnnot
   PageIndex:        Cardinal;         // The page index is used to sort form fields. See SortFieldsByIndex().
   MarkupAnnot:      LongBool;         // If true, the annotation is a markup annotation. Markup annotations can be flattened
                                       // separately, see FlattenAnnots().
   Opacity:          Single;           // Opacity = 1.0 = Opaque, Opacity < 1.0 = Transparent, Markup annotations only
   QuadPoints:       PSingle;          // Highlight, Link, and Redact annotations only
   QuadPointsCount:  Cardinal;         // Highlight, Link, and Redact annotations only

   DashPattern:      PSingle;          // Only present if BorderStyle == bsDashed
   DashPatternCount: Cardinal;         // Number of values in the array

   Intent:           PAnsiChar;        // Markup annotations only. The intent allows to distinguish between different uses of an annotation.
                                       // For example, line annotations have two intents: LineArrow and LineDimension.
   LE1:              TLineEndStyle;    // Line end style of the start point -> Line and PolyLine annotations only
   LE2:              TLineEndStyle;    // Line end style of the end point -> Line and PolyLine annotations only
   Vertices:         PSingle;          // Line, PolyLine, and Polygon annotations only
   VerticesCount:    Cardinal;         // Number of values in the array. This is the raw number of floating point values.
                                       // Since a vertice requires always two coordinate pairs, the number of vertices
                                       // or points is VerticeCount divided by 2.
   // Line annotations only. These properties should only be considered if the member Intent is set to the string LineDimension.
   Caption:          LongBool;         // If true, the annotation string Content is used as caption. The string is shown in a PopUp annotation otherwise.
   CaptionOffsetX:   Single;           // Horizontal offset of the caption from its normal position
   CaptionOffsetY:   Single;           // Vertical offset of the caption from its normal position
   CaptionPos:       TLineCaptionPos;  // The position where the caption should be drawn if present
   LeaderLineLen:    Single;           // Length of the leader lines (positive or negative)
   LeaderLineExtend: Single;           // Optional leader line extend beyond the leader line (must be a positive value or zero)
   LeaderLineOffset: Single;           // Amount of space between the endpoints of the annotation and the leader lines (must be a positive value or zero)

   BorderEffect:     TBorderEffect;    // Circle, Square, FreeText, and Polygon annotations.
   RichStyle:        PAnsiChar;        // Optional default style string.      -> FreeText annotations only.
   RichtText:        PAnsiChar;        // Optional rich text string (RC key). -> Markup annotations only.

   InkList:          PPointer;         // Ink annotations only. Array of array. The sub arrays can be accessed with GetInkList().
   InkListCount:     Cardinal;         // Number of ink arrays.
   OC:               Integer;          // Handle of an OCG or OCMD or -1 if not set. See help file for further information.

   RD:               PFltRect;         // Caret, Circle, Square, and FreeText annotations. 
   Rotate:           Integer;          // Caret annotations only. Must be zero or a multiple of 90. This key is not documented in the specs.
end;

type TPDFBarcode = record
   StructSize:   Cardinal;  // Must be set to sizeof(TPDFBarcode) before calling CreateBarcodeField()!
   CaptionA:     PAnsiChar; // Optional, the ansi string takes precedence
   CaptionW:     PWideChar; // Optional
   ECC:          Single;    // 0..8 for PDF417, or 0..3 for QRCode
   Height:       Single;    // Height in inches
   nCodeWordCol: Single;    // Required for PDF417. The number of codewords per barcode coloumn.
   nCodeWordRow: Single;    // Required for PDF417. The number of codewords per barcode row.
   Resolution:   Cardinal;  // Required -> Should be 300
   Symbology:    PAnsiChar; // PDF417, QRCode, or DataMatrix.
   Version:      Single;    // Should be 1
   Width:        Single;    // Width in inches
   XSymHeight:   Single;    // Only needed for PDF417. The vertical distance between two barcode modules,
                            // measured in pixels. The ratio XSymHeight/XSymWidth shall be an integer
                            // value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode
                            // and DataMatrix, this ratio shall always be 1.
   XSymWidth:    Single;    // Required -> The horizontal distance, in pixels, between two barcode modules.
end;

// The tags have the same meaning as the corresponding HTML tags.
// See PDF Reference for further information.
type TPDFBaseTag =
(
   btArt,
   btArtifact,
   btAnnot,
   btBibEntry,      // BibEntry -> Bibliography entry
   btBlockQuote,
   btCaption,
   btCode,
   btDiv,
   btDocument,
   btFigure,
   btForm,
   btFormula,
   btH,
   btH1,
   btH2,
   btH3,
   btH4,
   btH5,
   btH6,
   btIndex,
   btLink,
   btList,          // L
   btListElem,      // LI
   btListText,      // LBody
   btNote,
   btP,
   btPart,
   btQuote,
   btReference,
   btSection,       // Sect
   btSpan,
   btTable,
   btTableDataCell, // TD
   btTableHeader,   // TH
   btTableRow,      // TR
   btTOC,
   btTOCEntry,      // TOCI
   btCL,            // CL (Continued List)
   btLabel,         // Lbl
   btRuby,
   btWarichu,
   // PDF 2.0 tags:
   btAbbr,
   btCallout,
   btDek,
   btEm,
   btLineNum,
   btReason,
   btRedaction,
   btSidebar,
   btStrong,
   btSub,
   btSup
);

type TPDFBitmap = record
   StructSize: Cardinal; // Must be set to sizeof(TPDFBitmap)
   Buffer:     PByte;    // Image buffer
   BufSize:    Cardinal; // Buffer size in bytes
   DestX:      Integer;  // Destination x-coordinate on the main image (the rendered page)
   DestY:      Integer;  // Destination y-coordinate on the main image (the rendered page)
   Height:     Cardinal; // Image height in pixels
   Stride:     Integer;  // Scanline length in bytes
   Width:      Cardinal; // Image width
end;

type TPDFChoiceValue = record
   StructSize:  Cardinal; // Must be set with sizeof(TPDFChoiceValue)
   ExpValueA:   PAnsiChar;
   ExpValueW:   PWideChar;
   ExpValueLen: Cardinal;
   ValueA:      PAnsiChar;
   ValueW:      PWideChar;
   ValueLen:    Cardinal;
   Selected:    LongBool;
end;

{
   The structure contains several duplicate fields because CMap files contain usually a DSC comment
   section which provides Postscript specific initialization code. With exception of DSCResName the
   strings in the DSC section should not differ from their CMap counterparts. The Identity mapping
   of a character collection should contain the DSC comment "%%BeginResource: CMap (Identity)".
   Otherwise the string should be set to the CMap name.
}
type TPDFCMap = record
   StructSize:     Cardinal;  // Must be set to sizeof(TPDFCMap) before calling GetCMap()!
   BaseCMap:       PAnsiChar; // If set, this base cmap is required when loading the cmap.
   CIDCount:       Cardinal;  // 0 if not set.
   CMapName:       PAnsiChar; // The CMap name.
   CMapType:       Cardinal;  // Should be 1!
   CMapVersion:    Single;    // The CMap version.
   DSCBaseCMap:    PAnsiChar; // DSC comment.
   DSCCMapVersion: Single;    // DSC comment.
   DSCResName:     PAnsiChar; // DSC comment. If the CMap uses an Identity mapping this string should be set to Identity.
   DSCTitle:       PAnsiChar; // DSC comment -> DSC CMap name + Registry + Ordering + Supplement, e.g. "GB-EUC-H Adobe GB1 0"
   FileNameA:      PAnsiChar; // The file name and CMap name should be identical!
   FileNameW:      PWideChar; // The file name and CMap name should be identical!
   FilePathA:      PAnsiChar; // The Ansi string is set if the Ansi version of SetCMapDir() was used.
   FilePathW:      PWideChar; // The Unicode string is set if the Unicode version of SetCMapDir() was used.
   Ordering:       PAnsiChar; // CIDSystemInfo -> The Character Collection, e.g. Japan1.
   Registry:       PAnsiChar; // CIDSystemInfo -> The registrant of the Character Collection is usually Adobe.
   Supplement:     Cardinal;  // CIDSystemInfo -> The Supplement number should be supported in the used PDF Version.
   WritingMode:    Cardinal;  // 0 == Horizontal, 1 == Vertical
end;

type TPDFColSplitInfo =
(
   spiNone,       // Do not display a splitter
   spiHorizontal, // Display a horizontal splitter
   spiVertical    // Display a vertical splitter
);

type TPDFCollectionInfo = record
   StructSize: Cardinal;         // Must be set to sizeof(TPDFColectionInfo)
   InitalFile: Integer;          // Possible values are -2, -1, or a valid embedded files handle (a value greater or equal zero). See help file for further information.
   InitalView: TColView;         // Determines how embedded files should be displayed.
   SortBy:     PAnsiChar;        // Optional name of the first field that should be used to sort the list of embedded files.
   SortDesc:   Boolean;          // If true, the list of embedded files should be sorted in descending order.
   SplitInfo:  TPDFColSplitInfo; // Determines whether a splitter bar should be displayed.
   SplitPos:   Single;           // Meaningful only, if SplitInfo is not spiNone. The initial position of the splitter bar,
                                 // specified as a percentage of the available window area (0 to 100).
end;

type TPDFColorSpace =
(
   csDeviceRGB,
   csDeviceCMYK,
   csDeviceGray
);

type TPDFColorSpaceObj = record
   ColorSpaceType:   TExtColorSpace;
   Alternate:        TExtColorSpace; // Alternate color space or base space of an Indexed or Pattern color space.
   IAlternate:       Pointer;        // Only set if the color space contains an alternate or base color space -> GetColorSpaceObjEx().
   Buffer:           PByte;          // Contains either an ICC profile or the color table of an Indexed color space.
   BufSize:          Cardinal;       // Buffer length in bytes.
   BlackPoint:       PSingle;        // CIE blackpoint. If set, the array contains exactly 3 values.
   WhitePoint:       PSingle;        // CIE whitepoint. If set, the array contains exactly 3 values.
   Gamma:            PSingle;        // If set, one value per component.
   Range:            PSingle;        // min/max for each component or for the .a and .b components of a Lab color space.
   Matrix:           PSingle;        // XYZ matrix. If set, the array contains exactly 9 values.
   NumInComponents:  Cardinal;       // Number of input components.
   NumOutComponents: Cardinal;       // Number of output components.
   NumColors:        Cardinal;       // HiVal + 1 as specified in the color space. Indexed color space only.
   Colorants:        Array[0..31] of PAnsiChar; // UTF-8 Colorant names (Separation, DeviceN, and NChannel only).
   ColorantsCount:   Cardinal;       // The number of colorants in the array.
   Metadata:         PByte;          // Optional XMP metadata stream -> ICCBased only.
   MetadataSize:     Cardinal;       // Metadata length in bytes.
   IFunction:        Pointer;        // Pointer to function object -> Separation, DeviceN, and NChannel only.
   IAttributes:      Pointer;        // Optional attributes of DeviceN or NChannel color spaces -> GetNChannelOptions().
   IColorSpaceObj:   Pointer;        // Pointer of the corresponding color space object
   Handle:           Integer;        // Handle of the color space object or -1 if an internal color space object was returned by ParseContent(), for example.
   Reserved01:       Pointer;
   Reserved02:       Pointer;
   Reserved03:       Pointer;
   Reserved04:       Pointer;
   Reserved05:       Pointer;
   Reserved06:       Pointer;
   Reserved07:       Pointer;
   Reserved08:       Pointer;
end;

type TDeviceNAttributes = record
   IProcessColorSpace:    Pointer;    // Pointer to process color space or NULL -> GetColorSpaceEx().
   ProcessColorants:      Array[0..7] of PAnsiChar; // UTF-8 Process colorant names
   ProcessColorantsCount: Cardinal;   // Number of process colorants in the array or zero if not set.
   Separations:           Array[0..31] of Pointer; // Optional pointers to Separation color spaces -> GetColorSpaceEx().
   SeparationsCount:      Cardinal;   // Number of color spaces in the array.
   IMixingHints:          Pointer;    // Optional mixing hints. There is no API function at this time to access mixing hints.
   Reserved01:            Pointer;
   Reserved02:            Pointer;
   Reserved03:            Pointer;
   Reserved04:            Pointer;
end;

type TPDFDateTime =
(
   dfMM_D,
   dfM_D_YY,
   dfMM_DD_YY,
   dfMM_YY,
   dfD_MMM,
   dfD_MMM_YY,
   dfDD_MMM_YY,
   dfYY_MM_DD,
   dfMMM_YY,
   dfMMMM_YY,
   dfMMM_D_YYYY,
   dfMMMM_D_YYYY,
   dfM_D_YY_H_MM_TT,
   dfM_D_YY_HH_MM,
   { time formats }
   df24HR_MM,
   df12HR_MM,
   df24HR_MM_SS,
   df12HR_MM_SS
);

type TPDFEncryptInfo = record
   StructSize:        Cardinal;      // Must be set to sizeof(TPDFEncryptInfo)
   Filter:            TKeyLen;       // Encryption filter
   HaveOpenPassword:  LongBool;      // If true, an open password was set.
   HaveOwnerPassword: LongBool;      // If true, an owner password was set. This should always be true!
   Restrictions:      TRestrictions; // What must be restricted? No additional call of GetInEncryptionFlags() required.
   UnsafeOpenPwd:     LongBool;      // If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
   UnsafeOwnerPwd:    LongBool;      // If true, the file can be easily decrypted by DynaPDF if SetUseExactPwd() is false.
end;

type TPDFError = record
   StructSize: Cardinal;  // Must be initialized to sizeof(TPDFError)
   Msg:        PAnsiChar; // The error message
   ObjNum:     Integer;   // -1 if not available
   Offset:     Integer;   // -1 if not available
   SrcFile:    PAnsiChar; // Source file
   SrcLine:    Cardinal;  // Source line
   ErrCode:    Integer;   // ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
   ErrType:    Integer;   // ErrCode and ErrType are set if the error mode was set to emUseErrLog. See SetErrorMode() for further information.
end;

// It is not possible to set all available graphic state parameters with DynaPDF, such as black generation functions,
// halftones and so on. The structure will be extended when further objects are supported.
type TPDFExtGState = record
   AutoStrokeAdjust: Cardinal;          // PDF_MAX_INT if not set
   BlendMode:        TBlendMode;        // Default bmNotSet
   FlatnessTol:      Single;            // -1.0 if not set
   OverPrintFill:    Cardinal;          // PDF_MAX_INT if not set
   OverPrintStroke:  Cardinal;          // PDF_MAX_INT if not set
   OverPrintMode:    Cardinal;          // PDF_MAX_INT if not set
   RenderingIntent:  TRenderingIntent;  // riNone if not set
   SmoothnessTol:    Single;            // -1.0 if not set
   FillAlpha:        Single;            // -1.0 if not set
   StrokeAlpha:      Single;            // -1.0 if not set
   AlphaIsShape:     Cardinal;          // PDF_MAX_INT if not set
   TextKnockout:     Cardinal;          // PDF_MAX_INT if not set
   SoftMaskNone:     LongBool;          // Disables the active soft mask
   SoftMask:         Pointer;           // Soft mask pointer or nil. See CreateSoftMask() for further information.
   Reserved1:        Pointer;
   Reserved2:        Pointer;
   Reserved3:        Pointer;
   Reserved4:        Pointer;
   Reserved5:        Pointer;
   Reserved6:        Pointer;
   Reserved7:        Pointer;
end;

// Extended graphics state dictionary
type TPDFExtGState2 = record
   AlphaIsShape:       Integer;          // PDF_MAX_INT if not set
   AutoStrokeAdjust:   Integer;          // PDF_MAX_INT if not set
   BlackGen:           Pointer;          // Function handle or NULL -> GetFunction()
   BlackGen2:          Pointer;          // Function handle or NULL -> GetFunction()
   BlendMode:         ^TBlendMode;       // Array of blend modes or nil
   BlendModeCount:     Cardinal;         // Number of blend modes
   FillAlpha:          Single;           // -1.0 if not set
   FlatnessTol:        Single;           // -1.0 if not set
   Halftone:           Pointer;          // Halftone handle or NULL -> GetHalftoneDict()
   OverPrintFill:      Integer;          // PDF_MAX_INT if not set
   OverPrintStroke:    Integer;          // PDF_MAX_INT if not set
   OverPrintMode:      Integer;          // PDF_MAX_INT if not set
   RenderingIntent:    TRenderingIntent; // riNone if not set
   SmoothnessTol:      Single;           // -1.0 if not set
   SoftMask:           Pointer;          // Soft mask handle or NULL
   StrokeAlpha:        Single;           // -1.0 if not set
   TextKnockout:       Integer;          // PDF_MAX_INT if not set
   TransferFunc:       Pointer;          // Array of functions -> GetFunction()
   TransferFuncCount:  Cardinal;         // Number of transfer functions
   TransferFunc2:      Pointer;          // Array of functions -> GetFunction()
   TransferFunc2Count: Cardinal;         // Number of transfer functions
   UnderColorRem:      Pointer;          // Function handle or NULL -> GetFunction()
   UnderColorRem2:     Pointer;          // Function handle or NULL -> GetFunction()
   SoftMaskNone:       LongBool;         // If true, the current softmask will be disabled
   Reserved1:          Pointer;
   Reserved2:          Pointer;
   Reserved3:          Pointer;
end;

type TPDFField = record
   FieldType:    Integer;
   Deleted:      LongBool;
   BBox:         TPDFRect;
   Handle:       Integer;
   FieldName:    PAnsiChar;
   FieldNameLen: Cardinal;
   BackCS:       Cardinal;
   TextCS:       Cardinal;
   BackColor:    Cardinal;
   BorderColor:  Cardinal;
   TextColor:    Cardinal;
   Checked:      LongBool;
   Parent:       Integer;
   KidCount:     Cardinal;
   Font:         PAnsiChar;
   FontSize:     Double;
   Value:        Pointer;
   UniVal:       LongBool;
   ValLen:       Cardinal;
   ToolTip:      Pointer;
   UniToolTip:   LongBool;
   ToolTipLen:   Cardinal;
end;

const PDF_ANNOT_INDEX = $40000000; // Special flag for GetPageFieldEx() to indicate that an annotation index
                                   // was passed to the function. See GetPageFieldEx() for further information.

type TPDFFieldEx = record
   StructSize:    Cardinal;       // Must be set to sizeof(TPDFFieldEx)
   Deleted:       LongBool;       // If true, the field was marked as deleted by DeleteField()
   BBox:          TPDFRect;       // Bounding box of the field in bottom-up coordinates
   FieldType:     TFieldType;     // Field type
   GroupType:     TFieldType;     // If GroupType != FieldType the field is a terminal field of a field group
   Handle:        Cardinal;       // Field handle
   BackColor:     Cardinal;       // Background color
   BackColorSP:   TExtColorSpace; // Color space of the background color
   BorderColor:   Cardinal;       // Border color
   BorderColorSP: TExtColorSpace; // Color space of the border color
   BorderStyle:   TBorderStyle;   // Border style
   BorderWidth:   Single;         // Border width
   CharSpacing:   Single;         // Text fields only
   Checked:       LongBool;       // Check boxes only
   CheckBoxChar:  Cardinal;       // ZapfDingbats character that is used to display the on state
   DefState:      TCheckBoxState; // Check boxes only
   DefValueA:     PAnsiChar;      // Optional default value
   DefValueW:     PWideChar;      // Optional default value
   IEditFont:     PFNT;           // Pointer to default editing font
   EditFont:      PAnsiChar;      // Postscript name of the editing font
   ExpValCount:   Cardinal;       // Combo and list boxes only. The values can be accessed with GetFieldExpValueEx()
   ExpValueA:     PAnsiChar;      // Check boxes only
   ExpValueW:     PWideChar;      // Check boxes only
   FieldFlags:    TFieldFlags;    // Field flags
   IFieldFont:    PFNT;           // Pointer to the font that is used by the field
   FieldFont:     PAnsiChar;      // Postscript name of the font
   Reserved:      Integer;        // Reserved field to avoid alignment errors
   FontSize:      Double;         // Font size. 0.0 means auto font size
   FieldNameA:    PAnsiChar;      // Note that children of a field group or radio button have no name
   FieldNameW:    PWideChar;      // Note that children of a field group or radio button have no name
   HighlightMode: THighlightMode; // Highlight mode
   IsCalcField:   LongBool;       // If true, the OnCalc event of the field is connected with a JavaScript action
   MapNameA:      PAnsiChar;      // Optional unique mapping name of the field
   MapNameW:      PWideChar;      // If true, MapName is an Unicode string
   MaxLen:        Cardinal;       // Text fields only -> zero means not restricted
   Kids:          PIFLD;          // Array of child fields -> GetFieldEx2()
   KidCount:      Cardinal;       // Number of fields in the array
   Parent:        Pointer;        // Pointer to parent field or NULL
   PageNum:       Integer;        // Page on which the field is used or -1
   Rotate:        Integer;        // Rotation angle in degrees
   TextAlign:     TTextAlign;     // Text fields only
   TextColor:     Cardinal;       // Text color
   TextColorSP:   TExtColorSpace; // Color space of the field's text
   TextScaling:   Single;         // Text fields only
   ToolTipA:      PAnsiChar;      // Optional tool tip
   ToolTipW:      PWideChar;      // Optional tool tip
   UniqueNameA:   PAnsiChar;      // Optional unique name (NM key)
   UniqueNameW:   PWideChar;      // Optional unique name (NM key)
   ValueA:        PAnsiChar;      // Field value
   ValueW:        PWideChar;      // Field value
   WordSpacing:   Single;         // Text fields only
   PageIndex:     Cardinal;       // Array index to change the tab order, see SortFieldsByIndex().
   IBarcode:      IFLD;           // If present, this field is a barcode field. The field type is set to ftText
                                  // since barcode fields are extended text fields. -> GetBarcodeDict().
   ISignature:    IFLD;           // Signature fields only. Present only for imported signature fields which
                                  // which have a value. That means the file was digitally signed. -> GetSigDict().
                                  // Signed signature fields are always marked as deleted!
   ModDate:       PAnsiChar;      // Last modification date (optional)

   // Push buttons only. The down and roll over states are optional. If not present, then all states use the up state.
   // The handles of the up, down, and roll over states are template handles! The templates can be opened for editing
   // with EditTemplate2() and parsed with ParseContent().
   CaptionPos:    TBtnCaptionPos; // Where to position the caption relative to its image
   DownCaptionA:  PAnsiChar;      // Caption of the down state
   DownCaptionW:  PWideChar;      // Caption of the down state
   DownImage:     Integer;        // Image of the down state
   RollCaptionA:  PAnsiChar;      // Caption of the roll over state
   RollCaptionW:  PWideChar;      // Caption of the roll over state
   RollImage:     Integer;        // Image of the roll over state
   UpCaptionA:    PAnsiChar;      // Caption of the up state
   UpCaptionW:    PWideChar;      // Caption of the up state
   UpImage:       Integer;        // Image of the up state -> if > -1, the button is an image button
   OC:            Integer;        // Handle of an OCG or OCMD or -1 if not set. See help file for further information.
   Action:        Integer;        // Action handle or -1 if not set. This action is executed when the field is activated.
   ActionType:    TActionType;    // Meaningful only, if Action >= 0.
   Events:        IEVT;           // See GetObjEvent() if set.
   Reserved2:     Cardinal;       // Reserved field to avoid alignment errors
   FmtTextColor:  Cardinal;       // Zero if not set. Usually RGB red otherwise.
   FmtTextA:      PAnsiChar;      // Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
   FmtTextW:      PWideChar;      // Text fields only. The formatted field value if the field contains an OnFormat Javascript action.
end;

type TPDFFileSpec = record
   Buffer:      PAnsiChar; // Buffer of an embedded file
   BufSize:     Cardinal;  // Buffer size in bytes.
   Compressed:  LongBool;  // Should be false if Decompress was true in the GetEmbeddedFile() call, otherwise usually true.
                           // DynaPDF decompresses Flate encoded streams only. Other filters can occur but this is very unusual.
   ColItem:     Pointer;   // If != NULL the embedded file contains a collection item with user defined data. This entry
                           // can occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further
                           // information.
   Name:        PAnsiChar; // Name of the file specification in the name tree.
   NameUnicode: LongBool;  // Is Name in Unicode format?
   FileName:    PAnsiChar; // File name as 7 bit ASCII string.
   IsURL:       LongBool;  // If true, FileName contains a URL.
   UF:          PAnsiChar; // PDF 1.7. Same as FileName but Unicode is allowed.
   UFUnicode:   LongBool;  // Is UF in Unicode format?
   Desc:        PAnsiChar; // Description
   DescUnicode: LongBool;  // Is Desc in Unicode format?
   FileSize:    Cardinal;  // Size of the decompressed stream or zero if not known. Note: this is either the Size key of
                           // the Params dictionary if present or the DL key in the file stream. Whether this value is
                           // correct depends on the file creator! The parameter is definitely correct if the file was
                           // decompressed.
   MIMEType:    PAnsiChar; // MIME media type name as defined in Internet RFC 2046.
   CreateDate:  PAnsiChar; // Creation date as string. See help file "The standard date format".
   ModDate:     PAnsiChar; // Modification date as string. See help file "The standard date format".
   CheckSum:    PAnsiChar; // 16 byte MD5 digest. Note that this is a binary string. It is exactly 16 bytes long if set!
end;

type TPDFFileSpecEx = record
   StructSize:     Cardinal;  // Must be set to sizeof(TPDFFileSpecEx).
   AFRelationship: PAnsiChar; // PDF 2.0
   ColItem:        Pointer;   // If != NULL the embedded file contains a collection item with user defined data. This entry can
                              // occur in PDF Collections only (PDF 1.7). See "PDF Collections" in the help file for further information.
   DescriptionA:   PAnsiChar; // Optional description string.
   DescriptionW:   PWideChar; // Optional description string.
   DOS:            PAnsiChar; // Optional DOS file name.
   EmbFileNode:    IEFN;      // GetEmbeddedFileNode().
   FileName:       PAnsiChar; // File name as 7 bit ASCII string.
   FileNameIsURL:  LongBool;  // If true, FileName contains a URL.
   ID1:            PByte;     // Optional file ID. Meaningful only if FileName points to a PDF file.
   ID1Len:         Cardinal;  // String length in bytes.
   ID2:            PByte;     // Optional file ID. Meaningful only if FileName points to a PDF file.
   ID2Len:         Cardinal;  // String length in bytes.
   IsVolatile:     LongBool;  // If true, the file changes frequently with time.
   Mac:            PAnsiChar; // Optional Mac file name.
   Unix:           PAnsiChar; // Optional Unix file name.
   RelFileNode:    IRFN;      // Optional related files array. -> GetRelFileNode().
   Thumb:          PIMG;      // Optional thumb nail image. -> GetImageObjEx().
   UFileNameA:     PAnsiChar; // PDF 1.7. Same as FileName but Unicode is allowed.
   UFileNameW:     PWideChar; // Either the Ansi or Unicode string is set but never both.
end;

type TPDFEmbFileNode = record
   StructSize: Cardinal;     // Must be set to sizeof(TPDFEmbFileNode).
   Name:       PAnsiChar;    // UTF-8 encoded name. This key contains usually a 7 bit ASCII string.
   EF:         TPDFFileSpec; // Embedded file.
   NextNode:   IEFN;         // Next node if any.
end;

type TPDFFontInfo = record
   StructSize:      Cardinal;         // Must be set to sizeof(TPDFFontInfo).
   Ascent:          Single;           // Ascent (optional).
   AvgWidth:        Single;           // Average character width (optional).
   BaseEncoding:    TBaseEncoding;    // Valid only if HaveEncoding is true.
   BaseFont:        PAnsiChar;        // PostScript Name or Family Name.
   CapHeight:       Single;           // Cap height (optional).
   CharSet:         PAnsiChar;        // The charset describes which glyphs are present in the font.
   CharSetSize:     Cardinal;         // Length of the CharSet in bytes.
   CIDOrdering:     PAnsiChar;        // SystemInfo -> A string that uniquely names the character collection within the specified registry.
   CIDRegistry:     PAnsiChar;        // SystemInfo -> Issuer of the character collection.
   CIDSet:          PByte;            // CID fonts only. This is a table of bits indexed by CIDs.
   CIDSetSize:      Cardinal;         // Length of the CIDSet in bytes.
   CIDSupplement:   Cardinal;         // CIDSystemInfo -> The supllement number of the character collection.
   CIDToGIDMap:     PByte;            // Allowed for embedded TrueType based CID fonts only.
   CIDToGIDMapSize: Cardinal;         // Length of the stream in bytes.
   CMapBuf:         PByte;            // Only available if the CMap was embedded.
   CMapBufSize:     Cardinal;         // Buffer size in bytes.
   CMapName:        PAnsiChar;        // CID fonts only (this is the encoding if the CMap is not embedded).
   Descent:         Single;           // Descent (optional).
   Encoding:        PWideChar;        // Unicode mapping 0..255 -> not available for CID fonts.
   FirstChar:       Cardinal;         // First char (simple fonts only).
   Flags:           TPDFFontFlags;    // The font flags describe various characteristics of the font. See help file for further information.
   FontBBox:        TBBox;            // This is the size of the largest glyph in this font. The bounding box is important for text selection.
   FontBuffer:      PByte;            // The font buffer is present if the font was embedded or if it was loaded from a file buffer.
   FontBufSize:     Cardinal;         // Font file size in bytes.
   FontFamilyA:     PAnsiChar;        // Optional Font Family (Family Name, always available for system fonts).
   FontFamilyW:     PWideChar;        // Optional Font Family (either the Ansi or Unicode string is set, but never both).
   FontFilePathA:   PAnsiChar;        // Only available for system fonts.
   FontFilePathW:   PWideChar;        // Either the Ansi or Unicode path is set, but never both.
   FontFileType:    TFontFileSubtype; // See description in the help file for further information.
   FontName:        PAnsiChar;        // Font name (should be the same as BaseFont).
   FontStretch:     PAnsiChar;        // Optional -> UltraCondensed, ExtraCondensed, Condensed, and so on.
   FontType:        TFontType;        // If ftType0 the font is a CID font. The Encoding is not set in this case.
   FontWeight:      Single;           // Font weight (optional).
   FullNameA:       PAnsiChar;        // System fonts only.
   FullNameW:       PWideChar;        // System fonts only (either the Ansi or Unicode string is set, but never both).
   HaveEncoding:    LongBool;         // If true, BaseEncoding was set from the font's encoding.
   HorzWidths:      PSingle;          // Horizontal glyph widths -> 0..HorzWidthsCount -1.
   HorzWidthsCount: Cardinal;         // Number of horizontal widths in the array.
   Imported:        LongBool;         // If true, the font was imported from an external PDF file.
   ItalicAngle:     Single;           // Italic angle
   Lang:            PAnsiChar;        // Optional language code defined by BCP 47.
   LastChar:        Cardinal;         // Last char (simple fonts only).
   Leading:         Single;           // Recommended leading (optional).
   Length1:         Cardinal;         // Length of the clear text portion of a Type1 font.
   Length2:         Cardinal;         // Length of the encrypted portion of a Type1 font program (Type1 fonts only).
   Length3:         Cardinal;         // Length of the fixed-content portion of a Type1 font program or zero if not present.
   MaxWidth:        Single;           // Maximum glyph width (optional).
   Metadata:        PByte;            // Optional XMP stream that contains metadata about the font file.
   MetadataSize:    Cardinal;         // Buffer size in bytes.
   MisWidth:        Single;           // Missing width (default = 0.0).
   Panose:          PByte;            // CID fonts only -> Optional 12 bytes long Panose string as described in Microsofts TrueType 1.0 Font Files Technical Specification.
   PostScriptNameA: PAnsiChar;        // System fonts only.
   PostScriptNameW: PWideChar;        // System fonts only (either the Ansi or Unicode string is set, but never both).
   SpaceWidth:      Single;           // Space width in font units. A default value is set if the font contains no space character.
   StemH:           Single;           // The thickness, measured vertically, of the dominant horizontal stems of glyphs in the font.
   StemV:           Single;           // The thickness, measured horizontally, of the dominant vertical stems of glyphs in the font.
   ToUnicode:       PByte;            // Only available for imported fonts. This is an embedded CMap that translates PDF strings to Unicode.
   ToUnicodeSize:   Cardinal;         // Buffer size in bytes.
   VertDefPos:      TFltPoint;        // Default vertical displacement vector.
   VertWidths:      PCIDMetric;       // Vertical glyph widths -> 0..VertWidthsCount -1.
   VertWidthsCount: Cardinal;         // Number of vertical widths in the array.
   WMode:           Cardinal;         // Writing Mode -> 0 == Horizontal, 1 == Vertical.
   XHeight:         Single;           // The height of lowercase letters (like the letter x), measured from the baseline, in fonts that have Latin characters.
   BaseFontW:       PWideChar;        // BaseFont converted to Unicode. This the font name that Adobe's Acrobat displays in the font overview.
end;

type TPDFFontMetrics = record
   StructSize:     Cardinal; // Must be set to sizeof(TPDFFontMetrics)
   Ascent:         Single;   // Ascent (usWinAscent)
   AvgWidth:       Single;   // Average character width
   CapHeight:      Single;   // Cap height
   DefWidth:       Single;   // Default width
   Descent:        Single;   // sTypoDescender of the OS/2 table of TrueType and OpenType fonts
   FirstChar:      Cardinal; // First char
   FixedWidth:     Single;   // Width of all glyphs in a fixed pitch font
   FontStyle:      TFStyle;  // Font style with which the font was loaded
   FontBBox:       TBBox;    // Font's bounding box
   IsFixedPitch:   LongBool; // Is this a fixed pitch font?
   IsSymbolFont:   LongBool; // Is this is a symbolic font?
   IsStdFont:      LongBool; // Is this is a standard font?
   ItalicAngle:    Single;   // Italic angle of italic fonts
   LastChar:       Cardinal; // Last char
   LineGap:        Single;   // sTypoLineGap of the OS/2 table of TrueType and OpenType fonts
   MacStyle:       Cardinal; // macOS style flags
   RealStyle:      TFStyle;  // This is the real style of the font (bold and italic styles are maybe emulated)
   StemV:          Single;   // Width of vertical stems
   StrikeoutPos:   Single;   // Strikeout position
   StrikeoutWidth: Single;   // Width of the strikeout line
   UnderlinePos:   Single;   // Underline position
   UnderlineWidth: Single;   // Width of the underline
   UnicodeRange1:  Cardinal; // Bitset -> TUnicodeRange1
   UnicodeRange2:  Cardinal; // Bitset -> TUnicodeRange2
   UnicodeRange3:  Cardinal; // Bitset -> TUnicodeRange3
   UnicodeRange4:  Cardinal; // Bitset -> TUnicodeRange4
   Weight:         Cardinal; // Font weight
   WidthClass:     Cardinal; // Width class of the font
   WinDescent:     Single;   // usWinDescent of the OS/2 table of TrueType and OpenType fonts
   WinStyle:       Cardinal; // fsSelection of the OS/2 table of TrueType and OpenType fonts
   XHeight:        Single;   // X-height
   TypoAscender:   Single;   // sTypoAscender of the OS/2 table of TrueType and OpenType fonts
   TypoLeading:    Single;   // Typographic leading or line height of the font. This is TypoAscender - Descent + LineGap.
                             // If typographic metrics are not available then TypoAscender is set to Ascent.
end;

type TPDFFontObj = record
   Ascent:        Single;        // Ascent
   BaseFont:      PAnsiChar;     // PostScript Name or Family Name
   CapHeight:     Single;        // Cap height
   Descent:       Single;        // Descent
   Encoding:      PWideChar;     // Unicode mapping 0..255 -> not set if a CID font is selected
   FirstChar:     Cardinal;      // First char
   Flags:         TPDFFontFlags; // Font flags -> font descriptor
   FontFamily:    PAnsiChar;     // Optional Font Family (Family Name)
   FontFamilyUni: LongBool;      // If true, FontFamily is in Unicode format -> make a type cast to PWideChar in this case
   FontName:      PAnsiChar;     // Font name -> font descriptor
   FontType:      TFontType;     // If ftType0 the font is a CID font. The Encoding is not set in this case.
   ItalicAngle:   Single;        // Italic angle
   LastChar:      Cardinal;      // Last char
   SpaceWidth:    Single;        // Space width in font units. A default value is set if the font contains no space character.
   Widths:        PSingle;       // Glyph widths -> 0..WidthsCount -1
   WidthsCount:   Cardinal;      // Number of widths in the array
   XHeight:       Single;        // x-height
   DefWidth:      Single;        // Default character widths -> CID fonts only
   FontFile:      PAnsiChar;     // Font file buffer -> only imported fonts are returned.
   Length1:       Cardinal;      // Length of the clear text portion of the Type1 font, or the length of the entire font program if FontType != ffType1.
   Length2:       Cardinal;      // Length of the encrypted portion of the Type1 font program (Type1 fonts only).
   Length3:       Cardinal;      // Length of the fixed-content portion of the Type1 font program or zero if not present.
   FontFileType:  TFontFileSubtype; // See description in the help file for further information.
end;

type TPDFGoToAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TPDFGoToAction).
   DestPage:       Integer;     // Destination page (the first page is denoted by 1).
   DestPos:        PSingle;     // Destination position -> Array of 4 floating point values if set.
   DestType:       TDestType;   // Destination type.
   // GoToR (GoTo Remote) actions only:
   DestFile:       IFSR;        // see GetFileSpec().
   DestNameA:      PAnsiChar;   // Optional named destination that shall be loaded when opening the file.
   DestNameW:      PWideChar;   // Either the Ansi or Unicode string is set but never both.
   NewWindow:      Integer;     // Meaningful only if the destination file points to a PDF file.
                                // -1 = viewer default, 0 = false, 1 = true.
   NextAction:     Integer;     // -1 or next action handle to be executed if any.
   NextActionType: TActionType; // Only set if NextAction is >= 0.
end;

// Every header or footer string supports the following numbering and date formats:
//
// Bates numbering syntax: Bates#0..10#1..2147483648 (case-sensitive). The number sign (#) is part of the syntax and is required.
// No spaces before or after the number sign or before and after the keyword 'Bates' are allowed.
//
// <<Bates#6#1>>  // Six digits, numbering starts at 1 -> 000001.
// <<Bates#10#5>> // Ten digits, numbering starts at 5 -> 0000000005.
// << Bates#6#1>> // Wrong, no space is not allowed.
// <<bates#6#1>>  // Wrong, the correct keyword name is 'Bates'.
//
// Date formats:
//
// The date format supports three characters: m = month, d = day, y = year.
// Each character can be repeated to define the number of digits, e.g. mm, or yyyy are examples. Allowed delimiters are '.', '-', and '/'.
//
// <<yy/mm/d>>    // Ok
// <<mm-d/yy>>    // Unusual but ok
// <y/mm/d>>      // Wrong, missing '<' and a valid year format has either 2 or 4 digits
// <<yyyy:mm:dd>> // Wrong, invalid delimiter
//
// Page numbering:
//
// The page number format has two reserved characters:
//
// // 0..2147483648 -> The number is added to the current page index (the first page is denoted by 0). Default = 1.
// // 'n'           -> Is replaced by the number of pages. The 'n' must be surrounded by an escape character, otherwise it is treated as text.
// // Escapes chars -> ' ', ')', '(', '[', ']', '<', '>', '/', '%', '{', '}'.
//
// Arbitrary text can occur before, between, and after a reserved character.
// Example results on the first page if the document has 57 pages:
//
// <<28>>              // Ok, 28 is added to the page index.                              -> "28"
// << Page 4 of n>>    // Ok                                                              -> " Page 4 of 57"
// <<1/n>>             // Ok                                                              -> "1/57"
// <<0/n>>             // Ok, but unusual. The first page number would be 0 in this case. -> "0/57"
// <<-5 of n>>         // Ok, note that the minus is treated as text!                     -> "-5 of 57"
// <<Page1 ofn pages>> // Ok, but the 'n' is treated as text.                             -> "Page1 ofn pages"
// <<Page 5 of n>>     // Ok, 5 is added to the page index.                               -> "Page 5 of 57"
// <<Seite 1 von n>>   // Ok, note which 'n' is replaced by the number of pages.          -> "Seite 1 von 57"
// <<Page>>            // Wrong, nothing to do. Treated as text.                          -> "<<Page>>"

type TPDFHdrFtr = record
   Color:      Cardinal;       // Text color.
   CS:         TExtColorSpace; // Color space -> default = esInitSpace.
   CSHandle:   Integer;        // Optional color space handle if CS is set to a non-device space.

   Codepage:   TCodepage;      // The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   Embed:      LongBool;       // If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   Reserved1:  Integer;        // Placeholder to avoid alignment issues
   FontA:      PAnsiChar;      // Optional font name.
   FontW:      PWideChar;      // Optional font name.
   FontSize:   Single;         // Font size -> considered only if a font name is set.
   Reserved2:  Integer;        // Placeholder to avoid alignment issues
   FontType:   PAnsiChar;      // Optional font type ("TrueType", "OpenType", or "Type1").

   IsHeader:   LongBool;       // If true, the record is treated as header.
   Position:   TTextAlign;     // Valid values are taLeft, taCenter, and taRight.
   ShiftX:     Single;         // Positive values move the text to the right, negative to the left.
   ShiftY:     Single;         // Positive values move the text up or down depending on the used coordinate system (top down or bottom up). Negative values move the text into the opposite direction.
   TextA:      PAnsiChar;      // The text that should be output. Either the Ansi or Unicode string must be set.
   TextW:      PWideChar;      // The text that should be output. Either the Ansi or Unicode string must be set.
   TextLen:    Cardinal;       // Text length in characters.
   Reserved3:  Integer;        // Placeholder to avoid alignment issues
end;

type PPDFHdrFtr = ^TPDFHdrFtr;

type TPDFHdrFtrFlags = Integer;
   const hffDefault    = 3;   // Output header / footer text on even and odd pages
   const hffEvenPages  = 1;   // Output header / footer text on even pages
   const hffOddPages   = 2;   // Output header / footer text on odd pages
   const hffFixedPrint = 4;   // Can be set by LoadHeaderFooterSettings(). Not considered yet.
   const hffLoadUTF8   = 8;   // Load all strings in UTF-8 format.
   const hffShrink     = 16;  // Can be set by LoadHeaderFooterSettings(). Not considered yet.
   const hffLoadBatesN = 32;  // If set, LoadHeaderFooterSetting() loads bates numbers only.
   const hffLoadHF     = 64;  // If set, LoadHeaderFooterSetting() loads header / footer settings only.
   const hffSearchRun  = 128; // Scan the file for available header / footer types. See LoadHeaderFooterSetting() for further information.

type TPDFHeaderFooter = record
   StructSize:      Cardinal;        // Must be initialized to sizeof(TPDFHeaderFooter).
   FirstPage:       Integer;         // In/Out -> The first output page.
   Flags:           TPDFHdrFtrFlags; // In/Out -> Additional processing flags.
   InitColor:       Cardinal;        // In/Out -> Initial text color.
   InitCS:          TExtColorSpace;  // In/Out -> Initial color space -> default = esDeviceGray.
   InitCSHandle:    Integer;         // In     -> Optional color space handle if InitCS is set to a non-device space.
   InitDate:        PAnsiChar;       // Out    -> Initial date format.
   InitCodepage:    TCodepage;       // In/Out -> The code page that should be used to load the font. It is always set to cpUnicode if the property was loaded with LoadHeaderFooterSettings().
   InitEmbed:       LongBool;        // In     -> If true, the font will be embedded. Always set to false if the property was loaded with LoadHeaderFooterSettings().
   InitFontA:       PAnsiChar;       // In/Out -> Optional font name.
   InitFontW:       PWideChar;       // In/Out -> Optional font name.
   InitFontSize:    Single;          // In/Out -> Optional font size. Considered only if a font name is set.
   Reserved:        Integer;         // Placeholder to avoid alignment issues
   InitFontType:    PAnsiChar;       // Out    -> Optional font type ("TrueType", "OpenType", or "Type1").
   InitPageFormatA: PAnsiChar;       // Out    -> Initial page format string.
   InitPageFormatW: PWideChar;       // Out    -> Initial page format string.
   LastPage:        Integer;         // In/Out -> The last output page.
   Margin:          TFltRect;        // In/Out -> Margin to output the header/footer text.
end;

type TPDFHideAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TPDFHideAction).
   Fields:         PIFLD;       // Array of field pointers -> GetFieldEx2().
   FieldsCount:    Cardinal;    // Number of fields in the array.
   Hide:           LongBool;    // A flag indicating whether to hide or show the fields in the array.
   NextAction:     Integer;     // -1 or next action handle to be executed if any.
   NextActionType: TActionType; // Only set if NextAction is >= 0.
end;

type TPDFImage = record
   Buffer:           PAnsiChar;         // Each scanline is aligned to a full byte.
   BufSize:          Cardinal;          // The size of the image buffer in bytes.
   Filter:           TDecodeFilter;     // Required decode filter if the image is compressed.
                                        // Possible values are dfDCTDecode (JPEG), dfJPXDecode (JPEG2000),
                                        // and dfJBIG2Decode. Other filters are always removed by DynaPDF since
                                        // a conversion to a native file format is then always required.
   OrgFilter:        TDecodeFilter;     // The image was compressed with this filter in the PDF file. This info is
                                        // useful to determine which compression filter should be used when creating
                                        // a new image file from the image buffer.
   JBIG2Globals:     PAnsiChar;         // Optional global page 0 segment (dfJBIG2Decode filter only).
   JBIG2GlobalsSize: Cardinal;          // The size of the bit stream in bytes.
   BitsPerPixel:     Cardinal;          // Bit depth of the image buffer. Possible values are 1, 2, 4, 8, 24, 32, and 64.
   ColorSpace:       TExtColorSpace;    // The color space refers either to the image buffer or to the color table if set.
                                        // Note that 1 bit images can occur with and without a color table.
   NumComponents:    Cardinal;          // The number of components stored in the image buffer.
   MinIsWhite:       LongBool;          // If true, the colors of 1 bit images are reversed.
   IColorSpaceObj:   Pointer;           // Pointer to the original color space.
   ColorTable:       PAnsiChar;         // The color table or NULL.
   ColorCount:       Cardinal;          // The number of colors in the color table.
   Width:            Cardinal;          // Image width in pixel.
   Height:           Cardinal;          // Image height in pixel.
   ScanLineLength:   Cardinal;          // The length of a scanline in bytes.
   InlineImage:      LongBool;          // If true, the image is an inline image.
   Interpolate:      LongBool;          // If true, image interpolation should be performed.
   Transparent:      LongBool;          // The meaning is different depending on the bit depth and whether a color
                                        // table is available. If the image is a 1 bit image and if no color table is available,
                                        // black pixels must be drawn with the current fill color.
                                        // If the image contains a color table ColorMask contains the range of indexes
                                        // in the form min/max index which appears transparent. If no color table is
                                        // present ColorMask contains the transparent ranges in the form min/max for
                                        // each component.
   ColorMask:        PAnsiChar;         // The array contains ranges in the form min/max (2 values per component) for each
                                        // component before decoding.
   IMaskImage:       PIMG;              // If set, a 1 bit image is used as a transparency mask. Call GetImageObjEx() to decode the image.
   ISoftMask:        PIMG;              // If set, a grayscale image is used as alpha channel. Call GetImageObjEx() to decode the image.
   Decode:           PSingle;           // If set, samples must be decoded. The array contains 2 * NumComponents values.
                                        // The decode array is never set if the image is returned decompressed since
                                        // it is already applied during decompression.
   Intent:           TRenderingIntent;  // Default riNone.
   SMaskInData:      Cardinal;          // JPXDecode only, PDF_MAX_INT if not set. See PDF Reference for further information.
   OC:               Pointer;           // Pointer of an OCG or OCMD if set. -> See GetOCHandle()
   Metadata:         PAnsiChar;         // Optional XML Metadata stream.
   MetadataSize:     Cardinal;          // Length of Metadata in bytes.
   ObjectPtr:        Pointer;           // Internal pointer to the image class.
   ResolutionX:      Single;            // Image resolution on the x-axis.
   ResolutionY:      Single;            // Image resolution on the y-axis.
   Measure:          IMSR;              // Optional measure dictionary -> GetMeasureObj().
   PtData:           IPTD;              // Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
   {
      The parallelogram into which the image is drawn.
      p1--p2
      |   |
      p4--p3
   }
   DestX1:           Single;            // 0
   DestY1:           Single;            // 0
   DestX2:           Single;            // 1
   DestY2:           Single;            // 0
   DestX3:           Single;            // 1
   DestY3:           Single;            // 1
   DestX4:           Single;            // 0
   DestY4:           Single;            // 1
   DestWidth:        Single;            // Destination width (can be negative).
   DestHeight:       Single;            // Destination height (can be negative).
   FillColor:        Cardinal;          // The current fill color. An image mask is drawn with the current fill color.
   FillColorSpace:   TPDFColorSpace;    // The color space in which FillColor is defined.
   // Reserved fields for future extensions
   Reserved1:        Cardinal;
   Reserved2:        Cardinal;
   Reserved3:        Cardinal;
   Reserved4:        Cardinal;
end;

type TPDFImportDataAction = record
   StructSize:     Cardinal;       // Must be set to sizeof(TPDFImportDataAction).
   Data:           TPDFFileSpecEx; // The data or file to be loaded.
   NextAction:     Integer;        // -1 or next action handle to be executed if any
   NextActionType: TActionType;    // Only set if NextAction is >= 0.
end;

type TPDFJavaScriptAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TPDFJavaScriptAction).
   ScriptA:        PAnsiChar;   // The script.
   ScriptW:        PWideChar;   // Either the Ansi or Unicode string is set but never both.
   ScriptLen:      Cardinal;    // Script length in characters, not bytes!
   NextAction:     Integer;     // -1 or next action handle to be executed if any
   NextActionType: TActionType; // Only set if NextAction is >= 0.
end;

type TPDFLaunchAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TPDFLaunchAction).
   AppName:        PAnsiChar;   // Optional. The name of the application that should be launched.
   DefDir:         PAnsiChar;   // Optional default directory.
   DestFile:       IFSR;        // see GetFileSpec().
   NewWindow:      Integer;     // -1 = viewer default, 0 = false, 1 = true.
   NextAction:     Integer;     // -1 or next action handle to be executed if any
   NextActionType: TActionType; // Only set if NextAction is >= 0.
   Operation:      PAnsiChar;   // Optional string specifying the operation to perform (open or print).
   Parameter:      PAnsiChar;   // Optional parameter string that shall be passed to the application (AppName).
end;

type TPDFMeasure = record
   StructSize:    Cardinal;    // Must be set to sizeof(TPDFMeasure)
   IsRectilinear: LongBool; // If true, the members of the rectilinear measure dictionary are set. The geospatial members otherwise.
   // --- Rectilinear measure dictionary ---
   Angles:        PINFM;      // Number format array to measure angles -> GetNumberFormatObj()
   AnglesCount:   Cardinal;   // Number of objects in the array.
   Area:          PINFM;      // Number format array to measure areas -> GetNumberFormatObj()
   AreaCount:     Cardinal;   // Number of objects in the array.
   CXY:           Single;     // Optional, meaningful only when Y is present.
   Distance:      PINFM;      // Number format array to measure distances -> GetNumberFormatObj()
   DistanceCount: Cardinal;   // Number of objects in the array.
   OriginX:       Single;     // Origin of the measurement coordinate system.
   OriginY:       Single;     // Origin of the measurement coordinate system.
   RA:            PAnsiChar;  // A text string expressing the scale ratio of the drawing.
   RW:            PWideChar;  // A text string expressing the scale ratio of the drawing.
   Slope:         PINFM;      // Number format array for measurement of the slope of a line -> GetNumberFormatObj()
   SlopeCount:    Cardinal;   // Number of objects in the array.
   X:             PINFM;      // Number format array for measurement of change along the x-axis and, if Y is not present, along the y-axis as well.
   XCount:        Cardinal;   // Number of objects in the array.
   Y:             PINFM;      // Number format array for measurement of change along the y-axis.
   YCount:        Cardinal;   // Number of objects in the array.

   // --- Geospatial measure dictionary ---
   Bounds:        PSingle;    // Array of numbers taken pairwise to describe the bounds for which geospatial transforms are valid.
   BoundCount:    Cardinal;   // Number of values in the array. Should be a multiple of two.

   // The DCS coordinate system is optional.
   DCS_IsSet:     LongBool;   // If true, the DCS members are set.
   DCS_Projected: LongBool;   // If true, the DCS values contains a pojected coordinate system.
   DCS_EPSG:      Integer;    // Optional, either EPSG or WKT is set.
   DCS_WKT:       PAnsiChar;  // Optional ASCII string

   // The GCS coordinate system is required and should be present.
   GCS_Projected: LongBool;   // If true, the GCS values contains a pojected coordinate system.
   GCS_EPSG:      Integer;    // Optional, either EPSG or WKT is set.
   GCS_WKT:       PAnsiChar;  // Optional ASCII string

   GPTS:          PSingle;    // Required, an array of numbers that shall be taken pairwise, defining points in geographic space as degrees of latitude and longitude, respectively.
   GPTSCount:     Cardinal;   // Number of values in the array.
   LPTS:          PSingle;    // Optional, an array of numbers that shall be taken pairwise to define points in a 2D unit square.
   LPTSCount:     Cardinal;   // Number of values in the array.

   PDU1:          PAnsiChar;  // Optional preferred linear display units.
   PDU2:          PAnsiChar;  // Optional preferred area display units.
   PDU3:          PAnsiChar;  // Optional preferred angular display units.
end;

type TPDFMovieAction = record
   StructSize: Cardinal;        // Must be set to sizeof(TPDFMovieAction).
   Annot:          Integer;     // Optional. The movie annotation handle identifying the movie that shall be played.
   FWPosition:     Array[0..1] of Single;   // FWPosition
   FWScale:        Array[0..1] of Cardinal; // FWScale
   Mode:           PAnsiChar;   // Mode
   NextAction:     Integer;     // -1 or next action handle to be executed if any
   NextActionType: TActionType; // Only set if NextAction is >= 0.
   Operation:      PAnsiChar;   // Operation
   Rate:           Single;      // Rate
   ShowControls:   LongBool;    // ShowControls
   Synchronous:    LongBool;    // Synchronous
   TitleA:         PAnsiChar;   // The title of a movie annotation that shall be played. Either Annot or Title should be set, but not both.
   TitleW:         PWideChar;   // Either the Ansi or Unicode string is set at time.
   Volume:         Single;      // Volume
end;

type TPDFNamedAction = record
   StructSize:     Cardinal;     // Must be set to sizeof(TPDFNamedAction).
   Name:           PAnsiChar;    // Only set if AType == naUserDefined.
   NewWindow:      Integer;      // -1 = viewer default, 0 = false, 1 = true.
   NextAction:     Integer;      // -1 or next action handle to be executed if any
   NextActionType: TActionType;  // Only set if NextAction is >= 0.
   AType:          TNamedAction; // Known pre-defined actions.
end;

type TPDFNamedDest = record
   StructSize:  Cardinal;  // Must be initialized to sizeof(TPDFNamedDestination)
   NameA:       PAnsiChar;
   NameW:       PWideChar;
   NameLen:     Cardinal;
   DestFileA:   PAnsiChar;
   DestFileW:   PWideChar;
   DestFileLen: Cardinal;
   SDestPage:   Integer;
   DestPos:     TPDFRect;
   DestType:    TDestType;
end;

type TPDFNumberFormat = record
   StructSize: Cardinal;
   C:          Single;
   D:          Integer;
   F:          TMeasureNumFormat;
   FD:         LongBool;
   O:          TMeasureLblPos;
   PSA:        PAnsiChar;
   PSW:        PWideChar;
   RDA:        PAnsiChar;
   RDW:        PWideChar;
   RTA:        PAnsiChar;
   RTW:        PWideChar;
   SSA:        PAnsiChar;
   SSW:        PWideChar;
   UA:         PAnsiChar;
   UW:         PWideChar;
end;

type TPDFObjActions = record
   StructSize: Cardinal;    // Must be set to sizeof(TPDFObjActions).
   Action:     Integer;     // Action handle or -1 if not set.
   ActionType: TActionType; // The type of the action if Action >= 0.
   Events:     IEVT;        // Additional events if any -> GetObjEvent().
end;

type TPDFObjEvent = record
   StructSize: Cardinal;    // Must be set to sizeof(TPDFObjEvent).
   Action:     Integer;     // Action to be executed.
   ActionType: TActionType; // The type of the action.
   Event:      TObjEvent;   // The event when the action should be executed.
   Next:       IEVT;        // Pointer to the next event if any.
end;

// The operator is encoded in TI32Point. Decode the type as follows:
//  op = (p.x & (1<<30) | ((p.y & (1<<30) << 1);
type TPDFShapeOP = Cardinal;
const
   spMoveTo    = 0;
   spLineTo    = 1;
   spRectangle = 2;
   spEllipse   = 3;
   spCoordMask = $FFFFFFFF and not (1 shl 30);

type TPDFPathType = Cardinal;
const
   ptQuadPoint  = $00000000; // Default (TI32QuadPoint).
   ptEllipse    = $00000001; // Start and end point.
   ptPath       = $00000002; // Array of TI32Point. The operator type (TPDFShapeOP) is encoded in bit 30 of x and y.
   ptPolygon    = $00000003; // Array of TI32Point. The path must be closed.
   ptPolyLine   = $00000004; // Array of TI32Point.
   ptRectangle  = $00000005; // Start and end point.
   ptFillPath   = $00010000; // Fill path
   ptStrokePath = $00020000; // Stroke path
   ptTypeMask   = $0000FFFF;

type TPDFOCG = record
   StructSize:    Cardinal;          // Must be set to sizeof(TPDFOCG)
   Handle:        Cardinal;          // Handle or array index
   Intent:        TOCGIntent;        // Bitmask -> Contains also the visivility state
   NameA:         PAnsiChar;         // Layer name
   NameW:         PWideChar;         // Layer name
   HaveContUsage: LongBool;          // If true, the layer contains a Content Usage dictionary. -> GetOCGContUsage().
   // The following two members can only be set if HaveContUsage is true.
   AppEvents:     TOCAppEvent;       // Bitmask -> If non-zero, the layer is included in one or more app events which control the layer state.
   Categories:    TOCGUsageCategory; // Bitmask -> The Usage Categories which control the layer state.
end;

type TPDFOCGContUsage = record
   StructSize:     Cardinal;       // Must be set to sizeof(TPDFOCGContUsage)
   ExportState:    Cardinal;       // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   InfoCreatorA:   PAnsiChar;      // CreatorInfo -> The application that created the group
   InfoCreatorW:   PWideChar;      // CreatorInfo -> The application that created the group
   InfoSubtype:    PAnsiChar;      // CreatorInfo -> A name defining the type of content, e.g. Artwork, Technical etc.
   LanguageA:      PAnsiChar;      // A language code as described at SetLanguage() in the help file.
   LanguageW:      PWideChar;      // A language code as described at SetLanguage() in the help file.
   LangPreferred:  Cardinal;       // 0 = Off, 1 = On, PDF_MAX_INT = not set. The preffered state if there is a partial but no exact match of the language identifier.
   PageElement:    TOCPageElement; // If the group contains a pagination artefact.
   PrintState:     Cardinal;       // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   PrintSubtype:   PAnsiChar;      // The type of content that is controlled by the OCG, e.g. Trapping, PrintersMarks or Watermark.
   UserNamesCount: Cardinal;       // The user names (if any) can be accessed with GetOCGUsageUserName().
   UserType:       TOCUserType;    // The user for whom this optional content group is primarily intendet.
   ViewState:      Cardinal;       // 0 = Off, 1 = On, PDF_MAX_INT = not set.
   ZoomMin:        Single;         // The minimum magnification factor at which the group should be On. -1 if not set.
   ZoomMax:        Single;         // The maximum magnification factor at which the group should be On. -1 if not set.
end;

type TPDFOCUINode = record
   StructSize:  Cardinal;  // Must be set to sizeof(TPDFOCUINode)
   LabelA:      PAnsiChar; // Optional label.
   LabelW:      PWideChar; // Either the Ansi or Unicode string is set at time but never both.
   LabelLength: Cardinal;  // Length in characters.
   NextChild:   IOCN;      // If set, the next child node that must be loaded.
   NewNode:     LongBool;  // If true, a new child node must be created.
   OCG:         Integer;   // Optional OCG handle. -1 if not set -> GetOCG().
end;
type PPDFOCUINode = ^TPDFOCUINode;

type TPDFOCLayerConfig = record
   StructSize: Cardinal;   // Must be set to sizeof(TPDFOCLayerConfig)
   Intent:     TOCGIntent; // Possible values oiDesign, oiView, or oiAll.
   IsDefault:  LongBool;   // If true, this is the default configuration.
   NameA:      PAnsiChar;  // Optional configuration name. The default config has usually no name but all others should have one.
   NameW:      PWideChar;  // Either the Ansi or Unicode string is set at time but never both.
   NameLen:    Cardinal;   // Length in characters.
end;

type TPDFOutputIntent = record
   StructSize:         Cardinal;
   Buffer:             PAnsiChar;
   BufSize:            Cardinal;
   InfoA:              PAnsiChar;
   InfoW:              PWideChar;
   NumComponents:      Cardinal;
   OutputConditionA:   PAnsiChar;
   OutputConditionW:   PWideChar;
   OutputConditionIDA: PAnsiChar;
   OutputConditionIDW: PWideChar;
   RegistryNameA:      PAnsiChar;
   RegistryNameW:      PWideChar;
   SubType:            PAnsiChar;
end;

type TPDFPageLabel = record
   StartRange: Cardinal;           // Number of the first page in the range. If no further label follows, the last
                                   // page in the range is pdfGetPageCount(). The first page is denoted by 1.
   Format:       TPageLabelFormat; // Number format to be used.
   FirstPageNum: Integer;          // First page number to be displayed in the page label. Subsequent pages are
                                   // numbered sequentially from this value.
   Prefix:       PAnsiChar;        // Optional prefix
   PrefixLen:    Cardinal;         // Length of the prefix in characters
   PrefixUni:    LongBool;         // If true, the prefix is a Unicode string
end;

type TPDFPrintParams = record
   StructSize:   Cardinal;           // Must be set to sizeof(TPDFPrintParams).
   Compress:     LongBool;           // Meaningful only for image output. If true, compressed images are send to the printer.
   FilterGray:   TCompressionFilter; // Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   FilterColor:  TCompressionFilter; // Meaningful only for image output. Supported filters on Windows: cfFlate and cfJPEG.
   JPEGQuality:  Cardinal;           // JPEG Quality in percent. Zero == Default == 60.
   MaxRes:       Cardinal;           // Maximum print resolution. Zero == Default == 600 DPI.
   IgnoreDCSize: LongBool;           // If true, PageSize is used to calculate the output format.
   PageSize:     TIntRect;           // Considered only, if IgnoreDCSize is set to true.
end;

type PPDFPrintParams = ^TPDFPrintParams;

type TPDFRawImage = record
   StructSize:       Cardinal;       // Must be set to sizeof(TPDFRawImage)
   Buffer:           Pointer;        // Image buffer
   BufSize:          Cardinal;       // Buffer size
   BitsPerComponent: Cardinal;       // Bits per component
   NumComponents:    Cardinal;       // Number of components (max 32)
   CS:               TExtColorSpace; // Image color space
   CSHandle:         Integer;        // Color space handle (non-device color spaces only)
   Stride:           Integer;        // Scanline length in bytes -> If negative, the image is defined in bottom up coordinates, top down otherwise
   HasAlpha:         LongBool;       // If true, the last component is an alpha channel
   IsBGR:            LongBool;       // esDeviceRGB only -> If true, the image components are defined in BGR format instead of RGB
   MinIsWhite:       LongBool;       // 1 bit images only -> If true, zero pixel values must be treated as white instead of black
   Width:            Cardinal;       // Width in pixels (must be greater zero)
   Height:           Cardinal;       // Height in pixels (must be greater zero)
end;

type TPDFRelFileNode = record
   StructSize: Cardinal;     // Must be set to sizeof(TPDFRelFileNode).
   NameA:      PAnsiChar;    // Name of this file spcification.
   NameW:      PWideChar;    // Either the Ansi or Unicode name is set but never both.
   EF:         TPDFFileSpec; // Embedded file.
   NextNode:   IRFN;         // Next node if any.
end;

type TPDFResetFormAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TResetFormAction)
   Fields:         PIFLD;       // Array of field pointers -> GetFieldEx2().
   FieldsCount:    Cardinal;    // Number of fields in the array.
   Include:        LongBool;    // If true, the fields in the Fields array must be reset. If false, these fields must be excluded.
   NextAction:     Integer;     // -1 or next action handle to be executed if any.
   NextActionType: TActionType; // Only set if NextAction is >= 0.
end;

type TPDFSigDict = record
   StructSize:     Cardinal;  // Must be set to sizeof(TPDFSigDict).
   ByteRange:      PCardinal; // ByteRange -> Byte offset followed by the corresponding length.
                              // The byte ranges are required to create the digest. The values
                              // are returned as is. So, you must check whether the offsets and
                              // length values are valid. There are normally at least two ranges.
                              // Overlapping ranges are not allowed! Any error breaks processing
                              // and the signature should be considered as invalid.
   ByteRangeCount: Cardinal;  // The number of Offset / Length pairs. ByteRange contains 2 * ByteRangeCount values!
   Cert:           PAnsiChar; // X.509 Certificate when SubFilter is adbe.x509.rsa_sha1.
   CertLen:        Cardinal;  // Length in bytes
   Changes:        PCardinal; // If set, an array of three integers that specify changes to the
                              // document that have been made between the previous signature and
                              // this signature in this order: the number of pages altered, the
                              // number of fields altered, and the number of fields filled in.
   ContactInfoA:   PAnsiChar; // Optional contact info string, e.g. an email address
   ContactInfoW:   PWideChar; // Optional contact info string, e.g. an email address
   Contents:       PAnsiChar; // The signature. This is either a DER encoded PKCS#1 binary data
                              // object or a DER-encoded PKCS#7 binary data object depending on
                              // the used SubFilter.
   ContentsSize:   Cardinal;  // Length in bytes.
   Filter:         PAnsiChar; // The name of the security handler, usually Adobe.PPKLite.
   LocationA:      PAnsiChar; // Optional location of the signer
   LocationW:      PWideChar; // Optional location of the signer
   SignTime:       PAnsiChar; // Date/Time string
   NameA:          PAnsiChar; // Optional signers name
   NameW:          PWideChar; // Optional signers name
   PropAuthTime:   Cardinal;  // Optional -> The number of seconds since the signer was last authenticated.
   PropAuthType:   PAnsiChar; // Optional -> The method that shall be used to authenticate the signer.
                              // Valid values are PIN, Password, and Fingerprint.
   ReasonA:        PAnsiChar; // Optional reason
   ReasonW:        PWideChar; // Optional reason
   Revision:       Integer;   // Optional -> The version of the signature handler that was used to create
                              // the signature.
   SubFilter:      PAnsiChar; // A name that describes the encoding of the signature value. Should be
                              // adbe.x509.rsa_sha1, adbe.pkcs7.detached, or adbe.pkcs7.sha1.
   Version:        Integer;   // The version of the signature dictionary format.
end;

type TPDFSigParms = record
   StructSize:       Cardinal;  // Must be set to sizeof(TSignParms)
   PKCS7ObjLen:      Cardinal;  // The maximum length of the signed PKCS#7 object
   HashType:         THashType; // If set to htDetached, the bytes ranges of the PDF file will be returned.
   Range1:           PByte;     // Out -> Contains either the hash or the first byte range to create a detached signature
   Range1Len:        Cardinal;  // Out -> Length of the buffer
   Range2:           PByte;     // Out -> Set only if HashType == htDetached
   Range2Len:        Cardinal;  // Out -> Length of the buffer
   ContactInfoA:     PAnsiChar; // Optional, e.g. an email address
   ContactInfoW:     PWideChar; // Optional, e.g. an email address
   LocationA:        PAnsiChar; // Optional location of the signer
   LocationW:        PWideChar; // Optional location of the signer
   ReasonA:          PAnsiChar; // Optional reason why the file was signed
   ReasonW:          PWideChar; // Optional reason why the file was signed
   SignerA:          PAnsiChar; // Optional, the issuer of the certificate takes precedence
   SignerW:          PWideChar; // Optional, the issuer of the certificate takes precedence
   Encrypt:          LongBool;  // If true, the file will be encrypted
   // These members will be ignored if Encrypt is set to false
   OpenPwd:          PAnsiChar; // Open password
   OwnerPwd:         PAnsiChar; // Owner password to change the security settings
   KeyLen:           TKeyLen;   // Key length to be used to encrypt the file
   Restrict:         TRestrictions; // What should be restricted?
   // Currently Windows only
   Certificate:      Pointer;   // Handle of a certificate (PCCERT_CONTEXT), returned by CertFindCertificateInStore(), for example.
                                // If this paramteter is set, PKCS7ObjLen will be ignored and the file will be signed with this certificate.
   TimeStampServer:  PWideChar; // Optional URL of a time stamp server
   TimeOut:          Cardinal;  // Optional number of millisecond
end;

type TPDFStack = record
   ctm:          TCTM;               // Pre-multiplied global transformation matrix
   tm:           TCTM;               // Pre-multiplied text transformation matrix
   x:            Double;             // Unused -> always 0.0
   y:            Double;             // Unused -> always 0.0
   FontSize:     Double;             // Font size
   CharSP:       Double;             // Character spacing
   WordSP:       Double;             // Word spacing
   HScale:       Double;             // Horizontal text scaling
   TextRise:     Double;             // Text rise -> always 0.0 because it is already included in the text transformation matrix
   Leading:      Double;             // Leading
   LineWidth:    Double;             // Line width
   DrawMode:     TDrawMode;          // Text draw mode
   FillCS:       TPDFColorSpace;     // Fill color space
   StrokeCS:     TPDFColorSpace;     // Stroke color space
   FillColor:    Cardinal;           // Fill color
   StrokeColor:  Cardinal;           // Stroke color
   BaseObject:   Pointer;            // Internal
   CIDFont:      LongBool;           // If true, ReplacePageText() can only be used to delete a string
   Text:         PAnsiChar;          // Raw text without kerning space
   TextLen:      Cardinal;           // Raw text length
   RawKern:      TTextRecordAPtr;    // Raw kerning array
   Kerning:      TTextRecordWPtr;    // Already translated Unicode kerning array
   KerningCount: Cardinal;           // Number of kerning records
   TextWidth:    Single;             // The width of the entire text record measured in text space
   IFont:        Pointer;            // Font object used to print the string -> fntGetFont() can be used to return the font properties
   Embedded:     LongBool;           // If true, the font is embedded
   SpaceWidth:   Single;             // Measured in text space
   {
      These members can be modified after the structure has been initialized with InitStack().
      If the destination color space should be DeviceCMYK initialize FillColor and StrokeColor
      with PDF_CMYK(0,0,0,255); which represents black.
   }
   ConvColors:   LongBool;           // If set to true (default), all colors are converted to the specified destination color space
   DestSpace:    TPDFColorSpace;     // Destination color space -> default == csDeviceRGB

   // This member can be used in combination with ReplacePageText() to preserve a number
   // of kerning records from deletion. All records above this value will be deleted.
   // Take a look into the file examples/util/pdf_edit_text.cpp to determine how this member
   // can be used.
   DeleteKerningAt: Cardinal;
   FontFlags:       Cardinal;    // PDF font flags
   // ------------------------------- Reserved fields -------------------------------
   Reserved1:  Integer;
   Reserved2:  Integer;
   Reserved3:  Integer;
   Reserved4:  Integer;
   Reserved5:  Integer;
   Reserved6:  Integer;
   Reserved7:  Integer;
   Reserved8:  Integer;
   Reserved9:  Integer;
   Reserved10: Integer;
   Reserved11: Integer;
   ContentPtr: Pointer;
end;

type TPDFSubmitFormAction = record
   StructSize:     Cardinal;     // Must be set to sizeof(TSubmitFormAction)
   CharSet:        PAnsiChar;    // Optional charset in which the form should be submitted.
   Fields:         PIFLD;        // Array of field pointers -> GetFieldEx2().
   FieldsCount:    Cardinal;     // Number of fields in the array.
   Flags:          TSubmitFlags; // Various flags, see CreateSubmitAction() for further information.
   URL:            PAnsiChar;    // The URL of the script at the Web server that will process the submission.
   NextAction:     Integer;      // -1 or next action handle to be executed if any.
   NextActionType: TActionType;  // Only set if NextAction is >= 0.
end;

type TUnicodeRange1 = Cardinal;
   const urBasicLatin                  = 1 shl 0;  // 0000-007F
   const urLatin1Supplement            = 1 shl 1;  // 0080-00FF
   const urLatinExtendedA              = 1 shl 2;  // 0100-017F
   const urLatinExtendedB              = 1 shl 3;  // 0180-024F
   const urIPAExtensions               = 1 shl 4;  // 0250-02AF, 1D00-1D7F, 1D80-1DBF
   const urSpacingModifierLetters      = 1 shl 5;  // 02B0-02FF, A700-A71F
   const urCombiningDiacriticalMarks   = 1 shl 6;  // 0300-036F, 1DC0-1DFF
   const urGreekandCoptic              = 1 shl 7;  // 0370-03FF
   const urCoptic                      = 1 shl 8;  // 2C80-2CFF
   const urCyrillic                    = 1 shl 9;  // 0400-04FF, 0500-052F, 2DE0-2DFF, A640-A69F
   const urArmenian                    = 1 shl 10; // 0530-058F
   const urHebrew                      = 1 shl 11; // 0590-05FF
   const urVai                         = 1 shl 12; // A500-A63F
   const urArabic                      = 1 shl 13; // 0600-06FF, 0750-077F
   const urNKo                         = 1 shl 14; // 07C0-07FF
   const urDevanagari                  = 1 shl 15; // 0900-097F
   const urBengali                     = 1 shl 16; // 0980-09FF
   const urGurmukhi                    = 1 shl 17; // 0A00-0A7F
   const urGujarati                    = 1 shl 18; // 0A80-0AFF
   const urOriya                       = 1 shl 19; // 0B00-0B7F
   const urTamil                       = 1 shl 20; // 0B80-0BFF
   const urTelugu                      = 1 shl 21; // 0C00-0C7F
   const urKannada                     = 1 shl 22; // 0C80-0CFF
   const urMalayalam                   = 1 shl 23; // 0D00-0D7F
   const urThai                        = 1 shl 24; // 0E00-0E7F
   const urLao                         = 1 shl 25; // 0E80-0EFF
   const urGeorgian                    = 1 shl 26; // 10A0-10FF, 2D00-2D2F
   const urBalinese                    = 1 shl 27; // 1B00-1B7F
   const urHangulJamo                  = 1 shl 28; // 1100-11FF
   const urLatinExtendedAdditional     = 1 shl 29; // 1E00-1EFF, 2C60-2C7F, A720-A7FF
   const urGreekExtended               = 1 shl 30; // 1F00-1FFF
   const urGeneralPunctuation          = 1 shl 31; // 2000-206F, 2E00-2E7F

type TUnicodeRange2 = Cardinal;
   const urSuperscriptsAndSubscripts   = 1 shl 0;  // 2070-209F
   const urCurrencySymbols             = 1 shl 1;  // 20A0-20CF
   const urCombDiacritMarksForSymbols  = 1 shl 2;  // 20D0-20FF
   const urLetterlikeSymbols           = 1 shl 3;  // 2100-214F
   const urNumberForms                 = 1 shl 4;  // 2150-218F
   const urArrows                      = 1 shl 5;  // 2190-21FF, 27F0-27FF, 2900-297F, 2B00-2BFF
   const urMathematicalOperators       = 1 shl 6;  // 2200-22FF, 2A00-2AFF, 27C0-27EF, 2980-29FF
   const urMiscellaneousTechnical      = 1 shl 7;  // 2300-23FF
   const urControlPictures             = 1 shl 8;  // 2400-243F
   const urOpticalCharacterRecognition = 1 shl 9;  // 2440-245F
   const urEnclosedAlphanumerics       = 1 shl 10; // 2460-24FF
   const urBoxDrawing                  = 1 shl 11; // 2500-257F
   const urBlockElements               = 1 shl 12; // 2580-259F
   const urGeometricShapes             = 1 shl 13; // 25A0-25FF
   const urMiscellaneousSymbols        = 1 shl 14; // 2600-26FF
   const urDingbats                    = 1 shl 15; // 2700-27BF
   const urCJKSymbolsAndPunctuation    = 1 shl 16; // 3000-303F
   const urHiragana                    = 1 shl 17; // 3040-309F
   const urKatakana                    = 1 shl 18; // 30A0-30FF, 31F0-31FF
   const urBopomofo                    = 1 shl 19; // 3100-312F, 31A0-31BF
   const urHangulCompatibilityJamo     = 1 shl 20; // 3130-318F
   const urPhagsPa                     = 1 shl 21; // A840-A87F
   const urEnclosedCJKLettersAndMonths = 1 shl 22; // 3200-32FF
   const urCJKCompatibility            = 1 shl 23; // 3300-33FF
   const urHangulSyllables             = 1 shl 24; // AC00-D7AF
   const urNonPlane0                   = 1 shl 25; // D800-DFFF
   const urPhoenician                  = 1 shl 26; // 10900-1091F
   const urCJKUnifiedIdeographs        = 1 shl 27; // 4E00-9FFF, 2E80-2EFF, 2F00-2FDF, 2FF0-2FFF, 3400-4DBF, 20000-2A6DF, 3190-319F
   const urPrivateUseAreaPlane0        = 1 shl 28; // E000-F8FF
   const urCJKStrokes                  = 1 shl 29; // 31C0-31EF, F900-FAFF, 2F800-2FA1F
   const urAlphabeticPresentationForms = 1 shl 30; // FB00-FB4F
   const urArabicPresentationFormsA    = 1 shl 31; // FB50-FDFF

type TUnicodeRange3 = Cardinal;
   const urCombiningHalfMarks          = 1 shl 0;  // FE20-FE2F
   const urVerticalForms               = 1 shl 1;  // FE10-FE1F, FE30-FE4F
   const urSmallFormVariants           = 1 shl 2;  // FE50-FE6F
   const urArabicPresentationFormsB    = 1 shl 3;  // FE70-FEFF
   const urHalfwidthAndFullwidthForms  = 1 shl 4;  // FF00-FFEF
   const urSpecials                    = 1 shl 5;  // FFF0-FFFF
   const urTibetan                     = 1 shl 6;  // 0F00-0FFF
   const urSyriac                      = 1 shl 7;  // 0700-074F
   const urThaana                      = 1 shl 8;  // 0780-07BF
   const urSinhala                     = 1 shl 9;  // 0D80-0DFF
   const urMyanmar                     = 1 shl 10; // 1000-109F
   const urEthiopic                    = 1 shl 11; // 1200-137F, 1380-139F, 2D80-2DDF
   const urCherokee                    = 1 shl 12; // 13A0-13FF
   const urUnifiedCanadianAboriginal   = 1 shl 13; // 1400-167F
   const urOgham                       = 1 shl 14; // 1680-169F
   const urRunic                       = 1 shl 15; // 16A0-16FF
   const urKhmer                       = 1 shl 16; // 1780-17FF, 19E0-19FF
   const urMongolian                   = 1 shl 17; // 1800-18AF
   const urBraillePatterns             = 1 shl 18; // 2800-28FF
   const urYiSyllables                 = 1 shl 19; // A000-A48F, A490-A4CF
   const urTagalog                     = 1 shl 20; // 1700-171F, 1720-173F, 1740-175F, 1760-177F
   const urOldItalic                   = 1 shl 21; // 10300-1032F
   const urGothic                      = 1 shl 22; // 10330-1034F
   const urDeseret                     = 1 shl 23; // 10400-1044F
   const urMusicalSymbols              = 1 shl 24; // 1D000-1D0FF, 1D100-1D1FF, 1D200-1D24F
   const urMathematicalAlphanumeric    = 1 shl 25; // 1D400-1D7FF
   const urPrivateUsePlane15           = 1 shl 26; // FF000-FFFFD, 100000-10FFFD
   const urVariationSelectors          = 1 shl 27; // FE00-FE0F, E0100-E01EF
   const urTags                        = 1 shl 28; // E0000-E007F
   const urLimbu                       = 1 shl 29; // 1900-194F
   const urTaiLe                       = 1 shl 30; // 1950-197F
   const urNewTaiLue                   = 1 shl 31; // 1980-19DF

type TUnicodeRange4 = Cardinal;
   const urBuginese                    = 1 shl 0;  // 1A00-1A1F
   const urGlagolitic                  = 1 shl 1;  // 2C00-2C5F
   const urTifinagh                    = 1 shl 2;  // 2D30-2D7F
   const urYijingHexagramSymbols       = 1 shl 3;  // 4DC0-4DFF
   const urSylotiNagri                 = 1 shl 4;  // A800-A82F
   const urLinearBSyllabary            = 1 shl 5;  // 10000-1007F, 10080-100FF, 10100-1013F
   const urAncientGreekNumbers         = 1 shl 6;  // 10140-1018F
   const urUgaritic                    = 1 shl 7;  // 10380-1039F
   const urOldPersian                  = 1 shl 8;  // 103A0-103DF
   const urShavian                     = 1 shl 9;  // 10450-1047F
   const urOsmanya                     = 1 shl 10; // 10480-104AF
   const urCypriotSyllabary            = 1 shl 11; // 10800-1083F
   const urKharoshthi                  = 1 shl 12; // 10A00-10A5F
   const urTaiXuanJingSymbols          = 1 shl 13; // 1D300-1D35F
   const urCuneiform                   = 1 shl 14; // 12000-123FF, 12400-1247F
   const urCountingRodNumerals         = 1 shl 15; // 1D360-1D37F
   const urSundanese                   = 1 shl 16; // 1B80-1BBF
   const urLepcha                      = 1 shl 17; // 1C00-1C4F
   const urOlChiki                     = 1 shl 18; // 1C50-1C7F
   const urSaurashtra                  = 1 shl 19; // A880-A8DF
   const urKayahLi                     = 1 shl 20; // A900-A92F
   const urRejang                      = 1 shl 21; // A930-A95F
   const urCham                        = 1 shl 22; // AA00-AA5F
   const urAncientSymbols              = 1 shl 23; // 10190-101CF
   const urPhaistosDisc                = 1 shl 24; // 101D0-101FF
   const urCarian                      = 1 shl 25; // 102A0-102DF, 10280-1029F, 10920-1093F
   const urDominoTiles                 = 1 shl 26; // 1F030-1F09F, 1F000-1F02F

type TPDFSysFont = record
   StructSize:      Cardinal;           // Must be set to sizeof(TPDFSysFont)
   BaseType:        TFontBaseType;      // Font type
   CIDOrdering:     PAnsiChar;          // OpenType CID fonts only
   CIDRegistry:     PAnsiChar;          // OpenType CID fonts only
   CIDSupplement:   Cardinal;           // OpenType CID fonts only
   DataOffset:      Cardinal;           // Data offset
   FamilyName:      PWideChar;          // Family name
   FilePathA:       PAnsiChar;          // Font file path
   FilePathW:       PWideChar;          // Font file path
   FileSize:        Cardinal;           // File size in bytes
   Flags:           TEnumFontProcFlags; // Bitmask
   FullName:        PWideChar;          // Full name
   Length1:         Cardinal;           // Length of the clear text portion of a Type1 font
   Length2:         Cardinal;           // Length of the eexec encrypted binary portion of a Type1 font
   PostScriptNameA: PAnsiChar;          // Postscript mame
   PostScriptNameW: PWideChar;          // Postscript mame
   Index:           Integer;            // Zero based font index if the font is stored in a TrueType collection
   IsFixedPitch:    LongBool;           // If true, the font is a fixed pitch font. A proprtional font otherwise.
   Style:           TFStyle;            // Font style
   UnicodeRange1:   TUnicodeRange1;     // Bitmask
   UnicodeRange2:   TUnicodeRange2;     // Bitmask
   UnicodeRange3:   TUnicodeRange3;     // Bitmask
   UnicodeRange4:   TUnicodeRange4;     // Bitmask
end;

type TPDFXFAStream = record
   StructSize: Cardinal; // Must be set to sizeof(TPDFXFAStream)
   Buffer:     PByte;
   BufSize:    Cardinal;
   NameA:      PAnsiChar;
   NameW:      PWideChar;
end;

type PPDFXFAStream = ^TPDFXFAStream;

type TPDFVersion = Integer;
   const pvPDF_1_0           = 0;
   const pvPDF_1_1           = 1;
   const pvPDF_1_2           = 2;
   const pvPDF_1_3           = 3;
   const pvPDF_1_4           = 4;
   const pvPDF_1_5           = 5;
   const pvPDF_1_6           = 6;
   const pvPDF_1_7           = 7;
   const pvPDF_2_0           = 8;  // PDF 2.0
   const pvReserved          = 9;  // Reserved for future use
   const pvPDFX1a_2001       = 10; // PDF/X-1a:2001
   const pvPDFX1a_2003       = 11; // PDF/X-1a:2002
   const pvPDFX3_2002        = 12; // PDF/X-3:2002
   const pvPDFX3_2003        = 13; // PDF/X-3:2003
   const pvPDFA_2005         = 14; // PDF/A-1b 2005
   const pvPDFX_4            = 15; // PDF/X-4
   const pvPDFA_1a           = 16; // PDF/A 1a 2005
   const pvPDFA_2a           = 17; // PDF/A 2a
   const pvPDFA_2b           = 18; // PDF/A 2b
   const pvPDFA_2u           = 19; // PDF/A 2u
   const pvPDFA_3a           = 20; // PDF/A 3a
   const pvPDFA_3b           = 21; // PDF/A 3b
   const pvPDFA_3u           = 22; // PDF/A 3u
   // The following constants are flags which can be combined with pvPDFA_3a, pvPDFA_3b, and pvPDFA_3u.
   // If used stand alone PDF/A 3b with the correspondig ZUGFeRD metadata will be created.
   const pvZUGFeRD_Basic     = $00010000;
   const pvZUGFeRD_Comfort   = $00020000;
   const pvZUGFeRD_Extended  = $00040000;
   const pvZUGFeRD_Mask      = pvZUGFeRD_Basic or pvZUGFeRD_Comfort or pvZUGFeRD_Extended;
   // Factur-X and ZUGFeRD 2.0 profiles. The usage is identically as the older ZUGFeRD 1.0 flags. That means if
   // used alone; a PDF/A 3b file will be created.
   {* --------------------------------------------------------------------------------------------------------------
    *                                             Factur-X vs. ZUGFeRD 2.0
    *---------------------------------------------------------------------------------------------------------------
    * ZUGFeRD 2.0 and Factur-X are almost identically defined. Both standards support the very same profiles. To create
    * a ZUGFeRD 2.0 invoice with the profile Basic WL, for example, set the PDF version as follows:
    *
    *    pdfSetPDFVersion(pdf, TPDFVersion(pvFacturX_Basic_WL | pvZUGFeRD2_Flag));
    *
    * The PDF version is set to PDF/A 3b in the above example.
    *
    * If you want to create the very same invoice but as PDF/A 3u file, for example, then set also the whished output PDF
    * version:
    *
    *    pdfSetPDFVersion(pdf, TPDFVersion(pvPDFA_3u | pvFacturX_Basic_WL | pvZUGFeRD2_Flag));
    *
   *}
   const pvFacturX_Minimum   = $00080000; // Minimum profile
   const pvFacturX_Basic     = $00100000; // Basic profile
   const pvFacturX_Basic_WL  = $00200000; // Basic WL profile
   const pvFacturX_Comfort   = $00400000; // EN 16931 profile
   const pvFacturX_Extended  = $00800000; // Extended profile
   const pvFacturX_XRechnung = $02000000; // German XRechnung profile. The XML invoice must be named xrechnung.xml.
   const pvFacturX_Mask      = pvFacturX_Minimum or pvFacturX_Basic or pvFacturX_Basic_WL or pvFacturX_Comfort or pvFacturX_Extended;
   const pvZUGFeRD2_Flag     = $01000000; // If set, the PDF version will be set to the corresponding ZUGFeRD2 profile.
   const pvPDFX5g            = 23;        // PDF/X-5g
   const pvPDFX5n            = 24;        // PDF/X-5n
   const pvPDFX5pg           = 25;        // PDF/X-5pg
   const pvPDFX6             = 26;        // PDF/X 6
   const pvPDFX6n            = 27;        // PDF/X 6n
   const pvPDFX6p            = 28;        // PDF/X 6p
   const pvPDFUA1            = 29;        // PDF/UA-1 (ISO 14289-1)
   const pvPDFX4p            = 30;        // PDF/X-4p
   const pvPDFVT1            = $10000000; // PDF/VT 1 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   const pvPDFVT2            = $04000000; // PDF/VT 2 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   const pvPDFVT3            = $08000000; // PDF/VT 3 flag. This is just a flag because PDF/VT requires always a PDF/X base version.
   const pvPDFVTMask         = pvPDFVT1 Or pvPDFVT2 Or pvPDFVT3;
   const pvPDFUAFlag         = $20000000; // PDF/UA flag. Can be used in addition with other standards. File metadata will contain PDF/A and PDF/UA entries.
   const pvPDFA_4            = 31;         // PDF/A 4
   const pvPDFA_4e           = 32;         // PDF/A 4e allows 3D contents in rich media annotations.
   const pvPDFA_4f           = 33;         // PDF/A 4f allows file attach annotations.

// We have different members for PDF/A, PDF/E, PDF/VT, and PDF/X because multiple versions can be set at time.
// PDF/VT files require also PDF/X version information.
type TPDFVersionInfo = record
   StructSize:      Cardinal;  // Must be set to sizeof(TPDFVersionInfo)
   Major:           Cardinal;  // PDF major version, e.g. 1
   Minor:           Cardinal;  // PDF minor version, e.g. 7
   MainVer:         PAnsiChar; // Set only if the file conforms to a specific PDF standard, e.g. "PDF/X 1a:2003", "PDF/A 3b", and so on.
   SubVer:          PAnsiChar; // e.g. "ZUGFeRD 2.0", "Factur-X", and so on.
   // PDF/A
   PDFAConformance: PAnsiChar; // e.g. A, B, E, F, U, or UA.
   PDFAVersion:     Cardinal;  // If greater zero, this is a PDF/A file.
   // PDF/E
   PDFEVersion:     PAnsiChar; // e.g. PDF/E-1
   // PDF/VT
   PDFVTModDate:    PAnsiChar; // Modification date, e.g. 2016-05-07T15:42:23+01:00
   PDFVTVersion:    PAnsiChar; // e.g. PDF/VT-2
   // PDF/X
   PDFXConformance: PAnsiChar; // e.g. PDF/X-1a:2001 or PDF/X-1a:2003. PDF/X 3 and above do not set this key anymore.
   PDFXVersion:     PAnsiChar; // e.g. PDF/X-1:2001, PDF/X-1:2003, and so on.
   // ZUGFeRD, Factur-X, XRechnung
   FXConfLevel:     PAnsiChar; // ConformanceLevel
   FXDocName:       PAnsiChar; // DocumentFileName
   FXDocType:       PAnsiChar; // DocumentType
   FXVersion:       PAnsiChar; // Version
   VersionConst:    Integer;   // If >= 0 this is the TPDFVersion constant as integer. If the version is not supported by DynaPDF, this member is set to -1.
end;

type PPDFVersionInfo = ^TPDFVersionInfo;

type TRectL = record
   Left: Integer;
   Top: Integer;
   Right: Integer;
   Bottom: Integer;
end;

type PRectL = ^TRectL;

type TShadingType =
(
   stUnknown, // cannot occur -> internal use
   stFunctionBased,
   stAxial,
   stRadial,
   stFreeFormGouraud,
   stLatticeFormGouraud,
   stCoonsPatch,
   stTensorProduct
);

type TSpoolConvFlags = Integer;
const
   spcDefault            = 0;
   spcIgnorePaperFormat  = 1; // If set, the current page format is used as is for the entire spool file.
   spcDontAddMargins     = 2; // If set, the page format is calculated from the EMF files as is. The current page format is not used to calculate
                              // margins which are maybe required. Note that the parameters LeftMargin and TopMargin will still be considered.
   spcLoadSpoolFontsOnly = 4; // If set, only embedded fonts will be loaded. The EMF files must be converted with the flag mfIgnoreEmbFonts in this
                              // case. This flag can be useful if you want to use your own code to convert the EMF files of the spool file.
   spcFlushPages         = 8; // If set, the function writes every finish page directly to the output file to reduce the memory usage. This flag
                              // is meaningful only if the PDF file is not created in memory. Note also that it is not possible to access already
                              // flushed pages again with EditPage().

type TStdPattern =
(
   spHorizontal, { ----- }
   spVertical,   { ||||| }
   spRDiagonal,  { \\\\\ }
   spLDiagonal,  { ///// }
   spCross,      { +++++ }
   spDiaCross    { xxxxx }
);

type TPDFURIAction = record
   StructSize:     Cardinal;    // Must be set to sizeof(TPDFURIAction)
   BaseURL:        PAnsiChar;   // Optional, if defined in the Catalog object.
   IsMap:          LongBool;    // A flag specifying whether to track the mouse position when the URI is resolved: e.g. http://test.org?50,70.
   URI:            PAnsiChar;   // Uniform Resource Identifier.
   NextAction:     Integer;     // -1 or next action handle to be executed if any.
   NextActionType: TActionType; // Only set if NextAction is >= 0.
end;

type TPDFViewport = record
   StructSize: Cardinal;  // Must be set to sizeof(TPDFViewport)
   BBox:       TFltRect;  // Bounding box
   Measure:    IMSR;      // Optional -> GetMeasureObj()
   NameA:      PAnsiChar; // Optional name
   NameW:      PWideChar; // Optional name
   PtData:     IPTD;      // Pointer of a Point Data dictionary. The value can be accessed with GetPtDataObj().
end;
   
type TViewerPreference = Integer;
const
  vpUseNone             = $00000000;
  vpHideToolBar         = $00000001;
  vpHideMenuBar         = $00000002;
  vpHideWindowUI        = $00000004;
  vpFitWindow           = $00000008;
  vpCenterWindow        = $00000010;
  vpDisplayDocTitle     = $00000020;
  vpNonFullScrPageMode  = $00000040;
  vpDirection           = $00000080;
  vpViewArea            = $00000100;
  vpViewClip            = $00000200;
  vpPrintArea           = $00000400;
  vpPrintClip           = $00000800;

type TViewPrefAddVal = Integer;
const
  avNone                   = $00000000;
  avNonFullScrUseNone      = $00000001;
  avNonFullScrUseOutlines  = $00000002;
  avNonFullScrUseThumbs    = $00000004;
  avNonFullScrUseOC        = $00000400; // PDF 1.6
  avDirectionL2R           = $00000008;
  avDirectionR2L           = $00000010;
  avViewPrintArtBox        = $00000020;
  avViewPrintBleedBox      = $00000040;
  avViewPrintCropBox       = $00000080;
  avViewPrintMediaBox      = $00000100;
  avViewPrintTrimBox       = $00000200;

  // Use these masks to determine which value is defined.
  AV_NON_FULL_SRC_MASK     = $00000005;
  AV_DIRECTION_MASK        = $00000018;
  AV_VIEW_PRINT_MASK       = $000003E0;

{ --------------------------------------------- Callback functions ---------------------------------------------- }

// Data is always a user defined pointer which is passed unchanged to the callback funtion
type TErrorProc      = function(const Data: Pointer; ErrCode: Integer; const ErrMessage: PAnsiChar; ErrType: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEnumFontProc   = function(const Data: Pointer; const FamilyName: PWideChar; const PostScriptName: PAnsiChar; Style: TFStyle): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEnumFontProc2  = function(const Data, PDFFont: Pointer; FontType: TFontType; const BaseFont, FontName: PAnsiChar; Embedded, IsFormFont: LongBool; Flags: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEnumFontProcEx = function(const Data: Pointer; const FamilyName: PWideChar; const PostScriptName: PAnsiChar; Style: TFStyle; BaseType: TFontBaseType; Flags: TEnumFontProcFlags; const FilePath: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

{ ---------------------------------- Callback functions for CheckConformance() ---------------------------------- }

type TOnFontNotFoundProc  = function(const Data, PDFFont: Pointer; const FontName: PAnsiChar; Style: TFStyle; StdFontIndex: Integer; IsSymbolFont: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TOnReplaceICCProfile = function(const Data: Pointer; ProfileType: TICCProfileType; ColorSpace: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

{ ------------------------------------- Callback function for WriteFText ---------------------------------------- }

// The TOnPageBreakProc function is called by WriteFText when the rectangle was filled with text, or when a
// manual page break was inserted to the text and more text is available for output.
// You must set the text rectangle with SetTextRect to continue the text on a new position or simply call
// EndPage() and then Append() or EditPage() to continue the text on an arbitrary new page. You can make some
// changes inside the callback function such as setting another font, font color or other thinks.

// When the callback function returns a value greater or equal zero, processing continues on the new
// position or page that was set inside the callback function.

// The text alignment can also be changed with the following return values:

const NEW_ALIGN_LEFT    = 1;
const NEW_ALIGN_RIGHT   = 2;
const NEW_ALIGN_CENTER  = 3;
const NEW_ALIGN_JUSTIFY = 4;

type TOnPageBreakProc = function(const Data: Pointer; LastPosX, LastPosY: Double; PageBreak: LongBool): Integer; cdecl;

// When the return value of the callback function is one of the values listed above, then the alignment will
// be changed before the remaining text is processed. A return value of 0 determines that processing should
// be continued without changing the alignment.

// A negative return value breaks processing and WriteFText returns emmidiatly with a warning. Note that
// processing stops entirely when warnings should be handled as fatal errors (see SetErrorMode() in the help
// file for further information).

// NOTE: The coordinate system is always set to bottom up when the callback function is called, independent
// of the coordinate system that was set before WriteFText was called. WriteFText restores the coordinate system
// and all other temporarily changed variables when the function is leaved. The last text text position is
// also returned in bottom up coordinates. LastPosY is the position of the last baseline.

// You can change the coordinate system inside the callback function when needed, DynaPDF checks the state
// before processing continues.

{ ------------------------------- Callback functions to control a progress bar ---------------------------------- }

type TProgType = Integer;
const ptImportPage  = 0;
const ptWritePage   = 1;
const ptPrintPage   = 2;
const ptConvertPage = 3;

// TInitProgress is called before TProgress is called the first time
type TInitProgressProc = function(const Data: Pointer; ProgType: TProgType; MaxCount: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TProgressProc     = function(const Data: Pointer; ActivePage: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

{------------------------------------------- Parser Interface ---------------------------------------------------}

type TApplyPattern        = function(const Data, PDFObject: Pointer; PatternType: TPatternType; const Pattern: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBeginLayer          = function(const Data, IOCG: Pointer; InVisible: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBeginMarkedContent  = function(const Data: Pointer; ContentType: TPDFMarkedContentType; Invisible: LongBool; const Dict: PAnsiChar; DictLen: Cardinal; ObjPtr: IPDFObj): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBeginPattern        = function(const Data: Pointer; Fill: LongBool; Handle: Integer; PatternType: TPatternType; var BBox: TPDFRect; Matrix: PCTM; XStep, YStep: PDouble): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBeginTemplate       = function(const Data, PDFObject: Pointer; Handle: Integer; var BBox: TPDFRect; Matrix: PCTM): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBezierTo1           = function(const Data, PDFObject: Pointer; x1, y1, x3, y3: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBezierTo2           = function(const Data, PDFObject: Pointer; x2, y2, x3, y3: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TBezierTo3           = function(const Data, PDFObject: Pointer; x1, y1, x2, y2, x3, y3: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TClipPath            = function(const Data, PDFObject: Pointer; EvenOdd: LongBool; Mode: TPathFillMode): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TClosePath           = function(const Data, PDFObject: Pointer; Mode: TPathFillMode): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TDrawShading         = function(const Data, PDFObject: Pointer; ShadType: TShadingType; const Shading: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEndLayer            = procedure(const Data, IOCG: Pointer; InVisible: LongBool); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEndMarkedContent    = procedure(const Data: Pointer; ContentType: TPDFMarkedContentType; Invisible: LongBool); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEndPattern          = procedure(const Data: Pointer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TEndTemplate         = procedure(const Data: Pointer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TInsertImage         = function(const Data: Pointer; var Image: TPDFImage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TLineTo              = function(const Data, PDFObject: Pointer; x, y: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TMoveTo              = function(const Data, PDFObject: Pointer; x, y: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TMulMatrix           = procedure(const Data, PDFObject: Pointer; var Matrix: TCTM); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TRectangle           = function(const Data, PDFObject: Pointer; x, y, w, h: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TRestoreGraphicState = function(const Data: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSaveGraphicState    = function(const Data: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetCharSpacing      = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetExtGState        = procedure(const Data, PDFObject: Pointer; var GS: TPDFExtGState2); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetFillColor        = procedure(const Data, PDFObject: Pointer; Color: PDouble; NumComps: Cardinal; CS: TExtColorSpace; const IColorSpace: Pointer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetFont             = procedure(const Data, PDFObject: Pointer; FontType: TFontType; Embedded: LongBool; const FontName: PAnsiChar; Style: TFStyle; FontSize: Double; const Font: PFNT); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetLeading          = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetLineCapStyle     = procedure(const Data, PDFObject: Pointer; Style: TLineCapStyle); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetLineDashPattern  = procedure(const Data, PDFObject: Pointer; Dash: PDouble; NumValues, Phase: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetLineDashPattern2 = procedure(const Data, PDFObject: Pointer; Dash: PSingle; NumValues: Cardinal; Phase: Single);
type TSetLineJoinStyle    = procedure(const Data, PDFObject: Pointer; Style: TLineJoinStyle); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetLineWidth        = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetMiterLimit       = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetStrokeColor      = procedure(const Data, PDFObject: Pointer; Color: PDouble; NumComps: Cardinal; CS: TExtColorSpace; const IColorSpace: Pointer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetTextDrawMode     = procedure(const Data, PDFObject: Pointer; Mode: TDrawMode); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetTextScale        = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TSetWordSpacing      = procedure(const Data, PDFObject: Pointer; Value: Double); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TShowTextArrayA      = function(const Data: Pointer; Obj: PAnsiChar; var Matrix: TCTM; const Source: TTextRecordAPtr; Count: Cardinal; Width: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};
type TShowTextArrayW      = function(const Data: Pointer; const Source: TTextRecordAPtr; var Matrix: TCTM; const Kerning: TTextRecordWPtr; Count: Cardinal; Width: Double; Decoded: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

// All callback functions are optional. Set unnecessary callback functions to nil.
type TPDFParseInterface = record
   ApplyPattern:        TApplyPattern;
   BeginPattern:        TBeginPattern;
   BeginTemplate:       TBeginTemplate;
   BezierTo1:           TBezierTo1;
   BezierTo2:           TBezierTo2;
   BezierTo3:           TBezierTo3;
   ClipPath:            TClipPath;
   ClosePath:           TClosePath;
   DrawShading:         TDrawShading;
   EndPattern:          TEndPattern;
   EndTemplate:         TEndTemplate;
   LineTo:              TLineTo;
   MoveTo:              TMoveTo;
   MulMatrix:           TMulMatrix;
   Rectangle:           TRectangle;
   RestoreGraphicState: TRestoreGraphicState;
   SaveGraphicState:    TSaveGraphicState;
   SetCharSpacing:      TSetCharSpacing;
   SetExtGState:        TSetExtGState;
   SetFillColor:        TSetFillColor;
   SetFont:             TSetFont;
   SetLeading:          TSetLeading;
   SetLineCapStyle:     TSetLineCapStyle;
   SetLineDashPattern:  TSetLineDashPattern;
   SetLineJoinStyle:    TSetLineJoinStyle;
   SetLineWidth:        TSetLineWidth;
   SetMiterLimit:       TSetMiterLimit;
   SetStrokeColor:      TSetStrokeColor;
   SetTextDrawMode:     TSetTextDrawMode;
   SetTextScale:        TSetTextScale;
   SetWordSpacing:      TSetWordSpacing;
   Reserved001:         Pointer; // The old callabck functions TShowTextA and TShowTextW are no longer defined
   Reserved002:         Pointer; // The old callabck functions TShowTextA and TShowTextW are no longer defined
   ShowTextArrayW:      TShowTextArrayW;
   InsertImage:         TInsertImage;
   ShowTextArrayA:      TShowTextArrayA;
   BeginLayer:          TBeginLayer;
   EndLayer:            TEndLayer;
   SetLineDashPattern2: TSetLineDashPattern2;
   BeginMarkedContent:  TBeginMarkedContent;
   EndMarkedContent:    TEndMarkedContent;
   { These variables must be initialized with nil! }
   Reserved01: Pointer;
   Reserved02: Pointer;
   Reserved03: Pointer;
   Reserved04: Pointer;
   Reserved05: Pointer;
   Reserved06: Pointer;
   Reserved07: Pointer;
   Reserved08: Pointer;
   Reserved09: Pointer;
   Reserved10: Pointer;
   Reserved11: Pointer;
   Reserved12: Pointer;
   Reserved13: Pointer;
   Reserved14: Pointer;
   Reserved15: Pointer;
   Reserved16: Pointer;
   Reserved17: Pointer;
   Reserved18: Pointer;
   Reserved19: Pointer;
   Reserved20: Pointer;
   Reserved21: Pointer;
   Reserved22: Pointer;
end;

{ ----------------------------------- Rendering API ----------------------------------- }

type TPDFPixFormat =
(
   pxf1Bit,
   pxfGray,
   pxfRGB,
   pxfBGR,
   pxfRGBA,
   pxfBGRA,
   pxfARGB,
   pxfABGR,
   pxfGrayA,
   pxfCMYK,
   pxfCMYKA
);

type TPDFPageScale =
(
   psFitWidth,  // Scale the page to the width of the image buffer
   psFitHeight, // Scale the page to the height of the image buffer
   psFitBest,   // Scale the page so that it fits fully into the image buffer
   psFitZoom    // This mode should be used if the scaling factors of the transformation matrix are <> 1.0
);

type TRasterFlags = Cardinal;
const
   rfDefault               = $00000000; // Render the page as usual
   rfScaleToMediaBox       = $00000001; // Render the real paper format. Contents outside the crop box is clipped
   rfIgnoreCropBox         = $00000002; // Ignore the crop box and render anything inside the media box without clipping
   // Only one of these flags must be set at time!
   rfClipToArtBox          = $00000004; // Clip the page to the art box if any
   rfClipToBleedBox        = $00000008; // Clip the page to the bleed box if any
   rfClipToTrimBox         = $00000010; // Clip the page to the trim box if any
   rfExclAnnotations       = $00000020; // Don't render annotations
   rfExclFormFields        = $00000040; // Don't render form fields
   rfSkipUpdateBG          = $00000080; // Don't generate an update event after initializing the background to white
   rfRotate90              = $00000100; // Rotate the page 90 degress
   rfRotate180             = $00000200; // Rotate the page 180 degress
   rfRotate270             = $00000400; // Rotate the page 270 degress
   rfInitBlack             = $00000800; // Initialize the image buffer to black before rendering (RGBA or GrayA must be initialized to black)
   rfCompositeWhite        = $00001000; // Composite pixel formats with an alpha channel finally with a white background. The alpha channel is
                                        // 255 everywhere after composition. This flag is mainly provided for debug purposes but it can also be
                                        // useful if the image must be copied on screen with a function that doesn't support alpha blending.
   rfExclPageContent       = $00002000; // If set; only annotations and form fields will be rendered (if any).

   // If you want to render specific field types with RenderAnnotOrField() then use the following flags to exclude these fields.
   // If all fields should be skipped then set the flag rfExclFormFields instead.
   rfExclButtons           = $00004000;
   rfExclCheckBoxes        = $00008000;
   rfExclComboBoxes        = $00010000;
   rfExclListBoxes         = $00020000;
   rfExclTextFields        = $00040000;
   rfExclSigFields         = $00080000;

   // ---------------------------------
   rfScaleToBBox           = $00100000; // Considered only, if the flag rfClipToArtBox, rfClipToBleedBox, or rfClipToTrimBox is set.
                                        // If set, the picture size is set to the size of the whished bounding box.
   rfDisableAAClipping     = $00200000; // Disable Anti-Aliasing for clipping paths. This flag is the most important one since clipping paths
                                        // cause often visible artefacts in PDF files with flattened transparency.
   rfDisableAAText         = $00400000; // Disable Anti-Aliasing for text.
   rfDisableAAVector       = $00800000; // Disable Anti-Aliasing for vector graphics.
   rfDisableAntiAliasing   = rfDisableAAClipping or rfDisableAAText or rfDisableAAVector; // Fully disable Anti-Aliasing.
   rfDisableBiLinearFilter = $01000000; // Disable the BiLevel filter for images. Sometetimes useful if sharp images are needed, e.g. for barcodes.
   rfRenderInvisibleText   = $02000000; // If set, treat text rendering mode Invisible as Normal.
   rfEnableBlendCS         = $10000000; // If set, the page is rendered in the color space of the page group, soft proof color space, or output intent if set, and
                                        // finally converted to the destination color space.
   rfRenderPrintState      = $20000000; // If set, the print state of layers, annotations, and form fields will be rendered.
   rfForceInterpolation    = $40000000; // If set, image interpolation will be applied.
   rfPremulAlpha           = $80000000; // If set, an image with pre-multiplied alpha values will be created.
   
   
type TOnUpdateWindow = function(const Data: Pointer; var Area: TIntRect): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

// These flags can be combined with the structure size member:
//  TPDFRasterImage img;
//  img.StructSize = sizeof(img) | SKIP_INIT_SCREEN;
const SKIP_INIT_SCREEN   = $10000000; // Do not initialize the screen with a white image before rendering begins
const SKIP_UPDATE_SCREEN = $20000000; // Do not finally update the screen after the page was rendered

type TPDFRasterImage = record
   StructSize:      Cardinal;        // Must be set to sizeof(TPDFRasterImage)
   Flags:           TRasterFlags;    // This is a bit mask. Flags can be combined with a binary or operator
   DefScale:        TPDFPageScale;   // Specifies how the page should be scaled into the image buffer.
   InitWhite:       LongBool;        // If true, the image buffer is initialized to white before rendering.
                                     // When a clipping rectangle is set, only the area inside the clipping
                                     // rectangle is initialized to white.

   ClipRect:        TIntRect;        // Optional clipping rectangle defined in device coordinates (Pixels), default 0,0,0,0 (no clipping)
   Matrix:          TCTM;            // Optional transformation matrix. Initialize the variable to the identity matrix (1,0,0,1,0,0)
                                     // if you don't need it. The matrix can be used to move and scale the picture inside the image. 
   PageSpace:       TCTM;            // Out -> The matrix represents the mapping from page space to device space. This matrix
                                     // is required when further objects should be drawn on the page, e.g. the bounding boxes.

   DrawFrameRect:   LongBool;        // If true, the area outside the page's bounding box is filled with the
                                     // frame color. InitWhite can still be used, with or without a clipping
                                     // rectangle.
   FrameColor:      Cardinal;        // Must be defined in the color space of the pixel format but in the natural
                                     // component order, e.g. RGB.

   OnUpdateWindow:  TOnUpdateWindow; // Optional, UpdateOnPathCount and UpdateOnImageCoverage define when the function should be called
   OnInitDecoder:   Pointer;         // Not yet defined
   OnDecodeLine:    Pointer;         // Not yet defined
   UserData:        Pointer;         // Arbitrary pointer that should be passed to the callback functions

   UpdateOnPathCount: Cardinal;      // Optional -> Call OnUpdateWindow when the limit was reached.
                                     // Clipping paths increment the number too.
                                     // Only full paths are considered, independent of the number of vertices
                                     // they contain. The value should be larger than 50 and smaller than 10000.

   UpdateOnImageCoverage: Single;    // Optional -> DynaPDF multiplies the output image width and height with this
                                     // factor to calculate the coverage limit. When an image is inserted the unscaled
                                     // width and height is added to the current coverage value. When the number
                                     // reaches the limit the OnUpdateWindow event is raised.
                                     // The factor should be around 0.5 through 5.0. Larger values cause less
                                     // frequently update events.
   // Statistics...
   NumAnnots:         Cardinal;      // Out -> Number of rendered annotations (excluding invisible annotation but including annotations with no appearance)
   NumBezierCurves:   Cardinal;      // Out -> Number of bezier curves which where rendered. Glyph outlines are not taken into account.
   NumClipPaths:      Cardinal;      // Out -> Number of clipping paths used in the page. Should be small as possible!
   NumFormFields:     Cardinal;      // Out -> Number of rendered form fields (excluding invisible fields but including fields with no appearance)
   NumGlyphs:         Cardinal;      // Out -> When the number of glyphs equals NumTextRecords then there is probably some room for optimization...
   NumImages:         Cardinal;      // Out -> Number of images which were rendered
   NumLineTo:         Cardinal;      // Out -> Number of LineTo operators
   NumPaths:          Cardinal;      // Out -> Number of paths which were processed
   NumPatterns:       Cardinal;      // Out -> Number of pattern which were processed
   NumRectangles:     Cardinal;      // Out -> Number of rectangle operators
   NumRestoreGState:  Cardinal;      // Out -> Should be equal to NumSaveGState
   NumSaveGState:     Cardinal;      // Out -> The number of save graphics state operators
   NumShadings:       Cardinal;      // Out -> Number shadings which were processed
   NumSoftMasks:      Cardinal;      // Out -> Number of soft masks that were processed. Alpha channels of images are not taken into account.
   NumTextRecords:    Cardinal;      // Out -> Number of text records which were rendered
end;

type PPDFRasterImage = ^TPDFRasterImage;

{ ------------------------------------------------------------------------------------- }

{------------------------------------------ Function Prototypes --------------------------------------------------}

{$ifdef DYNLNK}
type
{$endif}
   { ------------------------------------------------- Font API ------------------------------------------------- }
   {$ifdef DYNLNK}fntBuildFamilyNameAndStyle = function{$else}function fntBuildFamilyNameAndStyle{$endif}(const IFont: PFNT; Name: PAnsiChar; var Style: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntGetFont                 = function{$else}function fntGetFont{$endif}(const IFont: PFNT; var F: TPDFFontObj): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntGetFontInfo             = function{$else}function fntGetFontInfo{$endif}(const IFont: PFNT; var F: TPDFFontInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntGetSpaceWidth           = function{$else}function fntGetSpaceWidth{$endif}(const IFont: PFNT; FontSize: Double): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntGetTextWidth            = function{$else}function fntGetTextWidth{$endif}(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; CharSpacing, WordSpacing, TextScale: Single): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntTranslateRawCode        = function{$else}function fntTranslateRawCode{$endif}(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; var Width: Double; OutText: PWideChar {Must be 32 characters long!}; var OutLen: Integer; var Decoded: LongBool; CharSpacing, WordSpacing, TextScale: Single): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntTranslateString         = function{$else}function fntTranslateString{$endif}(var Stack: TPDFStack; Buffer: PWideChar; Size, Flags: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}fntTranslateString2        = function{$else}function fntTranslateString2{$endif}(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; OutBuf: PWideChar; Size, Flags: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}


   { ------------------------------------------------ Parser API ------------------------------------------------ }

   type
      PContentOP = ^TContentOP;
      TContentOP = packed record
      OP:    Byte;        // Operator to excecute.
      Param: Pointer;     // It is guaranteed that this pointer is set for operators which have parameters.
   end;
   
   type TContent = record
      Count: Cardinal;    // Number of available operators.
      OP:    PContentOP;  // Array of operators.
   end;
   
   type TContentParseFlags = Integer;
   const
      cpfDefault              = $00000000; // Nothing special to do.
      cpfComputeBBox          = $00000001; // Compute bounding boxes of all objects.
      cpfFlattenLayers        = $00000002; // Flatten layers.
      cpfSkipInvisibleObjects = $00000004; // Ignore invisible objects.
      cpfFullRecursive        = $00000008; // Parse all objects recursively.
      cpfNoInlineTemplate     = $00000010; // Do not resolve templates with a reference count of 1.
      cpfCalcDeviceColors     = $00000020; // Compute device colors of all colors which are set in the content streams.
      cpfImidiateMode         = $00000040; // Internal. This flag is always set if the TPDFParseCallbacks structure is passed to ParsePage(). It disables certain optimisations.
      cpfNewLinkNames         = $00000080; // Internal. Create new link names for all objects. This flag is used by Optimize() and CheckConformance().
      cpfEnableTextSelection  = $00000100; // This flag is required to enable text selection and text extraction.
      cpfInitMatrix           = $00000200; // The transformation matrix must be set in the TContentParseParms structure.
      cpfSkipClipPaths        = $00000400; // Useful for debugging purposes.
      cpfSkipImages           = $00000800; // Ignore all images. This flag is useful for text extraction.
      cpfSkipShadings         = $00001000; // Useful for debugging purposes.
      cpfSkipText             = $00002000; // Useful for debugging purposes.
      cpfSkipVector           = $00004000; // Useful for debugging purposes. Exclude vector graphics with exception of clipping paths.
   
   type
      // Dummy type. Real implementation comes later.
      PPDFParseCallbacks = ^TPDFParseCallbacks;
      TPDFParseCallbacks = record
      StructSize: Cardinal; // Must be set to sizeof(TPDFParseCallbacks)
   end;
   
   type
      PContentParseParms = ^TContentParseParms;
      TContentParseParms = record
      StructSize: Cardinal; // Must be set to sizeof(TContentParseParms)
      InitMatrix: TCTM;     // Considered only if the flag cpfInitMatrix is set.
   end;

   type TDeleteTextFlags =
   (
      dtfDefault = 0
   );

   type TReplaceTextFlags =
   (
      rtfDefault = 0
   );
   
   type TSearchType = Cardinal;
   const
      stDefault         = 0; // Case sensitive search
      stWholeWord       = 1; // Only whole words
      stCaseInSensitive = 2; // Case insensitive search
      stMatchAlways     = 4; // Return every character that was found
      stSearchAsIs      = 8; // Disable sorting on the x-axis

   type
      PTextSelection = ^TTextSelection;
      TTextSelection = record
      StructSize: Cardinal;       // Must be set to sizeof(TTextSelection).
      Line:       Cardinal;       // Index of the text line.
      Matrix:     TCTM;           // Text matrix pre-calculated in user space.
      Sub1:       Integer;        // Index of the text node.
      Sub2:       Integer;        // Index of the sub text node.
      TextLen:    Integer;        // How many characters of this record are selected?
      TextOP:     Pointer;        // The text record in which the text was found. The real declaration follows later...
      TextPos:    Integer;        // Index where the first character of the search text was found.
      X:          Single;         // X-Coordinate in text space
      Y:          Single;         // Y-Coordinate in text space
      Next:       PTextSelection; // Next record if the search text spans multiple text records.
      Prev:       PTextSelection; // Prev record if any.
   end;
   
   // Parser API
   {$ifdef DYNLNK}psrAbort                      = procedure{$else}procedure psrAbort{$endif}(const Ctx: IPSR); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrChangeAltFont              = function {$else}function  psrChangeAltFont{$endif}(const IPDF: PPDF; const Ctx: IPSR; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrClearSelection             = procedure{$else}procedure psrClearSelection{$endif}(const Ctx: IPSR); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrCreateParserContext        = function {$else}function  psrCreateParserContext{$endif}(const IPDF: PPDF; Flags: TOptimizeFlags; Parms: POptimizeParams): IPSR; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrDeleteOperator             = function {$else}function  psrDeleteOperator{$endif}(const Ctx: IPSR; Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrDeleteOperatorInObject     = function {$else}function  psrDeleteOperatorInObject{$endif}(const Ctx: IPSR; ObjPtr: IPDFObj; Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrDeleteParserContext        = procedure{$else}procedure psrDeleteParserContext{$endif}(var Ctx: IPSR); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrDeleteText                 = function {$else}function  psrDeleteText{$endif}(const IPDF: PPDF; const Ctx: IPSR; Area: PFltRect; Flags: TDeleteTextFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrExtractText                = function {$else}function  psrExtractText{$endif}(const IPDF: PPDF; const Ctx: IPSR; Flags: TTextExtractionFlags; Area: PFltRect; var Text: PWideChar; var TextLen: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrFindText                   = function {$else}function  psrFindText{$endif}(const IPDF: PPDF; const Ctx: IPSR; Area: PFltRect; SearchType: TSearchType; Last: PTextSelection; const Text: PWideChar; TextLen: Cardinal; var SelText: TTextSelection): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrGetSelBBox                 = function {$else}function  psrGetSelBBox{$endif}(const IPDF: PPDF; const Ctx: IPSR; var SelText: TTextSelection; var BBox: TBBox): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrGetSelBBox2                = function {$else}function  psrGetSelBBox2{$endif}(const IPDF: PPDF; var SelText:  TTextSelection; QuadPoint: PFltPoint): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrGetSelText                 = function {$else}function  psrGetSelText{$endif}(const IPDF: PPDF; var SelText:  TTextSelection; var Text: PWideChar; var TextLen: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrParsePage                  = function {$else}function  psrParsePage{$endif}(const IPDF: PPDF; const Ctx: IPSR; const UserData: Pointer; Funcs: PPDFParseCallbacks; PageNum: Cardinal; Flags: TContentParseFlags; Parms:  PContentParseParms; var Value: TContent): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrReplaceSelText             = function {$else}function  psrReplaceSelText{$endif}(const IPDF: PPDF; const Ctx: IPSR; Flags: TReplaceTextFlags; var SelText: TTextSelection; const Text: PWideChar; TextLen: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrSetAltFontA                = function {$else}function  psrSetAltFontA{$endif}(const IPDF: PPDF; const Ctx: IPSR; const Name: PAnsiChar; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrSetAltFontW                = function {$else}function  psrSetAltFontW{$endif}(const IPDF: PPDF; const Ctx: IPSR; const Name: PWideChar; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}psrWriteToPage                = function {$else}function  psrWriteToPage{$endif}(const IPDF: PPDF; const Ctx: IPSR; Flags: TOptimizeFlags; Parms: POptimizeParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}

   { --------------------------------------------- Rendering Engine --------------------------------------------- }

   {$ifdef DYNLNK}rasAbort              = procedure{$else}procedure rasAbort{$endif}(RasPtr: IRAS);{$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasAttachImageBuffer  = function {$else}function  rasAttachImageBuffer{$endif}(RasPtr: IRAS; Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCalcPagePixelSize  = procedure{$else}procedure rasCalcPagePixelSize{$endif}(PagePtr: IPGE; DefScale: TPDFPageScale; Scale: Single; FrameWidth, FrameHeight: Cardinal; Flags: TRasterFlags; var Width, Height: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreateRasterizer   = function {$else}function  rasCreateRasterizer{$endif}(const IPDF: PPDF; Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer; PixelFormat: TPDFPixFormat): IRAS; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreateRasterizerEx = function {$else}function  rasCreateRasterizerEx{$endif}(const IPDF: PPDF; DC: HDC; Width, Height: Cardinal; PixFmt: TPDFPixFormat): IRAS; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasDeleteRasterizer   = procedure{$else}procedure rasDeleteRasterizer{$endif}(RasPtr: PIRAS); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetWidthHeight     = function {$else}function  rasGetWidthHeight{$endif}(PagePtr: IPGE; Flags: TRasterFlags; var Width, Height: Single; Rotate: Integer; BBox: PPointer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasRedraw             = procedure{$else}procedure rasRedraw{$endif}(RasPtr: IRAS; DC: HDC; DestX, DestY: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasResizeBitmap       = function {$else}function  rasResizeBitmap{$endif}(RasPtr: IRAS; DC: HDC; Width, Height: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetMinLineWidth2   = procedure{$else}procedure rasSetMinLineWidth2{$endif}(RasPtr: IRAS; Value: Single); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetScreenRes       = procedure{$else}procedure rasSetScreenRes{$endif}(RasPtr: IRAS; Value: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   
   { ------------------------------------------------ Page Cache ------------------------------------------------ }

   type TPDFControlSubType =
   (
      cstNone,
      cstButton,
      cstCheckBox,
      cstComboBox,
      cstListBox,
      cstSignature,
      cstTextField
   );

   type TPDFControlType =
   (
      crpCaretAnnot,    // Draw a Caret annotation
      crpCircleAnnot,   // Draw an oval or circle if shift is pressed
      crpFileAttach,    // Draw a File Attach annotation
      crpFileLink,      // Draw a File Link annotation
      crpInkAnnot,      // Draw an Ink annotation
      crpLineAnnot,     // Draw a Line annotation
      crpPolygonAnnot,  // Draw a Polygon annotation
      crpPolyLineAnnot, // Draw a PolyLine annotation
      crpSelObject,     // Draw a placeholder for object selection. This type is created by SelectObject(). It cannot be created with CreateControl()!
      crpSquareAnnot,   // Draw a regular rectangle or square if shift is pressed
      crpStampAnnot,    // Draw a Stamp annotation
      crpTextAnnot,     // Draw a Text annotation
      crpWidget,        // Draw a form field
      crpSelRect
   );

   type TPDFCtrlFlags =
   (
      fcfDefault   = 0,
      fcfChecked   = 1,
      fcfMultiline = 2,
      fcfSort      = 4
   );

   type
      PPDFControl = ^TPDFControl;
      TPDFControl = record
      StructSize:     Cardinal;           // Must be initialized with sizeof(TPDFPrimitive)
      BorderEffect:   TBorderEffect;      // Border effect
      BorderWidth:    Single;             // Border width in PDF units
      ControlSubType: TPDFControlSubType; // Control sub type
      ControlType:    TPDFControlType;    // Control type
      FillColor:      Cardinal;           // Fill color
      IconType:       Cardinal;           // Used by FileAttach and Text annotations only -> TAnnotIcon or TFileAttachIcon.
      LineEndStyle1:  TLineEndStyle;      // Line end style of the start point
      LineEndStyle2:  TLineEndStyle;      // Line end style of the end point
      Opacity:        Single;             // Opacity 0..1. 0 == fully transparent, 1.0 == fully opaque
      StrokeColor:    Cardinal;           // Stroke color
      // Members for form fields
      Flags:          TPDFCtrlFlags;      // Various flags
      MaxLen:         Integer;            // Text fields
      Name:           PAnsiChar;          // Might be an UTF8 string
      Parent:         Integer;            // Parent field or -1
      StrVal:         PAnsiChar;          // Caption or ExpValue
   end;
   
   type TPDFCursor =
   (
      pcrHandNormal, // This is the default cursor if the left mouse button is not pressed and if we are not over an action field or text
      pcrHandClosed, // This cursor is used if the cursor leaves an action field and if the left mouse button is pressed
      pcrHandPoint,  // This cursor is used if we enter a link or button field
      pcrIBeam,      // This cursor is used we move the cursor over text of if we enter an action field that accepts text input
      pcrCross,      // This cursor is used to draw a selection rectangle, for example.
      pcrDrag,       // Drag cursor for single items being dragged.
      pcrHourGlass,  // Hour glass cursor to indicate a busy process.
      pcrMultiDrag,  // Drag cursor for multiple items being dragged.
      pcrNo,         // Cross in a circle indicating invalid mouse target location.
      pcrNoDrop,     // Cross in a circle indicating that a drag operation is hovering over an invalid drop target.
      pcrSizeAll,    // Cursor for resizing up, down, left, and right.
      pcrSizeNESW,   // North-East to South-West resizing.
      pcrSizeNS,     // Vertical resizing cursor.
      pcrSizeNWSE,   // Resizing cursor from North-West to South-East resizing.
      pcrSizeWE,     // Horizontal resizing cursor
      pcrSplitH,     // Cursor shown when the mouse is over a horizontal splitter.
      pcrSplitV,     // Cursor shown when the mouse is over a vertical splitter. 
      pcrArrow1,     // White arrow.
      pcrArrow2,     // Black arrow.
      pcrArrow3,     // Black arrow with a smaller shape.
      pcrUserDef1,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef2,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef3,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef4,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef5,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef6,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef7,   // User defined cursor. Can be activated with ChangeCursor().
      pcrUserDef8    // User defined cursor. Can be activated with ChangeCursor().
   );
   
   type TInitCacheFlags = Cardinal;
   const
      icfDefault          = 0;
      icfIgnoreOpenAction = 1;
      icfIgnorePageLayout = 2;
      icfNonTileMode      = 4;

   type TPDFMouseKeys = Cardinal;
   const
      mkNone         = $00000000;
      mkLeftButton   = $00000001;
      mkRightButton  = $00000002;
      mkShift        = $00000004;
      mkControl      = $00000008;
      mkMiddleButton = $00000010;
      
   type TPageCacheOptions =
   (
      pcoBackColor,     // UI32 -> Color
      pcoCursor,        // TPDFCursor
      pcoDefPageLayout, // TPageLayout
      pcoPageScale,     // TPDFPageScale
      pcoResolution,    // UI32 -> Screen resolution
      pcoRotate         // SI32 (90 degree steps)
   );
      
   {
      The path names can be set in Ansi (code page 1252 on Windows) or Unicode format. The Ansi version accepts
      UTF-8 strings on non-Windows operating systems. UTF-16 Unicode strings are converted to UTF-8 on non-Windows
      operating systems.

      In general, the DefInXXX profiles are used if no other profile is available for the color space. Possible
      sources are DefaultGray, DefaultRGB, DefaultCMYK, and the Rendering Intents.

      The SoftProof profile emulates the output device. This is typically a printer profile or a default CMYK
      profile. If no profile is set then no device will be emulated. What you see is maybe not what you get on
      a printer.

      To disable color management set the parameter Profiles of TPDFPageCache.InitColormanagement() to nil.
   }
   type TPDFColorProfiles = record
      StructSize:     Cardinal;  // Must be set to sizeof(TPDFColorProfile)
      DefInGrayA:     PAnsiChar; // Optional
      DefInGrayW:     PWideChar; // Optional
      DefInRGBA:      PAnsiChar; // Optional, sRGB is the default. The "A" stands for Ansi string and not for Alpha...
      DefInRGBW:      PWideChar; // Optional
      DefInCMYKA:     PAnsiChar; // Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
      DefInCMYKW:     PWideChar; // but this is not possible with a CMYK profile. So, this is the most important input profile.
      DeviceProfileA: PAnsiChar; // Optional, the output profile must be compatible with the output color space.
      DeviceProfileW: PWideChar; // At this time only Gray or RGB profiles are supported. This is the monitor profile! Default is sRGB.
      SoftProofA:     PAnsiChar; // Optional, this profile emulates the output device.
      SoftProofW:     PWideChar; // Optional.
   end;
   type PPDFColorProfiles = ^TPDFColorProfiles;

   type TPDFColorProfilesEx = record
      StructSize:       Cardinal; // Must be set to sizeof(TPDFColorProfilesEx)
      DefInGray:        Pointer;  // Optional
      DefInGrayLen:     Cardinal; // Optional
      DefInRGB:         Pointer;  // Optional
      DefInRGBLen:      Cardinal; // Optional
      DefInCMYK:        Pointer;  // Optional, CMYK colors are the problematic ones. The other profiles can be created on demand
      DefInCMYKLen:     Cardinal; // but this is not possible with a CMYK profile. So, this is the most important input profile.
      DeviceProfile:    Pointer;  // Optional, the output profile must be compatible with the output color space.
      DeviceProfileLen: Cardinal; // Gray, RGB, or CMYK profiles are supported.
      SoftProof:        Pointer;  // Optional but very important. This profile emulates the output device.
      SoftProofLen:     Cardinal; // Optional.
   end;
   type PPDFColorProfilesEx = ^TPDFColorProfilesEx;
   
   type TPDFInitCMFlags = Integer;
   const
      icmDefault        = 0;  // Default rules.
      icmBPCompensation = 1;  // Black point compensation preserves the black point when converting CMYK colors to different color spaces.
                              // Should be set by default to increae the rendering quality of CMYK images.
      icmCheckBlackPoint = 2; // If set, soft proofing will be disabled if the black point of the output intent is probably invalid.
     
   type TPDFObjectFlags = Cardinal;
   const
      acfDefault           = 0;
      acfDrawTextSelection = 1;

   type TSelObjAction =
   (
      soaNoSelection,      // No object was selected
      soaDeselected,       // Object was de-selected and nothing was changed.
      soaError,            // An error occurred while applying pending change. Object is now de-selected.
      soaIgnored,          // This state occurs if nothing was to do, e.g. if no button was pressed.
      soaInvObjInfo,       // TPDFObjectInfo structure contains invalid data.
      soaSelctionApplied,  // Pending change was applied and object was de-selected.
      soaSelected,         // The object was selected.
      soaSelectionChanged, // Another object was selected. Previous object was not changed.
      soaStillSelected     // Nothing changed. The same object is still selected.
   );
      
   type TSelectObjType = Cardinal;
   const
      sotDefault    = $00000000; // Hand tool
      sotAnnotation = $00000001; // Select annotations
      sotFormField  = $00000002; // Select form fields
      sotImage      = $00000004; // Select images
      sotText       = $00000008; // Select text
      sotVector     = $00000010; // Select vector graphics
      
   type TPDFObjectInfo = record
      StructSize: Cardinal;        // Must be set to sizeof(TPDFObject).
      Action:     Integer;         // Action handle or -1 if not set.
      ActionPtr:  Pointer;         // Action pointer for fast access if available.
      ActionType: TActionType;     // The type of the action if Action >= 0.
      BBox:       TIntRect;        // Bounding box if available.
      Events:     IEVT;            // Additional events if any -> GetObjEvent().
      Flags:      TPDFObjectFlags; // Certain object flags.
      ObjHandle:  Integer;         // Object handle.
      ObjPtr:     Pointer;         // Object pointer for fast access if available. If ObjType == sotText then ObjType holds a pointer of the corresponding font -> fntGetFontInfo().
      ObjType:    TSelectObjType;  // Object type that was selected.
      PageNum:    Integer;         // The page number on which this object was found.
      SubType:    Integer;         // This is currently the annotation or field type if ObjType == sotAnnotation or ObjType == sotFormField. Otherwise the the value is not set (-1).
   end;

   type PPDFObjectInfo = ^TPDFObjectInfo;

   type
      PPDFObjSelPath = ^TPDFObjSelPath;
      TPDFObjSelPath = record
      StructSize:   Cardinal;     // Must be set to sizeof(TPDFObjSelPath)
      BBox:         TIntRect;     // Bound box (24.8 fixed integer)
      First:        Integer;      // First index of selection
      Last:         Integer;      // Last index of selection
      LineWidth:    Single;       // Line width of stroked paths. This value was passed to CreatePDFControl().
      Path:         Pointer;      // The data type depends on PathType. By default quad points are returned. Make a typecast to TI32QuadPoint or TI32Point depending on PathType;
      PathSize:     Cardinal;     // Note that this is the number of quad points or points, depending on PathType.
      PathType:     TPDFPathType; // Specifies how Path must be interpreted. ptQuadPoints = TI32QuadPoint, TI32Point otherwise.
      SizeGrip:     PI32Point;    // If the control size can be changed, then we must draw a size grip around the base path.
      SizeGripSize: Cardinal;     // Number of points in the path.
      PageWidth:    Cardinal;     // The scaled page width for which this selection was created.
   end;

   type TPDFCtrlType =
   (
      pctNotInitialized,
      pctPDFCanvas,
      pctThumbCtrl
   );

   type TPDFTileFlags = Cardinal;
   const
      tfrDefault        = 0;
      tfrSkipSelAreas   = 1; // Should be set when rendering tiles
      tfrNoUpdateEvents = 2; // Should be set if a page has already a bitmap, e.g. when resizing or zooming.
   
   type
      PPDFTile = ^TPDFTile;
      TPDFTile = record
      StructSize:  Cardinal;      // Must be set to sizeof(TPDFTile)
      DstRect:     TBBox;         // Destination rectangle
      Flags:       TPDFTileFlags; // Certain flags
      IndexX:      Cardinal;      // Horizontal tile index
      IndexY:      Cardinal;      // Vertical tile index
      PageW:       Cardinal;      // Scaled page width in pixel
      Scale:       Single;        // Scaling factor of this tile
      SrcX:        Single;        // Source x-coordinate
      SrcY:        Single;        // Source y-coordinate
      TileH:       Integer;       // Height in pixels
      TileW:       Integer;       // Width in pixels
      UsrCtrl:     Pointer;       // User defined pointer
      UsrCtrlType: TPDFCtrlType;  // User defined control type. The control type is considered by RenderTile() and AbortInvisible().
      UsrPage:     Pointer;       // User defined pointer
      Zoom:        Cardinal;      // Quantized zoom factor
   end;

   const PDF_GET_TILE_INFO = $10000000;

   // Screen resolution is not considered
   type TPDFPageInfo = record
      StructSize:  Cardinal;      // Must be set to sizeof(TPDFPageInfo)
      Cols:        PSingle;       // Column widths
      ColsCount:   Integer;       // Number of columns
      DestH:       Single;        // Scaled height without screen scaling
      DestW:       Single;        // Scaled width without screen scaling
      DestX:       Single;        // Destination coordinate
      DestY:       Single;        // Destination coordinate
      IncY:        Single;        // Increment the destination y-coordinate by this value.
      NextRow:     LongBool;      // If true, add the divider height to the y-coordinate.
      PixH:        Integer;       // Height in pixels
      PixW:        Integer;       // Width in pixels
      Rows:        PSingle;       // Row heights
      RowsCount:   Integer;       // Number of rows
      TileH:       Cardinal;      // The tile height of the page
      Tiles:       PPDFTile;      // Array of tiles
      TileW:       Cardinal;      // The tile width of the page
      Zoom:        Cardinal;      // Quantized zoom factor
   end;
   
   type TPDFDisplayTile = procedure(UserData: Pointer; NRows, NCols: Cardinal; Tile: PPDFTile); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif};

   type PPByte = ^PByte;
   
   type TPDFRasInfo = record
      StructSize:  Cardinal; // Must be set to sizeof(TPDFRasInfo)
      BmpInfo:     {$ifdef MSWINDOWS}PBITMAPINFO;{$else}Pointer;{$endif}
      Buffer:      PByte;    // Either Buffer or Rows is set
      Height:      Cardinal; // Bitmap height
      Rows:        PPByte;   // Either Buffer or Rows is set
      Stride:      Integer;  // Scanline length in bytes
      Width:       Cardinal; // bitmap width
   end;
   
   type TPDFThreadPriority =
   (
      ttpLowest,
      ttpIdle,
      ttpBelowNormal, // This is the default value. Normal can be used too but scrolling is smoother in this mode.
      ttpNormal,
      ttpAboveNormal,
      ttpHighest,     // Not really useful...
      ttpTimeCritical // Don't do that!
   );

   type TUpdBmkAction = Integer;
   const
      ubaDoNothing     = 0;  // Nothing to do
      ubaOpenPage      = 1;  // Jump to the new page. This flag is set if the bookmark contained a destination or go to action.
      ubaPageScale     = 2;  // Update the page scale with SetPageScale().
      ubaZoom          = 4;  // Zoom into the page, update the scroll ranges, and set the scroll positions.
      ubaUpdScrollBars = 8;  // This flag is always set if ubaZoom is set.
      ubaExecAction    = 16; // Check the parameter Action to execute further code. This flag can occur with or without ubaOpenPage.

   type TUpdScrollbar = Integer;
   const
      usbNoUpdate         = $00000000; // Nothing to do
      usbVertRange        = $00000001; // Update the vertical scroll range
      usbVertScrollPos    = $00000002; // Update the vertical scroll position
      usbHorzRange        = $00000004; // Update the horizontal scroll range
      usbHorzScrollPos    = $00000008; // Update the horizontal scroll position
      usbUpdateAll        = $0000000F; // Update both scroll ranges and the scroll positions
      // The cursor constants are set by MouseMove. Since we have only one cursor there is never more than one constant set.
      usbCursorHandNormal = $00000010; // This is the default cursor if the left mouse button is not pressed and if we are not over an action field or text
      usbCursorHandClosed = $00000020; // This cursor is used if the cursor leaves an action field and if the left mouse button is pressed
      usbCursorHandPoint  = $00000040; // This cursor is used if we enter a link or button field
      usbCursorIBeam      = $00000080; // This cursor is used if we move the cursor over text of if we enter an action field that accepts text input
      usbCursorCross      = $00001000; // This cursor is used to draw a selection rectangle; for example.
      usbCursorDrag       = $00001100; // Drag cursor for single items being dragged.
      usbCursorHourGlass  = $00001200; // Hour glass cursor to indicate a busy process.
      usbCursorMultiDrag  = $00001300; // Drag cursor for multiple items being dragged.
      usbCursorNo         = $00001400; // Cross in a circle indicating invalid mouse target location.
      usbCursorNoDrop     = $00001500; // Cross in a circle indicating that a drag operation is hovering over an invalid drop target.
      usbCursorSizeAll    = $00001600; // Cursor for resizing up; down; left; and right.
      usbCursorSizeNESW   = $00001700; // North-East to South-West resizing.
      usbCursorSizeNS     = $00001800; // Vertical resizing cursor.
      usbCursorSizeNWSE   = $00001900; // Resizing cursor from North-West to South-East resizing.
      usbCursorSizeWE     = $00001A00; // Horizontal resizing cursor
      usbCursorSplitH     = $00001B00; // Cursor shown when the mouse is over a horizontal splitter.
      usbCursorSplitV     = $00001C00; // Cursor shown when the mouse is over a vertical splitter. 
      usbCursorArrow1     = $00001D00; // White arrow.
      usbCursorArrow2     = $00001E00; // Black arrow.
      usbCursorArrow3     = $00001F00; // Black arrow with a smaller shape.
      usbCursorUserDef1   = $00002000; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef2   = $00002100; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef3   = $00002200; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef4   = $00002300; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef5   = $00002400; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef6   = $00002500; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef7   = $00002600; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorUserDef8   = $00002700; // User defined cursor. Can be activated with ChangeCursor().
      usbCursorMask       = $00003FF0; // Bitmask to mask out the cursor constants

{$ifdef DYNLNK}
type
{$endif}
   {$ifdef DYNLNK}rasAbortInvisible         = procedure{$else}procedure rasAbortInvisible{$endif}(CachePtr: IPGC; CtrlType: TPDFCtrlType; FirstVisible, LastVisible: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasAbortTile              = procedure{$else}procedure rasAbortTile{$endif}(CachePtr: IPGC; CtrlType: TPDFCtrlType; PageNum, IndexX, IndexY, Zoom: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasAppend                 = function {$else}function  rasAppend{$endif}(CachePtr: IPGC): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCalcMaxima             = procedure{$else}procedure rasCalcMaxima{$endif}(CachePtr: IPGC; FirstPage, LastPage: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasChangeBackColor        = procedure{$else}procedure rasChangeBackColor{$endif}(CachePtr: IPGC; Value: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasChangeCursor           = procedure{$else}procedure rasChangeCursor{$endif}(CachePtr: IPGC; Value: TPDFCursor); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasClearSelection         = procedure{$else}procedure rasClearSelection{$endif}(CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCloseFile              = procedure{$else}procedure rasCloseFile{$endif}(CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCopyToClipBoard        = function {$else}function  rasCopyToClipBoard{$endif}(CachePtr: IPGC; hWnd: HWND; SelectedObjType: TSelectObjType; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreateAnnotFromControl = function {$else}function  rasCreateAnnotFromControl{$endif}(CachePtr: IPGC; Author, Comment: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreateControl          = function {$else}function  rasCreateControl{$endif}(CachePtr: IPGC; Value: PPDFControl): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreatePageCache        = function {$else}function  rasCreatePageCache{$endif}(const IPDF: PPDF; PixFmt: Integer; HBorder, VBorder, BackColor: Cardinal): IPGC; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasCreatePageCacheV3      = function {$else}function  rasCreatePageCacheV3{$endif}(const IPDF: PPDF; PixFmt: TPDFPixFormat; ScreenScale, Divider: Single; TileWidth, TileHeight: Cardinal): IPGC; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasDeletePage             = function {$else}function  rasDeletePage{$endif}(CachePtr: IPGC; PageNum: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasDeletePageCache        = procedure{$else}procedure rasDeletePageCache{$endif}(var CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasExecBookmark           = function {$else}function  rasExecBookmark{$endif}(CachePtr: IPGC; Handle: Cardinal; var NewX, NewY: Integer; var NewZoom: Single; var NewPageScale: TPDFPageScale; Action: Pointer): TUpdBmkAction; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasExchangePages          = function {$else}function  rasExchangePages{$endif}(CachePtr: IPGC; First, Second: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetBaseControlSize     = function {$else}function  rasGetBaseControlSize{$endif}(CachePtr: IPGC; var Value: TI32Point): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetCurrPage            = function {$else}function  rasGetCurrPage{$endif}(CachePtr: IPGC): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetCurrTile            = function {$else}function  rasGetCurrTile{$endif}(CachePtr: IPGC; var Tile: TPDFTile): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetCurrZoom            = function {$else}function  rasGetCurrZoom{$endif}(CachePtr: IPGC): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetDefPageLayout       = function {$else}function  rasGetDefPageLayout{$endif}(CachePtr: IPGC): TPageLayout; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetObjTypeAt           = function {$else}function  rasGetObjTypeAt{$endif}(CachePtr: IPGC; X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetObjTypeAtV3         = function {$else}function  rasGetObjTypeAtV3{$endif}(CachePtr: IPGC; PageNum: Cardinal; X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetOption              = function {$else}function  rasGetOption{$endif}(CachePtr: IPGC; Option: TPageCacheOptions; var Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPageAt              = function {$else}function  rasGetPageAt{$endif}(CachePtr: IPGC; ScrollX, ScrollY, X, Y: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPageInfo            = function {$else}function  rasGetPageInfo{$endif}(CachePtr: IPGC; PageNum: Integer; var Value: TPDFPageInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPageLayout          = function {$else}function  rasGetPageLayout{$endif}(CachePtr: IPGC): TPageLayout; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPageMatrix          = function {$else}function  rasGetPageMatrix{$endif}(CachePtr: IPGC; CursorX, CursorY: Integer; var DestX, DestY, Width, Height: Integer; var Matrix: TCTM): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPagePos             = function {$else}function  rasGetPagePos{$endif}(CachePtr: IPGC; PageNum: Integer; var X, Y: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetPageScale           = function {$else}function  rasGetPageScale{$endif}(CachePtr: IPGC): TPDFPageScale; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetRasInfo             = function {$else}function  rasGetRasInfo{$endif}(CachePtr: IPGC; var Info: TPDFRasInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetRotate              = function {$else}function  rasGetRotate{$endif}(CachePtr: IPGC): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetScrollLineDelta     = function {$else}function  rasGetScrollLineDelta{$endif}(CachePtr: IPGC; Vertical: LongBool): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetScrollPos           = function {$else}function  rasGetScrollPos{$endif}(CachePtr: IPGC; Vertical: LongBool; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetScrollRange         = function {$else}function  rasGetScrollRange{$endif}(CachePtr: IPGC; Vertical: LongBool; var Max, SmallChange, LargeChange: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetSelectedText        = function {$else}function  rasGetSelectedText{$endif}(CachePtr: IPGC; var Size: Cardinal): PWideChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetSelectionMode       = function {$else}function  rasGetSelectionMode{$endif}(CachePtr: IPGC): TSelectObjType; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetSelectionPath       = function {$else}function  rasGetSelectionPath{$endif}(CachePtr: IPGC; PageNum: Cardinal; var Value: TPDFObjSelPath): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetSelRect             = function {$else}function  rasGetSelRect{$endif}(CachePtr: IPGC; var Value: TIntRect): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasGetSelRectPDF          = function {$else}function  rasGetSelRectPDF{$endif}(CachePtr: IPGC; var Value: TBBox): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasInitBaseObjects        = function {$else}function  rasInitBaseObjects{$endif}(CachePtr: IPGC; Width, Height: Integer; Flags: TInitCacheFlags): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasInitBaseObjectsV3      = function {$else}function  rasInitBaseObjectsV3{$endif}(CachePtr: IPGC; DisplayTile: TPDFDisplayTile; UserData: Pointer; Width, Height: Single; Flags: TInitCacheFlags): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasInitColorManagement    = function {$else}function  rasInitColorManagement{$endif}(CachePtr: IPGC; Profiles: PPDFColorProfiles; Flags: TPDFInitCMFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasInitialize             = function {$else}function  rasInitialize{$endif}(CachePtr: IPGC; Priority: TPDFThreadPriority): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasInitMainTile           = function {$else}function  rasInitMainTile{$endif}(CachePtr: IPGC; const Buffer: Pointer; Width, Height: Cardinal; Stride: Integer; PixFmt: TPDFPixFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif} 
   {$ifdef DYNLNK}rasHaveSelection          = function {$else}function  rasHaveSelection{$endif}(CachePtr: IPGC): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasHaveSelectedText       = function {$else}function  rasHaveSelectedText{$endif}(CachePtr: IPGC): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasHighlightText          = function {$else}function  rasHighlightText{$endif}(CachePtr: IPGC; SubType: TAnnotType; Color: Cardinal; const Author: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasKeyStroke              = function {$else}function  rasKeyStroke{$endif}(CachePtr: IPGC; Down: LongBool; CharCode, ShiftState: Cardinal): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasLock                   = procedure{$else}procedure rasLock{$endif}(CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseDblClick          = function {$else}function  rasMouseDblClick{$endif}(CachePtr: IPGC; X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseDblClickV3        = function {$else}function  rasMouseDblClickV3{$endif}(CachePtr: IPGC; PageNum: Cardinal; X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseDown              = function {$else}function  rasMouseDown{$endif}(CachePtr: IPGC; X, Y: Integer): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseDown2             = function {$else}function  rasMouseDown2{$endif}(CachePtr: IPGC; X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseDown3             = function {$else}function  rasMouseDown3{$endif}(CachePtr: IPGC; PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseMove              = function {$else}function  rasMouseMove{$endif}(CachePtr: IPGC; hWnd: HWND; LeftBtnDown: LongBool; var ScrollX, ScrollY: Integer; X, Y: Integer): TUpdScrollbar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseMove2             = function {$else}function  rasMouseMove2{$endif}(CachePtr: IPGC; hWnd: HWND; Keys: TPDFMouseKeys; var ScrollX, ScrollY: Integer; X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseMove3             = function {$else}function  rasMouseMove3{$endif}(CachePtr: IPGC; Keys: TPDFMouseKeys; PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseUp                = function {$else}function  rasMouseUp{$endif}(CachePtr: IPGC; X, Y: Integer): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseUp2               = function {$else}function  rasMouseUp2{$endif}(CachePtr: IPGC; X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMouseUp3               = function {$else}function  rasMouseUp3{$endif}(CachePtr: IPGC; PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasMovePage               = function {$else}function  rasMovePage{$endif}(CachePtr: IPGC; Source, Dest: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasPaint                  = function {$else}function  rasPaint{$endif}(CachePtr: IPGC; DC: HDC; var ScrollX, ScrollY: Integer): TUpdScrollbar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasPixToPDF               = function {$else}function  rasPixToPDF{$endif}(CachePtr: IPGC; X, Y: Integer; var OutX, OutY: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasProcessErrors          = function {$else}function  rasProcessErrors{$endif}(CachePtr: IPGC): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasRenderTile             = function {$else}function  rasRenderTile{$endif}(CachePtr: IPGC; PageNum, PageW, PageH, NRows, NCols: Cardinal; var Tile: TPDFTile): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasResetMousePos          = procedure{$else}procedure rasResetMousePos{$endif}(CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasResize                 = function {$else}function  rasResize{$endif}(CachePtr: IPGC; Width, Height: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasResizeViewport         = procedure{$else}procedure rasResizeViewport{$endif}(CachePtr: IPGC; Width, Height: Single); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasScroll                 = function {$else}function  rasScroll{$endif}(CachePtr: IPGC; Vertical: LongBool; ScrollCode: Integer; var ScrollX, ScrollY: Integer): TUpdScrollbar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSelectAll              = procedure{$else}procedure rasSelectAll{$endif}(CachePtr: IPGC; ObjTypes: TSelectObjType); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSelectAnnotOrField     = function {$else}function  rasSelectAnnotOrField{$endif}(CachePtr: IPGC; Handle: Cardinal; IsField: LongBool; SelColor: Cardinal; var NewX, NewY, NewZoom: Single; var NewPageScale: TPDFPageScale): TUpdBmkAction; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSelectObject           = function {$else}function  rasSelectObject{$endif}(CachePtr: IPGC; Down: LongBool; X, Y: Integer; SelColor: Cardinal; Info: PPDFObjectInfo): TSelObjAction; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSelectObjectV3         = function {$else}function  rasSelectObjectV3{$endif}(CachePtr: IPGC; PageNum: Cardinal; Down: LongBool; X, Y: Integer; Info: PPDFObjectInfo): TSelObjAction; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetBaseControlSize     = procedure{$else}procedure rasSetBaseControlSize{$endif}(CachePtr: IPGC; Width, Height: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetClientRect          = procedure{$else}procedure rasSetClientRect{$endif}(CachePtr: IPGC; DC: HDC; var ClientRect: TIntRect); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetCMapDirA            = function {$else}function  rasSetCMapDirA{$endif}(CachePtr: IPGC; const Path: PAnsiChar; Flags: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetCMapDirW            = function {$else}function  rasSetCMapDirW{$endif}(CachePtr: IPGC; const Path: PWideChar; Flags: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetDefPageLayout       = procedure{$else}procedure rasSetDefPageLayout{$endif}(CachePtr: IPGC; Value: TPageLayout); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetMinLineWidth        = function {$else}function  rasSetMinLineWidth{$endif}(CachePtr: IPGC; Value: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetOCGState            = function {$else}function  rasSetOCGState{$endif}(CachePtr: IPGC; Handle: Cardinal; Visible, SaveState: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetOnPaintCallback     = procedure{$else}procedure rasSetOnPaintCallback{$endif}(CachePtr: IPGC; const UserData: Pointer; Callback: TOnUpdateWindow); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetOption              = function {$else}function  rasSetOption{$endif}(CachePtr: IPGC; Option: TPageCacheOptions; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetPageLayout          = procedure{$else}procedure rasSetPageLayout{$endif}(CachePtr: IPGC; Value: TPageLayout); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetPageScale           = procedure{$else}procedure rasSetPageScale{$endif}(CachePtr: IPGC; Value: TPDFPageScale); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetRotate              = procedure{$else}procedure rasSetRotate{$endif}(CachePtr: IPGC; Value: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetScrollLineDelta     = function {$else}function  rasSetScrollLineDelta{$endif}(CachePtr: IPGC; Vertical: LongBool; Value: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetSelectionMode       = procedure{$else}procedure rasSetSelectionMode{$endif}(CachePtr: IPGC; Value: TSelectObjType); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetThreadPriority      = procedure{$else}procedure rasSetThreadPriority{$endif}(CachePtr: IPGC; UpdateThread, RenderThread: TPDFThreadPriority); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasSetWindowHandle        = procedure{$else}procedure rasSetWindowHandle{$endif}(CachePtr: IPGC; hWnd: HWND); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasUnLock                 = procedure{$else}procedure rasUnLock{$endif}(CachePtr: IPGC); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasUpdate                 = procedure{$else}procedure rasUpdate{$endif}(CachePtr: IPGC; PageNum: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}rasZoom                   = function {$else}function  rasZoom{$endif}(CachePtr: IPGC; Value: Single; var HorzPos, VertPos: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}

   { ------------------------------------------------- Table API ------------------------------------------------ }

   type ITBL = Pointer;

   type TCellContType =
   (
      cctText,
      cctImage,
      cctTable,
      cctTemplate,
      cctAction
   );

   type TDeleteContent = Integer;
   const  
      dcText       = $00000001; // Text is always a foreground object
      dcImage      = $00000002;
      dcTemplate   = $00000004; // PDF or EMF objects
      dcTable      = $00000008;
      dcAction     = $00000010; // A cell action is always a background object
      dcAllCont    = $0000001F; // Delete all content types
      dcForeGround = $10000000;
      dcBackGround = $20000000;
      dcBoth       = $30000000; // Delete both foreground and background objects

{$if defined(DELPHI6_OR_HIGHER) and not defined(FPC)}
   type TCellAlign =
   (
      coLeft,
      coTop    = coLeft,
      coRight,
      coBottom = coRight,
      coCenter
   );
{$else}
   type TCellAlign = Integer;
   const
      coLeft   = $00000000;
      coTop    = $00000000;
      coRight  = $00000001;
      coBottom = $00000001;
      coCenter = $00000002;
{$ifend}
   
   type TCellSide =
   (
      csLeft,
      csBottom,
      csRight,
      csTop
   );
   
   type TColumnAdjust =
   (
      coaUniqueWidth, // Set the column widths uniquely to TableWidth / NumColumns
      coaAdjLeft,     // Decrease or increase the column widths starting from the left side
      coaAdjRight     // Decrease or increase the column widths starting from the right side
   );
      
   type TTableColor =
   (
      tcBackColor,     // Table, Columns, Rows, Cells -> default none (transparent)
      tcBorderColor,   // Table, Columns, Rows, Cells -> default black
      tcGridHorzColor, // Table                       -> default black
      tcGridVertColor, // Table                       -> default black
      tcImageColor,    // Table, Columns, Rows, Cells -> default RGB black
      tcTextColor      // Table, Columns, Rows, Cells -> default black
   );

   type TTableBoxProperty =
   (
      tbpBorderWidth, // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
      tbpCellSpacing, // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
      tbpCellPadding  // Table, Columns, Rows, Cells -> default (0, 0, 0, 0)
   );

   type TTableFlags = Integer;
   const
      tfDefault         = 0;
      tfStatic          = 1;  // This flag marks a row, column, or cell as static to avoid the deletion of the content with ClearContent().
      tfHeaderRow       = 2;  // Header rows are drawn first after a page break occurred
      tfNoLineBreak     = 4;  // Prohibit line breaks in cells whith text -> Can be set to the entire table, columns, rows, and cells
      tfScaleToRect     = 8;  // If set, the specified output width and height represents the maximum size of the image or template.
                              // The image or template is scaled into this rectangle without changing the aspect ratio.
      tfUseImageCS      = 16; // If set, images are inserted in the native image color space.
      tfAddFlags        = 32; // If set, the new flags are added to the current ones. If absent, the new flags override the previous value.
      tfFixedTextHeight = 64; // If set, text does not increase the row height if necessary. The row height must be non-zero.

{$ifdef DYNLNK}
type
{$endif}
   {$ifdef DYNLNK}tblAddColumn          = function {$else}function  tblAddColumn{$endif}(const Table: ITBL; Left: LongBool; Width: Single): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblAddRow             = function {$else}function  tblAddRow{$endif}(const Table: ITBL; Height: Single): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblAddRows            = function {$else}function  tblAddRows{$endif}(const Table: ITBL; Count: Cardinal; Height: Single): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblClearColumn        = procedure{$else}procedure tblClearColumn{$endif}(const Table: ITBL; Col: Cardinal; Types: TDeleteContent); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblClearContent       = procedure{$else}procedure tblClearContent{$endif}(const Table: ITBL; Types: TDeleteContent); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblClearRow           = procedure{$else}procedure tblClearRow{$endif}(const Table: ITBL; Row: Cardinal; Types: TDeleteContent); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblCreateTable        = function {$else}function  tblCreateTable{$endif}(const IPDF: PPDF; AllocRows, NumCols: Cardinal; Width, DefRowHeight: Single): ITBL; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblDeleteCol          = procedure{$else}procedure tblDeleteCol{$endif}(const Table: ITBL; Col: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblDeleteRow          = procedure{$else}procedure tblDeleteRow{$endif}(const Table: ITBL; Row: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblDeleteRows         = procedure{$else}procedure tblDeleteRows{$endif}(const Table: ITBL); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblDeleteTable        = procedure{$else}procedure tblDeleteTable{$endif}(var Table: ITBL); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblDrawTable          = function {$else}function  tblDrawTable{$endif}(const Table: ITBL; x, y, MaxHeight: Single): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetFirstRow        = function {$else}function  tblGetFirstRow{$endif}(const Table: ITBL): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetFlags           = function {$else}function  tblGetFlags{$endif}(const Table: ITBL; Row, Col: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetNextHeight      = function {$else}function  tblGetNextHeight{$endif}(const Table: ITBL; MaxHeight: Single; NextRow: PInteger): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetNextRow         = function {$else}function  tblGetNextRow{$endif}(const Table: ITBL): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetNumCols         = function {$else}function  tblGetNumCols{$endif}(const Table: ITBL): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetNumRows         = function {$else}function  tblGetNumRows{$endif}(const Table: ITBL): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetTableHeight     = function {$else}function  tblGetTableHeight{$endif}(const Table: ITBL): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblGetTableWidth      = function {$else}function  tblGetTableWidth{$endif}(const Table: ITBL): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblHaveMore           = function {$else}function  tblHaveMore{$endif}(const Table: ITBL): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetBoxProperty     = function {$else}function  tblSetBoxProperty{$endif}(const Table: ITBL; Row, Col: Integer; PropType: TTableBoxProperty; Left, Right, Top, Bottom: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellAction      = function {$else}function  tblSetCellAction{$endif}(const Table: ITBL; Row, Col: Integer; ActionHandle: Cardinal; Mode: THighlightMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellDashPattern = function {$else}function  tblSetCellDashPattern{$endif}(const Table: ITBL; Row, Col: Integer; Side: TCellSide; Style: TLineCapStyle; const Dash: PSingle; NumValues: Cardinal; Phase: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellImageA      = function {$else}function  tblSetCellImageA{$endif}(const Table: ITBL; Row, Col: Integer; ForeGround: LongBool; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: PAnsiChar; Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellImageW      = function {$else}function  tblSetCellImageW{$endif}(const Table: ITBL; Row, Col: Integer; ForeGround: LongBool; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: PWideChar; Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellImageEx     = function {$else}function  tblSetCellImageEx{$endif}(const Table: ITBL; Row, Col: Integer; ForeGround: LongBool; HAlign, VAlign: TCellAlign; Width, Height: Single; const Buffer: Pointer; BufSize, Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellOrientation = function {$else}function  tblSetCellOrientation{$endif}(const Table: ITBL; Row, Col, Orientation: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellTable       = function {$else}function  tblSetCellTable{$endif}(const Table: ITBL; Row, Col: Cardinal; HAlign, VAlign: TCellAlign; const SubTable: ITBL): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellTemplate    = function {$else}function  tblSetCellTemplate{$endif}(const Table: ITBL; Row, Col: Integer; ForeGround: LongBool; HAlign, VAlign: TCellAlign; TmplHandle: Cardinal; Width, Height: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellTextA       = function {$else}function  tblSetCellTextA{$endif}(const Table: ITBL; Row, Col, HAlign: TTextAlign; VAlign: TCellAlign; const Text: PAnsiChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetCellTextW       = function {$else}function  tblSetCellTextW{$endif}(const Table: ITBL; Row, Col, HAlign: TTextAlign; VAlign: TCellAlign; const Text: PWideChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetColor           = function {$else}function  tblSetColor{$endif}(const Table: ITBL; Row, Col: Integer; ClrType: TTableColor; CS: TPDFColorSpace; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetColorEx         = function {$else}function  tblSetColorEx{$endif}(const Table: ITBL; Row, Col: Integer; ClrType: TTableColor; Color: PSingle; NumComps: Cardinal; CS: TExtColorSpace; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetColWidth        = function {$else}function  tblSetColWidth{$endif}(const Table: ITBL; Col: Cardinal; Width: Single; ExtTable: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetFlags           = function {$else}function  tblSetFlags{$endif}(const Table: ITBL; Row, Col: Integer; Flags: TTableFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetFontA           = function {$else}function  tblSetFontA{$endif}(const Table: ITBL; Row, Col: Integer; const Name: PAnsiChar; Style: TFStyle; Embed: LongBool; CP: TCodepage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetFontW           = function {$else}function  tblSetFontW{$endif}(const Table: ITBL; Row, Col: Integer; const Name: PWideChar; Style: TFStyle; Embed: LongBool; CP: TCodepage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetFontSelMode     = function {$else}function  tblSetFontSelMode{$endif}(const Table: ITBL; Row, Col: Integer; Mode: TFontSelMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetFontSize        = function {$else}function  tblSetFontSize{$endif}(const Table: ITBL; Row, Col: Integer; Value: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetGridWidth       = function {$else}function  tblSetGridWidth{$endif}(const Table: ITBL; Horz, Vert: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetRowHeight       = function {$else}function  tblSetRowHeight{$endif}(const Table: ITBL; Row: Integer; Value: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}tblSetTableWidth      = procedure{$else}procedure tblSetTableWidth{$endif}(const Table: ITBL; Value: Single; AdjustType: TColumnAdjust; MinColWidth: Single); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}

   { ------------------------------------------------ DynaPDF API ----------------------------------------------- }

   {$ifdef DYNLNK}pdfActivateAltFontList        = function {$else}function  pdfActivateAltFontList{$endif}(const IPDF: PPDF; Handle: Integer; EnableSysFonts: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddActionToObj             = function {$else}function  pdfAddActionToObj{$endif}(const IPDF: PPDF; ObjType, Event: Integer; ActHandle, ObjHandle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddAnnotToPage             = function {$else}function  pdfAddAnnotToPage{$endif}(const IPDF: PPDF; PageNum, Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddArticle                 = function {$else}function  pdfAddArticle{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkA               = function {$else}function  pdfAddBookmarkA{$endif}(const IPDF: PPDF; const Title: PAnsiChar; Parent: Integer; DestPage: Cardinal; Open: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkW               = function {$else}function  pdfAddBookmarkW{$endif}(const IPDF: PPDF; const Title: PWideChar; Parent: Integer; DestPage: Cardinal; Open: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkExA             = function {$else}function  pdfAddBookmarkExA{$endif}(const IPDF: PPDF; const Title: PAnsiChar; Parent: Integer; NamedDest: Cardinal; Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkExW             = function {$else}function  pdfAddBookmarkExW{$endif}(const IPDF: PPDF; const Title: PWideChar; Parent: Integer; NamedDest: Cardinal; Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkEx2A            = function {$else}function  pdfAddBookmarkEx2A{$endif}(const IPDF: PPDF; const Title: PAnsiChar; Parent: Integer; const NamedDest: Pointer; Unicode, Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddBookmarkEx2W            = function {$else}function  pdfAddBookmarkEx2W{$endif}(const IPDF: PPDF; const Title: PWideChar; Parent: Integer; const NamedDest: Pointer; Unicode, Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddButtonImageA            = function {$else}function  pdfAddButtonImageA{$endif}(const IPDF: PPDF; BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddButtonImageW            = function {$else}function  pdfAddButtonImageW{$endif}(const IPDF: PPDF; BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddButtonImageEx           = function {$else}function  pdfAddButtonImageEx{$endif}(const IPDF: PPDF; BtnHandle: Cardinal; State: TButtonState; const Caption: PAnsiChar; Handle: Pointer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddButtonImageEx2          = function {$else}function  pdfAddButtonImageEx2{$endif}(const IPDF: PPDF; BtnHandle: Cardinal; State: TButtonState; const Caption: PWideChar; const Buffer: Pointer; BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddContinueTextA           = function {$else}function  pdfAddContinueTextA{$endif}(const IPDF: PPDF; const AText: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddContinueTextW           = function {$else}function  pdfAddContinueTextW{$endif}(const IPDF: PPDF; const AText: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddDeviceNProcessColorants = function {$else}function  pdfAddDeviceNProcessColorants{$endif}(const IPDF: PPDF; DeviceNCS: Cardinal; const Colorants: PPAnsiChar; NumColorants: Cardinal; ProcessCS: TExtColorSpace; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddDeviceNSeparations      = function {$else}function  pdfAddDeviceNSeparations{$endif}(const IPDF: PPDF; DeviceNCS: Cardinal; const Colorants: PPAnsiChar; SeparationCS: PInteger; NumColorants: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddDPartNode               = function {$else}function  pdfAddDPartNode{$endif}(const IPDF: PPDF; Parent, FirstPage, LastPage: Integer; const DPM: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFieldToFormAction       = function {$else}function  pdfAddFieldToFormAction{$endif}(const IPDF: PPDF; Action, AField: Cardinal; Include: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFieldToHideAction       = function {$else}function  pdfAddFieldToHideAction{$endif}(const IPDF: PPDF; HideAct, AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFileCommentA            = function {$else}function  pdfAddFileCommentA{$endif}(const IPDF: PPDF; const AText: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFileCommentW            = function {$else}function  pdfAddFileCommentW{$endif}(const IPDF: PPDF; const AText: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFontSearchPathA         = function {$else}function  pdfAddFontSearchPathA{$endif}(const IPDF: PPDF; const APath: PAnsiChar; Recursive: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddFontSearchPathW         = function {$else}function  pdfAddFontSearchPathW{$endif}(const IPDF: PPDF; const APath: PWideChar; Recursive: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddHeaderFooter            = function {$else}function  pdfAddHeaderFooter{$endif}(const IPDF: PPDF; var Value: TPDFHeaderFooter; HFArray: PPDFHdrFtr; Count: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddImage                   = function {$else}function  pdfAddImage{$endif}(const IPDF: PPDF; Filter: TCompressionFilter; Flags: Cardinal; var Image: TPDFImage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddInkList                 = function {$else}function  pdfAddInkList{$endif}(const IPDF: PPDF; InkAnnot: Cardinal; Points: PFltPoint; NumPoints: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddJavaScriptA             = function {$else}function  pdfAddJavaScriptA{$endif}(const IPDF: PPDF; const Name, Script: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddJavaScriptW             = function {$else}function  pdfAddJavaScriptW{$endif}(const IPDF: PPDF; const Name: PAnsiChar; const Script: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddLayerToDisplTreeA       = function {$else}function  pdfAddLayerToDisplTreeA{$endif}(const IPDF: PPDF; Parent: Pointer; Layer: Integer; const Title: PAnsiChar): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddLayerToDisplTreeW       = function {$else}function  pdfAddLayerToDisplTreeW{$endif}(const IPDF: PPDF; Parent: Pointer; Layer: Integer; const Title: PWideChar): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddMaskImage               = function {$else}function  pdfAddMaskImage{$endif}(const IPDF: PPDF; BaseImage: Cardinal; const Buffer: Pointer; BufSize: Cardinal; Stride: Integer; BitsPerPixel, Width, Height: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddObjectToLayer           = function {$else}function  pdfAddObjectToLayer{$endif}(const IPDF: PPDF; OCG: Cardinal; ObjType: TOCObject; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddOCGToAppEvent           = function {$else}function  pdfAddOCGToAppEvent{$endif}(const IPDF: PPDF; Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddOutputIntentA           = function {$else}function  pdfAddOutputIntentA{$endif}(const IPDF: PPDF; const ICCFile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddOutputIntentW           = function {$else}function  pdfAddOutputIntentW{$endif}(const IPDF: PPDF; const ICCFile: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddOutputIntentEx          = function {$else}function  pdfAddOutputIntentEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddPageLabelA              = function {$else}function  pdfAddPageLabelA{$endif}(const IPDF: PPDF; StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: PAnsiChar; AddNum: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddPageLabelW              = function {$else}function  pdfAddPageLabelW{$endif}(const IPDF: PPDF; StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: PWideChar; AddNum: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddRasImage                = function {$else}function  pdfAddRasImage{$endif}(const IPDF: PPDF; RasPtr: IRAS; Filter: TCompressionFilter): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddValToChoiceFieldA       = function {$else}function  pdfAddValToChoiceFieldA{$endif}(const IPDF: PPDF; Field: Cardinal; const ExpValue, Value: PAnsiChar; Selected: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAddValToChoiceFieldW       = function {$else}function  pdfAddValToChoiceFieldW{$endif}(const IPDF: PPDF; Field: Cardinal; const ExpValue: PAnsiChar; const Value: PWideChar; Selected: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAppend                     = function {$else}function  pdfAppend{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfApplyAppEvent              = function {$else}function  pdfApplyAppEvent{$endif}(const IPDF: PPDF; Event: TOCAppEvent; SaveResult: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfApplyPattern               = function {$else}function  pdfApplyPattern{$endif}(const IPDF: PPDF; PattHandle: Integer; ColorMode: TColorMode; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfApplyShading               = function {$else}function  pdfApplyShading{$endif}(const IPDF: PPDF; ShadHandle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAssociateEmbFile           = function {$else}function  pdfAssociateEmbFile{$endif}(const IPDF: PPDF; DestObject: TAFDestObject; DestHandle: Integer; Relationship: TAFRelationship; EmbFile: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAttachFileA                = function {$else}function  pdfAttachFileA{$endif}(const IPDF: PPDF; const FilePath, Description: PAnsiChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAttachFileW                = function {$else}function  pdfAttachFileW{$endif}(const IPDF: PPDF; const FilePath, Description: PWideChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAttachFileExA              = function {$else}function  pdfAttachFileExA{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: PAnsiChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAttachFileExW              = function {$else}function  pdfAttachFileExW{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: PWideChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfAutoTemplate               = function {$else}function  pdfAutoTemplate{$endif}(const IPDF: PPDF; Templ: Cardinal; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginClipPath              = function {$else}function  pdfBeginClipPath{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginContinueText          = function {$else}function  pdfBeginContinueText{$endif}(const IPDF: PPDF; PosX, PosY: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginLayer                 = function {$else}function  pdfBeginLayer{$endif}(const IPDF: PPDF; OCG: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginPageTemplate          = function {$else}function  pdfBeginPageTemplate{$endif}(const IPDF: PPDF; const Name: PAnsiChar; UseAutoTemplates: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginPattern               = function {$else}function  pdfBeginPattern{$endif}(const IPDF: PPDF; PatternType: TPatternType; TilingType: TTilingType; Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginTemplate              = function {$else}function  pdfBeginTemplate{$endif}(const IPDF: PPDF; Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginTemplateEx            = function {$else}function  pdfBeginTemplateEx{$endif}(const IPDF: PPDF; var BBox: TPDFRect; var Matrix: TCTM): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBeginTransparencyGroup     = function {$else}function  pdfBeginTransparencyGroup{$endif}(const IPDF: PPDF; x1, y1, x2, y2: Double; Isolated, Knockout: LongBool; CS: TExtColorSpace; CSHandle: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBezier_1_2_3               = function {$else}function  pdfBezier_1_2_3{$endif}(const IPDF: PPDF; x1, y1, x2, y2, x3, y3: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBezier_1_3                 = function {$else}function  pdfBezier_1_3{$endif}(const IPDF: PPDF; x1, y1, x3, y3: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfBezier_2_3                 = function {$else}function  pdfBezier_2_3{$endif}(const IPDF: PPDF; x2, y2, x3, y3: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCalcWidthHeight            = function {$else}function  pdfCalcWidthHeight{$endif}(const IPDF: PPDF; OrgWidth, OrgHeight, ScaledWidth, ScaledHeight: Double): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCaretAnnotA                = function {$else}function  pdfCaretAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCaretAnnotW                = function {$else}function  pdfCaretAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeAnnotNameA           = function {$else}function  pdfChangeAnnotNameA{$endif}(const IPDF: PPDF; Handle: Cardinal; const Name: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeAnnotNameW           = function {$else}function  pdfChangeAnnotNameW{$endif}(const IPDF: PPDF; Handle: Cardinal; const Name: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeAnnotPos             = function {$else}function  pdfChangeAnnotPos{$endif}(const IPDF: PPDF; Handle: Cardinal; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeBookmarkA            = function {$else}function  pdfChangeBookmarkA{$endif}(const IPDF: PPDF; ABmk: Integer; const Title: PAnsiChar; Parent: Integer; DestPage: Cardinal; Open: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeBookmarkW            = function {$else}function  pdfChangeBookmarkW{$endif}(const IPDF: PPDF; ABmk: Integer; const Title: PWideChar; Parent: Integer; DestPage: Cardinal; Open: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeFont                 = function {$else}function  pdfChangeFont{$endif}(const IPDF: PPDF; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeFontEx               = function {$else}function  pdfChangeFontEx{$endif}(const IPDF: PPDF; Handle: Integer; FontSize: Double; Style: TFStyle): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeFontSize             = function {$else}function  pdfChangeFontSize{$endif}(const IPDF: PPDF; Size: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeFontStyle            = function {$else}function  pdfChangeFontStyle{$endif}(const IPDF: PPDF; Style: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeFontStyleEx          = function {$else}function  pdfChangeFontStyleEx{$endif}(const IPDF: PPDF; Style: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptA          = function {$else}function  pdfChangeJavaScriptA{$endif}(const IPDF: PPDF; Handle: Cardinal; const NewScript: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptW          = function {$else}function  pdfChangeJavaScriptW{$endif}(const IPDF: PPDF; Handle: Cardinal; const NewScript: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptActionA    = function {$else}function  pdfChangeJavaScriptActionA{$endif}(const IPDF: PPDF; Handle: Cardinal; const NewScript: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptActionW    = function {$else}function  pdfChangeJavaScriptActionW{$endif}(const IPDF: PPDF; Handle: Cardinal; const NewScript: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptNameA      = function {$else}function  pdfChangeJavaScriptNameA{$endif}(const IPDF: PPDF; Handle: Cardinal; const Name: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeJavaScriptNameW      = function {$else}function  pdfChangeJavaScriptNameW{$endif}(const IPDF: PPDF; Handle: Cardinal; const Name: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeLinkAnnot            = function {$else}function  pdfChangeLinkAnnot{$endif}(const IPDF: PPDF; Handle: Cardinal; const URL: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeNamedDestA           = function {$else}function  pdfChangeNamedDestA{$endif}(const IPDF: Pointer; ObjType: TObjType; Handle: Cardinal; const NewDestName: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeNamedDestW           = function {$else}function  pdfChangeNamedDestW{$endif}(const IPDF: Pointer; ObjType: TObjType; Handle: Cardinal; const NewDestName: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeOCGNameA             = function {$else}function  pdfChangeOCGNameA{$endif}(const IPDF: PPDF; Handle: Cardinal; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeOCGNameW             = function {$else}function  pdfChangeOCGNameW{$endif}(const IPDF: PPDF; Handle: Cardinal; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfChangeSeparationColor      = function {$else}function  pdfChangeSeparationColor{$endif}(const IPDF: PPDF; CSHandle, NewColor: Cardinal; Alternate: TExtColorSpace; AltHandle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCheckCollection            = function {$else}function  pdfCheckCollection{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCheckConformance           = function {$else}function  pdfCheckConformance{$endif}(const IPDF: PPDF; ConfType: Integer; Options: Cardinal; const UserData: Pointer; OnFontNotFound: TOnFontNotFoundProc; OnReplaceICCProfile: TOnReplaceICCProfile): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCheckFieldNames            = function {$else}function  pdfCheckFieldNames{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCircleAnnotA               = function {$else}function  pdfCircleAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCircleAnnotW               = function {$else}function  pdfCircleAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfClearAutoTemplates         = function {$else}function  pdfClearAutoTemplates{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfClearErrorLog              = procedure{$else}procedure pdfClearErrorLog{$endif}(const IPDF: PPDF); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfClearHostFonts             = function {$else}function  pdfClearHostFonts{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfClipPath                   = function {$else}function  pdfClipPath{$endif}(const IPDF: PPDF; ClipMode: TClippingMode; FillMode: TPathFillMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseAndSignFile           = function {$else}function  pdfCloseAndSignFile{$endif}(const IPDF: PPDF; const CertFile, Password, Reason, Location: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseAndSignFileEx         = function {$else}function  pdfCloseAndSignFileEx{$endif}(const IPDF: PPDF; const OpenPwd, OwnerPwd: PAnsiChar; KeyLen, Restrict: Integer; const CertFile, Password, Reason, Location: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseAndSignFileExt        = function {$else}function  pdfCloseAndSignFileExt{$endif}(const IPDF: PPDF; var SigParms: TPDFSigParms): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseFile                  = function {$else}function  pdfCloseFile{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseFileEx                = function {$else}function  pdfCloseFileEx{$endif}(const IPDF: PPDF; const OpenPwd, OwnerPwd: PAnsiChar; KeyLen, Restrict: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseImage                 = function {$else}function  pdfCloseImage{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseImportFile            = function {$else}function  pdfCloseImportFile{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseImportFileEx          = function {$else}function  pdfCloseImportFileEx{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfClosePath                  = function {$else}function  pdfClosePath{$endif}(const IPDF: PPDF; FillMode: TPathFillMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCloseTag                   = function {$else}function  pdfCloseTag{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfComputeBBox                = function {$else}function  pdfComputeBBox{$endif}(const IPDF: PPDF; var BBox: TPDFRect; Flags: TCompBBoxFlags): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvColor                  = function {$else}function  pdfConvColor{$endif}(const Color: PDouble; NumComps: Cardinal; SourceCS: Integer; const IColorSpace: Pointer; DestCS: Integer): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvertColors              = function {$else}function  pdfConvertColors{$endif}(const IPDF: PPDF; Flags: TColorConvFlags; Add: PSingle): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvertEMFSpoolA           = function {$else}function  pdfConvertEMFSpoolA{$endif}(const IPDF: PPDF; const SpoolFile: PAnsiChar; LeftMargin, TopMargin: Double; Flags: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvertEMFSpoolW           = function {$else}function  pdfConvertEMFSpoolW{$endif}(const IPDF: PPDF; const SpoolFile: PWideChar; LeftMargin, TopMargin: Double; Flags: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvToFreeTextCallout      = function {$else}function  pdfConvToFreeTextCallout{$endif}(const IPDF: PPDF; Handle: Cardinal; StartX, StartY, KneeOffset: Single; EndStyle: TLineEndStyle): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfConvToUnicode              = function {$else}function  pdfConvToUnicode{$endif}(const IPDF: PPDF; const AString: PAnsiChar; CP: Integer): PWideChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCopyChoiceValues           = function {$else}function  pdfCopyChoiceValues{$endif}(const IPDF: PPDF; Source, Dest: Cardinal; Share: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DAnnotA             = function {$else}function  pdfCreate3DAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DAnnotW             = function {$else}function  pdfCreate3DAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DBackground         = function {$else}function  pdfCreate3DBackground{$endif}(const IPDF: PPDF; const IView: Pointer; BackColor: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DGotoViewAction     = function {$else}function  pdfCreate3DGotoViewAction{$endif}(const IPDF: PPDF; Base3DAnnot: Cardinal; const IView: Pointer; Named: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DProjection         = function {$else}function  pdfCreate3DProjection{$endif}(const IPDF: PPDF; const IView: Pointer; ProjType, ScaleType: Integer; Diameter, FOV: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreate3DViewW              = function {$else}function  pdfCreate3DViewW{$endif}(const IPDF: PPDF; Base3DAnnot: Cardinal; const Name: PWideChar; SetAsDefault: LongBool; const Matrix: PDouble; CamDistance: Double; RM: T3DRenderingMode; LS: T3DLightingSheme): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateAltFontList          = function {$else}function  pdfCreateAltFontList{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateAnnotAP              = function {$else}function  pdfCreateAnnotAP{$endif}(const IPDF: PPDF; Annot: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateArticleThreadA       = function {$else}function  pdfCreateArticleThreadA{$endif}(const IPDF: PPDF; const ThreadName: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateArticleThreadW       = function {$else}function  pdfCreateArticleThreadW{$endif}(const IPDF: PPDF; const ThreadName: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateAxialShading         = function {$else}function  pdfCreateAxialShading{$endif}(const IPDF: PPDF; sX, sY, eX, eY, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateBarcodeField         = function {$else}function  pdfCreateBarcodeField{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Parent: Integer; PosX, PosY, Width, Height: Double; var Barcode: TPDFBarcode): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateButtonA              = function {$else}function  pdfCreateButtonA{$endif}(const IPDF: PPDF; const Name, Caption: PAnsiChar; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateButtonW              = function {$else}function  pdfCreateButtonW{$endif}(const IPDF: PPDF; const Name: PAnsiChar; const Caption: PWideChar; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateCheckBox             = function {$else}function  pdfCreateCheckBox{$endif}(const IPDF: PPDF; const Name, ExpValue: PAnsiChar; Checked, Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateCIEColorSpace        = function {$else}function  pdfCreateCIEColorSpace{$endif}(const IPDF: PPDF; Base: TExtColorSpace; WhitePoint, BlackPoint, Gamma, Matrix: PSingle): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateCollection           = function {$else}function  pdfCreateCollection{$endif}(const IPDF: PPDF; View: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateCollectionFieldA     = function {$else}function  pdfCreateCollectionFieldA{$endif}(const IPDF: PPDF; ColType, Column: Integer; const Name, Key: PAnsiChar; Visible, Editable: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateCollectionFieldW     = function {$else}function  pdfCreateCollectionFieldW{$endif}(const IPDF: PPDF; ColType, Column: Integer; const Name: PWideChar; const Key: PAnsiChar; Visible, Editable: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateColItemDate          = function {$else}function  pdfCreateColItemDate{$endif}(const IPDF: PPDF; EmbFile: Cardinal; const Key: PAnsiChar; Date: LongInt; const Prefix: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateColItemNumber        = function {$else}function  pdfCreateColItemNumber{$endif}(const IPDF: PPDF; EmbFile: Cardinal; const Key: PAnsiChar; Value: Double; const Prefix: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateColItemStringA       = function {$else}function  pdfCreateColItemStringA{$endif}(const IPDF: PPDF; EmbFile: Cardinal; const Key, Value, Prefix: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateColItemStringW       = function {$else}function  pdfCreateColItemStringW{$endif}(const IPDF: PPDF; EmbFile: Cardinal; const Key: PAnsiChar; const Value, Prefix: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateComboBox             = function {$else}function  pdfCreateComboBox{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Sort, Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateDeviceNColorSpace    = function {$else}function  pdfCreateDeviceNColorSpace{$endif}(const IPDF: PPDF; const Colorants: PPAnsiChar; NumColorants: Cardinal; const PostScriptFunc: PAnsiChar; Alternate: TExtColorSpace; Handle: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateDPartRoot            = function {$else}function  pdfCreateDPartRoot{$endif}(const IPDF: PPDF; const NodeNameList: PPAnsiChar; NodeNamesCount: Cardinal; RecordLevel: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateExtGState            = function {$else}function  pdfCreateExtGState{$endif}(const IPDF: PPDF; var GS: TPDFExtGState): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGeospatialMeasure    = function {$else}function  pdfCreateGeospatialMeasure{$endif}(const IPDF: PPDF; Viewport: Cardinal; const Attributes: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToAction           = function {$else}function  pdfCreateGoToAction{$endif}(const IPDF: PPDF; DestType: TDestType; PageNum: Cardinal; a, b, c, d: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToActionEx         = function {$else}function  pdfCreateGoToActionEx{$endif}(const IPDF: PPDF; NamedDest: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToEActionA         = function {$else}function  pdfCreateGoToEActionA{$endif}(const IPDF: PPDF; Location: TEmbFileLocation; const Source: PAnsiChar; SrcPage: Cardinal; const Target, DestName: PAnsiChar; DestPage: Cardinal; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToEActionW         = function {$else}function  pdfCreateGoToEActionW{$endif}(const IPDF: PPDF; Location: TEmbFileLocation; const Source: PWideChar; SrcPage: Cardinal; const Target, DestName: PWideChar; DestPage: Cardinal; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRAction          = function {$else}function  pdfCreateGoToRAction{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRActionW         = function {$else}function  pdfCreateGoToRActionW{$endif}(const IPDF: PPDF; const FileName: PWideChar; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRActionExA       = function {$else}function  pdfCreateGoToRActionExA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; DestName: PAnsiChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRActionExW       = function {$else}function  pdfCreateGoToRActionExW{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; DestName: PWideChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRActionExUA      = function {$else}function  pdfCreateGoToRActionExUA{$endif}(const IPDF: PPDF; const FileName: PWideChar; DestName: PAnsiChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGoToRActionExUW      = function {$else}function  pdfCreateGoToRActionExUW{$endif}(const IPDF: PPDF; const FileName: PWideChar; DestName: PWideChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateGroupField           = function {$else}function  pdfCreateGroupField{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Parent: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateHideAction           = function {$else}function  pdfCreateHideAction{$endif}(const IPDF: PPDF; AField: Cardinal; Hide: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateICCBasedColorSpaceA  = function {$else}function  pdfCreateICCBasedColorSpaceA{$endif}(const IPDF: PPDF; const ICCProfile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateICCBasedColorSpaceW  = function {$else}function  pdfCreateICCBasedColorSpaceW{$endif}(const IPDF: PPDF; const ICCProfile: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateICCBasedColorSpaceEx = function {$else}function  pdfCreateICCBasedColorSpaceEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateImageA               = function {$else}function  pdfCreateImageA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateImageW               = function {$else}function  pdfCreateImageW{$endif}(const IPDF: PPDF; const FileName: PWideChar; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateImpDataActionA       = function {$else}function  pdfCreateImpDataActionA{$endif}(const IPDF: PPDF; const DataFile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateImpDataActionW       = function {$else}function  pdfCreateImpDataActionW{$endif}(const IPDF: PPDF; const DataFile: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateIndexedColorSpace    = function {$else}function  pdfCreateIndexedColorSpace{$endif}(const IPDF: PPDF; Base, Handle: Integer; const ColorTable: Pointer; NumColors: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateJSActionA            = function {$else}function  pdfCreateJSActionA{$endif}(const IPDF: PPDF; const Script: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateJSActionW            = function {$else}function  pdfCreateJSActionW{$endif}(const IPDF: PPDF; const Script: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateLaunchAction         = function {$else}function  pdfCreateLaunchAction{$endif}(const IPDF: PPDF; OP: Integer; const FileName, DefDir, Param: PAnsiChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateLaunchActionExA      = function {$else}function  pdfCreateLaunchActionExA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateLaunchActionExW      = function {$else}function  pdfCreateLaunchActionExW{$endif}(const IPDF: PPDF; const FileName: PWideChar; NewWindow: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateListBox              = function {$else}function  pdfCreateListBox{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Sort: LongBool; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateNamedAction          = function {$else}function  pdfCreateNamedAction{$endif}(const IPDF: PPDF; Action: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateNamedDestA           = function {$else}function  pdfCreateNamedDestA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateNamedDestW           = function {$else}function  pdfCreateNamedDestW{$endif}(const IPDF: PPDF; const Name: PWideChar; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateNewPDFA              = function {$else}function  pdfCreateNewPDFA{$endif}(const IPDF: PPDF; const OutPDF: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateNewPDFW              = function {$else}function  pdfCreateNewPDFW{$endif}(const IPDF: PPDF; const OutPDF: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateOCGA                 = function {$else}function  pdfCreateOCGA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; DisplayInUI, Visible: LongBool; Intent: TOCGIntent): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateOCGW                 = function {$else}function  pdfCreateOCGW{$endif}(const IPDF: PPDF; const Name: PWideChar; DisplayInUI, Visible: LongBool; Intent: TOCGIntent): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateOCMD                 = function {$else}function  pdfCreateOCMD{$endif}(const IPDF: PPDF; Visibility: TOCVisibility; const OCGs: PCardinal; Count: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateRadialShading        = function {$else}function  pdfCreateRadialShading{$endif}(const IPDF: PPDF; sX, sY, R1, eX, eY, R2, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateRadioButton          = function {$else}function  pdfCreateRadioButton{$endif}(const IPDF: PPDF; const Name, ExpValue: PAnsiChar; Checked, Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateRectilinearMeasureA  = function {$else}function  pdfCreateRectilinearMeasureA{$endif}(const IPDF: PPDF; Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateRectilinearMeasureW  = function {$else}function  pdfCreateRectilinearMeasureW{$endif}(const IPDF: PPDF; Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateResetAction          = function {$else}function  pdfCreateResetAction{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSeparationCS         = function {$else}function  pdfCreateSeparationCS{$endif}(const IPDF: PPDF; const Colorant: PAnsiChar; Alternate, Handle: Integer; Color: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSetOCGStateAction    = function {$else}function  pdfCreateSetOCGStateAction{$endif}(const IPDF: PPDF; const On_: PCardinal; OnCount: Cardinal; const Off: PCardinal; OffCount: Cardinal; const Toggle: PCardinal; ToggleCount: Cardinal; PreserveRB: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSigField             = function {$else}function  pdfCreateSigField{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSigFieldAP           = function {$else}function  pdfCreateSigFieldAP{$endif}(const IPDF: PPDF; SigField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSoftMask             = function {$else}function  pdfCreateSoftMask{$endif}(const IPDF: PPDF; TranspGroup: Cardinal; MaskType: TSoftMaskType; BackColor: Cardinal): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateStdPattern           = function {$else}function  pdfCreateStdPattern{$endif}(const IPDF: PPDF; Pattern: Integer; LineWidth, Distance: Double; LineColor, BackColor: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateStructureTreeEx      = function {$else}function  pdfCreateStructureTreeEx{$endif}(const IPDF: PPDF; RootTag: TPDFBaseTag): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateSubmitAction         = function {$else}function  pdfCreateSubmitAction{$endif}(const IPDF: PPDF; Flags: Integer; const URL: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateTextField            = function {$else}function  pdfCreateTextField{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Parent, Multiline, MaxLen: Integer; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateURIAction            = function {$else}function  pdfCreateURIAction{$endif}(const IPDF: PPDF; const URL: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateViewportA            = function {$else}function  pdfCreateViewportA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; X1, Y1, X2, Y2: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateViewportW            = function {$else}function  pdfCreateViewportW{$endif}(const IPDF: PPDF; const Name: PWideChar; X1, Y1, X2, Y2: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateXFAStreamA           = function {$else}function  pdfCreateXFAStreamA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfCreateXFAStreamW           = function {$else}function  pdfCreateXFAStreamW{$endif}(const IPDF: PPDF; const Name: PWideChar; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDecryptPDFA                = function {$else}function  pdfDecryptPDFA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; PwdType: Integer; const Password: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDecryptPDFW                = function {$else}function  pdfDecryptPDFW{$endif}(const IPDF: PPDF; const FileName: PWideChar; PwdType: Integer; const Password: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteAcroForm             = procedure{$else}procedure pdfDeleteAcroForm{$endif}(const IPDF: PPDF); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteActionFromObj        = function {$else}function  pdfDeleteActionFromObj{$endif}(const IPDF: PPDF; ObjType: Integer; ActHandle, ObjHandle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteActionFromObjEx      = function {$else}function  pdfDeleteActionFromObjEx{$endif}(const IPDF: PPDF; ObjType: Integer; ObjHandle, ActIndex: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteAltFontList          = function {$else}function  pdfDeleteAltFontList{$endif}(const IPDF: PPDF; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteAnnotation           = function {$else}function  pdfDeleteAnnotation{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteAnnotationFromPage   = function {$else}function  pdfDeleteAnnotationFromPage{$endif}(const IPDF: PPDF; PageNum, Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteAppEvents            = function {$else}function  pdfDeleteAppEvents{$endif}(const IPDF: PPDF; ApplyEvent: LongBool; Event: TOCAppEvent): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteBookmark             = function {$else}function  pdfDeleteBookmark{$endif}(const IPDF: PPDF; ABmk: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteDPartNode            = function {$else}function  pdfDeleteDPartNode{$endif}(const PPDF: PPDF; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteEmbeddedFile         = function {$else}function  pdfDeleteEmbeddedFile{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteField                = function {$else}function  pdfDeleteField{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteFieldEx              = function {$else}function  pdfDeleteFieldEx{$endif}(const IPDF: PPDF; const Name: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteJavaScripts          = procedure{$else}procedure pdfDeleteJavaScripts{$endif}(const IPDF: PPDF; DelJavaScriptActions: LongBool); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteNamedDestA           = function {$else}function  pdfDeleteNamedDestA{$endif}(const IPDF: PPDF; const Name: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteNamedDestW           = function {$else}function  pdfDeleteNamedDestW{$endif}(const IPDF: PPDF; const Name: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteNamedDestByIndex     = function {$else}function  pdfDeleteNamedDestByIndex{$endif}(const IPDF: PPDF; Index: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteOCGFromAppEvent      = function {$else}function  pdfDeleteOCGFromAppEvent{$endif}(const IPDF: PPDF; Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory; DelCategoryOnly: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteOCGFromDisplayTree   = function {$else}function  pdfDeleteOCGFromDisplayTree{$endif}(const IPDF: PPDF; OCGHandle: Cardinal; Recursive: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteOCUINode             = function {$else}function  pdfDeleteOCUINode{$endif}(const IPDF: PPDF; Node: IOCN): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteOutputIntent         = function {$else}function  pdfDeleteOutputIntent{$endif}(const IPDF: PPDF; Index: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeletePageLabels           = procedure{$else}procedure pdfDeletePageLabels{$endif}(const IPDF: PPDF); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeletePage                 = function {$else}function  pdfDeletePage{$endif}(const IPDF: PPDF; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeletePDF                  = function {$else}function  pdfDeletePDF{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteSeparationInfo       = function {$else}function  pdfDeleteSeparationInfo{$endif}(const IPDF: PPDF; AllPages: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteTemplate             = function {$else}function  pdfDeleteTemplate{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteTemplateEx           = function {$else}function  pdfDeleteTemplateEx{$endif}(const IPDF: PPDF; Index: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteWatermark            = function {$else}function  pdfDeleteWatermark{$endif}(const IPDF: PPDF; PageNum: Integer; InclAnnots: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDeleteXFAForm              = procedure{$else}procedure pdfDeleteXFAForm{$endif}(const IPDF: PPDF); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawArc                    = function {$else}function  pdfDrawArc{$endif}(const IPDF: PPDF; PosX, PosY, Radius, StartAngle, EndAngle: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawArcEx                  = function {$else}function  pdfDrawArcEx{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, StartAngle, EndAngle: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawChord                  = function {$else}function  pdfDrawChord{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawCircle                 = function {$else}function  pdfDrawCircle{$endif}(const IPDF: PPDF; PosX, PosY, Radius: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawNGon                   = function {$else}function  pdfDrawNGon{$endif}(const IPDF: PPDF; PosX, PosY, Radius, Alpha: Double; NumSides: Cardinal; FillMode: TPathFillMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfDrawPie                    = function {$else}function  pdfDrawPie{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEditPage                   = function {$else}function  pdfEditPage{$endif}(const IPDF: PPDF; PageNum: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEditTemplate               = function {$else}function  pdfEditTemplate{$endif}(const IPDF: PPDF; Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEditTemplate2              = function {$else}function  pdfEditTemplate2{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEllipse                    = function {$else}function  pdfEllipse{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEnableImageCache           = function {$else}function  pdfEnableImageCache{$endif}(const IPDF: PPDF; MaxImageCount, Size: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEncryptPDFA                = function {$else}function  pdfEncryptPDFA{$endif}(const IPDF: PPDF; const FileName, OpenPwd, OwnerPwd: PAnsiChar; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEncryptPDFW                = function {$else}function  pdfEncryptPDFW{$endif}(const IPDF: PPDF; const FileName: PWideChar; const OpenPwd, OwnerPwd: PAnsiChar; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEndContinueText            = function {$else}function  pdfEndContinueText{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEndLayer                   = function {$else}function  pdfEndLayer{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEndPage                    = function {$else}function  pdfEndPage{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEndPattern                 = function {$else}function  pdfEndPattern{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEndTemplate                = function {$else}function  pdfEndTemplate{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEnumDocFonts               = function {$else}function  pdfEnumDocFonts{$endif}(const IPDF: PPDF; const Data: Pointer; EnumProc: TEnumFontProc2): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEnumHostFonts              = function {$else}function  pdfEnumHostFonts{$endif}(const IPDF: PPDF; const Data: Pointer; EnumProc: TEnumFontProc): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfEnumHostFontsEx            = function {$else}function  pdfEnumHostFontsEx{$endif}(const IPDF: PPDF; const Data: Pointer; EnumProc: TEnumFontProcEx): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfExchangeBookmarks          = function {$else}function  pdfExchangeBookmarks{$endif}(const IPDF: PPDF; Bmk1, Bmk2: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfExchangePages              = function {$else}function  pdfExchangePages{$endif}(const IPDF: PPDF; First, Second: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfExtractText                = function {$else}function  pdfExtractText{$endif}(const IPDF: PPDF; PageNum: Cardinal; Flags: TTextExtractionFlags; const Area: PFltRect; var Text: PWideChar; var TextLen: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileAttachAnnotA           = function {$else}function  pdfFileAttachAnnotA{$endif}(const IPDF: PPDF; PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: PAnsiChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileAttachAnnotW           = function {$else}function  pdfFileAttachAnnotW{$endif}(const IPDF: PPDF; PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: PWideChar; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileAttachAnnotExA         = function {$else}function  pdfFileAttachAnnotExA{$endif}(const IPDF: PPDF; PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: PAnsiChar; const Buffer: Pointer; BufSize: Cardinal; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileAttachAnnotExW         = function {$else}function  pdfFileAttachAnnotExW{$endif}(const IPDF: PPDF; PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: PWideChar; const Buffer: Pointer; BufSize: Cardinal; Compress: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileLinkA                  = function {$else}function  pdfFileLinkA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const AFilePath: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFileLinkW                  = function {$else}function  pdfFileLinkW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const AFilePath: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindBookmarkA              = function {$else}function  pdfFindBookmarkA{$endif}(const IPDF: PPDF; DestPage: Integer; const Title: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindBookmarkW              = function {$else}function  pdfFindBookmarkW{$endif}(const IPDF: PPDF; DestPage: Integer; const Title: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindEmbeddedFileW          = function {$else}function  pdfFindEmbeddedFileW{$endif}(const IPDF: PPDF; const Name: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindFieldA                 = function {$else}function  pdfFindFieldA{$endif}(const IPDF: PPDF; const Name: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindFieldW                 = function {$else}function  pdfFindFieldW{$endif}(const IPDF: PPDF; const Name: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindLinkAnnot              = function {$else}function  pdfFindLinkAnnot{$endif}(const IPDF: PPDF; const URL: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFindNextBookmark           = function {$else}function  pdfFindNextBookmark{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFinishSignature            = function {$else}function  pdfFinishSignature{$endif}(const IPDF: PPDF; const PKCS7Obj: Pointer; Length: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlattenAnnotOrField        = function {$else}function  pdfFlattenAnnotOrField{$endif}(const IPDF: PPDF; Index: Cardinal; Flags: TAnnotFlattenFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlattenAnnots              = function {$else}function  pdfFlattenAnnots{$endif}(const IPDF: PPDF; Flags: TAnnotFlattenFlags): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlattenForm                = function {$else}function  pdfFlattenForm{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlushPageContent           = function {$else}function  pdfFlushPageContent{$endif}(const IPDF: PPDF; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlushPages                 = function {$else}function  pdfFlushPages{$endif}(const IPDF: PPDF; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFlushPagesEx               = function {$else}function  pdfFlushPagesEx{$endif}(const IPDF: PPDF; Flags: Integer; LastPage: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeImageBuffer            = procedure{$else}procedure pdfFreeImageBuffer{$endif}(const IPDF: PPDF); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeImageObj               = function {$else}function  pdfFreeImageObj{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeImageObjEx             = function {$else}function  pdfFreeImageObjEx{$endif}(const IPDF: PPDF; const ImagePtr: Pointer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreePDF                    = function {$else}function  pdfFreePDF{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeTextAnnotA             = function {$else}function  pdfFreeTextAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, AText: PAnsiChar; Align: TTextAlign): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeTextAnnotW             = function {$else}function  pdfFreeTextAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, AText: PWideChar; Align: TTextAlign): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfFreeUniBuf                 = function {$else}function  pdfFreeUniBuf{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGet3DAnnotStream           = function {$else}function  pdfGet3DAnnotStream{$endif}(const IPDF: PPDF; Annot: Cardinal; var Data: PByte; var Size: Cardinal; var SubType: PAnsiString): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetActionCount             = function {$else}function  pdfGetActionCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetActionHandle            = function {$else}function  pdfGetActionHandle{$endif}(const IPDF: PPDF; ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetActionType              = function {$else}function  pdfGetActionType{$endif}(const IPDF: PPDF; ActHandle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetActionTypeEx            = function {$else}function  pdfGetActionTypeEx{$endif}(const IPDF: PPDF; ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetActiveFont              = function {$else}function  pdfGetActiveFont{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAllocBy                 = function {$else}function  pdfGetAllocBy{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnot                   = function {$else}function  pdfGetAnnot{$endif}(const IPDF: PPDF; Handle: Cardinal; var Annot: TPDFAnnotation): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotBBox               = function {$else}function  pdfGetAnnotBBox{$endif}(const IPDF: PPDF; Handle: Cardinal; var BBox: TPDFRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotColor              = function {$else}function  pdfGetAnnotColor{$endif}(const IPDF: PPDF; Handle: Cardinal; ColorType: TAnnotColor; var CS: TPDFColorSpace; var Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotCount              = function {$else}function  pdfGetAnnotCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotEx                 = function {$else}function  pdfGetAnnotEx{$endif}(const IPDF: PPDF; Handle: Cardinal; var Annot: TPDFAnnotationEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotFlags              = function {$else}function  pdfGetAnnotFlags{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotLink               = function {$else}function  pdfGetAnnotLink{$endif}(const IPDF: PPDF; Handle: Cardinal): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotTextAlign          = function {$else}function  pdfGetAnnotTextAlign{$endif}(const IPDF: PPDF; Handle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAnnotType               = function {$else}function  pdfGetAnnotType{$endif}(const IPDF: PPDF; Handle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetAscent                  = function {$else}function  pdfGetAscent{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBarcodeDict             = function {$else}function  pdfGetBarcodeDict{$endif}(const IBarcode: Pointer; var Barcode: TPDFBarcode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBBox                    = function {$else}function  pdfGetBBox{$endif}(const IPDF: PPDF; Boundary: TPageBoundary; var BBox: TPDFRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBidiMode                = function {$else}function  pdfGetBidiMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBookmark                = function {$else}function  pdfGetBookmark{$endif}(const IPDF: PPDF; Handle: Integer; var Bmk: TBookmark): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBookmarkCount           = function {$else}function  pdfGetBookmarkCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBookmarkEx              = function {$else}function  pdfGetBookmarkEx{$endif}(const IPDF: Pointer; Handle: Cardinal; var Bmk: TPDFBookmark): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBorderStyle             = function {$else}function  pdfGetBorderStyle{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetBuffer                  = function {$else}function  pdfGetBuffer{$endif}(const IPDF: PPDF; var BufSize: Cardinal): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCapHeight               = function {$else}function  pdfGetCapHeight{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCharacterSpacing        = function {$else}function  pdfGetCharacterSpacing{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCheckBoxChar            = function {$else}function  pdfGetCheckBoxChar{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCheckBoxCharEx          = function {$else}function  pdfGetCheckBoxCharEx{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCheckBoxDefState        = function {$else}function  pdfGetCheckBoxDefState{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCMap                    = function {$else}function  pdfGetCMap{$endif}(const IPDF: PPDF; Index: Cardinal; var CMap: TPDFCMap): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCMapCount               = function {$else}function  pdfGetCMapCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCollectionInfo          = function {$else}function  pdfGetCollectionInfo{$endif}(const IPDF: Pointer; var Value: TPDFCollectionInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetColorSpace              = function {$else}function  pdfGetColorSpace{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetColorSpaceCount         = function {$else}function  pdfGetColorSpaceCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetColorSpaceObj           = function {$else}function  pdfGetColorSpaceObj{$endif}(const IPDF: PPDF; Handle: Cardinal; var CS: TPDFColorSpaceObj): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetColorSpaceObjEx         = function {$else}function  pdfGetColorSpaceObjEx{$endif}(const IColorSpace: Pointer; var CS: TPDFColorSpaceObj): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCompressionFilter       = function {$else}function  pdfGetCompressionFilter{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetCompressionLevel        = function {$else}function  pdfGetCompressionLevel{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetContent                 = function {$else}function  pdfGetContent{$endif}(const IPDF: PPDF; var Buffer: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDefBitsPerPixel         = function {$else}function  pdfGetDefBitsPerPixel{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDescent                 = function {$else}function  pdfGetDescent{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDeviceNAttributes       = function {$else}function  pdfGetDeviceNAttributes{$endif}(const IAttributes: Pointer; var Attributes: TDeviceNAttributes): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDocInfo                 = function {$else}function  pdfGetDocInfo{$endif}(const IPDF: PPDF; DInfo: Integer; var Value: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDocInfoCount            = function {$else}function  pdfGetDocInfoCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDocInfoEx               = function {$else}function  pdfGetDocInfoEx{$endif}(const IPDF: PPDF; Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDocUsesTransparency     = function {$else}function  pdfGetDocUsesTransparency{$endif}(const IPDF: PPDF; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDrawDirection           = function {$else}function  pdfGetDrawDirection{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetDynaPDFVersion          = function {$else}function  pdfGetDynaPDFVersion{$endif}(): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetEmbeddedFile            = function {$else}function  pdfGetEmbeddedFile{$endif}(const IPDF: PPDF; Handle: Cardinal; var FileSpec: TPDFFileSpec; Decompress: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetEmbeddedFileCount       = function {$else}function  pdfGetEmbeddedFileCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetEmbeddedFileNode        = function {$else}function  pdfGetEmbeddedFileNode{$endif}(const IEF: IEFN; var F: TPDFEmbFileNode; Decompress: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetEMFPatternDistance      = function {$else}function  pdfGetEMFPatternDistance{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetErrLogMessage           = function {$else}function  pdfGetErrLogMessage{$endif}(const IPDF: PPDF; Index: Cardinal; var Err: TPDFError): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetErrLogMessageCount      = function {$else}function  pdfGetErrLogMessageCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetErrorMessage            = function {$else}function  pdfGetErrorMessage{$endif}(const IPDF: PPDF): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetErrorMode               = function {$else}function  pdfGetErrorMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetField                   = function {$else}function  pdfGetField{$endif}(const IPDF: PPDF; Handle: Cardinal; var Field: TPDFField): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldBackColor          = function {$else}function  pdfGetFieldBackColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldBorderColor        = function {$else}function  pdfGetFieldBorderColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldBorderStyle        = function {$else}function  pdfGetFieldBorderStyle{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldBorderWidth        = function {$else}function  pdfGetFieldBorderWidth{$endif}(const IPDF: PPDF; AField: Cardinal): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldCalcOrder          = function {$else}function  pdfGetFieldCalcOrder{$endif}(const IPDF: PPDF; var Out: PCardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldChoiceValue        = function {$else}function  pdfGetFieldChoiceValue{$endif}(const IPDF: PPDF; AField, ValIndex: Cardinal; var Value: TPDFChoiceValue): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldColor              = function {$else}function  pdfGetFieldColor{$endif}(const IPDF: PPDF; AField: Cardinal; ColorType: Integer; var ColorSpace: Integer; var Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldCount              = function {$else}function  pdfGetFieldCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldEx                 = function {$else}function  pdfGetFieldEx{$endif}(const IPDF: PPDF; Handle: Cardinal; var Field: TPDFFieldEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldEx2                = function {$else}function  pdfGetFieldEx2{$endif}(const IField: Pointer; var Field: TPDFFieldEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldExpValCount        = function {$else}function  pdfGetFieldExpValCount{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldExpValue           = function {$else}function  pdfGetFieldExpValue{$endif}(const IPDF: PPDF; AField: Cardinal; var Value: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldExpValueEx         = function {$else}function  pdfGetFieldExpValueEx{$endif}(const IPDF: PPDF; AField, ValIndex: Cardinal; var Value, ExpValue: PAnsiChar; var Selected: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldFlags              = function {$else}function  pdfGetFieldFlags{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldGroupType          = function {$else}function  pdfGetFieldGroupType{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldHighlightMode      = function {$else}function  pdfGetFieldHighlightMode{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldIndex              = function {$else}function  pdfGetFieldIndex{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldMapName            = function {$else}function  pdfGetFieldMapName{$endif}(const IPDF: PPDF; AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldName               = function {$else}function  pdfGetFieldName{$endif}(const IPDF: PPDF; AField: Cardinal; var Name: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldOrientation        = function {$else}function  pdfGetFieldOrientation{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldTextAlign          = function {$else}function  pdfGetFieldTextAlign{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldTextColor          = function {$else}function  pdfGetFieldTextColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldToolTip            = function {$else}function  pdfGetFieldToolTip{$endif}(const IPDF: PPDF; AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFieldType               = function {$else}function  pdfGetFieldType{$endif}(const IPDF: PPDF; AField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFileSpec                = function {$else}function  pdfGetFileSpec{$endif}(const IFS: IFSR; var F: TPDFFileSpecEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFillColor               = function {$else}function  pdfGetFillColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontCount               = function {$else}function  pdfGetFontCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontEx                  = function {$else}function  pdfGetFontEx{$endif}(const IPDF: PPDF; Handle: Cardinal; var F: TPDFFontObj): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontInfoEx              = function {$else}function  pdfGetFontInfoEx{$endif}(const IPDF: PPDF; Handle: Cardinal; var F: TPDFFontInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontMetrics             = function {$else}function  pdfGetFontMetrics{$endif}(const IPDF: PPDF; Handle: Cardinal; var Metrics: TPDFFontMetrics): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontOrigin              = function {$else}function  pdfGetFontOrigin{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontSearchOrder         = procedure{$else}procedure pdfGetFontSearchOrder{$endif}(const IPDF: PPDF; Order: PFontBaseType{Array[0..3] of TFontBaseType}); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontSelMode             = function {$else}function  pdfGetFontSelMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontSize                = function {$else}function  pdfGetFontSize{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFontWeight              = function {$else}function  pdfGetFontWeight{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFTextHeightA            = function {$else}function  pdfGetFTextHeightA{$endif}(const IPDF: PPDF; Align: Integer; const AText: PAnsiChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFTextHeightExA          = function {$else}function  pdfGetFTextHeightExA{$endif}(const IPDF: PPDF; Width: Double; Align: Integer; const AText: PAnsiChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFTextHeightExW          = function {$else}function  pdfGetFTextHeightExW{$endif}(const IPDF: PPDF; Width: Double; Align: Integer; const AText: PWideChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFTextHeightW            = function {$else}function  pdfGetFTextHeightW{$endif}(const IPDF: PPDF; Align: Integer; const AText: PWideChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetFullyQualifiedFieldName = function {$else}function  pdfGetFullyQualifiedFieldName{$endif}(const IPDF: PPDF; Handle: Cardinal; var Out: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetGlyphIndex              = function {$else}function  pdfGetGlyphIndex{$endif}(const IPDF: PPDF; Index: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetGlyphOutline            = function {$else}function  pdfGetGlyphOutline{$endif}(const IPDF: PPDF; Index: Cardinal; Outline: PPDFGlyphOutline): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetGoToAction              = function {$else}function  pdfGetGoToAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFGoToAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetGoToRAction             = function {$else}function  pdfGetGoToRAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFGoToAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetGStateFlags             = function {$else}function  pdfGetGStateFlags{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetHideAction              = function {$else}function  pdfGetHideAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFHideAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetIconColor               = function {$else}function  pdfGetIconColor{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageBuffer             = function {$else}function  pdfGetImageBuffer{$endif}(const IPDF: PPDF; var BufSize: Cardinal): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageCountA             = function {$else}function  pdfGetImageCountA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageCountW             = function {$else}function  pdfGetImageCountW{$endif}(const IPDF: PPDF; const FileName: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageCountEx            = function {$else}function  pdfGetImageCountEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageHeight             = function {$else}function  pdfGetImageHeight{$endif}(const IPDF: PPDF; Handle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetImageObj                = function {$else}function  pdfGetImageObj{$endif}(const IPDF: PPDF; Handle: Cardinal; Flags: TParseFlags; var Image: TPDFImage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImageObjCount           = function {$else}function  pdfGetImageObjCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImageObjEx              = function {$else}function  pdfGetImageObjEx{$endif}(const IPDF: PPDF; const ImagePtr: PIMG; Flags: Integer; var Image: TPDFImage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImageWidth              = function {$else}function  pdfGetImageWidth{$endif}(const IPDF: PPDF; Handle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImportDataAction        = function {$else}function  pdfGetImportDataAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFImportDataAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImportFlags             = function {$else}function  pdfGetImportFlags{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetImportFlags2            = function {$else}function  pdfGetImportFlags2{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInBBox                  = function {$else}function  pdfGetInBBox{$endif}(const IPDF: PPDF; PageNum: Cardinal; Boundary: Integer; var BBox: TPDFRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInDocInfo               = function {$else}function  pdfGetInDocInfo{$endif}(const IPDF: PPDF; DInfo: TDocumentInfo; var Value: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInDocInfoCount          = function {$else}function  pdfGetInDocInfoCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInDocInfoEx             = function {$else}function  pdfGetInDocInfoEx{$endif}(const IPDF: PPDF; Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInEncryptionFlags       = function {$else}function  pdfGetInEncryptionFlags{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInEncryptionInfo        = function {$else}function  pdfGetInEncryptionInfo{$endif}(const IPDF: PPDF; var Info: TPDFEncryptInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetInFieldCount            = function {$else}function  pdfGetInFieldCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsCollection          = function {$else}function  pdfGetInIsCollection{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsEncrypted           = function {$else}function  pdfGetInIsEncrypted{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsSigned              = function {$else}function  pdfGetInIsSigned{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsTaggedPDF           = function {$else}function  pdfGetInIsTaggedPDF{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsTrapped             = function {$else}function  pdfGetInIsTrapped{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInIsXFAForm             = function {$else}function  pdfGetInIsXFAForm{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInkList                 = function {$else}function  pdfGetInkList{$endif}(const List: Pointer; Points: PSingle; Count: PCardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInMetadata              = function {$else}function  pdfGetInMetadata{$endif}(const IPDF: PPDF; PageNum: Integer; var Buffer: PByte; var BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInOrientation           = function {$else}function  pdfGetInOrientation{$endif}(const IPDF: PPDF; PageNum: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInPageCount             = function {$else}function  pdfGetInPageCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInPDFVersion            = function {$else}function  pdfGetInPDFVersion{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInPDFVersionEx          = function {$else}function  pdfGetInPDFVersionEx{$endif}(const IPDF: PPDF; Value: PPDFVersionInfo): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInPrintSettings         = function {$else}function  pdfGetInPrintSettings{$endif}(const IPDF: PPDF; var Settings: TPDFPrintSettings): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetInRepairMode            = function {$else}function  pdfGetInRepairMode{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetIsFixedPitch            = function {$else}function  pdfGetIsFixedPitch{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetIsTaggingEnabled        = function {$else}function  pdfGetIsTaggingEnabled{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetItalicAngle             = function {$else}function  pdfGetItalicAngle{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScript              = function {$else}function  pdfGetJavaScript{$endif}(const IPDF: PPDF; Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptAction        = function {$else}function  pdfGetJavaScriptAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptAction2       = function {$else}function  pdfGetJavaScriptAction2{$endif}(const IPDF: PPDF; ObjType: TObjType; ObjHandle, ActIndex: Cardinal; var Len: Cardinal; var Unicode: LongBool; var Event: TObjEvent): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptActionEx      = function {$else}function  pdfGetJavaScriptActionEx{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFJavaScriptAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptCount         = function {$else}function  pdfGetJavaScriptCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptEx            = function {$else}function  pdfGetJavaScriptEx{$endif}(const IPDF: PPDF; const Name: PAnsiChar; var Len: Cardinal; var Unicode: LongBool): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJavaScriptName          = function {$else}function  pdfGetJavaScriptName{$endif}(const IPDF: PPDF; Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetJPEGQuality             = function {$else}function  pdfGetJPEGQuality{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLanguage                = function {$else}function  pdfGetLanguage{$endif}(const IPDF: PPDF): PAnsiChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLastTextPosX            = function {$else}function  pdfGetLastTextPosX{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLastTextPosXAbs         = function {$else}function  pdfGetLastTextPosX{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLastTextPosY            = function {$else}function  pdfGetLastTextPosY{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLastTextPosYAbs         = function {$else}function  pdfGetLastTextPosY{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLaunchAction            = function {$else}function  pdfGetLaunchAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFLaunchAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLayerConfig             = function {$else}function  pdfGetLayerConfig{$endif}(const IPDF: PPDF; Index: Integer; var Config: TPDFOCLayerConfig): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLayerConfigCount        = function {$else}function  pdfGetLayerConfigCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLeading                 = function {$else}function  pdfGetLeading{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLineCapStyle            = function {$else}function  pdfGetLineCapStyle{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLineJoinStyle           = function {$else}function  pdfGetLineJoinStyle{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLineWidth               = function {$else}function  pdfGetLineWidth{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLinkHighlightMode       = function {$else}function  pdfGetLinkHighlightMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLogMetafileSizeA        = function {$else}function  pdfGetLogMetafileSizeA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; var R: TRectL): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLogMetafileSizeW        = function {$else}function  pdfGetLogMetafileSizeW{$endif}(const IPDF: PPDF; const FileName: PWideChar; var R: TRectL): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetLogMetafileSizeEx       = function {$else}function  pdfGetLogMetafileSizeEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; var R: TRectL): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMatrix                  = function {$else}function  pdfGetMatrix{$endif}(const IPDF: PPDF; var M: TCTM): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMaxFieldLen             = function {$else}function  pdfGetMaxFieldLen{$endif}(const IPDF: PPDF; TxtField: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMeasureObj              = function {$else}function  pdfGetMeasureObj{$endif}(const Measure: IMSR; var Value: TPDFMeasure): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMetaConvFlags           = function {$else}function  pdfGetMetaConvFlags{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMetadata                = function {$else}function  pdfGetMetadata{$endif}(const IPDF: PPDF; ObjType: TMetadataObj; Handle: Integer; var Buffer: PByte; var BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMissingGlyphs           = function {$else}function  pdfGetMissingGlyphs{$endif}(const IPDF: PPDF; var Count: Cardinal): PCardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMiterLimit              = function {$else}function  pdfGetMiterLimit{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetMovieAction             = function {$else}function  pdfGetMovieAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFMovieAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetNamedAction             = function {$else}function  pdfGetNamedAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFNamedAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetNamedDest               = function {$else}function  pdfGetNamedDest{$endif}(const IPDF: PPDF; Index: Cardinal; var Dest: TPDFNamedDest): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetNamedDestCount          = function {$else}function  pdfGetNamedDestCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetNeedAppearance          = function {$else}function  pdfGetNeedAppearance{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetNumberFormatObj         = function {$else}function  pdfGetNumberFormatObj{$endif}(NumberFmt: INFM; var Value: TPDFNumberFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetObjActionCount          = function {$else}function  pdfGetObjActionCount{$endif}(const IPDF: PPDF; ObjType: Integer; ObjHandle: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetObjActions              = function {$else}function  pdfGetObjActions{$endif}(const IPDF: PPDF; ObjType: TObjType; ObjHandle: Cardinal; var Actions: TPDFObjActions): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetObjEvent                = function {$else}function  pdfGetObjEvent{$endif}(const IEvent: IEVT; var Event: TPDFObjEvent): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCG                     = function {$else}function  pdfGetOCG{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFOCG): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCGContUsage            = function {$else}function  pdfGetOCGContUsage{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFOCGContUsage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCGCount                = function {$else}function  pdfGetOCGCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCGUsageUserName        = function {$else}function  pdfGetOCGUsageUserName{$endif}(const IPDF: PPDF; Handle, Index: Cardinal; var NameA: PAnsiChar; var NameW: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCHandle                = function {$else}function  pdfGetOCHandle{$endif}(const OC: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOCUINode                = function {$else}function  pdfGetOCUINode{$endif}(const IPDF: PPDF; const Node: IOCN; OutNode: PPDFOCUINode): IOCN; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOpacity                 = function {$else}function  pdfGetOpacity{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOrientation             = function {$else}function  pdfGetOrientation{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOutputIntent            = function {$else}function  pdfGetOutputIntent{$endif}(const IPDF: PPDF; Index: Cardinal; var Intent: TPDFOutputIntent): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetOutputIntentCount       = function {$else}function  pdfGetOutputIntentCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageAnnot               = function {$else}function  pdfGetPageAnnot{$endif}(const IPDF: PPDF; Index: Cardinal; var Annot: TPDFAnnotation): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageAnnotCount          = function {$else}function  pdfGetPageAnnotCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageAnnotEx             = function {$else}function  pdfGetPageAnnotEx{$endif}(const IPDF: PPDF; Index: Cardinal; var Annot: TPDFAnnotationEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageBBox                = function {$else}function  pdfGetPageBBox{$endif}(PagePtr: IPGE; Boundary: TPageBoundary; var BBox: TFltRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageCoords              = function {$else}function  pdfGetPageCoords{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageCount               = function {$else}function  pdfGetPageCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageField               = function {$else}function  pdfGetPageField{$endif}(const IPDF: PPDF; Index: Cardinal; var Field: TPDFField): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageFieldCount          = function {$else}function  pdfGetPageFieldCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageFieldEx             = function {$else}function  pdfGetPageFieldEx{$endif}(const IPDF: PPDF; Index: Cardinal; var Field: TPDFFieldEx): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageHeight              = function {$else}function  pdfGetPageHeight{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageLabel               = function {$else}function  pdfGetPageLabel{$endif}(const IPDF: PPDF; Index: Cardinal; var Lbl: TPDFPageLabel): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageLabelCount          = function {$else}function  pdfGetPageLabelCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageLayout              = function {$else}function  pdfGetPageLayout{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageMode                = function {$else}function  pdfGetPageMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageNum                 = function {$else}function  pdfGetPageNum{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageObject              = function {$else}function  pdfGetPageObject{$endif}(const IPDF: PPDF; PageNum: Cardinal): IPGE; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageOrientation         = function {$else}function  pdfGetPageOrientation{$endif}(PagePtr: IPGE): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageText                = function {$else}function  pdfGetPageText{$endif}(const IPDF: PPDF; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPageWidth               = function {$else}function  pdfGetPageWidth{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPDFVersion              = function {$else}function  pdfGetPDFVersion{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPDFVersionEx            = function {$else}function  pdfGetPDFVersionEx{$endif}(const IPDF: PPDF; var Value: TPDFVersionInfo): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPrintSettings           = function {$else}function  pdfGetPrintSettings{$endif}(const IPDF: PPDF; var Settings: TPDFPrintSettings): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPtDataArray             = function {$else}function  pdfGetPtDataArray{$endif}(const PtData: IPTD; Index: Cardinal; var DataType: PAnsiChar; var Values: PSingle; var ValCount: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetPtDataObj               = function {$else}function  pdfGetPtDataObj{$endif}(const PtData: IPTD; var Subtype: PAnsiChar; var NumArrays: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetRelFileNode             = function {$else}function  pdfGetRelFileNode{$endif}(const IRF: IRFN; var F: TPDFRelFileNode; Decompress: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetResetAction             = function {$else}function  pdfGetResetAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFResetFormAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetResolution              = function {$else}function  pdfGetResolution{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetSaveNewImageFormat      = function {$else}function  pdfGetSaveNewImageFormat{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetSeparationInfo          = function {$else}function  pdfGetSeparationInfo{$endif}(const IPDF: PPDF; var Colorant: PAnsiChar; var CS: TExtColorSpace): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetSigDict                 = function {$else}function  pdfGetSigDict{$endif}(const ISignature: Pointer; var SigDict: TPDFSigDict): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetStrokeColor             = function {$else}function  pdfGetStrokeColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetSubmitAction            = function {$else}function  pdfGetSubmitAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFSubmitFormAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetSysFontInfo             = function {$else}function  pdfGetSysFontInfo{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFSysFont): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTabLen                  = function {$else}function  pdfGetTabLen{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTemplCount              = function {$else}function  pdfGetTemplCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTemplHandle             = function {$else}function  pdfGetTemplHandle{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTemplHeight             = function {$else}function  pdfGetTemplHeight{$endif}(const IPDF: PPDF; TmplHandle: Integer): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTemplWidth              = function {$else}function  pdfGetTemplWidth{$endif}(const IPDF: PPDF; TmplHandle: Integer): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextBBoxA               = function {$else}function  pdfGetTextBBoxA{$endif}(const IPDF: PPDF; const Text: PAnsiChar; Len: Cardinal; var BBox: TBBox): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetTextBBoxW               = function {$else}function  pdfGetTextBBoxW{$endif}(const IPDF: PPDF; const Text: PWideChar; Len: Cardinal; var BBox: TBBox): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfGetTextDrawMode            = function {$else}function  pdfGetTextDrawMode{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextFieldValue          = function {$else}function  pdfGetTextFieldValue{$endif}(const IPDF: PPDF; AField: Cardinal; var Value: PAnsiChar; var ValIsUnicode: LongBool; var DefValue: PAnsiChar; var DefValIsUnicode: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextRect                = function {$else}function  pdfGetTextRect{$endif}(const IPDF: PPDF; var PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextRise                = function {$else}function  pdfGetTextRise{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextScaling             = function {$else}function  pdfGetTextScaling{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextWidthA              = function {$else}function  pdfGetTextWidthA{$endif}(const IPDF: PPDF; const AText: PAnsiChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextWidthW              = function {$else}function  pdfGetTextWidthW{$endif}(const IPDF: PPDF; const AText: PWideChar): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextWidthExA            = function {$else}function  pdfGetTextWidthExA{$endif}(const IPDF: PPDF; const AText: PAnsiChar; Len: Cardinal): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTextWidthExW            = function {$else}function  pdfGetTextWidthExW{$endif}(const IPDF: PPDF; const AText: PWideChar; Len: Cardinal): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTrapped                 = function {$else}function  pdfGetTrapped{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTransparentColor        = function {$else}function  pdfGetTransparentColor{$endif}(const IPDF: PPDF): Cardinal; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetTypoLeading             = function {$else}function  pdfGetTypoLeading{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetURIAction               = function {$else}function  pdfGetURIAction{$endif}(const IPDF: PPDF; Handle: Cardinal; var Action: TPDFURIAction): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseExactPwd             = function {$else}function  pdfGetUseExactPwd{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseGlobalImpFiles       = function {$else}function  pdfGetUseGlobalImpFiles{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUserRights              = function {$else}function  pdfGetUserRights{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUserUnit                = function {$else}function  pdfGetUserUnit{$endif}(const IPDF: PPDF): Single; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseStdFonts             = function {$else}function  pdfGetUseStdFonts{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseSystemFonts          = function {$else}function  pdfGetUseSystemFonts{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUsesTransparency        = function {$else}function  pdfGetUsesTransparency{$endif}(const IPDF: PPDF; PageNum: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseTransparency         = function {$else}function  pdfGetUseTransparency{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetUseVisibleCoords        = function {$else}function  pdfGetUseVisibleCoords{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetViewerPreferences       = function {$else}function  pdfGetViewerPreferences{$endif}(const IPDF: PPDF; var Preference, AddVal: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetViewport                = function {$else}function  pdfGetViewport{$endif}(const IPDF: PPDF; PageNum, Index: Cardinal; var VP: TPDFViewport): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetViewportCount           = function {$else}function  pdfGetViewportCount{$endif}(const IPDF: PPDF; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetWMFDefExtent            = function {$else}function  pdfGetWMFDefExtent{$endif}(const IPDF: PPDF; var Width, Height: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetWMFPixelPerInch         = function {$else}function  pdfGetWMFPixelPerInch{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetWordSpacing             = function {$else}function  pdfGetWordSpacing{$endif}(const IPDF: PPDF): Double; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetXFAStream               = function {$else}function  pdfGetXFAStream{$endif}(const IPDF: PPDF; Index: Cardinal; OutStrm: PPDFXFAStream): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfGetXFAStreamCount          = function {$else}function  pdfGetXFAStreamCount{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfHaveDPartRoot              = function {$else}function  pdfHaveDPartRoot{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfHaveOpenDoc                = function {$else}function  pdfHaveOpenDoc{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfHaveOpenPage               = function {$else}function  pdfHaveOpenPage{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfHighlightAnnotA            = function {$else}function  pdfHighlightAnnotA{$endif}(const IPDF: PPDF; SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfHighlightAnnotW            = function {$else}function  pdfHighlightAnnotW{$endif}(const IPDF: PPDF; SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportBookmarks            = function {$else}function  pdfImportBookmarks{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportCatalogObjects       = function {$else}function  pdfImportCatalogObjects{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportDocInfo              = function {$else}function  pdfImportDocInfo{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportEncryptionSettings   = function {$else}function  pdfImportEncryptionSettings{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportOCProperties         = function {$else}function  pdfImportOCProperties{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportPage                 = function {$else}function  pdfImportPage{$endif}(const IPDF: PPDF; PageNum: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportPageEx               = function {$else}function  pdfImportPageEx{$endif}(const IPDF: PPDF; PageNum: Cardinal; ScaleFactX, ScaleFactY: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfImportPDFFile              = function {$else}function  pdfImportPDFFile{$endif}(const IPDF: PPDF; DestPage: Cardinal; ScaleFactX, ScaleFactY: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitBarcode2               = function {$else}function  pdfInitBarcode2{$endif}(var Barcode: TPDFBarcode2): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitColorManagement        = function {$else}function  pdfInitColorManagement{$endif}(const IPDF: PPDF; Profiles: PPDFColorProfiles; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitColorManagementEx      = function {$else}function  pdfInitColorManagementEx{$endif}(const IPDF: PPDF; Profiles: PPDFColorProfilesEx; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitExtGState              = function {$else}function  pdfInitExtGState{$endif}(var GS: TPDFExtGState): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitHeaderFooter           = function {$else}function  pdfInitHeaderFooter{$endif}(var Value: TPDFHeaderFooter; HFArray: PPDFHdrFtr; Count: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitOCGContUsage           = function {$else}function  pdfInitOCGContUsage{$endif}(var Value: TPDFOCGContUsage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInitStack                  = function {$else}function  pdfInitStack{$endif}(const IPDF: PPDF; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInkAnnotA                  = function {$else}function  pdfInkAnnotA{$endif}(const IPDF: PPDF; Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInkAnnotW                  = function {$else}function  pdfInkAnnotW{$endif}(const IPDF: PPDF; Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBarcode              = function {$else}function  pdfInsertBarcode{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; HAlign, VAlign: TCellAlign; var Barcode: TPDFBarcode2): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBMPFromBuffer        = function {$else}function  pdfInsertBMPFromBuffer{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBMPFromHandle        = function {$else}function  pdfInsertBMPFromHandle{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; Handle: Pointer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBookmarkA            = function {$else}function  pdfInsertBookmarkA{$endif}(const IPDF: PPDF; const Title: PAnsiChar; Parent: Integer; DestPage: Cardinal; Open, AddChildren: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBookmarkW            = function {$else}function  pdfInsertBookmarkW{$endif}(const IPDF: PPDF; const Title: PWideChar; Parent: Integer; DestPage: Cardinal; Open, AddChildren: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBookmarkExA          = function {$else}function  pdfInsertBookmarkExA{$endif}(const IPDF: PPDF; const Title: PAnsiChar; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertBookmarkExW          = function {$else}function  pdfInsertBookmarkExW{$endif}(const IPDF: PPDF; const Title: PWideChar; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertImage                = function {$else}function  pdfInsertImage{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertImageEx              = function {$else}function  pdfInsertImageEx{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: PAnsiChar; Index: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertImageExW             = function {$else}function  pdfInsertImageExW{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; const Image: PWideChar; Index: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertImageFromBuffer      = function {$else}function  pdfInsertImageFromBuffer{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer; BufSize, Index: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileA            = function {$else}function  pdfInsertMetafileA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileW            = function {$else}function  pdfInsertMetafileW{$endif}(const IPDF: PPDF; const FileName: PWideChar; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileEx           = function {$else}function  pdfInsertMetafileEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileExtA         = function {$else}function  pdfInsertMetafileExtA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; var View: TRectL; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileExtW         = function {$else}function  pdfInsertMetafileExtW{$endif}(const IPDF: PPDF; const FileName: PWideChar; var View: TRectL; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileExtEx        = function {$else}function  pdfInsertMetafileExtEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; var View: TRectL; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileFromHandle   = function {$else}function  pdfInsertMetafileFromHandle{$endif}(const IPDF: PPDF; const hEnhMetafile: Pointer; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertMetafileFromHandleEx = function {$else}function  pdfInsertMetafileFromHandleEx{$endif}(const IPDF: PPDF; const hEnhMetafile: Pointer; var View: TRectL; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertRawImage             = function {$else}function  pdfInsertRawImage{$endif}(const IPDF: PPDF; const Buffer: Pointer; BitsPerPixel, ColorCount, ImgWidth, ImgHeight: Cardinal; PosX, PosY, ScaleWidth, ScaleHeight: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfInsertRawImageEx           = function {$else}function  pdfInsertRawImageEx{$endif}(const IPDF: PPDF; PosX, PosY, ScaleWidth, ScaleHeight: Double; var Image: TPDFRawImage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfIsBidiText                 = function {$else}function  pdfIsBidiText{$endif}(const IPDF: PPDF; const AText: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfIsColorPage                = function {$else}function  pdfIsColorPage{$endif}(const IPDF: PPDF; GrayIsColor: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfIsEmptyPage                = function {$else}function  pdfIsEmptyPage{$endif}(const IPDF: PPDF): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLineAnnotA                 = function {$else}function  pdfLineAnnotA{$endif}(const IPDF: PPDF; x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLineAnnotW                 = function {$else}function  pdfLineAnnotW{$endif}(const IPDF: PPDF; x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLineTo                     = function {$else}function  pdfLineTo{$endif}(const IPDF: PPDF; PosX, PosY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadCMap                   = function {$else}function  pdfLoadCMap{$endif}(const IPDF: PPDF; const CMapName: PAnsiChar; Embed: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFDFDataA               = function {$else}function  pdfLoadFDFDataA{$endif}(const IPDF: PPDF; const FileName, Password: PAnsiChar; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFDFDataW               = function {$else}function  pdfLoadFDFDataW{$endif}(const IPDF: PPDF; const FileName: PWideChar; const Password: PAnsiChar; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFDFDataEx              = function {$else}function  pdfLoadFDFDataEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; const Password: PAnsiChar; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFont                   = function {$else}function  pdfLoadFont{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; Style: Integer; Size: Double; Embed: LongBool; CP: Integer): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFontExA                = function {$else}function  pdfLoadFontExA{$endif}(const IPDF: PPDF; const FontFile: PAnsiChar; Index: Cardinal; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadFontExW                = function {$else}function  pdfLoadFontExW{$endif}(const IPDF: PPDF; const FontFile: PWideChar; Index: Cardinal; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadHeaderFooterSettings   = function {$else}function  pdfLoadHeaderFooterSettings{$endif}(const IPDF: PPDF; var Value: TPDFHeaderFooter; HFArray: PPDFHdrFtr): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLoadLayerConfig            = function {$else}function  pdfLoadLayerConfig{$endif}(const IPDF: PPDF; Index: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfLockLayer                  = function {$else}function  pdfLockLayer{$endif}(const IPDF: PPDF; Layer: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfMarkTemplateAsWatermark    = function {$else}function  pdfMarkTemplateAsWatermark{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfMovePage                   = function {$else}function  pdfMovePage{$endif}(const IPDF: PPDF; Source, Dest: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfMoveTo                     = function {$else}function  pdfMoveTo{$endif}(const IPDF: PPDF; PosX, PosY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfNewPDF                     = function {$else}function  pdfNewPDF{$endif}(): PPDF; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenImportBuffer           = function {$else}function  pdfOpenImportBuffer{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize: Cardinal; PwdType: Integer; const Password: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenImportFileA            = function {$else}function  pdfOpenImportFileA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; PwdType: Integer; const Password: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenImportFileW            = function {$else}function  pdfOpenImportFileW{$endif}(const IPDF: PPDF; const FileName: PWideChar; PwdType: Integer; const Password: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenOutputFileA            = function {$else}function  pdfOpenOutputFileA{$endif}(const IPDF: PPDF; const OutPDF: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenOutputFileW            = function {$else}function  pdfOpenOutputFileW{$endif}(const IPDF: PPDF; const OutPDF: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenOutputFileEncryptedW   = function {$else}function  pdfOpenOutputFileEncryptedW{$endif}(const IPDF: PPDF; const OutPDF: PWideChar; const OpenPwd, OwnerPwd: PAnsiChar; KeyLen: TKeyLen; Restrict: TRestrictions): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagA                   = function {$else}function  pdfOpenTagA{$endif}(const IPDF: PPDF; Tag: TPDFBaseTag; const Lang, AltText, Expansion: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagW                   = function {$else}function  pdfOpenTagW{$endif}(const IPDF: PPDF; Tag: TPDFBaseTag; const Lang: PAnsiChar; const AltText, Expansion: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagBBoxA               = function {$else}function  pdfOpenTagBBoxA{$endif}(const IPDF: Pointer; Tag: TPDFBaseTag; const Lang, AltText, Expansion: PAnsiChar; BBox: PBBox): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagBBoxW               = function {$else}function  pdfOpenTagBBoxW{$endif}(const IPDF: Pointer; Tag: TPDFBaseTag; const Lang: PAnsiChar; const AltText, Expansion: PWideChar; BBox: PBBox): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagExA                 = function {$else}function  pdfOpenTagExA{$endif}(const IPDF: PPDF; Tag: TPDFBaseTag; const Lang: PAnsiChar; const AltText, Expansion: PAnsiChar; const Attributes: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOpenTagExW                 = function {$else}function  pdfOpenTagExW{$endif}(const IPDF: PPDF; Tag: TPDFBaseTag; const Lang: PAnsiChar; const AltText, Expansion: PWideChar; const Attributes: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfOptimize                   = function {$else}function  pdfOptimize{$endif}(const IPDF: PPDF; Flags: TOptimizeFlags; Parms: POptimizeParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPageLink                   = function {$else}function  pdfPageLink{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; DestPage: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPageLink2                  = function {$else}function  pdfPageLink2{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; NamedDest: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPageLink3A                 = function {$else}function  pdfPageLink3A{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const NamedDest: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPageLink3W                 = function {$else}function  pdfPageLink3W{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const NamedDest: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPageLinkEx                 = function {$else}function  pdfPageLinkEx{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; DestType: Integer; DestPage: Cardinal; a, b, c, d: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfParseContent               = function {$else}function  pdfParseContent{$endif}(const IPDF: PPDF; const Data: Pointer; var Stack: TPDFParseInterface; Flags: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPlaceImage                 = function {$else}function  pdfPlaceImage{$endif}(const IPDF: PPDF; ImgHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPlaceSigFieldValidateIcon  = function {$else}function  pdfPlaceSigFieldValidateIcon{$endif}(const IPDF: PPDF; SigField: Cardinal; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPlaceTemplate              = function {$else}function  pdfPlaceTemplate{$endif}(const IPDF: PPDF; TmplHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPlaceTemplateEx            = function {$else}function  pdfPlaceTemplateEx{$endif}(const IPDF: PPDF; TmplHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPlaceTemplByMatrix         = function {$else}function  pdfPlaceTemplByMatrix{$endif}(const IPDF: PPDF; TmplHandle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPolygonAnnotA              = function {$else}function  pdfPolygonAnnotA{$endif}(const IPDF: PPDF; Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPolygonAnnotW              = function {$else}function  pdfPolygonAnnotW{$endif}(const IPDF: PPDF; Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPolyLineAnnotA             = function {$else}function  pdfPolyLineAnnotA{$endif}(const IPDF: PPDF; Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPolyLineAnnotW             = function {$else}function  pdfPolyLineAnnotW{$endif}(const IPDF: PPDF; Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPrintPageA                 = function {$else}function  pdfPrintPageA{$endif}(const IPDF: PPDF; PageNum: Cardinal; const DocName: PAnsiChar; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPrintPageW                 = function {$else}function  pdfPrintPageW{$endif}(const IPDF: PPDF; PageNum: Cardinal; const DocName: PWideChar; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPrintPDFFileA              = function {$else}function  pdfPrintPDFFileA{$endif}(const IPDF: PPDF; const TmpDir, DocName: PAnsiChar; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfPrintPDFFileW              = function {$else}function  pdfPrintPDFFileW{$endif}(const IPDF: PPDF; const TmpDir, DocName: PWideChar; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormatA           = function {$else}function  pdfReadImageFormatA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormatW           = function {$else}function  pdfReadImageFormatW{$endif}(const IPDF: PPDF; const FileName: PWideChar; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormat2A          = function {$else}function  pdfReadImageFormat2A{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormat2W          = function {$else}function  pdfReadImageFormat2W{$endif}(const IPDF: PPDF; const FileName: PWideChar; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormatEx          = function {$else}function  pdfReadImageFormatEx{$endif}(const IPDF: PPDF; hBitmap: Pointer; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageFormatFromBuffer  = function {$else}function  pdfReadImageFormatFromBuffer{$endif}(IPDF, Buffer: Pointer; BufSize, Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageResolutionA       = function {$else}function  pdfReadImageResolutionA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; Index: Cardinal; var ResX, ResY: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageResolutionW       = function {$else}function  pdfReadImageResolutionW{$endif}(const IPDF: PPDF; const FileName: PWideChar; Index: Cardinal; var ResX, ResY: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReadImageResolutionEx      = function {$else}function  pdfReadImageResolutionEx{$endif}(const IPDF: PPDF; const Buffer: Pointer; BufSize, Index: Cardinal; var ResX, ResY: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRectangle                  = function {$else}function  pdfRectangle{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReEncryptPDFA              = function {$else}function  pdfReEncryptPDFA{$endif}(const IPDF: PPDF; const FileName: PAnsiChar; PwdType: Integer; const InPwd, NewOpenPwd, NewOwnerPwd: PAnsiChar; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReEncryptPDFW              = function {$else}function  pdfReEncryptPDFW{$endif}(const IPDF: PPDF; const FileName: PWideChar; PwdType: Integer; const InPwd, NewOpenPwd, NewOwnerPwd: PAnsiChar; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenameSpotColor            = function {$else}function  pdfRenameSpotColor{$endif}(const IPDF: PPDF; const Colorant, NewName: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderAnnotOrField         = function {$else}function  pdfRenderAnnotOrField{$endif}(const IPDF: PPDF; Handle: Cardinal; IsAnnot: LongBool; State: TButtonState; var Matrix: TCTM; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; var OutImage: TPDFBitmap): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPage                 = function {$else}function  pdfRenderPage{$endif}(const IPDF: PPDF; PagePtr: IPGE; RasPtr: IRAS; var Img: TPDFRasterImage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPageEx               = function {$else}function  pdfRenderPageEx{$endif}(const IPDF: PPDF; DC: HDC; var DestX, DestY: Integer; PagePtr: IPGE; RasPtr: IRAS; var Img: TPDFRasterImage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPageToImageA         = function {$else}function  pdfRenderPageToImageA{$endif}(const IPDF: PPDF; PageNum: Cardinal; const OutFile: PAnsiChar; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPageToImageW         = function {$else}function  pdfRenderPageToImageW{$endif}(const IPDF: PPDF; PageNum: Cardinal; const OutFile: PWideChar; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPDFFileA             = function {$else}function  pdfRenderPDFFileA{$endif}(const IPDF: PPDF; const OutFile: PAnsiChar; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPDFFileW             = function {$else}function  pdfRenderPDFFileW{$endif}(const IPDF: PPDF; const OutFile: PWideChar; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPDFFileExA           = function {$else}function  pdfRenderPDFFileExA{$endif}(const IPDF: PPDF; const OutFile: PAnsiChar; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRenderPDFFileExW           = function {$else}function  pdfRenderPDFFileExW{$endif}(const IPDF: PPDF; const OutFile: PWideChar; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReOpenImportFile           = function {$else}function  pdfReOpenImportFile{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceFontA               = function {$else}function  pdfReplaceFontA{$endif}(const IPDF: PPDF; const PDFFont: Pointer; const Name: PAnsiChar; Style: Integer; NameIsFamilyName: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceFontW               = function {$else}function  pdfReplaceFontW{$endif}(const IPDF: PPDF; const PDFFont: Pointer; const Name: PWideChar; Style: Integer; NameIsFamilyName: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceFontExA             = function {$else}function  pdfReplaceFontExA{$endif}(const IPDF: PPDF; const PDFFont: Pointer; const FontFile: PAnsiChar; Embed: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceFontExW             = function {$else}function  pdfReplaceFontExW{$endif}(const IPDF: PPDF; const PDFFont: Pointer; const FontFile: PWideChar; Embed: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceICCProfileA         = function {$else}function  pdfReplaceICCProfileA{$endif}(const IPDF: PPDF; ColorSpace: Cardinal; const ICCFile: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceICCProfileW         = function {$else}function  pdfReplaceICCProfileW{$endif}(const IPDF: PPDF; ColorSpace: Cardinal; const ICCFile: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceICCProfileEx        = function {$else}function  pdfReplaceICCProfileEx{$endif}(const IPDF: PPDF; ColorSpace: Cardinal; const Buffer: Pointer; BufSize: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceImageA              = function {$else}function  pdfReplaceImageA{$endif}(const IPDF: PPDF; var Source: TPDFImage; const Image: PAnsiChar; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceImageW              = function {$else}function  pdfReplaceImageW{$endif}(const IPDF: PPDF; var Source: TPDFImage; const Image: PWideChar; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplaceImageEx             = function {$else}function  pdfReplaceImageEx{$endif}(const IPDF: PPDF; var Source: TPDFImage; const Buffer: Pointer; BufSize, Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplacePageTextA           = function {$else}function  pdfReplacePageTextA{$endif}(const IPDF: PPDF; const NewText: PAnsiChar; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplacePageTextExA         = function {$else}function  pdfReplacePageTextExA{$endif}(const IPDF: PPDF; const NewText: PAnsiChar; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfReplacePageTextExW         = function {$else}function  pdfReplacePageTextExW{$endif}(const IPDF: PPDF; const NewText: PWideChar; var Stack: TPDFStack): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfResetAnnotAP               = function {$else}function  pdfResetAnnotAP{$endif}(const IPDF: PPDF; Handle: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfResetEncryptionSettings    = function {$else}function  pdfResetEncryptionSettings{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfResetLineDashPattern       = function {$else}function  pdfResetLineDashPattern{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRestoreGraphicState        = function {$else}function  pdfRestoreGraphicState{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRotateCoords               = function {$else}function  pdfRotateCoords{$endif}(const IPDF: PPDF; alpha, OriginX, OriginY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRoundRect                  = function {$else}function  pdfRoundRect{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, Radius: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfRoundRectEx                = function {$else}function  pdfRoundRectEx{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, rWidth, rHeight: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSaveGraphicState           = function {$else}function  pdfSaveGraphicState{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfScaleCoords                = function {$else}function  pdfScaleCoords{$endif}(const IPDF: PPDF; sx, sy: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSelfTest                   = function {$else}function  pdfSelfTest{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSet3DAnnotProps            = function {$else}function  pdfSet3DAnnotProps{$endif}(const IPDF: PPDF; Annot: Cardinal; ActType, DeActType, InstType, DeInstType: Integer; DisplToolbar, DisplModelTree: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSet3DAnnotScriptA          = function {$else}function  pdfSet3DAnnotScriptA{$endif}(const IPDF: PPDF; Annot: Cardinal; const Value: PAnsiChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetActiveSigField          = function {$else}function  pdfSetActiveSigField{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfSetAllocBy                 = function {$else}function  pdfSetAllocBy{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAltFontsW               = function {$else}function  pdfSetAltFontsW{$endif}(const IPDF: Pointer; ListHandle: Cardinal; const List: PPWideChar; Count: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotBorderEffect       = function {$else}function  pdfSetAnnotBorderEffect{$endif}(const IPDF: PPDF; Handle: Cardinal; Value: TBorderEffect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotBorderStyle        = function {$else}function  pdfSetAnnotBorderStyle{$endif}(const IPDF: PPDF; Handle: Cardinal; Style: TBorderStyle): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotBorderWidth        = function {$else}function  pdfSetAnnotBorderWidth{$endif}(const IPDF: PPDF; Handle: Cardinal; LineWidth: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotColor              = function {$else}function  pdfSetAnnotColor{$endif}(const IPDF: PPDF; Handle: Cardinal; ColorType: TAnnotColor; CS: TPDFColorSpace; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotFlags              = function {$else}function  pdfSetAnnotFlags{$endif}(const IPDF: PPDF; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotFlagsEx            = function {$else}function  pdfSetAnnotFlagsEx{$endif}(const IPDF: PPDF; Handle: Cardinal; Flags: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotHighlightMode      = function {$else}function  pdfSetAnnotHighlightMode{$endif}(const IPDF: PPDF; Handle: Cardinal; Mode: THighlightMode): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotIcon               = function {$else}function  pdfSetAnnotIcon{$endif}(const IPDF: PPDF; Handle: Cardinal; Icon: TAnnotIcon): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotLineDashPattern    = function {$else}function  pdfSetAnnotLineDashPattern{$endif}(const IPDF: PPDF; Handle: Cardinal; const Dash: PSingle; NumValues: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotLineEndStyle       = function {$else}function  pdfSetAnnotLineEndStyle{$endif}(const IPDF: PPDF; Handle: Cardinal; LE1, LE2: TLineEndStyle): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotMigrationStateA    = function {$else}function  pdfSetAnnotMigrationStateA{$endif}(const IPDF: PPDF; Annot: Cardinal; State: TAnnotState; const User: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotMigrationStateW    = function {$else}function  pdfSetAnnotMigrationStateW{$endif}(const IPDF: PPDF; Annot: Cardinal; State: TAnnotState; const User: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotOpacity            = function {$else}function  pdfSetAnnotOpacity{$endif}(const IPDF: PPDF; Handle: Cardinal; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotOpenState          = function {$else}function  pdfSetAnnotOpenState{$endif}(const IPDF: PPDF; Handle: Cardinal; Open: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotOrFieldDate        = function {$else}function  pdfSetAnnotOrFieldDate{$endif}(const IPDF: PPDF; Handle: Cardinal; IsField: LongBool; DateType: TDateType; DateTime: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotQuadPoints         = function {$else}function  pdfSetAnnotQuadPoints{$endif}(const IPDF: PPDF; Handle: Cardinal; Value: PFltPoint; Count: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotStringA            = function {$else}function  pdfSetAnnotStringA{$endif}(const IPDF: PPDF; Handle: Cardinal; StringType: Integer; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotStringW            = function {$else}function  pdfSetAnnotStringW{$endif}(const IPDF: PPDF; Handle: Cardinal; StringType: Integer; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotSubjectA           = function {$else}function  pdfSetAnnotSubjectA{$endif}(const IPDF: PPDF; Handle: Cardinal; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetAnnotSubjectW           = function {$else}function  pdfSetAnnotSubjectW{$endif}(const IPDF: PPDF; Handle: Cardinal; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetBBox                    = function {$else}function  pdfSetBBox{$endif}(const IPDF: PPDF; Boundary: TPageBoundary; LeftX, LeftY, RightX, RightY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetBidiMode                = function {$else}function  pdfSetBidiMode{$endif}(const IPDF: PPDF; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetBookmarkDest            = function {$else}function  pdfSetBookmarkDest{$endif}(const IPDF: PPDF; ABmk, DestType: Integer; a, b, c, d: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetBookmarkStyle           = function {$else}function  pdfSetBookmarkStyle{$endif}(const IPDF: PPDF; ABmk: Integer; Style: TFStyle; RGBColor: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetBorderStyle             = function {$else}function  pdfSetBorderStyle{$endif}(const IPDF: PPDF; Style: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCharacterSpacing        = function {$else}function  pdfSetCharacterSpacing{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCheckBoxChar            = function {$else}function  pdfSetCheckBoxChar{$endif}(const IPDF: PPDF; CheckBoxChar: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCheckBoxDefState        = function {$else}function  pdfSetCheckBoxDefState{$endif}(const IPDF: PPDF; AField: Cardinal; Checked: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCheckBoxState           = function {$else}function  pdfSetCheckBoxState{$endif}(const IPDF: PPDF; AField: Cardinal; Checked: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCIDFontA                = function {$else}function  pdfSetCIDFontA{$endif}(const IPDF: PPDF; CMapHandle: Cardinal; const Name: PAnsiChar; Style: Integer; Size: Double; Embed: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCIDFontW                = function {$else}function  pdfSetCIDFontW{$endif}(const IPDF: PPDF; CMapHandle: Cardinal; const Name: PWideChar; Style: Integer; Size: Double; Embed: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCMapDirA                = function {$else}function  pdfSetCMapDirA{$endif}(const IPDF: PPDF; const Path: PAnsiChar; Recursive: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCMapDirW                = function {$else}function  pdfSetCMapDirW{$endif}(const IPDF: PPDF; const Path: PWideChar; Recursive: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetColDefFile              = function {$else}function  pdfSetColDefFile{$endif}(const IPDF: PPDF; EmbFile: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetColorMask               = function {$else}function  pdfSetColorMask{$endif}(const IPDF: PPDF; ImageHandle: Cardinal; Mask: PInteger; Count: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetColors                  = function {$else}function  pdfSetColors{$endif}(const IPDF: PPDF; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetColorSpace              = function {$else}function  pdfSetColorSpace{$endif}(const IPDF: PPDF; ColorSpace: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetColSortField            = function {$else}function  pdfSetColSortField{$endif}(const IPDF: PPDF; ColField: Cardinal; AscendingOrder: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCompressionFilter       = function {$else}function  pdfSetCompressionFilter{$endif}(const IPDF: PPDF; Filter: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetCompressionLevel        = function {$else}function  pdfSetCompressionLevel{$endif}(const IPDF: PPDF; CompressLevel: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetContent                 = function {$else}function  pdfSetContent{$endif}(const IPDF: PPDF; const Buffer: PAnsiChar; BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDateTimeFormat          = function {$else}function  pdfSetDateTimeFormat{$endif}(const IPDF: PPDF; TxtField: Cardinal; Fmt: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDefBitsPerPixel         = function {$else}function  pdfSetDefBitsPerPixel{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDocInfoA                = function {$else}function  pdfSetDocInfoA{$endif}(const IPDF: PPDF; DInfo: TDocumentInfo; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDocInfoW                = function {$else}function  pdfSetDocInfoW{$endif}(const IPDF: PPDF; DInfo: TDocumentInfo; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDocInfoExA              = function {$else}function  pdfSetDocInfoExA{$endif}(const IPDF: PPDF; DInfo: TDocumentInfo; const Key, Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDocInfoExW              = function {$else}function  pdfSetDocInfoExW{$endif}(const IPDF: PPDF; DInfo: TDocumentInfo; const Key: PAnsiChar; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetDrawDirection           = function {$else}function  pdfSetDrawDirection{$endif}(const IPDF: PPDF; Direction: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetEMFFrameDPI             = function {$else}function  pdfSetEMFFrameDPI{$endif}(const IPDF: PPDF; DPIX, DPIY: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetEMFPatternDistance      = function {$else}function  pdfSetEMFPatternDistance{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetErrorMode               = function {$else}function  pdfSetErrorMode{$endif}(const IPDF: PPDF; ErrMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetExtColorSpace           = function {$else}function  pdfSetExtColorSpace{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetExtFillColorSpace       = function {$else}function  pdfSetExtFillColorSpace{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetExtGState               = function {$else}function  pdfSetExtGState{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetExtStrokeColorSpace     = function {$else}function  pdfSetExtStrokeColorSpace{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldBackColor          = function {$else}function  pdfSetFieldBackColor{$endif}(const IPDF: PPDF; AColor: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldBBox               = function {$else}function  pdfSetFieldBBox{$endif}(const IPDF: PPDF; AField: Cardinal; var BBox: TPDFRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldBorderColor        = function {$else}function  pdfSetFieldBorderColor{$endif}(const IPDF: PPDF; AColor: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldBorderStyle        = function {$else}function  pdfSetFieldBorderStyle{$endif}(const IPDF: PPDF; AField: Cardinal; Style: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldBorderWidth        = function {$else}function  pdfSetFieldBorderWidth{$endif}(const IPDF: PPDF; AField: Cardinal; LineWidth: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldCalcOrder          = function {$else}function  pdfSetFieldCalcOrder{$endif}(const IPDF: PPDF; CurrIndex: Integer; NewIndex: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldColor              = function {$else}function  pdfSetFieldColor{$endif}(const IPDF: PPDF; AField: Cardinal; ColorType, CS: Integer; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldExpValue           = function {$else}function  pdfSetFieldExpValue{$endif}(const IPDF: PPDF; AField, ValIndex: Cardinal; const Value: PAnsiChar; const ExpValue: PAnsiChar; Selected: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldExpValueW          = function {$else}function  pdfSetFieldExpValueW{$endif}(const IPDF: PPDF; AField, ValIndex: Cardinal; const Value: PWideChar; const ExpValue: PAnsiChar; Selected: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldExpValueEx         = function {$else}function  pdfSetFieldExpValueEx{$endif}(const IPDF: PPDF; AField, ValIndex: Cardinal; Selected, DefSelected: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldFlags              = function {$else}function  pdfSetFieldFlags{$endif}(const IPDF: PPDF; AField: Cardinal; Flags: Integer; Reset: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldFontA              = function {$else}function  pdfSetFieldFontA{$endif}(const IPDF: PPDF; Field: Cardinal; const Name: PAnsiChar; Style: Integer; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldFontW              = function {$else}function  pdfSetFieldFontW{$endif}(const IPDF: PPDF; Field: Cardinal; const Name: PWideChar; Style: Integer; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldFontEx             = function {$else}function  pdfSetFieldFontEx{$endif}(const IPDF: PPDF; Field, Handle: Cardinal; FontSize: double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldFontSize           = function {$else}function  pdfSetFieldFontSize{$endif}(const IPDF: PPDF; AField: Cardinal; FontSize: double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldHighlightMode      = function {$else}function  pdfSetFieldHighlightMode{$endif}(const IPDF: PPDF; AField: Cardinal; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldIndex              = function {$else}function  pdfSetFieldIndex{$endif}(const IPDF: PPDF; AField, Index: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldMapNameA           = function {$else}function  pdfSetFieldMapNameA{$endif}(const IPDF: PPDF; AField: Cardinal; const Name: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldMapNameW           = function {$else}function  pdfSetFieldMapNameW{$endif}(const IPDF: PPDF; AField: Cardinal; const Name: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldNameA              = function {$else}function  pdfSetFieldNameA{$endif}(const IPDF: PPDF; AField: Cardinal; const NewName: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldNameW              = function {$else}function  pdfSetFieldNameW{$endif}(const IPDF: PPDF; AField: Cardinal; const NewName: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldOrientation        = function {$else}function  pdfSetFieldOrientation{$endif}(const IPDF: PPDF; AField: Cardinal; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldTextAlign          = function {$else}function  pdfSetFieldTextAlign{$endif}(const IPDF: PPDF; AField: Cardinal; Align: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldTextColor          = function {$else}function  pdfSetFieldTextColor{$endif}(const IPDF: PPDF; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldToolTipA           = function {$else}function  pdfSetFieldToolTipA{$endif}(const IPDF: PPDF; AField: Cardinal; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFieldToolTipW           = function {$else}function  pdfSetFieldToolTipW{$endif}(const IPDF: PPDF; AField: Cardinal; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFillColor               = function {$else}function  pdfSetFillColor{$endif}(const IPDF: PPDF; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFillColorEx             = function {$else}function  pdfSetFillColorEx{$endif}(const IPDF: PPDF; const Color: PByte; NumComponents: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFillColorF              = function {$else}function  pdfSetFillColorF{$endif}(const IPDF: PPDF; const Color: PSingle; NumComponents: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFillColorSpace          = procedure{$else}procedure pdfSetFillColorSpace{$endif}(const IPDF: PPDF; CS: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFloatPrecision          = function {$else}function  pdfSetFloatPrecision{$endif}(const IPDF: PPDF; NumTextDecDigits, NumVectDecDigits: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontA                   = function {$else}function  pdfSetFontA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontW                   = function {$else}function  pdfSetFontW{$endif}(const IPDF: PPDF; const Name: PWideChar; Style: TFStyle; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontExA                 = function {$else}function  pdfSetFontExA{$endif}(const IPDF: PPDF; const Name: PAnsiChar; Style: Integer; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontExW                 = function {$else}function  pdfSetFontExW{$endif}(const IPDF: PPDF; const Name: PWideChar; Style: Integer; Size: Double; Embed: LongBool; CP: TCodepage): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontOrigin              = function {$else}function  pdfSetFontOrigin{$endif}(const IPDF: PPDF; Origin: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontSearchOrder         = procedure{$else}procedure pdfSetFontSearchOrder{$endif}(const IPDF: PPDF; Order: PFontBaseType{Array[0..3] of TFontBaseType}); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontSearchOrderEx       = procedure{$else}procedure pdfSetFontSearchOrderEx{$endif}(const IPDF: PPDF; S1, S2, S3, S4: TFontBaseType); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontSelMode             = function {$else}function  pdfSetFontSelMode{$endif}(const IPDF: PPDF; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetFontWeight              = function {$else}function  pdfSetFontWeight{$endif}(const IPDF: PPDF; Weight: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetGStateFlags             = function {$else}function  pdfSetGStateFlags{$endif}(const IPDF: PPDF; Flags: TGStateFlags; Reset: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetIconColor               = function {$else}function  pdfSetIconColor{$endif}(const IPDF: PPDF; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetImportFlags             = function {$else}function  pdfSetImportFlags{$endif}(const IPDF: PPDF; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetImportFlags2            = function {$else}function  pdfSetImportFlags2{$endif}(const IPDF: PPDF; Flags: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetItalicAngle             = function {$else}function  pdfSetItalicAngle{$endif}(const IPDF: PPDF; Angle: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetJPEGQuality             = function {$else}function  pdfSetJPEGQuality{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLanguage                = function {$else}function  pdfSetLanguage{$endif}(const IPDF: PPDF; const ISOTag: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLeading                 = function {$else}function  pdfSetLeading{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLicenseKey              = function {$else}function  pdfSetLicenseKey{$endif}(const IPDF: PPDF; const Key: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineAnnotParms          = function {$else}function  pdfSetLineAnnotParms{$endif}(const IPDF: PPDF; Handle: Cardinal; FontHandle: Integer; FontSize: Double; const Parms: PLineAnnotParms): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineAnnotPoints         = function {$else}function  pdfSetLineAnnotPoints{$endif}(const IPDF: PPDF; Handle: Cardinal; P1, P2:  PFltPoint): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfSetLineCapStyle            = function {$else}function  pdfSetLineCapStyle{$endif}(const IPDF: PPDF; Style: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineDashPattern         = function {$else}function  pdfSetLineDashPattern{$endif}(const IPDF: PPDF; const Dash: PAnsiChar; Phase: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineDashPattern2        = function {$else}function  pdfSetLineDashPattern2{$endif}(const IPDF: PPDF; const Dash: PSingle; NumValues: Cardinal; Phase: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineDashPatternEx       = function {$else}function  pdfSetLineDashPatternEx{$endif}(const IPDF: PPDF; const Dash: Pointer; NumValues: Cardinal; Phase: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineJoinStyle           = function {$else}function  pdfSetLineJoinStyle{$endif}(const IPDF: PPDF; Style: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLineWidth               = function {$else}function  pdfSetLineWidth{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetLinkHighlightMode       = function {$else}function  pdfSetLinkHighlightMode{$endif}(const IPDF: PPDF; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetListFont                = function {$else}function  pdfSetListFont{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMatrix                  = function {$else}function  pdfSetMatrix{$endif}(const IPDF: PPDF; var Matrix: TCTM): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMaxErrLogMsgCount       = procedure{$else}procedure pdfSetMaxErrLogMsgCount{$endif}(const IPDF: PPDF; Value: Cardinal); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMaxFieldLen             = function {$else}function  pdfSetMaxFieldLen{$endif}(const IPDF: PPDF; TxtField: Cardinal; MaxLen: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMetaConvFlags           = function {$else}function  pdfSetMetaConvFlags{$endif}(const IPDF: PPDF; Flags: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMetadata                = function {$else}function  pdfSetMetadata{$endif}(const IPDF: PPDF; ObjType: TMetadataObj; Handle: Integer; const Buffer: Pointer; BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetMiterLimit              = function {$else}function  pdfSetMiterLimit{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetNeedAppearance          = function {$else}function  pdfSetNeedAppearance{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetNumberFormat            = function {$else}function  pdfSetNumberFormat{$endif}(const IPDF: PPDF; TxtField: Cardinal; Sep: Integer; DecPlaces: Cardinal; NegStyle: Integer; const CurrStr: PAnsiChar; Prepend: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOCGContUsage            = function {$else}function  pdfSetOCGContUsage{$endif}(const IPDF: PPDF; Handle: Cardinal; var Value: TPDFOCGContUsage): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOCGState                = function {$else}function  pdfSetOCGState{$endif}(const IPDF: PPDF; Handle: Cardinal; Visible, SaveState: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOnErrorProc             = function {$else}function  pdfSetOnErrorProc{$endif}(const IPDF: PPDF; const Data: Pointer; ErrProc: TErrorProc): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOnPageBreakProc         = function {$else}function  pdfSetOnPageBreakProc{$endif}(const IPDF: PPDF; const Data: Pointer; OnBreakProc: TOnPageBreakProc): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOpacity                 = function {$else}function  pdfSetOpacity{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOrientation             = function {$else}function  pdfSetOrientation{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetOrientationEx           = function {$else}function  pdfSetOrientationEx{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageBBox                = function {$else}function  pdfSetPageBBox{$endif}(PagePtr: IPGE; Boundary: TPageBoundary; var BBox: TFltRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageCoords              = function {$else}function  pdfSetPageCoords{$endif}(const IPDF: PPDF; PageCoords: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageFormat              = function {$else}function  pdfSetPageFormat{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageHeight              = function {$else}function  pdfSetPageHeight{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageLayout              = function {$else}function  pdfSetPageLayout{$endif}(const IPDF: PPDF; Layout: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageMode                = function {$else}function  pdfSetPageMode{$endif}(const IPDF: PPDF; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageOrientation         = function {$else}function  pdfSetPageOrientation{$endif}(const IPDF: PPDF; PagePtr: IPGE; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPageWidth               = function {$else}function  pdfSetPageWidth{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPDFVersion              = function {$else}function  pdfSetPDFVersion{$endif}(const IPDF: PPDF; Version: TPDFVersion): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetPrintSettings           = function {$else}function  pdfSetPrintSettings{$endif}(const IPDF: PPDF; Mode: TDuplexMode; PickTrayByPDFSize: Integer; NumCopies: Cardinal; PrintScaling: TPrintScaling; const PrintRanges: PCardinal; NumRanges: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetProgressProc            = function {$else}function  pdfSetProgressProc{$endif}(const IPDF: PPDF; const Data: Pointer; InitProgress: TInitProgressProc; Progress: TProgressProc): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetRenderingIntent         = function {$else}function  pdfSetRenderingIntent{$endif}(const IPDF: Pointer; ImgHandle: Cardinal; Value: TRenderingIntent): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetResolution              = function {$else}function  pdfSetResolution{$endif}(const IPDF: PPDF; Value: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetSaveNewImageFormat      = function {$else}function  pdfSetSaveNewImageFormat{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetSeparationInfo          = function {$else}function  pdfSetSeparationInfo{$endif}(const IPDF: PPDF; Handle: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetSpaceWidthFactor        = function {$else}function  pdfSetSpaceWidthFactor{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetStrokeColor             = function {$else}function  pdfSetStrokeColor{$endif}(const IPDF: PPDF; Color: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetStrokeColorEx           = function {$else}function  pdfSetStrokeColorEx{$endif}(const IPDF: PPDF; const Color: PByte; NumComponents: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetStrokeColorF            = function {$else}function  pdfSetStrokeColorF{$endif}(const IPDF: PPDF; const Color: PSingle; NumComponents: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetStrokeColorSpace        = procedure{$else}procedure pdfSetStrokeColorSpace{$endif}(const IPDF: PPDF; CS: Integer); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTabLen                  = function {$else}function  pdfSetTabLen{$endif}(const IPDF: PPDF; TabLen: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTemplBBox               = function {$else}function  pdfSetTemplBBox{$endif}(const IPDF: PPDF; Handle: Cardinal; Boundary: TPageBoundary; var BBox: TPDFRect): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextDrawMode            = function {$else}function  pdfSetTextDrawMode{$endif}(const IPDF: PPDF; Mode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextFieldValueA         = function {$else}function  pdfSetTextFieldValueA{$endif}(const IPDF: PPDF; Field: Cardinal; const Value, DefValue: PAnsiChar; Align: TTextAlign): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextFieldValueW         = function {$else}function  pdfSetTextFieldValueW{$endif}(const IPDF: PPDF; Field: Cardinal; const Value, DefValue: PWideChar; Align: TTextAlign): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextRect                = function {$else}function  pdfSetTextRect{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextRise                = function {$else}function  pdfSetTextRise{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextScaling             = function {$else}function  pdfSetTextScaling{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTrapped                 = procedure{$else}procedure pdfSetTrapped{$endif}(const IPDF: PPDF; Value: LongBool); {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTransparentColor        = function {$else}function  pdfSetTransparentColor{$endif}(const IPDF: PPDF; AColor: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseExactPwd             = function {$else}function  pdfSetUseExactPwd{$endif}(const IPDF: PPDF; Value: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseGlobalImpFiles       = function {$else}function  pdfSetUseGlobalImpFiles{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseImageInterpolation   = function {$else}function  pdfSetUseImageInterpolation{$endif}(const IPDF: PPDF; Handle: Cardinal; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseImageInterpolationEx = function {$else}function  pdfSetUseImageInterpolationEx{$endif}(const Image: PIMG; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUserUnit                = function {$else}function  pdfSetUserUnit{$endif}(const IPDF: PPDF; Value: Single): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseStdFonts             = function {$else}function  pdfSetUseStdFonts{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseSwapFile             = function {$else}function  pdfSetUseSwapFile{$endif}(const IPDF: PPDF; SwapContents: LongBool; SwapLimit: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseSwapFileEx           = function {$else}function  pdfSetUseSwapFileEx{$endif}(const IPDF: PPDF; SwapContents: LongBool; SwapLimit: Cardinal; const SwapDir: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseSystemFonts          = function {$else}function  pdfSetUseSystemFonts{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseTransparency         = function {$else}function  pdfSetUseTransparency{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetUseVisibleCoords        = function {$else}function  pdfSetUseVisibleCoords{$endif}(const IPDF: PPDF; Value: LongBool): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetViewerPreferences       = function {$else}function  pdfSetViewerPreferences{$endif}(const IPDF: PPDF; Value, AddVal: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetWMFDefExtent            = function {$else}function  pdfSetWMFDefExtent{$endif}(const IPDF: PPDF; Width, Height: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetWMFPixelPerInch         = function {$else}function  pdfSetWMFPixelPerInch{$endif}(const IPDF: PPDF; Value: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetWordSpacing             = function {$else}function  pdfSetWordSpacing{$endif}(const IPDF: PPDF; Value: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetXFAStream               = function {$else}function  pdfSetXFAStream{$endif}(const IPDF: PPDF; Index: Cardinal; const Buffer: Pointer; BufSize: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSkewCoords                 = function {$else}function  pdfSkewCoords{$endif}(const IPDF: PPDF; alpha, beta, OriginX, OriginY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSortFieldsByIndex          = function {$else}function  pdfSortFieldsByIndex{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSortFieldsByName           = function {$else}function  pdfSortFieldsByName{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSquareAnnotA               = function {$else}function  pdfSquareAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSquareAnnotW               = function {$else}function  pdfSquareAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfStampAnnotA                = function {$else}function  pdfStampAnnotA{$endif}(const IPDF: PPDF; SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfStampAnnotW                = function {$else}function  pdfStampAnnotW{$endif}(const IPDF: PPDF; SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfStrokePath                 = function {$else}function  pdfStrokePath{$endif}(const IPDF: PPDF): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTextAnnotA                 = function {$else}function  pdfTextAnnotA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, Text: PAnsiChar; Icon: TAnnotIcon; Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTextAnnotW                 = function {$else}function  pdfTextAnnotW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const Author, Text: PWideChar; Icon: TAnnotIcon; Open: LongBool): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextFieldValueExA       = function {$else}function  pdfSetTextFieldValueExA{$endif}(const IPDF: PPDF; Field: Cardinal; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfSetTextFieldValueExW       = function {$else}function  pdfSetTextFieldValueExW{$endif}(const IPDF: PPDF; Field: Cardinal; const Value: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTestGlyphsA                = function {$else}function  pdfTestGlyphsA{$endif}(const IPDF: PPDF; FontHandle: Integer; const Text: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTestGlyphsW                = function {$else}function  pdfTestGlyphsW{$endif}(const IPDF: PPDF; FontHandle: Integer; const Text: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTestGlyphsExA              = function {$else}function  pdfTestGlyphsExA{$endif}(const IPDF: PPDF; FontHandle: Integer; const Text: PAnsiChar; Len: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTestGlyphsExW              = function {$else}function  pdfTestGlyphsExW{$endif}(const IPDF: PPDF; FontHandle: Integer; const Text: PWideChar; Len: Cardinal): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTestPassword               = function {$else}function  pdfTestPassword{$endif}(const IPDF: PPDF; PwdType: TPwdType; const Value: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB {$ifdef LDELAYED}delayed{$endif};{$endif}
   {$ifdef DYNLNK}pdfTranslateCoords            = function {$else}function  pdfTranslateCoords{$endif}(const IPDF: PPDF; NewOriginX, NewOriginY: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfTriangle                   = function {$else}function  pdfTriangle{$endif}(const IPDF: PPDF; x1, y1, x2, y2, x3, y3: Double; FillMode: Integer): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfUnLockLayer                = function {$else}function  pdfUnLockLayer{$endif}(const IPDF: PPDF; Layer: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfUTF16ToUTF32               = function {$else}function  pdfUTF16ToUTF32{$endif}(const IPDF: PPDF; const Source: PWideChar): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfUTF16ToUTF32Ex             = function {$else}function  pdfUTF16ToUTF32Ex{$endif}(const IPDF: PPDF; const Source: PWideChar; var Len: Cardinal): Pointer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfUTF32ToUTF16               = function {$else}function  pdfUTF32ToUTF16{$endif}(const IPDF: PPDF; const Source: Pointer): PWideChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfUTF32ToUTF16Ex             = function {$else}function  pdfUTF32ToUTF16Ex{$endif}(const IPDF: PPDF; const Source: Pointer; var Len: Cardinal): PWideChar; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWatermarkAnnot             = function {$else}function  pdfWatermarkAnnot{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWebLinkA                   = function {$else}function  pdfWebLinkA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const URL: PAnsiChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWebLinkW                   = function {$else}function  pdfWebLinkW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; const URL: PWideChar): Integer; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteAngleTextA            = function {$else}function  pdfWriteAngleTextA{$endif}(const IPDF: PPDF; const AText: PAnsiChar; Angle, PosX, PosY, Radius, YOrigin: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteAngleTextW            = function {$else}function  pdfWriteAngleTextW{$endif}(const IPDF: PPDF; const AText: PWideChar; Angle, PosX, PosY, Radius, YOrigin: Double): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteFTextA                = function {$else}function  pdfWriteFTextA{$endif}(const IPDF: PPDF; Align: TTextAlign; const AText: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteFTextW                = function {$else}function  pdfWriteFTextW{$endif}(const IPDF: PPDF; Align: TTextAlign; const AText: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteFTextExA              = function {$else}function  pdfWriteFTextExA{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; Align: Integer; const AText: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteFTextExW              = function {$else}function  pdfWriteFTextExW{$endif}(const IPDF: PPDF; PosX, PosY, Width, Height: Double; Align: Integer; const AText: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextMatrixA           = function {$else}function  pdfWriteTextMatrixA{$endif}(const IPDF: PPDF; var Matrix: TCTM; const AText: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextMatrixW           = function {$else}function  pdfWriteTextMatrixW{$endif}(const IPDF: PPDF; var Matrix: TCTM; const AText: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextMatrixExA         = function {$else}function  pdfWriteTextMatrixExA{$endif}(const IPDF: PPDF; var M: TCTM; const AText: PAnsiChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextMatrixExW         = function {$else}function  pdfWriteTextMatrixExW{$endif}(const IPDF: PPDF; var M: TCTM; const AText: PWideChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextA                 = function {$else}function  pdfWriteTextA{$endif}(const IPDF: PPDF; PosX, PosY: Double; const AText: PAnsiChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextW                 = function {$else}function  pdfWriteTextW{$endif}(const IPDF: PPDF; PosX, PosY: Double; const AText: PWideChar): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextExA               = function {$else}function  pdfWriteTextExA{$endif}(const IPDF: PPDF; PosX, PosY: Double; const AText: PAnsiChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}
   {$ifdef DYNLNK}pdfWriteTextExW               = function {$else}function  pdfWriteTextExW{$endif}(const IPDF: PPDF; PosX, PosY: Double; const AText: PWideChar; Len: Cardinal): LongBool; {$ifdef MSWINDOWS}stdcall{$else}cdecl{$endif}; {$ifndef DYNLNK} external DYNAPDFLIB{$ifdef MSWINDOWS} delayed;{$endif}{$endif}

   
type TPDF = class(TObject)
 private
   FInstance: Pointer;
 public
 {$ifdef MSWINDOWS}
   constructor Create(const LibName: WideString = 'dynapdf.dll');
 {$else}
   {$if defined(MACOS)}
      constructor Create(const LibName: WideString = 'libdynapdf.dylib');
   {$elseif defined(ANDROID32)}
      constructor Create(const LibName: WideString = 'libdynapdf32.so');
   {$elseif defined(ANDROID64)}
      constructor Create(const LibName: WideString = 'libdynapdf64.so');
   {$else}
      constructor Create(const LibName: WideString = 'libdynapdf.so');
   {$ifend}
{$endif}
   destructor Destroy(); override;
   procedure Abort(RasPtr: IRAS);
   function ActivateAltFontList(Handle: Integer; EnableSysFonts: Boolean): Boolean;
   function AddActionToObj(ObjType: TObjType; Event: TObjEvent; ActHandle, ObjHandle: Cardinal): Integer;
   function AddAnnotToPage(PageNum, Handle: Cardinal): Boolean;
   function AddArticle(PosX, PosY, Width, Height: Double): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddBookmark(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer; overload;
   function AddBookmark(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer; overload;
{$endif}
   function AddBookmarkA(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
   function AddBookmarkW(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddBookmarkEx(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer; overload;
   function AddBookmarkEx(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer; overload;
{$endif}
   function AddBookmarkExA(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
   function AddBookmarkExW(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddBookmarkEx2(const Title: AnsiString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer; overload;
   function AddBookmarkEx2(const Title: AnsiString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer; overload;
   function AddBookmarkEx2(const Title: WideString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer; overload;
   function AddBookmarkEx2(const Title: WideString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer; overload;
{$endif}
   function AddBookmarkEx2AA(const Title: AnsiString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
   function AddBookmarkEx2AW(const Title: AnsiString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
   function AddBookmarkEx2WA(const Title: WideString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
   function AddBookmarkEx2WW(const Title: WideString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddButtonImage(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: AnsiString): Boolean; overload;
   function AddButtonImage(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: WideString): Boolean; overload;
{$else}
   function AddButtonImage(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: AnsiString): Boolean;
{$endif}
   function AddButtonImageA(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: AnsiString): Boolean;
   function AddButtonImageW(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: WideString): Boolean;
   function AddButtonImageEx(BtnHandle: Cardinal; State: TButtonState; const Caption: AnsiString; Handle: HBITMAP): Boolean;
   function AddButtonImageEx2(BtnHandle: Cardinal; State: TButtonState; const Caption: WideString; const Buffer: Pointer; BufSize: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function AddContinueText(const AText: AnsiString): Integer; overload;
   function AddContinueText(const AText: WideString): Integer; overload;
{$endif}
   function AddContinueTextA(const AText: AnsiString): Integer;
   function AddContinueTextW(const AText: WideString): Integer;
   function AddDeviceNProcessColorants(DeviceNCS: Cardinal; const Colorants: Array of AnsiString; NumColorants: Cardinal; ProcessCS: TExtColorSpace; Handle: Integer): Boolean;
   function AddDeviceNSeparations(DeviceNCS: Cardinal; const Colorants: Array of AnsiString; SeparationCS: Array of Integer; NumColorants: Cardinal): Boolean;
   function AddDPartNode(Parent, FirstPage, LastPage: Integer; const DPM: AnsiString): Integer;
   function AddFieldToFormAction(Action, AField: Cardinal; Include: Boolean): Integer;
   function AddFieldToHideAction(HideAct, AField: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddFileComment(const AText: AnsiString): Boolean; overload;
   function AddFileComment(const AText: WideString): Boolean; overload;
{$endif}
   function AddFileCommentA(const AText: AnsiString): Boolean;
   function AddFileCommentW(const AText: WideString): Boolean;
   function AddHeaderFooter(var Value: TPDFHeaderFooter; var HFArray: Array of TPDFHdrFtr): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function AddFontSearchPath(const APath: AnsiString; Recursive: Boolean): Integer; overload;
   function AddFontSearchPath(const APath: WideString; Recursive: Boolean): Integer; overload;
{$endif}
   function AddFontSearchPathA(const APath: AnsiString; Recursive: Boolean): Integer;
   function AddFontSearchPathW(const APath: WideString; Recursive: Boolean): Integer;
   function AddImage(Filter: TCompressionFilter; Flags: TImageConversionFlags; var Image: TPDFImage): Boolean;
   function AddInkList(InkAnnot: Cardinal; Points: PFltPoint; NumPoints: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function AddJavaScript(const Name, Script: AnsiString): Integer; overload;
   function AddJavaScript(const Name: AnsiString; const Script: WideString): Integer; overload;
{$endif}
   function AddJavaScriptA(const Name, Script: AnsiString): Integer;
   function AddJavaScriptW(const Name: AnsiString; const Script: WideString): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddLayerToDisplTree(Parent: Pointer; Layer: Integer; const Title: AnsiString): Pointer; overload;
   function AddLayerToDisplTree(Parent: Pointer; Layer: Integer; const Title: WideString): Pointer; overload;
{$endif}
   function AddLayerToDisplTreeA(Parent: Pointer; Layer: Integer; const Title: AnsiString): Pointer;
   function AddLayerToDisplTreeW(Parent: Pointer; Layer: Integer; const Title: WideString): Pointer;
   function AddObjectToLayer(OCG: Cardinal; ObjType: TOCObject; Handle: Cardinal): Boolean;
   function AddOCGToAppEvent(Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory): Boolean;
   function AddMaskImage(BaseImage: Cardinal; const Buffer: Pointer; BufSize: Cardinal; Stride: Integer; BitsPerPixel, Width, Height: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function AddOutputIntent(const ICCFile: AnsiString): Integer; overload;
   function AddOutputIntent(const ICCFile: WideString): Integer; overload;
{$endif}
   function AddOutputIntentA(const ICCFile: AnsiString): Integer;
   function AddOutputIntentW(const ICCFile: WideString): Integer;
   function AddOutputIntentEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddPageLabel(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: AnsiString; AddNum: Integer): Integer; overload;
   function AddPageLabel(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: WideString; AddNum: Integer): Integer; overload;
{$endif}
   function AddPageLabelA(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: AnsiString; AddNum: Integer): Integer;
   function AddPageLabelW(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: WideString; AddNum: Integer): Integer;
   function AddRasImage(RasPtr: IRAS; Filter: TCompressionFilter): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   // These functions were incorrectly named. Please use AddOuputIntent() instead
   function AddRenderingIntent(const ICCFile: AnsiString): Integer; overload;
   function AddRenderingIntent(const ICCFile: WideString): Integer; overload;
{$endif}
   function AddRenderingIntentA(const ICCFile: AnsiString): Integer;
   function AddRenderingIntentW(const ICCFile: WideString): Integer;
   function AddRenderingIntentEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function AddValToChoiceField(Field: Cardinal; const ExpValue: AnsiString; const Value: AnsiString; Selected: Boolean): Boolean; overload;
   function AddValToChoiceField(Field: Cardinal; const ExpValue: AnsiString; const Value: WideString; Selected: Boolean): Boolean; overload;
{$endif}
   function AddValToChoiceFieldA(Field: Cardinal; const ExpValue, Value: AnsiString; Selected: Boolean): Boolean; 
   function AddValToChoiceFieldW(Field: Cardinal; const ExpValue: AnsiString; const Value: WideString; Selected: Boolean): Boolean; 
   function Append(): Boolean;
   function ApplyAppEvent(Event: TOCAppEvent; SaveResult: Boolean): Boolean;
   function ApplyPattern(PattHandle: Integer; ColorMode: TColorMode; Color: Cardinal): Boolean;
   function ApplyShading(ShadHandle: Integer): Boolean;
   function AssociateEmbFile(DestObject: TAFDestObject; DestHandle: Integer; Relationship: TAFRelationship; EmbFile: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function AttachFile(const FilePath, Description: AnsiString; Compress: Boolean): Integer; overload;
   function AttachFile(const FilePath, Description: WideString; Compress: Boolean): Integer; overload;
   function AttachFileEx(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: AnsiString; Compress: Boolean): Integer; overload;
   function AttachFileEx(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: WideString; Compress: Boolean): Integer; overload;
{$endif}
   function AttachFileA(const FilePath, Description: AnsiString; Compress: Boolean): Integer;
   function AttachFileW(const FilePath, Description: WideString; Compress: Boolean): Integer;
   function AttachFileExA(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: AnsiString; Compress: Boolean): Integer;
   function AttachFileExW(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: WideString; Compress: Boolean): Integer;
   function AttachImageBuffer(RasPtr: IRAS; Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer): Boolean;
   function AutoTemplate(Templ: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
   function BeginClipPath(): Boolean;
   function BeginContinueText(PosX, PosY: Double): Integer;
   function BeginLayer(OCG: Cardinal): Boolean;
   function BeginPageTemplate(const Name: AnsiString; UseAutoTemplates: Boolean): Boolean;
   function BeginPattern(PatternType: TPatternType; TilingType: TTilingType; Width, Height: Double): Integer;
   function BeginTemplate(Width, Height: Double): Integer;
   function BeginTemplateEx(var BBox: TPDFRect; var Matrix: TCTM): Integer;
   function BeginTransparencyGroup(x1, y1, x2, y2: Double; Isolated, Knockout: Boolean; CS: TExtColorSpace; CSHandle: Integer): Integer;
   function Bezier_1_2_3(x1, y1, x2, y2, x3, y3: Double): Boolean;
   function Bezier_1_3(x1, y1, x3, y3: Double): Boolean;
   function Bezier_2_3(x2, y2, x3, y3: Double): Boolean;
   function BuildFamilyNameAndStyle(const IFont: PFNT; Name: PAnsiChar{Array[0..127] of AnsiChar}; var Style: TFStyle): Boolean;
   procedure CalcPagePixelSize(PagePtr: IPGE; DefScale: TPDFPageScale; Scale: Single; FrameWidth, FrameHeight: Cardinal; Flags: TRasterFlags; var Width, Height: Cardinal);
   function CalcWidthHeight(OrgWidth, OrgHeight, ScaledWidth, ScaledHeight: Double): Double;
{$ifdef DELPHI6_OR_HIGHER}
   function CaretAnnot(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer; overload;
   function CaretAnnot(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer; overload;
   function ChangeAnnotName(Handle: Cardinal; const Name: AnsiString): Boolean; overload;
   function ChangeAnnotName(Handle: Cardinal; const Name: WideString): Boolean; overload;
{$endif}
   function CaretAnnotA(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
   function CaretAnnotW(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
   function ChangeAnnotNameA(Handle: Cardinal; const Name: AnsiString): Boolean;
   function ChangeAnnotNameW(Handle: Cardinal; const Name: WideString): Boolean;
   function ChangeAnnotPos(Handle: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ChangeBookmark(ABmk: Integer; const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean; overload;
   function ChangeBookmark(ABmk: Integer; const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean; overload;
{$endif}
   function ChangeBookmarkA(ABmk: Integer; const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean; 
   function ChangeBookmarkW(ABmk: Integer; const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean; 
   function ChangeFont(Handle: Integer): Boolean;
   function ChangeFontEx(Handle: Integer; FontSize: Double; Style: TFStyle): Boolean;
   function ChangeFontSize(Size: Double): Boolean;
   function ChangeFontStyle(Style: TFStyle): Boolean;
   function ChangeFontStyleEx(Style: TFStyle): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ChangeJavaScript(Handle: Cardinal; const NewScript: AnsiString): Boolean; overload;
   function ChangeJavaScript(Handle: Cardinal; const NewScript: WideString): Boolean; overload;
   function ChangeJavaScriptAction(Handle: Cardinal; const NewScript: AnsiString): Boolean; overload;
   function ChangeJavaScriptAction(Handle: Cardinal; const NewScript: WideString): Boolean; overload;
   function ChangeJavaScriptName(Handle: Cardinal; const Name: AnsiString): Boolean; overload;
   function ChangeJavaScriptName(Handle: Cardinal; const Name: WideString): Boolean; overload;
{$endif}
   function ChangeJavaScriptA(Handle: Cardinal; const NewScript: AnsiString): Boolean;
   function ChangeJavaScriptW(Handle: Cardinal; const NewScript: WideString): Boolean;
   function ChangeJavaScriptActionA(Handle: Cardinal; const NewScript: AnsiString): Boolean;
   function ChangeJavaScriptActionW(Handle: Cardinal; const NewScript: WideString): Boolean;
   function ChangeJavaScriptNameA(Handle: Cardinal; const Name: AnsiString): Boolean;
   function ChangeJavaScriptNameW(Handle: Cardinal; const Name: WideString): Boolean;
   function ChangeLinkAnnot(Handle: Cardinal; const URL: AnsiString): Boolean;
   function ChangeNamedDestA(ObjType: TObjType; Handle: Cardinal; const NewDestName: AnsiString): Boolean;
   function ChangeNamedDestW(ObjType: TObjType; Handle: Cardinal; const NewDestName: WideString): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ChangeNamedDest(ObjType: TObjType; Handle: Cardinal; const NewDestName: WideString): Boolean;
   function ChangeOCGName(Handle: Cardinal; const Value: WideString): Boolean;
{$else}
   function ChangeOCGNameA(Handle: Cardinal; const Value: AnsiString): Boolean;
   function ChangeOCGNameW(Handle: Cardinal; const Value: WideString): Boolean;
{$endif}
   function ChangeSeparationColor(CSHandle, NewColor: Cardinal; Alternate: TExtColorSpace; AltHandle: Integer): Boolean;
   function CheckCollection(): Boolean;
   function CheckConformance(ConfType: TConformanceType; Options: TCheckOptions; UserData: Pointer; OnFontNotFound: TOnFontNotFoundProc; OnReplaceICCProfile: TOnReplaceICCProfile): Integer;
   function CheckFieldNames(): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CircleAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer; overload;
   function CircleAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer; overload;
{$endif}
   function CircleAnnotA(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer;
   function CircleAnnotW(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer;
   function ClearAutoTemplates(): Boolean;
   procedure ClearErrorLog();
   function ClearHostFonts(): Boolean;
   function ClipPath(ClipMode: TClippingMode; FillMode: TPathFillMode): Boolean;
   function CloseAndSignFile(const CertFile, Password, Reason, Location: AnsiString): Boolean;
   function CloseAndSignFileEx(const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions; const CertFile, Password, Reason, Location: AnsiString): Boolean;
   function CloseAndSignFileExt(var SigParms: TPDFSigParms): Boolean;
   function CloseFile(): Boolean;
   function CloseFileEx(const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Boolean;
   function CloseImage(): Boolean;
   function CloseImportFile(): Boolean;
   function CloseImportFileEx(Handle: Cardinal): Boolean;
   function ClosePath(FillMode: TPathFillMode): Boolean;
   function CloseTag(): Boolean;
   function ComputeBBox(var BBox: TPDFRect; Flags: TCompBBoxFlags): Integer;
   function ConvColor(const Color: PDouble; NumComps: Cardinal; SourceCS: TExtColorSpace; const IColorSpace: Pointer; DestCS: TExtColorSpace): Cardinal;
   function ConvertColors(Flags: TColorConvFlags; Add: Single = 0.0): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function ConvertEMFSpool(const SpoolFile: AnsiString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer; overload;
   function ConvertEMFSpool(const SpoolFile: WideString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer; overload;
{$endif}
   function ConvertEMFSpoolA(const SpoolFile: AnsiString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
   function ConvertEMFSpoolW(const SpoolFile: WideString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
   function ConvToFreeTextCallout(Handle: Cardinal; StartX, StartY, KneeOffset: Single; EndStyle: TLineEndStyle): Boolean;
   function ConvToUnicode(const AString: AnsiString; CP: TCodepage): WideString;
   function CopyChoiceValues(Source, Dest: Cardinal; Share: Boolean): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function Create3DAnnot(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: AnsiString): Integer; overload;
   function Create3DAnnot(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: WideString): Integer; overload;
{$endif}
   function Create3DAnnotA(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: AnsiString): Integer;
   function Create3DAnnotW(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: WideString): Integer;
   function Create3DBackground(const IView: Pointer; BackColor: Cardinal): Boolean;
   function Create3DGotoViewAction(Base3DAnnot: Cardinal; const IView: Pointer; Named: T3DNamedAction): Integer;
   function Create3DProjection(const IView: Pointer; ProjType: T3DProjType; ScaleType: T3DScaleType; Diameter, FOV: Double): Boolean;
   function Create3DView(Base3DAnnot: Cardinal; const Name: WideString; SetAsDefault: Boolean; Matrix: PDouble; CamDistance: Double; RM: T3DRenderingMode; LS: T3DLightingSheme): Pointer;
   function CreateAltFontList(): Integer;
   function CreateAnnotAP(Annot: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateArticleThread(const ThreadName: AnsiString): Integer; overload;
   function CreateArticleThread(const ThreadName: WideString): Integer; overload;
{$endif}
   function CreateArticleThreadA(const ThreadName: AnsiString): Integer;
   function CreateArticleThreadW(const ThreadName: WideString): Integer; 
   function CreateAxialShading(sX, sY, eX, eY, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Boolean): Integer;
   function CreateBarcodeField(const Name: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double; var Barcode: TPDFBarcode): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateButton(const Name: AnsiString; const Caption: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; overload;
   function CreateButton(const Name: AnsiString; const Caption: WideString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer; overload;
{$endif}
   function CreateButtonA(const Name, Caption: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateButtonW(const Name: AnsiString; const Caption: WideString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateCheckBox(const Name, ExpValue: AnsiString; Checked: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateCIEColorSpace(Base: TExtColorSpace; WhitePoint, BlackPoint, Gamma, Matrix: PSingle): Integer;
   function CreateCollection(View: TColView): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateCollectionField(ColType: TColColumnType; Column: Integer; const Name, Key: AnsiString; Visible, Editable: Boolean): Integer; overload;
   function CreateCollectionField(ColType: TColColumnType; Column: Integer; const Name: WideString; const Key: AnsiString; Visible, Editable: Boolean): Integer; overload;
{$endif}
   function CreateCollectionFieldA(ColType: TColColumnType; Column: Integer; const Name, Key: AnsiString; Visible, Editable: Boolean): Integer;
   function CreateCollectionFieldW(ColType: TColColumnType; Column: Integer; const Name: WideString; const Key: AnsiString; Visible, Editable: Boolean): Integer;
   function CreateColItemDate(EmbFile: Cardinal; const Key: AnsiString; Date: LongInt; const Prefix: AnsiString): Boolean;
   function CreateColItemNumber(EmbFile: Cardinal; const Key: AnsiString; Value: Double; const Prefix: AnsiString): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateColItemString(EmbFile: Cardinal; const Key, Value, Prefix: AnsiString): Boolean; overload;
   function CreateColItemString(EmbFile: Cardinal; const Key: AnsiString; const Value, Prefix: WideString): Boolean; overload;
{$endif}
   function CreateColItemStringA(EmbFile: Cardinal; const Key, Value, Prefix: AnsiString): Boolean;
   function CreateColItemStringW(EmbFile: Cardinal; const Key: AnsiString; const Value, Prefix: WideString): Boolean;
   function CreateComboBox(const Name: AnsiString; Sort: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateDeviceNColorSpace(const Colorants: Array of PAnsiChar; NumColorants: Cardinal; const PostScriptFunc: AnsiString; Alternate: TExtColorSpace; Handle: Integer): Integer;
   function CreateDPartRoot(const NodeNameList: Array of PAnsiChar; NodeNamesCount: Cardinal; RecordLevel: Integer): Boolean;
   function CreateExtGState(var GS: TPDFExtGState): Integer;
   function CreateGeospatialMeasure(Viewport: Cardinal; const Attributes: AnsiString): Integer;
   function CreateGoToAction(DestType: TDestType; PageNum: Cardinal; a, b, c, d: Double): Integer;
   function CreateGoToActionEx(NamedDest: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateGoToEAction(Location: TEmbFileLocation; const Source: AnsiString; SrcPage: Cardinal; const Target, DestName: AnsiString; DestPage: Cardinal; NewWindow: Boolean): Integer; overload;
   function CreateGoToEAction(Location: TEmbFileLocation; const Source: WideString; SrcPage: Cardinal; const Target, DestName: WideString; DestPage: Cardinal; NewWindow: Boolean): Integer; overload;
   function CreateGoToRAction(const FileName: AnsiString; PageNum: Cardinal): Integer; overload;
   function CreateGoToRAction(const FileName: WideString; PageNum: Cardinal): Integer; overload;
{$else}
   function CreateGoToRAction(const FileName: AnsiString; PageNum: Cardinal): Integer;
{$endif}
   function CreateGoToEActionA(Location: TEmbFileLocation; const Source: AnsiString; SrcPage: Cardinal; const Target, DestName: AnsiString; DestPage: Cardinal; NewWindow: Boolean): Integer;
   function CreateGoToEActionW(Location: TEmbFileLocation; const Source: WideString; SrcPage: Cardinal; const Target, DestName: WideString; DestPage: Cardinal; NewWindow: Boolean): Integer;
   function CreateGoToRActionW(const FileName: WideString; PageNum: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateGoToRActionEx(const FileName: AnsiString; DestName: AnsiString; NewWindow: Boolean): Integer; overload;
   function CreateGoToRActionEx(const FileName: AnsiString; DestName: WideString; NewWindow: Boolean): Integer; overload;
   function CreateGoToRActionExU(const FileName: WideString; DestName: AnsiString; NewWindow: Boolean): Integer; overload;
   function CreateGoToRActionExU(const FileName: WideString; DestName: WideString; NewWindow: Boolean): Integer; overload;
{$endif}
   function CreateGoToRActionExA(const FileName: AnsiString; DestName: AnsiString; NewWindow: Boolean): Integer;
   function CreateGoToRActionExW(const FileName: AnsiString; DestName: WideString; NewWindow: Boolean): Integer;
   function CreateGoToRActionExUA(const FileName: WideString; DestName: AnsiString; NewWindow: Boolean): Integer;
   function CreateGoToRActionExUW(const FileName: WideString; DestName: WideString; NewWindow: Boolean): Integer;
   function CreateGroupField(const Name: AnsiString; Parent: Integer): Integer;
   function CreateHideAction(AField: Cardinal; Hide: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateICCBasedColorSpace(const ICCProfile: AnsiString): Integer; overload;
   function CreateICCBasedColorSpace(const ICCProfile: WideString): Integer; overload;
   function CreateImage(const FileName: AnsiString; Format: TImageFormat): Boolean; overload;
   function CreateImage(const FileName: WideString; Format: TImageFormat): Boolean; overload;
   function CreateImpDataAction(const DataFile: AnsiString): Integer; overload;
   function CreateImpDataAction(const DataFile: WideString): Integer; overload;
{$endif}
   function CreateICCBasedColorSpaceA(const ICCProfile: AnsiString): Integer;
   function CreateICCBasedColorSpaceW(const ICCProfile: WideString): Integer;
   function CreateICCBasedColorSpaceEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
   function CreateImageA(const FileName: AnsiString; Format: TImageFormat): Boolean;
   function CreateImageW(const FileName: WideString; Format: TImageFormat): Boolean;
   function CreateImpDataActionA(const DataFile: AnsiString): Integer;
   function CreateImpDataActionW(const DataFile: WideString): Integer;
   function CreateIndexedColorSpace(Base: TExtColorSpace; Handle: Integer; const ColorTable: Pointer; NumColors: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateJSAction(const Script: AnsiString): Integer; overload;
   function CreateJSAction(const Script: WideString): Integer; overload;
   function CreateLaunchActionEx(const FileName: AnsiString; NewWindow: Boolean): Integer; overload;
   function CreateLaunchActionEx(const FileName: WideString; NewWindow: Boolean): Integer; overload;
{$endif}
   function CreateJSActionA(const Script: AnsiString): Integer;
   function CreateJSActionW(const Script: WideString): Integer;
   function CreateLaunchAction(OP: TFileOP; const FileName, DefDir, Param: AnsiString; NewWindow: Boolean): Integer;
   function CreateLaunchActionExA(const FileName: AnsiString; NewWindow: Boolean): Integer;
   function CreateLaunchActionExW(const FileName: WideString; NewWindow: Boolean): Integer;
   function CreateListBox(const Name: PAnsiChar; Sort: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateNamedAction(Action: TNamedAction): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateNamedDest(const Name: AnsiString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer; overload;
   function CreateNamedDest(const Name: WideString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer; overload;
   function CreateNewPDF(const OutPDF: AnsiString): Boolean; overload;
   function CreateNewPDF(const OutPDF: WideString): Boolean; overload;
   function CreateOCG(const Name: AnsiString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer; overload;
   function CreateOCG(const Name: WideString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer; overload;
{$endif}
   function CreateNamedDestA(const Name: AnsiString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
   function CreateNamedDestW(const Name: WideString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
   function CreateNewPDFA(const OutPDF: AnsiString): Boolean;
   function CreateNewPDFW(const OutPDF: WideString): Boolean;
   function CreateOCGA(const Name: AnsiString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
   function CreateOCGW(const Name: WideString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
   function CreateOCMD(Visibility: TOCVisibility; const OCGs: PCardinal; Count: Cardinal): Integer;
   function CreateRadialShading(sX, sY, R1, eX, eY, R2, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Boolean): Integer;
   function CreateRadioButton(const Name, ExpValue: AnsiString; Checked: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateRasterizer(Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer; PixelFormat: TPDFPixFormat): Pointer;
   function CreateRasterizerEx(DC: HDC; Width, Height: Cardinal; PixFmt: TPDFPixFormat): Pointer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateRectilinearMeasure(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: AnsiString): Integer; overload;
   function CreateRectilinearMeasure(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: WideString): Integer; overload;
{$endif}
   function CreateRectilinearMeasureA(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: AnsiString): Integer;
   function CreateRectilinearMeasureW(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: WideString): Integer;
   function CreateResetAction(): Integer;
   function CreateSeparationCS(const Colorant: AnsiString; Alternate: TExtColorSpace; Handle: Integer; Color: Cardinal): Integer;
   function CreateSetOCGStateAction(const On_: PCardinal; OnCount: Cardinal; const Off: PCardinal; OffCount: Cardinal; const Toggle: PCardinal; ToggleCount: Cardinal; PreserveRB: Boolean): Integer;
   function CreateSigField(const Name: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateSigFieldAP(SigField: Cardinal): Integer;
   function CreateSoftMask(TranspGroup: Cardinal; MaskType: TSoftMaskType; BackColor: Cardinal): Pointer;
   function CreateStdPattern(Pattern: TStdPattern; LineWidth, Distance: Double; LineColor, BackColor: Cardinal): Integer;
   function CreateStructureTree(): Boolean;
   function CreateStructureTreeEx(RootTag: TPDFBaseTag): Boolean;
   function CreateSubmitAction(Flags: TSubmitFlags; const URL: AnsiString): Integer;
   function CreateTextField(const Name: AnsiString; Parent: Integer; Multiline: Boolean; MaxLen: Integer; PosX, PosY, Width, Height: Double): Integer;
   function CreateURIAction(const URL: AnsiString): Integer;
   function CreateViewportA(const Name: AnsiString; X1, Y1, X2, Y2: Double): Integer;
   function CreateViewportW(const Name: WideString; X1, Y1, X2, Y2: Double): Integer;
   function CreateXFAStreamA(const Name: AnsiString; const Buffer: Pointer; BufSize: Cardinal): Integer;
   function CreateXFAStreamW(const Name: WideString; const Buffer: Pointer; BufSize: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function CreateViewport(const Name: AnsiString; X1, Y1, X2, Y2: Double): Integer; overload;
   function CreateViewport(const Name: WideString; X1, Y1, X2, Y2: Double): Integer; overload;
   function CreateXFAStream(const Name: AnsiString; const Buffer: Pointer; BufSize: Cardinal): Integer; overload;
   function CreateXFAStream(const Name: WideString; const Buffer: Pointer; BufSize: Cardinal): Integer; overload;
   function DecryptPDF(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer; overload;
   function DecryptPDF(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer; overload;
{$endif}
   function DecryptPDFA(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer; 
   function DecryptPDFW(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer; 
   procedure DeleteAcroForm();
   function DeleteActionFromObj(ObjType: TObjType; ActHandle, ObjHandle: Cardinal): Integer;
   function DeleteActionFromObjEx(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
   function DeleteAltFontList(Handle: Integer): Boolean;
   function DeleteAnnotation(Handle: Cardinal): Boolean;
   function DeleteAnnotationFromPage(PageNum, Handle: Cardinal): Boolean;
   function DeleteAppEvents(ApplyEvent: Boolean; Event: TOCAppEvent): Integer;
   function DeleteBookmark(ABmk: Cardinal): Integer;
   function DeleteDPartNode(Handle: Integer): Boolean;
   function DeleteEmbeddedFile(Handle: Cardinal): Boolean;
   function DeleteField(AField: Cardinal): Integer;
   function DeleteFieldEx(const Name: AnsiString): Integer;
   procedure DeleteJavaScripts(DelJavaScriptActions: Boolean);
{$ifdef DELPHI6_OR_HIGHER}
   function DeleteNamedDest(const Name: WideString): Boolean;
{$else}
   function DeleteNamedDestA(const Name: String): Boolean;
   function DeleteNamedDestW(const Name: WideString): Boolean;
{$endif}
   function DeleteNamedDestByIndex(Index: Integer): Boolean;
   function DeleteOCGFromAppEvent(Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory; DelCategoryOnly: Boolean): Boolean;
   function DeleteOCGFromDisplayTree(OCGHandle: Cardinal; Recursive: Boolean): Boolean;
   function DeleteOCUINode(Node: IOCN): Boolean;
   function DeleteOutputIntent(Index: Integer): Integer;
   function DeletePage(PageNum: Cardinal): Integer;
   procedure DeletePageLabels();
   procedure DeleteRasterizer(RasPtr: PIRAS);
   function DeleteSeparationInfo(AllPages: Boolean): Boolean;
   function DeleteTemplate(Handle: Cardinal): Boolean;
   function DeleteTemplateEx(Index: Cardinal): Integer;
   function DeleteWatermark(PageNum: Integer; InclAnnots: Boolean): Integer;
   procedure DeleteXFAForm();
   function DrawArc(PosX, PosY, Radius, StartAngle, EndAngle: Double): Boolean;
   function DrawArcEx(PosX, PosY, Width, Height, StartAngle, EndAngle: Double): Boolean;
   function DrawChord(PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: TPathFillMode): Boolean;
   function DrawCircle(PosX, PosY, Radius: Double; FillMode: TPathFillMode): Boolean;
   function DrawNGon(PosX, PosY, Radius, Alpha: Double; NumSides: Cardinal; FillMode: TPathFillMode): Boolean;
   function DrawPie(PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: TPathFillMode): Boolean;
   function EditPage(PageNum: Integer): Boolean;
   function EditTemplate(Index: Cardinal): Boolean;
   function EditTemplate2(Handle: Cardinal): Boolean;
   function Ellipse(PosX, PosY, Width, Height: Double; FillMode: TPathFillMode): Boolean;
   function EnableImageCache(MaxImageCount, Size: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function EncryptPDF(const FileName, OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; overload;
   function EncryptPDF(const FileName: WideString; const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; overload;
{$endif}
   function EncryptPDFA(const FileName, OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; 
   function EncryptPDFW(const FileName: WideString; const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer; 
   function EndContinueText(): Integer;
   function EndLayer(): Boolean;
   function EndPage(): Boolean;
   function EndPattern(): Boolean;
   function EndTemplate(): Boolean;
   function EnumDocFonts(const Data: Pointer; EnumProc: TEnumFontProc2): Integer;
   function EnumHostFonts(const Data: Pointer; EnumProc: TEnumFontProc): Integer;
   function EnumHostFontsEx(const Data: Pointer; EnumProc: TEnumFontProcEx): Integer;
   function ExchangeBookmarks(Bmk1, Bmk2: Integer): Boolean;
   function ExchangePages(First, Second: Cardinal): Boolean;
   function ExtractText(PageNum: Cardinal; Flags: TTextExtractionFlags; const Area: PFltRect; var Text: WideString): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function FileAttachAnnot(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: AnsiString; Compress: Boolean): Integer; overload;
   function FileAttachAnnot(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: WideString; Compress: Boolean): Integer; overload;
   function FileAttachAnnotEx(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: AnsiString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer; overload;
   function FileAttachAnnotEx(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: WideString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer; overload;
{$endif}
   function FileAttachAnnotA(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: AnsiString; Compress: Boolean): Integer;
   function FileAttachAnnotW(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: WideString; Compress: Boolean): Integer;
   function FileAttachAnnotExA(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: AnsiString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
   function FileAttachAnnotExW(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: WideString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function FileLink(PosX, PosY, Width, Height: Double; const AFilePath: AnsiString): Integer; overload;
   function FileLink(PosX, PosY, Width, Height: Double; const AFilePath: WideString): Integer; overload;
   function FindBookmark(DestPage: Integer; const Title: AnsiString): Integer; overload;
   function FindBookmark(DestPage: Integer; const Title: WideString): Integer; overload;
{$endif}
   function FileLinkA(PosX, PosY, Width, Height: Double; const AFilePath: AnsiString): Integer; 
   function FileLinkW(PosX, PosY, Width, Height: Double; const AFilePath: WideString): Integer; 
   function FindBookmarkA(DestPage: Integer; const Title: AnsiString): Integer; 
   function FindBookmarkW(DestPage: Integer; const Title: WideString): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function FindField(const Name: AnsiString): Integer; overload;
   function FindField(const Name: WideString): Integer; overload;
{$endif}
   function FindEmbeddedFile(const Name: WideString): Integer;
   function FindFieldA(const Name: AnsiString): Integer;
   function FindFieldW(const Name: WideString): Integer;
   function FindLinkAnnot(const URL: AnsiString): Integer;
   function FindNextBookmark(): Integer;
   function FinishSignature(const PKCS7Obj: Pointer; Length: Cardinal): Boolean;
   function FlattenAnnotOrField(Index: Cardinal; Flags: TAnnotFlattenFlags): Boolean;
   function FlattenAnnots(Flags: TAnnotFlattenFlags): Integer;
   function FlattenForm(): Boolean;
   function FlushPageContent(var Stack: TPDFStack): Boolean;
   function FlushPages(Flags: TFlushPageFlags): Boolean;
   function FlushPagesEx(Flags: TFlushPageFlags; LastPage: Cardinal): Boolean;
   procedure FreeImageBuffer();
   function FreeImageObj(Handle: Cardinal): Boolean;
   function FreeImageObjEx(const ImagePtr: Pointer): Boolean;
   function FreePDF(): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function FreeTextAnnot(PosX, PosY, Width, Height: Double; const Author, AText: AnsiString; Align: TTextAlign): Integer; overload;
   function FreeTextAnnot(PosX, PosY, Width, Height: Double; const Author, AText: WideString; Align: TTextAlign): Integer; overload;
{$endif}
   function FreeTextAnnotA(PosX, PosY, Width, Height: Double; const Author, AText: AnsiString; Align: TTextAlign): Integer; 
   function FreeTextAnnotW(PosX, PosY, Width, Height: Double; const Author, AText: WideString; Align: TTextAlign): Integer;
   function FreeUniBuf(): Boolean;
   function Get3DAnnotStream(Annot: Cardinal; var Data: PByte; var Size: Cardinal; var SubType: PAnsiString): Boolean;
   function GetActionCount(): Integer;
   function GetActionHandle(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
   function GetActionType(ActHandle: Cardinal): Integer;
   function GetActionTypeEx(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
   function GetActiveFont(): Integer;
   function GetAllocBy(): Integer;
   function GetAnnot(Handle: Cardinal; var Annot: TPDFAnnotation): Boolean;
   function GetAnnotBBox(Handle: Cardinal; var BBox: TPDFRect): Boolean;
   function GetAnnotColor(Handle: Cardinal; ColorType: TAnnotColor; var CS: TPDFColorSpace; var Color: Cardinal): Boolean;
   function GetAnnotCount(): Integer;
   function GetAnnotEx(Handle: Cardinal; var Annot: TPDFAnnotationEx): Boolean;
   function GetAnnotFlags(): Integer;
   function GetAnnotLink(Handle: Cardinal): AnsiString;
   function GetAnnotTextAlign(Handle: Cardinal): Integer;
   function GetAnnotType(Handle: Cardinal): Integer;
   function GetAscent(): Double;
   function GetBarcodeDict(const IBarcode: Pointer; var Barcode: TPDFBarcode): Boolean;
   function GetBBox(Boundary: TPageBoundary; var BBox: TPDFRect): Boolean;
   function GetBidiMode(): TPDFBidiMode;
   function GetBookmark(Handle: Integer; var Bmk: TBookmark): Boolean;
   function GetBookmarkEx(Handle: Integer; var Bmk: TPDFBookmark): Boolean;
   function GetBookmarkCount(): Integer;
   function GetBorderStyle(): TBorderStyle;
   function GetBuffer(var BufSize: Cardinal): PAnsiChar;
   function GetCapHeight(): Double;
   function GetCharacterSpacing(): Double;
   function GetCheckBoxChar(): Integer;
   function GetCheckBoxCharEx(AField: Cardinal): Integer;
   function GetCheckBoxDefState(AField: Cardinal): Integer;
   function GetCMap(Index: Cardinal; var CMap: TPDFCMap): Boolean;
   function GetCMapCount(): Integer;
   function GetCollectionInfo(var Value: TPDFCollectionInfo): Boolean;
   function GetColorSpace(): Integer;
   function GetColorSpaceCount(): Integer;
   function GetColorSpaceObj(Handle: Cardinal; var CS: TPDFColorSpaceObj): Boolean;
   function GetColorSpaceObjEx(const IColorSpace: Pointer; var CS: TPDFColorSpaceObj): Boolean;
   function GetCompressionFilter(): Integer;
   function GetCompressionLevel(): Integer;
   function GetContent(var Buffer: PAnsiChar): Integer;
   function GetDefBitsPerPixel(): Integer;
   function GetDescent(): Double;
   function GetDeviceNAttributes(IAttributes: Pointer; var Attributes: TDeviceNAttributes): Boolean;
   function GetDocInfo(DInfo: TDocumentInfo; var Value: PWideChar): Integer;
   function GetDocInfoCount(): Integer;
   function GetDocInfoEx(Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): Integer;
   function GetDocUsesTransparency(Flags: Cardinal): Boolean;
   function GetDrawDirection(): Integer;
   function GetDynaPDFVersion(): AnsiString;
   function GetDynaPDFVersionInt(): Integer;
   function GetEmbeddedFile(Handle: Cardinal; var FileSpec: TPDFFileSpec; Decompress: Boolean): Boolean;
   function GetEmbeddedFileCount(): Integer;
   function GetEmbeddedFileNode(const IEF: IEFN; F: TPDFEmbFileNode; Decompress: Boolean): Boolean;
   function GetEMFPatternDistance(): Double;
   function GetErrLogMessage(Index: Cardinal; var Err: TPDFError): Boolean;
   function GetErrLogMessageCount(): Integer;
   function GetErrorMessage(): AnsiString;
   function GetErrorMode(): Integer;
   function GetField(Handle: Cardinal; var Field: TPDFField): Boolean;
   function GetFieldBackColor(): Cardinal;
   function GetFieldBorderColor(): Cardinal;
   function GetFieldBorderStyle(AField: Cardinal): Integer;
   function GetFieldBorderWidth(AField: Cardinal): Double;
   function GetFieldCalcOrder(var Out: PCardinal): Integer;
   function GetFieldChoiceValue(AField, ValIndex: Cardinal; var Value: TPDFChoiceValue): Boolean;
   function GetFieldColor(AField: Cardinal; ColorType: TFieldColor; var ColorSpace: Integer; var Color: Cardinal): Boolean;
   function GetFieldCount(): Integer;
   function GetFieldEx(Handle: Cardinal; var Field: TPDFFieldEx): Boolean;
   function GetFieldEx2(const IField: Pointer; var Field: TPDFFieldEx): Boolean;
   function GetFieldExpValCount(AField: Cardinal): Integer;
   function GetFieldExpValue(AField: Cardinal; var Value: AnsiString): Integer;
   function GetFieldExpValueEx(AField, ValIndex: Cardinal; var Value, ExpValue: AnsiString; var Selected: Boolean): Boolean;
   function GetFieldFlags(AField: Cardinal): Integer;
   function GetFieldGroupType(AField: Cardinal): Integer;
   function GetFieldHighlightMode(AField: Cardinal): Integer;
   function GetFieldIndex(AField: Cardinal): Integer;
   function GetFieldMapName(AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer;
   function GetFieldName(AField: Cardinal; var Name: AnsiString): Integer;
   function GetFieldOrientation(AField: Cardinal): Integer;
   function GetFieldTextAlign(AField: Cardinal): Integer;
   function GetFieldTextColor(): Cardinal;
   function GetFieldToolTip(AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer;
   function GetFieldType(AField: Cardinal): Integer;
   function GetFileSpec(const IFS: IFSR; var F: TPDFFileSpecEx): Boolean;
   function GetFillColor(): Cardinal;
   function GetFont(const IFont: PFNT; var F: TPDFFontObj): Boolean;
   function GetFontInfo(const IFont: PFNT; var F: TPDFFontInfo): Boolean;
   function GetFontCount(): Integer;
   function GetFontEx(Handle: Cardinal; var F: TPDFFontObj): Boolean;
   function GetFontInfoEx(Handle: Cardinal; var F: TPDFFontInfo): Boolean;
   function GetFontMetrics(Handle: Cardinal; var Metrics: TPDFFontMetrics): Boolean;
   function GetFontOrigin(): Integer;
   procedure GetFontSearchOrder(Order: PFontBaseType {Array[0..3] of TFontBaseType});
   function GetFontSelMode(): Integer;
   function GetFontSize(): Double;
   function GetFontWeight(): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function GetFTextHeight(Align: TTextAlign; const AText: AnsiString): Double; overload;
   function GetFTextHeight(Align: TTextAlign; const AText: WideString): Double; overload;
   function GetFTextHeightEx(Width: Double; Align: TTextAlign; const AText: AnsiString): Double; overload;
   function GetFTextHeightEx(Width: Double; Align: TTextAlign; const AText: WideString): Double; overload;
{$endif}
   function GetFTextHeightA(Align: TTextAlign; const AText: AnsiString): Double;
   function GetFTextHeightW(Align: TTextAlign; const AText: WideString): Double;
   function GetFTextHeightExA(Width: Double; Align: TTextAlign; const AText: AnsiString): Double;
   function GetFTextHeightExW(Width: Double; Align: TTextAlign; const AText: WideString): Double;
   function GetFullyQualifiedFieldName(Handle: Cardinal; var Value: PWideChar): Integer;
   function GetGlyphIndex(Index: Cardinal): Integer;
   function GetGlyphOutline(Index: Cardinal; Outline: PPDFGlyphOutline): Integer;
   function GetGoToAction(Handle: Cardinal; var Action: TPDFGoToAction): Boolean;
   function GetGoToRAction(Handle: Cardinal; var Action: TPDFGoToAction): Boolean;
   function GetGStateFlags(): Integer;
   function GetHideAction(Handle: Cardinal; var Action: TPDFHideAction): Boolean;
   function GetIconColor(): Integer;
   function GetImageBuffer(var BufSize: Cardinal): PAnsiChar;
{$ifdef DELPHI6_OR_HIGHER}
   function GetImageCount(const FileName: AnsiString): Integer; overload;
   function GetImageCount(const FileName: WideString): Integer; overload;
{$else}
   function GetImageCount(const FileName: AnsiString): Integer;
{$endif}
   function GetImageCountW(const FileName: WideString): Integer;
   function GetImageCountEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
   function GetImageHeight(Handle: Cardinal): Integer;
   function GetImageObj(Handle: Cardinal; Flags: TParseFlags; var Image: TPDFImage): Boolean;
   function GetImageObjCount(): Integer;
   function GetImageObjEx(const ImagePtr: PIMG; Flags: TParseFlags; var Image: TPDFImage): Boolean;
   function GetImageWidth(Handle: Cardinal): Integer;
   function GetImportDataAction(Handle: Cardinal; var Action: TPDFImportDataAction): Boolean;
   function GetImportFlags(): Cardinal;
   function GetImportFlags2(): Cardinal;
   function GetInBBox(PageNum: Cardinal; Boundary: TPageBoundary; var BBox: TPDFRect): Boolean;
   function GetInDocInfo(DInfo: TDocumentInfo; var Value: PWideChar): Integer;
   function GetInDocInfoCount(): Integer;
   function GetInDocInfoEx(Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): Boolean;
   function GetInEncryptionFlags(): Integer;
   function GetInEncryptionInfo(var Info: TPDFEncryptInfo): Boolean;
   function GetInFieldCount(): Integer;
   function GetInIsCollection(): Boolean;
   function GetInIsEncrypted(): Boolean;
   function GetInIsSigned(): Boolean;
   function GetInIsTaggedPDF(): Integer;
   function GetInIsTrapped(): Boolean;
   function GetInIsXFAForm(): Boolean;
   function GetInkList(const List: Pointer; Points: PSingle; Count: PCardinal): Boolean;
   function GetInMetadata(PageNum: Integer; var Buffer: PByte; var BufSize: Cardinal): Boolean;
   function GetInOrientation(PageNum: Integer): Integer;
   function GetInPageCount(): Integer;
   function GetInPDFVersion(): Integer;
   function GetInPDFVersionEx(Value: PPDFVersionInfo): Integer;
   function GetInPrintSettings(var Settings: TPDFPrintSettings): Boolean;
   function GetInRepairMode(): Boolean;
   function GetIsFixedPitch(): Integer;
   function GetIsTaggingEnabled(): Boolean;
   function GetItalicAngle(): Double;
   function GetJavaScript(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
   function GetJavaScriptAction(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
   function GetJavaScriptAction2(ObjType: TObjType; ObjHandle, ActIndex: Cardinal; var Len: Cardinal; var Unicode: LongBool; var Event: TObjEvent): PAnsiChar;
   function GetJavaScriptActionEx(Handle: Cardinal; var Action: TPDFJavaScriptAction): Boolean;
   function GetJavaScriptCount(): Integer;
   function GetJavaScriptEx(const Name: AnsiString; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
   function GetJavaScriptName(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
   function GetJPEGQuality(): Integer;
   function GetLanguage(): AnsiString;
   function GetLastTextPosX(): Double;
   function GetLastTextPosXAbs(): Double;
   function GetLastTextPosY(): Double;
   function GetLastTextPosYAbs(): Double;
   function GetLaunchAction(Handle: Cardinal; var Action: TPDFLaunchAction): Boolean;
   function GetLayerConfig(Index: Integer; var Config: TPDFOCLayerConfig): Boolean;
   function GetLayerConfigCount(): Integer;
   function GetLeading(): Double;
 {$ifdef DYNLNK}
   function GetLibHandle(): HMODULE;
   function GetLibName(): String;
 {$endif}
   function GetLineCapStyle(): Integer;
   function GetLineJoinStyle(): Integer;
   function GetLineWidth(): Double;
   function GetLinkHighlightMode(): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function GetLogMetafileSize(const FileName: AnsiString; var R: TRectL): Boolean; overload;
   function GetLogMetafileSize(const FileName: WideString; var R: TRectL): Boolean; overload;
{$else}
   function GetLogMetafileSize(const FileName: AnsiString; var R: TRectL): Boolean;
{$endif}
   function GetLogMetafileSizeA(const FileName: AnsiString; var R: TRectL): Boolean;
   function GetLogMetafileSizeW(const FileName: WideString; var R: TRectL): Boolean;
   function GetLogMetafileSizeEx(const Buffer: Pointer; BufSize: Cardinal; var R: TRectL): Boolean;
   function GetMeasureObj(const MeasurePtr: IMSR; var Value: TPDFMeasure): Boolean;
   function GetMatrix(var M: TCTM): Boolean;
   function GetMaxFieldLen(TxtField: Cardinal): Integer;
   function GetMetaConvFlags(): Cardinal;
   function GetMetadata(ObjType: TMetadataObj; Handle: Integer; var Buffer: PByte; var BufSize: Cardinal): Boolean;
   function GetMissingGlyphs(var Count: Cardinal): PCardinal;
   function GetMiterLimit(): Double;
   function GetMovieAction(Handle: Cardinal; var Action: TPDFMovieAction): Boolean;
   function GetNamedAction(Handle: Cardinal; var Action: TPDFNamedAction): Boolean;
   function GetNamedDest(Index: Cardinal; var Dest: TPDFNamedDest): Boolean;
   function GetNamedDestCount(): Integer;
   function GetNeedAppearance(): Boolean;
   function GetNumberFormatObj(const NumberFmtPtr: INFM; var Value: TPDFNumberFormat): Boolean;
   function GetObjActionCount(ObjType: TObjType; ObjHandle: Cardinal): Integer;
   function GetObjActions(ObjType: TObjType; ObjHandle: Cardinal; var Actions: TPDFObjActions): Integer;
   function GetObjEvent(const IEvent: IEVT; var Event: TPDFObjEvent): Boolean;
   function GetOCG(Handle: Cardinal; var Value: TPDFOCG): Boolean;
   function GetOCGContUsage(Handle: Cardinal; var Value: TPDFOCGContUsage): Boolean;
   function GetOCGCount(): Integer;
   function GetOCGUsageUserName(Handle, Index: Cardinal; var NameA: PAnsiChar; var NameW: PWideChar): Boolean;
   function GetOCHandle(const OC: Pointer): Integer;
   function GetOCUINode(const Node: IOCN; UINode: PPDFOCUINode): IOCN;
   function GetOpacity(): Double;
   function GetOrientation(): Integer;
   function GetOutputIntent(Index: Cardinal; var Intent: TPDFOutputIntent): Boolean;
   function GetOutputIntentCount(): Integer;
   function GetPageAnnot(Index: Cardinal; var Annot: TPDFAnnotation): Boolean;
   function GetPageAnnotCount(): Integer;
   function GetPageAnnotEx(Index: Cardinal; var Annot: TPDFAnnotationEx): Boolean;
   function GetPageBBox(PagePtr: IPGE; Boundary: TPageBoundary; var BBox: TFltRect): Boolean;
   function GetPageCoords(): TPageCoord;
   function GetPageCount(): Integer;
   function GetPageField(Index: Cardinal; var Field: TPDFField): Boolean;
   function GetPageFieldCount(): Integer;
   function GetPageFieldEx(Index: Cardinal; var Field: TPDFFieldEx): Boolean;
   function GetPageHeight(): Double;
   function GetPageLabel(Index: Cardinal; var Lbl: TPDFPageLabel): Boolean;
   function GetPageLabelCount(): Integer;
   function GetPageLayout(): Integer;
   function GetPageMode(): Integer;
   function GetPageNum(): Integer;
   function GetPageObject(PageNum: Cardinal): Pointer;
   function GetPageOrientation(PagePtr: IPGE): Integer;
   function GetPageText(var Stack: TPDFStack): Boolean;
   function GetPageWidth(): Double;
   function GetPDFVersion(): Integer;
   function GetPDFVersionEx(var Value: TPDFVersionInfo): Boolean;
   function GetPrintSettings(var Settings: TPDFPrintSettings): Boolean;
   function GetPtDataArray(const PtData: IPTD; Index: Cardinal; var DataType: PAnsiChar; var Values: PSingle; var ValCount: Cardinal): Boolean;
   function GetPtDataObj(const PtData: IPTD; var Subtype: PAnsiChar; var NumArrays: Cardinal): Boolean;
   function GetRelFileNode(const IRF: IRFN; var F: TPDFRelFileNode; Decompress: Boolean): Boolean;
   function GetResetAction(Handle: Cardinal; var Value: TPDFResetFormAction): Boolean;
   function GetResolution(): Integer;
   function GetSaveNewImageFormat(): Boolean;
   function GetSeparationInfo(var Colorant: AnsiString; var CS: TExtColorSpace): Boolean;
   function GetSigDict(const ISignature: Pointer; var SigDict: TPDFSigDict): Boolean;
   function GetSpaceWidth(const IFont: PFNT; FontSize: Double): Double;
   function GetStrokeColor(): Cardinal;
   function GetSubmitAction(Handle: Cardinal; var Value: TPDFSubmitFormAction): Boolean;
   function GetSysFontInfo(Handle: Cardinal; var Value: TPDFSysFont): Integer;
   function GetTabLen(): Integer;
   function GetTemplCount(): Integer;
   function GetTemplHandle(): Integer;
   function GetTemplHeight(TmplHandle: Integer): Double;
   function GetTemplWidth(TmplHandle: Integer): Double;
{$ifdef DELPHI6_OR_HIGHER}
   function GetTextBBox(const Text: AnsiString; var BBox: TBBox): Boolean; overload;
   function GetTextBBox(const Text: WideString; var BBox: TBBox): Boolean; overload;
{$endif}
   function GetTextBBoxA(const Text: AnsiString; var BBox: TBBox): Boolean;
   function GetTextBBoxW(const Text: WideString; var BBox: TBBox): Boolean;
   function GetTextDrawMode(): Integer;
   function GetTextFieldValue(AField: Cardinal; var Value: PAnsiChar; var ValIsUnicode: LongBool; var DefValue: PAnsiChar; var DefValIsUnicode: LongBool): Boolean;
   function GetTextRect(var PosX, PosY, Width, Height: Double): Boolean;
   function GetTextRise(): Double;
   function GetTextScaling(): Double;
{$ifdef DELPHI6_OR_HIGHER}
   function GetTextWidth(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; CharSpacing, WordSpacing, TextScale: Single): Double; overload;
   function GetTextWidth(const AText: AnsiString): Double; overload;
   function GetTextWidth(const AText: WideString): Double; overload;
   function GetTextWidthEx(const AText: AnsiString; Len: Cardinal): Double; overload;
   function GetTextWidthEx(const AText: WideString; Len: Cardinal): Double; overload;
{$else}
   function GetTextWidth(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; CharSpacing, WordSpacing, TextScale: Single): Double;
{$endif}
   function GetTextWidthA(const AText: AnsiString): Double;
   function GetTextWidthW(const AText: WideString): Double;
   function GetTextWidthExA(const AText: AnsiString; Len: Cardinal): Double;
   function GetTextWidthExW(const AText: WideString; Len: Cardinal): Double;
   function GetTrapped(): Boolean;
   function GetTransparentColor(): Cardinal;
   function GetTypoLeading(): Double;
   function GetURIAction(Handle: Cardinal; var Action: TPDFURIAction): Boolean;
   function GetUseExactPwd(): Boolean;
   function GetUseGlobalImpFiles(): Boolean;
   function GetUserRights(): Integer;
   function GetUserUnit(): Single;
   function GetUseStdFonts(): Boolean;
   function GetUseSystemFonts(): Boolean;
   function GetUsesTransparency(PageNum: Integer): Integer;
   function GetUseTransparency(): Boolean;
   function GetUseVisibleCoords(): Boolean;
   function GetViewerPreferences(var Preference, AddVal: Integer): Boolean;
   function GetViewport(PageNum, Index: Cardinal; var VP: TPDFViewport): Boolean;
   function GetViewportCount(PageNum: Cardinal): Integer;
   function GetWidthHeight(PagePtr: IPGE; Flags: TRasterFlags; var Width, Height: Single; Rotate: Integer; var BBox: PFltRect): LongBool;
   function GetWMFDefExtent(var Width, Height: Cardinal): Boolean;
   function GetWMFPixelPerInch(): Integer;
   function GetWordSpacing(): Double;
   function GetXFAStream(Index: Cardinal; OutStrm: PPDFXFAStream): Boolean;
   function GetXFAStreamCount(): Integer;
   function HaveDPartRoot(): Boolean;
   function HaveOpenDoc(): Boolean;
   function HaveOpenPage(): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function HighlightAnnot(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: AnsiString): Integer; overload;
   function HighlightAnnot(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: WideString): Integer; overload;
{$endif}
   function HighlightAnnotA(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: AnsiString): Integer;
   function HighlightAnnotW(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: WideString): Integer;
   function ImportBookmarks(): Integer;
   function ImportCatalogObjects(): Boolean;
   function ImportDocInfo(): Boolean;
   function ImportEncryptionSettings(): Boolean;
   function ImportOCProperties(): Boolean;
   function ImportPage(PageNum: Cardinal): Integer;
   function ImportPageEx(PageNum: Cardinal; ScaleFactX, ScaleFactY: Double): Integer;
   function ImportPDFFile(DestPage: Cardinal; ScaleFactX, ScaleFactY: Double): Integer;
   function InitBarcode2(var Barcode: TPDFBarcode2): Boolean;
   function InitColorManagement(Profiles: PPDFColorProfiles; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): Boolean;
   function InitColorManagementEx(Profiles: PPDFColorProfilesEx; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): Boolean;
   function InitExtGState(var GS: TPDFExtGState): Boolean;
   function InitHeaderFooter(var Value: TPDFHeaderFooter; var HFArray: Array of TPDFHdrFtr): Boolean;
   function InitOCGContUsage(var Value: TPDFOCGContUsage): Boolean;
   function InitStack(var Stack: TPDFStack): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function InkAnnot(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer; overload;
   function InkAnnot(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer; overload;
{$endif}
   function InkAnnotA(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
   function InkAnnotW(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
   function InsertBarcode(PosX, PosY, Width, Height: Double; HAlign, VAlign: TCellAlign; var Barcode: TPDFBarcode2): Integer;
   function InsertBMPFromBuffer(PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer): Integer;
   function InsertBMPFromHandle(PosX, PosY, ScaleWidth, ScaleHeight: Double; Handle: HBITMAP): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function InsertBookmark(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer; overload;
   function InsertBookmark(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer; overload;
   function InsertBookmarkEx(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer; overload;
   function InsertBookmarkEx(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer; overload;
{$endif}
   function InsertBookmarkA(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
   function InsertBookmarkW(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
   function InsertBookmarkExA(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
   function InsertBookmarkExW(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
   function InsertImage(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: AnsiString): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function InsertImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: AnsiString; Index: Cardinal): Integer; overload;
   function InsertImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: WideString; Index: Cardinal): Integer; overload;
{$else}
   function InsertImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: AnsiString; Index: Cardinal): Integer;
{$endif}
   function InsertImageExW(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: WideString; Index: Cardinal): Integer;
   function InsertImageFromBuffer(PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer; BufSize, Index: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function InsertMetafile(const FileName: AnsiString; PosX, PosY, Width, Height: Double): Boolean; overload;
   function InsertMetafile(const FileName: WideString; PosX, PosY, Width, Height: Double): Boolean; overload;
{$else}
   function InsertMetafile(const FileName: AnsiString; PosX, PosY, Width, Height: Double): Boolean;
{$endif}
   function InsertMetafileA(const FileName: AnsiString; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileW(const FileName: WideString; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileEx(const Buffer: Pointer; BufSize: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function InsertMetafileExt(const FileName: AnsiString; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean; overload;
   function InsertMetafileExt(const FileName: WideString; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean; overload;
{$else}
   function InsertMetafileExt(const FileName: AnsiString; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean;
{$endif}
   function InsertMetafileExtA(const FileName: AnsiString; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileExtW(const FileName: WideString; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileExtEx(const Buffer: Pointer; BufSize: Cardinal; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileFromHandle(Handle: HENHMETAFILE; PosX, PosY, Width, Height: Double): Boolean;
   function InsertMetafileFromHandleEx(Handle: HENHMETAFILE; var View: TRectL; PosX, PosY, Width, Height: Double): Boolean;
   function InsertRawImage(const Buffer: Pointer; BitsPerPixel, ColorCount, ImgWidth, ImgHeight: Cardinal; PosX, PosY, ScaleWidth, ScaleHeight: Double): Integer;
   function InsertRawImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; var Image: TPDFRawImage): Integer;
   function IsBidiText(const AText: WideString): Integer;
   function IsColorPage(GrayIsColor: Boolean): Integer;
   function IsEmptyPage(): Integer;
   function IsWrongPwd(ErrCode: Integer): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function LineAnnot(x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer; overload;
   function LineAnnot(x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer; overload;
{$endif}
   function LineAnnotA(x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
   function LineAnnotW(x1, y1, x2, y2, LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
   function LineTo(PosX, PosY: Double): Boolean;
   function LoadCMap(const CMapName: AnsiString; Embed: Boolean): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function LoadFDFData(const FileName, Password: AnsiString; Flags: Cardinal): Boolean; overload;
   function LoadFDFData(const FileName: WideString; const Password: AnsiString; Flags: Cardinal): Boolean; overload;
{$endif}
   function LoadFDFDataA(const FileName, Password: AnsiString; Flags: Cardinal): Boolean;
   function LoadFDFDataW(const FileName: WideString; const Password: AnsiString; Flags: Cardinal): Boolean;
   function LoadFDFDataEx(const Buffer: Pointer; BufSize: Cardinal; const Password: AnsiString; Flags: Cardinal): Boolean;
   function LoadFont(const Buffer: Pointer; BufSize: Cardinal; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function LoadFontEx(const FontFile: AnsiString; Index: Cardinal; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
   function LoadFontEx(const FontFile: WideString; Index: Cardinal; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
{$endif}
   function LoadFontExA(const FontFile: AnsiString; Index: Cardinal; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function LoadFontExW(const FontFile: WideString; Index: Cardinal; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function LoadHeaderFooterSettings(var Value: TPDFHeaderFooter; var HFArray: Array of TPDFHdrFtr): Integer;
   function LoadLayerConfig(Index: Integer): Boolean;
   function LockLayer(Layer: Cardinal): Boolean;
   function MarkTemplateAsWatermark(Handle: Cardinal): Boolean;
   function MovePage(Source, Dest: Cardinal): Boolean;
   function MoveTo(PosX, PosY: Double): Boolean;
   procedure MultiplyMatrix(var M1, M2, NewMatrix: TCTM);
   function OpenImportBuffer(const Buffer: Pointer; BufSize: Cardinal; PwdType: TPwdType; const Password: AnsiString): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function OpenImportFile(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer; overload;
   function OpenImportFile(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer; overload;
   function OpenOutputFile(const OutPDF: AnsiString): Boolean; overload;
   function OpenOutputFile(const OutPDF: WideString): Boolean; overload;
   function OpenTag(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: AnsiString): Boolean; overload;
   function OpenTag(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString): Boolean; overload;
   function OpenTagBBox(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString; BBox: PBBox): Boolean;
   function OpenTagEx(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString; const Attributes: AnsiString): Boolean;
{$endif}
   function OpenImportFileA(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer;
   function OpenImportFileW(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer; 
   function OpenOutputFileA(const OutPDF: AnsiString): Boolean;
   function OpenOutputFileW(const OutPDF: WideString): Boolean;
   function OpenOutputFileEncrypted(const OutPDF: WideString; const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Boolean;
   function OpenTagA(Tag: TPDFBaseTag; const Lang, AltText, Expansion: AnsiString): Boolean;
   function OpenTagW(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString): Boolean;
   function OpenTagBBoxA(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: AnsiString; BBox: PBBox): Boolean;
   function OpenTagBBoxW(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString; BBox: PBBox): Boolean;
   function OpenTagExA(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: AnsiString; const Attributes: AnsiString): Boolean;
   function OpenTagExW(Tag: TPDFBaseTag; const Lang: AnsiString; const AltText, Expansion: WideString; const Attributes: AnsiString): Boolean;
   function Optimize(Flags: TOptimizeFlags; Parms: POptimizeParams): Boolean;
   function PageLink(PosX, PosY, Width, Height: Double; DestPage: Cardinal): Integer;
   function PageLink2(PosX, PosY, Width, Height: Double; NamedDest: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function PageLink3(PosX, PosY, Width, Height: Double; const NamedDest: AnsiString): Integer; overload;
   function PageLink3(PosX, PosY, Width, Height: Double; const NamedDest: WideString): Integer; overload;
{$endif}
   function PageLink3A(PosX, PosY, Width, Height: Double; const NamedDest: AnsiString): Integer;
   function PageLink3W(PosX, PosY, Width, Height: Double; const NamedDest: WideString): Integer;
   function PageLinkEx(PosX, PosY, Width, Height: Double; DestType: TDestType; DestPage: Cardinal; a, b, c, d: Double): Integer;
   function ParseContent(const UserData: Pointer; var Stack: TPDFParseInterface; Flags: TParseFlags): Boolean;
   property PDFInstance: Pointer read FInstance;
   function PlaceImage(ImgHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): Boolean;
   function PlaceSigFieldValidateIcon(SigField: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
   function PlaceTemplate(TmplHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): Boolean;
   function PlaceTemplateEx(TmplHandle: Integer; PosX, PosY, ScaleWidth, ScaleHeight: Double): Boolean;
   function PlaceTemplByMatrix(TmplHandle: Integer): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function PolygonAnnot(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer; overload;
   function PolygonAnnot(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer; overload;
   function PolyLineAnnot(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer; overload;
   function PolyLineAnnot(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer; overload;
   function PrintPage(PageNum: Cardinal; const DocName: AnsiString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): Boolean; overload;
   function PrintPage(PageNum: Cardinal; const DocName: WideString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): Boolean; overload;
   function PrintPDFFile(const TmpDir, DocName: AnsiString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL = nil; const Parms: PPDFPrintParams = nil): LongBool; overload;
   function PrintPDFFile(const TmpDir, DocName: WideString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL = nil; const Parms: PPDFPrintParams = nil): LongBool; overload;
{$endif}
   function PolygonAnnotA(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
   function PolygonAnnotW(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
   function PolyLineAnnotA(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
   function PolyLineAnnotW(Vertices: PFltPoint; NumVertices: Cardinal; LineWidth: Double; lStart, lEnd: TLineEndStyle; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
   function PrintPageA(PageNum: Cardinal; const DocName: AnsiString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): Boolean;
   function PrintPageW(PageNum: Cardinal; const DocName: WideString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): Boolean;
   function PrintPDFFileA(const TmpDir, DocName: AnsiString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool;
   function PrintPDFFileW(const TmpDir, DocName: WideString; DC: HDC; Flags: TPDFPrintFlags; const Margin: PRectL; const Parms: PPDFPrintParams): LongBool;
   function ReadImageFormatA(const FileName: AnsiString; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
   function ReadImageFormatW(const FileName: WideString; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
   function ReadImageFormat2A(const FileName: AnsiString; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
   function ReadImageFormat2W(const FileName: WideString; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ReadImageFormat(const FileName: AnsiString; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean; overload;
   function ReadImageFormat(const FileName: WideString; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean; overload;
   function ReadImageFormat2(const FileName: AnsiString; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean; overload;
   function ReadImageFormat2(const FileName: WideString; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean; overload;
{$else}
   function ReadImageFormat(const FileName: AnsiString; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
   function ReadImageFormat2(const FileName: AnsiString; Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
{$endif}
   function ReadImageFormatEx(hBitmap: HBITMAP; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
   function ReadImageFormatFromBuffer(const Buffer: Pointer; BufSize, Index: Cardinal; var Width, Height: Cardinal; var BitsPerPixel, UseZip: Integer): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ReadImageResolution(const FileName: AnsiString; Index: Cardinal; var ResX, ResY: Cardinal): Boolean; overload;
   function ReadImageResolution(const FileName: WideString; Index: Cardinal; var ResX, ResY: Cardinal): Boolean; overload;
{$else}
   function ReadImageResolution(const FileName: AnsiString; Index: Cardinal; var ResX, ResY: Cardinal): Boolean;
{$endif}
   function ReadImageResolutionA(const FileName: AnsiString; Index: Cardinal; var ResX, ResY: Cardinal): Boolean;
   function ReadImageResolutionW(const FileName: WideString; Index: Cardinal; var ResX, ResY: Cardinal): Boolean;
   function ReadImageResolutionEx(const Buffer: Pointer; BufSize, Index: Cardinal; var ResX, ResY: Cardinal): Boolean;
   function Rectangle(PosX, PosY, Width, Height: Double; FillMode: TPathFillMode): Boolean;
   procedure Redraw(RasPtr: IRAS; DC: HDC; DestX, DestY: Integer);
{$ifdef DELPHI6_OR_HIGHER}
   function ReEncryptPDF(const FileName: AnsiString; PwdType: TPwdType; const InPwd, NewOpenPwd, NewOwnerPwd: AnsiString; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; overload;
   function ReEncryptPDF(const FileName: WideString; PwdType: TPwdType; const InPwd, NewOpenPwd, NewOwnerPwd: AnsiString; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; overload;
{$endif}
   function ReEncryptPDFA(const FileName: AnsiString; PwdType: TPwdType; const InPwd, NewOpenPwd, NewOwnerPwd: AnsiString; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; 
   function ReEncryptPDFW(const FileName: WideString; PwdType: TPwdType; const InPwd, NewOpenPwd, NewOwnerPwd: AnsiString; NewKeyLen: TKeyLen; Restrict: TRestrictions): Integer; 
   function RenameSpotColor(const Colorant, NewName: AnsiString): Integer;
   function RenderAnnotOrField(Handle: Cardinal; IsAnnot: Boolean; State: TButtonState; var Matrix: TCTM; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; var OutImage: TPDFBitmap): Boolean;
   function RenderPage(PagePtr: IPGE; RasPtr: IRAS; var Img: TPDFRasterImage): Boolean;
   function RenderPageEx(DC: HDC; var DestX, DestY: Integer; PagePtr: IPGE; RasPtr: IRAS; var Img: TPDFRasterImage): Boolean;
   function RenderPageToImageA(PageNum: Cardinal; const OutFile: AnsiString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
   function RenderPageToImageW(PageNum: Cardinal; const OutFile: WideString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function RenderPageToImage(PageNum: Cardinal; const OutFile: AnsiString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function RenderPageToImage(PageNum: Cardinal; const OutFile: WideString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function RenderPDFFile(const OutFile: AnsiString; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function RenderPDFFile(const OutFile: WideString; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function RenderPDFFileEx(const OutFile: AnsiString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function RenderPDFFileEx(const OutFile: WideString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean; overload;
   function ReplaceFont(const PDFFont: Pointer; const Name: AnsiString; Style: TFStyle; NameIsFamilyName: Boolean): Integer; overload;
   function ReplaceFont(const PDFFont: Pointer; const Name: WideString; Style: TFStyle; NameIsFamilyName: Boolean): Integer; overload;
   function ReplaceFontEx(const PDFFont: Pointer; const FontFile: AnsiString; Embed: Boolean): Integer; overload;
   function ReplaceFontEx(const PDFFont: Pointer; const FontFile: WideString; Embed: Boolean): Integer; overload;
   function ReplaceICCProfile(ColorSpace: Cardinal; const ICCFile: AnsiString): Integer; overload;
   function ReplaceICCProfile(ColorSpace: Cardinal; const ICCFile: WideString): Integer; overload;
   function ReplaceImage(var Source: TPDFImage; const Image: AnsiString; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): Boolean; overload;
   function ReplaceImage(var Source: TPDFImage; const Image: WideString; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): Boolean; overload;
{$endif}
   function ReOpenImportFile(Handle: Cardinal): Boolean;
   function RenderPDFFileA(const OutFile: AnsiString; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
   function RenderPDFFileW(const OutFile: WideString; Resolution: Cardinal; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
   function RenderPDFFileExA(const OutFile: AnsiString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
   function RenderPDFFileExW(const OutFile: WideString; Resolution: Cardinal; Width, Height: Integer; Flags: TRasterFlags; PixFmt: TPDFPixFormat; Filter: TCompressionFilter; Format: TImageFormat): Boolean;
   function ReplaceFontA(const PDFFont: Pointer; const Name: AnsiString; Style: TFStyle; NameIsFamilyName: Boolean): Integer;
   function ReplaceFontW(const PDFFont: Pointer; const Name: WideString; Style: TFStyle; NameIsFamilyName: Boolean): Integer;
   function ReplaceFontExA(const PDFFont: Pointer; const FontFile: AnsiString; Embed: Boolean): Integer;
   function ReplaceFontExW(const PDFFont: Pointer; const FontFile: WideString; Embed: Boolean): Integer;
   function ReplaceICCProfileA(ColorSpace: Cardinal; const ICCFile: AnsiString): Integer;
   function ReplaceICCProfileW(ColorSpace: Cardinal; const ICCFile: WideString): Integer;
   function ReplaceICCProfileEx(ColorSpace: Cardinal; const Buffer: Pointer; BufSize: Cardinal): Integer;
   function ReplaceImageA(var Source: TPDFImage; const Image: AnsiString; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): Boolean;
   function ReplaceImageW(var Source: TPDFImage; const Image: WideString; Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): Boolean;
   function ReplaceImageEx(var Source: TPDFImage; const Buffer: Pointer; BufSize, Index: Cardinal; CS: TExtColorSpace; CSHandle: Integer; Flags: TReplaceImageFlags): Boolean;
   function ReplacePageText(const NewText: AnsiString; var Stack: TPDFStack): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ReplacePageTextEx(const NewText: AnsiString; var Stack: TPDFStack): Boolean; overload;
   function ReplacePageTextEx(const NewText: WideString; var Stack: TPDFStack): Boolean; overload;
{$endif}
   function ReplacePageTextExA(const NewText: AnsiString; var Stack: TPDFStack): Boolean;
   function ReplacePageTextExW(const NewText: WideString; var Stack: TPDFStack): Boolean;
   function ResetAnnotAP(Handle: Integer): Boolean;
   function ResetEncryptionSettings(): Boolean;
   function ResetLineDashPattern(): Boolean;
   function ResizeBitmap(RasPtr: IRAS; DC: HDC; Width, Height: Cardinal): Boolean;
   function RestoreGraphicState(): Boolean;
   function RotateCoords(alpha, OriginX, OriginY: Double): Boolean;
   function RoundRect(PosX, PosY, Width, Height, Radius: Double; FillMode: TPathFillMode): Boolean;
   function RoundRectEx(PosX, PosY, Width, Height, rWidth, rHeight: Double; FillMode: TPathFillMode): Boolean;
   function SaveGraphicState(): Boolean;
   function ScaleCoords(sx, sy: Double): Boolean;
   function SelfTest(): Boolean;
   function Set3DAnnotProps(Annot: Cardinal; ActType: T3DActivationType; DeActType: T3DDeActivateType; InstType: T3DInstanceType; DeInstType: T3DDeActInstance; DisplToolbar, DisplModelTree: Boolean): Boolean;
   function Set3DAnnotScriptA(Annot: Cardinal; const Value: AnsiString): Boolean;
   function SetActiveSigField(Handle: Cardinal): Boolean;
   function SetAllocBy(Value: Integer): Boolean;
   function SetAltFonts(ListHandle: Cardinal; const List: PPWideChar; Count: Cardinal): Boolean;
   function SetAnnotBorderEffect(Handle: Cardinal; Value: TBorderEffect): Boolean;
   function SetAnnotBorderStyle(Handle: Cardinal; Style: TBorderStyle): Boolean;
   function SetAnnotBorderWidth(Handle: Cardinal; LineWidth: Double): Boolean;
   function SetAnnotColor(Handle: Cardinal; ColorType: TAnnotColor; CS: TPDFColorSpace; Color: Cardinal): Boolean;
   function SetAnnotFlags(Flags: TAnnotFlags): Boolean;
   function SetAnnotFlagsEx(Handle: Cardinal; Flags: Integer): Boolean;
   function SetAnnotHighlightMode(Handle: Cardinal; Mode: THighlightMode): Boolean;
   function SetAnnotIcon(Handle: Cardinal; Icon: TAnnotIcon): Boolean;
   function SetAnnotLineDashPattern(Handle: Cardinal; const Dash: PSingle; NumValues: Cardinal): Boolean;
   function SetAnnotLineEndStyle(Handle: Cardinal; StartStyle, EndStyle: TLineEndStyle): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetAnnotMigrationState(Annot: Cardinal; State: TAnnotState; const User: AnsiString): Integer; overload;
   function SetAnnotMigrationState(Annot: Cardinal; State: TAnnotState; const User: WideString): Integer; overload;
{$endif}
   function SetAnnotMigrationStateA(Annot: Cardinal; State: TAnnotState; const User: AnsiString): Integer;
   function SetAnnotMigrationStateW(Annot: Cardinal; State: TAnnotState; const User: WideString): Integer;
   function SetAnnotOpacity(Handle: Cardinal; Value: Double): Boolean;
   function SetAnnotOpenState(Handle: Cardinal; Open: Boolean): Boolean;
   function SetAnnotOrFieldDate(Handle: Cardinal; IsField: Boolean; DateType: TDateType; DateTime: Cardinal): Boolean;
   function SetAnnotQuadPoints(Handle: Cardinal; Value: PFltPoint; Count: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetAnnotString(Handle: Cardinal; StringType: TAnnotString; const Value: AnsiString): Boolean; overload;
   function SetAnnotString(Handle: Cardinal; StringType: TAnnotString; const Value: WideString): Boolean; overload;
   function SetAnnotSubject(Handle: Cardinal; const Value: AnsiString): Boolean; overload;
   function SetAnnotSubject(Handle: Cardinal; const Value: WideString): Boolean; overload;
{$endif}
   function SetAnnotStringA(Handle: Cardinal; StringType: TAnnotString; const Value: AnsiString): Boolean;
   function SetAnnotStringW(Handle: Cardinal; StringType: TAnnotString; const Value: WideString): Boolean;
   function SetAnnotSubjectA(Handle: Cardinal; const Value: AnsiString): Boolean;
   function SetAnnotSubjectW(Handle: Cardinal; const Value: WideString): Boolean;
   function SetBBox(Boundary: TPageBoundary; LeftX, LeftY, RightX, RightY: Double): Boolean;
   function SetBidiMode(Mode: TPDFBidiMode): Boolean;
   function SetBookmarkDest(ABmk: Integer; DestType: TDestType; a, b, c, d: Double): Boolean;
   function SetBookmarkStyle(ABmk: Integer; Style: TFStyle; RGBColor: Cardinal): Boolean;
   function SetBorderStyle(Style: TBorderStyle): Boolean;
   function SetCharacterSpacing(Value: Double): Boolean;
   function SetCheckBoxChar(CheckBoxChar: TCheckBoxChar): Boolean;
   function SetCheckBoxDefState(AField: Cardinal; Checked: Boolean): Boolean;
   function SetCheckBoxState(AField: Cardinal; Checked: Boolean): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetCIDFont(CMapHandle: Cardinal; const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean): Integer; overload;
   function SetCIDFont(CMapHandle: Cardinal; const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean): Integer; overload;
   function SetCMapDir(const Path: AnsiString; Flags: TLoadCMapFlags): Integer; overload;
   function SetCMapDir(const Path: WideString; Flags: TLoadCMapFlags): Integer; overload;
{$endif}
   function SetCIDFontA(CMapHandle: Cardinal; const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean): Integer;
   function SetCIDFontW(CMapHandle: Cardinal; const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean): Integer;
   function SetCMapDirA(const Path: AnsiString; Flags: TLoadCMapFlags): Integer;
   function SetCMapDirW(const Path: WideString; Flags: TLoadCMapFlags): Integer;
   function SetColDefFile(EmbFile: Cardinal): Boolean;
   function SetColorMask(ImageHandle: Cardinal; Mask: PInteger; Count: Cardinal): Boolean;
   function SetColors(Color: Cardinal): Boolean;
   function SetColorSpace(ColorSpace: TPDFColorSpace): Boolean;
   function SetColSortField(ColField: Cardinal; AscendingOrder: Boolean): Boolean;
   function SetCompressionFilter(Filter: TCompressionFilter): Boolean;
   function SetCompressionLevel(CompressLevel: TCompressionLevel): Boolean;
   function SetContent(const Buffer: PAnsiChar; BufSize: Cardinal): Boolean;
   function SetDateTimeFormat(TxtField: Cardinal; Fmt: TPDFDateTime): Boolean;
   function SetDefBitsPerPixel(Value: Integer): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetDocInfo(DInfo: TDocumentInfo; const Value: AnsiString): Boolean; overload;
   function SetDocInfo(DInfo: TDocumentInfo; const Value: WideString): Boolean; overload;
   function SetDocInfoEx(DInfo: TDocumentInfo; const Key, Value: AnsiString): Boolean; overload;
   function SetDocInfoEx(DInfo: TDocumentInfo; const Key: AnsiString; const Value: WideString): Boolean; overload;
{$endif}
   function SetDocInfoA(DInfo: TDocumentInfo; const Value: AnsiString): Boolean; 
   function SetDocInfoW(DInfo: TDocumentInfo; const Value: WideString): Boolean;
   function SetDocInfoExA(DInfo: TDocumentInfo; const Key, Value: AnsiString): Boolean;
   function SetDocInfoExW(DInfo: TDocumentInfo; const Key: AnsiString; const Value: WideString): Boolean;
   function SetDrawDirection(Direction: TDrawDirection): Boolean;
   function SetEMFFrameDPI(DPIX, DPIY: Cardinal): Boolean;
   function SetEMFPatternDistance(Value: Double): Boolean;
   function SetErrorMode(ErrMode: TErrMode): Boolean;
   function SetExtColorSpace(Handle: Cardinal): Boolean;
   function SetExtFillColorSpace(Handle: Cardinal): Boolean;
   function SetExtGState(Handle: Cardinal): Boolean;
   function SetExtStrokeColorSpace(Handle: Cardinal): Boolean;
   function SetFieldBackColor(AColor: Cardinal): Boolean;
   function SetFieldBBox(AField: Cardinal; var BBox: TPDFRect): Boolean;
   function SetFieldBorderColor(AColor: Cardinal): Boolean;
   function SetFieldBorderStyle(AField: Cardinal; Style: TBorderStyle): Boolean;
   function SetFieldBorderWidth(AField: Cardinal; LineWidth: Double): Boolean;
   function SetFieldCalcOrder(CurrIndex: Integer; NewIndex: Cardinal): Boolean;
   function SetFieldColor(AField: Cardinal; ColorType: TFieldColor; CS: TPDFColorSpace; Color: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFieldExpValue(AField, ValIndex: Cardinal; const Value: AnsiString; const ExpValue: AnsiString; Selected: Boolean): Boolean; overload;
   function SetFieldExpValue(AField, ValIndex: Cardinal; const Value: WideString; const ExpValue: AnsiString; Selected: Boolean): Boolean; overload;
{$else}
   function SetFieldExpValue(AField, ValIndex: Cardinal; const Value: AnsiString; const ExpValue: AnsiString; Selected: Boolean): Boolean;
{$endif}
   function SetFieldExpValueW(AField, ValIndex: Cardinal; const Value: WideString; const ExpValue: AnsiString; Selected: Boolean): Boolean;
   function SetFieldExpValueEx(AField, ValIndex: Cardinal; Selected, DefSelected: Boolean): Boolean;
   function SetFieldFlags(AField: Cardinal; Flags: TFieldFlags; Reset: Boolean): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFieldFont(Field: Cardinal; const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
   function SetFieldFont(Field: Cardinal; const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
{$else}
   function SetFieldFontA(Field: Cardinal; const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function SetFieldFontW(Field: Cardinal; const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
{$endif}
   function SetFieldFontEx(Field, Handle: Cardinal; FontSize: Double): Boolean;
   function SetFieldFontSize(AField: Cardinal; FontSize: double): Boolean;
   function SetFieldHighlightMode(AField: Cardinal; Mode: THighlightMode): Boolean;
   function SetFieldIndex(AField, Index: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFieldMapName(AField: Cardinal; const Name: AnsiString): Boolean; overload;
   function SetFieldMapName(AField: Cardinal; const Name: WideString): Boolean; overload;
{$endif}
   function SetFieldMapNameA(AField: Cardinal; const Name: AnsiString): Boolean;
   function SetFieldMapNameW(AField: Cardinal; const Name: WideString): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFieldName(AField: Cardinal; const NewName: AnsiString): Boolean; overload;
   function SetFieldName(AField: Cardinal; const NewName: WideString): Boolean; overload;
{$else}
   function SetFieldName(AField: Cardinal; const NewName: AnsiString): Boolean;
{$endif}
   function SetFieldNameA(AField: Cardinal; const NewName: AnsiString): Boolean;
   function SetFieldNameW(AField: Cardinal; const NewName: WideString): Boolean;
   function SetFieldOrientation(AField: Cardinal; Value: Integer): Boolean;
   function SetFieldTextAlign(AField: Cardinal; Align: TTextAlign): Boolean;
   function SetFieldTextColor(Color: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFieldToolTip(AField: Cardinal; const Value: AnsiString): Boolean; overload;
   function SetFieldToolTip(AField: Cardinal; const Value: WideString): Boolean; overload;
{$endif}
   function SetFieldToolTipA(AField: Cardinal; const Value: AnsiString): Boolean;
   function SetFieldToolTipW(AField: Cardinal; const Value: WideString): Boolean;
   function SetFillColor(Color: Cardinal): Boolean;
   function SetFillColorEx(const Color: Array of Byte; NumComponents: Cardinal): Boolean;
   function SetFillColorF(const Color: PSingle; NumComponents: Cardinal): Boolean;
   procedure SetFillColorSpace(CS: TPDFColorSpace);
   function SetFloatPrecision(NumTextDecDigits, NumVectDecDigits: Cardinal): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetFont(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage = cp1252): Integer; overload;
   function SetFont(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage = cp1252): Integer; overload;
   function SetFontEx(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
   function SetFontEx(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
{$endif}
   function SetFontA(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage = cp1252): Integer; 
   function SetFontW(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage = cp1252): Integer; 
   function SetFontExA(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function SetFontExW(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function SetFontOrigin(Origin: TOrigin): Boolean;
   procedure SetFontSearchOrder(Order: PFontBaseType{Array[0..3] of TFontBaseType});
   procedure SetFontSearchOrderEx(S1, S2, S3, S4: TFontBaseType);
   function SetFontSelMode(Mode: TFontSelMode): Boolean;
   function SetFontWeight(Weight: Integer): Boolean;
   function SetGStateFlags(Flags: TGStateFlags; Reset: Boolean): Boolean;
   function SetIconColor(Color: Cardinal): Boolean;
   function SetImportFlags(Flags: TImportFlags): Boolean;
   function SetImportFlags2(Flags: TImportFlags2): Boolean;
   function SetItalicAngle(Angle: Double): Boolean;
   function SetJPEGQuality(Value: Integer): Boolean;
   function SetLanguage(const ISOTag: AnsiString): Boolean;
   function SetLeading(Value: Double): Boolean;
   function SetLicenseKey(const Key: AnsiString): Boolean;
   function SetLineAnnotParms(Handle: Cardinal; FontHandle: Integer; FontSize: Double; const Parms: PLineAnnotParms): Boolean;
   function SetLineAnnotPoints(Handle: Cardinal; P1, P2:  PFltPoint): Boolean;
   function SetLineCapStyle(Style: TLineCapStyle): Boolean;
   function SetLineDashPattern(const Dash: AnsiString; Phase: Integer): Boolean;
   function SetLineDashPattern2(const Dash: Array of Single; NumValues: Cardinal; Phase: Single): Boolean;
   function SetLineDashPatternEx(const Dash: Array of Double; NumValues: Cardinal; Phase: Integer): Boolean;
   function SetLineJoinStyle(Style: TLineJoinStyle): Boolean;
   function SetLineWidth(Value: Double): Boolean;
   function SetLinkHighlightMode(Mode: THighlightMode): Boolean;
   function SetListFont(Handle: Cardinal): Boolean;
   function SetMatrix(var Matrix: TCTM): Boolean;
   procedure SetMaxErrLogMsgCount(Value: Cardinal);
   function SetMaxFieldLen(TxtField: Cardinal; MaxLen: Integer): Boolean;
   function SetMetaConvFlags(Flags: TMetaFlags): Boolean;
   function SetMetadata(ObjType: TMetadataObj; Handle: Integer; const Buffer: Pointer; BufSize: Cardinal): Boolean;
   procedure SetMinLineWidth2(RasPtr: IRAS; Value: Single);
   function SetMiterLimit(Value: Double): Boolean;
   function SetNeedAppearance(Value: Boolean): Boolean;
   function SetNumberFormat(TxtField: Cardinal; Sep: TDecSeparator; DecPlaces: Cardinal; NegStyle: TNegativeStyle; const CurrStr: AnsiString; Prepend: Boolean): Boolean;
   function SetOCGContUsage(Handle: Cardinal; var Value: TPDFOCGContUsage): Boolean;
   function SetOCGState(Handle: Cardinal; Visible, SaveState: Boolean): Boolean;
   function SetOnErrorProc(const Data: Pointer; ErrProc: TErrorProc): Boolean;
   function SetOnPageBreakProc(const Data: Pointer; OnBreakProc: TOnPageBreakProc): Boolean;
   function SetOpacity(Value: Double): Boolean;
   function SetOrientation(Value: Integer): Boolean;
   function SetOrientationEx(Value: Integer): Boolean;
   function SetPageBBox(PagePtr: IPGE; Boundary: TPageBoundary; var BBox: TFltRect): Boolean;
   function SetPageCoords(PageCoords: TPageCoord): Boolean;
   function SetPageFormat(Value: TPageFormat): Boolean;
   function SetPageHeight(Value: Double): Boolean;
   function SetPageLayout(Layout: TPageLayout): Boolean;
   function SetPageMode(Mode: TPageMode): Boolean;
   function SetPageOrientation(PagePtr: IPGE; Value: Integer): Boolean;
   function SetPageWidth(Value: Double): Boolean;
   function SetPDFVersion(Version: TPDFVersion): Boolean;
   function SetPrintSettings(Mode: TDuplexMode; PickTrayByPDFSize: Integer; NumCopies: Cardinal; PrintScaling: TPrintScaling; const PrintRanges: Array of Cardinal; NumRanges: Cardinal): Boolean;
   function SetProgressProc(const Data: Pointer; InitProgressProc: TInitProgressProc; ProgressProc: TProgressProc): Boolean;
   function SetRenderingIntent(ImgHandle: Cardinal; Value: TRenderingIntent): Boolean;
   function SetResolution(Value: Cardinal): Boolean;
   function SetSaveNewImageFormat(Value: Boolean): Boolean;
   procedure SetScreenRes(RasPtr: IRAS; Value: Cardinal);
   function SetSeparationInfo(Handle: Cardinal): Boolean;
   function SetSpaceWidthFactor(Value: Double): Boolean;
   function SetStrokeColor(Color: Cardinal): Boolean;
   function SetStrokeColorEx(const Color: Array of Byte; NumComponents: Cardinal): Boolean;
   function SetStrokeColorF(const Color: PSingle; NumComponents: Cardinal): Boolean;
   procedure SetStrokeColorSpace(CS: TPDFColorSpace);
   function SetTabLen(TabLen: Integer): Boolean;
   function SetTemplBBox(Handle: Cardinal; Boundary: TPageBoundary; var BBox: TPDFRect): Boolean;
   function SetTextDrawMode(Mode: TDrawMode): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SetTextFieldValue(Field: Cardinal; const Value, DefValue: AnsiString; Align: TTextAlign): Boolean; overload;
   function SetTextFieldValue(Field: Cardinal; const Value, DefValue: WideString; Align: TTextAlign): Boolean; overload;
   function SetTextFieldValueEx(Field: Cardinal; const Value: AnsiString): Boolean; overload;
   function SetTextFieldValueEx(Field: Cardinal; const Value: WideString): Boolean; overload;
{$endif}
   function SetTextFieldValueA(Field: Cardinal; const Value, DefValue: AnsiString; Align: TTextAlign): Boolean; 
   function SetTextFieldValueW(Field: Cardinal; const Value, DefValue: WideString; Align: TTextAlign): Boolean;
   function SetTextFieldValueExA(Field: Cardinal; const Value: AnsiString): Boolean;
   function SetTextFieldValueExW(Field: Cardinal; const Value: WideString): Boolean;
   function SetTextRect(PosX, PosY, Width, Height: Double): Boolean;
   function SetTextRise(Value: Double): Boolean;
   function SetTextScaling(Value: Double): Boolean;
   procedure SetTrapped(Value: Boolean);
   function SetTransparentColor(AColor: Cardinal): Boolean;
   function SetUseExactPwd(Value: Boolean): Boolean;
   function SetUseGlobalImpFiles(Value: Boolean): Boolean;
   function SetUseImageInterpolation(Handle: Cardinal; Value: Boolean): Boolean;
   function SetUseImageInterpolationEx(const Image: PIMG; Value: Boolean): Boolean;
   function SetUserUnit(Value: Single): Boolean;
   function SetUseStdFonts(Value: Boolean): Boolean;
   function SetUseSwapFile(SwapContents: Boolean; SwapLimit: Cardinal): Boolean;
   function SetUseSwapFileEx(SwapContents: Boolean; SwapLimit: Cardinal; const SwapDir: AnsiString): Boolean;
   function SetUseSystemFonts(Value: Boolean): Boolean;
   function SetUseTransparency(Value: Boolean): Boolean;
   function SetUseVisibleCoords(Value: Boolean): Boolean;
   function SetViewerPreferences(Value: TViewerPreference; AddVal: TViewPrefAddVal): Boolean;
   function SetWMFDefExtent(Width, Height: Cardinal): Boolean;
   function SetWMFPixelPerInch(Value: Cardinal): Boolean;
   function SetWordSpacing(Value: Double): Boolean;
   function SetXFAStream(Index: Cardinal; const Buffer: Pointer; BufSize: Cardinal): Boolean;
   function SkewCoords(alpha, beta, OriginX, OriginY: Double): Boolean;
   function SortFieldsByIndex(): Boolean;
   function SortFieldsByName(): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function SquareAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer; overload;
   function SquareAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer; overload;
{$endif}
   function SquareAnnotA(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer;
   function SquareAnnotW(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function StampAnnot(SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: AnsiString): Integer; overload;
   function StampAnnot(SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: WideString): Integer; overload;
{$endif}
   function StampAnnotA(SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: AnsiString): Integer;
   function StampAnnotW(SubType: TRubberStamp; PosX, PosY, Width, Height: Double; const Author, Subject, Comment: WideString): Integer;
   function StrokePath(): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function ToUnicode(const S: AnsiString): WideString; overload;
   function ToUnicode(const S: PAnsiChar; Len: Integer): WideString; overload;
{$endif}
   function ToUnicodeA(const S: AnsiString): WideString;
   function ToUnicodeW(const S: PAnsiChar; Len: Integer): WideString;
   function TranslateRawCode(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; var Width: Double; OutText: PWideChar{Array[0..31] of WideChar}; var OutLen: Integer; var Decoded: LongBool; CharSpacing, WordSpacing, TextScale: Single): Cardinal;
   function TranslateString(var Stack: TPDFStack; var Buffer: PWideChar; var Size: Cardinal; Flags: Cardinal): Integer;
   function TranslateString2(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; OutBuf: WideString; Size, Flags: Cardinal): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function TestGlyphs(FontHandle: Integer; const Text: AnsiString): Integer; overload;
   function TestGlyphs(FontHandle: Integer; const Text: WideString): Integer; overload;
   function TestGlyphsEx(FontHandle: Integer; const Text: AnsiString; Len: Cardinal): Integer; overload;
   function TestGlyphsEx(FontHandle: Integer; const Text: WideString; Len: Cardinal): Integer; overload;
{$else}
   function TestGlyphsA(FontHandle: Integer; const Text: AnsiString): Integer;
   function TestGlyphsW(FontHandle: Integer; const Text: WideString): Integer;
   function TestGlyphsExA(FontHandle: Integer; const Text: AnsiString; Len: Cardinal): Integer;
   function TestGlyphsExW(FontHandle: Integer; const Text: WideString; Len: Cardinal): Integer;
{$endif}
   function TestPassword(PwdType: TPwdType; const Value: String): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function TextAnnot(PosX, PosY, Width, Height: Double; const Author, Text: AnsiString; Icon: TAnnotIcon; Open: Boolean): Integer; overload;
   function TextAnnot(PosX, PosY, Width, Height: Double; const Author, Text: WideString; Icon: TAnnotIcon; Open: Boolean): Integer; overload;
{$endif}
   function TextAnnotA(PosX, PosY, Width, Height: Double; const Author, Text: AnsiString; Icon: TAnnotIcon; Open: Boolean): Integer;
   function TextAnnotW(PosX, PosY, Width, Height: Double; const Author, Text: WideString; Icon: TAnnotIcon; Open: Boolean): Integer;
   function TranslateCoords(NewOriginX, NewOriginY: Double): Boolean;
   function Triangle(x1, y1, x2, y2, x3, y3: Double; FillMode: TPathFillMode): Boolean;
   function UnicodeIsDefault(): Boolean;
   function UnLockLayer(Layer: Cardinal): Boolean;
   function UTF16ToUTF32(const Source: WideString): Pointer;
   function UTF16ToUTF32Ex(const Source: WideString; var Len: Cardinal): Pointer;
   function UTF32ToUTF16(const Source: Pointer): PWideChar;
   function UTF32ToUTF16Ex(const Source: Pointer; var Len: Cardinal): PWideChar;
   function WatermarkAnnot(PosX, PosY, Width, Height: Double): Integer;
{$ifdef DELPHI6_OR_HIGHER}
   function WebLink(PosX, PosY, Width, Height: Double; const URL: AnsiString): Integer; overload;
   function WebLink(PosX, PosY, Width, Height: Double; const URL: WideString): Integer; overload;
{$endif}
   function WebLinkA(PosX, PosY, Width, Height: Double; const URL: AnsiString): Integer; 
   function WebLinkW(PosX, PosY, Width, Height: Double; const URL: WideString): Integer; 
   function WeightFromStyle(Style: TFStyle): Cardinal;
   function WeightToStyle(Weight: Cardinal): TFStyle;
   function WidthFromStyle(Style: TFStyle): Cardinal;
   function WidthToStyle(Width: Cardinal): TFStyle;
{$ifdef DELPHI6_OR_HIGHER}
   function WriteAngleText(const AText: AnsiString; Angle, PosX, PosY, Radius, YOrigin: Double): Boolean; overload;
   function WriteAngleText(const AText: WideString; Angle, PosX, PosY, Radius, YOrigin: Double): Boolean; overload;
   function WriteFText(Align: TTextAlign; const AText: AnsiString): Boolean; overload;
   function WriteFText(Align: TTextAlign; const AText: WideString): Boolean; overload;
   function WriteFTextEx(PosX, PosY, Width, Height: Double; Align: TTextAlign; const AText: AnsiString): Boolean; overload;
   function WriteFTextEx(PosX, PosY, Width, Height: Double; Align: TTextAlign; const AText: WideString): Boolean; overload;
   function WriteText(PosX, PosY: Double; const AText: AnsiString): Boolean; overload;
   function WriteText(PosX, PosY: Double; const AText: WideString): Boolean; overload;
   function WriteTextEx(PosX, PosY: Double; const AText: AnsiString; Len: Cardinal): Boolean; overload;
   function WriteTextEx(PosX, PosY: Double; const AText: WideString; Len: Cardinal): Boolean; overload;
   function WriteTextMatrix(var Matrix: TCTM; const AText: AnsiString): Boolean; overload;
   function WriteTextMatrix(var Matrix: TCTM; const AText: WideString): Boolean; overload;
   function WriteTextMatrixEx(var M: TCTM; const AText: AnsiString; Len: Cardinal): Boolean; overload;
   function WriteTextMatrixEx(var M: TCTM; const AText: WideString; Len: Cardinal): Boolean; overload;
{$endif}
   function WriteAngleTextA(const AText: AnsiString; Angle, PosX, PosY, Radius, YOrigin: Double): Boolean; 
   function WriteAngleTextW(const AText: WideString; Angle, PosX, PosY, Radius, YOrigin: Double): Boolean; 
   function WriteFTextA(Align: TTextAlign; const AText: AnsiString): Boolean; 
   function WriteFTextW(Align: TTextAlign; const AText: WideString): Boolean; 
   function WriteFTextExA(PosX, PosY, Width, Height: Double; Align: TTextAlign; const AText: AnsiString): Boolean;
   function WriteFTextExW(PosX, PosY, Width, Height: Double; Align: TTextAlign; const AText: WideString): Boolean; 
   function WriteTextA(PosX, PosY: Double; const AText: AnsiString): Boolean;
   function WriteTextW(PosX, PosY: Double; const AText: WideString): Boolean;
   function WriteTextExA(PosX, PosY: Double; const AText: AnsiString; Len: Cardinal): Boolean;
   function WriteTextExW(PosX, PosY: Double; const AText: WideString; Len: Cardinal): Boolean;
   function WriteTextMatrixA(var Matrix: TCTM; const AText: AnsiString): Boolean;
   function WriteTextMatrixW(var Matrix: TCTM; const AText: WideString): Boolean;
   function WriteTextMatrixExA(var M: TCTM; const AText: AnsiString; Len: Cardinal): Boolean;
   function WriteTextMatrixExW(var M: TCTM; const AText: WideString; Len: Cardinal): Boolean;
 protected
 {$ifdef DYNLNK}
   FDLL_Handle:                     HMODULE;
   FLibName:                        String;
   // Helper functions for ParseContent() and Font API
   fntBuildFamilyNameAndStyle:      fntBuildFamilyNameAndStyle;
   fntGetFont:                      fntGetFont;
   fntGetFontInfo:                  fntGetFontInfo;
   fntGetTextWidth:                 fntGetTextWidth;
   fntGetSpaceWidth:                fntGetSpaceWidth;
   fntTranslateRawCode:             fntTranslateRawCode;
   fntTranslateString:              fntTranslateString;
   fntTranslateString2:             fntTranslateString2;

   // Rendering Engine
   rasAbort:                        rasAbort;
   rasAttachImageBuffer:            rasAttachImageBuffer;
   rasCalcPagePixelSize:            rasCalcPagePixelSize;
   rasCreateRasterizer:             rasCreateRasterizer;
   rasCreateRasterizerEx:           rasCreateRasterizerEx;
   rasDeleteRasterizer:             rasDeleteRasterizer;
   rasGetWidthHeight:               rasGetWidthHeight;
   rasRedraw:                       rasRedraw;
   rasResizeBitmap:                 rasResizeBitmap;
   rasSetMinLineWidth2:             rasSetMinLineWidth2;
   rasSetScreenRes:                 rasSetScreenRes;

   // DynaPDF API
   pdfActivateAltFontList:          pdfActivateAltFontList;
   pdfAddActionToObj:               pdfAddActionToObj;
   pdfAddAnnotToPage:               pdfAddAnnotToPage;
   pdfAddArticle:                   pdfAddArticle;
   pdfAddBookmarkA:                 pdfAddBookmarkA;
   pdfAddBookmarkW:                 pdfAddBookmarkW;
   pdfAddBookmarkExA:               pdfAddBookmarkExA;
   pdfAddBookmarkExW:               pdfAddBookmarkExW;
   pdfAddBookmarkEx2A:              pdfAddBookmarkEx2A;
   pdfAddBookmarkEx2W:              pdfAddBookmarkEx2W;
   pdfAddButtonImageA:              pdfAddButtonImageA;
   pdfAddButtonImageW:              pdfAddButtonImageW;
   pdfAddButtonImageEx:             pdfAddButtonImageEx;
   pdfAddButtonImageEx2:            pdfAddButtonImageEx2;
   pdfAddContinueTextA:             pdfAddContinueTextA;
   pdfAddContinueTextW:             pdfAddContinueTextW;
   pdfAddDeviceNProcessColorants:   pdfAddDeviceNProcessColorants;
   pdfAddDeviceNSeparations:        pdfAddDeviceNSeparations;
   pdfAddDPartNode:                 pdfAddDPartNode;
   pdfAddFieldToFormAction:         pdfAddFieldToFormAction;
   pdfAddFieldToHideAction:         pdfAddFieldToHideAction;
   pdfAddFileCommentA:              pdfAddFileCommentA;
   pdfAddFileCommentW:              pdfAddFileCommentW;
   pdfAddFontSearchPathA:           pdfAddFontSearchPathA;
   pdfAddFontSearchPathW:           pdfAddFontSearchPathW;
   pdfAddHeaderFooter:              pdfAddHeaderFooter;
   pdfAddImage:                     pdfAddImage;
   pdfAddInkList:                   pdfAddInkList;
   pdfAddJavaScriptA:               pdfAddJavaScriptA;
   pdfAddJavaScriptW:               pdfAddJavaScriptW;
   pdfAddLayerToDisplTreeA:         pdfAddLayerToDisplTreeA;
   pdfAddLayerToDisplTreeW:         pdfAddLayerToDisplTreeW;
   pdfAddMaskImage:                 pdfAddMaskImage;
   pdfAddObjectToLayer:             pdfAddObjectToLayer;
   pdfAddOCGToAppEvent:             pdfAddOCGToAppEvent;
   pdfAddOutputIntentA:             pdfAddOutputIntentA;
   pdfAddOutputIntentW:             pdfAddOutputIntentW;
   pdfAddOutputIntentEx:            pdfAddOutputIntentEx;
   pdfAddPageLabelA:                pdfAddPageLabelA;
   pdfAddPageLabelW:                pdfAddPageLabelW;
   pdfAddRasImage:                  pdfAddRasImage;
   pdfAddValToChoiceFieldA:         pdfAddValToChoiceFieldA;
   pdfAddValToChoiceFieldW:         pdfAddValToChoiceFieldW;
   pdfAppend:                       pdfAppend;
   pdfApplyAppEvent:                pdfApplyAppEvent;
   pdfApplyPattern:                 pdfApplyPattern;
   pdfApplyShading:                 pdfApplyShading;
   pdfAssociateEmbFile:             pdfAssociateEmbFile;
   pdfAttachFileA:                  pdfAttachFileA;
   pdfAttachFileW:                  pdfAttachFileW;
   pdfAttachFileExA:                pdfAttachFileExA;
   pdfAttachFileExW:                pdfAttachFileExW;
   pdfAutoTemplate:                 pdfAutoTemplate;
   pdfBeginClipPath:                pdfBeginClipPath;
   pdfBeginContinueText:            pdfBeginContinueText;
   pdfBeginLayer:                   pdfBeginLayer;
   pdfBeginPageTemplate:            pdfBeginPageTemplate;
   pdfBeginPattern:                 pdfBeginPattern;
   pdfBeginTemplate:                pdfBeginTemplate;
   pdfBeginTemplateEx:              pdfBeginTemplateEx;
   pdfBeginTransparencyGroup:       pdfBeginTransparencyGroup;
   pdfBezier_1_2_3:                 pdfBezier_1_2_3;
   pdfBezier_1_3:                   pdfBezier_1_3;
   pdfBezier_2_3:                   pdfBezier_2_3;
   pdfCalcWidthHeight:              pdfCalcWidthHeight;
   pdfCaretAnnotA:                  pdfCaretAnnotA;
   pdfCaretAnnotW:                  pdfCaretAnnotW;
   pdfChangeAnnotNameA:             pdfChangeAnnotNameA;
   pdfChangeAnnotNameW:             pdfChangeAnnotNameW;
   pdfChangeAnnotPos:               pdfChangeAnnotPos;
   pdfChangeBookmarkA:              pdfChangeBookmarkA;
   pdfChangeBookmarkW:              pdfChangeBookmarkW;
   pdfChangeFont:                   pdfChangeFont;
   pdfChangeFontEx:                 pdfChangeFontEx;
   pdfChangeFontSize:               pdfChangeFontSize;
   pdfChangeFontStyle:              pdfChangeFontStyle;
   pdfChangeFontStyleEx:            pdfChangeFontStyleEx;
   pdfChangeJavaScriptA:            pdfChangeJavaScriptA;
   pdfChangeJavaScriptW:            pdfChangeJavaScriptW;
   pdfChangeJavaScriptActionA:      pdfChangeJavaScriptActionA;
   pdfChangeJavaScriptActionW:      pdfChangeJavaScriptActionW;
   pdfChangeJavaScriptNameA:        pdfChangeJavaScriptNameA;
   pdfChangeJavaScriptNameW:        pdfChangeJavaScriptNameW;
   pdfChangeLinkAnnot:              pdfChangeLinkAnnot;
   pdfChangeNamedDestA:             pdfChangeNamedDestA;
   pdfChangeNamedDestW:             pdfChangeNamedDestW;
   pdfChangeOCGNameA:               pdfChangeOCGNameA;
   pdfChangeOCGNameW:               pdfChangeOCGNameW;
   pdfChangeSeparationColor:        pdfChangeSeparationColor;
   pdfCheckCollection:              pdfCheckCollection;
   pdfCheckConformance:             pdfCheckConformance;
   pdfCheckFieldNames:              pdfCheckFieldNames;
   pdfCircleAnnotA:                 pdfCircleAnnotA;
   pdfCircleAnnotW:                 pdfCircleAnnotW;
   pdfClearAutoTemplates:           pdfClearAutoTemplates;
   pdfClearErrorLog:                pdfClearErrorLog;
   pdfClearHostFonts:               pdfClearHostFonts;
   pdfClipPath:                     pdfClipPath;
   pdfCloseAndSignFile:             pdfCloseAndSignFile;
   pdfCloseAndSignFileEx:           pdfCloseAndSignFileEx;
   pdfCloseAndSignFileExt:          pdfCloseAndSignFileExt;
   pdfCloseFile:                    pdfCloseFile;
   pdfCloseFileEx:                  pdfCloseFileEx;
   pdfCloseImage:                   pdfCloseImage;
   pdfCloseImportFile:              pdfCloseImportFile;
   pdfCloseImportFileEx:            pdfCloseImportFileEx;
   pdfClosePath:                    pdfClosePath;
   pdfCloseTag:                     pdfCloseTag;
   pdfComputeBBox:                  pdfComputeBBox;
   pdfConvColor:                    pdfConvColor;
   pdfConvertColors:                pdfConvertColors;
   pdfConvertEMFSpoolA:             pdfConvertEMFSpoolA;
   pdfConvertEMFSpoolW:             pdfConvertEMFSpoolW;
   pdfConvToFreeTextCallout:        pdfConvToFreeTextCallout;
   pdfConvToUnicode:                pdfConvToUnicode;
   pdfCopyChoiceValues:             pdfCopyChoiceValues;
   pdfCreate3DAnnotA:               pdfCreate3DAnnotA;
   pdfCreate3DAnnotW:               pdfCreate3DAnnotW;
   pdfCreate3DBackground:           pdfCreate3DBackground;
   pdfCreate3DGotoViewAction:       pdfCreate3DGotoViewAction;
   pdfCreate3DProjection:           pdfCreate3DProjection;
   pdfCreate3DViewW:                pdfCreate3DViewW;
   pdfCreateAltFontList:            pdfCreateAltFontList;
   pdfCreateAnnotAP:                pdfCreateAnnotAP;
   pdfCreateArticleThreadA:         pdfCreateArticleThreadA;
   pdfCreateArticleThreadW:         pdfCreateArticleThreadW;
   pdfCreateAxialShading:           pdfCreateAxialShading;
   pdfCreateBarcodeField:           pdfCreateBarcodeField;
   pdfCreateButtonA:                pdfCreateButtonA;
   pdfCreateButtonW:                pdfCreateButtonW;
   pdfCreateCheckBox:               pdfCreateCheckBox;
   pdfCreateCIEColorSpace:          pdfCreateCIEColorSpace;
   pdfCreateCollection:             pdfCreateCollection;
   pdfCreateCollectionFieldA:       pdfCreateCollectionFieldA;
   pdfCreateCollectionFieldW:       pdfCreateCollectionFieldW;
   pdfCreateColItemDate:            pdfCreateColItemDate;
   pdfCreateColItemNumber:          pdfCreateColItemNumber;
   pdfCreateColItemStringA:         pdfCreateColItemStringA;
   pdfCreateColItemStringW:         pdfCreateColItemStringW;
   pdfCreateComboBox:               pdfCreateComboBox;
   pdfCreateDeviceNColorSpace:      pdfCreateDeviceNColorSpace;
   pdfCreateDPartRoot:              pdfCreateDPartRoot;
   pdfCreateExtGState:              pdfCreateExtGState;
   pdfCreateGeospatialMeasure:      pdfCreateGeospatialMeasure;
   pdfCreateGoToAction:             pdfCreateGoToAction;
   pdfCreateGoToActionEx:           pdfCreateGoToActionEx;
   pdfCreateGoToEActionA:           pdfCreateGoToEActionA;
   pdfCreateGoToEActionW:           pdfCreateGoToEActionW;
   pdfCreateGoToRAction:            pdfCreateGoToRAction;
   pdfCreateGoToRActionW:           pdfCreateGoToRActionW;
   pdfCreateGoToRActionExA:         pdfCreateGoToRActionExA;
   pdfCreateGoToRActionExW:         pdfCreateGoToRActionExW;
   pdfCreateGoToRActionExUA:        pdfCreateGoToRActionExUA;
   pdfCreateGoToRActionExUW:        pdfCreateGoToRActionExUW;
   pdfCreateGroupField:             pdfCreateGroupField;
   pdfCreateHideAction:             pdfCreateHideAction;
   pdfCreateICCBasedColorSpaceA:    pdfCreateICCBasedColorSpaceA;
   pdfCreateICCBasedColorSpaceW:    pdfCreateICCBasedColorSpaceW;
   pdfCreateICCBasedColorSpaceEx:   pdfCreateICCBasedColorSpaceEx;
   pdfCreateImageA:                 pdfCreateImageA;
   pdfCreateImageW:                 pdfCreateImageW;
   pdfCreateImpDataActionA:         pdfCreateImpDataActionA;
   pdfCreateImpDataActionW:         pdfCreateImpDataActionW;
   pdfCreateIndexedColorSpace:      pdfCreateIndexedColorSpace;
   pdfCreateJSActionA:              pdfCreateJSActionA;
   pdfCreateJSActionW:              pdfCreateJSActionW;
   pdfCreateLaunchAction:           pdfCreateLaunchAction;
   pdfCreateLaunchActionExA:        pdfCreateLaunchActionExA;
   pdfCreateLaunchActionExW:        pdfCreateLaunchActionExW;
   pdfCreateListBox:                pdfCreateListBox;
   pdfCreateNamedAction:            pdfCreateNamedAction;
   pdfCreateNamedDestA:             pdfCreateNamedDestA;
   pdfCreateNamedDestW:             pdfCreateNamedDestW;
   pdfCreateNewPDFA:                pdfCreateNewPDFA;
   pdfCreateNewPDFW:                pdfCreateNewPDFW;
   pdfCreateOCGA:                   pdfCreateOCGA;
   pdfCreateOCGW:                   pdfCreateOCGW;
   pdfCreateOCMD:                   pdfCreateOCMD;
   pdfCreateRadialShading:          pdfCreateRadialShading;
   pdfCreateRadioButton:            pdfCreateRadioButton;
   pdfCreateRectilinearMeasureA:    pdfCreateRectilinearMeasureA;
   pdfCreateRectilinearMeasureW:    pdfCreateRectilinearMeasureW;
   pdfCreateResetAction:            pdfCreateResetAction;
   pdfCreateSeparationCS:           pdfCreateSeparationCS;
   pdfCreateSetOCGStateAction:      pdfCreateSetOCGStateAction;
   pdfCreateSigField:               pdfCreateSigField;
   pdfCreateSigFieldAP:             pdfCreateSigFieldAP;
   pdfCreateSoftMask:               pdfCreateSoftMask;
   pdfCreateStdPattern:             pdfCreateStdPattern;
   pdfCreateStructureTreeEx:        pdfCreateStructureTreeEx;
   pdfCreateSubmitAction:           pdfCreateSubmitAction;
   pdfCreateTextField:              pdfCreateTextField;
   pdfCreateURIAction:              pdfCreateURIAction;
   pdfCreateViewportA:              pdfCreateViewportA;
   pdfCreateViewportW:              pdfCreateViewportW;
   pdfCreateXFAStreamA:             pdfCreateXFAStreamA;
   pdfCreateXFAStreamW:             pdfCreateXFAStreamW;
   pdfDecryptPDFA:                  pdfDecryptPDFA;
   pdfDecryptPDFW:                  pdfDecryptPDFW;
   pdfDeleteAcroForm:               pdfDeleteAcroForm;
   pdfDeleteActionFromObj:          pdfDeleteActionFromObj;
   pdfDeleteActionFromObjEx:        pdfDeleteActionFromObjEx;
   pdfDeleteAltFontList:            pdfDeleteAltFontList;
   pdfDeleteAnnotation:             pdfDeleteAnnotation;
   pdfDeleteAnnotationFromPage:     pdfDeleteAnnotationFromPage;
   pdfDeleteAppEvents:              pdfDeleteAppEvents;
   pdfDeleteBookmark:               pdfDeleteBookmark;
   pdfDeleteDPartNode:              pdfDeleteDPartNode;
   pdfDeleteEmbeddedFile:           pdfDeleteEmbeddedFile;
   pdfDeleteField:                  pdfDeleteField;
   pdfDeleteFieldEx:                pdfDeleteFieldEx;
   pdfDeleteJavaScripts:            pdfDeleteJavaScripts;
 {$ifndef DELPHI6_OR_HIGHER}
   pdfDeleteNamedDestA:             pdfDeleteNamedDestA;
 {$endif}
   pdfDeleteNamedDestW:             pdfDeleteNamedDestW;
   pdfDeleteNamedDestByIndex:       pdfDeleteNamedDestByIndex;
   pdfDeleteOCGFromAppEvent:        pdfDeleteOCGFromAppEvent;
   pdfDeleteOCGFromDisplayTree:     pdfDeleteOCGFromDisplayTree;
   pdfDeleteOCUINode:               pdfDeleteOCUINode;
   pdfDeleteOutputIntent:           pdfDeleteOutputIntent;
   pdfDeletePage:                   pdfDeletePage;
   pdfDeletePageLabels:             pdfDeletePageLabels;
   pdfDeleteSeparationInfo:         pdfDeleteSeparationInfo;
   pdfDeleteTemplate:               pdfDeleteTemplate;
   pdfDeleteTemplateEx:             pdfDeleteTemplateEx;
   pdfDeleteWatermark:              pdfDeleteWatermark;
   pdfDeleteXFAForm:                pdfDeleteXFAForm;
   pdfDrawArc:                      pdfDrawArc;
   pdfDrawArcEx:                    pdfDrawArcEx;
   pdfDrawChord:                    pdfDrawChord;
   pdfDrawCircle:                   pdfDrawCircle;
   pdfDrawNGon:                     pdfDrawNGon;
   pdfDrawPie:                      pdfDrawPie;
   pdfEditPage:                     pdfEditPage;
   pdfEditTemplate:                 pdfEditTemplate;
   pdfEditTemplate2:                pdfEditTemplate2;
   pdfEllipse:                      pdfEllipse;
   pdfEnableImageCache:             pdfEnableImageCache;
   pdfEncryptPDFA:                  pdfEncryptPDFA;
   pdfEncryptPDFW:                  pdfEncryptPDFW;
   pdfEndContinueText:              pdfEndContinueText;
   pdfEndLayer:                     pdfEndLayer;
   pdfEndPage:                      pdfEndPage;
   pdfEndPattern:                   pdfEndPattern;
   pdfEndTemplate:                  pdfEndTemplate;
   pdfEnumDocFonts:                 pdfEnumDocFonts;
   pdfEnumHostFonts:                pdfEnumHostFonts;
   pdfEnumHostFontsEx:              pdfEnumHostFontsEx;
   pdfExchangeBookmarks:            pdfExchangeBookmarks;
   pdfExchangePages:                pdfExchangePages;
   pdfExtractText:                  pdfExtractText;
   pdfFileAttachAnnotA:             pdfFileAttachAnnotA;
   pdfFileAttachAnnotW:             pdfFileAttachAnnotW;
   pdfFileAttachAnnotExA:           pdfFileAttachAnnotExA;
   pdfFileAttachAnnotExW:           pdfFileAttachAnnotExW;
   pdfFileLinkA:                    pdfFileLinkA;
   pdfFileLinkW:                    pdfFileLinkW;
   pdfFindBookmarkA:                pdfFindBookmarkA;
   pdfFindBookmarkW:                pdfFindBookmarkW;
   pdfFindEmbeddedFileW:            pdfFindEmbeddedFileW;
   pdfFindFieldA:                   pdfFindFieldA;
   pdfFindFieldW:                   pdfFindFieldW;
   pdfFindLinkAnnot:                pdfFindLinkAnnot;
   pdfFindNextBookmark:             pdfFindNextBookmark;
   pdfFinishSignature:              pdfFinishSignature;
   pdfFlattenAnnotOrField:          pdfFlattenAnnotOrField;
   pdfFlattenAnnots:                pdfFlattenAnnots;
   pdfFlattenForm:                  pdfFlattenForm;
   pdfFlushPageContent:             pdfFlushPageContent;
   pdfFlushPages:                   pdfFlushPages;
   pdfFlushPagesEx:                 pdfFlushPagesEx;
   pdfFreeImageBuffer:              pdfFreeImageBuffer;
   pdfFreeImageObj:                 pdfFreeImageObj;
   pdfFreeImageObjEx:               pdfFreeImageObjEx;
   pdfFreePDF:                      pdfFreePDF;
   pdfFreeTextAnnotA:               pdfFreeTextAnnotA;
   pdfFreeTextAnnotW:               pdfFreeTextAnnotW;
   pdfFreeUniBuf:                   pdfFreeUniBuf;
   pdfGet3DAnnotStream:             pdfGet3DAnnotStream;
   pdfGetActionCount:               pdfGetActionCount;
   pdfGetActionHandle:              pdfGetActionHandle;
   pdfGetActionType:                pdfGetActionType;
   pdfGetActionTypeEx:              pdfGetActionTypeEx;
   pdfGetActiveFont:                pdfGetActiveFont;
   pdfGetAllocBy:                   pdfGetAllocBy;
   pdfGetAnnot:                     pdfGetAnnot;
   pdfGetAnnotBBox:                 pdfGetAnnotBBox;
   pdfGetAnnotColor:                pdfGetAnnotColor;
   pdfGetAnnotCount:                pdfGetAnnotCount;
   pdfGetAnnotEx:                   pdfGetAnnotEx;
   pdfGetAnnotFlags:                pdfGetAnnotFlags;
   pdfGetAnnotLink:                 pdfGetAnnotLink;
   pdfGetAnnotTextAlign:            pdfGetAnnotTextAlign;
   pdfGetAnnotType:                 pdfGetAnnotType;
   pdfGetAscent:                    pdfGetAscent;
   pdfGetBarcodeDict:               pdfGetBarcodeDict;
   pdfGetBBox:                      pdfGetBBox;
   pdfGetBidiMode:                  pdfGetBidiMode;
   pdfGetBookmark:                  pdfGetBookmark;
   pdfGetBookmarkCount:             pdfGetBookmarkCount;
   pdfGetBookmarkEx:                pdfGetBookmarkEx;
   pdfGetBorderStyle:               pdfGetBorderStyle;
   pdfGetBuffer:                    pdfGetBuffer;
   pdfGetCapHeight:                 pdfGetCapHeight;
   pdfGetCharacterSpacing:          pdfGetCharacterSpacing;
   pdfGetCheckBoxChar:              pdfGetCheckBoxChar;
   pdfGetCheckBoxCharEx:            pdfGetCheckBoxCharEx;
   pdfGetCheckBoxDefState:          pdfGetCheckBoxDefState;
   pdfGetCMap:                      pdfGetCMap;
   pdfGetCMapCount:                 pdfGetCMapCount;
   pdfGetCollectionInfo:            pdfGetCollectionInfo;
   pdfGetColorSpace:                pdfGetColorSpace;
   pdfGetColorSpaceCount:           pdfGetColorSpaceCount;
   pdfGetColorSpaceObj:             pdfGetColorSpaceObj;
   pdfGetColorSpaceObjEx:           pdfGetColorSpaceObjEx;
   pdfGetCompressionFilter:         pdfGetCompressionFilter;
   pdfGetCompressionLevel:          pdfGetCompressionLevel;
   pdfGetContent:                   pdfGetContent;
   pdfGetDefBitsPerPixel:           pdfGetDefBitsPerPixel;
   pdfGetDescent:                   pdfGetDescent;
   pdfGetDeviceNAttributes:         pdfGetDeviceNAttributes;
   pdfGetDocInfo:                   pdfGetDocInfo;
   pdfGetDocInfoCount:              pdfGetDocInfoCount;
   pdfGetDocInfoEx:                 pdfGetDocInfoEx;
   pdfGetDocUsesTransparency:       pdfGetDocUsesTransparency;
   pdfGetDrawDirection:             pdfGetDrawDirection;
   pdfGetDynaPDFVersion:            pdfGetDynaPDFVersion;
   pdfGetEmbeddedFile:              pdfGetEmbeddedFile;
   pdfGetEmbeddedFileCount:         pdfGetEmbeddedFileCount;
   pdfGetEmbeddedFileNode:          pdfGetEmbeddedFileNode;
   pdfGetEMFPatternDistance:        pdfGetEMFPatternDistance;
   pdfGetErrLogMessage:             pdfGetErrLogMessage;
   pdfGetErrLogMessageCount:        pdfGetErrLogMessageCount;
   pdfGetErrorMessage:              pdfGetErrorMessage;
   pdfGetErrorMode:                 pdfGetErrorMode;
   pdfGetField:                     pdfGetField;
   pdfGetFieldBackColor:            pdfGetFieldBackColor;
   pdfGetFieldBorderColor:          pdfGetFieldBorderColor;
   pdfGetFieldBorderStyle:          pdfGetFieldBorderStyle;
   pdfGetFieldBorderWidth:          pdfGetFieldBorderWidth;
   pdfGetFieldCalcOrder:            pdfGetFieldCalcOrder;
   pdfGetFieldChoiceValue:          pdfGetFieldChoiceValue;
   pdfGetFieldColor:                pdfGetFieldColor;
   pdfGetFieldCount:                pdfGetFieldCount;
   pdfGetFieldEx:                   pdfGetFieldEx;
   pdfGetFieldEx2:                  pdfGetFieldEx2;
   pdfGetFieldExpValCount:          pdfGetFieldExpValCount;
   pdfGetFieldExpValue:             pdfGetFieldExpValue;
   pdfGetFieldExpValueEx:           pdfGetFieldExpValueEx;
   pdfGetFieldFlags:                pdfGetFieldFlags;
   pdfGetFieldGroupType:            pdfGetFieldGroupType;
   pdfGetFieldHighlightMode:        pdfGetFieldHighlightMode;
   pdfGetFieldIndex:                pdfGetFieldIndex;
   pdfGetFieldMapName:              pdfGetFieldMapName;
   pdfGetFieldName:                 pdfGetFieldName;
   pdfGetFieldOrientation:          pdfGetFieldOrientation;
   pdfGetFieldTextAlign:            pdfGetFieldTextAlign;
   pdfGetFieldTextColor:            pdfGetFieldTextColor;
   pdfGetFieldToolTip:              pdfGetFieldToolTip;
   pdfGetFieldType:                 pdfGetFieldType;
   pdfGetFileSpec:                  pdfGetFileSpec;
   pdfGetFillColor:                 pdfGetFillColor;
   pdfGetFontCount:                 pdfGetFontCount;
   pdfGetFontEx:                    pdfGetFontEx;
   pdfGetFontInfoEx:                pdfGetFontInfoEx;
   pdfGetFontMetrics:               pdfGetFontMetrics;
   pdfGetFontOrigin:                pdfGetFontOrigin;
   pdfGetFontSearchOrder:           pdfGetFontSearchOrder;
   pdfGetFontSelMode:               pdfGetFontSelMode;
   pdfGetFontSize:                  pdfGetFontSize;
   pdfGetFontWeight:                pdfGetFontWeight;
   pdfGetFTextHeightA:              pdfGetFTextHeightA;
   pdfGetFTextHeightExA:            pdfGetFTextHeightExA;
   pdfGetFTextHeightExW:            pdfGetFTextHeightExW;
   pdfGetFTextHeightW:              pdfGetFTextHeightW;
   pdfGetFullyQualifiedFieldName:   pdfGetFullyQualifiedFieldName;
   pdfGetGlyphIndex:                pdfGetGlyphIndex;
   pdfGetGlyphOutline:              pdfGetGlyphOutline;
   pdfGetGoToAction:                pdfGetGoToAction;
   pdfGetGoToRAction:               pdfGetGoToRAction;
   pdfGetGStateFlags:               pdfGetGStateFlags;
   pdfGetHideAction:                pdfGetHideAction;
   pdfGetIconColor:                 pdfGetIconColor;
   pdfGetImageBuffer:               pdfGetImageBuffer;
   pdfGetImageCountA:               pdfGetImageCountA;
   pdfGetImageCountW:               pdfGetImageCountW;
   pdfGetImageCountEx:              pdfGetImageCountEx;
   pdfGetImageHeight:               pdfGetImageHeight;
   pdfGetImageObj:                  pdfGetImageObj;
   pdfGetImageObjCount:             pdfGetImageObjCount;
   pdfGetImageObjEx:                pdfGetImageObjEx;
   pdfGetImageWidth:                pdfGetImageWidth;
   pdfGetImportDataAction:          pdfGetImportDataAction;
   pdfGetImportFlags:               pdfGetImportFlags;
   pdfGetImportFlags2:              pdfGetImportFlags2;
   pdfGetInBBox:                    pdfGetInBBox;
   pdfGetInDocInfo:                 pdfGetInDocInfo;
   pdfGetInDocInfoCount:            pdfGetInDocInfoCount;
   pdfGetInDocInfoEx:               pdfGetInDocInfoEx;
   pdfGetInEncryptionFlags:         pdfGetInEncryptionFlags;
   pdfGetInEncryptionInfo:          pdfGetInEncryptionInfo;
   pdfGetInFieldCount:              pdfGetInFieldCount;
   pdfGetInIsCollection:            pdfGetInIsCollection;
   pdfGetInIsEncrypted:             pdfGetInIsEncrypted;
   pdfGetInIsSigned:                pdfGetInIsSigned;
   pdfGetInIsTaggedPDF:             pdfGetInIsTaggedPDF;
   pdfGetInIsTrapped:               pdfGetInIsTrapped;
   pdfGetInIsXFAForm:               pdfGetInIsXFAForm;
   pdfGetInkList:                   pdfGetInkList;
   pdfGetInMetadata:                pdfGetInMetadata;
   pdfGetInOrientation:             pdfGetInOrientation;
   pdfGetInPageCount:               pdfGetInPageCount;
   pdfGetInPDFVersion:              pdfGetInPDFVersion;
   pdfGetInPDFVersionEx:            pdfGetInPDFVersionEx;
   pdfGetInPrintSettings:           pdfGetInPrintSettings;
   pdfGetInRepairMode:              pdfGetInRepairMode;
   pdfGetIsFixedPitch:              pdfGetIsFixedPitch;
   pdfGetIsTaggingEnabled:          pdfGetIsTaggingEnabled;
   pdfGetItalicAngle:               pdfGetItalicAngle;
   pdfGetJavaScript:                pdfGetJavaScript;
   pdfGetJavaScriptAction:          pdfGetJavaScriptAction;
   pdfGetJavaScriptAction2:         pdfGetJavaScriptAction2;
   pdfGetJavaScriptActionEx:        pdfGetJavaScriptActionEx;
   pdfGetJavaScriptCount:           pdfGetJavaScriptCount;
   pdfGetJavaScriptEx:              pdfGetJavaScriptEx;
   pdfGetJavaScriptName:            pdfGetJavaScriptName;
   pdfGetJPEGQuality:               pdfGetJPEGQuality;
   pdfGetLanguage:                  pdfGetLanguage;
   pdfGetLastTextPosX:              pdfGetLastTextPosX;
   pdfGetLastTextPosXAbs:           pdfGetLastTextPosXAbs;
   pdfGetLastTextPosY:              pdfGetLastTextPosY;
   pdfGetLastTextPosYAbs:           pdfGetLastTextPosYAbs;
   pdfGetLaunchAction:              pdfGetLaunchAction;
   pdfGetLayerConfig:               pdfGetLayerConfig;
   pdfGetLayerConfigCount:          pdfGetLayerConfigCount;
   pdfGetLeading:                   pdfGetLeading;
   pdfGetLineCapStyle:              pdfGetLineCapStyle;
   pdfGetLineJoinStyle:             pdfGetLineJoinStyle;
   pdfGetLineWidth:                 pdfGetLineWidth;
   pdfGetLinkHighlightMode:         pdfGetLinkHighlightMode;
   pdfGetLogMetafileSizeA:          pdfGetLogMetafileSizeA;
   pdfGetLogMetafileSizeW:          pdfGetLogMetafileSizeW;
   pdfGetLogMetafileSizeEx:         pdfGetLogMetafileSizeEx;
   pdfGetMatrix:                    pdfGetMatrix;
   pdfGetMaxFieldLen:               pdfGetMaxFieldLen;
   pdfGetMeasureObj:                pdfGetMeasureObj;
   pdfGetMetaConvFlags:             pdfGetMetaConvFlags;
   pdfGetMetadata:                  pdfGetMetadata;
   pdfGetMissingGlyphs:             pdfGetMissingGlyphs;
   pdfGetMiterLimit:                pdfGetMiterLimit;
   pdfGetMovieAction:               pdfGetMovieAction;
   pdfGetNamedAction:               pdfGetNamedAction;
   pdfGetNamedDest:                 pdfGetNamedDest;
   pdfGetNamedDestCount:            pdfGetNamedDestCount;
   pdfGetNeedAppearance:            pdfGetNeedAppearance;
   pdfGetNumberFormatObj:           pdfGetNumberFormatObj;
   pdfGetObjActionCount:            pdfGetObjActionCount;
   pdfGetObjActions:                pdfGetObjActions;
   pdfGetObjEvent:                  pdfGetObjEvent;
   pdfGetOCG:                       pdfGetOCG;
   pdfGetOCGContUsage:              pdfGetOCGContUsage;
   pdfGetOCGCount:                  pdfGetOCGCount;
   pdfGetOCGUsageUserName:          pdfGetOCGUsageUserName;
   pdfGetOCHandle:                  pdfGetOCHandle;
   pdfGetOCUINode:                  pdfGetOCUINode;
   pdfGetOpacity:                   pdfGetOpacity;
   pdfGetOrientation:               pdfGetOrientation;
   pdfGetOutputIntent:              pdfGetOutputIntent;
   pdfGetOutputIntentCount:         pdfGetOutputIntentCount;
   pdfGetPageAnnot:                 pdfGetPageAnnot;
   pdfGetPageAnnotCount:            pdfGetPageAnnotCount;
   pdfGetPageAnnotEx:               pdfGetPageAnnotEx;
   pdfGetPageBBox:                  pdfGetPageBBox;
   pdfGetPageCoords:                pdfGetPageCoords;
   pdfGetPageCount:                 pdfGetPageCount;
   pdfGetPageField:                 pdfGetPageField;
   pdfGetPageFieldCount:            pdfGetPageFieldCount;
   pdfGetPageFieldEx:               pdfGetPageFieldEx;
   pdfGetPageHeight:                pdfGetPageHeight;
   pdfGetPageLabel:                 pdfGetPageLabel;
   pdfGetPageLabelCount:            pdfGetPageLabelCount;
   pdfGetPageLayout:                pdfGetPageLayout;
   pdfGetPageMode:                  pdfGetPageMode;
   pdfGetPageNum:                   pdfGetPageNum;
   pdfGetPageObject:                pdfGetPageObject;
   pdfGetPageOrientation:           pdfGetPageOrientation;
   pdfGetPageText:                  pdfGetPageText;
   pdfGetPageWidth:                 pdfGetPageWidth;
   pdfGetPDFVersion:                pdfGetPDFVersion;
   pdfGetPDFVersionEx:              pdfGetPDFVersionEx;
   pdfGetPrintSettings:             pdfGetPrintSettings;
   pdfGetPtDataArray:               pdfGetPtDataArray;
   pdfGetPtDataObj:                 pdfGetPtDataObj;
   pdfGetRelFileNode:               pdfGetRelFileNode;
   pdfGetResetAction:               pdfGetResetAction;
   pdfGetResolution:                pdfGetResolution;
   pdfGetSaveNewImageFormat:        pdfGetSaveNewImageFormat;
   pdfGetSeparationInfo:            pdfGetSeparationInfo;
   pdfGetSigDict:                   pdfGetSigDict;
   pdfGetStrokeColor:               pdfGetStrokeColor;
   pdfGetSubmitAction:              pdfGetSubmitAction;
   pdfGetSysFontInfo:               pdfGetSysFontInfo;
   pdfGetTabLen:                    pdfGetTabLen;
   pdfGetTemplCount:                pdfGetTemplCount;
   pdfGetTemplHandle:               pdfGetTemplHandle;
   pdfGetTemplHeight:               pdfGetTemplHeight;
   pdfGetTemplWidth:                pdfGetTemplWidth;
   pdfGetTextBBoxA:                 pdfGetTextBBoxA;
   pdfGetTextBBoxW:                 pdfGetTextBBoxW;
   pdfGetTextDrawMode:              pdfGetTextDrawMode;
   pdfGetTextFieldValue:            pdfGetTextFieldValue;
   pdfGetTextRect:                  pdfGetTextRect;
   pdfGetTextRise:                  pdfGetTextRise;
   pdfGetTextScaling:               pdfGetTextScaling;
   pdfGetTextWidthA:                pdfGetTextWidthA;
   pdfGetTextWidthW:                pdfGetTextWidthW;
   pdfGetTextWidthExA:              pdfGetTextWidthExA;
   pdfGetTextWidthExW:              pdfGetTextWidthExW;
   pdfGetTrapped:                   pdfGetTrapped;
   pdfGetTransparentColor:          pdfGetTransparentColor;
   pdfGetTypoLeading:               pdfGetTypoLeading;
   pdfGetURIAction:                 pdfGetURIAction;
   pdfGetUseExactPwd:               pdfGetUseExactPwd;
   pdfGetUseGlobalImpFiles:         pdfGetUseGlobalImpFiles;
   pdfGetUserRights:                pdfGetUserRights;
   pdfGetUserUnit:                  pdfGetUserUnit;
   pdfGetUseStdFonts:               pdfGetUseStdFonts;
   pdfGetUseSystemFonts:            pdfGetUseSystemFonts;
   pdfGetUsesTransparency:          pdfGetUsesTransparency;
   pdfGetUseTransparency:           pdfGetUseTransparency;
   pdfGetUseVisibleCoords:          pdfGetUseVisibleCoords;
   pdfGetViewerPreferences:         pdfGetViewerPreferences;
   pdfGetViewport:                  pdfGetViewport;
   pdfGetViewportCount:             pdfGetViewportCount;
   pdfGetWMFDefExtent:              pdfGetWMFDefExtent;
   pdfGetWMFPixelPerInch:           pdfGetWMFPixelPerInch;
   pdfGetWordSpacing:               pdfGetWordSpacing;
   pdfGetXFAStream:                 pdfGetXFAStream;
   pdfGetXFAStreamCount:            pdfGetXFAStreamCount;
   pdfHaveDPartRoot:                pdfHaveDPartRoot;
   pdfHaveOpenDoc:                  pdfHaveOpenDoc;
   pdfHaveOpenPage:                 pdfHaveOpenPage;
   pdfHighlightAnnotA:              pdfHighlightAnnotA;
   pdfHighlightAnnotW:              pdfHighlightAnnotW;
   pdfImportBookmarks:              pdfImportBookmarks;
   pdfImportCatalogObjects:         pdfImportCatalogObjects;
   pdfImportDocInfo:                pdfImportDocInfo;
   pdfImportEncryptionSettings:     pdfImportEncryptionSettings;
   pdfImportOCProperties:           pdfImportOCProperties;
   pdfImportPage:                   pdfImportPage;
   pdfImportPageEx:                 pdfImportPageEx;
   pdfImportPDFFile:                pdfImportPDFFile;
   pdfInitBarcode2:                 pdfInitBarcode2;
   pdfInitColorManagement:          pdfInitColorManagement;
   pdfInitColorManagementEx:        pdfInitColorManagementEx;
   pdfInitExtGState:                pdfInitExtGState;
   pdfInitHeaderFooter:             pdfInitHeaderFooter;
   pdfInitOCGContUsage:             pdfInitOCGContUsage;
   pdfInitStack:                    pdfInitStack;
   pdfInkAnnotA:                    pdfInkAnnotA;
   pdfInkAnnotW:                    pdfInkAnnotW;
   pdfInsertBarcode:                pdfInsertBarcode;
   pdfInsertBMPFromBuffer:          pdfInsertBMPFromBuffer;
   pdfInsertBMPFromHandle:          pdfInsertBMPFromHandle;
   pdfInsertBookmarkA:              pdfInsertBookmarkA;
   pdfInsertBookmarkW:              pdfInsertBookmarkW;
   pdfInsertBookmarkExA:            pdfInsertBookmarkExA;
   pdfInsertBookmarkExW:            pdfInsertBookmarkExW;
   pdfInsertImage:                  pdfInsertImage;
   pdfInsertImageEx:                pdfInsertImageEx;
   pdfInsertImageExW:               pdfInsertImageExW;
   pdfInsertImageFromBuffer:        pdfInsertImageFromBuffer;
   pdfInsertMetafileA:              pdfInsertMetafileA;
   pdfInsertMetafileW:              pdfInsertMetafileW;
   pdfInsertMetafileEx:             pdfInsertMetafileEx;
   pdfInsertMetafileExtA:           pdfInsertMetafileExtA;
   pdfInsertMetafileExtW:           pdfInsertMetafileExtW;
   pdfInsertMetafileExtEx:          pdfInsertMetafileExtEx;
   pdfInsertMetafileFromHandle:     pdfInsertMetafileFromHandle;
   pdfInsertMetafileFromHandleEx:   pdfInsertMetafileFromHandleEx;
   pdfInsertRawImage:               pdfInsertRawImage;
   pdfInsertRawImageEx:             pdfInsertRawImageEx;
   pdfIsBidiText:                   pdfIsBidiText;
   pdfIsColorPage:                  pdfIsColorPage;
   pdfIsEmptyPage:                  pdfIsEmptyPage;
   pdfLineAnnotA:                   pdfLineAnnotA;
   pdfLineAnnotW:                   pdfLineAnnotW;
   pdfLineTo:                       pdfLineTo;
   pdfLoadCMap:                     pdfLoadCMap;
   pdfLoadFDFDataA:                 pdfLoadFDFDataA;
   pdfLoadFDFDataW:                 pdfLoadFDFDataW;
   pdfLoadFDFDataEx:                pdfLoadFDFDataEx;
   pdfLoadFont:                     pdfLoadFont;
   pdfLoadFontExA:                  pdfLoadFontExA;
   pdfLoadFontExW:                  pdfLoadFontExW;
   pdfLoadHeaderFooterSettings:     pdfLoadHeaderFooterSettings;
   pdfLoadLayerConfig:              pdfLoadLayerConfig;
   pdfLockLayer:                    pdfLockLayer;
   pdfMarkTemplateAsWatermark:      pdfMarkTemplateAsWatermark;
   pdfMovePage:                     pdfMovePage;
   pdfMoveTo:                       pdfMoveTo;
   pdfOpenImportBuffer:             pdfOpenImportBuffer;
   pdfOpenImportFileA:              pdfOpenImportFileA;
   pdfOpenImportFileW:              pdfOpenImportFileW;
   pdfOpenOutputFileA:              pdfOpenOutputFileA;
   pdfOpenOutputFileW:              pdfOpenOutputFileW;
   pdfOpenOutputFileEncryptedW:     pdfOpenOutputFileEncryptedW;
   pdfOpenTagA:                     pdfOpenTagA;
   pdfOpenTagW:                     pdfOpenTagW;
   pdfOpenTagBBoxA:                 pdfOpenTagBBoxA;
   pdfOpenTagBBoxW:                 pdfOpenTagBBoxW;
   pdfOpenTagExA:                   pdfOpenTagExA;
   pdfOpenTagExW:                   pdfOpenTagExW;
   pdfOptimize:                     pdfOptimize;
   pdfPageLink:                     pdfPageLink;
   pdfPageLink2:                    pdfPageLink2;
   pdfPageLink3A:                   pdfPageLink3A;
   pdfPageLink3W:                   pdfPageLink3W;
   pdfPageLinkEx:                   pdfPageLinkEx;
   pdfParseContent:                 pdfParseContent;
   pdfPlaceImage:                   pdfPlaceImage;
   pdfPlaceSigFieldValidateIcon:    pdfPlaceSigFieldValidateIcon;
   pdfPlaceTemplate:                pdfPlaceTemplate;
   pdfPlaceTemplateEx:              pdfPlaceTemplateEx;
   pdfPlaceTemplByMatrix:           pdfPlaceTemplByMatrix;
   pdfPolygonAnnotA:                pdfPolygonAnnotA;
   pdfPolygonAnnotW:                pdfPolygonAnnotW;
   pdfPolyLineAnnotA:               pdfPolyLineAnnotA;
   pdfPolyLineAnnotW:               pdfPolyLineAnnotW;
   pdfPrintPageA:                   pdfPrintPageA;
   pdfPrintPageW:                   pdfPrintPageW;
   pdfPrintPDFFileA:                pdfPrintPDFFileA;
   pdfPrintPDFFileW:                pdfPrintPDFFileW;
   pdfReadImageFormatA:             pdfReadImageFormatA;
   pdfReadImageFormatW:             pdfReadImageFormatW;
   pdfReadImageFormat2A:            pdfReadImageFormat2A;
   pdfReadImageFormat2W:            pdfReadImageFormat2W;
   pdfReadImageFormatEx:            pdfReadImageFormatEx;
   pdfReadImageFormatFromBuffer:    pdfReadImageFormatFromBuffer;
   pdfReadImageResolutionA:         pdfReadImageResolutionA;
   pdfReadImageResolutionW:         pdfReadImageResolutionW;
   pdfReadImageResolutionEx:        pdfReadImageResolutionEx;
   pdfRectangle:                    pdfRectangle;
   pdfReEncryptPDFA:                pdfReEncryptPDFA;
   pdfReEncryptPDFW:                pdfReEncryptPDFW;
   pdfRenameSpotColor:              pdfRenameSpotColor;
   pdfRenderAnnotOrField:           pdfRenderAnnotOrField;
   pdfRenderPage:                   pdfRenderPage;
   pdfRenderPageEx:                 pdfRenderPageEx;
   pdfRenderPageToImageA:           pdfRenderPageToImageA;
   pdfRenderPageToImageW:           pdfRenderPageToImageW;
   pdfRenderPDFFileA:               pdfRenderPDFFileA;
   pdfRenderPDFFileW:               pdfRenderPDFFileW;
   pdfRenderPDFFileExA:             pdfRenderPDFFileExA;
   pdfRenderPDFFileExW:             pdfRenderPDFFileExW;
   pdfReOpenImportFile:             pdfReOpenImportFile;
   pdfReplaceFontA:                 pdfReplaceFontA;
   pdfReplaceFontW:                 pdfReplaceFontW;
   pdfReplaceFontExA:               pdfReplaceFontExA;
   pdfReplaceFontExW:               pdfReplaceFontExW;
   pdfReplaceICCProfileA:           pdfReplaceICCProfileA;
   pdfReplaceICCProfileW:           pdfReplaceICCProfileW;
   pdfReplaceICCProfileEx:          pdfReplaceICCProfileEx;
   pdfReplaceImageA:                pdfReplaceImageA;
   pdfReplaceImageW:                pdfReplaceImageW;
   pdfReplaceImageEx:               pdfReplaceImageEx;
   pdfReplacePageTextA:             pdfReplacePageTextA;
   pdfReplacePageTextExA:           pdfReplacePageTextExA;
   pdfReplacePageTextExW:           pdfReplacePageTextExW;
   pdfResetAnnotAP:                 pdfResetAnnotAP;
   pdfResetEncryptionSettings:      pdfResetEncryptionSettings;
   pdfResetLineDashPattern:         pdfResetLineDashPattern;
   pdfRestoreGraphicState:          pdfRestoreGraphicState;
   pdfRotateCoords:                 pdfRotateCoords;
   pdfRoundRect:                    pdfRoundRect;
   pdfRoundRectEx:                  pdfRoundRectEx;
   pdfSaveGraphicState:             pdfSaveGraphicState;
   pdfScaleCoords:                  pdfScaleCoords;
   pdfSelfTest:                     pdfSelfTest;
   pdfSet3DAnnotProps:              pdfSet3DAnnotProps;
   pdfSet3DAnnotScriptA:            pdfSet3DAnnotScriptA;
   pdfSetActiveSigField:            pdfSetActiveSigField;
   pdfSetAllocBy:                   pdfSetAllocBy;
   pdfSetAltFontsW:                 pdfSetAltFontsW;
   pdfSetAnnotBorderEffect:         pdfSetAnnotBorderEffect;
   pdfSetAnnotBorderStyle:          pdfSetAnnotBorderStyle;
   pdfSetAnnotBorderWidth:          pdfSetAnnotBorderWidth;
   pdfSetAnnotColor:                pdfSetAnnotColor;
   pdfSetAnnotFlags:                pdfSetAnnotFlags;
   pdfSetAnnotFlagsEx:              pdfSetAnnotFlagsEx;
   pdfSetAnnotHighlightMode:        pdfSetAnnotHighlightMode;
   pdfSetAnnotIcon:                 pdfSetAnnotIcon;
   pdfSetAnnotLineDashPattern:      pdfSetAnnotLineDashPattern;
   pdfSetAnnotLineEndStyle:         pdfSetAnnotLineEndStyle;
   pdfSetAnnotMigrationStateA:      pdfSetAnnotMigrationStateA;
   pdfSetAnnotMigrationStateW:      pdfSetAnnotMigrationStateW;
   pdfSetAnnotOpacity:              pdfSetAnnotOpacity;
   pdfSetAnnotOpenState:            pdfSetAnnotOpenState;
   pdfSetAnnotOrFieldDate:          pdfSetAnnotOrFieldDate;
   pdfSetAnnotQuadPoints:           pdfSetAnnotQuadPoints;
   pdfSetAnnotStringA:              pdfSetAnnotStringA;
   pdfSetAnnotStringW:              pdfSetAnnotStringW;
   pdfSetAnnotSubjectA:             pdfSetAnnotSubjectA;
   pdfSetAnnotSubjectW:             pdfSetAnnotSubjectW;
   pdfSetBBox:                      pdfSetBBox;
   pdfSetBidiMode:                  pdfSetBidiMode;
   pdfSetBookmarkDest:              pdfSetBookmarkDest;
   pdfSetBookmarkStyle:             pdfSetBookmarkStyle;
   pdfSetBorderStyle:               pdfSetBorderStyle;
   pdfSetCharacterSpacing:          pdfSetCharacterSpacing;
   pdfSetCheckBoxChar:              pdfSetCheckBoxChar;
   pdfSetCheckBoxDefState:          pdfSetCheckBoxDefState;
   pdfSetCheckBoxState:             pdfSetCheckBoxState;
   pdfSetCIDFontA:                  pdfSetCIDFontA;
   pdfSetCIDFontW:                  pdfSetCIDFontW;
   pdfSetCMapDirA:                  pdfSetCMapDirA;
   pdfSetCMapDirW:                  pdfSetCMapDirW;
   pdfSetColDefFile:                pdfSetColDefFile;
   pdfSetColorMask:                 pdfSetColorMask;
   pdfSetColors:                    pdfSetColors;
   pdfSetColorSpace:                pdfSetColorSpace;
   pdfSetColSortField:              pdfSetColSortField;
   pdfSetCompressionFilter:         pdfSetCompressionFilter;
   pdfSetCompressionLevel:          pdfSetCompressionLevel;
   pdfSetContent:                   pdfSetContent;
   pdfSetDateTimeFormat:            pdfSetDateTimeFormat;
   pdfSetDefBitsPerPixel:           pdfSetDefBitsPerPixel;
   pdfSetDocInfoA:                  pdfSetDocInfoA;
   pdfSetDocInfoW:                  pdfSetDocInfoW;
   pdfSetDocInfoExA:                pdfSetDocInfoExA;
   pdfSetDocInfoExW:                pdfSetDocInfoExW;
   pdfSetDrawDirection:             pdfSetDrawDirection;
   pdfSetEMFFrameDPI:               pdfSetEMFFrameDPI;
   pdfSetEMFPatternDistance:        pdfSetEMFPatternDistance;
   pdfSetErrorMode:                 pdfSetErrorMode;
   pdfSetExtColorSpace:             pdfSetExtColorSpace;
   pdfSetExtFillColorSpace:         pdfSetExtFillColorSpace;
   pdfSetExtGState:                 pdfSetExtGState;
   pdfSetExtStrokeColorSpace:       pdfSetExtStrokeColorSpace;
   pdfSetFieldBackColor:            pdfSetFieldBackColor;
   pdfSetFieldBBox:                 pdfSetFieldBBox;
   pdfSetFieldBorderColor:          pdfSetFieldBorderColor;
   pdfSetFieldBorderStyle:          pdfSetFieldBorderStyle;
   pdfSetFieldBorderWidth:          pdfSetFieldBorderWidth;
   pdfSetFieldCalcOrder:            pdfSetFieldCalcOrder;
   pdfSetFieldColor:                pdfSetFieldColor;
   pdfSetFieldExpValue:             pdfSetFieldExpValue;
   pdfSetFieldExpValueW:            pdfSetFieldExpValueW;
   pdfSetFieldExpValueEx:           pdfSetFieldExpValueEx;
   pdfSetFieldFlags:                pdfSetFieldFlags;
   pdfSetFieldFontA:                pdfSetFieldFontA;
   pdfSetFieldFontW:                pdfSetFieldFontW;
   pdfSetFieldFontEx:               pdfSetFieldFontEx;
   pdfSetFieldFontSize:             pdfSetFieldFontSize;
   pdfSetFieldHighlightMode:        pdfSetFieldHighlightMode;
   pdfSetFieldIndex:                pdfSetFieldIndex;
   pdfSetFieldMapNameA:             pdfSetFieldMapNameA;
   pdfSetFieldMapNameW:             pdfSetFieldMapNameW;
   pdfSetFieldNameA:                pdfSetFieldNameA;
   pdfSetFieldNameW:                pdfSetFieldNameW;
   pdfSetFieldOrientation:          pdfSetFieldOrientation;
   pdfSetFieldTextAlign:            pdfSetFieldTextAlign;
   pdfSetFieldTextColor:            pdfSetFieldTextColor;
   pdfSetFieldToolTipA:             pdfSetFieldToolTipA;
   pdfSetFieldToolTipW:             pdfSetFieldToolTipW;
   pdfSetFillColor:                 pdfSetFillColor;
   pdfSetFillColorEx:               pdfSetFillColorEx;
   pdfSetFillColorF:                pdfSetFillColorF;
   pdfSetFillColorSpace:            pdfSetFillColorSpace;
   pdfSetFloatPrecision:            pdfSetFloatPrecision;
   pdfSetFontA:                     pdfSetFontA;
   pdfSetFontW:                     pdfSetFontW;
   pdfSetFontExA:                   pdfSetFontExA;
   pdfSetFontExW:                   pdfSetFontExW;
   pdfSetFontOrigin:                pdfSetFontOrigin;
   pdfSetFontSearchOrder:           pdfSetFontSearchOrder;
   pdfSetFontSearchOrderEx:         pdfSetFontSearchOrderEx;
   pdfSetFontSelMode:               pdfSetFontSelMode;
   pdfSetFontWeight:                pdfSetFontWeight;
   pdfSetGStateFlags:               pdfSetGStateFlags;
   pdfSetIconColor:                 pdfSetIconColor;
   pdfSetImportFlags:               pdfSetImportFlags;
   pdfSetImportFlags2:              pdfSetImportFlags2;
   pdfSetItalicAngle:               pdfSetItalicAngle;
   pdfSetJPEGQuality:               pdfSetJPEGQuality;
   pdfSetLanguage:                  pdfSetLanguage;
   pdfSetLeading:                   pdfSetLeading;
   pdfSetLicenseKey:                pdfSetLicenseKey;
   pdfSetLineAnnotParms:            pdfSetLineAnnotParms;
   pdfSetLineAnnotPoints:           pdfSetLineAnnotPoints;
   pdfSetLineCapStyle:              pdfSetLineCapStyle;
   pdfSetLineDashPattern:           pdfSetLineDashPattern;
   pdfSetLineDashPattern2:          pdfSetLineDashPattern2;
   pdfSetLineDashPatternEx:         pdfSetLineDashPatternEx;
   pdfSetLineJoinStyle:             pdfSetLineJoinStyle;
   pdfSetLineWidth:                 pdfSetLineWidth;
   pdfSetLinkHighlightMode:         pdfSetLinkHighlightMode;
   pdfSetListFont:                  pdfSetListFont;
   pdfSetMatrix:                    pdfSetMatrix;
   pdfSetMaxErrLogMsgCount:         pdfSetMaxErrLogMsgCount;
   pdfSetMaxFieldLen:               pdfSetMaxFieldLen;
   pdfSetMetaConvFlags:             pdfSetMetaConvFlags;
   pdfSetMetadata:                  pdfSetMetadata;
   pdfSetMiterLimit:                pdfSetMiterLimit;
   pdfSetNeedAppearance:            pdfSetNeedAppearance;
   pdfSetNumberFormat:              pdfSetNumberFormat;
   pdfSetOCGContUsage:              pdfSetOCGContUsage;
   pdfSetOCGState:                  pdfSetOCGState;
   pdfSetOnErrorProc:               pdfSetOnErrorProc;
   pdfSetOnPageBreakProc:           pdfSetOnPageBreakProc;
   pdfSetOpacity:                   pdfSetOpacity;
   pdfSetOrientation:               pdfSetOrientation;
   pdfSetOrientationEx:             pdfSetOrientationEx;
   pdfSetPageBBox:                  pdfSetPageBBox;
   pdfSetPageCoords:                pdfSetPageCoords;
   pdfSetPageFormat:                pdfSetPageFormat;
   pdfSetPageHeight:                pdfSetPageHeight;
   pdfSetPageLayout:                pdfSetPageLayout;
   pdfSetPageMode:                  pdfSetPageMode;
   pdfSetPageOrientation:           pdfSetPageOrientation;
   pdfSetPageWidth:                 pdfSetPageWidth;
   pdfSetPDFVersion:                pdfSetPDFVersion;
   pdfSetPrintSettings:             pdfSetPrintSettings;
   pdfSetProgressProc:              pdfSetProgressProc;
   pdfSetRenderingIntent:           pdfSetRenderingIntent;
   pdfSetResolution:                pdfSetResolution;
   pdfSetSaveNewImageFormat:        pdfSetSaveNewImageFormat;
   pdfSetSeparationInfo:            pdfSetSeparationInfo;
   pdfSetSpaceWidthFactor:          pdfSetSpaceWidthFactor;
   pdfSetStrokeColor:               pdfSetStrokeColor;
   pdfSetStrokeColorEx:             pdfSetStrokeColorEx;
   pdfSetStrokeColorF:              pdfSetStrokeColorF;
   pdfSetStrokeColorSpace:          pdfSetStrokeColorSpace;
   pdfSetTabLen:                    pdfSetTabLen;
   pdfSetTemplBBox:                 pdfSetTemplBBox;
   pdfSetTextDrawMode:              pdfSetTextDrawMode;
   pdfSetTextFieldValueA:           pdfSetTextFieldValueA;
   pdfSetTextFieldValueW:           pdfSetTextFieldValueW;
   pdfSetTextFieldValueExA:         pdfSetTextFieldValueExA;
   pdfSetTextFieldValueExW:         pdfSetTextFieldValueExW;
   pdfSetTextRect:                  pdfSetTextRect;
   pdfSetTextRise:                  pdfSetTextRise;
   pdfSetTextScaling:               pdfSetTextScaling;
   pdfSetTrapped:                   pdfSetTrapped;
   pdfSetTransparentColor:          pdfSetTransparentColor;
   pdfSetUseExactPwd:               pdfSetUseExactPwd;
   pdfSetUseGlobalImpFiles:         pdfSetUseGlobalImpFiles;
   pdfSetUseImageInterpolation:     pdfSetUseImageInterpolation;
   pdfSetUseImageInterpolationEx:   pdfSetUseImageInterpolationEx;
   pdfSetUserUnit:                  pdfSetUserUnit;
   pdfSetUseStdFonts:               pdfSetUseStdFonts;
   pdfSetUseSwapFile:               pdfSetUseSwapFile;
   pdfSetUseSwapFileEx:             pdfSetUseSwapFileEx;
   pdfSetUseSystemFonts:            pdfSetUseSystemFonts;
   pdfSetUseTransparency:           pdfSetUseTransparency;
   pdfSetUseVisibleCoords:          pdfSetUseVisibleCoords;
   pdfSetViewerPreferences:         pdfSetViewerPreferences;
   pdfSetWMFDefExtent:              pdfSetWMFDefExtent;
   pdfSetWMFPixelPerInch:           pdfSetWMFPixelPerInch;
   pdfSetWordSpacing:               pdfSetWordSpacing;
   pdfSetXFAStream:                 pdfSetXFAStream;
   pdfSkewCoords:                   pdfSkewCoords;
   pdfSortFieldsByIndex:            pdfSortFieldsByIndex;
   pdfSortFieldsByName:             pdfSortFieldsByName;
   pdfSquareAnnotA:                 pdfSquareAnnotA;
   pdfSquareAnnotW:                 pdfSquareAnnotW;
   pdfStampAnnotA:                  pdfStampAnnotA;
   pdfStampAnnotW:                  pdfStampAnnotW;
   pdfStrokePath:                   pdfStrokePath;
   pdfTestGlyphsExA:                pdfTestGlyphsExA;
   pdfTestGlyphsExW:                pdfTestGlyphsExW;
   pdfTestPassword:                 pdfTestPassword;
   pdfTextAnnotA:                   pdfTextAnnotA;
   pdfTextAnnotW:                   pdfTextAnnotW;
   pdfTranslateCoords:              pdfTranslateCoords;
   pdfTriangle:                     pdfTriangle;
   pdfUnLockLayer:                  pdfUnLockLayer;
   pdfUTF16ToUTF32:                 pdfUTF16ToUTF32;
   pdfUTF16ToUTF32Ex:               pdfUTF16ToUTF32Ex;
   pdfUTF32ToUTF16:                 pdfUTF32ToUTF16;
   pdfUTF32ToUTF16Ex:               pdfUTF32ToUTF16Ex;
   pdfWatermarkAnnot:               pdfWatermarkAnnot;
   pdfWebLinkA:                     pdfWebLinkA;
   pdfWebLinkW:                     pdfWebLinkW;
   pdfWriteAngleTextA:              pdfWriteAngleTextA;
   pdfWriteAngleTextW:              pdfWriteAngleTextW;
   pdfWriteFTextA:                  pdfWriteFTextA;
   pdfWriteFTextW:                  pdfWriteFTextW;
   pdfWriteFTextExA:                pdfWriteFTextExA;
   pdfWriteFTextExW:                pdfWriteFTextExW;
   pdfWriteTextA:                   pdfWriteTextA;
   pdfWriteTextW:                   pdfWriteTextW;
   pdfWriteTextExA:                 pdfWriteTextExA;
   pdfWriteTextExW:                 pdfWriteTextExW;
   pdfWriteTextMatrixA:             pdfWriteTextMatrixA;
   pdfWriteTextMatrixW:             pdfWriteTextMatrixW;
   pdfWriteTextMatrixExA:           pdfWriteTextMatrixExA;
   pdfWriteTextMatrixExW:           pdfWriteTextMatrixExW;
   procedure LoadFunction(var Func: Pointer; const FuncName: String);
{$endif}
   function IntStrLen(Value: PAnsiChar): Integer;
end;

type TPDFContentParser = class(TObject)
  public
   constructor Create(PDFInst: TPDF; Flags: TOptimizeFlags; Parms: POptimizeParams);
   destructor  Destroy(); override;

   procedure Abort();
   function  ChangeAltFont(Handle: Cardinal): Boolean;
   procedure ClearSelection();
   function  DeleteOperator(Index: Cardinal): Boolean;
   function  DeleteOperatorInObject(ObjPtr: IPDFObj; Index: Cardinal): Boolean;
   function  DeleteText(Area: PFltRect; Flags: TDeleteTextFlags): Boolean;
   function  ExtractText(Flags: TTextExtractionFlags; Area: PFltRect; var Text: WideString): Boolean;
   function  FindText(Area: PFltRect; SearchType: TSearchType; Last: PTextSelection; const Text: WideString; var SelText: TTextSelection): Boolean;
   function  GetSelBBox(var SelText: TTextSelection; var BBox: TBBox): Boolean;
   function  GetSelBBox2(var SelText: TTextSelection; QuadPoint: PFltPoint): Boolean;
   function  GetSelText(var SelText: TTextSelection; var Text: WideString): Boolean;
   function  ParsePage(PageNum: Cardinal; Flags: TContentParseFlags; Parms: PContentParseParms; var Value: TContent): Boolean;
   function  ReplaceSelText(Flags: TReplaceTextFlags; var SelText: TTextSelection; const Text: WideString): Boolean;
  {$ifdef DELPHI6_OR_HIGHER}
   function  SetAltFont(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
   function  SetAltFont(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer; overload;
  {$endif}
   function  SetAltFontA(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function  SetAltFontW(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
   function  WriteToPage(Flags: TOptimizeFlags; Parms: POptimizeParams): Boolean;
  protected
   FInstance:                 TPDF;
   FContext:                  IPSR;
  {$ifdef DYNLNK}
   psrAbort:                  psrAbort;
   psrChangeAltFont:          psrChangeAltFont;
   psrClearSelection:         psrClearSelection;
   psrCreateParserContext:    psrCreateParserContext;
   psrDeleteOperator:         psrDeleteOperator;
   psrDeleteOperatorInObject: psrDeleteOperatorInObject;
   psrDeleteParserContext:    psrDeleteParserContext;
   psrDeleteText:             psrDeleteText;
   psrExtractText:            psrExtractText;
   psrFindText:               psrFindText;
   psrGetSelBBox:             psrGetSelBBox;
   psrGetSelBBox2:            psrGetSelBBox2;
   psrGetSelText:             psrGetSelText;
   psrParsePage:              psrParsePage;
   psrReplaceSelText:         psrReplaceSelText;
   psrSetAltFontA:            psrSetAltFontA;
   psrSetAltFontW:            psrSetAltFontW;
   psrWriteToPage:            psrWriteToPage;
  {$endif}
end;

type TPDFPageCache = class(TObject)
 public
   constructor Create(PDFInst: TPDF; PixFmt: TPDFPixFormat; HBorder, VBorder, BackColor: Cardinal; Priority: TPDFThreadPriority; APIVersion: Integer = 1); overload;
   constructor Create(PDFInst: TPDF; PixFmt: TPDFPixFormat; ScreenScale, Divider: Single; TileWidth, TileHeight: Cardinal); overload;
   destructor  Destroy(); override;
   procedure AbortInvisible(CtrlType: TPDFCtrlType; FirstVisible, LastVisible: Integer);
   procedure AbortTile(CtrlType: TPDFCtrlType; PageNum, IndexX, IndexY, Zoom: Cardinal);
   function  Append: Boolean;
   procedure CalcMaxima(FirstPage, LastPage: Integer);
   procedure ChangeBackColor(Color: Cardinal);
   procedure ChangeCursor(Value: TPDFCursor);
   procedure ClearSelection();
   procedure CloseFile();
   function  CopyToClipBoard(hWnd: HWND; SelectedObjType: TSelectObjType; Flags: Cardinal): Boolean;
   function  CreateAnnotFromControl(Author, Comment: WideString): Integer;
   function  CreateControl(Value: PPDFControl): Boolean;
   function  DeletePage(PageNum: Cardinal): Boolean;
   function  ExecBookmark(Handle: Cardinal; var NewX, NewY: Integer; var NewZoom: Single; var NewPageScale: TPDFPageScale; Action: Pointer): TUpdBmkAction;
   function  ExchangePages(First, Second: Cardinal): Boolean;
   function  GetBaseControlSize(var Value: TI32Point): Boolean;
   function  GetCurrPage(): Integer;
   function  GetCurrZoom(): Single;
   function  GetCurrTile(var Tile: TPDFTile): Boolean;
   function  GetDefPageLayout(): TPageLayout;
   function  GetObjTypeAt(X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType; overload;
   function  GetObjTypeAt(PageNum: Cardinal; X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType; overload;
   function  GetOption(Option: TPageCacheOptions; var Value: Integer): Boolean;
   function  GetPageAt(ScrollX, ScrollY: Integer; X, Y: Integer): Integer;
   function  GetPageInfo(PageNum: Cardinal; var Info: TPDFPageInfo): Boolean;
   function  GetPageLayout(): TPageLayout;
   function  GetPageMatrix(CursorX, CursorY: Integer; var DestX, DestY, Width, Height: Integer; var Matrix: TCTM): Integer;
   function  GetPagePos(PageNum: Integer; var X, Y: Integer): Boolean;
   function  GetPageScale(): TPDFPageScale;
   function  GetRasInfo(var Info: TPDFRasInfo): Boolean;
   function  GetRotate(): Integer;
   function  GetScrollLineDelta(Vertical: Boolean): Cardinal;
   function  GetScrollPos(Vertical: Boolean; PageNum: Cardinal): Integer;
   function  GetScrollRange(Vertical: Boolean; var Max, SmallChange, LargeChange: Integer): Boolean;
   function  GetSelectedText(var Size: Cardinal): PWideChar;
   function  GetSelectionMode(): TSelectObjType;
   function  GetSelectionPath(PageNum: Cardinal; var Value: TPDFObjSelPath): Boolean;
   function  GetSelRect(var Value: TIntRect): Integer;
   function  GetSelRectPDF(var Value: TBBox): Integer;
   function  InitBaseObjects(Width, Height: Integer; Flags: TInitCacheFlags): Integer;
   function  InitBaseObjectsV3(DisplayTile: TPDFDisplayTile; UserData: Pointer; Width, Height: Single; Flags: TInitCacheFlags): Integer;
   function  InitColorManagement(Profiles: PPDFColorProfiles; Flags: TPDFInitCMFlags): Boolean;
   function  HaveSelectedText(): Boolean;
   function  HaveSelection(): Boolean;
   function  HighlightText(SubType: TAnnotType; Color: Cardinal; const Author: PWideChar): Boolean;
   function  InitMaintTile(const Buffer: Pointer; Width, Height: Cardinal; Stride: Integer; PixFmt: TPDFPixFormat): Boolean;
   function  KeyStroke(Down: Boolean; CharCode, ShiftState: Cardinal): TPDFCursor;
   procedure Lock();
   function  MouseDblClick(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MouseDblClick(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MouseDown(X, Y: Integer): TPDFCursor; overload;
   function  MouseDown(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MouseDown(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MouseMove(hWnd: HWND; LeftBtnDown: Boolean; var ScrollX, ScrollY: Integer; X, Y: Integer): TUpdScrollbar; overload;
   function  MouseMove(hWnd: HWND; Keys: TPDFMouseKeys; var ScrollX, ScrollY: Integer; X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar; overload;
   function  MouseMove(Keys: TPDFMouseKeys; PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar; overload;
   function  MouseUp(X, Y: Integer): TPDFCursor; overload;
   function  MouseUp(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MouseUp(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor; overload;
   function  MovePage(Source, Dest: Cardinal): Boolean;
   function  Paint(DC: HDC; var ScrollX, ScrollY: Integer): TUpdScrollbar;
   function  PixToPDF(X, Y: Integer; var OutX, OutY: Double): Integer;
   function  ProcessErrors(): Boolean;
   procedure ResetMousePos();
   function  RenderTile(PageNum, PageW, PageH, NRows, NCols: Cardinal; var Tile: TPDFTile): Boolean;
   function  Resize(Width, Height: Integer): Boolean;
   procedure ResizeViewport(Width, Height: Single);
   function  Scroll(Vertical: Boolean; ScrollCode: Integer; var ScrollX, ScrollY: Integer): TUpdScrollbar;
   procedure SelectAll(ObjTypes: TSelectObjType);
   function  SelectAnnotOrField(Handle: Cardinal; IsField: Boolean; SelColor: Cardinal; var NewX, NewY, NewZoom: Single; var NewPageScale: TPDFPageScale): TUpdBmkAction;
   function  SelectObject(Down: Boolean; X, Y: Integer; SelColor: Cardinal; const Info: PPDFObjectInfo): TSelObjAction; overload;
   function  SelectObject(PageNum: Cardinal; Down: Boolean; X, Y: Integer; const Info: PPDFObjectInfo): TSelObjAction; overload;
   procedure SetBaseControlSize(Width, Height: Integer);
{$ifdef DELPHI6_OR_HIGHER}
   function  SetCMapDir(const Path: AnsiString; Flags: TLoadCMapFlags): Integer; overload;
   function  SetCMapDir(const Path: WideString; Flags: TLoadCMapFlags): Integer; overload;
{$endif}
   procedure SetClientRect(DC: HDC; var Value: TIntRect);
   function  SetCMapDirA(const Path: AnsiString; Flags: TLoadCMapFlags): Integer;
   function  SetCMapDirW(const Path: WideString; Flags: TLoadCMapFlags): Integer;
   procedure SetDefPageLayout(Value: TPageLayout);
   function  SetMinLineWidth(Value: Single): Boolean;
   function  SetOCGState(Handle: Cardinal; Visible, SaveState: Boolean): Boolean;
   procedure SetOnPaintCallback(const UserData: Pointer; Callback: TOnUpdateWindow);
   function  SetOption(Option: TPageCacheOptions; Value: Integer): Boolean;
   procedure SetPageLayout(Value: TPageLayout);
   procedure SetPageScale(Value: TPDFPageScale);
   procedure SetRotate(Value: Integer);
   function  SetScrollLineDelta(Vertical: Boolean; Value: Cardinal): Boolean;
   procedure SetSelectionMode(Value: TSelectObjType);
   procedure SetThreadPriority(UpdateThread, RenderThread: TPDFThreadPriority);
   procedure SetWindowHandle(hWnd: HWND);
   procedure UnLock();
   procedure Update(PageNum: Integer);
   function  Zoom(Value: Single; var HorzPos, VertPos: Integer): Boolean;
 protected
   FCache:                          IPGC;
 {$ifdef DYNLNK}
   rasAbortInvisible:               rasAbortInvisible;
   rasAbortTile:                    rasAbortTile;
   rasAppend:                       rasAppend;
   rasCalcMaxima:                   rasCalcMaxima;
   rasChangeBackColor:              rasChangeBackColor;
   rasChangeCursor:                 rasChangeCursor;
   rasClearSelection:               rasClearSelection;
   rasCloseFile:                    rasCloseFile;
   rasCopyToClipBoard:              rasCopyToClipBoard;
   rasCreateAnnotFromControl:       rasCreateAnnotFromControl;
   rasCreateControl:                rasCreateControl;
   rasCreatePageCache:              rasCreatePageCache;
   rasCreatePageCacheV3:            rasCreatePageCacheV3;
   rasDeletePage:                   rasDeletePage;
   rasDeletePageCache:              rasDeletePageCache;
   rasExecBookmark:                 rasExecBookmark;
   rasExchangePages:                rasExchangePages;
   rasGetBaseControlSize:           rasGetBaseControlSize;
   rasGetCurrPage:                  rasGetCurrPage;
   rasGetCurrTile:                  rasGetCurrTile;
   rasGetCurrZoom:                  rasGetCurrZoom;
   rasGetDefPageLayout:             rasGetDefPageLayout;
   rasGetObjTypeAt:                 rasGetObjTypeAt;
   rasGetObjTypeAtV3:               rasGetObjTypeAtV3;
   rasGetOption:                    rasGetOption;
   rasGetPageAt:                    rasGetPageAt;
   rasGetPageInfo:                  rasGetPageInfo;
   rasGetPageLayout:                rasGetPageLayout;
   rasGetPageMatrix:                rasGetPageMatrix;
   rasGetPagePos:                   rasGetPagePos;
   rasGetPageScale:                 rasGetPageScale;
   rasGetRasInfo:                   rasGetRasInfo;
   rasGetRotate:                    rasGetRotate;
   rasGetScrollLineDelta:           rasGetScrollLineDelta;
   rasGetScrollPos:                 rasGetScrollPos;
   rasGetScrollRange:               rasGetScrollRange;
   rasGetSelectedText:              rasGetSelectedText;
   rasGetSelectionMode:             rasGetSelectionMode;
   rasGetSelectionPath:             rasGetSelectionPath;
   rasGetSelRect:                   rasGetSelRect;
   rasGetSelRectPDF:                rasGetSelRectPDF;
   rasHaveSelectedText:             rasHaveSelectedText;
   rasHaveSelection:                rasHaveSelection;
   rasHighlightText:                rasHighlightText;
   rasInitBaseObjects:              rasInitBaseObjects;
   rasInitBaseObjectsV3:            rasInitBaseObjectsV3;
   rasInitColorManagement:          rasInitColorManagement;
   rasInitialize:                   rasInitialize;
   rasInitMainTile:                 rasInitMainTile;
   rasKeyStroke:                    rasKeyStroke;
   rasLock:                         rasLock;
   rasMouseDblClick:                rasMouseDblClick;
   rasMouseDblClickV3:              rasMouseDblClickV3;
   rasMouseDown:                    rasMouseDown;
   rasMouseDown2:                   rasMouseDown2;
   rasMouseDown3:                   rasMouseDown3;
   rasMouseMove:                    rasMouseMove;
   rasMouseMove2:                   rasMouseMove2;
   rasMouseMove3:                   rasMouseMove3;
   rasMouseUp:                      rasMouseUp;
   rasMouseUp2:                     rasMouseUp2;
   rasMouseUp3:                     rasMouseUp3;
   rasMovePage:                     rasMovePage;
   rasPaint:                        rasPaint;
   rasPixToPDF:                     rasPixToPDF;
   rasProcessErrors:                rasProcessErrors;
   rasRenderTile:                   rasRenderTile;
   rasResetMousePos:                rasResetMousePos;
   rasResize:                       rasResize;
   rasResizeViewport:               rasResizeViewport;
   rasScroll:                       rasScroll;
   rasSelectAll:                    rasSelectAll;
   rasSelectAnnotOrField:           rasSelectAnnotOrField;
   rasSelectObject:                 rasSelectObject;
   rasSelectObjectV3:               rasSelectObjectV3;
   rasSetBaseControlSize:           rasSetBaseControlSize;
   rasSetClientRect:                rasSetClientRect;
   rasSetCMapDirA:                  rasSetCMapDirA;
   rasSetCMapDirW:                  rasSetCMapDirW;
   rasSetDefPageLayout:             rasSetDefPageLayout;
   rasSetMinLineWidth:              rasSetMinLineWidth;
   rasSetOCGState:                  rasSetOCGState;
   rasSetOnPaintCallback:           rasSetOnPaintCallback;
   rasSetOption:                    rasSetOption;
   rasSetPageLayout:                rasSetPageLayout;
   rasSetPageScale:                 rasSetPageScale;
   rasSetRotate:                    rasSetRotate;
   rasSetScrollLineDelta:           rasSetScrollLineDelta;
   rasSetSelectionMode:             rasSetSelectionMode;
   rasSetThreadPriority:            rasSetThreadPriority;
   rasSetWindowHandle:              rasSetWindowHandle;
   rasUnLock:                       rasUnLock;
   rasUpdate:                       rasUpdate;
   rasZoom:                         rasZoom;
   procedure LoadAPI(PDFInst: TPDF; Version: Integer);
 {$endif}
end;

type TPDFTable = class(TObject)
 public
   constructor Create(PDFInst: TPDF; AllocRows, NumCols: Cardinal; Width, DefRowHeight: Single); overload;
   destructor  Destroy(); override;
   function  AddColumn(Left: Boolean; Width: Single): Integer;
   function  AddRow(Height: Single): Integer;
   function  AddRows(Count: Cardinal; Height: Single): Integer;
   procedure ClearColumn(Col: Cardinal; Types: TDeleteContent);
   procedure ClearContent(Types: TDeleteContent);
   procedure ClearRow(Row: Cardinal; Types: TDeleteContent);
   procedure DeleteCol(Col: Cardinal);
   procedure DeleteRow(Row: Cardinal);
   procedure DeleteRows();
   function  DrawTable(x, y, MaxHeight: Single): Single;
   function  GetFirstRow(): Integer;
   function  GetFlags(Row, Col: Integer): Integer;
   function  GetNextHeight(MaxHeight: Single; NextRow: PInteger): Single;
   function  GetNextRow(): Integer;
   function  GetNumCols(): Integer;
   function  GetNumRows(): Integer;
   function  GetTableHeight(): Single;
   function  GetTableWidth(): Single;
   function  HaveMore(): Boolean;
   function  SetBoxProperty(Row, Col: Integer; PropType: TTableBoxProperty; Left, Right, Top, Bottom: Single): Boolean;
   function  SetCellAction(Row, Col: Integer; ActionHandle: Cardinal; Mode: THighlightMode): Boolean;
   function  SetCellDashPattern(Row, Col: Integer; Side: TCellSide; Style: TLineCapStyle; const Dash: Array of Single; NumValues: Cardinal; Phase: Single): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function  SetCellImage(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: AnsiString; Index: Cardinal): Boolean; overload;
   function  SetCellImage(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: WideString; Index: Cardinal): Boolean; overload;
{$endif}
   function  SetCellImageA(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: AnsiString; Index: Cardinal): Boolean;
   function  SetCellImageW(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: WideString; Index: Cardinal): Boolean;
   function  SetCellImageEx(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Buffer: Pointer; BufSize, Index: Cardinal): Boolean;
   function  SetCellOrientation(Row, Col, Orientation: Integer): Boolean;
   function  SetCellTable(Row, Col: Cardinal; HAlign, VAlign: TCellAlign; const SubTable: TPDFTable): Boolean;
   function  SetCellTemplate(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; TmplHandle: Cardinal; Width, Height: Single): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function  SetCellText(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: AnsiString): Boolean; overload;
   function  SetCellText(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: WideString): Boolean; overload;
{$endif}
   function  SetCellTextA(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: AnsiString): Boolean;
   function  SetCellTextW(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: WideString): Boolean;
   function  SetColor(Row, Col: Integer; ClrType: TTableColor; CS: TPDFColorSpace; Color: Cardinal): Boolean;
   function  SetColorEx(Row, Col: Integer; ClrType: TTableColor; Color: PSingle; NumComps: Cardinal; CS: TExtColorSpace; Handle: Integer): Boolean;
   function  SetColWidth(Col: Cardinal; Width: Single; ExtTable: Boolean): Boolean;
   function  SetFlags(Row, Col: Integer; Flags: TTableFlags): Boolean;
{$ifdef DELPHI6_OR_HIGHER}
   function  SetFont(Row, Col: Integer; const Name: AnsiString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean; overload;
   function  SetFont(Row, Col: Integer; const Name: WideString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean; overload;
{$endif}
   function  SetFontA(Row, Col: Integer; const Name: AnsiString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
   function  SetFontW(Row, Col: Integer; const Name: WideString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
   function  SetFontSelMode(Row, Col: Integer; Mode: TFontSelMode): Boolean;
   function  SetFontSize(Row, Col: Integer; Value: Single): Boolean;
   function  SetGridWidth(Horz, Vert: Single): Boolean;
   function  SetRowHeight(Row: Integer; Value: Single): Boolean;
   procedure SetTableWidth(Value: Single; AdjustType: TColumnAdjust; MinColWidth: Single);
 protected
   m_Table:                         ITBL;
 {$ifdef DYNLNK}
   tblAddColumn:                    tblAddColumn;
   tblAddRow:                       tblAddRow;
   tblAddRows:                      tblAddRows;
   tblClearColumn:                  tblClearColumn;
   tblClearContent:                 tblClearContent;
   tblClearRow:                     tblClearRow;
   tblCreateTable:                  tblCreateTable;
   tblDeleteCol:                    tblDeleteCol;
   tblDeleteRow:                    tblDeleteRow;
   tblDeleteRows:                   tblDeleteRows;
   tblDeleteTable:                  tblDeleteTable;
   tblDrawTable:                    tblDrawTable;
   tblGetFirstRow:                  tblGetFirstRow;
   tblGetFlags:                     tblGetFlags;
   tblGetNextHeight:                tblGetNextHeight;
   tblGetNextRow:                   tblGetNextRow;
   tblGetNumCols:                   tblGetNumCols;
   tblGetNumRows:                   tblGetNumRows;
   tblGetTableHeight:               tblGetTableHeight;
   tblGetTableWidth:                tblGetTableWidth;
   tblHaveMore:                     tblHaveMore;
   tblSetBoxProperty:               tblSetBoxProperty;
   tblSetCellAction:                tblSetCellAction;
   tblSetCellDashPattern:           tblSetCellDashPattern;
   tblSetCellImageA:                tblSetCellImageA;
   tblSetCellImageW:                tblSetCellImageW;
   tblSetCellImageEx:               tblSetCellImageEx;
   tblSetCellOrientation:           tblSetCellOrientation;
   tblSetCellTable:                 tblSetCellTable;
   tblSetCellTemplate:              tblSetCellTemplate;
   tblSetCellTextA:                 tblSetCellTextA;
   tblSetCellTextW:                 tblSetCellTextW;
   tblSetColor:                     tblSetColor;
   tblSetColorEx:                   tblSetColorEx;
   tblSetColWidth:                  tblSetColWidth;
   tblSetFlags:                     tblSetFlags;
   tblSetFontA:                     tblSetFontA;
   tblSetFontW:                     tblSetFontW;
   tblSetFontSelMode:               tblSetFontSelMode;
   tblSetFontSize:                  tblSetFontSize;
   tblSetGridWidth:                 tblSetGridWidth;
   tblSetRowHeight:                 tblSetRowHeight;
   tblSetTableWidth:                tblSetTableWidth;
 {$endif}
   function GetInstancePtr(): ITBL;
end;

implementation

uses SysUtils;
   
{$ifdef POSIX}
function MakeWord(A, B: Byte): Word; inline;
begin
  Result := A or B shl 8;
end;
{$ENDIF POSIX}

function IsNum(const C: AnsiChar): Boolean;
begin
   Result := (Ord(C) - Ord('0') < 10) and (Ord(C) - Ord('0') > -1);
end;

{$ifdef DYNLNK}
procedure LoadFunction(LibHandle: HMODULE; var Func: Pointer; const FuncName: String);
begin
   {$ifdef DELPHI_UNICODE}
      Func := GetProcAddress(LibHandle, PWideChar(FuncName));
   {$else}
      Func := GetProcAddress(LibHandle, PAnsiChar(FuncName));
   {$endif}
end;
{$endif}

function ParseInt(const S: AnsiString; Pos: Integer; var Value: Integer): Integer;
var c: AnsiChar; isNegative: Boolean; p: Integer;
begin
   p      := Pos;
   Result := 0;
   Value  := 0;
   if Pos > Length(S) then Exit;
   isNegative := false;
   case S[Pos] of
      '-': begin
         isNegative := true;
         Inc(Pos);
      end;
      '+': Inc(Pos);
   end;
   while Pos <= Length(S) do begin
      c := S[Pos];
      if not IsNum(c) then break;
      Value := Value * 10 + Ord(c) - Ord('0');
      Inc(Pos);
   end;
   if isNegative then Value := -Value;
   Result := Pos - p;
end;


{ TPDFContentParser }

procedure TPDFContentParser.Abort;
begin
   psrAbort(FContext);
end;

function TPDFContentParser.ChangeAltFont(Handle: Cardinal): Boolean;
begin
   Result := psrChangeAltFont(FInstance, FContext, Handle);
end;

procedure TPDFContentParser.ClearSelection;
begin
   psrClearSelection(FInstance);
end;

constructor TPDFContentParser.Create(PDFInst: TPDF; Flags: TOptimizeFlags; Parms: POptimizeParams);
{$ifdef DYNLNK}
var libHandle: HMODULE;
{$endif}
begin
  {$ifdef DYNLNK}
   libHandle := PDFInst.GetLibHandle();
   LoadFunction(libHandle, @psrAbort,                    'psrAbort');
   LoadFunction(libHandle, @psrChangeAltFont,            'psrChangeAltFont');
   LoadFunction(libHandle, @psrClearSelection,           'psrClearSelection');
   LoadFunction(libHandle, @psrCreateParserContext,      'psrCreateParserContext');
   LoadFunction(libHandle, @psrDeleteOperator,           'psrDeleteOperator');
   LoadFunction(libHandle, @psrDeleteOperatorInObject,   'psrDeleteOperatorInObject');
   LoadFunction(libHandle, @psrDeleteParserContext,      'psrDeleteParserContext');
   LoadFunction(libHandle, @psrDeleteText,               'psrDeleteText');
   LoadFunction(libHandle, @psrExtractText,              'psrExtractText');
   LoadFunction(libHandle, @psrFindText,                 'psrFindText');
   LoadFunction(libHandle, @psrGetSelBBox,               'psrGetSelBBox');
   LoadFunction(libHandle, @psrGetSelBBox2,              'psrGetSelBBox2');
   LoadFunction(libHandle, @psrGetSelText,               'psrGetSelText');
   LoadFunction(libHandle, @psrParsePage,                'psrParsePage');
   LoadFunction(libHandle, @psrReplaceSelText,           'psrReplaceSelText');
   LoadFunction(libHandle, @psrSetAltFontA,              'psrSetAltFontA');
   LoadFunction(libHandle, @psrSetAltFontW,              'psrSetAltFontW');
   LoadFunction(libHandle, @psrWriteToPage,              'psrWriteToPage');
   if @psrWriteToPage = nil then raise Exception.Create('Failed to load the parser API! Check the DynaPDF version!');
  {$endif}
   FInstance := PDFInst.PDFInstance;
   FContext  := psrCreateParserContext(FInstance, Flags, Parms);
end;

function TPDFContentParser.DeleteOperator(Index: Cardinal): Boolean;
begin
   Result := psrDeleteOperator(FContext, Index);
end;

function TPDFContentParser.DeleteOperatorInObject(ObjPtr: IPDFObj; Index: Cardinal): Boolean;
begin
   Result := psrDeleteOperatorInObject(FContext, ObjPtr, Index);
end;

function TPDFContentParser.DeleteText(Area: PFltRect; Flags: TDeleteTextFlags): Boolean;
begin
   Result := psrDeleteText(FInstance, FContext, Area, Flags);
end;

destructor TPDFContentParser.Destroy;
begin
  psrDeleteParserContext(FContext);
  inherited;
end;

function TPDFContentParser.ExtractText(Flags: TTextExtractionFlags; Area: PFltRect; var Text: WideString): Boolean;
var txt: PWideChar; len: Cardinal; 
begin
   txt  := nil;
   len  := 0;
   Text := '';
   Result := psrExtractText(FInstance, FContext, Flags, Area, txt, len);
   if Result then begin
      SetLength(Text, len);
      Move(txt^, Text[1], len * 2);
   end;
end;

function TPDFContentParser.FindText(Area: PFltRect; SearchType: TSearchType; Last: PTextSelection; const Text: WideString; var SelText: TTextSelection): Boolean;
begin
   Result := psrFindText(FInstance, FContext, Area, SearchType, Last, PWideChar(Text), Length(Text), SelText);
end;

function TPDFContentParser.GetSelBBox(var SelText: TTextSelection; var BBox: TBBox): Boolean;
begin
   Result := psrGetSelBBox(FInstance, FContext, SelText, BBox);
end;

function TPDFContentParser.GetSelBBox2(var SelText: TTextSelection; QuadPoint: PFltPoint): Boolean;
begin
   Result := psrGetSelBBox2(FInstance, SelText, QuadPoint);
end;

function TPDFContentParser.GetSelText(var SelText: TTextSelection; var Text: WideString): Boolean;
var len: Integer; txt: PWideChar;
begin
   Text := '';
   txt  := nil;
   len  := 0;
   Result := psrGetSelText(FInstance, SelText, txt, len);
   if Result and (len > 0) then begin
      SetLength(Text, len);
      Move(txt^, Text[1], len * 2);
   end;
end;

function TPDFContentParser.ParsePage(PageNum: Cardinal; Flags: TContentParseFlags; Parms: PContentParseParms; var Value: TContent): Boolean;
begin
   Result := psrParsePage(FInstance, FContext, nil, nil, PageNum, Flags, Parms, Value);
end;

function TPDFContentParser.ReplaceSelText(Flags: TReplaceTextFlags; var SelText: TTextSelection; const Text: WideString): Boolean;
begin
   Result := psrReplaceSelText(FInstance, FContext, Flags, SelText, PWideChar(Text), Length(Text));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDFContentParser.SetAltFont(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
begin
   Result := psrSetAltFontA(FInstance, FContext, PAnsiChar(Name), Style, Size, Embed, CP);
end;

function TPDFContentParser.SetAltFont(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
begin
   Result := psrSetAltFontW(FInstance, FContext, PWideChar(Name), Style, Size, Embed, CP);
end;
{$endif}

function TPDFContentParser.SetAltFontA(const Name: AnsiString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
begin
   Result := psrSetAltFontA(FInstance, FContext, PAnsiChar(Name), Style, Size, Embed, CP);
end;

function TPDFContentParser.SetAltFontW(const Name: WideString; Style: TFStyle; Size: Double; Embed: Boolean; CP: TCodepage): Integer;
begin
   Result := psrSetAltFontW(FInstance, FContext, PWideChar(Name), Style, Size, Embed, CP);
end;

function TPDFContentParser.WriteToPage(Flags: TOptimizeFlags; Parms: POptimizeParams): Boolean;
begin
   Result := psrWriteToPage(FInstance, FContext, Flags, Parms);
end;

{ TPDFPageCache }

constructor TPDFPageCache.Create(PDFInst: TPDF; PixFmt: TPDFPixFormat; HBorder, VBorder, BackColor: Cardinal; Priority: TPDFThreadPriority; APIVersion: Integer);
var pixelFmt: Integer;
const V2_API = $1000;
begin
 {$ifdef DYNLNK}
   LoadAPI(PDFInst, APIVersion);
 {$endif}
   pixelFmt := Ord(PixFmt); 
   if APIVersion = 2 then pixelFmt := pixelFmt Or V2_API;

   FCache := rasCreatePageCache(PDFInst.PDFInstance, pixelFmt, HBorder, VBorder, BackColor);
   if FCache = nil then raise Exception.Create('Cannot create page cache instance!');
   if not rasInitialize(FCache, Priority) then raise Exception.Create('Out of memory!');
end;

constructor TPDFPageCache.Create(PDFInst: TPDF; PixFmt: TPDFPixFormat; ScreenScale, Divider: Single; TileWidth, TileHeight: Cardinal);
begin
 {$ifdef DYNLNK}
   LoadAPI(PDFInst, 3);
 {$endif}
   FCache := rasCreatePageCacheV3(PDFInst.PDFInstance, PixFmt, ScreenScale, Divider, TileWidth, TileHeight);
   if FCache = nil then raise Exception.Create('Cannot create page cache instance!');
   if not rasInitialize(FCache, ttpLowest) then raise Exception.Create('Out of memory!');
end;

function TPDFPageCache.CreateAnnotFromControl(Author, Comment: WideString): Integer;
begin
   Result := rasCreateAnnotFromControl(FCache, PWideChar(Author), PWideChar(Comment));
end;

function TPDFPageCache.DeletePage(PageNum: Cardinal): Boolean;
begin
   Result := rasDeletePage(FCache, PageNum);
end;

destructor TPDFPageCache.Destroy;
begin
   if FCache <> nil then rasDeletePageCache(FCache);
   inherited;
end;

procedure TPDFPageCache.AbortInvisible(CtrlType: TPDFCtrlType; FirstVisible, LastVisible: Integer);
begin
   rasAbortInvisible(FCache, CtrlType, FirstVisible, LastVisible);
end;

procedure TPDFPageCache.AbortTile(CtrlType: TPDFCtrlType; PageNum, IndexX, IndexY, Zoom: Cardinal);
begin
   rasAbortTile(FCache, CtrlType, PageNum, IndexX, IndexY, Zoom);
end;

function TPDFPageCache.Append: Boolean;
begin
   Result := rasAppend(FCache);
end;

procedure TPDFPageCache.CalcMaxima(FirstPage, LastPage: Integer);
begin
   rasCalcMaxima(FCache, FirstPage, LastPage);
end;

procedure TPDFPageCache.ChangeBackColor(Color: Cardinal);
begin
   rasChangeBackColor(FCache, Color);
end;

procedure TPDFPageCache.ChangeCursor(Value: TPDFCursor);
begin
   rasChangeCursor(FCache, Value);
end;

procedure TPDFPageCache.ClearSelection;
begin
   rasClearSelection(FCache);
end;

procedure TPDFPageCache.CloseFile();
begin
   rasCloseFile(FCache);
end;

function TPDFPageCache.CopyToClipBoard(hWnd: HWND; SelectedObjType: TSelectObjType; Flags: Cardinal): Boolean;
begin
   Result := rasCopyToClipBoard(FCache, hWnd, SelectedObjType, Flags);
end;

function TPDFPageCache.CreateControl(Value: PPDFControl): Boolean;
begin
   Result := rasCreateControl(FCache, Value);
end;

function TPDFPageCache.ExchangePages(First, Second: Cardinal): Boolean;
begin
   Result := rasExchangePages(FCache, First, Second);
end;

function TPDFPageCache.ExecBookmark(Handle: Cardinal; var NewX, NewY: Integer; var NewZoom: Single; var NewPageScale: TPDFPageScale; Action: Pointer): TUpdBmkAction;
begin
   Result := rasExecBookmark(FCache, Handle, NewX, NewY, NewZoom, NewPageScale, Action);
end;

function TPDFPageCache.GetBaseControlSize(var Value: TI32Point): Boolean;
begin
   Result := rasGetBaseControlSize(FCache, Value);
end;

function TPDFPageCache.GetCurrPage: Integer;
begin
   Result := rasGetCurrPage(FCache);
end;

function TPDFPageCache.GetCurrTile(var Tile: TPDFTile): Boolean;
begin
   Result := rasGetCurrTile(FCache, Tile);
end;

function TPDFPageCache.GetCurrZoom: Single;
begin
   Result := rasGetCurrZoom(FCache);
end;

function TPDFPageCache.GetDefPageLayout: TPageLayout;
begin
   Result := rasGetDefPageLayout(FCache);
end;

function TPDFPageCache.GetObjTypeAt(X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType;
begin
   Result := rasGetObjTypeAt(FCache, X, Y, Info);
end;

function TPDFPageCache.GetObjTypeAt(PageNum: Cardinal; X, Y: Integer; var Info: TPDFObjectInfo): TSelectObjType;
begin
   Result := rasGetObjTypeAtV3(FCache, PageNum, X, Y, Info);
end;

function TPDFPageCache.GetOption(Option: TPageCacheOptions; var Value: Integer): Boolean;
begin
   Result := rasGetOption(FCache, Option, Value);
end;

function TPDFPageCache.GetPageAt(ScrollX, ScrollY, X, Y: Integer): Integer;
begin
   Result := rasGetPageAt(FCache, ScrollX, ScrollY, X, Y);
end;

function TPDFPageCache.GetPageInfo(PageNum: Cardinal; var Info: TPDFPageInfo): Boolean;
begin
   Result := rasGetPageInfo(FCache, PageNum, Info);
end;

function TPDFPageCache.GetPageLayout: TPageLayout;
begin
   Result := rasGetPageLayout(FCache);
end;

// Min version 4.0.17.44 or 40170044
function TPDFPageCache.GetPageMatrix(CursorX, CursorY: Integer; var DestX, DestY, Width, Height: Integer; var Matrix: TCTM): Integer;
begin
   Result := rasGetPageMatrix(FCache, CursorX, CursorY, DestX, DestY, Width, Height, Matrix);
end;

// Min version 4.0.81.234 or 4081234
function TPDFPageCache.GetPagePos(PageNum: Integer; var X, Y: Integer): Boolean;
begin
   Result := rasGetPagePos(FCache, PageNum, X, Y);
end;

function TPDFPageCache.GetPageScale: TPDFPageScale;
begin
   Result := rasGetPageScale(FCache);
end;

function TPDFPageCache.GetRasInfo(var Info: TPDFRasInfo): Boolean;
begin
   Result := rasGetRasInfo(FCache, Info);
end;

function TPDFPageCache.GetRotate: Integer;
begin
   Result := rasGetRotate(FCache);
end;

function TPDFPageCache.GetScrollLineDelta(Vertical: Boolean): Cardinal;
begin
   Result := rasGetScrollLineDelta(FCache, Vertical);
end;

function TPDFPageCache.GetScrollPos(Vertical: Boolean; PageNum: Cardinal): Integer;
begin
   Result := rasGetScrollPos(FCache, Vertical, PageNum);
end;

function TPDFPageCache.GetScrollRange(Vertical: Boolean; var Max, SmallChange, LargeChange: Integer): Boolean;
begin
   Result := rasGetScrollRange(FCache, Vertical, Max, SmallChange, LargeChange);
end;

function TPDFPageCache.GetSelectedText(var Size: Cardinal): PWideChar;
begin
   Result := rasGetSelectedText(FCache, Size);
end;

function TPDFPageCache.GetSelectionMode: TSelectObjType;
begin
   Result := rasGetSelectionMode(FCache);
end;

function TPDFPageCache.GetSelectionPath(PageNum: Cardinal; var Value: TPDFObjSelPath): Boolean;
begin
   Result := rasGetSelectionPath(FCache, PageNum, Value);
end;

function TPDFPageCache.GetSelRect(var Value: TIntRect): Integer;
begin
   Result := rasGetSelRect(FCache, Value);
end;

function TPDFPageCache.GetSelRectPDF(var Value: TBBox): Integer;
begin
   Result := rasGetSelRectPDF(FCache, Value);
end;

function TPDFPageCache.HaveSelectedText: Boolean;
begin
   Result := rasHaveSelectedText(FCache);
end;

function TPDFPageCache.HighlightText(SubType: TAnnotType; Color: Cardinal; const Author: PWideChar): Boolean;
begin
   Result := rasHighlightText(FCache, SubType, Color, Author);
end;

function TPDFPageCache.HaveSelection: Boolean;
begin
   Result := rasHaveSelection(FCache);
end;

function TPDFPageCache.InitBaseObjects(Width, Height: Integer; Flags: TInitCacheFlags): Integer;
begin
   Result := rasInitBaseObjects(FCache, Width, Height, Flags);
end;

function TPDFPageCache.InitBaseObjectsV3(DisplayTile: TPDFDisplayTile; UserData: Pointer; Width, Height: Single; Flags: TInitCacheFlags): Integer;
begin
   Result := rasInitBaseObjectsV3(FCache, DisplayTile, UserData, Width, Height, Flags);
end;

function TPDFPageCache.InitColorManagement(Profiles: PPDFColorProfiles; Flags: TPDFInitCMFlags): Boolean;
begin
   Result := rasInitColorManagement(FCache, Profiles, Flags);
end;

function TPDFPageCache.InitMaintTile(const Buffer: Pointer; Width, Height: Cardinal; Stride: Integer; PixFmt: TPDFPixFormat): Boolean;
begin
   Result := rasInitMainTile(FCache, Buffer, Width, Height, Stride, PixFmt);
end;

function TPDFPageCache.KeyStroke(Down: Boolean; CharCode, ShiftState: Cardinal): TPDFCursor;
begin
   Result := rasKeyStroke(FCache, Down, CharCode, ShiftState);
end;

{$ifdef DYNLNK}
procedure TPDFPageCache.LoadAPI(PDFInst: TPDF; Version: Integer);
var libHandle: HMODULE;
begin
   libHandle                  := PDFInst.GetLibHandle();
   // V1
   rasChangeBackColor         := GetProcAddress(libHandle, 'rasChangeBackColor');
   rasChangeCursor            := GetProcAddress(libHandle, 'rasChangeCursor');
   rasCloseFile               := GetProcAddress(libHandle, 'rasCloseFile');
   rasCreatePageCache         := GetProcAddress(libHandle, 'rasCreatePageCache');
   rasDeletePageCache         := GetProcAddress(libHandle, 'rasDeletePageCache');
   rasExecBookmark            := GetProcAddress(libHandle, 'rasExecBookmark');
   rasGetCurrPage             := GetProcAddress(libHandle, 'rasGetCurrPage');
   rasGetCurrTile             := GetProcAddress(libHandle, 'rasGetCurrTile');
   rasGetCurrZoom             := GetProcAddress(libHandle, 'rasGetCurrZoom');
   rasGetDefPageLayout        := GetProcAddress(libHandle, 'rasGetDefPageLayout');
   rasGetPageAt               := GetProcAddress(libHandle, 'rasGetPageAt');
   rasGetPageLayout           := GetProcAddress(libHandle, 'rasGetPageLayout');
   rasGetPageMatrix           := GetProcAddress(libHandle, 'rasGetPageMatrix');
   rasGetPageScale            := GetProcAddress(libHandle, 'rasGetPageScale');
   rasGetRotate               := GetProcAddress(libHandle, 'rasGetRotate');
   rasGetScrollLineDelta      := GetProcAddress(libHandle, 'rasGetScrollLineDelta');
   rasGetScrollPos            := GetProcAddress(libHandle, 'rasGetScrollPos');
   rasGetScrollRange          := GetProcAddress(libHandle, 'rasGetScrollRange');
   rasInitBaseObjects         := GetProcAddress(libHandle, 'rasInitBaseObjects');
   rasInitColorManagement     := GetProcAddress(libHandle, 'rasInitColorManagement');
   rasInitialize              := GetProcAddress(libHandle, 'rasInitialize');
   rasMouseDown               := GetProcAddress(libHandle, 'rasMouseDown');
   rasMouseMove               := GetProcAddress(libHandle, 'rasMouseMove');
   rasMouseUp                 := GetProcAddress(libHandle, 'rasMouseUp');
   rasPaint                   := GetProcAddress(libHandle, 'rasPaint');
   rasProcessErrors           := GetProcAddress(libHandle, 'rasProcessErrors');
   rasResetMousePos           := GetProcAddress(libHandle, 'rasResetMousePos');
   rasResize                  := GetProcAddress(libHandle, 'rasResize');
   rasScroll                  := GetProcAddress(libHandle, 'rasScroll');
   rasSetCMapDirA             := GetProcAddress(libHandle, 'rasSetCMapDirA');
   rasSetCMapDirW             := GetProcAddress(libHandle, 'rasSetCMapDirW');
   rasSetDefPageLayout        := GetProcAddress(libHandle, 'rasSetDefPageLayout');
   rasSetMinLineWidth         := GetProcAddress(libHandle, 'rasSetMinLineWidth');
   rasSetOCGState             := GetProcAddress(libHandle, 'rasSetOCGState');
   rasSetOnPaintCallback      := GetProcAddress(libHandle, 'rasSetOnPaintCallback');
   rasSetPageLayout           := GetProcAddress(libHandle, 'rasSetPageLayout');
   rasSetPageScale            := GetProcAddress(libHandle, 'rasSetPageScale');
   rasSetRotate               := GetProcAddress(libHandle, 'rasSetRotate');
   rasSetScrollLineDelta      := GetProcAddress(libHandle, 'rasSetScrollLineDelta');
   rasSetThreadPriority       := GetProcAddress(libHandle, 'rasSetThreadPriority');
   rasZoom                    := GetProcAddress(libHandle, 'rasZoom');

   if Version > 1 then begin // V2
      rasClearSelection          := GetProcAddress(libHandle, 'rasClearSelection');
      rasCopyToClipBoard         := GetProcAddress(libHandle, 'rasCopyToClipBoard');
      rasCreateAnnotFromControl  := GetProcAddress(libHandle, 'rasCreateAnnotFromControl');
      rasCreateControl           := GetProcAddress(libHandle, 'rasCreateControl');
      rasGetObjTypeAt            := GetProcAddress(libHandle, 'rasGetObjTypeAt');
      rasGetOption               := GetProcAddress(libHandle, 'rasGetOption');
      rasGetPagePos              := GetProcAddress(libHandle, 'rasGetPagePos');
      rasGetSelectionMode        := GetProcAddress(libHandle, 'rasGetSelectionMode');
      rasGetSelRect              := GetProcAddress(libHandle, 'rasGetSelRect');
      rasGetSelRectPDF           := GetProcAddress(libHandle, 'rasGetSelRectPDF');
      rasHaveSelectedText        := GetProcAddress(libHandle, 'rasHaveSelectedText');
      rasHighlightText           := GetProcAddress(libHandle, 'rasHighlightText');
      rasKeyStroke               := GetProcAddress(libHandle, 'rasKeyStroke');
      rasLock                    := GetProcAddress(libHandle, 'rasLock');
      rasMouseDblClick           := GetProcAddress(libHandle, 'rasMouseDblClick');
      rasMouseDown2              := GetProcAddress(libHandle, 'rasMouseDown2');
      rasMouseMove2              := GetProcAddress(libHandle, 'rasMouseMove2');
      rasMouseUp2                := GetProcAddress(libHandle, 'rasMouseUp2');
      rasPixToPDF                := GetProcAddress(libHandle, 'rasPixToPDF');
      rasSelectAll               := GetProcAddress(libHandle, 'rasSelectAll');
      rasSelectAnnotOrField      := GetProcAddress(libHandle, 'rasSelectAnnotOrField');
      rasSelectObject            := GetProcAddress(libHandle, 'rasSelectObject');
      rasSetClientRect           := GetProcAddress(libHandle, 'rasSetClientRect');
      rasSetOption               := GetProcAddress(libHandle, 'rasSetOption');
      rasSetSelectionMode        := GetProcAddress(libHandle, 'rasSetSelectionMode');
      rasSetWindowHandle         := GetProcAddress(libHandle, 'rasSetWindowHandle');
      rasUnLock                  := GetProcAddress(libHandle, 'rasUnLock');
      rasUpdate                  := GetProcAddress(libHandle, 'rasUpdate');
      if @rasClearSelection = nil then rasCreatePageCache := nil;
   end;

   if Version > 2 then begin // V3
      rasAbortInvisible          := GetProcAddress(libHandle, 'rasAbortInvisible');
      rasAbortTile               := GetProcAddress(libHandle, 'rasAbortTile');
      rasAppend                  := GetProcAddress(libHandle, 'rasAppend');
      rasCalcMaxima              := GetProcAddress(libHandle, 'rasCalcMaxima');
      rasCreatePageCacheV3       := GetProcAddress(libHandle, 'rasCreatePageCacheV3');
      rasDeletePage              := GetProcAddress(libHandle, 'rasDeletePage');
      rasExchangePages           := GetProcAddress(libHandle, 'rasExchangePages');
      rasGetBaseControlSize      := GetProcAddress(libHandle, 'rasGetBaseControlSize');
      rasGetObjTypeAtV3          := GetProcAddress(libHandle, 'rasGetObjTypeAtV3');
      rasGetSelectedText         := GetProcAddress(libHandle, 'rasGetSelectedText');
      rasGetSelectionPath        := GetProcAddress(libHandle, 'rasGetSelectionPath');
      rasGetPageInfo             := GetProcAddress(libHandle, 'rasGetPageInfo');
      rasGetRasInfo              := GetProcAddress(libHandle, 'rasGetRasInfo');
      rasHaveSelection           := GetProcAddress(libHandle, 'rasHaveSelection');
      rasInitBaseObjectsV3       := GetProcAddress(libHandle, 'rasInitBaseObjectsV3');
      rasInitMainTile            := GetProcAddress(libHandle, 'rasInitMainTile');
      rasMouseDblClickV3         := GetProcAddress(libHandle, 'rasMouseDblClickV3');
      rasMouseDown3              := GetProcAddress(libHandle, 'rasMouseDown3');
      rasMouseMove3              := GetProcAddress(libHandle, 'rasMouseMove3');
      rasMouseUp3                := GetProcAddress(libHandle, 'rasMouseUp3');
      rasMovePage                := GetProcAddress(libHandle, 'rasMovePage');
      rasRenderTile              := GetProcAddress(libHandle, 'rasRenderTile');
      rasResizeViewport          := GetProcAddress(libHandle, 'rasResizeViewport');
      rasSelectObjectV3          := GetProcAddress(libHandle, 'rasSelectObjectV3');
      rasSetBaseControlSize      := GetProcAddress(libHandle, 'rasSetBaseControlSize');
      if @rasAbortTile = nil then rasCreatePageCache := nil;
   end;
   
   if @rasCreatePageCache = nil then raise Exception.Create('Failed to load the Page Cache API! Check the DynaPDF version!');
end;
{$endif}

procedure TPDFPageCache.Lock;
begin
   rasLock(FCache);
end;

function TPDFPageCache.MouseDblClick(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseDblClick(FCache, X, Y, Info);
end;

function TPDFPageCache.MouseDblClick(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseDblClickV3(FCache, PageNum, X, Y, Info);
end;

function TPDFPageCache.MouseDown(X, Y: Integer): TPDFCursor;
begin
   Result := rasMouseDown(FCache, X, Y);
end;

function TPDFPageCache.MouseDown(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseDown2(FCache, X, Y, Info);
end;

function TPDFPageCache.MouseDown(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseDown3(FCache, PageNum, X, Y, Info);
end;

function TPDFPageCache.MouseMove(hWnd: HWND; LeftBtnDown: Boolean; var ScrollX, ScrollY: Integer; X, Y: Integer): TUpdScrollbar;
begin
   Result := rasMouseMove(FCache, hWnd, LeftBtnDown, ScrollX, ScrollY, X, Y);
end;

function TPDFPageCache.MouseMove(hWnd: HWND; Keys: TPDFMouseKeys; var ScrollX, ScrollY: Integer; X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar;
begin
   Result := rasMouseMove2(FCache, hWnd, Keys, ScrollX, ScrollY, X, Y, Info);
end;

function TPDFPageCache.MouseMove(Keys: TPDFMouseKeys; PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TUpdScrollbar;
begin
   Result := rasMouseMove3(FCache, Keys, PageNum, X, Y, Info);
end;

function TPDFPageCache.MouseUp(X, Y: Integer): TPDFCursor;
begin
   Result := rasMouseUp(FCache, X, Y);
end;

function TPDFPageCache.MouseUp(X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseUp2(FCache, X, Y, Info);
end;

function TPDFPageCache.MouseUp(PageNum, X, Y: Integer; var Info: TPDFObjectInfo): TPDFCursor;
begin
   Result := rasMouseUp3(FCache, PageNum, X, Y, Info);
end;

function TPDFPageCache.MovePage(Source, Dest: Cardinal): Boolean;
begin
   Result := rasMovePage(FCache, Source, Dest);
end;

function TPDFPageCache.Paint(DC: HDC; var ScrollX, ScrollY: Integer): TUpdScrollbar;
begin
   Result := rasPaint(FCache, DC, ScrollX, ScrollY);
end;

function TPDFPageCache.PixToPDF(X, Y: Integer; var OutX, OutY: Double): Integer;
begin
   Result := rasPixToPDF(FCache, X, Y, OutX, OutY);
end;

function TPDFPageCache.ProcessErrors: Boolean;
begin
   Result := rasProcessErrors(FCache);
end;

function TPDFPageCache.RenderTile(PageNum, PageW, PageH, NRows, NCols: Cardinal; var Tile: TPDFTile): Boolean;
begin
   Result := rasRenderTile(FCache, PageNum, PageW, PageH, NRows, NCols, Tile);
end;

procedure TPDFPageCache.ResetMousePos;
begin
   rasResetMousePos(FCache);
end;

function TPDFPageCache.Resize(Width, Height: Integer): Boolean;
begin
   Result := rasResize(FCache, Width, Height);
end;

procedure TPDFPageCache.ResizeViewport(Width, Height: Single);
begin
   rasResizeViewport(FCache, Width, Height);
end;

function TPDFPageCache.Scroll(Vertical: Boolean; ScrollCode: Integer; var ScrollX, ScrollY: Integer): TUpdScrollbar;
begin
   Result := rasScroll(FCache, Vertical, ScrollCode, ScrollX, ScrollY);
end;

procedure TPDFPageCache.SelectAll(ObjTypes: TSelectObjType);
begin
   rasSelectAll(FCache, ObjTypes);
end;

function TPDFPageCache.SelectAnnotOrField(Handle: Cardinal; IsField: Boolean; SelColor: Cardinal; var NewX, NewY, NewZoom: Single; var NewPageScale: TPDFPageScale): TUpdBmkAction;
begin
   Result := rasSelectAnnotOrField(FCache, Handle, IsField, SelColor, NewX, NewY, NewZoom, NewPageScale);
end;

function TPDFPageCache.SelectObject(Down: Boolean; X, Y: Integer; SelColor: Cardinal; const Info: PPDFObjectInfo): TSelObjAction;
begin
   Result := rasSelectObject(FCache, Down, X, Y, SelColor, Info);
end;

function TPDFPageCache.SelectObject(PageNum: Cardinal; Down: Boolean; X, Y: Integer; const Info: PPDFObjectInfo): TSelObjAction;
begin
   Result := rasSelectObjectV3(FCache, PageNum, Down, X, Y, Info);
end;

procedure TPDFPageCache.SetBaseControlSize(Width, Height: Integer);
begin
   rasSetBaseControlSize(FCache, Width, Height);
end;

procedure TPDFPageCache.SetClientRect(DC: HDC; var Value: TIntRect);
begin
   rasSetClientRect(FCache, DC, Value);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDFPageCache.SetCMapDir(const Path: AnsiString; Flags: TLoadCMapFlags): Integer;
begin
   Result := rasSetCMapDirA(FCache, PAnsiChar(Path), Flags);
end;

function TPDFPageCache.SetCMapDir(const Path: WideString; Flags: TLoadCMapFlags): Integer;
begin
   Result := rasSetCMapDirW(FCache, PWideChar(Path), Flags);
end;
{$endif}

function TPDFPageCache.SetCMapDirA(const Path: AnsiString; Flags: TLoadCMapFlags): Integer;
begin
   Result := rasSetCMapDirA(FCache, PAnsiChar(Path), Flags);
end;

function TPDFPageCache.SetCMapDirW(const Path: WideString; Flags: TLoadCMapFlags): Integer;
begin
   Result := rasSetCMapDirW(FCache, PWideChar(Path), Flags);
end;

procedure TPDFPageCache.SetDefPageLayout(Value: TPageLayout);
begin
   rasSetDefPageLayout(FCache, Value);
end;

function TPDFPageCache.SetMinLineWidth(Value: Single): Boolean;
begin
   Result := rasSetMinLineWidth(FCache, Value);
end;

// Min version 4.0.17.44 or 40170044
function TPDFPageCache.SetOCGState(Handle: Cardinal; Visible, SaveState: Boolean): Boolean;
begin
   Result := rasSetOCGState(FCache, Handle, Visible, SaveState);
end;

procedure TPDFPageCache.SetOnPaintCallback(const UserData: Pointer; Callback: TOnUpdateWindow);
begin
 {$ifdef DYNLNK}
   if Assigned(rasSetOnPaintCallback) then
 {$endif}
      rasSetOnPaintCallback(FCache, UserData, Callback);
end;

function TPDFPageCache.SetOption(Option: TPageCacheOptions; Value: Integer): Boolean;
begin
   Result := rasSetOption(FCache, Option, Value);
end;

procedure TPDFPageCache.SetPageLayout(Value: TPageLayout);
begin
   rasSetPageLayout(FCache, Value);
end;

procedure TPDFPageCache.SetPageScale(Value: TPDFPageScale);
begin
   rasSetPageScale(FCache, Value);
end;

procedure TPDFPageCache.SetRotate(Value: Integer);
begin
   rasSetRotate(FCache, Value);
end;

function TPDFPageCache.SetScrollLineDelta(Vertical: Boolean; Value: Cardinal): Boolean;
begin
   Result := rasSetScrollLineDelta(FCache, Vertical, Value);
end;

procedure TPDFPageCache.SetSelectionMode(Value: TSelectObjType);
begin
   rasSetSelectionMode(FCache, Value);
end;

procedure TPDFPageCache.SetThreadPriority(UpdateThread, RenderThread: TPDFThreadPriority);
begin
   rasSetThreadPriority(FCache, UpdateThread, RenderThread);
end;

procedure TPDFPageCache.SetWindowHandle(hWnd: HWND);
begin
   rasSetWindowHandle(FCache, hWnd);
end;

procedure TPDFPageCache.UnLock;
begin
   rasUnLock(FCache);
end;

procedure TPDFPageCache.Update(PageNum: Integer);
begin
   rasUpdate(FCache, PageNum);
end;

function TPDFPageCache.Zoom(Value: Single; var HorzPos, VertPos: Integer): Boolean;
begin
   Result := rasZoom(FCache, Value, HorzPos, VertPos);
end;

{--------------------------------------------------------------------------------------------------------------------------------------------------------------}

{ TPDFTable }

constructor TPDFTable.Create(PDFInst: TPDF; AllocRows, NumCols: Cardinal; Width, DefRowHeight: Single);
{$ifdef DYNLNK}
var libHandle: HMODULE;
{$endif}
begin
 {$ifdef DYNLNK}
   libHandle := PDFInst.GetLibHandle();
   LoadFunction(libHandle, @tblAddColumn, 'tblAddColumn');
   LoadFunction(libHandle, @tblAddRow,    'tblAddRow');
   LoadFunction(libHandle, @tblAddRows,   'tblAddRows');
   LoadFunction(libHandle, @tblClearColumn, 'tblClearColumn');
   LoadFunction(libHandle, @tblClearContent, 'tblClearContent');
   LoadFunction(libHandle, @tblClearRow, 'tblClearRow');
   LoadFunction(libHandle, @tblCreateTable, 'tblCreateTable');
   LoadFunction(libHandle, @tblDeleteCol, 'tblDeleteCol');
   LoadFunction(libHandle, @tblDeleteRow, 'tblDeleteRow');
   LoadFunction(libHandle, @tblDeleteRows, 'tblDeleteRows');
   LoadFunction(libHandle, @tblDeleteTable, 'tblDeleteTable');
   LoadFunction(libHandle, @tblDrawTable, 'tblDrawTable');
   LoadFunction(libHandle, @tblGetFirstRow, 'tblGetFirstRow');
   LoadFunction(libHandle, @tblGetFlags, 'tblGetFlags');
   LoadFunction(libHandle, @tblGetNextHeight, 'tblGetNextHeight');
   LoadFunction(libHandle, @tblGetNextRow, 'tblGetNextRow');
   LoadFunction(libHandle, @tblGetNumCols, 'tblGetNumCols');
   LoadFunction(libHandle, @tblGetNumRows, 'tblGetNumRows');
   LoadFunction(libHandle, @tblGetTableHeight, 'tblGetTableHeight');
   LoadFunction(libHandle, @tblGetTableWidth, 'tblGetTableWidth');
   LoadFunction(libHandle, @tblHaveMore, 'tblHaveMore');
   LoadFunction(libHandle, @tblSetBoxProperty, 'tblSetBoxProperty');
   LoadFunction(libHandle, @tblSetCellAction, 'tblSetCellAction');
   LoadFunction(libHandle, @tblSetCellDashPattern, 'tblSetCellDashPattern');
   LoadFunction(libHandle, @tblSetCellImageA, 'tblSetCellImageA');
   LoadFunction(libHandle, @tblSetCellImageW, 'tblSetCellImageW');
   LoadFunction(libHandle, @tblSetCellImageEx, 'tblSetCellImageEx');
   LoadFunction(libHandle, @tblSetCellOrientation, 'tblSetCellOrientation');
   LoadFunction(libHandle, @tblSetCellTable, 'tblSetCellTable');
   LoadFunction(libHandle, @tblSetCellTemplate, 'tblSetCellTemplate');
   LoadFunction(libHandle, @tblSetCellTextA, 'tblSetCellTextA');
   LoadFunction(libHandle, @tblSetCellTextW, 'tblSetCellTextW');
   LoadFunction(libHandle, @tblSetColor, 'tblSetColor');
   LoadFunction(libHandle, @tblSetColorEx, 'tblSetColorEx');
   LoadFunction(libHandle, @tblSetColWidth, 'tblSetColWidth');
   LoadFunction(libHandle, @tblSetFlags, 'tblSetFlags');
   LoadFunction(libHandle, @tblSetFontA, 'tblSetFontA');
   LoadFunction(libHandle, @tblSetFontW, 'tblSetFontW');
   LoadFunction(libHandle, @tblSetFontSelMode, 'tblSetFontSelMode');
   LoadFunction(libHandle, @tblSetFontSize, 'tblSetFontSize');
   LoadFunction(libHandle, @tblSetGridWidth, 'tblSetGridWidth');
   LoadFunction(libHandle, @tblSetRowHeight, 'tblSetRowHeight');
   LoadFunction(libHandle, @tblSetTableWidth, 'tblSetTableWidth');
   if @tblCreateTable = nil then raise Exception.Create('Failed to load the Table API! Check the DynaPDF version!');
 {$endif}
   m_Table := tblCreateTable(PDFInst.PDFInstance, AllocRows, NumCols, Width, DefRowHeight);
   if m_Table = nil then raise Exception.Create('Out of memory!');
end;

destructor TPDFTable.Destroy;
begin
   if m_Table <> nil then tblDeleteTable(m_Table);
   inherited;
end;

function TPDFTable.AddColumn(Left: Boolean; Width: Single): Integer;
begin
   Result := tblAddColumn(m_Table, Left, Width);
end;

function TPDFTable.AddRow(Height: Single): Integer;
begin
   Result := tblAddRow(m_Table, Height);
end;

function TPDFTable.AddRows(Count: Cardinal; Height: Single): Integer;
begin
   Result := tblAddRows(m_Table, Count, Height);
end;

procedure TPDFTable.ClearColumn(Col: Cardinal; Types: TDeleteContent);
begin
   tblClearColumn(m_Table, Col, Types);
end;

procedure TPDFTable.ClearContent(Types: TDeleteContent);
begin
   tblClearContent(m_Table, Types);
end;

procedure TPDFTable.ClearRow(Row: Cardinal; Types: TDeleteContent);
begin
   tblClearRow(m_Table, Row, Types);
end;

procedure TPDFTable.DeleteCol(Col: Cardinal);
begin
   tblDeleteCol(m_Table, Col);
end;

procedure TPDFTable.DeleteRow(Row: Cardinal);
begin
   tblDeleteRow(m_Table, Row);
end;

procedure TPDFTable.DeleteRows;
begin
   tblDeleteRows(m_Table);
end;

function TPDFTable.DrawTable(x, y, MaxHeight: Single): Single;
begin
   Result := tblDrawTable(m_Table, x, y, MaxHeight);
end;

function TPDFTable.GetFirstRow: Integer;
begin
   Result := tblGetFirstRow(m_Table);
end;

function TPDFTable.GetFlags(Row, Col: Integer): Integer;
begin
   Result := tblGetFlags(m_Table, Row, Col);
end;

function TPDFTable.GetInstancePtr: ITBL;
begin
   Result := m_Table;
end;

function TPDFTable.GetNextHeight(MaxHeight: Single; NextRow: PInteger): Single;
begin
   Result := tblGetNextHeight(m_Table, MaxHeight, NextRow);
end;

function TPDFTable.GetNextRow: Integer;
begin
   Result := tblGetNextRow(m_Table);
end;

function TPDFTable.GetNumCols: Integer;
begin
   Result := tblGetNumCols(m_Table);
end;

function TPDFTable.GetNumRows: Integer;
begin
   Result := tblGetNumRows(m_Table);
end;

function TPDFTable.GetTableHeight: Single;
begin
   Result := tblGetTableHeight(m_Table);
end;

function TPDFTable.GetTableWidth: Single;
begin
   Result := tblGetTableWidth(m_Table);
end;

function TPDFTable.HaveMore: Boolean;
begin
   Result := tblHaveMore(m_Table);
end;

function TPDFTable.SetBoxProperty(Row, Col: Integer; PropType: TTableBoxProperty; Left, Right, Top, Bottom: Single): Boolean;
begin
   Result := tblSetBoxProperty(m_Table, Row, Col, PropType, Left, Right, Top, Bottom);
end;

function TPDFTable.SetCellAction(Row, Col: Integer; ActionHandle: Cardinal; Mode: THighlightMode): Boolean;
begin
   Result := tblSetCellAction(m_Table, Row, Col, ActionHandle, Mode);
end;

function TPDFTable.SetCellDashPattern(Row, Col: Integer; Side: TCellSide; Style: TLineCapStyle; const Dash: Array of Single; NumValues: Cardinal; Phase: Single): Boolean;
begin
   Result := tblSetCellDashPattern(m_Table, Row, Col, Side, Style, @Dash[0], NumValues, Phase);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDFTable.SetCellImage(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: AnsiString; Index: Cardinal): Boolean;
begin
   Result := tblSetCellImageA(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, PAnsiChar(Image), Index);
end;

function TPDFTable.SetCellImage(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: WideString; Index: Cardinal): Boolean;
begin
   Result := tblSetCellImageW(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, PWideChar(Image), Index);
end;
{$endif}

function TPDFTable.SetCellImageA(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: AnsiString; Index: Cardinal): Boolean;
begin
   Result := tblSetCellImageA(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, PAnsiChar(Image), Index);
end;

function TPDFTable.SetCellImageW(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Image: WideString; Index: Cardinal): Boolean;
begin
   Result := tblSetCellImageW(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, PWideChar(Image), Index);
end;

function TPDFTable.SetCellImageEx(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; Width, Height: Single; const Buffer: Pointer; BufSize, Index: Cardinal): Boolean;
begin
   Result := tblSetCellImageEx(m_Table, Row, Col, ForeGround, HAlign, VAlign, Width, Height, Buffer, BufSize, Index);
end;

function TPDFTable.SetCellOrientation(Row, Col, Orientation: Integer): Boolean;
begin
   Result := tblSetCellOrientation(m_Table, Row, Col, Orientation);
end;

function TPDFTable.SetCellTable(Row, Col: Cardinal; HAlign, VAlign: TCellAlign; const SubTable: TPDFTable): Boolean;
begin
   Result := tblSetCellTable(m_Table, Row, Col, HAlign, VAlign, SubTable.GetInstancePtr());
end;

function TPDFTable.SetCellTemplate(Row, Col: Integer; ForeGround: Boolean; HAlign, VAlign: TCellAlign; TmplHandle: Cardinal; Width, Height: Single): Boolean;
begin
   Result := tblSetCellTemplate(m_Table, Row, Col, ForeGround, HAlign, VAlign, TmplHandle, Width, Height);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDFTable.SetCellText(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: AnsiString): Boolean;
begin
   Result := tblSetCellTextA(m_Table, Row, Col, HAlign, VAlign, PAnsiChar(Text), Length(Text));
end;

function TPDFTable.SetCellText(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: WideString): Boolean;
begin
   Result := tblSetCellTextW(m_Table, Row, Col, HAlign, VAlign, PWideChar(Text), Length(Text));
end;
{$endif}

function TPDFTable.SetCellTextA(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: AnsiString): Boolean;
begin
   Result := tblSetCellTextA(m_Table, Row, Col, HAlign, VAlign, PAnsiChar(Text), Length(Text));
end;

function TPDFTable.SetCellTextW(Row, Col: Integer; HAlign: TTextAlign; VAlign: TCellAlign; const Text: WideString): Boolean;
begin
   Result := tblSetCellTextW(m_Table, Row, Col, HAlign, VAlign, PWideChar(Text), Length(Text));
end;

function TPDFTable.SetColor(Row, Col: Integer; ClrType: TTableColor; CS: TPDFColorSpace; Color: Cardinal): Boolean;
begin
   Result := tblSetColor(m_Table, Row, Col, ClrType, CS, Color);
end;

function TPDFTable.SetColorEx(Row, Col: Integer; ClrType: TTableColor; Color: PSingle; NumComps: Cardinal; CS: TExtColorSpace; Handle: Integer): Boolean;
begin
   Result := tblSetColorEx(m_Table, Row, Col, ClrType, Color, NumComps, CS, Handle);
end;

function TPDFTable.SetColWidth(Col: Cardinal; Width: Single; ExtTable: Boolean): Boolean;
begin
   Result := tblSetColWidth(m_Table, Col, Width, ExtTable);
end;

function TPDFTable.SetFlags(Row, Col: Integer; Flags: TTableFlags): Boolean;
begin
   Result := tblSetFlags(m_Table, Row, Col, Flags);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDFTable.SetFont(Row, Col: Integer; const Name: AnsiString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
begin
   Result := tblSetFontA(m_Table, Row, Col, PAnsiChar(Name), Style, Embed, CP);
end;

function TPDFTable.SetFont(Row, Col: Integer; const Name: WideString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
begin
   Result := tblSetFontW(m_Table, Row, Col, PWideChar(Name), Style, Embed, CP);
end;
{$endif}

function TPDFTable.SetFontA(Row, Col: Integer; const Name: AnsiString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
begin
   Result := tblSetFontA(m_Table, Row, Col, PAnsiChar(Name), Style, Embed, CP);
end;

function TPDFTable.SetFontW(Row, Col: Integer; const Name: WideString; Style: TFStyle; Embed: Boolean; CP: TCodepage): Boolean;
begin
   Result := tblSetFontW(m_Table, Row, Col, PWideChar(Name), Style, Embed, CP);
end;

function TPDFTable.SetFontSelMode(Row, Col: Integer; Mode: TFontSelMode): Boolean;
begin
   Result := tblSetFontSelMode(m_Table, Row, Col, Mode);
end;

function TPDFTable.SetFontSize(Row, Col: Integer; Value: Single): Boolean;
begin
   Result := tblSetFontSize(m_Table, Row, Col, Value);
end;

function TPDFTable.SetGridWidth(Horz, Vert: Single): Boolean;
begin
   Result := tblSetGridWidth(m_Table, Horz, Vert);
end;

function TPDFTable.SetRowHeight(Row: Integer; Value: Single): Boolean;
begin
   Result := tblSetRowHeight(m_Table, Row, Value);
end;

procedure TPDFTable.SetTableWidth(Value: Single; AdjustType: TColumnAdjust; MinColWidth: Single);
begin
   tblSetTableWidth(m_Table, Value, AdjustType, MinColWidth);
end;

{--------------------------------------------------------------------------------------------------------------------------------------------------------------}

{ TPDF }

// The constructor was changed in Version 2.0.49.485 to achieve compability with Delphi 2009 or higher.
 {$ifdef MSWINDOWS}
   constructor TPDF.Create(const LibName: WideString = 'dynapdf.dll');
 {$else}
   {$if defined(MACOS)}
      constructor TPDF.Create(const LibName: WideString = 'libdynapdf.dylib');
   {$elseif defined(ANDROID32)}
      constructor TPDF.Create(const LibName: WideString = 'libdynapdf32.so');
   {$elseif defined(ANDROID64)}
      constructor TPDF.Create(const LibName: WideString = 'libdynapdf64.so');
   {$else}
      constructor TPDF.Create(const LibName: WideString = 'libdynapdf.so');
   {$ifend}
{$endif}
{$ifdef DYNLNK}
var newPDF: pdfNewPDF;
{$endif}
begin
   FLibName := LibName;
   {$ifdef DYNLNK}
      {$ifndef FPC}
         {$if (defined(MACOS) Or defined(IOS) Or defined(ANDROID) Or defined(Linux))}
            FDLL_Handle := LoadLibrary(PWideChar(LibName));
         {$else}
            FDLL_Handle := LoadLibraryW(PWideChar(LibName));
         {$ifend}
      {$else}
         FDLL_Handle := LoadLibrary(LibName);
      {$endif}
      {$ifdef FPC}
      {$warn 4105 off}
      {$endif}
      if FDLL_Handle = 0 then raise Exception.Create('Error: Cannot find ' + LibName);
      newPDF := nil;
      LoadFunction(Pointer(@newPDF), 'pdfNewPDF');
      FInstance := newPDF;
      if (FInstance = nil) then Exception.Create('Out of memory!');
   {$else}
      FInstance := pdfNewPDF;
   {$endif}
end;

destructor TPDF.Destroy;
{$ifdef DYNLNK}
var deletePDF: pdfDeletePDF;
{$endif}
begin
 {$ifdef DYNLNK}
   if FDLL_Handle = 0 then Exit;
   @deletePDF := GetProcAddress(FDLL_Handle, 'pdfDeletePDF');
   if @deletePDF = nil then begin
      // Maybe a wrong library loaded?
      // If this function cannot be found then most other functions should not be found too.
      // We assume that this error was already handled...
      FreeLibrary(FDLL_Handle);
      Exit;
   end;
   deletePDF(FInstance);
   FreeLibrary(FDLL_Handle);
 {$else}
   pdfDeletePDF(FInstance);
 {$endif}
   inherited;
end;

function TPDF.IntStrLen(Value: PAnsiChar): Integer;
begin
   Result := 0;
   if Value <> nil then begin
      while Value^ <> Char(0) do begin
          Inc(Result);
          Inc(Value);
      end;
   end;
end;

{$ifdef DYNLNK}
procedure TPDF.LoadFunction(var Func: Pointer; const FuncName: String);
begin
   if Func = nil then begin
   {$ifdef DELPHI_UNICODE}
      Func := GetProcAddress(FDLL_Handle, PWideChar(FuncName));
   {$else}
      Func := GetProcAddress(FDLL_Handle, PAnsiChar(FuncName));
   {$endif}
      if Func = nil then raise Exception.Create(Format('Error loading function: "%s"', [FuncName]));
   end;
end;
{$endif}

procedure TPDF.Abort(RasPtr: IRAS);
begin
   {$ifdef DYNLNK}LoadFunction(@rasAbort, 'rasAbort');{$endif}
   rasAbort(RasPtr);
end;

function TPDF.ActivateAltFontList(Handle: Integer; EnableSysFonts: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfActivateAltFontList, 'pdfActivateAltFontList');{$endif}
   Result := pdfActivateAltFontList(FInstance, Handle, EnableSysFonts);
end;

function TPDF.AddActionToObj(ObjType: TObjType; Event: TObjEvent; ActHandle, ObjHandle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddActionToObj, 'pdfAddActionToObj');{$endif}
   Result := pdfAddActionToObj(FInstance, Integer(ObjType), Integer(Event), ActHandle, ObjHandle);
end;

function TPDF.AddAnnotToPage(PageNum, Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddAnnotToPage, 'pdfAddAnnotToPage');{$endif}
   Result := pdfAddAnnotToPage(FInstance, PageNum, Handle);
end;

function TPDF.AddArticle(PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddArticle, 'pdfAddArticle');{$endif}
   Result := pdfAddArticle(FInstance, PosX, PosY, Width, Height);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddBookmark(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkA, 'pdfAddBookmarkA');{$endif}
   Result := pdfAddBookmarkA(FInstance, PAnsiChar(Title), Parent, DestPage, Integer(Open));
end;

function TPDF.AddBookmark(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkW, 'pdfAddBookmarkW');{$endif}
   Result := pdfAddBookmarkW(FInstance, PWideChar(Title), Parent, DestPage, Integer(Open));
end;
{$endif}

function TPDF.AddBookmarkA(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkA, 'pdfAddBookmarkA');{$endif}
   Result := pdfAddBookmarkA(FInstance, PAnsiChar(Title), Parent, DestPage, Integer(Open));
end;

function TPDF.AddBookmarkW(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkW, 'pdfAddBookmarkW');{$endif}
   Result := pdfAddBookmarkW(FInstance, PWideChar(Title), Parent, DestPage, Integer(Open));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddBookmarkEx(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkExA, 'pdfAddBookmarkExA');{$endif}
   Result := pdfAddBookmarkExA(FInstance, PAnsiChar(Title), Parent, NamedDest, Open);
end;

function TPDF.AddBookmarkEx(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkExW, 'pdfAddBookmarkExW');{$endif}
   Result := pdfAddBookmarkExW(FInstance, PWideChar(Title), Parent, NamedDest, Open);
end;
{$endif}

function TPDF.AddBookmarkExA(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkExA, 'pdfAddBookmarkExA');{$endif}
   Result := pdfAddBookmarkExA(FInstance, PAnsiChar(Title), Parent, NamedDest, Open);
end;

function TPDF.AddBookmarkExW(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkExW, 'pdfAddBookmarkExW');{$endif}
   Result := pdfAddBookmarkExW(FInstance, PWideChar(Title), Parent, NamedDest, Open);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddBookmarkEx2(const Title: AnsiString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2A, 'pdfAddBookmarkEx2A');{$endif}
   Result := pdfAddBookmarkEx2A(FInstance, PAnsiChar(Title), Parent, PAnsiChar(NamedDest), false, Open);
end;

function TPDF.AddBookmarkEx2(const Title: AnsiString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2A, 'pdfAddBookmarkEx2A');{$endif}
   Result := pdfAddBookmarkEx2A(FInstance, PAnsiChar(Title), Parent, PWideChar(NamedDest), true, Open);
end;

function TPDF.AddBookmarkEx2(const Title: WideString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2W, 'pdfAddBookmarkEx2W');{$endif}
   Result := pdfAddBookmarkEx2W(FInstance, PWideChar(Title), Parent, PAnsiChar(NamedDest), false, Open);
end;

function TPDF.AddBookmarkEx2(const Title: WideString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2W, 'pdfAddBookmarkEx2W');{$endif}
   Result := pdfAddBookmarkEx2W(FInstance, PWideChar(Title), Parent, PWideChar(NamedDest), true, Open);
end;
{$endif}

function TPDF.AddBookmarkEx2AA(const Title: AnsiString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2A, 'pdfAddBookmarkEx2A');{$endif}
   Result := pdfAddBookmarkEx2A(FInstance, PAnsiChar(Title), Parent, PAnsiChar(NamedDest), false, Open);
end;

function TPDF.AddBookmarkEx2AW(const Title: AnsiString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2A, 'pdfAddBookmarkEx2A');{$endif}
   Result := pdfAddBookmarkEx2A(FInstance, PAnsiChar(Title), Parent, PWideChar(NamedDest), true, Open);
end;

function TPDF.AddBookmarkEx2WA(const Title: WideString; Parent: Integer; const NamedDest: AnsiString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2W, 'pdfAddBookmarkEx2W');{$endif}
   Result := pdfAddBookmarkEx2W(FInstance, PWideChar(Title), Parent, PAnsiChar(NamedDest), false, Open);
end;

function TPDF.AddBookmarkEx2WW(const Title: WideString; Parent: Integer; const NamedDest: WideString; Open: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddBookmarkEx2W, 'pdfAddBookmarkEx2W');{$endif}
   Result := pdfAddBookmarkEx2W(FInstance, PWideChar(Title), Parent, PWideChar(NamedDest), true, Open);
end;

function TPDF.AddButtonImage(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageA, 'pdfAddButtonImageA');{$endif}
   Result := pdfAddButtonImageA(FInstance, BtnHandle, State, PAnsiChar(Caption), PAnsiChar(ImgFile));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddButtonImage(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageW, 'pdfAddButtonImageW');{$endif}
   Result := pdfAddButtonImageW(FInstance, BtnHandle, State, PWideChar(Caption), PWideChar(ImgFile));
end;
{$endif}

function TPDF.AddButtonImageA(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageA, 'pdfAddButtonImageA');{$endif}
   Result := pdfAddButtonImageA(FInstance, BtnHandle, State, PAnsiChar(Caption), PAnsiChar(ImgFile));
end;

function TPDF.AddButtonImageW(BtnHandle: Cardinal; State: TButtonState; const Caption, ImgFile: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageW, 'pdfAddButtonImageW');{$endif}
   Result := pdfAddButtonImageW(FInstance, BtnHandle, State, PWideChar(Caption), PWideChar(ImgFile));
end;

function TPDF.AddButtonImageEx(BtnHandle: Cardinal; State: TButtonState; const Caption: AnsiString; Handle: HBITMAP): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageEx, 'pdfAddButtonImageEx');{$endif}
   Result := pdfAddButtonImageEx(FInstance, BtnHandle, State, PAnsiChar(Caption), Pointer(Handle));
end;

function TPDF.AddButtonImageEx2(BtnHandle: Cardinal; State: TButtonState; const Caption: WideString; const Buffer: Pointer; BufSize: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddButtonImageEx2, 'pdfAddButtonImageEx2');{$endif}
   Result := pdfAddButtonImageEx2(FInstance, BtnHandle, State, PWideChar(Caption), Buffer, BufSize);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddContinueText(const AText: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddContinueTextA, 'pdfAddContinueTextA');{$endif}
   Result := pdfAddContinueTextA(FInstance, PAnsiChar(AText));
end;

function TPDF.AddContinueText(const AText: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddContinueTextW, 'pdfAddContinueTextW');{$endif}
   Result := pdfAddContinueTextW(FInstance, PWideChar(AText));
end;
{$endif}

function TPDF.AddContinueTextA(const AText: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddContinueTextA, 'pdfAddContinueTextA');{$endif}
   Result := pdfAddContinueTextA(FInstance, PAnsiChar(AText));
end;

function TPDF.AddContinueTextW(const AText: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddContinueTextW, 'pdfAddContinueTextW');{$endif}
   Result := pdfAddContinueTextW(FInstance, PWideChar(AText));
end;

function TPDF.AddDeviceNProcessColorants(DeviceNCS: Cardinal; const Colorants: Array of AnsiString; NumColorants: Cardinal; ProcessCS: TExtColorSpace; Handle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddDeviceNProcessColorants, 'pdfAddDeviceNProcessColorants');{$endif}
   Result := pdfAddDeviceNProcessColorants(FInstance, DeviceNCS, PPAnsiChar(@Colorants[0]), NumColorants, ProcessCS, Handle);
end;

function TPDF.AddDeviceNSeparations(DeviceNCS: Cardinal; const Colorants: Array of AnsiString; SeparationCS: Array of Integer; NumColorants: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddDeviceNSeparations, 'pdfAddDeviceNSeparations');{$endif}
   Result := pdfAddDeviceNSeparations(FInstance, DeviceNCS, PPAnsiChar(@Colorants[0]), PInteger(@SeparationCS[0]), NumColorants);
end;

function TPDF.AddDPartNode(Parent, FirstPage, LastPage: Integer; const DPM: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddDPartNode, 'pdfAddDPartNode');{$endif}
   Result := pdfAddDPartNode(FInstance, Parent, FirstPage, LastPage, PAnsiChar(DPM));
end;

function TPDF.AddFieldToFormAction(Action, AField: Cardinal; Include: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFieldToFormAction, 'pdfAddFieldToFormAction');{$endif}
   Result := pdfAddFieldToFormAction(FInstance, Action, AField, Include);
end;

function TPDF.AddFieldToHideAction(HideAct, AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFieldToHideAction, 'pdfAddFieldToHideAction');{$endif}
   Result := pdfAddFieldToHideAction(FInstance, HideAct, AField);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddFileComment(const AText: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFileCommentA, 'pdfAddFileCommentA');{$endif}
   Result := pdfAddFileCommentA(FInstance, PAnsiChar(AText));
end;

function TPDF.AddFileComment(const AText: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFileCommentW, 'pdfAddFileCommentW');{$endif}
   Result := pdfAddFileCommentW(FInstance, PWideChar(AText));
end;
{$endif}

function TPDF.AddFileCommentA(const AText: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFileCommentA, 'pdfAddFileCommentA');{$endif}
   Result := pdfAddFileCommentA(FInstance, PAnsiChar(AText));
end;

function TPDF.AddFileCommentW(const AText: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFileCommentW, 'pdfAddFileCommentW');{$endif}
   Result := pdfAddFileCommentW(FInstance, PWideChar(AText));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddFontSearchPath(const APath: AnsiString; Recursive: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFontSearchPathA, 'pdfAddFontSearchPathA');{$endif}
   Result := pdfAddFontSearchPathA(FInstance, PAnsiChar(APath), Recursive);
end;

function TPDF.AddFontSearchPath(const APath: WideString; Recursive: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFontSearchPathW, 'pdfAddFontSearchPathW');{$endif}
   Result := pdfAddFontSearchPathW(FInstance, PWideChar(APath), Recursive);
end;
{$endif}

function TPDF.AddFontSearchPathA(const APath: AnsiString; Recursive: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFontSearchPathA, 'pdfAddFontSearchPathA');{$endif}
   Result := pdfAddFontSearchPathA(FInstance, PAnsiChar(APath), Recursive);
end;

function TPDF.AddFontSearchPathW(const APath: WideString; Recursive: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddFontSearchPathW, 'pdfAddFontSearchPathW');{$endif}
   Result := pdfAddFontSearchPathW(FInstance, PWideChar(APath), Recursive);
end;

function TPDF.AddHeaderFooter(var Value: TPDFHeaderFooter; var HFArray: Array of TPDFHdrFtr): Boolean;
begin
   Value.StructSize := sizeof(Value);
   {$ifdef DYNLNK}LoadFunction(@pdfAddHeaderFooter, 'pdfAddHeaderFooter');{$endif}
   Result := pdfAddHeaderFooter(FInstance, Value, @HFArray[0], High(HFArray) +1);
end;

function TPDF.AddImage(Filter: TCompressionFilter; Flags: TImageConversionFlags; var Image: TPDFImage): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddImage, 'pdfAddImage');{$endif}
   Result := pdfAddImage(FInstance, Filter, Flags, Image);
end;

function TPDF.AddInkList(InkAnnot: Cardinal; Points: PFltPoint; NumPoints: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddInkList, 'pdfAddInkList');{$endif}
   Result := pdfAddInkList(FInstance, InkAnnot, Points, NumPoints);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddJavaScript(const Name, Script: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddJavaScriptA, 'pdfAddJavaScriptA');{$endif}
   Result := pdfAddJavaScriptA(FInstance, PAnsiChar(Name), PAnsiChar(Script));
end;

function TPDF.AddJavaScript(const Name: AnsiString; const Script: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddJavaScriptW, 'pdfAddJavaScriptW');{$endif}
   Result := pdfAddJavaScriptW(FInstance, PAnsiChar(Name), PWideChar(Script));
end;
{$endif}

function TPDF.AddJavaScriptA(const Name, Script: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddJavaScriptA, 'pdfAddJavaScriptA');{$endif}
   Result := pdfAddJavaScriptA(FInstance, PAnsiChar(Name), PAnsiChar(Script));
end;

function TPDF.AddJavaScriptW(const Name: AnsiString; const Script: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddJavaScriptW, 'pdfAddJavaScriptW');{$endif}
   Result := pdfAddJavaScriptW(FInstance, PAnsiChar(Name), PWideChar(Script));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddLayerToDisplTree(Parent: Pointer; Layer: Integer; const Title: AnsiString): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddLayerToDisplTreeA, 'pdfAddLayerToDisplTreeA');{$endif}
   Result := pdfAddLayerToDisplTreeA(FInstance, Parent, Layer, PAnsiChar(Title));
end;

function TPDF.AddLayerToDisplTree(Parent: Pointer; Layer: Integer; const Title: WideString): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddLayerToDisplTreeW, 'pdfAddLayerToDisplTreeW');{$endif}
   Result := pdfAddLayerToDisplTreeW(FInstance, Parent, Layer, PWideChar(Title));
end;
{$endif}

function TPDF.AddLayerToDisplTreeA(Parent: Pointer; Layer: Integer; const Title: AnsiString): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddLayerToDisplTreeA, 'pdfAddLayerToDisplTreeA');{$endif}
   Result := pdfAddLayerToDisplTreeA(FInstance, Parent, Layer, PAnsiChar(Title));
end;

function TPDF.AddLayerToDisplTreeW(Parent: Pointer; Layer: Integer; const Title: WideString): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddLayerToDisplTreeW, 'pdfAddLayerToDisplTreeW');{$endif}
   Result := pdfAddLayerToDisplTreeW(FInstance, Parent, Layer, PWideChar(Title));
end;

function TPDF.AddMaskImage(BaseImage: Cardinal; const Buffer: Pointer; BufSize: Cardinal; Stride: Integer; BitsPerPixel, Width, Height: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddMaskImage, 'pdfAddMaskImage');{$endif}
   Result := pdfAddMaskImage(FInstance, BaseImage, Buffer, BufSize, Stride, BitsPerPixel, Width, Height);
end;

function TPDF.AddObjectToLayer(OCG: Cardinal; ObjType: TOCObject; Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddObjectToLayer, 'pdfAddObjectToLayer');{$endif}
   Result := pdfAddObjectToLayer(FInstance, OCG, ObjType, Handle);
end;

function TPDF.AddOCGToAppEvent(Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOCGToAppEvent, 'pdfAddOCGToAppEvent');{$endif}
   Result := pdfAddOCGToAppEvent(FInstance, Handle, Events, Categories);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddOutputIntent(const ICCFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentA, 'pdfAddOutputIntentA');{$endif}
   Result := pdfAddOutputIntentA(FInstance, PAnsiChar(ICCFile));
end;

function TPDF.AddOutputIntent(const ICCFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentW, 'pdfAddOutputIntentW');{$endif}
   Result := pdfAddOutputIntentW(FInstance, PWideChar(ICCFile));
end;
{$endif}

function TPDF.AddOutputIntentA(const ICCFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentA, 'pdfAddOutputIntentA');{$endif}
   Result := pdfAddOutputIntentA(FInstance, PAnsiChar(ICCFile));
end;

function TPDF.AddOutputIntentW(const ICCFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentW, 'pdfAddOutputIntentW');{$endif}
   Result := pdfAddOutputIntentW(FInstance, PWideChar(ICCFile));
end;

function TPDF.AddOutputIntentEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentEx, 'pdfAddOutputIntentEx');{$endif}
   Result := pdfAddOutputIntentEx(FInstance, Buffer, BufSize);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddPageLabel(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: AnsiString; AddNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddPageLabelA, 'pdfAddPageLabelA');{$endif}
   Result := pdfAddPageLabelA(FInstance, StartRange, Format, PAnsiChar(Prefix), AddNum);
end;

function TPDF.AddPageLabel(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: WideString; AddNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddPageLabelW, 'pdfAddPageLabelW');{$endif}
   Result := pdfAddPageLabelW(FInstance, StartRange, Format, PWideChar(Prefix), AddNum);
end;
{$endif}

function TPDF.AddPageLabelA(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: AnsiString; AddNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddPageLabelA, 'pdfAddPageLabelA');{$endif}
   Result := pdfAddPageLabelA(FInstance, StartRange, Format, PAnsiChar(Prefix), AddNum);
end;

function TPDF.AddPageLabelW(StartRange: Cardinal; Format: TPageLabelFormat; const Prefix: WideString; AddNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddPageLabelW, 'pdfAddPageLabelW');{$endif}
   Result := pdfAddPageLabelW(FInstance, StartRange, Format, PWideChar(Prefix), AddNum);
end;

function TPDF.AddRasImage(RasPtr: IRAS; Filter: TCompressionFilter): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddRasImage, 'pdfAddRasImage');{$endif}
   Result := pdfAddRasImage(FInstance, RasPtr, Filter);
end;

{$ifdef DELPHI6_OR_HIGHER}
{
  These functions were incorrectly named. Please use AddOutputIntent() instead.
  ------------------------------------------------------------------------------------------------------------------------------------------------------------ }

function TPDF.AddRenderingIntent(const ICCFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentA, 'pdfAddRenderingIntentA');{$endif}
   Result := pdfAddOutputIntentA(FInstance, PAnsiChar(ICCFile));
end;

function TPDF.AddRenderingIntent(const ICCFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentW, 'pdfAddRenderingIntentW');{$endif}
   Result := pdfAddOutputIntentW(FInstance, PWideChar(ICCFile));
end;
{$endif}

function TPDF.AddRenderingIntentA(const ICCFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentA, 'pdfAddRenderingIntentA');{$endif}
   Result := pdfAddOutputIntentA(FInstance, PAnsiChar(ICCFile));
end;

function TPDF.AddRenderingIntentW(const ICCFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentW, 'pdfAddRenderingIntentW');{$endif}
   Result := pdfAddOutputIntentW(FInstance, PWideChar(ICCFile));
end;

function TPDF.AddRenderingIntentEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddOutputIntentEx, 'pdfAddRenderingIntentEx');{$endif}
   Result := pdfAddOutputIntentEx(FInstance, Buffer, BufSize);
end;

{ ------------------------------------------------------------------------------------------------------------------------------------------------------------ }

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AddValToChoiceField(Field: Cardinal; const ExpValue, Value: AnsiString; Selected: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddValToChoiceFieldA, 'pdfAddValToChoiceFieldA');{$endif}
   Result := pdfAddValToChoiceFieldA(FInstance, Field, PAnsiChar(ExpValue), PAnsiChar(Value), Integer(Selected));
end;

function TPDF.AddValToChoiceField(Field: Cardinal; const ExpValue: AnsiString; const Value: WideString; Selected: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddValToChoiceFieldW, 'pdfAddValToChoiceFieldW');{$endif}
   Result := pdfAddValToChoiceFieldW(FInstance, Field, PAnsiChar(ExpValue), PWideChar(Value), Integer(Selected));
end;
{$endif}

function TPDF.AddValToChoiceFieldA(Field: Cardinal; const ExpValue, Value: AnsiString; Selected: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddValToChoiceFieldA, 'pdfAddValToChoiceFieldA');{$endif}
   Result := pdfAddValToChoiceFieldA(FInstance, Field, PAnsiChar(ExpValue), PAnsiChar(Value), Integer(Selected));
end;

function TPDF.AddValToChoiceFieldW(Field: Cardinal; const ExpValue: AnsiString; const Value: WideString; Selected: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAddValToChoiceFieldW, 'pdfAddValToChoiceFieldW');{$endif}
   Result := pdfAddValToChoiceFieldW(FInstance, Field, PAnsiChar(ExpValue), PWideChar(Value), Integer(Selected));
end;

function TPDF.Append(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAppend, 'pdfAppend');{$endif}
   Result := pdfAppend(FInstance);
end;

function TPDF.ApplyAppEvent(Event: TOCAppEvent; SaveResult: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfApplyAppEvent, 'pdfApplyAppEvent');{$endif}
   Result := pdfApplyAppEvent(FInstance, Event, SaveResult);
end;

function TPDF.ApplyPattern(PattHandle: Integer; ColorMode: TColorMode; Color: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfApplyPattern, 'pdfApplyPattern');{$endif}
   Result := pdfApplyPattern(FInstance, PattHandle, ColorMode, Color);
end;

function TPDF.ApplyShading(ShadHandle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfApplyShading, 'pdfApplyShading');{$endif}
   Result := pdfApplyShading(FInstance, ShadHandle);
end;

function TPDF.AssociateEmbFile(DestObject: TAFDestObject; DestHandle: Integer; Relationship: TAFRelationship; EmbFile: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAssociateEmbFile, 'pdfAssociateEmbFile');{$endif}
   Result := pdfAssociateEmbFile(FInstance, DestObject, DestHandle, Relationship, EmbFile);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AttachFile(const FilePath, Description: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileA, 'pdfAttachFileA');{$endif}
   Result := pdfAttachFileA(FInstance, PAnsiChar(FilePath), PAnsiChar(Description), Compress);
end;

function TPDF.AttachFile(const FilePath, Description: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileW, 'pdfAttachFileW');{$endif}
   Result := pdfAttachFileW(FInstance, PWideChar(FilePath), PWideChar(Description), Compress);
end;
{$endif}

function TPDF.AttachFileA(const FilePath, Description: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileA, 'pdfAttachFileA');{$endif}
   Result := pdfAttachFileA(FInstance, PAnsiChar(FilePath), PAnsiChar(Description), Compress);
end;

function TPDF.AttachFileW(const FilePath, Description: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileW, 'pdfAttachFileW');{$endif}
   Result := pdfAttachFileW(FInstance, PWideChar(FilePath), PWideChar(Description), Compress);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.AttachFileEx(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileExA, 'pdfAttachFileExA');{$endif}
   Result := pdfAttachFileExA(FInstance, Pointer(Buffer), BufSize, PAnsiChar(FileName), PAnsiChar(Description), Compress);
end;

function TPDF.AttachFileEx(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileExW, 'pdfAttachFileExW');{$endif}
   Result := pdfAttachFileExW(FInstance, Pointer(Buffer), BufSize, PWideChar(FileName), PWideChar(Description), Compress);
end;
{$endif}

function TPDF.AttachFileExA(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileExA, 'pdfAttachFileExA');{$endif}
   Result := pdfAttachFileExA(FInstance, Pointer(Buffer), BufSize, PAnsiChar(FileName), PAnsiChar(Description), Compress);
end;

function TPDF.AttachFileExW(const Buffer: Pointer; BufSize: Cardinal; const FileName, Description: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAttachFileExW, 'pdfAttachFileExW');{$endif}
   Result := pdfAttachFileExW(FInstance, Pointer(Buffer), BufSize, PWideChar(FileName), PWideChar(Description), Compress);
end;

function TPDF.AttachImageBuffer(RasPtr: IRAS; Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@rasAttachImageBuffer, 'rasAttachImageBuffer');{$endif}
   Result := rasAttachImageBuffer(RasPtr, Rows, Buffer, Width, Height, ScanlineLen);
end;

function TPDF.AutoTemplate(Templ: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfAutoTemplate, 'pdfAutoTemplate');{$endif}
   Result := pdfAutoTemplate(FInstance, Templ, PosX, PosY, Width, Height);
end;

function TPDF.BeginClipPath(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginClipPath, 'pdfBeginClipPath');{$endif}
   Result := pdfBeginClipPath(FInstance);
end;

function TPDF.BeginContinueText(PosX, PosY: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginContinueText, 'pdfBeginContinueText');{$endif}
   Result := pdfBeginContinueText(FInstance, PosX, PosY);
end;

function TPDF.BeginLayer(OCG: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginLayer, 'pdfBeginLayer');{$endif}
   Result := pdfBeginLayer(FInstance, OCG);
end;

function TPDF.BeginPageTemplate(const Name: AnsiString; UseAutoTemplates: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginPageTemplate, 'BeginPageTemplate');{$endif}
   Result := pdfBeginPageTemplate(FInstance, PAnsiChar(Name), UseAutoTemplates);
end;

function TPDF.BeginPattern(PatternType: TPatternType; TilingType: TTilingType; Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginPattern, 'pdfBeginPattern');{$endif}
   Result := pdfBeginPattern(FInstance, PatternType, TilingType, Width, Height);
end;

function TPDF.BeginTemplate(Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginTemplate, 'pdfBeginTemplate');{$endif}
   Result := pdfBeginTemplate(FInstance, Width, Height);
end;

function TPDF.BeginTemplateEx(var BBox: TPDFRect; var Matrix: TCTM): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginTemplateEx, 'pdfBeginTemplateEx');{$endif}
   Result := pdfBeginTemplateEx(FInstance, BBox, Matrix);
end;

function TPDF.BeginTransparencyGroup(x1, y1, x2, y2: Double; Isolated, Knockout: Boolean; CS: TExtColorSpace; CSHandle: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBeginTransparencyGroup, 'pdfBeginTransparencyGroup');{$endif}
   Result := pdfBeginTransparencyGroup(FInstance, x1, y1, x2, y2, Isolated, Knockout, CS, CSHandle);
end;

function TPDF.Bezier_1_2_3(x1, y1, x2, y2, x3, y3: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBezier_1_2_3, 'pdfBezier_1_2_3');{$endif}
   Result := pdfBezier_1_2_3(FInstance, x1, y1, x2, y2, x3, y3);
end;

function TPDF.Bezier_1_3(x1, y1, x3, y3: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBezier_1_3, 'pdfBezier_1_3');{$endif}
   Result := pdfBezier_1_3(FInstance, x1, y1, x3, y3);
end;

function TPDF.Bezier_2_3(x2, y2, x3, y3: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfBezier_2_3, 'pdfBezier_2_3');{$endif}
   Result := pdfBezier_2_3(FInstance, x2, y2, x3, y3);
end;

function TPDF.BuildFamilyNameAndStyle(const IFont: PFNT; Name: PAnsiChar; var Style: TFStyle): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@fntBuildFamilyNameAndStyle, 'fntBuildFamilyNameAndStyle');{$endif}
   Result := fntBuildFamilyNameAndStyle(IFont, Name, Style);
end;

procedure TPDF.CalcPagePixelSize(PagePtr: IPGE; DefScale: TPDFPageScale; Scale: Single; FrameWidth, FrameHeight: Cardinal; Flags: TRasterFlags; var Width, Height: Cardinal);
begin
   {$ifdef DYNLNK}LoadFunction(@rasCalcPagePixelSize, 'rasCalcPagePixelSize');{$endif}
   rasCalcPagePixelSize(PagePtr, DefScale, Scale, FrameWidth, FrameHeight, Flags, Width, Height);
end;

function TPDF.CalcWidthHeight(OrgWidth, OrgHeight, ScaledWidth, ScaledHeight: Double): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCalcWidthHeight, 'pdfCalcWidthHeight');{$endif}
   Result := pdfCalcWidthHeight(FInstance, OrgWidth, OrgHeight, ScaledWidth, ScaledHeight);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CaretAnnot(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCaretAnnotA, 'pdfCaretAnnotA');{$endif}
   Result := pdfCaretAnnotA(FInstance, PosX, PosY, Width, Height, Color, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Content));
end;

function TPDF.CaretAnnot(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCaretAnnotW, 'pdfCaretAnnotW');{$endif}
   Result := pdfCaretAnnotW(FInstance, PosX, PosY, Width, Height, Color, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Content));
end;
{$endif}

function TPDF.CaretAnnotA(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCaretAnnotA, 'pdfCaretAnnotA');{$endif}
   Result := pdfCaretAnnotA(FInstance, PosX, PosY, Width, Height, Color, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Content));
end;

function TPDF.CaretAnnotW(PosX, PosY, Width, Height: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCaretAnnotW, 'pdfCaretAnnotW');{$endif}
   Result := pdfCaretAnnotW(FInstance, PosX, PosY, Width, Height, Color, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Content));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeAnnotName(Handle: Cardinal; const Name: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeAnnotNameA, 'pdfChangeAnnotNameA');{$endif}
   Result := pdfChangeAnnotNameA(FInstance, Handle, PAnsiChar(Name));
end;

function TPDF.ChangeAnnotName(Handle: Cardinal; const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeAnnotNameW, 'pdfChangeAnnotNameW');{$endif}
   Result := pdfChangeAnnotNameW(FInstance, Handle, PWideChar(Name));
end;
{$endif}

function TPDF.ChangeAnnotNameA(Handle: Cardinal; const Name: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeAnnotNameA, 'pdfChangeAnnotNameA');{$endif}
   Result := pdfChangeAnnotNameA(FInstance, Handle, PAnsiChar(Name));
end;

function TPDF.ChangeAnnotNameW(Handle: Cardinal; const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeAnnotNameW, 'pdfChangeAnnotNameW');{$endif}
   Result := pdfChangeAnnotNameW(FInstance, Handle, PWideChar(Name));
end;

function TPDF.ChangeAnnotPos(Handle: Cardinal; PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeAnnotPos, 'pdfChangeAnnotPos');{$endif}
   Result := pdfChangeAnnotPos(FInstance, Handle, PosX, PosY, Width, Height);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeBookmark(ABmk: Integer; const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeBookmarkA, 'pdfChangeBookmarkA');{$endif}
   Result := pdfChangeBookmarkA(FInstance, ABmk, PAnsiChar(Title), Parent, DestPage, Open);
end;

function TPDF.ChangeBookmark(ABmk: Integer; const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeBookmarkW, 'pdfChangeBookmarkW');{$endif}
   Result := pdfChangeBookmarkW(FInstance, ABmk, PWideChar(Title), Parent, DestPage, Open);
end;
{$endif}

function TPDF.ChangeBookmarkA(ABmk: Integer; const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeBookmarkA, 'pdfChangeBookmarkA');{$endif}
   Result := pdfChangeBookmarkA(FInstance, ABmk, PAnsiChar(Title), Parent, DestPage, Open);
end;

function TPDF.ChangeBookmarkW(ABmk: Integer; const Title: WideString; Parent: Integer; DestPage: Cardinal; Open: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeBookmarkW, 'pdfChangeBookmarkW');{$endif}
   Result := pdfChangeBookmarkW(FInstance, ABmk, PWideChar(Title), Parent, DestPage, Open);
end;

function TPDF.ChangeFont(Handle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeFont, 'pdfChangeFont');{$endif}
   Result := pdfChangeFont(FInstance, Handle);
end;

function TPDF.ChangeFontEx(Handle: Integer; FontSize: Double; Style: TFStyle): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeFontEx, 'pdfChangeFontEx');{$endif}
   Result := pdfChangeFontEx(FInstance, Handle, FontSize, Style);
end;

function TPDF.ChangeFontSize(Size: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeFontSize, 'pdfChangeFontSize');{$endif}
   Result := pdfChangeFontSize(FInstance, Size);
end;

function TPDF.ChangeFontStyle(Style: TFStyle): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeFontStyle, 'pdfChangeFontStyle');{$endif}
   Result := pdfChangeFontStyle(FInstance, Style);
end;

function TPDF.ChangeFontStyleEx(Style: TFStyle): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeFontStyleEx, 'pdfChangeFontStyleEx');{$endif}
   Result := pdfChangeFontStyleEx(FInstance, Style);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeJavaScript(Handle: Cardinal; const NewScript: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptA, 'pdfChangeJavaScriptA');{$endif}
   Result := pdfChangeJavaScriptA(FInstance, Handle, PAnsiChar(NewScript));
end;

function TPDF.ChangeJavaScript(Handle: Cardinal; const NewScript: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptW, 'pdfChangeJavaScriptW');{$endif}
   Result := pdfChangeJavaScriptW(FInstance, Handle, PWideChar(NewScript));
end;
{$endif}

function TPDF.ChangeJavaScriptA(Handle: Cardinal; const NewScript: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptA, 'pdfChangeJavaScriptA');{$endif}
   Result := pdfChangeJavaScriptA(FInstance, Handle, PAnsiChar(NewScript));
end;

function TPDF.ChangeJavaScriptW(Handle: Cardinal; const NewScript: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptW, 'pdfChangeJavaScriptW');{$endif}
   Result := pdfChangeJavaScriptW(FInstance, Handle, PWideChar(NewScript));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeJavaScriptAction(Handle: Cardinal; const NewScript: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptActionA, 'pdfChangeJavaScriptActionA');{$endif}
   Result := pdfChangeJavaScriptActionA(FInstance, Handle, PAnsiChar(NewScript));
end;

function TPDF.ChangeJavaScriptAction(Handle: Cardinal; const NewScript: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptActionW, 'pdfChangeJavaScriptActionW');{$endif}
   Result := pdfChangeJavaScriptActionW(FInstance, Handle, PWideChar(NewScript));
end;
{$endif}

function TPDF.ChangeJavaScriptActionA(Handle: Cardinal; const NewScript: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptActionA, 'pdfChangeJavaScriptActionA');{$endif}
   Result := pdfChangeJavaScriptActionA(FInstance, Handle, PAnsiChar(NewScript));
end;

function TPDF.ChangeJavaScriptActionW(Handle: Cardinal; const NewScript: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptActionW, 'pdfChangeJavaScriptActionW');{$endif}
   Result := pdfChangeJavaScriptActionW(FInstance, Handle, PWideChar(NewScript));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeJavaScriptName(Handle: Cardinal; const Name: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptNameA, 'pdfChangeJavaScriptNameA');{$endif}
   Result := pdfChangeJavaScriptNameA(FInstance, Handle, PAnsiChar(Name));
end;

function TPDF.ChangeJavaScriptName(Handle: Cardinal; const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptNameW, 'pdfChangeJavaScriptNameW');{$endif}
   Result := pdfChangeJavaScriptNameW(FInstance, Handle, PWideChar(Name));
end;
{$endif}

function TPDF.ChangeJavaScriptNameA(Handle: Cardinal; const Name: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptNameA, 'pdfChangeJavaScriptNameA');{$endif}
   Result := pdfChangeJavaScriptNameA(FInstance, Handle, PAnsiChar(Name));
end;

function TPDF.ChangeJavaScriptNameW(Handle: Cardinal; const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeJavaScriptNameW, 'pdfChangeJavaScriptNameW');{$endif}
   Result := pdfChangeJavaScriptNameW(FInstance, Handle, PWideChar(Name));
end;

function TPDF.ChangeLinkAnnot(Handle: Cardinal; const URL: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeLinkAnnot, 'pdfChangeLinkAnnot');{$endif}
   Result := pdfChangeLinkAnnot(FInstance, Handle, PAnsiChar(URL));
end;

function TPDF.ChangeNamedDestA(ObjType: TObjType; Handle: Cardinal; const NewDestName: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeNamedDestA, 'pdfChangeNamedDestA');{$endif}
   Result := pdfChangeNamedDestA(FInstance, ObjType, Handle, PAnsiChar(NewDestName));
end;

function TPDF.ChangeNamedDestW(ObjType: TObjType; Handle: Cardinal; const NewDestName: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeNamedDestW, 'pdfChangeNamedDestW');{$endif}
   Result := pdfChangeNamedDestW(FInstance, ObjType, Handle, PWideChar(NewDestName));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ChangeNamedDest(ObjType: TObjType; Handle: Cardinal; const NewDestName: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeNamedDestW, 'pdfChangeNamedDestW');{$endif}
   Result := pdfChangeNamedDestW(FInstance, ObjType, Handle, PWideChar(NewDestName));
end;

function TPDF.ChangeOCGName(Handle: Cardinal; const Value: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeOCGNameW, 'pdfChangeOCGNameW');{$endif}
   Result := pdfChangeOCGNameW(FInstance, Handle, PWideChar(Value));
end;
{$else}
function TPDF.ChangeOCGNameA(Handle: Cardinal; const Value: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeOCGNameA, 'pdfChangeOCGNameA');{$endif}
   Result := pdfChangeOCGNameA(FInstance, Handle, PAnsiChar(Value));
end;

function TPDF.ChangeOCGNameW(Handle: Cardinal; const Value: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeOCGNameW, 'pdfChangeOCGNameW');{$endif}
   Result := pdfChangeOCGNameW(FInstance, Handle, PWideChar(Value));
end;
{$endif}

function TPDF.ChangeSeparationColor(CSHandle, NewColor: Cardinal; Alternate: TExtColorSpace; AltHandle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfChangeSeparationColor, 'pdfChangeSeparationColor');{$endif}
   Result := pdfChangeSeparationColor(FInstance, CSHandle, NewColor, Alternate, AltHandle);
end;

function TPDF.CheckCollection: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCheckCollection, 'pdfCheckCollection');{$endif}
   Result := pdfCheckCollection(FInstance);
end;

function TPDF.CheckConformance(ConfType: TConformanceType; Options: TCheckOptions; UserData: Pointer; OnFontNotFound: TOnFontNotFoundProc; OnReplaceICCProfile: TOnReplaceICCProfile): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCheckConformance, 'pdfCheckConformance');{$endif}
   Result := pdfCheckConformance(FInstance, Integer(ConfType), Options, UserData, OnFontNotFound, OnReplaceICCProfile);
end;

function TPDF.CheckFieldNames(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCheckFieldNames, 'pdfCheckFieldNames');{$endif}
   Result := pdfCheckFieldNames(FInstance);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CircleAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCircleAnnotA, 'pdfCircleAnnotA');{$endif}
   Result := pdfCircleAnnotA(FInstance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Comment));
end;

function TPDF.CircleAnnot(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCircleAnnotW, 'pdfCircleAnnotW');{$endif}
   Result := pdfCircleAnnotW(FInstance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Comment));
end;
{$endif}

function TPDF.CircleAnnotA(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCircleAnnotA, 'pdfCircleAnnotA');{$endif}
   Result := pdfCircleAnnotA(FInstance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Comment));
end;

function TPDF.CircleAnnotW(PosX, PosY, Width, Height, LineWidth: Double; FillColor, StrokeColor: Cardinal; CS: TPDFColorSpace; const Author, Subject, Comment: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCircleAnnotW, 'pdfCircleAnnotW');{$endif}
   Result := pdfCircleAnnotW(FInstance, PosX, PosY, Width, Height, LineWidth, FillColor, StrokeColor, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Comment));
end;

function TPDF.ClearAutoTemplates: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfClearAutoTemplates, 'pdfClearAutoTemplates');{$endif}
   Result := pdfClearAutoTemplates(FInstance);
end;

procedure TPDF.ClearErrorLog;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfClearErrorLog, 'pdfClearErrorLog');{$endif}
   pdfClearErrorLog(FInstance);
end;

function TPDF.ClearHostFonts(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfClearHostFonts, 'pdfClearHostFonts');{$endif}
   Result := pdfClearHostFonts(FInstance);
end;

function TPDF.ClipPath(ClipMode: TClippingMode; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfClipPath, 'pdfClipPath');{$endif}
   Result := pdfClipPath(FInstance, ClipMode, FillMode);
end;

function TPDF.CloseAndSignFile(const CertFile, Password, Reason, Location: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseAndSignFile, 'pdfCloseAndSignFile');{$endif}
   Result := pdfCloseAndSignFile(FInstance, PAnsiChar(CertFile), PAnsiChar(Password), PAnsiChar(Reason), PAnsiChar(Location));
end;

function TPDF.CloseAndSignFileEx(const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions; const CertFile, Password, Reason, Location: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseAndSignFileEx, 'pdfCloseAndSignFileEx');{$endif}
   Result := pdfCloseAndSignFileEx(FInstance, PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), Ord(KeyLen), Ord(Restrict), PAnsiChar(CertFile), PAnsiChar(Password), PAnsiChar(Reason), PAnsiChar(Location));
end;

function TPDF.CloseAndSignFileExt(var SigParms: TPDFSigParms): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseAndSignFileExt, 'pdfCloseAndSignFileExt');{$endif}
   Result := pdfCloseAndSignFileExt(FInstance, SigParms);
end;

function TPDF.CloseFile(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseFile, 'pdfCloseFile');{$endif}
   Result := pdfCloseFile(FInstance);
end;

function TPDF.CloseFileEx(const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseFileEx, 'pdfCloseFileEx');{$endif}
   Result := pdfCloseFileEx(FInstance, PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), Ord(KeyLen), Ord(Restrict));
end;

function TPDF.CloseImage: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseImage, 'pdfCloseImage');{$endif}
   Result := pdfCloseImage(FInstance);
end;

function TPDF.CloseImportFile(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseImportFile, 'pdfCloseImportFile');{$endif}
   Result := pdfCloseImportFile(FInstance);
end;

function TPDF.CloseImportFileEx(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseImportFileEx, 'pdfCloseImportFileEx');{$endif}
   Result := pdfCloseImportFileEx(FInstance, Handle);
end;

function TPDF.ClosePath(FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfClosePath, 'pdfClosePath');{$endif}
   Result := pdfClosePath(FInstance, FillMode);
end;

function TPDF.CloseTag: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCloseTag, 'pdfCloseTag');{$endif}
   Result := pdfCloseTag(FInstance);
end;

function TPDF.ComputeBBox(var BBox: TPDFRect; Flags: TCompBBoxFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfComputeBBox, 'pdfComputeBBox');{$endif}
   Result := pdfComputeBBox(FInstance, BBox, Flags);
end;

function TPDF.ConvColor(const Color: PDouble; NumComps: Cardinal; SourceCS: TExtColorSpace; const IColorSpace: Pointer; DestCS: TExtColorSpace): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvColor, 'pdfConvColor');{$endif}
   Result := pdfConvColor(Color, NumComps, Integer(SourceCS), IColorSpace, Integer(DestCS));
end;

function TPDF.ConvertColors(Flags: TColorConvFlags; Add: Single): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvertColors, 'pdfConvertColors');{$endif}
   Result := pdfConvertColors(FInstance, Flags, @Add);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.ConvertEMFSpool(const SpoolFile: AnsiString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvertEMFSpoolA, 'pdfConvertEMFSpoolA');{$endif}
   Result := pdfConvertEMFSpoolA(FInstance, PAnsiChar(SpoolFile), LeftMargin, TopMargin, Integer(Flags));
end;

function TPDF.ConvertEMFSpool(const SpoolFile: WideString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvertEMFSpoolW, 'pdfConvertEMFSpoolW');{$endif}
   Result := pdfConvertEMFSpoolW(FInstance, PWideChar(SpoolFile), LeftMargin, TopMargin, Integer(Flags));
end;
{$endif}

function TPDF.ConvertEMFSpoolA(const SpoolFile: AnsiString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvertEMFSpoolA, 'pdfConvertEMFSpoolA');{$endif}
   Result := pdfConvertEMFSpoolA(FInstance, PAnsiChar(SpoolFile), LeftMargin, TopMargin, Integer(Flags));
end;

function TPDF.ConvertEMFSpoolW(const SpoolFile: WideString; LeftMargin, TopMargin: Double; Flags: TSpoolConvFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvertEMFSpoolW, 'pdfConvertEMFSpoolW');{$endif}
   Result := pdfConvertEMFSpoolW(FInstance, PWideChar(SpoolFile), LeftMargin, TopMargin, Integer(Flags));
end;

function TPDF.ConvToFreeTextCallout(Handle: Cardinal; StartX, StartY, KneeOffset: Single; EndStyle: TLineEndStyle): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvToFreeTextCallout, 'pdfConvToFreeTextCallout');{$endif}
   Result := pdfConvToFreeTextCallout(FInstance, Handle, StartX, StartY, KneeOffset, EndStyle);
end;

function TPDF.ConvToUnicode(const AString: AnsiString; CP: TCodepage): WideString;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfConvToUnicode, 'pdfConvToUnicode');{$endif}
   Result := pdfConvToUnicode(FInstance, PAnsiChar(AString), Integer(CP));
end;

function TPDF.CopyChoiceValues(Source, Dest: Cardinal; Share: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCopyChoiceValues, 'pdfCopyChoiceValues');{$endif}
   Result := pdfCopyChoiceValues(FInstance, Source, Dest, Share);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.Create3DAnnot(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DAnnotA, 'pdfCreate3DAnnotA');{$endif}
   Result := pdfCreate3DAnnotA(FInstance, PosX, PosY, Width, Height, PAnsiChar(Author), PAnsiChar(AnnotName), PAnsiChar(U3DFile), PAnsiChar(ImageFile));
end;

function TPDF.Create3DAnnot(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DAnnotW, 'pdfCreate3DAnnotW');{$endif}
   Result := pdfCreate3DAnnotW(FInstance, PosX, PosY, Width, Height, PWideChar(Author), PWideChar(AnnotName), PWideChar(U3DFile), PWideChar(ImageFile));
end;
{$endif}

function TPDF.Create3DAnnotA(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DAnnotA, 'pdfCreate3DAnnotA');{$endif}
   Result := pdfCreate3DAnnotA(FInstance, PosX, PosY, Width, Height, PAnsiChar(Author), PAnsiChar(AnnotName), PAnsiChar(U3DFile), PAnsiChar(ImageFile));
end;

function TPDF.Create3DAnnotW(PosX, PosY, Width, Height: Double; const Author, AnnotName, U3DFile, ImageFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DAnnotW, 'pdfCreate3DAnnotW');{$endif}
   Result := pdfCreate3DAnnotW(FInstance, PosX, PosY, Width, Height, PWideChar(Author), PWideChar(AnnotName), PWideChar(U3DFile), PWideChar(ImageFile));
end;

function TPDF.Create3DBackground(const IView: Pointer; BackColor: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DBackground, 'pdfCreate3DBackground');{$endif}
   Result := pdfCreate3DBackground(FInstance, IView, BackColor);
end;

function TPDF.Create3DGotoViewAction(Base3DAnnot: Cardinal; const IView: Pointer; Named: T3DNamedAction): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DGotoViewAction, 'pdfCreate3DGotoViewAction');{$endif}
   Result := pdfCreate3DGotoViewAction(FInstance, Base3DAnnot, IView, Integer(Named));
end;

function TPDF.Create3DProjection(const IView: Pointer; ProjType: T3DProjType; ScaleType: T3DScaleType; Diameter, FOV: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DProjection, 'pdfCreate3DProjection');{$endif}
   Result := pdfCreate3DProjection(FInstance, IView, Integer(ProjType), Integer(ScaleType), Diameter, FOV);
end;

function TPDF.Create3DView(Base3DAnnot: Cardinal; const Name: WideString; SetAsDefault: Boolean; Matrix: PDouble; CamDistance: Double; RM: T3DRenderingMode; LS: T3DLightingSheme): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreate3DViewW, 'pdfCreate3DViewW');{$endif}
   Result := pdfCreate3DViewW(FInstance, Base3DAnnot, PWideChar(WideString(Name)), SetAsDefault, Matrix, CamDistance, RM, LS);
end;

function TPDF.CreateAltFontList: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateAltFontList, 'pdfCreateAltFontList');{$endif}
   Result := pdfCreateAltFontList(FInstance);
end;

function TPDF.CreateAnnotAP(Annot: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateAnnotAP, 'pdfCreateAnnotAP');{$endif}
   Result := pdfCreateAnnotAP(FInstance, Annot);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateArticleThread(const ThreadName: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateArticleThreadA, 'pdfCreateArticleThreadA');{$endif}
   Result := pdfCreateArticleThreadA(FInstance, PAnsiChar(ThreadName));
end;

function TPDF.CreateArticleThread(const ThreadName: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateArticleThreadW, 'pdfCreateArticleThreadW');{$endif}
   Result := pdfCreateArticleThreadW(FInstance, PWideChar(ThreadName));
end;
{$endif}

function TPDF.CreateArticleThreadA(const ThreadName: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateArticleThreadA, 'pdfCreateArticleThreadA');{$endif}
   Result := pdfCreateArticleThreadA(FInstance, PAnsiChar(ThreadName));
end;

function TPDF.CreateArticleThreadW(const ThreadName: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateArticleThreadW, 'pdfCreateArticleThreadW');{$endif}
   Result := pdfCreateArticleThreadW(FInstance, PWideChar(ThreadName));
end;

function TPDF.CreateAxialShading(sX, sY, eX, eY, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateAxialShading, 'pdfCreateAxialShading');{$endif}
   Result := pdfCreateAxialShading(FInstance, sX, sY, eX, eY, SCenter, SColor, EColor, Integer(Extend1), Integer(Extend2));
end;

function TPDF.CreateBarcodeField(const Name: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double; var Barcode: TPDFBarcode): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateBarcodeField, 'pdfCreateBarcodeField');{$endif}
   Barcode.StructSize := sizeof(TPDFBarcode);
   Result := pdfCreateBarcodeField(FInstance, PAnsiChar(Name), Parent, PosX, PosY, Width, Height, Barcode);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateButton(const Name, Caption: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateButtonA, 'pdfCreateButtonA');{$endif}
   Result := pdfCreateButtonA(FInstance, PAnsiChar(Name), PAnsiChar(Caption), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateButton(const Name: AnsiString; const Caption: WideString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateButtonW, 'pdfCreateButtonW');{$endif}
   Result := pdfCreateButtonW(FInstance, PAnsiChar(Name), PWideChar(Caption), Parent, PosX, PosY, Width, Height);
end;
{$endif}

function TPDF.CreateButtonA(const Name, Caption: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateButtonA, 'pdfCreateButtonA');{$endif}
   Result := pdfCreateButtonA(FInstance, PAnsiChar(Name), PAnsiChar(Caption), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateButtonW(const Name: AnsiString; const Caption: WideString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateButtonW, 'pdfCreateButtonW');{$endif}
   Result := pdfCreateButtonW(FInstance, PAnsiChar(Name), PWideChar(Caption), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateCheckBox(const Name, ExpValue: AnsiString; Checked: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCheckBox, 'pdfCreateCheckBox');{$endif}
   Result := pdfCreateCheckBox(FInstance, PAnsiChar(Name), PAnsiChar(ExpValue), Integer(Checked), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateCIEColorSpace(Base: TExtColorSpace; WhitePoint, BlackPoint, Gamma, Matrix: PSingle): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCIEColorSpace, 'pdfCreateCIEColorSpace');{$endif}
   Result := pdfCreateCIEColorSpace(FInstance, Base, WhitePoint, BlackPoint, Gamma, Matrix);
end;

function TPDF.CreateCollection(View: TColView): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCollection, 'pdfCreateCollection');{$endif}
   Result := pdfCreateCollection(FInstance, Integer(View));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateCollectionField(ColType: TColColumnType; Column: Integer; const Name, Key: AnsiString; Visible, Editable: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCollectionFieldA, 'pdfCreateCollectionFieldA');{$endif}
   Result := pdfCreateCollectionFieldA(FInstance, Integer(ColType), Column, PAnsiChar(Name), PAnsiChar(Key), Visible, Editable);
end;

function TPDF.CreateCollectionField(ColType: TColColumnType; Column: Integer; const Name: WideString; const Key: AnsiString; Visible, Editable: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCollectionFieldW, 'pdfCreateCollectionFieldW');{$endif}
   Result := pdfCreateCollectionFieldW(FInstance, Integer(ColType), Column, PWideChar(Name), PAnsiChar(Key), Visible, Editable);
end;
{$endif}

function TPDF.CreateCollectionFieldA(ColType: TColColumnType; Column: Integer; const Name, Key: AnsiString; Visible, Editable: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCollectionFieldA, 'pdfCreateCollectionFieldA');{$endif}
   Result := pdfCreateCollectionFieldA(FInstance, Integer(ColType), Column, PAnsiChar(Name), PAnsiChar(Key), Visible, Editable);
end;

function TPDF.CreateCollectionFieldW(ColType: TColColumnType; Column: Integer; const Name: WideString; const Key: AnsiString; Visible, Editable: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateCollectionFieldW, 'pdfCreateCollectionFieldW');{$endif}
   Result := pdfCreateCollectionFieldW(FInstance, Integer(ColType), Column, PWideChar(Name), PAnsiChar(Key), Visible, Editable);
end;

function TPDF.CreateColItemDate(EmbFile: Cardinal; const Key: AnsiString; Date: LongInt; const Prefix: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemDate, 'pdfCreateColItemDate');{$endif}
   Result := pdfCreateColItemDate(FInstance, EmbFile, PAnsiChar(Key), Date, PAnsiChar(Prefix));
end;

function TPDF.CreateColItemNumber(EmbFile: Cardinal; const Key: AnsiString; Value: Double; const Prefix: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemNumber, 'pdfCreateColItemNumber');{$endif}
   Result := pdfCreateColItemNumber(FInstance, EmbFile, PAnsiChar(Key), Value, PAnsiChar(Prefix));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateColItemString(EmbFile: Cardinal; const Key, Value, Prefix: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemStringA, 'pdfCreateColItemStringA');{$endif}
   Result := pdfCreateColItemStringA(FInstance, EmbFile, PAnsiChar(Key), PAnsiChar(Value), PAnsiChar(Prefix));
end;

function TPDF.CreateColItemString(EmbFile: Cardinal; const Key: AnsiString; const Value, Prefix: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemStringW, 'pdfCreateColItemStringW');{$endif}
   Result := pdfCreateColItemStringW(FInstance, EmbFile, PAnsiChar(Key), PWideChar(Value), PWideChar(Prefix));
end;
{$endif}

function TPDF.CreateColItemStringA(EmbFile: Cardinal; const Key, Value, Prefix: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemStringA, 'pdfCreateColItemStringA');{$endif}
   Result := pdfCreateColItemStringA(FInstance, EmbFile, PAnsiChar(Key), PAnsiChar(Value), PAnsiChar(Prefix));
end;

function TPDF.CreateColItemStringW(EmbFile: Cardinal; const Key: AnsiString; const Value, Prefix: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateColItemStringW, 'pdfCreateColItemStringW');{$endif}
   Result := pdfCreateColItemStringW(FInstance, EmbFile, PAnsiChar(Key), PWideChar(Value), PWideChar(Prefix));
end;

function TPDF.CreateComboBox(const Name: AnsiString; Sort: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateComboBox, 'pdfCreateComboBox');{$endif}
   Result := pdfCreateComboBox(FInstance, PAnsiChar(Name), Integer(Sort), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateDeviceNColorSpace(const Colorants: Array of PAnsiChar; NumColorants: Cardinal; const PostScriptFunc: AnsiString; Alternate: TExtColorSpace; Handle: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateDeviceNColorSpace, 'pdfCreateDeviceNColorSpace');{$endif}
   Result := pdfCreateDeviceNColorSpace(FInstance, PPAnsiChar(@Colorants[0]), NumColorants, PAnsiChar(PostScriptFunc), Alternate, Handle);
end;

function TPDF.CreateDPartRoot(const NodeNameList: Array of PAnsiChar; NodeNamesCount: Cardinal; RecordLevel: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateDPartRoot, 'pdfCreateDPartRoot');{$endif}
   Result := pdfCreateDPartRoot(FInstance, PPAnsiChar(@NodeNameList[0]), NodeNamesCount, RecordLevel);
end;

function TPDF.CreateExtGState(var GS: TPDFExtGState): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateExtGState, 'pdfCreateExtGState');{$endif}
   Result := pdfCreateExtGState(FInstance, GS);
end;

function TPDF.CreateGeospatialMeasure(Viewport: Cardinal; const Attributes: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGeospatialMeasure, 'pdfCreateGeospatialMeasure');{$endif}
   Result := pdfCreateGeospatialMeasure(FInstance, Viewport, PAnsiChar(Attributes));
end;

function TPDF.CreateGoToAction(DestType: TDestType; PageNum: Cardinal; a, b, c, d: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToAction, 'pdfCreateGoToAction');{$endif}
   Result := pdfCreateGoToAction(FInstance, DestType, PageNum, a, b, c, d);
end;

function TPDF.CreateGoToActionEx(NamedDest: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToActionEx, 'pdfCreateGoToActionEx');{$endif}
   Result := pdfCreateGoToActionEx(FInstance, NamedDest);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateGoToEAction(Location: TEmbFileLocation; const Source: AnsiString; SrcPage: Cardinal; const Target, DestName: AnsiString; DestPage: Cardinal; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToEActionA, 'pdfCreateGoToEActionA');{$endif}
   Result := pdfCreateGoToEActionA(FInstance, Location, PAnsiChar(Source), SrcPage, PAnsiChar(Target), PAnsiChar(DestName), DestPage, NewWindow);
end;

function TPDF.CreateGoToEAction(Location: TEmbFileLocation; const Source: WideString; SrcPage: Cardinal; const Target, DestName: WideString; DestPage: Cardinal; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToEActionW, 'pdfCreateGoToEActionW');{$endif}
   Result := pdfCreateGoToEActionW(FInstance, Location, PWideChar(Source), SrcPage, PWideChar(Target), PWideChar(DestName), DestPage, NewWindow);
end;
{$endif}

function TPDF.CreateGoToEActionA(Location: TEmbFileLocation; const Source: AnsiString; SrcPage: Cardinal; const Target, DestName: AnsiString; DestPage: Cardinal; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToEActionA, 'pdfCreateGoToEActionA');{$endif}
   Result := pdfCreateGoToEActionA(FInstance, Location, PAnsiChar(Source), SrcPage, PAnsiChar(Target), PAnsiChar(DestName), DestPage, NewWindow);
end;

function TPDF.CreateGoToEActionW(Location: TEmbFileLocation; const Source: WideString; SrcPage: Cardinal; const Target, DestName: WideString; DestPage: Cardinal; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToEActionW, 'pdfCreateGoToEActionW');{$endif}
   Result := pdfCreateGoToEActionW(FInstance, Location, PWideChar(Source), SrcPage, PWideChar(Target), PWideChar(DestName), DestPage, NewWindow);
end;

function TPDF.CreateGoToRAction(const FileName: AnsiString; PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRAction, 'pdfCreateGoToRAction');{$endif}
   Result := pdfCreateGoToRAction(FInstance, PAnsiChar(FileName), PageNum);
end;

function TPDF.CreateGoToRActionW(const FileName: WideString; PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionW, 'pdfCreateGoToRActionW');{$endif}
   Result := pdfCreateGoToRActionW(FInstance, PWideChar(FileName), PageNum);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateGoToRAction(const FileName: WideString; PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionW, 'pdfCreateGoToRActionW');{$endif}
   Result := pdfCreateGoToRActionW(FInstance, PWideChar(FileName), PageNum);
end;

function TPDF.CreateGoToRActionEx(const FileName: AnsiString; DestName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExA, 'pdfCreateGoToRActionExA');{$endif}
   Result := pdfCreateGoToRActionExA(FInstance, PAnsiChar(FileName), PAnsiChar(DestName), NewWindow);
end;

function TPDF.CreateGoToRActionEx(const FileName: AnsiString; DestName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExW, 'pdfCreateGoToRActionExW');{$endif}
   Result := pdfCreateGoToRActionExW(FInstance, PAnsiChar(FileName), PWideChar(DestName), NewWindow);
end;
{$endif}

function TPDF.CreateGoToRActionExA(const FileName: AnsiString; DestName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExA, 'pdfCreateGoToRActionExA');{$endif}
   Result := pdfCreateGoToRActionExA(FInstance, PAnsiChar(FileName), PAnsiChar(DestName), NewWindow);
end;

function TPDF.CreateGoToRActionExW(const FileName: AnsiString; DestName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExW, 'pdfCreateGoToRActionExW');{$endif}
   Result := pdfCreateGoToRActionExW(FInstance, PAnsiChar(FileName), PWideChar(DestName), NewWindow);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateGoToRActionExU(const FileName: WideString; DestName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExUA, 'pdfCreateGoToRActionExUA');{$endif}
   Result := pdfCreateGoToRActionExUA(FInstance, PWideChar(FileName), PAnsiChar(DestName), NewWindow);
end;

function TPDF.CreateGoToRActionExU(const FileName: WideString; DestName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExUW, 'pdfCreateGoToRActionExUW');{$endif}
   Result := pdfCreateGoToRActionExUW(FInstance, PWideChar(FileName), PWideChar(DestName), NewWindow);
end;
{$endif}

function TPDF.CreateGoToRActionExUA(const FileName: WideString; DestName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExUA, 'pdfCreateGoToRActionExUA');{$endif}
   Result := pdfCreateGoToRActionExUA(FInstance, PWideChar(FileName), PAnsiChar(DestName), NewWindow);
end;

function TPDF.CreateGoToRActionExUW(const FileName: WideString; DestName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGoToRActionExUW, 'pdfCreateGoToRActionExUW');{$endif}
   Result := pdfCreateGoToRActionExUW(FInstance, PWideChar(FileName), PWideChar(DestName), NewWindow);
end;

function TPDF.CreateGroupField(const Name: AnsiString; Parent: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateGroupField, 'pdfCreateGroupField');{$endif}
   Result := pdfCreateGroupField(FInstance, PAnsiChar(Name), Parent);
end;

function TPDF.CreateHideAction(AField: Cardinal; Hide: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateHideAction, 'pdfCreateHideAction');{$endif}
   Result := pdfCreateHideAction(FInstance, AField, Hide);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateICCBasedColorSpace(const ICCProfile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateICCBasedColorSpaceA, 'pdfCreateICCBasedColorSpaceA');{$endif}
   Result := pdfCreateICCBasedColorSpaceA(FInstance, PAnsiChar(ICCProfile));
end;

function TPDF.CreateICCBasedColorSpace(const ICCProfile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateICCBasedColorSpaceW, 'pdfCreateICCBasedColorSpaceW');{$endif}
   Result := pdfCreateICCBasedColorSpaceW(FInstance, PWideChar(ICCProfile));
end;
{$endif}

function TPDF.CreateICCBasedColorSpaceA(const ICCProfile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateICCBasedColorSpaceA, 'pdfCreateICCBasedColorSpaceA');{$endif}
   Result := pdfCreateICCBasedColorSpaceA(FInstance, PAnsiChar(ICCProfile));
end;

function TPDF.CreateICCBasedColorSpaceW(const ICCProfile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateICCBasedColorSpaceW, 'pdfCreateICCBasedColorSpaceW');{$endif}
   Result := pdfCreateICCBasedColorSpaceW(FInstance, PWideChar(ICCProfile));
end;

function TPDF.CreateICCBasedColorSpaceEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateICCBasedColorSpaceEx, 'pdfCreateICCBasedColorSpaceEx');{$endif}
   Result := pdfCreateICCBasedColorSpaceEx(FInstance, Buffer, BufSize);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateImage(const FileName: AnsiString; Format: TImageFormat): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImageA, 'pdfCreateImageA');{$endif}
   Result := pdfCreateImageA(FInstance, PAnsiChar(FileName), Format);
end;

function TPDF.CreateImage(const FileName: WideString; Format: TImageFormat): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImageW, 'pdfCreateImageW');{$endif}
   Result := pdfCreateImageW(FInstance, PWideChar(FileName), Format);
end;
{$endif}

function TPDF.CreateImageA(const FileName: AnsiString; Format: TImageFormat): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImageA, 'pdfCreateImageA');{$endif}
   Result := pdfCreateImageA(FInstance, PAnsiChar(FileName), Format);
end;

function TPDF.CreateImageW(const FileName: WideString; Format: TImageFormat): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImageW, 'pdfCreateImageW');{$endif}
   Result := pdfCreateImageW(FInstance, PWideChar(FileName), Format);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateImpDataAction(const DataFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImpDataActionA, 'pdfCreateImpDataActionA');{$endif}
   Result := pdfCreateImpDataActionA(FInstance, PAnsiChar(DataFile));
end;

function TPDF.CreateImpDataAction(const DataFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImpDataActionW, 'pdfCreateImpDataActionW');{$endif}
   Result := pdfCreateImpDataActionW(FInstance, PWideChar(DataFile));
end;
{$endif}

function TPDF.CreateImpDataActionA(const DataFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImpDataActionA, 'pdfCreateImpDataActionA');{$endif}
   Result := pdfCreateImpDataActionA(FInstance, PAnsiChar(DataFile));
end;

function TPDF.CreateImpDataActionW(const DataFile: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateImpDataActionW, 'pdfCreateImpDataActionW');{$endif}
   Result := pdfCreateImpDataActionW(FInstance, PWideChar(DataFile));
end;

function TPDF.CreateIndexedColorSpace(Base: TExtColorSpace; Handle: Integer; const ColorTable: Pointer; NumColors: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateIndexedColorSpace, 'pdfCreateIndexedColorSpace');{$endif}
   Result := pdfCreateIndexedColorSpace(FInstance, Integer(Base), Handle, ColorTable, NumColors);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateJSAction(const Script: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateJSActionA, 'pdfCreateJSActionA');{$endif}
   Result := pdfCreateJSActionA(FInstance, PAnsiChar(Script));
end;

function TPDF.CreateJSAction(const Script: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateJSActionW, 'pdfCreateJSActionW');{$endif}
   Result := pdfCreateJSActionW(FInstance, PWideChar(Script));
end;
{$endif}

function TPDF.CreateJSActionA(const Script: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateJSActionA, 'pdfCreateJSActionA');{$endif}
   Result := pdfCreateJSActionA(FInstance, PAnsiChar(Script));
end;

function TPDF.CreateJSActionW(const Script: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateJSActionW, 'pdfCreateJSActionW');{$endif}
   Result := pdfCreateJSActionW(FInstance, PWideChar(Script));
end;

function TPDF.CreateLaunchAction(OP: TFileOP; const FileName, DefDir, Param: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateLaunchAction, 'pdfCreateLaunchAction');{$endif}
   Result := pdfCreateLaunchAction(FInstance, Ord(OP), PAnsiChar(FileName), PAnsiChar(DefDir), PAnsiChar(Param), NewWindow);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateLaunchActionEx(const FileName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateLaunchActionExA, 'pdfCreateLaunchActionExA');{$endif}
   Result := pdfCreateLaunchActionExA(FInstance, PAnsiChar(FileName), NewWindow);
end;

function TPDF.CreateLaunchActionEx(const FileName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateLaunchActionExW, 'pdfCreateLaunchActionExW');{$endif}
   Result := pdfCreateLaunchActionExW(FInstance, PWideChar(FileName), NewWindow);
end;
{$endif}

function TPDF.CreateLaunchActionExA(const FileName: AnsiString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateLaunchActionExA, 'pdfCreateLaunchActionExA');{$endif}
   Result := pdfCreateLaunchActionExA(FInstance, PAnsiChar(FileName), NewWindow);
end;

function TPDF.CreateLaunchActionExW(const FileName: WideString; NewWindow: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateLaunchActionExW, 'pdfCreateLaunchActionExW');{$endif}
   Result := pdfCreateLaunchActionExW(FInstance, PWideChar(FileName), NewWindow);
end;

function TPDF.CreateListBox(const Name: PAnsiChar; Sort: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateListBox, 'pdfCreateListBox');{$endif}
   Result := pdfCreateListBox(FInstance, PAnsiChar(Name), Sort, Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateNamedAction(Action: TNamedAction): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNamedAction, 'pdfCreateNamedAction');{$endif}
   Result := pdfCreateNamedAction(FInstance, Ord(Action));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateNamedDest(const Name: AnsiString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNamedDestA, 'pdfCreateNamedDestA');{$endif}
   Result := pdfCreateNamedDestA(FInstance, PAnsiChar(Name), DestPage, DestType, a, b, c, d);
end;

function TPDF.CreateNamedDest(const Name: WideString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNamedDestW, 'pdfCreateNamedDestW');{$endif}
   Result := pdfCreateNamedDestW(FInstance, PWideChar(Name), DestPage, DestType, a, b, c, d);
end;
{$endif}

function TPDF.CreateNamedDestA(const Name: AnsiString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNamedDestA, 'pdfCreateNamedDestA');{$endif}
   Result := pdfCreateNamedDestA(FInstance, PAnsiChar(Name), DestPage, DestType, a, b, c, d);
end;

function TPDF.CreateNamedDestW(const Name: WideString; DestPage: Cardinal; DestType: TDestType; a, b, c, d: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNamedDestW, 'pdfCreateNamedDestW');{$endif}
   Result := pdfCreateNamedDestW(FInstance, PWideChar(Name), DestPage, DestType, a, b, c, d);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateNewPDF(const OutPDF: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNewPDFA, 'pdfCreateNewPDFA');{$endif}
   Result := pdfCreateNewPDFA(FInstance, PAnsiChar(OutPDF));
end;

function TPDF.CreateNewPDF(const OutPDF: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNewPDFW, 'pdfCreateNewPDFW');{$endif}
   Result := pdfCreateNewPDFW(FInstance, PWideChar(OutPDF));
end;
{$endif}

function TPDF.CreateNewPDFA(const OutPDF: AnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNewPDFA, 'pdfCreateNewPDFA');{$endif}
   Result := pdfCreateNewPDFA(FInstance, PAnsiChar(OutPDF));
end;

function TPDF.CreateNewPDFW(const OutPDF: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateNewPDFW, 'pdfCreateNewPDFW');{$endif}
   Result := pdfCreateNewPDFW(FInstance, PWideChar(OutPDF));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateOCG(const Name: AnsiString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateOCGA, 'pdfCreateOCGA');{$endif}
   Result := pdfCreateOCGA(FInstance, PAnsiChar(Name), DisplayInUI, Visible, Intent);
end;

function TPDF.CreateOCG(const Name: WideString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateOCGW, 'pdfCreateOCGW');{$endif}
   Result := pdfCreateOCGW(FInstance, PWideChar(Name), DisplayInUI, Visible, Intent);
end;
{$endif}

function TPDF.CreateOCGA(const Name: AnsiString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateOCGA, 'pdfCreateOCGA');{$endif}
   Result := pdfCreateOCGA(FInstance, PAnsiChar(Name), DisplayInUI, Visible, Intent);
end;

function TPDF.CreateOCGW(const Name: WideString; DisplayInUI, Visible: Boolean; Intent: TOCGIntent): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateOCGW, 'pdfCreateOCGW');{$endif}
   Result := pdfCreateOCGW(FInstance, PWideChar(Name), DisplayInUI, Visible, Intent);
end;

function TPDF.CreateOCMD(Visibility: TOCVisibility; const OCGs: PCardinal; Count: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateOCMD, 'pdfCreateOCMD');{$endif}
   Result := pdfCreateOCMD(FInstance, Visibility, OCGs, Count);
end;

function TPDF.CreateRadialShading(sX, sY, R1, eX, eY, R2, SCenter: Double; SColor, EColor: Cardinal; Extend1, Extend2: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRadialShading, 'pdfCreateRadialShading');{$endif}
   Result := pdfCreateRadialShading(FInstance, sX, sY, R1, eX, eY, R2, SCenter, SColor, EColor, Integer(Extend1), Integer(Extend2));
end;

function TPDF.CreateRadioButton(const Name, ExpValue: AnsiString; Checked: Boolean; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRadioButton, 'pdfCreateRadioButton');{$endif}
   Result := pdfCreateRadioButton(FInstance, PAnsiChar(Name), PAnsiChar(ExpValue), Integer(Checked), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateRasterizer(Rows: PPointer; Buffer: Pointer; Width, Height: Cardinal; ScanlineLen: Integer; PixelFormat: TPDFPixFormat): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@rasCreateRasterizer, 'rasCreateRasterizer');{$endif}
   Result := rasCreateRasterizer(FInstance, Rows, Buffer, Width, Height, ScanlineLen, PixelFormat);
end;

function TPDF.CreateRasterizerEx(DC: HDC; Width, Height: Cardinal; PixFmt: TPDFPixFormat): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@rasCreateRasterizerEx, 'rasCreateRasterizerEx');{$endif}
   Result := rasCreateRasterizerEx(FInstance, DC, Width, Height, PixFmt);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.CreateRectilinearMeasure(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRectilinearMeasureA, 'pdfCreateRectilinearMeasureA');{$endif}
   Result := pdfCreateRectilinearMeasureA(FInstance, Viewport, Scale, PAnsiChar(UnitDescription), PAnsiChar(LabelDistance), PAnsiChar(LabelArea));
end;

function TPDF.CreateRectilinearMeasure(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRectilinearMeasureW, 'pdfCreateRectilinearMeasureW');{$endif}
   Result := pdfCreateRectilinearMeasureW(FInstance, Viewport, Scale, PWideChar(UnitDescription), PWideChar(LabelDistance), PWideChar(LabelArea));
end;
{$endif}

function TPDF.CreateRectilinearMeasureA(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRectilinearMeasureA, 'pdfCreateRectilinearMeasureA');{$endif}
   Result := pdfCreateRectilinearMeasureA(FInstance, Viewport, Scale, PAnsiChar(UnitDescription), PAnsiChar(LabelDistance), PAnsiChar(LabelArea));
end;

function TPDF.CreateRectilinearMeasureW(Viewport: Cardinal; Scale: Double; const UnitDescription, LabelDistance, LabelArea: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateRectilinearMeasureW, 'pdfCreateRectilinearMeasureW');{$endif}
   Result := pdfCreateRectilinearMeasureW(FInstance, Viewport, Scale, PWideChar(UnitDescription), PWideChar(LabelDistance), PWideChar(LabelArea));
end;

function TPDF.CreateResetAction(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateResetAction, 'pdfCreateResetAction');{$endif}
   Result := pdfCreateResetAction(FInstance);
end;

function TPDF.CreateSeparationCS(const Colorant: AnsiString; Alternate: TExtColorSpace; Handle: Integer; Color: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSeparationCS, 'pdfCreateSeparationCS');{$endif}
   Result := pdfCreateSeparationCS(FInstance, PAnsiChar(Colorant), Integer(Alternate), Handle, Color);
end;

function TPDF.CreateSetOCGStateAction(const On_: PCardinal; OnCount: Cardinal; const Off: PCardinal; OffCount: Cardinal; const Toggle: PCardinal; ToggleCount: Cardinal; PreserveRB: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSetOCGStateAction, 'pdfCreateSetOCGStateAction');{$endif}
   Result := pdfCreateSetOCGStateAction(FInstance, On_, OnCount, Off, OffCount, Toggle, ToggleCount, PreserveRB);
end;

function TPDF.CreateSigField(const Name: AnsiString; Parent: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSigField, 'pdfCreateSigField');{$endif}
   Result := pdfCreateSigField(FInstance, PAnsiChar(Name), Parent, PosX, PosY, Width, Height);
end;

function TPDF.CreateSigFieldAP(SigField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSigFieldAP, 'pdfCreateSigFieldAP');{$endif}
   Result := pdfCreateSigFieldAP(FInstance, SigField);
end;

function TPDF.CreateSoftMask(TranspGroup: Cardinal; MaskType: TSoftMaskType; BackColor: Cardinal): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSoftMask, 'pdfCreateSoftMask');{$endif}
   Result := pdfCreateSoftMask(FInstance, TranspGroup, MaskType, BackColor);
end;

function TPDF.CreateStdPattern(Pattern: TStdPattern; LineWidth, Distance: Double; LineColor, BackColor: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateStdPattern, 'pdfCreateStdPattern');{$endif}
   Result := pdfCreateStdPattern(FInstance, Ord(Pattern), LineWidth, Distance, LineColor, BackColor);
end;

function TPDF.CreateStructureTree: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateStructureTreeEx, 'pdfCreateStructureTreeEx');{$endif}
   Result := pdfCreateStructureTreeEx(FInstance, btTOCEntry {Dummy value will be ignored});
end;

function TPDF.CreateStructureTreeEx(RootTag: TPDFBaseTag): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateStructureTreeEx, 'pdfCreateStructureTreeEx');{$endif}
   Result := pdfCreateStructureTreeEx(FInstance, RootTag);
end;

function TPDF.CreateSubmitAction(Flags: TSubmitFlags; const URL: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateSubmitAction, 'pdfCreateSubmitAction');{$endif}
   Result := pdfCreateSubmitAction(FInstance, Flags, PAnsiChar(URL));
end;

function TPDF.CreateTextField(const Name: AnsiString; Parent: Integer; Multiline: Boolean; MaxLen: Integer; PosX, PosY, Width, Height: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateTextField, 'pdfCreateTextField');{$endif}
   Result := pdfCreateTextField(FInstance, PAnsiChar(Name), Parent, Integer(Multiline), MaxLen, PosX, PosY, Width, Height);
end;

function TPDF.CreateURIAction(const URL: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateURIAction, 'pdfCreateURIAction');{$endif}
   Result := pdfCreateURIAction(FInstance, PAnsiChar(URL));
end;

function TPDF.CreateViewportA(const Name: AnsiString; X1, Y1, X2, Y2: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateViewportA, 'pdfCreateViewportA');{$endif}
   Result := pdfCreateViewportA(FInstance, PAnsiChar(Name), X1, Y1, X2, Y2);
end;

function TPDF.CreateViewportW(const Name: WideString; X1, Y1, X2, Y2: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateViewportW, 'pdfCreateViewportW');{$endif}
   Result := pdfCreateViewportW(FInstance, PWideChar(Name), X1, Y1, X2, Y2);
end;

function TPDF.CreateXFAStreamA(const Name: AnsiString; const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateXFAStreamA, 'pdfCreateXFAStreamA');{$endif}
   Result := pdfCreateXFAStreamA(FInstance, PAnsiChar(Name), Buffer, BufSize);
end;

function TPDF.CreateXFAStreamW(const Name: WideString; const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateXFAStreamW, 'pdfCreateXFAStreamW');{$endif}
   Result := pdfCreateXFAStreamW(FInstance, PWideChar(Name), Buffer, BufSize);
end;

{$ifdef DELPHI6_OR_HIGHER}

function TPDF.CreateViewport(const Name: AnsiString; X1, Y1, X2, Y2: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateViewportA, 'pdfCreateViewportA');{$endif}
   Result := pdfCreateViewportA(FInstance, PAnsiChar(Name), X1, Y1, X2, Y2);
end;

function TPDF.CreateViewport(const Name: WideString; X1, Y1, X2, Y2: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateViewportW, 'pdfCreateViewportW');{$endif}
   Result := pdfCreateViewportW(FInstance, PWideChar(Name), X1, Y1, X2, Y2);
end;

function TPDF.CreateXFAStream(const Name: AnsiString; const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateXFAStreamA, 'pdfCreateXFAStreamA');{$endif}
   Result := pdfCreateXFAStreamA(FInstance, PAnsiChar(Name), Buffer, BufSize);
end;

function TPDF.CreateXFAStream(const Name: WideString; const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfCreateXFAStreamW, 'pdfCreateXFAStreamW');{$endif}
   Result := pdfCreateXFAStreamW(FInstance, PWideChar(Name), Buffer, BufSize);
end;

function TPDF.DecryptPDF(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDecryptPDFA, 'pdfDecryptPDFA');{$endif}
   Result := pdfDecryptPDFA(FInstance, PAnsiChar(FileName), Ord(PwdType), PAnsiChar(Password));
end;

function TPDF.DecryptPDF(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDecryptPDFW, 'pdfDecryptPDFW');{$endif}
   Result := pdfDecryptPDFW(FInstance, PWideChar(FileName), Ord(PwdType), PAnsiChar(Password));
end;
{$endif}

function TPDF.DecryptPDFA(const FileName: AnsiString; PwdType: TPwdType; const Password: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDecryptPDFA, 'pdfDecryptPDFA');{$endif}
   Result := pdfDecryptPDFA(FInstance, PAnsiChar(FileName), Ord(PwdType), PAnsiChar(Password));
end;

function TPDF.DecryptPDFW(const FileName: WideString; PwdType: TPwdType; const Password: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDecryptPDFW, 'pdfDecryptPDFW');{$endif}
   Result := pdfDecryptPDFW(FInstance, PWideChar(FileName), Ord(PwdType), PAnsiChar(Password));
end;

procedure TPDF.DeleteAcroForm;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteAcroForm, 'pdfDeleteAcroForm');{$endif}
   pdfDeleteAcroForm(FInstance);
end;

function TPDF.DeleteActionFromObj(ObjType: TObjType; ActHandle, ObjHandle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteActionFromObj, 'pdfDeleteActionFromObj');{$endif}
   Result := pdfDeleteActionFromObj(FInstance, Ord(ObjType), ActHandle, ObjHandle);
end;

function TPDF.DeleteActionFromObjEx(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteActionFromObjEx, 'pdfDeleteActionFromObjEx');{$endif}
   Result := pdfDeleteActionFromObjEx(FInstance, Ord(ObjType), ObjHandle, ActIndex);
end;

function TPDF.DeleteAltFontList(Handle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteAltFontList, 'pdfDeleteAltFontList');{$endif}
   Result := pdfDeleteAltFontList(FInstance, Handle);
end;

function TPDF.DeleteAnnotation(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteAnnotation, 'pdfDeleteAnnotation');{$endif}
   Result := pdfDeleteAnnotation(FInstance, Handle);
end;

function TPDF.DeleteAnnotationFromPage(PageNum, Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteAnnotationFromPage, 'pdfDeleteAnnotationFromPage');{$endif}
   Result := pdfDeleteAnnotationFromPage(FInstance, PageNum, Handle);
end;

function TPDF.DeleteAppEvents(ApplyEvent: Boolean; Event: TOCAppEvent): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteAppEvents, 'pdfDeleteAppEvents');{$endif}
   Result := pdfDeleteAppEvents(FInstance, ApplyEvent, Event);
end;

function TPDF.DeleteBookmark(ABmk: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteBookmark, 'pdfDeleteBookmark');{$endif}
   Result := pdfDeleteBookmark(FInstance, ABmk);
end;

function TPDF.DeleteDPartNode(Handle: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteDPartNode, 'pdfDeleteDPartNode');{$endif}
   Result := pdfDeleteDPartNode(FInstance, Handle);
end;

function TPDF.DeleteEmbeddedFile(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteEmbeddedFile, 'pdfDeleteEmbeddedFile');{$endif}
   Result := pdfDeleteEmbeddedFile(FInstance, Handle);
end;

function TPDF.DeleteField(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteField, 'pdfDeleteField');{$endif}
   Result := pdfDeleteField(FInstance, AField);
end;

function TPDF.DeleteFieldEx(const Name: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteFieldEx, 'pdfDeleteFieldEx');{$endif}
   Result := pdfDeleteFieldEx(FInstance, PAnsiChar(Name));
end;

procedure TPDF.DeleteJavaScripts(DelJavaScriptActions: Boolean);
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteJavaScripts, 'pdfDeleteJavaScripts');{$endif}
   pdfDeleteJavaScripts(FInstance, DelJavaScriptActions);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.DeleteNamedDest(const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteNamedDestW, 'pdfDeleteNamedDestW');{$endif}
   Result := pdfDeleteNamedDestW(FInstance, PWideChar(Name));
end;
{$else}
function TPDF.DeleteNamedDestA(const Name: String): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteNamedDestA, 'pdfDeleteNamedDestA');{$endif}
   Result := pdfDeleteNamedDestA(FInstance, PAnsiChar(Name));
end;

function TPDF.DeleteNamedDestW(const Name: WideString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteNamedDestW, 'pdfDeleteNamedDestW');{$endif}
   Result := pdfDeleteNamedDestW(FInstance, PWideChar(Name));
end;
{$endif}

function TPDF.DeleteNamedDestByIndex(Index: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteNamedDestByIndex, 'pdfDeleteNamedDestByIndex');{$endif}
   Result := pdfDeleteNamedDestByIndex(FInstance, Index);
end;

function TPDF.DeleteOCGFromAppEvent(Handle: Cardinal; Events: TOCAppEvent; Categories: TOCGUsageCategory; DelCategoryOnly: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteOCGFromAppEvent, 'pdfDeleteOCGFromAppEvent');{$endif}
   Result := pdfDeleteOCGFromAppEvent(FInstance, Handle, Events, Categories, DelCategoryOnly);
end;

function TPDF.DeleteOCGFromDisplayTree(OCGHandle: Cardinal; Recursive: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteOCGFromDisplayTree, 'pdfDeleteOCGFromDisplayTree');{$endif}
   Result := pdfDeleteOCGFromDisplayTree(FInstance, OCGHandle, Recursive);
end;

function TPDF.DeleteOCUINode(Node: IOCN): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteOCUINode, 'pdfDeleteOCUINode');{$endif}
   Result := pdfDeleteOCUINode(FInstance, Node);
end;

function TPDF.DeleteOutputIntent(Index: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteOutputIntent, 'pdfDeleteOutputIntent');{$endif}
   Result := pdfDeleteOutputIntent(FInstance, Index);
end;

function TPDF.DeletePage(PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeletePage, 'pdfDeletePage');{$endif}
   Result := pdfDeletePage(FInstance, PageNum);
end;

procedure TPDF.DeletePageLabels;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeletePageLabels, 'pdfDeletePageLabels');{$endif}
   pdfDeletePageLabels(FInstance);
end;

procedure TPDF.DeleteRasterizer(RasPtr: PIRAS);
begin
   {$ifdef DYNLNK}LoadFunction(@rasDeleteRasterizer, 'rasDeleteRasterizer');{$endif}
   rasDeleteRasterizer(RasPtr);
end;

function TPDF.DeleteSeparationInfo(AllPages: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteSeparationInfo, 'pdfDeleteSeparationInfo');{$endif}
   Result := pdfDeleteSeparationInfo(FInstance, AllPages);
end;

function TPDF.DeleteTemplate(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteTemplate, 'pdfDeleteTemplate');{$endif}
   Result := pdfDeleteTemplate(FInstance, Handle);
end;

function TPDF.DeleteTemplateEx(Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteTemplateEx, 'pdfDeleteTemplateEx');{$endif}
   Result := pdfDeleteTemplateEx(FInstance, Index);
end;

function TPDF.DeleteWatermark(PageNum: Integer; InclAnnots: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteWatermark, 'pdfDeleteWatermark');{$endif}
   Result := pdfDeleteWatermark(FInstance, PageNum, InclAnnots);
end;

procedure TPDF.DeleteXFAForm;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDeleteXFAForm, 'pdfDeleteXFAForm');{$endif}
   pdfDeleteXFAForm(FInstance);
end;

function TPDF.DrawArc(PosX, PosY, Radius, StartAngle, EndAngle: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawArc, 'pdfDrawArc');{$endif}
   Result := pdfDrawArc(FInstance, PosX, PosY, Radius, StartAngle, EndAngle);
end;

function TPDF.DrawArcEx(PosX, PosY, Width, Height, StartAngle, EndAngle: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawArcEx, 'pdfDrawArcEx');{$endif}
   Result := pdfDrawArcEx(FInstance, PosX, PosY, Width, Height, StartAngle, EndAngle);
end;

function TPDF.DrawChord(PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawChord, 'pdfDrawChord');{$endif}
   Result := pdfDrawChord(FInstance, PosX, PosY, Width, Height, StartAngle, EndAngle, Ord(FillMode));
end;

function TPDF.DrawCircle(PosX, PosY, Radius: Double; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawCircle, 'pdfDrawCircle');{$endif}
   Result := pdfDrawCircle(FInstance, PosX, PosY, Radius, Ord(FillMode));
end;

function TPDF.DrawNGon(PosX, PosY, Radius, Alpha: Double; NumSides: Cardinal; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawNGon, 'pdfDrawNGon');{$endif}
   Result := pdfDrawNGon(FInstance, PosX, PosY, Radius, Alpha, NumSides, FillMode);
end;

function TPDF.DrawPie(PosX, PosY, Width, Height, StartAngle, EndAngle: Double; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfDrawPie, 'pdfDrawPie');{$endif}
   Result := pdfDrawPie(FInstance, PosX, PosY, Width, Height, StartAngle, EndAngle, Ord(FillMode));
end;

function TPDF.EditPage(PageNum: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEditPage, 'pdfEditPage');{$endif}
   Result := pdfEditPage(FInstance, PageNum);
end;

function TPDF.EditTemplate(Index: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEditTemplate, 'pdfEditTemplate');{$endif}
   Result := pdfEditTemplate(FInstance, Index);
end;

function TPDF.EditTemplate2(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEditTemplate2, 'pdfEditTemplate2');{$endif}
   Result := pdfEditTemplate2(FInstance, Handle);
end;

function TPDF.Ellipse(PosX, PosY, Width, Height: Double; FillMode: TPathFillMode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEllipse, 'pdfEllipse');{$endif}
   Result := pdfEllipse(FInstance, PosX, PosY, Width, Height, Ord(FillMode));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.EncryptPDF(const FileName, OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEncryptPDFA, 'pdfEncryptPDFA');{$endif}
   Result := pdfEncryptPDFA(FInstance, PAnsiChar(FileName), PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), KeyLen, Restrict);
end;

function TPDF.EncryptPDF(const FileName: WideString; const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEncryptPDFW, 'pdfEncryptPDFW');{$endif}
   Result := pdfEncryptPDFW(FInstance, PWideChar(FileName), PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), KeyLen, Restrict);
end;
{$endif}

function TPDF.EnableImageCache(MaxImageCount, Size: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEnableImageCache, 'pdfEnableImageCache');{$endif}
   Result := pdfEnableImageCache(FInstance, MaxImageCount, Size);
end;

function TPDF.EncryptPDFA(const FileName, OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEncryptPDFA, 'pdfEncryptPDFA');{$endif}
   Result := pdfEncryptPDFA(FInstance, PAnsiChar(FileName), PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), KeyLen, Restrict);
end;

function TPDF.EncryptPDFW(const FileName: WideString; const OpenPwd, OwnerPwd: AnsiString; KeyLen: TKeyLen; Restrict: TRestrictions): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEncryptPDFW, 'pdfEncryptPDFW');{$endif}
   Result := pdfEncryptPDFW(FInstance, PWideChar(FileName), PAnsiChar(OpenPwd), PAnsiChar(OwnerPwd), KeyLen, Restrict);
end;

function TPDF.EndContinueText(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEndContinueText, 'pdfEndContinueText');{$endif}
   Result := pdfEndContinueText(FInstance);
end;

function TPDF.EndLayer: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEndLayer, 'pdfEndLayer');{$endif}
   Result := pdfEndLayer(FInstance);
end;

function TPDF.EndPage(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEndPage, 'pdfEndPage');{$endif}
   Result := pdfEndPage(FInstance);
end;

function TPDF.EndPattern(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEndPattern, 'pdfEndPattern');{$endif}
   Result := pdfEndPattern(FInstance);
end;

function TPDF.EndTemplate(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEndTemplate, 'pdfEndTemplate');{$endif}
   Result := pdfEndTemplate(FInstance);
end;

function TPDF.EnumDocFonts(const Data: Pointer; EnumProc: TEnumFontProc2): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEnumDocFonts, 'pdfEnumDocFonts');{$endif}
   Result := pdfEnumDocFonts(FInstance, Data, EnumProc);
end;

function TPDF.EnumHostFonts(const Data: Pointer; EnumProc: TEnumFontProc): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEnumHostFonts, 'pdfEnumHostFonts');{$endif}
   Result := pdfEnumHostFonts(FInstance, Data, EnumProc);
end;

function TPDF.EnumHostFontsEx(const Data: Pointer; EnumProc: TEnumFontProcEx): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfEnumHostFontsEx, 'pdfEnumHostFontsEx');{$endif}
   Result := pdfEnumHostFontsEx(FInstance, Data, EnumProc);
end;

function TPDF.ExchangeBookmarks(Bmk1, Bmk2: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfExchangeBookmarks, 'pdfExchangeBookmarks');{$endif}
   Result := pdfExchangeBookmarks(FInstance, Bmk1, Bmk2);
end;

function TPDF.ExchangePages(First, Second: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfExchangePages, 'pdfExchangePages');{$endif}
   Result := pdfExchangePages(FInstance, First, Second);
end;

function TPDF.ExtractText(PageNum: Cardinal; Flags: TTextExtractionFlags; const Area: PFltRect; var Text: WideString): Boolean;
var txt: PWideChar; len: Cardinal;
begin
   txt := nil;
   len := 0;
   {$ifdef DYNLNK}LoadFunction(@pdfExtractText, 'pdfExtractText');{$endif}
   Result := pdfExtractText(FInstance, PageNum, Flags, Area, txt, len);
   // This assignment is safe since the string is null-terminated.
   if Result then
      Text := WideString(txt)
   else
      Text := '';
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.FileAttachAnnot(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotA, 'pdfFileAttachAnnotA');{$endif}
   Result := pdfFileAttachAnnotA(FInstance, PosX, PosY, Icon, PAnsiChar(Author), PAnsiChar(Desc), PAnsiChar(AFile), Compress);
end;

function TPDF.FileAttachAnnot(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotW, 'pdfFileAttachAnnotW');{$endif}
   Result := pdfFileAttachAnnotW(FInstance, PosX, PosY, Icon, PWideChar(Author), PWideChar(Desc), PWideChar(AFile), Compress);
end;

function TPDF.FileAttachAnnotEx(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: AnsiString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotExA, 'pdfFileAttachAnnotExA');{$endif}
   Result := pdfFileAttachAnnotExA(FInstance, PosX, PosY, Icon, PAnsiChar(FileName), PAnsiChar(Author), PAnsiChar(Desc), Buffer, BufSize, Compress);
end;

function TPDF.FileAttachAnnotEx(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: WideString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotExW, 'pdfFileAttachAnnotExW');{$endif}
   Result := pdfFileAttachAnnotExW(FInstance, PosX, PosY, Icon, PWideChar(FileName), PWideChar(Author), PWideChar(Desc), Buffer, BufSize, Compress);
end;
{$endif}

function TPDF.FileAttachAnnotA(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: AnsiString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotA, 'pdfFileAttachAnnotA');{$endif}
   Result := pdfFileAttachAnnotA(FInstance, PosX, PosY, Icon, PAnsiChar(Author), PAnsiChar(Desc), PAnsiChar(AFile), Compress);
end;

function TPDF.FileAttachAnnotW(PosX, PosY: Double; Icon: TFileAttachIcon; const Author, Desc, AFile: WideString; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotW, 'pdfFileAttachAnnotW');{$endif}
   Result := pdfFileAttachAnnotW(FInstance, PosX, PosY, Icon, PWideChar(Author), PWideChar(Desc), PWideChar(AFile), Compress);
end;

function TPDF.FileAttachAnnotExA(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: AnsiString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotExA, 'pdfFileAttachAnnotExA');{$endif}
   Result := pdfFileAttachAnnotExA(FInstance, PosX, PosY, Icon, PAnsiChar(FileName), PAnsiChar(Author), PAnsiChar(Desc), Buffer, BufSize, Compress);
end;

function TPDF.FileAttachAnnotExW(PosX, PosY: Double; Icon: TFileAttachIcon; const FileName, Author, Desc: WideString; const Buffer: Pointer; BufSize: Cardinal; Compress: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileAttachAnnotExW, 'pdfFileAttachAnnotExW');{$endif}
   Result := pdfFileAttachAnnotExW(FInstance, PosX, PosY, Icon, PWideChar(FileName), PWideChar(Author), PWideChar(Desc), Buffer, BufSize, Compress);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.FileLink(PosX, PosY, Width, Height: Double; const AFilePath: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileLinkA, 'pdfFileLinkA');{$endif}
   Result := pdfFileLinkA(FInstance, PosX, PosY, Width, Height, PAnsiChar(AFilePath));
end;

function TPDF.FileLink(PosX, PosY, Width, Height: Double; const AFilePath: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileLinkW, 'pdfFileLinkW');{$endif}
   Result := pdfFileLinkW(FInstance, PosX, PosY, Width, Height, PWideChar(AFilePath));
end;
{$endif}

function TPDF.FileLinkA(PosX, PosY, Width, Height: Double; const AFilePath: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileLinkA, 'pdfFileLinkA');{$endif}
   Result := pdfFileLinkA(FInstance, PosX, PosY, Width, Height, PAnsiChar(AFilePath));
end;

function TPDF.FileLinkW(PosX, PosY, Width, Height: Double; const AFilePath: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFileLinkW, 'pdfFileLinkW');{$endif}
   Result := pdfFileLinkW(FInstance, PosX, PosY, Width, Height, PWideChar(AFilePath));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.FindBookmark(DestPage: Integer; const Title: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindBookmarkA, 'pdfFindBookmarkA');{$endif}
   Result := pdfFindBookmarkA(FInstance, DestPage, PAnsiChar(Title));
end;

function TPDF.FindBookmark(DestPage: Integer; const Title: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindBookmarkW, 'pdfFindBookmarkW');{$endif}
   Result := pdfFindBookmarkW(FInstance, DestPage, PWideChar(Title));
end;
{$endif}

function TPDF.FindBookmarkA(DestPage: Integer; const Title: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindBookmarkA, 'pdfFindBookmarkA');{$endif}
   Result := pdfFindBookmarkA(FInstance, DestPage, PAnsiChar(Title));
end;

function TPDF.FindBookmarkW(DestPage: Integer; const Title: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindBookmarkW, 'pdfFindBookmarkW');{$endif}
   Result := pdfFindBookmarkW(FInstance, DestPage, PWideChar(Title));
end;

function TPDF.FindEmbeddedFile(const Name: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindEmbeddedFileW, 'pdfFindEmbeddedFileW');{$endif}
   Result := pdfFindEmbeddedFileW(FInstance, PWideChar(Name));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.FindField(const Name: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindFieldA, 'pdfFindFieldA');{$endif}
   Result := pdfFindFieldA(FInstance, PAnsiChar(Name));
end;

function TPDF.FindField(const Name: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindFieldW, 'pdfFindFieldW');{$endif}
   Result := pdfFindFieldW(FInstance, PWideChar(Name));
end;
{$endif}

function TPDF.FindFieldA(const Name: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindFieldA, 'pdfFindFieldA');{$endif}
   Result := pdfFindFieldA(FInstance, PAnsiChar(Name));
end;

function TPDF.FindFieldW(const Name: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindFieldW, 'pdfFindFieldW');{$endif}
   Result := pdfFindFieldW(FInstance, PWideChar(Name));
end;

function TPDF.FindLinkAnnot(const URL: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindLinkAnnot, 'pdfFindLinkAnnot');{$endif}
   Result := pdfFindLinkAnnot(FInstance, PAnsiChar(URL));
end;

function TPDF.FindNextBookmark(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFindNextBookmark, 'pdfFindNextBookmark');{$endif}
   Result := pdfFindNextBookmark(FInstance);
end;

function TPDF.FinishSignature(const PKCS7Obj: Pointer; Length: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFinishSignature, 'pdfFinishSignature');{$endif}
   Result := pdfFinishSignature(FInstance, PKCS7Obj, Length);
end;

function TPDF.FlattenAnnotOrField(Index: Cardinal; Flags: TAnnotFlattenFlags): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlattenAnnotOrField, 'pdfFlattenAnnotOrField');{$endif}
   Result := pdfFlattenAnnotOrField(FInstance, Index, Flags);
end;

function TPDF.FlattenAnnots(Flags: TAnnotFlattenFlags): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlattenAnnots, 'pdfFlattenAnnots');{$endif}
   Result := pdfFlattenAnnots(FInstance, Flags);
end;

function TPDF.FlattenForm(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlattenForm, 'pdfFlattenForm');{$endif}
   Result := pdfFlattenForm(FInstance);
end;

function TPDF.FlushPageContent(var Stack: TPDFStack): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlushPageContent, 'pdfFlushPageContent');{$endif}
   Result := pdfFlushPageContent(FInstance, Stack);
end;

function TPDF.FlushPages(Flags: TFlushPageFlags): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlushPages, 'pdfFlushPages');{$endif}
   Result := pdfFlushPages(FInstance, Integer(Flags));
end;

function TPDF.FlushPagesEx(Flags: TFlushPageFlags; LastPage: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFlushPagesEx, 'pdfFlushPagesEx');{$endif}
   Result := pdfFlushPagesEx(FInstance, Flags, LastPage);
end;

procedure TPDF.FreeImageBuffer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeImageBuffer, 'pdfFreeImageBuffer');{$endif}
   pdfFreeImageBuffer(FInstance);
end;

function TPDF.FreeImageObj(Handle: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeImageObj, 'pdfFreeImageObj');{$endif}
   Result := pdfFreeImageObj(FInstance, Handle);
end;

function TPDF.FreeImageObjEx(const ImagePtr: Pointer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeImageObjEx, 'pdfFreeImageObjEx');{$endif}
   Result := pdfFreeImageObjEx(FInstance, ImagePtr);
end;

function TPDF.FreePDF(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreePDF, 'pdfFreePDF');{$endif}
   Result := pdfFreePDF(FInstance);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.FreeTextAnnot(PosX, PosY, Width, Height: Double; const Author, AText: AnsiString; Align: TTextAlign): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeTextAnnotA, 'pdfFreeTextAnnotA');{$endif}
   Result := pdfFreeTextAnnotA(FInstance, PosX, PosY, Width, Height, PAnsiChar(Author), PAnsiChar(AText), Align);
end;

function TPDF.FreeTextAnnot(PosX, PosY, Width, Height: Double; const Author, AText: WideString; Align: TTextAlign): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeTextAnnotW, 'pdfFreeTextAnnotW');{$endif}
   Result := pdfFreeTextAnnotW(FInstance, PosX, PosY, Width, Height, PWideChar(Author), PWideChar(AText), Align);
end;
{$endif}

function TPDF.FreeTextAnnotA(PosX, PosY, Width, Height: Double; const Author, AText: AnsiString; Align: TTextAlign): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeTextAnnotA, 'pdfFreeTextAnnotA');{$endif}
   Result := pdfFreeTextAnnotA(FInstance, PosX, PosY, Width, Height, PAnsiChar(Author), PAnsiChar(AText), Align);
end;

function TPDF.FreeTextAnnotW(PosX, PosY, Width, Height: Double; const Author, AText: WideString; Align: TTextAlign): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeTextAnnotW, 'pdfFreeTextAnnotW');{$endif}
   Result := pdfFreeTextAnnotW(FInstance, PosX, PosY, Width, Height, PWideChar(Author), PWideChar(AText), Align);
end;

function TPDF.FreeUniBuf(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfFreeUniBuf, 'pdfFreeUniBuf');{$endif}
   Result := pdfFreeUniBuf(FInstance);
end;

function TPDF.Get3DAnnotStream(Annot: Cardinal; var Data: PByte; var Size: Cardinal; var SubType: PAnsiString): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGet3DAnnotStream, 'pdfGet3DAnnotStream');{$endif}
   Result := pdfGet3DAnnotStream(FInstance, Annot, Data, Size, SubType);
end;

function TPDF.GetActionCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetActionCount, 'pdfGetActionCount');{$endif}
   Result := pdfGetActionCount(FInstance);
end;

function TPDF.GetActionHandle(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetActionHandle, 'pdfGetActionHandle');{$endif}
   Result := pdfGetActionHandle(FInstance, ObjType, ObjHandle, ActIndex);
end;

function TPDF.GetActionType(ActHandle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetActionType, 'pdfGetActionType');{$endif}
   Result := pdfGetActionType(FInstance, ActHandle);
end;

function TPDF.GetActionTypeEx(ObjType: TObjType; ObjHandle, ActIndex: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetActionTypeEx, 'pdfGetActionTypeEx');{$endif}
   Result := pdfGetActionTypeEx(FInstance, ObjType, ObjHandle, ActIndex);
end;

function TPDF.GetActiveFont: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetActiveFont, 'pdfGetActiveFont');{$endif}
   Result := pdfGetActiveFont(FInstance);
end;

function TPDF.GetAllocBy(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAllocBy, 'pdfGetAllocBy');{$endif}
   Result := pdfGetAllocBy(FInstance);
end;

function TPDF.GetAnnot(Handle: Cardinal; var Annot: TPDFAnnotation): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnot, 'pdfGetAnnot');{$endif}
   Result := pdfGetAnnot(FInstance, Handle, Annot);
end;

function TPDF.GetAnnotBBox(Handle: Cardinal; var BBox: TPDFRect): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotBBox, 'pdfGetAnnotBBox');{$endif}
   Result := pdfGetAnnotBBox(FInstance, Handle, BBox);
end;

function TPDF.GetAnnotColor(Handle: Cardinal; ColorType: TAnnotColor; var CS: TPDFColorSpace; var Color: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotColor, 'pdfGetAnnotColor');{$endif}
   Result := pdfGetAnnotColor(FInstance, Handle, ColorType, CS, Color);
end;

function TPDF.GetAnnotCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotCount, 'pdfGetAnnotCount');{$endif}
   Result := pdfGetAnnotCount(FInstance);
end;

function TPDF.GetAnnotEx(Handle: Cardinal; var Annot: TPDFAnnotationEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotEx, 'pdfGetAnnotEx');{$endif}
   Result := pdfGetAnnotEx(FInstance, Handle, Annot);
end;

function TPDF.GetAnnotFlags(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotFlags, 'pdfGetAnnotFlags');{$endif}
   Result := pdfGetAnnotFlags(FInstance);
end;

function TPDF.GetAnnotLink(Handle: Cardinal): AnsiString;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotLink, 'pdfGetAnnotLink');{$endif}
   Result := pdfGetAnnotLink(FInstance, Handle);
end;

function TPDF.GetAnnotTextAlign(Handle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotTextAlign, 'pdfGetAnnotTextAlign');{$endif}
   Result := pdfGetAnnotTextAlign(FInstance, Handle);
end;

function TPDF.GetAnnotType(Handle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAnnotType, 'pdfGetAnnotType');{$endif}
   Result := pdfGetAnnotType(FInstance, Handle);
end;

function TPDF.GetAscent(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetAscent, 'pdfGetAscent');{$endif}
   Result := pdfGetAscent(FInstance);
end;

function TPDF.GetBarcodeDict(const IBarcode: Pointer; var Barcode: TPDFBarcode): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBarcodeDict, 'pdfGetBarcodeDict');{$endif}
   Barcode.StructSize := sizeof(TPDFBarcode);
   Result := pdfGetBarcodeDict(IBarcode, Barcode);
end;

function TPDF.GetBBox(Boundary: TPageBoundary; var BBox: TPDFRect): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBBox, 'pdfGetBBox');{$endif}
   Result := pdfGetBBox(FInstance, Boundary, BBox);
end;

function TPDF.GetBidiMode: TPDFBidiMode;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBidiMode, 'pdfGetBidiMode');{$endif}
   Result := TPDFBidiMode(pdfGetBidiMode(FInstance));
end;

function TPDF.GetBookmark(Handle: Integer; var Bmk: TBookmark): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBookmark, 'pdfGetBookmark');{$endif}
   Result := pdfGetBookmark(FInstance, Handle, Bmk);
end;

function TPDF.GetBookmarkCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBookmarkCount, 'pdfGetBookmarkCount');{$endif}
   Result := pdfGetBookmarkCount(FInstance);
end;

function TPDF.GetBookmarkEx(Handle: Integer; var Bmk: TPDFBookmark): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBookmarkEx, 'pdfGetBookmarkEx');{$endif}
   Result := pdfGetBookmarkEx(FInstance, Handle, Bmk);
end;

function TPDF.GetBorderStyle(): TBorderStyle;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBorderStyle, 'pdfGetBorderStyle');{$endif}
   Result := TBorderStyle(pdfGetBorderStyle(FInstance));
end;

function TPDF.GetBuffer(var BufSize: Cardinal): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetBuffer, 'pdfGetBuffer');{$endif}
   Result := pdfGetBuffer(FInstance, BufSize);
end;

function TPDF.GetCapHeight(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCapHeight, 'pdfGetCapHeight');{$endif}
   Result := pdfGetCapHeight(FInstance);
end;

function TPDF.GetCharacterSpacing(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCharacterSpacing, 'pdfGetCharacterSpacing');{$endif}
   Result := pdfGetCharacterSpacing(FInstance);
end;

function TPDF.GetCheckBoxChar: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCheckBoxChar, 'pdfGetCheckBoxChar');{$endif}
   Result := pdfGetCheckBoxChar(FInstance);
end;

function TPDF.GetCheckBoxCharEx(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCheckBoxCharEx, 'pdfGetCheckBoxCharEx');{$endif}
   Result := pdfGetCheckBoxCharEx(FInstance, AField);
end;

function TPDF.GetCheckBoxDefState(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCheckBoxDefState, 'pdfGetCheckBoxDefState');{$endif}
   Result := pdfGetCheckBoxDefState(FInstance, AField);
end;

function TPDF.GetCMap(Index: Cardinal; var CMap: TPDFCMap): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCMap, 'pdfGetCMap');{$endif}
   CMap.StructSize := sizeof(CMap);
   Result := pdfGetCMap(FInstance, Index, CMap);
end;

function TPDF.GetCMapCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCMapCount, 'pdfGetCMapCount');{$endif}
   Result := pdfGetCMapCount(FInstance);
end;

function TPDF.GetCollectionInfo(var Value: TPDFCollectionInfo): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCollectionInfo, 'pdfGetCollectionInfo');{$endif}
   Result := pdfGetCollectionInfo(FInstance, Value);
end;

function TPDF.GetColorSpace(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetColorSpace, 'pdfGetColorSpace');{$endif}
   Result := pdfGetColorSpace(FInstance);
end;

function TPDF.GetColorSpaceCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetColorSpaceCount, 'pdfGetColorSpaceCount');{$endif}
   Result := pdfGetColorSpaceCount(FInstance);
end;

function TPDF.GetColorSpaceObj(Handle: Cardinal; var CS: TPDFColorSpaceObj): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetColorSpaceObj, 'pdfGetColorSpaceObj');{$endif}
   Result := pdfGetColorSpaceObj(FInstance, Handle, CS);
end;

function TPDF.GetColorSpaceObjEx(const IColorSpace: Pointer; var CS: TPDFColorSpaceObj): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetColorSpaceObjEx, 'pdfGetColorSpaceObjEx');{$endif}
   Result := pdfGetColorSpaceObjEx(IColorSpace, CS);
end;

function TPDF.GetCompressionFilter: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCompressionFilter, 'pdfGetCompressionFilter');{$endif}
   Result := pdfGetCompressionFilter(FInstance);
end;

function TPDF.GetCompressionLevel(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetCompressionLevel, 'pdfGetCompressionLevel');{$endif}
   Result := pdfGetCompressionLevel(FInstance);
end;

function TPDF.GetContent(var Buffer: PAnsiChar): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetContent, 'pdfGetContent');{$endif}
   Result := pdfGetContent(FInstance, Buffer);
end;

function TPDF.GetDefBitsPerPixel(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDefBitsPerPixel, 'pdfGetDefBitsPerPixel');{$endif}
   Result := pdfGetDefBitsPerPixel(FInstance);
end;

function TPDF.GetDescent(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDescent, 'pdfGetDescent');{$endif}
   Result := pdfGetDescent(FInstance);
end;

function TPDF.GetDeviceNAttributes(IAttributes: Pointer; var Attributes: TDeviceNAttributes): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDeviceNAttributes, 'pdfGetDeviceNAttributes');{$endif}
   Result := pdfGetDeviceNAttributes(IAttributes, Attributes);
end;

function TPDF.GetDocInfo(DInfo: TDocumentInfo; var Value: PWideChar): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDocInfo, 'pdfGetDocInfo');{$endif}
   Result := pdfGetDocInfo(FInstance, Ord(DInfo), Value);
end;

function TPDF.GetDocInfoCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDocInfoCount, 'pdfGetDocInfoCount');{$endif}
   Result := pdfGetDocInfoCount(FInstance);
end;

function TPDF.GetDocInfoEx(Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDocInfoEx, 'pdfGetDocInfoEx');{$endif}
   Result := pdfGetDocInfoEx(FInstance, Index, DInfo, Key, Value, Unicode);
end;

function TPDF.GetDocUsesTransparency(Flags: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDocUsesTransparency, 'pdfGetDocUsesTransparency');{$endif}
   Result := pdfGetDocUsesTransparency(FInstance, Flags);
end;

function TPDF.GetDrawDirection(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDrawDirection, 'pdfGetDrawDirection');{$endif}
   Result := pdfGetDrawDirection(FInstance);
end;

function TPDF.GetDynaPDFVersion: AnsiString;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetDynaPDFVersion, 'pdfGetDynaPDFVersion');{$endif}
   Result := pdfGetDynaPDFVersion();
end;

function TPDF.GetDynaPDFVersionInt(): Integer;
var v: AnsiString; retval, value, len, p: Integer;
begin
   Result := 0;
   v      := GetDynaPDFVersion;
   p      := 1;
   value  := 0;
   len := ParseInt(v, p, value);
   if len = 0 then Exit;
   retval := value * 10000000;
   Inc(p, len + 3);
   len := ParseInt(v, p, value);
   if len = 0 then Exit;
   Inc(retval, value * 10000);
   Inc(p, len + 1);
   if ParseInt(v, p, value) = 0 then Exit;
   Inc(retval, value);
   Result := retval;
end;

function TPDF.GetEmbeddedFile(Handle: Cardinal; var FileSpec: TPDFFileSpec; Decompress: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetEmbeddedFile, 'pdfGetEmbeddedFile');{$endif}
   Result := pdfGetEmbeddedFile(FInstance, Handle, FileSpec, Decompress);
end;

function TPDF.GetEmbeddedFileCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetEmbeddedFileCount, 'pdfGetEmbeddedFileCount');{$endif}
   Result := pdfGetEmbeddedFileCount(FInstance);
end;

function TPDF.GetEmbeddedFileNode(const IEF: IEFN; F: TPDFEmbFileNode; Decompress: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetEmbeddedFileNode, 'pdfGetEmbeddedFileNode');{$endif}
   Result := pdfGetEmbeddedFileNode(IEF, F, Decompress);
end;

function TPDF.GetEMFPatternDistance(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetEMFPatternDistance, 'pdfGetEMFPatternDistance');{$endif}
   Result := pdfGetEMFPatternDistance(FInstance);
end;

function TPDF.GetErrLogMessage(Index: Cardinal; var Err: TPDFError): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetErrLogMessage, 'pdfGetErrLogMessage');{$endif}
   Result := pdfGetErrLogMessage(FInstance, Index, Err);
end;

function TPDF.GetErrLogMessageCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetErrLogMessageCount, 'pdfGetErrLogMessageCount');{$endif}
   Result := pdfGetErrLogMessageCount(FInstance);
end;

function TPDF.GetErrorMessage(): AnsiString;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetErrorMessage, 'pdfGetErrorMessage');{$endif}
   Result := pdfGetErrorMessage(FInstance);
end;

function TPDF.GetErrorMode(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetErrorMode, 'pdfGetErrorMode');{$endif}
   Result := pdfGetErrorMode(FInstance);
end;

function TPDF.GetField(Handle: Cardinal; var Field: TPDFField): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetField, 'pdfGetField');{$endif}
   {
      Note: FieldName can be an Unicode string!
      To determine whether FieldName contains an ANSI or Unicode string
      proceed as follows:
      if f.FielNameLen > 0 and StrLen(f.FieldName) <> f.FieldNameLen then begin
         // f.FieldName contains a null-terminated Unicode string
         // f.FieldNameLen is the length in Unicode characters, but we have an ANSI string.
         // So, we must multiply the length with 2 to convert the entire string!
         nameW := pdf.ToUnicode(f.FieldName, f.FieldNameLen * 2);         
      end;
   }
   Result := pdfGetField(FInstance, Handle, Field);
end;

function TPDF.GetFieldBackColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldBackColor, 'pdfGetFieldBackColor');{$endif}
   Result := pdfGetFieldBackColor(FInstance);
end;

function TPDF.GetFieldBorderColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldBorderColor, 'pdfGetFieldBorderColor');{$endif}
   Result := pdfGetFieldBorderColor(FInstance);
end;

function TPDF.GetFieldBorderStyle(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldBorderStyle, 'pdfGetFieldBorderStyle');{$endif}
   Result := pdfGetFieldBorderStyle(FInstance, AField);
end;

function TPDF.GetFieldBorderWidth(AField: Cardinal): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldBorderWidth, 'pdfGetFieldBorderWidth');{$endif}
   Result := pdfGetFieldBorderWidth(FInstance, AField);
end;

function TPDF.GetFieldCalcOrder(var Out: PCardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldCalcOrder, 'pdfGetFieldCalcOrder');{$endif}
   Result := pdfGetFieldCalcOrder(FInstance, Out);
end;

function TPDF.GetFieldChoiceValue(AField, ValIndex: Cardinal; var Value: TPDFChoiceValue): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldChoiceValue, 'pdfGetFieldChoiceValue');{$endif}
   Result := pdfGetFieldChoiceValue(FInstance, AField, ValIndex, Value);
end;

function TPDF.GetFieldColor(AField: Cardinal; ColorType: TFieldColor; var ColorSpace: Integer; var Color: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldColor, 'pdfGetFieldColor');{$endif}
   Result := pdfGetFieldColor(FInstance, AField, Integer(ColorType), ColorSpace, Color);
end;

function TPDF.GetFieldCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldCount, 'pdfGetFieldCount');{$endif}
   Result := pdfGetFieldCount(FInstance);
end;

function TPDF.GetFieldEx(Handle: Cardinal; var Field: TPDFFieldEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldEx, 'pdfGetFieldEx');{$endif}
   Field.StructSize := sizeof(Field);
   Result := pdfGetFieldEx(FInstance, Handle, Field);
end;

function TPDF.GetFieldEx2(const IField: Pointer; var Field: TPDFFieldEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldEx2, 'pdfGetFieldEx2');{$endif}
   Field.StructSize := sizeof(Field);
   Result := pdfGetFieldEx2(IField, Field);
end;

function TPDF.GetFieldExpValCount(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldExpValCount, 'pdfGetFieldExpValCount');{$endif}
   Result := pdfGetFieldExpValCount(FInstance, AField);
end;

function TPDF.GetFieldExpValue(AField: Cardinal; var Value: AnsiString): Integer;
var retval: PAnsiChar;
begin
   retval := nil;
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldExpValue, 'pdfGetFieldExpValue');{$endif}
   Result := pdfGetFieldExpValue(FInstance, AField, retval);
   Value := retval;
end;

function TPDF.GetFieldExpValueEx(AField, ValIndex: Cardinal; var Value, ExpValue: AnsiString; var Selected: Boolean): Boolean;
var val, expVal: PAnsiChar; sel: LongBool;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldExpValueEx, 'pdfGetFieldExpValueEx');{$endif}
   val      := nil;
   expVal   := nil;
   sel      := false;
   Result   := pdfGetFieldExpValueEx(FInstance, AField, ValIndex, val, expVal, sel);
   Value    := val;
   ExpValue := expVal;
   Selected := sel;
end;

function TPDF.GetFieldFlags(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldFlags, 'pdfGetFieldFlags');{$endif}
   Result := pdfGetFieldFlags(FInstance, AField);
end;

function TPDF.GetFieldGroupType(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldGroupType, 'pdfGetFieldGroupType');{$endif}
   Result := pdfGetFieldGroupType(FInstance, AField);
end;

function TPDF.GetFieldHighlightMode(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldHighlightMode, 'pdfGetFieldHighlightMode');{$endif}
   Result := pdfGetFieldHighlightMode(FInstance, AField);
end;

function TPDF.GetFieldIndex(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldIndex, 'pdfGetFieldIndex');{$endif}
   Result := pdfGetFieldIndex(FInstance, AField);
end;

function TPDF.GetFieldMapName(AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldMapName, 'pdfGetFieldMapName');{$endif}
   Result := pdfGetFieldMapName(FInstance, AField, Value, Unicode);
end;

function TPDF.GetFieldName(AField: Cardinal; var Name: AnsiString): Integer;
var retval: PAnsiChar; i, p, len: Integer;
begin
   retval := nil;
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldName, 'pdfGetFieldName');{$endif}
   Result := pdfGetFieldName(FInstance, AField, retval);
   if Result > 0 then begin
      len := IntStrLen(retval);
      if len <> Result then
         len := Result * 2
      else
         len := Result;
      SetLength(Name, len);
      {
         A field name can be an Unicode string. To determine whether we have an ANSI or an Unicode
         string proceed as follows:
         nameLen := pdf.GetFieldName(myField, name);
         if nameLen > 0 then begin
            if Length(name) <> nameLen then begin
               nameW := pdf.ToUnicode(name);
               ...
            end else begin
               ...
            end;            
         end;
      }
      p := 0;
      for i := 1 to len do begin
         Name[i] := retval[p];
         Inc(p);
      end;
   end else
      Name := '';
end;

function TPDF.GetFieldOrientation(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldOrientation, 'pdfGetFieldOrientation');{$endif}
   Result := pdfGetFieldOrientation(FInstance, AField);
end;

function TPDF.GetFieldTextAlign(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldTextAlign, 'pdfGetFieldTextAlign');{$endif}
   Result := pdfGetFieldTextAlign(FInstance, AField);
end;

function TPDF.GetFieldTextColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldTextColor, 'pdfGetFieldTextColor');{$endif}
   Result := pdfGetFieldTextColor(FInstance);
end;

function TPDF.GetFieldToolTip(AField: Cardinal; var Value: Pointer; var Unicode: LongBool): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldToolTip, 'pdfGetFieldToolTip');{$endif}
   Result := pdfGetFieldToolTip(FInstance, AField, Value, Unicode);
end;

function TPDF.GetFieldType(AField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFieldType, 'pdfGetFieldType');{$endif}
   Result := pdfGetFieldType(FInstance, AField);
end;

function TPDF.GetFileSpec(const IFS: IFSR; var F: TPDFFileSpecEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFileSpec, 'pdfGetFileSpec');{$endif}
   Result := pdfGetFileSpec(IFS, F);
end;

function TPDF.GetFillColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFillColor, 'pdfGetFillColor');{$endif}
   Result := pdfGetFillColor(FInstance);
end;

function TPDF.GetFont(const IFont: PFNT; var F: TPDFFontObj): Boolean;
begin
   // if F.Length1 = 0 and if F.FontFile <> nil then the variable contains
   // the file path to the used font file. This string is always an Ansi string at this time.
   {$ifdef DYNLNK}LoadFunction(@fntGetFont, 'fntGetFont');{$endif}
   Result := fntGetFont(IFont, F);
end;

function TPDF.GetFontCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontCount, 'pdfGetFontCount');{$endif}
   Result := pdfGetFontCount(FInstance);
end;

function TPDF.GetFontEx(Handle: Cardinal; var F: TPDFFontObj): Boolean;
begin
   // if F.Length1 = 0 and if F.FontFile <> nil then the variable contains
   // the file path to the used font file. This string is always an Ansi string at this time.
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontEx, 'pdfGetFontEx');{$endif}
   Result := pdfGetFontEx(FInstance, Handle, F);
end;

function TPDF.GetFontInfo(const IFont: PFNT; var F: TPDFFontInfo): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@fntGetFontInfo, 'fntGetFontInfo');{$endif}
   Result := fntGetFontInfo(IFont, F);
end;

function TPDF.GetFontInfoEx(Handle: Cardinal; var F: TPDFFontInfo): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontInfoEx, 'pdfGetFontInfoEx');{$endif}
   Result := pdfGetFontInfoEx(FInstance, Handle, F);
end;

function TPDF.GetFontMetrics(Handle: Cardinal; var Metrics: TPDFFontMetrics): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontMetrics, 'pdfGetFontMetrics');{$endif}
   Result := pdfGetFontMetrics(FInstance, Handle, Metrics);
end;

function TPDF.GetFontOrigin(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontOrigin, 'pdfGetFontOrigin');{$endif}
   Result := pdfGetFontOrigin(FInstance);
end;

procedure TPDF.GetFontSearchOrder(Order: PFontBaseType);
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontSearchOrder, 'pdfGetFontSearchOrder');{$endif}
   pdfGetFontSearchOrder(FInstance, Order);
end;

function TPDF.GetFontSelMode(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontSelMode, 'pdfGetFontSelMode');{$endif}
   Result := pdfGetFontSelMode(FInstance);
end;

function TPDF.GetFontSize: Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontSize, 'pdfGetFontSize');{$endif}
   Result := pdfGetFontSize(FInstance);
end;

function TPDF.GetFontWeight(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFontWeight, 'pdfGetFontWeight');{$endif}
   Result := pdfGetFontWeight(FInstance);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetFTextHeight(Align: TTextAlign; const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightA, 'pdfGetFTextHeightA');{$endif}
   Result := pdfGetFTextHeightA(FInstance, Ord(Align), PAnsiChar(AText));
end;

function TPDF.GetFTextHeight(Align: TTextAlign; const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightW, 'pdfGetFTextHeightW');{$endif}
   Result := pdfGetFTextHeightW(FInstance, Ord(Align), PWideChar(AText));
end;
{$endif}

function TPDF.GetFTextHeightA(Align: TTextAlign; const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightA, 'pdfGetFTextHeightA');{$endif}
   Result := pdfGetFTextHeightA(FInstance, Ord(Align), PAnsiChar(AText));
end;

function TPDF.GetFTextHeightW(Align: TTextAlign; const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightW, 'pdfGetFTextHeightW');{$endif}
   Result := pdfGetFTextHeightW(FInstance, Ord(Align), PWideChar(AText));
end;

function TPDF.GetFullyQualifiedFieldName(Handle: Cardinal; var Value: PWideChar): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFullyQualifiedFieldName, 'pdfGetFullyQualifiedFieldName');{$endif}
   Result := pdfGetFullyQualifiedFieldName(FInstance, Handle, Value);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetFTextHeightEx(Width: Double; Align: TTextAlign; const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightExA, 'pdfGetFTextHeightExA');{$endif}
   Result := pdfGetFTextHeightExA(FInstance, Width, Align, PAnsiChar(AText));
end;

function TPDF.GetFTextHeightEx(Width: Double; Align: TTextAlign; const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightExW, 'pdfGetFTextHeightExW');{$endif}
   Result := pdfGetFTextHeightExW(FInstance, Width, Align, PWideChar(AText));
end;
{$endif}

function TPDF.GetFTextHeightExA(Width: Double; Align: TTextAlign; const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightExA, 'pdfGetFTextHeightExA');{$endif}
   Result := pdfGetFTextHeightExA(FInstance, Width, Align, PAnsiChar(AText));
end;

function TPDF.GetFTextHeightExW(Width: Double; Align: TTextAlign; const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetFTextHeightExW, 'pdfGetFTextHeightExW');{$endif}
   Result := pdfGetFTextHeightExW(FInstance, Width, Align, PWideChar(AText));
end;

function TPDF.GetGlyphIndex(Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetGlyphIndex, 'pdfGetGlyphIndex');{$endif}
   Result := pdfGetGlyphIndex(FInstance, Index);
end;

function TPDF.GetGlyphOutline(Index: Cardinal; Outline: PPDFGlyphOutline): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetGlyphOutline, 'pdfGetGlyphOutline');{$endif}
   Result := pdfGetGlyphOutline(FInstance, Index, Outline);
end;

function TPDF.GetGoToAction(Handle: Cardinal; var Action: TPDFGoToAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetGoToAction, 'pdfGetGoToAction');{$endif}
   Result := pdfGetGoToAction(FInstance, Handle, Action);
end;

function TPDF.GetGoToRAction(Handle: Cardinal; var Action: TPDFGoToAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetGoToRAction, 'pdfGetGoToRAction');{$endif}
   Result := pdfGetGoToRAction(FInstance, Handle, Action);
end;

function TPDF.GetGStateFlags: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetGStateFlags, 'pdfGetGStateFlags');{$endif}
   Result := pdfGetGStateFlags(FInstance);
end;

function TPDF.GetHideAction(Handle: Cardinal; var Action: TPDFHideAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetHideAction, 'pdfGetHideAction');{$endif}
   Result := pdfGetHideAction(FInstance, Handle, Action);
end;

function TPDF.GetIconColor(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetIconColor, 'pdfGetIconColor');{$endif}
   Result := pdfGetIconColor(FInstance);
end;

function TPDF.GetImageBuffer(var BufSize: Cardinal): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageBuffer, 'pdfGetImageBuffer');{$endif}
   Result := pdfGetImageBuffer(FInstance, BufSize);
end;

function TPDF.GetImageCount(const FileName: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageCountA, 'pdfGetImageCountA');{$endif}
   Result := pdfGetImageCountA(FInstance, PAnsiChar(FileName));
end;
{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetImageCount(const FileName: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageCountW, 'pdfGetImageCountW');{$endif}
   Result := pdfGetImageCountW(FInstance, PWideChar(FileName));
end;
{$endif}
function TPDF.GetImageCountW(const FileName: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageCountW, 'pdfGetImageCountW');{$endif}
   Result := pdfGetImageCountW(FInstance, PWideChar(FileName));
end;

function TPDF.GetImageCountEx(const Buffer: Pointer; BufSize: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageCountEx, 'pdfGetImageCountEx');{$endif}
   Result := pdfGetImageCountEx(FInstance, Buffer, BufSize);
end;

function TPDF.GetImageHeight(Handle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageHeight, 'pdfGetImageHeight');{$endif}
   Result := pdfGetImageHeight(FInstance, Handle);
end;

function TPDF.GetImageObj(Handle: Cardinal; Flags: TParseFlags; var Image: TPDFImage): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageObj, 'pdfGetImageObj');{$endif}
   Result := pdfGetImageObj(FInstance, Handle, Flags, Image);
end;

function TPDF.GetImageObjCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageObjCount, 'pdfGetImageObjCount');{$endif}
   Result := pdfGetImageObjCount(FInstance);
end;

function TPDF.GetImageObjEx(const ImagePtr: PIMG; Flags: TParseFlags; var Image: TPDFImage): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageObjEx, 'pdfGetImageObjEx');{$endif}
   Result := pdfGetImageObjEx(FInstance, ImagePtr, Flags, Image);
end;

function TPDF.GetImageWidth(Handle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImageWidth, 'pdfGetImageWidth');{$endif}
   Result := pdfGetImageWidth(FInstance, Handle);
end;

function TPDF.GetImportDataAction(Handle: Cardinal; var Action: TPDFImportDataAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImportDataAction, 'pdfGetImportDataAction');{$endif}
   Result := pdfGetImportDataAction(FInstance, Handle, Action);
end;

function TPDF.GetImportFlags(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImportFlags, 'pdfGetImportFlags');{$endif}
   Result := pdfGetImportFlags(FInstance);
end;

function TPDF.GetImportFlags2: Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetImportFlags2, 'pdfGetGetImportFlags2');{$endif}
   Result := pdfGetImportFlags2(FInstance);
end;

function TPDF.GetInBBox(PageNum: Cardinal; Boundary: TPageBoundary; var BBox: TPDFRect): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInBBox, 'pdfGetInBBox');{$endif}
   Result := pdfGetInBBox(FInstance, PageNum, Ord(Boundary), BBox);
end;

function TPDF.GetInDocInfo(DInfo: TDocumentInfo; var Value: PWideChar): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInDocInfo, 'pdfGetInDocInfo');{$endif}
   Result := pdfGetInDocInfo(FInstance, DInfo, Value);
end;

function TPDF.GetInDocInfoCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInDocInfoCount, 'pdfGetInDocInfoCount');{$endif}
   Result := pdfGetInDocInfoCount(FInstance);
end;

function TPDF.GetInDocInfoEx(Index: Cardinal; var DInfo: TDocumentInfo; var Key, Value: PAnsiChar; var Unicode: LongBool): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInDocInfoEx, 'pdfGetInDocInfoEx');{$endif}
   Result := pdfGetInDocInfoEx(FInstance, Index, DInfo, Key, Value, Unicode);
end;

function TPDF.GetInEncryptionFlags: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInEncryptionFlags, 'pdfGetInEncryptionFlags');{$endif}
   Result := pdfGetInEncryptionFlags(FInstance);
end;

function TPDF.GetInEncryptionInfo(var Info: TPDFEncryptInfo): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInEncryptionInfo, 'pdfGetInEncryptionInfo');{$endif}
   Result := pdfGetInEncryptionInfo(FInstance, Info);
end;

function TPDF.GetInFieldCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInFieldCount, 'pdfGetInFieldCount');{$endif}
   Result := pdfGetInFieldCount(FInstance);
end;

function TPDF.GetInIsCollection: Boolean;
var retval: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsCollection, 'pdfGetInIsCollection');{$endif}
   retval := pdfGetInIsCollection(FInstance);
   if retval < 0 then
      Result := false
   else
      Result := retval <> 0;
end;

function TPDF.GetInIsEncrypted: Boolean;
var retval: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsEncrypted, 'pdfGetInIsEncrypted');{$endif}
   retval := pdfGetInIsEncrypted(FInstance);
   if retval < 0 then
      Result := false
   else
      Result := retval <> 0;
end;

function TPDF.GetInIsSigned: Boolean;
var retval: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsSigned, 'pdfGetInIsSigned');{$endif}
   retval := pdfGetInIsSigned(FInstance);
   if retval < 0 then
      Result := false
   else
      Result := retval <> 0;
end;

function TPDF.GetInIsTaggedPDF: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsTaggedPDF, 'pdfGetInIsTaggedPDF');{$endif}
   Result := pdfGetInIsTaggedPDF(FInstance);
end;

function TPDF.GetInIsTrapped: Boolean;
var retval: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsTrapped, 'pdfGetInIsTrapped');{$endif}
   retval := pdfGetInIsTrapped(FInstance);
   if retval < 0 then
      Result := false
   else
      Result := retval <> 0;
end;

function TPDF.GetInIsXFAForm: Boolean;
var retval: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInIsXFAForm, 'pdfGetInIsXFAForm');{$endif}
   retval := pdfGetInIsXFAForm(FInstance);
   if retval < 0 then
      Result := false
   else
      Result := retval <> 0;
end;

function TPDF.GetInkList(const List: Pointer; Points: PSingle; Count: PCardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInkList, 'pdfGetInkList');{$endif}
   Result := pdfGetInkList(List, Points, Count);
end;

function TPDF.GetInMetadata(PageNum: Integer; var Buffer: PByte; var BufSize: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInMetadata, 'pdfGetInMetadata');{$endif}
   Result := pdfGetInMetadata(FInstance, PageNum, Buffer, BufSize);
end;

function TPDF.GetInOrientation(PageNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInOrientation, 'pdfGetInOrientation');{$endif}
   Result := pdfGetInOrientation(FInstance, PageNum);
end;

function TPDF.GetInPageCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInPageCount, 'pdfGetInPageCount');{$endif}
   Result := pdfGetInPageCount(FInstance);
end;

function TPDF.GetInPDFVersion(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInPDFVersion, 'pdfGetInPDFVersion');{$endif}
   Result := pdfGetInPDFVersion(FInstance);
end;

function TPDF.GetInPDFVersionEx(Value: PPDFVersionInfo): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInPDFVersionEx, 'pdfGetInPDFVersionEx');{$endif}
   Result := pdfGetInPDFVersionEx(FInstance, Value);
end;

function TPDF.GetInPrintSettings(var Settings: TPDFPrintSettings): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInPrintSettings, 'pdfGetInPrintSettings');{$endif}
   Result := pdfGetInPrintSettings(FInstance, Settings);
end;

function TPDF.GetInRepairMode: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetInRepairMode, 'pdfGetInRepairMode');{$endif}
   Result := pdfGetInRepairMode(FInstance);
end;

function TPDF.GetIsFixedPitch(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetIsFixedPitch, 'pdfGetIsFixedPitch');{$endif}
   Result := pdfGetIsFixedPitch(FInstance);
end;

function TPDF.GetIsTaggingEnabled: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetIsTaggingEnabled, 'pdfGetIsTaggingEnabled');{$endif}
   Result := pdfGetIsTaggingEnabled(FInstance);
end;

function TPDF.GetItalicAngle(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetItalicAngle, 'pdfGetItalicAngle');{$endif}
   Result := pdfGetItalicAngle(FInstance);
end; 

function TPDF.GetJavaScript(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScript, 'pdfGetJavaScript');{$endif}
   Result := pdfGetJavaScript(FInstance, Handle, Len, Unicode);
end;

function TPDF.GetJavaScriptAction(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptAction, 'pdfGetJavaScriptAction');{$endif}
   Result := pdfGetJavaScriptAction(FInstance, Handle, Len, Unicode);
end;

function TPDF.GetJavaScriptAction2(ObjType: TObjType; ObjHandle, ActIndex: Cardinal; var Len: Cardinal; var Unicode: LongBool; var Event: TObjEvent): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptAction2, 'pdfGetJavaScriptAction2');{$endif}
   Result := pdfGetJavaScriptAction2(FInstance, ObjType, ObjHandle, ActIndex, Len, Unicode, Event);
end;

function TPDF.GetJavaScriptActionEx(Handle: Cardinal; var Action: TPDFJavaScriptAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptActionEx, 'pdfGetJavaScriptActionEx');{$endif}
   Result := pdfGetJavaScriptActionEx(FInstance, Handle, Action);
end;

function TPDF.GetJavaScriptCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptCount, 'pdfGetJavaScriptCount');{$endif}
   Result := pdfGetJavaScriptCount(FInstance);
end;

function TPDF.GetJavaScriptEx(const Name: AnsiString; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptEx, 'pdfGetJavaScriptEx');{$endif}
   Result := pdfGetJavaScriptEx(FInstance, PAnsiChar(Name), Len, Unicode);
end;

function TPDF.GetJavaScriptName(Handle: Cardinal; var Len: Cardinal; var Unicode: LongBool): PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJavaScriptName, 'pdfGetJavaScriptName');{$endif}
   Result := pdfGetJavaScriptName(FInstance, Handle, Len, Unicode);
end;

function TPDF.GetJPEGQuality: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetJPEGQuality, 'pdfGetJPEGQuality');{$endif}
   Result := pdfGetJPEGQuality(FInstance);
end;

function TPDF.GetLanguage(): AnsiString;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLanguage, 'pdfGetLanguage');{$endif}
   Result := pdfGetLanguage(FInstance);
end;

function TPDF.GetLastTextPosX(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLastTextPosX, 'pdfGetLastTextPosX');{$endif}
   Result := pdfGetLastTextPosX(FInstance);
end;

function TPDF.GetLastTextPosXAbs(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLastTextPosXAbs, 'pdfGetLastTextPosXAbs');{$endif}
   Result := pdfGetLastTextPosXAbs(FInstance);
end;

function TPDF.GetLastTextPosY(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLastTextPosY, 'pdfGetLastTextPosY');{$endif}
   Result := pdfGetLastTextPosY(FInstance);
end;

function TPDF.GetLastTextPosYAbs(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLastTextPosYAbs, 'pdfGetLastTextPosYAbs');{$endif}
   Result := pdfGetLastTextPosYAbs(FInstance);
end;

function TPDF.GetLaunchAction(Handle: Cardinal; var Action: TPDFLaunchAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLaunchAction, 'pdfGetLaunchAction');{$endif}
   Result := pdfGetLaunchAction(FInstance, Handle, Action);
end;

function TPDF.GetLayerConfig(Index: Integer; var Config: TPDFOCLayerConfig): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLayerConfig, 'pdfGetLayerConfig');{$endif}
   Result := pdfGetLayerConfig(FInstance, Index, Config);
end;

function TPDF.GetLayerConfigCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLayerConfigCount, 'pdfGetLayerConfigCount');{$endif}
   Result := pdfGetLayerConfigCount(FInstance);
end;

function TPDF.GetLeading(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLeading, 'pdfGetLeading');{$endif}
   Result := pdfGetLeading(FInstance);
end;

{$ifdef DYNLNK}
function TPDF.GetLibHandle: HMODULE;
begin
   Result := FDLL_Handle;
end;

function TPDF.GetLibName(): String;
begin
   Result := FLibName;
end;
{$endif}

function TPDF.GetLineCapStyle(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLineCapStyle, 'pdfGetLineCapStyle');{$endif}
   Result := pdfGetLineCapStyle(FInstance);
end;

function TPDF.GetLineJoinStyle(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLineJoinStyle, 'pdfGetLineJoinStyle');{$endif}
   Result := pdfGetLineJoinStyle(FInstance);
end;

function TPDF.GetLineWidth(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLineWidth, 'pdfGetLineWidth');{$endif}
   Result := pdfGetLineWidth(FInstance);
end;

function TPDF.GetLinkHighlightMode(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLinkHighlightMode, 'pdfGetLinkHighlightMode');{$endif}
   Result := pdfGetLinkHighlightMode(FInstance);
end;

function TPDF.GetLogMetafileSize(const FileName: AnsiString; var R: TRectL): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLogMetafileSizeA, 'pdfGetLogMetafileSizeA');{$endif}
   Result := pdfGetLogMetafileSizeA(FInstance, PAnsiChar(FileName), R);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetLogMetafileSize(const FileName: WideString; var R: TRectL): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLogMetafileSizeW, 'pdfGetLogMetafileSizeW');{$endif}
   Result := pdfGetLogMetafileSizeW(FInstance, PWideChar(FileName), R);
end;
{$endif}

function TPDF.GetLogMetafileSizeA(const FileName: AnsiString; var R: TRectL): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLogMetafileSizeA, 'pdfGetLogMetafileSizeA');{$endif}
   Result := pdfGetLogMetafileSizeA(FInstance, PAnsiChar(FileName), R);
end;

function TPDF.GetLogMetafileSizeW(const FileName: WideString; var R: TRectL): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLogMetafileSizeW, 'pdfGetLogMetafileSizeW');{$endif}
   Result := pdfGetLogMetafileSizeW(FInstance, PWideChar(FileName), R);
end;

function TPDF.GetLogMetafileSizeEx(const Buffer: Pointer; BufSize: Cardinal; var R: TRectL): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetLogMetafileSizeEx, 'pdfGetLogMetafileSizeEx');{$endif}
   Result := pdfGetLogMetafileSizeEx(FInstance, Buffer, BufSize, R);
end;

function TPDF.GetMatrix(var M: TCTM): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMatrix, 'pdfGetMatrix');{$endif}
   Result := pdfGetMatrix(FInstance, M);
end;

function TPDF.GetMaxFieldLen(TxtField: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMaxFieldLen, 'pdfGetMaxFieldLen');{$endif}
   Result := pdfGetMaxFieldLen(FInstance, TxtField);
end;

function TPDF.GetMeasureObj(const MeasurePtr: IMSR; var Value: TPDFMeasure): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMeasureObj, 'pdfGetMeasureObj');{$endif}
   Result := pdfGetMeasureObj(MeasurePtr, Value);
end;

function TPDF.GetMetaConvFlags(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMetaConvFlags, 'pdfGetMetaConvFlags');{$endif}
   Result := pdfGetMetaConvFlags(FInstance);
end;

function TPDF.GetMetadata(ObjType: TMetadataObj; Handle: Integer; var Buffer: PByte; var BufSize: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMetadata, 'pdfGetMetadata');{$endif}
   Result := pdfGetMetadata(FInstance, ObjType, Handle, Buffer, BufSize);
end;

function TPDF.GetMissingGlyphs(var Count: Cardinal): PCardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMissingGlyphs, 'pdfGetMissingGlyphs');{$endif}
   Result := pdfGetMissingGlyphs(FInstance, Count);
end;

function TPDF.GetMiterLimit(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMiterLimit, 'pdfGetMiterLimit');{$endif}
   Result := pdfGetMiterLimit(FInstance);
end;

function TPDF.GetMovieAction(Handle: Cardinal; var Action: TPDFMovieAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetMovieAction, 'pdfGetMovieAction');{$endif}
   Result := pdfGetMovieAction(FInstance, Handle, Action);
end;

function TPDF.GetNamedAction(Handle: Cardinal; var Action: TPDFNamedAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetNamedAction, 'pdfGetNamedAction');{$endif}
   Result := pdfGetNamedAction(FInstance, Handle, Action);
end;

function TPDF.GetNamedDest(Index: Cardinal; var Dest: TPDFNamedDest): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetNamedDest, 'pdfGetNamedDest');{$endif}
   Dest.StructSize := sizeof(TPDFNamedDest);
   Result := pdfGetNamedDest(FInstance, Index, Dest);
end;

function TPDF.GetNamedDestCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetNamedDestCount, 'pdfGetNamedDestCount');{$endif}
   Result := pdfGetNamedDestCount(FInstance);
end;

function TPDF.GetNeedAppearance: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetNeedAppearance, 'pdfGetNeedAppearance');{$endif}
   Result := pdfGetNeedAppearance(FInstance);
end;

function TPDF.GetNumberFormatObj(const NumberFmtPtr: INFM; var Value: TPDFNumberFormat): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetNumberFormatObj, 'pdfGetNumberFormatObj');{$endif}
   Result := pdfGetNumberFormatObj(NumberFmtPtr, Value);
end;

function TPDF.GetObjActionCount(ObjType: TObjType; ObjHandle: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetObjActionCount, 'pdfGetObjActionCount');{$endif}
   Result := pdfGetObjActionCount(FInstance, Ord(ObjType), ObjHandle);
end;

function TPDF.GetObjActions(ObjType: TObjType; ObjHandle: Cardinal; var Actions: TPDFObjActions): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetObjActions, 'pdfGetObjActions');{$endif}
   Result := pdfGetObjActions(FInstance, ObjType, ObjHandle, Actions);
end;

function TPDF.GetObjEvent(const IEvent: IEVT; var Event: TPDFObjEvent): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetObjEvent, 'pdfGetObjEvent');{$endif}
   Result := pdfGetObjEvent(IEvent, Event);
end;

function TPDF.GetOCG(Handle: Cardinal; var Value: TPDFOCG): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCG, 'pdfGetOCG');{$endif}
   Result := pdfGetOCG(FInstance, Handle, Value);
end;

function TPDF.GetOCGContUsage(Handle: Cardinal; var Value: TPDFOCGContUsage): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCGContUsage, 'pdfGetOCGContUsage');{$endif}
   Result := pdfGetOCGContUsage(FInstance, Handle, Value);
end;

function TPDF.GetOCGCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCGCount, 'pdfGetOCGCount');{$endif}
   Result := pdfGetOCGCount(FInstance);
end;

function TPDF.GetOCGUsageUserName(Handle, Index: Cardinal; var NameA: PAnsiChar; var NameW: PWideChar): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCGUsageUserName, 'pdfGetOCGUsageUserName');{$endif}
   Result := pdfGetOCGUsageUserName(FInstance, Handle, Index, NameA, NameW);
end;

function TPDF.GetOCHandle(const OC: Pointer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCHandle, 'pdfGetOCHandle');{$endif}
   Result := pdfGetOCHandle(OC);
end;

function TPDF.GetOCUINode(const Node: IOCN; UINode: PPDFOCUINode): IOCN;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOCUINode, 'pdfGetOCUINode');{$endif}
   Result := pdfGetOCUINode(FInstance, Node, UINode);
end;

function TPDF.GetOpacity(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOpacity, 'pdfGetOpacity');{$endif}
   Result := pdfGetOpacity(FInstance);
end;

function TPDF.GetOrientation(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOrientation, 'pdfGetOrientation');{$endif}
   Result := pdfGetOrientation(FInstance);
end;

function TPDF.GetOutputIntent(Index: Cardinal; var Intent: TPDFOutputIntent): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOutputIntent, 'pdfGetOutputIntent');{$endif}
   Result := pdfGetOutputIntent(FInstance, Index, Intent);
end;

function TPDF.GetOutputIntentCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetOutputIntentCount, 'pdfGetOutputIntentCount');{$endif}
   Result := pdfGetOutputIntentCount(FInstance);
end;

function TPDF.GetPageAnnot(Index: Cardinal; var Annot: TPDFAnnotation): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageAnnot, 'pdfGetPageAnnot');{$endif}
   Result := pdfGetPageAnnot(FInstance, Index, Annot);
end;

function TPDF.GetPageAnnotCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageAnnotCount, 'pdfGetPageAnnotCount');{$endif}
   Result := pdfGetPageAnnotCount(FInstance);
end;

function TPDF.GetPageAnnotEx(Index: Cardinal; var Annot: TPDFAnnotationEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageAnnotEx, 'pdfGetPageAnnotEx');{$endif}
   Result := pdfGetPageAnnotEx(FInstance, Index, Annot);
end;

function TPDF.GetPageBBox(PagePtr: IPGE; Boundary: TPageBoundary; var BBox: TFltRect): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageBBox, 'pdfGetPageBBox');{$endif}
   Result := pdfGetPageBBox(PagePtr, Boundary, BBox);
end;

function TPDF.GetPageCoords(): TPageCoord;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageCoords, 'pdfGetPageCoords');{$endif}
   Result := TPageCoord(pdfGetPageCoords(FInstance));
end;

function TPDF.GetPageCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageCount, 'pdfGetPageCount');{$endif}
   Result := pdfGetPageCount(FInstance);
end;

function TPDF.GetPageField(Index: Cardinal; var Field: TPDFField): Boolean;
begin
   {
      Note: FieldName can be an Unicode string!
      To determine whether FieldName contains an ANSI or Unicode string
      proceed as follows:
      if f.FielNameLen > 0 and StrLen(f.FieldName) <> f.FieldNameLen then begin
         // f.FieldName contains a null-terminated Unicode string
         // f.FieldNameLen is the length in Unicode characters, but we have an ANSI string!
         // So, we must multiply the length with 2 to convert the entire string!
         nameW := pdf.ToUnicode(f.FieldName, f.FieldNameLen * 2);         
      end;
   }
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageField, 'pdfGetPageField');{$endif}
   Result := pdfGetPageField(FInstance, Index, Field);
end;

function TPDF.GetPageFieldCount(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageFieldCount, 'pdfGetPageFieldCount');{$endif}
   Result := pdfGetPageFieldCount(FInstance);
end;

function TPDF.GetPageFieldEx(Index: Cardinal; var Field: TPDFFieldEx): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageFieldEx, 'pdfGetPageFieldEx');{$endif}
   Field.StructSize := sizeof(Field);
   Result := pdfGetPageFieldEx(FInstance, Index, Field);
end;

function TPDF.GetPageHeight(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageHeight, 'pdfGetPageHeight');{$endif}
   Result := pdfGetPageHeight(FInstance);
end;

function TPDF.GetPageLabel(Index: Cardinal; var Lbl: TPDFPageLabel): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageLabel, 'pdfGetPageLabel');{$endif}
   Result := pdfGetPageLabel(FInstance, Index, Lbl);
end;

function TPDF.GetPageLabelCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageLabelCount, 'pdfGetPageLabelCount');{$endif}
   Result := pdfGetPageLabelCount(FInstance);
end;

function TPDF.GetPageLayout(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageLayout, 'pdfGetPageLayout');{$endif}
   Result := pdfGetPageLayout(FInstance);
end;

function TPDF.GetPageMode(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageMode, 'pdfGetPageMode');{$endif}
   Result := pdfGetPageMode(FInstance);
end;

function TPDF.GetPageNum: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageNum, 'pdfGetPageNum');{$endif}
   Result := pdfGetPageNum(FInstance);
end;

function TPDF.GetPageObject(PageNum: Cardinal): Pointer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageObject, 'pdfGetPageObject');{$endif}
   Result := pdfGetPageObject(FInstance, PageNum);
end;

function TPDF.GetPageOrientation(PagePtr: IPGE): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageOrientation, 'pdfGetPageOrientation');{$endif}
   Result := pdfGetPageOrientation(PagePtr);
end;

function TPDF.GetPageText(var Stack: TPDFStack): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageText, 'pdfGetPageText');{$endif}
   Result := pdfGetPageText(FInstance, Stack);
end;

function TPDF.GetPageWidth(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPageWidth, 'pdfGetPageWidth');{$endif}
   Result := pdfGetPageWidth(FInstance);
end;

function TPDF.GetPDFVersion(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPDFVersion, 'pdfGetPDFVersion');{$endif}
   Result := pdfGetPDFVersion(FInstance);
end;

function TPDF.GetPDFVersionEx(var Value: TPDFVersionInfo): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPDFVersionEx, 'pdfGetPDFVersionEx');{$endif}
   Result := pdfGetPDFVersionEx(FInstance, Value);
end;

function TPDF.GetPrintSettings(var Settings: TPDFPrintSettings): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPrintSettings, 'pdfGetPrintSettings');{$endif}
   Result := pdfGetPrintSettings(FInstance, Settings);
end;

function TPDF.GetPtDataArray(const PtData: IPTD; Index: Cardinal; var DataType: PAnsiChar; var Values: PSingle; var ValCount: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPtDataArray, 'pdfGetPtDataArray');{$endif}
   Result := pdfGetPtDataArray(PtData, Index, DataType, Values, ValCount);
end;

function TPDF.GetPtDataObj(const PtData: IPTD; var Subtype: PAnsiChar; var NumArrays: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetPtDataObj, 'pdfGetPtDataObj');{$endif}
   Result := pdfGetPtDataObj(PtData, Subtype, NumArrays);
end;

function TPDF.GetRelFileNode(const IRF: IRFN; var F: TPDFRelFileNode; Decompress: Boolean): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetRelFileNode, 'pdfGetRelFileNode');{$endif}
   Result := pdfGetRelFileNode(IRF, F, Decompress);
end;

function TPDF.GetResetAction(Handle: Cardinal; var Value: TPDFResetFormAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetResetAction, 'pdfGetResetAction');{$endif}
   Result := pdfGetResetAction(FInstance, Handle, Value);
end;

function TPDF.GetResolution(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetResolution, 'pdfGetResolution');{$endif}
   Result := pdfGetResolution(FInstance);
end;

function TPDF.GetSaveNewImageFormat(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetSaveNewImageFormat, 'pdfGetSaveNewImageFormat');{$endif}
   Result := pdfGetSaveNewImageFormat(FInstance);
end;

function TPDF.GetSeparationInfo(var Colorant: AnsiString; var CS: TExtColorSpace): Boolean;
var clt: PAnsiChar;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetSeparationInfo, 'pdfGetSeparationInfo');{$endif}
   clt := nil;
   Result := pdfGetSeparationInfo(FInstance, clt, CS);
   Colorant := clt;
end;

function TPDF.GetSigDict(const ISignature: Pointer; var SigDict: TPDFSigDict): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetSigDict, 'pdfGetSigDict');{$endif}
   SigDict.StructSize := sizeof(TPDFSigDict);
   Result := pdfGetSigDict(ISignature, SigDict);
end;

function TPDF.GetSpaceWidth(const IFont: PFNT; FontSize: Double): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@fntGetSpaceWidth, 'fntGetSpaceWidth');{$endif}
   Result := fntGetSpaceWidth(IFont, FontSize);
end;

function TPDF.GetStrokeColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetStrokeColor, 'pdfGetStrokeColor');{$endif}
   Result := pdfGetStrokeColor(FInstance);
end;

function TPDF.GetSubmitAction(Handle: Cardinal; var Value: TPDFSubmitFormAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetSubmitAction, 'pdfGetSubmitAction');{$endif}
   Result := pdfGetSubmitAction(FInstance, Handle, Value);
end;

function TPDF.GetSysFontInfo(Handle: Cardinal; var Value: TPDFSysFont): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetSysFontInfo, 'pdfGetSysFontInfo');{$endif}
   Result := pdfGetSysFontInfo(FInstance, Handle, Value);
end;

function TPDF.GetTabLen: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTabLen, 'pdfGetTabLen');{$endif}
   Result := pdfGetTabLen(FInstance);
end;

function TPDF.GetTemplCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTemplCount, 'pdfGetTemplCount');{$endif}
   Result := pdfGetTemplCount(FInstance);
end;

function TPDF.GetTemplHandle: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTemplHandle, 'pdfGetTemplHandle');{$endif}
   Result := pdfGetTemplHandle(FInstance);
end;

function TPDF.GetTemplHeight(TmplHandle: Integer): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTemplHeight, 'pdfGetTemplHeight');{$endif}
   Result := pdfGetTemplHeight(FInstance, TmplHandle);
end;

function TPDF.GetTemplWidth(TmplHandle: Integer): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTemplWidth, 'pdfGetTemplWidth');{$endif}
   Result := pdfGetTemplWidth(FInstance, TmplHandle);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetTextBBox(const Text: AnsiString; var BBox: TBBox): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextBBoxA, 'pdfGetTextBBoxA');{$endif}
   Result := pdfGetTextBBoxA(FInstance, PAnsiChar(Text), Length(Text), BBox);
end;

function TPDF.GetTextBBox(const Text: WideString; var BBox: TBBox): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextBBoxW, 'pdfGetTextBBoxW');{$endif}
   Result := pdfGetTextBBoxW(FInstance, PWideChar(Text), Length(Text), BBox);
end;
{$endif}

function TPDF.GetTextBBoxA(const Text: AnsiString; var BBox: TBBox): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextBBoxA, 'pdfGetTextBBoxA');{$endif}
   Result := pdfGetTextBBoxA(FInstance, PAnsiChar(Text), Length(Text), BBox);
end;

function TPDF.GetTextBBoxW(const Text: WideString; var BBox: TBBox): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextBBoxW, 'pdfGetTextBBoxW');{$endif}
   Result := pdfGetTextBBoxW(FInstance, PWideChar(Text), Length(Text), BBox);
end;

function TPDF.GetTextDrawMode(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextDrawMode, 'pdfGetTextDrawMode');{$endif}
   Result := pdfGetTextDrawMode(FInstance);
end;

function TPDF.GetTextFieldValue(AField: Cardinal; var Value: PAnsiChar; var ValIsUnicode: LongBool; var DefValue: PAnsiChar; var DefValIsUnicode: LongBool): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextFieldValue, 'pdfGetTextFieldValue');{$endif}
   Result := pdfGetTextFieldValue(FInstance, AField, Value, ValIsUnicode, DefValue, DefValIsUnicode);
end;

function TPDF.GetTextRect(var PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextRect, 'pdfGetTextRect');{$endif}
   Result := pdfGetTextRect(FInstance, PosX, PosY, Width, Height);
end;

function TPDF.GetTextRise(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextRise, 'pdfGetTextRise');{$endif}
   Result := pdfGetTextRise(FInstance);
end;

function TPDF.GetTextScaling(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextScaling, 'pdfGetTextScaling');{$endif}
   Result := pdfGetTextScaling(FInstance);
end;

function TPDF.GetTextWidth(const IFont: PFNT; const Text: PAnsiChar; Len: Cardinal; CharSpacing, WordSpacing, TextScale: Single): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@fntGetTextWidth, 'fntGetTextWidth');{$endif}
   Result := fntGetTextWidth(IFont, Text, Len, CharSpacing, WordSpacing, TextScale);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.GetTextWidth(const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthA, 'pdfGetTextWidthA');{$endif}
   Result := pdfGetTextWidthA(FInstance, PAnsiChar(AText));
end;

function TPDF.GetTextWidth(const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthW, 'pdfGetTextWidthW');{$endif}
   Result := pdfGetTextWidthW(FInstance, PWideChar(AText));
end;

function TPDF.GetTextWidthEx(const AText: AnsiString; Len: Cardinal): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthExA, 'pdfGetTextWidthExA');{$endif}
   Result := pdfGetTextWidthExA(FInstance, PAnsiChar(AText), Len);
end;

function TPDF.GetTextWidthEx(const AText: WideString; Len: Cardinal): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthExW, 'pdfGetTextWidthExW');{$endif}
   Result := pdfGetTextWidthExW(FInstance, PWideChar(AText), Len);
end;
{$endif}

function TPDF.GetTextWidthA(const AText: AnsiString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthA, 'pdfGetTextWidthA');{$endif}
   Result := pdfGetTextWidthA(FInstance, PAnsiChar(AText));
end;

function TPDF.GetTextWidthW(const AText: WideString): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthW, 'pdfGetTextWidthW');{$endif}
   Result := pdfGetTextWidthW(FInstance, PWideChar(AText));
end;

function TPDF.GetTextWidthExA(const AText: AnsiString; Len: Cardinal): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthExA, 'pdfGetTextWidthExA');{$endif}
   Result := pdfGetTextWidthExA(FInstance, PAnsiChar(AText), Len);
end;

function TPDF.GetTextWidthExW(const AText: WideString; Len: Cardinal): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTextWidthExW, 'pdfGetTextWidthExW');{$endif}
   Result := pdfGetTextWidthExW(FInstance, PWideChar(AText), Len);
end;

function TPDF.GetTransparentColor(): Cardinal;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTransparentColor, 'pdfGetTransparentColor');{$endif}
   Result := pdfGetTransparentColor(FInstance);
end;

function TPDF.GetTrapped: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTrapped, 'pdfGetTrapped');{$endif}
   Result := pdfGetTrapped(FInstance);
end;

function TPDF.GetTypoLeading: Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetTypoLeading, 'pdfGetTypoLeading');{$endif}
   Result := pdfGetTypoLeading(FInstance);
end;

function TPDF.GetURIAction(Handle: Cardinal; var Action: TPDFURIAction): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetURIAction, 'pdfGetURIAction');{$endif}
   Result := pdfGetURIAction(FInstance, Handle, Action);
end;

function TPDF.GetUseTransparency(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseTransparency, 'pdfGetUseTransparency');{$endif}
   Result := pdfGetUseTransparency(FInstance);
end;

function TPDF.GetUseVisibleCoords(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseVisibleCoords, 'pdfGetUseVisibleCoords');{$endif}
   Result := pdfGetUseVisibleCoords(FInstance);
end;

function TPDF.GetUseExactPwd(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseExactPwd, 'pdfGetUseExactPwd');{$endif}
   Result := pdfGetUseExactPwd(FInstance);
end;

function TPDF.GetUseGlobalImpFiles(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseGlobalImpFiles, 'pdfGetUseGlobalImpFiles');{$endif}
   Result := pdfGetUseGlobalImpFiles(FInstance);
end;

function TPDF.GetUserRights(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUserRights, 'pdfGetUserRights');{$endif}
   Result := pdfGetUserRights(FInstance);
end;

function TPDF.GetUserUnit: Single;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUserUnit, 'pdfGetUserUnit');{$endif}
   Result := pdfGetUserUnit(FInstance);
end;

function TPDF.GetUseStdFonts(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseStdFonts, 'pdfGetUseStdFonts');{$endif}
   Result := pdfGetUseStdFonts(FInstance);
end;

function TPDF.GetUseSystemFonts(): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUseSystemFonts, 'pdfGetUseSystemFonts');{$endif}
   Result := pdfGetUseSystemFonts(FInstance);
end;

function TPDF.GetUsesTransparency(PageNum: Integer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetUsesTransparency, 'pdfGetUsesTransparency');{$endif}
   Result := pdfGetUsesTransparency(FInstance, PageNum);
end;

function TPDF.GetViewerPreferences(var Preference, AddVal: Integer): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetViewerPreferences, 'pdfGetViewerPreferences');{$endif}
   Result := pdfGetViewerPreferences(FInstance, Preference, AddVal);
end;

function TPDF.GetViewport(PageNum, Index: Cardinal; var VP: TPDFViewport): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetViewport, 'pdfGetViewport');{$endif}
   Result := pdfGetViewport(FInstance, PageNum, Index, VP);
end;

function TPDF.GetViewportCount(PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetViewportCount, 'pdfGetViewportCount');{$endif}
   Result := pdfGetViewportCount(FInstance, PageNum);
end;

function TPDF.GetWidthHeight(PagePtr: IPGE; Flags: TRasterFlags; var Width, Height: Single; Rotate: Integer; var BBox: PFltRect): LongBool;
begin
   {$ifdef DYNLNK}LoadFunction(@rasGetWidthHeight, 'rasGetWidthHeight');{$endif}
   Result := rasGetWidthHeight(PagePtr, Flags, Width, Height, Rotate, PPointer(@BBox));
end;

function TPDF.GetWMFDefExtent(var Width, Height: Cardinal): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetWMFDefExtent, 'pdfGetWMFDefExtent');{$endif}
   Result := pdfGetWMFDefExtent(FInstance, Width, Height);
end;

function TPDF.GetWMFPixelPerInch(): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetWMFPixelPerInch, 'pdfGetWMFPixelPerInch');{$endif}
   Result := pdfGetWMFPixelPerInch(FInstance);
end;

function TPDF.GetWordSpacing(): Double;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetWordSpacing, 'pdfGetWordSpacing');{$endif}
   Result := pdfGetWordSpacing(FInstance);
end;

function TPDF.GetXFAStream(Index: Cardinal; OutStrm: PPDFXFAStream): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetXFAStream, 'pdfGetXFAStream');{$endif}
   Result := pdfGetXFAStream(FInstance, Index, OutStrm);
end;

function TPDF.GetXFAStreamCount: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfGetXFAStreamCount, 'pdfGetXFAStreamCount');{$endif}
   Result := pdfGetXFAStreamCount(FInstance);
end;

function TPDF.HaveDPartRoot: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHaveDPartRoot, 'pdfHaveDPartRoot');{$endif}
   Result := pdfHaveDPartRoot(FInstance);
end;

function TPDF.HaveOpenDoc: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHaveOpenDoc, 'pdfHaveOpenDoc');{$endif}
   Result := pdfHaveOpenDoc(FInstance);
end;

function TPDF.HaveOpenPage: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHaveOpenPage, 'pdfHaveOpenPage');{$endif}
   Result := pdfHaveOpenPage(FInstance);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.HighlightAnnot(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHighlightAnnotA, 'pdfHighlightAnnotA');{$endif}
   Result := pdfHighlightAnnotA(FInstance, SubType, PosX, PosY, Width, Height, Color, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Comment));
end;

function TPDF.HighlightAnnot(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHighlightAnnotW, 'pdfHighlightAnnotW');{$endif}
   Result := pdfHighlightAnnotW(FInstance, SubType, PosX, PosY, Width, Height, Color, PWideChar(Author), PWideChar(Subject), PWideChar(Comment));
end;
{$endif}

function TPDF.HighlightAnnotA(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHighlightAnnotA, 'pdfHighlightAnnotA');{$endif}
   Result := pdfHighlightAnnotA(FInstance, SubType, PosX, PosY, Width, Height, Color, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Comment));
end;

function TPDF.HighlightAnnotW(SubType: TAnnotType; PosX, PosY, Width, Height: Double; Color: Cardinal; const Author, Subject, Comment: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfHighlightAnnotW, 'pdfHighlightAnnotW');{$endif}
   Result := pdfHighlightAnnotW(FInstance, SubType, PosX, PosY, Width, Height, Color, PWideChar(Author), PWideChar(Subject), PWideChar(Comment));
end;

function TPDF.ImportBookmarks: Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportBookmarks, 'pdfImportBookmarks');{$endif}
   Result := pdfImportBookmarks(FInstance);
end;

function TPDF.ImportCatalogObjects: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportCatalogObjects, 'pdfImportCatalogObjects');{$endif}
   Result := pdfImportCatalogObjects(FInstance);
end;

function TPDF.ImportDocInfo: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportDocInfo, 'pdfImportDocInfo');{$endif}
   Result := pdfImportDocInfo(FInstance);
end;

function TPDF.ImportEncryptionSettings: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportEncryptionSettings, 'pdfImportEncryptionSettings');{$endif}
   Result := pdfImportEncryptionSettings(FInstance);
end;

function TPDF.ImportOCProperties: Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportOCProperties, 'pdfImportOCProperties');{$endif}
   Result := pdfImportOCProperties(FInstance);
end;

function TPDF.ImportPage(PageNum: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportPage, 'pdfImportPage');{$endif}
   Result := pdfImportPage(FInstance, PageNum);
end;

function TPDF.ImportPageEx(PageNum: Cardinal; ScaleFactX, ScaleFactY: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportPageEx, 'pdfImportPageEx');{$endif}
   Result := pdfImportPageEx(FInstance, PageNum, ScaleFactX, ScaleFactY);
end;

function TPDF.ImportPDFFile(DestPage: Cardinal; ScaleFactX, ScaleFactY: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfImportPDFFile, 'pdfImportPDFFile');{$endif}
   Result := pdfImportPDFFile(FInstance, DestPage, ScaleFactX, ScaleFactY);
end;

function TPDF.InitBarcode2(var Barcode: TPDFBarcode2): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitBarcode2, 'pdfInitBarcode2');{$endif}
   Barcode.StructSize := sizeof(Barcode);
   Result := pdfInitBarcode2(Barcode);
end;

function TPDF.InitColorManagement(Profiles: PPDFColorProfiles; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitColorManagement, 'pdfInitColorManagement');{$endif}
   Result := pdfInitColorManagement(FInstance, Profiles, DestSpace, Flags);
end;

function TPDF.InitColorManagementEx(Profiles: PPDFColorProfilesEx; DestSpace: TPDFColorSpace; Flags: TPDFInitCMFlags): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitColorManagementEx, 'pdfInitColorManagementEx');{$endif}
   Result := pdfInitColorManagementEx(FInstance, Profiles, DestSpace, Flags);
end;

function TPDF.InitExtGState(var GS: TPDFExtGState): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitExtGState, 'pdfInitExtGState');{$endif}
   Result := pdfInitExtGState(GS);
end;

function TPDF.InitHeaderFooter(var Value: TPDFHeaderFooter; var HFArray: Array of TPDFHdrFtr): Boolean;
begin
   Value.StructSize := sizeof(Value);
   {$ifdef DYNLNK}LoadFunction(@pdfInitHeaderFooter, 'pdfInitHeaderFooter');{$endif}
   Result := pdfInitHeaderFooter(Value, @HFArray[0], High(HFArray) +1);
end;

function TPDF.InitOCGContUsage(var Value: TPDFOCGContUsage): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitOCGContUsage, 'pdfInitOCGContUsage');{$endif}
   Result := pdfInitOCGContUsage(Value);
end;

function TPDF.InitStack(var Stack: TPDFStack): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInitStack, 'pdfInitStack');{$endif}
   Result := pdfInitStack(FInstance, Stack);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.InkAnnot(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInkAnnotA, 'pdfInkAnnotA');{$endif}
   Result := pdfInkAnnotA(FInstance, Points, NumPoints, LineWidth, Color, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Content));
end;

function TPDF.InkAnnot(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInkAnnotW, 'pdfInkAnnotW');{$endif}
   Result := pdfInkAnnotW(FInstance, Points, NumPoints, LineWidth, Color, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Content));
end;
{$endif}

function TPDF.InkAnnotA(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInkAnnotA, 'pdfInkAnnotA');{$endif}
   Result := pdfInkAnnotA(FInstance, Points, NumPoints, LineWidth, Color, CS, PAnsiChar(Author), PAnsiChar(Subject), PAnsiChar(Content));
end;

function TPDF.InkAnnotW(Points: PFltPoint; NumPoints: Cardinal; LineWidth: Double; Color: Cardinal; CS: TPDFColorSpace; const Author, Subject, Content: WideString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInkAnnotW, 'pdfInkAnnotW');{$endif}
   Result := pdfInkAnnotW(FInstance, Points, NumPoints, LineWidth, Color, CS, PWideChar(Author), PWideChar(Subject), PWideChar(Content));
end;

function TPDF.InsertBarcode(PosX, PosY, Width, Height: Double; HAlign, VAlign: TCellAlign; var Barcode: TPDFBarcode2): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBarcode, 'pdfInsertBarcode');{$endif}
   Result := pdfInsertBarcode(FInstance, PosX, PosY, Width, Height, HAlign, VAlign, Barcode);
end;

function TPDF.InsertBMPFromBuffer(PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBMPFromBuffer, 'pdfInsertBMPFromBuffer');{$endif}
   Result := pdfInsertBMPFromBuffer(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, Buffer);
end;

function TPDF.InsertBMPFromHandle(PosX, PosY, ScaleWidth, ScaleHeight: Double; Handle: HBITMAP): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBMPFromHandle, 'pdfInsertBMPFromHandle');{$endif}
   Result := pdfInsertBMPFromHandle(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, Pointer(Handle));
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.InsertBookmark(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkA, 'pdfInsertBookmarkA');{$endif}
   Result := pdfInsertBookmarkA(FInstance, PAnsiChar(Title), Parent, DestPage, Open, AddChildren);
end;

function TPDF.InsertBookmark(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkW, 'pdfInsertBookmarkW');{$endif}
   Result := pdfInsertBookmarkW(FInstance, PWideChar(Title), Parent, DestPage, Open, AddChildren);
end;

function TPDF.InsertBookmarkEx(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkExA, 'pdfInsertBookmarkExA');{$endif}
   Result := pdfInsertBookmarkExA(FInstance, PAnsiChar(Title), Parent, NamedDest, Open, AddChildren);
end;

function TPDF.InsertBookmarkEx(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkExW, 'pdfInsertBookmarkExW');{$endif}
   Result := pdfInsertBookmarkExW(FInstance, PWideChar(Title), Parent, NamedDest, Open, AddChildren);
end;
{$endif}

function TPDF.InsertBookmarkA(const Title: AnsiString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkA, 'pdfInsertBookmarkA');{$endif}
   Result := pdfInsertBookmarkA(FInstance, PAnsiChar(Title), Parent, DestPage, Open, AddChildren);
end;

function TPDF.InsertBookmarkW(const Title: WideString; Parent: Integer; DestPage: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkW, 'pdfInsertBookmarkW');{$endif}
   Result := pdfInsertBookmarkW(FInstance, PWideChar(Title), Parent, DestPage, Open, AddChildren);
end;

function TPDF.InsertBookmarkExA(const Title: AnsiString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkExA, 'pdfInsertBookmarkExA');{$endif}
   Result := pdfInsertBookmarkExA(FInstance, PAnsiChar(Title), Parent, NamedDest, Open, AddChildren);
end;

function TPDF.InsertBookmarkExW(const Title: WideString; Parent: Integer; NamedDest: Cardinal; Open, AddChildren: Boolean): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertBookmarkExW, 'pdfInsertBookmarkExW');{$endif}
   Result := pdfInsertBookmarkExW(FInstance, PWideChar(Title), Parent, NamedDest, Open, AddChildren);
end;

function TPDF.InsertImage(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: AnsiString): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertImage, 'pdfInsertImage');{$endif}
   Result := pdfInsertImage(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, PAnsiChar(AFile));
end;

function TPDF.InsertImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: AnsiString; Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertImageEx, 'pdfInsertImageEx');{$endif}
   Result := pdfInsertImageEx(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, PAnsiChar(AFile), Index);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.InsertImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: WideString; Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertImageExW, 'pdfInsertImageExW');{$endif}
   Result := pdfInsertImageExW(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, PWideChar(AFile), Index);
end;
{$endif}

function TPDF.InsertImageExW(PosX, PosY, ScaleWidth, ScaleHeight: Double; const AFile: WideString; Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertImageExW, 'pdfInsertImageExW');{$endif}
   Result := pdfInsertImageExW(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, PWideChar(AFile), Index);
end;

function TPDF.InsertImageFromBuffer(PosX, PosY, ScaleWidth, ScaleHeight: Double; const Buffer: Pointer; BufSize, Index: Cardinal): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertImageFromBuffer, 'pdfInsertImageFromBuffer');{$endif}
   Result := pdfInsertImageFromBuffer(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, Buffer, BufSize, Index);
end;

function TPDF.InsertRawImage(const Buffer: Pointer; BitsPerPixel, ColorCount, ImgWidth, ImgHeight: Cardinal; PosX, PosY, ScaleWidth, ScaleHeight: Double): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertRawImage, 'pdfInsertRawImage');{$endif}
   Result := pdfInsertRawImage(FInstance, Buffer, BitsPerPixel, ColorCount, ImgWidth, ImgHeight, PosX, PosY, ScaleWidth, ScaleHeight);
end;

function TPDF.InsertRawImageEx(PosX, PosY, ScaleWidth, ScaleHeight: Double; var Image: TPDFRawImage): Integer;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertRawImageEx, 'pdfInsertRawImageEx');{$endif}
   Result := pdfInsertRawImageEx(FInstance, PosX, PosY, ScaleWidth, ScaleHeight, Image);
end;

function TPDF.InsertMetafile(const FileName: AnsiString; PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertMetafileA, 'pdfInsertMetafileA');{$endif}
   Result := pdfInsertMetafileA(FInstance, PAnsiChar(FileName), PosX, PosY, Width, Height);
end;

{$ifdef DELPHI6_OR_HIGHER}
function TPDF.InsertMetafile(const FileName: WideString; PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertMetafileW, 'pdfInsertMetafileW');{$endif}
   Result := pdfInsertMetafileW(FInstance, PWideChar(FileName), PosX, PosY, Width, Height);
end;
{$endif}

function TPDF.InsertMetafileA(const FileName: AnsiString; PosX, PosY, Width, Height: Double): Boolean;
begin
   {$ifdef DYNLNK}LoadFunction(@pdfInsertMetafileA, 'pdfInsertMetafileA');{$endif}
   Result :