/*---------------------------------------------------------+
| DynaPDF 4.0                                              |
+----------------------------------------------------------+
| Copyright (C) 2003-2024                                  |
| Jens Boschulte, DynaForms GmbH.                          |
| All rights reserved.                                     |
+----------------------------------------------------------+
| Please report errors or other potential problems to      |
| support@dynaforms.com.                                   |
| The actual version is available at www.dynaforms.com.    |
+----------------------------------------------------------*/

#ifndef pdf_interfaceH
#define pdf_interfaceH

#ifndef DRV_GLOBAL
   #include "dynapdf.h"
   #include "parser_interface.h"
#endif

#if defined(DRV_PDF)
   #include "../drv_main.h"
   using namespace DOCDRV;
#endif

#if !defined(DRV_GLOBAL) && defined(__BORLANDC__)
   #error "The abstract interface class IPDF can be used with MS VC++ only! Use the C interface dynapdf.h instead."
#endif

#if defined(_MSC_VER) && _MSC_VER >= 1929
   #pragma warning(push)
   #pragma warning(disable:26812) // Type enum is unscoped. Prefer enum class over enum
#endif

namespace DynaPDF
{

/*
   This is a C++ interface for DynaPDF. This class can be used to access DynaPDF functions directly.
   The interface can be used as follows:

   IPDF* pdf = (IPDF*)pdfNewPDF();
   pdf->CreateNewPDF("c:/test.pdf");
   ...
   pdfDeletePDF(pdf);

   Note that the interface doesn't contain all DynaPDF functions. Missing functions must be used with the
   regular C-API.

   Note also that the return values of the class functions are not the same as from the C interface. The class IPDF
   returns a value greater or equal zero on success and a negative error code on failure.
*/

#if defined(DRV_PDF)
   class IPDF : public IDriver
#else
   class IPDF
#endif
{
  public:
   virtual ~IPDF(void){}
   virtual SI32    AddActionToObj(TObjType ObjType, TObjEvent Event, UI32 ActHandle, UI32 ObjHandle)=0;
   virtual SI32    AddArticle(double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    AddBookmark(const char* Title, SI32 Parent, UI32 DestPage, bool Open)=0;
   virtual SI32    AddBookmark(const UI16* Title, SI32 Parent, UI32 DestPage, bool Open)=0;
   virtual SI32    AddButtonImage(UI32 BtnHandle, TButtonState State, const char* Caption, const char* ImgFile)=0;
   virtual SI32    AddButtonImage(UI32 BtnHandle, TButtonState State, const char* Caption, void* hBitmap)=0;
   virtual SI32    AddContinueText(const char* Text)=0;
   virtual SI32    AddContinueText(const UI16* Text)=0;
   virtual SI32    AddFieldToFormAction(UI32 Action, UI32 AField, bool Include)=0;
   virtual SI32    AddFieldToHideAction(UI32 HideAct, UI32 AField)=0;
   virtual SI32    AddFileComment(const char* AText)=0;
   virtual SI32    AddFileComment(const UI16* AText)=0;
   virtual SI32    AddFontSearchPath(const char* APath, bool Recursive)=0;
   virtual SI32    AddFontSearchPath(const UI16* APath, bool Recursive)=0;
   virtual SI32    AddJavaScript(const char* Name, const char* Script)=0;
   virtual SI32    AddJavaScript(const char* Name, const UI16* Script)=0;
   virtual SI32    AddValToChoiceField(UI32 Field, const char* ExpValue, const char* Value, bool Selected)=0;
   virtual SI32    AddValToChoiceField(UI32 Field, const char* ExpValue, const UI16* Value, bool Selected)=0;
   virtual SI32    Append(void)=0;
   virtual SI32    ApplyPattern(SI32 PattHandle, TColorMode ColorMode, UI32 Color)=0;
   virtual SI32    ApplyShading(SI32 ShadHandle)=0;
   virtual SI32    AutoTemplate(UI32 Templ, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    BeginClipPath(void)=0;
   virtual SI32    BeginContinueText(double PosX, double PosY)=0;
   virtual SI32    BeginPattern(TPatternType PatternType, TTilingType TilingType, double Width, double Height)=0;
   virtual SI32    BeginTemplate(double Width, double Height)=0;
   virtual SI32    Bezier_1_2_3(double x1, double y1, double x2, double y2, double x3, double y3)=0;
   virtual SI32    Bezier_1_3(double x1, double y1, double x3, double y3)=0;
   virtual SI32    Bezier_2_3(double x2, double y2, double x3, double y3)=0;
   virtual double  CalcWidthHeight(double OrgWidth, double OrgHeight, double ScaledWidth, double ScaledHeight)=0;
   virtual SI32    ChangeBookmark(SI32 ABmk, const char* Title, SI32 Parent, UI32 DestPage, bool Open)=0;
   virtual SI32    ChangeBookmark(SI32 ABmk, const UI16* Title, SI32 Parent, UI32 DestPage, bool Open)=0;
   virtual SI32    ChangeFont(SI32 AHandle)=0;
   virtual SI32    ChangeFontSize(double Size)=0;
   virtual SI32    ChangeFontStyle(TFStyle Style)=0;
   virtual SI32    ChangeJavaScript(UI32 AHandle, const char* NewScript)=0;
   virtual SI32    ChangeJavaScript(UI32 AHandle, const UI16* NewScript)=0;
   virtual SI32    ChangeJavaScriptAction(UI32 AHandle, const char* NewScript)=0;
   virtual SI32    ChangeJavaScriptAction(UI32 AHandle, const UI16* NewScript)=0;
   virtual SI32    CheckFieldNames(void)=0;
   virtual SI32    ClearAutoTemplates(void)=0;
   virtual SI32    ClearHostFonts(void)=0;
   virtual SI32    ClipPath(TClippingMode ClipMode, TPathFillMode FillMode)=0;
   virtual SI32    CloseFile(void)=0;
   virtual SI32    CloseFileEx(const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict)=0;
   virtual SI32    CloseImportFile(void)=0;
   virtual SI32    ClosePath(TPathFillMode FillMode, bool CloseClipPath)=0;
   virtual UI16*   ConvToUnicode(const char* AString, TCodepage CP)=0;
   virtual SI32    CreateArticleThread(const char* ThreadName)=0;
   virtual SI32    CreateArticleThread(const UI16* ThreadName)=0;
   virtual SI32    CreateAxialShading(double sX, double sY, double eX, double eY, double SCenter, UI32 SColor, UI32 EColor, bool Extend1, bool Extend2)=0;
   virtual SI32    CreateButton(const char* Name, const char* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateButton(const char* Name, const UI16* Caption, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateCheckBox(const char* Name, const char* ExpValue, bool Checked, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateComboBox(const char* Name, bool Sort, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateExtGState(TPDFExtGState* GS)=0;
   virtual SI32    CreateGoToAction(TDestType DestType, UI32 PageNum, double a, double b, double c, double d)=0;
   virtual SI32    CreateGoToRAction(const char* FileName, UI32 PageNum)=0;
   virtual SI32    CreateGroupField(const char* Name, SI32 Parent)=0;
   virtual SI32    CreateHideAction(UI32 AField, bool Hide)=0;
   virtual SI32    CreateImpDataAction(const char* DataFile)=0;
   virtual SI32    CreateImpDataAction(const UI16* DataFile)=0;
   virtual SI32    CreateJSAction(const char* Script)=0;
   virtual SI32    CreateJSAction(const UI16* Script)=0;
   virtual SI32    CreateLaunchAction(TFileOP OP, const char* FileName, const char* DefDir, const char* Param, bool NewWindow)=0;
   virtual SI32    CreateListBox(const char* Name, bool Sort, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateNamedAction(TNamedAction Action)=0;
   virtual SI32    CreateNewPDFA(const char* OutPDF)=0;
   virtual SI32    CreateNewPDFW(const UI16* OutPDF)=0;
   virtual SI32    CreateRadialShading(double sX, double sY, double R1, double eX, double eY, double R2, double SCenter, UI32 SColor, UI32 EColor, bool Extend1, bool Extend2)=0;
   virtual SI32    CreateRadioButton(const char* Name, const char* ExpValue, bool Checked, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateResetAction(void)=0;
   virtual SI32    CreateStdPattern(TStdPattern Pattern, double LineWidth, double Distance, UI32 LineColor, UI32 BackColor)=0;
   virtual SI32    CreateSubmitAction(TSubmitFlags Flags, const char* URL)=0;
   virtual SI32    CreateTextField(const char* Name, SI32 Parent, bool Multiline, SI32 MaxLen, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    CreateURIAction(const char* URL)=0;
   virtual SI32    DecryptPDF(const char* FileName, TPwdType PwdType, const char* Password)=0;
   virtual SI32    DecryptPDF(const UI16* FileName, TPwdType PwdType, const char* Password)=0;
   virtual SI32    DeleteActionFromObj(TObjType ObjType, UI32 ActHandle, UI32 ObjHandle)=0;
   virtual SI32    DeleteActionFromObjEx(TObjType ObjType, UI32 ObjHandle, UI32 ActIndex)=0;
   virtual SI32    DeleteAnnotation(UI32 Handle)=0;
   virtual SI32    DeleteBookmark(UI32 ABmk)=0;
   virtual SI32    DeleteField(UI32 AField)=0;
   virtual SI32    DeleteFieldEx(const char* Name)=0;
   virtual SI32    DeletePage(UI32 PageNum)=0;
   virtual SI32    DeleteTemplate(UI32 Handle)=0;
   virtual SI32    DeleteTemplateEx(UI32 Index)=0;
   virtual SI32    DrawArc(double PosX, double PosY, double Radius, double StartAngle, double EndAngle)=0;
   virtual SI32    DrawArcEx(double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle)=0;
   virtual SI32    DrawChord(double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode)=0;
   virtual SI32    DrawCircle(double PosX, double PosY, double Radius, TPathFillMode FillMode)=0;
   virtual SI32    DrawPie(double PosX, double PosY, double Width, double Height, double StartAngle, double EndAngle, TPathFillMode FillMode)=0;
   virtual SI32    EditPage(SI32 PageNum)=0;
   virtual SI32    EditTemplate(UI32 Index)=0;
   virtual SI32    EditTemplate2(UI32 Handle)=0;
   virtual SI32    Ellipse(double PosX, double PosY, double Width, double Height, TPathFillMode FillMode)=0;
   virtual SI32    EncryptPDF(const char* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict)=0;
   virtual SI32    EncryptPDF(const UI16* FileName, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict)=0;
   virtual SI32    EndContinueText(void)=0;
   virtual SI32    EndPage(void)=0;
   virtual SI32    EndPage(const char* FuncName, bool Reset)=0;
   virtual SI32    EndPattern(void)=0;
   virtual SI32    EndTemplate(void)=0;
   virtual SI32    EnumHostFonts(const void* Data, TEnumFontProc* EnumProc)=0;
   virtual SI32    ExchangeBookmarks(SI32 Bmk1, SI32 Bmk2)=0;
   virtual SI32    FileLink(double PosX, double PosY, double Width, double Height, const char* AFilePath)=0;
   virtual SI32    FileLink(double PosX, double PosY, double Width, double Height, const UI16* AFilePath)=0;
   virtual SI32    FindBookmark(SI32 DestPage, const void* Title, bool Unicode)=0;
   virtual SI32    FindNextBookmark(void)=0;
   virtual SI32    FlushPageContent(TPDFStack* Stack)=0;
   virtual SI32    FreePDF(void)=0;
   virtual SI32    FreeTextAnnot(double PosX, double PosY, double Width, double Height, const char* Author, const char* AText, TTextAlign Align)=0;
   virtual SI32    FreeTextAnnot(double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* AText, TTextAlign Align)=0;
   virtual SI32    FreeUniBuf(void)=0;
   virtual SI32    GetActionCount(void)=0;
   virtual SI32    GetActionType(UI32 ActHandle)=0;
   virtual SI32    GetActionTypeEx(TObjType ObjType, UI32 ObjHandle, UI32 ActIndex)=0;
   virtual SI32    GetActiveFont(void)=0;
   virtual SI32    GetAllocBy(void)=0;
   virtual SI32    GetAnnotCount(void)=0;
   virtual SI32    GetAnnotFlags(void)=0;
   virtual SI32    GetAnnotType(UI32 Handle)=0;
   virtual double  GetAscent(void)=0;
   virtual SI32    GetBBox(TPageBoundary Boundary, TPDFRect &BBox)=0;
   virtual SI32    GetBookmark(SI32 AHandle, TBookmark &Bmk)=0;
   virtual SI32    GetBookmarkCount(void)=0;
   virtual char*   GetBuffer(UI32 &BufSize)=0;
   virtual double  GetCapHeight(void)=0;
   virtual double  GetCharacterSpacing(void)=0;
   virtual SI32    GetCheckBoxChar(void)=0;
   virtual SI32    GetColorSpace(void)=0;
   virtual SI32    GetCompressionFilter(void)=0;
   virtual SI32    GetCompressionLevel(void)=0;
   virtual SI32    GetContent(char* &Buffer)=0;
   virtual SI32    GetDefBitsPerPixel(void)=0;
   virtual double  GetDescent(void)=0;
   virtual SI32    GetDocInfo(TDocumentInfo DInfo, UI16* &Value)=0;
   virtual SI32    GetDrawDirection(void)=0;
   virtual double  GetEMFPatternDistance(void)=0;
   virtual char*   GetErrorMessage(void)=0;
   virtual SI32    GetErrorMode(void)=0;
   virtual SI32    GetField(UI32 AHandle, TPDFField* Field)=0;
   virtual UI32    GetFieldBackColor(void)=0;
   virtual UI32    GetFieldBorderColor(void)=0;
   virtual SI32    GetFieldColor(UI32 AField, TFieldColor ColorType, SI32 &ColorSpace, UI32 &Color)=0;
   virtual SI32    GetFieldCount(void)=0;
   virtual SI32    GetFieldExpValue(UI32 AField, char* &Value)=0;
   virtual SI32    GetFieldFlags(UI32 AField)=0;
   virtual SI32    GetFieldIndex(UI32 AField)=0;
   virtual SI32    GetFieldName(UI32 AField, char* &Name)=0;
   virtual SI32    GetFieldTextAlign(UI32 AField)=0;
   virtual UI32    GetFieldTextColor(void)=0;
   virtual SI32    GetFieldToolTip(UI32 AField, void* &Value, LBOOL &Unicode)=0;
   virtual SI32    GetFieldType(UI32 AField)=0;
   virtual UI32    GetFillColor(void)=0;
   virtual SI32    GetFontOrigin(void)=0;
   virtual SI32    GetFontSelMode(void)=0;
   virtual SI32    GetFontWeight(void)=0;
   virtual double  GetFTextHeight(TTextAlign Align, const char* AText)=0;
   virtual double  GetFTextHeight(TTextAlign Align, const UI16* AText)=0;
   virtual double  GetFTextHeightEx(double Width, TTextAlign Align, const char* AText)=0;
   virtual double  GetFTextHeightEx(double Width, TTextAlign Align, const UI16* AText)=0;
   virtual SI32    GetHostFontCount(void)=0;
   virtual UI32    GetIconColor(void)=0;
   virtual SI32    GetImageCount(const char* FileName)=0;
   virtual SI32    GetImageHeight(UI32 AHandle)=0;
   virtual SI32    GetImageWidth(UI32 AHandle)=0;
   virtual UI32    GetImportFlags(void)=0;
   virtual SI32    GetInBBox(UI32 PageNum, TPageBoundary Boundary, TPDFRect &BBox)=0;
   virtual SI32    GetInDocInfo(TDocumentInfo Info, UI16* &Value)=0;
   virtual SI32    GetInPageCount(void)=0;
   virtual SI32    GetInPDFVersion(void)=0;
   virtual SI32    GetIsFixedPitch(void)=0;
   virtual double  GetItalicAngle(void)=0;
   virtual SI32    GetJPEGQuality(void)=0;
   virtual char*   GetJavaScript(UI32 AHandle, UI32 &Len, LBOOL &Unicode)=0;
   virtual char*   GetJavaScriptAction(UI32 AHandle, UI32 &Len, LBOOL &Unicode)=0;
   virtual char*   GetJavaScriptEx(const char* Name, UI32 &Len, LBOOL &Unicode)=0;
   virtual SI32    GetJavaScriptCount(void)=0;
   virtual char*   GetLanguage(void)=0;
   virtual double  GetLastTextPosX(void)=0;
   virtual double  GetLastTextPosY(void)=0;
   virtual double  GetLeading(void)=0;
   virtual SI32    GetLineCapStyle(void)=0;
   virtual SI32    GetLineJoinStyle(void)=0;
   virtual double  GetLineWidth(void)=0;
   virtual SI32    GetLinkHighlightMode(void)=0;
   virtual SI32    GetLogMetafileSize(const char* FileName, struct TRectL* R)=0;
   virtual SI32    GetLogMetafileSizeEx(const void* Buffer, UI32 BufSize, struct TRectL* R)=0;
   virtual SI32    GetMatrix(struct TCTM* Matrix)=0;
   virtual SI32    GetMaxFieldLen(UI32 TxtField)=0;
   virtual UI32    GetMetaConvFlags(void)=0;
   virtual double  GetMiterLimit(void)=0;
   virtual SI32    GetObjActionCount(TObjType ObjType, UI32 ObjHandle)=0;
   virtual double  GetOpacity(void)=0;
   virtual SI32    GetOrientation(void)=0;
   virtual SI32    GetPageCoords(void)=0;
   virtual SI32    GetPageCount(void)=0;
   virtual SI32    GetPageField(UI32 Index, TPDFField* Field)=0;
   virtual SI32    GetPageFieldCount(void)=0;
   virtual double  GetPageHeight(void)=0;
   virtual SI32    GetPageLayout(void)=0;
   virtual SI32    GetPageMode(void)=0;
   virtual SI32    GetPageNum(void)=0;
   virtual SI32    GetPageText(TPDFStack* Stack)=0;
   virtual double  GetPageWidth(void)=0;
   virtual SI32    GetPDFVersion(void)=0;
   virtual SI32    GetResolution(void)=0;
   virtual SI32    GetSaveNewImageFormat(void)=0;
   virtual UI32    GetStrokeColor(void)=0;
   virtual SI32    GetTabLen(void)=0;
   virtual SI32    GetTemplCount(void)=0;
   virtual double  GetTemplHeight(SI32 TmplHandle)=0;
   virtual double  GetTemplWidth(SI32 TmplHandle)=0;
   virtual SI32    GetTextDrawMode(void)=0;
   virtual SI32    GetTextRect(double &PosX, double &PosY, double &Width, double &Height)=0;
   virtual double  GetTextRise(void)=0;
   virtual double  GetTextScaling(void)=0;
   virtual double  GetTextWidth(const char* AText)=0;
   virtual double  GetTextWidth(const UI16* AText)=0;
   virtual UI32    GetTransparentColor(void)=0;
   virtual SI32    GetUseExactPwd(void)=0;
   virtual SI32    GetUseGlobalImpFiles(void)=0;
   virtual SI32    GetUserRights(void)=0;
   virtual SI32    GetUseStdFonts(void)=0;
   virtual SI32    GetUseSystemFonts(void)=0;
   virtual SI32    GetUseTransparency(void)=0;
   virtual SI32    GetUseVisibleCoords(void)=0;
   virtual SI32    GetViewerPrefrences(SI32 &Preference, SI32 &AddVal){return GetViewerPreferences(Preference, AddVal);} // Typo in function name. Use GetViewerPreferences() instead!
   virtual SI32    GetWMFDefExtent(UI32 &Width, UI32 &Height)=0;
   virtual SI32    GetWMFPixelPerInch(void)=0;
   virtual double  GetWordSpacing(void)=0;
   virtual SI32    ImportPage(UI32 PageNum)=0;
   virtual SI32    ImportPageEx(UI32 PageNum, double ScaleX, double ScaleY, bool ImportAll)=0;
   virtual SI32    ImportPDFFile(UI32 DestPage, double ScaleX, double ScaleY)=0;
   virtual SI32    InitStack(TPDFStack* Stack, bool FreeLast)=0;
   virtual SI32    InsertBMPFromBuffer(double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer)=0;
   virtual SI32    InsertImage(double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* Image)=0;
   virtual SI32    InsertImageEx(double PosX, double PosY, double ScaleWidth, double ScaleHeight, const char* Image, UI32 Index)=0;
   virtual SI32    InsertMetafile(const char* FileName, struct TRectL* View, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    InsertMetafileEx(const void* Buffer, UI32 BufSize, struct TRectL* View, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    InsertRawImage(const void* Buffer, BYTE BitsPerPixel, UI16 ColorCount, SI32 ImgWidth, SI32 ImgHeight, double PosX, double PosY, double ScaleWidth, double ScaleHeight)=0;
   virtual SI32    IsBidiText(const UI16* AText)=0;
   virtual SI32    LineTo(double PosX, double PosY)=0;
   virtual SI32    MoveTo(double PosX, double PosY)=0;
   virtual SI32    OpenImportBuffer(const void* Buffer, UI32 BufSize, TPwdType PwdType, const char* Password)=0;
   virtual SI32    OpenImportFile(const char* FileName, TPwdType PwdType, const char* Password)=0;
   virtual SI32    OpenImportFile(const UI16* FileName, TPwdType PwdType, const char* Password)=0;
   virtual SI32    PageLink(double PosX, double PosY, double Width, double Height, UI32 DestPage)=0;
   virtual SI32    PageLinkEx(double PosX, double PosY, double Width, double Height, TDestType DestType, UI32 DestPage, double a, double b, double c, double d)=0;
   virtual SI32    PlaceImage(SI32 ImgHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight)=0;
   virtual SI32    PlaceTemplate(SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight)=0;
   virtual SI32    ReadImageFormat(const char* FileName, UI32 &Width, UI32 &Height, SI32 &BitsPerPixel, SI32 &UseZip, UI32 Index = 1)=0;
   virtual SI32    ReadImageFormatEx(void* hBitmap, UI32 &Width, UI32 &Height, SI32 &BitsPerPixel, SI32 &UseZip)=0;
   virtual SI32    Rectangle(double PosX, double PosY, double Width, double Height, TPathFillMode FillMode)=0;
   virtual SI32    ReEncryptPDF(const char* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict)=0;
   virtual SI32    ReEncryptPDF(const UI16* FileName, TPwdType PwdType, const char* InPwd, const char* NewOpenPwd, const char* NewOwnerPwd, TKeyLen NewKeyLen, TRestrictions Restrict)=0;
   virtual SI32    ReplacePageText(const char* NewText, TPDFStack* Stack)=0;
   virtual SI32    ReplacePageTextEx(const char* NewText, TPDFStack* Stack)=0;
   virtual SI32    ResetLineDashPattern(void)=0;
   virtual SI32    RestoreGraphicState(void)=0;
   virtual SI32    RotateCoords(double Alpha, double OriginX, double OriginY)=0;
   virtual SI32    RoundRect(double PosX, double PosY, double Width, double Height, double Radius, TPathFillMode FillMode)=0;
   virtual SI32    RoundRectEx(double PosX, double PosY, double Width, double Height, double rWidth, double rHeight, TPathFillMode FillMode)=0;
   virtual SI32    SaveGraphicState(void)=0;
   virtual SI32    ScaleCoords(double sx, double sy)=0;
   virtual SI32    SelfTest(void)=0;
   virtual SI32    SetAllocBy(SI32 Value)=0;
   virtual SI32    SetAnnotFlags(SI32 Flags)=0;
   virtual SI32    SetBBox(TPageBoundary Boundary, double LeftX, double LeftY, double RightX, double RightY)=0;
   virtual SI32    SetBookmarkDest(SI32 ABmk, TDestType DestType, double a, double b, double c, double d)=0;
   virtual SI32    SetBookmarkStyle(SI32 ABmk, TFStyle FStyle, UI32 RGBColor)=0;
   virtual SI32    SetCharacterSpacing(double Value)=0;
   virtual SI32    SetCheckBoxChar(TCheckBoxChar CheckBoxChar)=0;
   virtual SI32    SetCheckBoxState(UI32 AField, bool Checked)=0;
   virtual SI32    SetColors(UI32 Color)=0;
   virtual SI32    SetColorSpace(TPDFColorSpace ColorSpace)=0;
   virtual SI32    SetCompressionFilter(TCompressionFilter Filter)=0;
   virtual SI32    SetCompressionLevel(TCompressionLevel CompressLevel)=0;
   virtual SI32    SetContent(const char* Buffer, UI32 BufSize)=0;
   virtual SI32    SetDateTimeFormat(UI32 TxtField, TPDFDateTime Fmt)=0;
   virtual SI32    SetDefBitsPerPixel(SI32 Value)=0;
   virtual SI32    SetDocInfo(TDocumentInfo DInfo, const char* Value)=0;
   virtual SI32    SetDocInfo(TDocumentInfo DInfo, const UI16* Value)=0;
   virtual SI32    SetDrawDirection(TDrawDirection Direction)=0;
   virtual SI32    SetEMFPatternDistance(double Value)=0;
   virtual SI32    SetErrorMode(SI32 ErrMode)=0;
   virtual SI32    SetFieldBackColor(UI32 AColor)=0;
   virtual SI32    SetFieldBorderColor(UI32 AColor)=0;
   virtual SI32    SetFieldColor(UI32 AField, TFieldColor ColorType, TPDFColorSpace CS, UI32 Color)=0;
   virtual SI32    SetFieldFlags(UI32 AField, UI32 Flags, bool Reset)=0;
   virtual SI32    SetFieldIndex(UI32 AField, UI32 Index)=0;
   virtual SI32    SetFieldName(UI32 AField, const char* NewName)=0;
   virtual SI32    SetFieldTextAlign(UI32 AField, TTextAlign Align)=0;
   virtual SI32    SetFieldTextColor(UI32 Color)=0;
   virtual SI32    SetFieldToolTip(UI32 AField, const char* Value)=0;
   virtual SI32    SetFieldToolTip(UI32 AField, const UI16* Value)=0;
   virtual SI32    SetFillColor(UI32 Value)=0;
   virtual SI32    SetFont(const char* Name, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    SetFontOrigin(TOrigin Origin)=0;
   virtual SI32    SetFontSelMode(TFontSelMode Mode)=0;
   virtual SI32    SetFont(const UI16* Name, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    SetFontWeight(SI32 Weight)=0;
   virtual SI32    SetIconColor(UI32 Color)=0;
   virtual SI32    SetImportFlags(UI32 Flags)=0;
   virtual SI32    SetItalicAngle(double Angle)=0;
   virtual SI32    SetJPEGQuality(SI32 Value)=0;
   virtual SI32    SetLanguage(const char* ISOTag)=0;
   virtual SI32    SetLeading(double Value)=0;
   virtual SI32    SetLicenseKey(const char* Value)=0;
   virtual SI32    SetLineCapStyle(TLineCapStyle Style)=0;
   virtual SI32    SetLineDashPattern(const char* Dash, SI32 Phase)=0;
   virtual SI32    SetLineJoinStyle(TLineJoinStyle Style)=0;
   virtual SI32    SetLineWidth(double Value)=0;
   virtual SI32    SetLinkHighlightMode(THighlightMode Mode)=0;
   virtual SI32    SetMatrix(struct TCTM* Matrix)=0;
   virtual SI32    SetMaxFieldLen(UI32 TxtField, SI32 MaxLen)=0;
   virtual SI32    SetMetaConvFlags(TMetaFlags Flags)=0;
   virtual SI32    SetMiterLimit(double Value)=0;
   virtual SI32    SetNumberFormat(UI32 TxtField, TDecSeparator Sep, UI32 DecPlaces, TNegativeStyle NegStyle, const char* CurrStr, bool Prepend)=0;
   virtual SI32    SetOnErrorProc(const void* Data, TErrorProc* ErrProc)=0;
   virtual SI32    SetOnPageBreakProc(const void* Data, TOnPageBreakProc* OnBreakProc)=0;
   virtual SI32    SetOpacity(double Value)=0;
   virtual SI32    SetOrientation(SI32 Value)=0;
   virtual SI32    SetPageCoords(TPageCoord PageCoords)=0;
   virtual SI32    SetPageFormat(TPageFormat Value)=0;
   virtual SI32    SetPageHeight(double Value)=0;
   virtual SI32    SetPageLayout(TPageLayout Layout)=0;
   virtual SI32    SetPageMode(TPageMode Mode)=0;
   virtual SI32    SetPageWidth(double Value)=0;
   virtual SI32    SetPDFVersion(TPDFVersion Version)=0;
   virtual SI32    SetProgressProc(const void* Data, TInitProgressProc* InitProgress, TProgressProc* Progress)=0;
   virtual SI32    SetResolution(UI32 Value)=0;
   virtual SI32    SetSaveNewImageFormat(bool Value)=0;
   virtual SI32    SetStrokeColor(UI32 Value)=0;
   virtual SI32    SetTabLen(SI32 TabLen)=0;
   virtual SI32    SetTextDrawMode(TDrawMode Mode)=0;
   virtual SI32    SetTextFieldValue(UI32 Field, const char* Value, const char* DefValue, TTextAlign Align)=0;
   virtual SI32    SetTextFieldValue(UI32 Field, const UI16* Value, const UI16* DefValue, TTextAlign Align)=0;
   virtual SI32    SetTextRect(double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    SetTextRise(double Value)=0;
   virtual SI32    SetTextScaling(double Value)=0;
   virtual SI32    SetTransparentColor(UI32 AColor)=0;
   virtual SI32    SetUseExactPwd(bool Value)=0;
   virtual SI32    SetUseGlobalImpFiles(bool Value)=0;
   virtual SI32    SetUseStdFonts(bool Value)=0;
   virtual SI32    SetUseSwapFile(bool SwapContents, UI32 SwapLimit)=0;
   virtual SI32    SetUseSystemFonts(bool Value)=0;
   virtual SI32    SetUseTransparency(bool Value)=0;
   virtual SI32    SetUseVisibleCoords(bool Value)=0;
   virtual SI32    SetViewerPreferences(TViewerPreference Value, TViewPrefAddVal AddVal)=0;
   virtual SI32    SetWMFDefExtent(UI32 Width, UI32 Height)=0;
   virtual SI32    SetWMFPixelPerInch(UI32 Value)=0;
   virtual SI32    SetWordSpacing(double Value)=0;
   virtual SI32    SkewCoords(double alpha, double beta, double OriginX, double OriginY)=0;
   virtual SI32    SortFieldsByIndex(void)=0;
   virtual SI32    SortFieldsByName(void)=0;
   virtual SI32    StrLenA(const char* AText)=0;
   virtual SI32    StrLenW(const UI16* AText)=0;
   virtual SI32    StrokePath(void)=0;
   virtual SI32    TextAnnot(double PosX, double PosY, double Width, double Height, const char* Author, const char* Text, TAnnotIcon Icon, bool Open)=0;
   virtual SI32    TextAnnot(double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Text, TAnnotIcon Icon, bool Open)=0;
   virtual SI32    TranslateCoords(double NewOriginX, double NewOriginY)=0;
   virtual SI32    Triangle(double x1, double y1, double x2, double y2, double x3, double y3, TPathFillMode FillMode)=0;
   virtual UI32*   UTF16ToUTF32(const UI16* Source)=0;
   virtual UI32*   UTF16ToUTF32Ex(const UI16* Source, UI32 &Len)=0;
   virtual UI16*   UTF32ToUTF16(const UI32* Source)=0;
   virtual UI16*   UTF32ToUTF16Ex(const UI32* Source, UI32 &Len)=0;
   virtual SI32    WebLink(double PosX, double PosY, double Width, double Height, const char* URL)=0;
   virtual SI32    WebLink(double PosX, double PosY, double Width, double Height, const UI16* URL)=0;
   virtual SI32    WriteAngleText(const char* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin)=0;
   virtual SI32    WriteAngleText(const UI16* AText, double Angle, double PosX, double PosY, double Radius, double YOrigin)=0;
   virtual void    WriteFillMode(TPathFillMode FillMode)=0;
   virtual SI32    WriteFText(TTextAlign Align, const char* AText)=0;
   virtual SI32    WriteFText(TTextAlign Align, const UI16* AText)=0;
   virtual SI32    WriteFTextEx(double PosX, double PosY, double Width, double Height, TTextAlign Align, const char* AText)=0;
   virtual SI32    WriteFTextEx(double PosX, double PosY, double Width, double Height, TTextAlign Align, const UI16* AText)=0;
   virtual SI32    WriteText(double PosX, double PosY, const char* AText)=0;
   virtual SI32    WriteText(double PosX, double PosY, const UI16* AText)=0;
   virtual SI32    WriteTextMatrix(struct TCTM* M, const char* AText)=0;
   virtual SI32    WriteTextMatrix(struct TCTM* M, const UI16* AText)=0;
   virtual SI32    GetFieldExpValCount(UI32 AField)=0;
   virtual SI32    GetFieldExpValueEx(UI32 AField, UI32 ValIndex, char* &Value, char* &ExpValue, LBOOL &Selected)=0;
   virtual SI32    BeginDoc(FILE* OutStream)=0;
   virtual SI32    IsColorPage(bool GrayIsColor)=0;
   virtual SI32    IsEmptyPage(void)=0;
   virtual SI32    InsertImageFromBuffer(double PosX, double PosY, double ScaleWidth, double ScaleHeight, const void* Buffer, UI32 BufSize, UI32 Index)=0;
   virtual SI32    ReadImageFormatFromBuffer(const void* Buffer, UI32 BufSize, UI32 Index, UI32 &Width, UI32 &Height, SI32 &BitsPerPixel, SI32 &UseZip)=0;
   virtual SI32    GetImageCountEx(const void* Buffer, UI32 BufSize)=0;
   virtual SI32    FlattenForm(void)=0;
   virtual SI32    GetBorderStyle(void)=0;
   virtual SI32    GetFieldBorderStyle(UI32 AField)=0;
   virtual SI32    SetBorderStyle(TBorderStyle Style)=0;
   virtual SI32    SetFieldBorderStyle(UI32 AField, TBorderStyle Style)=0;
   virtual SI32    InsertBMPFromHandle(double PosX, double PosY, double ScaleWidth, double ScaleHeight, void* hBitmap)=0;
   virtual SI32    AddContinueText(const char* Text, UI32 Len)=0;
   virtual SI32    AddContinueText(const UI16* Text, UI32 Len)=0;
   virtual SI32    WriteAngleText(const char* AText, UI32 Len, double Angle, double PosX, double PosY, double Radius, double YOrigin)=0;
   virtual SI32    WriteAngleText(const UI16* AText, UI32 Len, double Angle, double PosX, double PosY, double Radius, double YOrigin)=0;
   virtual SI32    WriteText(double PosX, double PosY, const char* AText, UI32 Len)=0;
   virtual SI32    WriteText(double PosX, double PosY, const UI16* AText, UI32 Len)=0;
   virtual SI32    WriteTextMatrix(struct TCTM* M, const char* AText, UI32 Len)=0;
   virtual SI32    WriteTextMatrix(struct TCTM* M, const UI16* AText, UI32 Len)=0;
   virtual SI32    CloseAndSignFile(const char* CertFile, const char* Password, const char* Reason, const char* Location)=0;
   virtual SI32    CloseAndSignFile(const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict, const char* CertFile, const char* Password, const char* Reason, const char* Location)=0;
   virtual SI32    CreateSigField(const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height)=0;
   virtual double  GetFieldBorderWidth(UI32 AField)=0;
   virtual SI32    HaveOpenDoc(void)=0;
   virtual SI32    SetFieldBorderWidth(UI32 AField, double LineWidth)=0;
   virtual SI32    SetFieldExpValue(UI32 AField, UI32 ValIndex, const char* Value, const char* ExpValue, bool Selected)=0;
   virtual SI32    GetFieldMapName(UI32 AField, void* &Value, LBOOL &Unicode)=0;
   virtual SI32    GetFieldOrientation(UI32 AField)=0;
   virtual SI32    SetFieldMapName(UI32 AField, const char* Name)=0;
   virtual SI32    SetFieldMapName(UI32 AField, const UI16* Name)=0;
   virtual SI32    SetFieldOrientation(UI32 AField, SI32 Value)=0;
   virtual SI32    GetCheckBoxDefState(UI32 AField)=0;
   virtual SI32    SetCheckBoxDefState(UI32 AField, bool Checked)=0;
   virtual double  GetTextWidth(const char* AText, UI32 Len)=0;
   virtual double  GetTextWidth(const UI16* AText, UI32 Len)=0;
   virtual SI32    ReadImageResolution(const char* FileName, UI32 Index, UI32 &ResX, UI32 &ResY)=0;
   virtual SI32    ReadImageResolutionEx(const void* Buffer, UI32 BufSize, UI32 Index, UI32 &ResX, UI32 &ResY)=0;
   virtual SI32    AddRenderingIntent(const char* ICCFile)=0;
   virtual SI32    AddRenderingIntent(const UI16* ICCFile)=0;
   virtual SI32    ChangeJavaScriptName(UI32 AHandle, const char* Name)=0;
   virtual SI32    ChangeJavaScriptName(UI32 AHandle, const UI16* Name)=0;
   virtual SI32    GetInIsSigned(void)=0;
   virtual SI32    InsertMetafileFromHandle(const void* hEnhMetafile, struct TRectL* View, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    ChangeLinkAnnot(UI32 Handle, const char* URL)=0;
   virtual SI32    FindLinkAnnot(const char* URL)=0;
   virtual char*   GetAnnotLink(UI32 Handle)=0;
   virtual SI32    GetInOrientation(SI32 PageNum)=0;
   virtual SI32    ImportBookmarks(void)=0;
   virtual SI32    SetUseSwapFile(bool SwapContents, UI32 SwapLimit, const char* Path)=0;
   virtual SI32    ChangeAnnotName(UI32 Handle, const char* Name)=0;
   virtual SI32    ChangeAnnotPos(UI32 Handle, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    GetAnnot(UI32 Handle, TPDFAnnotation &Annot)=0;
   virtual SI32    GetAnnotBBox(UI32 Handle, TPDFRect &BBox)=0;
   virtual SI32    FindField(const char* Name)=0;
   virtual SI32    FindField(const UI16* Name)=0;
   virtual SI32    ExchangePages(UI32 First, UI32 Second)=0;
   virtual SI32    MovePage(UI32 Source, UI32 Dest)=0;
   virtual SI32    SetLineDashPattern(const double* Dash, UI32 NumValues, SI32 Phase)=0;
   // Added functions in version 2.0.23.277
   virtual SI32    AttachFile(const char* FilePath, const char* Description, bool Compress)=0;
   virtual SI32    AttachFile(const UI16* FilePath, const UI16* Description, bool Compress)=0;
   virtual SI32    AttachFileEx(const void* Buffer, UI32 BufSize, const char* FileName, const char* Description, bool Compress)=0;
   virtual SI32    AttachFileEx(const void* Buffer, UI32 BufSize, const UI16* FileName, const UI16* Description, bool Compress)=0;
   virtual SI32    BeginTemplateEx(struct TPDFRect* BBox, struct TCTM* Matrix)=0;
   virtual SI32    ChangeAnnotName(UI32 Handle, const UI16* Name)=0;
   virtual SI32    ChangeFontStyleEx(TFStyle Style)=0;
   virtual SI32    CheckAndRepairFonts(void)=0;
   virtual SI32    CheckCollection(void)=0;
   virtual SI32    CheckConformance(TConformanceType Type, TCheckOptions Options, const void* UserData, TOnFontNotFoundProc* OnFontNotFound, TOnReplaceICCProfile* OnReplaceICCProfile)=0;
   virtual SI32    ClosePath(TPathFillMode FillMode)=0;
   virtual SI32    Create3DAnnot(double PosX, double PosY, double Width, double Height, const char* Author, const char* Name, const char* U3DFile, const char* Image)=0;
   virtual SI32    Create3DBackground(const I3DV* IView, UI32 BackColor)=0;
   virtual SI32    Create3DGotoViewAction(UI32 Base3DAnnot, const I3DV* IView, T3DNamedAction Named)=0;
   virtual SI32    Create3DProjection(const I3DV* IView, T3DProjType ProjType, T3DScaleType ScaleType, double Diameter, double FOV)=0;
   virtual I3DV*   Create3DView(UI32 Base3DAnnot, const char* Name, bool SetAsDefault, double* Matrix, double CamDistance, T3DRenderingMode RM, T3DLightingSheme LS)=0;
   virtual SI32    CreateCollection(TColView View)=0;
   virtual SI32    CreateCollectionField(TColColumnType ColType, SI32 Column, const char* Name, const char* Key, bool Visible, bool Editable)=0;
   virtual SI32    CreateCollectionField(TColColumnType ColType, SI32 Column, const UI16* Name, const char* Key, bool Visible, bool Editable)=0;
   virtual SI32    CreateColItemDate(UI32 EmbFile, const char* Key, long Date, const char* Prefix)=0;
   virtual SI32    CreateColItemNumber(UI32 EmbFile, const char* Key, double Value, const char* Prefix)=0;
   virtual SI32    CreateColItemString(UI32 EmbFile, const char* Key, const char* Value, const char* Prefix)=0;
   virtual SI32    CreateColItemString(UI32 EmbFile, const char* Key, const UI16* Value, const UI16* Prefix)=0;
   virtual SI32    CreateSigFieldAP(UI32 SigField)=0;
   virtual SI32    EnumDocFonts(const void* Data, TEnumFontProc2* EnumProc)=0;
   virtual SI32    EnumHostFontsEx(const void* Data, TEnumFontProcEx* EnumProc)=0;
   virtual SI32    FileAttachAnnot(double PosX, double PosY, TFileAttachIcon Icon, const char* Author, const char* Description, const char* AFile, bool Compress)=0;
   virtual SI32    FileAttachAnnot(double PosX, double PosY, TFileAttachIcon Icon, const UI16* Author, const UI16* Description, const UI16* AFile, bool Compress)=0;
   virtual SI32    GetDocInfoCount(void)=0;
   virtual SI32    GetDocInfoEx(UI32 Index, TDocumentInfo &DInfo, char* &Key, char* &Value, LBOOL &Unicode)=0;
   virtual SI32    GetEmbeddedFile(UI32 Handle, struct TPDFFileSpec* FileSpec, bool Decompress)=0;
   virtual SI32    GetEmbeddedFileCount(void)=0;
   virtual SI32    GetFieldGroupType(UI32 AField)=0;
   virtual SI32    GetFieldHighlightMode(UI32 AField)=0;
   virtual UI32    GetGStateFlags(void)=0;
   virtual SI32    GetInDocInfoCount(void)=0;
   virtual SI32    GetInDocInfoEx(UI32 Index, TDocumentInfo &DInfo, char* &Key, char* &Value, LBOOL &Unicode)=0;
   virtual SI32    GetInEncryptionFlags(void)=0;
   virtual SI32    GetInIsCollection(void)=0;
   virtual SI32    GetInIsEncrypted(void)=0;
   virtual char*   GetJavaScriptName(UI32 Handle, UI32 &Len, LBOOL &Unicode)=0;
   virtual bool    GetTrapped(void)=0;
   virtual SI32    ImportCatalogObjects(void)=0;
   virtual SI32    ImportDocInfo(void)=0;
   virtual SI32    LoadFont(const void* Buffer, UI32 BufSize, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    OpenOutputFile(const char* OutPDF)=0;
   virtual SI32    OpenOutputFile(const UI16* OutPDF)=0;
   virtual SI32    ParseContent(const void* Data, TPDFParseInterface* Stack, UI32 Flags)=0;
   virtual SI32    PlaceSigFieldValidateIcon(UI32 SigField, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    PlaceTemplByMatrix(SI32 TmplHandle)=0;
   virtual SI32    ReplaceFont(const void* PDFFont, const char* Name, TFStyle Style, bool NameIsFamilyName)=0;
   virtual SI32    ReplaceFont(const void* PDFFont, const UI16* Name, TFStyle Style, bool NameIsFamilyName)=0;
   virtual SI32    ReplaceFontEx(const void* PDFFont, const char* FontFile, bool Embed)=0;
   virtual SI32    ReplaceFontEx(const void* PDFFont, const UI16* FontFile, bool Embed)=0;
   virtual SI32    ReplaceICCProfile(UI32 ColorSpace, const char* ICCFile)=0;
   virtual SI32    ReplaceICCProfile(UI32 ColorSpace, const UI16* ICCFile)=0;
   virtual SI32    SetAnnotSubject(UI32 Handle, const char* Value)=0;
   virtual SI32    SetAnnotSubject(UI32 Handle, const UI16* Value)=0;
   virtual SI32    SetColDefFile(UI32 EmbFile)=0;
   virtual SI32    SetColSortField(UI32 ColField, bool AscendingOrder)=0;
   virtual SI32    SetDocInfoEx(TDocumentInfo DInfo, const char* Key, const char* Value)=0;
   virtual SI32    SetDocInfoEx(TDocumentInfo DInfo, const char* Key, const UI16* Value)=0;
   virtual SI32    SetEMFFrameDPI(UI32 DPIX, UI32 DPIY)=0;
   virtual SI32    SetExtGState(UI32 Handle)=0;
   virtual SI32    SetFieldBBox(UI32 AField, TPDFRect* BBox)=0;
   virtual SI32    SetFieldFontSize(UI32 AField, double FontSize)=0;
   virtual SI32    SetFieldHighlightMode(UI32 AField, THighlightMode Mode)=0;
   virtual SI32    SetFillColorSpace(TPDFColorSpace CS)=0;
   virtual SI32    SetFontEx(const char* Name, SI32 Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    SetFontEx(const UI16* Name, SI32 Style, double Size, bool Embed, TCodepage CP)=0;
   virtual void    SetGStateFlags(UI32 Flags, bool Reset)=0;
   virtual SI32    SetListFont(UI32 Handle)=0;
   virtual SI32    SetOrientationEx(SI32 Value)=0;
   virtual SI32    SetStrokeColorSpace(TPDFColorSpace CS)=0;
   virtual void    SetTrapped(bool Value)=0;
   virtual SI32    AddBookmarkEx(const char* Title, SI32 Parent, UI32 NamedDest, bool Open)=0;
   virtual SI32    AddBookmarkEx(const UI16* Title, SI32 Parent, UI32 NamedDest, bool Open)=0;
   virtual SI32    CreateGoToAction(UI32 NamedDest)=0;
   virtual SI32    CreateGoToRAction(const char* FileName, const char* DestName, bool NewWindow)=0;
   virtual SI32    CreateGoToRAction(const char* FileName, const UI16* DestName, bool NewWindow)=0;
   virtual SI32    CreateNamedDest(const char* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d)=0;
   virtual SI32    CreateNamedDest(const UI16* Name, UI32 DestPage, TDestType DestType, double a, double b, double c, double d)=0;
   virtual SI32    PageLink2(double PosX, double PosY, double Width, double Height, UI32 NamedDest)=0;
   virtual SI32    CreateCIEColorSpace(TExtColorSpace Base, float* WhitePoint, float* BlackPoint, float* Gamma, float* Matrix)=0;
   virtual SI32    CreateICCBasedColorSpace(const char* ICCProfile)=0;
   virtual SI32    CreateICCBasedColorSpace(const UI16* ICCProfile)=0;
   virtual SI32    CreateIndexedColorSpace(TExtColorSpace Base, SI32 Handle, const void* ColorTable, UI32 NumColors)=0;
   virtual SI32    CreateSeparationCS(const char* Colorant, TExtColorSpace Alternate, SI32 Handle, UI32 Color)=0;
   virtual SI32    GetBidiMode(void)=0;
   virtual SI32    SetBidiMode(TPDFBidiMode Mode)=0;
   virtual SI32    SetExtColorSpace(UI32 Handle)=0;
   virtual SI32    AddPageLabel(UI32 StartRange, TPageLabelFormat Format, const char* Prefix, SI32 AddNum)=0;
   virtual SI32    AddPageLabel(UI32 StartRange, TPageLabelFormat Format, const UI16* Prefix, SI32 AddNum)=0;
   virtual void    DeletePageLabels(void)=0;
   virtual SI32    DeleteSeparationInfo(bool AllPages)=0;
   virtual SI32    GetPageLabel(UI32 Index, TPDFPageLabel* Label)=0;
   virtual SI32    GetPageLabelCount(void)=0;
   virtual SI32    GetSeparationInfo(char* &Colorant, TExtColorSpace &CS)=0;
   virtual SI32    GetTemplHandle(void)=0;
   virtual SI32    ReplacePageTextEx(const UI16* NewText, TPDFStack* Stack)=0;
   virtual SI32    SetSeparationInfo(UI32 Handle)=0;
   virtual UI32    ConvColor(const double* Color, UI32 NumComps, TExtColorSpace SourceCS, const void* IColorSpace, TExtColorSpace DestCS)=0;
   virtual char*   GetDynaPDFVersion(void)=0;
   virtual SI32    AddImage(TCompressionFilter Filter, TImageConversionFlags Flags, struct TPDFImage* Image)=0;
   virtual SI32    CloseImage(void)=0;
   virtual SI32    CloseTag(void)=0;
   virtual SI32    ComputeBBox(struct TPDFRect &BBox, TCompBBoxFlags Flags)=0;
   virtual SI32    ConvertColors(TColorConvFlags Flags, const float* Color)=0;
   virtual SI32    CreateAnnotAP(UI32 Annot)=0;
   virtual SI32    CreateDeviceNColorSpace(const char** Colorants, UI32 NumColorants, const char* PostScriptFunc, TExtColorSpace Alternate, SI32 Handle)=0;
   virtual SI32    CreateImage(const char* FileName, TImageFormat Format)=0;
   virtual SI32    CreateImage(const UI16* FileName, TImageFormat Format)=0;
   virtual SI32    CreateSeparationInfo(UI32 ColorSpace)=0;
   virtual SI32    CreateStructureTree(void)=0;
   virtual SI32    DeleteEmbeddedFile(UI32 Handle)=0;
   virtual void    DeleteStructureTree(void)=0;
   virtual SI32    FlattenAnnots(TAnnotFlattenFlags Flags)=0;
   virtual void    FreeImageBuffer(void)=0;
   virtual SI32    GetAnnotEx(UI32 Handle, TPDFAnnotationEx &Annot)=0;
   virtual SI32    GetColorSpaceCount(void)=0;
   virtual SI32    GetColorSpaceObj(UI32 Handle, TPDFColorSpaceObj* CS)=0;
   virtual SI32    GetFontCount(void)=0;
   virtual SI32    GetFontEx(UI32 Handle, TPDFFontObj* F)=0;
   virtual char*   GetImageBuffer(UI32 &BufSize)=0;
   virtual UI32    GetImportFlags2(void)=0;
   virtual SI32    GetInIsXFAForm(void)=0;
   virtual SI32    GetInNamedDest(UI32 Index, TPDFNamedDest* Dest)=0;
   virtual SI32    GetInNamedDestCount(void)=0;
   virtual SI32    GetInPrintSettings(TPDFPrintSettings* Settings)=0;
   virtual char*   GetJavaScriptAction2(TObjType ObjType, UI32 ObjHandle, UI32 ActIndex, UI32 &Len, LBOOL &Unicode, TObjEvent &Event)=0;
   virtual SI32    GetNeedAppearance(void)=0;
   virtual SI32    GetPageAnnot(UI32 Index, TPDFAnnotation &Annot)=0;
   virtual SI32    GetPageAnnotCount(void)=0;
   virtual SI32    GetPageAnnotEx(UI32 Index, TPDFAnnotationEx &Annot)=0;
   virtual SI32    GetPrintSettings(TPDFPrintSettings* Settings)=0;
   virtual SI32    GetTextFieldValue(UI32 AField, char* &Value, LBOOL &ValIsUnicode, char* &DefValue, LBOOL &DefValIsUnicode)=0;
   virtual SI32    HighlightAnnot(TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const char* Author, const char* Subject, const char* Comment)=0;
   virtual SI32    HighlightAnnot(TAnnotType SubType, double PosX, double PosY, double Width, double Height, UI32 Color, const UI16* Author, const UI16* Subject, const UI16* Comment)=0;
   virtual SI32    OpenTag(TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion)=0;
   virtual SI32    OpenTag(TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion)=0;
   virtual SI32    SetFillColorEx(const BYTE* Value, UI32 NumComponents)=0;
   virtual SI32    SetImportFlags2(TImportFlags2 Flags)=0;
   virtual SI32    SetNeedAppearance(bool Value)=0;
   virtual SI32    SetPrintSettings(TDuplexMode Mode, SI32 PickTrayByPDFSize, UI32 NumCopies, TPrintScaling PrintScaling, UI32* PrintRanges, UI32 NumRanges)=0;
   virtual SI32    SetStrokeColorEx(const BYTE* Value, UI32 NumComponents)=0;
   virtual SI32    SetTextFieldValueEx(UI32 Field, const char* Value)=0;
   virtual SI32    SetTextFieldValueEx(UI32 Field, const UI16* Value)=0;
   virtual SI32    StampAnnot(TRubberStamp Type, double PosX, double PosY, double Width, double Height, const char* Author, const char* Subject, const char* Comment)=0;
   virtual SI32    StampAnnot(TRubberStamp Type, double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Subject, const UI16* Comment)=0;
   virtual SI32    AddDeviceNProcessColorants(UI32 DeviceNCS, const char** Colorants, UI32 NumColorants, TExtColorSpace ProcessCS, SI32 Handle)=0;
   virtual SI32    AddDeviceNSeparations(UI32 DeviceNCS, const char** Colorants, UI32* SeparationCS, UI32 NumColorants)=0;
   virtual SI32    GetCheckBoxCharEx(UI32 AField)=0;
   virtual SI32    LoadFDFData(const char* FileName, const char* Password, UI32 Flags)=0;
   virtual SI32    LoadFDFData(const UI16* FileName, const char* Password, UI32 Flags)=0;
   virtual SI32    LoadFDFData(const void* Buffer, UI32 BufSize, const char* Password, UI32 Flags)=0;
   virtual SI32    SetAnnotString(UI32 Handle, TAnnotString StringType, const char* Value)=0;
   virtual SI32    SetAnnotString(UI32 Handle, TAnnotString StringType, const UI16* Value)=0;
   virtual void    DeleteAcroForm(void)=0;
   virtual void    DeleteJavaScripts(bool DelJavaScriptActions)=0;
   virtual void    DeleteXFAForm(void)=0;
   virtual SI32    Set3DAnnotProps(UI32 Annot, T3DActivationType ActType, T3DDeActivateType DeActType, T3DInstanceType InstType, T3DDeActInstance DeInstType, bool DisplToolbar, bool DisplModelTree)=0;
   virtual SI32    Set3DAnnotScript(UI32 Annot, const char* Value, UI32 Len)=0;
   // --------------------------------------------- DynaPDF 2.5 ---------------------------------------------
   virtual SI32    GetCMap(UI32 Index, TPDFCMap* CMap)=0;
   virtual SI32    GetCMapCount(void)=0;
   virtual void    GetFontSearchOrder(TFontBaseType Order[4])=0;
   virtual UI32*   GetMissingGlyphs(UI32 &Count)=0;
   virtual SI32    LoadCMap(const char* CMapName, bool Embed)=0;
   virtual SI32    PlaceTemplateEx(SI32 TmplHandle, double PosX, double PosY, double ScaleWidth, double ScaleHeight)=0;
   virtual SI32    SetCIDFont(UI32 CMapHandle, const char* Name, TFStyle Style, double Size, bool Embed)=0;
   virtual SI32    SetCIDFont(UI32 CMapHandle, const UI16* Name, TFStyle Style, double Size, bool Embed)=0;
   virtual SI32    SetCMapDir(const char* Path, bool Recursive)=0;
   virtual SI32    SetCMapDir(const UI16* Path, bool Recursive)=0;
   virtual void    SetFontSearchOrder(TFontBaseType Order[4])=0;
   virtual SI32    GetFieldEx(UI32 Handle, TPDFFieldEx* Field)=0;
   virtual SI32    GetPageFieldEx(UI32 Index, TPDFFieldEx* Field)=0;
   virtual SI32    CloseAndSignFileExt(struct TPDFSigParms* SigParms)=0;
   virtual SI32    FinishSignature(const void* PKCS7Obj, UI32 Length)=0;
   virtual SI32    AddRenderingIntentEx(const void* Buffer, UI32 BufSize)=0;
   virtual SI32    GetInIsTrapped(void)=0;
   virtual SI32    GetFieldChoiceValue(UI32 AField, UI32 ValIndex, TPDFChoiceValue* Value)=0;
   virtual SI32    RenameSpotColor(const char* Colorant, const char* NewName)=0;
   virtual SI32    SetAnnotBorderStyle(UI32 Handle, TBorderStyle Style)=0;
   virtual SI32    SetAnnotBorderWidth(UI32 Handle, double LineWidth)=0;
   virtual SI32    SetAnnotColor(UI32 Handle, TAnnotColor ColorType, TPDFColorSpace CS, UI32 Color)=0;
   virtual SI32    SetAnnotFlagsEx(UI32 Handle, SI32 Flags)=0;
   virtual SI32    SetAnnotHighlightMode(UI32 Handle, THighlightMode Mode)=0;
   virtual SI32    SetAnnotIcon(UI32 Handle, TAnnotIcon Icon)=0;
   virtual SI32    SetAnnotOpenState(UI32 Handle, bool Open)=0;
   virtual SI32    AddObjectToLayer(UI32 OCG, TOCObject ObjType, UI32 Handle)=0;
   virtual SI32    BeginLayer(UI32 OCG)=0;
   virtual SI32    CreateOCG(const char* Name, bool DisplayInUI, bool Visible, TOCGIntent Intent)=0;
   virtual SI32    CreateOCG(const UI16* Name, bool DisplayInUI, bool Visible, TOCGIntent Intent)=0;
   virtual SI32    CreateOCMD(TOCVisibility Visibility, UI32* OCGs, UI32 Count)=0;
   virtual SI32    CreateSetOCGStateAction(UI32* On, UI32 OnCount, UI32* Off, UI32 OffCount, UI32* Toggle, UI32 ToggleCount, bool PreserveRB)=0;
   virtual SI32    EndLayer(void)=0;
   // --------------------------------------------- DynaPDF 3.0 ---------------------------------------------
   virtual SI32    CreateBarcodeField(const char* Name, SI32 Parent, double PosX, double PosY, double Width, double Height, TPDFBarcode* Barcode)=0;
   virtual SI32    FlushPages(TFlushPageFlags Flags)=0;
   virtual SI32    GetErrLogMessage(UI32 Index, TPDFError* Err)=0;
   virtual UI32    GetErrLogMessageCount(void)=0;
   virtual SI32    GetInFieldCount(void)=0;
   virtual SI32    GetNamedDest(UI32 Index, TPDFNamedDest* Dest)=0;
   virtual SI32    GetNamedDestCount(void)=0;
   virtual bool    HaveOpenPage(void)=0;
   virtual SI32    InsertImageEx(double PosX, double PosY, double ScaleWidth, double ScaleHeight, const UI16* Image, UI32 Index)=0;
   virtual void    SetMaxErrLogMsgCount(UI32 Value)=0;
   virtual SI32    CreateGoToRAction(const UI16* FileName, UI32 PageNum)=0;
   virtual SI32    CreateGoToRActionU(const UI16* FileName, const char* DestName, bool NewWindow)=0;
   virtual SI32    CreateGoToRActionU(const UI16* FileName, const UI16* DestName, bool NewWindow)=0;
   virtual bool    GetDocUsesTransparency(UI32 Flags)=0;
   virtual bool    GetIsTaggingEnabled(void)=0;
   virtual SI32    CreateLaunchActionEx(const char* FileName, bool NewWindow)=0;
   virtual SI32    CreateLaunchActionEx(const UI16* FileName, bool NewWindow)=0;
   virtual void    ClearErrorLog(void)=0;
   virtual IPGE*   GetPageObject(UI32 PageNum)=0;
   virtual SI32    AddRasImage(IRAS* RasPtr, TCompressionFilter Filter)=0;
   virtual IRAS*   CreateRasterizer(BYTE** Rows, BYTE* Buffer, UI32 Width, UI32 Height, SI32 ScanlineLen, TPDFPixFormat PixelFormat)=0;
   virtual SI32    RenderPage(IPGE* PagePtr, IRAS* RasPtr, TPDFRasterImage* Img)=0;
   virtual SI32    RenderPDFFile(const char* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual SI32    RenderPDFFile(const UI16* OutFile, UI32 Resolution, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual SI32    SetCMapDir(const char* Path, TLoadCMapFlags Flags)=0;
   virtual SI32    SetCMapDir(const UI16* Path, TLoadCMapFlags Flags)=0;
   virtual SI32    SetExtFillColorSpace(UI32 Handle)=0;
   virtual SI32    SetExtStrokeColorSpace(UI32 Handle)=0;
   virtual SI32    SetFillColorF(const float* Value, UI32 NumComponents)=0;
   virtual SI32    SetStrokeColorF(const float* Value, UI32 NumComponents)=0;
   virtual IRAS*   CreateRasterizerEx(const void* DC, UI32 Width, UI32 Height, TPDFPixFormat PixelFormat)=0;
   virtual SI32    BeginTransparencyGroup(double x1, double y1, double x2, double y2, bool Isolated, bool Knockout, TExtColorSpace CS, SI32 CSHandle)=0;
   virtual PSMK*   CreateSoftMask(UI32 TranspGroup, TSoftMaskType Type, UI32 BackColor)=0;
   virtual SI32    RenderPageToImage(UI32 PageNum, const char* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual SI32    RenderPageToImage(UI32 PageNum, const UI16* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual float   GetUserUnit(void)=0;
   virtual SI32    SetUserUnit(float Value)=0;
   virtual SI32    LoadFontEx(const char* FontFile, UI32 Index, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    LoadFontEx(const UI16* FontFile, UI32 Index, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    PageLink3(double PosX, double PosY, double Width, double Height, const char* NamedDest)=0;
   virtual SI32    PageLink3(double PosX, double PosY, double Width, double Height, const UI16* NamedDest)=0;
   virtual SI32    SetFieldExpValueEx(UI32 Field, UI32 ValIndex, bool Selected, bool DefSelected)=0;
   virtual SI32    AddBookmarkEx2(const char* Title, SI32 Parent, const void* NamedDest, bool Unicode, bool Open)=0;
   virtual SI32    AddBookmarkEx2(const UI16* Title, SI32 Parent, const void* NamedDest, bool Unicode, bool Open)=0;
   virtual SI32    CreateICCBasedColorSpaceEx(const void* Buffer, UI32 BufSize)=0;
   virtual SI32    ReadImageFormat(const UI16* FileName, UI32 &Width, UI32 &Height, SI32 &BitsPerPixel, SI32 &UseZip, UI32 Index = 1)=0;
   virtual SI32    ReadImageResolution(const UI16* FileName, UI32 Index, UI32 &ResX, UI32 &ResY)=0;
   virtual LGRP*   AddLayerToDisplTree(LGRP* Parent, SI32 Layer, const char* Title)=0;
   virtual LGRP*   AddLayerToDisplTree(LGRP* Parent, SI32 Layer, const UI16* Title)=0;
   virtual SI32    LockLayer(UI32 Layer)=0;
   virtual SI32    UnLockLayer(UI32 Layer)=0;
   virtual SI32    GetImageCount(const UI16* FileName)=0;
   virtual SI32    AddButtonImage(UI32 BtnHandle, TButtonState State, const UI16* Caption, const UI16* ImgFile)=0;
   virtual SI32    BeginPageTemplate(const char* Name, bool UseAutoTemplates)=0;
   virtual SI32    GetLogMetafileSize(const UI16* FileName, struct TRectL* R)=0;
   virtual SI32    InsertMetafile(const UI16* FileName, struct TRectL* View, double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    AddOutputIntent(const char* ICCFile)=0;
   virtual SI32    AddOutputIntent(const UI16* ICCFile)=0;
   virtual SI32    AddOutputIntentEx(const void* Buffer, UI32 BufSize)=0;
   virtual SI32    AddMaskImage(UI32 BaseImage, const void* Buffer, UI32 BufSize, SI32 Stride, UI32 BitsPerPixel, UI32 Width, UI32 Height)=0;
   virtual SI32    CreateGoToEAction(TEmbFileLocation Location, const char* Source, UI32 SrcPage, const char* Target, const char* DestName, UI32 DestPage, bool NewWindow)=0;
   virtual SI32    CreateGoToEAction(TEmbFileLocation Location, const UI16* Source, UI32 SrcPage, const UI16* Target, const UI16* DestName, UI32 DestPage, bool NewWindow)=0;
   virtual SI32    InsertRawImageEx(double PosX, double PosY, double ScaleWidth, double ScaleHeight, TPDFRawImage* Image)=0;
   virtual SI32    SetColorMask(UI32 ImageHandle, SI32* Mask, UI32 Count)=0;
   virtual SI32    ConvertEMFSpool(const char* SpoolFile, double LeftMargin, double TopMargin, TSpoolConvFlags Flags)=0;
   virtual SI32    ConvertEMFSpool(const UI16* SpoolFile, double LeftMargin, double TopMargin, TSpoolConvFlags Flags)=0;
   virtual SI32    ChangeSeparationColor(UI32 CSHandle, UI32 NewColor, TExtColorSpace Alternate, SI32 AltHandle)=0;
   virtual SI32    CircleOrSquareAnnot(bool Circle, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Comment)=0;
   virtual SI32    CircleOrSquareAnnot(bool Circle, double PosX, double PosY, double Width, double Height, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Comment)=0;
   virtual SI32    AssociateEmbFile(TAFDestObject DestObject, SI32 DestHandle, TAFRelationship Relashionship, UI32 EmbFile)=0;
   virtual SI32    LineAnnot(double x1, double y1, double x2, double y2, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Comment)=0;
   virtual SI32    LineAnnot(double x1, double y1, double x2, double y2, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Comment)=0;
   virtual SI32    SetAnnotOrFieldDate(UI32 Handle, bool IsField, TDateType Type, UI32 DateTime)=0;
   virtual SI32    FreeImageObj(UI32 Handle)=0;
   virtual SI32    GetImageObj(UI32 Handle, TParseFlags Flags, TPDFImage* Image)=0;
   virtual SI32    GetImageObjCount(void)=0;
   virtual SI32    GetInMetadata(SI32 PageNum, BYTE** Buffer, UI32* BufSize)=0;
   virtual SI32    GetMetadata(TMetadataObj ObjType, SI32 Handle, BYTE** Buffer, UI32* BufSize)=0;
   virtual SI32    PolygonOrPolyLineAnnot(bool PolyLine, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content)=0;
   virtual SI32    PolygonOrPolyLineAnnot(bool PolyLine, struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content)=0;
   virtual SI32    PolygonAnnot(struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content)
      {return PolygonOrPolyLineAnnot(false, Vertices, NumVertices, LineWidth, leNone, leNone, FillColor, StrokeColor, CS, Author, Subject, Content);}
   virtual SI32    PolygonAnnot(struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content)
      {return PolygonOrPolyLineAnnot(false, Vertices, NumVertices, LineWidth, leNone, leNone, FillColor, StrokeColor, CS, Author, Subject, Content);}
   virtual SI32    PolyLineAnnot(struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content)
      {return PolygonOrPolyLineAnnot(true, Vertices, NumVertices, LineWidth, Start, End, FillColor, StrokeColor, CS, Author, Subject, Content);}
   virtual SI32    PolyLineAnnot(struct TFltPoint* Vertices, UI32 NumVertices, double LineWidth, TLineEndStyle Start, TLineEndStyle End, UI32 FillColor, UI32 StrokeColor, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content)
      {return PolygonOrPolyLineAnnot(true, Vertices, NumVertices, LineWidth, Start, End, FillColor, StrokeColor, CS, Author, Subject, Content);}
   virtual SI32    SetAnnotLineEndStyle(UI32 Handle, TLineEndStyle Start, TLineEndStyle End)=0;
   virtual SI32    SetLineAnnotParms(UI32 Handle, SI32 FontHandle, double FontSize, struct TLineAnnotParms* Parms)=0;
   virtual SI32    DeleteOutputIntent(SI32 Index)=0;
   virtual SI32    FreeImageObjEx(const void* ImagePtr)=0;
   virtual SI32    GetImageObjEx(const PIMG* ImagePtr, TParseFlags Flags, TPDFImage* Image)=0;
   virtual SI32    GetOutputIntent(UI32 Index, TPDFOutputIntent* Intent)=0;
   virtual SI32    GetOutputIntentCount(void)=0;
   virtual SI32    Optimize(TOptimizeFlags Flags, TOptimizeParams* Parms, SI32 PageNum = -1)=0;
   virtual void    EnableMutex(bool Value)=0;
   virtual SI32    GetFontInfoEx(UI32 Handle, TPDFFontInfo* F)=0;
   virtual SI32    RenderAnnotOrField(UI32 Handle, bool IsAnnot, TButtonState State, TCTM* Matrix, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TPDFBitmap* Out)=0;
   virtual SI32    AddOCGToAppEvent(UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories)=0;
   virtual SI32    DeleteOCGFromAppEvent(UI32 Handle, TOCAppEvent Events, TOCGUsageCategory Categories, bool DelCategoryOnly)=0;
   virtual SI32    GetOCG(UI32 Handle, TPDFOCG* Out)=0;
   virtual SI32    GetOCGContUsage(UI32 Handle, TPDFOCGContUsage* Out)=0;
   virtual SI32    GetOCGCount(void)=0;
   virtual SI32    GetOCGUsageUserName(UI32 Handle, UI32 Index, char* &NameA, UI16* &NameW)=0;
   virtual SI32    SetOCGContUsage(UI32 Handle, TPDFOCGContUsage* Value)=0;
   virtual SI32    SetOCGState(UI32 Handle, bool On, bool SaveState)=0;
   virtual SI32    GetSysFontInfo(UI32 Index, TPDFSysFont* Out)=0;
   virtual SI32    GetViewport(UI32 PageNum, UI32 Index, struct TPDFViewport* VP)=0;
   virtual SI32    GetViewportCount(UI32 PageNum)=0;
   virtual SI32    SetFieldFont(UI32 Field, const char* Name, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    SetFieldFont(UI32 Field, const UI16* Name, TFStyle Style, double Size, bool Embed, TCodepage CP)=0;
   virtual SI32    SetFieldFontEx(UI32 Field, UI32 Handle, double FontSize)=0;
   virtual SI32    TestGlyphs(SI32 FontHandle, const char* Text, UI32 Len)=0;
   virtual SI32    TestGlyphs(SI32 FontHandle, const UI16* Text, UI32 Len)=0;
   virtual SI32    SetMetadata(TMetadataObj ObjType, SI32 Handle, const void* Buffer, UI32 BufSize)=0;
   virtual SI32    PrintPDFFile(const char* TmpDir, const char* DocName, const void* DC, TPDFPrintFlags Flags, TRectL* Margin, TPDFPrintParams* Parms)=0;
   virtual SI32    PrintPDFFile(const UI16* TmpDir, const UI16* DocName, const void* DC, TPDFPrintFlags Flags, TRectL* Margin, TPDFPrintParams* Parms)=0;
   virtual SI32    CaretAnnot(double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content)=0;
   virtual SI32    CaretAnnot(double PosX, double PosY, double Width, double Height, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content)=0;
   virtual SI32    SetAnnotBorderEffect(UI32 Handle, TBorderEffect Value)=0;
   virtual SI32    AddInkList(UI32 InkAnnot, struct TFltPoint* Points, UI32 NumPoints)=0;
   virtual SI32    GetResetAction(UI32 Handle, TPDFResetFormAction* Value)=0;
   virtual SI32    GetSubmitAction(UI32 Handle, TPDFSubmitFormAction* Value)=0;
   virtual SI32    InkAnnot(TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const char* Author, const char* Subject, const char* Content)=0;
   virtual SI32    InkAnnot(TFltPoint* Points, UI32 NumPoints, double LineWidth, UI32 Color, TPDFColorSpace CS, const UI16* Author, const UI16* Subject, const UI16* Content)=0;
   virtual SI32    SetAnnotQuadPoints(UI32 Handle, TFltPoint* Value, UI32 Count)=0;
   virtual SI32    GetActionHandle(TObjType ObjType, UI32 ObjHandle, UI32 ActIndex)=0;
   virtual SI32    SetAnnotMigrationState(UI32 Annot, TAnnotState State, const char* User)=0;
   virtual SI32    SetAnnotMigrationState(UI32 Annot, TAnnotState State, const UI16* User)=0;
   virtual SI32    ApplyAppEvent(TOCAppEvent Event, bool SaveResult)=0;
   virtual SI32    DeleteAppEvents(bool ApplyEvent, TOCAppEvent Event)=0;
   virtual SI32    SetFieldName(UI32 Field, const UI16* NewName)=0;
   virtual SI32    InitColorManagementEx(TPDFColorProfilesEx* Profiles, TPDFColorSpace DestSpace, TPDFInitCMFlags Flags)=0;
   virtual SI32    SetAnnotOpacity(UI32 Handle, double Value)=0;
   virtual SI32    SetFieldExpValue(UI32 Field, UI32 ValIndex, const UI16* Value, const char* ExpValue, bool Selected)=0;
   virtual UI16    GetGlyphIndex(UI32 Index)=0;
   virtual SI32    GetGlyphOutline(UI32 Index, TPDFGlyphOutline* Outline)=0;
   virtual SI32    CopyChoiceValues(UI32 Source, UI32 Dest, bool Share)=0;
   virtual SI32    FindEmbeddedFile(const char* Name)=0;
   virtual SI32    FindEmbeddedFile(const UI16* Name)=0;
   virtual SI32    OpenOutputFileEncrypted(const char* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict)=0;
   virtual SI32    OpenOutputFileEncrypted(const UI16* OutPDF, const char* OpenPwd, const char* OwnerPwd, TKeyLen KeyLen, TRestrictions Restrict)=0;
   virtual SI32    GetImageHandle(const PIMG* ImagePtr)=0;
   virtual SI32    AddAnnotToPage(UI32 PageNum, UI32 Handle)=0;
   virtual SI32    GetHideAction(UI32 Handle, TPDFHideAction* Action)=0;
   virtual SI32    WatermarkAnnot(double PosX, double PosY, double Width, double Height)=0;
   virtual SI32    DeleteAnnotationFromPage(UI32 PageNum, UI32 Handle)=0;
   virtual SI32    GetGoToAction(UI32 Handle, TPDFGoToAction* Action)=0;
   virtual SI32    GetImportDataAction(UI32 Handle, TPDFImportDataAction* Action)=0;
   virtual SI32    GetJavaScriptActionEx(UI32 Handle, TPDFJavaScriptAction* Action)=0;
   virtual SI32    GetLaunchAction(UI32 Handle, TPDFLaunchAction* Action)=0;
   virtual SI32    GetMovieAction(UI32 Handle, TPDFMovieAction* Action)=0;
   virtual SI32    GetNamedAction(UI32 Handle, TPDFNamedAction* Action)=0;
   virtual SI32    GetObjActions(TObjType ObjType, UI32 ObjHandle, TPDFObjActions* Actions)=0;
   virtual SI32    GetURIAction(UI32 Handle, struct TPDFURIAction* Action)=0;
   virtual SI32    ImportEncryptionSettings(void)=0;
   virtual SI32    ResetEncryptionSettings(void)=0;
   virtual SI32    ReplaceImage(const PIMG* Source, const char* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags)=0;
   virtual SI32    ReplaceImage(const PIMG* Source, const UI16* Image, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags)=0;
   virtual SI32    ReplaceImage(const PIMG* Source, const void* Buffer, UI32 BufSize, UI32 Index, TExtColorSpace CS, SI32 CSHandle, TReplaceImageFlags Flags)=0;
   virtual SI32    GetLayerConfig(SI32 Index, TPDFOCLayerConfig* Config)=0;
   virtual SI32    GetLayerConfigCount(void)=0;
   virtual IOCN*   GetOCUINode(const IOCN* Node, TPDFOCUINode* OutNode)=0;
   virtual SI32    ImportOCProperties(void)=0;
   virtual SI32    LoadLayerConfig(SI32 Index)=0;
   virtual SI32    SetUseImageInterpolation(UI32 Handle, bool Value)=0;
   virtual SI32    ExtractText(UI32 PageNum, TTextExtractionFlags Flags, struct TFltRect* Area, UI16** Text, UI32* TextLen)=0;
   virtual SI32    FileAttachAnnotEx(double PosX, double PosY, TFileAttachIcon Icon, const char* FileName, const char* Author, const char* Description, const void* Buffer, UI32 BufSize, bool Compress)=0;
   virtual SI32    FileAttachAnnotEx(double PosX, double PosY, TFileAttachIcon Icon, const UI16* FileName, const UI16* Author, const UI16* Description, const void* Buffer, UI32 BufSize, bool Compress)=0;
   virtual SI32    RenderPDFFileEx(const char* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual SI32    RenderPDFFileEx(const UI16* OutFile, UI32 Resolution, SI32 Width, SI32 Height, TRasterFlags Flags, TPDFPixFormat PixFmt, TCompressionFilter Filter, TImageFormat Format)=0;
   virtual SI32    GetUsesTransparency(SI32 PageNum)=0;
   virtual SI32    Get3DAnnotStream(UI32 Annot, BYTE** Data, UI32* Size, char** SubType)=0;
   virtual SI32    ExtractText(const IPSR* Ctx, UI32 PageNum, TTextExtractionFlags Flags, struct TFltRect* Area, UI16** Text, UI32* TextLen)=0;
   virtual SI32    Create3DAnnot(double PosX, double PosY, double Width, double Height, const UI16* Author, const UI16* Name, const UI16* U3DFile, const UI16* Image)=0;
   virtual SI32    GetViewerPreferences(SI32 &Preference, SI32 &AddVal)=0;
   virtual SI32    GetFontMetrics(UI32 Handle, TPDFFontMetrics* Metrics)=0;
   virtual I3DV*   Create3DView(UI32 Base3DAnnot, const UI16* Name, bool SetAsDefault, double* Matrix, double CamDistance, T3DRenderingMode RM, T3DLightingSheme LS)=0;
   virtual SI32    GetFieldCalcOrder(UI32** Out)=0;
   virtual SI32    SetFieldCalcOrder(SI32 CurrIndex, UI32 NewIndex)=0;
   virtual SI32    CreateRectilinearMeasure(UI32 Viewport, double Scale, const char* UnitDescription, const char* LabelDistance, const char* LabelArea)=0;
   virtual SI32    CreateRectilinearMeasure(UI32 Viewport, double Scale, const UI16* UnitDescription, const UI16* LabelDistance, const UI16* LabelArea)=0;
   virtual SI32    CreateViewport(const char* Name, double X1, double Y1, double X2, double Y2)=0;
   virtual SI32    CreateViewport(const UI16* Name, double X1, double Y1, double X2, double Y2)=0;
   virtual SI32    CreateXFAStream(const char* Name, const void* Buffer, UI32 BufSize)=0;
   virtual SI32    CreateXFAStream(const UI16* Name, const void* Buffer, UI32 BufSize)=0;
   virtual SI32    SetXFAStream(UI32 Index, const void* Buffer, UI32 BufSize)=0;
   virtual SI32    SetLineDashPattern(const float* Dash, UI32 NumValues, float Phase)=0;
   virtual SI32    FlattenAnnotOrField(UI32 Index, TAnnotFlattenFlags Flags)=0;
   virtual SI32    FlushPagesEx(TFlushPageFlags Flags, UI32 LastPage)=0;
   virtual SI32    ResetAnnotAP(SI32 Handle)=0;
   virtual SI32    DrawNGon(double PosX, double PosY, double Radius, double Alpha, UI32 NumSides, TPathFillMode FillMode)=0;
   virtual SI32    InsertBarcode(double PosX, double PosY, double Width, double Height, TCellAlign HAlign, TCellAlign VAlign, TPDFBarcode2* Barcode)=0;
   virtual SI32    AddHeaderFooter(TPDFHeaderFooter* Init, TPDFHdrFtr* HFArray, UI32 Count)=0;
   virtual SI32    LoadHeaderFooterSettings(TPDFHeaderFooter* Init, TPDFHdrFtr* HFArray)=0;
   virtual SI32    ChangeOCGName(UI32 Handle, const char* Value)=0;
   virtual SI32    ChangeOCGName(UI32 Handle, const UI16* Value)=0;
   virtual SI32    DeleteNamedDest(SI32 Index)=0;
   virtual SI32    DeleteNamedDest(const char* Name)=0;
   virtual SI32    DeleteNamedDest(const UI16* Name)=0;
   virtual SI32    GetInIsTaggedPDF(void)=0;
   virtual SI32    DeleteOCGFromDisplayTree(UI32 OCGHandle, bool Recursive)=0;
   virtual SI32    DeleteOCUINode(IOCN* Node)=0;
   virtual SI32    GetPDFVersionEx(TPDFVersionInfo* Value)=0;
   virtual SI32    GetInPDFVersionEx(TPDFVersionInfo* Value)=0;
   virtual SI32    AddButtonImage(UI32 BtnHandle, TButtonState State, const char* Caption, const void* Buffer, UI32 BufSize)=0;
   virtual SI32    ActivateAltFontList(SI32 Handle, bool EnableSysFonts)=0;
   virtual SI32    CreateAltFontList(void)=0;
   virtual SI32    DeleteAltFontList(UI32 Handle)=0;
   virtual SI32    SetAltFonts(UI32 ListHandle, const char** List, UI32 Count)=0;
   virtual SI32    SetAltFonts(UI32 ListHandle, const UI16** List, UI32 Count)=0;
   virtual SI32    SetSpaceWidthFactor(double Value)=0;
   virtual SI32    SetTemplBBox(UI32 Handle, TPageBoundary Boundary, TPDFRect* BBox)=0;
   virtual double  GetFontSize(void)=0;
   virtual SI32    SetRenderingIntent(UI32 ImgHandle, TRenderingIntent Value)=0;
   virtual SI32    ChangeNamedDest(TObjType ObjType, UI32 Handle, const char* NewDestName)=0;
   virtual SI32    ChangeNamedDest(TObjType ObjType, UI32 Handle, const UI16* NewDestName)=0;
   virtual SI32    GetBookmarkEx(UI32 Handle, struct TPDFBookmark* Bmk)=0;
   virtual SI32    GetCollectionInfo(TPDFCollectionInfo* Value)=0;
   virtual SI32    OpenTagBBox(TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion, TBBox* BBox)=0;
   virtual SI32    OpenTagBBox(TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion, TBBox* BBox)=0;
   virtual SI32    CreateStructureTreeEx(TPDFBaseTag RootTag)=0;
   virtual SI32    AddDPartNode(SI32 Parent, SI32 First, SI32 Last, const char* DPM)=0;
   virtual SI32    CreateDPartRoot(const char** NodeNameList, UI32 NodeNamesCount, SI32 RecordLevel)=0;
   virtual SI32    DeleteWatermark(SI32 PageNum, LBOOL InclAnnots)=0;
   virtual UI32    GetLastTextOffset(void)=0;
   virtual bool    HaveDPartRoot(void)=0;
   virtual SI32    MarkTemplateAsWatermark(UI32 Handle)=0;
   virtual SI32    OpenTagEx(TPDFBaseTag Tag, const char* Lang, const char* AltText, const char* Expansion, const char* Attributes)=0;
   virtual SI32    OpenTagEx(TPDFBaseTag Tag, const char* Lang, const UI16* AltText, const UI16* Expansion, const char* Attributes)=0;
   virtual SI32    DeleteDPartNode(SI32 Handle)=0;
   virtual SI32    DeleteText(const IPSR* Ctx, TFltRect* Area, TDeleteTextFlags Flags)=0;
   virtual SI32    CreateGeospatialMeasure(UI32 Viewport, const char* Attributes)=0;
   virtual SI32    SetPageOrientation(IPGE* PagePtr, SI32 Value)=0;
   virtual SI32    GetFullyQualifiedFieldName(UI32 Handle, UI16* &Out)=0;
   virtual SI32    GetSelBBox(const IPSR* Ctx, TTextSelection* SelText, TBBox* BBox)=0;
   virtual SI32    GetSelBBox2(struct TTextSelection* SelText, struct TFltPoint QuadPoint[4])=0;
   virtual SI32    GetSelText(TTextSelection* SelText, UI16** Text, UI32* TextLen)=0;
   virtual SI32    EnableImageCache(UI32 MaxImageCount, UI32 Size)=0;
   virtual SI32    SetLineAnnotPoints(UI32 Handle, TFltPoint* P1, TFltPoint* P2)=0;
   virtual SI32    GetInEncryptionInfo(TPDFEncryptInfo* Info)=0;
   virtual SI32    TestPassword(TPwdType PwdType, const char* Value)=0;
   virtual SI32    GetAnnotTextAlign(UI32 Handle)=0;
   virtual SI32    GetAnnotColor(UI32 Handle, TAnnotColor ColorType, TPDFColorSpace* CS, UI32* Color)=0;
   virtual SI32    GetTextBBox(const char* Text, UI32 Len, TBBox* BBox)=0;
   virtual SI32    GetTextBBox(const UI16* Text, UI32 Len, TBBox* BBox)=0;
   virtual double  GetLastTextPosXAbs(void)=0;
   virtual double  GetLastTextPosYAbs(void)=0;
   virtual SI32    ConvToFreeTextCallout(UI32 Handle, float StartX, float StartY, float KneeOffset, TLineEndStyle EndStyle)=0;
   virtual SI32    SetActiveSigField(UI32 Handle)=0;
};

}

#if defined(_MSC_VER) && _MSC_VER >= 1929
   #pragma warning(pop)
#endif

#endif
