#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   
   // The output file is opened later
   pdfCreateNewPDF(pdf, NULL);

   // Set the license key here if you have one
   // pdfSetLicenseKey(pdf, "");

   GetCurrentDirectory(MAX_PATH, filePath);
   strcat(filePath, "/out.pdf");

   // We assume that the pdf invoice is already a valid PDF/A 3 file in this example.

   pdfSetImportFlags(pdf, ifImportAsPage | ifImportAll);
   if (pdfOpenImportFile(pdf, "../../../test_files/test_invoice.pdf", ptOpen, NULL) < 0) goto finish;

   pdfImportPDFFile(pdf, 1, 1.0, 1.0);

   SI32 ef = pdfAttachFile(pdf, "../../../test_files/factur-x.xml", "ZUGFeRD 2.3 Rechnung", false);
   pdfAssociateEmbFile(pdf, adCatalog, -1, arAlternative, ef);

   /* Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
      the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
      compliant, and hence cannot be used to create e-invoices.
   */
   pdfSetPDFVersion(pdf, pvFacturX_Comfort);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath)) goto finish;
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }

  finish:
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}