#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   TPDFRect bbox;
   TPDFExtGState g;
   SI32 grp, sh, gs;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   // Disable color key masking for images
   pdfSetUseTransparency(pdf, false);

   pdfAppend(pdf);
      pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
      pdfWriteText(pdf, 50.0, 50.0, "Transparency effect with a soft mask.");

      pdfInsertImageEx(pdf, 50.0, 80.0, pdfGetPageWidth(pdf) - 100.0, 0.0, "../../../test_files/images/meadow-110719_640.jpg", 1);

      // Note that a transparency group that it used as soft mask has no own coordinate system. The esiest way to avoid coordinate
      // issues is to create the transparency group in the full size of the page or template in which it is used. The real bounding
      // box can be computed after the transparency group was fully defined.
      grp = pdfBeginTransparencyGroup(pdf, 0.0, 0.0, pdfGetPageWidth(pdf), pdfGetPageHeight(pdf), true, false, esDeviceGray, -1);
         pdfSetColorSpace(pdf, csDeviceGray);
         sh = pdfCreateRadialShading(pdf, 400.0, 230.0, 20.0, 400.0, 230.0, 150.0, 1.0, 255, 0, true, false);
         pdfApplyShading(pdf, sh);
         // Optional but recommended: Compute the real bounding of the group if it is used as soft mask.
         pdfComputeBBox(pdf, bbox, cbfNone);
         pdfSetBBox(pdf, pbMediaBox, bbox.Left, bbox.Bottom, bbox.Right, bbox.Top);
      pdfEndTemplate(pdf);

      pdfInitExtGState(&g);
      g.SoftMask = pdfCreateSoftMask(pdf, grp, smtLuminosity, 0);
      gs = pdfCreateExtGState(pdf, &g);

      pdfSetExtGState(pdf, gs);
      pdfInsertImageEx(pdf, 220.0, 80.0, 500.0, 0.0, "../../../test_files/images/tree-frog-69813_640.jpg", 1);
   pdfEndPage(pdf);

   // Very important for consistent color results. Attach always an output intent if transparency is used!
   pdfAddOutputIntent(pdf, "../../../test_files/sRGB.icc");

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
