#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 gs, img;
   TPDFExtGState g;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   // Disable color key masking for images
   pdfSetUseTransparency(pdf, false);

   pdfAppend(pdf);
      pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
      pdfWriteText(pdf, 50.0, 50.0, "Fill Alpha = 0.5");

      pdfRectangle(pdf, 50.0, 70.0, 110.0, 160.0, fmFill);
      pdfSetFillColor(pdf, PDF_WHITE);
      pdfWriteText(pdf, 55.0, 75.0, "Background");

      pdfInitExtGState(&g);
      g.FillAlpha = 0.5f;
      gs = pdfCreateExtGState(pdf, &g);
      pdfSetExtGState(pdf, gs);

      img = pdfInsertImageEx(pdf, 60.0, 84.0, 200.0, 0.0, "../../../test_files/images/tree-frog-69813_640.jpg", 0);

      // To restore an extended graphics state, create a second one that restores the changes made before and activate this state.
      g.FillAlpha = 1.0f;
      gs = pdfCreateExtGState(pdf, &g);
      pdfSetExtGState(pdf, gs);

      pdfSetFillColor(pdf, PDF_BLACK);
      pdfWriteText(pdf, 340.0, 50.0, "Fill Alpha = 1.0 (default)");
      pdfRectangle(pdf, 340.0, 70.0, 110.0, 160.0, fmFill);
      pdfSetFillColor(pdf, PDF_WHITE);
      pdfWriteText(pdf, 345.0, 75.0, "Background");
      pdfPlaceImage(pdf, img, 350.0, 84.0, 200.0, 0.0);
   pdfEndPage(pdf);

   // Very important for consistent color results. Attach always an output intent if transparency is used!
   pdfAddOutputIntent(pdf, "../../../test_files/sRGB.icc");

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
