#include <stdio.h>
#include <conio.h>
#include <Windows.h>
#include <shellapi.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0;
}

int main(int argc, char* argv[])
{
   DWORD timeStart = GetTickCount();

   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 1;

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   SI32 i = 0, pageCount, rowNum = 0;

   pdfCreateNewPDF(pdf, NULL);

   pdfSetPageCoords(pdf, pcTopDown);

   ITBL* tbl = tblCreateTable(pdf, 3, 3, 500.0f, 100.0f);
   tblSetBoxProperty(tbl, -1, -1, tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
   tblSetGridWidth(tbl, 1.0f, 1.0f);

   // -1.0 means use the default row height as specified in the CreateTable() call.
   rowNum = tblAddRow(tbl, -1.0f);

   char text[] = "The cell alignment can be set for text, images, and templates...";

   tblSetCellText(tbl, rowNum, 0, taLeft, coTop, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 1, taCenter, coTop, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 2, taRight, coTop, text, sizeof(text) -1);

   rowNum = tblAddRow(tbl, -1.0f);
   tblSetCellText(tbl, rowNum, 0, taLeft, coCenter, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 1, taCenter, coCenter, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 2, taRight, coCenter, text, sizeof(text) -1);

   rowNum = tblAddRow(tbl, -1.0f);
   tblSetCellText(tbl, rowNum, 0, taLeft, coBottom, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 1, taCenter, coBottom, text, sizeof(text) -1);
   tblSetCellText(tbl, rowNum, 2, taRight, coBottom, text, sizeof(text) -1);

   // Draw the table now
   pdfAppend(pdf);
      tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      while (tblHaveMore(tbl))
      {
         pdfEndPage(pdf);
         pdfAppend(pdf);
         tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      }
   pdfEndPage(pdf);


   // Let's change the cell orientation to see what happens...
   tblSetCellOrientation(tbl, -1, -1, 90);
   pdfAppend(pdf);
      pdfSetFont(pdf, "Arial", fsRegular, 12.0, true, cp1252);
      pdfWriteText(pdf, 50.0, 50.0, "The same table but the cell orientation was changed to 90 degrees.");

      tblDrawTable(tbl, 50.0f, 65.0f, 742.0f);
      while (tblHaveMore(tbl))
      {
         pdfEndPage(pdf);
         pdfAppend(pdf);
         tblDrawTable(tbl, 50.0f, 50.0f, 737.0f);
      }
   pdfEndPage(pdf);

   tblDeleteTable(&tbl);

   // A table stores errors and warnings in the error log
   TPDFError err;
   err.StructSize = sizeof(err);
   pageCount = pdfGetErrLogMessageCount(pdf);
   for (i = 0; i < pageCount; i++)
   {
      pdfGetErrLogMessage(pdf, i, &err);
      printf("%s\n", err.Message);
   }

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      // We write the output file into the current directory.
      char filePath[MAX_PATH+1];
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         timeStart = GetTickCount() - timeStart;
         printf("Processing time: %d ms\n", timeStart);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
