#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include <Windows.h>
#include <shellapi.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0;
}

int main(int argc, char* argv[])
{
   DWORD timeStart = GetTickCount();

   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 1;

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   SI32 i, pageCount, tmpl, rowNum = 0;

   pdfSetPageCoords(pdf, pcTopDown);
   pdfCreateNewPDF(pdf, NULL);

   pdfSetImportFlags2(pdf, if2UseProxy); // Reduce the memory usage

   if (pdfOpenImportFile(pdf, "../../../../dynapdf_help.pdf", ptOpen, NULL) < 0)
   {
      pdfDeletePDF(pdf);
      _getch();
      return 2;
   }

   pageCount = pdfGetInPageCount(pdf);

   ITBL* tbl = tblCreateTable(pdf, pageCount / 4 + 1, 2, 512.12f, 0.0f);
   tblSetBoxProperty(tbl, -1, -1, tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
   tblSetBoxProperty(tbl, -1, -1, tbpCellPadding, 5.0f, 5.0f, 5.0f, 5.0f);
   tblSetGridWidth(tbl, 1.0f, 1.0f);
   tblSetFlags(tbl, -1, -1, tfScaleToRect);

   pdfSetPageFormat(pdf, pfUS_Letter);

   for (i = 1; i <= pageCount; i++)
   {
      tmpl = pdfImportPage(pdf, i);
      if (i & 1) rowNum = tblAddRow(tbl, 335.0f);
      tblSetCellTemplate(tbl, rowNum, (i-1) & 1, true, coCenter, coCenter, tmpl, 0.0f, 0.0f);
   }

   // Draw the table now
   pdfAppend(pdf);
      tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      while (tblHaveMore(tbl))
      {
         pdfEndPage(pdf);
         pdfAppend(pdf);
         tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      }
   pdfEndPage(pdf);

   tblDeleteTable(&tbl);

   // A table stores errors and warnings in the error log
   TPDFError err;
   err.StructSize = sizeof(err);
   pageCount = pdfGetErrLogMessageCount(pdf);
   for (i = 0; i < pageCount; i++)
   {
      pdfGetErrLogMessage(pdf, i, &err);
      printf("%s\n", err.Message);
   }

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         timeStart = GetTickCount() - timeStart;
         printf("Processing time: %d ms\n", timeStart);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
