#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <share.h>
#include <io.h>
#include <Windows.h>
#include <shellapi.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0;
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1] = {0}, path[MAX_PATH+1] = {0};
   bool fileOpened = false;
   DWORD timeStart = GetTickCount();

   PPDF* pdf = pdfNewPDF();
   if (!pdf) return -1;

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   SI32 i = 0, count, rowNum = -1;

   pdfCreateNewPDF(pdf, NULL);

   pdfSetPageCoords(pdf, pcTopDown);
   pdfSetResolution(pdf, 300);

   ITBL* tbl = tblCreateTable(pdf, 100, 4, 500.0f, 125.0f);
   tblSetBoxProperty(tbl, -1, -1, tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
   tblSetBoxProperty(tbl, -1, -1, tbpCellPadding, 5.0f, 5.0f, 5.0f, 5.0f);
   tblSetGridWidth(tbl, 1.0f, 1.0f);
   tblSetFlags(tbl, -1, -1, tfUseImageCS);

   struct _finddata_t fd;

   _fullpath(path, "../../../test_files/images/*.jpg", MAX_PATH);

  #if VS_2005_OR_HIGHER == 1
   intptr_t h = _findfirst(path, &fd);
  #else
   long h = _findfirst(path, &fd);
  #endif
   if (h == -1)
   {
      tblDeleteTable(&tbl);
      pdfDeletePDF(pdf);
      printf("Test images not found!");
      _getch();
      return -2;
   }
   UI32 fullSize = 0;
   _fullpath(path, "../../../test_files/images", MAX_PATH);
   do
   {
      if (fd.name[0] == '.') continue;
      if (rowNum < 0 || i == 4)
      {
         rowNum = tblAddRow(tbl, -1.0f);
         i = 0;
      }
      fullSize += fd.size;
      // This check is not required here but if you add many or very large images then the maximum size should be restricted
      if (fullSize > 3145728000) break; // 3 GB (The maximum size of a PDF file is 4 GB)
      sprintf(filePath, "%s/%s", path, fd.name);
      tblSetCellImage(tbl, rowNum, i++, true, coCenter, coCenter, 0.0f, 0.0f, filePath, 1);
   }while (_findnext(h, &fd) == 0);
   _findclose(h);

   pdfAppend(pdf);
      tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      while (tblHaveMore(tbl))
      {
         pdfEndPage(pdf);
         if (fullSize > 104857600) pdfFlushPages(pdf, fpfDefault);
         pdfAppend(pdf);
         tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      }
   pdfEndPage(pdf);


   // We draw the same table again but this time with the flag tfScaleToRect
   tblSetFlags(tbl, -1, -1, TTableFlags(tfScaleToRect | tfUseImageCS));
   pdfAppend(pdf);
      pdfSetFont(pdf, "Arial", fsRegular, 12.0, true, cp1252);
      pdfWriteText(pdf, 50.0, 50.0, "The same table but the flag tfScaleToRect was set.");

      tblDrawTable(tbl, 50.0f, 65.0f, 742.0f);
      while (tblHaveMore(tbl))
      {
         pdfEndPage(pdf);
         if (fullSize > 104857600) pdfFlushPages(pdf, fpfDefault);
         pdfAppend(pdf);
         tblDrawTable(tbl, 50.0f, 50.0f, 742.0f);
      }
   pdfEndPage(pdf);

   tblDeleteTable(&tbl);


   // A table stores errors and warnings in the error log
   TPDFError err;
   err.StructSize = sizeof(err);
   count = pdfGetErrLogMessageCount(pdf);
   for (i = 0; i < count; i++)
   {
      pdfGetErrLogMessage(pdf, i, &err);
      printf("%s\n", err.Message);
   }

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      if (!fileOpened)
      {
         // We write the output file into the current directory.
         GetCurrentDirectory(MAX_PATH, filePath);
         strcat(filePath, "\\out.pdf");
         // OK, now we can open the output file.
         if (!pdfOpenOutputFile(pdf, filePath))
         {
            pdfDeletePDF(pdf);
            _getch();
            return -1;
         }
      }
      if (pdfCloseFile(pdf))
      {
         timeStart = GetTickCount() - timeStart;
         printf("Processing time: %d ms\n", timeStart);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}
