#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);

   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage); // Import anything and avoid the conversion of pages to templates
   pdfSetImportFlags2(pdf, if2UseProxy);                 // This flag reduces the memory usage.

   if (pdfOpenImportFile(pdf, "../../../license.pdf", ptOpen, NULL) < 0)
   {
      pdfDeletePDF(pdf);
      _getch();
      return 3;
   }

   // Very important: This property makes sure that the open import file will not be closed
   // when CloseFile() is called.
   pdfSetUseGlobalImpFiles(pdf, true);

   SI32 i, count = pdfGetInPageCount(pdf);
   for (i = 1; i <= count; i++)
   {
      sprintf(filePath, "out/page%.4d.pdf", i);
      pdfCreateNewPDF(pdf, filePath);
         pdfAppend(pdf);
            pdfImportPageEx(pdf, i, 1.0, 1.0);
         pdfEndPage(pdf);
      pdfCloseFile(pdf);
   }
   // You should never forget to set the property back to false when finish.
   // In this example it makes no difference but if the PDF instance is used
   // to create or import other PDF files then make sure that the parser instance
   // can be deleted.
   pdfSetUseGlobalImpFiles(pdf, false);

   pdfDeletePDF(pdf); // Do not forget to delete the class instance

   // Open the output directory
   _fullpath(filePath, "out", MAX_PATH);
   ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
   return 0;
}
