#ifndef base_appH
#define base_appH

#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#pragma comment(lib, "comdlg32.lib")
#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

bool OpenFileDlg(HWND Wnd, TCHAR FileName[MAX_PATH+1]);

using namespace DynaPDF;

#define APP_BACK_COLOR     0x00505050 // COLORREF -> 0x00bbggrr
#define APP_CLIENT_BORDER  6
#define APP_CLIENT_BORDER2 3          // Must be the half of APP_CLIENT_BORDER

// Application defined message to show a file open dialog
#define WM_OPEN_FILE (WM_APP+1)

#if defined(_UNICODE) || defined(UNICODE)
   #define FullPath _wfullpath
#else
   #define FullPath _fullpath
#endif

class CBaseApp
{
  public:
   CBaseApp(HINSTANCE Instance);
   ~CBaseApp(void);
   UI16 GetLastCtrl(void)         {return m_LastCtrl;}
   UI16 GetLastKey(void)          {return m_LastKey;}
   HWND GetHWND(void)             {return m_Wnd;}
   bool InitWindow(const TCHAR* ClassName, const TCHAR* WindowName, const TCHAR* MenuName);
   bool IsInWindow(SI32 X, SI32 Y){return (X >= m_WindowRect.left && X <= m_WindowRect.right && Y >= m_WindowRect.top && Y <= m_WindowRect.bottom);}

   virtual void OnCreate(void)                          {}
   virtual void OnKey(UI32 KeyCode, UI32 Ctrl)          {(void)KeyCode; (void)Ctrl;}
   virtual void OnMouseWheel(SI32 Delta, SI32 X, SI32 Y){(void)Delta; (void)X; (void)Y;}
   virtual void OnPaint(void)                           {}
   virtual void OnResize(UI32 Width, UI32 Height)       {(void)Width; (void)Height;}
   virtual void OnShowOpenFileDlg(void)                 {}
           void OnWindowMoved(SI32 X, SI32 Y);

   void ResetKeys(void)                                 {m_LastCtrl = m_LastKey = 0;}
   SI32 Run(void);
   void SetCaption(TCHAR* Caption);
   void SetLastCtrl(UI16 Value){m_LastCtrl = Value;}
   void SetLastKey(UI16 Value) {m_LastKey  = Value;}
  protected:
   BITMAPINFO*     m_BMPInfo;
   SI32            m_BorderX;
   SI32            m_BorderY;
   BYTE*           m_Buffer;
   UI32            m_BufSize;
   RECT            m_ClientRect;
   HDC             m_DC;
   SI32            m_DPIX;
   SI32            m_DPIY;
   SI32            m_ImgH;
   SI32            m_ImgW;
   HINSTANCE       m_Instance;
   UI16            m_LastCtrl;
   UI16            m_LastKey;
   TPDFPixFormat   m_PixFmt;
   SI32            m_ScreenH;
   SI32            m_ScreenW;
   RECT            m_WindowRect;
   SI32            m_WindowH;
   SI32            m_WindowW;
   HWND            m_Wnd;

   void GetMonitorProfile(TCHAR FilePath[MAX_PATH+1]);
   bool UpdateBitmapInfo(void);
};

#endif
