#include "base_app.h"

/* ----------------------------------------------------------------------------------------- */

bool OpenFileDlg(HWND Wnd, TCHAR FileName[MAX_PATH+1])
{
   OPENFILENAME ofn;
   // Initialize OPENFILENAME
   memset(&ofn, 0, sizeof(OPENFILENAME));
   ofn.lStructSize     = sizeof(OPENFILENAME);
   ofn.hwndOwner       = Wnd;
   ofn.lpstrFile       = FileName;
   ofn.nMaxFile        = MAX_PATH;
   ofn.lpstrFilter     = TEXT("PDF Files\0*.pdf\0\0\0\0");
   ofn.nFilterIndex    = 1;
   ofn.lpstrFileTitle  = NULL;
   ofn.nMaxFileTitle   = 0;
   ofn.lpstrInitialDir = NULL;
   ofn.Flags           = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_ENABLESIZING | OFN_NODEREFERENCELINKS | OFN_LONGNAMES | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
   return (GetOpenFileName(&ofn) == TRUE);
}

/* ----------------------------------------------------------------------------------------- */

#if VS_2005_OR_HIGHER == 1
   #define GetWindowPtr() (CBaseApp*)GetWindowLongPtr(hWnd, GWLP_USERDATA)
#else
   #define GetWindowPtr() (CBaseApp*)GetWindowLong(hWnd, GWL_USERDATA)
#endif

#ifndef WM_MOUSEWHEEL
   #define WM_MOUSEWHEEL 0x020A
#endif

#define IsChar(c)((c > 64 && c < 91) || (c > 96 && c < 123))

LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   CBaseApp* app;
   if ((app = GetWindowPtr()) == NULL)
   {
      if(msg == WM_DESTROY)
      {
         ::PostQuitMessage(0);
         return 0;
      }
      return ::DefWindowProc(hWnd, msg, wParam, lParam);
   }
   switch(msg)
   {
      default:             return ::DefWindowProc(hWnd, msg, wParam, lParam);
      case WM_CREATE:      app->OnCreate();                               break;
      case WM_SIZE:        app->OnResize(LOWORD(lParam), HIWORD(lParam)); break;
      case WM_ERASEBKGND:  return 1;
      case WM_DESTROY:     ::PostQuitMessage(0);                          break;
      case WM_CHAR:
      case WM_SYSCHAR:
      case WM_SYSKEYUP:
      case WM_KEYUP:       app->ResetKeys();                              break;
      case WM_OPEN_FILE:   app->OnShowOpenFileDlg();                      break;
      case WM_MOVE:        app->OnWindowMoved((SI16)LOWORD(lParam), (SI16)HIWORD(lParam)); break;
      case WM_SYSKEYDOWN:
      case WM_KEYDOWN:
         if (IsChar(wParam))
            app->SetLastKey((UI16)wParam);
         else
            app->SetLastCtrl((UI16)wParam);
         app->OnKey(app->GetLastKey(), app->GetLastCtrl());
         break;
      case WM_PAINT:
      {
         PAINTSTRUCT ps;
         ::BeginPaint(hWnd, &ps);
         app->OnPaint();
         ::EndPaint(hWnd, &ps);
         break;
      }
      case WM_MOUSEWHEEL:
         if (app->IsInWindow((SI16)LOWORD(lParam), (SI16)HIWORD(lParam)))
            app->OnMouseWheel((SI16)HIWORD(wParam), LOWORD(lParam), HIWORD(lParam));
         break;
   }
   return 0;
}

/* ----------------------------------------------------------------------------------------- */

CBaseApp::CBaseApp(HINSTANCE Instance) :
   m_BMPInfo(NULL),
   m_BorderX(0),
   m_BorderY(0),
   m_Buffer(NULL),
   m_BufSize(0),
   m_DC(0),
   m_DPIX(0),
   m_DPIY(0),
   m_ImgH(0),
   m_ImgW(0),
   m_Instance(Instance),
   m_LastCtrl(0),
   m_LastKey(0),
   m_PixFmt(pxfBGRA),
   m_ScreenH(0),
   m_ScreenW(0),
   m_WindowH(0),
   m_WindowW(0),
   m_Wnd(0)
{
   memset(&m_ClientRect, 0, sizeof(m_ClientRect));
   memset(&m_WindowRect, 0, sizeof(m_WindowRect));
}

CBaseApp::~CBaseApp(void)
{
   if (m_BMPInfo) free(m_BMPInfo);
   if (m_Buffer)  free(m_Buffer);
}

void CBaseApp::GetMonitorProfile(TCHAR FilePath[MAX_PATH+1])
{
   DWORD size = MAX_PATH;
   HDC dc = GetDC(0);
   ::GetICMProfile(dc, &size, FilePath);
   ReleaseDC(0, dc);
   if (size == 0)
      FilePath[0] = 0;
}

bool CBaseApp::InitWindow(const TCHAR* ClassName, const TCHAR* WindowName, const TCHAR* MenuName)
{
   WNDCLASS wc;
   wc.lpszClassName = ClassName;
   wc.lpfnWndProc   = WindowProc;
   wc.style         = CS_OWNDC | CS_VREDRAW | CS_HREDRAW; // We need a private DC! The flag CS_OWNDC is required.
   wc.hInstance     = m_Instance;
   wc.hIcon         = LoadIcon(0, IDI_APPLICATION);
   wc.hCursor       = ::LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = ::CreateSolidBrush(APP_BACK_COLOR);
   wc.lpszMenuName  = MenuName;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = 0;
   ::RegisterClass(&wc);

   DWORD flags = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_THICKFRAME;

   HDC    dc = ::GetDC(0);
   m_DPIX    = ::GetDeviceCaps(dc, LOGPIXELSX);
   m_DPIY    = ::GetDeviceCaps(dc, LOGPIXELSY);
   m_ScreenW = ::GetDeviceCaps(dc, HORZRES);
   m_ScreenH = ::GetDeviceCaps(dc, VERTRES);
   ::ReleaseDC(0, dc);

   m_WindowW = 1200;
   m_WindowH = 1800;
   if (m_WindowW > m_ScreenW) m_WindowW = m_ScreenW;
   if (m_WindowH > m_ScreenH) m_WindowH = m_ScreenH;

   m_Wnd = ::CreateWindow(ClassName, WindowName, flags, (m_ScreenW-m_WindowW)>>1, (m_ScreenH-m_WindowH)>>1, m_WindowW, m_WindowH, 0, 0, m_Instance, 0);
   m_DC  = ::GetDC(m_Wnd);

   if (!m_DC) return false;

   // The window and client areas must be accessed before ShowWindow() is called!
   ::GetClientRect(m_Wnd, &m_ClientRect);
   ::GetWindowRect(m_Wnd, &m_WindowRect);

   m_BorderX = m_WindowW - (m_ClientRect.right - m_ClientRect.left) + APP_CLIENT_BORDER;
   m_BorderY = m_WindowH - (m_ClientRect.bottom - m_ClientRect.top) + APP_CLIENT_BORDER;

   // Make sure that the class pointer is available in the window procedure.
   #if VS_2005_OR_HIGHER == 1
      ::SetWindowLongPtr(m_Wnd, GWLP_USERDATA, (LONG_PTR)this);
   #else
      ::SetWindowLong(m_Wnd, GWL_USERDATA, (LONG)this);
   #endif
   ::ShowWindow(m_Wnd, SW_SHOW);

   ::SetBkColor(m_DC, APP_BACK_COLOR);
   ::ExtTextOut(m_DC, 0, 0, ETO_OPAQUE, &m_ClientRect, NULL, 0, NULL);
   return true;
}

void CBaseApp::OnWindowMoved(SI32 X, SI32 Y)
{
   SI32 w = m_WindowRect.right - m_WindowRect.left;
   SI32 h = m_WindowRect.bottom - m_WindowRect.top;
   m_WindowRect.left   = X;
   m_WindowRect.right  = X + w;
   m_WindowRect.top    = Y;
   m_WindowRect.bottom = Y + h;
}

SI32 CBaseApp::Run(void)
{
   MSG msg;
   while (::GetMessage(&msg, m_Wnd, 0, 0) == 1)
   {
      ::TranslateMessage(&msg);
      ::DispatchMessage(&msg);
   }
   return 0;
}

void CBaseApp::SetCaption(TCHAR* Caption)
{
   ::SetWindowText(m_Wnd, Caption);
}

bool CBaseApp::UpdateBitmapInfo(void)
{
   UI16 bits = 0;
   switch(m_PixFmt)
   {
      case pxf1Bit: bits = 1;  break;
      case pxfGray: bits = 8;  break;
      case pxfBGR:  bits = 24; break;
      case pxfBGRA: bits = 32; break;
      default:      return false;
   }
   if (!m_BMPInfo)
   {
      UI32 size = 40;
      if (bits == 8)
         size += 1024;
      else if (bits == 1)
         size += 8;

      if ((m_BMPInfo = (BITMAPINFO*)calloc(size + 4, 1)) == NULL) return false;
      m_BMPInfo->bmiHeader.biBitCount = bits;
      m_BMPInfo->bmiHeader.biPlanes   = 1;
      m_BMPInfo->bmiHeader.biSize     = 40;
      if (size > 40)
      {
         BYTE* buf = (BYTE*)m_BMPInfo + 40;
         UI32 i, count = (1 << bits) - 1;
         for (i = 0; i <= count; i++, buf += 4)
         {
            buf[0] =
            buf[1] =
            buf[2] = (BYTE)((i * 255) / count);
            buf[3] = 0;
         }
      }
   }
   m_BMPInfo->bmiHeader.biSizeImage =  m_ImgH * (((m_ImgW * bits +31) & ~31) >> 3);
   m_BMPInfo->bmiHeader.biWidth     =  m_ImgW;
   m_BMPInfo->bmiHeader.biHeight    = -m_ImgH;
   return true;
}
