#include <windows.h>
#include <conio.h>
#include <stdio.h>
#include <commdlg.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

HDC GetPrinterDC(void)
{
   PRINTDLG pd;
   memset(&pd, 0, sizeof(pd));
   pd.lStructSize = sizeof(PRINTDLG);
   pd.Flags = PD_RETURNDC  |  PD_HIDEPRINTTOFILE | PD_DISABLEPRINTTOFILE | PD_NOSELECTION;
   if (PrintDlg(&pd) == TRUE)
      return pd.hDC;
   else
   {
      printf("Cancelled!\n");
      return NULL;
   }
}

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   HDC dc;
   SI32 retval;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   pdfCreateNewPDF(pdf, NULL); // We don't create a PDF file in this example

   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage); // Avoid the conversion of pages to templates
   pdfSetImportFlags2(pdf, if2UseProxy);                 // Reduce the memory usage

   if ((retval = pdfOpenImportFile(pdf, "../../../dynapdf_help.pdf", ptOpen, NULL)) < 0) goto err;

   // We print only the first page in this example.
   pdfAppend(pdf);
      pdfImportPageEx(pdf, 1, 1.0, 1.0);
   pdfEndPage(pdf);

   // If the file contains layers then ApplyAppEvent() makes sure that the same result will be printed
   // that Adobe's Acrobat would print. However, you can also print the view or export state if you want.
   // The help file doesn't contain layers and this command does just nothing but in a real world
   // application ApplyAppEvent() should be called.
   pdfApplyAppEvent(pdf, aePrint, false);

   if ((dc = GetPrinterDC()) != NULL)
   {
      if (pdfPrintPDFFile(pdf, NULL, "Test Print", dc, (TPDFPrintFlags)(pffDefault | pffAutoRotateAndCenter | pffShrinkToPrintArea), NULL, NULL))
         printf("Page 1 successfully printed\n");

      DeleteDC(dc);
   }
  err:
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}
