#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?
   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);
      pdfSetFont(pdf, "Helvetica", fsRegular, 14.0, false, cp1252);
      pdfWriteFTextEx(pdf, 50.0, 50.0, pdfGetPageWidth(pdf) - 100.0, -1.0, taJustify,
         "The following pages were imported from different PDF files. DynaPDF adjusts the destinations of link annotations and bookmarks so that "
         "all destinations refer to the new page numbers after import.\n\n"
         "Entire PDF files can be easily merged with ImportPDFFile() but it is also possible to import only specific pages of an arbitrary number "
         "of PDF files. You can also add further pages or edit imported pages if necessary. An existing page can be opened for editing with EditPage().");
   pdfEndPage(pdf);

   bool first        = true;
   SI32 destPage     = 1;
   bool haveXFA      = false;
   bool isCollection = false;

   const char* files[2] = {"license.pdf", "dynapdf_help.pdf"};

   // Generic code to merge arbitrary PDF files.
   for (SI32 i = 0; i < 2; i++)
   {
      sprintf(filePath, "../../../%s", files[i]);
      if (pdfOpenImportFile(pdf, filePath, ptOpen, NULL) < 0)
      {
         pdfDeletePDF(pdf);
         _getch();
         return 1;
      }
      /*
         Not all PDF files can be merged:
            - An Interactive Form is a global structure that cannot be simply merged. The names of all form fields must be
              be unique. But also if name collusions will be solved, there is no guarantee that embedded Javascripts or Javascript
              actions will work as expected. Interactive Forms should not be merged!

            - A PDF collection is a special PDF file that consists of a container PDF and an array of embedded files.
              It is possible to merge two or more PDF Collections but it is not meaningful to merge a PDF Collection
              with normal PDF files or vice versa.
      */
      if (first)
      {
         first        = false;
         haveXFA      = pdfGetInIsXFAForm(pdf) != 0;
         isCollection = pdfGetInIsCollection(pdf) != 0;
         if ((destPage = pdfImportPDFFile(pdf, destPage + 1, 1.0, 1.0)) < 0) break;
      }else
      {
         // Special handling for PDF Collections
         if (isCollection)
         {
            if (pdfGetInIsCollection(pdf))
            {
               // Import the embedded files only
               pdfSetImportFlags(pdf, ifEmbeddedFiles);
               // We could also use ImportPDFFile() but this function is more efficient since no pages will be imported.
               if (pdf, !pdfImportCatalogObjects(pdf)) break;
            }else
            {
               pdfCloseImportFile(pdf);
               // Add the file to the collection
               pdfAttachFile(pdf, filePath, files[i], true);
            }
         }else
         {
            if (pdfGetInIsCollection(pdf) || ((pdfGetInIsXFAForm(pdf) || pdfGetInFieldCount(pdf)) && (pdfGetFieldCount(pdf) > 0 || haveXFA))) break;
            pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage); // Import anything and avoid the conversion of pages to templates
            pdfSetImportFlags2(pdf, if2UseProxy);                 // This flag reduces the memory usage.
            if ((destPage = pdfImportPDFFile(pdf, destPage + 1, 1.0, 1.0)) < 0) break;
         }
      }
      pdfCloseImportFile(pdf);
   }

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
      // If you want to encrypt the file, use CloseFileEx() instead.
      //pdfCloseFileEx(pdf, NULL, "test", kl128bit, rsDenyAll & ~rsPrint & ~rsPrintHighRes);
   }
   pdfDeletePDF(pdf); // Do not forget to delete the class instance
   return 0;
}
