#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

bool SignFile(PPDF* PDF, const char* InFileName, const char* OutFileName, const char* FieldName, const char* Reason, double PosX, bool VisibleSignature)
{
   bool retval = false;
   char filePath[MAX_PATH+1] = "\\tmp";
   const char* out = OutFileName;
   if (InFileName == OutFileName)
   {
      if (!tmpnam(filePath)) return false;
      out = filePath;
   }
   pdfCreateNewPDF(PDF, out);

   /*
      Adding multiple signatures with a demo version of DynaPDF couldn't work since a demo string would
      be added to each page that was edited or changed and this would invalidate previous signatures.
   */
   pdfSetLicenseKey(PDF, "SigDemo");

   // This flag also sets the flags ifImportAsPage | ifImportAll, and if2UseProxy | if2CopyEncryptDict to make sure that
   // anything is imported and nothing gets changed.
   pdfSetImportFlags2(PDF, if2IncrementalUpd);
   if (pdfOpenImportFile(PDF, InFileName, ptOpen, NULL) < 0) return false;
   pdfImportPDFFile(PDF, 1, 1.0, 1.0);

   if (VisibleSignature)
   {
      pdfSetPageCoords(PDF, pcTopDown);
      pdfEditPage(PDF, 1);
         SI32 sig = pdfCreateSigField(PDF, FieldName, -1, PosX, 30.0, 180.0, 40.0);
         pdfSetFieldBorderWidth(PDF, sig, 0.0);
      pdfEndPage(PDF);
   }
   if ((retval = pdfCloseAndSignFile(PDF, "../../../test_files/test_cert.pfx", "123456", Reason, NULL)) != 0)
   {
      if (out == filePath)
      {
         DeleteFile(OutFileName);
         retval = MoveFileEx(out, OutFileName, MOVEFILE_COPY_ALLOWED | MOVEFILE_WRITE_THROUGH) != 0;
      }
   }
   return retval;
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);

   // We write the output file into the current directory.
   GetCurrentDirectory(MAX_PATH, filePath);
   strcat(filePath, "\\out.pdf");

   // We sign the file 4 times in this example. We add two visible and two invisible signatures.
   if (SignFile(pdf, "../../../../license.PDF", filePath, "Signature1", "Test signature 1", 50.0, true))
   {
      if (SignFile(pdf, filePath, filePath, "Signature2", "Test signature 2", 430.0, true))
      {
         if (SignFile(pdf, filePath, filePath, NULL, "Test signature 3", 0.0, false))
         {
            if (SignFile(pdf, filePath, filePath, NULL, "Test signature 4", 0.0, false))
            {
               printf("PDF file \"%s\" successfully created!\n", filePath);
               ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
            }
         }
      }
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}