#ifndef pdf_signatureH
#define pdf_signatureH

#include <Windows.h>
#include <WinCrypt.h>

#define PDF_STATIC // Enable static binding when compiling the project with the workspace dynapdf_static.
#include "../../../include/C_CPP/dynapdf.h"

namespace DynaPDF
{

class CWinCrypt
{
  public:
   CWinCrypt(void);
   ~CWinCrypt(void);
   void CleanUp(void);
   bool CloseAndSignPDFFile(const void* PDF, const char* OutFile, bool DetachedSignature);
   bool LoadCertFromFile(const char* FileName, const wchar_t* Password);
   bool OpenCert(UI32 Index);
   bool OpenStore(const wchar_t* Name);
   bool SelectCertificateFromStore(void);
  private:
   PCCERT_CONTEXT m_CertCtx;
   BYTE*          m_PKCS7Obj;
   HCERTSTORE     m_Store;

   BYTE* GetFileBuf(const char* FileName, long &BufSize);
};

}

#endif
