#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 f, orientation;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?
   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   // Import anything and don't convert pages to templates
   pdfSetImportFlags(pdf, ifImportAll | ifImportAsPage);
   // The flag if2UseProxy reduces the memory usage.
   pdfSetImportFlags2(pdf, if2UseProxy);
   if (pdfOpenImportFile(pdf, "../../test_files/rotated_270.pdf", ptOpen, NULL) < 0)
   {
      pdfDeletePDF(pdf);
      return 3;
   }
   pdfImportPDFFile(pdf, 1, 1.0, 1.0);
   pdfCloseImportFile(pdf);

   pdfSetPageCoords(pdf, pcTopDown);

   // This property moves the coordinate origin into the visible area (default value == false).
   pdfSetUseVisibleCoords(pdf, true);

   // Open page 1 for editing
   pdfEditPage(pdf, 1);
      // Check whether the page is rotated.
      if ((orientation = pdfGetOrientation(pdf)) != 0)
      {
         // SetOrientationEx() rotates the coordinate system into the opposite direction of the page orientation.
         // There is no guarantee that the contents in a page is rotated in the same way. If the result is wrong
         // then don"t call this function.
         pdfSetOrientationEx(pdf, orientation);
      }
      f = pdfSetFont(pdf, "Helvetica", fsRegular, 12.0, false, cp1252);
      // We use this font also as list font. In this example we use a bullet as list symbol (character index 143 of the code page 1252).
      pdfSetListFont(pdf, f);
      pdfWriteFTextEx(pdf, 50.0, 200.0, pdfGetPageWidth(pdf) - 100.0, -1.0, taJustify,
         "It is not difficult to edit an imported page but two things must be considered:\n\n\\LI[20,143]\\LD[16]The page's "
         "orientation.\\EL#\\LI[20,143]\\LD[12]The coordinate origin. The coordinate origin can be taken from the crop box if present, or from the media box (Left and Bottom).\\EL#\n\\LD[12]"
         "Although it is possible to correct the coordinate origin manually, it is much easier to set the property SetUseVisibleCoords() to true. DynaPDF moves the zero point then automatically "
         "into the visible area of the page.\n\n"
         "The functions GetPageWidth() and GetPageHeight() return then also the logical width or height of the page depending on the orientation and whether a crop box is present.\n\n"
         "The handling of rotated pages is a bit more complicated since the orientation is just a property. That means there is no guarantee that the contents is rotated "
         "into the opposite direction like the contents in this page. Whether this is the case depends on the creator of the PDF file.\n\n"
         "However, by default it is probably best to assume that the contents is rotated. SetOrientationEx() rotates the coordinate system so that we can work with the page as if it was "
         "not rotated. If this produces a wrong result then don't call SetOrientationEx().\n\n"
         "Now you ask probably yourself whether it is possible to identify the orientation of the contents in a page. The answer is maybe. It is possible to parse a page with ParseContent() "
         "and to inspect the transformation matrices but this can produce wrong results especially if a page contains not much contents.");
   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
      // If you want to encrypt the file, use CloseFileEx() instead.
      //pdfCloseFileEx(pdf, NULL, "test", kl128bit, rsDenyAll & ~rsPrint & ~rsPrintHighRes);
   }
   pdfDeletePDF(pdf); // Do not forget to delete the class instance
   _getch();
   return 0;
}
