#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <windows.h>
#include <shellapi.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

class CHandleList
{
  public:
   CHandleList(void) :
      m_Capacity(0),
      m_Count(0),
      m_Handles(NULL)
   {}
   ~CHandleList(void)
   {
      if (m_Handles) free(m_Handles);
   }
   SI32 Add(SI32 Handle)
   {
      if (m_Count == m_Capacity)
      {
         m_Capacity += 50;
         SI32* tmp = (SI32*)realloc(m_Handles, sizeof(SI32) * m_Capacity);
         if (!tmp)
         {
            m_Capacity -= 50;
            return -1;
         }
         m_Handles = tmp;
      }
      m_Handles[m_Count] = Handle;
      return m_Count++;
   }
   SI32 Find(SI32 Handle)
   {
      SI32 i = 0;
      SI32 e = m_Count -1;
      while (i <= e)
      {
         if (m_Handles[i] == Handle) return i;
         if (m_Handles[e] == Handle) return e;
         ++i;
         --e;
      }
      return -1;
   }
  private:
   UI32  m_Capacity;
   UI32  m_Count;
   SI32* m_Handles;
};

class CImageList
{
  public:
   CImageList(void) :
      m_Capacity(0),
      m_Count(0),
      m_Handles(NULL)
   {}
   ~CImageList(void)
   {
      if (m_Handles) free(m_Handles);
   }
   SI32 Add(const void* Ptr)
   {
      if (m_Count == m_Capacity)
      {
         m_Capacity += 50;
         const void** tmp = (const void**)realloc(m_Handles, sizeof(void*) * m_Capacity);
         if (!tmp)
         {
            m_Capacity -= 50;
            return -1;
         }
         m_Handles = tmp;
      }
      m_Handles[m_Count] = Ptr;
      return m_Count++;
   }
   SI32 Find(const void* Ptr)
   {
      SI32 i = 0;
      SI32 e = m_Count -1;
      while (i <= e)
      {
         if (m_Handles[i] == Ptr) return i;
         if (m_Handles[e] == Ptr) return e;
         ++i;
         --e;
      }
      return -1;
   }
  private:
   UI32         m_Capacity;
   UI32         m_Count;
   const void** m_Handles;
};

CHandleList m_Handles; // Template handles
CImageList  m_Images;  // Processed images
static SI32 m_Counter = 0;

SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // We try to continue
}

SI32 PDF_CALL parseBeginPattern(const void* Data, LBOOL Fill, SI32 Handle, TPatternType Type, struct TPDFRect* BBox, struct TCTM* Matrix, double* XStep, double* YStep)
{
   return 0;
}

SI32 PDF_CALL parseBeginTemplate(const void* Data, const BYTE* Object, SI32 Handle, struct TPDFRect* BBox, struct TCTM* Matrix)
{
   // Already handled?
   if (m_Handles.Find(Handle) > -1) return  1; // Skip the template
   if (m_Handles.Add(Handle)  <  0) return -1; // Break processing if we have no more memory
   return 0;
}

SI32 PDF_CALL parseInsertImage(const void* Data, TPDFImage* Image)
{
   if (!Image->InlineImage)
   {
      if (m_Images.Find(Image->ObjectPtr) > -1) return 0;  // Already handled?
      if (m_Images.Add(Image->ObjectPtr)  <  0) return -1; // Out of memory?
   }
   // If an image cannot be decompressed due to an unsupported filter or if the decoder
   // failed to decompress it then we can get a compressed image here.
   if (Image->Filter != dfNone) return 0;
   // Note that Flate compression is no standard filter; Photoshop does not support this filter.
   if (Image->BitsPerPixel == 1)
      pdfAddImage(Data, cfCCITT4, icNone, Image);
   else
      pdfAddImage(Data, cfLZW, icNone, Image);
   return 0;
}

int main(int argc, char* argv[])
{
   char filePath[MAX_PATH+1];
   UI32 timeStart = GetTickCount();

   PPDF* pdf = pdfNewPDF();
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // We don't create a PDF file

   // Skip anything that is not required
   pdfSetImportFlags(pdf, ifContentOnly | ifImportAsPage);
   // From which PDF file do you want to extract the images?
   pdfOpenImportFile(pdf, "../../../../dynapdf_help.pdf", ptOpen, NULL);

   // Comment this out if you want to extract the images from specific pages only
   pdfImportPDFFile(pdf, 1, 1.0, 1.0);

   SI32 i, pageCount = pdfGetPageCount(pdf);

   pdfCloseImportFile(pdf);

   TPDFParseInterface stack;
   memset(&stack, 0, sizeof(stack));
   // Set the required callback functions
   stack.BeginPattern  = parseBeginPattern;
   stack.BeginTemplate = parseBeginTemplate;
   stack.InsertImage   = parseInsertImage;

   // We create a multi-page TIFF in this example
   GetCurrentDirectory(MAX_PATH, filePath);
   strcat(filePath, "\\out.tif");
   pdfCreateImage(pdf, filePath, ifmTIFF);

   for (i = 1; i <= pageCount; i++)
   {
      pdfEditPage(pdf, i);
      /*
         If you want to convert the images into a specific color space then set
         one of the folowing flags (see also TParseFlags in dynapdf.h):

            pfDitherImagesToBW // Floyd-Steinberg dithering.
            pfConvImagesToGray
            pfConvImagesToRGB
            pfConvImagesToCMYK

         Only one color space conversion flag must be set at time.
      */
      pdfParseContent(pdf, pdf, &stack, pfDecomprAllImages);
      pdfEndPage(pdf);
   }
   pdfCloseImage(pdf);

   // Delete the PDF instance. This frees all resources.
   pdfDeletePDF(pdf);

   timeStart = GetTickCount() - timeStart;
   printf("Processing time: %d ms\n", timeStart);

   printf("Images have been extracted to %s\n", filePath);
   ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);

   _getch();
   return 0;
}


