#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   double x, y;
   SI32 act, lnk, f, bmk, root;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?
   // Error messages and warnings are passed to the callback function.
   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   pdfSetPageHeight(pdf, 500.0);
   pdfSetPageWidth(pdf, 800.0);

   pdfAppend(pdf);
      f = pdfSetFont(pdf, "Helvetica", fsRegular, 20, false, cp1252);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtFit");
      root = pdfAddBookmark(pdf, "DestType dtFit", -1, 1, true);
      pdfSetBookmarkDest(pdf, root, dtFit, 0, 0, 0, 0);
      pdfSetBookmarkStyle(pdf, root, fsItalic, PDF_RED);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtXY_Zoom");
      pdfWriteText(pdf, 50, 70, "Zoom factor 3, Top position 50 (pdf, TopDown coordinates)");
      bmk = pdfAddBookmark(pdf, "DestType: dtXY_Zoom, zoom factor 3", root, 2, false);
      pdfSetBookmarkDest(pdf, bmk, dtXY_Zoom, 50, 50, 3, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsBold, PDF_MAROON);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtXY_Zoom");
      pdfWriteText(pdf, 50, 70, "Zoom factor 0.5, Top position 50 (pdf, TopDown coordinates)");
      bmk = pdfAddBookmark(pdf, "DestType: dtXY_Zoom, zoom factor 0.5", root, 3, false);
      pdfSetBookmarkDest(pdf, bmk, dtXY_Zoom, 50, 50, 0.5, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsBold | fsItalic, PDF_GREEN);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtXY_Zoom");
      pdfWriteText(pdf, 50, 70, "Zoom factor not defined (pdf, unchanged), Top position 50 (pdf, TopDown coordinates)");
      bmk = pdfAddBookmark(pdf, "DestType: dtXY_Zoom, zoom factor unchanged", root, 4, false);
      pdfSetBookmarkDest(pdf, bmk, dtXY_Zoom, 50, 50, 0, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsRegular, PDF_BLUE);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtFitH_Top");
      pdfWriteText(pdf, 50, 70, "Top position 50 (pdf, TopDown coordinates)");
      bmk = pdfAddBookmark(pdf, "DestType: dtFitH_Top (pdf, 50)", root, 5, false);
      pdfSetBookmarkDest(pdf, bmk, dtFitH_Top, 50, 0, 0, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsRegular, 0x00FF8080);
      pdfWriteText(pdf, 50, 200, "Bookmark destination type dtFitH_Top");
      pdfWriteText(pdf, 50, 220, "Top position 200 (pdf, TopDown coordinates)");
      bmk = pdfAddBookmark(pdf, "DestType dtFitH_Top (pdf, 200)", root, 5, false);
      pdfSetBookmarkDest(pdf, bmk, dtFitH_Top, 200, 0, 0, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsRegular, 0x00C08080);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 200, 50, "Bookmark destination type dtFitV_Left");
      pdfWriteText(pdf, 200, 70, "Left position 200. FitV has no effect if the width of the page");
      pdfWriteText(pdf, 200, 90, "is not greater as the height.");
      bmk = pdfAddBookmark(pdf, "DestType: dtFitV_Left (pdf, 200)", root, 6, false);
      pdfSetBookmarkDest(pdf, bmk, dtFitV_Left, 200, 0, 0, 0);
      pdfSetBookmarkStyle(pdf, bmk, fsRegular, 0x00808FFF);
   pdfEndPage(pdf);

   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteText(pdf, 50, 50, "Bookmark destination type dtFit_Rect");
      x = (pdf, pdfGetPageWidth(pdf)  -90.0) / 2.0;
      y = (pdf, pdfGetPageHeight(pdf) -65.0) / 2.0;

      pdfWriteFTextEx(pdf, x, y, 90.0, -1, taCenter, "We zoom into the rectangle");
      pdfRectangle(pdf, x, y, 90.0, 65.0, fmStroke);

      // We place a page link with a GoTo action on this position. The link zooms into the rectangle in the same way as the bookmark.
      pdfSetLinkHighlightMode(pdf, hmInvert);
      lnk = pdfPageLink(pdf, x, y, 90, 65, 7);
      act = pdfCreateGoToAction(pdf, dtFit_Rect, 7, x - 5.0, y - 5.0, x + 100.0, y + 70.0);
      pdfAddActionToObj(pdf, otPageLink, oeOnMouseUp, act, lnk);

      bmk = pdfAddBookmark(pdf, "DestType: dtFit_Rect", -1, 7, false);
      // The page link uses the same destination as the bookmark should use. So we add the action to the bookmark instead
      // of a bookmark destination. This saves just a little bit disk space.
      pdfAddActionToObj(pdf, otBookmark, oeOnMouseUp, act, bmk);
      pdfSetBookmarkStyle(pdf, bmk, fsRegular, 0x000080FF);
   pdfEndPage(pdf);

   pdfSetPageFormat(pdf, pfDIN_A4);
   pdfAppend(pdf);
      pdfChangeFont(pdf, f);
      pdfWriteFTextEx(pdf, 50.0, 50.0, pdfGetPageWidth(pdf) - 100.0, -1.0, taLeft, "Destination type dtFit. This variant scales the page so that both sides fit into the viewer window.");
   pdfEndPage(pdf);

   root = pdfAddBookmark(pdf, "DestType dtFit", -1, 8, false);
   pdfSetBookmarkDest(pdf, root, dtFit, 0, 0, 0, 0);

   bmk  = pdfAddBookmark(pdf, "DestType: dtXY_Zoom, zoom factor 3", root, 2, false);
   pdfSetBookmarkDest(pdf, bmk, dtXY_Zoom, 50, 50, 3, 0);
   pdfSetBookmarkStyle(pdf, bmk, fsBold, PDF_MAROON);


   pdfSetPageLayout(pdf, plOneColumn);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      // We write the output file into the current directory.
      char filePath[512];
      GetCurrentDirectory(511, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
      // If you want to encrypt the file, use CloseFileEx() instead.
      //pdfCloseFileEx(pdf, NULL, "test", kl128bit, rsDenyAll & ~rsPrint & ~rsPrintHighRes);
   }
   pdfDeletePDF(pdf); // Do not forget to delete the class instance
   _getch();
   return 0;
}
