#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windows search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 a;
   TFltPoint points[4];
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);

      pdfSaveGraphicState(pdf);

         pdfSetGStateFlags(pdf, gfRealTopDownCoords, false); // This simplifies the handling a little bit.
         pdfRotateCoords(pdf, -30, 50.0, 200.0);

         char text[] = "Some rotated text on a page...";
         pdfSetFont(pdf, "Helvetica", fsRegular, 20.0, false, cp1252);

         float d = (float)pdfGetDescent(pdf);
         float w = (float)pdfGetTextWidth(pdf, text);

         // Highlight annotations do not consider coordinate transformations made on a page.
         // To get such annotations rotated we must set the annotation's quad points.
         // SetAnnotQuadPoints() considers transformations of the coordinate system.

         pdfWriteText(pdf, 0.0, 0.0, text);
         a = pdfHighlightAnnot(pdf, atHighlight, 50.0, 50.0 + d, w, 20.0, PDF_YELLOW, "Test app", "Highligh Annotations", "This is a highlight annotation");
         // Consider the unusual order of the points!
         points[0].x = 0.0f;      // x1 -> Top left corner
         points[0].y = d;         // y1 -> Top left corner
         points[1].x = w;         // x2 -> Top right corner
         points[1].y = d;         // y2 -> Top right corner
         points[2].x = 0.0f;      // x3 -> Bottom left corner
         points[2].y = 20.0f + d; // y3 -> Bottom left corner
         points[3].x = w;         // x4 -> Bottom right corner
         points[3].y = 20.0f + d; // y4 -> Bottom right corner
         pdfSetAnnotQuadPoints(pdf, a, points, 4);

         pdfWriteText(pdf, 0.0, 30.0, text);
         a = pdfHighlightAnnot(pdf, atSquiggly, 50.0, 80.0, w, 20.0, PDF_RED, "Test app", "Squiggly Annotations", "This is a squiggly annotation");
         // Update the y-coordinates
         points[0].y += 30.0f;
         points[1].y += 30.0f;
         points[2].y += 30.0f;
         points[3].y += 30.0f;
         pdfSetAnnotQuadPoints(pdf, a, points, 4);

         pdfWriteText(pdf, 0.0, 60.0, text);
         a = pdfHighlightAnnot(pdf, atStrikeOut, 50.0, 110.0, w, 20.0, PDF_RED, "Test app", "Strikeout Annotations", "This is a strikeout annotation");
         // Update the y-coordinates
         points[0].y += 30.0f;
         points[1].y += 30.0f;
         points[2].y += 30.0f;
         points[3].y += 30.0f;
         pdfSetAnnotQuadPoints(pdf, a, points, 4);

         pdfWriteText(pdf, 0.0, 90.0, text);
         a = pdfHighlightAnnot(pdf, atUnderline, 50.0, 140.0, w, 20.0, PDF_RED, "Test app", "Underline Annotations", "This is a underline annotation");
         // Update the y-coordinates
         points[0].y += 30.0f;
         points[1].y += 30.0f;
         points[2].y += 30.0f;
         points[3].y += 30.0f;
         pdfSetAnnotQuadPoints(pdf, a, points, 4);

         char txt[] = "Link annotations support quad points too";
         w = (float)pdfGetTextWidth(pdf, txt);
         pdfWriteText(pdf, 0.0, 120.0, txt);
         // Link annotations support quad points too.
         a = pdfWebLink(pdf, 0.0, 120.0, w, 20, "www.dynaforms.com");
         pdfSetAnnotBorderWidth(pdf, a, 1.0);
         pdfSetAnnotColor(pdf, a, fcBorderColor, csDeviceRGB, PDF_BLUE);
         points[0].x = 0.0f;       // x1 -> Top left corner
         points[0].y = 120.0f + d; // y1 -> Top left corner
         points[1].x = w;          // x2 -> Top right corner
         points[1].y = 120.0f + d; // y2 -> Top right corner
         points[2].x = 0.0f;       // x3 -> Bottom left corner
         points[2].y = 140.0f + d; // y3 -> Bottom left corner
         points[3].x = w;          // x4 -> Bottom right corner
         points[3].y = 140.0f + d; // y4 -> Bottom right corner
         pdfSetAnnotQuadPoints(pdf, a, points, 4);

      pdfRestoreGraphicState(pdf);

   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   return 0;
}