#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 f, r;
   double y;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetDocInfo(pdf, diTitle, "Form fields");
   pdfSetDocInfo(pdf, diSubject, "DynaPDF C++ example");

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);
      y = 50.0;
      pdfSetFont(pdf, "Helvetica", fsRegular, 10.0, false, cp1252);
      pdfWriteText(pdf, 50.0, y, "Text fields:");

      y += 15.0;
      f = pdfCreateTextField(pdf, "Text1", -1, false, 0, 50.0, y, 200.0, 20.0);
      pdfSetTextFieldValue(pdf, f, NULL, "Single line text...", taLeft);

      y += 30.0;
      f = pdfCreateTextField(pdf, "Text2", -1, true, 0, 50.0, y, 200.0, 50.0);
      pdfSetTextFieldValue(pdf, f, NULL, "This field accepts multi-line text. The maximum text length can be restricted if necessary.", taLeft);

      y += 60.0;
      pdfWriteText(pdf, 50.0, y, "A password field:");
      y += 15.0;
      f = pdfCreateTextField(pdf, "Text3", -1, false, 0, 50.0, y, 200.0, 20.0);
      pdfSetFieldFlags(pdf, f, ffPassword, false);
      pdfSetTextFieldValue(pdf, f, NULL, "**********", taLeft);

      y += 30.0;
      pdfWriteText(pdf, 50.0, y, "A fixed length field separated into combs:");
      y += 15.0;
      f = pdfCreateTextField(pdf, "Text4", -1, false, 10, 50.0, y, 200.0, 20.0);
      pdfSetTextFieldValue(pdf, f, NULL, "Test value", taLeft);
      pdfSetFieldFlags(pdf, f, ffComb, false);


      y = 50.0;
      pdfWriteText(pdf, 350.0, y, "Choice fields:");
      y += 15.0;
      f = pdfCreateComboBox(pdf, "Combo1", true, -1, 350.0, y, 200.0, 20.0);
      pdfAddValToChoiceField(pdf, f, NULL, " Select a value...", true);
      pdfAddValToChoiceField(pdf, f, "Apple",  "Apple",  false);
      pdfAddValToChoiceField(pdf, f, "Banana", "Banana", false);
      pdfAddValToChoiceField(pdf, f, "Pear",   "Pear",   false);
      pdfAddValToChoiceField(pdf, f, "Grape",  "Grape",  false);
      pdfAddValToChoiceField(pdf, f, "Orange", "Orange", false);

      y += 30.0;
      f = pdfCreateListBox(pdf, "List", true, -1, 350.0, y, 200.0, 50.0);
      pdfAddValToChoiceField(pdf, f, "Apple",  "Apple",  false);
      pdfAddValToChoiceField(pdf, f, "Banana", "Banana", true);
      pdfAddValToChoiceField(pdf, f, "Pear",   "Pear",   false);
      pdfAddValToChoiceField(pdf, f, "Grape",  "Grape",  false);
      pdfAddValToChoiceField(pdf, f, "Orange", "Orange", false);

      y += 60.0;
      pdfWriteText(pdf, 350.0, y, "Editable combo box:");
      y += 15.0;
      f = pdfCreateComboBox(pdf, "Combo2", true, -1, 350.0, y, 200.0, 20.0);
      pdfAddValToChoiceField(pdf, f, "Apple",  "Apple",  false);
      pdfAddValToChoiceField(pdf, f, "Banana", "Banana", false);
      pdfAddValToChoiceField(pdf, f, "Pear",   "Pear",   false);
      pdfAddValToChoiceField(pdf, f, "Grape",  "Grape",  false);
      pdfAddValToChoiceField(pdf, f, "Orange", "Orange", false);
      pdfSetFieldFlags(pdf, f, ffEdit, false);
      pdfSetFieldExpValue(pdf, f, 1000, "Select or enter a value...", NULL, true);

      y += 30.0;
      pdfWriteText(pdf, 350.0, y, "Check boxes / Radio buttons:");

      y += 15.0;
      pdfChangeFontSize(pdf, 1.0);
      f = pdfCreateCheckBox(pdf, "N1", "C1", true, -1, 350.0, y, 20.0, 20.0);
      f = pdfCreateCheckBox(pdf, "N2", "C2", true, -1, 380.0, y, 20.0, 20.0);
      f = pdfCreateCheckBox(pdf, "N3", "C1", true, -1, 410.0, y, 20.0, 20.0);

      pdfCreateCheckBox(pdf, "G1", "C1", false, -1, 450.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G1", "C2", false, -1, 480.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G1", "C1", true,  -1, 510.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G1", "C2", false, -1, 540.0, y, 20.0, 20.0);

      y += 30.0;
      pdfChangeFontSize(pdf, 15.0);
      pdfSetCheckBoxChar(pdf, ccCircle);
      r = pdfCreateRadioButton(pdf, "Radio1", "R1", true, -1, 350.0, y, 20.0, 20.0);
      pdfSetCheckBoxDefState(pdf, r, false);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 380.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R3", false, r, 410.0, y, 20.0, 20.0);

      r = pdfCreateRadioButton(pdf, "Radio2", "R1", true, -1, 450.0, y, 20.0, 20.0);
      pdfSetFieldFlags(pdf, r, ffRadioIsUnion, false);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 480.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R1", true,  r, 510.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 540.0, y, 20.0, 20.0);
   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}