#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <conio.h>

#define PDF_STATIC // Enable static binding. This define makes nothing when we link dynamically.
#include "../../../../include/C_CPP/dynapdf.h"

#if defined(WIN64) || defined(_WIN64)
   #ifdef _DLL
      #pragma comment(lib, "../../../../win64/dynapdfm.lib") // Multithreaded-DLL
   #else
      #pragma comment(lib, "../../../../win64/dynapdf.lib")  // Multithreaded
   #endif
#elif defined(_DLL)
   #pragma comment(lib, "../../../../win32/dynapdfm.lib") // Multithreaded-DLL
#else
   #pragma comment(lib, "../../../../win32/dynapdf.lib")  // Multithreaded
#endif

using namespace DynaPDF;

/*
   Note that the dynapdf.dll must be copied into the output directory or into a
   Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
*/

// Error callback function.
SI32 PDF_CALL PDFError(const void* Data, SI32 ErrCode, const char* ErrMessage, SI32 ErrType)
{
   printf("%s\n", ErrMessage);
   return 0; // any other return value breaks processing!
}

int main(int argc, char* argv[])
{
   SI32 act, f, r;
   double y;
   PPDF* pdf = pdfNewPDF();
   if (!pdf) return 2; // Out of memory?

   pdfSetOnErrorProc(pdf, NULL, PDFError);
   pdfCreateNewPDF(pdf, NULL); // The output file is created later

   pdfSetDocInfo(pdf, diTitle, "Check boxes");
   pdfSetDocInfo(pdf, diSubject, "DynaPDF C++ example");

   pdfSetPageCoords(pdf, pcTopDown);

   pdfAppend(pdf);
      pdfSetFont(pdf, "Helvetica", fsRegular, 10.0, false, cp1252);
      pdfWriteText(pdf, 50.0, 50.0, "Normal check boxes.");

      pdfChangeFontSize(pdf, 1.0);
      f = pdfCreateCheckBox(pdf, "N1", "C1", true, -1, 50.0,  70.0, 20.0, 20.0);
      pdfSetCheckBoxDefState(pdf, f, true);
      f = pdfCreateCheckBox(pdf, "N2", "C2", true, -1, 80.0,  70.0, 20.0, 20.0);
      pdfSetCheckBoxDefState(pdf, f, true);
      f = pdfCreateCheckBox(pdf, "N3", "C1", true, -1, 110.0, 70.0, 20.0, 20.0);
      pdfSetCheckBoxDefState(pdf, f, true);

      pdfChangeFontSize(pdf, 10.0);
      pdfWriteText(pdf, 50.0, 100.0, "Field group with check boxes.");

      pdfChangeFontSize(pdf, 1.0);
      pdfCreateCheckBox(pdf, "G1", "C1", false, -1, 50.0, 120.0, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G1", "C2", false, -1, 80.0, 120.0, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G1", "C1", true, -1, 110.0, 120.0, 20.0, 20.0);

      pdfChangeFontSize(pdf, 10.0);
      pdfWriteFTextEx(pdf, 50.0, 150.0, 220.0, -1.0, taLeft, "This group works like a radio button but only radio buttons get a round border if the check box character is set to ccCircle. No problem, set the border width to zero and draw the circle in background if needed.");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;

      pdfChangeFontSize(pdf, 1.0);
      pdfSetCheckBoxChar(pdf, ccCircle);
      pdfCreateCheckBox(pdf, "G2", "C1", false, -1, 50.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G2", "C2", false, -1, 80.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, "G2", "C3", true, -1, 110.0, y, 20.0, 20.0);


      pdfChangeFontSize(pdf, 10.0);
      pdfWriteFTextEx(pdf, 300.0, 50.0, 250.0, -1.0, taLeft, "This is a radio button. Since Acrobat 7 it is no longer possible to deselect the active check box, except with a reset form or Javascript action.");

      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;

      pdfChangeFontSize(pdf, 15.0);
      r = pdfCreateRadioButton(pdf, "Radio1", "R1", true, -1, 300.0, y, 20.0, 20.0);
      pdfSetCheckBoxDefState(pdf, r, false);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 330.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R3", false, r, 360.0, y, 20.0, 20.0);

      pdfChangeFontSize(pdf, 10.0);
      f = pdfCreateButton(pdf, "Reset", "Reset", -1, 400.0, y, 60.0, 20.0);
      pdfSetFieldColor(pdf, f, fcBackColor, csDeviceRGB, PDF_LTGRAY);
      pdfSetFieldBorderStyle(pdf, f, bsBevelled);

      act = pdfCreateResetAction(pdf);
      pdfAddActionToObj(pdf, otField, oeOnMouseUp, act, f);
      pdfAddFieldToFormAction(pdf, act, r, true);

      y += 40.0;
      pdfChangeFontSize(pdf, 10.0);
      pdfWriteFTextEx(pdf, 300.0, y, 250.0, -1.0, taLeft, "The RadioIsUnion flag has only an effect if at least two check boxes use the same export value.");
      y = pdfGetPageHeight(pdf) - pdfGetLastTextPosY(pdf) + 10.0;

      pdfChangeFontSize(pdf, 15.0);
      r = pdfCreateRadioButton(pdf, "Radio2", "R1", true, -1, 300.0, y, 20.0, 20.0);
      pdfSetFieldFlags(pdf, r, ffRadioIsUnion, false);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 330.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R1", true, r, 360.0, y, 20.0, 20.0);
      pdfCreateCheckBox(pdf, NULL, "R2", false, r, 390.0, y, 20.0, 20.0);
   pdfEndPage(pdf);

   // No fatal error occurred?
   if (pdfHaveOpenDoc(pdf))
   {
      char filePath[MAX_PATH+1];
      // We write the output file into the current directory.
      GetCurrentDirectory(MAX_PATH, filePath);
      strcat(filePath, "\\out.pdf");
      // OK, now we can open the output file.
      if (!pdfOpenOutputFile(pdf, filePath))
      {
         pdfDeletePDF(pdf);
         _getch();
         return -1;
      }
      if (pdfCloseFile(pdf))
      {
         printf("PDF file \"%s\" successfully created!\n", filePath);
         ShellExecute(0, "open", filePath, NULL, NULL, SW_SHOWMAXIMIZED);
      }
   }
   pdfDeletePDF(pdf);
   _getch();
   return 0;
}