dnl $Id: config.m4,v 1.3 2002/09/19 20:14:33 derick Exp $

PHP_ARG_WITH(dynapdf, for dynapdf support,
[  --with-dynapdf[=DIR]      Include DynaPDF support])

if test "$PHP_DYNAPDF" != "no"; then
	SHLIBEXT=so
	case "${target_os}" in
	macos*|darwin*|rhapsody*)
		SHLIBEXT=dylib
		;;
	hpux*)
		case "${target_cpu}" in
		ia64*)
			SHLIBEXT=so
			;;
		*)
			SHLIBEXT=sl
			;;
		esac
		;;
	esac

	if test "${SHLIBEXT}" != "dylib"; then
		AC_MSG_CHECKING(for $PHP_DYNAPDF/dynapdf.h and $PHP_DYNAPDF/drv_conf.h)
		if test -r "$PHP_DYNAPDF/dynapdf.h" && test -r "$PHP_DYNAPDF/drv_conf.h"; then
			DYNAPDF_INC_DIR="$PHP_DYNAPDF"
			AC_MSG_RESULT([yes])
		else
			AC_MSG_ERROR(not found)
		fi
	else
		AC_MSG_CHECKING(for $PHP_DYNAPDF/dynapdf.h)
		if test -r "$PHP_DYNAPDF/dynapdf.h"; then
			DYNAPDF_INC_DIR="$PHP_DYNAPDF"
			AC_MSG_RESULT([yes])
		else
			AC_MSG_ERROR(not found)
		fi
	fi

	AC_MSG_CHECKING(for $PHP_DYNAPDF/libdynapdf.$SHLIBEXT)
	if test -r "$PHP_DYNAPDF/libdynapdf.${SHLIBEXT}"; then
		DYNAPDF_LIB_DIR="$PHP_DYNAPDF"
		AC_MSG_RESULT([yes])
    else
    	AC_MSG_RESULT([no])
		AC_MSG_CHECKING(for $PHP_DYNAPDF/libdynapdf.a)
		if test -r "$PHP_DYNAPDF/libdynapdf.a"; then
			DYNAPDF_LIB_DIR="$PHP_DYNAPDF"
			AC_MSG_RESULT([yes])
		else
			AC_MSG_ERROR(DynaPDF library not found!)
    fi
  fi

  PHP_ADD_INCLUDE($DYNAPDF_INC_DIR)
  PHP_SUBST(DYNAPDF_SHARED_LIBADD)
  PHP_ADD_LIBRARY_WITH_PATH(dynapdf, $DYNAPDF_LIB_DIR, DYNAPDF_SHARED_LIBADD)
  AC_DEFINE(HAVE_DYNAPDF,1,[ ])

  PHP_NEW_EXTENSION(dynapdf, php_dynapdf.c, $ext_shared)
  PHP_ADD_LIBRARY(dynapdf)
fi

